********************************************************************************
*
*						Figure 1 - Replication
*
********************************************************************************

***********************************************
* WORKER- AND FIRM-LEVEL TREATMENT DISTRIBUTION
***********************************************

global baseline_year = 2009
global treatment_year = 2011



use  "${data}\treatment_quarter_individual_data.dta", clear
	
*merge decile of wage for CTR workers 
merge m:1 id_lavoratore codice_fiscale using "${data}\decile_wage_affected_core.dta", keepusing(always*)
drop if _merge == 2
drop    _merge
	
*merge firm level info from baseline firm panel 
merge m:1 codice_fiscale anno_riferimento using  "${data}\baseline_panel.dta", ///
	                                                keepusing(*bl* aff_* *dyear* sample_period_p_ft bl_flag_single_matricola fflag_single_matricola_ty flag_balanced_cm)
keep  if anno_riferimento == $treatment_year 
keep if _merge == 3 // keep only firms in our sample 
drop _merge
	
    
* info about predicted retirement date
merge m:1 id_lavoratore using "${data}\treatment_retage_individual.dta"
drop if _merge == 2
drop _merge
	
*gen time variable 
gen time = 0
replace time = anno_riferimento - 2008

*Baseline characteristics interacted with time dummies
#delimit;
global baseline med_bl_emp med_bl_age_worker med_bl_male_sh med_bl_firm_age
                med_bl_firm_age2 med_bl_mean_dwage bl_ateco07 bl_prov bl_reg
				med_bl_share_young med_bl_share_middle med_bl_share_old;
#delimit cr

foreach var of global baseline {
	egen num_`var'=group(`var' time)
}





foreach l of numlist 10  {
 foreach u of numlist 200  {
  foreach s of numlist 3  {
   
     global sample // all firms
	 
	 if `j' == 0 global suff1 
	 if `j' == 1 global suff1 sr
	
	global add & sample_period_p_ft == 7 & ${reducing_sample}
	global suff2  bal_no_miss_firms
	 

   **********************
   * WORKER-LEVEL TREATMENT
   **********************
   preserve 
   
   *sample restrictions 
     keep if bl_emp >= `l' & bl_emp <= `u' ${add} 
	 keep if sample`s' == 1 & always_full_time == 1 & always_permanent == 1 // keep only CTR workers 
	 keep if bl_flag_single_matricola == 1 & fflag_single_matricola_ty == 1
   
   * keep one obs per worker 
     cap drop last_month
     bysort id_lavoratore: egen last_month = max(mese_riferimento)
     drop if mese_riferimento != last_month
     duplicates drop id_lavoratore, force
   
     count 
     global nobs = r(N)
     sum dyear
     global mean = round(r(mean), 0.01)
     global sd   = round(r(sd), 0.01)
     qui histogram dyear, ///
	 xtitle("Years until retirement eligibility")  ///
	 ytitle("") ///
	 graphregion(color(white)) plotregion(color(white))
     graph export "${directory_out}\figure_1_panel_A.pdf", as(pdf) replace
	 	 
   restore

   
   **********************
   * FIRM-LEVEL TREATMENT
   **********************
   preserve 
   
	 *sample restrictions 
     keep if bl_emp >= `l' & bl_emp <= `u' ${add} // keep affected firms
	 keep if bl_flag_single_matricola == 1 & fflag_single_matricola_ty == 1
	 
	 gen treat_norm     =  dyear_`s'_firm_ft_p/bl_emp
	 replace treat_norm = 0 if treat_norm == .
	 
	 
	 * keep one obs per firm
	 duplicates drop codice_fiscale, force
	 
	 count 
	 global nobs = r(N)
     sum treat_norm, detail
	 global mean = round(r(mean), 0.01)
     global sd   = round(r(sd), 0.01)
	 global pc1  = r(p1)
	 global pc99 = r(p99)
	 
	 ** treatment on  all workers
	 qui histogram treat_norm, ///
	 xtitle("Years until retirement eligibility per CTR worker") ///
	 ytitle("") ///
	 graphregion(color(white)) plotregion(color(white)) 
     graph export "${directory_out}\figure_1_panel_B.pdf", as(pdf) replace
	 
   restore
   
   
   
   }
  }
 }
 



