% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_correlation.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Correlation simplified creation}
\usage{
plot_correlation(
  df,
  x,
  ...,
  ylog = T,
  xlog = F,
  add = "reg.line",
  cor.coef = T,
  cor.method = "spearman",
  conf.int = F,
  outputExpr = F,
  colwrap = NA,
  wrapscale = "free",
  caption = F
)
}
\arguments{
\item{df}{name of the dataset to analyze}

\item{x}{name of the X variable}

\item{...}{names of the y variables (one per wrapped subplot)}

\item{ylog}{y logarithmic scale}

\item{add}{By default "reg.line", see ggpubr ("none"," "reg.line", "loess")}

\item{cor.coef}{To display correlation coeficient or not}

\item{cor.method}{Correlation method to use ("pearson", "spearman" or "kendall")}

\item{conf.int}{Toggle or not confidence interval}

\item{outputExpr}{display the R inependent code (T) or its evaluation (F)}

\item{colwrap}{column to wrap, if "..." is of length one only}

\item{wrapscale}{Scale for wrapping (ggplot syntax)}

\item{xlox}{x logarithmic scale}
}
\description{
Correlation simplified creation
}
\author{
Thibaud Derippe (\email{Thibaud.Derippe@gmail.com})
}
