% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peccary_NCA.R
\name{peccary_pknca}
\alias{peccary_pknca}
\title{PKNCA helper}
\usage{
peccary_pknca(
  dataset,
  Time,
  conc,
  Subject,
  dose = NA,
  EVID = NA,
  AUC0_x = 0,
  computeMedian = T,
  route = NA,
  rate = 0,
  duration = 0,
  option = NA,
  outputExpr = F
)
}
\arguments{
\item{dataset}{Dataset to analyze}

\item{Time}{The name (unquoted) of the time column. Mandatory.}

\item{conc}{The name  (unquoted) of the observation column. Mandatory.}

\item{Subject}{All the names (unquoted) of the grouping column separated by "+"  (ID, YTYPE, nAdmin, any covariate....).}

\item{dose}{Name of the dose column (unquoted)}

\item{EVID}{The name  (unquoted) of the evid column. Optional. Only line with evidcol = 0 will be kept}

\item{AUC0_x}{Numeric input. Compute AUC from time 0 to time auc_0_X}

\item{computeMedian}{Compute median of profile per Subject combination and time (avoid computational error)}

\item{route}{Optionnal, either "intravascular" or "extravascular"}

\item{rate}{Either name of the perfusion rate column or a number other of 0 for perf}

\item{duration}{Either name of the perfusion duration column or a number other of 0 for perf}

\item{option}{List of options to input in PKNCa, see their documentations}

\item{outputExpr}{Output the expression (T), the result (F) or both ("Both")}
}
\description{
\code{peccary_NCA} compute basic NCA analysis (no extrapolation)
}
\author{
Thibaud Derippe (\email{Thibaud.Derippe@gmail.com})
}
