% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecc_table1.R
\name{pecc_table1}
\alias{pecc_table1}
\title{Table1 creation}
\usage{
pecc_table1(
  dataset,
  rowl,
  ...,
  coll = "",
  NArp = " ",
  geomMean = F,
  na.rm = T,
  round = 1
)
}
\arguments{
\item{dataset}{dataset to analysis}

\item{rowl}{vector of dataset column names (quoted) with addition of _cont ("X_cont") or _cat ("X_cat") to force to consider a numeric column into a categorical one}

\item{...}{columns (generally ID, unquoted) used to reduce the dataset. "..." integrated into pecc_search_cov(...) function.}

\item{coll}{optional name of a categorical covariate (quoted)}

\item{NArp}{if NA are produced, which string to display (default = " ")}

\item{geomMean}{if True, compute geometric mean}

\item{na.rm}{if True (default), NA values are removed and ignored. If false, NA are kept with NA as result of most statistics parameter.}

\item{round}{number of digit displayed}
}
\description{
Re compute table1 from sratch
}
\examples{
pecc_table1(mtcars, rowl = c("mpg_cont", "gear_cont", "gear_cat"), coll = "cyl")

# if you have a dataset with multiple rows per ID, you will have too many patients (one per row):
pecc_table1(Theoph, rowl = c("Wt_cont", "Dose_cont"))

# after rowl parameter, you can add all ID columns you want in "..." to extract one line per patient:
}
\author{
Thibaud Derippe (\email{Thibaud.Derippe@gmail.com})
}
