% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecc_addn.R
\name{addn}
\alias{addn}
\title{Add number of occurences of a covariate}
\usage{
addn(dataset, col, ...)
}
\arguments{
\item{dataset}{dataset to modify}

\item{col}{a column to modify}

\item{...}{all columns to used for grouping (ID most of the time)}
}
\description{
This function is used to modify a column containing a categorical covariate to add the number of occurences. It is mostly used with boxplot  (inside \code{\link{plot_boxplot}} function for instance).
}
\examples{
mtcars \%>\%
 addn(carb) \%>\%
 ggplot()+
 geom_boxplot(aes(carb, mpg))


 Theoph \%>\%
   mutate(cov = sample(LETTERS[1:3], size = nrow(Theoph), replace = T)) \%>\%
   addn(cov, Subject)
}
\author{
Thibaud Derippe (\email{Thibaud.Derippe@gmail.com})
}
