!STARTOFREGISTRYGENERATEDFILE 'WakeDynamics_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! WakeDynamics_Types
!.................................................................................................................................
! This file is part of WakeDynamics.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in WakeDynamics. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE WakeDynamics_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_RotDiam = 1      ! Wake diameter calculation model: rotor diameter [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_Velocity = 2      ! Wake diameter calculation model: velocity-based [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_MassFlux = 3      ! Wake diameter calculation model: mass-flux based [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeDiamMod_MtmFlux = 4      ! Wake diameter calculation model: momentum-flux based [-]
! =========  WD_InputFileType  =======
  TYPE, PUBLIC :: WD_InputFileType
    REAL(ReKi)  :: dr      !< Radial increment of radial finite-difference grid [>0.0] [m]
    INTEGER(IntKi)  :: NumRadii      !< Number of radii in the radial finite-difference grid [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes      !< Number of wake planes [>=2] [-]
    REAL(ReKi)  :: f_c      !< Cut-off frequency of the low-pass time-filter for the wake advection, deflection, and meandering model [>0.0] [Hz]
    REAL(ReKi)  :: C_HWkDfl_O      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor [m]
    REAL(ReKi)  :: C_HWkDfl_OY      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor scaled with yaw error [m/rad]
    REAL(ReKi)  :: C_HWkDfl_x      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance [-]
    REAL(ReKi)  :: C_HWkDfl_xY      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance and yaw error [1/rad]
    REAL(ReKi)  :: C_NearWake      !< Calibrated parameter for the near-wake correction [>-1.0] [-]
    REAL(ReKi)  :: k_vAmb      !< Calibrated parameter for the influence of ambient turbulence in the eddy viscosity [>=0.0] [-]
    REAL(ReKi)  :: k_vShr      !< Calibrated parameter for the influence of the shear layer in the eddy viscosity [>=0.0] [-]
    REAL(ReKi)  :: C_vAmb_DMin      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the minimum and exponential regions [>=0.0 ] [-]
    REAL(ReKi)  :: C_vAmb_DMax      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the exponential and maximum regions [> C_vAmb_DMin] [-]
    REAL(ReKi)  :: C_vAmb_FMin      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the value in the minimum region [>=0.0 and <=1.0] [-]
    REAL(ReKi)  :: C_vAmb_Exp      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the exponent in the exponential region [> 0.0] [-]
    REAL(ReKi)  :: C_vShr_DMin      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the minimum and exponential regions [>=0.0] [-]
    REAL(ReKi)  :: C_vShr_DMax      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the exponential and maximum regions [> C_vShr_DMin] [-]
    REAL(ReKi)  :: C_vShr_FMin      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the value in the minimum region [>=0.0 and <=1.0] [-]
    REAL(ReKi)  :: C_vShr_Exp      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the exponent in the exponential region [> 0.0] [-]
    INTEGER(IntKi)  :: Mod_WakeDiam      !< Wake diameter calculation model {1: rotor diameter, 2: velocity-based, 3: mass-flux based, 4: momentum-flux based} [DEFAULT=1] [-]
    REAL(ReKi)  :: C_WakeDiam      !< Calibrated parameter for wake diameter calculation [>0.0 and <1.0] [unused for Mod_WakeDiam=1] [-]
  END TYPE WD_InputFileType
! =======================
! =========  WD_InitInputType  =======
  TYPE, PUBLIC :: WD_InitInputType
    TYPE(WD_InputFileType)  :: InputFileData      !< FAST.Farm input-file data for wake dynamics [-]
    INTEGER(IntKi)  :: TurbNum = 0      !< Turbine ID number (start with 1; end with number of turbines) [-]
  END TYPE WD_InitInputType
! =======================
! =========  WD_InitOutputType  =======
  TYPE, PUBLIC :: WD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE WD_InitOutputType
! =======================
! =========  WD_ContinuousStateType  =======
  TYPE, PUBLIC :: WD_ContinuousStateType
    REAL(ReKi)  :: DummyContState      !< Remove this variable if you have continuous states [-]
  END TYPE WD_ContinuousStateType
! =======================
! =========  WD_DiscreteStateType  =======
  TYPE, PUBLIC :: WD_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: x_plane      !< Downwind distance from rotor to each wake plane [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vr_wake      !< Radial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_plane_filt      !< Time-filtered advection, deflection, and meandering velocity of wake planes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_wind_disk_filt      !< Time-filtered rotor-disk-averaged ambient wind speed of wake planes, normal to planes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TI_amb_filt      !< Time-filtered ambient turbulence intensity of wind at wake planes [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: D_rotor_filt      !< Time-filtered rotor diameter associated with each wake plane [m]
    REAL(ReKi)  :: Vx_rel_disk_filt      !< Time-filtered rotor-disk-averaged relative wind speed (ambient + deficits + motion), normal to disk [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ct_azavg_filt      !< Time-filtered azimuthally averaged thrust force coefficient (normal to disk), distributed radially [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: YawErr_filt      !< Time-filtered nacelle-yaw error at the wake planes [rad]
  END TYPE WD_DiscreteStateType
! =======================
! =========  WD_ConstraintStateType  =======
  TYPE, PUBLIC :: WD_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState      !< Remove this variable if you have constraint states [-]
  END TYPE WD_ConstraintStateType
! =======================
! =========  WD_OtherStateType  =======
  TYPE, PUBLIC :: WD_OtherStateType
    LOGICAL  :: firstPass      !< Flag indicating whether or not the states have been initialized with proper inputs [-]
  END TYPE WD_OtherStateType
! =======================
! =========  WD_MiscVarType  =======
  TYPE, PUBLIC :: WD_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dvdr      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dvtdr      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_tot      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_amb      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vt_shr      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: a      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: b      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: c      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: d      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r_wake      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_high      !<  [-]
  END TYPE WD_MiscVarType
! =======================
! =========  WD_ParameterType  =======
  TYPE, PUBLIC :: WD_ParameterType
    REAL(DbKi)  :: dt_low      !< Time interval for wake dynamics calculations {or default} [s]
    INTEGER(IntKi)  :: NumPlanes      !< Number of wake planes [-]
    INTEGER(IntKi)  :: NumRadii      !< Number of radii in the radial finite-difference grid [-]
    REAL(ReKi)  :: dr      !< Radial increment of radial finite-difference grid [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r      !< Discretization of radial finite-difference grid [m]
    REAL(ReKi)  :: filtParam      !< Low-pass time-filter parameter, with a value between 0 (minimum filtering) and 1 (maximum filtering) (exclusive) [-]
    REAL(ReKi)  :: oneMinusFiltParam      !< 1.0 - filtParam [-]
    REAL(ReKi)  :: C_HWkDfl_O      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor [m]
    REAL(ReKi)  :: C_HWkDfl_OY      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset at the rotor scaled with yaw error [m/rad]
    REAL(ReKi)  :: C_HWkDfl_x      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance [-]
    REAL(ReKi)  :: C_HWkDfl_xY      !< Calibrated parameter in the correction for wake deflection defining the horizontal offset scaled with downstream distance and yaw error [1/rad]
    REAL(ReKi)  :: C_NearWake      !< Calibrated parameter for near-wake correction [-]
    REAL(ReKi)  :: C_vAmb_DMin      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the minimum and exponential regions [-]
    REAL(ReKi)  :: C_vAmb_DMax      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the transitional diameter fraction between the exponential and maximum regions [-]
    REAL(ReKi)  :: C_vAmb_FMin      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the functional value in the minimum region [-]
    REAL(ReKi)  :: C_vAmb_Exp      !< Calibrated parameter in the eddy viscosity filter function for ambient turbulence defining the exponent in the exponential region [-]
    REAL(ReKi)  :: C_vShr_DMin      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the minimum and exponential regions [-]
    REAL(ReKi)  :: C_vShr_DMax      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the transitional diameter fraction between the exponential and maximum regions [-]
    REAL(ReKi)  :: C_vShr_FMin      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the functional value in the minimum region [-]
    REAL(ReKi)  :: C_vShr_Exp      !< Calibrated parameter in the eddy viscosity filter function for the shear layer defining the exponent in the exponential region [-]
    REAL(ReKi)  :: k_vAmb      !< Calibrated parameter for the influence of ambient turbulence in the eddy viscosity [-]
    REAL(ReKi)  :: k_vShr      !< Calibrated parameter for the influence of the shear layer in the eddy viscosity [-]
    INTEGER(IntKi)  :: Mod_WakeDiam      !< Wake diameter calculation model [-]
    REAL(ReKi)  :: C_WakeDiam      !< Calibrated parameter for wake diameter calculation [-]
  END TYPE WD_ParameterType
! =======================
! =========  WD_InputType  =======
  TYPE, PUBLIC :: WD_InputType
    REAL(ReKi) , DIMENSION(1:3)  :: xhat_disk      !< Orientation of rotor centerline, normal to disk [-]
    REAL(ReKi) , DIMENSION(1:3)  :: p_hub      !< Center position of hub [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_plane      !< Advection, deflection, and meandering velocity of wake planes [m/s]
    REAL(ReKi)  :: Vx_wind_disk      !< Rotor-disk-averaged ambient wind speed, normal to planes [m/s]
    REAL(ReKi)  :: TI_amb      !< Ambient turbulence intensity of wind at rotor disk [-]
    REAL(ReKi)  :: D_rotor      !< Rotor diameter [m]
    REAL(ReKi)  :: Vx_rel_disk      !< Rotor-disk-averaged relative wind speed (ambient + deficits + motion), normal to disk [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ct_azavg      !< Azimuthally averaged thrust force coefficient (normal to disk), distributed radially [-]
    REAL(ReKi)  :: YawErr      !< Nacelle-yaw error at the wake planes [rad]
  END TYPE WD_InputType
! =======================
! =========  WD_OutputType  =======
  TYPE, PUBLIC :: WD_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vr_wake      !< Radial wake velocity deficit at wake planes, distributed radially [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: D_wake      !< Wake diameters at wake planes [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: x_plane      !< Downwind distance from rotor to each wake plane [m]
  END TYPE WD_OutputType
! =======================
CONTAINS
 SUBROUTINE WD_CopyInputFileType( SrcInputFileTypeData, DstInputFileTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_InputFileType), INTENT(IN) :: SrcInputFileTypeData
   TYPE(WD_InputFileType), INTENT(INOUT) :: DstInputFileTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyInputFileType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileTypeData%dr = SrcInputFileTypeData%dr
    DstInputFileTypeData%NumRadii = SrcInputFileTypeData%NumRadii
    DstInputFileTypeData%NumPlanes = SrcInputFileTypeData%NumPlanes
    DstInputFileTypeData%f_c = SrcInputFileTypeData%f_c
    DstInputFileTypeData%C_HWkDfl_O = SrcInputFileTypeData%C_HWkDfl_O
    DstInputFileTypeData%C_HWkDfl_OY = SrcInputFileTypeData%C_HWkDfl_OY
    DstInputFileTypeData%C_HWkDfl_x = SrcInputFileTypeData%C_HWkDfl_x
    DstInputFileTypeData%C_HWkDfl_xY = SrcInputFileTypeData%C_HWkDfl_xY
    DstInputFileTypeData%C_NearWake = SrcInputFileTypeData%C_NearWake
    DstInputFileTypeData%k_vAmb = SrcInputFileTypeData%k_vAmb
    DstInputFileTypeData%k_vShr = SrcInputFileTypeData%k_vShr
    DstInputFileTypeData%C_vAmb_DMin = SrcInputFileTypeData%C_vAmb_DMin
    DstInputFileTypeData%C_vAmb_DMax = SrcInputFileTypeData%C_vAmb_DMax
    DstInputFileTypeData%C_vAmb_FMin = SrcInputFileTypeData%C_vAmb_FMin
    DstInputFileTypeData%C_vAmb_Exp = SrcInputFileTypeData%C_vAmb_Exp
    DstInputFileTypeData%C_vShr_DMin = SrcInputFileTypeData%C_vShr_DMin
    DstInputFileTypeData%C_vShr_DMax = SrcInputFileTypeData%C_vShr_DMax
    DstInputFileTypeData%C_vShr_FMin = SrcInputFileTypeData%C_vShr_FMin
    DstInputFileTypeData%C_vShr_Exp = SrcInputFileTypeData%C_vShr_Exp
    DstInputFileTypeData%Mod_WakeDiam = SrcInputFileTypeData%Mod_WakeDiam
    DstInputFileTypeData%C_WakeDiam = SrcInputFileTypeData%C_WakeDiam
 END SUBROUTINE WD_CopyInputFileType

 SUBROUTINE WD_DestroyInputFileType( InputFileTypeData, ErrStat, ErrMsg )
  TYPE(WD_InputFileType), INTENT(INOUT) :: InputFileTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyInputFileType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE WD_DestroyInputFileType

 SUBROUTINE WD_PackInputFileType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_InputFileType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackInputFileType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! dr
      Int_BufSz  = Int_BufSz  + 1  ! NumRadii
      Int_BufSz  = Int_BufSz  + 1  ! NumPlanes
      Re_BufSz   = Re_BufSz   + 1  ! f_c
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_O
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_OY
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_x
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_xY
      Re_BufSz   = Re_BufSz   + 1  ! C_NearWake
      Re_BufSz   = Re_BufSz   + 1  ! k_vAmb
      Re_BufSz   = Re_BufSz   + 1  ! k_vShr
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_DMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_DMax
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_FMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_Exp
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_DMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_DMax
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_FMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_Exp
      Int_BufSz  = Int_BufSz  + 1  ! Mod_WakeDiam
      Re_BufSz   = Re_BufSz   + 1  ! C_WakeDiam
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%dr
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumRadii
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumPlanes
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%f_c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_O
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_OY
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_x
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_xY
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_NearWake
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_vAmb
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_vShr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_DMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_DMax
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_FMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_Exp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_DMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_DMax
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_FMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_Exp
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Mod_WakeDiam
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_WakeDiam
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_PackInputFileType

 SUBROUTINE WD_UnPackInputFileType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_InputFileType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackInputFileType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumRadii = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumPlanes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%f_c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_O = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_OY = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_x = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_xY = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_NearWake = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_vAmb = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_vShr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_DMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_DMax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_FMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_Exp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_DMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_DMax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_FMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_Exp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Mod_WakeDiam = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%C_WakeDiam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_UnPackInputFileType

 SUBROUTINE WD_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(WD_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL WD_Copyinputfiletype( SrcInitInputData%InputFileData, DstInitInputData%InputFileData, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstInitInputData%TurbNum = SrcInitInputData%TurbNum
 END SUBROUTINE WD_CopyInitInput

 SUBROUTINE WD_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(WD_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL WD_Destroyinputfiletype( InitInputData%InputFileData, ErrStat, ErrMsg )
 END SUBROUTINE WD_DestroyInitInput

 SUBROUTINE WD_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! InputFileData: size of buffers for each call to pack subtype
      CALL WD_Packinputfiletype( Re_Buf, Db_Buf, Int_Buf, InData%InputFileData, ErrStat2, ErrMsg2, .TRUE. ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InputFileData
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InputFileData
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InputFileData
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! TurbNum
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL WD_Packinputfiletype( Re_Buf, Db_Buf, Int_Buf, InData%InputFileData, ErrStat2, ErrMsg2, OnlySize ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = InData%TurbNum
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE WD_PackInitInput

 SUBROUTINE WD_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL WD_Unpackinputfiletype( Re_Buf, Db_Buf, Int_Buf, OutData%InputFileData, ErrStat2, ErrMsg2 ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%TurbNum = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE WD_UnPackInitInput

 SUBROUTINE WD_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(WD_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE WD_CopyInitOutput

 SUBROUTINE WD_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(WD_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE WD_DestroyInitOutput

 SUBROUTINE WD_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE WD_PackInitOutput

 SUBROUTINE WD_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE WD_UnPackInitOutput

 SUBROUTINE WD_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(WD_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%DummyContState = SrcContStateData%DummyContState
 END SUBROUTINE WD_CopyContState

 SUBROUTINE WD_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(WD_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE WD_DestroyContState

 SUBROUTINE WD_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyContState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyContState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_PackContState

 SUBROUTINE WD_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyContState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_UnPackContState

 SUBROUTINE WD_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(WD_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcDiscStateData%xhat_plane)) THEN
  i1_l = LBOUND(SrcDiscStateData%xhat_plane,1)
  i1_u = UBOUND(SrcDiscStateData%xhat_plane,1)
  i2_l = LBOUND(SrcDiscStateData%xhat_plane,2)
  i2_u = UBOUND(SrcDiscStateData%xhat_plane,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%xhat_plane)) THEN 
    ALLOCATE(DstDiscStateData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%xhat_plane = SrcDiscStateData%xhat_plane
ENDIF
IF (ALLOCATED(SrcDiscStateData%p_plane)) THEN
  i1_l = LBOUND(SrcDiscStateData%p_plane,1)
  i1_u = UBOUND(SrcDiscStateData%p_plane,1)
  i2_l = LBOUND(SrcDiscStateData%p_plane,2)
  i2_u = UBOUND(SrcDiscStateData%p_plane,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%p_plane)) THEN 
    ALLOCATE(DstDiscStateData%p_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%p_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%p_plane = SrcDiscStateData%p_plane
ENDIF
IF (ALLOCATED(SrcDiscStateData%x_plane)) THEN
  i1_l = LBOUND(SrcDiscStateData%x_plane,1)
  i1_u = UBOUND(SrcDiscStateData%x_plane,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%x_plane)) THEN 
    ALLOCATE(DstDiscStateData%x_plane(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%x_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%x_plane = SrcDiscStateData%x_plane
ENDIF
IF (ALLOCATED(SrcDiscStateData%Vx_wake)) THEN
  i1_l = LBOUND(SrcDiscStateData%Vx_wake,1)
  i1_u = UBOUND(SrcDiscStateData%Vx_wake,1)
  i2_l = LBOUND(SrcDiscStateData%Vx_wake,2)
  i2_u = UBOUND(SrcDiscStateData%Vx_wake,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Vx_wake)) THEN 
    ALLOCATE(DstDiscStateData%Vx_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Vx_wake = SrcDiscStateData%Vx_wake
ENDIF
IF (ALLOCATED(SrcDiscStateData%Vr_wake)) THEN
  i1_l = LBOUND(SrcDiscStateData%Vr_wake,1)
  i1_u = UBOUND(SrcDiscStateData%Vr_wake,1)
  i2_l = LBOUND(SrcDiscStateData%Vr_wake,2)
  i2_u = UBOUND(SrcDiscStateData%Vr_wake,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Vr_wake)) THEN 
    ALLOCATE(DstDiscStateData%Vr_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Vr_wake = SrcDiscStateData%Vr_wake
ENDIF
IF (ALLOCATED(SrcDiscStateData%V_plane_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%V_plane_filt,1)
  i1_u = UBOUND(SrcDiscStateData%V_plane_filt,1)
  i2_l = LBOUND(SrcDiscStateData%V_plane_filt,2)
  i2_u = UBOUND(SrcDiscStateData%V_plane_filt,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%V_plane_filt)) THEN 
    ALLOCATE(DstDiscStateData%V_plane_filt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%V_plane_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%V_plane_filt = SrcDiscStateData%V_plane_filt
ENDIF
IF (ALLOCATED(SrcDiscStateData%Vx_wind_disk_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%Vx_wind_disk_filt,1)
  i1_u = UBOUND(SrcDiscStateData%Vx_wind_disk_filt,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%Vx_wind_disk_filt)) THEN 
    ALLOCATE(DstDiscStateData%Vx_wind_disk_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Vx_wind_disk_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Vx_wind_disk_filt = SrcDiscStateData%Vx_wind_disk_filt
ENDIF
IF (ALLOCATED(SrcDiscStateData%TI_amb_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%TI_amb_filt,1)
  i1_u = UBOUND(SrcDiscStateData%TI_amb_filt,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%TI_amb_filt)) THEN 
    ALLOCATE(DstDiscStateData%TI_amb_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TI_amb_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%TI_amb_filt = SrcDiscStateData%TI_amb_filt
ENDIF
IF (ALLOCATED(SrcDiscStateData%D_rotor_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%D_rotor_filt,1)
  i1_u = UBOUND(SrcDiscStateData%D_rotor_filt,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%D_rotor_filt)) THEN 
    ALLOCATE(DstDiscStateData%D_rotor_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%D_rotor_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%D_rotor_filt = SrcDiscStateData%D_rotor_filt
ENDIF
    DstDiscStateData%Vx_rel_disk_filt = SrcDiscStateData%Vx_rel_disk_filt
IF (ALLOCATED(SrcDiscStateData%Ct_azavg_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%Ct_azavg_filt,1)
  i1_u = UBOUND(SrcDiscStateData%Ct_azavg_filt,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%Ct_azavg_filt)) THEN 
    ALLOCATE(DstDiscStateData%Ct_azavg_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Ct_azavg_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Ct_azavg_filt = SrcDiscStateData%Ct_azavg_filt
ENDIF
IF (ALLOCATED(SrcDiscStateData%YawErr_filt)) THEN
  i1_l = LBOUND(SrcDiscStateData%YawErr_filt,1)
  i1_u = UBOUND(SrcDiscStateData%YawErr_filt,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%YawErr_filt)) THEN 
    ALLOCATE(DstDiscStateData%YawErr_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%YawErr_filt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%YawErr_filt = SrcDiscStateData%YawErr_filt
ENDIF
 END SUBROUTINE WD_CopyDiscState

 SUBROUTINE WD_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(WD_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(DiscStateData%xhat_plane)) THEN
  DEALLOCATE(DiscStateData%xhat_plane)
ENDIF
IF (ALLOCATED(DiscStateData%p_plane)) THEN
  DEALLOCATE(DiscStateData%p_plane)
ENDIF
IF (ALLOCATED(DiscStateData%x_plane)) THEN
  DEALLOCATE(DiscStateData%x_plane)
ENDIF
IF (ALLOCATED(DiscStateData%Vx_wake)) THEN
  DEALLOCATE(DiscStateData%Vx_wake)
ENDIF
IF (ALLOCATED(DiscStateData%Vr_wake)) THEN
  DEALLOCATE(DiscStateData%Vr_wake)
ENDIF
IF (ALLOCATED(DiscStateData%V_plane_filt)) THEN
  DEALLOCATE(DiscStateData%V_plane_filt)
ENDIF
IF (ALLOCATED(DiscStateData%Vx_wind_disk_filt)) THEN
  DEALLOCATE(DiscStateData%Vx_wind_disk_filt)
ENDIF
IF (ALLOCATED(DiscStateData%TI_amb_filt)) THEN
  DEALLOCATE(DiscStateData%TI_amb_filt)
ENDIF
IF (ALLOCATED(DiscStateData%D_rotor_filt)) THEN
  DEALLOCATE(DiscStateData%D_rotor_filt)
ENDIF
IF (ALLOCATED(DiscStateData%Ct_azavg_filt)) THEN
  DEALLOCATE(DiscStateData%Ct_azavg_filt)
ENDIF
IF (ALLOCATED(DiscStateData%YawErr_filt)) THEN
  DEALLOCATE(DiscStateData%YawErr_filt)
ENDIF
 END SUBROUTINE WD_DestroyDiscState

 SUBROUTINE WD_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! xhat_plane allocated yes/no
  IF ( ALLOCATED(InData%xhat_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! xhat_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%xhat_plane)  ! xhat_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! p_plane allocated yes/no
  IF ( ALLOCATED(InData%p_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! p_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%p_plane)  ! p_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! x_plane allocated yes/no
  IF ( ALLOCATED(InData%x_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! x_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%x_plane)  ! x_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wake allocated yes/no
  IF ( ALLOCATED(InData%Vx_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vx_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wake)  ! Vx_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vr_wake allocated yes/no
  IF ( ALLOCATED(InData%Vr_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vr_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vr_wake)  ! Vr_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! V_plane_filt allocated yes/no
  IF ( ALLOCATED(InData%V_plane_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! V_plane_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%V_plane_filt)  ! V_plane_filt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wind_disk_filt allocated yes/no
  IF ( ALLOCATED(InData%Vx_wind_disk_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vx_wind_disk_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wind_disk_filt)  ! Vx_wind_disk_filt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TI_amb_filt allocated yes/no
  IF ( ALLOCATED(InData%TI_amb_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TI_amb_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TI_amb_filt)  ! TI_amb_filt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! D_rotor_filt allocated yes/no
  IF ( ALLOCATED(InData%D_rotor_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! D_rotor_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%D_rotor_filt)  ! D_rotor_filt
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Vx_rel_disk_filt
  Int_BufSz   = Int_BufSz   + 1     ! Ct_azavg_filt allocated yes/no
  IF ( ALLOCATED(InData%Ct_azavg_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Ct_azavg_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Ct_azavg_filt)  ! Ct_azavg_filt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! YawErr_filt allocated yes/no
  IF ( ALLOCATED(InData%YawErr_filt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! YawErr_filt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%YawErr_filt)  ! YawErr_filt
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%xhat_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%xhat_plane,2), UBOUND(InData%xhat_plane,2)
        DO i1 = LBOUND(InData%xhat_plane,1), UBOUND(InData%xhat_plane,1)
          ReKiBuf(Re_Xferred) = InData%xhat_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%p_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%p_plane,2), UBOUND(InData%p_plane,2)
        DO i1 = LBOUND(InData%p_plane,1), UBOUND(InData%p_plane,1)
          ReKiBuf(Re_Xferred) = InData%p_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%x_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%x_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%x_plane,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%x_plane,1), UBOUND(InData%x_plane,1)
        ReKiBuf(Re_Xferred) = InData%x_plane(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vx_wake,2), UBOUND(InData%Vx_wake,2)
        DO i1 = LBOUND(InData%Vx_wake,1), UBOUND(InData%Vx_wake,1)
          ReKiBuf(Re_Xferred) = InData%Vx_wake(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vr_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vr_wake,2), UBOUND(InData%Vr_wake,2)
        DO i1 = LBOUND(InData%Vr_wake,1), UBOUND(InData%Vr_wake,1)
          ReKiBuf(Re_Xferred) = InData%Vr_wake(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%V_plane_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane_filt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane_filt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane_filt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%V_plane_filt,2), UBOUND(InData%V_plane_filt,2)
        DO i1 = LBOUND(InData%V_plane_filt,1), UBOUND(InData%V_plane_filt,1)
          ReKiBuf(Re_Xferred) = InData%V_plane_filt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wind_disk_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wind_disk_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wind_disk_filt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vx_wind_disk_filt,1), UBOUND(InData%Vx_wind_disk_filt,1)
        ReKiBuf(Re_Xferred) = InData%Vx_wind_disk_filt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TI_amb_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_amb_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_amb_filt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TI_amb_filt,1), UBOUND(InData%TI_amb_filt,1)
        ReKiBuf(Re_Xferred) = InData%TI_amb_filt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%D_rotor_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%D_rotor_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%D_rotor_filt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%D_rotor_filt,1), UBOUND(InData%D_rotor_filt,1)
        ReKiBuf(Re_Xferred) = InData%D_rotor_filt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Vx_rel_disk_filt
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Ct_azavg_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Ct_azavg_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Ct_azavg_filt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Ct_azavg_filt,1), UBOUND(InData%Ct_azavg_filt,1)
        ReKiBuf(Re_Xferred) = InData%Ct_azavg_filt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%YawErr_filt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%YawErr_filt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%YawErr_filt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%YawErr_filt,1), UBOUND(InData%YawErr_filt,1)
        ReKiBuf(Re_Xferred) = InData%YawErr_filt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_PackDiscState

 SUBROUTINE WD_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xhat_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%xhat_plane)) DEALLOCATE(OutData%xhat_plane)
    ALLOCATE(OutData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%xhat_plane,2), UBOUND(OutData%xhat_plane,2)
        DO i1 = LBOUND(OutData%xhat_plane,1), UBOUND(OutData%xhat_plane,1)
          OutData%xhat_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! p_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%p_plane)) DEALLOCATE(OutData%p_plane)
    ALLOCATE(OutData%p_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%p_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%p_plane,2), UBOUND(OutData%p_plane,2)
        DO i1 = LBOUND(OutData%p_plane,1), UBOUND(OutData%p_plane,1)
          OutData%p_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! x_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%x_plane)) DEALLOCATE(OutData%x_plane)
    ALLOCATE(OutData%x_plane(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%x_plane,1), UBOUND(OutData%x_plane,1)
        OutData%x_plane(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wake)) DEALLOCATE(OutData%Vx_wake)
    ALLOCATE(OutData%Vx_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vx_wake,2), UBOUND(OutData%Vx_wake,2)
        DO i1 = LBOUND(OutData%Vx_wake,1), UBOUND(OutData%Vx_wake,1)
          OutData%Vx_wake(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vr_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vr_wake)) DEALLOCATE(OutData%Vr_wake)
    ALLOCATE(OutData%Vr_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vr_wake,2), UBOUND(OutData%Vr_wake,2)
        DO i1 = LBOUND(OutData%Vr_wake,1), UBOUND(OutData%Vr_wake,1)
          OutData%Vr_wake(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V_plane_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%V_plane_filt)) DEALLOCATE(OutData%V_plane_filt)
    ALLOCATE(OutData%V_plane_filt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V_plane_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%V_plane_filt,2), UBOUND(OutData%V_plane_filt,2)
        DO i1 = LBOUND(OutData%V_plane_filt,1), UBOUND(OutData%V_plane_filt,1)
          OutData%V_plane_filt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wind_disk_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wind_disk_filt)) DEALLOCATE(OutData%Vx_wind_disk_filt)
    ALLOCATE(OutData%Vx_wind_disk_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wind_disk_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vx_wind_disk_filt,1), UBOUND(OutData%Vx_wind_disk_filt,1)
        OutData%Vx_wind_disk_filt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TI_amb_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TI_amb_filt)) DEALLOCATE(OutData%TI_amb_filt)
    ALLOCATE(OutData%TI_amb_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TI_amb_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TI_amb_filt,1), UBOUND(OutData%TI_amb_filt,1)
        OutData%TI_amb_filt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! D_rotor_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%D_rotor_filt)) DEALLOCATE(OutData%D_rotor_filt)
    ALLOCATE(OutData%D_rotor_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%D_rotor_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%D_rotor_filt,1), UBOUND(OutData%D_rotor_filt,1)
        OutData%D_rotor_filt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Vx_rel_disk_filt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Ct_azavg_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Ct_azavg_filt)) DEALLOCATE(OutData%Ct_azavg_filt)
    ALLOCATE(OutData%Ct_azavg_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Ct_azavg_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Ct_azavg_filt,1), UBOUND(OutData%Ct_azavg_filt,1)
        OutData%Ct_azavg_filt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! YawErr_filt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%YawErr_filt)) DEALLOCATE(OutData%YawErr_filt)
    ALLOCATE(OutData%YawErr_filt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%YawErr_filt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%YawErr_filt,1), UBOUND(OutData%YawErr_filt,1)
        OutData%YawErr_filt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_UnPackDiscState

 SUBROUTINE WD_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(WD_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
 END SUBROUTINE WD_CopyConstrState

 SUBROUTINE WD_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(WD_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE WD_DestroyConstrState

 SUBROUTINE WD_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstrState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstrState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_PackConstrState

 SUBROUTINE WD_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstrState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_UnPackConstrState

 SUBROUTINE WD_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(WD_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%firstPass = SrcOtherStateData%firstPass
 END SUBROUTINE WD_CopyOtherState

 SUBROUTINE WD_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(WD_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE WD_DestroyOtherState

 SUBROUTINE WD_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! firstPass
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = TRANSFER(InData%firstPass, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE WD_PackOtherState

 SUBROUTINE WD_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%firstPass = TRANSFER(IntKiBuf(Int_Xferred), OutData%firstPass)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE WD_UnPackOtherState

 SUBROUTINE WD_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(WD_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%dvdr)) THEN
  i1_l = LBOUND(SrcMiscData%dvdr,1)
  i1_u = UBOUND(SrcMiscData%dvdr,1)
  IF (.NOT. ALLOCATED(DstMiscData%dvdr)) THEN 
    ALLOCATE(DstMiscData%dvdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dvdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%dvdr = SrcMiscData%dvdr
ENDIF
IF (ALLOCATED(SrcMiscData%dvtdr)) THEN
  i1_l = LBOUND(SrcMiscData%dvtdr,1)
  i1_u = UBOUND(SrcMiscData%dvtdr,1)
  IF (.NOT. ALLOCATED(DstMiscData%dvtdr)) THEN 
    ALLOCATE(DstMiscData%dvtdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dvtdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%dvtdr = SrcMiscData%dvtdr
ENDIF
IF (ALLOCATED(SrcMiscData%vt_tot)) THEN
  i1_l = LBOUND(SrcMiscData%vt_tot,1)
  i1_u = UBOUND(SrcMiscData%vt_tot,1)
  i2_l = LBOUND(SrcMiscData%vt_tot,2)
  i2_u = UBOUND(SrcMiscData%vt_tot,2)
  IF (.NOT. ALLOCATED(DstMiscData%vt_tot)) THEN 
    ALLOCATE(DstMiscData%vt_tot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_tot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%vt_tot = SrcMiscData%vt_tot
ENDIF
IF (ALLOCATED(SrcMiscData%vt_amb)) THEN
  i1_l = LBOUND(SrcMiscData%vt_amb,1)
  i1_u = UBOUND(SrcMiscData%vt_amb,1)
  i2_l = LBOUND(SrcMiscData%vt_amb,2)
  i2_u = UBOUND(SrcMiscData%vt_amb,2)
  IF (.NOT. ALLOCATED(DstMiscData%vt_amb)) THEN 
    ALLOCATE(DstMiscData%vt_amb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_amb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%vt_amb = SrcMiscData%vt_amb
ENDIF
IF (ALLOCATED(SrcMiscData%vt_shr)) THEN
  i1_l = LBOUND(SrcMiscData%vt_shr,1)
  i1_u = UBOUND(SrcMiscData%vt_shr,1)
  i2_l = LBOUND(SrcMiscData%vt_shr,2)
  i2_u = UBOUND(SrcMiscData%vt_shr,2)
  IF (.NOT. ALLOCATED(DstMiscData%vt_shr)) THEN 
    ALLOCATE(DstMiscData%vt_shr(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vt_shr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%vt_shr = SrcMiscData%vt_shr
ENDIF
IF (ALLOCATED(SrcMiscData%a)) THEN
  i1_l = LBOUND(SrcMiscData%a,1)
  i1_u = UBOUND(SrcMiscData%a,1)
  IF (.NOT. ALLOCATED(DstMiscData%a)) THEN 
    ALLOCATE(DstMiscData%a(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%a.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%a = SrcMiscData%a
ENDIF
IF (ALLOCATED(SrcMiscData%b)) THEN
  i1_l = LBOUND(SrcMiscData%b,1)
  i1_u = UBOUND(SrcMiscData%b,1)
  IF (.NOT. ALLOCATED(DstMiscData%b)) THEN 
    ALLOCATE(DstMiscData%b(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%b.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%b = SrcMiscData%b
ENDIF
IF (ALLOCATED(SrcMiscData%c)) THEN
  i1_l = LBOUND(SrcMiscData%c,1)
  i1_u = UBOUND(SrcMiscData%c,1)
  IF (.NOT. ALLOCATED(DstMiscData%c)) THEN 
    ALLOCATE(DstMiscData%c(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%c.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%c = SrcMiscData%c
ENDIF
IF (ALLOCATED(SrcMiscData%d)) THEN
  i1_l = LBOUND(SrcMiscData%d,1)
  i1_u = UBOUND(SrcMiscData%d,1)
  IF (.NOT. ALLOCATED(DstMiscData%d)) THEN 
    ALLOCATE(DstMiscData%d(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%d.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%d = SrcMiscData%d
ENDIF
IF (ALLOCATED(SrcMiscData%r_wake)) THEN
  i1_l = LBOUND(SrcMiscData%r_wake,1)
  i1_u = UBOUND(SrcMiscData%r_wake,1)
  IF (.NOT. ALLOCATED(DstMiscData%r_wake)) THEN 
    ALLOCATE(DstMiscData%r_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%r_wake = SrcMiscData%r_wake
ENDIF
IF (ALLOCATED(SrcMiscData%Vx_high)) THEN
  i1_l = LBOUND(SrcMiscData%Vx_high,1)
  i1_u = UBOUND(SrcMiscData%Vx_high,1)
  IF (.NOT. ALLOCATED(DstMiscData%Vx_high)) THEN 
    ALLOCATE(DstMiscData%Vx_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vx_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vx_high = SrcMiscData%Vx_high
ENDIF
 END SUBROUTINE WD_CopyMisc

 SUBROUTINE WD_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(WD_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%dvdr)) THEN
  DEALLOCATE(MiscData%dvdr)
ENDIF
IF (ALLOCATED(MiscData%dvtdr)) THEN
  DEALLOCATE(MiscData%dvtdr)
ENDIF
IF (ALLOCATED(MiscData%vt_tot)) THEN
  DEALLOCATE(MiscData%vt_tot)
ENDIF
IF (ALLOCATED(MiscData%vt_amb)) THEN
  DEALLOCATE(MiscData%vt_amb)
ENDIF
IF (ALLOCATED(MiscData%vt_shr)) THEN
  DEALLOCATE(MiscData%vt_shr)
ENDIF
IF (ALLOCATED(MiscData%a)) THEN
  DEALLOCATE(MiscData%a)
ENDIF
IF (ALLOCATED(MiscData%b)) THEN
  DEALLOCATE(MiscData%b)
ENDIF
IF (ALLOCATED(MiscData%c)) THEN
  DEALLOCATE(MiscData%c)
ENDIF
IF (ALLOCATED(MiscData%d)) THEN
  DEALLOCATE(MiscData%d)
ENDIF
IF (ALLOCATED(MiscData%r_wake)) THEN
  DEALLOCATE(MiscData%r_wake)
ENDIF
IF (ALLOCATED(MiscData%Vx_high)) THEN
  DEALLOCATE(MiscData%Vx_high)
ENDIF
 END SUBROUTINE WD_DestroyMisc

 SUBROUTINE WD_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! dvdr allocated yes/no
  IF ( ALLOCATED(InData%dvdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dvdr upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dvdr)  ! dvdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dvtdr allocated yes/no
  IF ( ALLOCATED(InData%dvtdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dvtdr upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dvtdr)  ! dvtdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! vt_tot allocated yes/no
  IF ( ALLOCATED(InData%vt_tot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! vt_tot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%vt_tot)  ! vt_tot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! vt_amb allocated yes/no
  IF ( ALLOCATED(InData%vt_amb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! vt_amb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%vt_amb)  ! vt_amb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! vt_shr allocated yes/no
  IF ( ALLOCATED(InData%vt_shr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! vt_shr upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%vt_shr)  ! vt_shr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! a allocated yes/no
  IF ( ALLOCATED(InData%a) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! a upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%a)  ! a
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! b allocated yes/no
  IF ( ALLOCATED(InData%b) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! b upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%b)  ! b
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! c allocated yes/no
  IF ( ALLOCATED(InData%c) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! c upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%c)  ! c
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! d allocated yes/no
  IF ( ALLOCATED(InData%d) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! d upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%d)  ! d
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_wake allocated yes/no
  IF ( ALLOCATED(InData%r_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! r_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_wake)  ! r_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_high allocated yes/no
  IF ( ALLOCATED(InData%Vx_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vx_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_high)  ! Vx_high
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%dvdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dvdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dvdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dvdr,1), UBOUND(InData%dvdr,1)
        ReKiBuf(Re_Xferred) = InData%dvdr(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dvtdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dvtdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dvtdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dvtdr,1), UBOUND(InData%dvtdr,1)
        ReKiBuf(Re_Xferred) = InData%dvtdr(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%vt_tot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_tot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_tot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_tot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_tot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%vt_tot,2), UBOUND(InData%vt_tot,2)
        DO i1 = LBOUND(InData%vt_tot,1), UBOUND(InData%vt_tot,1)
          ReKiBuf(Re_Xferred) = InData%vt_tot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%vt_amb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_amb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_amb,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_amb,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_amb,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%vt_amb,2), UBOUND(InData%vt_amb,2)
        DO i1 = LBOUND(InData%vt_amb,1), UBOUND(InData%vt_amb,1)
          ReKiBuf(Re_Xferred) = InData%vt_amb(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%vt_shr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_shr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_shr,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vt_shr,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vt_shr,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%vt_shr,2), UBOUND(InData%vt_shr,2)
        DO i1 = LBOUND(InData%vt_shr,1), UBOUND(InData%vt_shr,1)
          ReKiBuf(Re_Xferred) = InData%vt_shr(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%a) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%a,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%a,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%a,1), UBOUND(InData%a,1)
        ReKiBuf(Re_Xferred) = InData%a(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%b) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%b,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%b,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%b,1), UBOUND(InData%b,1)
        ReKiBuf(Re_Xferred) = InData%b(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%c) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%c,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%c,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%c,1), UBOUND(InData%c,1)
        ReKiBuf(Re_Xferred) = InData%c(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%d) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%d,1), UBOUND(InData%d,1)
        ReKiBuf(Re_Xferred) = InData%d(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_wake,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%r_wake,1), UBOUND(InData%r_wake,1)
        ReKiBuf(Re_Xferred) = InData%r_wake(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vx_high,1), UBOUND(InData%Vx_high,1)
        ReKiBuf(Re_Xferred) = InData%Vx_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_PackMisc

 SUBROUTINE WD_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dvdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dvdr)) DEALLOCATE(OutData%dvdr)
    ALLOCATE(OutData%dvdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dvdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dvdr,1), UBOUND(OutData%dvdr,1)
        OutData%dvdr(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dvtdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dvtdr)) DEALLOCATE(OutData%dvtdr)
    ALLOCATE(OutData%dvtdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dvtdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dvtdr,1), UBOUND(OutData%dvtdr,1)
        OutData%dvtdr(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! vt_tot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%vt_tot)) DEALLOCATE(OutData%vt_tot)
    ALLOCATE(OutData%vt_tot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%vt_tot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%vt_tot,2), UBOUND(OutData%vt_tot,2)
        DO i1 = LBOUND(OutData%vt_tot,1), UBOUND(OutData%vt_tot,1)
          OutData%vt_tot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! vt_amb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%vt_amb)) DEALLOCATE(OutData%vt_amb)
    ALLOCATE(OutData%vt_amb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%vt_amb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%vt_amb,2), UBOUND(OutData%vt_amb,2)
        DO i1 = LBOUND(OutData%vt_amb,1), UBOUND(OutData%vt_amb,1)
          OutData%vt_amb(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! vt_shr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%vt_shr)) DEALLOCATE(OutData%vt_shr)
    ALLOCATE(OutData%vt_shr(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%vt_shr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%vt_shr,2), UBOUND(OutData%vt_shr,2)
        DO i1 = LBOUND(OutData%vt_shr,1), UBOUND(OutData%vt_shr,1)
          OutData%vt_shr(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! a not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%a)) DEALLOCATE(OutData%a)
    ALLOCATE(OutData%a(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%a.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%a,1), UBOUND(OutData%a,1)
        OutData%a(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! b not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%b)) DEALLOCATE(OutData%b)
    ALLOCATE(OutData%b(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%b.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%b,1), UBOUND(OutData%b,1)
        OutData%b(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! c not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%c)) DEALLOCATE(OutData%c)
    ALLOCATE(OutData%c(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%c.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%c,1), UBOUND(OutData%c,1)
        OutData%c(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! d not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%d)) DEALLOCATE(OutData%d)
    ALLOCATE(OutData%d(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%d.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%d,1), UBOUND(OutData%d,1)
        OutData%d(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_wake)) DEALLOCATE(OutData%r_wake)
    ALLOCATE(OutData%r_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%r_wake,1), UBOUND(OutData%r_wake,1)
        OutData%r_wake(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_high)) DEALLOCATE(OutData%Vx_high)
    ALLOCATE(OutData%Vx_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vx_high,1), UBOUND(OutData%Vx_high,1)
        OutData%Vx_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_UnPackMisc

 SUBROUTINE WD_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(WD_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%dt_low = SrcParamData%dt_low
    DstParamData%NumPlanes = SrcParamData%NumPlanes
    DstParamData%NumRadii = SrcParamData%NumRadii
    DstParamData%dr = SrcParamData%dr
IF (ALLOCATED(SrcParamData%r)) THEN
  i1_l = LBOUND(SrcParamData%r,1)
  i1_u = UBOUND(SrcParamData%r,1)
  IF (.NOT. ALLOCATED(DstParamData%r)) THEN 
    ALLOCATE(DstParamData%r(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%r.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%r = SrcParamData%r
ENDIF
    DstParamData%filtParam = SrcParamData%filtParam
    DstParamData%oneMinusFiltParam = SrcParamData%oneMinusFiltParam
    DstParamData%C_HWkDfl_O = SrcParamData%C_HWkDfl_O
    DstParamData%C_HWkDfl_OY = SrcParamData%C_HWkDfl_OY
    DstParamData%C_HWkDfl_x = SrcParamData%C_HWkDfl_x
    DstParamData%C_HWkDfl_xY = SrcParamData%C_HWkDfl_xY
    DstParamData%C_NearWake = SrcParamData%C_NearWake
    DstParamData%C_vAmb_DMin = SrcParamData%C_vAmb_DMin
    DstParamData%C_vAmb_DMax = SrcParamData%C_vAmb_DMax
    DstParamData%C_vAmb_FMin = SrcParamData%C_vAmb_FMin
    DstParamData%C_vAmb_Exp = SrcParamData%C_vAmb_Exp
    DstParamData%C_vShr_DMin = SrcParamData%C_vShr_DMin
    DstParamData%C_vShr_DMax = SrcParamData%C_vShr_DMax
    DstParamData%C_vShr_FMin = SrcParamData%C_vShr_FMin
    DstParamData%C_vShr_Exp = SrcParamData%C_vShr_Exp
    DstParamData%k_vAmb = SrcParamData%k_vAmb
    DstParamData%k_vShr = SrcParamData%k_vShr
    DstParamData%Mod_WakeDiam = SrcParamData%Mod_WakeDiam
    DstParamData%C_WakeDiam = SrcParamData%C_WakeDiam
 END SUBROUTINE WD_CopyParam

 SUBROUTINE WD_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(WD_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%r)) THEN
  DEALLOCATE(ParamData%r)
ENDIF
 END SUBROUTINE WD_DestroyParam

 SUBROUTINE WD_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! dt_low
      Int_BufSz  = Int_BufSz  + 1  ! NumPlanes
      Int_BufSz  = Int_BufSz  + 1  ! NumRadii
      Re_BufSz   = Re_BufSz   + 1  ! dr
  Int_BufSz   = Int_BufSz   + 1     ! r allocated yes/no
  IF ( ALLOCATED(InData%r) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! r upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r)  ! r
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! filtParam
      Re_BufSz   = Re_BufSz   + 1  ! oneMinusFiltParam
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_O
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_OY
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_x
      Re_BufSz   = Re_BufSz   + 1  ! C_HWkDfl_xY
      Re_BufSz   = Re_BufSz   + 1  ! C_NearWake
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_DMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_DMax
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_FMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vAmb_Exp
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_DMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_DMax
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_FMin
      Re_BufSz   = Re_BufSz   + 1  ! C_vShr_Exp
      Re_BufSz   = Re_BufSz   + 1  ! k_vAmb
      Re_BufSz   = Re_BufSz   + 1  ! k_vShr
      Int_BufSz  = Int_BufSz  + 1  ! Mod_WakeDiam
      Re_BufSz   = Re_BufSz   + 1  ! C_WakeDiam
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%dt_low
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumPlanes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumRadii
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dr
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%r) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%r,1), UBOUND(InData%r,1)
        ReKiBuf(Re_Xferred) = InData%r(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%filtParam
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%oneMinusFiltParam
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_O
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_OY
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_x
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_HWkDfl_xY
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_NearWake
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_DMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_DMax
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_FMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vAmb_Exp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_DMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_DMax
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_FMin
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_vShr_Exp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_vAmb
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_vShr
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Mod_WakeDiam
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_WakeDiam
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_PackParam

 SUBROUTINE WD_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dt_low = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%NumPlanes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumRadii = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r)) DEALLOCATE(OutData%r)
    ALLOCATE(OutData%r(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%r,1), UBOUND(OutData%r,1)
        OutData%r(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%filtParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%oneMinusFiltParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_O = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_OY = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_x = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_HWkDfl_xY = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_NearWake = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_DMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_DMax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_FMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vAmb_Exp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_DMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_DMax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_FMin = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_vShr_Exp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_vAmb = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_vShr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Mod_WakeDiam = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%C_WakeDiam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_UnPackParam

 SUBROUTINE WD_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_InputType), INTENT(IN) :: SrcInputData
   TYPE(WD_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputData%xhat_disk = SrcInputData%xhat_disk
    DstInputData%p_hub = SrcInputData%p_hub
IF (ALLOCATED(SrcInputData%V_plane)) THEN
  i1_l = LBOUND(SrcInputData%V_plane,1)
  i1_u = UBOUND(SrcInputData%V_plane,1)
  i2_l = LBOUND(SrcInputData%V_plane,2)
  i2_u = UBOUND(SrcInputData%V_plane,2)
  IF (.NOT. ALLOCATED(DstInputData%V_plane)) THEN 
    ALLOCATE(DstInputData%V_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%V_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%V_plane = SrcInputData%V_plane
ENDIF
    DstInputData%Vx_wind_disk = SrcInputData%Vx_wind_disk
    DstInputData%TI_amb = SrcInputData%TI_amb
    DstInputData%D_rotor = SrcInputData%D_rotor
    DstInputData%Vx_rel_disk = SrcInputData%Vx_rel_disk
IF (ALLOCATED(SrcInputData%Ct_azavg)) THEN
  i1_l = LBOUND(SrcInputData%Ct_azavg,1)
  i1_u = UBOUND(SrcInputData%Ct_azavg,1)
  IF (.NOT. ALLOCATED(DstInputData%Ct_azavg)) THEN 
    ALLOCATE(DstInputData%Ct_azavg(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Ct_azavg.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Ct_azavg = SrcInputData%Ct_azavg
ENDIF
    DstInputData%YawErr = SrcInputData%YawErr
 END SUBROUTINE WD_CopyInput

 SUBROUTINE WD_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(WD_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%V_plane)) THEN
  DEALLOCATE(InputData%V_plane)
ENDIF
IF (ALLOCATED(InputData%Ct_azavg)) THEN
  DEALLOCATE(InputData%Ct_azavg)
ENDIF
 END SUBROUTINE WD_DestroyInput

 SUBROUTINE WD_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + SIZE(InData%xhat_disk)  ! xhat_disk
      Re_BufSz   = Re_BufSz   + SIZE(InData%p_hub)  ! p_hub
  Int_BufSz   = Int_BufSz   + 1     ! V_plane allocated yes/no
  IF ( ALLOCATED(InData%V_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! V_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%V_plane)  ! V_plane
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Vx_wind_disk
      Re_BufSz   = Re_BufSz   + 1  ! TI_amb
      Re_BufSz   = Re_BufSz   + 1  ! D_rotor
      Re_BufSz   = Re_BufSz   + 1  ! Vx_rel_disk
  Int_BufSz   = Int_BufSz   + 1     ! Ct_azavg allocated yes/no
  IF ( ALLOCATED(InData%Ct_azavg) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Ct_azavg upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Ct_azavg)  ! Ct_azavg
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! YawErr
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i1 = LBOUND(InData%xhat_disk,1), UBOUND(InData%xhat_disk,1)
      ReKiBuf(Re_Xferred) = InData%xhat_disk(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%p_hub,1), UBOUND(InData%p_hub,1)
      ReKiBuf(Re_Xferred) = InData%p_hub(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%V_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%V_plane,2), UBOUND(InData%V_plane,2)
        DO i1 = LBOUND(InData%V_plane,1), UBOUND(InData%V_plane,1)
          ReKiBuf(Re_Xferred) = InData%V_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Vx_wind_disk
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TI_amb
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%D_rotor
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Vx_rel_disk
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Ct_azavg) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Ct_azavg,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Ct_azavg,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Ct_azavg,1), UBOUND(InData%Ct_azavg,1)
        ReKiBuf(Re_Xferred) = InData%Ct_azavg(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%YawErr
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_PackInput

 SUBROUTINE WD_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%xhat_disk,1)
    i1_u = UBOUND(OutData%xhat_disk,1)
    DO i1 = LBOUND(OutData%xhat_disk,1), UBOUND(OutData%xhat_disk,1)
      OutData%xhat_disk(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%p_hub,1)
    i1_u = UBOUND(OutData%p_hub,1)
    DO i1 = LBOUND(OutData%p_hub,1), UBOUND(OutData%p_hub,1)
      OutData%p_hub(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%V_plane)) DEALLOCATE(OutData%V_plane)
    ALLOCATE(OutData%V_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%V_plane,2), UBOUND(OutData%V_plane,2)
        DO i1 = LBOUND(OutData%V_plane,1), UBOUND(OutData%V_plane,1)
          OutData%V_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%Vx_wind_disk = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TI_amb = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%D_rotor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Vx_rel_disk = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Ct_azavg not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Ct_azavg)) DEALLOCATE(OutData%Ct_azavg)
    ALLOCATE(OutData%Ct_azavg(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Ct_azavg.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Ct_azavg,1), UBOUND(OutData%Ct_azavg,1)
        OutData%Ct_azavg(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%YawErr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE WD_UnPackInput

 SUBROUTINE WD_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(WD_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(WD_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'WD_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%xhat_plane)) THEN
  i1_l = LBOUND(SrcOutputData%xhat_plane,1)
  i1_u = UBOUND(SrcOutputData%xhat_plane,1)
  i2_l = LBOUND(SrcOutputData%xhat_plane,2)
  i2_u = UBOUND(SrcOutputData%xhat_plane,2)
  IF (.NOT. ALLOCATED(DstOutputData%xhat_plane)) THEN 
    ALLOCATE(DstOutputData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%xhat_plane = SrcOutputData%xhat_plane
ENDIF
IF (ALLOCATED(SrcOutputData%p_plane)) THEN
  i1_l = LBOUND(SrcOutputData%p_plane,1)
  i1_u = UBOUND(SrcOutputData%p_plane,1)
  i2_l = LBOUND(SrcOutputData%p_plane,2)
  i2_u = UBOUND(SrcOutputData%p_plane,2)
  IF (.NOT. ALLOCATED(DstOutputData%p_plane)) THEN 
    ALLOCATE(DstOutputData%p_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%p_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%p_plane = SrcOutputData%p_plane
ENDIF
IF (ALLOCATED(SrcOutputData%Vx_wake)) THEN
  i1_l = LBOUND(SrcOutputData%Vx_wake,1)
  i1_u = UBOUND(SrcOutputData%Vx_wake,1)
  i2_l = LBOUND(SrcOutputData%Vx_wake,2)
  i2_u = UBOUND(SrcOutputData%Vx_wake,2)
  IF (.NOT. ALLOCATED(DstOutputData%Vx_wake)) THEN 
    ALLOCATE(DstOutputData%Vx_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Vx_wake = SrcOutputData%Vx_wake
ENDIF
IF (ALLOCATED(SrcOutputData%Vr_wake)) THEN
  i1_l = LBOUND(SrcOutputData%Vr_wake,1)
  i1_u = UBOUND(SrcOutputData%Vr_wake,1)
  i2_l = LBOUND(SrcOutputData%Vr_wake,2)
  i2_u = UBOUND(SrcOutputData%Vr_wake,2)
  IF (.NOT. ALLOCATED(DstOutputData%Vr_wake)) THEN 
    ALLOCATE(DstOutputData%Vr_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Vr_wake = SrcOutputData%Vr_wake
ENDIF
IF (ALLOCATED(SrcOutputData%D_wake)) THEN
  i1_l = LBOUND(SrcOutputData%D_wake,1)
  i1_u = UBOUND(SrcOutputData%D_wake,1)
  IF (.NOT. ALLOCATED(DstOutputData%D_wake)) THEN 
    ALLOCATE(DstOutputData%D_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%D_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%D_wake = SrcOutputData%D_wake
ENDIF
IF (ALLOCATED(SrcOutputData%x_plane)) THEN
  i1_l = LBOUND(SrcOutputData%x_plane,1)
  i1_u = UBOUND(SrcOutputData%x_plane,1)
  IF (.NOT. ALLOCATED(DstOutputData%x_plane)) THEN 
    ALLOCATE(DstOutputData%x_plane(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%x_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%x_plane = SrcOutputData%x_plane
ENDIF
 END SUBROUTINE WD_CopyOutput

 SUBROUTINE WD_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(WD_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'WD_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%xhat_plane)) THEN
  DEALLOCATE(OutputData%xhat_plane)
ENDIF
IF (ALLOCATED(OutputData%p_plane)) THEN
  DEALLOCATE(OutputData%p_plane)
ENDIF
IF (ALLOCATED(OutputData%Vx_wake)) THEN
  DEALLOCATE(OutputData%Vx_wake)
ENDIF
IF (ALLOCATED(OutputData%Vr_wake)) THEN
  DEALLOCATE(OutputData%Vr_wake)
ENDIF
IF (ALLOCATED(OutputData%D_wake)) THEN
  DEALLOCATE(OutputData%D_wake)
ENDIF
IF (ALLOCATED(OutputData%x_plane)) THEN
  DEALLOCATE(OutputData%x_plane)
ENDIF
 END SUBROUTINE WD_DestroyOutput

 SUBROUTINE WD_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(WD_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! xhat_plane allocated yes/no
  IF ( ALLOCATED(InData%xhat_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! xhat_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%xhat_plane)  ! xhat_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! p_plane allocated yes/no
  IF ( ALLOCATED(InData%p_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! p_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%p_plane)  ! p_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wake allocated yes/no
  IF ( ALLOCATED(InData%Vx_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vx_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wake)  ! Vx_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vr_wake allocated yes/no
  IF ( ALLOCATED(InData%Vr_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vr_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vr_wake)  ! Vr_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! D_wake allocated yes/no
  IF ( ALLOCATED(InData%D_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! D_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%D_wake)  ! D_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! x_plane allocated yes/no
  IF ( ALLOCATED(InData%x_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! x_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%x_plane)  ! x_plane
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%xhat_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%xhat_plane,2), UBOUND(InData%xhat_plane,2)
        DO i1 = LBOUND(InData%xhat_plane,1), UBOUND(InData%xhat_plane,1)
          ReKiBuf(Re_Xferred) = InData%xhat_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%p_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%p_plane,2), UBOUND(InData%p_plane,2)
        DO i1 = LBOUND(InData%p_plane,1), UBOUND(InData%p_plane,1)
          ReKiBuf(Re_Xferred) = InData%p_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vx_wake,2), UBOUND(InData%Vx_wake,2)
        DO i1 = LBOUND(InData%Vx_wake,1), UBOUND(InData%Vx_wake,1)
          ReKiBuf(Re_Xferred) = InData%Vx_wake(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vr_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vr_wake,2), UBOUND(InData%Vr_wake,2)
        DO i1 = LBOUND(InData%Vr_wake,1), UBOUND(InData%Vr_wake,1)
          ReKiBuf(Re_Xferred) = InData%Vr_wake(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%D_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%D_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%D_wake,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%D_wake,1), UBOUND(InData%D_wake,1)
        ReKiBuf(Re_Xferred) = InData%D_wake(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%x_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%x_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%x_plane,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%x_plane,1), UBOUND(InData%x_plane,1)
        ReKiBuf(Re_Xferred) = InData%x_plane(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_PackOutput

 SUBROUTINE WD_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(WD_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'WD_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xhat_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%xhat_plane)) DEALLOCATE(OutData%xhat_plane)
    ALLOCATE(OutData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%xhat_plane,2), UBOUND(OutData%xhat_plane,2)
        DO i1 = LBOUND(OutData%xhat_plane,1), UBOUND(OutData%xhat_plane,1)
          OutData%xhat_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! p_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%p_plane)) DEALLOCATE(OutData%p_plane)
    ALLOCATE(OutData%p_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%p_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%p_plane,2), UBOUND(OutData%p_plane,2)
        DO i1 = LBOUND(OutData%p_plane,1), UBOUND(OutData%p_plane,1)
          OutData%p_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wake)) DEALLOCATE(OutData%Vx_wake)
    ALLOCATE(OutData%Vx_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vx_wake,2), UBOUND(OutData%Vx_wake,2)
        DO i1 = LBOUND(OutData%Vx_wake,1), UBOUND(OutData%Vx_wake,1)
          OutData%Vx_wake(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vr_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vr_wake)) DEALLOCATE(OutData%Vr_wake)
    ALLOCATE(OutData%Vr_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vr_wake,2), UBOUND(OutData%Vr_wake,2)
        DO i1 = LBOUND(OutData%Vr_wake,1), UBOUND(OutData%Vr_wake,1)
          OutData%Vr_wake(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! D_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%D_wake)) DEALLOCATE(OutData%D_wake)
    ALLOCATE(OutData%D_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%D_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%D_wake,1), UBOUND(OutData%D_wake,1)
        OutData%D_wake(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! x_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%x_plane)) DEALLOCATE(OutData%x_plane)
    ALLOCATE(OutData%x_plane(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%x_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%x_plane,1), UBOUND(OutData%x_plane,1)
        OutData%x_plane(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE WD_UnPackOutput

END MODULE WakeDynamics_Types
!ENDOFREGISTRYGENERATEDFILE
