!STARTOFREGISTRYGENERATEDFILE 'SuperController_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SuperController_Types
!.................................................................................................................................
! This file is part of SuperController.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SuperController. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SuperController_Types
!---------------------------------------------------------------------------------------------------------------------------------
!USE, INTRINSIC :: ISO_C_Binding
USE NWTC_Library
IMPLICIT NONE
! =========  SC_InitInputType_C  =======
  TYPE, BIND(C) :: SC_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: nTurbines 
    CHARACTER(KIND=C_CHAR), DIMENSION(1024) :: DLL_FileName 
  END TYPE SC_InitInputType_C
  TYPE, PUBLIC :: SC_InitInputType
    TYPE( SC_InitInputType_C ) :: C_obj
    INTEGER(IntKi)  :: nTurbines      !< Number of turbines in the simulation [-]
    CHARACTER(1024)  :: DLL_FileName      !< Name of the shared library which the super controller logic [-]
  END TYPE SC_InitInputType
! =======================
! =========  SC_InitOutputType_C  =======
  TYPE, BIND(C) :: SC_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: NumCtrl2SC 
    INTEGER(KIND=C_INT) :: nInpGlobal 
    INTEGER(KIND=C_INT) :: NumSC2Ctrl 
    INTEGER(KIND=C_INT) :: NumSC2CtrlGlob 
  END TYPE SC_InitOutputType_C
  TYPE, PUBLIC :: SC_InitOutputType
    TYPE( SC_InitOutputType_C ) :: C_obj
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: NumCtrl2SC      !< Number of turbine controller outputs [to supercontroller] [-]
    INTEGER(IntKi)  :: nInpGlobal      !< Number of global inputs to SC [-]
    INTEGER(IntKi)  :: NumSC2Ctrl      !< Number of turbine specific controller inputs [from supercontroller] [-]
    INTEGER(IntKi)  :: NumSC2CtrlGlob      !< Number of global controller inputs [from supercontroller] [-]
  END TYPE SC_InitOutputType
! =======================
! =========  SC_ParameterType_C  =======
  TYPE, BIND(C) :: SC_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: DT 
    INTEGER(KIND=C_INT) :: nTurbines 
    INTEGER(KIND=C_INT) :: NumCtrl2SC 
    INTEGER(KIND=C_INT) :: nInpGlobal 
    INTEGER(KIND=C_INT) :: NumSC2Ctrl 
    INTEGER(KIND=C_INT) :: NumSC2CtrlGlob 
    INTEGER(KIND=C_INT) :: NumStatesGlobal 
    INTEGER(KIND=C_INT) :: NumStatesTurbine 
    INTEGER(KIND=C_INT) :: NumParamGlobal 
    INTEGER(KIND=C_INT) :: NumParamTurbine 
    TYPE(C_ptr) :: ParamGlobal = C_NULL_PTR 
    INTEGER(C_int) :: ParamGlobal_Len = 0 
    TYPE(C_ptr) :: ParamTurbine = C_NULL_PTR 
    INTEGER(C_int) :: ParamTurbine_Len = 0 
  END TYPE SC_ParameterType_C
  TYPE, PUBLIC :: SC_ParameterType
    TYPE( SC_ParameterType_C ) :: C_obj
    REAL(DbKi)  :: DT      !< Time step for continuous state integration & discrete state update [secondstypedef]
    INTEGER(IntKi)  :: nTurbines      !< Number of turbines in the simulation [-]
    INTEGER(IntKi)  :: NumCtrl2SC      !< Number of turbine controller outputs [to supercontroller] [-]
    INTEGER(IntKi)  :: nInpGlobal      !< Number of global inputs [-]
    INTEGER(IntKi)  :: NumSC2Ctrl      !< Number of turbine specific controller inputs [from supercontroller] [-]
    INTEGER(IntKi)  :: NumSC2CtrlGlob      !< Number of global controller inputs [from supercontroller] [-]
    INTEGER(IntKi)  :: NumStatesGlobal      !< Number of global states [-]
    INTEGER(IntKi)  :: NumStatesTurbine      !< Number of states per turbine [-]
    INTEGER(IntKi)  :: NumParamGlobal      !< Number of global parameters [-]
    INTEGER(IntKi)  :: NumParamTurbine      !< Number of parameters per turbine [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: ParamGlobal => NULL()      !< Global parameters [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: ParamTurbine => NULL()      !< Parameters per turbine [-]
    TYPE(DLL_Type)  :: DLL_Trgt      !< The addresses and names of the super controller shared library and its procedures [-]
  END TYPE SC_ParameterType
! =======================
! =========  SC_DiscreteStateType_C  =======
  TYPE, BIND(C) :: SC_DiscreteStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: Global = C_NULL_PTR 
    INTEGER(C_int) :: Global_Len = 0 
    TYPE(C_ptr) :: Turbine = C_NULL_PTR 
    INTEGER(C_int) :: Turbine_Len = 0 
  END TYPE SC_DiscreteStateType_C
  TYPE, PUBLIC :: SC_DiscreteStateType
    TYPE( SC_DiscreteStateType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: Global => NULL()      !< Global states at time increment, n (total of nStatesGlobal of these states) [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: Turbine => NULL()      !< Turbine-dependent states at time increment, n (total of nTurbines*nStatesTurbine of these states) [-]
  END TYPE SC_DiscreteStateType
! =======================
! =========  SC_ContinuousStateType_C  =======
  TYPE, BIND(C) :: SC_ContinuousStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_FLOAT) :: Dummy 
  END TYPE SC_ContinuousStateType_C
  TYPE, PUBLIC :: SC_ContinuousStateType
    TYPE( SC_ContinuousStateType_C ) :: C_obj
    REAL(SiKi)  :: Dummy      !< Remove this variable if you have continuous states [-]
  END TYPE SC_ContinuousStateType
! =======================
! =========  SC_ConstraintStateType_C  =======
  TYPE, BIND(C) :: SC_ConstraintStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_FLOAT) :: Dummy 
  END TYPE SC_ConstraintStateType_C
  TYPE, PUBLIC :: SC_ConstraintStateType
    TYPE( SC_ConstraintStateType_C ) :: C_obj
    REAL(SiKi)  :: Dummy      !< Remove this variable if you have constraint states [-]
  END TYPE SC_ConstraintStateType
! =======================
! =========  SC_MiscVarType_C  =======
  TYPE, BIND(C) :: SC_MiscVarType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_FLOAT) :: Dummy 
  END TYPE SC_MiscVarType_C
  TYPE, PUBLIC :: SC_MiscVarType
    TYPE( SC_MiscVarType_C ) :: C_obj
    REAL(SiKi)  :: Dummy      !< Remove this variable if you have misc vars [-]
  END TYPE SC_MiscVarType
! =======================
! =========  SC_OtherStateType_C  =======
  TYPE, BIND(C) :: SC_OtherStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: Dummy 
  END TYPE SC_OtherStateType_C
  TYPE, PUBLIC :: SC_OtherStateType
    TYPE( SC_OtherStateType_C ) :: C_obj
    INTEGER(IntKi)  :: Dummy      !< Dummy Other State [-]
  END TYPE SC_OtherStateType
! =======================
! =========  SC_InputType_C  =======
  TYPE, BIND(C) :: SC_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: toSCglob = C_NULL_PTR 
    INTEGER(C_int) :: toSCglob_Len = 0 
    TYPE(C_ptr) :: toSC = C_NULL_PTR 
    INTEGER(C_int) :: toSC_Len = 0 
  END TYPE SC_InputType_C
  TYPE, PUBLIC :: SC_InputType
    TYPE( SC_InputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: toSCglob => NULL()      !< Global inputs [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: toSC => NULL()      !< inputs to the super controller (from the turbine controller) [-]
  END TYPE SC_InputType
! =======================
! =========  SC_OutputType_C  =======
  TYPE, BIND(C) :: SC_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: fromSCglob = C_NULL_PTR 
    INTEGER(C_int) :: fromSCglob_Len = 0 
    TYPE(C_ptr) :: fromSC = C_NULL_PTR 
    INTEGER(C_int) :: fromSC_Len = 0 
  END TYPE SC_OutputType_C
  TYPE, PUBLIC :: SC_OutputType
    TYPE( SC_OutputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fromSCglob => NULL()      !< Global outputs of the super controller (to the turbine controller) [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fromSC => NULL()      !< Turbine specific outputs of the super controller (to the turbine controller) [-]
  END TYPE SC_OutputType
! =======================
CONTAINS
 SUBROUTINE SC_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(SC_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%nTurbines = SrcInitInputData%nTurbines
    DstInitInputData%C_obj%nTurbines = SrcInitInputData%C_obj%nTurbines
    DstInitInputData%DLL_FileName = SrcInitInputData%DLL_FileName
    DstInitInputData%C_obj%DLL_FileName = SrcInitInputData%C_obj%DLL_FileName
 END SUBROUTINE SC_CopyInitInput

 SUBROUTINE SC_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(SC_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DestroyInitInput

 SUBROUTINE SC_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! nTurbines
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%DLL_FileName)  ! DLL_FileName
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%nTurbines
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%DLL_FileName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%DLL_FileName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE SC_PackInitInput

 SUBROUTINE SC_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%nTurbines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%nTurbines = OutData%nTurbines
    DO I = 1, LEN(OutData%DLL_FileName)
      OutData%DLL_FileName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%DLL_FileName = TRANSFER(OutData%DLL_FileName, OutData%C_obj%DLL_FileName )
 END SUBROUTINE SC_UnPackInitInput

 SUBROUTINE SC_C2Fary_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%nTurbines = InitInputData%C_obj%nTurbines
    InitInputData%DLL_FileName = TRANSFER(InitInputData%C_obj%DLL_FileName, InitInputData%DLL_FileName )
 END SUBROUTINE SC_C2Fary_CopyInitInput

 SUBROUTINE SC_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%C_obj%nTurbines = InitInputData%nTurbines
    InitInputData%C_obj%DLL_FileName = TRANSFER(InitInputData%DLL_FileName, InitInputData%C_obj%DLL_FileName )
 END SUBROUTINE SC_F2C_CopyInitInput

 SUBROUTINE SC_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(SC_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstInitOutputData%NumCtrl2SC = SrcInitOutputData%NumCtrl2SC
    DstInitOutputData%C_obj%NumCtrl2SC = SrcInitOutputData%C_obj%NumCtrl2SC
    DstInitOutputData%nInpGlobal = SrcInitOutputData%nInpGlobal
    DstInitOutputData%C_obj%nInpGlobal = SrcInitOutputData%C_obj%nInpGlobal
    DstInitOutputData%NumSC2Ctrl = SrcInitOutputData%NumSC2Ctrl
    DstInitOutputData%C_obj%NumSC2Ctrl = SrcInitOutputData%C_obj%NumSC2Ctrl
    DstInitOutputData%NumSC2CtrlGlob = SrcInitOutputData%NumSC2CtrlGlob
    DstInitOutputData%C_obj%NumSC2CtrlGlob = SrcInitOutputData%C_obj%NumSC2CtrlGlob
 END SUBROUTINE SC_CopyInitOutput

 SUBROUTINE SC_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(SC_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE SC_DestroyInitOutput

 SUBROUTINE SC_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumCtrl2SC
      Int_BufSz  = Int_BufSz  + 1  ! nInpGlobal
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2Ctrl
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2CtrlGlob
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = InData%NumCtrl2SC
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nInpGlobal
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumSC2Ctrl
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumSC2CtrlGlob
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE SC_PackInitOutput

 SUBROUTINE SC_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%NumCtrl2SC = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumCtrl2SC = OutData%NumCtrl2SC
    OutData%nInpGlobal = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%nInpGlobal = OutData%nInpGlobal
    OutData%NumSC2Ctrl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2Ctrl = OutData%NumSC2Ctrl
    OutData%NumSC2CtrlGlob = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2CtrlGlob = OutData%NumSC2CtrlGlob
 END SUBROUTINE SC_UnPackInitOutput

 SUBROUTINE SC_C2Fary_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitOutputData%NumCtrl2SC = InitOutputData%C_obj%NumCtrl2SC
    InitOutputData%nInpGlobal = InitOutputData%C_obj%nInpGlobal
    InitOutputData%NumSC2Ctrl = InitOutputData%C_obj%NumSC2Ctrl
    InitOutputData%NumSC2CtrlGlob = InitOutputData%C_obj%NumSC2CtrlGlob
 END SUBROUTINE SC_C2Fary_CopyInitOutput

 SUBROUTINE SC_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitOutputData%C_obj%NumCtrl2SC = InitOutputData%NumCtrl2SC
    InitOutputData%C_obj%nInpGlobal = InitOutputData%nInpGlobal
    InitOutputData%C_obj%NumSC2Ctrl = InitOutputData%NumSC2Ctrl
    InitOutputData%C_obj%NumSC2CtrlGlob = InitOutputData%NumSC2CtrlGlob
 END SUBROUTINE SC_F2C_CopyInitOutput

 SUBROUTINE SC_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(SC_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
    DstParamData%C_obj%DT = SrcParamData%C_obj%DT
    DstParamData%nTurbines = SrcParamData%nTurbines
    DstParamData%C_obj%nTurbines = SrcParamData%C_obj%nTurbines
    DstParamData%NumCtrl2SC = SrcParamData%NumCtrl2SC
    DstParamData%C_obj%NumCtrl2SC = SrcParamData%C_obj%NumCtrl2SC
    DstParamData%nInpGlobal = SrcParamData%nInpGlobal
    DstParamData%C_obj%nInpGlobal = SrcParamData%C_obj%nInpGlobal
    DstParamData%NumSC2Ctrl = SrcParamData%NumSC2Ctrl
    DstParamData%C_obj%NumSC2Ctrl = SrcParamData%C_obj%NumSC2Ctrl
    DstParamData%NumSC2CtrlGlob = SrcParamData%NumSC2CtrlGlob
    DstParamData%C_obj%NumSC2CtrlGlob = SrcParamData%C_obj%NumSC2CtrlGlob
    DstParamData%NumStatesGlobal = SrcParamData%NumStatesGlobal
    DstParamData%C_obj%NumStatesGlobal = SrcParamData%C_obj%NumStatesGlobal
    DstParamData%NumStatesTurbine = SrcParamData%NumStatesTurbine
    DstParamData%C_obj%NumStatesTurbine = SrcParamData%C_obj%NumStatesTurbine
    DstParamData%NumParamGlobal = SrcParamData%NumParamGlobal
    DstParamData%C_obj%NumParamGlobal = SrcParamData%C_obj%NumParamGlobal
    DstParamData%NumParamTurbine = SrcParamData%NumParamTurbine
    DstParamData%C_obj%NumParamTurbine = SrcParamData%C_obj%NumParamTurbine
IF (ASSOCIATED(SrcParamData%ParamGlobal)) THEN
  i1_l = LBOUND(SrcParamData%ParamGlobal,1)
  i1_u = UBOUND(SrcParamData%ParamGlobal,1)
  IF (.NOT. ASSOCIATED(DstParamData%ParamGlobal)) THEN 
    ALLOCATE(DstParamData%ParamGlobal(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ParamGlobal.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstParamData%c_obj%ParamGlobal_Len = SIZE(DstParamData%ParamGlobal)
    IF (DstParamData%c_obj%ParamGlobal_Len > 0) &
      DstParamData%c_obj%ParamGlobal = C_LOC( DstParamData%ParamGlobal(i1_l) ) 
  END IF
    DstParamData%ParamGlobal = SrcParamData%ParamGlobal
ENDIF
IF (ASSOCIATED(SrcParamData%ParamTurbine)) THEN
  i1_l = LBOUND(SrcParamData%ParamTurbine,1)
  i1_u = UBOUND(SrcParamData%ParamTurbine,1)
  IF (.NOT. ASSOCIATED(DstParamData%ParamTurbine)) THEN 
    ALLOCATE(DstParamData%ParamTurbine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ParamTurbine.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstParamData%c_obj%ParamTurbine_Len = SIZE(DstParamData%ParamTurbine)
    IF (DstParamData%c_obj%ParamTurbine_Len > 0) &
      DstParamData%c_obj%ParamTurbine = C_LOC( DstParamData%ParamTurbine(i1_l) ) 
  END IF
    DstParamData%ParamTurbine = SrcParamData%ParamTurbine
ENDIF
      DstParamData%DLL_Trgt = SrcParamData%DLL_Trgt
 END SUBROUTINE SC_CopyParam

 SUBROUTINE SC_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(SC_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(ParamData%ParamGlobal)) THEN
  DEALLOCATE(ParamData%ParamGlobal)
  ParamData%ParamGlobal => NULL()
  ParamData%C_obj%ParamGlobal = C_NULL_PTR
  ParamData%C_obj%ParamGlobal_Len = 0
ENDIF
IF (ASSOCIATED(ParamData%ParamTurbine)) THEN
  DEALLOCATE(ParamData%ParamTurbine)
  ParamData%ParamTurbine => NULL()
  ParamData%C_obj%ParamTurbine = C_NULL_PTR
  ParamData%C_obj%ParamTurbine_Len = 0
ENDIF
  CALL FreeDynamicLib( ParamData%DLL_Trgt, ErrStat, ErrMsg )
 END SUBROUTINE SC_DestroyParam

 SUBROUTINE SC_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Int_BufSz  = Int_BufSz  + 1  ! nTurbines
      Int_BufSz  = Int_BufSz  + 1  ! NumCtrl2SC
      Int_BufSz  = Int_BufSz  + 1  ! nInpGlobal
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2Ctrl
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2CtrlGlob
      Int_BufSz  = Int_BufSz  + 1  ! NumStatesGlobal
      Int_BufSz  = Int_BufSz  + 1  ! NumStatesTurbine
      Int_BufSz  = Int_BufSz  + 1  ! NumParamGlobal
      Int_BufSz  = Int_BufSz  + 1  ! NumParamTurbine
  Int_BufSz   = Int_BufSz   + 1     ! ParamGlobal allocated yes/no
  IF ( ASSOCIATED(InData%ParamGlobal) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ParamGlobal upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ParamGlobal)  ! ParamGlobal
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ParamTurbine allocated yes/no
  IF ( ASSOCIATED(InData%ParamTurbine) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ParamTurbine upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ParamTurbine)  ! ParamTurbine
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! DLL_Trgt: size of buffers for each call to pack subtype
      CALL DLLTypePack( InData%DLL_Trgt, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! DLL_Trgt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DLL_Trgt
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DLL_Trgt
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DLL_Trgt
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nTurbines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumCtrl2SC
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nInpGlobal
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumSC2Ctrl
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumSC2CtrlGlob
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumStatesGlobal
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumStatesTurbine
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumParamGlobal
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumParamTurbine
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ASSOCIATED(InData%ParamGlobal) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ParamGlobal,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ParamGlobal,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ParamGlobal,1), UBOUND(InData%ParamGlobal,1)
        ReKiBuf(Re_Xferred) = InData%ParamGlobal(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%ParamTurbine) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ParamTurbine,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ParamTurbine,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ParamTurbine,1), UBOUND(InData%ParamTurbine,1)
        ReKiBuf(Re_Xferred) = InData%ParamTurbine(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      CALL DLLTypePack( InData%DLL_Trgt, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! DLL_Trgt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE SC_PackParam

 SUBROUTINE SC_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%DT = OutData%DT
    OutData%nTurbines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%nTurbines = OutData%nTurbines
    OutData%NumCtrl2SC = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumCtrl2SC = OutData%NumCtrl2SC
    OutData%nInpGlobal = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%nInpGlobal = OutData%nInpGlobal
    OutData%NumSC2Ctrl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2Ctrl = OutData%NumSC2Ctrl
    OutData%NumSC2CtrlGlob = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2CtrlGlob = OutData%NumSC2CtrlGlob
    OutData%NumStatesGlobal = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumStatesGlobal = OutData%NumStatesGlobal
    OutData%NumStatesTurbine = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumStatesTurbine = OutData%NumStatesTurbine
    OutData%NumParamGlobal = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumParamGlobal = OutData%NumParamGlobal
    OutData%NumParamTurbine = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumParamTurbine = OutData%NumParamTurbine
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ParamGlobal not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%ParamGlobal)) DEALLOCATE(OutData%ParamGlobal)
    ALLOCATE(OutData%ParamGlobal(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ParamGlobal.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%ParamGlobal_Len = SIZE(OutData%ParamGlobal)
    IF (OutData%c_obj%ParamGlobal_Len > 0) &
       OutData%c_obj%ParamGlobal = C_LOC( OutData%ParamGlobal(i1_l) ) 
      DO i1 = LBOUND(OutData%ParamGlobal,1), UBOUND(OutData%ParamGlobal,1)
        OutData%ParamGlobal(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ParamTurbine not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%ParamTurbine)) DEALLOCATE(OutData%ParamTurbine)
    ALLOCATE(OutData%ParamTurbine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ParamTurbine.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%ParamTurbine_Len = SIZE(OutData%ParamTurbine)
    IF (OutData%c_obj%ParamTurbine_Len > 0) &
       OutData%c_obj%ParamTurbine = C_LOC( OutData%ParamTurbine(i1_l) ) 
      DO i1 = LBOUND(OutData%ParamTurbine,1), UBOUND(OutData%ParamTurbine,1)
        OutData%ParamTurbine(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DLLTypeUnpack( OutData%DLL_Trgt, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! DLL_Trgt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE SC_UnPackParam

 SUBROUTINE SC_C2Fary_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%DT = ParamData%C_obj%DT
    ParamData%nTurbines = ParamData%C_obj%nTurbines
    ParamData%NumCtrl2SC = ParamData%C_obj%NumCtrl2SC
    ParamData%nInpGlobal = ParamData%C_obj%nInpGlobal
    ParamData%NumSC2Ctrl = ParamData%C_obj%NumSC2Ctrl
    ParamData%NumSC2CtrlGlob = ParamData%C_obj%NumSC2CtrlGlob
    ParamData%NumStatesGlobal = ParamData%C_obj%NumStatesGlobal
    ParamData%NumStatesTurbine = ParamData%C_obj%NumStatesTurbine
    ParamData%NumParamGlobal = ParamData%C_obj%NumParamGlobal
    ParamData%NumParamTurbine = ParamData%C_obj%NumParamTurbine

    ! -- ParamGlobal Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%ParamGlobal ) ) THEN
          NULLIFY( ParamData%ParamGlobal )
       ELSE
          CALL C_F_POINTER(ParamData%C_obj%ParamGlobal, ParamData%ParamGlobal, (/ParamData%C_obj%ParamGlobal_Len/))
       END IF
    END IF

    ! -- ParamTurbine Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%ParamTurbine ) ) THEN
          NULLIFY( ParamData%ParamTurbine )
       ELSE
          CALL C_F_POINTER(ParamData%C_obj%ParamTurbine, ParamData%ParamTurbine, (/ParamData%C_obj%ParamTurbine_Len/))
       END IF
    END IF
 END SUBROUTINE SC_C2Fary_CopyParam

 SUBROUTINE SC_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%C_obj%DT = ParamData%DT
    ParamData%C_obj%nTurbines = ParamData%nTurbines
    ParamData%C_obj%NumCtrl2SC = ParamData%NumCtrl2SC
    ParamData%C_obj%nInpGlobal = ParamData%nInpGlobal
    ParamData%C_obj%NumSC2Ctrl = ParamData%NumSC2Ctrl
    ParamData%C_obj%NumSC2CtrlGlob = ParamData%NumSC2CtrlGlob
    ParamData%C_obj%NumStatesGlobal = ParamData%NumStatesGlobal
    ParamData%C_obj%NumStatesTurbine = ParamData%NumStatesTurbine
    ParamData%C_obj%NumParamGlobal = ParamData%NumParamGlobal
    ParamData%C_obj%NumParamTurbine = ParamData%NumParamTurbine

    ! -- ParamGlobal Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ParamData%ParamGlobal)) THEN 
          ParamData%c_obj%ParamGlobal_Len = 0
          ParamData%c_obj%ParamGlobal = C_NULL_PTR
       ELSE
          ParamData%c_obj%ParamGlobal_Len = SIZE(ParamData%ParamGlobal)
          IF (ParamData%c_obj%ParamGlobal_Len > 0) &
             ParamData%c_obj%ParamGlobal = C_LOC( ParamData%ParamGlobal( LBOUND(ParamData%ParamGlobal,1) ) ) 
       END IF
    END IF

    ! -- ParamTurbine Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ParamData%ParamTurbine)) THEN 
          ParamData%c_obj%ParamTurbine_Len = 0
          ParamData%c_obj%ParamTurbine = C_NULL_PTR
       ELSE
          ParamData%c_obj%ParamTurbine_Len = SIZE(ParamData%ParamTurbine)
          IF (ParamData%c_obj%ParamTurbine_Len > 0) &
             ParamData%c_obj%ParamTurbine = C_LOC( ParamData%ParamTurbine( LBOUND(ParamData%ParamTurbine,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_F2C_CopyParam

 SUBROUTINE SC_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(SC_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcDiscStateData%Global)) THEN
  i1_l = LBOUND(SrcDiscStateData%Global,1)
  i1_u = UBOUND(SrcDiscStateData%Global,1)
  IF (.NOT. ASSOCIATED(DstDiscStateData%Global)) THEN 
    ALLOCATE(DstDiscStateData%Global(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Global.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstDiscStateData%c_obj%Global_Len = SIZE(DstDiscStateData%Global)
    IF (DstDiscStateData%c_obj%Global_Len > 0) &
      DstDiscStateData%c_obj%Global = C_LOC( DstDiscStateData%Global(i1_l) ) 
  END IF
    DstDiscStateData%Global = SrcDiscStateData%Global
ENDIF
IF (ASSOCIATED(SrcDiscStateData%Turbine)) THEN
  i1_l = LBOUND(SrcDiscStateData%Turbine,1)
  i1_u = UBOUND(SrcDiscStateData%Turbine,1)
  IF (.NOT. ASSOCIATED(DstDiscStateData%Turbine)) THEN 
    ALLOCATE(DstDiscStateData%Turbine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Turbine.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstDiscStateData%c_obj%Turbine_Len = SIZE(DstDiscStateData%Turbine)
    IF (DstDiscStateData%c_obj%Turbine_Len > 0) &
      DstDiscStateData%c_obj%Turbine = C_LOC( DstDiscStateData%Turbine(i1_l) ) 
  END IF
    DstDiscStateData%Turbine = SrcDiscStateData%Turbine
ENDIF
 END SUBROUTINE SC_CopyDiscState

 SUBROUTINE SC_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(SC_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(DiscStateData%Global)) THEN
  DEALLOCATE(DiscStateData%Global)
  DiscStateData%Global => NULL()
  DiscStateData%C_obj%Global = C_NULL_PTR
  DiscStateData%C_obj%Global_Len = 0
ENDIF
IF (ASSOCIATED(DiscStateData%Turbine)) THEN
  DEALLOCATE(DiscStateData%Turbine)
  DiscStateData%Turbine => NULL()
  DiscStateData%C_obj%Turbine = C_NULL_PTR
  DiscStateData%C_obj%Turbine_Len = 0
ENDIF
 END SUBROUTINE SC_DestroyDiscState

 SUBROUTINE SC_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Global allocated yes/no
  IF ( ASSOCIATED(InData%Global) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Global upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Global)  ! Global
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Turbine allocated yes/no
  IF ( ASSOCIATED(InData%Turbine) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Turbine upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Turbine)  ! Turbine
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%Global) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Global,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Global,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Global,1), UBOUND(InData%Global,1)
        ReKiBuf(Re_Xferred) = InData%Global(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Turbine) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Turbine,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Turbine,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Turbine,1), UBOUND(InData%Turbine,1)
        ReKiBuf(Re_Xferred) = InData%Turbine(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_PackDiscState

 SUBROUTINE SC_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Global not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Global)) DEALLOCATE(OutData%Global)
    ALLOCATE(OutData%Global(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Global.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Global_Len = SIZE(OutData%Global)
    IF (OutData%c_obj%Global_Len > 0) &
       OutData%c_obj%Global = C_LOC( OutData%Global(i1_l) ) 
      DO i1 = LBOUND(OutData%Global,1), UBOUND(OutData%Global,1)
        OutData%Global(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Turbine not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Turbine)) DEALLOCATE(OutData%Turbine)
    ALLOCATE(OutData%Turbine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Turbine.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Turbine_Len = SIZE(OutData%Turbine)
    IF (OutData%c_obj%Turbine_Len > 0) &
       OutData%c_obj%Turbine = C_LOC( OutData%Turbine(i1_l) ) 
      DO i1 = LBOUND(OutData%Turbine,1), UBOUND(OutData%Turbine,1)
        OutData%Turbine(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_UnPackDiscState

 SUBROUTINE SC_C2Fary_CopyDiscState( DiscStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DiscreteStateType), INTENT(INOUT) :: DiscStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- Global DiscState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( DiscStateData%C_obj%Global ) ) THEN
          NULLIFY( DiscStateData%Global )
       ELSE
          CALL C_F_POINTER(DiscStateData%C_obj%Global, DiscStateData%Global, (/DiscStateData%C_obj%Global_Len/))
       END IF
    END IF

    ! -- Turbine DiscState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( DiscStateData%C_obj%Turbine ) ) THEN
          NULLIFY( DiscStateData%Turbine )
       ELSE
          CALL C_F_POINTER(DiscStateData%C_obj%Turbine, DiscStateData%Turbine, (/DiscStateData%C_obj%Turbine_Len/))
       END IF
    END IF
 END SUBROUTINE SC_C2Fary_CopyDiscState

 SUBROUTINE SC_F2C_CopyDiscState( DiscStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DiscreteStateType), INTENT(INOUT) :: DiscStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- Global DiscState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(DiscStateData%Global)) THEN 
          DiscStateData%c_obj%Global_Len = 0
          DiscStateData%c_obj%Global = C_NULL_PTR
       ELSE
          DiscStateData%c_obj%Global_Len = SIZE(DiscStateData%Global)
          IF (DiscStateData%c_obj%Global_Len > 0) &
             DiscStateData%c_obj%Global = C_LOC( DiscStateData%Global( LBOUND(DiscStateData%Global,1) ) ) 
       END IF
    END IF

    ! -- Turbine DiscState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(DiscStateData%Turbine)) THEN 
          DiscStateData%c_obj%Turbine_Len = 0
          DiscStateData%c_obj%Turbine = C_NULL_PTR
       ELSE
          DiscStateData%c_obj%Turbine_Len = SIZE(DiscStateData%Turbine)
          IF (DiscStateData%c_obj%Turbine_Len > 0) &
             DiscStateData%c_obj%Turbine = C_LOC( DiscStateData%Turbine( LBOUND(DiscStateData%Turbine,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_F2C_CopyDiscState

 SUBROUTINE SC_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(SC_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%Dummy = SrcContStateData%Dummy
    DstContStateData%C_obj%Dummy = SrcContStateData%C_obj%Dummy
 END SUBROUTINE SC_CopyContState

 SUBROUTINE SC_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(SC_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DestroyContState

 SUBROUTINE SC_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Dummy
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE SC_PackContState

 SUBROUTINE SC_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Dummy = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%Dummy = OutData%Dummy
 END SUBROUTINE SC_UnPackContState

 SUBROUTINE SC_C2Fary_CopyContState( ContStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_ContinuousStateType), INTENT(INOUT) :: ContStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ContStateData%Dummy = ContStateData%C_obj%Dummy
 END SUBROUTINE SC_C2Fary_CopyContState

 SUBROUTINE SC_F2C_CopyContState( ContStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_ContinuousStateType), INTENT(INOUT) :: ContStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ContStateData%C_obj%Dummy = ContStateData%Dummy
 END SUBROUTINE SC_F2C_CopyContState

 SUBROUTINE SC_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(SC_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%Dummy = SrcConstrStateData%Dummy
    DstConstrStateData%C_obj%Dummy = SrcConstrStateData%C_obj%Dummy
 END SUBROUTINE SC_CopyConstrState

 SUBROUTINE SC_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(SC_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DestroyConstrState

 SUBROUTINE SC_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Dummy
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE SC_PackConstrState

 SUBROUTINE SC_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Dummy = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%Dummy = OutData%Dummy
 END SUBROUTINE SC_UnPackConstrState

 SUBROUTINE SC_C2Fary_CopyConstrState( ConstrStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ConstrStateData%Dummy = ConstrStateData%C_obj%Dummy
 END SUBROUTINE SC_C2Fary_CopyConstrState

 SUBROUTINE SC_F2C_CopyConstrState( ConstrStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ConstrStateData%C_obj%Dummy = ConstrStateData%Dummy
 END SUBROUTINE SC_F2C_CopyConstrState

 SUBROUTINE SC_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(SC_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMiscData%Dummy = SrcMiscData%Dummy
    DstMiscData%C_obj%Dummy = SrcMiscData%C_obj%Dummy
 END SUBROUTINE SC_CopyMisc

 SUBROUTINE SC_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(SC_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DestroyMisc

 SUBROUTINE SC_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Dummy
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE SC_PackMisc

 SUBROUTINE SC_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Dummy = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%Dummy = OutData%Dummy
 END SUBROUTINE SC_UnPackMisc

 SUBROUTINE SC_C2Fary_CopyMisc( MiscData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_MiscVarType), INTENT(INOUT) :: MiscData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    MiscData%Dummy = MiscData%C_obj%Dummy
 END SUBROUTINE SC_C2Fary_CopyMisc

 SUBROUTINE SC_F2C_CopyMisc( MiscData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_MiscVarType), INTENT(INOUT) :: MiscData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    MiscData%C_obj%Dummy = MiscData%Dummy
 END SUBROUTINE SC_F2C_CopyMisc

 SUBROUTINE SC_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(SC_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%Dummy = SrcOtherStateData%Dummy
    DstOtherStateData%C_obj%Dummy = SrcOtherStateData%C_obj%Dummy
 END SUBROUTINE SC_CopyOtherState

 SUBROUTINE SC_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(SC_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DestroyOtherState

 SUBROUTINE SC_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! Dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%Dummy
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE SC_PackOtherState

 SUBROUTINE SC_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Dummy = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%Dummy = OutData%Dummy
 END SUBROUTINE SC_UnPackOtherState

 SUBROUTINE SC_C2Fary_CopyOtherState( OtherStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_OtherStateType), INTENT(INOUT) :: OtherStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    OtherStateData%Dummy = OtherStateData%C_obj%Dummy
 END SUBROUTINE SC_C2Fary_CopyOtherState

 SUBROUTINE SC_F2C_CopyOtherState( OtherStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_OtherStateType), INTENT(INOUT) :: OtherStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    OtherStateData%C_obj%Dummy = OtherStateData%Dummy
 END SUBROUTINE SC_F2C_CopyOtherState

 SUBROUTINE SC_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_InputType), INTENT(IN) :: SrcInputData
   TYPE(SC_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcInputData%toSCglob)) THEN
  i1_l = LBOUND(SrcInputData%toSCglob,1)
  i1_u = UBOUND(SrcInputData%toSCglob,1)
  IF (.NOT. ASSOCIATED(DstInputData%toSCglob)) THEN 
    ALLOCATE(DstInputData%toSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%toSCglob.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%toSCglob_Len = SIZE(DstInputData%toSCglob)
    IF (DstInputData%c_obj%toSCglob_Len > 0) &
      DstInputData%c_obj%toSCglob = C_LOC( DstInputData%toSCglob(i1_l) ) 
  END IF
    DstInputData%toSCglob = SrcInputData%toSCglob
ENDIF
IF (ASSOCIATED(SrcInputData%toSC)) THEN
  i1_l = LBOUND(SrcInputData%toSC,1)
  i1_u = UBOUND(SrcInputData%toSC,1)
  IF (.NOT. ASSOCIATED(DstInputData%toSC)) THEN 
    ALLOCATE(DstInputData%toSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%toSC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%toSC_Len = SIZE(DstInputData%toSC)
    IF (DstInputData%c_obj%toSC_Len > 0) &
      DstInputData%c_obj%toSC = C_LOC( DstInputData%toSC(i1_l) ) 
  END IF
    DstInputData%toSC = SrcInputData%toSC
ENDIF
 END SUBROUTINE SC_CopyInput

 SUBROUTINE SC_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(SC_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(InputData%toSCglob)) THEN
  DEALLOCATE(InputData%toSCglob)
  InputData%toSCglob => NULL()
  InputData%C_obj%toSCglob = C_NULL_PTR
  InputData%C_obj%toSCglob_Len = 0
ENDIF
IF (ASSOCIATED(InputData%toSC)) THEN
  DEALLOCATE(InputData%toSC)
  InputData%toSC => NULL()
  InputData%C_obj%toSC = C_NULL_PTR
  InputData%C_obj%toSC_Len = 0
ENDIF
 END SUBROUTINE SC_DestroyInput

 SUBROUTINE SC_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! toSCglob allocated yes/no
  IF ( ASSOCIATED(InData%toSCglob) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! toSCglob upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%toSCglob)  ! toSCglob
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! toSC allocated yes/no
  IF ( ASSOCIATED(InData%toSC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! toSC upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%toSC)  ! toSC
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%toSCglob) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%toSCglob,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%toSCglob,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%toSCglob,1), UBOUND(InData%toSCglob,1)
        ReKiBuf(Re_Xferred) = InData%toSCglob(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%toSC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%toSC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%toSC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%toSC,1), UBOUND(InData%toSC,1)
        ReKiBuf(Re_Xferred) = InData%toSC(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_PackInput

 SUBROUTINE SC_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! toSCglob not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%toSCglob)) DEALLOCATE(OutData%toSCglob)
    ALLOCATE(OutData%toSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%toSCglob.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%toSCglob_Len = SIZE(OutData%toSCglob)
    IF (OutData%c_obj%toSCglob_Len > 0) &
       OutData%c_obj%toSCglob = C_LOC( OutData%toSCglob(i1_l) ) 
      DO i1 = LBOUND(OutData%toSCglob,1), UBOUND(OutData%toSCglob,1)
        OutData%toSCglob(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! toSC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%toSC)) DEALLOCATE(OutData%toSC)
    ALLOCATE(OutData%toSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%toSC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%toSC_Len = SIZE(OutData%toSC)
    IF (OutData%c_obj%toSC_Len > 0) &
       OutData%c_obj%toSC = C_LOC( OutData%toSC(i1_l) ) 
      DO i1 = LBOUND(OutData%toSC,1), UBOUND(OutData%toSC,1)
        OutData%toSC(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_UnPackInput

 SUBROUTINE SC_C2Fary_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- toSCglob Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%toSCglob ) ) THEN
          NULLIFY( InputData%toSCglob )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%toSCglob, InputData%toSCglob, (/InputData%C_obj%toSCglob_Len/))
       END IF
    END IF

    ! -- toSC Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%toSC ) ) THEN
          NULLIFY( InputData%toSC )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%toSC, InputData%toSC, (/InputData%C_obj%toSC_Len/))
       END IF
    END IF
 END SUBROUTINE SC_C2Fary_CopyInput

 SUBROUTINE SC_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- toSCglob Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%toSCglob)) THEN 
          InputData%c_obj%toSCglob_Len = 0
          InputData%c_obj%toSCglob = C_NULL_PTR
       ELSE
          InputData%c_obj%toSCglob_Len = SIZE(InputData%toSCglob)
          IF (InputData%c_obj%toSCglob_Len > 0) &
             InputData%c_obj%toSCglob = C_LOC( InputData%toSCglob( LBOUND(InputData%toSCglob,1) ) ) 
       END IF
    END IF

    ! -- toSC Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%toSC)) THEN 
          InputData%c_obj%toSC_Len = 0
          InputData%c_obj%toSC = C_NULL_PTR
       ELSE
          InputData%c_obj%toSC_Len = SIZE(InputData%toSC)
          IF (InputData%c_obj%toSC_Len > 0) &
             InputData%c_obj%toSC = C_LOC( InputData%toSC( LBOUND(InputData%toSC,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_F2C_CopyInput

 SUBROUTINE SC_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(SC_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcOutputData%fromSCglob)) THEN
  i1_l = LBOUND(SrcOutputData%fromSCglob,1)
  i1_u = UBOUND(SrcOutputData%fromSCglob,1)
  IF (.NOT. ASSOCIATED(DstOutputData%fromSCglob)) THEN 
    ALLOCATE(DstOutputData%fromSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%fromSCglob.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%fromSCglob_Len = SIZE(DstOutputData%fromSCglob)
    IF (DstOutputData%c_obj%fromSCglob_Len > 0) &
      DstOutputData%c_obj%fromSCglob = C_LOC( DstOutputData%fromSCglob(i1_l) ) 
  END IF
    DstOutputData%fromSCglob = SrcOutputData%fromSCglob
ENDIF
IF (ASSOCIATED(SrcOutputData%fromSC)) THEN
  i1_l = LBOUND(SrcOutputData%fromSC,1)
  i1_u = UBOUND(SrcOutputData%fromSC,1)
  IF (.NOT. ASSOCIATED(DstOutputData%fromSC)) THEN 
    ALLOCATE(DstOutputData%fromSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%fromSC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%fromSC_Len = SIZE(DstOutputData%fromSC)
    IF (DstOutputData%c_obj%fromSC_Len > 0) &
      DstOutputData%c_obj%fromSC = C_LOC( DstOutputData%fromSC(i1_l) ) 
  END IF
    DstOutputData%fromSC = SrcOutputData%fromSC
ENDIF
 END SUBROUTINE SC_CopyOutput

 SUBROUTINE SC_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(SC_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(OutputData%fromSCglob)) THEN
  DEALLOCATE(OutputData%fromSCglob)
  OutputData%fromSCglob => NULL()
  OutputData%C_obj%fromSCglob = C_NULL_PTR
  OutputData%C_obj%fromSCglob_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%fromSC)) THEN
  DEALLOCATE(OutputData%fromSC)
  OutputData%fromSC => NULL()
  OutputData%C_obj%fromSC = C_NULL_PTR
  OutputData%C_obj%fromSC_Len = 0
ENDIF
 END SUBROUTINE SC_DestroyOutput

 SUBROUTINE SC_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! fromSCglob allocated yes/no
  IF ( ASSOCIATED(InData%fromSCglob) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fromSCglob upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fromSCglob)  ! fromSCglob
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fromSC allocated yes/no
  IF ( ASSOCIATED(InData%fromSC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fromSC upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fromSC)  ! fromSC
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%fromSCglob) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fromSCglob,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fromSCglob,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fromSCglob,1), UBOUND(InData%fromSCglob,1)
        ReKiBuf(Re_Xferred) = InData%fromSCglob(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%fromSC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fromSC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fromSC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fromSC,1), UBOUND(InData%fromSC,1)
        ReKiBuf(Re_Xferred) = InData%fromSC(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_PackOutput

 SUBROUTINE SC_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fromSCglob not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fromSCglob)) DEALLOCATE(OutData%fromSCglob)
    ALLOCATE(OutData%fromSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fromSCglob.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fromSCglob_Len = SIZE(OutData%fromSCglob)
    IF (OutData%c_obj%fromSCglob_Len > 0) &
       OutData%c_obj%fromSCglob = C_LOC( OutData%fromSCglob(i1_l) ) 
      DO i1 = LBOUND(OutData%fromSCglob,1), UBOUND(OutData%fromSCglob,1)
        OutData%fromSCglob(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fromSC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fromSC)) DEALLOCATE(OutData%fromSC)
    ALLOCATE(OutData%fromSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fromSC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fromSC_Len = SIZE(OutData%fromSC)
    IF (OutData%c_obj%fromSC_Len > 0) &
       OutData%c_obj%fromSC = C_LOC( OutData%fromSC(i1_l) ) 
      DO i1 = LBOUND(OutData%fromSC,1), UBOUND(OutData%fromSC,1)
        OutData%fromSC(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_UnPackOutput

 SUBROUTINE SC_C2Fary_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- fromSCglob Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%fromSCglob ) ) THEN
          NULLIFY( OutputData%fromSCglob )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%fromSCglob, OutputData%fromSCglob, (/OutputData%C_obj%fromSCglob_Len/))
       END IF
    END IF

    ! -- fromSC Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%fromSC ) ) THEN
          NULLIFY( OutputData%fromSC )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%fromSC, OutputData%fromSC, (/OutputData%C_obj%fromSC_Len/))
       END IF
    END IF
 END SUBROUTINE SC_C2Fary_CopyOutput

 SUBROUTINE SC_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- fromSCglob Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%fromSCglob)) THEN 
          OutputData%c_obj%fromSCglob_Len = 0
          OutputData%c_obj%fromSCglob = C_NULL_PTR
       ELSE
          OutputData%c_obj%fromSCglob_Len = SIZE(OutputData%fromSCglob)
          IF (OutputData%c_obj%fromSCglob_Len > 0) &
             OutputData%c_obj%fromSCglob = C_LOC( OutputData%fromSCglob( LBOUND(OutputData%fromSCglob,1) ) ) 
       END IF
    END IF

    ! -- fromSC Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%fromSC)) THEN 
          OutputData%c_obj%fromSC_Len = 0
          OutputData%c_obj%fromSC = C_NULL_PTR
       ELSE
          OutputData%c_obj%fromSC_Len = SIZE(OutputData%fromSC)
          IF (OutputData%c_obj%fromSC_Len > 0) &
             OutputData%c_obj%fromSC = C_LOC( OutputData%fromSC( LBOUND(OutputData%fromSC,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_F2C_CopyOutput


 SUBROUTINE SC_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(SC_InputType), INTENT(IN)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(SC_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'SC_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL SC_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL SC_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL SC_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE SC_Input_ExtrapInterp


 SUBROUTINE SC_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(SC_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
 TYPE(SC_InputType), INTENT(IN)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(SC_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'SC_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(u_out%toSCglob) .AND. ASSOCIATED(u1%toSCglob)) THEN
  DO i1 = LBOUND(u_out%toSCglob,1),UBOUND(u_out%toSCglob,1)
    b = -(u1%toSCglob(i1) - u2%toSCglob(i1))
    u_out%toSCglob(i1) = u1%toSCglob(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%toSC) .AND. ASSOCIATED(u1%toSC)) THEN
  DO i1 = LBOUND(u_out%toSC,1),UBOUND(u_out%toSC,1)
    b = -(u1%toSC(i1) - u2%toSC(i1))
    u_out%toSC(i1) = u1%toSC(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE SC_Input_ExtrapInterp1


 SUBROUTINE SC_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(SC_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
 TYPE(SC_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
 TYPE(SC_InputType), INTENT(IN)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(SC_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'SC_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(u_out%toSCglob) .AND. ASSOCIATED(u1%toSCglob)) THEN
  DO i1 = LBOUND(u_out%toSCglob,1),UBOUND(u_out%toSCglob,1)
    b = (t(3)**2*(u1%toSCglob(i1) - u2%toSCglob(i1)) + t(2)**2*(-u1%toSCglob(i1) + u3%toSCglob(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%toSCglob(i1) + t(3)*u2%toSCglob(i1) - t(2)*u3%toSCglob(i1) ) * scaleFactor
    u_out%toSCglob(i1) = u1%toSCglob(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%toSC) .AND. ASSOCIATED(u1%toSC)) THEN
  DO i1 = LBOUND(u_out%toSC,1),UBOUND(u_out%toSC,1)
    b = (t(3)**2*(u1%toSC(i1) - u2%toSC(i1)) + t(2)**2*(-u1%toSC(i1) + u3%toSC(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%toSC(i1) + t(3)*u2%toSC(i1) - t(2)*u3%toSC(i1) ) * scaleFactor
    u_out%toSC(i1) = u1%toSC(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE SC_Input_ExtrapInterp2


 SUBROUTINE SC_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(SC_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(SC_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'SC_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL SC_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL SC_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL SC_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE SC_Output_ExtrapInterp


 SUBROUTINE SC_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(SC_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(SC_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(SC_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'SC_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(y_out%fromSCglob) .AND. ASSOCIATED(y1%fromSCglob)) THEN
  DO i1 = LBOUND(y_out%fromSCglob,1),UBOUND(y_out%fromSCglob,1)
    b = -(y1%fromSCglob(i1) - y2%fromSCglob(i1))
    y_out%fromSCglob(i1) = y1%fromSCglob(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%fromSC) .AND. ASSOCIATED(y1%fromSC)) THEN
  DO i1 = LBOUND(y_out%fromSC,1),UBOUND(y_out%fromSC,1)
    b = -(y1%fromSC(i1) - y2%fromSC(i1))
    y_out%fromSC(i1) = y1%fromSC(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE SC_Output_ExtrapInterp1


 SUBROUTINE SC_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(SC_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(SC_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(SC_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(SC_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'SC_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(y_out%fromSCglob) .AND. ASSOCIATED(y1%fromSCglob)) THEN
  DO i1 = LBOUND(y_out%fromSCglob,1),UBOUND(y_out%fromSCglob,1)
    b = (t(3)**2*(y1%fromSCglob(i1) - y2%fromSCglob(i1)) + t(2)**2*(-y1%fromSCglob(i1) + y3%fromSCglob(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%fromSCglob(i1) + t(3)*y2%fromSCglob(i1) - t(2)*y3%fromSCglob(i1) ) * scaleFactor
    y_out%fromSCglob(i1) = y1%fromSCglob(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%fromSC) .AND. ASSOCIATED(y1%fromSC)) THEN
  DO i1 = LBOUND(y_out%fromSC,1),UBOUND(y_out%fromSC,1)
    b = (t(3)**2*(y1%fromSC(i1) - y2%fromSC(i1)) + t(2)**2*(-y1%fromSC(i1) + y3%fromSC(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%fromSC(i1) + t(3)*y2%fromSC(i1) - t(2)*y3%fromSC(i1) ) * scaleFactor
    y_out%fromSC(i1) = y1%fromSC(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE SC_Output_ExtrapInterp2

END MODULE SuperController_Types
!ENDOFREGISTRYGENERATEDFILE
