!STARTOFREGISTRYGENERATEDFILE 'SCDataEx_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! SCDataEx_Types
!.................................................................................................................................
! This file is part of SCDataEx.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in SCDataEx. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE SCDataEx_Types
!---------------------------------------------------------------------------------------------------------------------------------
!USE, INTRINSIC :: ISO_C_Binding
USE NWTC_Library
IMPLICIT NONE
! =========  SC_DX_InitInputType_C  =======
  TYPE, BIND(C) :: SC_DX_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: NumSC2Ctrl 
    INTEGER(KIND=C_INT) :: NumSC2CtrlGlob 
    INTEGER(KIND=C_INT) :: NumCtrl2SC 
  END TYPE SC_DX_InitInputType_C
  TYPE, PUBLIC :: SC_DX_InitInputType
    TYPE( SC_DX_InitInputType_C ) :: C_obj
    INTEGER(IntKi)  :: NumSC2Ctrl      !< number of turbine specific controller inputs [from supercontroller] [-]
    INTEGER(IntKi)  :: NumSC2CtrlGlob      !< number of global controller inputs [from supercontroller] [-]
    INTEGER(IntKi)  :: NumCtrl2SC      !< number of controller outputs [to supercontroller] [-]
  END TYPE SC_DX_InitInputType
! =======================
! =========  SC_DX_InitOutputType_C  =======
  TYPE, BIND(C) :: SC_DX_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
  END TYPE SC_DX_InitOutputType_C
  TYPE, PUBLIC :: SC_DX_InitOutputType
    TYPE( SC_DX_InitOutputType_C ) :: C_obj
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE SC_DX_InitOutputType
! =======================
! =========  SC_DX_ParameterType_C  =======
  TYPE, BIND(C) :: SC_DX_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    LOGICAL(KIND=C_BOOL) :: useSC 
  END TYPE SC_DX_ParameterType_C
  TYPE, PUBLIC :: SC_DX_ParameterType
    TYPE( SC_DX_ParameterType_C ) :: C_obj
    LOGICAL  :: useSC = .FALSE.      !< Flag that tells this module if supercontroller is on. [-]
  END TYPE SC_DX_ParameterType
! =======================
! =========  SC_DX_InputType_C  =======
  TYPE, BIND(C) :: SC_DX_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: toSC = C_NULL_PTR 
    INTEGER(C_int) :: toSC_Len = 0 
  END TYPE SC_DX_InputType_C
  TYPE, PUBLIC :: SC_DX_InputType
    TYPE( SC_DX_InputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: toSC => NULL()      !< inputs to the super controller (from the turbine controller) [-]
  END TYPE SC_DX_InputType
! =======================
! =========  SC_DX_OutputType_C  =======
  TYPE, BIND(C) :: SC_DX_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: fromSC = C_NULL_PTR 
    INTEGER(C_int) :: fromSC_Len = 0 
    TYPE(C_ptr) :: fromSCglob = C_NULL_PTR 
    INTEGER(C_int) :: fromSCglob_Len = 0 
  END TYPE SC_DX_OutputType_C
  TYPE, PUBLIC :: SC_DX_OutputType
    TYPE( SC_DX_OutputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fromSC => NULL()      !< global outputs of the super controller (to the turbine controller) [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fromSCglob => NULL()      !< turbine specific outputs of the super controller (to the turbine controller) [-]
  END TYPE SC_DX_OutputType
! =======================
CONTAINS
 SUBROUTINE SC_DX_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DX_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(SC_DX_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%NumSC2Ctrl = SrcInitInputData%NumSC2Ctrl
    DstInitInputData%C_obj%NumSC2Ctrl = SrcInitInputData%C_obj%NumSC2Ctrl
    DstInitInputData%NumSC2CtrlGlob = SrcInitInputData%NumSC2CtrlGlob
    DstInitInputData%C_obj%NumSC2CtrlGlob = SrcInitInputData%C_obj%NumSC2CtrlGlob
    DstInitInputData%NumCtrl2SC = SrcInitInputData%NumCtrl2SC
    DstInitInputData%C_obj%NumCtrl2SC = SrcInitInputData%C_obj%NumCtrl2SC
 END SUBROUTINE SC_DX_CopyInitInput

 SUBROUTINE SC_DX_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(SC_DX_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DX_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DX_DestroyInitInput

 SUBROUTINE SC_DX_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DX_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2Ctrl
      Int_BufSz  = Int_BufSz  + 1  ! NumSC2CtrlGlob
      Int_BufSz  = Int_BufSz  + 1  ! NumCtrl2SC
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NumSC2Ctrl
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumSC2CtrlGlob
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumCtrl2SC
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE SC_DX_PackInitInput

 SUBROUTINE SC_DX_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DX_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NumSC2Ctrl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2Ctrl = OutData%NumSC2Ctrl
    OutData%NumSC2CtrlGlob = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumSC2CtrlGlob = OutData%NumSC2CtrlGlob
    OutData%NumCtrl2SC = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumCtrl2SC = OutData%NumCtrl2SC
 END SUBROUTINE SC_DX_UnPackInitInput

 SUBROUTINE SC_DX_C2Fary_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DX_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%NumSC2Ctrl = InitInputData%C_obj%NumSC2Ctrl
    InitInputData%NumSC2CtrlGlob = InitInputData%C_obj%NumSC2CtrlGlob
    InitInputData%NumCtrl2SC = InitInputData%C_obj%NumCtrl2SC
 END SUBROUTINE SC_DX_C2Fary_CopyInitInput

 SUBROUTINE SC_DX_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DX_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%C_obj%NumSC2Ctrl = InitInputData%NumSC2Ctrl
    InitInputData%C_obj%NumSC2CtrlGlob = InitInputData%NumSC2CtrlGlob
    InitInputData%C_obj%NumCtrl2SC = InitInputData%NumCtrl2SC
 END SUBROUTINE SC_DX_F2C_CopyInitInput

 SUBROUTINE SC_DX_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DX_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(SC_DX_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE SC_DX_CopyInitOutput

 SUBROUTINE SC_DX_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(SC_DX_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DX_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE SC_DX_DestroyInitOutput

 SUBROUTINE SC_DX_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DX_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE SC_DX_PackInitOutput

 SUBROUTINE SC_DX_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DX_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE SC_DX_UnPackInitOutput

 SUBROUTINE SC_DX_C2Fary_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DX_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE SC_DX_C2Fary_CopyInitOutput

 SUBROUTINE SC_DX_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DX_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE SC_DX_F2C_CopyInitOutput

 SUBROUTINE SC_DX_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DX_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(SC_DX_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%useSC = SrcParamData%useSC
    DstParamData%C_obj%useSC = SrcParamData%C_obj%useSC
 END SUBROUTINE SC_DX_CopyParam

 SUBROUTINE SC_DX_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(SC_DX_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DX_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE SC_DX_DestroyParam

 SUBROUTINE SC_DX_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DX_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! useSC
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = TRANSFER(InData%useSC, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE SC_DX_PackParam

 SUBROUTINE SC_DX_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DX_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%useSC = TRANSFER(IntKiBuf(Int_Xferred), OutData%useSC)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%useSC = OutData%useSC
 END SUBROUTINE SC_DX_UnPackParam

 SUBROUTINE SC_DX_C2Fary_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DX_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%useSC = ParamData%C_obj%useSC
 END SUBROUTINE SC_DX_C2Fary_CopyParam

 SUBROUTINE SC_DX_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DX_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%C_obj%useSC = ParamData%useSC
 END SUBROUTINE SC_DX_F2C_CopyParam

 SUBROUTINE SC_DX_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DX_InputType), INTENT(IN) :: SrcInputData
   TYPE(SC_DX_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcInputData%toSC)) THEN
  i1_l = LBOUND(SrcInputData%toSC,1)
  i1_u = UBOUND(SrcInputData%toSC,1)
  IF (.NOT. ASSOCIATED(DstInputData%toSC)) THEN 
    ALLOCATE(DstInputData%toSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%toSC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%toSC_Len = SIZE(DstInputData%toSC)
    IF (DstInputData%c_obj%toSC_Len > 0) &
      DstInputData%c_obj%toSC = C_LOC( DstInputData%toSC(i1_l) ) 
  END IF
    DstInputData%toSC = SrcInputData%toSC
ENDIF
 END SUBROUTINE SC_DX_CopyInput

 SUBROUTINE SC_DX_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(SC_DX_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DX_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(InputData%toSC)) THEN
  DEALLOCATE(InputData%toSC)
  InputData%toSC => NULL()
  InputData%C_obj%toSC = C_NULL_PTR
  InputData%C_obj%toSC_Len = 0
ENDIF
 END SUBROUTINE SC_DX_DestroyInput

 SUBROUTINE SC_DX_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DX_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! toSC allocated yes/no
  IF ( ASSOCIATED(InData%toSC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! toSC upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%toSC)  ! toSC
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%toSC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%toSC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%toSC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%toSC,1), UBOUND(InData%toSC,1)
        ReKiBuf(Re_Xferred) = InData%toSC(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_DX_PackInput

 SUBROUTINE SC_DX_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DX_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! toSC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%toSC)) DEALLOCATE(OutData%toSC)
    ALLOCATE(OutData%toSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%toSC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%toSC_Len = SIZE(OutData%toSC)
    IF (OutData%c_obj%toSC_Len > 0) &
       OutData%c_obj%toSC = C_LOC( OutData%toSC(i1_l) ) 
      DO i1 = LBOUND(OutData%toSC,1), UBOUND(OutData%toSC,1)
        OutData%toSC(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_DX_UnPackInput

 SUBROUTINE SC_DX_C2Fary_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DX_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- toSC Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%toSC ) ) THEN
          NULLIFY( InputData%toSC )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%toSC, InputData%toSC, (/InputData%C_obj%toSC_Len/))
       END IF
    END IF
 END SUBROUTINE SC_DX_C2Fary_CopyInput

 SUBROUTINE SC_DX_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DX_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- toSC Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%toSC)) THEN 
          InputData%c_obj%toSC_Len = 0
          InputData%c_obj%toSC = C_NULL_PTR
       ELSE
          InputData%c_obj%toSC_Len = SIZE(InputData%toSC)
          IF (InputData%c_obj%toSC_Len > 0) &
             InputData%c_obj%toSC = C_LOC( InputData%toSC( LBOUND(InputData%toSC,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_DX_F2C_CopyInput

 SUBROUTINE SC_DX_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(SC_DX_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(SC_DX_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcOutputData%fromSC)) THEN
  i1_l = LBOUND(SrcOutputData%fromSC,1)
  i1_u = UBOUND(SrcOutputData%fromSC,1)
  IF (.NOT. ASSOCIATED(DstOutputData%fromSC)) THEN 
    ALLOCATE(DstOutputData%fromSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%fromSC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%fromSC_Len = SIZE(DstOutputData%fromSC)
    IF (DstOutputData%c_obj%fromSC_Len > 0) &
      DstOutputData%c_obj%fromSC = C_LOC( DstOutputData%fromSC(i1_l) ) 
  END IF
    DstOutputData%fromSC = SrcOutputData%fromSC
ENDIF
IF (ASSOCIATED(SrcOutputData%fromSCglob)) THEN
  i1_l = LBOUND(SrcOutputData%fromSCglob,1)
  i1_u = UBOUND(SrcOutputData%fromSCglob,1)
  IF (.NOT. ASSOCIATED(DstOutputData%fromSCglob)) THEN 
    ALLOCATE(DstOutputData%fromSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%fromSCglob.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%fromSCglob_Len = SIZE(DstOutputData%fromSCglob)
    IF (DstOutputData%c_obj%fromSCglob_Len > 0) &
      DstOutputData%c_obj%fromSCglob = C_LOC( DstOutputData%fromSCglob(i1_l) ) 
  END IF
    DstOutputData%fromSCglob = SrcOutputData%fromSCglob
ENDIF
 END SUBROUTINE SC_DX_CopyOutput

 SUBROUTINE SC_DX_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(SC_DX_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'SC_DX_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(OutputData%fromSC)) THEN
  DEALLOCATE(OutputData%fromSC)
  OutputData%fromSC => NULL()
  OutputData%C_obj%fromSC = C_NULL_PTR
  OutputData%C_obj%fromSC_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%fromSCglob)) THEN
  DEALLOCATE(OutputData%fromSCglob)
  OutputData%fromSCglob => NULL()
  OutputData%C_obj%fromSCglob = C_NULL_PTR
  OutputData%C_obj%fromSCglob_Len = 0
ENDIF
 END SUBROUTINE SC_DX_DestroyOutput

 SUBROUTINE SC_DX_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(SC_DX_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! fromSC allocated yes/no
  IF ( ASSOCIATED(InData%fromSC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fromSC upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fromSC)  ! fromSC
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fromSCglob allocated yes/no
  IF ( ASSOCIATED(InData%fromSCglob) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fromSCglob upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fromSCglob)  ! fromSCglob
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%fromSC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fromSC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fromSC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fromSC,1), UBOUND(InData%fromSC,1)
        ReKiBuf(Re_Xferred) = InData%fromSC(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%fromSCglob) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fromSCglob,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fromSCglob,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fromSCglob,1), UBOUND(InData%fromSCglob,1)
        ReKiBuf(Re_Xferred) = InData%fromSCglob(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_DX_PackOutput

 SUBROUTINE SC_DX_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(SC_DX_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'SC_DX_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fromSC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fromSC)) DEALLOCATE(OutData%fromSC)
    ALLOCATE(OutData%fromSC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fromSC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fromSC_Len = SIZE(OutData%fromSC)
    IF (OutData%c_obj%fromSC_Len > 0) &
       OutData%c_obj%fromSC = C_LOC( OutData%fromSC(i1_l) ) 
      DO i1 = LBOUND(OutData%fromSC,1), UBOUND(OutData%fromSC,1)
        OutData%fromSC(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fromSCglob not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fromSCglob)) DEALLOCATE(OutData%fromSCglob)
    ALLOCATE(OutData%fromSCglob(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fromSCglob.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fromSCglob_Len = SIZE(OutData%fromSCglob)
    IF (OutData%c_obj%fromSCglob_Len > 0) &
       OutData%c_obj%fromSCglob = C_LOC( OutData%fromSCglob(i1_l) ) 
      DO i1 = LBOUND(OutData%fromSCglob,1), UBOUND(OutData%fromSCglob,1)
        OutData%fromSCglob(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE SC_DX_UnPackOutput

 SUBROUTINE SC_DX_C2Fary_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(SC_DX_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- fromSC Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%fromSC ) ) THEN
          NULLIFY( OutputData%fromSC )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%fromSC, OutputData%fromSC, (/OutputData%C_obj%fromSC_Len/))
       END IF
    END IF

    ! -- fromSCglob Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%fromSCglob ) ) THEN
          NULLIFY( OutputData%fromSCglob )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%fromSCglob, OutputData%fromSCglob, (/OutputData%C_obj%fromSCglob_Len/))
       END IF
    END IF
 END SUBROUTINE SC_DX_C2Fary_CopyOutput

 SUBROUTINE SC_DX_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(SC_DX_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- fromSC Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%fromSC)) THEN 
          OutputData%c_obj%fromSC_Len = 0
          OutputData%c_obj%fromSC = C_NULL_PTR
       ELSE
          OutputData%c_obj%fromSC_Len = SIZE(OutputData%fromSC)
          IF (OutputData%c_obj%fromSC_Len > 0) &
             OutputData%c_obj%fromSC = C_LOC( OutputData%fromSC( LBOUND(OutputData%fromSC,1) ) ) 
       END IF
    END IF

    ! -- fromSCglob Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%fromSCglob)) THEN 
          OutputData%c_obj%fromSCglob_Len = 0
          OutputData%c_obj%fromSCglob = C_NULL_PTR
       ELSE
          OutputData%c_obj%fromSCglob_Len = SIZE(OutputData%fromSCglob)
          IF (OutputData%c_obj%fromSCglob_Len > 0) &
             OutputData%c_obj%fromSCglob = C_LOC( OutputData%fromSCglob( LBOUND(OutputData%fromSCglob,1) ) ) 
       END IF
    END IF
 END SUBROUTINE SC_DX_F2C_CopyOutput

END MODULE SCDataEx_Types
!ENDOFREGISTRYGENERATEDFILE
