!STARTOFREGISTRYGENERATEDFILE 'OpenFOAM_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! OpenFOAM_Types
!.................................................................................................................................
! This file is part of OpenFOAM.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in OpenFOAM. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE OpenFOAM_Types
!---------------------------------------------------------------------------------------------------------------------------------
!USE, INTRINSIC :: ISO_C_Binding
USE NWTC_Library
IMPLICIT NONE
! =========  OpFM_InitInputType_C  =======
  TYPE, BIND(C) :: OpFM_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    INTEGER(KIND=C_INT) :: NumActForcePtsBlade 
    INTEGER(KIND=C_INT) :: NumActForcePtsTower 
    TYPE(C_ptr) :: StructBldRNodes = C_NULL_PTR 
    INTEGER(C_int) :: StructBldRNodes_Len = 0 
    TYPE(C_ptr) :: StructTwrHNodes = C_NULL_PTR 
    INTEGER(C_int) :: StructTwrHNodes_Len = 0 
    REAL(KIND=C_FLOAT) :: BladeLength 
    REAL(KIND=C_FLOAT) :: TowerHeight 
    REAL(KIND=C_FLOAT) :: TowerBaseHeight 
  END TYPE OpFM_InitInputType_C
  TYPE, PUBLIC :: OpFM_InitInputType
    TYPE( OpFM_InitInputType_C ) :: C_obj
    INTEGER(IntKi)  :: NumActForcePtsBlade      !< number of actuator line force points in blade [-]
    INTEGER(IntKi)  :: NumActForcePtsTower      !< number of actuator line force points in tower [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: StructBldRNodes => NULL()      !< Radius to structural model analysis nodes relative to hub [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: StructTwrHNodes => NULL()      !< Location of variable-spaced structural model tower nodes (relative to the tower rigid base height) [-]
    REAL(ReKi)  :: BladeLength      !< Blade length [meters]
    REAL(ReKi)  :: TowerHeight      !< Tower Height [meters]
    REAL(ReKi)  :: TowerBaseHeight      !< Tower Base Height [meters]
  END TYPE OpFM_InitInputType
! =======================
! =========  OpFM_InitOutputType_C  =======
  TYPE, BIND(C) :: OpFM_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: WriteOutputHdr = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutputHdr_Len = 0 
    TYPE(C_ptr) :: WriteOutputUnt = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutputUnt_Len = 0 
  END TYPE OpFM_InitOutputType_C
  TYPE, PUBLIC :: OpFM_InitOutputType
    TYPE( OpFM_InitOutputType_C ) :: C_obj
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE OpFM_InitOutputType
! =======================
! =========  OpFM_MiscVarType_C  =======
  TYPE, BIND(C) :: OpFM_MiscVarType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
  END TYPE OpFM_MiscVarType_C
  TYPE, PUBLIC :: OpFM_MiscVarType
    TYPE( OpFM_MiscVarType_C ) :: C_obj
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceLoads      !< line2 mesh for transferring AeroDyn distributed loads to OpenFOAM [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceMotions      !< line2 mesh for transferring AeroDyn distributed loads to OpenFOAM (needs translationDisp) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceMotionsPoints      !< point mesh for transferring AeroDyn distributed loads to OpenFOAM (needs translationDisp) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ActForceLoadsPoints      !< point mesh for transferring AeroDyn distributed loads to OpenFOAM [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Line2_Loads      !< mapping data structure to convert line2 loads to line2 loads [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Line2_Motions      !< mapping data structure to convert line2 loads to line2 motions [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Point_Loads      !< mapping data structure to convert line2 loads to point loads [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: Line2_to_Point_Motions      !< mapping data structure to convert line2 loads to point motions [-]
  END TYPE OpFM_MiscVarType
! =======================
! =========  OpFM_ParameterType_C  =======
  TYPE, BIND(C) :: OpFM_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_FLOAT) :: AirDens 
    INTEGER(KIND=C_INT) :: NumBl 
    INTEGER(KIND=C_INT) :: NMappings 
    INTEGER(KIND=C_INT) :: NnodesVel 
    INTEGER(KIND=C_INT) :: NnodesForce 
    INTEGER(KIND=C_INT) :: NnodesForceBlade 
    INTEGER(KIND=C_INT) :: NnodesForceTower 
    TYPE(C_ptr) :: forceBldRnodes = C_NULL_PTR 
    INTEGER(C_int) :: forceBldRnodes_Len = 0 
    TYPE(C_ptr) :: forceTwrHnodes = C_NULL_PTR 
    INTEGER(C_int) :: forceTwrHnodes_Len = 0 
    REAL(KIND=C_FLOAT) :: BladeLength 
    REAL(KIND=C_FLOAT) :: TowerHeight 
    REAL(KIND=C_FLOAT) :: TowerBaseHeight 
  END TYPE OpFM_ParameterType_C
  TYPE, PUBLIC :: OpFM_ParameterType
    TYPE( OpFM_ParameterType_C ) :: C_obj
    REAL(ReKi)  :: AirDens      !< Air density for normalization of loads sent to OpenFOAM [kg/m^3]
    INTEGER(IntKi)  :: NumBl      !< Number of blades [-]
    INTEGER(IntKi)  :: NMappings      !< Number of mappings [-]
    INTEGER(IntKi)  :: NnodesVel      !< number of velocity nodes on FAST v8-OpenFOAM interface [-]
    INTEGER(IntKi)  :: NnodesForce      !< number of force nodes on FAST v8-OpenFOAM interface [-]
    INTEGER(IntKi)  :: NnodesForceBlade      !< number of force nodes on FAST v8-OpenFOAM interface [-]
    INTEGER(IntKi)  :: NnodesForceTower      !< number of force nodes on FAST v8-OpenFOAM interface [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceBldRnodes => NULL() 
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceTwrHnodes => NULL() 
    REAL(ReKi)  :: BladeLength      !< Blade length (same for all blades) [m]
    REAL(ReKi)  :: TowerHeight      !< Tower height [m]
    REAL(ReKi)  :: TowerBaseHeight      !< Tower base height [m]
  END TYPE OpFM_ParameterType
! =======================
! =========  OpFM_InputType_C  =======
  TYPE, BIND(C) :: OpFM_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: pxVel = C_NULL_PTR 
    INTEGER(C_int) :: pxVel_Len = 0 
    TYPE(C_ptr) :: pyVel = C_NULL_PTR 
    INTEGER(C_int) :: pyVel_Len = 0 
    TYPE(C_ptr) :: pzVel = C_NULL_PTR 
    INTEGER(C_int) :: pzVel_Len = 0 
    TYPE(C_ptr) :: pxForce = C_NULL_PTR 
    INTEGER(C_int) :: pxForce_Len = 0 
    TYPE(C_ptr) :: pyForce = C_NULL_PTR 
    INTEGER(C_int) :: pyForce_Len = 0 
    TYPE(C_ptr) :: pzForce = C_NULL_PTR 
    INTEGER(C_int) :: pzForce_Len = 0 
    TYPE(C_ptr) :: xdotForce = C_NULL_PTR 
    INTEGER(C_int) :: xdotForce_Len = 0 
    TYPE(C_ptr) :: ydotForce = C_NULL_PTR 
    INTEGER(C_int) :: ydotForce_Len = 0 
    TYPE(C_ptr) :: zdotForce = C_NULL_PTR 
    INTEGER(C_int) :: zdotForce_Len = 0 
    TYPE(C_ptr) :: pOrientation = C_NULL_PTR 
    INTEGER(C_int) :: pOrientation_Len = 0 
    TYPE(C_ptr) :: fx = C_NULL_PTR 
    INTEGER(C_int) :: fx_Len = 0 
    TYPE(C_ptr) :: fy = C_NULL_PTR 
    INTEGER(C_int) :: fy_Len = 0 
    TYPE(C_ptr) :: fz = C_NULL_PTR 
    INTEGER(C_int) :: fz_Len = 0 
    TYPE(C_ptr) :: momentx = C_NULL_PTR 
    INTEGER(C_int) :: momentx_Len = 0 
    TYPE(C_ptr) :: momenty = C_NULL_PTR 
    INTEGER(C_int) :: momenty_Len = 0 
    TYPE(C_ptr) :: momentz = C_NULL_PTR 
    INTEGER(C_int) :: momentz_Len = 0 
    TYPE(C_ptr) :: forceNodesChord = C_NULL_PTR 
    INTEGER(C_int) :: forceNodesChord_Len = 0 
  END TYPE OpFM_InputType_C
  TYPE, PUBLIC :: OpFM_InputType
    TYPE( OpFM_InputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pxVel => NULL()      !< x position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pyVel => NULL()      !< y position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pzVel => NULL()      !< z position of velocity interface (Aerodyn) nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pxForce => NULL()      !< x position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pyForce => NULL()      !< y position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pzForce => NULL()      !< z position of actuator force nodes [m]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: xdotForce => NULL()      !< x velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: ydotForce => NULL()      !< y velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: zdotForce => NULL()      !< z velocity of actuator force nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: pOrientation => NULL()      !< Direction cosine matrix to transform vectors from global frame of reference to actuator force node frame of reference [-]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fx => NULL()      !< normalized x force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fy => NULL()      !< normalized y force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: fz => NULL()      !< normalized z force at actuator force nodes [N/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momentx => NULL()      !< normalized x moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momenty => NULL()      !< normalized y moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: momentz => NULL()      !< normalized z moment at actuator force nodes [Nm/kg/m^3]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: forceNodesChord => NULL()      !< chord distribution at the actuator force nodes [m]
  END TYPE OpFM_InputType
! =======================
! =========  OpFM_OutputType_C  =======
  TYPE, BIND(C) :: OpFM_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: u = C_NULL_PTR 
    INTEGER(C_int) :: u_Len = 0 
    TYPE(C_ptr) :: v = C_NULL_PTR 
    INTEGER(C_int) :: v_Len = 0 
    TYPE(C_ptr) :: w = C_NULL_PTR 
    INTEGER(C_int) :: w_Len = 0 
    TYPE(C_ptr) :: WriteOutput = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutput_Len = 0 
  END TYPE OpFM_OutputType_C
  TYPE, PUBLIC :: OpFM_OutputType
    TYPE( OpFM_OutputType_C ) :: C_obj
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: u => NULL()      !< U-component wind speed (in the X-direction) at interface nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: v => NULL()      !< V-component wind speed (in the Y-direction) at interface nodes [m/s]
    REAL(KIND=C_FLOAT) , DIMENSION(:), POINTER  :: w => NULL()      !< W-component wind speed (in the Z-direction) at interface nodes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE OpFM_OutputType
! =======================
CONTAINS
 SUBROUTINE OpFM_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(OpFM_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%NumActForcePtsBlade = SrcInitInputData%NumActForcePtsBlade
    DstInitInputData%C_obj%NumActForcePtsBlade = SrcInitInputData%C_obj%NumActForcePtsBlade
    DstInitInputData%NumActForcePtsTower = SrcInitInputData%NumActForcePtsTower
    DstInitInputData%C_obj%NumActForcePtsTower = SrcInitInputData%C_obj%NumActForcePtsTower
IF (ASSOCIATED(SrcInitInputData%StructBldRNodes)) THEN
  i1_l = LBOUND(SrcInitInputData%StructBldRNodes,1)
  i1_u = UBOUND(SrcInitInputData%StructBldRNodes,1)
  IF (.NOT. ASSOCIATED(DstInitInputData%StructBldRNodes)) THEN 
    ALLOCATE(DstInitInputData%StructBldRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%StructBldRNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInitInputData%c_obj%StructBldRNodes_Len = SIZE(DstInitInputData%StructBldRNodes)
    IF (DstInitInputData%c_obj%StructBldRNodes_Len > 0) &
      DstInitInputData%c_obj%StructBldRNodes = C_LOC( DstInitInputData%StructBldRNodes(i1_l) ) 
  END IF
    DstInitInputData%StructBldRNodes = SrcInitInputData%StructBldRNodes
ENDIF
IF (ASSOCIATED(SrcInitInputData%StructTwrHNodes)) THEN
  i1_l = LBOUND(SrcInitInputData%StructTwrHNodes,1)
  i1_u = UBOUND(SrcInitInputData%StructTwrHNodes,1)
  IF (.NOT. ASSOCIATED(DstInitInputData%StructTwrHNodes)) THEN 
    ALLOCATE(DstInitInputData%StructTwrHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%StructTwrHNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInitInputData%c_obj%StructTwrHNodes_Len = SIZE(DstInitInputData%StructTwrHNodes)
    IF (DstInitInputData%c_obj%StructTwrHNodes_Len > 0) &
      DstInitInputData%c_obj%StructTwrHNodes = C_LOC( DstInitInputData%StructTwrHNodes(i1_l) ) 
  END IF
    DstInitInputData%StructTwrHNodes = SrcInitInputData%StructTwrHNodes
ENDIF
    DstInitInputData%BladeLength = SrcInitInputData%BladeLength
    DstInitInputData%C_obj%BladeLength = SrcInitInputData%C_obj%BladeLength
    DstInitInputData%TowerHeight = SrcInitInputData%TowerHeight
    DstInitInputData%C_obj%TowerHeight = SrcInitInputData%C_obj%TowerHeight
    DstInitInputData%TowerBaseHeight = SrcInitInputData%TowerBaseHeight
    DstInitInputData%C_obj%TowerBaseHeight = SrcInitInputData%C_obj%TowerBaseHeight
 END SUBROUTINE OpFM_CopyInitInput

 SUBROUTINE OpFM_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(OpFM_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(InitInputData%StructBldRNodes)) THEN
  DEALLOCATE(InitInputData%StructBldRNodes)
  InitInputData%StructBldRNodes => NULL()
  InitInputData%C_obj%StructBldRNodes = C_NULL_PTR
  InitInputData%C_obj%StructBldRNodes_Len = 0
ENDIF
IF (ASSOCIATED(InitInputData%StructTwrHNodes)) THEN
  DEALLOCATE(InitInputData%StructTwrHNodes)
  InitInputData%StructTwrHNodes => NULL()
  InitInputData%C_obj%StructTwrHNodes = C_NULL_PTR
  InitInputData%C_obj%StructTwrHNodes_Len = 0
ENDIF
 END SUBROUTINE OpFM_DestroyInitInput

 SUBROUTINE OpFM_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NumActForcePtsBlade
      Int_BufSz  = Int_BufSz  + 1  ! NumActForcePtsTower
  Int_BufSz   = Int_BufSz   + 1     ! StructBldRNodes allocated yes/no
  IF ( ASSOCIATED(InData%StructBldRNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StructBldRNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StructBldRNodes)  ! StructBldRNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StructTwrHNodes allocated yes/no
  IF ( ASSOCIATED(InData%StructTwrHNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StructTwrHNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StructTwrHNodes)  ! StructTwrHNodes
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BladeLength
      Re_BufSz   = Re_BufSz   + 1  ! TowerHeight
      Re_BufSz   = Re_BufSz   + 1  ! TowerBaseHeight
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NumActForcePtsBlade
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumActForcePtsTower
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ASSOCIATED(InData%StructBldRNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StructBldRNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StructBldRNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StructBldRNodes,1), UBOUND(InData%StructBldRNodes,1)
        ReKiBuf(Re_Xferred) = InData%StructBldRNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%StructTwrHNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StructTwrHNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StructTwrHNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StructTwrHNodes,1), UBOUND(InData%StructTwrHNodes,1)
        ReKiBuf(Re_Xferred) = InData%StructTwrHNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BladeLength
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerHeight
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerBaseHeight
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE OpFM_PackInitInput

 SUBROUTINE OpFM_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NumActForcePtsBlade = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumActForcePtsBlade = OutData%NumActForcePtsBlade
    OutData%NumActForcePtsTower = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumActForcePtsTower = OutData%NumActForcePtsTower
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StructBldRNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%StructBldRNodes)) DEALLOCATE(OutData%StructBldRNodes)
    ALLOCATE(OutData%StructBldRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StructBldRNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%StructBldRNodes_Len = SIZE(OutData%StructBldRNodes)
    IF (OutData%c_obj%StructBldRNodes_Len > 0) &
       OutData%c_obj%StructBldRNodes = C_LOC( OutData%StructBldRNodes(i1_l) ) 
      DO i1 = LBOUND(OutData%StructBldRNodes,1), UBOUND(OutData%StructBldRNodes,1)
        OutData%StructBldRNodes(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StructTwrHNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%StructTwrHNodes)) DEALLOCATE(OutData%StructTwrHNodes)
    ALLOCATE(OutData%StructTwrHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StructTwrHNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%StructTwrHNodes_Len = SIZE(OutData%StructTwrHNodes)
    IF (OutData%c_obj%StructTwrHNodes_Len > 0) &
       OutData%c_obj%StructTwrHNodes = C_LOC( OutData%StructTwrHNodes(i1_l) ) 
      DO i1 = LBOUND(OutData%StructTwrHNodes,1), UBOUND(OutData%StructTwrHNodes,1)
        OutData%StructTwrHNodes(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%BladeLength = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%BladeLength = OutData%BladeLength
    OutData%TowerHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%TowerHeight = OutData%TowerHeight
    OutData%TowerBaseHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%TowerBaseHeight = OutData%TowerBaseHeight
 END SUBROUTINE OpFM_UnPackInitInput

 SUBROUTINE OpFM_C2Fary_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%NumActForcePtsBlade = InitInputData%C_obj%NumActForcePtsBlade
    InitInputData%NumActForcePtsTower = InitInputData%C_obj%NumActForcePtsTower

    ! -- StructBldRNodes InitInput Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InitInputData%C_obj%StructBldRNodes ) ) THEN
          NULLIFY( InitInputData%StructBldRNodes )
       ELSE
          CALL C_F_POINTER(InitInputData%C_obj%StructBldRNodes, InitInputData%StructBldRNodes, (/InitInputData%C_obj%StructBldRNodes_Len/))
       END IF
    END IF

    ! -- StructTwrHNodes InitInput Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InitInputData%C_obj%StructTwrHNodes ) ) THEN
          NULLIFY( InitInputData%StructTwrHNodes )
       ELSE
          CALL C_F_POINTER(InitInputData%C_obj%StructTwrHNodes, InitInputData%StructTwrHNodes, (/InitInputData%C_obj%StructTwrHNodes_Len/))
       END IF
    END IF
    InitInputData%BladeLength = InitInputData%C_obj%BladeLength
    InitInputData%TowerHeight = InitInputData%C_obj%TowerHeight
    InitInputData%TowerBaseHeight = InitInputData%C_obj%TowerBaseHeight
 END SUBROUTINE OpFM_C2Fary_CopyInitInput

 SUBROUTINE OpFM_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%C_obj%NumActForcePtsBlade = InitInputData%NumActForcePtsBlade
    InitInputData%C_obj%NumActForcePtsTower = InitInputData%NumActForcePtsTower

    ! -- StructBldRNodes InitInput Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InitInputData%StructBldRNodes)) THEN 
          InitInputData%c_obj%StructBldRNodes_Len = 0
          InitInputData%c_obj%StructBldRNodes = C_NULL_PTR
       ELSE
          InitInputData%c_obj%StructBldRNodes_Len = SIZE(InitInputData%StructBldRNodes)
          IF (InitInputData%c_obj%StructBldRNodes_Len > 0) &
             InitInputData%c_obj%StructBldRNodes = C_LOC( InitInputData%StructBldRNodes( LBOUND(InitInputData%StructBldRNodes,1) ) ) 
       END IF
    END IF

    ! -- StructTwrHNodes InitInput Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InitInputData%StructTwrHNodes)) THEN 
          InitInputData%c_obj%StructTwrHNodes_Len = 0
          InitInputData%c_obj%StructTwrHNodes = C_NULL_PTR
       ELSE
          InitInputData%c_obj%StructTwrHNodes_Len = SIZE(InitInputData%StructTwrHNodes)
          IF (InitInputData%c_obj%StructTwrHNodes_Len > 0) &
             InitInputData%c_obj%StructTwrHNodes = C_LOC( InitInputData%StructTwrHNodes( LBOUND(InitInputData%StructTwrHNodes,1) ) ) 
       END IF
    END IF
    InitInputData%C_obj%BladeLength = InitInputData%BladeLength
    InitInputData%C_obj%TowerHeight = InitInputData%TowerHeight
    InitInputData%C_obj%TowerBaseHeight = InitInputData%TowerBaseHeight
 END SUBROUTINE OpFM_F2C_CopyInitInput

 SUBROUTINE OpFM_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(OpFM_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE OpFM_CopyInitOutput

 SUBROUTINE OpFM_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(OpFM_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE OpFM_DestroyInitOutput

 SUBROUTINE OpFM_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE OpFM_PackInitOutput

 SUBROUTINE OpFM_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE OpFM_UnPackInitOutput

 SUBROUTINE OpFM_C2Fary_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE OpFM_C2Fary_CopyInitOutput

 SUBROUTINE OpFM_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE OpFM_F2C_CopyInitOutput

 SUBROUTINE OpFM_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_MiscVarType), INTENT(INOUT) :: SrcMiscData
   TYPE(OpFM_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%ActForceLoads)) THEN
  i1_l = LBOUND(SrcMiscData%ActForceLoads,1)
  i1_u = UBOUND(SrcMiscData%ActForceLoads,1)
  IF (.NOT. ALLOCATED(DstMiscData%ActForceLoads)) THEN 
    ALLOCATE(DstMiscData%ActForceLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceLoads.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%ActForceLoads,1), UBOUND(SrcMiscData%ActForceLoads,1)
      CALL MeshCopy( SrcMiscData%ActForceLoads(i1), DstMiscData%ActForceLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%ActForceMotions)) THEN
  i1_l = LBOUND(SrcMiscData%ActForceMotions,1)
  i1_u = UBOUND(SrcMiscData%ActForceMotions,1)
  IF (.NOT. ALLOCATED(DstMiscData%ActForceMotions)) THEN 
    ALLOCATE(DstMiscData%ActForceMotions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceMotions.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%ActForceMotions,1), UBOUND(SrcMiscData%ActForceMotions,1)
      CALL MeshCopy( SrcMiscData%ActForceMotions(i1), DstMiscData%ActForceMotions(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%ActForceMotionsPoints)) THEN
  i1_l = LBOUND(SrcMiscData%ActForceMotionsPoints,1)
  i1_u = UBOUND(SrcMiscData%ActForceMotionsPoints,1)
  IF (.NOT. ALLOCATED(DstMiscData%ActForceMotionsPoints)) THEN 
    ALLOCATE(DstMiscData%ActForceMotionsPoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceMotionsPoints.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%ActForceMotionsPoints,1), UBOUND(SrcMiscData%ActForceMotionsPoints,1)
      CALL MeshCopy( SrcMiscData%ActForceMotionsPoints(i1), DstMiscData%ActForceMotionsPoints(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%ActForceLoadsPoints)) THEN
  i1_l = LBOUND(SrcMiscData%ActForceLoadsPoints,1)
  i1_u = UBOUND(SrcMiscData%ActForceLoadsPoints,1)
  IF (.NOT. ALLOCATED(DstMiscData%ActForceLoadsPoints)) THEN 
    ALLOCATE(DstMiscData%ActForceLoadsPoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ActForceLoadsPoints.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%ActForceLoadsPoints,1), UBOUND(SrcMiscData%ActForceLoadsPoints,1)
      CALL MeshCopy( SrcMiscData%ActForceLoadsPoints(i1), DstMiscData%ActForceLoadsPoints(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%Line2_to_Line2_Loads)) THEN
  i1_l = LBOUND(SrcMiscData%Line2_to_Line2_Loads,1)
  i1_u = UBOUND(SrcMiscData%Line2_to_Line2_Loads,1)
  IF (.NOT. ALLOCATED(DstMiscData%Line2_to_Line2_Loads)) THEN 
    ALLOCATE(DstMiscData%Line2_to_Line2_Loads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Line2_Loads.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%Line2_to_Line2_Loads,1), UBOUND(SrcMiscData%Line2_to_Line2_Loads,1)
      CALL NWTC_Library_Copymeshmaptype( SrcMiscData%Line2_to_Line2_Loads(i1), DstMiscData%Line2_to_Line2_Loads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%Line2_to_Line2_Motions)) THEN
  i1_l = LBOUND(SrcMiscData%Line2_to_Line2_Motions,1)
  i1_u = UBOUND(SrcMiscData%Line2_to_Line2_Motions,1)
  IF (.NOT. ALLOCATED(DstMiscData%Line2_to_Line2_Motions)) THEN 
    ALLOCATE(DstMiscData%Line2_to_Line2_Motions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Line2_Motions.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%Line2_to_Line2_Motions,1), UBOUND(SrcMiscData%Line2_to_Line2_Motions,1)
      CALL NWTC_Library_Copymeshmaptype( SrcMiscData%Line2_to_Line2_Motions(i1), DstMiscData%Line2_to_Line2_Motions(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%Line2_to_Point_Loads)) THEN
  i1_l = LBOUND(SrcMiscData%Line2_to_Point_Loads,1)
  i1_u = UBOUND(SrcMiscData%Line2_to_Point_Loads,1)
  IF (.NOT. ALLOCATED(DstMiscData%Line2_to_Point_Loads)) THEN 
    ALLOCATE(DstMiscData%Line2_to_Point_Loads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Point_Loads.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%Line2_to_Point_Loads,1), UBOUND(SrcMiscData%Line2_to_Point_Loads,1)
      CALL NWTC_Library_Copymeshmaptype( SrcMiscData%Line2_to_Point_Loads(i1), DstMiscData%Line2_to_Point_Loads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%Line2_to_Point_Motions)) THEN
  i1_l = LBOUND(SrcMiscData%Line2_to_Point_Motions,1)
  i1_u = UBOUND(SrcMiscData%Line2_to_Point_Motions,1)
  IF (.NOT. ALLOCATED(DstMiscData%Line2_to_Point_Motions)) THEN 
    ALLOCATE(DstMiscData%Line2_to_Point_Motions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line2_to_Point_Motions.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%Line2_to_Point_Motions,1), UBOUND(SrcMiscData%Line2_to_Point_Motions,1)
      CALL NWTC_Library_Copymeshmaptype( SrcMiscData%Line2_to_Point_Motions(i1), DstMiscData%Line2_to_Point_Motions(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE OpFM_CopyMisc

 SUBROUTINE OpFM_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(OpFM_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%ActForceLoads)) THEN
DO i1 = LBOUND(MiscData%ActForceLoads,1), UBOUND(MiscData%ActForceLoads,1)
  CALL MeshDestroy( MiscData%ActForceLoads(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%ActForceLoads)
ENDIF
IF (ALLOCATED(MiscData%ActForceMotions)) THEN
DO i1 = LBOUND(MiscData%ActForceMotions,1), UBOUND(MiscData%ActForceMotions,1)
  CALL MeshDestroy( MiscData%ActForceMotions(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%ActForceMotions)
ENDIF
IF (ALLOCATED(MiscData%ActForceMotionsPoints)) THEN
DO i1 = LBOUND(MiscData%ActForceMotionsPoints,1), UBOUND(MiscData%ActForceMotionsPoints,1)
  CALL MeshDestroy( MiscData%ActForceMotionsPoints(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%ActForceMotionsPoints)
ENDIF
IF (ALLOCATED(MiscData%ActForceLoadsPoints)) THEN
DO i1 = LBOUND(MiscData%ActForceLoadsPoints,1), UBOUND(MiscData%ActForceLoadsPoints,1)
  CALL MeshDestroy( MiscData%ActForceLoadsPoints(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%ActForceLoadsPoints)
ENDIF
IF (ALLOCATED(MiscData%Line2_to_Line2_Loads)) THEN
DO i1 = LBOUND(MiscData%Line2_to_Line2_Loads,1), UBOUND(MiscData%Line2_to_Line2_Loads,1)
  CALL NWTC_Library_Destroymeshmaptype( MiscData%Line2_to_Line2_Loads(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%Line2_to_Line2_Loads)
ENDIF
IF (ALLOCATED(MiscData%Line2_to_Line2_Motions)) THEN
DO i1 = LBOUND(MiscData%Line2_to_Line2_Motions,1), UBOUND(MiscData%Line2_to_Line2_Motions,1)
  CALL NWTC_Library_Destroymeshmaptype( MiscData%Line2_to_Line2_Motions(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%Line2_to_Line2_Motions)
ENDIF
IF (ALLOCATED(MiscData%Line2_to_Point_Loads)) THEN
DO i1 = LBOUND(MiscData%Line2_to_Point_Loads,1), UBOUND(MiscData%Line2_to_Point_Loads,1)
  CALL NWTC_Library_Destroymeshmaptype( MiscData%Line2_to_Point_Loads(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%Line2_to_Point_Loads)
ENDIF
IF (ALLOCATED(MiscData%Line2_to_Point_Motions)) THEN
DO i1 = LBOUND(MiscData%Line2_to_Point_Motions,1), UBOUND(MiscData%Line2_to_Point_Motions,1)
  CALL NWTC_Library_Destroymeshmaptype( MiscData%Line2_to_Point_Motions(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%Line2_to_Point_Motions)
ENDIF
 END SUBROUTINE OpFM_DestroyMisc

 SUBROUTINE OpFM_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! ActForceLoads allocated yes/no
  IF ( ALLOCATED(InData%ActForceLoads) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ActForceLoads upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%ActForceLoads,1), UBOUND(InData%ActForceLoads,1)
      Int_BufSz   = Int_BufSz + 3  ! ActForceLoads: size of buffers for each call to pack subtype
      CALL MeshPack( InData%ActForceLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! ActForceLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! ActForceLoads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! ActForceLoads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! ActForceLoads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ActForceMotions allocated yes/no
  IF ( ALLOCATED(InData%ActForceMotions) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ActForceMotions upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%ActForceMotions,1), UBOUND(InData%ActForceMotions,1)
      Int_BufSz   = Int_BufSz + 3  ! ActForceMotions: size of buffers for each call to pack subtype
      CALL MeshPack( InData%ActForceMotions(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! ActForceMotions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! ActForceMotions
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! ActForceMotions
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! ActForceMotions
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ActForceMotionsPoints allocated yes/no
  IF ( ALLOCATED(InData%ActForceMotionsPoints) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ActForceMotionsPoints upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%ActForceMotionsPoints,1), UBOUND(InData%ActForceMotionsPoints,1)
      Int_BufSz   = Int_BufSz + 3  ! ActForceMotionsPoints: size of buffers for each call to pack subtype
      CALL MeshPack( InData%ActForceMotionsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! ActForceMotionsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! ActForceMotionsPoints
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! ActForceMotionsPoints
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! ActForceMotionsPoints
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ActForceLoadsPoints allocated yes/no
  IF ( ALLOCATED(InData%ActForceLoadsPoints) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ActForceLoadsPoints upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%ActForceLoadsPoints,1), UBOUND(InData%ActForceLoadsPoints,1)
      Int_BufSz   = Int_BufSz + 3  ! ActForceLoadsPoints: size of buffers for each call to pack subtype
      CALL MeshPack( InData%ActForceLoadsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! ActForceLoadsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! ActForceLoadsPoints
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! ActForceLoadsPoints
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! ActForceLoadsPoints
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line2_to_Line2_Loads allocated yes/no
  IF ( ALLOCATED(InData%Line2_to_Line2_Loads) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Line2_to_Line2_Loads upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%Line2_to_Line2_Loads,1), UBOUND(InData%Line2_to_Line2_Loads,1)
      Int_BufSz   = Int_BufSz + 3  ! Line2_to_Line2_Loads: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Line2_Loads(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Line2_to_Line2_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Line2_to_Line2_Loads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Line2_to_Line2_Loads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Line2_to_Line2_Loads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line2_to_Line2_Motions allocated yes/no
  IF ( ALLOCATED(InData%Line2_to_Line2_Motions) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Line2_to_Line2_Motions upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%Line2_to_Line2_Motions,1), UBOUND(InData%Line2_to_Line2_Motions,1)
      Int_BufSz   = Int_BufSz + 3  ! Line2_to_Line2_Motions: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Line2_Motions(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Line2_to_Line2_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Line2_to_Line2_Motions
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Line2_to_Line2_Motions
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Line2_to_Line2_Motions
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line2_to_Point_Loads allocated yes/no
  IF ( ALLOCATED(InData%Line2_to_Point_Loads) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Line2_to_Point_Loads upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%Line2_to_Point_Loads,1), UBOUND(InData%Line2_to_Point_Loads,1)
      Int_BufSz   = Int_BufSz + 3  ! Line2_to_Point_Loads: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Point_Loads(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Line2_to_Point_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Line2_to_Point_Loads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Line2_to_Point_Loads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Line2_to_Point_Loads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line2_to_Point_Motions allocated yes/no
  IF ( ALLOCATED(InData%Line2_to_Point_Motions) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Line2_to_Point_Motions upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%Line2_to_Point_Motions,1), UBOUND(InData%Line2_to_Point_Motions,1)
      Int_BufSz   = Int_BufSz + 3  ! Line2_to_Point_Motions: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Point_Motions(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Line2_to_Point_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Line2_to_Point_Motions
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Line2_to_Point_Motions
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Line2_to_Point_Motions
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%ActForceLoads) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ActForceLoads,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ActForceLoads,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%ActForceLoads,1), UBOUND(InData%ActForceLoads,1)
      CALL MeshPack( InData%ActForceLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! ActForceLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ActForceMotions) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ActForceMotions,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ActForceMotions,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%ActForceMotions,1), UBOUND(InData%ActForceMotions,1)
      CALL MeshPack( InData%ActForceMotions(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! ActForceMotions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ActForceMotionsPoints) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ActForceMotionsPoints,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ActForceMotionsPoints,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%ActForceMotionsPoints,1), UBOUND(InData%ActForceMotionsPoints,1)
      CALL MeshPack( InData%ActForceMotionsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! ActForceMotionsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ActForceLoadsPoints) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ActForceLoadsPoints,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ActForceLoadsPoints,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%ActForceLoadsPoints,1), UBOUND(InData%ActForceLoadsPoints,1)
      CALL MeshPack( InData%ActForceLoadsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! ActForceLoadsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line2_to_Line2_Loads) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line2_to_Line2_Loads,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line2_to_Line2_Loads,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Line2_to_Line2_Loads,1), UBOUND(InData%Line2_to_Line2_Loads,1)
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Line2_Loads(i1), ErrStat2, ErrMsg2, OnlySize ) ! Line2_to_Line2_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line2_to_Line2_Motions) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line2_to_Line2_Motions,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line2_to_Line2_Motions,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Line2_to_Line2_Motions,1), UBOUND(InData%Line2_to_Line2_Motions,1)
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Line2_Motions(i1), ErrStat2, ErrMsg2, OnlySize ) ! Line2_to_Line2_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line2_to_Point_Loads) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line2_to_Point_Loads,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line2_to_Point_Loads,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Line2_to_Point_Loads,1), UBOUND(InData%Line2_to_Point_Loads,1)
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Point_Loads(i1), ErrStat2, ErrMsg2, OnlySize ) ! Line2_to_Point_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line2_to_Point_Motions) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line2_to_Point_Motions,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line2_to_Point_Motions,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Line2_to_Point_Motions,1), UBOUND(InData%Line2_to_Point_Motions,1)
      CALL NWTC_Library_Packmeshmaptype( Re_Buf, Db_Buf, Int_Buf, InData%Line2_to_Point_Motions(i1), ErrStat2, ErrMsg2, OnlySize ) ! Line2_to_Point_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE OpFM_PackMisc

 SUBROUTINE OpFM_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ActForceLoads not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ActForceLoads)) DEALLOCATE(OutData%ActForceLoads)
    ALLOCATE(OutData%ActForceLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceLoads.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%ActForceLoads,1), UBOUND(OutData%ActForceLoads,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%ActForceLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! ActForceLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ActForceMotions not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ActForceMotions)) DEALLOCATE(OutData%ActForceMotions)
    ALLOCATE(OutData%ActForceMotions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceMotions.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%ActForceMotions,1), UBOUND(OutData%ActForceMotions,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%ActForceMotions(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! ActForceMotions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ActForceMotionsPoints not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ActForceMotionsPoints)) DEALLOCATE(OutData%ActForceMotionsPoints)
    ALLOCATE(OutData%ActForceMotionsPoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceMotionsPoints.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%ActForceMotionsPoints,1), UBOUND(OutData%ActForceMotionsPoints,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%ActForceMotionsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! ActForceMotionsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ActForceLoadsPoints not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ActForceLoadsPoints)) DEALLOCATE(OutData%ActForceLoadsPoints)
    ALLOCATE(OutData%ActForceLoadsPoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ActForceLoadsPoints.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%ActForceLoadsPoints,1), UBOUND(OutData%ActForceLoadsPoints,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%ActForceLoadsPoints(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! ActForceLoadsPoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line2_to_Line2_Loads not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line2_to_Line2_Loads)) DEALLOCATE(OutData%Line2_to_Line2_Loads)
    ALLOCATE(OutData%Line2_to_Line2_Loads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Line2_Loads.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Line2_to_Line2_Loads,1), UBOUND(OutData%Line2_to_Line2_Loads,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackmeshmaptype( Re_Buf, Db_Buf, Int_Buf, OutData%Line2_to_Line2_Loads(i1), ErrStat2, ErrMsg2 ) ! Line2_to_Line2_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line2_to_Line2_Motions not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line2_to_Line2_Motions)) DEALLOCATE(OutData%Line2_to_Line2_Motions)
    ALLOCATE(OutData%Line2_to_Line2_Motions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Line2_Motions.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Line2_to_Line2_Motions,1), UBOUND(OutData%Line2_to_Line2_Motions,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackmeshmaptype( Re_Buf, Db_Buf, Int_Buf, OutData%Line2_to_Line2_Motions(i1), ErrStat2, ErrMsg2 ) ! Line2_to_Line2_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line2_to_Point_Loads not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line2_to_Point_Loads)) DEALLOCATE(OutData%Line2_to_Point_Loads)
    ALLOCATE(OutData%Line2_to_Point_Loads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Point_Loads.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Line2_to_Point_Loads,1), UBOUND(OutData%Line2_to_Point_Loads,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackmeshmaptype( Re_Buf, Db_Buf, Int_Buf, OutData%Line2_to_Point_Loads(i1), ErrStat2, ErrMsg2 ) ! Line2_to_Point_Loads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line2_to_Point_Motions not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line2_to_Point_Motions)) DEALLOCATE(OutData%Line2_to_Point_Motions)
    ALLOCATE(OutData%Line2_to_Point_Motions(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line2_to_Point_Motions.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Line2_to_Point_Motions,1), UBOUND(OutData%Line2_to_Point_Motions,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackmeshmaptype( Re_Buf, Db_Buf, Int_Buf, OutData%Line2_to_Point_Motions(i1), ErrStat2, ErrMsg2 ) ! Line2_to_Point_Motions 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE OpFM_UnPackMisc

 SUBROUTINE OpFM_C2Fary_CopyMisc( MiscData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_MiscVarType), INTENT(INOUT) :: MiscData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE OpFM_C2Fary_CopyMisc

 SUBROUTINE OpFM_F2C_CopyMisc( MiscData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_MiscVarType), INTENT(INOUT) :: MiscData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
 END SUBROUTINE OpFM_F2C_CopyMisc

 SUBROUTINE OpFM_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(OpFM_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%AirDens = SrcParamData%AirDens
    DstParamData%C_obj%AirDens = SrcParamData%C_obj%AirDens
    DstParamData%NumBl = SrcParamData%NumBl
    DstParamData%C_obj%NumBl = SrcParamData%C_obj%NumBl
    DstParamData%NMappings = SrcParamData%NMappings
    DstParamData%C_obj%NMappings = SrcParamData%C_obj%NMappings
    DstParamData%NnodesVel = SrcParamData%NnodesVel
    DstParamData%C_obj%NnodesVel = SrcParamData%C_obj%NnodesVel
    DstParamData%NnodesForce = SrcParamData%NnodesForce
    DstParamData%C_obj%NnodesForce = SrcParamData%C_obj%NnodesForce
    DstParamData%NnodesForceBlade = SrcParamData%NnodesForceBlade
    DstParamData%C_obj%NnodesForceBlade = SrcParamData%C_obj%NnodesForceBlade
    DstParamData%NnodesForceTower = SrcParamData%NnodesForceTower
    DstParamData%C_obj%NnodesForceTower = SrcParamData%C_obj%NnodesForceTower
IF (ASSOCIATED(SrcParamData%forceBldRnodes)) THEN
  i1_l = LBOUND(SrcParamData%forceBldRnodes,1)
  i1_u = UBOUND(SrcParamData%forceBldRnodes,1)
  IF (.NOT. ASSOCIATED(DstParamData%forceBldRnodes)) THEN 
    ALLOCATE(DstParamData%forceBldRnodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%forceBldRnodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstParamData%c_obj%forceBldRnodes_Len = SIZE(DstParamData%forceBldRnodes)
    IF (DstParamData%c_obj%forceBldRnodes_Len > 0) &
      DstParamData%c_obj%forceBldRnodes = C_LOC( DstParamData%forceBldRnodes(i1_l) ) 
  END IF
    DstParamData%forceBldRnodes = SrcParamData%forceBldRnodes
ENDIF
IF (ASSOCIATED(SrcParamData%forceTwrHnodes)) THEN
  i1_l = LBOUND(SrcParamData%forceTwrHnodes,1)
  i1_u = UBOUND(SrcParamData%forceTwrHnodes,1)
  IF (.NOT. ASSOCIATED(DstParamData%forceTwrHnodes)) THEN 
    ALLOCATE(DstParamData%forceTwrHnodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%forceTwrHnodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstParamData%c_obj%forceTwrHnodes_Len = SIZE(DstParamData%forceTwrHnodes)
    IF (DstParamData%c_obj%forceTwrHnodes_Len > 0) &
      DstParamData%c_obj%forceTwrHnodes = C_LOC( DstParamData%forceTwrHnodes(i1_l) ) 
  END IF
    DstParamData%forceTwrHnodes = SrcParamData%forceTwrHnodes
ENDIF
    DstParamData%BladeLength = SrcParamData%BladeLength
    DstParamData%C_obj%BladeLength = SrcParamData%C_obj%BladeLength
    DstParamData%TowerHeight = SrcParamData%TowerHeight
    DstParamData%C_obj%TowerHeight = SrcParamData%C_obj%TowerHeight
    DstParamData%TowerBaseHeight = SrcParamData%TowerBaseHeight
    DstParamData%C_obj%TowerBaseHeight = SrcParamData%C_obj%TowerBaseHeight
 END SUBROUTINE OpFM_CopyParam

 SUBROUTINE OpFM_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(OpFM_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(ParamData%forceBldRnodes)) THEN
  DEALLOCATE(ParamData%forceBldRnodes)
  ParamData%forceBldRnodes => NULL()
  ParamData%C_obj%forceBldRnodes = C_NULL_PTR
  ParamData%C_obj%forceBldRnodes_Len = 0
ENDIF
IF (ASSOCIATED(ParamData%forceTwrHnodes)) THEN
  DEALLOCATE(ParamData%forceTwrHnodes)
  ParamData%forceTwrHnodes => NULL()
  ParamData%C_obj%forceTwrHnodes = C_NULL_PTR
  ParamData%C_obj%forceTwrHnodes_Len = 0
ENDIF
 END SUBROUTINE OpFM_DestroyParam

 SUBROUTINE OpFM_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! AirDens
      Int_BufSz  = Int_BufSz  + 1  ! NumBl
      Int_BufSz  = Int_BufSz  + 1  ! NMappings
      Int_BufSz  = Int_BufSz  + 1  ! NnodesVel
      Int_BufSz  = Int_BufSz  + 1  ! NnodesForce
      Int_BufSz  = Int_BufSz  + 1  ! NnodesForceBlade
      Int_BufSz  = Int_BufSz  + 1  ! NnodesForceTower
  Int_BufSz   = Int_BufSz   + 1     ! forceBldRnodes allocated yes/no
  IF ( ASSOCIATED(InData%forceBldRnodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! forceBldRnodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%forceBldRnodes)  ! forceBldRnodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! forceTwrHnodes allocated yes/no
  IF ( ASSOCIATED(InData%forceTwrHnodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! forceTwrHnodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%forceTwrHnodes)  ! forceTwrHnodes
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BladeLength
      Re_BufSz   = Re_BufSz   + 1  ! TowerHeight
      Re_BufSz   = Re_BufSz   + 1  ! TowerBaseHeight
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%AirDens
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBl
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NMappings
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NnodesVel
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NnodesForce
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NnodesForceBlade
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NnodesForceTower
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ASSOCIATED(InData%forceBldRnodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%forceBldRnodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%forceBldRnodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%forceBldRnodes,1), UBOUND(InData%forceBldRnodes,1)
        ReKiBuf(Re_Xferred) = InData%forceBldRnodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%forceTwrHnodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%forceTwrHnodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%forceTwrHnodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%forceTwrHnodes,1), UBOUND(InData%forceTwrHnodes,1)
        ReKiBuf(Re_Xferred) = InData%forceTwrHnodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BladeLength
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerHeight
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerBaseHeight
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE OpFM_PackParam

 SUBROUTINE OpFM_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%AirDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%AirDens = OutData%AirDens
    OutData%NumBl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NumBl = OutData%NumBl
    OutData%NMappings = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NMappings = OutData%NMappings
    OutData%NnodesVel = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NnodesVel = OutData%NnodesVel
    OutData%NnodesForce = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NnodesForce = OutData%NnodesForce
    OutData%NnodesForceBlade = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NnodesForceBlade = OutData%NnodesForceBlade
    OutData%NnodesForceTower = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%NnodesForceTower = OutData%NnodesForceTower
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! forceBldRnodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%forceBldRnodes)) DEALLOCATE(OutData%forceBldRnodes)
    ALLOCATE(OutData%forceBldRnodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%forceBldRnodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%forceBldRnodes_Len = SIZE(OutData%forceBldRnodes)
    IF (OutData%c_obj%forceBldRnodes_Len > 0) &
       OutData%c_obj%forceBldRnodes = C_LOC( OutData%forceBldRnodes(i1_l) ) 
      DO i1 = LBOUND(OutData%forceBldRnodes,1), UBOUND(OutData%forceBldRnodes,1)
        OutData%forceBldRnodes(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! forceTwrHnodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%forceTwrHnodes)) DEALLOCATE(OutData%forceTwrHnodes)
    ALLOCATE(OutData%forceTwrHnodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%forceTwrHnodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%forceTwrHnodes_Len = SIZE(OutData%forceTwrHnodes)
    IF (OutData%c_obj%forceTwrHnodes_Len > 0) &
       OutData%c_obj%forceTwrHnodes = C_LOC( OutData%forceTwrHnodes(i1_l) ) 
      DO i1 = LBOUND(OutData%forceTwrHnodes,1), UBOUND(OutData%forceTwrHnodes,1)
        OutData%forceTwrHnodes(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%BladeLength = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%BladeLength = OutData%BladeLength
    OutData%TowerHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%TowerHeight = OutData%TowerHeight
    OutData%TowerBaseHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
      OutData%C_obj%TowerBaseHeight = OutData%TowerBaseHeight
 END SUBROUTINE OpFM_UnPackParam

 SUBROUTINE OpFM_C2Fary_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%AirDens = ParamData%C_obj%AirDens
    ParamData%NumBl = ParamData%C_obj%NumBl
    ParamData%NMappings = ParamData%C_obj%NMappings
    ParamData%NnodesVel = ParamData%C_obj%NnodesVel
    ParamData%NnodesForce = ParamData%C_obj%NnodesForce
    ParamData%NnodesForceBlade = ParamData%C_obj%NnodesForceBlade
    ParamData%NnodesForceTower = ParamData%C_obj%NnodesForceTower

    ! -- forceBldRnodes Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%forceBldRnodes ) ) THEN
          NULLIFY( ParamData%forceBldRnodes )
       ELSE
          CALL C_F_POINTER(ParamData%C_obj%forceBldRnodes, ParamData%forceBldRnodes, (/ParamData%C_obj%forceBldRnodes_Len/))
       END IF
    END IF

    ! -- forceTwrHnodes Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ParamData%C_obj%forceTwrHnodes ) ) THEN
          NULLIFY( ParamData%forceTwrHnodes )
       ELSE
          CALL C_F_POINTER(ParamData%C_obj%forceTwrHnodes, ParamData%forceTwrHnodes, (/ParamData%C_obj%forceTwrHnodes_Len/))
       END IF
    END IF
    ParamData%BladeLength = ParamData%C_obj%BladeLength
    ParamData%TowerHeight = ParamData%C_obj%TowerHeight
    ParamData%TowerBaseHeight = ParamData%C_obj%TowerBaseHeight
 END SUBROUTINE OpFM_C2Fary_CopyParam

 SUBROUTINE OpFM_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%C_obj%AirDens = ParamData%AirDens
    ParamData%C_obj%NumBl = ParamData%NumBl
    ParamData%C_obj%NMappings = ParamData%NMappings
    ParamData%C_obj%NnodesVel = ParamData%NnodesVel
    ParamData%C_obj%NnodesForce = ParamData%NnodesForce
    ParamData%C_obj%NnodesForceBlade = ParamData%NnodesForceBlade
    ParamData%C_obj%NnodesForceTower = ParamData%NnodesForceTower

    ! -- forceBldRnodes Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ParamData%forceBldRnodes)) THEN 
          ParamData%c_obj%forceBldRnodes_Len = 0
          ParamData%c_obj%forceBldRnodes = C_NULL_PTR
       ELSE
          ParamData%c_obj%forceBldRnodes_Len = SIZE(ParamData%forceBldRnodes)
          IF (ParamData%c_obj%forceBldRnodes_Len > 0) &
             ParamData%c_obj%forceBldRnodes = C_LOC( ParamData%forceBldRnodes( LBOUND(ParamData%forceBldRnodes,1) ) ) 
       END IF
    END IF

    ! -- forceTwrHnodes Param Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ParamData%forceTwrHnodes)) THEN 
          ParamData%c_obj%forceTwrHnodes_Len = 0
          ParamData%c_obj%forceTwrHnodes = C_NULL_PTR
       ELSE
          ParamData%c_obj%forceTwrHnodes_Len = SIZE(ParamData%forceTwrHnodes)
          IF (ParamData%c_obj%forceTwrHnodes_Len > 0) &
             ParamData%c_obj%forceTwrHnodes = C_LOC( ParamData%forceTwrHnodes( LBOUND(ParamData%forceTwrHnodes,1) ) ) 
       END IF
    END IF
    ParamData%C_obj%BladeLength = ParamData%BladeLength
    ParamData%C_obj%TowerHeight = ParamData%TowerHeight
    ParamData%C_obj%TowerBaseHeight = ParamData%TowerBaseHeight
 END SUBROUTINE OpFM_F2C_CopyParam

 SUBROUTINE OpFM_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_InputType), INTENT(IN) :: SrcInputData
   TYPE(OpFM_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcInputData%pxVel)) THEN
  i1_l = LBOUND(SrcInputData%pxVel,1)
  i1_u = UBOUND(SrcInputData%pxVel,1)
  IF (.NOT. ASSOCIATED(DstInputData%pxVel)) THEN 
    ALLOCATE(DstInputData%pxVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pxVel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pxVel_Len = SIZE(DstInputData%pxVel)
    IF (DstInputData%c_obj%pxVel_Len > 0) &
      DstInputData%c_obj%pxVel = C_LOC( DstInputData%pxVel(i1_l) ) 
  END IF
    DstInputData%pxVel = SrcInputData%pxVel
ENDIF
IF (ASSOCIATED(SrcInputData%pyVel)) THEN
  i1_l = LBOUND(SrcInputData%pyVel,1)
  i1_u = UBOUND(SrcInputData%pyVel,1)
  IF (.NOT. ASSOCIATED(DstInputData%pyVel)) THEN 
    ALLOCATE(DstInputData%pyVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pyVel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pyVel_Len = SIZE(DstInputData%pyVel)
    IF (DstInputData%c_obj%pyVel_Len > 0) &
      DstInputData%c_obj%pyVel = C_LOC( DstInputData%pyVel(i1_l) ) 
  END IF
    DstInputData%pyVel = SrcInputData%pyVel
ENDIF
IF (ASSOCIATED(SrcInputData%pzVel)) THEN
  i1_l = LBOUND(SrcInputData%pzVel,1)
  i1_u = UBOUND(SrcInputData%pzVel,1)
  IF (.NOT. ASSOCIATED(DstInputData%pzVel)) THEN 
    ALLOCATE(DstInputData%pzVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pzVel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pzVel_Len = SIZE(DstInputData%pzVel)
    IF (DstInputData%c_obj%pzVel_Len > 0) &
      DstInputData%c_obj%pzVel = C_LOC( DstInputData%pzVel(i1_l) ) 
  END IF
    DstInputData%pzVel = SrcInputData%pzVel
ENDIF
IF (ASSOCIATED(SrcInputData%pxForce)) THEN
  i1_l = LBOUND(SrcInputData%pxForce,1)
  i1_u = UBOUND(SrcInputData%pxForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%pxForce)) THEN 
    ALLOCATE(DstInputData%pxForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pxForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pxForce_Len = SIZE(DstInputData%pxForce)
    IF (DstInputData%c_obj%pxForce_Len > 0) &
      DstInputData%c_obj%pxForce = C_LOC( DstInputData%pxForce(i1_l) ) 
  END IF
    DstInputData%pxForce = SrcInputData%pxForce
ENDIF
IF (ASSOCIATED(SrcInputData%pyForce)) THEN
  i1_l = LBOUND(SrcInputData%pyForce,1)
  i1_u = UBOUND(SrcInputData%pyForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%pyForce)) THEN 
    ALLOCATE(DstInputData%pyForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pyForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pyForce_Len = SIZE(DstInputData%pyForce)
    IF (DstInputData%c_obj%pyForce_Len > 0) &
      DstInputData%c_obj%pyForce = C_LOC( DstInputData%pyForce(i1_l) ) 
  END IF
    DstInputData%pyForce = SrcInputData%pyForce
ENDIF
IF (ASSOCIATED(SrcInputData%pzForce)) THEN
  i1_l = LBOUND(SrcInputData%pzForce,1)
  i1_u = UBOUND(SrcInputData%pzForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%pzForce)) THEN 
    ALLOCATE(DstInputData%pzForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pzForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pzForce_Len = SIZE(DstInputData%pzForce)
    IF (DstInputData%c_obj%pzForce_Len > 0) &
      DstInputData%c_obj%pzForce = C_LOC( DstInputData%pzForce(i1_l) ) 
  END IF
    DstInputData%pzForce = SrcInputData%pzForce
ENDIF
IF (ASSOCIATED(SrcInputData%xdotForce)) THEN
  i1_l = LBOUND(SrcInputData%xdotForce,1)
  i1_u = UBOUND(SrcInputData%xdotForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%xdotForce)) THEN 
    ALLOCATE(DstInputData%xdotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%xdotForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%xdotForce_Len = SIZE(DstInputData%xdotForce)
    IF (DstInputData%c_obj%xdotForce_Len > 0) &
      DstInputData%c_obj%xdotForce = C_LOC( DstInputData%xdotForce(i1_l) ) 
  END IF
    DstInputData%xdotForce = SrcInputData%xdotForce
ENDIF
IF (ASSOCIATED(SrcInputData%ydotForce)) THEN
  i1_l = LBOUND(SrcInputData%ydotForce,1)
  i1_u = UBOUND(SrcInputData%ydotForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%ydotForce)) THEN 
    ALLOCATE(DstInputData%ydotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%ydotForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%ydotForce_Len = SIZE(DstInputData%ydotForce)
    IF (DstInputData%c_obj%ydotForce_Len > 0) &
      DstInputData%c_obj%ydotForce = C_LOC( DstInputData%ydotForce(i1_l) ) 
  END IF
    DstInputData%ydotForce = SrcInputData%ydotForce
ENDIF
IF (ASSOCIATED(SrcInputData%zdotForce)) THEN
  i1_l = LBOUND(SrcInputData%zdotForce,1)
  i1_u = UBOUND(SrcInputData%zdotForce,1)
  IF (.NOT. ASSOCIATED(DstInputData%zdotForce)) THEN 
    ALLOCATE(DstInputData%zdotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%zdotForce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%zdotForce_Len = SIZE(DstInputData%zdotForce)
    IF (DstInputData%c_obj%zdotForce_Len > 0) &
      DstInputData%c_obj%zdotForce = C_LOC( DstInputData%zdotForce(i1_l) ) 
  END IF
    DstInputData%zdotForce = SrcInputData%zdotForce
ENDIF
IF (ASSOCIATED(SrcInputData%pOrientation)) THEN
  i1_l = LBOUND(SrcInputData%pOrientation,1)
  i1_u = UBOUND(SrcInputData%pOrientation,1)
  IF (.NOT. ASSOCIATED(DstInputData%pOrientation)) THEN 
    ALLOCATE(DstInputData%pOrientation(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%pOrientation.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%pOrientation_Len = SIZE(DstInputData%pOrientation)
    IF (DstInputData%c_obj%pOrientation_Len > 0) &
      DstInputData%c_obj%pOrientation = C_LOC( DstInputData%pOrientation(i1_l) ) 
  END IF
    DstInputData%pOrientation = SrcInputData%pOrientation
ENDIF
IF (ASSOCIATED(SrcInputData%fx)) THEN
  i1_l = LBOUND(SrcInputData%fx,1)
  i1_u = UBOUND(SrcInputData%fx,1)
  IF (.NOT. ASSOCIATED(DstInputData%fx)) THEN 
    ALLOCATE(DstInputData%fx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%fx_Len = SIZE(DstInputData%fx)
    IF (DstInputData%c_obj%fx_Len > 0) &
      DstInputData%c_obj%fx = C_LOC( DstInputData%fx(i1_l) ) 
  END IF
    DstInputData%fx = SrcInputData%fx
ENDIF
IF (ASSOCIATED(SrcInputData%fy)) THEN
  i1_l = LBOUND(SrcInputData%fy,1)
  i1_u = UBOUND(SrcInputData%fy,1)
  IF (.NOT. ASSOCIATED(DstInputData%fy)) THEN 
    ALLOCATE(DstInputData%fy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fy.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%fy_Len = SIZE(DstInputData%fy)
    IF (DstInputData%c_obj%fy_Len > 0) &
      DstInputData%c_obj%fy = C_LOC( DstInputData%fy(i1_l) ) 
  END IF
    DstInputData%fy = SrcInputData%fy
ENDIF
IF (ASSOCIATED(SrcInputData%fz)) THEN
  i1_l = LBOUND(SrcInputData%fz,1)
  i1_u = UBOUND(SrcInputData%fz,1)
  IF (.NOT. ASSOCIATED(DstInputData%fz)) THEN 
    ALLOCATE(DstInputData%fz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%fz.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%fz_Len = SIZE(DstInputData%fz)
    IF (DstInputData%c_obj%fz_Len > 0) &
      DstInputData%c_obj%fz = C_LOC( DstInputData%fz(i1_l) ) 
  END IF
    DstInputData%fz = SrcInputData%fz
ENDIF
IF (ASSOCIATED(SrcInputData%momentx)) THEN
  i1_l = LBOUND(SrcInputData%momentx,1)
  i1_u = UBOUND(SrcInputData%momentx,1)
  IF (.NOT. ASSOCIATED(DstInputData%momentx)) THEN 
    ALLOCATE(DstInputData%momentx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momentx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%momentx_Len = SIZE(DstInputData%momentx)
    IF (DstInputData%c_obj%momentx_Len > 0) &
      DstInputData%c_obj%momentx = C_LOC( DstInputData%momentx(i1_l) ) 
  END IF
    DstInputData%momentx = SrcInputData%momentx
ENDIF
IF (ASSOCIATED(SrcInputData%momenty)) THEN
  i1_l = LBOUND(SrcInputData%momenty,1)
  i1_u = UBOUND(SrcInputData%momenty,1)
  IF (.NOT. ASSOCIATED(DstInputData%momenty)) THEN 
    ALLOCATE(DstInputData%momenty(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momenty.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%momenty_Len = SIZE(DstInputData%momenty)
    IF (DstInputData%c_obj%momenty_Len > 0) &
      DstInputData%c_obj%momenty = C_LOC( DstInputData%momenty(i1_l) ) 
  END IF
    DstInputData%momenty = SrcInputData%momenty
ENDIF
IF (ASSOCIATED(SrcInputData%momentz)) THEN
  i1_l = LBOUND(SrcInputData%momentz,1)
  i1_u = UBOUND(SrcInputData%momentz,1)
  IF (.NOT. ASSOCIATED(DstInputData%momentz)) THEN 
    ALLOCATE(DstInputData%momentz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%momentz.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%momentz_Len = SIZE(DstInputData%momentz)
    IF (DstInputData%c_obj%momentz_Len > 0) &
      DstInputData%c_obj%momentz = C_LOC( DstInputData%momentz(i1_l) ) 
  END IF
    DstInputData%momentz = SrcInputData%momentz
ENDIF
IF (ASSOCIATED(SrcInputData%forceNodesChord)) THEN
  i1_l = LBOUND(SrcInputData%forceNodesChord,1)
  i1_u = UBOUND(SrcInputData%forceNodesChord,1)
  IF (.NOT. ASSOCIATED(DstInputData%forceNodesChord)) THEN 
    ALLOCATE(DstInputData%forceNodesChord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%forceNodesChord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%forceNodesChord_Len = SIZE(DstInputData%forceNodesChord)
    IF (DstInputData%c_obj%forceNodesChord_Len > 0) &
      DstInputData%c_obj%forceNodesChord = C_LOC( DstInputData%forceNodesChord(i1_l) ) 
  END IF
    DstInputData%forceNodesChord = SrcInputData%forceNodesChord
ENDIF
 END SUBROUTINE OpFM_CopyInput

 SUBROUTINE OpFM_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(OpFM_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(InputData%pxVel)) THEN
  DEALLOCATE(InputData%pxVel)
  InputData%pxVel => NULL()
  InputData%C_obj%pxVel = C_NULL_PTR
  InputData%C_obj%pxVel_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pyVel)) THEN
  DEALLOCATE(InputData%pyVel)
  InputData%pyVel => NULL()
  InputData%C_obj%pyVel = C_NULL_PTR
  InputData%C_obj%pyVel_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pzVel)) THEN
  DEALLOCATE(InputData%pzVel)
  InputData%pzVel => NULL()
  InputData%C_obj%pzVel = C_NULL_PTR
  InputData%C_obj%pzVel_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pxForce)) THEN
  DEALLOCATE(InputData%pxForce)
  InputData%pxForce => NULL()
  InputData%C_obj%pxForce = C_NULL_PTR
  InputData%C_obj%pxForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pyForce)) THEN
  DEALLOCATE(InputData%pyForce)
  InputData%pyForce => NULL()
  InputData%C_obj%pyForce = C_NULL_PTR
  InputData%C_obj%pyForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pzForce)) THEN
  DEALLOCATE(InputData%pzForce)
  InputData%pzForce => NULL()
  InputData%C_obj%pzForce = C_NULL_PTR
  InputData%C_obj%pzForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%xdotForce)) THEN
  DEALLOCATE(InputData%xdotForce)
  InputData%xdotForce => NULL()
  InputData%C_obj%xdotForce = C_NULL_PTR
  InputData%C_obj%xdotForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%ydotForce)) THEN
  DEALLOCATE(InputData%ydotForce)
  InputData%ydotForce => NULL()
  InputData%C_obj%ydotForce = C_NULL_PTR
  InputData%C_obj%ydotForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%zdotForce)) THEN
  DEALLOCATE(InputData%zdotForce)
  InputData%zdotForce => NULL()
  InputData%C_obj%zdotForce = C_NULL_PTR
  InputData%C_obj%zdotForce_Len = 0
ENDIF
IF (ASSOCIATED(InputData%pOrientation)) THEN
  DEALLOCATE(InputData%pOrientation)
  InputData%pOrientation => NULL()
  InputData%C_obj%pOrientation = C_NULL_PTR
  InputData%C_obj%pOrientation_Len = 0
ENDIF
IF (ASSOCIATED(InputData%fx)) THEN
  DEALLOCATE(InputData%fx)
  InputData%fx => NULL()
  InputData%C_obj%fx = C_NULL_PTR
  InputData%C_obj%fx_Len = 0
ENDIF
IF (ASSOCIATED(InputData%fy)) THEN
  DEALLOCATE(InputData%fy)
  InputData%fy => NULL()
  InputData%C_obj%fy = C_NULL_PTR
  InputData%C_obj%fy_Len = 0
ENDIF
IF (ASSOCIATED(InputData%fz)) THEN
  DEALLOCATE(InputData%fz)
  InputData%fz => NULL()
  InputData%C_obj%fz = C_NULL_PTR
  InputData%C_obj%fz_Len = 0
ENDIF
IF (ASSOCIATED(InputData%momentx)) THEN
  DEALLOCATE(InputData%momentx)
  InputData%momentx => NULL()
  InputData%C_obj%momentx = C_NULL_PTR
  InputData%C_obj%momentx_Len = 0
ENDIF
IF (ASSOCIATED(InputData%momenty)) THEN
  DEALLOCATE(InputData%momenty)
  InputData%momenty => NULL()
  InputData%C_obj%momenty = C_NULL_PTR
  InputData%C_obj%momenty_Len = 0
ENDIF
IF (ASSOCIATED(InputData%momentz)) THEN
  DEALLOCATE(InputData%momentz)
  InputData%momentz => NULL()
  InputData%C_obj%momentz = C_NULL_PTR
  InputData%C_obj%momentz_Len = 0
ENDIF
IF (ASSOCIATED(InputData%forceNodesChord)) THEN
  DEALLOCATE(InputData%forceNodesChord)
  InputData%forceNodesChord => NULL()
  InputData%C_obj%forceNodesChord = C_NULL_PTR
  InputData%C_obj%forceNodesChord_Len = 0
ENDIF
 END SUBROUTINE OpFM_DestroyInput

 SUBROUTINE OpFM_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! pxVel allocated yes/no
  IF ( ASSOCIATED(InData%pxVel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pxVel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pxVel)  ! pxVel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pyVel allocated yes/no
  IF ( ASSOCIATED(InData%pyVel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pyVel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pyVel)  ! pyVel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pzVel allocated yes/no
  IF ( ASSOCIATED(InData%pzVel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pzVel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pzVel)  ! pzVel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pxForce allocated yes/no
  IF ( ASSOCIATED(InData%pxForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pxForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pxForce)  ! pxForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pyForce allocated yes/no
  IF ( ASSOCIATED(InData%pyForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pyForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pyForce)  ! pyForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pzForce allocated yes/no
  IF ( ASSOCIATED(InData%pzForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pzForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pzForce)  ! pzForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! xdotForce allocated yes/no
  IF ( ASSOCIATED(InData%xdotForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! xdotForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%xdotForce)  ! xdotForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ydotForce allocated yes/no
  IF ( ASSOCIATED(InData%ydotForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ydotForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ydotForce)  ! ydotForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! zdotForce allocated yes/no
  IF ( ASSOCIATED(InData%zdotForce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! zdotForce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%zdotForce)  ! zdotForce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pOrientation allocated yes/no
  IF ( ASSOCIATED(InData%pOrientation) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! pOrientation upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pOrientation)  ! pOrientation
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fx allocated yes/no
  IF ( ASSOCIATED(InData%fx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fx)  ! fx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fy allocated yes/no
  IF ( ASSOCIATED(InData%fy) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fy upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fy)  ! fy
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fz allocated yes/no
  IF ( ASSOCIATED(InData%fz) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! fz upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fz)  ! fz
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! momentx allocated yes/no
  IF ( ASSOCIATED(InData%momentx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! momentx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%momentx)  ! momentx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! momenty allocated yes/no
  IF ( ASSOCIATED(InData%momenty) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! momenty upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%momenty)  ! momenty
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! momentz allocated yes/no
  IF ( ASSOCIATED(InData%momentz) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! momentz upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%momentz)  ! momentz
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! forceNodesChord allocated yes/no
  IF ( ASSOCIATED(InData%forceNodesChord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! forceNodesChord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%forceNodesChord)  ! forceNodesChord
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%pxVel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pxVel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pxVel,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pxVel,1), UBOUND(InData%pxVel,1)
        ReKiBuf(Re_Xferred) = InData%pxVel(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pyVel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pyVel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pyVel,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pyVel,1), UBOUND(InData%pyVel,1)
        ReKiBuf(Re_Xferred) = InData%pyVel(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pzVel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pzVel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pzVel,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pzVel,1), UBOUND(InData%pzVel,1)
        ReKiBuf(Re_Xferred) = InData%pzVel(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pxForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pxForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pxForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pxForce,1), UBOUND(InData%pxForce,1)
        ReKiBuf(Re_Xferred) = InData%pxForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pyForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pyForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pyForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pyForce,1), UBOUND(InData%pyForce,1)
        ReKiBuf(Re_Xferred) = InData%pyForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pzForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pzForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pzForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pzForce,1), UBOUND(InData%pzForce,1)
        ReKiBuf(Re_Xferred) = InData%pzForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%xdotForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xdotForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xdotForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%xdotForce,1), UBOUND(InData%xdotForce,1)
        ReKiBuf(Re_Xferred) = InData%xdotForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%ydotForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ydotForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ydotForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ydotForce,1), UBOUND(InData%ydotForce,1)
        ReKiBuf(Re_Xferred) = InData%ydotForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%zdotForce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zdotForce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zdotForce,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%zdotForce,1), UBOUND(InData%zdotForce,1)
        ReKiBuf(Re_Xferred) = InData%zdotForce(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%pOrientation) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pOrientation,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pOrientation,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%pOrientation,1), UBOUND(InData%pOrientation,1)
        ReKiBuf(Re_Xferred) = InData%pOrientation(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%fx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fx,1), UBOUND(InData%fx,1)
        ReKiBuf(Re_Xferred) = InData%fx(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%fy) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fy,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fy,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fy,1), UBOUND(InData%fy,1)
        ReKiBuf(Re_Xferred) = InData%fy(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%fz) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fz,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fz,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%fz,1), UBOUND(InData%fz,1)
        ReKiBuf(Re_Xferred) = InData%fz(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%momentx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%momentx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%momentx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%momentx,1), UBOUND(InData%momentx,1)
        ReKiBuf(Re_Xferred) = InData%momentx(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%momenty) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%momenty,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%momenty,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%momenty,1), UBOUND(InData%momenty,1)
        ReKiBuf(Re_Xferred) = InData%momenty(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%momentz) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%momentz,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%momentz,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%momentz,1), UBOUND(InData%momentz,1)
        ReKiBuf(Re_Xferred) = InData%momentz(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%forceNodesChord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%forceNodesChord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%forceNodesChord,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%forceNodesChord,1), UBOUND(InData%forceNodesChord,1)
        ReKiBuf(Re_Xferred) = InData%forceNodesChord(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE OpFM_PackInput

 SUBROUTINE OpFM_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pxVel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pxVel)) DEALLOCATE(OutData%pxVel)
    ALLOCATE(OutData%pxVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pxVel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pxVel_Len = SIZE(OutData%pxVel)
    IF (OutData%c_obj%pxVel_Len > 0) &
       OutData%c_obj%pxVel = C_LOC( OutData%pxVel(i1_l) ) 
      DO i1 = LBOUND(OutData%pxVel,1), UBOUND(OutData%pxVel,1)
        OutData%pxVel(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pyVel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pyVel)) DEALLOCATE(OutData%pyVel)
    ALLOCATE(OutData%pyVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pyVel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pyVel_Len = SIZE(OutData%pyVel)
    IF (OutData%c_obj%pyVel_Len > 0) &
       OutData%c_obj%pyVel = C_LOC( OutData%pyVel(i1_l) ) 
      DO i1 = LBOUND(OutData%pyVel,1), UBOUND(OutData%pyVel,1)
        OutData%pyVel(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pzVel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pzVel)) DEALLOCATE(OutData%pzVel)
    ALLOCATE(OutData%pzVel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pzVel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pzVel_Len = SIZE(OutData%pzVel)
    IF (OutData%c_obj%pzVel_Len > 0) &
       OutData%c_obj%pzVel = C_LOC( OutData%pzVel(i1_l) ) 
      DO i1 = LBOUND(OutData%pzVel,1), UBOUND(OutData%pzVel,1)
        OutData%pzVel(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pxForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pxForce)) DEALLOCATE(OutData%pxForce)
    ALLOCATE(OutData%pxForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pxForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pxForce_Len = SIZE(OutData%pxForce)
    IF (OutData%c_obj%pxForce_Len > 0) &
       OutData%c_obj%pxForce = C_LOC( OutData%pxForce(i1_l) ) 
      DO i1 = LBOUND(OutData%pxForce,1), UBOUND(OutData%pxForce,1)
        OutData%pxForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pyForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pyForce)) DEALLOCATE(OutData%pyForce)
    ALLOCATE(OutData%pyForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pyForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pyForce_Len = SIZE(OutData%pyForce)
    IF (OutData%c_obj%pyForce_Len > 0) &
       OutData%c_obj%pyForce = C_LOC( OutData%pyForce(i1_l) ) 
      DO i1 = LBOUND(OutData%pyForce,1), UBOUND(OutData%pyForce,1)
        OutData%pyForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pzForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pzForce)) DEALLOCATE(OutData%pzForce)
    ALLOCATE(OutData%pzForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pzForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pzForce_Len = SIZE(OutData%pzForce)
    IF (OutData%c_obj%pzForce_Len > 0) &
       OutData%c_obj%pzForce = C_LOC( OutData%pzForce(i1_l) ) 
      DO i1 = LBOUND(OutData%pzForce,1), UBOUND(OutData%pzForce,1)
        OutData%pzForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xdotForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%xdotForce)) DEALLOCATE(OutData%xdotForce)
    ALLOCATE(OutData%xdotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdotForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%xdotForce_Len = SIZE(OutData%xdotForce)
    IF (OutData%c_obj%xdotForce_Len > 0) &
       OutData%c_obj%xdotForce = C_LOC( OutData%xdotForce(i1_l) ) 
      DO i1 = LBOUND(OutData%xdotForce,1), UBOUND(OutData%xdotForce,1)
        OutData%xdotForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ydotForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%ydotForce)) DEALLOCATE(OutData%ydotForce)
    ALLOCATE(OutData%ydotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ydotForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%ydotForce_Len = SIZE(OutData%ydotForce)
    IF (OutData%c_obj%ydotForce_Len > 0) &
       OutData%c_obj%ydotForce = C_LOC( OutData%ydotForce(i1_l) ) 
      DO i1 = LBOUND(OutData%ydotForce,1), UBOUND(OutData%ydotForce,1)
        OutData%ydotForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! zdotForce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%zdotForce)) DEALLOCATE(OutData%zdotForce)
    ALLOCATE(OutData%zdotForce(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%zdotForce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%zdotForce_Len = SIZE(OutData%zdotForce)
    IF (OutData%c_obj%zdotForce_Len > 0) &
       OutData%c_obj%zdotForce = C_LOC( OutData%zdotForce(i1_l) ) 
      DO i1 = LBOUND(OutData%zdotForce,1), UBOUND(OutData%zdotForce,1)
        OutData%zdotForce(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pOrientation not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%pOrientation)) DEALLOCATE(OutData%pOrientation)
    ALLOCATE(OutData%pOrientation(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pOrientation.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%pOrientation_Len = SIZE(OutData%pOrientation)
    IF (OutData%c_obj%pOrientation_Len > 0) &
       OutData%c_obj%pOrientation = C_LOC( OutData%pOrientation(i1_l) ) 
      DO i1 = LBOUND(OutData%pOrientation,1), UBOUND(OutData%pOrientation,1)
        OutData%pOrientation(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fx)) DEALLOCATE(OutData%fx)
    ALLOCATE(OutData%fx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fx_Len = SIZE(OutData%fx)
    IF (OutData%c_obj%fx_Len > 0) &
       OutData%c_obj%fx = C_LOC( OutData%fx(i1_l) ) 
      DO i1 = LBOUND(OutData%fx,1), UBOUND(OutData%fx,1)
        OutData%fx(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fy not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fy)) DEALLOCATE(OutData%fy)
    ALLOCATE(OutData%fy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fy.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fy_Len = SIZE(OutData%fy)
    IF (OutData%c_obj%fy_Len > 0) &
       OutData%c_obj%fy = C_LOC( OutData%fy(i1_l) ) 
      DO i1 = LBOUND(OutData%fy,1), UBOUND(OutData%fy,1)
        OutData%fy(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fz not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%fz)) DEALLOCATE(OutData%fz)
    ALLOCATE(OutData%fz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fz.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%fz_Len = SIZE(OutData%fz)
    IF (OutData%c_obj%fz_Len > 0) &
       OutData%c_obj%fz = C_LOC( OutData%fz(i1_l) ) 
      DO i1 = LBOUND(OutData%fz,1), UBOUND(OutData%fz,1)
        OutData%fz(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! momentx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%momentx)) DEALLOCATE(OutData%momentx)
    ALLOCATE(OutData%momentx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%momentx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%momentx_Len = SIZE(OutData%momentx)
    IF (OutData%c_obj%momentx_Len > 0) &
       OutData%c_obj%momentx = C_LOC( OutData%momentx(i1_l) ) 
      DO i1 = LBOUND(OutData%momentx,1), UBOUND(OutData%momentx,1)
        OutData%momentx(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! momenty not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%momenty)) DEALLOCATE(OutData%momenty)
    ALLOCATE(OutData%momenty(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%momenty.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%momenty_Len = SIZE(OutData%momenty)
    IF (OutData%c_obj%momenty_Len > 0) &
       OutData%c_obj%momenty = C_LOC( OutData%momenty(i1_l) ) 
      DO i1 = LBOUND(OutData%momenty,1), UBOUND(OutData%momenty,1)
        OutData%momenty(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! momentz not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%momentz)) DEALLOCATE(OutData%momentz)
    ALLOCATE(OutData%momentz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%momentz.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%momentz_Len = SIZE(OutData%momentz)
    IF (OutData%c_obj%momentz_Len > 0) &
       OutData%c_obj%momentz = C_LOC( OutData%momentz(i1_l) ) 
      DO i1 = LBOUND(OutData%momentz,1), UBOUND(OutData%momentz,1)
        OutData%momentz(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! forceNodesChord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%forceNodesChord)) DEALLOCATE(OutData%forceNodesChord)
    ALLOCATE(OutData%forceNodesChord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%forceNodesChord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%forceNodesChord_Len = SIZE(OutData%forceNodesChord)
    IF (OutData%c_obj%forceNodesChord_Len > 0) &
       OutData%c_obj%forceNodesChord = C_LOC( OutData%forceNodesChord(i1_l) ) 
      DO i1 = LBOUND(OutData%forceNodesChord,1), UBOUND(OutData%forceNodesChord,1)
        OutData%forceNodesChord(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE OpFM_UnPackInput

 SUBROUTINE OpFM_C2Fary_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- pxVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pxVel ) ) THEN
          NULLIFY( InputData%pxVel )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pxVel, InputData%pxVel, (/InputData%C_obj%pxVel_Len/))
       END IF
    END IF

    ! -- pyVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pyVel ) ) THEN
          NULLIFY( InputData%pyVel )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pyVel, InputData%pyVel, (/InputData%C_obj%pyVel_Len/))
       END IF
    END IF

    ! -- pzVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pzVel ) ) THEN
          NULLIFY( InputData%pzVel )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pzVel, InputData%pzVel, (/InputData%C_obj%pzVel_Len/))
       END IF
    END IF

    ! -- pxForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pxForce ) ) THEN
          NULLIFY( InputData%pxForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pxForce, InputData%pxForce, (/InputData%C_obj%pxForce_Len/))
       END IF
    END IF

    ! -- pyForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pyForce ) ) THEN
          NULLIFY( InputData%pyForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pyForce, InputData%pyForce, (/InputData%C_obj%pyForce_Len/))
       END IF
    END IF

    ! -- pzForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pzForce ) ) THEN
          NULLIFY( InputData%pzForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pzForce, InputData%pzForce, (/InputData%C_obj%pzForce_Len/))
       END IF
    END IF

    ! -- xdotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%xdotForce ) ) THEN
          NULLIFY( InputData%xdotForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%xdotForce, InputData%xdotForce, (/InputData%C_obj%xdotForce_Len/))
       END IF
    END IF

    ! -- ydotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%ydotForce ) ) THEN
          NULLIFY( InputData%ydotForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%ydotForce, InputData%ydotForce, (/InputData%C_obj%ydotForce_Len/))
       END IF
    END IF

    ! -- zdotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%zdotForce ) ) THEN
          NULLIFY( InputData%zdotForce )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%zdotForce, InputData%zdotForce, (/InputData%C_obj%zdotForce_Len/))
       END IF
    END IF

    ! -- pOrientation Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%pOrientation ) ) THEN
          NULLIFY( InputData%pOrientation )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%pOrientation, InputData%pOrientation, (/InputData%C_obj%pOrientation_Len/))
       END IF
    END IF

    ! -- fx Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fx ) ) THEN
          NULLIFY( InputData%fx )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%fx, InputData%fx, (/InputData%C_obj%fx_Len/))
       END IF
    END IF

    ! -- fy Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fy ) ) THEN
          NULLIFY( InputData%fy )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%fy, InputData%fy, (/InputData%C_obj%fy_Len/))
       END IF
    END IF

    ! -- fz Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%fz ) ) THEN
          NULLIFY( InputData%fz )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%fz, InputData%fz, (/InputData%C_obj%fz_Len/))
       END IF
    END IF

    ! -- momentx Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momentx ) ) THEN
          NULLIFY( InputData%momentx )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%momentx, InputData%momentx, (/InputData%C_obj%momentx_Len/))
       END IF
    END IF

    ! -- momenty Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momenty ) ) THEN
          NULLIFY( InputData%momenty )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%momenty, InputData%momenty, (/InputData%C_obj%momenty_Len/))
       END IF
    END IF

    ! -- momentz Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%momentz ) ) THEN
          NULLIFY( InputData%momentz )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%momentz, InputData%momentz, (/InputData%C_obj%momentz_Len/))
       END IF
    END IF

    ! -- forceNodesChord Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%forceNodesChord ) ) THEN
          NULLIFY( InputData%forceNodesChord )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%forceNodesChord, InputData%forceNodesChord, (/InputData%C_obj%forceNodesChord_Len/))
       END IF
    END IF
 END SUBROUTINE OpFM_C2Fary_CopyInput

 SUBROUTINE OpFM_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- pxVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pxVel)) THEN 
          InputData%c_obj%pxVel_Len = 0
          InputData%c_obj%pxVel = C_NULL_PTR
       ELSE
          InputData%c_obj%pxVel_Len = SIZE(InputData%pxVel)
          IF (InputData%c_obj%pxVel_Len > 0) &
             InputData%c_obj%pxVel = C_LOC( InputData%pxVel( LBOUND(InputData%pxVel,1) ) ) 
       END IF
    END IF

    ! -- pyVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pyVel)) THEN 
          InputData%c_obj%pyVel_Len = 0
          InputData%c_obj%pyVel = C_NULL_PTR
       ELSE
          InputData%c_obj%pyVel_Len = SIZE(InputData%pyVel)
          IF (InputData%c_obj%pyVel_Len > 0) &
             InputData%c_obj%pyVel = C_LOC( InputData%pyVel( LBOUND(InputData%pyVel,1) ) ) 
       END IF
    END IF

    ! -- pzVel Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pzVel)) THEN 
          InputData%c_obj%pzVel_Len = 0
          InputData%c_obj%pzVel = C_NULL_PTR
       ELSE
          InputData%c_obj%pzVel_Len = SIZE(InputData%pzVel)
          IF (InputData%c_obj%pzVel_Len > 0) &
             InputData%c_obj%pzVel = C_LOC( InputData%pzVel( LBOUND(InputData%pzVel,1) ) ) 
       END IF
    END IF

    ! -- pxForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pxForce)) THEN 
          InputData%c_obj%pxForce_Len = 0
          InputData%c_obj%pxForce = C_NULL_PTR
       ELSE
          InputData%c_obj%pxForce_Len = SIZE(InputData%pxForce)
          IF (InputData%c_obj%pxForce_Len > 0) &
             InputData%c_obj%pxForce = C_LOC( InputData%pxForce( LBOUND(InputData%pxForce,1) ) ) 
       END IF
    END IF

    ! -- pyForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pyForce)) THEN 
          InputData%c_obj%pyForce_Len = 0
          InputData%c_obj%pyForce = C_NULL_PTR
       ELSE
          InputData%c_obj%pyForce_Len = SIZE(InputData%pyForce)
          IF (InputData%c_obj%pyForce_Len > 0) &
             InputData%c_obj%pyForce = C_LOC( InputData%pyForce( LBOUND(InputData%pyForce,1) ) ) 
       END IF
    END IF

    ! -- pzForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pzForce)) THEN 
          InputData%c_obj%pzForce_Len = 0
          InputData%c_obj%pzForce = C_NULL_PTR
       ELSE
          InputData%c_obj%pzForce_Len = SIZE(InputData%pzForce)
          IF (InputData%c_obj%pzForce_Len > 0) &
             InputData%c_obj%pzForce = C_LOC( InputData%pzForce( LBOUND(InputData%pzForce,1) ) ) 
       END IF
    END IF

    ! -- xdotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%xdotForce)) THEN 
          InputData%c_obj%xdotForce_Len = 0
          InputData%c_obj%xdotForce = C_NULL_PTR
       ELSE
          InputData%c_obj%xdotForce_Len = SIZE(InputData%xdotForce)
          IF (InputData%c_obj%xdotForce_Len > 0) &
             InputData%c_obj%xdotForce = C_LOC( InputData%xdotForce( LBOUND(InputData%xdotForce,1) ) ) 
       END IF
    END IF

    ! -- ydotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%ydotForce)) THEN 
          InputData%c_obj%ydotForce_Len = 0
          InputData%c_obj%ydotForce = C_NULL_PTR
       ELSE
          InputData%c_obj%ydotForce_Len = SIZE(InputData%ydotForce)
          IF (InputData%c_obj%ydotForce_Len > 0) &
             InputData%c_obj%ydotForce = C_LOC( InputData%ydotForce( LBOUND(InputData%ydotForce,1) ) ) 
       END IF
    END IF

    ! -- zdotForce Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%zdotForce)) THEN 
          InputData%c_obj%zdotForce_Len = 0
          InputData%c_obj%zdotForce = C_NULL_PTR
       ELSE
          InputData%c_obj%zdotForce_Len = SIZE(InputData%zdotForce)
          IF (InputData%c_obj%zdotForce_Len > 0) &
             InputData%c_obj%zdotForce = C_LOC( InputData%zdotForce( LBOUND(InputData%zdotForce,1) ) ) 
       END IF
    END IF

    ! -- pOrientation Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%pOrientation)) THEN 
          InputData%c_obj%pOrientation_Len = 0
          InputData%c_obj%pOrientation = C_NULL_PTR
       ELSE
          InputData%c_obj%pOrientation_Len = SIZE(InputData%pOrientation)
          IF (InputData%c_obj%pOrientation_Len > 0) &
             InputData%c_obj%pOrientation = C_LOC( InputData%pOrientation( LBOUND(InputData%pOrientation,1) ) ) 
       END IF
    END IF

    ! -- fx Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%fx)) THEN 
          InputData%c_obj%fx_Len = 0
          InputData%c_obj%fx = C_NULL_PTR
       ELSE
          InputData%c_obj%fx_Len = SIZE(InputData%fx)
          IF (InputData%c_obj%fx_Len > 0) &
             InputData%c_obj%fx = C_LOC( InputData%fx( LBOUND(InputData%fx,1) ) ) 
       END IF
    END IF

    ! -- fy Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%fy)) THEN 
          InputData%c_obj%fy_Len = 0
          InputData%c_obj%fy = C_NULL_PTR
       ELSE
          InputData%c_obj%fy_Len = SIZE(InputData%fy)
          IF (InputData%c_obj%fy_Len > 0) &
             InputData%c_obj%fy = C_LOC( InputData%fy( LBOUND(InputData%fy,1) ) ) 
       END IF
    END IF

    ! -- fz Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%fz)) THEN 
          InputData%c_obj%fz_Len = 0
          InputData%c_obj%fz = C_NULL_PTR
       ELSE
          InputData%c_obj%fz_Len = SIZE(InputData%fz)
          IF (InputData%c_obj%fz_Len > 0) &
             InputData%c_obj%fz = C_LOC( InputData%fz( LBOUND(InputData%fz,1) ) ) 
       END IF
    END IF

    ! -- momentx Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%momentx)) THEN 
          InputData%c_obj%momentx_Len = 0
          InputData%c_obj%momentx = C_NULL_PTR
       ELSE
          InputData%c_obj%momentx_Len = SIZE(InputData%momentx)
          IF (InputData%c_obj%momentx_Len > 0) &
             InputData%c_obj%momentx = C_LOC( InputData%momentx( LBOUND(InputData%momentx,1) ) ) 
       END IF
    END IF

    ! -- momenty Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%momenty)) THEN 
          InputData%c_obj%momenty_Len = 0
          InputData%c_obj%momenty = C_NULL_PTR
       ELSE
          InputData%c_obj%momenty_Len = SIZE(InputData%momenty)
          IF (InputData%c_obj%momenty_Len > 0) &
             InputData%c_obj%momenty = C_LOC( InputData%momenty( LBOUND(InputData%momenty,1) ) ) 
       END IF
    END IF

    ! -- momentz Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%momentz)) THEN 
          InputData%c_obj%momentz_Len = 0
          InputData%c_obj%momentz = C_NULL_PTR
       ELSE
          InputData%c_obj%momentz_Len = SIZE(InputData%momentz)
          IF (InputData%c_obj%momentz_Len > 0) &
             InputData%c_obj%momentz = C_LOC( InputData%momentz( LBOUND(InputData%momentz,1) ) ) 
       END IF
    END IF

    ! -- forceNodesChord Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%forceNodesChord)) THEN 
          InputData%c_obj%forceNodesChord_Len = 0
          InputData%c_obj%forceNodesChord = C_NULL_PTR
       ELSE
          InputData%c_obj%forceNodesChord_Len = SIZE(InputData%forceNodesChord)
          IF (InputData%c_obj%forceNodesChord_Len > 0) &
             InputData%c_obj%forceNodesChord = C_LOC( InputData%forceNodesChord( LBOUND(InputData%forceNodesChord,1) ) ) 
       END IF
    END IF
 END SUBROUTINE OpFM_F2C_CopyInput

 SUBROUTINE OpFM_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OpFM_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(OpFM_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcOutputData%u)) THEN
  i1_l = LBOUND(SrcOutputData%u,1)
  i1_u = UBOUND(SrcOutputData%u,1)
  IF (.NOT. ASSOCIATED(DstOutputData%u)) THEN 
    ALLOCATE(DstOutputData%u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%u_Len = SIZE(DstOutputData%u)
    IF (DstOutputData%c_obj%u_Len > 0) &
      DstOutputData%c_obj%u = C_LOC( DstOutputData%u(i1_l) ) 
  END IF
    DstOutputData%u = SrcOutputData%u
ENDIF
IF (ASSOCIATED(SrcOutputData%v)) THEN
  i1_l = LBOUND(SrcOutputData%v,1)
  i1_u = UBOUND(SrcOutputData%v,1)
  IF (.NOT. ASSOCIATED(DstOutputData%v)) THEN 
    ALLOCATE(DstOutputData%v(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%v.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%v_Len = SIZE(DstOutputData%v)
    IF (DstOutputData%c_obj%v_Len > 0) &
      DstOutputData%c_obj%v = C_LOC( DstOutputData%v(i1_l) ) 
  END IF
    DstOutputData%v = SrcOutputData%v
ENDIF
IF (ASSOCIATED(SrcOutputData%w)) THEN
  i1_l = LBOUND(SrcOutputData%w,1)
  i1_u = UBOUND(SrcOutputData%w,1)
  IF (.NOT. ASSOCIATED(DstOutputData%w)) THEN 
    ALLOCATE(DstOutputData%w(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%w.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%w_Len = SIZE(DstOutputData%w)
    IF (DstOutputData%c_obj%w_Len > 0) &
      DstOutputData%c_obj%w = C_LOC( DstOutputData%w(i1_l) ) 
  END IF
    DstOutputData%w = SrcOutputData%w
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
 END SUBROUTINE OpFM_CopyOutput

 SUBROUTINE OpFM_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(OpFM_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'OpFM_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(OutputData%u)) THEN
  DEALLOCATE(OutputData%u)
  OutputData%u => NULL()
  OutputData%C_obj%u = C_NULL_PTR
  OutputData%C_obj%u_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%v)) THEN
  DEALLOCATE(OutputData%v)
  OutputData%v => NULL()
  OutputData%C_obj%v = C_NULL_PTR
  OutputData%C_obj%v_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%w)) THEN
  DEALLOCATE(OutputData%w)
  OutputData%w => NULL()
  OutputData%C_obj%w = C_NULL_PTR
  OutputData%C_obj%w_Len = 0
ENDIF
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
 END SUBROUTINE OpFM_DestroyOutput

 SUBROUTINE OpFM_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OpFM_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! u allocated yes/no
  IF ( ASSOCIATED(InData%u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%u)  ! u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! v allocated yes/no
  IF ( ASSOCIATED(InData%v) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! v upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%v)  ! v
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! w allocated yes/no
  IF ( ASSOCIATED(InData%w) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! w upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%w)  ! w
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%u,1), UBOUND(InData%u,1)
        ReKiBuf(Re_Xferred) = InData%u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%v) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%v,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%v,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%v,1), UBOUND(InData%v,1)
        ReKiBuf(Re_Xferred) = InData%v(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%w) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%w,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%w,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%w,1), UBOUND(InData%w,1)
        ReKiBuf(Re_Xferred) = InData%w(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE OpFM_PackOutput

 SUBROUTINE OpFM_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OpFM_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'OpFM_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%u)) DEALLOCATE(OutData%u)
    ALLOCATE(OutData%u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%u_Len = SIZE(OutData%u)
    IF (OutData%c_obj%u_Len > 0) &
       OutData%c_obj%u = C_LOC( OutData%u(i1_l) ) 
      DO i1 = LBOUND(OutData%u,1), UBOUND(OutData%u,1)
        OutData%u(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! v not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%v)) DEALLOCATE(OutData%v)
    ALLOCATE(OutData%v(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%v.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%v_Len = SIZE(OutData%v)
    IF (OutData%c_obj%v_Len > 0) &
       OutData%c_obj%v = C_LOC( OutData%v(i1_l) ) 
      DO i1 = LBOUND(OutData%v,1), UBOUND(OutData%v,1)
        OutData%v(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! w not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%w)) DEALLOCATE(OutData%w)
    ALLOCATE(OutData%w(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%w.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%w_Len = SIZE(OutData%w)
    IF (OutData%c_obj%w_Len > 0) &
       OutData%c_obj%w = C_LOC( OutData%w(i1_l) ) 
      DO i1 = LBOUND(OutData%w,1), UBOUND(OutData%w,1)
        OutData%w(i1) = REAL(ReKiBuf(Re_Xferred), C_FLOAT)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE OpFM_UnPackOutput

 SUBROUTINE OpFM_C2Fary_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(OpFM_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- u Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%u ) ) THEN
          NULLIFY( OutputData%u )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%u, OutputData%u, (/OutputData%C_obj%u_Len/))
       END IF
    END IF

    ! -- v Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%v ) ) THEN
          NULLIFY( OutputData%v )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%v, OutputData%v, (/OutputData%C_obj%v_Len/))
       END IF
    END IF

    ! -- w Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%w ) ) THEN
          NULLIFY( OutputData%w )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%w, OutputData%w, (/OutputData%C_obj%w_Len/))
       END IF
    END IF
 END SUBROUTINE OpFM_C2Fary_CopyOutput

 SUBROUTINE OpFM_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(OpFM_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- u Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%u)) THEN 
          OutputData%c_obj%u_Len = 0
          OutputData%c_obj%u = C_NULL_PTR
       ELSE
          OutputData%c_obj%u_Len = SIZE(OutputData%u)
          IF (OutputData%c_obj%u_Len > 0) &
             OutputData%c_obj%u = C_LOC( OutputData%u( LBOUND(OutputData%u,1) ) ) 
       END IF
    END IF

    ! -- v Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%v)) THEN 
          OutputData%c_obj%v_Len = 0
          OutputData%c_obj%v = C_NULL_PTR
       ELSE
          OutputData%c_obj%v_Len = SIZE(OutputData%v)
          IF (OutputData%c_obj%v_Len > 0) &
             OutputData%c_obj%v = C_LOC( OutputData%v( LBOUND(OutputData%v,1) ) ) 
       END IF
    END IF

    ! -- w Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%w)) THEN 
          OutputData%c_obj%w_Len = 0
          OutputData%c_obj%w = C_NULL_PTR
       ELSE
          OutputData%c_obj%w_Len = SIZE(OutputData%w)
          IF (OutputData%c_obj%w_Len > 0) &
             OutputData%c_obj%w = C_LOC( OutputData%w( LBOUND(OutputData%w,1) ) ) 
       END IF
    END IF
 END SUBROUTINE OpFM_F2C_CopyOutput


 SUBROUTINE OpFM_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(OpFM_InputType), INTENT(IN)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(OpFM_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'OpFM_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL OpFM_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL OpFM_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL OpFM_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE OpFM_Input_ExtrapInterp


 SUBROUTINE OpFM_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(OpFM_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
 TYPE(OpFM_InputType), INTENT(IN)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(OpFM_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'OpFM_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(u_out%pxVel) .AND. ASSOCIATED(u1%pxVel)) THEN
  DO i1 = LBOUND(u_out%pxVel,1),UBOUND(u_out%pxVel,1)
    b = -(u1%pxVel(i1) - u2%pxVel(i1))
    u_out%pxVel(i1) = u1%pxVel(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pyVel) .AND. ASSOCIATED(u1%pyVel)) THEN
  DO i1 = LBOUND(u_out%pyVel,1),UBOUND(u_out%pyVel,1)
    b = -(u1%pyVel(i1) - u2%pyVel(i1))
    u_out%pyVel(i1) = u1%pyVel(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pzVel) .AND. ASSOCIATED(u1%pzVel)) THEN
  DO i1 = LBOUND(u_out%pzVel,1),UBOUND(u_out%pzVel,1)
    b = -(u1%pzVel(i1) - u2%pzVel(i1))
    u_out%pzVel(i1) = u1%pzVel(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pxForce) .AND. ASSOCIATED(u1%pxForce)) THEN
  DO i1 = LBOUND(u_out%pxForce,1),UBOUND(u_out%pxForce,1)
    b = -(u1%pxForce(i1) - u2%pxForce(i1))
    u_out%pxForce(i1) = u1%pxForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pyForce) .AND. ASSOCIATED(u1%pyForce)) THEN
  DO i1 = LBOUND(u_out%pyForce,1),UBOUND(u_out%pyForce,1)
    b = -(u1%pyForce(i1) - u2%pyForce(i1))
    u_out%pyForce(i1) = u1%pyForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pzForce) .AND. ASSOCIATED(u1%pzForce)) THEN
  DO i1 = LBOUND(u_out%pzForce,1),UBOUND(u_out%pzForce,1)
    b = -(u1%pzForce(i1) - u2%pzForce(i1))
    u_out%pzForce(i1) = u1%pzForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%xdotForce) .AND. ASSOCIATED(u1%xdotForce)) THEN
  DO i1 = LBOUND(u_out%xdotForce,1),UBOUND(u_out%xdotForce,1)
    b = -(u1%xdotForce(i1) - u2%xdotForce(i1))
    u_out%xdotForce(i1) = u1%xdotForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%ydotForce) .AND. ASSOCIATED(u1%ydotForce)) THEN
  DO i1 = LBOUND(u_out%ydotForce,1),UBOUND(u_out%ydotForce,1)
    b = -(u1%ydotForce(i1) - u2%ydotForce(i1))
    u_out%ydotForce(i1) = u1%ydotForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%zdotForce) .AND. ASSOCIATED(u1%zdotForce)) THEN
  DO i1 = LBOUND(u_out%zdotForce,1),UBOUND(u_out%zdotForce,1)
    b = -(u1%zdotForce(i1) - u2%zdotForce(i1))
    u_out%zdotForce(i1) = u1%zdotForce(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pOrientation) .AND. ASSOCIATED(u1%pOrientation)) THEN
  DO i1 = LBOUND(u_out%pOrientation,1),UBOUND(u_out%pOrientation,1)
    b = -(u1%pOrientation(i1) - u2%pOrientation(i1))
    u_out%pOrientation(i1) = u1%pOrientation(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fx) .AND. ASSOCIATED(u1%fx)) THEN
  DO i1 = LBOUND(u_out%fx,1),UBOUND(u_out%fx,1)
    b = -(u1%fx(i1) - u2%fx(i1))
    u_out%fx(i1) = u1%fx(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fy) .AND. ASSOCIATED(u1%fy)) THEN
  DO i1 = LBOUND(u_out%fy,1),UBOUND(u_out%fy,1)
    b = -(u1%fy(i1) - u2%fy(i1))
    u_out%fy(i1) = u1%fy(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fz) .AND. ASSOCIATED(u1%fz)) THEN
  DO i1 = LBOUND(u_out%fz,1),UBOUND(u_out%fz,1)
    b = -(u1%fz(i1) - u2%fz(i1))
    u_out%fz(i1) = u1%fz(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momentx) .AND. ASSOCIATED(u1%momentx)) THEN
  DO i1 = LBOUND(u_out%momentx,1),UBOUND(u_out%momentx,1)
    b = -(u1%momentx(i1) - u2%momentx(i1))
    u_out%momentx(i1) = u1%momentx(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momenty) .AND. ASSOCIATED(u1%momenty)) THEN
  DO i1 = LBOUND(u_out%momenty,1),UBOUND(u_out%momenty,1)
    b = -(u1%momenty(i1) - u2%momenty(i1))
    u_out%momenty(i1) = u1%momenty(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momentz) .AND. ASSOCIATED(u1%momentz)) THEN
  DO i1 = LBOUND(u_out%momentz,1),UBOUND(u_out%momentz,1)
    b = -(u1%momentz(i1) - u2%momentz(i1))
    u_out%momentz(i1) = u1%momentz(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%forceNodesChord) .AND. ASSOCIATED(u1%forceNodesChord)) THEN
  DO i1 = LBOUND(u_out%forceNodesChord,1),UBOUND(u_out%forceNodesChord,1)
    b = -(u1%forceNodesChord(i1) - u2%forceNodesChord(i1))
    u_out%forceNodesChord(i1) = u1%forceNodesChord(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE OpFM_Input_ExtrapInterp1


 SUBROUTINE OpFM_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(OpFM_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
 TYPE(OpFM_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
 TYPE(OpFM_InputType), INTENT(IN)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(OpFM_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'OpFM_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(u_out%pxVel) .AND. ASSOCIATED(u1%pxVel)) THEN
  DO i1 = LBOUND(u_out%pxVel,1),UBOUND(u_out%pxVel,1)
    b = (t(3)**2*(u1%pxVel(i1) - u2%pxVel(i1)) + t(2)**2*(-u1%pxVel(i1) + u3%pxVel(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pxVel(i1) + t(3)*u2%pxVel(i1) - t(2)*u3%pxVel(i1) ) * scaleFactor
    u_out%pxVel(i1) = u1%pxVel(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pyVel) .AND. ASSOCIATED(u1%pyVel)) THEN
  DO i1 = LBOUND(u_out%pyVel,1),UBOUND(u_out%pyVel,1)
    b = (t(3)**2*(u1%pyVel(i1) - u2%pyVel(i1)) + t(2)**2*(-u1%pyVel(i1) + u3%pyVel(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pyVel(i1) + t(3)*u2%pyVel(i1) - t(2)*u3%pyVel(i1) ) * scaleFactor
    u_out%pyVel(i1) = u1%pyVel(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pzVel) .AND. ASSOCIATED(u1%pzVel)) THEN
  DO i1 = LBOUND(u_out%pzVel,1),UBOUND(u_out%pzVel,1)
    b = (t(3)**2*(u1%pzVel(i1) - u2%pzVel(i1)) + t(2)**2*(-u1%pzVel(i1) + u3%pzVel(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pzVel(i1) + t(3)*u2%pzVel(i1) - t(2)*u3%pzVel(i1) ) * scaleFactor
    u_out%pzVel(i1) = u1%pzVel(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pxForce) .AND. ASSOCIATED(u1%pxForce)) THEN
  DO i1 = LBOUND(u_out%pxForce,1),UBOUND(u_out%pxForce,1)
    b = (t(3)**2*(u1%pxForce(i1) - u2%pxForce(i1)) + t(2)**2*(-u1%pxForce(i1) + u3%pxForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pxForce(i1) + t(3)*u2%pxForce(i1) - t(2)*u3%pxForce(i1) ) * scaleFactor
    u_out%pxForce(i1) = u1%pxForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pyForce) .AND. ASSOCIATED(u1%pyForce)) THEN
  DO i1 = LBOUND(u_out%pyForce,1),UBOUND(u_out%pyForce,1)
    b = (t(3)**2*(u1%pyForce(i1) - u2%pyForce(i1)) + t(2)**2*(-u1%pyForce(i1) + u3%pyForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pyForce(i1) + t(3)*u2%pyForce(i1) - t(2)*u3%pyForce(i1) ) * scaleFactor
    u_out%pyForce(i1) = u1%pyForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pzForce) .AND. ASSOCIATED(u1%pzForce)) THEN
  DO i1 = LBOUND(u_out%pzForce,1),UBOUND(u_out%pzForce,1)
    b = (t(3)**2*(u1%pzForce(i1) - u2%pzForce(i1)) + t(2)**2*(-u1%pzForce(i1) + u3%pzForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pzForce(i1) + t(3)*u2%pzForce(i1) - t(2)*u3%pzForce(i1) ) * scaleFactor
    u_out%pzForce(i1) = u1%pzForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%xdotForce) .AND. ASSOCIATED(u1%xdotForce)) THEN
  DO i1 = LBOUND(u_out%xdotForce,1),UBOUND(u_out%xdotForce,1)
    b = (t(3)**2*(u1%xdotForce(i1) - u2%xdotForce(i1)) + t(2)**2*(-u1%xdotForce(i1) + u3%xdotForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%xdotForce(i1) + t(3)*u2%xdotForce(i1) - t(2)*u3%xdotForce(i1) ) * scaleFactor
    u_out%xdotForce(i1) = u1%xdotForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%ydotForce) .AND. ASSOCIATED(u1%ydotForce)) THEN
  DO i1 = LBOUND(u_out%ydotForce,1),UBOUND(u_out%ydotForce,1)
    b = (t(3)**2*(u1%ydotForce(i1) - u2%ydotForce(i1)) + t(2)**2*(-u1%ydotForce(i1) + u3%ydotForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%ydotForce(i1) + t(3)*u2%ydotForce(i1) - t(2)*u3%ydotForce(i1) ) * scaleFactor
    u_out%ydotForce(i1) = u1%ydotForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%zdotForce) .AND. ASSOCIATED(u1%zdotForce)) THEN
  DO i1 = LBOUND(u_out%zdotForce,1),UBOUND(u_out%zdotForce,1)
    b = (t(3)**2*(u1%zdotForce(i1) - u2%zdotForce(i1)) + t(2)**2*(-u1%zdotForce(i1) + u3%zdotForce(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%zdotForce(i1) + t(3)*u2%zdotForce(i1) - t(2)*u3%zdotForce(i1) ) * scaleFactor
    u_out%zdotForce(i1) = u1%zdotForce(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%pOrientation) .AND. ASSOCIATED(u1%pOrientation)) THEN
  DO i1 = LBOUND(u_out%pOrientation,1),UBOUND(u_out%pOrientation,1)
    b = (t(3)**2*(u1%pOrientation(i1) - u2%pOrientation(i1)) + t(2)**2*(-u1%pOrientation(i1) + u3%pOrientation(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%pOrientation(i1) + t(3)*u2%pOrientation(i1) - t(2)*u3%pOrientation(i1) ) * scaleFactor
    u_out%pOrientation(i1) = u1%pOrientation(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fx) .AND. ASSOCIATED(u1%fx)) THEN
  DO i1 = LBOUND(u_out%fx,1),UBOUND(u_out%fx,1)
    b = (t(3)**2*(u1%fx(i1) - u2%fx(i1)) + t(2)**2*(-u1%fx(i1) + u3%fx(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%fx(i1) + t(3)*u2%fx(i1) - t(2)*u3%fx(i1) ) * scaleFactor
    u_out%fx(i1) = u1%fx(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fy) .AND. ASSOCIATED(u1%fy)) THEN
  DO i1 = LBOUND(u_out%fy,1),UBOUND(u_out%fy,1)
    b = (t(3)**2*(u1%fy(i1) - u2%fy(i1)) + t(2)**2*(-u1%fy(i1) + u3%fy(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%fy(i1) + t(3)*u2%fy(i1) - t(2)*u3%fy(i1) ) * scaleFactor
    u_out%fy(i1) = u1%fy(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%fz) .AND. ASSOCIATED(u1%fz)) THEN
  DO i1 = LBOUND(u_out%fz,1),UBOUND(u_out%fz,1)
    b = (t(3)**2*(u1%fz(i1) - u2%fz(i1)) + t(2)**2*(-u1%fz(i1) + u3%fz(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%fz(i1) + t(3)*u2%fz(i1) - t(2)*u3%fz(i1) ) * scaleFactor
    u_out%fz(i1) = u1%fz(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momentx) .AND. ASSOCIATED(u1%momentx)) THEN
  DO i1 = LBOUND(u_out%momentx,1),UBOUND(u_out%momentx,1)
    b = (t(3)**2*(u1%momentx(i1) - u2%momentx(i1)) + t(2)**2*(-u1%momentx(i1) + u3%momentx(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%momentx(i1) + t(3)*u2%momentx(i1) - t(2)*u3%momentx(i1) ) * scaleFactor
    u_out%momentx(i1) = u1%momentx(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momenty) .AND. ASSOCIATED(u1%momenty)) THEN
  DO i1 = LBOUND(u_out%momenty,1),UBOUND(u_out%momenty,1)
    b = (t(3)**2*(u1%momenty(i1) - u2%momenty(i1)) + t(2)**2*(-u1%momenty(i1) + u3%momenty(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%momenty(i1) + t(3)*u2%momenty(i1) - t(2)*u3%momenty(i1) ) * scaleFactor
    u_out%momenty(i1) = u1%momenty(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%momentz) .AND. ASSOCIATED(u1%momentz)) THEN
  DO i1 = LBOUND(u_out%momentz,1),UBOUND(u_out%momentz,1)
    b = (t(3)**2*(u1%momentz(i1) - u2%momentz(i1)) + t(2)**2*(-u1%momentz(i1) + u3%momentz(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%momentz(i1) + t(3)*u2%momentz(i1) - t(2)*u3%momentz(i1) ) * scaleFactor
    u_out%momentz(i1) = u1%momentz(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%forceNodesChord) .AND. ASSOCIATED(u1%forceNodesChord)) THEN
  DO i1 = LBOUND(u_out%forceNodesChord,1),UBOUND(u_out%forceNodesChord,1)
    b = (t(3)**2*(u1%forceNodesChord(i1) - u2%forceNodesChord(i1)) + t(2)**2*(-u1%forceNodesChord(i1) + u3%forceNodesChord(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%forceNodesChord(i1) + t(3)*u2%forceNodesChord(i1) - t(2)*u3%forceNodesChord(i1) ) * scaleFactor
    u_out%forceNodesChord(i1) = u1%forceNodesChord(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE OpFM_Input_ExtrapInterp2


 SUBROUTINE OpFM_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(OpFM_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(OpFM_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'OpFM_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL OpFM_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL OpFM_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL OpFM_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE OpFM_Output_ExtrapInterp


 SUBROUTINE OpFM_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(OpFM_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(OpFM_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(OpFM_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'OpFM_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(y_out%u) .AND. ASSOCIATED(y1%u)) THEN
  DO i1 = LBOUND(y_out%u,1),UBOUND(y_out%u,1)
    b = -(y1%u(i1) - y2%u(i1))
    y_out%u(i1) = y1%u(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%v) .AND. ASSOCIATED(y1%v)) THEN
  DO i1 = LBOUND(y_out%v,1),UBOUND(y_out%v,1)
    b = -(y1%v(i1) - y2%v(i1))
    y_out%v(i1) = y1%v(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%w) .AND. ASSOCIATED(y1%w)) THEN
  DO i1 = LBOUND(y_out%w,1),UBOUND(y_out%w,1)
    b = -(y1%w(i1) - y2%w(i1))
    y_out%w(i1) = y1%w(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE OpFM_Output_ExtrapInterp1


 SUBROUTINE OpFM_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(OpFM_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(OpFM_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(OpFM_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(OpFM_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'OpFM_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(y_out%u) .AND. ASSOCIATED(y1%u)) THEN
  DO i1 = LBOUND(y_out%u,1),UBOUND(y_out%u,1)
    b = (t(3)**2*(y1%u(i1) - y2%u(i1)) + t(2)**2*(-y1%u(i1) + y3%u(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%u(i1) + t(3)*y2%u(i1) - t(2)*y3%u(i1) ) * scaleFactor
    y_out%u(i1) = y1%u(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%v) .AND. ASSOCIATED(y1%v)) THEN
  DO i1 = LBOUND(y_out%v,1),UBOUND(y_out%v,1)
    b = (t(3)**2*(y1%v(i1) - y2%v(i1)) + t(2)**2*(-y1%v(i1) + y3%v(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%v(i1) + t(3)*y2%v(i1) - t(2)*y3%v(i1) ) * scaleFactor
    y_out%v(i1) = y1%v(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%w) .AND. ASSOCIATED(y1%w)) THEN
  DO i1 = LBOUND(y_out%w,1),UBOUND(y_out%w,1)
    b = (t(3)**2*(y1%w(i1) - y2%w(i1)) + t(2)**2*(-y1%w(i1) + y3%w(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%w(i1) + t(3)*y2%w(i1) - t(2)*y3%w(i1) ) * scaleFactor
    y_out%w(i1) = y1%w(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE OpFM_Output_ExtrapInterp2

END MODULE OpenFOAM_Types
!ENDOFREGISTRYGENERATEDFILE
