!STARTOFREGISTRYGENERATEDFILE 'NWTC_Library_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! NWTC_Library_Types
!.................................................................................................................................
! This file is part of NWTC_Library.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! bjj: modifications made
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in NWTC_Library. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE NWTC_Library_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE SysSubs
IMPLICIT NONE
! =========  ProgDesc  =======
  TYPE, PUBLIC :: ProgDesc
    CHARACTER(99)  :: Name      !< Name of the program or module [-]
    CHARACTER(99)  :: Ver      !< Version number of the program or module [-]
    CHARACTER(24)  :: Date      !< String containing date module was last updated [-]
  END TYPE ProgDesc
! =======================
! =========  FASTdataType  =======
  TYPE, PUBLIC :: FASTdataType
    CHARACTER(1024)  :: File      !< Name of the FAST-style binary file [-]
    CHARACTER(1024)  :: Descr      !< String describing file [-]
    INTEGER(IntKi)  :: NumChans      !< Number of output channels in this binary file (not including the time channel) [-]
    INTEGER(IntKi)  :: NumRecs      !< Number of records (rows) of data in the file [-]
    REAL(DbKi)  :: TimeStep      !< Time step for evenly-spaced data in the output file (when NumRecs is not allo [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: ChanNames      !< Strings describing the names of the channels from the binary file (including the time channel) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: ChanUnits      !< Strings describing the units of the channels from the binary file (including the time channel) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Data      !< numeric data (rows and columns) from the binary file, including the time channel [-]
  END TYPE FASTdataType
! =======================
! =========  OutParmType  =======
  TYPE, PUBLIC :: OutParmType
    INTEGER(IntKi)  :: Indx      !< An index into AllOuts array where this channel is computed/stored [-]
    CHARACTER(ChanLen)  :: Name      !< Name of the output channel [-]
    CHARACTER(ChanLen)  :: Units      !< Units this channel is specified in [-]
    INTEGER(IntKi)  :: SignM      !< Multiplier for output channel; usually -1 (minus) or 0 (invalid channel) [-]
  END TYPE OutParmType
! =======================
! =========  FileInfoType  =======
  TYPE, PUBLIC :: FileInfoType
    INTEGER(IntKi)  :: NumLines 
    INTEGER(IntKi)  :: NumFiles 
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FileLine 
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FileIndx 
    CHARACTER(MaxFileInfoLineLen) , DIMENSION(:), ALLOCATABLE  :: FileList 
    CHARACTER(MaxFileInfoLineLen) , DIMENSION(:), ALLOCATABLE  :: Lines 
  END TYPE FileInfoType
! =======================
! =========  Quaternion  =======
  TYPE, PUBLIC :: Quaternion
    REAL(ReKi)  :: q0 
    REAL(ReKi) , DIMENSION(1:3)  :: v 
  END TYPE Quaternion
! =======================
! =========  NWTC_RandomNumber_ParameterType  =======
  TYPE, PUBLIC :: NWTC_RandomNumber_ParameterType
    INTEGER(IntKi)  :: pRNG 
    INTEGER(IntKi) , DIMENSION(1:3)  :: RandSeed 
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: RandSeedAry 
    CHARACTER(6)  :: RNG_type 
  END TYPE NWTC_RandomNumber_ParameterType
! =======================
CONTAINS

!=======================================================================
!> This routine sets the error status and error message for a routine      
!!  that may set non-AbortErrLev errors. It concatenates error messages
!!  and has the ability to provide a sort of traceback message of called
!!  routines (if this is called consistently).
!!  Modules in the FAST framework are recommend to use it.
   SUBROUTINE SetErrStat ( ErrStatLcl, ErrMessLcl, ErrStat, ErrMess, RoutineName )
      
      ! This routine is placed in this file because it is called in code generated by the FAST Registry (and I don't feel like putting it in the Sys files) ... be careful not to delete this routine!
      
   
      INTEGER(IntKi),                    INTENT(IN   )  :: ErrStatLcl   ! Error status of the operation
      CHARACTER(*),                      INTENT(IN   )  :: ErrMessLcl   ! Error message if ErrStat /= ErrID_None
                                                                        
      INTEGER(IntKi),                    INTENT(INOUT)  :: ErrStat      ! Error status of the operation
      CHARACTER(*),                      INTENT(INOUT)  :: ErrMess      ! Error message if ErrStat /= ErrID_None
   
      CHARACTER(*),                      INTENT(IN   )  :: RoutineName  ! Name of the routine error occurred in
      
   
      IF ( ErrStatLcl /= ErrID_None ) THEN
      
         IF (ErrStat /= ErrID_None) ErrMess = TRIM(ErrMess)//NewLine
         ErrMess = TRIM(ErrMess)//TRIM(RoutineName)//':'//TRIM(ErrMessLcl)
         ErrStat = MAX(ErrStat,ErrStatLcl)
         
      END IF
         
   END SUBROUTINE SetErrStat    
!=======================================================================

 SUBROUTINE NWTC_Library_CopyProgDesc( SrcProgDescData, DstProgDescData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ProgDesc), INTENT(IN) :: SrcProgDescData
   TYPE(ProgDesc), INTENT(INOUT) :: DstProgDescData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyProgDesc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstProgDescData%Name = SrcProgDescData%Name
    DstProgDescData%Ver = SrcProgDescData%Ver
    DstProgDescData%Date = SrcProgDescData%Date
 END SUBROUTINE NWTC_Library_CopyProgDesc

 SUBROUTINE NWTC_Library_DestroyProgDesc( ProgDescData, ErrStat, ErrMsg )
  TYPE(ProgDesc), INTENT(INOUT) :: ProgDescData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyProgDesc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE NWTC_Library_DestroyProgDesc

 SUBROUTINE NWTC_Library_PackProgDesc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ProgDesc),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackProgDesc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Name)  ! Name
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Ver)  ! Ver
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Date)  ! Date
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%Name)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Name(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Ver)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Ver(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Date)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Date(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE NWTC_Library_PackProgDesc

 SUBROUTINE NWTC_Library_UnPackProgDesc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ProgDesc), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackProgDesc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%Name)
      OutData%Name(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Ver)
      OutData%Ver(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Date)
      OutData%Date(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE NWTC_Library_UnPackProgDesc

 SUBROUTINE NWTC_Library_CopyFASTdataType( SrcFASTdataTypeData, DstFASTdataTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FASTdataType), INTENT(IN) :: SrcFASTdataTypeData
   TYPE(FASTdataType), INTENT(INOUT) :: DstFASTdataTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyFASTdataType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstFASTdataTypeData%File = SrcFASTdataTypeData%File
    DstFASTdataTypeData%Descr = SrcFASTdataTypeData%Descr
    DstFASTdataTypeData%NumChans = SrcFASTdataTypeData%NumChans
    DstFASTdataTypeData%NumRecs = SrcFASTdataTypeData%NumRecs
    DstFASTdataTypeData%TimeStep = SrcFASTdataTypeData%TimeStep
IF (ALLOCATED(SrcFASTdataTypeData%ChanNames)) THEN
  i1_l = LBOUND(SrcFASTdataTypeData%ChanNames,1)
  i1_u = UBOUND(SrcFASTdataTypeData%ChanNames,1)
  IF (.NOT. ALLOCATED(DstFASTdataTypeData%ChanNames)) THEN 
    ALLOCATE(DstFASTdataTypeData%ChanNames(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFASTdataTypeData%ChanNames.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFASTdataTypeData%ChanNames = SrcFASTdataTypeData%ChanNames
ENDIF
IF (ALLOCATED(SrcFASTdataTypeData%ChanUnits)) THEN
  i1_l = LBOUND(SrcFASTdataTypeData%ChanUnits,1)
  i1_u = UBOUND(SrcFASTdataTypeData%ChanUnits,1)
  IF (.NOT. ALLOCATED(DstFASTdataTypeData%ChanUnits)) THEN 
    ALLOCATE(DstFASTdataTypeData%ChanUnits(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFASTdataTypeData%ChanUnits.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFASTdataTypeData%ChanUnits = SrcFASTdataTypeData%ChanUnits
ENDIF
IF (ALLOCATED(SrcFASTdataTypeData%Data)) THEN
  i1_l = LBOUND(SrcFASTdataTypeData%Data,1)
  i1_u = UBOUND(SrcFASTdataTypeData%Data,1)
  i2_l = LBOUND(SrcFASTdataTypeData%Data,2)
  i2_u = UBOUND(SrcFASTdataTypeData%Data,2)
  IF (.NOT. ALLOCATED(DstFASTdataTypeData%Data)) THEN 
    ALLOCATE(DstFASTdataTypeData%Data(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFASTdataTypeData%Data.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFASTdataTypeData%Data = SrcFASTdataTypeData%Data
ENDIF
 END SUBROUTINE NWTC_Library_CopyFASTdataType

 SUBROUTINE NWTC_Library_DestroyFASTdataType( FASTdataTypeData, ErrStat, ErrMsg )
  TYPE(FASTdataType), INTENT(INOUT) :: FASTdataTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyFASTdataType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(FASTdataTypeData%ChanNames)) THEN
  DEALLOCATE(FASTdataTypeData%ChanNames)
ENDIF
IF (ALLOCATED(FASTdataTypeData%ChanUnits)) THEN
  DEALLOCATE(FASTdataTypeData%ChanUnits)
ENDIF
IF (ALLOCATED(FASTdataTypeData%Data)) THEN
  DEALLOCATE(FASTdataTypeData%Data)
ENDIF
 END SUBROUTINE NWTC_Library_DestroyFASTdataType

 SUBROUTINE NWTC_Library_PackFASTdataType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FASTdataType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackFASTdataType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%File)  ! File
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Descr)  ! Descr
      Int_BufSz  = Int_BufSz  + 1  ! NumChans
      Int_BufSz  = Int_BufSz  + 1  ! NumRecs
      Db_BufSz   = Db_BufSz   + 1  ! TimeStep
  Int_BufSz   = Int_BufSz   + 1     ! ChanNames allocated yes/no
  IF ( ALLOCATED(InData%ChanNames) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ChanNames upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%ChanNames)*LEN(InData%ChanNames)  ! ChanNames
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ChanUnits allocated yes/no
  IF ( ALLOCATED(InData%ChanUnits) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ChanUnits upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%ChanUnits)*LEN(InData%ChanUnits)  ! ChanUnits
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Data allocated yes/no
  IF ( ALLOCATED(InData%Data) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Data upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Data)  ! Data
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%File)
      IntKiBuf(Int_Xferred) = ICHAR(InData%File(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Descr)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Descr(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NumChans
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumRecs
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%TimeStep
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%ChanNames) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChanNames,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChanNames,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ChanNames,1), UBOUND(InData%ChanNames,1)
        DO I = 1, LEN(InData%ChanNames)
          IntKiBuf(Int_Xferred) = ICHAR(InData%ChanNames(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ChanUnits) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChanUnits,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChanUnits,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ChanUnits,1), UBOUND(InData%ChanUnits,1)
        DO I = 1, LEN(InData%ChanUnits)
          IntKiBuf(Int_Xferred) = ICHAR(InData%ChanUnits(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Data) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Data,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Data,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Data,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Data,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Data,2), UBOUND(InData%Data,2)
        DO i1 = LBOUND(InData%Data,1), UBOUND(InData%Data,1)
          ReKiBuf(Re_Xferred) = InData%Data(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE NWTC_Library_PackFASTdataType

 SUBROUTINE NWTC_Library_UnPackFASTdataType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FASTdataType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackFASTdataType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%File)
      OutData%File(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Descr)
      OutData%Descr(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NumChans = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumRecs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TimeStep = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ChanNames not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ChanNames)) DEALLOCATE(OutData%ChanNames)
    ALLOCATE(OutData%ChanNames(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ChanNames.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ChanNames,1), UBOUND(OutData%ChanNames,1)
        DO I = 1, LEN(OutData%ChanNames)
          OutData%ChanNames(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ChanUnits not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ChanUnits)) DEALLOCATE(OutData%ChanUnits)
    ALLOCATE(OutData%ChanUnits(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ChanUnits.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ChanUnits,1), UBOUND(OutData%ChanUnits,1)
        DO I = 1, LEN(OutData%ChanUnits)
          OutData%ChanUnits(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Data not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Data)) DEALLOCATE(OutData%Data)
    ALLOCATE(OutData%Data(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Data.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Data,2), UBOUND(OutData%Data,2)
        DO i1 = LBOUND(OutData%Data,1), UBOUND(OutData%Data,1)
          OutData%Data(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE NWTC_Library_UnPackFASTdataType

 SUBROUTINE NWTC_Library_CopyOutParmType( SrcOutParmTypeData, DstOutParmTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(OutParmType), INTENT(IN) :: SrcOutParmTypeData
   TYPE(OutParmType), INTENT(INOUT) :: DstOutParmTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyOutParmType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOutParmTypeData%Indx = SrcOutParmTypeData%Indx
    DstOutParmTypeData%Name = SrcOutParmTypeData%Name
    DstOutParmTypeData%Units = SrcOutParmTypeData%Units
    DstOutParmTypeData%SignM = SrcOutParmTypeData%SignM
 END SUBROUTINE NWTC_Library_CopyOutParmType

 SUBROUTINE NWTC_Library_DestroyOutParmType( OutParmTypeData, ErrStat, ErrMsg )
  TYPE(OutParmType), INTENT(INOUT) :: OutParmTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyOutParmType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE NWTC_Library_DestroyOutParmType

 SUBROUTINE NWTC_Library_PackOutParmType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(OutParmType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackOutParmType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! Indx
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Name)  ! Name
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Units)  ! Units
      Int_BufSz  = Int_BufSz  + 1  ! SignM
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%Indx
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%Name)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Name(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Units)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Units(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%SignM
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE NWTC_Library_PackOutParmType

 SUBROUTINE NWTC_Library_UnPackOutParmType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(OutParmType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackOutParmType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Indx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%Name)
      OutData%Name(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Units)
      OutData%Units(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%SignM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE NWTC_Library_UnPackOutParmType

 SUBROUTINE NWTC_Library_CopyFileInfoType( SrcFileInfoTypeData, DstFileInfoTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FileInfoType), INTENT(IN) :: SrcFileInfoTypeData
   TYPE(FileInfoType), INTENT(INOUT) :: DstFileInfoTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyFileInfoType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstFileInfoTypeData%NumLines = SrcFileInfoTypeData%NumLines
    DstFileInfoTypeData%NumFiles = SrcFileInfoTypeData%NumFiles
IF (ALLOCATED(SrcFileInfoTypeData%FileLine)) THEN
  i1_l = LBOUND(SrcFileInfoTypeData%FileLine,1)
  i1_u = UBOUND(SrcFileInfoTypeData%FileLine,1)
  IF (.NOT. ALLOCATED(DstFileInfoTypeData%FileLine)) THEN 
    ALLOCATE(DstFileInfoTypeData%FileLine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFileInfoTypeData%FileLine.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFileInfoTypeData%FileLine = SrcFileInfoTypeData%FileLine
ENDIF
IF (ALLOCATED(SrcFileInfoTypeData%FileIndx)) THEN
  i1_l = LBOUND(SrcFileInfoTypeData%FileIndx,1)
  i1_u = UBOUND(SrcFileInfoTypeData%FileIndx,1)
  IF (.NOT. ALLOCATED(DstFileInfoTypeData%FileIndx)) THEN 
    ALLOCATE(DstFileInfoTypeData%FileIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFileInfoTypeData%FileIndx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFileInfoTypeData%FileIndx = SrcFileInfoTypeData%FileIndx
ENDIF
IF (ALLOCATED(SrcFileInfoTypeData%FileList)) THEN
  i1_l = LBOUND(SrcFileInfoTypeData%FileList,1)
  i1_u = UBOUND(SrcFileInfoTypeData%FileList,1)
  IF (.NOT. ALLOCATED(DstFileInfoTypeData%FileList)) THEN 
    ALLOCATE(DstFileInfoTypeData%FileList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFileInfoTypeData%FileList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFileInfoTypeData%FileList = SrcFileInfoTypeData%FileList
ENDIF
IF (ALLOCATED(SrcFileInfoTypeData%Lines)) THEN
  i1_l = LBOUND(SrcFileInfoTypeData%Lines,1)
  i1_u = UBOUND(SrcFileInfoTypeData%Lines,1)
  IF (.NOT. ALLOCATED(DstFileInfoTypeData%Lines)) THEN 
    ALLOCATE(DstFileInfoTypeData%Lines(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFileInfoTypeData%Lines.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFileInfoTypeData%Lines = SrcFileInfoTypeData%Lines
ENDIF
 END SUBROUTINE NWTC_Library_CopyFileInfoType

 SUBROUTINE NWTC_Library_DestroyFileInfoType( FileInfoTypeData, ErrStat, ErrMsg )
  TYPE(FileInfoType), INTENT(INOUT) :: FileInfoTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyFileInfoType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(FileInfoTypeData%FileLine)) THEN
  DEALLOCATE(FileInfoTypeData%FileLine)
ENDIF
IF (ALLOCATED(FileInfoTypeData%FileIndx)) THEN
  DEALLOCATE(FileInfoTypeData%FileIndx)
ENDIF
IF (ALLOCATED(FileInfoTypeData%FileList)) THEN
  DEALLOCATE(FileInfoTypeData%FileList)
ENDIF
IF (ALLOCATED(FileInfoTypeData%Lines)) THEN
  DEALLOCATE(FileInfoTypeData%Lines)
ENDIF
 END SUBROUTINE NWTC_Library_DestroyFileInfoType

 SUBROUTINE NWTC_Library_PackFileInfoType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FileInfoType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackFileInfoType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NumLines
      Int_BufSz  = Int_BufSz  + 1  ! NumFiles
  Int_BufSz   = Int_BufSz   + 1     ! FileLine allocated yes/no
  IF ( ALLOCATED(InData%FileLine) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FileLine upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FileLine)  ! FileLine
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FileIndx allocated yes/no
  IF ( ALLOCATED(InData%FileIndx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FileIndx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FileIndx)  ! FileIndx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FileList allocated yes/no
  IF ( ALLOCATED(InData%FileList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FileList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FileList)*LEN(InData%FileList)  ! FileList
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Lines allocated yes/no
  IF ( ALLOCATED(InData%Lines) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Lines upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Lines)*LEN(InData%Lines)  ! Lines
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NumLines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumFiles
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%FileLine) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FileLine,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FileLine,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FileLine,1), UBOUND(InData%FileLine,1)
        IntKiBuf(Int_Xferred) = InData%FileLine(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FileIndx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FileIndx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FileIndx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FileIndx,1), UBOUND(InData%FileIndx,1)
        IntKiBuf(Int_Xferred) = InData%FileIndx(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FileList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FileList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FileList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FileList,1), UBOUND(InData%FileList,1)
        DO I = 1, LEN(InData%FileList)
          IntKiBuf(Int_Xferred) = ICHAR(InData%FileList(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Lines) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Lines,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Lines,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Lines,1), UBOUND(InData%Lines,1)
        DO I = 1, LEN(InData%Lines)
          IntKiBuf(Int_Xferred) = ICHAR(InData%Lines(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE NWTC_Library_PackFileInfoType

 SUBROUTINE NWTC_Library_UnPackFileInfoType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FileInfoType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackFileInfoType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NumLines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumFiles = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FileLine not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FileLine)) DEALLOCATE(OutData%FileLine)
    ALLOCATE(OutData%FileLine(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FileLine.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FileLine,1), UBOUND(OutData%FileLine,1)
        OutData%FileLine(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FileIndx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FileIndx)) DEALLOCATE(OutData%FileIndx)
    ALLOCATE(OutData%FileIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FileIndx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FileIndx,1), UBOUND(OutData%FileIndx,1)
        OutData%FileIndx(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FileList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FileList)) DEALLOCATE(OutData%FileList)
    ALLOCATE(OutData%FileList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FileList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FileList,1), UBOUND(OutData%FileList,1)
        DO I = 1, LEN(OutData%FileList)
          OutData%FileList(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Lines not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Lines)) DEALLOCATE(OutData%Lines)
    ALLOCATE(OutData%Lines(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Lines.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Lines,1), UBOUND(OutData%Lines,1)
        DO I = 1, LEN(OutData%Lines)
          OutData%Lines(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE NWTC_Library_UnPackFileInfoType

 SUBROUTINE NWTC_Library_CopyQuaternion( SrcQuaternionData, DstQuaternionData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Quaternion), INTENT(IN) :: SrcQuaternionData
   TYPE(Quaternion), INTENT(INOUT) :: DstQuaternionData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyQuaternion'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstQuaternionData%q0 = SrcQuaternionData%q0
    DstQuaternionData%v = SrcQuaternionData%v
 END SUBROUTINE NWTC_Library_CopyQuaternion

 SUBROUTINE NWTC_Library_DestroyQuaternion( QuaternionData, ErrStat, ErrMsg )
  TYPE(Quaternion), INTENT(INOUT) :: QuaternionData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyQuaternion'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE NWTC_Library_DestroyQuaternion

 SUBROUTINE NWTC_Library_PackQuaternion( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Quaternion),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackQuaternion'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! q0
      Re_BufSz   = Re_BufSz   + SIZE(InData%v)  ! v
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%q0
    Re_Xferred = Re_Xferred + 1
    DO i1 = LBOUND(InData%v,1), UBOUND(InData%v,1)
      ReKiBuf(Re_Xferred) = InData%v(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE NWTC_Library_PackQuaternion

 SUBROUTINE NWTC_Library_UnPackQuaternion( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Quaternion), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackQuaternion'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%q0 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    i1_l = LBOUND(OutData%v,1)
    i1_u = UBOUND(OutData%v,1)
    DO i1 = LBOUND(OutData%v,1), UBOUND(OutData%v,1)
      OutData%v(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE NWTC_Library_UnPackQuaternion

 SUBROUTINE NWTC_Library_CopyNWTC_RandomNumber_ParameterType( SrcNWTC_RandomNumber_ParameterTypeData, DstNWTC_RandomNumber_ParameterTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(NWTC_RandomNumber_ParameterType), INTENT(IN) :: SrcNWTC_RandomNumber_ParameterTypeData
   TYPE(NWTC_RandomNumber_ParameterType), INTENT(INOUT) :: DstNWTC_RandomNumber_ParameterTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_CopyNWTC_RandomNumber_ParameterType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstNWTC_RandomNumber_ParameterTypeData%pRNG = SrcNWTC_RandomNumber_ParameterTypeData%pRNG
    DstNWTC_RandomNumber_ParameterTypeData%RandSeed = SrcNWTC_RandomNumber_ParameterTypeData%RandSeed
IF (ALLOCATED(SrcNWTC_RandomNumber_ParameterTypeData%RandSeedAry)) THEN
  i1_l = LBOUND(SrcNWTC_RandomNumber_ParameterTypeData%RandSeedAry,1)
  i1_u = UBOUND(SrcNWTC_RandomNumber_ParameterTypeData%RandSeedAry,1)
  IF (.NOT. ALLOCATED(DstNWTC_RandomNumber_ParameterTypeData%RandSeedAry)) THEN 
    ALLOCATE(DstNWTC_RandomNumber_ParameterTypeData%RandSeedAry(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstNWTC_RandomNumber_ParameterTypeData%RandSeedAry.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstNWTC_RandomNumber_ParameterTypeData%RandSeedAry = SrcNWTC_RandomNumber_ParameterTypeData%RandSeedAry
ENDIF
    DstNWTC_RandomNumber_ParameterTypeData%RNG_type = SrcNWTC_RandomNumber_ParameterTypeData%RNG_type
 END SUBROUTINE NWTC_Library_CopyNWTC_RandomNumber_ParameterType

 SUBROUTINE NWTC_Library_DestroyNWTC_RandomNumber_ParameterType( NWTC_RandomNumber_ParameterTypeData, ErrStat, ErrMsg )
  TYPE(NWTC_RandomNumber_ParameterType), INTENT(INOUT) :: NWTC_RandomNumber_ParameterTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'NWTC_Library_DestroyNWTC_RandomNumber_ParameterType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(NWTC_RandomNumber_ParameterTypeData%RandSeedAry)) THEN
  DEALLOCATE(NWTC_RandomNumber_ParameterTypeData%RandSeedAry)
ENDIF
 END SUBROUTINE NWTC_Library_DestroyNWTC_RandomNumber_ParameterType

 SUBROUTINE NWTC_Library_PackNWTC_RandomNumber_ParameterType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(NWTC_RandomNumber_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_PackNWTC_RandomNumber_ParameterType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! pRNG
      Int_BufSz  = Int_BufSz  + SIZE(InData%RandSeed)  ! RandSeed
  Int_BufSz   = Int_BufSz   + 1     ! RandSeedAry allocated yes/no
  IF ( ALLOCATED(InData%RandSeedAry) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RandSeedAry upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%RandSeedAry)  ! RandSeedAry
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RNG_type)  ! RNG_type
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%pRNG
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%RandSeed,1), UBOUND(InData%RandSeed,1)
      IntKiBuf(Int_Xferred) = InData%RandSeed(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%RandSeedAry) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RandSeedAry,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RandSeedAry,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RandSeedAry,1), UBOUND(InData%RandSeedAry,1)
        IntKiBuf(Int_Xferred) = InData%RandSeedAry(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(InData%RNG_type)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RNG_type(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE NWTC_Library_PackNWTC_RandomNumber_ParameterType

 SUBROUTINE NWTC_Library_UnPackNWTC_RandomNumber_ParameterType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(NWTC_RandomNumber_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'NWTC_Library_UnPackNWTC_RandomNumber_ParameterType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%pRNG = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%RandSeed,1)
    i1_u = UBOUND(OutData%RandSeed,1)
    DO i1 = LBOUND(OutData%RandSeed,1), UBOUND(OutData%RandSeed,1)
      OutData%RandSeed(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RandSeedAry not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RandSeedAry)) DEALLOCATE(OutData%RandSeedAry)
    ALLOCATE(OutData%RandSeedAry(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RandSeedAry.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RandSeedAry,1), UBOUND(OutData%RandSeedAry,1)
        OutData%RandSeedAry(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(OutData%RNG_type)
      OutData%RNG_type(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE NWTC_Library_UnPackNWTC_RandomNumber_ParameterType

END MODULE NWTC_Library_Types
!ENDOFREGISTRYGENERATEDFILE
