!STARTOFREGISTRYGENERATEDFILE 'MAP_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! MAP_Types
!.................................................................................................................................
! This file is part of MAP.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in MAP. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE MAP_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE MAP_Fortran_Types
!USE, INTRINSIC :: ISO_C_Binding
USE NWTC_Library
IMPLICIT NONE
! =========  MAP_InitInputType_C  =======
  TYPE, BIND(C) :: MAP_InitInputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: gravity 
    REAL(KIND=C_DOUBLE) :: sea_density 
    REAL(KIND=C_DOUBLE) :: depth 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: file_name 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: summary_file_name 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: library_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: node_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: line_input_str 
    CHARACTER(KIND=C_CHAR), DIMENSION(255) :: option_input_str 
  END TYPE MAP_InitInputType_C
  TYPE, PUBLIC :: MAP_InitInputType
    TYPE( MAP_InitInputType_C ) :: C_obj
    REAL(R8Ki)  :: gravity = -999.9      !< gravity constant [[m/s^2]]
    REAL(R8Ki)  :: sea_density = -999.9      !< sea density [[kg/m^3]]
    REAL(R8Ki)  :: depth = -999.9      !< depth of water [[m]]
    CHARACTER(255)  :: file_name      !< MAP input file [-]
    CHARACTER(255)  :: summary_file_name      !< MAP summary file name [-]
    CHARACTER(255)  :: library_input_str      !< cable library string information (from input file) [-]
    CHARACTER(255)  :: node_input_str      !< node string information (from input file) [-]
    CHARACTER(255)  :: line_input_str      !< element library string information (from input file) [-]
    CHARACTER(255)  :: option_input_str      !< solver options library string information (from input file) [-]
    TYPE(Lin_InitInputType)  :: LinInitInp      !<   [-]
  END TYPE MAP_InitInputType
! =======================
! =========  MAP_InitOutputType_C  =======
  TYPE, BIND(C) :: MAP_InitOutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    CHARACTER(KIND=C_CHAR), DIMENSION(99) :: progName 
    CHARACTER(KIND=C_CHAR), DIMENSION(99) :: version 
    CHARACTER(KIND=C_CHAR), DIMENSION(24) :: compilingData 
    TYPE(C_ptr) :: writeOutputHdr = C_NULL_PTR 
    INTEGER(C_int) :: writeOutputHdr_Len = 0 
    TYPE(C_ptr) :: writeOutputUnt = C_NULL_PTR 
    INTEGER(C_int) :: writeOutputUnt_Len = 0 
  END TYPE MAP_InitOutputType_C
  TYPE, PUBLIC :: MAP_InitOutputType
    TYPE( MAP_InitOutputType_C ) :: C_obj
    CHARACTER(99)  :: progName      !< program name [-]
    CHARACTER(99)  :: version      !< version numnber [-]
    CHARACTER(24)  :: compilingData      !< compiling data [-]
    CHARACTER(15) , DIMENSION(:), ALLOCATABLE  :: writeOutputHdr      !< first line output file contents: output variable names [-]
    CHARACTER(15) , DIMENSION(:), ALLOCATABLE  :: writeOutputUnt      !< second line of output file contents: units [-]
    TYPE(ProgDesc)  :: Ver      !< this module's name, version, and date [-]
    TYPE(Lin_InitOutputType)  :: LinInitOut      !< Init Output linearization data (fortran-only) [-]
  END TYPE MAP_InitOutputType
! =======================
! =========  MAP_ContinuousStateType_C  =======
  TYPE, BIND(C) :: MAP_ContinuousStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: dummy 
  END TYPE MAP_ContinuousStateType_C
  TYPE, PUBLIC :: MAP_ContinuousStateType
    TYPE( MAP_ContinuousStateType_C ) :: C_obj
    REAL(R8Ki)  :: dummy      !< Remove this variable if you have continuous states [-]
  END TYPE MAP_ContinuousStateType
! =======================
! =========  MAP_DiscreteStateType_C  =======
  TYPE, BIND(C) :: MAP_DiscreteStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: dummy 
  END TYPE MAP_DiscreteStateType_C
  TYPE, PUBLIC :: MAP_DiscreteStateType
    TYPE( MAP_DiscreteStateType_C ) :: C_obj
    REAL(R8Ki)  :: dummy      !< Remove this variable if you have discrete states [-]
  END TYPE MAP_DiscreteStateType
! =======================
! =========  MAP_OtherStateType_C  =======
  TYPE, BIND(C) :: MAP_OtherStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: H = C_NULL_PTR 
    INTEGER(C_int) :: H_Len = 0 
    TYPE(C_ptr) :: V = C_NULL_PTR 
    INTEGER(C_int) :: V_Len = 0 
    TYPE(C_ptr) :: Ha = C_NULL_PTR 
    INTEGER(C_int) :: Ha_Len = 0 
    TYPE(C_ptr) :: Va = C_NULL_PTR 
    INTEGER(C_int) :: Va_Len = 0 
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
    TYPE(C_ptr) :: xa = C_NULL_PTR 
    INTEGER(C_int) :: xa_Len = 0 
    TYPE(C_ptr) :: ya = C_NULL_PTR 
    INTEGER(C_int) :: ya_Len = 0 
    TYPE(C_ptr) :: za = C_NULL_PTR 
    INTEGER(C_int) :: za_Len = 0 
    TYPE(C_ptr) :: Fx_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fx_connect_Len = 0 
    TYPE(C_ptr) :: Fy_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fy_connect_Len = 0 
    TYPE(C_ptr) :: Fz_connect = C_NULL_PTR 
    INTEGER(C_int) :: Fz_connect_Len = 0 
    TYPE(C_ptr) :: Fx_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fx_anchor_Len = 0 
    TYPE(C_ptr) :: Fy_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fy_anchor_Len = 0 
    TYPE(C_ptr) :: Fz_anchor = C_NULL_PTR 
    INTEGER(C_int) :: Fz_anchor_Len = 0 
  END TYPE MAP_OtherStateType_C
  TYPE, PUBLIC :: MAP_OtherStateType
    TYPE( MAP_OtherStateType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: H => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: V => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Ha => NULL()      !< horizontal line force at anchor [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Va => NULL()      !< Vertical line force at anchor [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< x fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< y fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< z fairlead line position [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: xa => NULL()      !< x fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: ya => NULL()      !< y fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: za => NULL()      !< z fairlead line position at anchor [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx_connect => NULL()      !< horizontal x line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy_connect => NULL()      !< horizontal y line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz_connect => NULL()      !< vertical z line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx_anchor => NULL()      !< horizontal x line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy_anchor => NULL()      !< horizontal y line force at connect node [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz_anchor => NULL()      !< vertical z line force at connect node [[N]]
  END TYPE MAP_OtherStateType
! =======================
! =========  MAP_ConstraintStateType_C  =======
  TYPE, BIND(C) :: MAP_ConstraintStateType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: H = C_NULL_PTR 
    INTEGER(C_int) :: H_Len = 0 
    TYPE(C_ptr) :: V = C_NULL_PTR 
    INTEGER(C_int) :: V_Len = 0 
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
  END TYPE MAP_ConstraintStateType_C
  TYPE, PUBLIC :: MAP_ConstraintStateType
    TYPE( MAP_ConstraintStateType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: H => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: V => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< fairlead x displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< fairlead y displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< fairlead z displacement [[m]]
  END TYPE MAP_ConstraintStateType
! =======================
! =========  MAP_ParameterType_C  =======
  TYPE, BIND(C) :: MAP_ParameterType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    REAL(KIND=C_DOUBLE) :: g 
    REAL(KIND=C_DOUBLE) :: depth 
    REAL(KIND=C_DOUBLE) :: rho_sea 
    REAL(KIND=C_DOUBLE) :: dt 
    INTEGER(KIND=C_INT) :: numOuts 
  END TYPE MAP_ParameterType_C
  TYPE, PUBLIC :: MAP_ParameterType
    TYPE( MAP_ParameterType_C ) :: C_obj
    REAL(R8Ki)  :: g      !< gravitational constant [[kg/m^2]]
    REAL(R8Ki)  :: depth      !< distance to seabed [[m]]
    REAL(R8Ki)  :: rho_sea      !< density of seawater [[m]]
    REAL(R8Ki)  :: dt      !< time step coupling interval [[sec]]
    CHARACTER(255) , DIMENSION(1:500)  :: InputLines      !< input file line for restart [-]
    CHARACTER(1) , DIMENSION(1:500)  :: InputLineType      !< input file line type for restart [-]
    INTEGER(IntKi)  :: numOuts = 0      !< Number of write outputs [-]
    TYPE(Lin_ParamType)  :: LinParams      !< Parameter linearization data (fortran-only) [-]
  END TYPE MAP_ParameterType
! =======================
! =========  MAP_InputType_C  =======
  TYPE, BIND(C) :: MAP_InputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: x = C_NULL_PTR 
    INTEGER(C_int) :: x_Len = 0 
    TYPE(C_ptr) :: y = C_NULL_PTR 
    INTEGER(C_int) :: y_Len = 0 
    TYPE(C_ptr) :: z = C_NULL_PTR 
    INTEGER(C_int) :: z_Len = 0 
  END TYPE MAP_InputType_C
  TYPE, PUBLIC :: MAP_InputType
    TYPE( MAP_InputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: x => NULL()      !< fairlead x displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: y => NULL()      !< fairlead y displacement [[m]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: z => NULL()      !< fairlead z displacement [[m]]
    TYPE(MeshType)  :: PtFairDisplacement      !< position of each fairlead in X,Y,Z [[m]]
  END TYPE MAP_InputType
! =======================
! =========  MAP_OutputType_C  =======
  TYPE, BIND(C) :: MAP_OutputType_C
   TYPE(C_PTR) :: object = C_NULL_PTR
    TYPE(C_ptr) :: Fx = C_NULL_PTR 
    INTEGER(C_int) :: Fx_Len = 0 
    TYPE(C_ptr) :: Fy = C_NULL_PTR 
    INTEGER(C_int) :: Fy_Len = 0 
    TYPE(C_ptr) :: Fz = C_NULL_PTR 
    INTEGER(C_int) :: Fz_Len = 0 
    TYPE(C_ptr) :: WriteOutput = C_NULL_PTR 
    INTEGER(C_int) :: WriteOutput_Len = 0 
    TYPE(C_ptr) :: wrtOutput = C_NULL_PTR 
    INTEGER(C_int) :: wrtOutput_Len = 0 
  END TYPE MAP_OutputType_C
  TYPE, PUBLIC :: MAP_OutputType
    TYPE( MAP_OutputType_C ) :: C_obj
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fx => NULL()      !< horizontal line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fy => NULL()      !< Vertical line force [[N]]
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: Fz => NULL()      !< horizontal line force at anchor [[N]]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< outpur vector []
    REAL(KIND=C_DOUBLE) , DIMENSION(:), POINTER  :: wrtOutput => NULL()      !< outpur vector []
    TYPE(MeshType)  :: ptFairleadLoad      !< point mesh for forces in X,Y,Z [[N]]
  END TYPE MAP_OutputType
! =======================
CONTAINS
 SUBROUTINE MAP_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(MAP_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%gravity = SrcInitInputData%gravity
    DstInitInputData%C_obj%gravity = SrcInitInputData%C_obj%gravity
    DstInitInputData%sea_density = SrcInitInputData%sea_density
    DstInitInputData%C_obj%sea_density = SrcInitInputData%C_obj%sea_density
    DstInitInputData%depth = SrcInitInputData%depth
    DstInitInputData%C_obj%depth = SrcInitInputData%C_obj%depth
    DstInitInputData%file_name = SrcInitInputData%file_name
    DstInitInputData%C_obj%file_name = SrcInitInputData%C_obj%file_name
    DstInitInputData%summary_file_name = SrcInitInputData%summary_file_name
    DstInitInputData%C_obj%summary_file_name = SrcInitInputData%C_obj%summary_file_name
    DstInitInputData%library_input_str = SrcInitInputData%library_input_str
    DstInitInputData%C_obj%library_input_str = SrcInitInputData%C_obj%library_input_str
    DstInitInputData%node_input_str = SrcInitInputData%node_input_str
    DstInitInputData%C_obj%node_input_str = SrcInitInputData%C_obj%node_input_str
    DstInitInputData%line_input_str = SrcInitInputData%line_input_str
    DstInitInputData%C_obj%line_input_str = SrcInitInputData%C_obj%line_input_str
    DstInitInputData%option_input_str = SrcInitInputData%option_input_str
    DstInitInputData%C_obj%option_input_str = SrcInitInputData%C_obj%option_input_str
      CALL MAP_Fortran_Copylin_initinputtype( SrcInitInputData%LinInitInp, DstInitInputData%LinInitInp, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE MAP_CopyInitInput

 SUBROUTINE MAP_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(MAP_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MAP_Fortran_Destroylin_initinputtype( InitInputData%LinInitInp, ErrStat, ErrMsg )
 END SUBROUTINE MAP_DestroyInitInput

 SUBROUTINE MAP_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! gravity
      Db_BufSz   = Db_BufSz   + 1  ! sea_density
      Db_BufSz   = Db_BufSz   + 1  ! depth
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%file_name)  ! file_name
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%summary_file_name)  ! summary_file_name
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%library_input_str)  ! library_input_str
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%node_input_str)  ! node_input_str
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%line_input_str)  ! line_input_str
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%option_input_str)  ! option_input_str
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! LinInitInp: size of buffers for each call to pack subtype
      CALL MAP_Fortran_Packlin_initinputtype( Re_Buf, Db_Buf, Int_Buf, InData%LinInitInp, ErrStat2, ErrMsg2, .TRUE. ) ! LinInitInp 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! LinInitInp
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! LinInitInp
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! LinInitInp
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%gravity
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%sea_density
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%depth
    Db_Xferred = Db_Xferred + 1
    DO I = 1, LEN(InData%file_name)
      IntKiBuf(Int_Xferred) = ICHAR(InData%file_name(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%summary_file_name)
      IntKiBuf(Int_Xferred) = ICHAR(InData%summary_file_name(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%library_input_str)
      IntKiBuf(Int_Xferred) = ICHAR(InData%library_input_str(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%node_input_str)
      IntKiBuf(Int_Xferred) = ICHAR(InData%node_input_str(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%line_input_str)
      IntKiBuf(Int_Xferred) = ICHAR(InData%line_input_str(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%option_input_str)
      IntKiBuf(Int_Xferred) = ICHAR(InData%option_input_str(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      CALL MAP_Fortran_Packlin_initinputtype( Re_Buf, Db_Buf, Int_Buf, InData%LinInitInp, ErrStat2, ErrMsg2, OnlySize ) ! LinInitInp 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE MAP_PackInitInput

 SUBROUTINE MAP_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%gravity = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%gravity = OutData%gravity
    OutData%sea_density = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%sea_density = OutData%sea_density
    OutData%depth = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%depth = OutData%depth
    DO I = 1, LEN(OutData%file_name)
      OutData%file_name(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%file_name = TRANSFER(OutData%file_name, OutData%C_obj%file_name )
    DO I = 1, LEN(OutData%summary_file_name)
      OutData%summary_file_name(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%summary_file_name = TRANSFER(OutData%summary_file_name, OutData%C_obj%summary_file_name )
    DO I = 1, LEN(OutData%library_input_str)
      OutData%library_input_str(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%library_input_str = TRANSFER(OutData%library_input_str, OutData%C_obj%library_input_str )
    DO I = 1, LEN(OutData%node_input_str)
      OutData%node_input_str(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%node_input_str = TRANSFER(OutData%node_input_str, OutData%C_obj%node_input_str )
    DO I = 1, LEN(OutData%line_input_str)
      OutData%line_input_str(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%line_input_str = TRANSFER(OutData%line_input_str, OutData%C_obj%line_input_str )
    DO I = 1, LEN(OutData%option_input_str)
      OutData%option_input_str(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%option_input_str = TRANSFER(OutData%option_input_str, OutData%C_obj%option_input_str )
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MAP_Fortran_Unpacklin_initinputtype( Re_Buf, Db_Buf, Int_Buf, OutData%LinInitInp, ErrStat2, ErrMsg2 ) ! LinInitInp 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE MAP_UnPackInitInput

 SUBROUTINE MAP_C2Fary_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%gravity = InitInputData%C_obj%gravity
    InitInputData%sea_density = InitInputData%C_obj%sea_density
    InitInputData%depth = InitInputData%C_obj%depth
    InitInputData%file_name = TRANSFER(InitInputData%C_obj%file_name, InitInputData%file_name )
    InitInputData%summary_file_name = TRANSFER(InitInputData%C_obj%summary_file_name, InitInputData%summary_file_name )
    InitInputData%library_input_str = TRANSFER(InitInputData%C_obj%library_input_str, InitInputData%library_input_str )
    InitInputData%node_input_str = TRANSFER(InitInputData%C_obj%node_input_str, InitInputData%node_input_str )
    InitInputData%line_input_str = TRANSFER(InitInputData%C_obj%line_input_str, InitInputData%line_input_str )
    InitInputData%option_input_str = TRANSFER(InitInputData%C_obj%option_input_str, InitInputData%option_input_str )
 END SUBROUTINE MAP_C2Fary_CopyInitInput

 SUBROUTINE MAP_F2C_CopyInitInput( InitInputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_InitInputType), INTENT(INOUT) :: InitInputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitInputData%C_obj%gravity = InitInputData%gravity
    InitInputData%C_obj%sea_density = InitInputData%sea_density
    InitInputData%C_obj%depth = InitInputData%depth
    InitInputData%C_obj%file_name = TRANSFER(InitInputData%file_name, InitInputData%C_obj%file_name )
    InitInputData%C_obj%summary_file_name = TRANSFER(InitInputData%summary_file_name, InitInputData%C_obj%summary_file_name )
    InitInputData%C_obj%library_input_str = TRANSFER(InitInputData%library_input_str, InitInputData%C_obj%library_input_str )
    InitInputData%C_obj%node_input_str = TRANSFER(InitInputData%node_input_str, InitInputData%C_obj%node_input_str )
    InitInputData%C_obj%line_input_str = TRANSFER(InitInputData%line_input_str, InitInputData%C_obj%line_input_str )
    InitInputData%C_obj%option_input_str = TRANSFER(InitInputData%option_input_str, InitInputData%C_obj%option_input_str )
 END SUBROUTINE MAP_F2C_CopyInitInput

 SUBROUTINE MAP_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(MAP_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitOutputData%progName = SrcInitOutputData%progName
    DstInitOutputData%C_obj%progName = SrcInitOutputData%C_obj%progName
    DstInitOutputData%version = SrcInitOutputData%version
    DstInitOutputData%C_obj%version = SrcInitOutputData%C_obj%version
    DstInitOutputData%compilingData = SrcInitOutputData%compilingData
    DstInitOutputData%C_obj%compilingData = SrcInitOutputData%C_obj%compilingData
IF (ALLOCATED(SrcInitOutputData%writeOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%writeOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%writeOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%writeOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%writeOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%writeOutputHdr = SrcInitOutputData%writeOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%writeOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%writeOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%writeOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%writeOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%writeOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%writeOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%writeOutputUnt = SrcInitOutputData%writeOutputUnt
ENDIF
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MAP_Fortran_Copylin_initoutputtype( SrcInitOutputData%LinInitOut, DstInitOutputData%LinInitOut, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE MAP_CopyInitOutput

 SUBROUTINE MAP_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(MAP_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%writeOutputHdr)) THEN
  DEALLOCATE(InitOutputData%writeOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%writeOutputUnt)) THEN
  DEALLOCATE(InitOutputData%writeOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
  CALL MAP_Fortran_Destroylin_initoutputtype( InitOutputData%LinInitOut, ErrStat, ErrMsg )
 END SUBROUTINE MAP_DestroyInitOutput

 SUBROUTINE MAP_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%progName)  ! progName
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%version)  ! version
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%compilingData)  ! compilingData
  Int_BufSz   = Int_BufSz   + 1     ! writeOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%writeOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! writeOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%writeOutputHdr)*LEN(InData%writeOutputHdr)  ! writeOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! writeOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%writeOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! writeOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%writeOutputUnt)*LEN(InData%writeOutputUnt)  ! writeOutputUnt
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! LinInitOut: size of buffers for each call to pack subtype
      CALL MAP_Fortran_Packlin_initoutputtype( Re_Buf, Db_Buf, Int_Buf, InData%LinInitOut, ErrStat2, ErrMsg2, .TRUE. ) ! LinInitOut 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! LinInitOut
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! LinInitOut
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! LinInitOut
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%progName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%progName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%version)
      IntKiBuf(Int_Xferred) = ICHAR(InData%version(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%compilingData)
      IntKiBuf(Int_Xferred) = ICHAR(InData%compilingData(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%writeOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%writeOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%writeOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%writeOutputHdr,1), UBOUND(InData%writeOutputHdr,1)
        DO I = 1, LEN(InData%writeOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%writeOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%writeOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%writeOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%writeOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%writeOutputUnt,1), UBOUND(InData%writeOutputUnt,1)
        DO I = 1, LEN(InData%writeOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%writeOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MAP_Fortran_Packlin_initoutputtype( Re_Buf, Db_Buf, Int_Buf, InData%LinInitOut, ErrStat2, ErrMsg2, OnlySize ) ! LinInitOut 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE MAP_PackInitOutput

 SUBROUTINE MAP_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%progName)
      OutData%progName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%progName = TRANSFER(OutData%progName, OutData%C_obj%progName )
    DO I = 1, LEN(OutData%version)
      OutData%version(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%version = TRANSFER(OutData%version, OutData%C_obj%version )
    DO I = 1, LEN(OutData%compilingData)
      OutData%compilingData(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      OutData%C_obj%compilingData = TRANSFER(OutData%compilingData, OutData%C_obj%compilingData )
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! writeOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%writeOutputHdr)) DEALLOCATE(OutData%writeOutputHdr)
    ALLOCATE(OutData%writeOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%writeOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%writeOutputHdr,1), UBOUND(OutData%writeOutputHdr,1)
        DO I = 1, LEN(OutData%writeOutputHdr)
          OutData%writeOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! writeOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%writeOutputUnt)) DEALLOCATE(OutData%writeOutputUnt)
    ALLOCATE(OutData%writeOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%writeOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%writeOutputUnt,1), UBOUND(OutData%writeOutputUnt,1)
        DO I = 1, LEN(OutData%writeOutputUnt)
          OutData%writeOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MAP_Fortran_Unpacklin_initoutputtype( Re_Buf, Db_Buf, Int_Buf, OutData%LinInitOut, ErrStat2, ErrMsg2 ) ! LinInitOut 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE MAP_UnPackInitOutput

 SUBROUTINE MAP_C2Fary_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitOutputData%progName = TRANSFER(InitOutputData%C_obj%progName, InitOutputData%progName )
    InitOutputData%version = TRANSFER(InitOutputData%C_obj%version, InitOutputData%version )
    InitOutputData%compilingData = TRANSFER(InitOutputData%C_obj%compilingData, InitOutputData%compilingData )
 END SUBROUTINE MAP_C2Fary_CopyInitOutput

 SUBROUTINE MAP_F2C_CopyInitOutput( InitOutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_InitOutputType), INTENT(INOUT) :: InitOutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    InitOutputData%C_obj%progName = TRANSFER(InitOutputData%progName, InitOutputData%C_obj%progName )
    InitOutputData%C_obj%version = TRANSFER(InitOutputData%version, InitOutputData%C_obj%version )
    InitOutputData%C_obj%compilingData = TRANSFER(InitOutputData%compilingData, InitOutputData%C_obj%compilingData )
 END SUBROUTINE MAP_F2C_CopyInitOutput

 SUBROUTINE MAP_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%dummy = SrcContStateData%dummy
    DstContStateData%C_obj%dummy = SrcContStateData%C_obj%dummy
 END SUBROUTINE MAP_CopyContState

 SUBROUTINE MAP_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE MAP_DestroyContState

 SUBROUTINE MAP_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%dummy
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE MAP_PackContState

 SUBROUTINE MAP_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dummy = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%dummy = OutData%dummy
 END SUBROUTINE MAP_UnPackContState

 SUBROUTINE MAP_C2Fary_CopyContState( ContStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: ContStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ContStateData%dummy = ContStateData%C_obj%dummy
 END SUBROUTINE MAP_C2Fary_CopyContState

 SUBROUTINE MAP_F2C_CopyContState( ContStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_ContinuousStateType), INTENT(INOUT) :: ContStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ContStateData%C_obj%dummy = ContStateData%dummy
 END SUBROUTINE MAP_F2C_CopyContState

 SUBROUTINE MAP_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%dummy = SrcDiscStateData%dummy
    DstDiscStateData%C_obj%dummy = SrcDiscStateData%C_obj%dummy
 END SUBROUTINE MAP_CopyDiscState

 SUBROUTINE MAP_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE MAP_DestroyDiscState

 SUBROUTINE MAP_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! dummy
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%dummy
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE MAP_PackDiscState

 SUBROUTINE MAP_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dummy = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%dummy = OutData%dummy
 END SUBROUTINE MAP_UnPackDiscState

 SUBROUTINE MAP_C2Fary_CopyDiscState( DiscStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DiscStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    DiscStateData%dummy = DiscStateData%C_obj%dummy
 END SUBROUTINE MAP_C2Fary_CopyDiscState

 SUBROUTINE MAP_F2C_CopyDiscState( DiscStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_DiscreteStateType), INTENT(INOUT) :: DiscStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    DiscStateData%C_obj%dummy = DiscStateData%dummy
 END SUBROUTINE MAP_F2C_CopyDiscState

 SUBROUTINE MAP_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(MAP_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcOtherStateData%H)) THEN
  i1_l = LBOUND(SrcOtherStateData%H,1)
  i1_u = UBOUND(SrcOtherStateData%H,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%H)) THEN 
    ALLOCATE(DstOtherStateData%H(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%H.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%H_Len = SIZE(DstOtherStateData%H)
    IF (DstOtherStateData%c_obj%H_Len > 0) &
      DstOtherStateData%c_obj%H = C_LOC( DstOtherStateData%H(i1_l) ) 
  END IF
    DstOtherStateData%H = SrcOtherStateData%H
ENDIF
IF (ASSOCIATED(SrcOtherStateData%V)) THEN
  i1_l = LBOUND(SrcOtherStateData%V,1)
  i1_u = UBOUND(SrcOtherStateData%V,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%V)) THEN 
    ALLOCATE(DstOtherStateData%V(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%V.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%V_Len = SIZE(DstOtherStateData%V)
    IF (DstOtherStateData%c_obj%V_Len > 0) &
      DstOtherStateData%c_obj%V = C_LOC( DstOtherStateData%V(i1_l) ) 
  END IF
    DstOtherStateData%V = SrcOtherStateData%V
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Ha)) THEN
  i1_l = LBOUND(SrcOtherStateData%Ha,1)
  i1_u = UBOUND(SrcOtherStateData%Ha,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Ha)) THEN 
    ALLOCATE(DstOtherStateData%Ha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Ha.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Ha_Len = SIZE(DstOtherStateData%Ha)
    IF (DstOtherStateData%c_obj%Ha_Len > 0) &
      DstOtherStateData%c_obj%Ha = C_LOC( DstOtherStateData%Ha(i1_l) ) 
  END IF
    DstOtherStateData%Ha = SrcOtherStateData%Ha
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Va)) THEN
  i1_l = LBOUND(SrcOtherStateData%Va,1)
  i1_u = UBOUND(SrcOtherStateData%Va,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Va)) THEN 
    ALLOCATE(DstOtherStateData%Va(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Va.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Va_Len = SIZE(DstOtherStateData%Va)
    IF (DstOtherStateData%c_obj%Va_Len > 0) &
      DstOtherStateData%c_obj%Va = C_LOC( DstOtherStateData%Va(i1_l) ) 
  END IF
    DstOtherStateData%Va = SrcOtherStateData%Va
ENDIF
IF (ASSOCIATED(SrcOtherStateData%x)) THEN
  i1_l = LBOUND(SrcOtherStateData%x,1)
  i1_u = UBOUND(SrcOtherStateData%x,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%x)) THEN 
    ALLOCATE(DstOtherStateData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%x_Len = SIZE(DstOtherStateData%x)
    IF (DstOtherStateData%c_obj%x_Len > 0) &
      DstOtherStateData%c_obj%x = C_LOC( DstOtherStateData%x(i1_l) ) 
  END IF
    DstOtherStateData%x = SrcOtherStateData%x
ENDIF
IF (ASSOCIATED(SrcOtherStateData%y)) THEN
  i1_l = LBOUND(SrcOtherStateData%y,1)
  i1_u = UBOUND(SrcOtherStateData%y,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%y)) THEN 
    ALLOCATE(DstOtherStateData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%y.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%y_Len = SIZE(DstOtherStateData%y)
    IF (DstOtherStateData%c_obj%y_Len > 0) &
      DstOtherStateData%c_obj%y = C_LOC( DstOtherStateData%y(i1_l) ) 
  END IF
    DstOtherStateData%y = SrcOtherStateData%y
ENDIF
IF (ASSOCIATED(SrcOtherStateData%z)) THEN
  i1_l = LBOUND(SrcOtherStateData%z,1)
  i1_u = UBOUND(SrcOtherStateData%z,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%z)) THEN 
    ALLOCATE(DstOtherStateData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%z.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%z_Len = SIZE(DstOtherStateData%z)
    IF (DstOtherStateData%c_obj%z_Len > 0) &
      DstOtherStateData%c_obj%z = C_LOC( DstOtherStateData%z(i1_l) ) 
  END IF
    DstOtherStateData%z = SrcOtherStateData%z
ENDIF
IF (ASSOCIATED(SrcOtherStateData%xa)) THEN
  i1_l = LBOUND(SrcOtherStateData%xa,1)
  i1_u = UBOUND(SrcOtherStateData%xa,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%xa)) THEN 
    ALLOCATE(DstOtherStateData%xa(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xa.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%xa_Len = SIZE(DstOtherStateData%xa)
    IF (DstOtherStateData%c_obj%xa_Len > 0) &
      DstOtherStateData%c_obj%xa = C_LOC( DstOtherStateData%xa(i1_l) ) 
  END IF
    DstOtherStateData%xa = SrcOtherStateData%xa
ENDIF
IF (ASSOCIATED(SrcOtherStateData%ya)) THEN
  i1_l = LBOUND(SrcOtherStateData%ya,1)
  i1_u = UBOUND(SrcOtherStateData%ya,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%ya)) THEN 
    ALLOCATE(DstOtherStateData%ya(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%ya.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%ya_Len = SIZE(DstOtherStateData%ya)
    IF (DstOtherStateData%c_obj%ya_Len > 0) &
      DstOtherStateData%c_obj%ya = C_LOC( DstOtherStateData%ya(i1_l) ) 
  END IF
    DstOtherStateData%ya = SrcOtherStateData%ya
ENDIF
IF (ASSOCIATED(SrcOtherStateData%za)) THEN
  i1_l = LBOUND(SrcOtherStateData%za,1)
  i1_u = UBOUND(SrcOtherStateData%za,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%za)) THEN 
    ALLOCATE(DstOtherStateData%za(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%za.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%za_Len = SIZE(DstOtherStateData%za)
    IF (DstOtherStateData%c_obj%za_Len > 0) &
      DstOtherStateData%c_obj%za = C_LOC( DstOtherStateData%za(i1_l) ) 
  END IF
    DstOtherStateData%za = SrcOtherStateData%za
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fx_connect)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fx_connect,1)
  i1_u = UBOUND(SrcOtherStateData%Fx_connect,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fx_connect)) THEN 
    ALLOCATE(DstOtherStateData%Fx_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fx_connect.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fx_connect_Len = SIZE(DstOtherStateData%Fx_connect)
    IF (DstOtherStateData%c_obj%Fx_connect_Len > 0) &
      DstOtherStateData%c_obj%Fx_connect = C_LOC( DstOtherStateData%Fx_connect(i1_l) ) 
  END IF
    DstOtherStateData%Fx_connect = SrcOtherStateData%Fx_connect
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fy_connect)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fy_connect,1)
  i1_u = UBOUND(SrcOtherStateData%Fy_connect,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fy_connect)) THEN 
    ALLOCATE(DstOtherStateData%Fy_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fy_connect.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fy_connect_Len = SIZE(DstOtherStateData%Fy_connect)
    IF (DstOtherStateData%c_obj%Fy_connect_Len > 0) &
      DstOtherStateData%c_obj%Fy_connect = C_LOC( DstOtherStateData%Fy_connect(i1_l) ) 
  END IF
    DstOtherStateData%Fy_connect = SrcOtherStateData%Fy_connect
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fz_connect)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fz_connect,1)
  i1_u = UBOUND(SrcOtherStateData%Fz_connect,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fz_connect)) THEN 
    ALLOCATE(DstOtherStateData%Fz_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fz_connect.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fz_connect_Len = SIZE(DstOtherStateData%Fz_connect)
    IF (DstOtherStateData%c_obj%Fz_connect_Len > 0) &
      DstOtherStateData%c_obj%Fz_connect = C_LOC( DstOtherStateData%Fz_connect(i1_l) ) 
  END IF
    DstOtherStateData%Fz_connect = SrcOtherStateData%Fz_connect
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fx_anchor)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fx_anchor,1)
  i1_u = UBOUND(SrcOtherStateData%Fx_anchor,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fx_anchor)) THEN 
    ALLOCATE(DstOtherStateData%Fx_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fx_anchor.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fx_anchor_Len = SIZE(DstOtherStateData%Fx_anchor)
    IF (DstOtherStateData%c_obj%Fx_anchor_Len > 0) &
      DstOtherStateData%c_obj%Fx_anchor = C_LOC( DstOtherStateData%Fx_anchor(i1_l) ) 
  END IF
    DstOtherStateData%Fx_anchor = SrcOtherStateData%Fx_anchor
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fy_anchor)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fy_anchor,1)
  i1_u = UBOUND(SrcOtherStateData%Fy_anchor,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fy_anchor)) THEN 
    ALLOCATE(DstOtherStateData%Fy_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fy_anchor.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fy_anchor_Len = SIZE(DstOtherStateData%Fy_anchor)
    IF (DstOtherStateData%c_obj%Fy_anchor_Len > 0) &
      DstOtherStateData%c_obj%Fy_anchor = C_LOC( DstOtherStateData%Fy_anchor(i1_l) ) 
  END IF
    DstOtherStateData%Fy_anchor = SrcOtherStateData%Fy_anchor
ENDIF
IF (ASSOCIATED(SrcOtherStateData%Fz_anchor)) THEN
  i1_l = LBOUND(SrcOtherStateData%Fz_anchor,1)
  i1_u = UBOUND(SrcOtherStateData%Fz_anchor,1)
  IF (.NOT. ASSOCIATED(DstOtherStateData%Fz_anchor)) THEN 
    ALLOCATE(DstOtherStateData%Fz_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Fz_anchor.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOtherStateData%c_obj%Fz_anchor_Len = SIZE(DstOtherStateData%Fz_anchor)
    IF (DstOtherStateData%c_obj%Fz_anchor_Len > 0) &
      DstOtherStateData%c_obj%Fz_anchor = C_LOC( DstOtherStateData%Fz_anchor(i1_l) ) 
  END IF
    DstOtherStateData%Fz_anchor = SrcOtherStateData%Fz_anchor
ENDIF
 END SUBROUTINE MAP_CopyOtherState

 SUBROUTINE MAP_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(MAP_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(OtherStateData%H)) THEN
  DEALLOCATE(OtherStateData%H)
  OtherStateData%H => NULL()
  OtherStateData%C_obj%H = C_NULL_PTR
  OtherStateData%C_obj%H_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%V)) THEN
  DEALLOCATE(OtherStateData%V)
  OtherStateData%V => NULL()
  OtherStateData%C_obj%V = C_NULL_PTR
  OtherStateData%C_obj%V_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Ha)) THEN
  DEALLOCATE(OtherStateData%Ha)
  OtherStateData%Ha => NULL()
  OtherStateData%C_obj%Ha = C_NULL_PTR
  OtherStateData%C_obj%Ha_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Va)) THEN
  DEALLOCATE(OtherStateData%Va)
  OtherStateData%Va => NULL()
  OtherStateData%C_obj%Va = C_NULL_PTR
  OtherStateData%C_obj%Va_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%x)) THEN
  DEALLOCATE(OtherStateData%x)
  OtherStateData%x => NULL()
  OtherStateData%C_obj%x = C_NULL_PTR
  OtherStateData%C_obj%x_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%y)) THEN
  DEALLOCATE(OtherStateData%y)
  OtherStateData%y => NULL()
  OtherStateData%C_obj%y = C_NULL_PTR
  OtherStateData%C_obj%y_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%z)) THEN
  DEALLOCATE(OtherStateData%z)
  OtherStateData%z => NULL()
  OtherStateData%C_obj%z = C_NULL_PTR
  OtherStateData%C_obj%z_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%xa)) THEN
  DEALLOCATE(OtherStateData%xa)
  OtherStateData%xa => NULL()
  OtherStateData%C_obj%xa = C_NULL_PTR
  OtherStateData%C_obj%xa_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%ya)) THEN
  DEALLOCATE(OtherStateData%ya)
  OtherStateData%ya => NULL()
  OtherStateData%C_obj%ya = C_NULL_PTR
  OtherStateData%C_obj%ya_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%za)) THEN
  DEALLOCATE(OtherStateData%za)
  OtherStateData%za => NULL()
  OtherStateData%C_obj%za = C_NULL_PTR
  OtherStateData%C_obj%za_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fx_connect)) THEN
  DEALLOCATE(OtherStateData%Fx_connect)
  OtherStateData%Fx_connect => NULL()
  OtherStateData%C_obj%Fx_connect = C_NULL_PTR
  OtherStateData%C_obj%Fx_connect_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fy_connect)) THEN
  DEALLOCATE(OtherStateData%Fy_connect)
  OtherStateData%Fy_connect => NULL()
  OtherStateData%C_obj%Fy_connect = C_NULL_PTR
  OtherStateData%C_obj%Fy_connect_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fz_connect)) THEN
  DEALLOCATE(OtherStateData%Fz_connect)
  OtherStateData%Fz_connect => NULL()
  OtherStateData%C_obj%Fz_connect = C_NULL_PTR
  OtherStateData%C_obj%Fz_connect_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fx_anchor)) THEN
  DEALLOCATE(OtherStateData%Fx_anchor)
  OtherStateData%Fx_anchor => NULL()
  OtherStateData%C_obj%Fx_anchor = C_NULL_PTR
  OtherStateData%C_obj%Fx_anchor_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fy_anchor)) THEN
  DEALLOCATE(OtherStateData%Fy_anchor)
  OtherStateData%Fy_anchor => NULL()
  OtherStateData%C_obj%Fy_anchor = C_NULL_PTR
  OtherStateData%C_obj%Fy_anchor_Len = 0
ENDIF
IF (ASSOCIATED(OtherStateData%Fz_anchor)) THEN
  DEALLOCATE(OtherStateData%Fz_anchor)
  OtherStateData%Fz_anchor => NULL()
  OtherStateData%C_obj%Fz_anchor = C_NULL_PTR
  OtherStateData%C_obj%Fz_anchor_Len = 0
ENDIF
 END SUBROUTINE MAP_DestroyOtherState

 SUBROUTINE MAP_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! H allocated yes/no
  IF ( ASSOCIATED(InData%H) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! H upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%H)  ! H
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! V allocated yes/no
  IF ( ASSOCIATED(InData%V) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! V upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%V)  ! V
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Ha allocated yes/no
  IF ( ASSOCIATED(InData%Ha) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Ha upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Ha)  ! Ha
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Va allocated yes/no
  IF ( ASSOCIATED(InData%Va) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Va upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Va)  ! Va
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! x allocated yes/no
  IF ( ASSOCIATED(InData%x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! x upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%x)  ! x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! y allocated yes/no
  IF ( ASSOCIATED(InData%y) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! y upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%y)  ! y
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! z allocated yes/no
  IF ( ASSOCIATED(InData%z) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! z upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%z)  ! z
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! xa allocated yes/no
  IF ( ASSOCIATED(InData%xa) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! xa upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%xa)  ! xa
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ya allocated yes/no
  IF ( ASSOCIATED(InData%ya) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ya upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%ya)  ! ya
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! za allocated yes/no
  IF ( ASSOCIATED(InData%za) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! za upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%za)  ! za
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fx_connect allocated yes/no
  IF ( ASSOCIATED(InData%Fx_connect) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fx_connect upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fx_connect)  ! Fx_connect
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fy_connect allocated yes/no
  IF ( ASSOCIATED(InData%Fy_connect) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fy_connect upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fy_connect)  ! Fy_connect
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fz_connect allocated yes/no
  IF ( ASSOCIATED(InData%Fz_connect) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fz_connect upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fz_connect)  ! Fz_connect
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fx_anchor allocated yes/no
  IF ( ASSOCIATED(InData%Fx_anchor) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fx_anchor upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fx_anchor)  ! Fx_anchor
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fy_anchor allocated yes/no
  IF ( ASSOCIATED(InData%Fy_anchor) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fy_anchor upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fy_anchor)  ! Fy_anchor
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fz_anchor allocated yes/no
  IF ( ASSOCIATED(InData%Fz_anchor) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fz_anchor upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fz_anchor)  ! Fz_anchor
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%H) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%H,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%H,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%H,1), UBOUND(InData%H,1)
        DbKiBuf(Db_Xferred) = InData%H(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%V) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%V,1), UBOUND(InData%V,1)
        DbKiBuf(Db_Xferred) = InData%V(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Ha) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Ha,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Ha,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Ha,1), UBOUND(InData%Ha,1)
        DbKiBuf(Db_Xferred) = InData%Ha(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Va) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Va,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Va,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Va,1), UBOUND(InData%Va,1)
        DbKiBuf(Db_Xferred) = InData%Va(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%x,1), UBOUND(InData%x,1)
        DbKiBuf(Db_Xferred) = InData%x(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%y) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%y,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%y,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%y,1), UBOUND(InData%y,1)
        DbKiBuf(Db_Xferred) = InData%y(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%z) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%z,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%z,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%z,1), UBOUND(InData%z,1)
        DbKiBuf(Db_Xferred) = InData%z(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%xa) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xa,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xa,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%xa,1), UBOUND(InData%xa,1)
        DbKiBuf(Db_Xferred) = InData%xa(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%ya) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ya,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ya,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ya,1), UBOUND(InData%ya,1)
        DbKiBuf(Db_Xferred) = InData%ya(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%za) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%za,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%za,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%za,1), UBOUND(InData%za,1)
        DbKiBuf(Db_Xferred) = InData%za(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fx_connect) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fx_connect,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fx_connect,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fx_connect,1), UBOUND(InData%Fx_connect,1)
        DbKiBuf(Db_Xferred) = InData%Fx_connect(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fy_connect) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fy_connect,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fy_connect,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fy_connect,1), UBOUND(InData%Fy_connect,1)
        DbKiBuf(Db_Xferred) = InData%Fy_connect(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fz_connect) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fz_connect,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fz_connect,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fz_connect,1), UBOUND(InData%Fz_connect,1)
        DbKiBuf(Db_Xferred) = InData%Fz_connect(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fx_anchor) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fx_anchor,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fx_anchor,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fx_anchor,1), UBOUND(InData%Fx_anchor,1)
        DbKiBuf(Db_Xferred) = InData%Fx_anchor(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fy_anchor) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fy_anchor,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fy_anchor,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fy_anchor,1), UBOUND(InData%Fy_anchor,1)
        DbKiBuf(Db_Xferred) = InData%Fy_anchor(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fz_anchor) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fz_anchor,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fz_anchor,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fz_anchor,1), UBOUND(InData%Fz_anchor,1)
        DbKiBuf(Db_Xferred) = InData%Fz_anchor(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE MAP_PackOtherState

 SUBROUTINE MAP_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! H not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%H)) DEALLOCATE(OutData%H)
    ALLOCATE(OutData%H(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%H.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%H_Len = SIZE(OutData%H)
    IF (OutData%c_obj%H_Len > 0) &
       OutData%c_obj%H = C_LOC( OutData%H(i1_l) ) 
      DO i1 = LBOUND(OutData%H,1), UBOUND(OutData%H,1)
        OutData%H(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%V)) DEALLOCATE(OutData%V)
    ALLOCATE(OutData%V(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%V_Len = SIZE(OutData%V)
    IF (OutData%c_obj%V_Len > 0) &
       OutData%c_obj%V = C_LOC( OutData%V(i1_l) ) 
      DO i1 = LBOUND(OutData%V,1), UBOUND(OutData%V,1)
        OutData%V(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Ha not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Ha)) DEALLOCATE(OutData%Ha)
    ALLOCATE(OutData%Ha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Ha.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Ha_Len = SIZE(OutData%Ha)
    IF (OutData%c_obj%Ha_Len > 0) &
       OutData%c_obj%Ha = C_LOC( OutData%Ha(i1_l) ) 
      DO i1 = LBOUND(OutData%Ha,1), UBOUND(OutData%Ha,1)
        OutData%Ha(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Va not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Va)) DEALLOCATE(OutData%Va)
    ALLOCATE(OutData%Va(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Va.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Va_Len = SIZE(OutData%Va)
    IF (OutData%c_obj%Va_Len > 0) &
       OutData%c_obj%Va = C_LOC( OutData%Va(i1_l) ) 
      DO i1 = LBOUND(OutData%Va,1), UBOUND(OutData%Va,1)
        OutData%Va(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%x)) DEALLOCATE(OutData%x)
    ALLOCATE(OutData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%x_Len = SIZE(OutData%x)
    IF (OutData%c_obj%x_Len > 0) &
       OutData%c_obj%x = C_LOC( OutData%x(i1_l) ) 
      DO i1 = LBOUND(OutData%x,1), UBOUND(OutData%x,1)
        OutData%x(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! y not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%y)) DEALLOCATE(OutData%y)
    ALLOCATE(OutData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%y.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%y_Len = SIZE(OutData%y)
    IF (OutData%c_obj%y_Len > 0) &
       OutData%c_obj%y = C_LOC( OutData%y(i1_l) ) 
      DO i1 = LBOUND(OutData%y,1), UBOUND(OutData%y,1)
        OutData%y(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! z not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%z)) DEALLOCATE(OutData%z)
    ALLOCATE(OutData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%z_Len = SIZE(OutData%z)
    IF (OutData%c_obj%z_Len > 0) &
       OutData%c_obj%z = C_LOC( OutData%z(i1_l) ) 
      DO i1 = LBOUND(OutData%z,1), UBOUND(OutData%z,1)
        OutData%z(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xa not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%xa)) DEALLOCATE(OutData%xa)
    ALLOCATE(OutData%xa(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xa.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%xa_Len = SIZE(OutData%xa)
    IF (OutData%c_obj%xa_Len > 0) &
       OutData%c_obj%xa = C_LOC( OutData%xa(i1_l) ) 
      DO i1 = LBOUND(OutData%xa,1), UBOUND(OutData%xa,1)
        OutData%xa(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ya not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%ya)) DEALLOCATE(OutData%ya)
    ALLOCATE(OutData%ya(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ya.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%ya_Len = SIZE(OutData%ya)
    IF (OutData%c_obj%ya_Len > 0) &
       OutData%c_obj%ya = C_LOC( OutData%ya(i1_l) ) 
      DO i1 = LBOUND(OutData%ya,1), UBOUND(OutData%ya,1)
        OutData%ya(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! za not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%za)) DEALLOCATE(OutData%za)
    ALLOCATE(OutData%za(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%za.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%za_Len = SIZE(OutData%za)
    IF (OutData%c_obj%za_Len > 0) &
       OutData%c_obj%za = C_LOC( OutData%za(i1_l) ) 
      DO i1 = LBOUND(OutData%za,1), UBOUND(OutData%za,1)
        OutData%za(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fx_connect not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fx_connect)) DEALLOCATE(OutData%Fx_connect)
    ALLOCATE(OutData%Fx_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fx_connect.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fx_connect_Len = SIZE(OutData%Fx_connect)
    IF (OutData%c_obj%Fx_connect_Len > 0) &
       OutData%c_obj%Fx_connect = C_LOC( OutData%Fx_connect(i1_l) ) 
      DO i1 = LBOUND(OutData%Fx_connect,1), UBOUND(OutData%Fx_connect,1)
        OutData%Fx_connect(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fy_connect not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fy_connect)) DEALLOCATE(OutData%Fy_connect)
    ALLOCATE(OutData%Fy_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fy_connect.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fy_connect_Len = SIZE(OutData%Fy_connect)
    IF (OutData%c_obj%Fy_connect_Len > 0) &
       OutData%c_obj%Fy_connect = C_LOC( OutData%Fy_connect(i1_l) ) 
      DO i1 = LBOUND(OutData%Fy_connect,1), UBOUND(OutData%Fy_connect,1)
        OutData%Fy_connect(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fz_connect not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fz_connect)) DEALLOCATE(OutData%Fz_connect)
    ALLOCATE(OutData%Fz_connect(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fz_connect.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fz_connect_Len = SIZE(OutData%Fz_connect)
    IF (OutData%c_obj%Fz_connect_Len > 0) &
       OutData%c_obj%Fz_connect = C_LOC( OutData%Fz_connect(i1_l) ) 
      DO i1 = LBOUND(OutData%Fz_connect,1), UBOUND(OutData%Fz_connect,1)
        OutData%Fz_connect(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fx_anchor not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fx_anchor)) DEALLOCATE(OutData%Fx_anchor)
    ALLOCATE(OutData%Fx_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fx_anchor.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fx_anchor_Len = SIZE(OutData%Fx_anchor)
    IF (OutData%c_obj%Fx_anchor_Len > 0) &
       OutData%c_obj%Fx_anchor = C_LOC( OutData%Fx_anchor(i1_l) ) 
      DO i1 = LBOUND(OutData%Fx_anchor,1), UBOUND(OutData%Fx_anchor,1)
        OutData%Fx_anchor(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fy_anchor not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fy_anchor)) DEALLOCATE(OutData%Fy_anchor)
    ALLOCATE(OutData%Fy_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fy_anchor.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fy_anchor_Len = SIZE(OutData%Fy_anchor)
    IF (OutData%c_obj%Fy_anchor_Len > 0) &
       OutData%c_obj%Fy_anchor = C_LOC( OutData%Fy_anchor(i1_l) ) 
      DO i1 = LBOUND(OutData%Fy_anchor,1), UBOUND(OutData%Fy_anchor,1)
        OutData%Fy_anchor(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fz_anchor not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fz_anchor)) DEALLOCATE(OutData%Fz_anchor)
    ALLOCATE(OutData%Fz_anchor(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fz_anchor.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fz_anchor_Len = SIZE(OutData%Fz_anchor)
    IF (OutData%c_obj%Fz_anchor_Len > 0) &
       OutData%c_obj%Fz_anchor = C_LOC( OutData%Fz_anchor(i1_l) ) 
      DO i1 = LBOUND(OutData%Fz_anchor,1), UBOUND(OutData%Fz_anchor,1)
        OutData%Fz_anchor(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE MAP_UnPackOtherState

 SUBROUTINE MAP_C2Fary_CopyOtherState( OtherStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_OtherStateType), INTENT(INOUT) :: OtherStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- H OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%H ) ) THEN
          NULLIFY( OtherStateData%H )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%H, OtherStateData%H, (/OtherStateData%C_obj%H_Len/))
       END IF
    END IF

    ! -- V OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%V ) ) THEN
          NULLIFY( OtherStateData%V )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%V, OtherStateData%V, (/OtherStateData%C_obj%V_Len/))
       END IF
    END IF

    ! -- Ha OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Ha ) ) THEN
          NULLIFY( OtherStateData%Ha )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Ha, OtherStateData%Ha, (/OtherStateData%C_obj%Ha_Len/))
       END IF
    END IF

    ! -- Va OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Va ) ) THEN
          NULLIFY( OtherStateData%Va )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Va, OtherStateData%Va, (/OtherStateData%C_obj%Va_Len/))
       END IF
    END IF

    ! -- x OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%x ) ) THEN
          NULLIFY( OtherStateData%x )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%x, OtherStateData%x, (/OtherStateData%C_obj%x_Len/))
       END IF
    END IF

    ! -- y OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%y ) ) THEN
          NULLIFY( OtherStateData%y )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%y, OtherStateData%y, (/OtherStateData%C_obj%y_Len/))
       END IF
    END IF

    ! -- z OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%z ) ) THEN
          NULLIFY( OtherStateData%z )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%z, OtherStateData%z, (/OtherStateData%C_obj%z_Len/))
       END IF
    END IF

    ! -- xa OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%xa ) ) THEN
          NULLIFY( OtherStateData%xa )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%xa, OtherStateData%xa, (/OtherStateData%C_obj%xa_Len/))
       END IF
    END IF

    ! -- ya OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%ya ) ) THEN
          NULLIFY( OtherStateData%ya )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%ya, OtherStateData%ya, (/OtherStateData%C_obj%ya_Len/))
       END IF
    END IF

    ! -- za OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%za ) ) THEN
          NULLIFY( OtherStateData%za )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%za, OtherStateData%za, (/OtherStateData%C_obj%za_Len/))
       END IF
    END IF

    ! -- Fx_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fx_connect ) ) THEN
          NULLIFY( OtherStateData%Fx_connect )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fx_connect, OtherStateData%Fx_connect, (/OtherStateData%C_obj%Fx_connect_Len/))
       END IF
    END IF

    ! -- Fy_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fy_connect ) ) THEN
          NULLIFY( OtherStateData%Fy_connect )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fy_connect, OtherStateData%Fy_connect, (/OtherStateData%C_obj%Fy_connect_Len/))
       END IF
    END IF

    ! -- Fz_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fz_connect ) ) THEN
          NULLIFY( OtherStateData%Fz_connect )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fz_connect, OtherStateData%Fz_connect, (/OtherStateData%C_obj%Fz_connect_Len/))
       END IF
    END IF

    ! -- Fx_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fx_anchor ) ) THEN
          NULLIFY( OtherStateData%Fx_anchor )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fx_anchor, OtherStateData%Fx_anchor, (/OtherStateData%C_obj%Fx_anchor_Len/))
       END IF
    END IF

    ! -- Fy_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fy_anchor ) ) THEN
          NULLIFY( OtherStateData%Fy_anchor )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fy_anchor, OtherStateData%Fy_anchor, (/OtherStateData%C_obj%Fy_anchor_Len/))
       END IF
    END IF

    ! -- Fz_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OtherStateData%C_obj%Fz_anchor ) ) THEN
          NULLIFY( OtherStateData%Fz_anchor )
       ELSE
          CALL C_F_POINTER(OtherStateData%C_obj%Fz_anchor, OtherStateData%Fz_anchor, (/OtherStateData%C_obj%Fz_anchor_Len/))
       END IF
    END IF
 END SUBROUTINE MAP_C2Fary_CopyOtherState

 SUBROUTINE MAP_F2C_CopyOtherState( OtherStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_OtherStateType), INTENT(INOUT) :: OtherStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- H OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%H)) THEN 
          OtherStateData%c_obj%H_Len = 0
          OtherStateData%c_obj%H = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%H_Len = SIZE(OtherStateData%H)
          IF (OtherStateData%c_obj%H_Len > 0) &
             OtherStateData%c_obj%H = C_LOC( OtherStateData%H( LBOUND(OtherStateData%H,1) ) ) 
       END IF
    END IF

    ! -- V OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%V)) THEN 
          OtherStateData%c_obj%V_Len = 0
          OtherStateData%c_obj%V = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%V_Len = SIZE(OtherStateData%V)
          IF (OtherStateData%c_obj%V_Len > 0) &
             OtherStateData%c_obj%V = C_LOC( OtherStateData%V( LBOUND(OtherStateData%V,1) ) ) 
       END IF
    END IF

    ! -- Ha OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Ha)) THEN 
          OtherStateData%c_obj%Ha_Len = 0
          OtherStateData%c_obj%Ha = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Ha_Len = SIZE(OtherStateData%Ha)
          IF (OtherStateData%c_obj%Ha_Len > 0) &
             OtherStateData%c_obj%Ha = C_LOC( OtherStateData%Ha( LBOUND(OtherStateData%Ha,1) ) ) 
       END IF
    END IF

    ! -- Va OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Va)) THEN 
          OtherStateData%c_obj%Va_Len = 0
          OtherStateData%c_obj%Va = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Va_Len = SIZE(OtherStateData%Va)
          IF (OtherStateData%c_obj%Va_Len > 0) &
             OtherStateData%c_obj%Va = C_LOC( OtherStateData%Va( LBOUND(OtherStateData%Va,1) ) ) 
       END IF
    END IF

    ! -- x OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%x)) THEN 
          OtherStateData%c_obj%x_Len = 0
          OtherStateData%c_obj%x = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%x_Len = SIZE(OtherStateData%x)
          IF (OtherStateData%c_obj%x_Len > 0) &
             OtherStateData%c_obj%x = C_LOC( OtherStateData%x( LBOUND(OtherStateData%x,1) ) ) 
       END IF
    END IF

    ! -- y OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%y)) THEN 
          OtherStateData%c_obj%y_Len = 0
          OtherStateData%c_obj%y = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%y_Len = SIZE(OtherStateData%y)
          IF (OtherStateData%c_obj%y_Len > 0) &
             OtherStateData%c_obj%y = C_LOC( OtherStateData%y( LBOUND(OtherStateData%y,1) ) ) 
       END IF
    END IF

    ! -- z OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%z)) THEN 
          OtherStateData%c_obj%z_Len = 0
          OtherStateData%c_obj%z = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%z_Len = SIZE(OtherStateData%z)
          IF (OtherStateData%c_obj%z_Len > 0) &
             OtherStateData%c_obj%z = C_LOC( OtherStateData%z( LBOUND(OtherStateData%z,1) ) ) 
       END IF
    END IF

    ! -- xa OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%xa)) THEN 
          OtherStateData%c_obj%xa_Len = 0
          OtherStateData%c_obj%xa = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%xa_Len = SIZE(OtherStateData%xa)
          IF (OtherStateData%c_obj%xa_Len > 0) &
             OtherStateData%c_obj%xa = C_LOC( OtherStateData%xa( LBOUND(OtherStateData%xa,1) ) ) 
       END IF
    END IF

    ! -- ya OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%ya)) THEN 
          OtherStateData%c_obj%ya_Len = 0
          OtherStateData%c_obj%ya = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%ya_Len = SIZE(OtherStateData%ya)
          IF (OtherStateData%c_obj%ya_Len > 0) &
             OtherStateData%c_obj%ya = C_LOC( OtherStateData%ya( LBOUND(OtherStateData%ya,1) ) ) 
       END IF
    END IF

    ! -- za OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%za)) THEN 
          OtherStateData%c_obj%za_Len = 0
          OtherStateData%c_obj%za = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%za_Len = SIZE(OtherStateData%za)
          IF (OtherStateData%c_obj%za_Len > 0) &
             OtherStateData%c_obj%za = C_LOC( OtherStateData%za( LBOUND(OtherStateData%za,1) ) ) 
       END IF
    END IF

    ! -- Fx_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fx_connect)) THEN 
          OtherStateData%c_obj%Fx_connect_Len = 0
          OtherStateData%c_obj%Fx_connect = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fx_connect_Len = SIZE(OtherStateData%Fx_connect)
          IF (OtherStateData%c_obj%Fx_connect_Len > 0) &
             OtherStateData%c_obj%Fx_connect = C_LOC( OtherStateData%Fx_connect( LBOUND(OtherStateData%Fx_connect,1) ) ) 
       END IF
    END IF

    ! -- Fy_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fy_connect)) THEN 
          OtherStateData%c_obj%Fy_connect_Len = 0
          OtherStateData%c_obj%Fy_connect = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fy_connect_Len = SIZE(OtherStateData%Fy_connect)
          IF (OtherStateData%c_obj%Fy_connect_Len > 0) &
             OtherStateData%c_obj%Fy_connect = C_LOC( OtherStateData%Fy_connect( LBOUND(OtherStateData%Fy_connect,1) ) ) 
       END IF
    END IF

    ! -- Fz_connect OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fz_connect)) THEN 
          OtherStateData%c_obj%Fz_connect_Len = 0
          OtherStateData%c_obj%Fz_connect = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fz_connect_Len = SIZE(OtherStateData%Fz_connect)
          IF (OtherStateData%c_obj%Fz_connect_Len > 0) &
             OtherStateData%c_obj%Fz_connect = C_LOC( OtherStateData%Fz_connect( LBOUND(OtherStateData%Fz_connect,1) ) ) 
       END IF
    END IF

    ! -- Fx_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fx_anchor)) THEN 
          OtherStateData%c_obj%Fx_anchor_Len = 0
          OtherStateData%c_obj%Fx_anchor = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fx_anchor_Len = SIZE(OtherStateData%Fx_anchor)
          IF (OtherStateData%c_obj%Fx_anchor_Len > 0) &
             OtherStateData%c_obj%Fx_anchor = C_LOC( OtherStateData%Fx_anchor( LBOUND(OtherStateData%Fx_anchor,1) ) ) 
       END IF
    END IF

    ! -- Fy_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fy_anchor)) THEN 
          OtherStateData%c_obj%Fy_anchor_Len = 0
          OtherStateData%c_obj%Fy_anchor = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fy_anchor_Len = SIZE(OtherStateData%Fy_anchor)
          IF (OtherStateData%c_obj%Fy_anchor_Len > 0) &
             OtherStateData%c_obj%Fy_anchor = C_LOC( OtherStateData%Fy_anchor( LBOUND(OtherStateData%Fy_anchor,1) ) ) 
       END IF
    END IF

    ! -- Fz_anchor OtherState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OtherStateData%Fz_anchor)) THEN 
          OtherStateData%c_obj%Fz_anchor_Len = 0
          OtherStateData%c_obj%Fz_anchor = C_NULL_PTR
       ELSE
          OtherStateData%c_obj%Fz_anchor_Len = SIZE(OtherStateData%Fz_anchor)
          IF (OtherStateData%c_obj%Fz_anchor_Len > 0) &
             OtherStateData%c_obj%Fz_anchor = C_LOC( OtherStateData%Fz_anchor( LBOUND(OtherStateData%Fz_anchor,1) ) ) 
       END IF
    END IF
 END SUBROUTINE MAP_F2C_CopyOtherState

 SUBROUTINE MAP_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcConstrStateData%H)) THEN
  i1_l = LBOUND(SrcConstrStateData%H,1)
  i1_u = UBOUND(SrcConstrStateData%H,1)
  IF (.NOT. ASSOCIATED(DstConstrStateData%H)) THEN 
    ALLOCATE(DstConstrStateData%H(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%H.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstConstrStateData%c_obj%H_Len = SIZE(DstConstrStateData%H)
    IF (DstConstrStateData%c_obj%H_Len > 0) &
      DstConstrStateData%c_obj%H = C_LOC( DstConstrStateData%H(i1_l) ) 
  END IF
    DstConstrStateData%H = SrcConstrStateData%H
ENDIF
IF (ASSOCIATED(SrcConstrStateData%V)) THEN
  i1_l = LBOUND(SrcConstrStateData%V,1)
  i1_u = UBOUND(SrcConstrStateData%V,1)
  IF (.NOT. ASSOCIATED(DstConstrStateData%V)) THEN 
    ALLOCATE(DstConstrStateData%V(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%V.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstConstrStateData%c_obj%V_Len = SIZE(DstConstrStateData%V)
    IF (DstConstrStateData%c_obj%V_Len > 0) &
      DstConstrStateData%c_obj%V = C_LOC( DstConstrStateData%V(i1_l) ) 
  END IF
    DstConstrStateData%V = SrcConstrStateData%V
ENDIF
IF (ASSOCIATED(SrcConstrStateData%x)) THEN
  i1_l = LBOUND(SrcConstrStateData%x,1)
  i1_u = UBOUND(SrcConstrStateData%x,1)
  IF (.NOT. ASSOCIATED(DstConstrStateData%x)) THEN 
    ALLOCATE(DstConstrStateData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstConstrStateData%c_obj%x_Len = SIZE(DstConstrStateData%x)
    IF (DstConstrStateData%c_obj%x_Len > 0) &
      DstConstrStateData%c_obj%x = C_LOC( DstConstrStateData%x(i1_l) ) 
  END IF
    DstConstrStateData%x = SrcConstrStateData%x
ENDIF
IF (ASSOCIATED(SrcConstrStateData%y)) THEN
  i1_l = LBOUND(SrcConstrStateData%y,1)
  i1_u = UBOUND(SrcConstrStateData%y,1)
  IF (.NOT. ASSOCIATED(DstConstrStateData%y)) THEN 
    ALLOCATE(DstConstrStateData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%y.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstConstrStateData%c_obj%y_Len = SIZE(DstConstrStateData%y)
    IF (DstConstrStateData%c_obj%y_Len > 0) &
      DstConstrStateData%c_obj%y = C_LOC( DstConstrStateData%y(i1_l) ) 
  END IF
    DstConstrStateData%y = SrcConstrStateData%y
ENDIF
IF (ASSOCIATED(SrcConstrStateData%z)) THEN
  i1_l = LBOUND(SrcConstrStateData%z,1)
  i1_u = UBOUND(SrcConstrStateData%z,1)
  IF (.NOT. ASSOCIATED(DstConstrStateData%z)) THEN 
    ALLOCATE(DstConstrStateData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%z.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstConstrStateData%c_obj%z_Len = SIZE(DstConstrStateData%z)
    IF (DstConstrStateData%c_obj%z_Len > 0) &
      DstConstrStateData%c_obj%z = C_LOC( DstConstrStateData%z(i1_l) ) 
  END IF
    DstConstrStateData%z = SrcConstrStateData%z
ENDIF
 END SUBROUTINE MAP_CopyConstrState

 SUBROUTINE MAP_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(ConstrStateData%H)) THEN
  DEALLOCATE(ConstrStateData%H)
  ConstrStateData%H => NULL()
  ConstrStateData%C_obj%H = C_NULL_PTR
  ConstrStateData%C_obj%H_Len = 0
ENDIF
IF (ASSOCIATED(ConstrStateData%V)) THEN
  DEALLOCATE(ConstrStateData%V)
  ConstrStateData%V => NULL()
  ConstrStateData%C_obj%V = C_NULL_PTR
  ConstrStateData%C_obj%V_Len = 0
ENDIF
IF (ASSOCIATED(ConstrStateData%x)) THEN
  DEALLOCATE(ConstrStateData%x)
  ConstrStateData%x => NULL()
  ConstrStateData%C_obj%x = C_NULL_PTR
  ConstrStateData%C_obj%x_Len = 0
ENDIF
IF (ASSOCIATED(ConstrStateData%y)) THEN
  DEALLOCATE(ConstrStateData%y)
  ConstrStateData%y => NULL()
  ConstrStateData%C_obj%y = C_NULL_PTR
  ConstrStateData%C_obj%y_Len = 0
ENDIF
IF (ASSOCIATED(ConstrStateData%z)) THEN
  DEALLOCATE(ConstrStateData%z)
  ConstrStateData%z => NULL()
  ConstrStateData%C_obj%z = C_NULL_PTR
  ConstrStateData%C_obj%z_Len = 0
ENDIF
 END SUBROUTINE MAP_DestroyConstrState

 SUBROUTINE MAP_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! H allocated yes/no
  IF ( ASSOCIATED(InData%H) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! H upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%H)  ! H
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! V allocated yes/no
  IF ( ASSOCIATED(InData%V) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! V upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%V)  ! V
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! x allocated yes/no
  IF ( ASSOCIATED(InData%x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! x upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%x)  ! x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! y allocated yes/no
  IF ( ASSOCIATED(InData%y) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! y upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%y)  ! y
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! z allocated yes/no
  IF ( ASSOCIATED(InData%z) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! z upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%z)  ! z
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%H) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%H,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%H,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%H,1), UBOUND(InData%H,1)
        DbKiBuf(Db_Xferred) = InData%H(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%V) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%V,1), UBOUND(InData%V,1)
        DbKiBuf(Db_Xferred) = InData%V(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%x,1), UBOUND(InData%x,1)
        DbKiBuf(Db_Xferred) = InData%x(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%y) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%y,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%y,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%y,1), UBOUND(InData%y,1)
        DbKiBuf(Db_Xferred) = InData%y(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%z) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%z,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%z,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%z,1), UBOUND(InData%z,1)
        DbKiBuf(Db_Xferred) = InData%z(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE MAP_PackConstrState

 SUBROUTINE MAP_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! H not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%H)) DEALLOCATE(OutData%H)
    ALLOCATE(OutData%H(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%H.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%H_Len = SIZE(OutData%H)
    IF (OutData%c_obj%H_Len > 0) &
       OutData%c_obj%H = C_LOC( OutData%H(i1_l) ) 
      DO i1 = LBOUND(OutData%H,1), UBOUND(OutData%H,1)
        OutData%H(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%V)) DEALLOCATE(OutData%V)
    ALLOCATE(OutData%V(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%V_Len = SIZE(OutData%V)
    IF (OutData%c_obj%V_Len > 0) &
       OutData%c_obj%V = C_LOC( OutData%V(i1_l) ) 
      DO i1 = LBOUND(OutData%V,1), UBOUND(OutData%V,1)
        OutData%V(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%x)) DEALLOCATE(OutData%x)
    ALLOCATE(OutData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%x_Len = SIZE(OutData%x)
    IF (OutData%c_obj%x_Len > 0) &
       OutData%c_obj%x = C_LOC( OutData%x(i1_l) ) 
      DO i1 = LBOUND(OutData%x,1), UBOUND(OutData%x,1)
        OutData%x(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! y not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%y)) DEALLOCATE(OutData%y)
    ALLOCATE(OutData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%y.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%y_Len = SIZE(OutData%y)
    IF (OutData%c_obj%y_Len > 0) &
       OutData%c_obj%y = C_LOC( OutData%y(i1_l) ) 
      DO i1 = LBOUND(OutData%y,1), UBOUND(OutData%y,1)
        OutData%y(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! z not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%z)) DEALLOCATE(OutData%z)
    ALLOCATE(OutData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%z_Len = SIZE(OutData%z)
    IF (OutData%c_obj%z_Len > 0) &
       OutData%c_obj%z = C_LOC( OutData%z(i1_l) ) 
      DO i1 = LBOUND(OutData%z,1), UBOUND(OutData%z,1)
        OutData%z(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE MAP_UnPackConstrState

 SUBROUTINE MAP_C2Fary_CopyConstrState( ConstrStateData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- H ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%H ) ) THEN
          NULLIFY( ConstrStateData%H )
       ELSE
          CALL C_F_POINTER(ConstrStateData%C_obj%H, ConstrStateData%H, (/ConstrStateData%C_obj%H_Len/))
       END IF
    END IF

    ! -- V ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%V ) ) THEN
          NULLIFY( ConstrStateData%V )
       ELSE
          CALL C_F_POINTER(ConstrStateData%C_obj%V, ConstrStateData%V, (/ConstrStateData%C_obj%V_Len/))
       END IF
    END IF

    ! -- x ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%x ) ) THEN
          NULLIFY( ConstrStateData%x )
       ELSE
          CALL C_F_POINTER(ConstrStateData%C_obj%x, ConstrStateData%x, (/ConstrStateData%C_obj%x_Len/))
       END IF
    END IF

    ! -- y ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%y ) ) THEN
          NULLIFY( ConstrStateData%y )
       ELSE
          CALL C_F_POINTER(ConstrStateData%C_obj%y, ConstrStateData%y, (/ConstrStateData%C_obj%y_Len/))
       END IF
    END IF

    ! -- z ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( ConstrStateData%C_obj%z ) ) THEN
          NULLIFY( ConstrStateData%z )
       ELSE
          CALL C_F_POINTER(ConstrStateData%C_obj%z, ConstrStateData%z, (/ConstrStateData%C_obj%z_Len/))
       END IF
    END IF
 END SUBROUTINE MAP_C2Fary_CopyConstrState

 SUBROUTINE MAP_F2C_CopyConstrState( ConstrStateData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- H ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ConstrStateData%H)) THEN 
          ConstrStateData%c_obj%H_Len = 0
          ConstrStateData%c_obj%H = C_NULL_PTR
       ELSE
          ConstrStateData%c_obj%H_Len = SIZE(ConstrStateData%H)
          IF (ConstrStateData%c_obj%H_Len > 0) &
             ConstrStateData%c_obj%H = C_LOC( ConstrStateData%H( LBOUND(ConstrStateData%H,1) ) ) 
       END IF
    END IF

    ! -- V ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ConstrStateData%V)) THEN 
          ConstrStateData%c_obj%V_Len = 0
          ConstrStateData%c_obj%V = C_NULL_PTR
       ELSE
          ConstrStateData%c_obj%V_Len = SIZE(ConstrStateData%V)
          IF (ConstrStateData%c_obj%V_Len > 0) &
             ConstrStateData%c_obj%V = C_LOC( ConstrStateData%V( LBOUND(ConstrStateData%V,1) ) ) 
       END IF
    END IF

    ! -- x ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ConstrStateData%x)) THEN 
          ConstrStateData%c_obj%x_Len = 0
          ConstrStateData%c_obj%x = C_NULL_PTR
       ELSE
          ConstrStateData%c_obj%x_Len = SIZE(ConstrStateData%x)
          IF (ConstrStateData%c_obj%x_Len > 0) &
             ConstrStateData%c_obj%x = C_LOC( ConstrStateData%x( LBOUND(ConstrStateData%x,1) ) ) 
       END IF
    END IF

    ! -- y ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ConstrStateData%y)) THEN 
          ConstrStateData%c_obj%y_Len = 0
          ConstrStateData%c_obj%y = C_NULL_PTR
       ELSE
          ConstrStateData%c_obj%y_Len = SIZE(ConstrStateData%y)
          IF (ConstrStateData%c_obj%y_Len > 0) &
             ConstrStateData%c_obj%y = C_LOC( ConstrStateData%y( LBOUND(ConstrStateData%y,1) ) ) 
       END IF
    END IF

    ! -- z ConstrState Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(ConstrStateData%z)) THEN 
          ConstrStateData%c_obj%z_Len = 0
          ConstrStateData%c_obj%z = C_NULL_PTR
       ELSE
          ConstrStateData%c_obj%z_Len = SIZE(ConstrStateData%z)
          IF (ConstrStateData%c_obj%z_Len > 0) &
             ConstrStateData%c_obj%z = C_LOC( ConstrStateData%z( LBOUND(ConstrStateData%z,1) ) ) 
       END IF
    END IF
 END SUBROUTINE MAP_F2C_CopyConstrState

 SUBROUTINE MAP_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(MAP_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%g = SrcParamData%g
    DstParamData%C_obj%g = SrcParamData%C_obj%g
    DstParamData%depth = SrcParamData%depth
    DstParamData%C_obj%depth = SrcParamData%C_obj%depth
    DstParamData%rho_sea = SrcParamData%rho_sea
    DstParamData%C_obj%rho_sea = SrcParamData%C_obj%rho_sea
    DstParamData%dt = SrcParamData%dt
    DstParamData%C_obj%dt = SrcParamData%C_obj%dt
    DstParamData%InputLines = SrcParamData%InputLines
    DstParamData%InputLineType = SrcParamData%InputLineType
    DstParamData%numOuts = SrcParamData%numOuts
    DstParamData%C_obj%numOuts = SrcParamData%C_obj%numOuts
      CALL MAP_Fortran_Copylin_paramtype( SrcParamData%LinParams, DstParamData%LinParams, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE MAP_CopyParam

 SUBROUTINE MAP_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(MAP_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MAP_Fortran_Destroylin_paramtype( ParamData%LinParams, ErrStat, ErrMsg )
 END SUBROUTINE MAP_DestroyParam

 SUBROUTINE MAP_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! g
      Db_BufSz   = Db_BufSz   + 1  ! depth
      Db_BufSz   = Db_BufSz   + 1  ! rho_sea
      Db_BufSz   = Db_BufSz   + 1  ! dt
      Int_BufSz  = Int_BufSz  + SIZE(InData%InputLines)*LEN(InData%InputLines)  ! InputLines
      Int_BufSz  = Int_BufSz  + SIZE(InData%InputLineType)*LEN(InData%InputLineType)  ! InputLineType
      Int_BufSz  = Int_BufSz  + 1  ! numOuts
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! LinParams: size of buffers for each call to pack subtype
      CALL MAP_Fortran_Packlin_paramtype( Re_Buf, Db_Buf, Int_Buf, InData%LinParams, ErrStat2, ErrMsg2, .TRUE. ) ! LinParams 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! LinParams
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! LinParams
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! LinParams
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%g
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%depth
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%rho_sea
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%dt
    Db_Xferred = Db_Xferred + 1
    DO i1 = LBOUND(InData%InputLines,1), UBOUND(InData%InputLines,1)
      DO I = 1, LEN(InData%InputLines)
        IntKiBuf(Int_Xferred) = ICHAR(InData%InputLines(i1)(I:I), IntKi)
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
    DO i1 = LBOUND(InData%InputLineType,1), UBOUND(InData%InputLineType,1)
      DO I = 1, LEN(InData%InputLineType)
        IntKiBuf(Int_Xferred) = ICHAR(InData%InputLineType(i1)(I:I), IntKi)
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
    IntKiBuf(Int_Xferred) = InData%numOuts
    Int_Xferred = Int_Xferred + 1
      CALL MAP_Fortran_Packlin_paramtype( Re_Buf, Db_Buf, Int_Buf, InData%LinParams, ErrStat2, ErrMsg2, OnlySize ) ! LinParams 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE MAP_PackParam

 SUBROUTINE MAP_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%g = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%g = OutData%g
    OutData%depth = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%depth = OutData%depth
    OutData%rho_sea = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%rho_sea = OutData%rho_sea
    OutData%dt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
      OutData%C_obj%dt = OutData%dt
    i1_l = LBOUND(OutData%InputLines,1)
    i1_u = UBOUND(OutData%InputLines,1)
    DO i1 = LBOUND(OutData%InputLines,1), UBOUND(OutData%InputLines,1)
      DO I = 1, LEN(OutData%InputLines)
        OutData%InputLines(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
    i1_l = LBOUND(OutData%InputLineType,1)
    i1_u = UBOUND(OutData%InputLineType,1)
    DO i1 = LBOUND(OutData%InputLineType,1), UBOUND(OutData%InputLineType,1)
      DO I = 1, LEN(OutData%InputLineType)
        OutData%InputLineType(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
    OutData%numOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      OutData%C_obj%numOuts = OutData%numOuts
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MAP_Fortran_Unpacklin_paramtype( Re_Buf, Db_Buf, Int_Buf, OutData%LinParams, ErrStat2, ErrMsg2 ) ! LinParams 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE MAP_UnPackParam

 SUBROUTINE MAP_C2Fary_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%g = ParamData%C_obj%g
    ParamData%depth = ParamData%C_obj%depth
    ParamData%rho_sea = ParamData%C_obj%rho_sea
    ParamData%dt = ParamData%C_obj%dt
    ParamData%numOuts = ParamData%C_obj%numOuts
 END SUBROUTINE MAP_C2Fary_CopyParam

 SUBROUTINE MAP_F2C_CopyParam( ParamData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_ParameterType), INTENT(INOUT) :: ParamData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF
    ParamData%C_obj%g = ParamData%g
    ParamData%C_obj%depth = ParamData%depth
    ParamData%C_obj%rho_sea = ParamData%rho_sea
    ParamData%C_obj%dt = ParamData%dt
    ParamData%C_obj%numOuts = ParamData%numOuts
 END SUBROUTINE MAP_F2C_CopyParam

 SUBROUTINE MAP_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(MAP_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcInputData%x)) THEN
  i1_l = LBOUND(SrcInputData%x,1)
  i1_u = UBOUND(SrcInputData%x,1)
  IF (.NOT. ASSOCIATED(DstInputData%x)) THEN 
    ALLOCATE(DstInputData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%x_Len = SIZE(DstInputData%x)
    IF (DstInputData%c_obj%x_Len > 0) &
      DstInputData%c_obj%x = C_LOC( DstInputData%x(i1_l) ) 
  END IF
    DstInputData%x = SrcInputData%x
ENDIF
IF (ASSOCIATED(SrcInputData%y)) THEN
  i1_l = LBOUND(SrcInputData%y,1)
  i1_u = UBOUND(SrcInputData%y,1)
  IF (.NOT. ASSOCIATED(DstInputData%y)) THEN 
    ALLOCATE(DstInputData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%y.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%y_Len = SIZE(DstInputData%y)
    IF (DstInputData%c_obj%y_Len > 0) &
      DstInputData%c_obj%y = C_LOC( DstInputData%y(i1_l) ) 
  END IF
    DstInputData%y = SrcInputData%y
ENDIF
IF (ASSOCIATED(SrcInputData%z)) THEN
  i1_l = LBOUND(SrcInputData%z,1)
  i1_u = UBOUND(SrcInputData%z,1)
  IF (.NOT. ASSOCIATED(DstInputData%z)) THEN 
    ALLOCATE(DstInputData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%z.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstInputData%c_obj%z_Len = SIZE(DstInputData%z)
    IF (DstInputData%c_obj%z_Len > 0) &
      DstInputData%c_obj%z = C_LOC( DstInputData%z(i1_l) ) 
  END IF
    DstInputData%z = SrcInputData%z
ENDIF
      CALL MeshCopy( SrcInputData%PtFairDisplacement, DstInputData%PtFairDisplacement, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE MAP_CopyInput

 SUBROUTINE MAP_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(MAP_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(InputData%x)) THEN
  DEALLOCATE(InputData%x)
  InputData%x => NULL()
  InputData%C_obj%x = C_NULL_PTR
  InputData%C_obj%x_Len = 0
ENDIF
IF (ASSOCIATED(InputData%y)) THEN
  DEALLOCATE(InputData%y)
  InputData%y => NULL()
  InputData%C_obj%y = C_NULL_PTR
  InputData%C_obj%y_Len = 0
ENDIF
IF (ASSOCIATED(InputData%z)) THEN
  DEALLOCATE(InputData%z)
  InputData%z => NULL()
  InputData%C_obj%z = C_NULL_PTR
  InputData%C_obj%z_Len = 0
ENDIF
  CALL MeshDestroy( InputData%PtFairDisplacement, ErrStat, ErrMsg )
 END SUBROUTINE MAP_DestroyInput

 SUBROUTINE MAP_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! x allocated yes/no
  IF ( ASSOCIATED(InData%x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! x upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%x)  ! x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! y allocated yes/no
  IF ( ASSOCIATED(InData%y) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! y upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%y)  ! y
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! z allocated yes/no
  IF ( ASSOCIATED(InData%z) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! z upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%z)  ! z
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! PtFairDisplacement: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PtFairDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PtFairDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PtFairDisplacement
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PtFairDisplacement
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PtFairDisplacement
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%x,1), UBOUND(InData%x,1)
        DbKiBuf(Db_Xferred) = InData%x(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%y) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%y,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%y,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%y,1), UBOUND(InData%y,1)
        DbKiBuf(Db_Xferred) = InData%y(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%z) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%z,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%z,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%z,1), UBOUND(InData%z,1)
        DbKiBuf(Db_Xferred) = InData%z(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
      CALL MeshPack( InData%PtFairDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PtFairDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE MAP_PackInput

 SUBROUTINE MAP_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%x)) DEALLOCATE(OutData%x)
    ALLOCATE(OutData%x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%x_Len = SIZE(OutData%x)
    IF (OutData%c_obj%x_Len > 0) &
       OutData%c_obj%x = C_LOC( OutData%x(i1_l) ) 
      DO i1 = LBOUND(OutData%x,1), UBOUND(OutData%x,1)
        OutData%x(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! y not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%y)) DEALLOCATE(OutData%y)
    ALLOCATE(OutData%y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%y.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%y_Len = SIZE(OutData%y)
    IF (OutData%c_obj%y_Len > 0) &
       OutData%c_obj%y = C_LOC( OutData%y(i1_l) ) 
      DO i1 = LBOUND(OutData%y,1), UBOUND(OutData%y,1)
        OutData%y(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! z not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%z)) DEALLOCATE(OutData%z)
    ALLOCATE(OutData%z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%z_Len = SIZE(OutData%z)
    IF (OutData%c_obj%z_Len > 0) &
       OutData%c_obj%z = C_LOC( OutData%z(i1_l) ) 
      DO i1 = LBOUND(OutData%z,1), UBOUND(OutData%z,1)
        OutData%z(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%PtFairDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! PtFairDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE MAP_UnPackInput

 SUBROUTINE MAP_C2Fary_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- x Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%x ) ) THEN
          NULLIFY( InputData%x )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%x, InputData%x, (/InputData%C_obj%x_Len/))
       END IF
    END IF

    ! -- y Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%y ) ) THEN
          NULLIFY( InputData%y )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%y, InputData%y, (/InputData%C_obj%y_Len/))
       END IF
    END IF

    ! -- z Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( InputData%C_obj%z ) ) THEN
          NULLIFY( InputData%z )
       ELSE
          CALL C_F_POINTER(InputData%C_obj%z, InputData%z, (/InputData%C_obj%z_Len/))
       END IF
    END IF
 END SUBROUTINE MAP_C2Fary_CopyInput

 SUBROUTINE MAP_F2C_CopyInput( InputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_InputType), INTENT(INOUT) :: InputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- x Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%x)) THEN 
          InputData%c_obj%x_Len = 0
          InputData%c_obj%x = C_NULL_PTR
       ELSE
          InputData%c_obj%x_Len = SIZE(InputData%x)
          IF (InputData%c_obj%x_Len > 0) &
             InputData%c_obj%x = C_LOC( InputData%x( LBOUND(InputData%x,1) ) ) 
       END IF
    END IF

    ! -- y Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%y)) THEN 
          InputData%c_obj%y_Len = 0
          InputData%c_obj%y = C_NULL_PTR
       ELSE
          InputData%c_obj%y_Len = SIZE(InputData%y)
          IF (InputData%c_obj%y_Len > 0) &
             InputData%c_obj%y = C_LOC( InputData%y( LBOUND(InputData%y,1) ) ) 
       END IF
    END IF

    ! -- z Input Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(InputData%z)) THEN 
          InputData%c_obj%z_Len = 0
          InputData%c_obj%z = C_NULL_PTR
       ELSE
          InputData%c_obj%z_Len = SIZE(InputData%z)
          IF (InputData%c_obj%z_Len > 0) &
             InputData%c_obj%z = C_LOC( InputData%z( LBOUND(InputData%z,1) ) ) 
       END IF
    END IF
 END SUBROUTINE MAP_F2C_CopyInput

 SUBROUTINE MAP_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(MAP_OutputType), INTENT(INOUT) :: SrcOutputData
   TYPE(MAP_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ASSOCIATED(SrcOutputData%Fx)) THEN
  i1_l = LBOUND(SrcOutputData%Fx,1)
  i1_u = UBOUND(SrcOutputData%Fx,1)
  IF (.NOT. ASSOCIATED(DstOutputData%Fx)) THEN 
    ALLOCATE(DstOutputData%Fx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%Fx_Len = SIZE(DstOutputData%Fx)
    IF (DstOutputData%c_obj%Fx_Len > 0) &
      DstOutputData%c_obj%Fx = C_LOC( DstOutputData%Fx(i1_l) ) 
  END IF
    DstOutputData%Fx = SrcOutputData%Fx
ENDIF
IF (ASSOCIATED(SrcOutputData%Fy)) THEN
  i1_l = LBOUND(SrcOutputData%Fy,1)
  i1_u = UBOUND(SrcOutputData%Fy,1)
  IF (.NOT. ASSOCIATED(DstOutputData%Fy)) THEN 
    ALLOCATE(DstOutputData%Fy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fy.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%Fy_Len = SIZE(DstOutputData%Fy)
    IF (DstOutputData%c_obj%Fy_Len > 0) &
      DstOutputData%c_obj%Fy = C_LOC( DstOutputData%Fy(i1_l) ) 
  END IF
    DstOutputData%Fy = SrcOutputData%Fy
ENDIF
IF (ASSOCIATED(SrcOutputData%Fz)) THEN
  i1_l = LBOUND(SrcOutputData%Fz,1)
  i1_u = UBOUND(SrcOutputData%Fz,1)
  IF (.NOT. ASSOCIATED(DstOutputData%Fz)) THEN 
    ALLOCATE(DstOutputData%Fz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Fz.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%Fz_Len = SIZE(DstOutputData%Fz)
    IF (DstOutputData%c_obj%Fz_Len > 0) &
      DstOutputData%c_obj%Fz = C_LOC( DstOutputData%Fz(i1_l) ) 
  END IF
    DstOutputData%Fz = SrcOutputData%Fz
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
IF (ASSOCIATED(SrcOutputData%wrtOutput)) THEN
  i1_l = LBOUND(SrcOutputData%wrtOutput,1)
  i1_u = UBOUND(SrcOutputData%wrtOutput,1)
  IF (.NOT. ASSOCIATED(DstOutputData%wrtOutput)) THEN 
    ALLOCATE(DstOutputData%wrtOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%wrtOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
    DstOutputData%c_obj%wrtOutput_Len = SIZE(DstOutputData%wrtOutput)
    IF (DstOutputData%c_obj%wrtOutput_Len > 0) &
      DstOutputData%c_obj%wrtOutput = C_LOC( DstOutputData%wrtOutput(i1_l) ) 
  END IF
    DstOutputData%wrtOutput = SrcOutputData%wrtOutput
ENDIF
      CALL MeshCopy( SrcOutputData%ptFairleadLoad, DstOutputData%ptFairleadLoad, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE MAP_CopyOutput

 SUBROUTINE MAP_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(MAP_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'MAP_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ASSOCIATED(OutputData%Fx)) THEN
  DEALLOCATE(OutputData%Fx)
  OutputData%Fx => NULL()
  OutputData%C_obj%Fx = C_NULL_PTR
  OutputData%C_obj%Fx_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%Fy)) THEN
  DEALLOCATE(OutputData%Fy)
  OutputData%Fy => NULL()
  OutputData%C_obj%Fy = C_NULL_PTR
  OutputData%C_obj%Fy_Len = 0
ENDIF
IF (ASSOCIATED(OutputData%Fz)) THEN
  DEALLOCATE(OutputData%Fz)
  OutputData%Fz => NULL()
  OutputData%C_obj%Fz = C_NULL_PTR
  OutputData%C_obj%Fz_Len = 0
ENDIF
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
IF (ASSOCIATED(OutputData%wrtOutput)) THEN
  DEALLOCATE(OutputData%wrtOutput)
  OutputData%wrtOutput => NULL()
  OutputData%C_obj%wrtOutput = C_NULL_PTR
  OutputData%C_obj%wrtOutput_Len = 0
ENDIF
  CALL MeshDestroy( OutputData%ptFairleadLoad, ErrStat, ErrMsg )
 END SUBROUTINE MAP_DestroyOutput

 SUBROUTINE MAP_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(MAP_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Fx allocated yes/no
  IF ( ASSOCIATED(InData%Fx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fx upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fx)  ! Fx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fy allocated yes/no
  IF ( ASSOCIATED(InData%Fy) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fy upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fy)  ! Fy
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Fz allocated yes/no
  IF ( ASSOCIATED(InData%Fz) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Fz upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%Fz)  ! Fz
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! wrtOutput allocated yes/no
  IF ( ASSOCIATED(InData%wrtOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! wrtOutput upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%wrtOutput)  ! wrtOutput
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! ptFairleadLoad: size of buffers for each call to pack subtype
      CALL MeshPack( InData%ptFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! ptFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! ptFairleadLoad
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! ptFairleadLoad
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! ptFairleadLoad
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  IF (C_ASSOCIATED(InData%C_obj%object)) CALL SetErrStat(ErrID_Severe,'C_obj%object cannot be packed.',ErrStat,ErrMsg,RoutineName)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ASSOCIATED(InData%Fx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fx,1), UBOUND(InData%Fx,1)
        DbKiBuf(Db_Xferred) = InData%Fx(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fy) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fy,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fy,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fy,1), UBOUND(InData%Fy,1)
        DbKiBuf(Db_Xferred) = InData%Fy(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%Fz) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Fz,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Fz,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Fz,1), UBOUND(InData%Fz,1)
        DbKiBuf(Db_Xferred) = InData%Fz(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ASSOCIATED(InData%wrtOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%wrtOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%wrtOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%wrtOutput,1), UBOUND(InData%wrtOutput,1)
        DbKiBuf(Db_Xferred) = InData%wrtOutput(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
      CALL MeshPack( InData%ptFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! ptFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE MAP_PackOutput

 SUBROUTINE MAP_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(MAP_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'MAP_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fx)) DEALLOCATE(OutData%Fx)
    ALLOCATE(OutData%Fx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fx_Len = SIZE(OutData%Fx)
    IF (OutData%c_obj%Fx_Len > 0) &
       OutData%c_obj%Fx = C_LOC( OutData%Fx(i1_l) ) 
      DO i1 = LBOUND(OutData%Fx,1), UBOUND(OutData%Fx,1)
        OutData%Fx(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fy not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fy)) DEALLOCATE(OutData%Fy)
    ALLOCATE(OutData%Fy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fy.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fy_Len = SIZE(OutData%Fy)
    IF (OutData%c_obj%Fy_Len > 0) &
       OutData%c_obj%Fy = C_LOC( OutData%Fy(i1_l) ) 
      DO i1 = LBOUND(OutData%Fy,1), UBOUND(OutData%Fy,1)
        OutData%Fy(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Fz not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%Fz)) DEALLOCATE(OutData%Fz)
    ALLOCATE(OutData%Fz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Fz.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%Fz_Len = SIZE(OutData%Fz)
    IF (OutData%c_obj%Fz_Len > 0) &
       OutData%c_obj%Fz = C_LOC( OutData%Fz(i1_l) ) 
      DO i1 = LBOUND(OutData%Fz,1), UBOUND(OutData%Fz,1)
        OutData%Fz(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! wrtOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ASSOCIATED(OutData%wrtOutput)) DEALLOCATE(OutData%wrtOutput)
    ALLOCATE(OutData%wrtOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%wrtOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    OutData%c_obj%wrtOutput_Len = SIZE(OutData%wrtOutput)
    IF (OutData%c_obj%wrtOutput_Len > 0) &
       OutData%c_obj%wrtOutput = C_LOC( OutData%wrtOutput(i1_l) ) 
      DO i1 = LBOUND(OutData%wrtOutput,1), UBOUND(OutData%wrtOutput,1)
        OutData%wrtOutput(i1) = REAL(DbKiBuf(Db_Xferred), C_DOUBLE)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%ptFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! ptFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE MAP_UnPackOutput

 SUBROUTINE MAP_C2Fary_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers )
    TYPE(MAP_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- Fx Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fx ) ) THEN
          NULLIFY( OutputData%Fx )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%Fx, OutputData%Fx, (/OutputData%C_obj%Fx_Len/))
       END IF
    END IF

    ! -- Fy Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fy ) ) THEN
          NULLIFY( OutputData%Fy )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%Fy, OutputData%Fy, (/OutputData%C_obj%Fy_Len/))
       END IF
    END IF

    ! -- Fz Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%Fz ) ) THEN
          NULLIFY( OutputData%Fz )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%Fz, OutputData%Fz, (/OutputData%C_obj%Fz_Len/))
       END IF
    END IF

    ! -- wrtOutput Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. C_ASSOCIATED( OutputData%C_obj%wrtOutput ) ) THEN
          NULLIFY( OutputData%wrtOutput )
       ELSE
          CALL C_F_POINTER(OutputData%C_obj%wrtOutput, OutputData%wrtOutput, (/OutputData%C_obj%wrtOutput_Len/))
       END IF
    END IF
 END SUBROUTINE MAP_C2Fary_CopyOutput

 SUBROUTINE MAP_F2C_CopyOutput( OutputData, ErrStat, ErrMsg, SkipPointers  )
    TYPE(MAP_OutputType), INTENT(INOUT) :: OutputData
    INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
    CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    LOGICAL,OPTIONAL,INTENT(IN   ) :: SkipPointers
    ! 
    LOGICAL                        :: SkipPointers_local
    ErrStat = ErrID_None
    ErrMsg  = ""

    IF (PRESENT(SkipPointers)) THEN
       SkipPointers_local = SkipPointers
    ELSE
       SkipPointers_local = .false.
    END IF

    ! -- Fx Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%Fx)) THEN 
          OutputData%c_obj%Fx_Len = 0
          OutputData%c_obj%Fx = C_NULL_PTR
       ELSE
          OutputData%c_obj%Fx_Len = SIZE(OutputData%Fx)
          IF (OutputData%c_obj%Fx_Len > 0) &
             OutputData%c_obj%Fx = C_LOC( OutputData%Fx( LBOUND(OutputData%Fx,1) ) ) 
       END IF
    END IF

    ! -- Fy Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%Fy)) THEN 
          OutputData%c_obj%Fy_Len = 0
          OutputData%c_obj%Fy = C_NULL_PTR
       ELSE
          OutputData%c_obj%Fy_Len = SIZE(OutputData%Fy)
          IF (OutputData%c_obj%Fy_Len > 0) &
             OutputData%c_obj%Fy = C_LOC( OutputData%Fy( LBOUND(OutputData%Fy,1) ) ) 
       END IF
    END IF

    ! -- Fz Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%Fz)) THEN 
          OutputData%c_obj%Fz_Len = 0
          OutputData%c_obj%Fz = C_NULL_PTR
       ELSE
          OutputData%c_obj%Fz_Len = SIZE(OutputData%Fz)
          IF (OutputData%c_obj%Fz_Len > 0) &
             OutputData%c_obj%Fz = C_LOC( OutputData%Fz( LBOUND(OutputData%Fz,1) ) ) 
       END IF
    END IF

    ! -- wrtOutput Output Data fields
    IF ( .NOT. SkipPointers_local ) THEN
       IF ( .NOT. ASSOCIATED(OutputData%wrtOutput)) THEN 
          OutputData%c_obj%wrtOutput_Len = 0
          OutputData%c_obj%wrtOutput = C_NULL_PTR
       ELSE
          OutputData%c_obj%wrtOutput_Len = SIZE(OutputData%wrtOutput)
          IF (OutputData%c_obj%wrtOutput_Len > 0) &
             OutputData%c_obj%wrtOutput = C_LOC( OutputData%wrtOutput( LBOUND(OutputData%wrtOutput,1) ) ) 
       END IF
    END IF
 END SUBROUTINE MAP_F2C_CopyOutput


 SUBROUTINE MAP_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(MAP_InputType), INTENT(INOUT)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(MAP_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'MAP_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL MAP_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL MAP_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL MAP_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE MAP_Input_ExtrapInterp


 SUBROUTINE MAP_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(MAP_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
 TYPE(MAP_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(MAP_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'MAP_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(u_out%x) .AND. ASSOCIATED(u1%x)) THEN
  DO i1 = LBOUND(u_out%x,1),UBOUND(u_out%x,1)
    b = -(u1%x(i1) - u2%x(i1))
    u_out%x(i1) = u1%x(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%y) .AND. ASSOCIATED(u1%y)) THEN
  DO i1 = LBOUND(u_out%y,1),UBOUND(u_out%y,1)
    b = -(u1%y(i1) - u2%y(i1))
    u_out%y(i1) = u1%y(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%z) .AND. ASSOCIATED(u1%z)) THEN
  DO i1 = LBOUND(u_out%z,1),UBOUND(u_out%z,1)
    b = -(u1%z(i1) - u2%z(i1))
    u_out%z(i1) = u1%z(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp1(u1%PtFairDisplacement, u2%PtFairDisplacement, tin, u_out%PtFairDisplacement, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE MAP_Input_ExtrapInterp1


 SUBROUTINE MAP_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(MAP_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
 TYPE(MAP_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
 TYPE(MAP_InputType), INTENT(INOUT)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(MAP_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'MAP_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(u_out%x) .AND. ASSOCIATED(u1%x)) THEN
  DO i1 = LBOUND(u_out%x,1),UBOUND(u_out%x,1)
    b = (t(3)**2*(u1%x(i1) - u2%x(i1)) + t(2)**2*(-u1%x(i1) + u3%x(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%x(i1) + t(3)*u2%x(i1) - t(2)*u3%x(i1) ) * scaleFactor
    u_out%x(i1) = u1%x(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%y) .AND. ASSOCIATED(u1%y)) THEN
  DO i1 = LBOUND(u_out%y,1),UBOUND(u_out%y,1)
    b = (t(3)**2*(u1%y(i1) - u2%y(i1)) + t(2)**2*(-u1%y(i1) + u3%y(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%y(i1) + t(3)*u2%y(i1) - t(2)*u3%y(i1) ) * scaleFactor
    u_out%y(i1) = u1%y(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(u_out%z) .AND. ASSOCIATED(u1%z)) THEN
  DO i1 = LBOUND(u_out%z,1),UBOUND(u_out%z,1)
    b = (t(3)**2*(u1%z(i1) - u2%z(i1)) + t(2)**2*(-u1%z(i1) + u3%z(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%z(i1) + t(3)*u2%z(i1) - t(2)*u3%z(i1) ) * scaleFactor
    u_out%z(i1) = u1%z(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp2(u1%PtFairDisplacement, u2%PtFairDisplacement, u3%PtFairDisplacement, tin, u_out%PtFairDisplacement, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE MAP_Input_ExtrapInterp2


 SUBROUTINE MAP_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(MAP_OutputType), INTENT(INOUT)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'MAP_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL MAP_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL MAP_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL MAP_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE MAP_Output_ExtrapInterp


 SUBROUTINE MAP_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(MAP_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'MAP_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ASSOCIATED(y_out%Fx) .AND. ASSOCIATED(y1%Fx)) THEN
  DO i1 = LBOUND(y_out%Fx,1),UBOUND(y_out%Fx,1)
    b = -(y1%Fx(i1) - y2%Fx(i1))
    y_out%Fx(i1) = y1%Fx(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%Fy) .AND. ASSOCIATED(y1%Fy)) THEN
  DO i1 = LBOUND(y_out%Fy,1),UBOUND(y_out%Fy,1)
    b = -(y1%Fy(i1) - y2%Fy(i1))
    y_out%Fy(i1) = y1%Fy(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%Fz) .AND. ASSOCIATED(y1%Fz)) THEN
  DO i1 = LBOUND(y_out%Fz,1),UBOUND(y_out%Fz,1)
    b = -(y1%Fz(i1) - y2%Fz(i1))
    y_out%Fz(i1) = y1%Fz(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%wrtOutput) .AND. ASSOCIATED(y1%wrtOutput)) THEN
  DO i1 = LBOUND(y_out%wrtOutput,1),UBOUND(y_out%wrtOutput,1)
    b = -(y1%wrtOutput(i1) - y2%wrtOutput(i1))
    y_out%wrtOutput(i1) = y1%wrtOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp1(y1%ptFairleadLoad, y2%ptFairleadLoad, tin, y_out%ptFairleadLoad, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE MAP_Output_ExtrapInterp1


 SUBROUTINE MAP_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(MAP_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(MAP_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'MAP_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ASSOCIATED(y_out%Fx) .AND. ASSOCIATED(y1%Fx)) THEN
  DO i1 = LBOUND(y_out%Fx,1),UBOUND(y_out%Fx,1)
    b = (t(3)**2*(y1%Fx(i1) - y2%Fx(i1)) + t(2)**2*(-y1%Fx(i1) + y3%Fx(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%Fx(i1) + t(3)*y2%Fx(i1) - t(2)*y3%Fx(i1) ) * scaleFactor
    y_out%Fx(i1) = y1%Fx(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%Fy) .AND. ASSOCIATED(y1%Fy)) THEN
  DO i1 = LBOUND(y_out%Fy,1),UBOUND(y_out%Fy,1)
    b = (t(3)**2*(y1%Fy(i1) - y2%Fy(i1)) + t(2)**2*(-y1%Fy(i1) + y3%Fy(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%Fy(i1) + t(3)*y2%Fy(i1) - t(2)*y3%Fy(i1) ) * scaleFactor
    y_out%Fy(i1) = y1%Fy(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%Fz) .AND. ASSOCIATED(y1%Fz)) THEN
  DO i1 = LBOUND(y_out%Fz,1),UBOUND(y_out%Fz,1)
    b = (t(3)**2*(y1%Fz(i1) - y2%Fz(i1)) + t(2)**2*(-y1%Fz(i1) + y3%Fz(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%Fz(i1) + t(3)*y2%Fz(i1) - t(2)*y3%Fz(i1) ) * scaleFactor
    y_out%Fz(i1) = y1%Fz(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ASSOCIATED(y_out%wrtOutput) .AND. ASSOCIATED(y1%wrtOutput)) THEN
  DO i1 = LBOUND(y_out%wrtOutput,1),UBOUND(y_out%wrtOutput,1)
    b = (t(3)**2*(y1%wrtOutput(i1) - y2%wrtOutput(i1)) + t(2)**2*(-y1%wrtOutput(i1) + y3%wrtOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%wrtOutput(i1) + t(3)*y2%wrtOutput(i1) - t(2)*y3%wrtOutput(i1) ) * scaleFactor
    y_out%wrtOutput(i1) = y1%wrtOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp2(y1%ptFairleadLoad, y2%ptFairleadLoad, y3%ptFairleadLoad, tin, y_out%ptFairleadLoad, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE MAP_Output_ExtrapInterp2

END MODULE MAP_Types
!ENDOFREGISTRYGENERATEDFILE
