!STARTOFREGISTRYGENERATEDFILE 'IceDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! IceDyn_Types
!.................................................................................................................................
! This file is part of IceDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in IceDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE IceDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  IceD_InputFile  =======
  TYPE, PUBLIC :: IceD_InputFile
    INTEGER(IntKi)  :: IceModel      !< The current ice model number [-]
    INTEGER(IntKi)  :: IceSubModel      !< The current ice sub-model number [-]
    REAL(ReKi)  :: h      !< Ice thickness [m]
    REAL(ReKi)  :: v      !< Ice velocity [m/s]
    REAL(ReKi)  :: InitLoc      !< Ice sheet initial location [m]
    REAL(ReKi)  :: t0      !< Ice load starting time [s]
    REAL(ReKi)  :: rhow      !< Water mass density [kg/m^3]
    REAL(ReKi)  :: rhoi      !< Ice mass density [kg/m^3]
    INTEGER(IntKi)  :: Seed1      !< Random seed 1 [-]
    INTEGER(IntKi)  :: Seed2      !< Random seed 2 [-]
    INTEGER(IntKi)  :: NumLegs      !< Number of support structure legs in ice [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LegPosX      !< global X position of legs 1-NumLegs  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LegPosY      !< global Y position of legs 1-NumLegs  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StrWd      !< The width of the leg (structure) [m]
    REAL(ReKi)  :: Ikm      !< Indentation factor [-]
    REAL(ReKi)  :: Ag      !< Ice crystal type factor [MPa^-3s^-1]
    REAL(ReKi)  :: Qg      !< Activation energy [kJ]
    REAL(ReKi)  :: Rg      !< Universal gas constant [J]
    REAL(ReKi)  :: Tice      !< Ice temperature [K]
    REAL(ReKi)  :: nu      !< Poison ratio of ice [-]
    REAL(ReKi)  :: phi      !< Ice wedge angle [degree]
    REAL(ReKi)  :: SigNm      !< Nominal ice strength [MPa]
    REAL(ReKi)  :: Eice      !< Elastic modulus of ice [GPa]
    REAL(ReKi)  :: IceStr2      !< Ice tooth brittle strength [MPa]
    REAL(ReKi)  :: Delmax2      !< Ice tooth maximum elastic deformation for model 2 [m]
    REAL(ReKi)  :: Pitch      !< Distance between sequential ice teeth for model 2 [m]
    REAL(ReKi)  :: miuh      !< Mean value of random ice thickness [m]
    REAL(ReKi)  :: varh      !< Variance of random ice thicknesss [m^2]
    REAL(ReKi)  :: miuv      !< Mean value of random ice velocity [m/s]
    REAL(ReKi)  :: varv      !< Variance of random ice velocity [m^2/s^2]
    REAL(ReKi)  :: miut      !< Mean value of ice loading event duration time [s]
    REAL(ReKi)  :: miubr      !< Mean value of random ice brittle strength [MPa]
    REAL(ReKi)  :: varbr      !< Variance of random ice brittle strength [MPa^2]
    REAL(ReKi)  :: miuDelm      !< Mean value of random random maximum ice tooth tip displacement [MPa]
    REAL(ReKi)  :: varDelm      !< Variance of random random maximum ice tooth tip displacement [MPa^2]
    REAL(ReKi)  :: miuP      !< Mean value of random distance between sequential ice teeth [m]
    REAL(ReKi)  :: varP      !< Variance of random distance between sequential ice teeth [m^2]
    INTEGER(IntKi)  :: Zn1      !< Number of failure zones along contact width [-]
    INTEGER(IntKi)  :: Zn2      !< Number of failure zones along contact height/thickness [-]
    REAL(ReKi)  :: ZonePitch      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: PrflMean      !< Ice structure contact profile mean value [m]
    REAL(ReKi)  :: PrflSig      !< Ice structure contact profile standard deviation [m]
    REAL(ReKi)  :: IceStr      !< Ice failure strength [MPa]
    REAL(ReKi)  :: Delmax      !< Ice teeth maximum elastic deformation [m]
    REAL(ReKi)  :: alpha      !< slope angle of the cone [degree]
    REAL(ReKi)  :: Dwl      !< cone waterline diameter [m]
    REAL(ReKi)  :: Dtp      !< cone top diameter [m]
    REAL(ReKi)  :: hr      !< ride-up ice thickness [m]
    REAL(ReKi)  :: mu      !< friction coefficient between structure and ice [-]
    REAL(ReKi)  :: sigf      !< flexural strength of ice [MPa]
    REAL(ReKi)  :: StrLim      !< limit strain [-]
    REAL(ReKi)  :: StrRtLim      !< limit strain rate [s^-1]
    INTEGER(IntKi)  :: UorD      !< flag that indicates upward or downward breaking cone: 0,upward, 1,downward. [-]
    REAL(ReKi)  :: Ll      !< Ice floe length [m]
    REAL(ReKi)  :: Lw      !< Ice floe width [m]
    REAL(ReKi)  :: Cpa      !< ice crushing strength pressure-area relation constant [-]
    REAL(ReKi)  :: dpa      !< ice crushing strength pressure-area relation order [-]
    REAL(ReKi)  :: Fdr      !< Constant external driving force [MN]
    REAL(ReKi)  :: Kic      !< Fracture toughness of ice [kNm^(-3/2)]
    REAL(ReKi)  :: FspN      !< Non-dimensional splitting load [-]
  END TYPE IceD_InputFile
! =======================
! =========  IceD_InitInputType  =======
  TYPE, PUBLIC :: IceD_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file; remove if there is no file [-]
    CHARACTER(1024)  :: RootName      !< Root name of the output file [-]
    REAL(ReKi)  :: MSL2SWL      !< Offset between still-water level and mean sea level [m]
    REAL(ReKi)  :: WtrDens      !< Density of water [kg/m^3]
    REAL(ReKi)  :: gravity      !< Gravitational acceleration [m/s^2]
    INTEGER(IntKi)  :: LegNum      !< Which number of legs on the turbine this is being initialized for [m]
    REAL(DbKi)  :: TMax      !< Total simulation time [s]
  END TYPE IceD_InitInputType
! =======================
! =========  IceD_InitOutputType  =======
  TYPE, PUBLIC :: IceD_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    INTEGER(IntKi)  :: numLegs      !< Number of legs on the structure [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE IceD_InitOutputType
! =======================
! =========  IceD_ContinuousStateType  =======
  TYPE, PUBLIC :: IceD_ContinuousStateType
    REAL(ReKi)  :: q      !< q - displacement of ice mass [m]
    REAL(ReKi)  :: dqdt      !< dqdt - velocity of ice mass [m/s]
  END TYPE IceD_ContinuousStateType
! =======================
! =========  IceD_DiscreteStateType  =======
  TYPE, PUBLIC :: IceD_DiscreteStateType
    REAL(SiKi)  :: DummyDiscState      !< A variable, Replace if you have discrete states [-]
  END TYPE IceD_DiscreteStateType
! =======================
! =========  IceD_ConstraintStateType  =======
  TYPE, PUBLIC :: IceD_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState      !< A variable, Replace if you have constraint states [-]
  END TYPE IceD_ConstraintStateType
! =======================
! =========  IceD_OtherStateType  =======
  TYPE, PUBLIC :: IceD_OtherStateType
    INTEGER(IntKi)  :: IceTthNo2      !< Ice tooth number of the current ice tooth, for model 2 (updated in UpdateStates; used in CalcOutput) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Nc      !< Number of the current ice tooths number (time series) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Psum      !< The sum of pitches of all broken ice teeth (time series) [m]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IceTthNo      !< IceTthNo - the current numbers of ice teeth of each zone [-]
    REAL(ReKi)  :: Beta      !< angle between broken ice sheet and level waterline [rad]
    REAL(DbKi)  :: Tinit      !< Initial time of the current load cycle [s]
    INTEGER(IntKi)  :: Splitf      !< flag to indicate if the ice floe has split (0 not splitted, 1 splitted) [-]
    REAL(ReKi)  :: dxc      !< crushed depth of ice [m]
    TYPE(IceD_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: xdot      !< previous state deriv for multi-step [m]
    INTEGER(IntKi)  :: n      !< tracks time step for which OtherState was updated [-]
  END TYPE IceD_OtherStateType
! =======================
! =========  IceD_MiscVarType  =======
  TYPE, PUBLIC :: IceD_MiscVarType
    INTEGER(IntKi)  :: DummyMiscVar      !< Remove this variable if you have misc/optimization variables [-]
  END TYPE IceD_MiscVarType
! =======================
! =========  IceD_ParameterType  =======
  TYPE, PUBLIC :: IceD_ParameterType
    REAL(ReKi)  :: h      !< Ice thickness [m]
    REAL(ReKi)  :: v      !< Ice velocity [m/s]
    REAL(ReKi)  :: t0      !< Ice load starting time [s]
    REAL(ReKi)  :: StrWd      !< The width of the structure [m]
    REAL(ReKi)  :: dt      !< Time interval for integration within the module [s]
    REAL(ReKi)  :: InitLoc      !< Ice sheet initial location [m]
    REAL(ReKi)  :: tolerance      !< Tolerance when calculating ice breaking force, etc. [-]
    REAL(ReKi)  :: Tmax      !< Total simulation time [s]
    INTEGER(IntKi)  :: verif      !< flag to indicate if verification is being peformed [-]
    INTEGER(IntKi)  :: ModNo      !< The current ice model number [-]
    INTEGER(IntKi)  :: SubModNo      !< The current ice sub-model number [-]
    INTEGER(IntKi)  :: NumOuts      !< The number of output channels [-]
    INTEGER(IntKi)  :: method      !< integration method: 1-RK4, 2-AB4, 3-ABM4 [-]
    INTEGER(IntKi)  :: TmStep      !< Total time step [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutName      !< Names of all requested output parameters [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutUnit      !< Units of all requested output parameters [-]
    CHARACTER(1024)  :: RootName      !< Rootname [-]
    REAL(ReKi)  :: tm1a      !< Time for the maximum force to be reached for model 1a [s]
    REAL(ReKi)  :: tm1b      !< Time for the maximum force to be reached for model 1b [s]
    REAL(ReKi)  :: tm1c      !< Time for the maximum force to be reached for model 1c [s]
    REAL(ReKi)  :: Fmax1a      !< Maximum ice force of model 1a [N]
    REAL(ReKi)  :: Fmax1b      !< Maximum ice force of model 1b [N]
    REAL(ReKi)  :: Fmax1c      !< Maximum ice force of model 1c [N]
    REAL(ReKi)  :: Ikm      !< Indentation factor [-]
    REAL(ReKi)  :: Cstr      !< Constant when calculating creeping stresss [Pa*s^(-1/3)]
    REAL(ReKi)  :: EiPa      !< Elastic modulus of ice [Pa]
    REAL(ReKi)  :: Delmax2      !< Ice tooth maximum elastic deformation for model 2 [m]
    REAL(ReKi)  :: Pitch      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: Kice2      !< Stiffness of ice teeth for model 2 [N/m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmFm      !< Random maximum ice force time series [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmt0      !< Random ice loading event starting time [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmtm      !< Random time when the maximum force is reached [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmDm      !< Random maximum ice tooth tip displacement time series [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmP      !< Random distance between sequential ice teeth [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rdmKi      !< Random ice teeth stiffness [N/m]
    REAL(ReKi)  :: ZonePitch      !< Distance between sequential ice teeth [m]
    REAL(ReKi)  :: Kice      !< Stiffness of ice teeth [N/m]
    REAL(ReKi)  :: Delmax      !< Ice teeth maximum elastic deformation [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0      !< Ice structure contact profile initial location [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ContPrfl      !< Ice structure contact profile [m]
    INTEGER(IntKi)  :: Zn      !< Number of failure zones [-]
    REAL(ReKi)  :: rhoi      !< Ice mass density  [kg/m^3]
    REAL(ReKi)  :: rhow      !< Water mass density [kg/m^3]
    REAL(ReKi)  :: alphaR      !< Slope angle of the cone [rad]
    REAL(ReKi)  :: Dwl      !< Cone waterline diameter  [m]
    REAL(ReKi)  :: Zr      !< Ice ride-up height [m]
    REAL(ReKi)  :: RHbr      !< Horizontal breaking force [N]
    REAL(ReKi)  :: RVbr      !< Vertical breaking force [N]
    REAL(ReKi)  :: Lbr      !< Ice sheet breaking length [m]
    REAL(ReKi)  :: LovR      !< Ratio of ice breaking length over cone radius [-]
    REAL(ReKi)  :: mu      !< Friction coefficient between structure and ice [-]
    REAL(ReKi)  :: Wri      !< Initial ride-up ice weight  [kg]
    REAL(ReKi)  :: WL      !< Broken ice piece weight [kg]
    REAL(ReKi)  :: Cpa      !< ice crushing strength pressure-area relation constant [-]
    REAL(ReKi)  :: dpa      !< ice crushing strength pressure-area relation order [-]
    REAL(ReKi)  :: FdrN      !< Constant external driving force [N]
    REAL(ReKi)  :: Mice      !< Ice floe mass [kg]
    REAL(ReKi)  :: Fsp      !< Ice floe splitting force [N]
  END TYPE IceD_ParameterType
! =======================
! =========  IceD_InputType  =======
  TYPE, PUBLIC :: IceD_InputType
    TYPE(MeshType)  :: PointMesh      !< contains displacement and velocity of structure [-]
  END TYPE IceD_InputType
! =======================
! =========  IceD_OutputType  =======
  TYPE, PUBLIC :: IceD_OutputType
    TYPE(MeshType)  :: PointMesh      !< contains Ice force [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE IceD_OutputType
! =======================
CONTAINS
 SUBROUTINE IceD_CopyInputFile( SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_InputFile), INTENT(IN) :: SrcInputFileData
   TYPE(IceD_InputFile), INTENT(INOUT) :: DstInputFileData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyInputFile'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileData%IceModel = SrcInputFileData%IceModel
    DstInputFileData%IceSubModel = SrcInputFileData%IceSubModel
    DstInputFileData%h = SrcInputFileData%h
    DstInputFileData%v = SrcInputFileData%v
    DstInputFileData%InitLoc = SrcInputFileData%InitLoc
    DstInputFileData%t0 = SrcInputFileData%t0
    DstInputFileData%rhow = SrcInputFileData%rhow
    DstInputFileData%rhoi = SrcInputFileData%rhoi
    DstInputFileData%Seed1 = SrcInputFileData%Seed1
    DstInputFileData%Seed2 = SrcInputFileData%Seed2
    DstInputFileData%NumLegs = SrcInputFileData%NumLegs
IF (ALLOCATED(SrcInputFileData%LegPosX)) THEN
  i1_l = LBOUND(SrcInputFileData%LegPosX,1)
  i1_u = UBOUND(SrcInputFileData%LegPosX,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LegPosX)) THEN 
    ALLOCATE(DstInputFileData%LegPosX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LegPosX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LegPosX = SrcInputFileData%LegPosX
ENDIF
IF (ALLOCATED(SrcInputFileData%LegPosY)) THEN
  i1_l = LBOUND(SrcInputFileData%LegPosY,1)
  i1_u = UBOUND(SrcInputFileData%LegPosY,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LegPosY)) THEN 
    ALLOCATE(DstInputFileData%LegPosY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LegPosY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LegPosY = SrcInputFileData%LegPosY
ENDIF
IF (ALLOCATED(SrcInputFileData%StrWd)) THEN
  i1_l = LBOUND(SrcInputFileData%StrWd,1)
  i1_u = UBOUND(SrcInputFileData%StrWd,1)
  IF (.NOT. ALLOCATED(DstInputFileData%StrWd)) THEN 
    ALLOCATE(DstInputFileData%StrWd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%StrWd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%StrWd = SrcInputFileData%StrWd
ENDIF
    DstInputFileData%Ikm = SrcInputFileData%Ikm
    DstInputFileData%Ag = SrcInputFileData%Ag
    DstInputFileData%Qg = SrcInputFileData%Qg
    DstInputFileData%Rg = SrcInputFileData%Rg
    DstInputFileData%Tice = SrcInputFileData%Tice
    DstInputFileData%nu = SrcInputFileData%nu
    DstInputFileData%phi = SrcInputFileData%phi
    DstInputFileData%SigNm = SrcInputFileData%SigNm
    DstInputFileData%Eice = SrcInputFileData%Eice
    DstInputFileData%IceStr2 = SrcInputFileData%IceStr2
    DstInputFileData%Delmax2 = SrcInputFileData%Delmax2
    DstInputFileData%Pitch = SrcInputFileData%Pitch
    DstInputFileData%miuh = SrcInputFileData%miuh
    DstInputFileData%varh = SrcInputFileData%varh
    DstInputFileData%miuv = SrcInputFileData%miuv
    DstInputFileData%varv = SrcInputFileData%varv
    DstInputFileData%miut = SrcInputFileData%miut
    DstInputFileData%miubr = SrcInputFileData%miubr
    DstInputFileData%varbr = SrcInputFileData%varbr
    DstInputFileData%miuDelm = SrcInputFileData%miuDelm
    DstInputFileData%varDelm = SrcInputFileData%varDelm
    DstInputFileData%miuP = SrcInputFileData%miuP
    DstInputFileData%varP = SrcInputFileData%varP
    DstInputFileData%Zn1 = SrcInputFileData%Zn1
    DstInputFileData%Zn2 = SrcInputFileData%Zn2
    DstInputFileData%ZonePitch = SrcInputFileData%ZonePitch
    DstInputFileData%PrflMean = SrcInputFileData%PrflMean
    DstInputFileData%PrflSig = SrcInputFileData%PrflSig
    DstInputFileData%IceStr = SrcInputFileData%IceStr
    DstInputFileData%Delmax = SrcInputFileData%Delmax
    DstInputFileData%alpha = SrcInputFileData%alpha
    DstInputFileData%Dwl = SrcInputFileData%Dwl
    DstInputFileData%Dtp = SrcInputFileData%Dtp
    DstInputFileData%hr = SrcInputFileData%hr
    DstInputFileData%mu = SrcInputFileData%mu
    DstInputFileData%sigf = SrcInputFileData%sigf
    DstInputFileData%StrLim = SrcInputFileData%StrLim
    DstInputFileData%StrRtLim = SrcInputFileData%StrRtLim
    DstInputFileData%UorD = SrcInputFileData%UorD
    DstInputFileData%Ll = SrcInputFileData%Ll
    DstInputFileData%Lw = SrcInputFileData%Lw
    DstInputFileData%Cpa = SrcInputFileData%Cpa
    DstInputFileData%dpa = SrcInputFileData%dpa
    DstInputFileData%Fdr = SrcInputFileData%Fdr
    DstInputFileData%Kic = SrcInputFileData%Kic
    DstInputFileData%FspN = SrcInputFileData%FspN
 END SUBROUTINE IceD_CopyInputFile

 SUBROUTINE IceD_DestroyInputFile( InputFileData, ErrStat, ErrMsg )
  TYPE(IceD_InputFile), INTENT(INOUT) :: InputFileData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyInputFile'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputFileData%LegPosX)) THEN
  DEALLOCATE(InputFileData%LegPosX)
ENDIF
IF (ALLOCATED(InputFileData%LegPosY)) THEN
  DEALLOCATE(InputFileData%LegPosY)
ENDIF
IF (ALLOCATED(InputFileData%StrWd)) THEN
  DEALLOCATE(InputFileData%StrWd)
ENDIF
 END SUBROUTINE IceD_DestroyInputFile

 SUBROUTINE IceD_PackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_InputFile),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackInputFile'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! IceModel
      Int_BufSz  = Int_BufSz  + 1  ! IceSubModel
      Re_BufSz   = Re_BufSz   + 1  ! h
      Re_BufSz   = Re_BufSz   + 1  ! v
      Re_BufSz   = Re_BufSz   + 1  ! InitLoc
      Re_BufSz   = Re_BufSz   + 1  ! t0
      Re_BufSz   = Re_BufSz   + 1  ! rhow
      Re_BufSz   = Re_BufSz   + 1  ! rhoi
      Int_BufSz  = Int_BufSz  + 1  ! Seed1
      Int_BufSz  = Int_BufSz  + 1  ! Seed2
      Int_BufSz  = Int_BufSz  + 1  ! NumLegs
  Int_BufSz   = Int_BufSz   + 1     ! LegPosX allocated yes/no
  IF ( ALLOCATED(InData%LegPosX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LegPosX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LegPosX)  ! LegPosX
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LegPosY allocated yes/no
  IF ( ALLOCATED(InData%LegPosY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LegPosY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LegPosY)  ! LegPosY
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StrWd allocated yes/no
  IF ( ALLOCATED(InData%StrWd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StrWd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StrWd)  ! StrWd
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Ikm
      Re_BufSz   = Re_BufSz   + 1  ! Ag
      Re_BufSz   = Re_BufSz   + 1  ! Qg
      Re_BufSz   = Re_BufSz   + 1  ! Rg
      Re_BufSz   = Re_BufSz   + 1  ! Tice
      Re_BufSz   = Re_BufSz   + 1  ! nu
      Re_BufSz   = Re_BufSz   + 1  ! phi
      Re_BufSz   = Re_BufSz   + 1  ! SigNm
      Re_BufSz   = Re_BufSz   + 1  ! Eice
      Re_BufSz   = Re_BufSz   + 1  ! IceStr2
      Re_BufSz   = Re_BufSz   + 1  ! Delmax2
      Re_BufSz   = Re_BufSz   + 1  ! Pitch
      Re_BufSz   = Re_BufSz   + 1  ! miuh
      Re_BufSz   = Re_BufSz   + 1  ! varh
      Re_BufSz   = Re_BufSz   + 1  ! miuv
      Re_BufSz   = Re_BufSz   + 1  ! varv
      Re_BufSz   = Re_BufSz   + 1  ! miut
      Re_BufSz   = Re_BufSz   + 1  ! miubr
      Re_BufSz   = Re_BufSz   + 1  ! varbr
      Re_BufSz   = Re_BufSz   + 1  ! miuDelm
      Re_BufSz   = Re_BufSz   + 1  ! varDelm
      Re_BufSz   = Re_BufSz   + 1  ! miuP
      Re_BufSz   = Re_BufSz   + 1  ! varP
      Int_BufSz  = Int_BufSz  + 1  ! Zn1
      Int_BufSz  = Int_BufSz  + 1  ! Zn2
      Re_BufSz   = Re_BufSz   + 1  ! ZonePitch
      Re_BufSz   = Re_BufSz   + 1  ! PrflMean
      Re_BufSz   = Re_BufSz   + 1  ! PrflSig
      Re_BufSz   = Re_BufSz   + 1  ! IceStr
      Re_BufSz   = Re_BufSz   + 1  ! Delmax
      Re_BufSz   = Re_BufSz   + 1  ! alpha
      Re_BufSz   = Re_BufSz   + 1  ! Dwl
      Re_BufSz   = Re_BufSz   + 1  ! Dtp
      Re_BufSz   = Re_BufSz   + 1  ! hr
      Re_BufSz   = Re_BufSz   + 1  ! mu
      Re_BufSz   = Re_BufSz   + 1  ! sigf
      Re_BufSz   = Re_BufSz   + 1  ! StrLim
      Re_BufSz   = Re_BufSz   + 1  ! StrRtLim
      Int_BufSz  = Int_BufSz  + 1  ! UorD
      Re_BufSz   = Re_BufSz   + 1  ! Ll
      Re_BufSz   = Re_BufSz   + 1  ! Lw
      Re_BufSz   = Re_BufSz   + 1  ! Cpa
      Re_BufSz   = Re_BufSz   + 1  ! dpa
      Re_BufSz   = Re_BufSz   + 1  ! Fdr
      Re_BufSz   = Re_BufSz   + 1  ! Kic
      Re_BufSz   = Re_BufSz   + 1  ! FspN
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%IceModel
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IceSubModel
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%h
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%v
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%InitLoc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%t0
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rhow
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rhoi
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Seed1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Seed2
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumLegs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%LegPosX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LegPosX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LegPosX,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LegPosX,1), UBOUND(InData%LegPosX,1)
        ReKiBuf(Re_Xferred) = InData%LegPosX(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LegPosY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LegPosY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LegPosY,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LegPosY,1), UBOUND(InData%LegPosY,1)
        ReKiBuf(Re_Xferred) = InData%LegPosY(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StrWd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StrWd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StrWd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StrWd,1), UBOUND(InData%StrWd,1)
        ReKiBuf(Re_Xferred) = InData%StrWd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Ikm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Ag
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Qg
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Rg
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Tice
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%nu
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%phi
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SigNm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Eice
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%IceStr2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Delmax2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Pitch
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miuh
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%varh
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miuv
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%varv
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miut
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miubr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%varbr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miuDelm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%varDelm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%miuP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%varP
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Zn1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Zn2
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ZonePitch
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PrflMean
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PrflSig
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%IceStr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Delmax
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alpha
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Dwl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Dtp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%hr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%mu
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%sigf
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%StrLim
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%StrRtLim
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UorD
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Ll
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Lw
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cpa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dpa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Fdr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kic
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FspN
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_PackInputFile

 SUBROUTINE IceD_UnPackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_InputFile), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackInputFile'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%IceModel = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%IceSubModel = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%h = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%v = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%InitLoc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%t0 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rhow = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rhoi = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Seed1 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Seed2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumLegs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LegPosX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LegPosX)) DEALLOCATE(OutData%LegPosX)
    ALLOCATE(OutData%LegPosX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LegPosX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LegPosX,1), UBOUND(OutData%LegPosX,1)
        OutData%LegPosX(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LegPosY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LegPosY)) DEALLOCATE(OutData%LegPosY)
    ALLOCATE(OutData%LegPosY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LegPosY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LegPosY,1), UBOUND(OutData%LegPosY,1)
        OutData%LegPosY(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StrWd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StrWd)) DEALLOCATE(OutData%StrWd)
    ALLOCATE(OutData%StrWd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StrWd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StrWd,1), UBOUND(OutData%StrWd,1)
        OutData%StrWd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Ikm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Ag = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Qg = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Rg = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Tice = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%nu = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%phi = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SigNm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Eice = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%IceStr2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Delmax2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Pitch = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miuh = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%varh = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miuv = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%varv = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miut = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miubr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%varbr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miuDelm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%varDelm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%miuP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%varP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Zn1 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Zn2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ZonePitch = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PrflMean = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PrflSig = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%IceStr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Delmax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alpha = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Dwl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Dtp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%hr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%mu = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%sigf = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%StrLim = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%StrRtLim = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%UorD = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Ll = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Lw = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cpa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dpa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Fdr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kic = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FspN = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_UnPackInputFile

 SUBROUTINE IceD_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(IceD_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%InputFile = SrcInitInputData%InputFile
    DstInitInputData%RootName = SrcInitInputData%RootName
    DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
    DstInitInputData%WtrDens = SrcInitInputData%WtrDens
    DstInitInputData%gravity = SrcInitInputData%gravity
    DstInitInputData%LegNum = SrcInitInputData%LegNum
    DstInitInputData%TMax = SrcInitInputData%TMax
 END SUBROUTINE IceD_CopyInitInput

 SUBROUTINE IceD_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(IceD_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE IceD_DestroyInitInput

 SUBROUTINE IceD_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%InputFile)  ! InputFile
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Re_BufSz   = Re_BufSz   + 1  ! MSL2SWL
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
      Re_BufSz   = Re_BufSz   + 1  ! gravity
      Int_BufSz  = Int_BufSz  + 1  ! LegNum
      Db_BufSz   = Db_BufSz   + 1  ! TMax
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%InputFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%InputFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    ReKiBuf(Re_Xferred) = InData%MSL2SWL
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%gravity
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%LegNum
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%TMax
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE IceD_PackInitInput

 SUBROUTINE IceD_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%InputFile)
      OutData%InputFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%MSL2SWL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%LegNum = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TMax = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE IceD_UnPackInitInput

 SUBROUTINE IceD_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(IceD_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
    DstInitOutputData%numLegs = SrcInitOutputData%numLegs
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE IceD_CopyInitOutput

 SUBROUTINE IceD_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(IceD_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE IceD_DestroyInitOutput

 SUBROUTINE IceD_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numLegs
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numLegs
    Int_Xferred = Int_Xferred + 1
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE IceD_PackInitOutput

 SUBROUTINE IceD_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    OutData%numLegs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE IceD_UnPackInitOutput

 SUBROUTINE IceD_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(IceD_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%q = SrcContStateData%q
    DstContStateData%dqdt = SrcContStateData%dqdt
 END SUBROUTINE IceD_CopyContState

 SUBROUTINE IceD_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(IceD_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE IceD_DestroyContState

 SUBROUTINE IceD_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! q
      Re_BufSz   = Re_BufSz   + 1  ! dqdt
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dqdt
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_PackContState

 SUBROUTINE IceD_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dqdt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_UnPackContState

 SUBROUTINE IceD_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(IceD_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
 END SUBROUTINE IceD_CopyDiscState

 SUBROUTINE IceD_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(IceD_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE IceD_DestroyDiscState

 SUBROUTINE IceD_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyDiscState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyDiscState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_PackDiscState

 SUBROUTINE IceD_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyDiscState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_UnPackDiscState

 SUBROUTINE IceD_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(IceD_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
 END SUBROUTINE IceD_CopyConstrState

 SUBROUTINE IceD_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(IceD_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE IceD_DestroyConstrState

 SUBROUTINE IceD_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstrState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstrState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_PackConstrState

 SUBROUTINE IceD_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstrState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_UnPackConstrState

 SUBROUTINE IceD_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(IceD_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%IceTthNo2 = SrcOtherStateData%IceTthNo2
IF (ALLOCATED(SrcOtherStateData%Nc)) THEN
  i1_l = LBOUND(SrcOtherStateData%Nc,1)
  i1_u = UBOUND(SrcOtherStateData%Nc,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%Nc)) THEN 
    ALLOCATE(DstOtherStateData%Nc(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Nc.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%Nc = SrcOtherStateData%Nc
ENDIF
IF (ALLOCATED(SrcOtherStateData%Psum)) THEN
  i1_l = LBOUND(SrcOtherStateData%Psum,1)
  i1_u = UBOUND(SrcOtherStateData%Psum,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%Psum)) THEN 
    ALLOCATE(DstOtherStateData%Psum(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%Psum.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%Psum = SrcOtherStateData%Psum
ENDIF
IF (ALLOCATED(SrcOtherStateData%IceTthNo)) THEN
  i1_l = LBOUND(SrcOtherStateData%IceTthNo,1)
  i1_u = UBOUND(SrcOtherStateData%IceTthNo,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%IceTthNo)) THEN 
    ALLOCATE(DstOtherStateData%IceTthNo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IceTthNo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%IceTthNo = SrcOtherStateData%IceTthNo
ENDIF
    DstOtherStateData%Beta = SrcOtherStateData%Beta
    DstOtherStateData%Tinit = SrcOtherStateData%Tinit
    DstOtherStateData%Splitf = SrcOtherStateData%Splitf
    DstOtherStateData%dxc = SrcOtherStateData%dxc
IF (ALLOCATED(SrcOtherStateData%xdot)) THEN
  i1_l = LBOUND(SrcOtherStateData%xdot,1)
  i1_u = UBOUND(SrcOtherStateData%xdot,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%xdot)) THEN 
    ALLOCATE(DstOtherStateData%xdot(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%xdot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcOtherStateData%xdot,1), UBOUND(SrcOtherStateData%xdot,1)
      CALL IceD_CopyContState( SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstOtherStateData%n = SrcOtherStateData%n
 END SUBROUTINE IceD_CopyOtherState

 SUBROUTINE IceD_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(IceD_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OtherStateData%Nc)) THEN
  DEALLOCATE(OtherStateData%Nc)
ENDIF
IF (ALLOCATED(OtherStateData%Psum)) THEN
  DEALLOCATE(OtherStateData%Psum)
ENDIF
IF (ALLOCATED(OtherStateData%IceTthNo)) THEN
  DEALLOCATE(OtherStateData%IceTthNo)
ENDIF
IF (ALLOCATED(OtherStateData%xdot)) THEN
DO i1 = LBOUND(OtherStateData%xdot,1), UBOUND(OtherStateData%xdot,1)
  CALL IceD_DestroyContState( OtherStateData%xdot(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(OtherStateData%xdot)
ENDIF
 END SUBROUTINE IceD_DestroyOtherState

 SUBROUTINE IceD_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! IceTthNo2
  Int_BufSz   = Int_BufSz   + 1     ! Nc allocated yes/no
  IF ( ALLOCATED(InData%Nc) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Nc upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Nc)  ! Nc
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Psum allocated yes/no
  IF ( ALLOCATED(InData%Psum) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Psum upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Psum)  ! Psum
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! IceTthNo allocated yes/no
  IF ( ALLOCATED(InData%IceTthNo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IceTthNo upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%IceTthNo)  ! IceTthNo
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Beta
      Db_BufSz   = Db_BufSz   + 1  ! Tinit
      Int_BufSz  = Int_BufSz  + 1  ! Splitf
      Re_BufSz   = Re_BufSz   + 1  ! dxc
  Int_BufSz   = Int_BufSz   + 1     ! xdot allocated yes/no
  IF ( ALLOCATED(InData%xdot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! xdot upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      Int_BufSz   = Int_BufSz + 3  ! xdot: size of buffers for each call to pack subtype
      CALL IceD_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, .TRUE. ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! xdot
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! xdot
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! xdot
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! n
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%IceTthNo2
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Nc) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Nc,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Nc,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Nc,1), UBOUND(InData%Nc,1)
        IntKiBuf(Int_Xferred) = InData%Nc(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Psum) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Psum,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Psum,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Psum,1), UBOUND(InData%Psum,1)
        ReKiBuf(Re_Xferred) = InData%Psum(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%IceTthNo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IceTthNo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IceTthNo,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%IceTthNo,1), UBOUND(InData%IceTthNo,1)
        IntKiBuf(Int_Xferred) = InData%IceTthNo(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Beta
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%Tinit
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Splitf
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dxc
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%xdot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xdot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xdot,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      CALL IceD_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, OnlySize ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%n
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE IceD_PackOtherState

 SUBROUTINE IceD_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%IceTthNo2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Nc not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Nc)) DEALLOCATE(OutData%Nc)
    ALLOCATE(OutData%Nc(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Nc.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Nc,1), UBOUND(OutData%Nc,1)
        OutData%Nc(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Psum not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Psum)) DEALLOCATE(OutData%Psum)
    ALLOCATE(OutData%Psum(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Psum.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Psum,1), UBOUND(OutData%Psum,1)
        OutData%Psum(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IceTthNo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IceTthNo)) DEALLOCATE(OutData%IceTthNo)
    ALLOCATE(OutData%IceTthNo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IceTthNo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%IceTthNo,1), UBOUND(OutData%IceTthNo,1)
        OutData%IceTthNo(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%Beta = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Tinit = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%Splitf = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dxc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xdot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%xdot)) DEALLOCATE(OutData%xdot)
    ALLOCATE(OutData%xdot(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xdot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%xdot,1), UBOUND(OutData%xdot,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL IceD_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%xdot(i1), ErrStat2, ErrMsg2 ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%n = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE IceD_UnPackOtherState

 SUBROUTINE IceD_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(IceD_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMiscData%DummyMiscVar = SrcMiscData%DummyMiscVar
 END SUBROUTINE IceD_CopyMisc

 SUBROUTINE IceD_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(IceD_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE IceD_DestroyMisc

 SUBROUTINE IceD_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! DummyMiscVar
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%DummyMiscVar
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE IceD_PackMisc

 SUBROUTINE IceD_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyMiscVar = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE IceD_UnPackMisc

 SUBROUTINE IceD_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(IceD_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%h = SrcParamData%h
    DstParamData%v = SrcParamData%v
    DstParamData%t0 = SrcParamData%t0
    DstParamData%StrWd = SrcParamData%StrWd
    DstParamData%dt = SrcParamData%dt
    DstParamData%InitLoc = SrcParamData%InitLoc
    DstParamData%tolerance = SrcParamData%tolerance
    DstParamData%Tmax = SrcParamData%Tmax
    DstParamData%verif = SrcParamData%verif
    DstParamData%ModNo = SrcParamData%ModNo
    DstParamData%SubModNo = SrcParamData%SubModNo
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%method = SrcParamData%method
    DstParamData%TmStep = SrcParamData%TmStep
IF (ALLOCATED(SrcParamData%OutName)) THEN
  i1_l = LBOUND(SrcParamData%OutName,1)
  i1_u = UBOUND(SrcParamData%OutName,1)
  IF (.NOT. ALLOCATED(DstParamData%OutName)) THEN 
    ALLOCATE(DstParamData%OutName(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutName.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%OutName = SrcParamData%OutName
ENDIF
IF (ALLOCATED(SrcParamData%OutUnit)) THEN
  i1_l = LBOUND(SrcParamData%OutUnit,1)
  i1_u = UBOUND(SrcParamData%OutUnit,1)
  IF (.NOT. ALLOCATED(DstParamData%OutUnit)) THEN 
    ALLOCATE(DstParamData%OutUnit(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutUnit.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%OutUnit = SrcParamData%OutUnit
ENDIF
    DstParamData%RootName = SrcParamData%RootName
    DstParamData%tm1a = SrcParamData%tm1a
    DstParamData%tm1b = SrcParamData%tm1b
    DstParamData%tm1c = SrcParamData%tm1c
    DstParamData%Fmax1a = SrcParamData%Fmax1a
    DstParamData%Fmax1b = SrcParamData%Fmax1b
    DstParamData%Fmax1c = SrcParamData%Fmax1c
    DstParamData%Ikm = SrcParamData%Ikm
    DstParamData%Cstr = SrcParamData%Cstr
    DstParamData%EiPa = SrcParamData%EiPa
    DstParamData%Delmax2 = SrcParamData%Delmax2
    DstParamData%Pitch = SrcParamData%Pitch
    DstParamData%Kice2 = SrcParamData%Kice2
IF (ALLOCATED(SrcParamData%rdmFm)) THEN
  i1_l = LBOUND(SrcParamData%rdmFm,1)
  i1_u = UBOUND(SrcParamData%rdmFm,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmFm)) THEN 
    ALLOCATE(DstParamData%rdmFm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmFm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmFm = SrcParamData%rdmFm
ENDIF
IF (ALLOCATED(SrcParamData%rdmt0)) THEN
  i1_l = LBOUND(SrcParamData%rdmt0,1)
  i1_u = UBOUND(SrcParamData%rdmt0,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmt0)) THEN 
    ALLOCATE(DstParamData%rdmt0(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmt0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmt0 = SrcParamData%rdmt0
ENDIF
IF (ALLOCATED(SrcParamData%rdmtm)) THEN
  i1_l = LBOUND(SrcParamData%rdmtm,1)
  i1_u = UBOUND(SrcParamData%rdmtm,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmtm)) THEN 
    ALLOCATE(DstParamData%rdmtm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmtm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmtm = SrcParamData%rdmtm
ENDIF
IF (ALLOCATED(SrcParamData%rdmDm)) THEN
  i1_l = LBOUND(SrcParamData%rdmDm,1)
  i1_u = UBOUND(SrcParamData%rdmDm,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmDm)) THEN 
    ALLOCATE(DstParamData%rdmDm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmDm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmDm = SrcParamData%rdmDm
ENDIF
IF (ALLOCATED(SrcParamData%rdmP)) THEN
  i1_l = LBOUND(SrcParamData%rdmP,1)
  i1_u = UBOUND(SrcParamData%rdmP,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmP)) THEN 
    ALLOCATE(DstParamData%rdmP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmP = SrcParamData%rdmP
ENDIF
IF (ALLOCATED(SrcParamData%rdmKi)) THEN
  i1_l = LBOUND(SrcParamData%rdmKi,1)
  i1_u = UBOUND(SrcParamData%rdmKi,1)
  IF (.NOT. ALLOCATED(DstParamData%rdmKi)) THEN 
    ALLOCATE(DstParamData%rdmKi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rdmKi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rdmKi = SrcParamData%rdmKi
ENDIF
    DstParamData%ZonePitch = SrcParamData%ZonePitch
    DstParamData%Kice = SrcParamData%Kice
    DstParamData%Delmax = SrcParamData%Delmax
IF (ALLOCATED(SrcParamData%Y0)) THEN
  i1_l = LBOUND(SrcParamData%Y0,1)
  i1_u = UBOUND(SrcParamData%Y0,1)
  IF (.NOT. ALLOCATED(DstParamData%Y0)) THEN 
    ALLOCATE(DstParamData%Y0(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Y0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Y0 = SrcParamData%Y0
ENDIF
IF (ALLOCATED(SrcParamData%ContPrfl)) THEN
  i1_l = LBOUND(SrcParamData%ContPrfl,1)
  i1_u = UBOUND(SrcParamData%ContPrfl,1)
  IF (.NOT. ALLOCATED(DstParamData%ContPrfl)) THEN 
    ALLOCATE(DstParamData%ContPrfl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ContPrfl.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ContPrfl = SrcParamData%ContPrfl
ENDIF
    DstParamData%Zn = SrcParamData%Zn
    DstParamData%rhoi = SrcParamData%rhoi
    DstParamData%rhow = SrcParamData%rhow
    DstParamData%alphaR = SrcParamData%alphaR
    DstParamData%Dwl = SrcParamData%Dwl
    DstParamData%Zr = SrcParamData%Zr
    DstParamData%RHbr = SrcParamData%RHbr
    DstParamData%RVbr = SrcParamData%RVbr
    DstParamData%Lbr = SrcParamData%Lbr
    DstParamData%LovR = SrcParamData%LovR
    DstParamData%mu = SrcParamData%mu
    DstParamData%Wri = SrcParamData%Wri
    DstParamData%WL = SrcParamData%WL
    DstParamData%Cpa = SrcParamData%Cpa
    DstParamData%dpa = SrcParamData%dpa
    DstParamData%FdrN = SrcParamData%FdrN
    DstParamData%Mice = SrcParamData%Mice
    DstParamData%Fsp = SrcParamData%Fsp
 END SUBROUTINE IceD_CopyParam

 SUBROUTINE IceD_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(IceD_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%OutName)) THEN
  DEALLOCATE(ParamData%OutName)
ENDIF
IF (ALLOCATED(ParamData%OutUnit)) THEN
  DEALLOCATE(ParamData%OutUnit)
ENDIF
IF (ALLOCATED(ParamData%rdmFm)) THEN
  DEALLOCATE(ParamData%rdmFm)
ENDIF
IF (ALLOCATED(ParamData%rdmt0)) THEN
  DEALLOCATE(ParamData%rdmt0)
ENDIF
IF (ALLOCATED(ParamData%rdmtm)) THEN
  DEALLOCATE(ParamData%rdmtm)
ENDIF
IF (ALLOCATED(ParamData%rdmDm)) THEN
  DEALLOCATE(ParamData%rdmDm)
ENDIF
IF (ALLOCATED(ParamData%rdmP)) THEN
  DEALLOCATE(ParamData%rdmP)
ENDIF
IF (ALLOCATED(ParamData%rdmKi)) THEN
  DEALLOCATE(ParamData%rdmKi)
ENDIF
IF (ALLOCATED(ParamData%Y0)) THEN
  DEALLOCATE(ParamData%Y0)
ENDIF
IF (ALLOCATED(ParamData%ContPrfl)) THEN
  DEALLOCATE(ParamData%ContPrfl)
ENDIF
 END SUBROUTINE IceD_DestroyParam

 SUBROUTINE IceD_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! h
      Re_BufSz   = Re_BufSz   + 1  ! v
      Re_BufSz   = Re_BufSz   + 1  ! t0
      Re_BufSz   = Re_BufSz   + 1  ! StrWd
      Re_BufSz   = Re_BufSz   + 1  ! dt
      Re_BufSz   = Re_BufSz   + 1  ! InitLoc
      Re_BufSz   = Re_BufSz   + 1  ! tolerance
      Re_BufSz   = Re_BufSz   + 1  ! Tmax
      Int_BufSz  = Int_BufSz  + 1  ! verif
      Int_BufSz  = Int_BufSz  + 1  ! ModNo
      Int_BufSz  = Int_BufSz  + 1  ! SubModNo
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! method
      Int_BufSz  = Int_BufSz  + 1  ! TmStep
  Int_BufSz   = Int_BufSz   + 1     ! OutName allocated yes/no
  IF ( ALLOCATED(InData%OutName) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutName upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%OutName)*LEN(InData%OutName)  ! OutName
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OutUnit allocated yes/no
  IF ( ALLOCATED(InData%OutUnit) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutUnit upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%OutUnit)*LEN(InData%OutUnit)  ! OutUnit
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Re_BufSz   = Re_BufSz   + 1  ! tm1a
      Re_BufSz   = Re_BufSz   + 1  ! tm1b
      Re_BufSz   = Re_BufSz   + 1  ! tm1c
      Re_BufSz   = Re_BufSz   + 1  ! Fmax1a
      Re_BufSz   = Re_BufSz   + 1  ! Fmax1b
      Re_BufSz   = Re_BufSz   + 1  ! Fmax1c
      Re_BufSz   = Re_BufSz   + 1  ! Ikm
      Re_BufSz   = Re_BufSz   + 1  ! Cstr
      Re_BufSz   = Re_BufSz   + 1  ! EiPa
      Re_BufSz   = Re_BufSz   + 1  ! Delmax2
      Re_BufSz   = Re_BufSz   + 1  ! Pitch
      Re_BufSz   = Re_BufSz   + 1  ! Kice2
  Int_BufSz   = Int_BufSz   + 1     ! rdmFm allocated yes/no
  IF ( ALLOCATED(InData%rdmFm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmFm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmFm)  ! rdmFm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rdmt0 allocated yes/no
  IF ( ALLOCATED(InData%rdmt0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmt0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmt0)  ! rdmt0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rdmtm allocated yes/no
  IF ( ALLOCATED(InData%rdmtm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmtm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmtm)  ! rdmtm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rdmDm allocated yes/no
  IF ( ALLOCATED(InData%rdmDm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmDm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmDm)  ! rdmDm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rdmP allocated yes/no
  IF ( ALLOCATED(InData%rdmP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmP)  ! rdmP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rdmKi allocated yes/no
  IF ( ALLOCATED(InData%rdmKi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rdmKi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rdmKi)  ! rdmKi
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! ZonePitch
      Re_BufSz   = Re_BufSz   + 1  ! Kice
      Re_BufSz   = Re_BufSz   + 1  ! Delmax
  Int_BufSz   = Int_BufSz   + 1     ! Y0 allocated yes/no
  IF ( ALLOCATED(InData%Y0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Y0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Y0)  ! Y0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ContPrfl allocated yes/no
  IF ( ALLOCATED(InData%ContPrfl) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ContPrfl upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ContPrfl)  ! ContPrfl
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! Zn
      Re_BufSz   = Re_BufSz   + 1  ! rhoi
      Re_BufSz   = Re_BufSz   + 1  ! rhow
      Re_BufSz   = Re_BufSz   + 1  ! alphaR
      Re_BufSz   = Re_BufSz   + 1  ! Dwl
      Re_BufSz   = Re_BufSz   + 1  ! Zr
      Re_BufSz   = Re_BufSz   + 1  ! RHbr
      Re_BufSz   = Re_BufSz   + 1  ! RVbr
      Re_BufSz   = Re_BufSz   + 1  ! Lbr
      Re_BufSz   = Re_BufSz   + 1  ! LovR
      Re_BufSz   = Re_BufSz   + 1  ! mu
      Re_BufSz   = Re_BufSz   + 1  ! Wri
      Re_BufSz   = Re_BufSz   + 1  ! WL
      Re_BufSz   = Re_BufSz   + 1  ! Cpa
      Re_BufSz   = Re_BufSz   + 1  ! dpa
      Re_BufSz   = Re_BufSz   + 1  ! FdrN
      Re_BufSz   = Re_BufSz   + 1  ! Mice
      Re_BufSz   = Re_BufSz   + 1  ! Fsp
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%h
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%v
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%t0
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%StrWd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%InitLoc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tolerance
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Tmax
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%verif
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ModNo
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%SubModNo
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%method
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TmStep
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutName) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutName,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutName,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutName,1), UBOUND(InData%OutName,1)
        DO I = 1, LEN(InData%OutName)
          IntKiBuf(Int_Xferred) = ICHAR(InData%OutName(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OutUnit) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutUnit,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutUnit,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutUnit,1), UBOUND(InData%OutUnit,1)
        DO I = 1, LEN(InData%OutUnit)
          IntKiBuf(Int_Xferred) = ICHAR(InData%OutUnit(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    ReKiBuf(Re_Xferred) = InData%tm1a
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tm1b
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tm1c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Fmax1a
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Fmax1b
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Fmax1c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Ikm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cstr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%EiPa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Delmax2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Pitch
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kice2
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%rdmFm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmFm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmFm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmFm,1), UBOUND(InData%rdmFm,1)
        ReKiBuf(Re_Xferred) = InData%rdmFm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rdmt0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmt0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmt0,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmt0,1), UBOUND(InData%rdmt0,1)
        ReKiBuf(Re_Xferred) = InData%rdmt0(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rdmtm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmtm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmtm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmtm,1), UBOUND(InData%rdmtm,1)
        ReKiBuf(Re_Xferred) = InData%rdmtm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rdmDm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmDm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmDm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmDm,1), UBOUND(InData%rdmDm,1)
        ReKiBuf(Re_Xferred) = InData%rdmDm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rdmP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmP,1), UBOUND(InData%rdmP,1)
        ReKiBuf(Re_Xferred) = InData%rdmP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rdmKi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rdmKi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rdmKi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rdmKi,1), UBOUND(InData%rdmKi,1)
        ReKiBuf(Re_Xferred) = InData%rdmKi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%ZonePitch
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kice
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Delmax
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Y0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Y0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Y0,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Y0,1), UBOUND(InData%Y0,1)
        ReKiBuf(Re_Xferred) = InData%Y0(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ContPrfl) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ContPrfl,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ContPrfl,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ContPrfl,1), UBOUND(InData%ContPrfl,1)
        ReKiBuf(Re_Xferred) = InData%ContPrfl(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%Zn
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rhoi
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rhow
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alphaR
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Dwl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Zr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RHbr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RVbr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Lbr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%LovR
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%mu
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Wri
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WL
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cpa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dpa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FdrN
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Mice
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Fsp
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_PackParam

 SUBROUTINE IceD_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%h = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%v = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%t0 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%StrWd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%InitLoc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%tolerance = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Tmax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%verif = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ModNo = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%SubModNo = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%method = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TmStep = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutName not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutName)) DEALLOCATE(OutData%OutName)
    ALLOCATE(OutData%OutName(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutName.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutName,1), UBOUND(OutData%OutName,1)
        DO I = 1, LEN(OutData%OutName)
          OutData%OutName(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutUnit not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutUnit)) DEALLOCATE(OutData%OutUnit)
    ALLOCATE(OutData%OutUnit(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutUnit.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutUnit,1), UBOUND(OutData%OutUnit,1)
        DO I = 1, LEN(OutData%OutUnit)
          OutData%OutUnit(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%tm1a = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%tm1b = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%tm1c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Fmax1a = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Fmax1b = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Fmax1c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Ikm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cstr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%EiPa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Delmax2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Pitch = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kice2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmFm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmFm)) DEALLOCATE(OutData%rdmFm)
    ALLOCATE(OutData%rdmFm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmFm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmFm,1), UBOUND(OutData%rdmFm,1)
        OutData%rdmFm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmt0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmt0)) DEALLOCATE(OutData%rdmt0)
    ALLOCATE(OutData%rdmt0(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmt0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmt0,1), UBOUND(OutData%rdmt0,1)
        OutData%rdmt0(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmtm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmtm)) DEALLOCATE(OutData%rdmtm)
    ALLOCATE(OutData%rdmtm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmtm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmtm,1), UBOUND(OutData%rdmtm,1)
        OutData%rdmtm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmDm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmDm)) DEALLOCATE(OutData%rdmDm)
    ALLOCATE(OutData%rdmDm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmDm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmDm,1), UBOUND(OutData%rdmDm,1)
        OutData%rdmDm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmP)) DEALLOCATE(OutData%rdmP)
    ALLOCATE(OutData%rdmP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmP,1), UBOUND(OutData%rdmP,1)
        OutData%rdmP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rdmKi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rdmKi)) DEALLOCATE(OutData%rdmKi)
    ALLOCATE(OutData%rdmKi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rdmKi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rdmKi,1), UBOUND(OutData%rdmKi,1)
        OutData%rdmKi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%ZonePitch = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kice = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Delmax = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Y0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Y0)) DEALLOCATE(OutData%Y0)
    ALLOCATE(OutData%Y0(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Y0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Y0,1), UBOUND(OutData%Y0,1)
        OutData%Y0(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ContPrfl not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ContPrfl)) DEALLOCATE(OutData%ContPrfl)
    ALLOCATE(OutData%ContPrfl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ContPrfl.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ContPrfl,1), UBOUND(OutData%ContPrfl,1)
        OutData%ContPrfl(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Zn = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%rhoi = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rhow = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alphaR = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Dwl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Zr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RHbr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RVbr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Lbr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%LovR = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%mu = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Wri = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cpa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dpa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FdrN = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Mice = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Fsp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE IceD_UnPackParam

 SUBROUTINE IceD_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(IceD_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL MeshCopy( SrcInputData%PointMesh, DstInputData%PointMesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE IceD_CopyInput

 SUBROUTINE IceD_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(IceD_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MeshDestroy( InputData%PointMesh, ErrStat, ErrMsg )
 END SUBROUTINE IceD_DestroyInput

 SUBROUTINE IceD_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! PointMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PointMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PointMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PointMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL MeshPack( InData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE IceD_PackInput

 SUBROUTINE IceD_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE IceD_UnPackInput

 SUBROUTINE IceD_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(IceD_OutputType), INTENT(INOUT) :: SrcOutputData
   TYPE(IceD_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL MeshCopy( SrcOutputData%PointMesh, DstOutputData%PointMesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
 END SUBROUTINE IceD_CopyOutput

 SUBROUTINE IceD_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(IceD_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'IceD_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MeshDestroy( OutputData%PointMesh, ErrStat, ErrMsg )
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
 END SUBROUTINE IceD_DestroyOutput

 SUBROUTINE IceD_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(IceD_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! PointMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PointMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PointMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PointMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL MeshPack( InData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE IceD_PackOutput

 SUBROUTINE IceD_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(IceD_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'IceD_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%PointMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! PointMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE IceD_UnPackOutput


 SUBROUTINE IceD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(IceD_InputType), INTENT(INOUT)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(IceD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'IceD_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL IceD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL IceD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL IceD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE IceD_Input_ExtrapInterp


 SUBROUTINE IceD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(IceD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
 TYPE(IceD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(IceD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'IceD_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
      CALL MeshExtrapInterp1(u1%PointMesh, u2%PointMesh, tin, u_out%PointMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE IceD_Input_ExtrapInterp1


 SUBROUTINE IceD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(IceD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
 TYPE(IceD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
 TYPE(IceD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(IceD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'IceD_Input_ExtrapInterp2'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
      CALL MeshExtrapInterp2(u1%PointMesh, u2%PointMesh, u3%PointMesh, tin, u_out%PointMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE IceD_Input_ExtrapInterp2


 SUBROUTINE IceD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(IceD_OutputType), INTENT(INOUT)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'IceD_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL IceD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL IceD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL IceD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE IceD_Output_ExtrapInterp


 SUBROUTINE IceD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(IceD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'IceD_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
      CALL MeshExtrapInterp1(y1%PointMesh, y2%PointMesh, tin, y_out%PointMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE IceD_Output_ExtrapInterp1


 SUBROUTINE IceD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(IceD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(IceD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'IceD_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
      CALL MeshExtrapInterp2(y1%PointMesh, y2%PointMesh, y3%PointMesh, tin, y_out%PointMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE IceD_Output_ExtrapInterp2

END MODULE IceDyn_Types
!ENDOFREGISTRYGENERATEDFILE
