!STARTOFREGISTRYGENERATEDFILE 'Morison_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! Morison_Types
!.................................................................................................................................
! This file is part of Morison.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in Morison. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE Morison_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MaxMrsnOutputs = 4599      ! Total number of possible Morison module output channels [-]
! =========  Morison_JointType  =======
  TYPE, PUBLIC :: Morison_JointType
    INTEGER(IntKi)  :: JointID      !< User-specified integer ID for the given joint [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Position      !< Undisplaced location of the joint in the platform coordinate system [m]
    INTEGER(IntKi)  :: JointAxID      !< Axial ID (found in the user-supplied Axial Coefficients Table) for this joint: used to determine axial coefs [-]
    INTEGER(IntKi)  :: JointAxIDIndx      !< The index into the Axial Coefs arrays corresponding to the above Axial ID [-]
    INTEGER(IntKi)  :: JointOvrlp      !< Joint overlap code [Unused [-]
    INTEGER(IntKi)  :: NConnections      !< Number of members connecting to this joint [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: ConnectionList      !< List of Members connected to this joint.  The member index is what is stored, not the Member ID [-]
  END TYPE Morison_JointType
! =======================
! =========  Morison_MemberPropType  =======
  TYPE, PUBLIC :: Morison_MemberPropType
    INTEGER(IntKi)  :: PropSetID      !< User-specified integer ID for this group of properties [-]
    REAL(ReKi)  :: PropD      !< Diameter [m]
    REAL(ReKi)  :: PropThck      !< Wall thickness [m]
  END TYPE Morison_MemberPropType
! =======================
! =========  Morison_FilledGroupType  =======
  TYPE, PUBLIC :: Morison_FilledGroupType
    INTEGER(IntKi)  :: FillNumM      !< Number of members in the Fill Group [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: FillMList      !< List of Member IDs for the members in this fill group [-]
    REAL(ReKi)  :: FillFSLoc      !< The free-surface location (in Z) for this fill group [m]
    CHARACTER(80)  :: FillDensChr      !< String version of the Fill density [can be DEFAULT which sets the fill density to WtrDens] [kg/m^3]
    REAL(ReKi)  :: FillDens      !< Numerical fill density [kg/m^3]
  END TYPE Morison_FilledGroupType
! =======================
! =========  Morison_CoefDpths  =======
  TYPE, PUBLIC :: Morison_CoefDpths
    REAL(ReKi)  :: Dpth      !< Depth location for these depth-based hydrodynamic coefs [m]
    REAL(ReKi)  :: DpthCd      !< Depth-based drag coef [-]
    REAL(ReKi)  :: DpthCdMG      !< Depth-based drag coef for marine growth [-]
    REAL(ReKi)  :: DpthCa      !< Depth-based Ca [-]
    REAL(ReKi)  :: DpthCaMG      !< Depth-based Ca for marine growth [-]
    REAL(ReKi)  :: DpthCp      !< Depth-based Cp [-]
    REAL(ReKi)  :: DpthCpMG      !< Depth-based Cp for marine growth [-]
    REAL(ReKi)  :: DpthAxCd      !< Depth-based Axial Cd [-]
    REAL(ReKi)  :: DpthAxCdMG      !< Depth-based Axial Cd for marine growth [-]
    REAL(ReKi)  :: DpthAxCa      !< Depth-based Axial Ca [-]
    REAL(ReKi)  :: DpthAxCaMG      !< Depth-based Axial Ca for marine growth [-]
    REAL(ReKi)  :: DpthAxCp      !< Depth-based Axial Cp [-]
    REAL(ReKi)  :: DpthAxCpMG      !< Depth-based Axial Cp for marine growth [-]
  END TYPE Morison_CoefDpths
! =======================
! =========  Morison_AxialCoefType  =======
  TYPE, PUBLIC :: Morison_AxialCoefType
    INTEGER(IntKi)  :: AxCoefID      !< User-supplied integer ID for this set of Axial coefs [-]
    REAL(ReKi)  :: AxCd      !< Axial Cd [-]
    REAL(ReKi)  :: AxCa      !< Axial Ca [-]
    REAL(ReKi)  :: AxCp      !< Axial Cp [-]
  END TYPE Morison_AxialCoefType
! =======================
! =========  Morison_MemberInputType  =======
  TYPE, PUBLIC :: Morison_MemberInputType
    INTEGER(IntKi)  :: MemberID      !< User-supplied integer ID for this member [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeIndx      !< Index of each of the member's nodes in the master node list [-]
    INTEGER(IntKi)  :: MJointID1      !< Joint ID for start of member [-]
    INTEGER(IntKi)  :: MJointID2      !< Joint ID for end of member [-]
    INTEGER(IntKi)  :: MJointID1Indx      !< Index into the joint table for the start of this member [-]
    INTEGER(IntKi)  :: MJointID2Indx      !< Index into the joint table for the end of this member [-]
    INTEGER(IntKi)  :: MPropSetID1      !< Property set ID for the start of this member [-]
    INTEGER(IntKi)  :: MPropSetID2      !< Property set ID for the end of this member [-]
    INTEGER(IntKi)  :: MPropSetID1Indx      !< Index into the Property table for the start of this member [-]
    INTEGER(IntKi)  :: MPropSetID2Indx      !< Index into the Property table for the end of this member [-]
    REAL(ReKi)  :: MDivSize      !< User-specified desired member discretization size for the final element [m]
    INTEGER(IntKi)  :: MCoefMod      !< Which coef. model is being used for this member [1=simple, 2=depth-based, 3=member-based] [-]
    INTEGER(IntKi)  :: MmbrCoefIDIndx      !< Index into the appropriate coefs table for this member's properties [-]
    INTEGER(IntKi)  :: MmbrFilledIDIndx      !< Index into the filled group table if this is a filled member [-]
    LOGICAL  :: PropPot      !< Flag T/F for whether the member is modeled with potential flow theory [-]
    INTEGER(IntKi)  :: NElements      !< number of elements in this member [-]
    REAL(ReKi)  :: RefLength      !< the reference total length for this member [m]
    REAL(ReKi)  :: dl      !< the reference element length for this member (may be less than MDivSize to achieve uniform element lengths) [m]
  END TYPE Morison_MemberInputType
! =======================
! =========  Morison_NodeType  =======
  TYPE, PUBLIC :: Morison_NodeType
    INTEGER(IntKi)  :: JointIndx      !< Joint index from the user joint table that this node corresponds to.  If the software created this node, index is set to -1 [-]
    REAL(ReKi) , DIMENSION(1:3)  :: Position      !< Position of the node in global coordinates [m]
    INTEGER(IntKi)  :: JointOvrlp      !<  [-]
    INTEGER(IntKi)  :: JointAxIDIndx      !<  [-]
    INTEGER(IntKi)  :: NConnections      !< Number of elements connecting to this node [-]
    INTEGER(IntKi) , DIMENSION(1:10)  :: ConnectionList      !< Indices of all the members connected to this node (positive if end 1, negative if end 2) [-]
    REAL(ReKi)  :: JAxCd      !< Nodal lumped (joint) axial Cd [-]
    REAL(ReKi)  :: JAxCa      !< Nodal lumped (joint) axial Cp [-]
    REAL(ReKi)  :: JAxCp      !< Nodal lumped (joint) axial Ca [-]
    REAL(ReKi)  :: FillDensity      !< Fill fluid density [kg/m^3]
    REAL(ReKi)  :: tMG      !< Nodal thickness with marine growth  [m]
    REAL(ReKi)  :: MGdensity      !< Nodal density of marine growth [kg/m^3]
  END TYPE Morison_NodeType
! =======================
! =========  Morison_MemberType  =======
  TYPE, PUBLIC :: Morison_MemberType
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NodeIndx      !< Index of each of the member's nodes in the master node list [-]
    INTEGER(IntKi)  :: MemberID      !< User-supplied integer ID for this member [-]
    INTEGER(IntKi)  :: NElements      !< number of elements in this member [-]
    REAL(ReKi)  :: RefLength      !< the reference total length for this member [m]
    REAL(ReKi)  :: cosPhi_ref      !< the reference cosine of the inclination angle of the member [-]
    REAL(ReKi)  :: dl      !< the reference element length for this member (may be less than MDivSize to achieve uniform element lengths) [m]
    REAL(ReKi) , DIMENSION(1:3)  :: k      !< unit vector of the member's orientation (may be changed to per-element once additional flexibility is accounted for in HydroDyn) [m]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: kkt      !< matrix of matmul(k_hat, transpose(k_hat) [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: Ak      !< matrix of I - kkt [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: R      !< outer member radius at each node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RMG      !< radius at each node including marine growth [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Rin      !< inner member radius at node, equivalent to radius of water ballast at this node if filled [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: tMG      !< Nodal thickness with marine growth (of member at node location) [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MGdensity      !< Nodal density of marine growth [kg/m^3]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dRdl_mg      !< taper dr/dl of outer surface including marine growth of each element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dRdl_in      !< taper dr/dl of interior surface of each element [-]
    REAL(ReKi)  :: Vinner      !< Member volume without marine growth [m^3]
    REAL(ReKi)  :: Vouter      !< Member volume including marine growth [m^3]
    REAL(ReKi)  :: Vballast      !< Member ballast volume [m^3]
    REAL(ReKi)  :: Vsubmerged      !< Submerged volume corresponding to portion of Member in the water [m^3]
    REAL(ReKi)  :: l_fill      !< fill length along member axis from start node 1 [m]
    REAL(ReKi)  :: h_fill      !< fill length of partially flooded element [m]
    REAL(ReKi)  :: z_overfill      !< if member is fully filled, the head height of the fill pressure at the end node N+1. Zero if member is partially filled. [m]
    REAL(ReKi)  :: h_floor      !< the distance from the node to the seabed along the member axis (negative value) [m]
    INTEGER(IntKi)  :: i_floor      !< the number of the element that pierces the seabed (zero if the member doesn't pierce it) [-]
    LOGICAL  :: doEndBuoyancy      !< compute the end plate effect for the hightest node of this member [-]
    INTEGER(IntKi)  :: memfloodstatus      !< Member-level flooded status for each elemen: 0 unflooded or fully below seabed, 2 partially flooded, 1 fully flooded  [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: floodstatus      !< flooded status for each element: 0 unflooded or fully below seabed, 1 fully flooded, 2 partially flooded [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha      !< relative volume centroid of each element including marine growth, from node i to node i+1 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_fb      !< relative volume centroid of each element's flooded ballast, from node i to node i+1 [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_fb_star      !< load distribution factor for each element after adjusting alpha_fb for node reference depths [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cd      !< Member Cd at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Ca      !< Member Ca at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cp      !< Member Cp at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCd      !< Member axial Cd at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCa      !< Member axial Ca at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AxCp      !< Member axial Cp at each node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_fb_l      !< mass of flooded ballast in lower portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_fb_u      !< mass of flooded ballast in upper portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cfb_l      !< distance to flooded ballast centroid from node point in lower portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cfb_u      !< distance to flooded ballast centroid from node point in upper portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lfb_l      !< axial moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lfb_u      !< axial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rfb_l      !< radial moment of inertia of flooded ballast in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rfb_u      !< radial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_mg_l      !< mass of marine growth in lower portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: m_mg_u      !< mass of marine growth in upper portion of each element [kg]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cmg_l      !< distance to marine growth centroid from node point in lower portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: h_cmg_u      !< distance to marine growth centroid from node point in upper portion of each element [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lmg_l      !< axial moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_lmg_u      !< axial moment of inertia of marine growth in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rmg_l      !< radial moment of inertia of marine growth in lower portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: I_rmg_u      !< radial moment of inertia of flooded ballast in upper portion of each element [kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cfl_fb      !< axial force constant due to flooded ballast, for each element [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Cfr_fb      !< radial force constant due to flooded ballast, for each element [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CM0_fb      !< moment constant due to flooded ballast, for each element about lower node [Nm]
    REAL(ReKi)  :: MGvolume      !< Volume of marine growth material for this member/element [m^3]
    REAL(ReKi)  :: MDivSize      !< User-requested final element length (actual length may vary from this request) [m]
    INTEGER(IntKi)  :: MCoefMod      !< Coefs model for member: 1 = simple, 2 =depth, 3 = member-based  [-]
    INTEGER(IntKi)  :: MmbrCoefIDIndx      !< If MCoefMod=3, then this is the index for the member's coefs in the master Member Coefs Table [-]
    INTEGER(IntKi)  :: MmbrFilledIDIndx      !< If this member is part of a fill group, this is the index into the master fill group table, if not = -1 [-]
    REAL(ReKi)  :: FillFSLoc      !< Z-location of the filled free-surface [m]
    REAL(ReKi)  :: FillDens      !< Filled fluid density [kg/m^3]
    LOGICAL  :: PropPot      !< Is this element/member modeled with potential flow theory T/F [-]
    LOGICAL  :: Flipped      !< Was the member flipped in a reordering event?  Need to know this to get the correct normal vector to the ends [-]
  END TYPE Morison_MemberType
! =======================
! =========  Morison_MemberLoads  =======
  TYPE, PUBLIC :: Morison_MemberLoads
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_D      !< Member-based (side-effects) Nodal viscous drag loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_I      !< Member-based (side-effects) Nodal inertial loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_A      !< Member-based (side-effects) Nodal added mass loads at time t [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_B      !< Member-based (side-effects) Nodal buoyancy loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_BF      !< Member-based (side-effects) Nodal flooded ballast weight/buoyancy loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_If      !< Member-based (side-effects) Nodal flooded ballast inertia loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_WMG      !< Member-based (side-effects) Nodal marine growth weight loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_IMG      !< Member-based (side-effects) Nodal marine growth inertia loads [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FV      !< Fluid velocity at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FA      !< Fluid acceleration at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_DP      !< Lumped dynamic pressure loads at time t, which may not correspond to the WaveTime array of times [-]
  END TYPE Morison_MemberLoads
! =======================
! =========  Morison_CoefMembers  =======
  TYPE, PUBLIC :: Morison_CoefMembers
    INTEGER(IntKi)  :: MemberID      !< User-specified integer id for the Member-based coefs [-]
    REAL(ReKi)  :: MemberCd1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCd2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCdMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCa1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCa2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCaMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCp2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberCpMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCd2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCdMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCa2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCaMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCp2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG1      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
    REAL(ReKi)  :: MemberAxCpMG2      !< Member-based coefs, see above descriptions for meanings (1 = start, 2=end) [-]
  END TYPE Morison_CoefMembers
! =======================
! =========  Morison_MGDepthsType  =======
  TYPE, PUBLIC :: Morison_MGDepthsType
    REAL(ReKi)  :: MGDpth      !< Marine growth depth location for these properties [m]
    REAL(ReKi)  :: MGThck      !< Marine growth thickness [m]
    REAL(ReKi)  :: MGDens      !< Marine growth density [kg/m^3]
  END TYPE Morison_MGDepthsType
! =======================
! =========  Morison_MOutput  =======
  TYPE, PUBLIC :: Morison_MOutput
    INTEGER(IntKi)  :: MemberID      !< Member ID for requested output [-]
    INTEGER(IntKi)  :: NOutLoc      !< The number of requested output locations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NodeLocs      !< Normalized locations along user-specified member for the outputs [-]
    INTEGER(IntKi)  :: MemberIDIndx      !< Index for member in the master list [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MeshIndx1      !< Index of node in Mesh for the start of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MeshIndx2      !< Index of node in Mesh for the end of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MemberIndx1      !< Index of Member nodes for the start of the member element [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: MemberIndx2      !< Index of Member nodes for the end of the member element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s      !< Linear interpolation factor between node1 and node2 for the output location [-]
  END TYPE Morison_MOutput
! =======================
! =========  Morison_JOutput  =======
  TYPE, PUBLIC :: Morison_JOutput
    INTEGER(IntKi)  :: JointID      !< Joint ID for the requested output [-]
    INTEGER(IntKi)  :: JointIDIndx      !< Joint index in the master list [-]
  END TYPE Morison_JOutput
! =======================
! =========  Morison_InitInputType  =======
  TYPE, PUBLIC :: Morison_InitInputType
    REAL(ReKi)  :: Gravity      !< Gravity (scalar, positive-valued) [m/s^2]
    REAL(ReKi)  :: WtrDens      !< Water density [kg/m^3]
    REAL(ReKi)  :: WtrDpth      !< Water depth (positive-valued) [m]
    REAL(ReKi)  :: MSL2SWL      !< Mean Sea Level to Still Water Level offset [m]
    INTEGER(IntKi)  :: NJoints      !< Number of user-specified joints [-]
    INTEGER(IntKi)  :: NNodes      !< Total number of nodes in the final software model [-]
    TYPE(Morison_JointType) , DIMENSION(:), ALLOCATABLE  :: InpJoints      !< Array of user-specified joints [-]
    TYPE(Morison_NodeType) , DIMENSION(:), ALLOCATABLE  :: Nodes      !< Array of simulation node (some correspond to user-specified joints, others are created by software) [-]
    INTEGER(IntKi)  :: NAxCoefs      !< Number of axial Coefs entries in input file table [-]
    TYPE(Morison_AxialCoefType) , DIMENSION(:), ALLOCATABLE  :: AxialCoefs      !< List of axial coefs [-]
    INTEGER(IntKi)  :: NPropSets      !< Number of member property sets [-]
    TYPE(Morison_MemberPropType) , DIMENSION(:), ALLOCATABLE  :: MPropSets      !< List of Member property sets [-]
    REAL(ReKi)  :: SimplCd      !< Simple model drag coef [-]
    REAL(ReKi)  :: SimplCdMG      !< Simple model drag coef for marine growth [-]
    REAL(ReKi)  :: SimplCa      !< Simple model Ca [-]
    REAL(ReKi)  :: SimplCaMG      !< Simple model Ca for marine growth [-]
    REAL(ReKi)  :: SimplCp      !< Simple model Cp [-]
    REAL(ReKi)  :: SimplCpMG      !< Simple model Cp for marine growth [-]
    REAL(ReKi)  :: SimplAxCd      !< Simple model Axial Cd [-]
    REAL(ReKi)  :: SimplAxCdMG      !< Simple model Axial Cd for marine growth [-]
    REAL(ReKi)  :: SimplAxCa      !< Simple model Axial Ca [-]
    REAL(ReKi)  :: SimplAxCaMG      !< Simple model Axial Ca for marine growth [-]
    REAL(ReKi)  :: SimplAxCp      !< Simple model Axial Cp [-]
    REAL(ReKi)  :: SimplAxCpMG      !< Simple model Axial Cp for marine growth [-]
    INTEGER(IntKi)  :: NCoefDpth      !<  [-]
    TYPE(Morison_CoefDpths) , DIMENSION(:), ALLOCATABLE  :: CoefDpths      !<  [-]
    INTEGER(IntKi)  :: NCoefMembers      !<  [-]
    TYPE(Morison_CoefMembers) , DIMENSION(:), ALLOCATABLE  :: CoefMembers      !<  [-]
    INTEGER(IntKi)  :: NMembers      !< Number of user-specified members in the input file [-]
    TYPE(Morison_MemberInputType) , DIMENSION(:), ALLOCATABLE  :: InpMembers      !< Array of user-specified members [-]
    INTEGER(IntKi)  :: NFillGroups      !<  [-]
    TYPE(Morison_FilledGroupType) , DIMENSION(:), ALLOCATABLE  :: FilledGroups      !<  [-]
    INTEGER(IntKi)  :: NMGDepths      !<  [-]
    TYPE(Morison_MGDepthsType) , DIMENSION(:), ALLOCATABLE  :: MGDepths      !<  [-]
    REAL(ReKi)  :: MGTop      !<  [-]
    REAL(ReKi)  :: MGBottom      !<  [-]
    INTEGER(IntKi)  :: NMOutputs      !<  [-]
    TYPE(Morison_MOutput) , DIMENSION(:), ALLOCATABLE  :: MOutLst      !<  [-]
    INTEGER(IntKi)  :: NJOutputs      !<  [-]
    TYPE(Morison_JOutput) , DIMENSION(:), ALLOCATABLE  :: JOutLst      !<  [-]
    CHARACTER(ChanLen) , DIMENSION(1:4032)  :: OutList      !< This list size needs to be the maximum   of possible outputs because of the use of ReadAry() [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: ValidOutList      !<  [-]
    INTEGER(IntKi)  :: NumOuts      !<  [-]
    INTEGER(IntKi)  :: OutSwtch      !<  [-]
    LOGICAL  :: OutAll      !<  [-]
    CHARACTER(1024)  :: OutRootName      !<  [-]
    INTEGER(IntKi)  :: UnOutFile      !<  [-]
    INTEGER(IntKi)  :: UnSum      !<  [-]
    INTEGER(IntKi)  :: NStepWave      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc      !<  [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !<  [-]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: WaveDynP      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel      !<  [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: nodeInWater      !< Logical flag indicating if the node at the given time step is in the water, and hence needs to have hydrodynamic forces calculated [-]
  END TYPE Morison_InitInputType
! =======================
! =========  Morison_InitOutputType  =======
  TYPE, PUBLIC :: Morison_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< User-requested Output channel names [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !<  [-]
  END TYPE Morison_InitOutputType
! =======================
! =========  Morison_ContinuousStateType  =======
  TYPE, PUBLIC :: Morison_ContinuousStateType
    REAL(SiKi)  :: DummyContState      !< Remove this variable if you have continuous states [-]
  END TYPE Morison_ContinuousStateType
! =======================
! =========  Morison_DiscreteStateType  =======
  TYPE, PUBLIC :: Morison_DiscreteStateType
    REAL(SiKi)  :: DummyDiscState      !< Remove this variable if you have discrete states [-]
  END TYPE Morison_DiscreteStateType
! =======================
! =========  Morison_ConstraintStateType  =======
  TYPE, PUBLIC :: Morison_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState      !< Remove this variable if you have constraint states [-]
  END TYPE Morison_ConstraintStateType
! =======================
! =========  Morison_OtherStateType  =======
  TYPE, PUBLIC :: Morison_OtherStateType
    INTEGER(IntKi)  :: DummyOtherState      !< Remove this variable if you have other states [-]
  END TYPE Morison_OtherStateType
! =======================
! =========  Morison_MiscVarType  =======
  TYPE, PUBLIC :: Morison_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FV      !< Fluid velocity at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FA      !< Fluid acceleration at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FDynP      !< Fluid dynamic pressure at line element node at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: vrel      !< velocity of structural node relative to the water [m/s^2]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: nodeInWater      !< Logical flag indicating if the node at the given time step is in the water, and hence needs to have hydrodynamic forces calculated [-]
    TYPE(Morison_MemberLoads) , DIMENSION(:), ALLOCATABLE  :: memberLoads      !< Array (NMembers long) of member-based side-effects load contributions [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_B_End      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_D_End      !< Lumped viscous drag loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_I_End      !< Lumped intertia loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_IMG_End      !< Joint marine growth intertia loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_A_End      !< Lumped added mass loads at time t, which may not correspond to the WaveTime array of times [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_BF_End      !<  [-]
    INTEGER(IntKi)  :: LastIndWave      !< Last time index used in the wave kinematics arrays [-]
  END TYPE Morison_MiscVarType
! =======================
! =========  Morison_ParameterType  =======
  TYPE, PUBLIC :: Morison_ParameterType
    REAL(DbKi)  :: DT      !< Time step for continuous state integration & discrete state update [(sec)]
    REAL(ReKi)  :: Gravity      !< Gravity (scalar, positive-valued) [m/s^2]
    REAL(ReKi)  :: WtrDens      !< Water density [kg/m^3]
    REAL(ReKi)  :: WtrDpth      !< Water depth (positive-valued) [m]
    REAL(ReKi)  :: MSL2SWL      !< Mean Sea Level to Still Water Level offset [m]
    INTEGER(IntKi)  :: NMembers      !< number of members [-]
    TYPE(Morison_MemberType) , DIMENSION(:), ALLOCATABLE  :: Members      !< Array of Morison members used during simulation [-]
    INTEGER(IntKi)  :: NNodes      !<  [-]
    INTEGER(IntKi)  :: NJoints      !< Number of user-specified joints [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: I_MG_End      !< Inertial matrix associated with marine growth mass at joint [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: An_End      !< directional area vector of each joint [m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DragConst_End      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_WMG_End      !< Joint marine growth weight loads, constant for all t [N]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DP_Const_End      !< Constant part of Joint dynamic pressure term [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Mass_MG_End      !< Joint marine growth mass [kg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AM_End      !< 3x3 Joint added mass matrix, constant for all t [N]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel      !<  [-]
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc      !<  [-]
    REAL(SiKi) , DIMENSION(:,:), ALLOCATABLE  :: WaveDynP      !<  [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !< Times for which the wave kinematics are pre-computed [s]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: nodeInWater      !< Logical flag indicating if the node at the given time step is in the water, and hence needs to have hydrodynamic forces calculated [-]
    INTEGER(IntKi)  :: NStepWave      !<  [-]
    INTEGER(IntKi)  :: NMOutputs      !<  [-]
    TYPE(Morison_MOutput) , DIMENSION(:), ALLOCATABLE  :: MOutLst      !<  [-]
    INTEGER(IntKi)  :: NJOutputs      !<  [-]
    TYPE(Morison_JOutput) , DIMENSION(:), ALLOCATABLE  :: JOutLst      !<  [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !<  [-]
    INTEGER(IntKi)  :: NumOuts      !<  [-]
    INTEGER(IntKi)  :: NumOutAll      !<  [-]
    INTEGER(IntKi)  :: OutSwtch      !<  [-]
    INTEGER(IntKi)  :: UnOutFile      !<  [-]
    CHARACTER(20)  :: OutFmt      !<  [-]
    CHARACTER(20)  :: OutSFmt      !<  [-]
    CHARACTER(ChanLen)  :: Delim      !<  [-]
  END TYPE Morison_ParameterType
! =======================
! =========  Morison_InputType  =======
  TYPE, PUBLIC :: Morison_InputType
    TYPE(MeshType)  :: Mesh      !< Kinematics of each node input mesh [-]
  END TYPE Morison_InputType
! =======================
! =========  Morison_OutputType  =======
  TYPE, PUBLIC :: Morison_OutputType
    TYPE(MeshType)  :: Mesh      !< Loads on each node output mesh [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !<  [-]
  END TYPE Morison_OutputType
! =======================
CONTAINS
 SUBROUTINE Morison_CopyJointType( SrcJointTypeData, DstJointTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_JointType), INTENT(IN) :: SrcJointTypeData
   TYPE(Morison_JointType), INTENT(INOUT) :: DstJointTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyJointType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstJointTypeData%JointID = SrcJointTypeData%JointID
    DstJointTypeData%Position = SrcJointTypeData%Position
    DstJointTypeData%JointAxID = SrcJointTypeData%JointAxID
    DstJointTypeData%JointAxIDIndx = SrcJointTypeData%JointAxIDIndx
    DstJointTypeData%JointOvrlp = SrcJointTypeData%JointOvrlp
    DstJointTypeData%NConnections = SrcJointTypeData%NConnections
    DstJointTypeData%ConnectionList = SrcJointTypeData%ConnectionList
 END SUBROUTINE Morison_CopyJointType

 SUBROUTINE Morison_DestroyJointType( JointTypeData, ErrStat, ErrMsg )
  TYPE(Morison_JointType), INTENT(INOUT) :: JointTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyJointType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyJointType

 SUBROUTINE Morison_PackJointType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_JointType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackJointType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! JointID
      Re_BufSz   = Re_BufSz   + SIZE(InData%Position)  ! Position
      Int_BufSz  = Int_BufSz  + 1  ! JointAxID
      Int_BufSz  = Int_BufSz  + 1  ! JointAxIDIndx
      Int_BufSz  = Int_BufSz  + 1  ! JointOvrlp
      Int_BufSz  = Int_BufSz  + 1  ! NConnections
      Int_BufSz  = Int_BufSz  + SIZE(InData%ConnectionList)  ! ConnectionList
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%JointID
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%Position,1), UBOUND(InData%Position,1)
      ReKiBuf(Re_Xferred) = InData%Position(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%JointAxID
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%JointAxIDIndx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%JointOvrlp
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NConnections
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%ConnectionList,1), UBOUND(InData%ConnectionList,1)
      IntKiBuf(Int_Xferred) = InData%ConnectionList(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
 END SUBROUTINE Morison_PackJointType

 SUBROUTINE Morison_UnPackJointType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_JointType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackJointType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%JointID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%Position,1)
    i1_u = UBOUND(OutData%Position,1)
    DO i1 = LBOUND(OutData%Position,1), UBOUND(OutData%Position,1)
      OutData%Position(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%JointAxID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%JointAxIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%JointOvrlp = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NConnections = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%ConnectionList,1)
    i1_u = UBOUND(OutData%ConnectionList,1)
    DO i1 = LBOUND(OutData%ConnectionList,1), UBOUND(OutData%ConnectionList,1)
      OutData%ConnectionList(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
 END SUBROUTINE Morison_UnPackJointType

 SUBROUTINE Morison_CopyMemberPropType( SrcMemberPropTypeData, DstMemberPropTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MemberPropType), INTENT(IN) :: SrcMemberPropTypeData
   TYPE(Morison_MemberPropType), INTENT(INOUT) :: DstMemberPropTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMemberPropType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMemberPropTypeData%PropSetID = SrcMemberPropTypeData%PropSetID
    DstMemberPropTypeData%PropD = SrcMemberPropTypeData%PropD
    DstMemberPropTypeData%PropThck = SrcMemberPropTypeData%PropThck
 END SUBROUTINE Morison_CopyMemberPropType

 SUBROUTINE Morison_DestroyMemberPropType( MemberPropTypeData, ErrStat, ErrMsg )
  TYPE(Morison_MemberPropType), INTENT(INOUT) :: MemberPropTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMemberPropType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyMemberPropType

 SUBROUTINE Morison_PackMemberPropType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MemberPropType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMemberPropType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! PropSetID
      Re_BufSz   = Re_BufSz   + 1  ! PropD
      Re_BufSz   = Re_BufSz   + 1  ! PropThck
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%PropSetID
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PropD
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PropThck
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackMemberPropType

 SUBROUTINE Morison_UnPackMemberPropType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MemberPropType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMemberPropType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%PropSetID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%PropD = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PropThck = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackMemberPropType

 SUBROUTINE Morison_CopyFilledGroupType( SrcFilledGroupTypeData, DstFilledGroupTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_FilledGroupType), INTENT(IN) :: SrcFilledGroupTypeData
   TYPE(Morison_FilledGroupType), INTENT(INOUT) :: DstFilledGroupTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyFilledGroupType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstFilledGroupTypeData%FillNumM = SrcFilledGroupTypeData%FillNumM
IF (ALLOCATED(SrcFilledGroupTypeData%FillMList)) THEN
  i1_l = LBOUND(SrcFilledGroupTypeData%FillMList,1)
  i1_u = UBOUND(SrcFilledGroupTypeData%FillMList,1)
  IF (.NOT. ALLOCATED(DstFilledGroupTypeData%FillMList)) THEN 
    ALLOCATE(DstFilledGroupTypeData%FillMList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstFilledGroupTypeData%FillMList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstFilledGroupTypeData%FillMList = SrcFilledGroupTypeData%FillMList
ENDIF
    DstFilledGroupTypeData%FillFSLoc = SrcFilledGroupTypeData%FillFSLoc
    DstFilledGroupTypeData%FillDensChr = SrcFilledGroupTypeData%FillDensChr
    DstFilledGroupTypeData%FillDens = SrcFilledGroupTypeData%FillDens
 END SUBROUTINE Morison_CopyFilledGroupType

 SUBROUTINE Morison_DestroyFilledGroupType( FilledGroupTypeData, ErrStat, ErrMsg )
  TYPE(Morison_FilledGroupType), INTENT(INOUT) :: FilledGroupTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyFilledGroupType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(FilledGroupTypeData%FillMList)) THEN
  DEALLOCATE(FilledGroupTypeData%FillMList)
ENDIF
 END SUBROUTINE Morison_DestroyFilledGroupType

 SUBROUTINE Morison_PackFilledGroupType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_FilledGroupType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackFilledGroupType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! FillNumM
  Int_BufSz   = Int_BufSz   + 1     ! FillMList allocated yes/no
  IF ( ALLOCATED(InData%FillMList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FillMList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FillMList)  ! FillMList
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! FillFSLoc
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%FillDensChr)  ! FillDensChr
      Re_BufSz   = Re_BufSz   + 1  ! FillDens
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%FillNumM
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%FillMList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FillMList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FillMList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FillMList,1), UBOUND(InData%FillMList,1)
        IntKiBuf(Int_Xferred) = InData%FillMList(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%FillFSLoc
    Re_Xferred = Re_Xferred + 1
    DO I = 1, LEN(InData%FillDensChr)
      IntKiBuf(Int_Xferred) = ICHAR(InData%FillDensChr(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    ReKiBuf(Re_Xferred) = InData%FillDens
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackFilledGroupType

 SUBROUTINE Morison_UnPackFilledGroupType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_FilledGroupType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackFilledGroupType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%FillNumM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FillMList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FillMList)) DEALLOCATE(OutData%FillMList)
    ALLOCATE(OutData%FillMList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FillMList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FillMList,1), UBOUND(OutData%FillMList,1)
        OutData%FillMList(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%FillFSLoc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    DO I = 1, LEN(OutData%FillDensChr)
      OutData%FillDensChr(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%FillDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackFilledGroupType

 SUBROUTINE Morison_CopyCoefDpths( SrcCoefDpthsData, DstCoefDpthsData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_CoefDpths), INTENT(IN) :: SrcCoefDpthsData
   TYPE(Morison_CoefDpths), INTENT(INOUT) :: DstCoefDpthsData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyCoefDpths'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstCoefDpthsData%Dpth = SrcCoefDpthsData%Dpth
    DstCoefDpthsData%DpthCd = SrcCoefDpthsData%DpthCd
    DstCoefDpthsData%DpthCdMG = SrcCoefDpthsData%DpthCdMG
    DstCoefDpthsData%DpthCa = SrcCoefDpthsData%DpthCa
    DstCoefDpthsData%DpthCaMG = SrcCoefDpthsData%DpthCaMG
    DstCoefDpthsData%DpthCp = SrcCoefDpthsData%DpthCp
    DstCoefDpthsData%DpthCpMG = SrcCoefDpthsData%DpthCpMG
    DstCoefDpthsData%DpthAxCd = SrcCoefDpthsData%DpthAxCd
    DstCoefDpthsData%DpthAxCdMG = SrcCoefDpthsData%DpthAxCdMG
    DstCoefDpthsData%DpthAxCa = SrcCoefDpthsData%DpthAxCa
    DstCoefDpthsData%DpthAxCaMG = SrcCoefDpthsData%DpthAxCaMG
    DstCoefDpthsData%DpthAxCp = SrcCoefDpthsData%DpthAxCp
    DstCoefDpthsData%DpthAxCpMG = SrcCoefDpthsData%DpthAxCpMG
 END SUBROUTINE Morison_CopyCoefDpths

 SUBROUTINE Morison_DestroyCoefDpths( CoefDpthsData, ErrStat, ErrMsg )
  TYPE(Morison_CoefDpths), INTENT(INOUT) :: CoefDpthsData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyCoefDpths'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyCoefDpths

 SUBROUTINE Morison_PackCoefDpths( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_CoefDpths),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackCoefDpths'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Dpth
      Re_BufSz   = Re_BufSz   + 1  ! DpthCd
      Re_BufSz   = Re_BufSz   + 1  ! DpthCdMG
      Re_BufSz   = Re_BufSz   + 1  ! DpthCa
      Re_BufSz   = Re_BufSz   + 1  ! DpthCaMG
      Re_BufSz   = Re_BufSz   + 1  ! DpthCp
      Re_BufSz   = Re_BufSz   + 1  ! DpthCpMG
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCd
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCdMG
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCa
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCaMG
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCp
      Re_BufSz   = Re_BufSz   + 1  ! DpthAxCpMG
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Dpth
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCdMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCaMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthCpMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCdMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCaMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DpthAxCpMG
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackCoefDpths

 SUBROUTINE Morison_UnPackCoefDpths( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_CoefDpths), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackCoefDpths'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Dpth = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCdMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCaMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthCpMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCdMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCaMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DpthAxCpMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackCoefDpths

 SUBROUTINE Morison_CopyAxialCoefType( SrcAxialCoefTypeData, DstAxialCoefTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_AxialCoefType), INTENT(IN) :: SrcAxialCoefTypeData
   TYPE(Morison_AxialCoefType), INTENT(INOUT) :: DstAxialCoefTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyAxialCoefType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstAxialCoefTypeData%AxCoefID = SrcAxialCoefTypeData%AxCoefID
    DstAxialCoefTypeData%AxCd = SrcAxialCoefTypeData%AxCd
    DstAxialCoefTypeData%AxCa = SrcAxialCoefTypeData%AxCa
    DstAxialCoefTypeData%AxCp = SrcAxialCoefTypeData%AxCp
 END SUBROUTINE Morison_CopyAxialCoefType

 SUBROUTINE Morison_DestroyAxialCoefType( AxialCoefTypeData, ErrStat, ErrMsg )
  TYPE(Morison_AxialCoefType), INTENT(INOUT) :: AxialCoefTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyAxialCoefType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyAxialCoefType

 SUBROUTINE Morison_PackAxialCoefType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_AxialCoefType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackAxialCoefType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! AxCoefID
      Re_BufSz   = Re_BufSz   + 1  ! AxCd
      Re_BufSz   = Re_BufSz   + 1  ! AxCa
      Re_BufSz   = Re_BufSz   + 1  ! AxCp
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%AxCoefID
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AxCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AxCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AxCp
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackAxialCoefType

 SUBROUTINE Morison_UnPackAxialCoefType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_AxialCoefType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackAxialCoefType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%AxCoefID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%AxCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AxCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AxCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackAxialCoefType

 SUBROUTINE Morison_CopyMemberInputType( SrcMemberInputTypeData, DstMemberInputTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MemberInputType), INTENT(IN) :: SrcMemberInputTypeData
   TYPE(Morison_MemberInputType), INTENT(INOUT) :: DstMemberInputTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMemberInputType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMemberInputTypeData%MemberID = SrcMemberInputTypeData%MemberID
IF (ALLOCATED(SrcMemberInputTypeData%NodeIndx)) THEN
  i1_l = LBOUND(SrcMemberInputTypeData%NodeIndx,1)
  i1_u = UBOUND(SrcMemberInputTypeData%NodeIndx,1)
  IF (.NOT. ALLOCATED(DstMemberInputTypeData%NodeIndx)) THEN 
    ALLOCATE(DstMemberInputTypeData%NodeIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberInputTypeData%NodeIndx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberInputTypeData%NodeIndx = SrcMemberInputTypeData%NodeIndx
ENDIF
    DstMemberInputTypeData%MJointID1 = SrcMemberInputTypeData%MJointID1
    DstMemberInputTypeData%MJointID2 = SrcMemberInputTypeData%MJointID2
    DstMemberInputTypeData%MJointID1Indx = SrcMemberInputTypeData%MJointID1Indx
    DstMemberInputTypeData%MJointID2Indx = SrcMemberInputTypeData%MJointID2Indx
    DstMemberInputTypeData%MPropSetID1 = SrcMemberInputTypeData%MPropSetID1
    DstMemberInputTypeData%MPropSetID2 = SrcMemberInputTypeData%MPropSetID2
    DstMemberInputTypeData%MPropSetID1Indx = SrcMemberInputTypeData%MPropSetID1Indx
    DstMemberInputTypeData%MPropSetID2Indx = SrcMemberInputTypeData%MPropSetID2Indx
    DstMemberInputTypeData%MDivSize = SrcMemberInputTypeData%MDivSize
    DstMemberInputTypeData%MCoefMod = SrcMemberInputTypeData%MCoefMod
    DstMemberInputTypeData%MmbrCoefIDIndx = SrcMemberInputTypeData%MmbrCoefIDIndx
    DstMemberInputTypeData%MmbrFilledIDIndx = SrcMemberInputTypeData%MmbrFilledIDIndx
    DstMemberInputTypeData%PropPot = SrcMemberInputTypeData%PropPot
    DstMemberInputTypeData%NElements = SrcMemberInputTypeData%NElements
    DstMemberInputTypeData%RefLength = SrcMemberInputTypeData%RefLength
    DstMemberInputTypeData%dl = SrcMemberInputTypeData%dl
 END SUBROUTINE Morison_CopyMemberInputType

 SUBROUTINE Morison_DestroyMemberInputType( MemberInputTypeData, ErrStat, ErrMsg )
  TYPE(Morison_MemberInputType), INTENT(INOUT) :: MemberInputTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMemberInputType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MemberInputTypeData%NodeIndx)) THEN
  DEALLOCATE(MemberInputTypeData%NodeIndx)
ENDIF
 END SUBROUTINE Morison_DestroyMemberInputType

 SUBROUTINE Morison_PackMemberInputType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MemberInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMemberInputType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! MemberID
  Int_BufSz   = Int_BufSz   + 1     ! NodeIndx allocated yes/no
  IF ( ALLOCATED(InData%NodeIndx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NodeIndx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%NodeIndx)  ! NodeIndx
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! MJointID1
      Int_BufSz  = Int_BufSz  + 1  ! MJointID2
      Int_BufSz  = Int_BufSz  + 1  ! MJointID1Indx
      Int_BufSz  = Int_BufSz  + 1  ! MJointID2Indx
      Int_BufSz  = Int_BufSz  + 1  ! MPropSetID1
      Int_BufSz  = Int_BufSz  + 1  ! MPropSetID2
      Int_BufSz  = Int_BufSz  + 1  ! MPropSetID1Indx
      Int_BufSz  = Int_BufSz  + 1  ! MPropSetID2Indx
      Re_BufSz   = Re_BufSz   + 1  ! MDivSize
      Int_BufSz  = Int_BufSz  + 1  ! MCoefMod
      Int_BufSz  = Int_BufSz  + 1  ! MmbrCoefIDIndx
      Int_BufSz  = Int_BufSz  + 1  ! MmbrFilledIDIndx
      Int_BufSz  = Int_BufSz  + 1  ! PropPot
      Int_BufSz  = Int_BufSz  + 1  ! NElements
      Re_BufSz   = Re_BufSz   + 1  ! RefLength
      Re_BufSz   = Re_BufSz   + 1  ! dl
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%MemberID
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%NodeIndx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NodeIndx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NodeIndx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NodeIndx,1), UBOUND(InData%NodeIndx,1)
        IntKiBuf(Int_Xferred) = InData%NodeIndx(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%MJointID1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MJointID2
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MJointID1Indx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MJointID2Indx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MPropSetID1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MPropSetID2
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MPropSetID1Indx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MPropSetID2Indx
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MDivSize
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MCoefMod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MmbrCoefIDIndx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MmbrFilledIDIndx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PropPot, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NElements
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RefLength
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dl
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackMemberInputType

 SUBROUTINE Morison_UnPackMemberInputType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MemberInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMemberInputType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%MemberID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NodeIndx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NodeIndx)) DEALLOCATE(OutData%NodeIndx)
    ALLOCATE(OutData%NodeIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NodeIndx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NodeIndx,1), UBOUND(OutData%NodeIndx,1)
        OutData%NodeIndx(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%MJointID1 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MJointID2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MJointID1Indx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MJointID2Indx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MPropSetID1 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MPropSetID2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MPropSetID1Indx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MPropSetID2Indx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MDivSize = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MCoefMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MmbrCoefIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MmbrFilledIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%PropPot = TRANSFER(IntKiBuf(Int_Xferred), OutData%PropPot)
    Int_Xferred = Int_Xferred + 1
    OutData%NElements = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RefLength = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackMemberInputType

 SUBROUTINE Morison_CopyNodeType( SrcNodeTypeData, DstNodeTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_NodeType), INTENT(IN) :: SrcNodeTypeData
   TYPE(Morison_NodeType), INTENT(INOUT) :: DstNodeTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyNodeType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstNodeTypeData%JointIndx = SrcNodeTypeData%JointIndx
    DstNodeTypeData%Position = SrcNodeTypeData%Position
    DstNodeTypeData%JointOvrlp = SrcNodeTypeData%JointOvrlp
    DstNodeTypeData%JointAxIDIndx = SrcNodeTypeData%JointAxIDIndx
    DstNodeTypeData%NConnections = SrcNodeTypeData%NConnections
    DstNodeTypeData%ConnectionList = SrcNodeTypeData%ConnectionList
    DstNodeTypeData%JAxCd = SrcNodeTypeData%JAxCd
    DstNodeTypeData%JAxCa = SrcNodeTypeData%JAxCa
    DstNodeTypeData%JAxCp = SrcNodeTypeData%JAxCp
    DstNodeTypeData%FillDensity = SrcNodeTypeData%FillDensity
    DstNodeTypeData%tMG = SrcNodeTypeData%tMG
    DstNodeTypeData%MGdensity = SrcNodeTypeData%MGdensity
 END SUBROUTINE Morison_CopyNodeType

 SUBROUTINE Morison_DestroyNodeType( NodeTypeData, ErrStat, ErrMsg )
  TYPE(Morison_NodeType), INTENT(INOUT) :: NodeTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyNodeType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyNodeType

 SUBROUTINE Morison_PackNodeType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_NodeType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackNodeType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! JointIndx
      Re_BufSz   = Re_BufSz   + SIZE(InData%Position)  ! Position
      Int_BufSz  = Int_BufSz  + 1  ! JointOvrlp
      Int_BufSz  = Int_BufSz  + 1  ! JointAxIDIndx
      Int_BufSz  = Int_BufSz  + 1  ! NConnections
      Int_BufSz  = Int_BufSz  + SIZE(InData%ConnectionList)  ! ConnectionList
      Re_BufSz   = Re_BufSz   + 1  ! JAxCd
      Re_BufSz   = Re_BufSz   + 1  ! JAxCa
      Re_BufSz   = Re_BufSz   + 1  ! JAxCp
      Re_BufSz   = Re_BufSz   + 1  ! FillDensity
      Re_BufSz   = Re_BufSz   + 1  ! tMG
      Re_BufSz   = Re_BufSz   + 1  ! MGdensity
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%JointIndx
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%Position,1), UBOUND(InData%Position,1)
      ReKiBuf(Re_Xferred) = InData%Position(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%JointOvrlp
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%JointAxIDIndx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NConnections
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%ConnectionList,1), UBOUND(InData%ConnectionList,1)
      IntKiBuf(Int_Xferred) = InData%ConnectionList(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    ReKiBuf(Re_Xferred) = InData%JAxCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%JAxCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%JAxCp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FillDensity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MGdensity
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackNodeType

 SUBROUTINE Morison_UnPackNodeType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_NodeType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackNodeType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%JointIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%Position,1)
    i1_u = UBOUND(OutData%Position,1)
    DO i1 = LBOUND(OutData%Position,1), UBOUND(OutData%Position,1)
      OutData%Position(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%JointOvrlp = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%JointAxIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NConnections = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%ConnectionList,1)
    i1_u = UBOUND(OutData%ConnectionList,1)
    DO i1 = LBOUND(OutData%ConnectionList,1), UBOUND(OutData%ConnectionList,1)
      OutData%ConnectionList(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    OutData%JAxCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%JAxCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%JAxCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FillDensity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%tMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MGdensity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackNodeType

 SUBROUTINE Morison_CopyMemberType( SrcMemberTypeData, DstMemberTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MemberType), INTENT(IN) :: SrcMemberTypeData
   TYPE(Morison_MemberType), INTENT(INOUT) :: DstMemberTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMemberType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMemberTypeData%NodeIndx)) THEN
  i1_l = LBOUND(SrcMemberTypeData%NodeIndx,1)
  i1_u = UBOUND(SrcMemberTypeData%NodeIndx,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%NodeIndx)) THEN 
    ALLOCATE(DstMemberTypeData%NodeIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%NodeIndx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%NodeIndx = SrcMemberTypeData%NodeIndx
ENDIF
    DstMemberTypeData%MemberID = SrcMemberTypeData%MemberID
    DstMemberTypeData%NElements = SrcMemberTypeData%NElements
    DstMemberTypeData%RefLength = SrcMemberTypeData%RefLength
    DstMemberTypeData%cosPhi_ref = SrcMemberTypeData%cosPhi_ref
    DstMemberTypeData%dl = SrcMemberTypeData%dl
    DstMemberTypeData%k = SrcMemberTypeData%k
    DstMemberTypeData%kkt = SrcMemberTypeData%kkt
    DstMemberTypeData%Ak = SrcMemberTypeData%Ak
IF (ALLOCATED(SrcMemberTypeData%R)) THEN
  i1_l = LBOUND(SrcMemberTypeData%R,1)
  i1_u = UBOUND(SrcMemberTypeData%R,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%R)) THEN 
    ALLOCATE(DstMemberTypeData%R(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%R.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%R = SrcMemberTypeData%R
ENDIF
IF (ALLOCATED(SrcMemberTypeData%RMG)) THEN
  i1_l = LBOUND(SrcMemberTypeData%RMG,1)
  i1_u = UBOUND(SrcMemberTypeData%RMG,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%RMG)) THEN 
    ALLOCATE(DstMemberTypeData%RMG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%RMG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%RMG = SrcMemberTypeData%RMG
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Rin)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Rin,1)
  i1_u = UBOUND(SrcMemberTypeData%Rin,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Rin)) THEN 
    ALLOCATE(DstMemberTypeData%Rin(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Rin.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Rin = SrcMemberTypeData%Rin
ENDIF
IF (ALLOCATED(SrcMemberTypeData%tMG)) THEN
  i1_l = LBOUND(SrcMemberTypeData%tMG,1)
  i1_u = UBOUND(SrcMemberTypeData%tMG,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%tMG)) THEN 
    ALLOCATE(DstMemberTypeData%tMG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%tMG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%tMG = SrcMemberTypeData%tMG
ENDIF
IF (ALLOCATED(SrcMemberTypeData%MGdensity)) THEN
  i1_l = LBOUND(SrcMemberTypeData%MGdensity,1)
  i1_u = UBOUND(SrcMemberTypeData%MGdensity,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%MGdensity)) THEN 
    ALLOCATE(DstMemberTypeData%MGdensity(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%MGdensity.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%MGdensity = SrcMemberTypeData%MGdensity
ENDIF
IF (ALLOCATED(SrcMemberTypeData%dRdl_mg)) THEN
  i1_l = LBOUND(SrcMemberTypeData%dRdl_mg,1)
  i1_u = UBOUND(SrcMemberTypeData%dRdl_mg,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%dRdl_mg)) THEN 
    ALLOCATE(DstMemberTypeData%dRdl_mg(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dRdl_mg.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%dRdl_mg = SrcMemberTypeData%dRdl_mg
ENDIF
IF (ALLOCATED(SrcMemberTypeData%dRdl_in)) THEN
  i1_l = LBOUND(SrcMemberTypeData%dRdl_in,1)
  i1_u = UBOUND(SrcMemberTypeData%dRdl_in,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%dRdl_in)) THEN 
    ALLOCATE(DstMemberTypeData%dRdl_in(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%dRdl_in.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%dRdl_in = SrcMemberTypeData%dRdl_in
ENDIF
    DstMemberTypeData%Vinner = SrcMemberTypeData%Vinner
    DstMemberTypeData%Vouter = SrcMemberTypeData%Vouter
    DstMemberTypeData%Vballast = SrcMemberTypeData%Vballast
    DstMemberTypeData%Vsubmerged = SrcMemberTypeData%Vsubmerged
    DstMemberTypeData%l_fill = SrcMemberTypeData%l_fill
    DstMemberTypeData%h_fill = SrcMemberTypeData%h_fill
    DstMemberTypeData%z_overfill = SrcMemberTypeData%z_overfill
    DstMemberTypeData%h_floor = SrcMemberTypeData%h_floor
    DstMemberTypeData%i_floor = SrcMemberTypeData%i_floor
    DstMemberTypeData%doEndBuoyancy = SrcMemberTypeData%doEndBuoyancy
    DstMemberTypeData%memfloodstatus = SrcMemberTypeData%memfloodstatus
IF (ALLOCATED(SrcMemberTypeData%floodstatus)) THEN
  i1_l = LBOUND(SrcMemberTypeData%floodstatus,1)
  i1_u = UBOUND(SrcMemberTypeData%floodstatus,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%floodstatus)) THEN 
    ALLOCATE(DstMemberTypeData%floodstatus(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%floodstatus.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%floodstatus = SrcMemberTypeData%floodstatus
ENDIF
IF (ALLOCATED(SrcMemberTypeData%alpha)) THEN
  i1_l = LBOUND(SrcMemberTypeData%alpha,1)
  i1_u = UBOUND(SrcMemberTypeData%alpha,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%alpha)) THEN 
    ALLOCATE(DstMemberTypeData%alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%alpha = SrcMemberTypeData%alpha
ENDIF
IF (ALLOCATED(SrcMemberTypeData%alpha_fb)) THEN
  i1_l = LBOUND(SrcMemberTypeData%alpha_fb,1)
  i1_u = UBOUND(SrcMemberTypeData%alpha_fb,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%alpha_fb)) THEN 
    ALLOCATE(DstMemberTypeData%alpha_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha_fb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%alpha_fb = SrcMemberTypeData%alpha_fb
ENDIF
IF (ALLOCATED(SrcMemberTypeData%alpha_fb_star)) THEN
  i1_l = LBOUND(SrcMemberTypeData%alpha_fb_star,1)
  i1_u = UBOUND(SrcMemberTypeData%alpha_fb_star,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%alpha_fb_star)) THEN 
    ALLOCATE(DstMemberTypeData%alpha_fb_star(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%alpha_fb_star.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%alpha_fb_star = SrcMemberTypeData%alpha_fb_star
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Cd)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Cd,1)
  i1_u = UBOUND(SrcMemberTypeData%Cd,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Cd)) THEN 
    ALLOCATE(DstMemberTypeData%Cd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Cd = SrcMemberTypeData%Cd
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Ca)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Ca,1)
  i1_u = UBOUND(SrcMemberTypeData%Ca,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Ca)) THEN 
    ALLOCATE(DstMemberTypeData%Ca(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Ca.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Ca = SrcMemberTypeData%Ca
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Cp)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Cp,1)
  i1_u = UBOUND(SrcMemberTypeData%Cp,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Cp)) THEN 
    ALLOCATE(DstMemberTypeData%Cp(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Cp = SrcMemberTypeData%Cp
ENDIF
IF (ALLOCATED(SrcMemberTypeData%AxCd)) THEN
  i1_l = LBOUND(SrcMemberTypeData%AxCd,1)
  i1_u = UBOUND(SrcMemberTypeData%AxCd,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%AxCd)) THEN 
    ALLOCATE(DstMemberTypeData%AxCd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%AxCd = SrcMemberTypeData%AxCd
ENDIF
IF (ALLOCATED(SrcMemberTypeData%AxCa)) THEN
  i1_l = LBOUND(SrcMemberTypeData%AxCa,1)
  i1_u = UBOUND(SrcMemberTypeData%AxCa,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%AxCa)) THEN 
    ALLOCATE(DstMemberTypeData%AxCa(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCa.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%AxCa = SrcMemberTypeData%AxCa
ENDIF
IF (ALLOCATED(SrcMemberTypeData%AxCp)) THEN
  i1_l = LBOUND(SrcMemberTypeData%AxCp,1)
  i1_u = UBOUND(SrcMemberTypeData%AxCp,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%AxCp)) THEN 
    ALLOCATE(DstMemberTypeData%AxCp(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%AxCp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%AxCp = SrcMemberTypeData%AxCp
ENDIF
IF (ALLOCATED(SrcMemberTypeData%m_fb_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%m_fb_l,1)
  i1_u = UBOUND(SrcMemberTypeData%m_fb_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%m_fb_l)) THEN 
    ALLOCATE(DstMemberTypeData%m_fb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_fb_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%m_fb_l = SrcMemberTypeData%m_fb_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%m_fb_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%m_fb_u,1)
  i1_u = UBOUND(SrcMemberTypeData%m_fb_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%m_fb_u)) THEN 
    ALLOCATE(DstMemberTypeData%m_fb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_fb_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%m_fb_u = SrcMemberTypeData%m_fb_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%h_cfb_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%h_cfb_l,1)
  i1_u = UBOUND(SrcMemberTypeData%h_cfb_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%h_cfb_l)) THEN 
    ALLOCATE(DstMemberTypeData%h_cfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cfb_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%h_cfb_l = SrcMemberTypeData%h_cfb_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%h_cfb_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%h_cfb_u,1)
  i1_u = UBOUND(SrcMemberTypeData%h_cfb_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%h_cfb_u)) THEN 
    ALLOCATE(DstMemberTypeData%h_cfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cfb_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%h_cfb_u = SrcMemberTypeData%h_cfb_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_lfb_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_lfb_l,1)
  i1_u = UBOUND(SrcMemberTypeData%I_lfb_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_lfb_l)) THEN 
    ALLOCATE(DstMemberTypeData%I_lfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lfb_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_lfb_l = SrcMemberTypeData%I_lfb_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_lfb_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_lfb_u,1)
  i1_u = UBOUND(SrcMemberTypeData%I_lfb_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_lfb_u)) THEN 
    ALLOCATE(DstMemberTypeData%I_lfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lfb_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_lfb_u = SrcMemberTypeData%I_lfb_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_rfb_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_rfb_l,1)
  i1_u = UBOUND(SrcMemberTypeData%I_rfb_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_rfb_l)) THEN 
    ALLOCATE(DstMemberTypeData%I_rfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rfb_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_rfb_l = SrcMemberTypeData%I_rfb_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_rfb_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_rfb_u,1)
  i1_u = UBOUND(SrcMemberTypeData%I_rfb_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_rfb_u)) THEN 
    ALLOCATE(DstMemberTypeData%I_rfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rfb_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_rfb_u = SrcMemberTypeData%I_rfb_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%m_mg_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%m_mg_l,1)
  i1_u = UBOUND(SrcMemberTypeData%m_mg_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%m_mg_l)) THEN 
    ALLOCATE(DstMemberTypeData%m_mg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_mg_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%m_mg_l = SrcMemberTypeData%m_mg_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%m_mg_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%m_mg_u,1)
  i1_u = UBOUND(SrcMemberTypeData%m_mg_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%m_mg_u)) THEN 
    ALLOCATE(DstMemberTypeData%m_mg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%m_mg_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%m_mg_u = SrcMemberTypeData%m_mg_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%h_cmg_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%h_cmg_l,1)
  i1_u = UBOUND(SrcMemberTypeData%h_cmg_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%h_cmg_l)) THEN 
    ALLOCATE(DstMemberTypeData%h_cmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cmg_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%h_cmg_l = SrcMemberTypeData%h_cmg_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%h_cmg_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%h_cmg_u,1)
  i1_u = UBOUND(SrcMemberTypeData%h_cmg_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%h_cmg_u)) THEN 
    ALLOCATE(DstMemberTypeData%h_cmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%h_cmg_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%h_cmg_u = SrcMemberTypeData%h_cmg_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_lmg_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_lmg_l,1)
  i1_u = UBOUND(SrcMemberTypeData%I_lmg_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_lmg_l)) THEN 
    ALLOCATE(DstMemberTypeData%I_lmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lmg_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_lmg_l = SrcMemberTypeData%I_lmg_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_lmg_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_lmg_u,1)
  i1_u = UBOUND(SrcMemberTypeData%I_lmg_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_lmg_u)) THEN 
    ALLOCATE(DstMemberTypeData%I_lmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_lmg_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_lmg_u = SrcMemberTypeData%I_lmg_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_rmg_l)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_rmg_l,1)
  i1_u = UBOUND(SrcMemberTypeData%I_rmg_l,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_rmg_l)) THEN 
    ALLOCATE(DstMemberTypeData%I_rmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rmg_l.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_rmg_l = SrcMemberTypeData%I_rmg_l
ENDIF
IF (ALLOCATED(SrcMemberTypeData%I_rmg_u)) THEN
  i1_l = LBOUND(SrcMemberTypeData%I_rmg_u,1)
  i1_u = UBOUND(SrcMemberTypeData%I_rmg_u,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%I_rmg_u)) THEN 
    ALLOCATE(DstMemberTypeData%I_rmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%I_rmg_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%I_rmg_u = SrcMemberTypeData%I_rmg_u
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Cfl_fb)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Cfl_fb,1)
  i1_u = UBOUND(SrcMemberTypeData%Cfl_fb,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Cfl_fb)) THEN 
    ALLOCATE(DstMemberTypeData%Cfl_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cfl_fb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Cfl_fb = SrcMemberTypeData%Cfl_fb
ENDIF
IF (ALLOCATED(SrcMemberTypeData%Cfr_fb)) THEN
  i1_l = LBOUND(SrcMemberTypeData%Cfr_fb,1)
  i1_u = UBOUND(SrcMemberTypeData%Cfr_fb,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%Cfr_fb)) THEN 
    ALLOCATE(DstMemberTypeData%Cfr_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%Cfr_fb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%Cfr_fb = SrcMemberTypeData%Cfr_fb
ENDIF
IF (ALLOCATED(SrcMemberTypeData%CM0_fb)) THEN
  i1_l = LBOUND(SrcMemberTypeData%CM0_fb,1)
  i1_u = UBOUND(SrcMemberTypeData%CM0_fb,1)
  IF (.NOT. ALLOCATED(DstMemberTypeData%CM0_fb)) THEN 
    ALLOCATE(DstMemberTypeData%CM0_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberTypeData%CM0_fb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberTypeData%CM0_fb = SrcMemberTypeData%CM0_fb
ENDIF
    DstMemberTypeData%MGvolume = SrcMemberTypeData%MGvolume
    DstMemberTypeData%MDivSize = SrcMemberTypeData%MDivSize
    DstMemberTypeData%MCoefMod = SrcMemberTypeData%MCoefMod
    DstMemberTypeData%MmbrCoefIDIndx = SrcMemberTypeData%MmbrCoefIDIndx
    DstMemberTypeData%MmbrFilledIDIndx = SrcMemberTypeData%MmbrFilledIDIndx
    DstMemberTypeData%FillFSLoc = SrcMemberTypeData%FillFSLoc
    DstMemberTypeData%FillDens = SrcMemberTypeData%FillDens
    DstMemberTypeData%PropPot = SrcMemberTypeData%PropPot
    DstMemberTypeData%Flipped = SrcMemberTypeData%Flipped
 END SUBROUTINE Morison_CopyMemberType

 SUBROUTINE Morison_DestroyMemberType( MemberTypeData, ErrStat, ErrMsg )
  TYPE(Morison_MemberType), INTENT(INOUT) :: MemberTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMemberType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MemberTypeData%NodeIndx)) THEN
  DEALLOCATE(MemberTypeData%NodeIndx)
ENDIF
IF (ALLOCATED(MemberTypeData%R)) THEN
  DEALLOCATE(MemberTypeData%R)
ENDIF
IF (ALLOCATED(MemberTypeData%RMG)) THEN
  DEALLOCATE(MemberTypeData%RMG)
ENDIF
IF (ALLOCATED(MemberTypeData%Rin)) THEN
  DEALLOCATE(MemberTypeData%Rin)
ENDIF
IF (ALLOCATED(MemberTypeData%tMG)) THEN
  DEALLOCATE(MemberTypeData%tMG)
ENDIF
IF (ALLOCATED(MemberTypeData%MGdensity)) THEN
  DEALLOCATE(MemberTypeData%MGdensity)
ENDIF
IF (ALLOCATED(MemberTypeData%dRdl_mg)) THEN
  DEALLOCATE(MemberTypeData%dRdl_mg)
ENDIF
IF (ALLOCATED(MemberTypeData%dRdl_in)) THEN
  DEALLOCATE(MemberTypeData%dRdl_in)
ENDIF
IF (ALLOCATED(MemberTypeData%floodstatus)) THEN
  DEALLOCATE(MemberTypeData%floodstatus)
ENDIF
IF (ALLOCATED(MemberTypeData%alpha)) THEN
  DEALLOCATE(MemberTypeData%alpha)
ENDIF
IF (ALLOCATED(MemberTypeData%alpha_fb)) THEN
  DEALLOCATE(MemberTypeData%alpha_fb)
ENDIF
IF (ALLOCATED(MemberTypeData%alpha_fb_star)) THEN
  DEALLOCATE(MemberTypeData%alpha_fb_star)
ENDIF
IF (ALLOCATED(MemberTypeData%Cd)) THEN
  DEALLOCATE(MemberTypeData%Cd)
ENDIF
IF (ALLOCATED(MemberTypeData%Ca)) THEN
  DEALLOCATE(MemberTypeData%Ca)
ENDIF
IF (ALLOCATED(MemberTypeData%Cp)) THEN
  DEALLOCATE(MemberTypeData%Cp)
ENDIF
IF (ALLOCATED(MemberTypeData%AxCd)) THEN
  DEALLOCATE(MemberTypeData%AxCd)
ENDIF
IF (ALLOCATED(MemberTypeData%AxCa)) THEN
  DEALLOCATE(MemberTypeData%AxCa)
ENDIF
IF (ALLOCATED(MemberTypeData%AxCp)) THEN
  DEALLOCATE(MemberTypeData%AxCp)
ENDIF
IF (ALLOCATED(MemberTypeData%m_fb_l)) THEN
  DEALLOCATE(MemberTypeData%m_fb_l)
ENDIF
IF (ALLOCATED(MemberTypeData%m_fb_u)) THEN
  DEALLOCATE(MemberTypeData%m_fb_u)
ENDIF
IF (ALLOCATED(MemberTypeData%h_cfb_l)) THEN
  DEALLOCATE(MemberTypeData%h_cfb_l)
ENDIF
IF (ALLOCATED(MemberTypeData%h_cfb_u)) THEN
  DEALLOCATE(MemberTypeData%h_cfb_u)
ENDIF
IF (ALLOCATED(MemberTypeData%I_lfb_l)) THEN
  DEALLOCATE(MemberTypeData%I_lfb_l)
ENDIF
IF (ALLOCATED(MemberTypeData%I_lfb_u)) THEN
  DEALLOCATE(MemberTypeData%I_lfb_u)
ENDIF
IF (ALLOCATED(MemberTypeData%I_rfb_l)) THEN
  DEALLOCATE(MemberTypeData%I_rfb_l)
ENDIF
IF (ALLOCATED(MemberTypeData%I_rfb_u)) THEN
  DEALLOCATE(MemberTypeData%I_rfb_u)
ENDIF
IF (ALLOCATED(MemberTypeData%m_mg_l)) THEN
  DEALLOCATE(MemberTypeData%m_mg_l)
ENDIF
IF (ALLOCATED(MemberTypeData%m_mg_u)) THEN
  DEALLOCATE(MemberTypeData%m_mg_u)
ENDIF
IF (ALLOCATED(MemberTypeData%h_cmg_l)) THEN
  DEALLOCATE(MemberTypeData%h_cmg_l)
ENDIF
IF (ALLOCATED(MemberTypeData%h_cmg_u)) THEN
  DEALLOCATE(MemberTypeData%h_cmg_u)
ENDIF
IF (ALLOCATED(MemberTypeData%I_lmg_l)) THEN
  DEALLOCATE(MemberTypeData%I_lmg_l)
ENDIF
IF (ALLOCATED(MemberTypeData%I_lmg_u)) THEN
  DEALLOCATE(MemberTypeData%I_lmg_u)
ENDIF
IF (ALLOCATED(MemberTypeData%I_rmg_l)) THEN
  DEALLOCATE(MemberTypeData%I_rmg_l)
ENDIF
IF (ALLOCATED(MemberTypeData%I_rmg_u)) THEN
  DEALLOCATE(MemberTypeData%I_rmg_u)
ENDIF
IF (ALLOCATED(MemberTypeData%Cfl_fb)) THEN
  DEALLOCATE(MemberTypeData%Cfl_fb)
ENDIF
IF (ALLOCATED(MemberTypeData%Cfr_fb)) THEN
  DEALLOCATE(MemberTypeData%Cfr_fb)
ENDIF
IF (ALLOCATED(MemberTypeData%CM0_fb)) THEN
  DEALLOCATE(MemberTypeData%CM0_fb)
ENDIF
 END SUBROUTINE Morison_DestroyMemberType

 SUBROUTINE Morison_PackMemberType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MemberType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMemberType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! NodeIndx allocated yes/no
  IF ( ALLOCATED(InData%NodeIndx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NodeIndx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%NodeIndx)  ! NodeIndx
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! MemberID
      Int_BufSz  = Int_BufSz  + 1  ! NElements
      Re_BufSz   = Re_BufSz   + 1  ! RefLength
      Re_BufSz   = Re_BufSz   + 1  ! cosPhi_ref
      Re_BufSz   = Re_BufSz   + 1  ! dl
      Re_BufSz   = Re_BufSz   + SIZE(InData%k)  ! k
      Re_BufSz   = Re_BufSz   + SIZE(InData%kkt)  ! kkt
      Re_BufSz   = Re_BufSz   + SIZE(InData%Ak)  ! Ak
  Int_BufSz   = Int_BufSz   + 1     ! R allocated yes/no
  IF ( ALLOCATED(InData%R) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! R upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%R)  ! R
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RMG allocated yes/no
  IF ( ALLOCATED(InData%RMG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RMG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RMG)  ! RMG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Rin allocated yes/no
  IF ( ALLOCATED(InData%Rin) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Rin upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Rin)  ! Rin
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! tMG allocated yes/no
  IF ( ALLOCATED(InData%tMG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! tMG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%tMG)  ! tMG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MGdensity allocated yes/no
  IF ( ALLOCATED(InData%MGdensity) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MGdensity upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MGdensity)  ! MGdensity
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dRdl_mg allocated yes/no
  IF ( ALLOCATED(InData%dRdl_mg) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dRdl_mg upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dRdl_mg)  ! dRdl_mg
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dRdl_in allocated yes/no
  IF ( ALLOCATED(InData%dRdl_in) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dRdl_in upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dRdl_in)  ! dRdl_in
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Vinner
      Re_BufSz   = Re_BufSz   + 1  ! Vouter
      Re_BufSz   = Re_BufSz   + 1  ! Vballast
      Re_BufSz   = Re_BufSz   + 1  ! Vsubmerged
      Re_BufSz   = Re_BufSz   + 1  ! l_fill
      Re_BufSz   = Re_BufSz   + 1  ! h_fill
      Re_BufSz   = Re_BufSz   + 1  ! z_overfill
      Re_BufSz   = Re_BufSz   + 1  ! h_floor
      Int_BufSz  = Int_BufSz  + 1  ! i_floor
      Int_BufSz  = Int_BufSz  + 1  ! doEndBuoyancy
      Int_BufSz  = Int_BufSz  + 1  ! memfloodstatus
  Int_BufSz   = Int_BufSz   + 1     ! floodstatus allocated yes/no
  IF ( ALLOCATED(InData%floodstatus) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! floodstatus upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%floodstatus)  ! floodstatus
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha allocated yes/no
  IF ( ALLOCATED(InData%alpha) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! alpha upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha)  ! alpha
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha_fb allocated yes/no
  IF ( ALLOCATED(InData%alpha_fb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! alpha_fb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_fb)  ! alpha_fb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha_fb_star allocated yes/no
  IF ( ALLOCATED(InData%alpha_fb_star) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! alpha_fb_star upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_fb_star)  ! alpha_fb_star
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cd allocated yes/no
  IF ( ALLOCATED(InData%Cd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Cd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cd)  ! Cd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Ca allocated yes/no
  IF ( ALLOCATED(InData%Ca) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Ca upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Ca)  ! Ca
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cp allocated yes/no
  IF ( ALLOCATED(InData%Cp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Cp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cp)  ! Cp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxCd allocated yes/no
  IF ( ALLOCATED(InData%AxCd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AxCd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxCd)  ! AxCd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxCa allocated yes/no
  IF ( ALLOCATED(InData%AxCa) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AxCa upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxCa)  ! AxCa
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxCp allocated yes/no
  IF ( ALLOCATED(InData%AxCp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AxCp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxCp)  ! AxCp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m_fb_l allocated yes/no
  IF ( ALLOCATED(InData%m_fb_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! m_fb_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%m_fb_l)  ! m_fb_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m_fb_u allocated yes/no
  IF ( ALLOCATED(InData%m_fb_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! m_fb_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%m_fb_u)  ! m_fb_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! h_cfb_l allocated yes/no
  IF ( ALLOCATED(InData%h_cfb_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! h_cfb_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%h_cfb_l)  ! h_cfb_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! h_cfb_u allocated yes/no
  IF ( ALLOCATED(InData%h_cfb_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! h_cfb_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%h_cfb_u)  ! h_cfb_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_lfb_l allocated yes/no
  IF ( ALLOCATED(InData%I_lfb_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_lfb_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_lfb_l)  ! I_lfb_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_lfb_u allocated yes/no
  IF ( ALLOCATED(InData%I_lfb_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_lfb_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_lfb_u)  ! I_lfb_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_rfb_l allocated yes/no
  IF ( ALLOCATED(InData%I_rfb_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_rfb_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_rfb_l)  ! I_rfb_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_rfb_u allocated yes/no
  IF ( ALLOCATED(InData%I_rfb_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_rfb_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_rfb_u)  ! I_rfb_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m_mg_l allocated yes/no
  IF ( ALLOCATED(InData%m_mg_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! m_mg_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%m_mg_l)  ! m_mg_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m_mg_u allocated yes/no
  IF ( ALLOCATED(InData%m_mg_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! m_mg_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%m_mg_u)  ! m_mg_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! h_cmg_l allocated yes/no
  IF ( ALLOCATED(InData%h_cmg_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! h_cmg_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%h_cmg_l)  ! h_cmg_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! h_cmg_u allocated yes/no
  IF ( ALLOCATED(InData%h_cmg_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! h_cmg_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%h_cmg_u)  ! h_cmg_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_lmg_l allocated yes/no
  IF ( ALLOCATED(InData%I_lmg_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_lmg_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_lmg_l)  ! I_lmg_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_lmg_u allocated yes/no
  IF ( ALLOCATED(InData%I_lmg_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_lmg_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_lmg_u)  ! I_lmg_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_rmg_l allocated yes/no
  IF ( ALLOCATED(InData%I_rmg_l) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_rmg_l upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_rmg_l)  ! I_rmg_l
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! I_rmg_u allocated yes/no
  IF ( ALLOCATED(InData%I_rmg_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! I_rmg_u upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_rmg_u)  ! I_rmg_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cfl_fb allocated yes/no
  IF ( ALLOCATED(InData%Cfl_fb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Cfl_fb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cfl_fb)  ! Cfl_fb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cfr_fb allocated yes/no
  IF ( ALLOCATED(InData%Cfr_fb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Cfr_fb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cfr_fb)  ! Cfr_fb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CM0_fb allocated yes/no
  IF ( ALLOCATED(InData%CM0_fb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CM0_fb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CM0_fb)  ! CM0_fb
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! MGvolume
      Re_BufSz   = Re_BufSz   + 1  ! MDivSize
      Int_BufSz  = Int_BufSz  + 1  ! MCoefMod
      Int_BufSz  = Int_BufSz  + 1  ! MmbrCoefIDIndx
      Int_BufSz  = Int_BufSz  + 1  ! MmbrFilledIDIndx
      Re_BufSz   = Re_BufSz   + 1  ! FillFSLoc
      Re_BufSz   = Re_BufSz   + 1  ! FillDens
      Int_BufSz  = Int_BufSz  + 1  ! PropPot
      Int_BufSz  = Int_BufSz  + 1  ! Flipped
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%NodeIndx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NodeIndx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NodeIndx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NodeIndx,1), UBOUND(InData%NodeIndx,1)
        IntKiBuf(Int_Xferred) = InData%NodeIndx(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%MemberID
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NElements
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RefLength
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%cosPhi_ref
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dl
    Re_Xferred = Re_Xferred + 1
    DO i1 = LBOUND(InData%k,1), UBOUND(InData%k,1)
      ReKiBuf(Re_Xferred) = InData%k(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%kkt,2), UBOUND(InData%kkt,2)
      DO i1 = LBOUND(InData%kkt,1), UBOUND(InData%kkt,1)
        ReKiBuf(Re_Xferred) = InData%kkt(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%Ak,2), UBOUND(InData%Ak,2)
      DO i1 = LBOUND(InData%Ak,1), UBOUND(InData%Ak,1)
        ReKiBuf(Re_Xferred) = InData%Ak(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%R) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%R,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%R,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%R,1), UBOUND(InData%R,1)
        ReKiBuf(Re_Xferred) = InData%R(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RMG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RMG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RMG,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RMG,1), UBOUND(InData%RMG,1)
        ReKiBuf(Re_Xferred) = InData%RMG(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Rin) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Rin,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Rin,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Rin,1), UBOUND(InData%Rin,1)
        ReKiBuf(Re_Xferred) = InData%Rin(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%tMG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tMG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tMG,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%tMG,1), UBOUND(InData%tMG,1)
        ReKiBuf(Re_Xferred) = InData%tMG(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MGdensity) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MGdensity,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MGdensity,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MGdensity,1), UBOUND(InData%MGdensity,1)
        ReKiBuf(Re_Xferred) = InData%MGdensity(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dRdl_mg) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dRdl_mg,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dRdl_mg,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dRdl_mg,1), UBOUND(InData%dRdl_mg,1)
        ReKiBuf(Re_Xferred) = InData%dRdl_mg(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dRdl_in) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dRdl_in,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dRdl_in,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dRdl_in,1), UBOUND(InData%dRdl_in,1)
        ReKiBuf(Re_Xferred) = InData%dRdl_in(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Vinner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Vouter
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Vballast
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Vsubmerged
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%l_fill
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%h_fill
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%z_overfill
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%h_floor
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%i_floor
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%doEndBuoyancy, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%memfloodstatus
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%floodstatus) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%floodstatus,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%floodstatus,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%floodstatus,1), UBOUND(InData%floodstatus,1)
        IntKiBuf(Int_Xferred) = InData%floodstatus(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%alpha,1), UBOUND(InData%alpha,1)
        ReKiBuf(Re_Xferred) = InData%alpha(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha_fb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_fb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_fb,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%alpha_fb,1), UBOUND(InData%alpha_fb,1)
        ReKiBuf(Re_Xferred) = InData%alpha_fb(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha_fb_star) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_fb_star,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_fb_star,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%alpha_fb_star,1), UBOUND(InData%alpha_fb_star,1)
        ReKiBuf(Re_Xferred) = InData%alpha_fb_star(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Cd,1), UBOUND(InData%Cd,1)
        ReKiBuf(Re_Xferred) = InData%Cd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Ca) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Ca,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Ca,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Ca,1), UBOUND(InData%Ca,1)
        ReKiBuf(Re_Xferred) = InData%Ca(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cp,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Cp,1), UBOUND(InData%Cp,1)
        ReKiBuf(Re_Xferred) = InData%Cp(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxCd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxCd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxCd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AxCd,1), UBOUND(InData%AxCd,1)
        ReKiBuf(Re_Xferred) = InData%AxCd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxCa) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxCa,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxCa,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AxCa,1), UBOUND(InData%AxCa,1)
        ReKiBuf(Re_Xferred) = InData%AxCa(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxCp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxCp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxCp,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AxCp,1), UBOUND(InData%AxCp,1)
        ReKiBuf(Re_Xferred) = InData%AxCp(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m_fb_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m_fb_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m_fb_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%m_fb_l,1), UBOUND(InData%m_fb_l,1)
        ReKiBuf(Re_Xferred) = InData%m_fb_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m_fb_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m_fb_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m_fb_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%m_fb_u,1), UBOUND(InData%m_fb_u,1)
        ReKiBuf(Re_Xferred) = InData%m_fb_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%h_cfb_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%h_cfb_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%h_cfb_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%h_cfb_l,1), UBOUND(InData%h_cfb_l,1)
        ReKiBuf(Re_Xferred) = InData%h_cfb_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%h_cfb_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%h_cfb_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%h_cfb_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%h_cfb_u,1), UBOUND(InData%h_cfb_u,1)
        ReKiBuf(Re_Xferred) = InData%h_cfb_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_lfb_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_lfb_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_lfb_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_lfb_l,1), UBOUND(InData%I_lfb_l,1)
        ReKiBuf(Re_Xferred) = InData%I_lfb_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_lfb_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_lfb_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_lfb_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_lfb_u,1), UBOUND(InData%I_lfb_u,1)
        ReKiBuf(Re_Xferred) = InData%I_lfb_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_rfb_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_rfb_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_rfb_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_rfb_l,1), UBOUND(InData%I_rfb_l,1)
        ReKiBuf(Re_Xferred) = InData%I_rfb_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_rfb_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_rfb_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_rfb_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_rfb_u,1), UBOUND(InData%I_rfb_u,1)
        ReKiBuf(Re_Xferred) = InData%I_rfb_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m_mg_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m_mg_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m_mg_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%m_mg_l,1), UBOUND(InData%m_mg_l,1)
        ReKiBuf(Re_Xferred) = InData%m_mg_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m_mg_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m_mg_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m_mg_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%m_mg_u,1), UBOUND(InData%m_mg_u,1)
        ReKiBuf(Re_Xferred) = InData%m_mg_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%h_cmg_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%h_cmg_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%h_cmg_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%h_cmg_l,1), UBOUND(InData%h_cmg_l,1)
        ReKiBuf(Re_Xferred) = InData%h_cmg_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%h_cmg_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%h_cmg_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%h_cmg_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%h_cmg_u,1), UBOUND(InData%h_cmg_u,1)
        ReKiBuf(Re_Xferred) = InData%h_cmg_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_lmg_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_lmg_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_lmg_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_lmg_l,1), UBOUND(InData%I_lmg_l,1)
        ReKiBuf(Re_Xferred) = InData%I_lmg_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_lmg_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_lmg_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_lmg_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_lmg_u,1), UBOUND(InData%I_lmg_u,1)
        ReKiBuf(Re_Xferred) = InData%I_lmg_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_rmg_l) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_rmg_l,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_rmg_l,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_rmg_l,1), UBOUND(InData%I_rmg_l,1)
        ReKiBuf(Re_Xferred) = InData%I_rmg_l(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%I_rmg_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_rmg_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_rmg_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%I_rmg_u,1), UBOUND(InData%I_rmg_u,1)
        ReKiBuf(Re_Xferred) = InData%I_rmg_u(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cfl_fb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cfl_fb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cfl_fb,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Cfl_fb,1), UBOUND(InData%Cfl_fb,1)
        ReKiBuf(Re_Xferred) = InData%Cfl_fb(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cfr_fb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cfr_fb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cfr_fb,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Cfr_fb,1), UBOUND(InData%Cfr_fb,1)
        ReKiBuf(Re_Xferred) = InData%Cfr_fb(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CM0_fb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CM0_fb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CM0_fb,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%CM0_fb,1), UBOUND(InData%CM0_fb,1)
        ReKiBuf(Re_Xferred) = InData%CM0_fb(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%MGvolume
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MDivSize
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MCoefMod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MmbrCoefIDIndx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MmbrFilledIDIndx
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FillFSLoc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FillDens
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PropPot, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Flipped, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_PackMemberType

 SUBROUTINE Morison_UnPackMemberType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MemberType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMemberType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NodeIndx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NodeIndx)) DEALLOCATE(OutData%NodeIndx)
    ALLOCATE(OutData%NodeIndx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NodeIndx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NodeIndx,1), UBOUND(OutData%NodeIndx,1)
        OutData%NodeIndx(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%MemberID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NElements = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RefLength = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%cosPhi_ref = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    i1_l = LBOUND(OutData%k,1)
    i1_u = UBOUND(OutData%k,1)
    DO i1 = LBOUND(OutData%k,1), UBOUND(OutData%k,1)
      OutData%k(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%kkt,1)
    i1_u = UBOUND(OutData%kkt,1)
    i2_l = LBOUND(OutData%kkt,2)
    i2_u = UBOUND(OutData%kkt,2)
    DO i2 = LBOUND(OutData%kkt,2), UBOUND(OutData%kkt,2)
      DO i1 = LBOUND(OutData%kkt,1), UBOUND(OutData%kkt,1)
        OutData%kkt(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%Ak,1)
    i1_u = UBOUND(OutData%Ak,1)
    i2_l = LBOUND(OutData%Ak,2)
    i2_u = UBOUND(OutData%Ak,2)
    DO i2 = LBOUND(OutData%Ak,2), UBOUND(OutData%Ak,2)
      DO i1 = LBOUND(OutData%Ak,1), UBOUND(OutData%Ak,1)
        OutData%Ak(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! R not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%R)) DEALLOCATE(OutData%R)
    ALLOCATE(OutData%R(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%R.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%R,1), UBOUND(OutData%R,1)
        OutData%R(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RMG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RMG)) DEALLOCATE(OutData%RMG)
    ALLOCATE(OutData%RMG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RMG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RMG,1), UBOUND(OutData%RMG,1)
        OutData%RMG(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Rin not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Rin)) DEALLOCATE(OutData%Rin)
    ALLOCATE(OutData%Rin(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Rin.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Rin,1), UBOUND(OutData%Rin,1)
        OutData%Rin(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! tMG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%tMG)) DEALLOCATE(OutData%tMG)
    ALLOCATE(OutData%tMG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%tMG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%tMG,1), UBOUND(OutData%tMG,1)
        OutData%tMG(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MGdensity not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MGdensity)) DEALLOCATE(OutData%MGdensity)
    ALLOCATE(OutData%MGdensity(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MGdensity.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MGdensity,1), UBOUND(OutData%MGdensity,1)
        OutData%MGdensity(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dRdl_mg not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dRdl_mg)) DEALLOCATE(OutData%dRdl_mg)
    ALLOCATE(OutData%dRdl_mg(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dRdl_mg.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dRdl_mg,1), UBOUND(OutData%dRdl_mg,1)
        OutData%dRdl_mg(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dRdl_in not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dRdl_in)) DEALLOCATE(OutData%dRdl_in)
    ALLOCATE(OutData%dRdl_in(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dRdl_in.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dRdl_in,1), UBOUND(OutData%dRdl_in,1)
        OutData%dRdl_in(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Vinner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Vouter = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Vballast = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Vsubmerged = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%l_fill = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%h_fill = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%z_overfill = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%h_floor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%i_floor = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%doEndBuoyancy = TRANSFER(IntKiBuf(Int_Xferred), OutData%doEndBuoyancy)
    Int_Xferred = Int_Xferred + 1
    OutData%memfloodstatus = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! floodstatus not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%floodstatus)) DEALLOCATE(OutData%floodstatus)
    ALLOCATE(OutData%floodstatus(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%floodstatus.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%floodstatus,1), UBOUND(OutData%floodstatus,1)
        OutData%floodstatus(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha)) DEALLOCATE(OutData%alpha)
    ALLOCATE(OutData%alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%alpha,1), UBOUND(OutData%alpha,1)
        OutData%alpha(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_fb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_fb)) DEALLOCATE(OutData%alpha_fb)
    ALLOCATE(OutData%alpha_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_fb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%alpha_fb,1), UBOUND(OutData%alpha_fb,1)
        OutData%alpha_fb(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_fb_star not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_fb_star)) DEALLOCATE(OutData%alpha_fb_star)
    ALLOCATE(OutData%alpha_fb_star(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_fb_star.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%alpha_fb_star,1), UBOUND(OutData%alpha_fb_star,1)
        OutData%alpha_fb_star(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cd)) DEALLOCATE(OutData%Cd)
    ALLOCATE(OutData%Cd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Cd,1), UBOUND(OutData%Cd,1)
        OutData%Cd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Ca not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Ca)) DEALLOCATE(OutData%Ca)
    ALLOCATE(OutData%Ca(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Ca.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Ca,1), UBOUND(OutData%Ca,1)
        OutData%Ca(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cp)) DEALLOCATE(OutData%Cp)
    ALLOCATE(OutData%Cp(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Cp,1), UBOUND(OutData%Cp,1)
        OutData%Cp(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxCd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxCd)) DEALLOCATE(OutData%AxCd)
    ALLOCATE(OutData%AxCd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxCd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AxCd,1), UBOUND(OutData%AxCd,1)
        OutData%AxCd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxCa not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxCa)) DEALLOCATE(OutData%AxCa)
    ALLOCATE(OutData%AxCa(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxCa.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AxCa,1), UBOUND(OutData%AxCa,1)
        OutData%AxCa(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxCp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxCp)) DEALLOCATE(OutData%AxCp)
    ALLOCATE(OutData%AxCp(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxCp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AxCp,1), UBOUND(OutData%AxCp,1)
        OutData%AxCp(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m_fb_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m_fb_l)) DEALLOCATE(OutData%m_fb_l)
    ALLOCATE(OutData%m_fb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m_fb_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%m_fb_l,1), UBOUND(OutData%m_fb_l,1)
        OutData%m_fb_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m_fb_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m_fb_u)) DEALLOCATE(OutData%m_fb_u)
    ALLOCATE(OutData%m_fb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m_fb_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%m_fb_u,1), UBOUND(OutData%m_fb_u,1)
        OutData%m_fb_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! h_cfb_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%h_cfb_l)) DEALLOCATE(OutData%h_cfb_l)
    ALLOCATE(OutData%h_cfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%h_cfb_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%h_cfb_l,1), UBOUND(OutData%h_cfb_l,1)
        OutData%h_cfb_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! h_cfb_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%h_cfb_u)) DEALLOCATE(OutData%h_cfb_u)
    ALLOCATE(OutData%h_cfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%h_cfb_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%h_cfb_u,1), UBOUND(OutData%h_cfb_u,1)
        OutData%h_cfb_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_lfb_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_lfb_l)) DEALLOCATE(OutData%I_lfb_l)
    ALLOCATE(OutData%I_lfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_lfb_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_lfb_l,1), UBOUND(OutData%I_lfb_l,1)
        OutData%I_lfb_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_lfb_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_lfb_u)) DEALLOCATE(OutData%I_lfb_u)
    ALLOCATE(OutData%I_lfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_lfb_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_lfb_u,1), UBOUND(OutData%I_lfb_u,1)
        OutData%I_lfb_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_rfb_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_rfb_l)) DEALLOCATE(OutData%I_rfb_l)
    ALLOCATE(OutData%I_rfb_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_rfb_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_rfb_l,1), UBOUND(OutData%I_rfb_l,1)
        OutData%I_rfb_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_rfb_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_rfb_u)) DEALLOCATE(OutData%I_rfb_u)
    ALLOCATE(OutData%I_rfb_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_rfb_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_rfb_u,1), UBOUND(OutData%I_rfb_u,1)
        OutData%I_rfb_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m_mg_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m_mg_l)) DEALLOCATE(OutData%m_mg_l)
    ALLOCATE(OutData%m_mg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m_mg_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%m_mg_l,1), UBOUND(OutData%m_mg_l,1)
        OutData%m_mg_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m_mg_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m_mg_u)) DEALLOCATE(OutData%m_mg_u)
    ALLOCATE(OutData%m_mg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m_mg_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%m_mg_u,1), UBOUND(OutData%m_mg_u,1)
        OutData%m_mg_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! h_cmg_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%h_cmg_l)) DEALLOCATE(OutData%h_cmg_l)
    ALLOCATE(OutData%h_cmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%h_cmg_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%h_cmg_l,1), UBOUND(OutData%h_cmg_l,1)
        OutData%h_cmg_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! h_cmg_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%h_cmg_u)) DEALLOCATE(OutData%h_cmg_u)
    ALLOCATE(OutData%h_cmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%h_cmg_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%h_cmg_u,1), UBOUND(OutData%h_cmg_u,1)
        OutData%h_cmg_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_lmg_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_lmg_l)) DEALLOCATE(OutData%I_lmg_l)
    ALLOCATE(OutData%I_lmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_lmg_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_lmg_l,1), UBOUND(OutData%I_lmg_l,1)
        OutData%I_lmg_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_lmg_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_lmg_u)) DEALLOCATE(OutData%I_lmg_u)
    ALLOCATE(OutData%I_lmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_lmg_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_lmg_u,1), UBOUND(OutData%I_lmg_u,1)
        OutData%I_lmg_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_rmg_l not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_rmg_l)) DEALLOCATE(OutData%I_rmg_l)
    ALLOCATE(OutData%I_rmg_l(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_rmg_l.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_rmg_l,1), UBOUND(OutData%I_rmg_l,1)
        OutData%I_rmg_l(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_rmg_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_rmg_u)) DEALLOCATE(OutData%I_rmg_u)
    ALLOCATE(OutData%I_rmg_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_rmg_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%I_rmg_u,1), UBOUND(OutData%I_rmg_u,1)
        OutData%I_rmg_u(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cfl_fb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cfl_fb)) DEALLOCATE(OutData%Cfl_fb)
    ALLOCATE(OutData%Cfl_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cfl_fb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Cfl_fb,1), UBOUND(OutData%Cfl_fb,1)
        OutData%Cfl_fb(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cfr_fb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cfr_fb)) DEALLOCATE(OutData%Cfr_fb)
    ALLOCATE(OutData%Cfr_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cfr_fb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Cfr_fb,1), UBOUND(OutData%Cfr_fb,1)
        OutData%Cfr_fb(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CM0_fb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CM0_fb)) DEALLOCATE(OutData%CM0_fb)
    ALLOCATE(OutData%CM0_fb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CM0_fb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%CM0_fb,1), UBOUND(OutData%CM0_fb,1)
        OutData%CM0_fb(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%MGvolume = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MDivSize = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MCoefMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MmbrCoefIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MmbrFilledIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%FillFSLoc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FillDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PropPot = TRANSFER(IntKiBuf(Int_Xferred), OutData%PropPot)
    Int_Xferred = Int_Xferred + 1
    OutData%Flipped = TRANSFER(IntKiBuf(Int_Xferred), OutData%Flipped)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_UnPackMemberType

 SUBROUTINE Morison_CopyMemberLoads( SrcMemberLoadsData, DstMemberLoadsData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MemberLoads), INTENT(IN) :: SrcMemberLoadsData
   TYPE(Morison_MemberLoads), INTENT(INOUT) :: DstMemberLoadsData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMemberLoads'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMemberLoadsData%F_D)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_D,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_D,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_D,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_D,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_D)) THEN 
    ALLOCATE(DstMemberLoadsData%F_D(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_D.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_D = SrcMemberLoadsData%F_D
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_I)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_I,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_I,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_I,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_I,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_I)) THEN 
    ALLOCATE(DstMemberLoadsData%F_I(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_I.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_I = SrcMemberLoadsData%F_I
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_A)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_A,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_A,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_A,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_A,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_A)) THEN 
    ALLOCATE(DstMemberLoadsData%F_A(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_A.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_A = SrcMemberLoadsData%F_A
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_B)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_B,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_B,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_B,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_B,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_B)) THEN 
    ALLOCATE(DstMemberLoadsData%F_B(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_B.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_B = SrcMemberLoadsData%F_B
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_BF)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_BF,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_BF,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_BF,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_BF,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_BF)) THEN 
    ALLOCATE(DstMemberLoadsData%F_BF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_BF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_BF = SrcMemberLoadsData%F_BF
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_If)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_If,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_If,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_If,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_If,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_If)) THEN 
    ALLOCATE(DstMemberLoadsData%F_If(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_If.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_If = SrcMemberLoadsData%F_If
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_WMG)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_WMG,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_WMG,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_WMG,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_WMG,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_WMG)) THEN 
    ALLOCATE(DstMemberLoadsData%F_WMG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_WMG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_WMG = SrcMemberLoadsData%F_WMG
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_IMG)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_IMG,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_IMG,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_IMG,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_IMG,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_IMG)) THEN 
    ALLOCATE(DstMemberLoadsData%F_IMG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_IMG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_IMG = SrcMemberLoadsData%F_IMG
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%FV)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%FV,1)
  i1_u = UBOUND(SrcMemberLoadsData%FV,1)
  i2_l = LBOUND(SrcMemberLoadsData%FV,2)
  i2_u = UBOUND(SrcMemberLoadsData%FV,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%FV)) THEN 
    ALLOCATE(DstMemberLoadsData%FV(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%FV.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%FV = SrcMemberLoadsData%FV
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%FA)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%FA,1)
  i1_u = UBOUND(SrcMemberLoadsData%FA,1)
  i2_l = LBOUND(SrcMemberLoadsData%FA,2)
  i2_u = UBOUND(SrcMemberLoadsData%FA,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%FA)) THEN 
    ALLOCATE(DstMemberLoadsData%FA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%FA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%FA = SrcMemberLoadsData%FA
ENDIF
IF (ALLOCATED(SrcMemberLoadsData%F_DP)) THEN
  i1_l = LBOUND(SrcMemberLoadsData%F_DP,1)
  i1_u = UBOUND(SrcMemberLoadsData%F_DP,1)
  i2_l = LBOUND(SrcMemberLoadsData%F_DP,2)
  i2_u = UBOUND(SrcMemberLoadsData%F_DP,2)
  IF (.NOT. ALLOCATED(DstMemberLoadsData%F_DP)) THEN 
    ALLOCATE(DstMemberLoadsData%F_DP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMemberLoadsData%F_DP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMemberLoadsData%F_DP = SrcMemberLoadsData%F_DP
ENDIF
 END SUBROUTINE Morison_CopyMemberLoads

 SUBROUTINE Morison_DestroyMemberLoads( MemberLoadsData, ErrStat, ErrMsg )
  TYPE(Morison_MemberLoads), INTENT(INOUT) :: MemberLoadsData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMemberLoads'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MemberLoadsData%F_D)) THEN
  DEALLOCATE(MemberLoadsData%F_D)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_I)) THEN
  DEALLOCATE(MemberLoadsData%F_I)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_A)) THEN
  DEALLOCATE(MemberLoadsData%F_A)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_B)) THEN
  DEALLOCATE(MemberLoadsData%F_B)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_BF)) THEN
  DEALLOCATE(MemberLoadsData%F_BF)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_If)) THEN
  DEALLOCATE(MemberLoadsData%F_If)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_WMG)) THEN
  DEALLOCATE(MemberLoadsData%F_WMG)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_IMG)) THEN
  DEALLOCATE(MemberLoadsData%F_IMG)
ENDIF
IF (ALLOCATED(MemberLoadsData%FV)) THEN
  DEALLOCATE(MemberLoadsData%FV)
ENDIF
IF (ALLOCATED(MemberLoadsData%FA)) THEN
  DEALLOCATE(MemberLoadsData%FA)
ENDIF
IF (ALLOCATED(MemberLoadsData%F_DP)) THEN
  DEALLOCATE(MemberLoadsData%F_DP)
ENDIF
 END SUBROUTINE Morison_DestroyMemberLoads

 SUBROUTINE Morison_PackMemberLoads( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MemberLoads),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMemberLoads'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! F_D allocated yes/no
  IF ( ALLOCATED(InData%F_D) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_D upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_D)  ! F_D
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_I allocated yes/no
  IF ( ALLOCATED(InData%F_I) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_I upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_I)  ! F_I
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_A allocated yes/no
  IF ( ALLOCATED(InData%F_A) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_A upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_A)  ! F_A
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_B allocated yes/no
  IF ( ALLOCATED(InData%F_B) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_B upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_B)  ! F_B
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_BF allocated yes/no
  IF ( ALLOCATED(InData%F_BF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_BF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_BF)  ! F_BF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_If allocated yes/no
  IF ( ALLOCATED(InData%F_If) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_If upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_If)  ! F_If
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_WMG allocated yes/no
  IF ( ALLOCATED(InData%F_WMG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_WMG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_WMG)  ! F_WMG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_IMG allocated yes/no
  IF ( ALLOCATED(InData%F_IMG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_IMG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_IMG)  ! F_IMG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FV allocated yes/no
  IF ( ALLOCATED(InData%FV) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FV upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FV)  ! FV
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FA allocated yes/no
  IF ( ALLOCATED(InData%FA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FA)  ! FA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_DP allocated yes/no
  IF ( ALLOCATED(InData%F_DP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_DP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_DP)  ! F_DP
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%F_D) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_D,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_D,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_D,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_D,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_D,2), UBOUND(InData%F_D,2)
        DO i1 = LBOUND(InData%F_D,1), UBOUND(InData%F_D,1)
          ReKiBuf(Re_Xferred) = InData%F_D(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_I) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_I,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_I,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_I,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_I,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_I,2), UBOUND(InData%F_I,2)
        DO i1 = LBOUND(InData%F_I,1), UBOUND(InData%F_I,1)
          ReKiBuf(Re_Xferred) = InData%F_I(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_A) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_A,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_A,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_A,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_A,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_A,2), UBOUND(InData%F_A,2)
        DO i1 = LBOUND(InData%F_A,1), UBOUND(InData%F_A,1)
          ReKiBuf(Re_Xferred) = InData%F_A(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_B) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_B,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_B,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_B,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_B,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_B,2), UBOUND(InData%F_B,2)
        DO i1 = LBOUND(InData%F_B,1), UBOUND(InData%F_B,1)
          ReKiBuf(Re_Xferred) = InData%F_B(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_BF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_BF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_BF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_BF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_BF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_BF,2), UBOUND(InData%F_BF,2)
        DO i1 = LBOUND(InData%F_BF,1), UBOUND(InData%F_BF,1)
          ReKiBuf(Re_Xferred) = InData%F_BF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_If) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_If,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_If,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_If,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_If,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_If,2), UBOUND(InData%F_If,2)
        DO i1 = LBOUND(InData%F_If,1), UBOUND(InData%F_If,1)
          ReKiBuf(Re_Xferred) = InData%F_If(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_WMG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_WMG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_WMG,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_WMG,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_WMG,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_WMG,2), UBOUND(InData%F_WMG,2)
        DO i1 = LBOUND(InData%F_WMG,1), UBOUND(InData%F_WMG,1)
          ReKiBuf(Re_Xferred) = InData%F_WMG(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_IMG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_IMG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_IMG,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_IMG,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_IMG,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_IMG,2), UBOUND(InData%F_IMG,2)
        DO i1 = LBOUND(InData%F_IMG,1), UBOUND(InData%F_IMG,1)
          ReKiBuf(Re_Xferred) = InData%F_IMG(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FV) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FV,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FV,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FV,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FV,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FV,2), UBOUND(InData%FV,2)
        DO i1 = LBOUND(InData%FV,1), UBOUND(InData%FV,1)
          ReKiBuf(Re_Xferred) = InData%FV(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FA,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FA,2), UBOUND(InData%FA,2)
        DO i1 = LBOUND(InData%FA,1), UBOUND(InData%FA,1)
          ReKiBuf(Re_Xferred) = InData%FA(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_DP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_DP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_DP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_DP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_DP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_DP,2), UBOUND(InData%F_DP,2)
        DO i1 = LBOUND(InData%F_DP,1), UBOUND(InData%F_DP,1)
          ReKiBuf(Re_Xferred) = InData%F_DP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE Morison_PackMemberLoads

 SUBROUTINE Morison_UnPackMemberLoads( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MemberLoads), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMemberLoads'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_D not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_D)) DEALLOCATE(OutData%F_D)
    ALLOCATE(OutData%F_D(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_D.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_D,2), UBOUND(OutData%F_D,2)
        DO i1 = LBOUND(OutData%F_D,1), UBOUND(OutData%F_D,1)
          OutData%F_D(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_I not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_I)) DEALLOCATE(OutData%F_I)
    ALLOCATE(OutData%F_I(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_I.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_I,2), UBOUND(OutData%F_I,2)
        DO i1 = LBOUND(OutData%F_I,1), UBOUND(OutData%F_I,1)
          OutData%F_I(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_A not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_A)) DEALLOCATE(OutData%F_A)
    ALLOCATE(OutData%F_A(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_A.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_A,2), UBOUND(OutData%F_A,2)
        DO i1 = LBOUND(OutData%F_A,1), UBOUND(OutData%F_A,1)
          OutData%F_A(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_B not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_B)) DEALLOCATE(OutData%F_B)
    ALLOCATE(OutData%F_B(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_B.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_B,2), UBOUND(OutData%F_B,2)
        DO i1 = LBOUND(OutData%F_B,1), UBOUND(OutData%F_B,1)
          OutData%F_B(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_BF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_BF)) DEALLOCATE(OutData%F_BF)
    ALLOCATE(OutData%F_BF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_BF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_BF,2), UBOUND(OutData%F_BF,2)
        DO i1 = LBOUND(OutData%F_BF,1), UBOUND(OutData%F_BF,1)
          OutData%F_BF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_If not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_If)) DEALLOCATE(OutData%F_If)
    ALLOCATE(OutData%F_If(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_If.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_If,2), UBOUND(OutData%F_If,2)
        DO i1 = LBOUND(OutData%F_If,1), UBOUND(OutData%F_If,1)
          OutData%F_If(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_WMG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_WMG)) DEALLOCATE(OutData%F_WMG)
    ALLOCATE(OutData%F_WMG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_WMG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_WMG,2), UBOUND(OutData%F_WMG,2)
        DO i1 = LBOUND(OutData%F_WMG,1), UBOUND(OutData%F_WMG,1)
          OutData%F_WMG(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_IMG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_IMG)) DEALLOCATE(OutData%F_IMG)
    ALLOCATE(OutData%F_IMG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_IMG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_IMG,2), UBOUND(OutData%F_IMG,2)
        DO i1 = LBOUND(OutData%F_IMG,1), UBOUND(OutData%F_IMG,1)
          OutData%F_IMG(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FV not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FV)) DEALLOCATE(OutData%FV)
    ALLOCATE(OutData%FV(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FV.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FV,2), UBOUND(OutData%FV,2)
        DO i1 = LBOUND(OutData%FV,1), UBOUND(OutData%FV,1)
          OutData%FV(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FA)) DEALLOCATE(OutData%FA)
    ALLOCATE(OutData%FA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FA,2), UBOUND(OutData%FA,2)
        DO i1 = LBOUND(OutData%FA,1), UBOUND(OutData%FA,1)
          OutData%FA(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_DP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_DP)) DEALLOCATE(OutData%F_DP)
    ALLOCATE(OutData%F_DP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_DP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_DP,2), UBOUND(OutData%F_DP,2)
        DO i1 = LBOUND(OutData%F_DP,1), UBOUND(OutData%F_DP,1)
          OutData%F_DP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE Morison_UnPackMemberLoads

 SUBROUTINE Morison_CopyCoefMembers( SrcCoefMembersData, DstCoefMembersData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_CoefMembers), INTENT(IN) :: SrcCoefMembersData
   TYPE(Morison_CoefMembers), INTENT(INOUT) :: DstCoefMembersData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyCoefMembers'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstCoefMembersData%MemberID = SrcCoefMembersData%MemberID
    DstCoefMembersData%MemberCd1 = SrcCoefMembersData%MemberCd1
    DstCoefMembersData%MemberCd2 = SrcCoefMembersData%MemberCd2
    DstCoefMembersData%MemberCdMG1 = SrcCoefMembersData%MemberCdMG1
    DstCoefMembersData%MemberCdMG2 = SrcCoefMembersData%MemberCdMG2
    DstCoefMembersData%MemberCa1 = SrcCoefMembersData%MemberCa1
    DstCoefMembersData%MemberCa2 = SrcCoefMembersData%MemberCa2
    DstCoefMembersData%MemberCaMG1 = SrcCoefMembersData%MemberCaMG1
    DstCoefMembersData%MemberCaMG2 = SrcCoefMembersData%MemberCaMG2
    DstCoefMembersData%MemberCp1 = SrcCoefMembersData%MemberCp1
    DstCoefMembersData%MemberCp2 = SrcCoefMembersData%MemberCp2
    DstCoefMembersData%MemberCpMG1 = SrcCoefMembersData%MemberCpMG1
    DstCoefMembersData%MemberCpMG2 = SrcCoefMembersData%MemberCpMG2
    DstCoefMembersData%MemberAxCd1 = SrcCoefMembersData%MemberAxCd1
    DstCoefMembersData%MemberAxCd2 = SrcCoefMembersData%MemberAxCd2
    DstCoefMembersData%MemberAxCdMG1 = SrcCoefMembersData%MemberAxCdMG1
    DstCoefMembersData%MemberAxCdMG2 = SrcCoefMembersData%MemberAxCdMG2
    DstCoefMembersData%MemberAxCa1 = SrcCoefMembersData%MemberAxCa1
    DstCoefMembersData%MemberAxCa2 = SrcCoefMembersData%MemberAxCa2
    DstCoefMembersData%MemberAxCaMG1 = SrcCoefMembersData%MemberAxCaMG1
    DstCoefMembersData%MemberAxCaMG2 = SrcCoefMembersData%MemberAxCaMG2
    DstCoefMembersData%MemberAxCp1 = SrcCoefMembersData%MemberAxCp1
    DstCoefMembersData%MemberAxCp2 = SrcCoefMembersData%MemberAxCp2
    DstCoefMembersData%MemberAxCpMG1 = SrcCoefMembersData%MemberAxCpMG1
    DstCoefMembersData%MemberAxCpMG2 = SrcCoefMembersData%MemberAxCpMG2
 END SUBROUTINE Morison_CopyCoefMembers

 SUBROUTINE Morison_DestroyCoefMembers( CoefMembersData, ErrStat, ErrMsg )
  TYPE(Morison_CoefMembers), INTENT(INOUT) :: CoefMembersData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyCoefMembers'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyCoefMembers

 SUBROUTINE Morison_PackCoefMembers( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_CoefMembers),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackCoefMembers'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! MemberID
      Re_BufSz   = Re_BufSz   + 1  ! MemberCd1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCd2
      Re_BufSz   = Re_BufSz   + 1  ! MemberCdMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCdMG2
      Re_BufSz   = Re_BufSz   + 1  ! MemberCa1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCa2
      Re_BufSz   = Re_BufSz   + 1  ! MemberCaMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCaMG2
      Re_BufSz   = Re_BufSz   + 1  ! MemberCp1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCp2
      Re_BufSz   = Re_BufSz   + 1  ! MemberCpMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberCpMG2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCd1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCd2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCdMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCdMG2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCa1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCa2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCaMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCaMG2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCp1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCp2
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCpMG1
      Re_BufSz   = Re_BufSz   + 1  ! MemberAxCpMG2
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%MemberID
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCd1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCd2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCdMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCdMG2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCa1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCa2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCaMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCaMG2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCp1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCp2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCpMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberCpMG2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCd1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCd2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCdMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCdMG2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCa1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCa2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCaMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCaMG2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCp1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCp2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCpMG1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MemberAxCpMG2
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackCoefMembers

 SUBROUTINE Morison_UnPackCoefMembers( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_CoefMembers), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackCoefMembers'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%MemberID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%MemberCd1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCd2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCdMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCdMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCa1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCa2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCaMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCaMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCp1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCp2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCpMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberCpMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCd1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCd2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCdMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCdMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCa1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCa2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCaMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCaMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCp1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCp2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCpMG1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MemberAxCpMG2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackCoefMembers

 SUBROUTINE Morison_CopyMGDepthsType( SrcMGDepthsTypeData, DstMGDepthsTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MGDepthsType), INTENT(IN) :: SrcMGDepthsTypeData
   TYPE(Morison_MGDepthsType), INTENT(INOUT) :: DstMGDepthsTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMGDepthsType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMGDepthsTypeData%MGDpth = SrcMGDepthsTypeData%MGDpth
    DstMGDepthsTypeData%MGThck = SrcMGDepthsTypeData%MGThck
    DstMGDepthsTypeData%MGDens = SrcMGDepthsTypeData%MGDens
 END SUBROUTINE Morison_CopyMGDepthsType

 SUBROUTINE Morison_DestroyMGDepthsType( MGDepthsTypeData, ErrStat, ErrMsg )
  TYPE(Morison_MGDepthsType), INTENT(INOUT) :: MGDepthsTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMGDepthsType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyMGDepthsType

 SUBROUTINE Morison_PackMGDepthsType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MGDepthsType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMGDepthsType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! MGDpth
      Re_BufSz   = Re_BufSz   + 1  ! MGThck
      Re_BufSz   = Re_BufSz   + 1  ! MGDens
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%MGDpth
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MGThck
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MGDens
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackMGDepthsType

 SUBROUTINE Morison_UnPackMGDepthsType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MGDepthsType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMGDepthsType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%MGDpth = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MGThck = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MGDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackMGDepthsType

 SUBROUTINE Morison_CopyMOutput( SrcMOutputData, DstMOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MOutput), INTENT(IN) :: SrcMOutputData
   TYPE(Morison_MOutput), INTENT(INOUT) :: DstMOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMOutputData%MemberID = SrcMOutputData%MemberID
    DstMOutputData%NOutLoc = SrcMOutputData%NOutLoc
IF (ALLOCATED(SrcMOutputData%NodeLocs)) THEN
  i1_l = LBOUND(SrcMOutputData%NodeLocs,1)
  i1_u = UBOUND(SrcMOutputData%NodeLocs,1)
  IF (.NOT. ALLOCATED(DstMOutputData%NodeLocs)) THEN 
    ALLOCATE(DstMOutputData%NodeLocs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%NodeLocs.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%NodeLocs = SrcMOutputData%NodeLocs
ENDIF
    DstMOutputData%MemberIDIndx = SrcMOutputData%MemberIDIndx
IF (ALLOCATED(SrcMOutputData%MeshIndx1)) THEN
  i1_l = LBOUND(SrcMOutputData%MeshIndx1,1)
  i1_u = UBOUND(SrcMOutputData%MeshIndx1,1)
  IF (.NOT. ALLOCATED(DstMOutputData%MeshIndx1)) THEN 
    ALLOCATE(DstMOutputData%MeshIndx1(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MeshIndx1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%MeshIndx1 = SrcMOutputData%MeshIndx1
ENDIF
IF (ALLOCATED(SrcMOutputData%MeshIndx2)) THEN
  i1_l = LBOUND(SrcMOutputData%MeshIndx2,1)
  i1_u = UBOUND(SrcMOutputData%MeshIndx2,1)
  IF (.NOT. ALLOCATED(DstMOutputData%MeshIndx2)) THEN 
    ALLOCATE(DstMOutputData%MeshIndx2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MeshIndx2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%MeshIndx2 = SrcMOutputData%MeshIndx2
ENDIF
IF (ALLOCATED(SrcMOutputData%MemberIndx1)) THEN
  i1_l = LBOUND(SrcMOutputData%MemberIndx1,1)
  i1_u = UBOUND(SrcMOutputData%MemberIndx1,1)
  IF (.NOT. ALLOCATED(DstMOutputData%MemberIndx1)) THEN 
    ALLOCATE(DstMOutputData%MemberIndx1(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MemberIndx1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%MemberIndx1 = SrcMOutputData%MemberIndx1
ENDIF
IF (ALLOCATED(SrcMOutputData%MemberIndx2)) THEN
  i1_l = LBOUND(SrcMOutputData%MemberIndx2,1)
  i1_u = UBOUND(SrcMOutputData%MemberIndx2,1)
  IF (.NOT. ALLOCATED(DstMOutputData%MemberIndx2)) THEN 
    ALLOCATE(DstMOutputData%MemberIndx2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%MemberIndx2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%MemberIndx2 = SrcMOutputData%MemberIndx2
ENDIF
IF (ALLOCATED(SrcMOutputData%s)) THEN
  i1_l = LBOUND(SrcMOutputData%s,1)
  i1_u = UBOUND(SrcMOutputData%s,1)
  IF (.NOT. ALLOCATED(DstMOutputData%s)) THEN 
    ALLOCATE(DstMOutputData%s(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMOutputData%s.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMOutputData%s = SrcMOutputData%s
ENDIF
 END SUBROUTINE Morison_CopyMOutput

 SUBROUTINE Morison_DestroyMOutput( MOutputData, ErrStat, ErrMsg )
  TYPE(Morison_MOutput), INTENT(INOUT) :: MOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MOutputData%NodeLocs)) THEN
  DEALLOCATE(MOutputData%NodeLocs)
ENDIF
IF (ALLOCATED(MOutputData%MeshIndx1)) THEN
  DEALLOCATE(MOutputData%MeshIndx1)
ENDIF
IF (ALLOCATED(MOutputData%MeshIndx2)) THEN
  DEALLOCATE(MOutputData%MeshIndx2)
ENDIF
IF (ALLOCATED(MOutputData%MemberIndx1)) THEN
  DEALLOCATE(MOutputData%MemberIndx1)
ENDIF
IF (ALLOCATED(MOutputData%MemberIndx2)) THEN
  DEALLOCATE(MOutputData%MemberIndx2)
ENDIF
IF (ALLOCATED(MOutputData%s)) THEN
  DEALLOCATE(MOutputData%s)
ENDIF
 END SUBROUTINE Morison_DestroyMOutput

 SUBROUTINE Morison_PackMOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MOutput),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! MemberID
      Int_BufSz  = Int_BufSz  + 1  ! NOutLoc
  Int_BufSz   = Int_BufSz   + 1     ! NodeLocs allocated yes/no
  IF ( ALLOCATED(InData%NodeLocs) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NodeLocs upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%NodeLocs)  ! NodeLocs
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! MemberIDIndx
  Int_BufSz   = Int_BufSz   + 1     ! MeshIndx1 allocated yes/no
  IF ( ALLOCATED(InData%MeshIndx1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MeshIndx1 upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%MeshIndx1)  ! MeshIndx1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MeshIndx2 allocated yes/no
  IF ( ALLOCATED(InData%MeshIndx2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MeshIndx2 upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%MeshIndx2)  ! MeshIndx2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MemberIndx1 allocated yes/no
  IF ( ALLOCATED(InData%MemberIndx1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MemberIndx1 upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%MemberIndx1)  ! MemberIndx1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MemberIndx2 allocated yes/no
  IF ( ALLOCATED(InData%MemberIndx2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MemberIndx2 upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%MemberIndx2)  ! MemberIndx2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! s allocated yes/no
  IF ( ALLOCATED(InData%s) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! s upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%s)  ! s
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%MemberID
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NOutLoc
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%NodeLocs) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NodeLocs,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NodeLocs,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NodeLocs,1), UBOUND(InData%NodeLocs,1)
        ReKiBuf(Re_Xferred) = InData%NodeLocs(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%MemberIDIndx
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%MeshIndx1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeshIndx1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeshIndx1,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MeshIndx1,1), UBOUND(InData%MeshIndx1,1)
        IntKiBuf(Int_Xferred) = InData%MeshIndx1(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MeshIndx2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeshIndx2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeshIndx2,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MeshIndx2,1), UBOUND(InData%MeshIndx2,1)
        IntKiBuf(Int_Xferred) = InData%MeshIndx2(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MemberIndx1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MemberIndx1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MemberIndx1,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MemberIndx1,1), UBOUND(InData%MemberIndx1,1)
        IntKiBuf(Int_Xferred) = InData%MemberIndx1(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MemberIndx2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MemberIndx2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MemberIndx2,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MemberIndx2,1), UBOUND(InData%MemberIndx2,1)
        IntKiBuf(Int_Xferred) = InData%MemberIndx2(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%s) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%s,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%s,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%s,1), UBOUND(InData%s,1)
        ReKiBuf(Re_Xferred) = InData%s(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE Morison_PackMOutput

 SUBROUTINE Morison_UnPackMOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MOutput), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%MemberID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NOutLoc = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NodeLocs not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NodeLocs)) DEALLOCATE(OutData%NodeLocs)
    ALLOCATE(OutData%NodeLocs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NodeLocs.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NodeLocs,1), UBOUND(OutData%NodeLocs,1)
        OutData%NodeLocs(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%MemberIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MeshIndx1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MeshIndx1)) DEALLOCATE(OutData%MeshIndx1)
    ALLOCATE(OutData%MeshIndx1(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MeshIndx1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MeshIndx1,1), UBOUND(OutData%MeshIndx1,1)
        OutData%MeshIndx1(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MeshIndx2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MeshIndx2)) DEALLOCATE(OutData%MeshIndx2)
    ALLOCATE(OutData%MeshIndx2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MeshIndx2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MeshIndx2,1), UBOUND(OutData%MeshIndx2,1)
        OutData%MeshIndx2(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MemberIndx1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MemberIndx1)) DEALLOCATE(OutData%MemberIndx1)
    ALLOCATE(OutData%MemberIndx1(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MemberIndx1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MemberIndx1,1), UBOUND(OutData%MemberIndx1,1)
        OutData%MemberIndx1(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MemberIndx2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MemberIndx2)) DEALLOCATE(OutData%MemberIndx2)
    ALLOCATE(OutData%MemberIndx2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MemberIndx2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MemberIndx2,1), UBOUND(OutData%MemberIndx2,1)
        OutData%MemberIndx2(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! s not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%s)) DEALLOCATE(OutData%s)
    ALLOCATE(OutData%s(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%s.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%s,1), UBOUND(OutData%s,1)
        OutData%s(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE Morison_UnPackMOutput

 SUBROUTINE Morison_CopyJOutput( SrcJOutputData, DstJOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_JOutput), INTENT(IN) :: SrcJOutputData
   TYPE(Morison_JOutput), INTENT(INOUT) :: DstJOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyJOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstJOutputData%JointID = SrcJOutputData%JointID
    DstJOutputData%JointIDIndx = SrcJOutputData%JointIDIndx
 END SUBROUTINE Morison_CopyJOutput

 SUBROUTINE Morison_DestroyJOutput( JOutputData, ErrStat, ErrMsg )
  TYPE(Morison_JOutput), INTENT(INOUT) :: JOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyJOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyJOutput

 SUBROUTINE Morison_PackJOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_JOutput),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackJOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! JointID
      Int_BufSz  = Int_BufSz  + 1  ! JointIDIndx
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%JointID
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%JointIDIndx
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_PackJOutput

 SUBROUTINE Morison_UnPackJOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_JOutput), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackJOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%JointID = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%JointIDIndx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_UnPackJOutput

 SUBROUTINE Morison_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(Morison_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%Gravity = SrcInitInputData%Gravity
    DstInitInputData%WtrDens = SrcInitInputData%WtrDens
    DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
    DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
    DstInitInputData%NJoints = SrcInitInputData%NJoints
    DstInitInputData%NNodes = SrcInitInputData%NNodes
IF (ALLOCATED(SrcInitInputData%InpJoints)) THEN
  i1_l = LBOUND(SrcInitInputData%InpJoints,1)
  i1_u = UBOUND(SrcInitInputData%InpJoints,1)
  IF (.NOT. ALLOCATED(DstInitInputData%InpJoints)) THEN 
    ALLOCATE(DstInitInputData%InpJoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InpJoints.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%InpJoints,1), UBOUND(SrcInitInputData%InpJoints,1)
      CALL Morison_Copyjointtype( SrcInitInputData%InpJoints(i1), DstInitInputData%InpJoints(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInitInputData%Nodes)) THEN
  i1_l = LBOUND(SrcInitInputData%Nodes,1)
  i1_u = UBOUND(SrcInitInputData%Nodes,1)
  IF (.NOT. ALLOCATED(DstInitInputData%Nodes)) THEN 
    ALLOCATE(DstInitInputData%Nodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%Nodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%Nodes,1), UBOUND(SrcInitInputData%Nodes,1)
      CALL Morison_Copynodetype( SrcInitInputData%Nodes(i1), DstInitInputData%Nodes(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NAxCoefs = SrcInitInputData%NAxCoefs
IF (ALLOCATED(SrcInitInputData%AxialCoefs)) THEN
  i1_l = LBOUND(SrcInitInputData%AxialCoefs,1)
  i1_u = UBOUND(SrcInitInputData%AxialCoefs,1)
  IF (.NOT. ALLOCATED(DstInitInputData%AxialCoefs)) THEN 
    ALLOCATE(DstInitInputData%AxialCoefs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AxialCoefs.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%AxialCoefs,1), UBOUND(SrcInitInputData%AxialCoefs,1)
      CALL Morison_Copyaxialcoeftype( SrcInitInputData%AxialCoefs(i1), DstInitInputData%AxialCoefs(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NPropSets = SrcInitInputData%NPropSets
IF (ALLOCATED(SrcInitInputData%MPropSets)) THEN
  i1_l = LBOUND(SrcInitInputData%MPropSets,1)
  i1_u = UBOUND(SrcInitInputData%MPropSets,1)
  IF (.NOT. ALLOCATED(DstInitInputData%MPropSets)) THEN 
    ALLOCATE(DstInitInputData%MPropSets(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MPropSets.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%MPropSets,1), UBOUND(SrcInitInputData%MPropSets,1)
      CALL Morison_Copymemberproptype( SrcInitInputData%MPropSets(i1), DstInitInputData%MPropSets(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%SimplCd = SrcInitInputData%SimplCd
    DstInitInputData%SimplCdMG = SrcInitInputData%SimplCdMG
    DstInitInputData%SimplCa = SrcInitInputData%SimplCa
    DstInitInputData%SimplCaMG = SrcInitInputData%SimplCaMG
    DstInitInputData%SimplCp = SrcInitInputData%SimplCp
    DstInitInputData%SimplCpMG = SrcInitInputData%SimplCpMG
    DstInitInputData%SimplAxCd = SrcInitInputData%SimplAxCd
    DstInitInputData%SimplAxCdMG = SrcInitInputData%SimplAxCdMG
    DstInitInputData%SimplAxCa = SrcInitInputData%SimplAxCa
    DstInitInputData%SimplAxCaMG = SrcInitInputData%SimplAxCaMG
    DstInitInputData%SimplAxCp = SrcInitInputData%SimplAxCp
    DstInitInputData%SimplAxCpMG = SrcInitInputData%SimplAxCpMG
    DstInitInputData%NCoefDpth = SrcInitInputData%NCoefDpth
IF (ALLOCATED(SrcInitInputData%CoefDpths)) THEN
  i1_l = LBOUND(SrcInitInputData%CoefDpths,1)
  i1_u = UBOUND(SrcInitInputData%CoefDpths,1)
  IF (.NOT. ALLOCATED(DstInitInputData%CoefDpths)) THEN 
    ALLOCATE(DstInitInputData%CoefDpths(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefDpths.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%CoefDpths,1), UBOUND(SrcInitInputData%CoefDpths,1)
      CALL Morison_Copycoefdpths( SrcInitInputData%CoefDpths(i1), DstInitInputData%CoefDpths(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NCoefMembers = SrcInitInputData%NCoefMembers
IF (ALLOCATED(SrcInitInputData%CoefMembers)) THEN
  i1_l = LBOUND(SrcInitInputData%CoefMembers,1)
  i1_u = UBOUND(SrcInitInputData%CoefMembers,1)
  IF (.NOT. ALLOCATED(DstInitInputData%CoefMembers)) THEN 
    ALLOCATE(DstInitInputData%CoefMembers(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%CoefMembers.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%CoefMembers,1), UBOUND(SrcInitInputData%CoefMembers,1)
      CALL Morison_Copycoefmembers( SrcInitInputData%CoefMembers(i1), DstInitInputData%CoefMembers(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NMembers = SrcInitInputData%NMembers
IF (ALLOCATED(SrcInitInputData%InpMembers)) THEN
  i1_l = LBOUND(SrcInitInputData%InpMembers,1)
  i1_u = UBOUND(SrcInitInputData%InpMembers,1)
  IF (.NOT. ALLOCATED(DstInitInputData%InpMembers)) THEN 
    ALLOCATE(DstInitInputData%InpMembers(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%InpMembers.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%InpMembers,1), UBOUND(SrcInitInputData%InpMembers,1)
      CALL Morison_Copymemberinputtype( SrcInitInputData%InpMembers(i1), DstInitInputData%InpMembers(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NFillGroups = SrcInitInputData%NFillGroups
IF (ALLOCATED(SrcInitInputData%FilledGroups)) THEN
  i1_l = LBOUND(SrcInitInputData%FilledGroups,1)
  i1_u = UBOUND(SrcInitInputData%FilledGroups,1)
  IF (.NOT. ALLOCATED(DstInitInputData%FilledGroups)) THEN 
    ALLOCATE(DstInitInputData%FilledGroups(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%FilledGroups.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%FilledGroups,1), UBOUND(SrcInitInputData%FilledGroups,1)
      CALL Morison_Copyfilledgrouptype( SrcInitInputData%FilledGroups(i1), DstInitInputData%FilledGroups(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NMGDepths = SrcInitInputData%NMGDepths
IF (ALLOCATED(SrcInitInputData%MGDepths)) THEN
  i1_l = LBOUND(SrcInitInputData%MGDepths,1)
  i1_u = UBOUND(SrcInitInputData%MGDepths,1)
  IF (.NOT. ALLOCATED(DstInitInputData%MGDepths)) THEN 
    ALLOCATE(DstInitInputData%MGDepths(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MGDepths.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%MGDepths,1), UBOUND(SrcInitInputData%MGDepths,1)
      CALL Morison_Copymgdepthstype( SrcInitInputData%MGDepths(i1), DstInitInputData%MGDepths(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%MGTop = SrcInitInputData%MGTop
    DstInitInputData%MGBottom = SrcInitInputData%MGBottom
    DstInitInputData%NMOutputs = SrcInitInputData%NMOutputs
IF (ALLOCATED(SrcInitInputData%MOutLst)) THEN
  i1_l = LBOUND(SrcInitInputData%MOutLst,1)
  i1_u = UBOUND(SrcInitInputData%MOutLst,1)
  IF (.NOT. ALLOCATED(DstInitInputData%MOutLst)) THEN 
    ALLOCATE(DstInitInputData%MOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%MOutLst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%MOutLst,1), UBOUND(SrcInitInputData%MOutLst,1)
      CALL Morison_Copymoutput( SrcInitInputData%MOutLst(i1), DstInitInputData%MOutLst(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%NJOutputs = SrcInitInputData%NJOutputs
IF (ALLOCATED(SrcInitInputData%JOutLst)) THEN
  i1_l = LBOUND(SrcInitInputData%JOutLst,1)
  i1_u = UBOUND(SrcInitInputData%JOutLst,1)
  IF (.NOT. ALLOCATED(DstInitInputData%JOutLst)) THEN 
    ALLOCATE(DstInitInputData%JOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%JOutLst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%JOutLst,1), UBOUND(SrcInitInputData%JOutLst,1)
      CALL Morison_Copyjoutput( SrcInitInputData%JOutLst(i1), DstInitInputData%JOutLst(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%OutList = SrcInitInputData%OutList
IF (ALLOCATED(SrcInitInputData%ValidOutList)) THEN
  i1_l = LBOUND(SrcInitInputData%ValidOutList,1)
  i1_u = UBOUND(SrcInitInputData%ValidOutList,1)
  IF (.NOT. ALLOCATED(DstInitInputData%ValidOutList)) THEN 
    ALLOCATE(DstInitInputData%ValidOutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%ValidOutList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%ValidOutList = SrcInitInputData%ValidOutList
ENDIF
    DstInitInputData%NumOuts = SrcInitInputData%NumOuts
    DstInitInputData%OutSwtch = SrcInitInputData%OutSwtch
    DstInitInputData%OutAll = SrcInitInputData%OutAll
    DstInitInputData%OutRootName = SrcInitInputData%OutRootName
    DstInitInputData%UnOutFile = SrcInitInputData%UnOutFile
    DstInitInputData%UnSum = SrcInitInputData%UnSum
    DstInitInputData%NStepWave = SrcInitInputData%NStepWave
IF (ALLOCATED(SrcInitInputData%WaveAcc)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveAcc,1)
  i1_u = UBOUND(SrcInitInputData%WaveAcc,1)
  i2_l = LBOUND(SrcInitInputData%WaveAcc,2)
  i2_u = UBOUND(SrcInitInputData%WaveAcc,2)
  i3_l = LBOUND(SrcInitInputData%WaveAcc,3)
  i3_u = UBOUND(SrcInitInputData%WaveAcc,3)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveAcc)) THEN 
    ALLOCATE(DstInitInputData%WaveAcc(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveAcc.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveAcc = SrcInitInputData%WaveAcc
ENDIF
IF (ALLOCATED(SrcInitInputData%WaveTime)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveTime,1)
  i1_u = UBOUND(SrcInitInputData%WaveTime,1)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveTime)) THEN 
    ALLOCATE(DstInitInputData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveTime.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveTime = SrcInitInputData%WaveTime
ENDIF
IF (ALLOCATED(SrcInitInputData%WaveDynP)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveDynP,1)
  i1_u = UBOUND(SrcInitInputData%WaveDynP,1)
  i2_l = LBOUND(SrcInitInputData%WaveDynP,2)
  i2_u = UBOUND(SrcInitInputData%WaveDynP,2)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveDynP)) THEN 
    ALLOCATE(DstInitInputData%WaveDynP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveDynP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveDynP = SrcInitInputData%WaveDynP
ENDIF
IF (ALLOCATED(SrcInitInputData%WaveVel)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveVel,1)
  i1_u = UBOUND(SrcInitInputData%WaveVel,1)
  i2_l = LBOUND(SrcInitInputData%WaveVel,2)
  i2_u = UBOUND(SrcInitInputData%WaveVel,2)
  i3_l = LBOUND(SrcInitInputData%WaveVel,3)
  i3_u = UBOUND(SrcInitInputData%WaveVel,3)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveVel)) THEN 
    ALLOCATE(DstInitInputData%WaveVel(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveVel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveVel = SrcInitInputData%WaveVel
ENDIF
IF (ALLOCATED(SrcInitInputData%nodeInWater)) THEN
  i1_l = LBOUND(SrcInitInputData%nodeInWater,1)
  i1_u = UBOUND(SrcInitInputData%nodeInWater,1)
  i2_l = LBOUND(SrcInitInputData%nodeInWater,2)
  i2_u = UBOUND(SrcInitInputData%nodeInWater,2)
  IF (.NOT. ALLOCATED(DstInitInputData%nodeInWater)) THEN 
    ALLOCATE(DstInitInputData%nodeInWater(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%nodeInWater = SrcInitInputData%nodeInWater
ENDIF
 END SUBROUTINE Morison_CopyInitInput

 SUBROUTINE Morison_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(Morison_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%InpJoints)) THEN
DO i1 = LBOUND(InitInputData%InpJoints,1), UBOUND(InitInputData%InpJoints,1)
  CALL Morison_Destroyjointtype( InitInputData%InpJoints(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%InpJoints)
ENDIF
IF (ALLOCATED(InitInputData%Nodes)) THEN
DO i1 = LBOUND(InitInputData%Nodes,1), UBOUND(InitInputData%Nodes,1)
  CALL Morison_Destroynodetype( InitInputData%Nodes(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%Nodes)
ENDIF
IF (ALLOCATED(InitInputData%AxialCoefs)) THEN
DO i1 = LBOUND(InitInputData%AxialCoefs,1), UBOUND(InitInputData%AxialCoefs,1)
  CALL Morison_Destroyaxialcoeftype( InitInputData%AxialCoefs(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%AxialCoefs)
ENDIF
IF (ALLOCATED(InitInputData%MPropSets)) THEN
DO i1 = LBOUND(InitInputData%MPropSets,1), UBOUND(InitInputData%MPropSets,1)
  CALL Morison_Destroymemberproptype( InitInputData%MPropSets(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%MPropSets)
ENDIF
IF (ALLOCATED(InitInputData%CoefDpths)) THEN
DO i1 = LBOUND(InitInputData%CoefDpths,1), UBOUND(InitInputData%CoefDpths,1)
  CALL Morison_Destroycoefdpths( InitInputData%CoefDpths(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%CoefDpths)
ENDIF
IF (ALLOCATED(InitInputData%CoefMembers)) THEN
DO i1 = LBOUND(InitInputData%CoefMembers,1), UBOUND(InitInputData%CoefMembers,1)
  CALL Morison_Destroycoefmembers( InitInputData%CoefMembers(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%CoefMembers)
ENDIF
IF (ALLOCATED(InitInputData%InpMembers)) THEN
DO i1 = LBOUND(InitInputData%InpMembers,1), UBOUND(InitInputData%InpMembers,1)
  CALL Morison_Destroymemberinputtype( InitInputData%InpMembers(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%InpMembers)
ENDIF
IF (ALLOCATED(InitInputData%FilledGroups)) THEN
DO i1 = LBOUND(InitInputData%FilledGroups,1), UBOUND(InitInputData%FilledGroups,1)
  CALL Morison_Destroyfilledgrouptype( InitInputData%FilledGroups(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%FilledGroups)
ENDIF
IF (ALLOCATED(InitInputData%MGDepths)) THEN
DO i1 = LBOUND(InitInputData%MGDepths,1), UBOUND(InitInputData%MGDepths,1)
  CALL Morison_Destroymgdepthstype( InitInputData%MGDepths(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%MGDepths)
ENDIF
IF (ALLOCATED(InitInputData%MOutLst)) THEN
DO i1 = LBOUND(InitInputData%MOutLst,1), UBOUND(InitInputData%MOutLst,1)
  CALL Morison_Destroymoutput( InitInputData%MOutLst(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%MOutLst)
ENDIF
IF (ALLOCATED(InitInputData%JOutLst)) THEN
DO i1 = LBOUND(InitInputData%JOutLst,1), UBOUND(InitInputData%JOutLst,1)
  CALL Morison_Destroyjoutput( InitInputData%JOutLst(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%JOutLst)
ENDIF
IF (ALLOCATED(InitInputData%ValidOutList)) THEN
  DEALLOCATE(InitInputData%ValidOutList)
ENDIF
IF (ALLOCATED(InitInputData%WaveAcc)) THEN
  DEALLOCATE(InitInputData%WaveAcc)
ENDIF
IF (ALLOCATED(InitInputData%WaveTime)) THEN
  DEALLOCATE(InitInputData%WaveTime)
ENDIF
IF (ALLOCATED(InitInputData%WaveDynP)) THEN
  DEALLOCATE(InitInputData%WaveDynP)
ENDIF
IF (ALLOCATED(InitInputData%WaveVel)) THEN
  DEALLOCATE(InitInputData%WaveVel)
ENDIF
IF (ALLOCATED(InitInputData%nodeInWater)) THEN
  DEALLOCATE(InitInputData%nodeInWater)
ENDIF
 END SUBROUTINE Morison_DestroyInitInput

 SUBROUTINE Morison_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
      Re_BufSz   = Re_BufSz   + 1  ! WtrDpth
      Re_BufSz   = Re_BufSz   + 1  ! MSL2SWL
      Int_BufSz  = Int_BufSz  + 1  ! NJoints
      Int_BufSz  = Int_BufSz  + 1  ! NNodes
  Int_BufSz   = Int_BufSz   + 1     ! InpJoints allocated yes/no
  IF ( ALLOCATED(InData%InpJoints) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InpJoints upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%InpJoints,1), UBOUND(InData%InpJoints,1)
      Int_BufSz   = Int_BufSz + 3  ! InpJoints: size of buffers for each call to pack subtype
      CALL Morison_Packjointtype( Re_Buf, Db_Buf, Int_Buf, InData%InpJoints(i1), ErrStat2, ErrMsg2, .TRUE. ) ! InpJoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InpJoints
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InpJoints
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InpJoints
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Nodes allocated yes/no
  IF ( ALLOCATED(InData%Nodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Nodes upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%Nodes,1), UBOUND(InData%Nodes,1)
      Int_BufSz   = Int_BufSz + 3  ! Nodes: size of buffers for each call to pack subtype
      CALL Morison_Packnodetype( Re_Buf, Db_Buf, Int_Buf, InData%Nodes(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Nodes 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Nodes
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Nodes
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Nodes
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NAxCoefs
  Int_BufSz   = Int_BufSz   + 1     ! AxialCoefs allocated yes/no
  IF ( ALLOCATED(InData%AxialCoefs) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AxialCoefs upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%AxialCoefs,1), UBOUND(InData%AxialCoefs,1)
      Int_BufSz   = Int_BufSz + 3  ! AxialCoefs: size of buffers for each call to pack subtype
      CALL Morison_Packaxialcoeftype( Re_Buf, Db_Buf, Int_Buf, InData%AxialCoefs(i1), ErrStat2, ErrMsg2, .TRUE. ) ! AxialCoefs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! AxialCoefs
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! AxialCoefs
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! AxialCoefs
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NPropSets
  Int_BufSz   = Int_BufSz   + 1     ! MPropSets allocated yes/no
  IF ( ALLOCATED(InData%MPropSets) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MPropSets upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%MPropSets,1), UBOUND(InData%MPropSets,1)
      Int_BufSz   = Int_BufSz + 3  ! MPropSets: size of buffers for each call to pack subtype
      CALL Morison_Packmemberproptype( Re_Buf, Db_Buf, Int_Buf, InData%MPropSets(i1), ErrStat2, ErrMsg2, .TRUE. ) ! MPropSets 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! MPropSets
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! MPropSets
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! MPropSets
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! SimplCd
      Re_BufSz   = Re_BufSz   + 1  ! SimplCdMG
      Re_BufSz   = Re_BufSz   + 1  ! SimplCa
      Re_BufSz   = Re_BufSz   + 1  ! SimplCaMG
      Re_BufSz   = Re_BufSz   + 1  ! SimplCp
      Re_BufSz   = Re_BufSz   + 1  ! SimplCpMG
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCd
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCdMG
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCa
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCaMG
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCp
      Re_BufSz   = Re_BufSz   + 1  ! SimplAxCpMG
      Int_BufSz  = Int_BufSz  + 1  ! NCoefDpth
  Int_BufSz   = Int_BufSz   + 1     ! CoefDpths allocated yes/no
  IF ( ALLOCATED(InData%CoefDpths) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CoefDpths upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%CoefDpths,1), UBOUND(InData%CoefDpths,1)
      Int_BufSz   = Int_BufSz + 3  ! CoefDpths: size of buffers for each call to pack subtype
      CALL Morison_Packcoefdpths( Re_Buf, Db_Buf, Int_Buf, InData%CoefDpths(i1), ErrStat2, ErrMsg2, .TRUE. ) ! CoefDpths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! CoefDpths
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! CoefDpths
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! CoefDpths
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NCoefMembers
  Int_BufSz   = Int_BufSz   + 1     ! CoefMembers allocated yes/no
  IF ( ALLOCATED(InData%CoefMembers) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CoefMembers upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%CoefMembers,1), UBOUND(InData%CoefMembers,1)
      Int_BufSz   = Int_BufSz + 3  ! CoefMembers: size of buffers for each call to pack subtype
      CALL Morison_Packcoefmembers( Re_Buf, Db_Buf, Int_Buf, InData%CoefMembers(i1), ErrStat2, ErrMsg2, .TRUE. ) ! CoefMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! CoefMembers
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! CoefMembers
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! CoefMembers
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NMembers
  Int_BufSz   = Int_BufSz   + 1     ! InpMembers allocated yes/no
  IF ( ALLOCATED(InData%InpMembers) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InpMembers upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%InpMembers,1), UBOUND(InData%InpMembers,1)
      Int_BufSz   = Int_BufSz + 3  ! InpMembers: size of buffers for each call to pack subtype
      CALL Morison_Packmemberinputtype( Re_Buf, Db_Buf, Int_Buf, InData%InpMembers(i1), ErrStat2, ErrMsg2, .TRUE. ) ! InpMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InpMembers
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InpMembers
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InpMembers
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NFillGroups
  Int_BufSz   = Int_BufSz   + 1     ! FilledGroups allocated yes/no
  IF ( ALLOCATED(InData%FilledGroups) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FilledGroups upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%FilledGroups,1), UBOUND(InData%FilledGroups,1)
      Int_BufSz   = Int_BufSz + 3  ! FilledGroups: size of buffers for each call to pack subtype
      CALL Morison_Packfilledgrouptype( Re_Buf, Db_Buf, Int_Buf, InData%FilledGroups(i1), ErrStat2, ErrMsg2, .TRUE. ) ! FilledGroups 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! FilledGroups
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! FilledGroups
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! FilledGroups
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NMGDepths
  Int_BufSz   = Int_BufSz   + 1     ! MGDepths allocated yes/no
  IF ( ALLOCATED(InData%MGDepths) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MGDepths upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%MGDepths,1), UBOUND(InData%MGDepths,1)
      Int_BufSz   = Int_BufSz + 3  ! MGDepths: size of buffers for each call to pack subtype
      CALL Morison_Packmgdepthstype( Re_Buf, Db_Buf, Int_Buf, InData%MGDepths(i1), ErrStat2, ErrMsg2, .TRUE. ) ! MGDepths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! MGDepths
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! MGDepths
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! MGDepths
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! MGTop
      Re_BufSz   = Re_BufSz   + 1  ! MGBottom
      Int_BufSz  = Int_BufSz  + 1  ! NMOutputs
  Int_BufSz   = Int_BufSz   + 1     ! MOutLst allocated yes/no
  IF ( ALLOCATED(InData%MOutLst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MOutLst upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%MOutLst,1), UBOUND(InData%MOutLst,1)
      Int_BufSz   = Int_BufSz + 3  ! MOutLst: size of buffers for each call to pack subtype
      CALL Morison_Packmoutput( Re_Buf, Db_Buf, Int_Buf, InData%MOutLst(i1), ErrStat2, ErrMsg2, .TRUE. ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! MOutLst
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! MOutLst
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! MOutLst
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NJOutputs
  Int_BufSz   = Int_BufSz   + 1     ! JOutLst allocated yes/no
  IF ( ALLOCATED(InData%JOutLst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! JOutLst upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%JOutLst,1), UBOUND(InData%JOutLst,1)
      Int_BufSz   = Int_BufSz + 3  ! JOutLst: size of buffers for each call to pack subtype
      CALL Morison_Packjoutput( Re_Buf, Db_Buf, Int_Buf, InData%JOutLst(i1), ErrStat2, ErrMsg2, .TRUE. ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! JOutLst
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! JOutLst
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! JOutLst
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + SIZE(InData%OutList)*LEN(InData%OutList)  ! OutList
  Int_BufSz   = Int_BufSz   + 1     ! ValidOutList allocated yes/no
  IF ( ALLOCATED(InData%ValidOutList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ValidOutList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%ValidOutList)  ! ValidOutList
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! OutSwtch
      Int_BufSz  = Int_BufSz  + 1  ! OutAll
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutRootName)  ! OutRootName
      Int_BufSz  = Int_BufSz  + 1  ! UnOutFile
      Int_BufSz  = Int_BufSz  + 1  ! UnSum
      Int_BufSz  = Int_BufSz  + 1  ! NStepWave
  Int_BufSz   = Int_BufSz   + 1     ! WaveAcc allocated yes/no
  IF ( ALLOCATED(InData%WaveAcc) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveAcc upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveAcc)  ! WaveAcc
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveTime allocated yes/no
  IF ( ALLOCATED(InData%WaveTime) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WaveTime upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveTime)  ! WaveTime
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveDynP allocated yes/no
  IF ( ALLOCATED(InData%WaveDynP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! WaveDynP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveDynP)  ! WaveDynP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveVel allocated yes/no
  IF ( ALLOCATED(InData%WaveVel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveVel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveVel)  ! WaveVel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! nodeInWater allocated yes/no
  IF ( ALLOCATED(InData%nodeInWater) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! nodeInWater upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%nodeInWater)  ! nodeInWater
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDpth
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MSL2SWL
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NJoints
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NNodes
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%InpJoints) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InpJoints,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InpJoints,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%InpJoints,1), UBOUND(InData%InpJoints,1)
      CALL Morison_Packjointtype( Re_Buf, Db_Buf, Int_Buf, InData%InpJoints(i1), ErrStat2, ErrMsg2, OnlySize ) ! InpJoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Nodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Nodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Nodes,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Nodes,1), UBOUND(InData%Nodes,1)
      CALL Morison_Packnodetype( Re_Buf, Db_Buf, Int_Buf, InData%Nodes(i1), ErrStat2, ErrMsg2, OnlySize ) ! Nodes 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NAxCoefs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AxialCoefs) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxialCoefs,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxialCoefs,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%AxialCoefs,1), UBOUND(InData%AxialCoefs,1)
      CALL Morison_Packaxialcoeftype( Re_Buf, Db_Buf, Int_Buf, InData%AxialCoefs(i1), ErrStat2, ErrMsg2, OnlySize ) ! AxialCoefs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NPropSets
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%MPropSets) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MPropSets,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MPropSets,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%MPropSets,1), UBOUND(InData%MPropSets,1)
      CALL Morison_Packmemberproptype( Re_Buf, Db_Buf, Int_Buf, InData%MPropSets(i1), ErrStat2, ErrMsg2, OnlySize ) ! MPropSets 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%SimplCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplCdMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplCaMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplCp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplCpMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCdMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCa
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCaMG
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SimplAxCpMG
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NCoefDpth
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%CoefDpths) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CoefDpths,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CoefDpths,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%CoefDpths,1), UBOUND(InData%CoefDpths,1)
      CALL Morison_Packcoefdpths( Re_Buf, Db_Buf, Int_Buf, InData%CoefDpths(i1), ErrStat2, ErrMsg2, OnlySize ) ! CoefDpths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NCoefMembers
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%CoefMembers) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CoefMembers,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CoefMembers,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%CoefMembers,1), UBOUND(InData%CoefMembers,1)
      CALL Morison_Packcoefmembers( Re_Buf, Db_Buf, Int_Buf, InData%CoefMembers(i1), ErrStat2, ErrMsg2, OnlySize ) ! CoefMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NMembers
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%InpMembers) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InpMembers,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InpMembers,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%InpMembers,1), UBOUND(InData%InpMembers,1)
      CALL Morison_Packmemberinputtype( Re_Buf, Db_Buf, Int_Buf, InData%InpMembers(i1), ErrStat2, ErrMsg2, OnlySize ) ! InpMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NFillGroups
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%FilledGroups) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FilledGroups,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FilledGroups,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%FilledGroups,1), UBOUND(InData%FilledGroups,1)
      CALL Morison_Packfilledgrouptype( Re_Buf, Db_Buf, Int_Buf, InData%FilledGroups(i1), ErrStat2, ErrMsg2, OnlySize ) ! FilledGroups 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NMGDepths
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%MGDepths) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MGDepths,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MGDepths,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%MGDepths,1), UBOUND(InData%MGDepths,1)
      CALL Morison_Packmgdepthstype( Re_Buf, Db_Buf, Int_Buf, InData%MGDepths(i1), ErrStat2, ErrMsg2, OnlySize ) ! MGDepths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%MGTop
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MGBottom
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NMOutputs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%MOutLst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MOutLst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MOutLst,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%MOutLst,1), UBOUND(InData%MOutLst,1)
      CALL Morison_Packmoutput( Re_Buf, Db_Buf, Int_Buf, InData%MOutLst(i1), ErrStat2, ErrMsg2, OnlySize ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NJOutputs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%JOutLst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%JOutLst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%JOutLst,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%JOutLst,1), UBOUND(InData%JOutLst,1)
      CALL Morison_Packjoutput( Re_Buf, Db_Buf, Int_Buf, InData%JOutLst(i1), ErrStat2, ErrMsg2, OnlySize ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    DO i1 = LBOUND(InData%OutList,1), UBOUND(InData%OutList,1)
      DO I = 1, LEN(InData%OutList)
        IntKiBuf(Int_Xferred) = ICHAR(InData%OutList(i1)(I:I), IntKi)
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
  IF ( .NOT. ALLOCATED(InData%ValidOutList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ValidOutList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ValidOutList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ValidOutList,1), UBOUND(InData%ValidOutList,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%ValidOutList(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%OutSwtch
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%OutAll, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutRootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutRootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%UnOutFile
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UnSum
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NStepWave
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%WaveAcc) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveAcc,3), UBOUND(InData%WaveAcc,3)
        DO i2 = LBOUND(InData%WaveAcc,2), UBOUND(InData%WaveAcc,2)
          DO i1 = LBOUND(InData%WaveAcc,1), UBOUND(InData%WaveAcc,1)
            ReKiBuf(Re_Xferred) = InData%WaveAcc(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveTime) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveTime,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveTime,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WaveTime,1), UBOUND(InData%WaveTime,1)
        ReKiBuf(Re_Xferred) = InData%WaveTime(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveDynP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveDynP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveDynP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveDynP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveDynP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%WaveDynP,2), UBOUND(InData%WaveDynP,2)
        DO i1 = LBOUND(InData%WaveDynP,1), UBOUND(InData%WaveDynP,1)
          ReKiBuf(Re_Xferred) = InData%WaveDynP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveVel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveVel,3), UBOUND(InData%WaveVel,3)
        DO i2 = LBOUND(InData%WaveVel,2), UBOUND(InData%WaveVel,2)
          DO i1 = LBOUND(InData%WaveVel,1), UBOUND(InData%WaveVel,1)
            ReKiBuf(Re_Xferred) = InData%WaveVel(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%nodeInWater) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%nodeInWater,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%nodeInWater,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%nodeInWater,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%nodeInWater,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%nodeInWater,2), UBOUND(InData%nodeInWater,2)
        DO i1 = LBOUND(InData%nodeInWater,1), UBOUND(InData%nodeInWater,1)
          IntKiBuf(Int_Xferred) = InData%nodeInWater(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE Morison_PackInitInput

 SUBROUTINE Morison_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDpth = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MSL2SWL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NJoints = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InpJoints not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InpJoints)) DEALLOCATE(OutData%InpJoints)
    ALLOCATE(OutData%InpJoints(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpJoints.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%InpJoints,1), UBOUND(OutData%InpJoints,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackjointtype( Re_Buf, Db_Buf, Int_Buf, OutData%InpJoints(i1), ErrStat2, ErrMsg2 ) ! InpJoints 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Nodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Nodes)) DEALLOCATE(OutData%Nodes)
    ALLOCATE(OutData%Nodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Nodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Nodes,1), UBOUND(OutData%Nodes,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpacknodetype( Re_Buf, Db_Buf, Int_Buf, OutData%Nodes(i1), ErrStat2, ErrMsg2 ) ! Nodes 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NAxCoefs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxialCoefs not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxialCoefs)) DEALLOCATE(OutData%AxialCoefs)
    ALLOCATE(OutData%AxialCoefs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxialCoefs.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%AxialCoefs,1), UBOUND(OutData%AxialCoefs,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackaxialcoeftype( Re_Buf, Db_Buf, Int_Buf, OutData%AxialCoefs(i1), ErrStat2, ErrMsg2 ) ! AxialCoefs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NPropSets = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MPropSets not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MPropSets)) DEALLOCATE(OutData%MPropSets)
    ALLOCATE(OutData%MPropSets(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MPropSets.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%MPropSets,1), UBOUND(OutData%MPropSets,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmemberproptype( Re_Buf, Db_Buf, Int_Buf, OutData%MPropSets(i1), ErrStat2, ErrMsg2 ) ! MPropSets 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%SimplCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplCdMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplCaMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplCpMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCdMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCa = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCaMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SimplAxCpMG = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NCoefDpth = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CoefDpths not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CoefDpths)) DEALLOCATE(OutData%CoefDpths)
    ALLOCATE(OutData%CoefDpths(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefDpths.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%CoefDpths,1), UBOUND(OutData%CoefDpths,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackcoefdpths( Re_Buf, Db_Buf, Int_Buf, OutData%CoefDpths(i1), ErrStat2, ErrMsg2 ) ! CoefDpths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NCoefMembers = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CoefMembers not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CoefMembers)) DEALLOCATE(OutData%CoefMembers)
    ALLOCATE(OutData%CoefMembers(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CoefMembers.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%CoefMembers,1), UBOUND(OutData%CoefMembers,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackcoefmembers( Re_Buf, Db_Buf, Int_Buf, OutData%CoefMembers(i1), ErrStat2, ErrMsg2 ) ! CoefMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NMembers = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InpMembers not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InpMembers)) DEALLOCATE(OutData%InpMembers)
    ALLOCATE(OutData%InpMembers(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpMembers.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%InpMembers,1), UBOUND(OutData%InpMembers,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmemberinputtype( Re_Buf, Db_Buf, Int_Buf, OutData%InpMembers(i1), ErrStat2, ErrMsg2 ) ! InpMembers 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NFillGroups = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FilledGroups not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FilledGroups)) DEALLOCATE(OutData%FilledGroups)
    ALLOCATE(OutData%FilledGroups(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FilledGroups.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%FilledGroups,1), UBOUND(OutData%FilledGroups,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackfilledgrouptype( Re_Buf, Db_Buf, Int_Buf, OutData%FilledGroups(i1), ErrStat2, ErrMsg2 ) ! FilledGroups 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NMGDepths = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MGDepths not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MGDepths)) DEALLOCATE(OutData%MGDepths)
    ALLOCATE(OutData%MGDepths(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MGDepths.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%MGDepths,1), UBOUND(OutData%MGDepths,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmgdepthstype( Re_Buf, Db_Buf, Int_Buf, OutData%MGDepths(i1), ErrStat2, ErrMsg2 ) ! MGDepths 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%MGTop = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MGBottom = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NMOutputs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MOutLst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MOutLst)) DEALLOCATE(OutData%MOutLst)
    ALLOCATE(OutData%MOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MOutLst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%MOutLst,1), UBOUND(OutData%MOutLst,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmoutput( Re_Buf, Db_Buf, Int_Buf, OutData%MOutLst(i1), ErrStat2, ErrMsg2 ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NJOutputs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! JOutLst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%JOutLst)) DEALLOCATE(OutData%JOutLst)
    ALLOCATE(OutData%JOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%JOutLst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%JOutLst,1), UBOUND(OutData%JOutLst,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackjoutput( Re_Buf, Db_Buf, Int_Buf, OutData%JOutLst(i1), ErrStat2, ErrMsg2 ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    i1_l = LBOUND(OutData%OutList,1)
    i1_u = UBOUND(OutData%OutList,1)
    DO i1 = LBOUND(OutData%OutList,1), UBOUND(OutData%OutList,1)
      DO I = 1, LEN(OutData%OutList)
        OutData%OutList(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
        Int_Xferred = Int_Xferred + 1
      END DO ! I
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ValidOutList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ValidOutList)) DEALLOCATE(OutData%ValidOutList)
    ALLOCATE(OutData%ValidOutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ValidOutList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ValidOutList,1), UBOUND(OutData%ValidOutList,1)
        OutData%ValidOutList(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%ValidOutList(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%OutSwtch = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%OutAll = TRANSFER(IntKiBuf(Int_Xferred), OutData%OutAll)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutRootName)
      OutData%OutRootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%UnOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UnSum = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NStepWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveAcc not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveAcc)) DEALLOCATE(OutData%WaveAcc)
    ALLOCATE(OutData%WaveAcc(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveAcc.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveAcc,3), UBOUND(OutData%WaveAcc,3)
        DO i2 = LBOUND(OutData%WaveAcc,2), UBOUND(OutData%WaveAcc,2)
          DO i1 = LBOUND(OutData%WaveAcc,1), UBOUND(OutData%WaveAcc,1)
            OutData%WaveAcc(i1,i2,i3) = REAL(ReKiBuf(Re_Xferred), SiKi)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveTime not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveTime)) DEALLOCATE(OutData%WaveTime)
    ALLOCATE(OutData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveTime.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WaveTime,1), UBOUND(OutData%WaveTime,1)
        OutData%WaveTime(i1) = REAL(ReKiBuf(Re_Xferred), SiKi)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveDynP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveDynP)) DEALLOCATE(OutData%WaveDynP)
    ALLOCATE(OutData%WaveDynP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveDynP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%WaveDynP,2), UBOUND(OutData%WaveDynP,2)
        DO i1 = LBOUND(OutData%WaveDynP,1), UBOUND(OutData%WaveDynP,1)
          OutData%WaveDynP(i1,i2) = REAL(ReKiBuf(Re_Xferred), SiKi)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveVel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveVel)) DEALLOCATE(OutData%WaveVel)
    ALLOCATE(OutData%WaveVel(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveVel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveVel,3), UBOUND(OutData%WaveVel,3)
        DO i2 = LBOUND(OutData%WaveVel,2), UBOUND(OutData%WaveVel,2)
          DO i1 = LBOUND(OutData%WaveVel,1), UBOUND(OutData%WaveVel,1)
            OutData%WaveVel(i1,i2,i3) = REAL(ReKiBuf(Re_Xferred), SiKi)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! nodeInWater not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%nodeInWater)) DEALLOCATE(OutData%nodeInWater)
    ALLOCATE(OutData%nodeInWater(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%nodeInWater,2), UBOUND(OutData%nodeInWater,2)
        DO i1 = LBOUND(OutData%nodeInWater,1), UBOUND(OutData%nodeInWater,1)
          OutData%nodeInWater(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE Morison_UnPackInitInput

 SUBROUTINE Morison_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(Morison_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
 END SUBROUTINE Morison_CopyInitOutput

 SUBROUTINE Morison_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(Morison_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
 END SUBROUTINE Morison_DestroyInitOutput

 SUBROUTINE Morison_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE Morison_PackInitOutput

 SUBROUTINE Morison_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE Morison_UnPackInitOutput

 SUBROUTINE Morison_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(Morison_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%DummyContState = SrcContStateData%DummyContState
 END SUBROUTINE Morison_CopyContState

 SUBROUTINE Morison_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(Morison_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyContState

 SUBROUTINE Morison_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyContState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyContState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackContState

 SUBROUTINE Morison_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyContState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackContState

 SUBROUTINE Morison_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(Morison_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
 END SUBROUTINE Morison_CopyDiscState

 SUBROUTINE Morison_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(Morison_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyDiscState

 SUBROUTINE Morison_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyDiscState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyDiscState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackDiscState

 SUBROUTINE Morison_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyDiscState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackDiscState

 SUBROUTINE Morison_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(Morison_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
 END SUBROUTINE Morison_CopyConstrState

 SUBROUTINE Morison_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(Morison_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyConstrState

 SUBROUTINE Morison_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstrState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstrState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_PackConstrState

 SUBROUTINE Morison_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstrState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE Morison_UnPackConstrState

 SUBROUTINE Morison_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(Morison_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
 END SUBROUTINE Morison_CopyOtherState

 SUBROUTINE Morison_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(Morison_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE Morison_DestroyOtherState

 SUBROUTINE Morison_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! DummyOtherState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%DummyOtherState
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_PackOtherState

 SUBROUTINE Morison_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyOtherState = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_UnPackOtherState

 SUBROUTINE Morison_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(Morison_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%FV)) THEN
  i1_l = LBOUND(SrcMiscData%FV,1)
  i1_u = UBOUND(SrcMiscData%FV,1)
  i2_l = LBOUND(SrcMiscData%FV,2)
  i2_u = UBOUND(SrcMiscData%FV,2)
  IF (.NOT. ALLOCATED(DstMiscData%FV)) THEN 
    ALLOCATE(DstMiscData%FV(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FV.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FV = SrcMiscData%FV
ENDIF
IF (ALLOCATED(SrcMiscData%FA)) THEN
  i1_l = LBOUND(SrcMiscData%FA,1)
  i1_u = UBOUND(SrcMiscData%FA,1)
  i2_l = LBOUND(SrcMiscData%FA,2)
  i2_u = UBOUND(SrcMiscData%FA,2)
  IF (.NOT. ALLOCATED(DstMiscData%FA)) THEN 
    ALLOCATE(DstMiscData%FA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FA = SrcMiscData%FA
ENDIF
IF (ALLOCATED(SrcMiscData%FDynP)) THEN
  i1_l = LBOUND(SrcMiscData%FDynP,1)
  i1_u = UBOUND(SrcMiscData%FDynP,1)
  IF (.NOT. ALLOCATED(DstMiscData%FDynP)) THEN 
    ALLOCATE(DstMiscData%FDynP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FDynP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FDynP = SrcMiscData%FDynP
ENDIF
IF (ALLOCATED(SrcMiscData%vrel)) THEN
  i1_l = LBOUND(SrcMiscData%vrel,1)
  i1_u = UBOUND(SrcMiscData%vrel,1)
  i2_l = LBOUND(SrcMiscData%vrel,2)
  i2_u = UBOUND(SrcMiscData%vrel,2)
  IF (.NOT. ALLOCATED(DstMiscData%vrel)) THEN 
    ALLOCATE(DstMiscData%vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%vrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%vrel = SrcMiscData%vrel
ENDIF
IF (ALLOCATED(SrcMiscData%nodeInWater)) THEN
  i1_l = LBOUND(SrcMiscData%nodeInWater,1)
  i1_u = UBOUND(SrcMiscData%nodeInWater,1)
  IF (.NOT. ALLOCATED(DstMiscData%nodeInWater)) THEN 
    ALLOCATE(DstMiscData%nodeInWater(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%nodeInWater = SrcMiscData%nodeInWater
ENDIF
IF (ALLOCATED(SrcMiscData%memberLoads)) THEN
  i1_l = LBOUND(SrcMiscData%memberLoads,1)
  i1_u = UBOUND(SrcMiscData%memberLoads,1)
  IF (.NOT. ALLOCATED(DstMiscData%memberLoads)) THEN 
    ALLOCATE(DstMiscData%memberLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%memberLoads.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%memberLoads,1), UBOUND(SrcMiscData%memberLoads,1)
      CALL Morison_Copymemberloads( SrcMiscData%memberLoads(i1), DstMiscData%memberLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%F_B_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_B_End,1)
  i1_u = UBOUND(SrcMiscData%F_B_End,1)
  i2_l = LBOUND(SrcMiscData%F_B_End,2)
  i2_u = UBOUND(SrcMiscData%F_B_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_B_End)) THEN 
    ALLOCATE(DstMiscData%F_B_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_B_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_B_End = SrcMiscData%F_B_End
ENDIF
IF (ALLOCATED(SrcMiscData%F_D_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_D_End,1)
  i1_u = UBOUND(SrcMiscData%F_D_End,1)
  i2_l = LBOUND(SrcMiscData%F_D_End,2)
  i2_u = UBOUND(SrcMiscData%F_D_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_D_End)) THEN 
    ALLOCATE(DstMiscData%F_D_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_D_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_D_End = SrcMiscData%F_D_End
ENDIF
IF (ALLOCATED(SrcMiscData%F_I_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_I_End,1)
  i1_u = UBOUND(SrcMiscData%F_I_End,1)
  i2_l = LBOUND(SrcMiscData%F_I_End,2)
  i2_u = UBOUND(SrcMiscData%F_I_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_I_End)) THEN 
    ALLOCATE(DstMiscData%F_I_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_I_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_I_End = SrcMiscData%F_I_End
ENDIF
IF (ALLOCATED(SrcMiscData%F_IMG_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_IMG_End,1)
  i1_u = UBOUND(SrcMiscData%F_IMG_End,1)
  i2_l = LBOUND(SrcMiscData%F_IMG_End,2)
  i2_u = UBOUND(SrcMiscData%F_IMG_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_IMG_End)) THEN 
    ALLOCATE(DstMiscData%F_IMG_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_IMG_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_IMG_End = SrcMiscData%F_IMG_End
ENDIF
IF (ALLOCATED(SrcMiscData%F_A_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_A_End,1)
  i1_u = UBOUND(SrcMiscData%F_A_End,1)
  i2_l = LBOUND(SrcMiscData%F_A_End,2)
  i2_u = UBOUND(SrcMiscData%F_A_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_A_End)) THEN 
    ALLOCATE(DstMiscData%F_A_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_A_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_A_End = SrcMiscData%F_A_End
ENDIF
IF (ALLOCATED(SrcMiscData%F_BF_End)) THEN
  i1_l = LBOUND(SrcMiscData%F_BF_End,1)
  i1_u = UBOUND(SrcMiscData%F_BF_End,1)
  i2_l = LBOUND(SrcMiscData%F_BF_End,2)
  i2_u = UBOUND(SrcMiscData%F_BF_End,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_BF_End)) THEN 
    ALLOCATE(DstMiscData%F_BF_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_BF_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_BF_End = SrcMiscData%F_BF_End
ENDIF
    DstMiscData%LastIndWave = SrcMiscData%LastIndWave
 END SUBROUTINE Morison_CopyMisc

 SUBROUTINE Morison_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(Morison_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%FV)) THEN
  DEALLOCATE(MiscData%FV)
ENDIF
IF (ALLOCATED(MiscData%FA)) THEN
  DEALLOCATE(MiscData%FA)
ENDIF
IF (ALLOCATED(MiscData%FDynP)) THEN
  DEALLOCATE(MiscData%FDynP)
ENDIF
IF (ALLOCATED(MiscData%vrel)) THEN
  DEALLOCATE(MiscData%vrel)
ENDIF
IF (ALLOCATED(MiscData%nodeInWater)) THEN
  DEALLOCATE(MiscData%nodeInWater)
ENDIF
IF (ALLOCATED(MiscData%memberLoads)) THEN
DO i1 = LBOUND(MiscData%memberLoads,1), UBOUND(MiscData%memberLoads,1)
  CALL Morison_Destroymemberloads( MiscData%memberLoads(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%memberLoads)
ENDIF
IF (ALLOCATED(MiscData%F_B_End)) THEN
  DEALLOCATE(MiscData%F_B_End)
ENDIF
IF (ALLOCATED(MiscData%F_D_End)) THEN
  DEALLOCATE(MiscData%F_D_End)
ENDIF
IF (ALLOCATED(MiscData%F_I_End)) THEN
  DEALLOCATE(MiscData%F_I_End)
ENDIF
IF (ALLOCATED(MiscData%F_IMG_End)) THEN
  DEALLOCATE(MiscData%F_IMG_End)
ENDIF
IF (ALLOCATED(MiscData%F_A_End)) THEN
  DEALLOCATE(MiscData%F_A_End)
ENDIF
IF (ALLOCATED(MiscData%F_BF_End)) THEN
  DEALLOCATE(MiscData%F_BF_End)
ENDIF
 END SUBROUTINE Morison_DestroyMisc

 SUBROUTINE Morison_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! FV allocated yes/no
  IF ( ALLOCATED(InData%FV) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FV upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FV)  ! FV
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FA allocated yes/no
  IF ( ALLOCATED(InData%FA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FA)  ! FA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FDynP allocated yes/no
  IF ( ALLOCATED(InData%FDynP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FDynP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FDynP)  ! FDynP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! vrel allocated yes/no
  IF ( ALLOCATED(InData%vrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! vrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%vrel)  ! vrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! nodeInWater allocated yes/no
  IF ( ALLOCATED(InData%nodeInWater) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! nodeInWater upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%nodeInWater)  ! nodeInWater
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! memberLoads allocated yes/no
  IF ( ALLOCATED(InData%memberLoads) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! memberLoads upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%memberLoads,1), UBOUND(InData%memberLoads,1)
      Int_BufSz   = Int_BufSz + 3  ! memberLoads: size of buffers for each call to pack subtype
      CALL Morison_Packmemberloads( Re_Buf, Db_Buf, Int_Buf, InData%memberLoads(i1), ErrStat2, ErrMsg2, .TRUE. ) ! memberLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! memberLoads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! memberLoads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! memberLoads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_B_End allocated yes/no
  IF ( ALLOCATED(InData%F_B_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_B_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_B_End)  ! F_B_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_D_End allocated yes/no
  IF ( ALLOCATED(InData%F_D_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_D_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_D_End)  ! F_D_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_I_End allocated yes/no
  IF ( ALLOCATED(InData%F_I_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_I_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_I_End)  ! F_I_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_IMG_End allocated yes/no
  IF ( ALLOCATED(InData%F_IMG_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_IMG_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_IMG_End)  ! F_IMG_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_A_End allocated yes/no
  IF ( ALLOCATED(InData%F_A_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_A_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_A_End)  ! F_A_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_BF_End allocated yes/no
  IF ( ALLOCATED(InData%F_BF_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_BF_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_BF_End)  ! F_BF_End
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! LastIndWave
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%FV) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FV,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FV,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FV,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FV,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FV,2), UBOUND(InData%FV,2)
        DO i1 = LBOUND(InData%FV,1), UBOUND(InData%FV,1)
          ReKiBuf(Re_Xferred) = InData%FV(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FA,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FA,2), UBOUND(InData%FA,2)
        DO i1 = LBOUND(InData%FA,1), UBOUND(InData%FA,1)
          ReKiBuf(Re_Xferred) = InData%FA(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FDynP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FDynP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FDynP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FDynP,1), UBOUND(InData%FDynP,1)
        ReKiBuf(Re_Xferred) = InData%FDynP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%vrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vrel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vrel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vrel,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%vrel,2), UBOUND(InData%vrel,2)
        DO i1 = LBOUND(InData%vrel,1), UBOUND(InData%vrel,1)
          ReKiBuf(Re_Xferred) = InData%vrel(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%nodeInWater) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%nodeInWater,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%nodeInWater,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%nodeInWater,1), UBOUND(InData%nodeInWater,1)
        IntKiBuf(Int_Xferred) = InData%nodeInWater(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%memberLoads) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%memberLoads,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%memberLoads,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%memberLoads,1), UBOUND(InData%memberLoads,1)
      CALL Morison_Packmemberloads( Re_Buf, Db_Buf, Int_Buf, InData%memberLoads(i1), ErrStat2, ErrMsg2, OnlySize ) ! memberLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_B_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_B_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_B_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_B_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_B_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_B_End,2), UBOUND(InData%F_B_End,2)
        DO i1 = LBOUND(InData%F_B_End,1), UBOUND(InData%F_B_End,1)
          ReKiBuf(Re_Xferred) = InData%F_B_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_D_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_D_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_D_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_D_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_D_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_D_End,2), UBOUND(InData%F_D_End,2)
        DO i1 = LBOUND(InData%F_D_End,1), UBOUND(InData%F_D_End,1)
          ReKiBuf(Re_Xferred) = InData%F_D_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_I_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_I_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_I_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_I_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_I_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_I_End,2), UBOUND(InData%F_I_End,2)
        DO i1 = LBOUND(InData%F_I_End,1), UBOUND(InData%F_I_End,1)
          ReKiBuf(Re_Xferred) = InData%F_I_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_IMG_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_IMG_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_IMG_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_IMG_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_IMG_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_IMG_End,2), UBOUND(InData%F_IMG_End,2)
        DO i1 = LBOUND(InData%F_IMG_End,1), UBOUND(InData%F_IMG_End,1)
          ReKiBuf(Re_Xferred) = InData%F_IMG_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_A_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_A_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_A_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_A_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_A_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_A_End,2), UBOUND(InData%F_A_End,2)
        DO i1 = LBOUND(InData%F_A_End,1), UBOUND(InData%F_A_End,1)
          ReKiBuf(Re_Xferred) = InData%F_A_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_BF_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_BF_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_BF_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_BF_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_BF_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_BF_End,2), UBOUND(InData%F_BF_End,2)
        DO i1 = LBOUND(InData%F_BF_End,1), UBOUND(InData%F_BF_End,1)
          ReKiBuf(Re_Xferred) = InData%F_BF_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%LastIndWave
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_PackMisc

 SUBROUTINE Morison_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FV not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FV)) DEALLOCATE(OutData%FV)
    ALLOCATE(OutData%FV(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FV.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FV,2), UBOUND(OutData%FV,2)
        DO i1 = LBOUND(OutData%FV,1), UBOUND(OutData%FV,1)
          OutData%FV(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FA)) DEALLOCATE(OutData%FA)
    ALLOCATE(OutData%FA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FA,2), UBOUND(OutData%FA,2)
        DO i1 = LBOUND(OutData%FA,1), UBOUND(OutData%FA,1)
          OutData%FA(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FDynP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FDynP)) DEALLOCATE(OutData%FDynP)
    ALLOCATE(OutData%FDynP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FDynP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FDynP,1), UBOUND(OutData%FDynP,1)
        OutData%FDynP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! vrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%vrel)) DEALLOCATE(OutData%vrel)
    ALLOCATE(OutData%vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%vrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%vrel,2), UBOUND(OutData%vrel,2)
        DO i1 = LBOUND(OutData%vrel,1), UBOUND(OutData%vrel,1)
          OutData%vrel(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! nodeInWater not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%nodeInWater)) DEALLOCATE(OutData%nodeInWater)
    ALLOCATE(OutData%nodeInWater(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%nodeInWater,1), UBOUND(OutData%nodeInWater,1)
        OutData%nodeInWater(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! memberLoads not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%memberLoads)) DEALLOCATE(OutData%memberLoads)
    ALLOCATE(OutData%memberLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%memberLoads.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%memberLoads,1), UBOUND(OutData%memberLoads,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmemberloads( Re_Buf, Db_Buf, Int_Buf, OutData%memberLoads(i1), ErrStat2, ErrMsg2 ) ! memberLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_B_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_B_End)) DEALLOCATE(OutData%F_B_End)
    ALLOCATE(OutData%F_B_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_B_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_B_End,2), UBOUND(OutData%F_B_End,2)
        DO i1 = LBOUND(OutData%F_B_End,1), UBOUND(OutData%F_B_End,1)
          OutData%F_B_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_D_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_D_End)) DEALLOCATE(OutData%F_D_End)
    ALLOCATE(OutData%F_D_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_D_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_D_End,2), UBOUND(OutData%F_D_End,2)
        DO i1 = LBOUND(OutData%F_D_End,1), UBOUND(OutData%F_D_End,1)
          OutData%F_D_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_I_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_I_End)) DEALLOCATE(OutData%F_I_End)
    ALLOCATE(OutData%F_I_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_I_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_I_End,2), UBOUND(OutData%F_I_End,2)
        DO i1 = LBOUND(OutData%F_I_End,1), UBOUND(OutData%F_I_End,1)
          OutData%F_I_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_IMG_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_IMG_End)) DEALLOCATE(OutData%F_IMG_End)
    ALLOCATE(OutData%F_IMG_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_IMG_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_IMG_End,2), UBOUND(OutData%F_IMG_End,2)
        DO i1 = LBOUND(OutData%F_IMG_End,1), UBOUND(OutData%F_IMG_End,1)
          OutData%F_IMG_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_A_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_A_End)) DEALLOCATE(OutData%F_A_End)
    ALLOCATE(OutData%F_A_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_A_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_A_End,2), UBOUND(OutData%F_A_End,2)
        DO i1 = LBOUND(OutData%F_A_End,1), UBOUND(OutData%F_A_End,1)
          OutData%F_A_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_BF_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_BF_End)) DEALLOCATE(OutData%F_BF_End)
    ALLOCATE(OutData%F_BF_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_BF_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_BF_End,2), UBOUND(OutData%F_BF_End,2)
        DO i1 = LBOUND(OutData%F_BF_End,1), UBOUND(OutData%F_BF_End,1)
          OutData%F_BF_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%LastIndWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE Morison_UnPackMisc

 SUBROUTINE Morison_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(Morison_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
    DstParamData%Gravity = SrcParamData%Gravity
    DstParamData%WtrDens = SrcParamData%WtrDens
    DstParamData%WtrDpth = SrcParamData%WtrDpth
    DstParamData%MSL2SWL = SrcParamData%MSL2SWL
    DstParamData%NMembers = SrcParamData%NMembers
IF (ALLOCATED(SrcParamData%Members)) THEN
  i1_l = LBOUND(SrcParamData%Members,1)
  i1_u = UBOUND(SrcParamData%Members,1)
  IF (.NOT. ALLOCATED(DstParamData%Members)) THEN 
    ALLOCATE(DstParamData%Members(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Members.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%Members,1), UBOUND(SrcParamData%Members,1)
      CALL Morison_Copymembertype( SrcParamData%Members(i1), DstParamData%Members(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%NNodes = SrcParamData%NNodes
    DstParamData%NJoints = SrcParamData%NJoints
IF (ALLOCATED(SrcParamData%I_MG_End)) THEN
  i1_l = LBOUND(SrcParamData%I_MG_End,1)
  i1_u = UBOUND(SrcParamData%I_MG_End,1)
  i2_l = LBOUND(SrcParamData%I_MG_End,2)
  i2_u = UBOUND(SrcParamData%I_MG_End,2)
  i3_l = LBOUND(SrcParamData%I_MG_End,3)
  i3_u = UBOUND(SrcParamData%I_MG_End,3)
  IF (.NOT. ALLOCATED(DstParamData%I_MG_End)) THEN 
    ALLOCATE(DstParamData%I_MG_End(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%I_MG_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%I_MG_End = SrcParamData%I_MG_End
ENDIF
IF (ALLOCATED(SrcParamData%An_End)) THEN
  i1_l = LBOUND(SrcParamData%An_End,1)
  i1_u = UBOUND(SrcParamData%An_End,1)
  i2_l = LBOUND(SrcParamData%An_End,2)
  i2_u = UBOUND(SrcParamData%An_End,2)
  IF (.NOT. ALLOCATED(DstParamData%An_End)) THEN 
    ALLOCATE(DstParamData%An_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%An_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%An_End = SrcParamData%An_End
ENDIF
IF (ALLOCATED(SrcParamData%DragConst_End)) THEN
  i1_l = LBOUND(SrcParamData%DragConst_End,1)
  i1_u = UBOUND(SrcParamData%DragConst_End,1)
  IF (.NOT. ALLOCATED(DstParamData%DragConst_End)) THEN 
    ALLOCATE(DstParamData%DragConst_End(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DragConst_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DragConst_End = SrcParamData%DragConst_End
ENDIF
IF (ALLOCATED(SrcParamData%F_WMG_End)) THEN
  i1_l = LBOUND(SrcParamData%F_WMG_End,1)
  i1_u = UBOUND(SrcParamData%F_WMG_End,1)
  i2_l = LBOUND(SrcParamData%F_WMG_End,2)
  i2_u = UBOUND(SrcParamData%F_WMG_End,2)
  IF (.NOT. ALLOCATED(DstParamData%F_WMG_End)) THEN 
    ALLOCATE(DstParamData%F_WMG_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%F_WMG_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%F_WMG_End = SrcParamData%F_WMG_End
ENDIF
IF (ALLOCATED(SrcParamData%DP_Const_End)) THEN
  i1_l = LBOUND(SrcParamData%DP_Const_End,1)
  i1_u = UBOUND(SrcParamData%DP_Const_End,1)
  i2_l = LBOUND(SrcParamData%DP_Const_End,2)
  i2_u = UBOUND(SrcParamData%DP_Const_End,2)
  IF (.NOT. ALLOCATED(DstParamData%DP_Const_End)) THEN 
    ALLOCATE(DstParamData%DP_Const_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DP_Const_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DP_Const_End = SrcParamData%DP_Const_End
ENDIF
IF (ALLOCATED(SrcParamData%Mass_MG_End)) THEN
  i1_l = LBOUND(SrcParamData%Mass_MG_End,1)
  i1_u = UBOUND(SrcParamData%Mass_MG_End,1)
  IF (.NOT. ALLOCATED(DstParamData%Mass_MG_End)) THEN 
    ALLOCATE(DstParamData%Mass_MG_End(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Mass_MG_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Mass_MG_End = SrcParamData%Mass_MG_End
ENDIF
IF (ALLOCATED(SrcParamData%AM_End)) THEN
  i1_l = LBOUND(SrcParamData%AM_End,1)
  i1_u = UBOUND(SrcParamData%AM_End,1)
  i2_l = LBOUND(SrcParamData%AM_End,2)
  i2_u = UBOUND(SrcParamData%AM_End,2)
  i3_l = LBOUND(SrcParamData%AM_End,3)
  i3_u = UBOUND(SrcParamData%AM_End,3)
  IF (.NOT. ALLOCATED(DstParamData%AM_End)) THEN 
    ALLOCATE(DstParamData%AM_End(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AM_End.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AM_End = SrcParamData%AM_End
ENDIF
IF (ALLOCATED(SrcParamData%WaveVel)) THEN
  i1_l = LBOUND(SrcParamData%WaveVel,1)
  i1_u = UBOUND(SrcParamData%WaveVel,1)
  i2_l = LBOUND(SrcParamData%WaveVel,2)
  i2_u = UBOUND(SrcParamData%WaveVel,2)
  i3_l = LBOUND(SrcParamData%WaveVel,3)
  i3_u = UBOUND(SrcParamData%WaveVel,3)
  IF (.NOT. ALLOCATED(DstParamData%WaveVel)) THEN 
    ALLOCATE(DstParamData%WaveVel(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveVel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveVel = SrcParamData%WaveVel
ENDIF
IF (ALLOCATED(SrcParamData%WaveAcc)) THEN
  i1_l = LBOUND(SrcParamData%WaveAcc,1)
  i1_u = UBOUND(SrcParamData%WaveAcc,1)
  i2_l = LBOUND(SrcParamData%WaveAcc,2)
  i2_u = UBOUND(SrcParamData%WaveAcc,2)
  i3_l = LBOUND(SrcParamData%WaveAcc,3)
  i3_u = UBOUND(SrcParamData%WaveAcc,3)
  IF (.NOT. ALLOCATED(DstParamData%WaveAcc)) THEN 
    ALLOCATE(DstParamData%WaveAcc(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveAcc.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveAcc = SrcParamData%WaveAcc
ENDIF
IF (ALLOCATED(SrcParamData%WaveDynP)) THEN
  i1_l = LBOUND(SrcParamData%WaveDynP,1)
  i1_u = UBOUND(SrcParamData%WaveDynP,1)
  i2_l = LBOUND(SrcParamData%WaveDynP,2)
  i2_u = UBOUND(SrcParamData%WaveDynP,2)
  IF (.NOT. ALLOCATED(DstParamData%WaveDynP)) THEN 
    ALLOCATE(DstParamData%WaveDynP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveDynP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveDynP = SrcParamData%WaveDynP
ENDIF
IF (ALLOCATED(SrcParamData%WaveTime)) THEN
  i1_l = LBOUND(SrcParamData%WaveTime,1)
  i1_u = UBOUND(SrcParamData%WaveTime,1)
  IF (.NOT. ALLOCATED(DstParamData%WaveTime)) THEN 
    ALLOCATE(DstParamData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveTime.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveTime = SrcParamData%WaveTime
ENDIF
IF (ALLOCATED(SrcParamData%nodeInWater)) THEN
  i1_l = LBOUND(SrcParamData%nodeInWater,1)
  i1_u = UBOUND(SrcParamData%nodeInWater,1)
  i2_l = LBOUND(SrcParamData%nodeInWater,2)
  i2_u = UBOUND(SrcParamData%nodeInWater,2)
  IF (.NOT. ALLOCATED(DstParamData%nodeInWater)) THEN 
    ALLOCATE(DstParamData%nodeInWater(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%nodeInWater = SrcParamData%nodeInWater
ENDIF
    DstParamData%NStepWave = SrcParamData%NStepWave
    DstParamData%NMOutputs = SrcParamData%NMOutputs
IF (ALLOCATED(SrcParamData%MOutLst)) THEN
  i1_l = LBOUND(SrcParamData%MOutLst,1)
  i1_u = UBOUND(SrcParamData%MOutLst,1)
  IF (.NOT. ALLOCATED(DstParamData%MOutLst)) THEN 
    ALLOCATE(DstParamData%MOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MOutLst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%MOutLst,1), UBOUND(SrcParamData%MOutLst,1)
      CALL Morison_Copymoutput( SrcParamData%MOutLst(i1), DstParamData%MOutLst(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%NJOutputs = SrcParamData%NJOutputs
IF (ALLOCATED(SrcParamData%JOutLst)) THEN
  i1_l = LBOUND(SrcParamData%JOutLst,1)
  i1_u = UBOUND(SrcParamData%JOutLst,1)
  IF (.NOT. ALLOCATED(DstParamData%JOutLst)) THEN 
    ALLOCATE(DstParamData%JOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%JOutLst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%JOutLst,1), UBOUND(SrcParamData%JOutLst,1)
      CALL Morison_Copyjoutput( SrcParamData%JOutLst(i1), DstParamData%JOutLst(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcParamData%OutParam)) THEN
  i1_l = LBOUND(SrcParamData%OutParam,1)
  i1_u = UBOUND(SrcParamData%OutParam,1)
  IF (.NOT. ALLOCATED(DstParamData%OutParam)) THEN 
    ALLOCATE(DstParamData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%OutParam,1), UBOUND(SrcParamData%OutParam,1)
      CALL NWTC_Library_Copyoutparmtype( SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%NumOutAll = SrcParamData%NumOutAll
    DstParamData%OutSwtch = SrcParamData%OutSwtch
    DstParamData%UnOutFile = SrcParamData%UnOutFile
    DstParamData%OutFmt = SrcParamData%OutFmt
    DstParamData%OutSFmt = SrcParamData%OutSFmt
    DstParamData%Delim = SrcParamData%Delim
 END SUBROUTINE Morison_CopyParam

 SUBROUTINE Morison_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(Morison_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%Members)) THEN
DO i1 = LBOUND(ParamData%Members,1), UBOUND(ParamData%Members,1)
  CALL Morison_Destroymembertype( ParamData%Members(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%Members)
ENDIF
IF (ALLOCATED(ParamData%I_MG_End)) THEN
  DEALLOCATE(ParamData%I_MG_End)
ENDIF
IF (ALLOCATED(ParamData%An_End)) THEN
  DEALLOCATE(ParamData%An_End)
ENDIF
IF (ALLOCATED(ParamData%DragConst_End)) THEN
  DEALLOCATE(ParamData%DragConst_End)
ENDIF
IF (ALLOCATED(ParamData%F_WMG_End)) THEN
  DEALLOCATE(ParamData%F_WMG_End)
ENDIF
IF (ALLOCATED(ParamData%DP_Const_End)) THEN
  DEALLOCATE(ParamData%DP_Const_End)
ENDIF
IF (ALLOCATED(ParamData%Mass_MG_End)) THEN
  DEALLOCATE(ParamData%Mass_MG_End)
ENDIF
IF (ALLOCATED(ParamData%AM_End)) THEN
  DEALLOCATE(ParamData%AM_End)
ENDIF
IF (ALLOCATED(ParamData%WaveVel)) THEN
  DEALLOCATE(ParamData%WaveVel)
ENDIF
IF (ALLOCATED(ParamData%WaveAcc)) THEN
  DEALLOCATE(ParamData%WaveAcc)
ENDIF
IF (ALLOCATED(ParamData%WaveDynP)) THEN
  DEALLOCATE(ParamData%WaveDynP)
ENDIF
IF (ALLOCATED(ParamData%WaveTime)) THEN
  DEALLOCATE(ParamData%WaveTime)
ENDIF
IF (ALLOCATED(ParamData%nodeInWater)) THEN
  DEALLOCATE(ParamData%nodeInWater)
ENDIF
IF (ALLOCATED(ParamData%MOutLst)) THEN
DO i1 = LBOUND(ParamData%MOutLst,1), UBOUND(ParamData%MOutLst,1)
  CALL Morison_Destroymoutput( ParamData%MOutLst(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%MOutLst)
ENDIF
IF (ALLOCATED(ParamData%JOutLst)) THEN
DO i1 = LBOUND(ParamData%JOutLst,1), UBOUND(ParamData%JOutLst,1)
  CALL Morison_Destroyjoutput( ParamData%JOutLst(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%JOutLst)
ENDIF
IF (ALLOCATED(ParamData%OutParam)) THEN
DO i1 = LBOUND(ParamData%OutParam,1), UBOUND(ParamData%OutParam,1)
  CALL NWTC_Library_Destroyoutparmtype( ParamData%OutParam(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%OutParam)
ENDIF
 END SUBROUTINE Morison_DestroyParam

 SUBROUTINE Morison_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
      Re_BufSz   = Re_BufSz   + 1  ! WtrDpth
      Re_BufSz   = Re_BufSz   + 1  ! MSL2SWL
      Int_BufSz  = Int_BufSz  + 1  ! NMembers
  Int_BufSz   = Int_BufSz   + 1     ! Members allocated yes/no
  IF ( ALLOCATED(InData%Members) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Members upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%Members,1), UBOUND(InData%Members,1)
      Int_BufSz   = Int_BufSz + 3  ! Members: size of buffers for each call to pack subtype
      CALL Morison_Packmembertype( Re_Buf, Db_Buf, Int_Buf, InData%Members(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Members 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Members
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Members
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Members
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NNodes
      Int_BufSz  = Int_BufSz  + 1  ! NJoints
  Int_BufSz   = Int_BufSz   + 1     ! I_MG_End allocated yes/no
  IF ( ALLOCATED(InData%I_MG_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! I_MG_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%I_MG_End)  ! I_MG_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! An_End allocated yes/no
  IF ( ALLOCATED(InData%An_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! An_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%An_End)  ! An_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DragConst_End allocated yes/no
  IF ( ALLOCATED(InData%DragConst_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DragConst_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%DragConst_End)  ! DragConst_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_WMG_End allocated yes/no
  IF ( ALLOCATED(InData%F_WMG_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_WMG_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_WMG_End)  ! F_WMG_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DP_Const_End allocated yes/no
  IF ( ALLOCATED(InData%DP_Const_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! DP_Const_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%DP_Const_End)  ! DP_Const_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Mass_MG_End allocated yes/no
  IF ( ALLOCATED(InData%Mass_MG_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Mass_MG_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Mass_MG_End)  ! Mass_MG_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AM_End allocated yes/no
  IF ( ALLOCATED(InData%AM_End) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AM_End upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AM_End)  ! AM_End
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveVel allocated yes/no
  IF ( ALLOCATED(InData%WaveVel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveVel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveVel)  ! WaveVel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveAcc allocated yes/no
  IF ( ALLOCATED(InData%WaveAcc) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveAcc upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveAcc)  ! WaveAcc
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveDynP allocated yes/no
  IF ( ALLOCATED(InData%WaveDynP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! WaveDynP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveDynP)  ! WaveDynP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveTime allocated yes/no
  IF ( ALLOCATED(InData%WaveTime) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WaveTime upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveTime)  ! WaveTime
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! nodeInWater allocated yes/no
  IF ( ALLOCATED(InData%nodeInWater) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! nodeInWater upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%nodeInWater)  ! nodeInWater
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NStepWave
      Int_BufSz  = Int_BufSz  + 1  ! NMOutputs
  Int_BufSz   = Int_BufSz   + 1     ! MOutLst allocated yes/no
  IF ( ALLOCATED(InData%MOutLst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MOutLst upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%MOutLst,1), UBOUND(InData%MOutLst,1)
      Int_BufSz   = Int_BufSz + 3  ! MOutLst: size of buffers for each call to pack subtype
      CALL Morison_Packmoutput( Re_Buf, Db_Buf, Int_Buf, InData%MOutLst(i1), ErrStat2, ErrMsg2, .TRUE. ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! MOutLst
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! MOutLst
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! MOutLst
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NJOutputs
  Int_BufSz   = Int_BufSz   + 1     ! JOutLst allocated yes/no
  IF ( ALLOCATED(InData%JOutLst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! JOutLst upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%JOutLst,1), UBOUND(InData%JOutLst,1)
      Int_BufSz   = Int_BufSz + 3  ! JOutLst: size of buffers for each call to pack subtype
      CALL Morison_Packjoutput( Re_Buf, Db_Buf, Int_Buf, InData%JOutLst(i1), ErrStat2, ErrMsg2, .TRUE. ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! JOutLst
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! JOutLst
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! JOutLst
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OutParam allocated yes/no
  IF ( ALLOCATED(InData%OutParam) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutParam upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      Int_BufSz   = Int_BufSz + 3  ! OutParam: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, .TRUE. ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! OutParam
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! OutParam
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! OutParam
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! NumOutAll
      Int_BufSz  = Int_BufSz  + 1  ! OutSwtch
      Int_BufSz  = Int_BufSz  + 1  ! UnOutFile
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFmt)  ! OutFmt
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutSFmt)  ! OutSFmt
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Delim)  ! Delim
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDpth
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%MSL2SWL
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NMembers
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Members) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Members,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Members,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Members,1), UBOUND(InData%Members,1)
      CALL Morison_Packmembertype( Re_Buf, Db_Buf, Int_Buf, InData%Members(i1), ErrStat2, ErrMsg2, OnlySize ) ! Members 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NJoints
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%I_MG_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_MG_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_MG_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_MG_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_MG_End,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%I_MG_End,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%I_MG_End,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%I_MG_End,3), UBOUND(InData%I_MG_End,3)
        DO i2 = LBOUND(InData%I_MG_End,2), UBOUND(InData%I_MG_End,2)
          DO i1 = LBOUND(InData%I_MG_End,1), UBOUND(InData%I_MG_End,1)
            ReKiBuf(Re_Xferred) = InData%I_MG_End(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%An_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%An_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%An_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%An_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%An_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%An_End,2), UBOUND(InData%An_End,2)
        DO i1 = LBOUND(InData%An_End,1), UBOUND(InData%An_End,1)
          ReKiBuf(Re_Xferred) = InData%An_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DragConst_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DragConst_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DragConst_End,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DragConst_End,1), UBOUND(InData%DragConst_End,1)
        ReKiBuf(Re_Xferred) = InData%DragConst_End(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_WMG_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_WMG_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_WMG_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_WMG_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_WMG_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_WMG_End,2), UBOUND(InData%F_WMG_End,2)
        DO i1 = LBOUND(InData%F_WMG_End,1), UBOUND(InData%F_WMG_End,1)
          ReKiBuf(Re_Xferred) = InData%F_WMG_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DP_Const_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DP_Const_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DP_Const_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DP_Const_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DP_Const_End,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%DP_Const_End,2), UBOUND(InData%DP_Const_End,2)
        DO i1 = LBOUND(InData%DP_Const_End,1), UBOUND(InData%DP_Const_End,1)
          ReKiBuf(Re_Xferred) = InData%DP_Const_End(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Mass_MG_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Mass_MG_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Mass_MG_End,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Mass_MG_End,1), UBOUND(InData%Mass_MG_End,1)
        ReKiBuf(Re_Xferred) = InData%Mass_MG_End(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AM_End) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AM_End,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AM_End,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AM_End,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AM_End,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AM_End,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AM_End,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AM_End,3), UBOUND(InData%AM_End,3)
        DO i2 = LBOUND(InData%AM_End,2), UBOUND(InData%AM_End,2)
          DO i1 = LBOUND(InData%AM_End,1), UBOUND(InData%AM_End,1)
            ReKiBuf(Re_Xferred) = InData%AM_End(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveVel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveVel,3), UBOUND(InData%WaveVel,3)
        DO i2 = LBOUND(InData%WaveVel,2), UBOUND(InData%WaveVel,2)
          DO i1 = LBOUND(InData%WaveVel,1), UBOUND(InData%WaveVel,1)
            ReKiBuf(Re_Xferred) = InData%WaveVel(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveAcc) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveAcc,3), UBOUND(InData%WaveAcc,3)
        DO i2 = LBOUND(InData%WaveAcc,2), UBOUND(InData%WaveAcc,2)
          DO i1 = LBOUND(InData%WaveAcc,1), UBOUND(InData%WaveAcc,1)
            ReKiBuf(Re_Xferred) = InData%WaveAcc(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveDynP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveDynP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveDynP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveDynP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveDynP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%WaveDynP,2), UBOUND(InData%WaveDynP,2)
        DO i1 = LBOUND(InData%WaveDynP,1), UBOUND(InData%WaveDynP,1)
          ReKiBuf(Re_Xferred) = InData%WaveDynP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveTime) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveTime,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveTime,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WaveTime,1), UBOUND(InData%WaveTime,1)
        ReKiBuf(Re_Xferred) = InData%WaveTime(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%nodeInWater) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%nodeInWater,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%nodeInWater,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%nodeInWater,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%nodeInWater,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%nodeInWater,2), UBOUND(InData%nodeInWater,2)
        DO i1 = LBOUND(InData%nodeInWater,1), UBOUND(InData%nodeInWater,1)
          IntKiBuf(Int_Xferred) = InData%nodeInWater(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NStepWave
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NMOutputs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%MOutLst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MOutLst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MOutLst,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%MOutLst,1), UBOUND(InData%MOutLst,1)
      CALL Morison_Packmoutput( Re_Buf, Db_Buf, Int_Buf, InData%MOutLst(i1), ErrStat2, ErrMsg2, OnlySize ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NJOutputs
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%JOutLst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%JOutLst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%JOutLst,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%JOutLst,1), UBOUND(InData%JOutLst,1)
      CALL Morison_Packjoutput( Re_Buf, Db_Buf, Int_Buf, InData%JOutLst(i1), ErrStat2, ErrMsg2, OnlySize ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OutParam) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutParam,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutParam,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, OnlySize ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOutAll
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%OutSwtch
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UnOutFile
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%OutSFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutSFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE Morison_PackParam

 SUBROUTINE Morison_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDpth = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MSL2SWL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NMembers = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Members not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Members)) DEALLOCATE(OutData%Members)
    ALLOCATE(OutData%Members(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Members.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Members,1), UBOUND(OutData%Members,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmembertype( Re_Buf, Db_Buf, Int_Buf, OutData%Members(i1), ErrStat2, ErrMsg2 ) ! Members 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NJoints = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! I_MG_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%I_MG_End)) DEALLOCATE(OutData%I_MG_End)
    ALLOCATE(OutData%I_MG_End(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%I_MG_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%I_MG_End,3), UBOUND(OutData%I_MG_End,3)
        DO i2 = LBOUND(OutData%I_MG_End,2), UBOUND(OutData%I_MG_End,2)
          DO i1 = LBOUND(OutData%I_MG_End,1), UBOUND(OutData%I_MG_End,1)
            OutData%I_MG_End(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! An_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%An_End)) DEALLOCATE(OutData%An_End)
    ALLOCATE(OutData%An_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%An_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%An_End,2), UBOUND(OutData%An_End,2)
        DO i1 = LBOUND(OutData%An_End,1), UBOUND(OutData%An_End,1)
          OutData%An_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DragConst_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DragConst_End)) DEALLOCATE(OutData%DragConst_End)
    ALLOCATE(OutData%DragConst_End(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DragConst_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DragConst_End,1), UBOUND(OutData%DragConst_End,1)
        OutData%DragConst_End(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_WMG_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_WMG_End)) DEALLOCATE(OutData%F_WMG_End)
    ALLOCATE(OutData%F_WMG_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_WMG_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_WMG_End,2), UBOUND(OutData%F_WMG_End,2)
        DO i1 = LBOUND(OutData%F_WMG_End,1), UBOUND(OutData%F_WMG_End,1)
          OutData%F_WMG_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DP_Const_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DP_Const_End)) DEALLOCATE(OutData%DP_Const_End)
    ALLOCATE(OutData%DP_Const_End(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DP_Const_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%DP_Const_End,2), UBOUND(OutData%DP_Const_End,2)
        DO i1 = LBOUND(OutData%DP_Const_End,1), UBOUND(OutData%DP_Const_End,1)
          OutData%DP_Const_End(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Mass_MG_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Mass_MG_End)) DEALLOCATE(OutData%Mass_MG_End)
    ALLOCATE(OutData%Mass_MG_End(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Mass_MG_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Mass_MG_End,1), UBOUND(OutData%Mass_MG_End,1)
        OutData%Mass_MG_End(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AM_End not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AM_End)) DEALLOCATE(OutData%AM_End)
    ALLOCATE(OutData%AM_End(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AM_End.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AM_End,3), UBOUND(OutData%AM_End,3)
        DO i2 = LBOUND(OutData%AM_End,2), UBOUND(OutData%AM_End,2)
          DO i1 = LBOUND(OutData%AM_End,1), UBOUND(OutData%AM_End,1)
            OutData%AM_End(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveVel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveVel)) DEALLOCATE(OutData%WaveVel)
    ALLOCATE(OutData%WaveVel(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveVel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveVel,3), UBOUND(OutData%WaveVel,3)
        DO i2 = LBOUND(OutData%WaveVel,2), UBOUND(OutData%WaveVel,2)
          DO i1 = LBOUND(OutData%WaveVel,1), UBOUND(OutData%WaveVel,1)
            OutData%WaveVel(i1,i2,i3) = REAL(ReKiBuf(Re_Xferred), SiKi)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveAcc not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveAcc)) DEALLOCATE(OutData%WaveAcc)
    ALLOCATE(OutData%WaveAcc(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveAcc.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveAcc,3), UBOUND(OutData%WaveAcc,3)
        DO i2 = LBOUND(OutData%WaveAcc,2), UBOUND(OutData%WaveAcc,2)
          DO i1 = LBOUND(OutData%WaveAcc,1), UBOUND(OutData%WaveAcc,1)
            OutData%WaveAcc(i1,i2,i3) = REAL(ReKiBuf(Re_Xferred), SiKi)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveDynP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveDynP)) DEALLOCATE(OutData%WaveDynP)
    ALLOCATE(OutData%WaveDynP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveDynP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%WaveDynP,2), UBOUND(OutData%WaveDynP,2)
        DO i1 = LBOUND(OutData%WaveDynP,1), UBOUND(OutData%WaveDynP,1)
          OutData%WaveDynP(i1,i2) = REAL(ReKiBuf(Re_Xferred), SiKi)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveTime not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveTime)) DEALLOCATE(OutData%WaveTime)
    ALLOCATE(OutData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveTime.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WaveTime,1), UBOUND(OutData%WaveTime,1)
        OutData%WaveTime(i1) = REAL(ReKiBuf(Re_Xferred), SiKi)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! nodeInWater not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%nodeInWater)) DEALLOCATE(OutData%nodeInWater)
    ALLOCATE(OutData%nodeInWater(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%nodeInWater.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%nodeInWater,2), UBOUND(OutData%nodeInWater,2)
        DO i1 = LBOUND(OutData%nodeInWater,1), UBOUND(OutData%nodeInWater,1)
          OutData%nodeInWater(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    OutData%NStepWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NMOutputs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MOutLst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MOutLst)) DEALLOCATE(OutData%MOutLst)
    ALLOCATE(OutData%MOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MOutLst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%MOutLst,1), UBOUND(OutData%MOutLst,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackmoutput( Re_Buf, Db_Buf, Int_Buf, OutData%MOutLst(i1), ErrStat2, ErrMsg2 ) ! MOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NJOutputs = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! JOutLst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%JOutLst)) DEALLOCATE(OutData%JOutLst)
    ALLOCATE(OutData%JOutLst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%JOutLst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%JOutLst,1), UBOUND(OutData%JOutLst,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL Morison_Unpackjoutput( Re_Buf, Db_Buf, Int_Buf, OutData%JOutLst(i1), ErrStat2, ErrMsg2 ) ! JOutLst 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutParam not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutParam)) DEALLOCATE(OutData%OutParam)
    ALLOCATE(OutData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%OutParam,1), UBOUND(OutData%OutParam,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackoutparmtype( Re_Buf, Db_Buf, Int_Buf, OutData%OutParam(i1), ErrStat2, ErrMsg2 ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumOutAll = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%OutSwtch = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UnOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFmt)
      OutData%OutFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%OutSFmt)
      OutData%OutSFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Delim)
      OutData%Delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE Morison_UnPackParam

 SUBROUTINE Morison_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(Morison_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL MeshCopy( SrcInputData%Mesh, DstInputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE Morison_CopyInput

 SUBROUTINE Morison_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(Morison_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MeshDestroy( InputData%Mesh, ErrStat, ErrMsg )
 END SUBROUTINE Morison_DestroyInput

 SUBROUTINE Morison_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Mesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Mesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Mesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Mesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL MeshPack( InData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE Morison_PackInput

 SUBROUTINE Morison_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE Morison_UnPackInput

 SUBROUTINE Morison_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Morison_OutputType), INTENT(INOUT) :: SrcOutputData
   TYPE(Morison_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL MeshCopy( SrcOutputData%Mesh, DstOutputData%Mesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
 END SUBROUTINE Morison_CopyOutput

 SUBROUTINE Morison_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(Morison_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'Morison_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MeshDestroy( OutputData%Mesh, ErrStat, ErrMsg )
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
 END SUBROUTINE Morison_DestroyOutput

 SUBROUTINE Morison_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Morison_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Mesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Mesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Mesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Mesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL MeshPack( InData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE Morison_PackOutput

 SUBROUTINE Morison_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Morison_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'Morison_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%Mesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! Mesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE Morison_UnPackOutput


 SUBROUTINE Morison_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(Morison_InputType), INTENT(INOUT)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(Morison_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'Morison_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL Morison_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL Morison_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL Morison_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE Morison_Input_ExtrapInterp


 SUBROUTINE Morison_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(Morison_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
 TYPE(Morison_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(Morison_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'Morison_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
      CALL MeshExtrapInterp1(u1%Mesh, u2%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE Morison_Input_ExtrapInterp1


 SUBROUTINE Morison_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(Morison_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
 TYPE(Morison_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
 TYPE(Morison_InputType), INTENT(INOUT)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(Morison_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'Morison_Input_ExtrapInterp2'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
      CALL MeshExtrapInterp2(u1%Mesh, u2%Mesh, u3%Mesh, tin, u_out%Mesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE Morison_Input_ExtrapInterp2


 SUBROUTINE Morison_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(Morison_OutputType), INTENT(INOUT)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'Morison_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL Morison_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL Morison_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL Morison_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE Morison_Output_ExtrapInterp


 SUBROUTINE Morison_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(Morison_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'Morison_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
      CALL MeshExtrapInterp1(y1%Mesh, y2%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE Morison_Output_ExtrapInterp1


 SUBROUTINE Morison_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(Morison_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(Morison_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'Morison_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
      CALL MeshExtrapInterp2(y1%Mesh, y2%Mesh, y3%Mesh, tin, y_out%Mesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE Morison_Output_ExtrapInterp2

END MODULE Morison_Types
!ENDOFREGISTRYGENERATEDFILE
