!**********************************************************************************************************************************
! LICENSING
! Copyright (C) 2013-2015  National Renewable Energy Laboratory
!
!    This file is part of HydroDyn.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!    
!**********************************************************************************************************************************
MODULE HydroDyn_Output

      ! This MODULE stores variables used for output.

   USE                              NWTC_Library
   USE                              HydroDyn_Types
   !USE                              HydroDyn_Output_Types
   USE                              Waves
   IMPLICIT                         NONE
   
   PRIVATE

! ===================================================================================================
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary.
! ===================================================================================================
! This code was generated by Write_ChckOutLst.m at 05-Jan-2021 06:02:16.


     ! Parameters related to output length (number of characters allowed in the output data headers):

   INTEGER(IntKi), PARAMETER      :: OutStrLenM1 = ChanLen - 1


     ! Indices for computing output channels:
     ! NOTES:
     !    (1) These parameters are in the order stored in "OutListParameters.xlsx"
     !    (2) Array AllOuts() must be dimensioned to the value of the largest output parameter

     !  Time:

   INTEGER(IntKi), PARAMETER      :: Time      =   0


     ! Integrated Hydrodynamic Loads at (0,0,0):

   INTEGER(IntKi), PARAMETER      :: HydroFxi  =   1
   INTEGER(IntKi), PARAMETER      :: HydroFyi  =   2
   INTEGER(IntKi), PARAMETER      :: HydroFzi  =   3
   INTEGER(IntKi), PARAMETER      :: HydroMxi  =   4
   INTEGER(IntKi), PARAMETER      :: HydroMyi  =   5
   INTEGER(IntKi), PARAMETER      :: HydroMzi  =   6


     ! PRP Body Kinematics:

   INTEGER(IntKi), PARAMETER      :: PRPSurge  =   7
   INTEGER(IntKi), PARAMETER      :: PRPSway   =   8
   INTEGER(IntKi), PARAMETER      :: PRPHeave  =   9
   INTEGER(IntKi), PARAMETER      :: PRPRoll   =  10
   INTEGER(IntKi), PARAMETER      :: PRPPitch  =  11
   INTEGER(IntKi), PARAMETER      :: PRPYaw    =  12
   INTEGER(IntKi), PARAMETER      :: PRPTVxi   =  13
   INTEGER(IntKi), PARAMETER      :: PRPTVyi   =  14
   INTEGER(IntKi), PARAMETER      :: PRPTVzi   =  15
   INTEGER(IntKi), PARAMETER      :: PRPRVxi   =  16
   INTEGER(IntKi), PARAMETER      :: PRPRVyi   =  17
   INTEGER(IntKi), PARAMETER      :: PRPRVzi   =  18
   INTEGER(IntKi), PARAMETER      :: PRPTAxi   =  19
   INTEGER(IntKi), PARAMETER      :: PRPTAyi   =  20
   INTEGER(IntKi), PARAMETER      :: PRPTAzi   =  21
   INTEGER(IntKi), PARAMETER      :: PRPRAxi   =  22
   INTEGER(IntKi), PARAMETER      :: PRPRAyi   =  23
   INTEGER(IntKi), PARAMETER      :: PRPRAzi   =  24


     ! WAMIT Body Kinematics:

   INTEGER(IntKi), PARAMETER      :: B1Surge   =  25
   INTEGER(IntKi), PARAMETER      :: B1Sway    =  26
   INTEGER(IntKi), PARAMETER      :: B1Heave   =  27
   INTEGER(IntKi), PARAMETER      :: B1Roll    =  28
   INTEGER(IntKi), PARAMETER      :: B1Pitch   =  29
   INTEGER(IntKi), PARAMETER      :: B1Yaw     =  30
   INTEGER(IntKi), PARAMETER      :: B1TVxi    =  31
   INTEGER(IntKi), PARAMETER      :: B1TVyi    =  32
   INTEGER(IntKi), PARAMETER      :: B1TVzi    =  33
   INTEGER(IntKi), PARAMETER      :: B1RVxi    =  34
   INTEGER(IntKi), PARAMETER      :: B1RVyi    =  35
   INTEGER(IntKi), PARAMETER      :: B1RVzi    =  36
   INTEGER(IntKi), PARAMETER      :: B1TAxi    =  37
   INTEGER(IntKi), PARAMETER      :: B1TAyi    =  38
   INTEGER(IntKi), PARAMETER      :: B1TAzi    =  39
   INTEGER(IntKi), PARAMETER      :: B1RAxi    =  40
   INTEGER(IntKi), PARAMETER      :: B1RAyi    =  41
   INTEGER(IntKi), PARAMETER      :: B1RAzi    =  42
   INTEGER(IntKi), PARAMETER      :: B2Surge   =  43
   INTEGER(IntKi), PARAMETER      :: B2Sway    =  44
   INTEGER(IntKi), PARAMETER      :: B2Heave   =  45
   INTEGER(IntKi), PARAMETER      :: B2Roll    =  46
   INTEGER(IntKi), PARAMETER      :: B2Pitch   =  47
   INTEGER(IntKi), PARAMETER      :: B2Yaw     =  48
   INTEGER(IntKi), PARAMETER      :: B2TVxi    =  49
   INTEGER(IntKi), PARAMETER      :: B2TVyi    =  50
   INTEGER(IntKi), PARAMETER      :: B2TVzi    =  51
   INTEGER(IntKi), PARAMETER      :: B2RVxi    =  52
   INTEGER(IntKi), PARAMETER      :: B2RVyi    =  53
   INTEGER(IntKi), PARAMETER      :: B2RVzi    =  54
   INTEGER(IntKi), PARAMETER      :: B2TAxi    =  55
   INTEGER(IntKi), PARAMETER      :: B2TAyi    =  56
   INTEGER(IntKi), PARAMETER      :: B2TAzi    =  57
   INTEGER(IntKi), PARAMETER      :: B2RAxi    =  58
   INTEGER(IntKi), PARAMETER      :: B2RAyi    =  59
   INTEGER(IntKi), PARAMETER      :: B2RAzi    =  60
   INTEGER(IntKi), PARAMETER      :: B3Surge   =  61
   INTEGER(IntKi), PARAMETER      :: B3Sway    =  62
   INTEGER(IntKi), PARAMETER      :: B3Heave   =  63
   INTEGER(IntKi), PARAMETER      :: B3Roll    =  64
   INTEGER(IntKi), PARAMETER      :: B3Pitch   =  65
   INTEGER(IntKi), PARAMETER      :: B3Yaw     =  66
   INTEGER(IntKi), PARAMETER      :: B3TVxi    =  67
   INTEGER(IntKi), PARAMETER      :: B3TVyi    =  68
   INTEGER(IntKi), PARAMETER      :: B3TVzi    =  69
   INTEGER(IntKi), PARAMETER      :: B3RVxi    =  70
   INTEGER(IntKi), PARAMETER      :: B3RVyi    =  71
   INTEGER(IntKi), PARAMETER      :: B3RVzi    =  72
   INTEGER(IntKi), PARAMETER      :: B3TAxi    =  73
   INTEGER(IntKi), PARAMETER      :: B3TAyi    =  74
   INTEGER(IntKi), PARAMETER      :: B3TAzi    =  75
   INTEGER(IntKi), PARAMETER      :: B3RAxi    =  76
   INTEGER(IntKi), PARAMETER      :: B3RAyi    =  77
   INTEGER(IntKi), PARAMETER      :: B3RAzi    =  78
   INTEGER(IntKi), PARAMETER      :: B4Surge   =  79
   INTEGER(IntKi), PARAMETER      :: B4Sway    =  80
   INTEGER(IntKi), PARAMETER      :: B4Heave   =  81
   INTEGER(IntKi), PARAMETER      :: B4Roll    =  82
   INTEGER(IntKi), PARAMETER      :: B4Pitch   =  83
   INTEGER(IntKi), PARAMETER      :: B4Yaw     =  84
   INTEGER(IntKi), PARAMETER      :: B4TVxi    =  85
   INTEGER(IntKi), PARAMETER      :: B4TVyi    =  86
   INTEGER(IntKi), PARAMETER      :: B4TVzi    =  87
   INTEGER(IntKi), PARAMETER      :: B4RVxi    =  88
   INTEGER(IntKi), PARAMETER      :: B4RVyi    =  89
   INTEGER(IntKi), PARAMETER      :: B4RVzi    =  90
   INTEGER(IntKi), PARAMETER      :: B4TAxi    =  91
   INTEGER(IntKi), PARAMETER      :: B4TAyi    =  92
   INTEGER(IntKi), PARAMETER      :: B4TAzi    =  93
   INTEGER(IntKi), PARAMETER      :: B4RAxi    =  94
   INTEGER(IntKi), PARAMETER      :: B4RAyi    =  95
   INTEGER(IntKi), PARAMETER      :: B4RAzi    =  96
   INTEGER(IntKi), PARAMETER      :: B5Surge   =  97
   INTEGER(IntKi), PARAMETER      :: B5Sway    =  98
   INTEGER(IntKi), PARAMETER      :: B5Heave   =  99
   INTEGER(IntKi), PARAMETER      :: B5Roll    = 100
   INTEGER(IntKi), PARAMETER      :: B5Pitch   = 101
   INTEGER(IntKi), PARAMETER      :: B5Yaw     = 102
   INTEGER(IntKi), PARAMETER      :: B5TVxi    = 103
   INTEGER(IntKi), PARAMETER      :: B5TVyi    = 104
   INTEGER(IntKi), PARAMETER      :: B5TVzi    = 105
   INTEGER(IntKi), PARAMETER      :: B5RVxi    = 106
   INTEGER(IntKi), PARAMETER      :: B5RVyi    = 107
   INTEGER(IntKi), PARAMETER      :: B5RVzi    = 108
   INTEGER(IntKi), PARAMETER      :: B5TAxi    = 109
   INTEGER(IntKi), PARAMETER      :: B5TAyi    = 110
   INTEGER(IntKi), PARAMETER      :: B5TAzi    = 111
   INTEGER(IntKi), PARAMETER      :: B5RAxi    = 112
   INTEGER(IntKi), PARAMETER      :: B5RAyi    = 113
   INTEGER(IntKi), PARAMETER      :: B5RAzi    = 114
   INTEGER(IntKi), PARAMETER      :: B6Surge   = 115
   INTEGER(IntKi), PARAMETER      :: B6Sway    = 116
   INTEGER(IntKi), PARAMETER      :: B6Heave   = 117
   INTEGER(IntKi), PARAMETER      :: B6Roll    = 118
   INTEGER(IntKi), PARAMETER      :: B6Pitch   = 119
   INTEGER(IntKi), PARAMETER      :: B6Yaw     = 120
   INTEGER(IntKi), PARAMETER      :: B6TVxi    = 121
   INTEGER(IntKi), PARAMETER      :: B6TVyi    = 122
   INTEGER(IntKi), PARAMETER      :: B6TVzi    = 123
   INTEGER(IntKi), PARAMETER      :: B6RVxi    = 124
   INTEGER(IntKi), PARAMETER      :: B6RVyi    = 125
   INTEGER(IntKi), PARAMETER      :: B6RVzi    = 126
   INTEGER(IntKi), PARAMETER      :: B6TAxi    = 127
   INTEGER(IntKi), PARAMETER      :: B6TAyi    = 128
   INTEGER(IntKi), PARAMETER      :: B6TAzi    = 129
   INTEGER(IntKi), PARAMETER      :: B6RAxi    = 130
   INTEGER(IntKi), PARAMETER      :: B6RAyi    = 131
   INTEGER(IntKi), PARAMETER      :: B6RAzi    = 132
   INTEGER(IntKi), PARAMETER      :: B7Surge   = 133
   INTEGER(IntKi), PARAMETER      :: B7Sway    = 134
   INTEGER(IntKi), PARAMETER      :: B7Heave   = 135
   INTEGER(IntKi), PARAMETER      :: B7Roll    = 136
   INTEGER(IntKi), PARAMETER      :: B7Pitch   = 137
   INTEGER(IntKi), PARAMETER      :: B7Yaw     = 138
   INTEGER(IntKi), PARAMETER      :: B7TVxi    = 139
   INTEGER(IntKi), PARAMETER      :: B7TVyi    = 140
   INTEGER(IntKi), PARAMETER      :: B7TVzi    = 141
   INTEGER(IntKi), PARAMETER      :: B7RVxi    = 142
   INTEGER(IntKi), PARAMETER      :: B7RVyi    = 143
   INTEGER(IntKi), PARAMETER      :: B7RVzi    = 144
   INTEGER(IntKi), PARAMETER      :: B7TAxi    = 145
   INTEGER(IntKi), PARAMETER      :: B7TAyi    = 146
   INTEGER(IntKi), PARAMETER      :: B7TAzi    = 147
   INTEGER(IntKi), PARAMETER      :: B7RAxi    = 148
   INTEGER(IntKi), PARAMETER      :: B7RAyi    = 149
   INTEGER(IntKi), PARAMETER      :: B7RAzi    = 150
   INTEGER(IntKi), PARAMETER      :: B8Surge   = 151
   INTEGER(IntKi), PARAMETER      :: B8Sway    = 152
   INTEGER(IntKi), PARAMETER      :: B8Heave   = 153
   INTEGER(IntKi), PARAMETER      :: B8Roll    = 154
   INTEGER(IntKi), PARAMETER      :: B8Pitch   = 155
   INTEGER(IntKi), PARAMETER      :: B8Yaw     = 156
   INTEGER(IntKi), PARAMETER      :: B8TVxi    = 157
   INTEGER(IntKi), PARAMETER      :: B8TVyi    = 158
   INTEGER(IntKi), PARAMETER      :: B8TVzi    = 159
   INTEGER(IntKi), PARAMETER      :: B8RVxi    = 160
   INTEGER(IntKi), PARAMETER      :: B8RVyi    = 161
   INTEGER(IntKi), PARAMETER      :: B8RVzi    = 162
   INTEGER(IntKi), PARAMETER      :: B8TAxi    = 163
   INTEGER(IntKi), PARAMETER      :: B8TAyi    = 164
   INTEGER(IntKi), PARAMETER      :: B8TAzi    = 165
   INTEGER(IntKi), PARAMETER      :: B8RAxi    = 166
   INTEGER(IntKi), PARAMETER      :: B8RAyi    = 167
   INTEGER(IntKi), PARAMETER      :: B8RAzi    = 168
   INTEGER(IntKi), PARAMETER      :: B9Surge   = 169
   INTEGER(IntKi), PARAMETER      :: B9Sway    = 170
   INTEGER(IntKi), PARAMETER      :: B9Heave   = 171
   INTEGER(IntKi), PARAMETER      :: B9Roll    = 172
   INTEGER(IntKi), PARAMETER      :: B9Pitch   = 173
   INTEGER(IntKi), PARAMETER      :: B9Yaw     = 174
   INTEGER(IntKi), PARAMETER      :: B9TVxi    = 175
   INTEGER(IntKi), PARAMETER      :: B9TVyi    = 176
   INTEGER(IntKi), PARAMETER      :: B9TVzi    = 177
   INTEGER(IntKi), PARAMETER      :: B9RVxi    = 178
   INTEGER(IntKi), PARAMETER      :: B9RVyi    = 179
   INTEGER(IntKi), PARAMETER      :: B9RVzi    = 180
   INTEGER(IntKi), PARAMETER      :: B9TAxi    = 181
   INTEGER(IntKi), PARAMETER      :: B9TAyi    = 182
   INTEGER(IntKi), PARAMETER      :: B9TAzi    = 183
   INTEGER(IntKi), PARAMETER      :: B9RAxi    = 184
   INTEGER(IntKi), PARAMETER      :: B9RAyi    = 185
   INTEGER(IntKi), PARAMETER      :: B9RAzi    = 186


     ! WAMIT Body Forces:

   INTEGER(IntKi), PARAMETER      :: B1AddFxi  = 187
   INTEGER(IntKi), PARAMETER      :: B1AddFyi  = 188
   INTEGER(IntKi), PARAMETER      :: B1AddFzi  = 189
   INTEGER(IntKi), PARAMETER      :: B1AddMxi  = 190
   INTEGER(IntKi), PARAMETER      :: B1AddMyi  = 191
   INTEGER(IntKi), PARAMETER      :: B1AddMzi  = 192
   INTEGER(IntKi), PARAMETER      :: B1WvsF1xi = 193
   INTEGER(IntKi), PARAMETER      :: B1WvsF1yi = 194
   INTEGER(IntKi), PARAMETER      :: B1WvsF1zi = 195
   INTEGER(IntKi), PARAMETER      :: B1WvsM1xi = 196
   INTEGER(IntKi), PARAMETER      :: B1WvsM1yi = 197
   INTEGER(IntKi), PARAMETER      :: B1WvsM1zi = 198
   INTEGER(IntKi), PARAMETER      :: B1WvsFxi  = 199
   INTEGER(IntKi), PARAMETER      :: B1WvsFyi  = 200
   INTEGER(IntKi), PARAMETER      :: B1WvsFzi  = 201
   INTEGER(IntKi), PARAMETER      :: B1WvsMxi  = 202
   INTEGER(IntKi), PARAMETER      :: B1WvsMyi  = 203
   INTEGER(IntKi), PARAMETER      :: B1WvsMzi  = 204
   INTEGER(IntKi), PARAMETER      :: B1HdSFxi  = 205
   INTEGER(IntKi), PARAMETER      :: B1HdSFyi  = 206
   INTEGER(IntKi), PARAMETER      :: B1HdSFzi  = 207
   INTEGER(IntKi), PARAMETER      :: B1HdSMxi  = 208
   INTEGER(IntKi), PARAMETER      :: B1HdSMyi  = 209
   INTEGER(IntKi), PARAMETER      :: B1HdSMzi  = 210
   INTEGER(IntKi), PARAMETER      :: B1RdtFxi  = 211
   INTEGER(IntKi), PARAMETER      :: B1RdtFyi  = 212
   INTEGER(IntKi), PARAMETER      :: B1RdtFzi  = 213
   INTEGER(IntKi), PARAMETER      :: B1RdtMxi  = 214
   INTEGER(IntKi), PARAMETER      :: B1RdtMyi  = 215
   INTEGER(IntKi), PARAMETER      :: B1RdtMzi  = 216
   INTEGER(IntKi), PARAMETER      :: B2AddFxi  = 217
   INTEGER(IntKi), PARAMETER      :: B2AddFyi  = 218
   INTEGER(IntKi), PARAMETER      :: B2AddFzi  = 219
   INTEGER(IntKi), PARAMETER      :: B2AddMxi  = 220
   INTEGER(IntKi), PARAMETER      :: B2AddMyi  = 221
   INTEGER(IntKi), PARAMETER      :: B2AddMzi  = 222
   INTEGER(IntKi), PARAMETER      :: B2WvsF1xi = 223
   INTEGER(IntKi), PARAMETER      :: B2WvsF1yi = 224
   INTEGER(IntKi), PARAMETER      :: B2WvsF1zi = 225
   INTEGER(IntKi), PARAMETER      :: B2WvsM1xi = 226
   INTEGER(IntKi), PARAMETER      :: B2WvsM1yi = 227
   INTEGER(IntKi), PARAMETER      :: B2WvsM1zi = 228
   INTEGER(IntKi), PARAMETER      :: B2WvsFxi  = 229
   INTEGER(IntKi), PARAMETER      :: B2WvsFyi  = 230
   INTEGER(IntKi), PARAMETER      :: B2WvsFzi  = 231
   INTEGER(IntKi), PARAMETER      :: B2WvsMxi  = 232
   INTEGER(IntKi), PARAMETER      :: B2WvsMyi  = 233
   INTEGER(IntKi), PARAMETER      :: B2WvsMzi  = 234
   INTEGER(IntKi), PARAMETER      :: B2HdSFxi  = 235
   INTEGER(IntKi), PARAMETER      :: B2HdSFyi  = 236
   INTEGER(IntKi), PARAMETER      :: B2HdSFzi  = 237
   INTEGER(IntKi), PARAMETER      :: B2HdSMxi  = 238
   INTEGER(IntKi), PARAMETER      :: B2HdSMyi  = 239
   INTEGER(IntKi), PARAMETER      :: B2HdSMzi  = 240
   INTEGER(IntKi), PARAMETER      :: B2RdtFxi  = 241
   INTEGER(IntKi), PARAMETER      :: B2RdtFyi  = 242
   INTEGER(IntKi), PARAMETER      :: B2RdtFzi  = 243
   INTEGER(IntKi), PARAMETER      :: B2RdtMxi  = 244
   INTEGER(IntKi), PARAMETER      :: B2RdtMyi  = 245
   INTEGER(IntKi), PARAMETER      :: B2RdtMzi  = 246
   INTEGER(IntKi), PARAMETER      :: B3AddFxi  = 247
   INTEGER(IntKi), PARAMETER      :: B3AddFyi  = 248
   INTEGER(IntKi), PARAMETER      :: B3AddFzi  = 249
   INTEGER(IntKi), PARAMETER      :: B3AddMxi  = 250
   INTEGER(IntKi), PARAMETER      :: B3AddMyi  = 251
   INTEGER(IntKi), PARAMETER      :: B3AddMzi  = 252
   INTEGER(IntKi), PARAMETER      :: B3WvsF1xi = 253
   INTEGER(IntKi), PARAMETER      :: B3WvsF1yi = 254
   INTEGER(IntKi), PARAMETER      :: B3WvsF1zi = 255
   INTEGER(IntKi), PARAMETER      :: B3WvsM1xi = 256
   INTEGER(IntKi), PARAMETER      :: B3WvsM1yi = 257
   INTEGER(IntKi), PARAMETER      :: B3WvsM1zi = 258
   INTEGER(IntKi), PARAMETER      :: B3WvsFxi  = 259
   INTEGER(IntKi), PARAMETER      :: B3WvsFyi  = 260
   INTEGER(IntKi), PARAMETER      :: B3WvsFzi  = 261
   INTEGER(IntKi), PARAMETER      :: B3WvsMxi  = 262
   INTEGER(IntKi), PARAMETER      :: B3WvsMyi  = 263
   INTEGER(IntKi), PARAMETER      :: B3WvsMzi  = 264
   INTEGER(IntKi), PARAMETER      :: B3HdSFxi  = 265
   INTEGER(IntKi), PARAMETER      :: B3HdSFyi  = 266
   INTEGER(IntKi), PARAMETER      :: B3HdSFzi  = 267
   INTEGER(IntKi), PARAMETER      :: B3HdSMxi  = 268
   INTEGER(IntKi), PARAMETER      :: B3HdSMyi  = 269
   INTEGER(IntKi), PARAMETER      :: B3HdSMzi  = 270
   INTEGER(IntKi), PARAMETER      :: B3RdtFxi  = 271
   INTEGER(IntKi), PARAMETER      :: B3RdtFyi  = 272
   INTEGER(IntKi), PARAMETER      :: B3RdtFzi  = 273
   INTEGER(IntKi), PARAMETER      :: B3RdtMxi  = 274
   INTEGER(IntKi), PARAMETER      :: B3RdtMyi  = 275
   INTEGER(IntKi), PARAMETER      :: B3RdtMzi  = 276
   INTEGER(IntKi), PARAMETER      :: B4AddFxi  = 277
   INTEGER(IntKi), PARAMETER      :: B4AddFyi  = 278
   INTEGER(IntKi), PARAMETER      :: B4AddFzi  = 279
   INTEGER(IntKi), PARAMETER      :: B4AddMxi  = 280
   INTEGER(IntKi), PARAMETER      :: B4AddMyi  = 281
   INTEGER(IntKi), PARAMETER      :: B4AddMzi  = 282
   INTEGER(IntKi), PARAMETER      :: B4WvsF1xi = 283
   INTEGER(IntKi), PARAMETER      :: B4WvsF1yi = 284
   INTEGER(IntKi), PARAMETER      :: B4WvsF1zi = 285
   INTEGER(IntKi), PARAMETER      :: B4WvsM1xi = 286
   INTEGER(IntKi), PARAMETER      :: B4WvsM1yi = 287
   INTEGER(IntKi), PARAMETER      :: B4WvsM1zi = 288
   INTEGER(IntKi), PARAMETER      :: B4WvsFxi  = 289
   INTEGER(IntKi), PARAMETER      :: B4WvsFyi  = 290
   INTEGER(IntKi), PARAMETER      :: B4WvsFzi  = 291
   INTEGER(IntKi), PARAMETER      :: B4WvsMxi  = 292
   INTEGER(IntKi), PARAMETER      :: B4WvsMyi  = 293
   INTEGER(IntKi), PARAMETER      :: B4WvsMzi  = 294
   INTEGER(IntKi), PARAMETER      :: B4HdSFxi  = 295
   INTEGER(IntKi), PARAMETER      :: B4HdSFyi  = 296
   INTEGER(IntKi), PARAMETER      :: B4HdSFzi  = 297
   INTEGER(IntKi), PARAMETER      :: B4HdSMxi  = 298
   INTEGER(IntKi), PARAMETER      :: B4HdSMyi  = 299
   INTEGER(IntKi), PARAMETER      :: B4HdSMzi  = 300
   INTEGER(IntKi), PARAMETER      :: B4RdtFxi  = 301
   INTEGER(IntKi), PARAMETER      :: B4RdtFyi  = 302
   INTEGER(IntKi), PARAMETER      :: B4RdtFzi  = 303
   INTEGER(IntKi), PARAMETER      :: B4RdtMxi  = 304
   INTEGER(IntKi), PARAMETER      :: B4RdtMyi  = 305
   INTEGER(IntKi), PARAMETER      :: B4RdtMzi  = 306
   INTEGER(IntKi), PARAMETER      :: B5AddFxi  = 307
   INTEGER(IntKi), PARAMETER      :: B5AddFyi  = 308
   INTEGER(IntKi), PARAMETER      :: B5AddFzi  = 309
   INTEGER(IntKi), PARAMETER      :: B5AddMxi  = 310
   INTEGER(IntKi), PARAMETER      :: B5AddMyi  = 311
   INTEGER(IntKi), PARAMETER      :: B5AddMzi  = 312
   INTEGER(IntKi), PARAMETER      :: B5WvsF1xi = 313
   INTEGER(IntKi), PARAMETER      :: B5WvsF1yi = 314
   INTEGER(IntKi), PARAMETER      :: B5WvsF1zi = 315
   INTEGER(IntKi), PARAMETER      :: B5WvsM1xi = 316
   INTEGER(IntKi), PARAMETER      :: B5WvsM1yi = 317
   INTEGER(IntKi), PARAMETER      :: B5WvsM1zi = 318
   INTEGER(IntKi), PARAMETER      :: B5WvsFxi  = 319
   INTEGER(IntKi), PARAMETER      :: B5WvsFyi  = 320
   INTEGER(IntKi), PARAMETER      :: B5WvsFzi  = 321
   INTEGER(IntKi), PARAMETER      :: B5WvsMxi  = 322
   INTEGER(IntKi), PARAMETER      :: B5WvsMyi  = 323
   INTEGER(IntKi), PARAMETER      :: B5WvsMzi  = 324
   INTEGER(IntKi), PARAMETER      :: B5HdSFxi  = 325
   INTEGER(IntKi), PARAMETER      :: B5HdSFyi  = 326
   INTEGER(IntKi), PARAMETER      :: B5HdSFzi  = 327
   INTEGER(IntKi), PARAMETER      :: B5HdSMxi  = 328
   INTEGER(IntKi), PARAMETER      :: B5HdSMyi  = 329
   INTEGER(IntKi), PARAMETER      :: B5HdSMzi  = 330
   INTEGER(IntKi), PARAMETER      :: B5RdtFxi  = 331
   INTEGER(IntKi), PARAMETER      :: B5RdtFyi  = 332
   INTEGER(IntKi), PARAMETER      :: B5RdtFzi  = 333
   INTEGER(IntKi), PARAMETER      :: B5RdtMxi  = 334
   INTEGER(IntKi), PARAMETER      :: B5RdtMyi  = 335
   INTEGER(IntKi), PARAMETER      :: B5RdtMzi  = 336
   INTEGER(IntKi), PARAMETER      :: B6AddFxi  = 337
   INTEGER(IntKi), PARAMETER      :: B6AddFyi  = 338
   INTEGER(IntKi), PARAMETER      :: B6AddFzi  = 339
   INTEGER(IntKi), PARAMETER      :: B6AddMxi  = 340
   INTEGER(IntKi), PARAMETER      :: B6AddMyi  = 341
   INTEGER(IntKi), PARAMETER      :: B6AddMzi  = 342
   INTEGER(IntKi), PARAMETER      :: B6WvsF1xi = 343
   INTEGER(IntKi), PARAMETER      :: B6WvsF1yi = 344
   INTEGER(IntKi), PARAMETER      :: B6WvsF1zi = 345
   INTEGER(IntKi), PARAMETER      :: B6WvsM1xi = 346
   INTEGER(IntKi), PARAMETER      :: B6WvsM1yi = 347
   INTEGER(IntKi), PARAMETER      :: B6WvsM1zi = 348
   INTEGER(IntKi), PARAMETER      :: B6WvsFxi  = 349
   INTEGER(IntKi), PARAMETER      :: B6WvsFyi  = 350
   INTEGER(IntKi), PARAMETER      :: B6WvsFzi  = 351
   INTEGER(IntKi), PARAMETER      :: B6WvsMxi  = 352
   INTEGER(IntKi), PARAMETER      :: B6WvsMyi  = 353
   INTEGER(IntKi), PARAMETER      :: B6WvsMzi  = 354
   INTEGER(IntKi), PARAMETER      :: B6HdSFxi  = 355
   INTEGER(IntKi), PARAMETER      :: B6HdSFyi  = 356
   INTEGER(IntKi), PARAMETER      :: B6HdSFzi  = 357
   INTEGER(IntKi), PARAMETER      :: B6HdSMxi  = 358
   INTEGER(IntKi), PARAMETER      :: B6HdSMyi  = 359
   INTEGER(IntKi), PARAMETER      :: B6HdSMzi  = 360
   INTEGER(IntKi), PARAMETER      :: B6RdtFxi  = 361
   INTEGER(IntKi), PARAMETER      :: B6RdtFyi  = 362
   INTEGER(IntKi), PARAMETER      :: B6RdtFzi  = 363
   INTEGER(IntKi), PARAMETER      :: B6RdtMxi  = 364
   INTEGER(IntKi), PARAMETER      :: B6RdtMyi  = 365
   INTEGER(IntKi), PARAMETER      :: B6RdtMzi  = 366
   INTEGER(IntKi), PARAMETER      :: B7AddFxi  = 367
   INTEGER(IntKi), PARAMETER      :: B7AddFyi  = 368
   INTEGER(IntKi), PARAMETER      :: B7AddFzi  = 369
   INTEGER(IntKi), PARAMETER      :: B7AddMxi  = 370
   INTEGER(IntKi), PARAMETER      :: B7AddMyi  = 371
   INTEGER(IntKi), PARAMETER      :: B7AddMzi  = 372
   INTEGER(IntKi), PARAMETER      :: B7WvsF1xi = 373
   INTEGER(IntKi), PARAMETER      :: B7WvsF1yi = 374
   INTEGER(IntKi), PARAMETER      :: B7WvsF1zi = 375
   INTEGER(IntKi), PARAMETER      :: B7WvsM1xi = 376
   INTEGER(IntKi), PARAMETER      :: B7WvsM1yi = 377
   INTEGER(IntKi), PARAMETER      :: B7WvsM1zi = 378
   INTEGER(IntKi), PARAMETER      :: B7WvsFxi  = 379
   INTEGER(IntKi), PARAMETER      :: B7WvsFyi  = 380
   INTEGER(IntKi), PARAMETER      :: B7WvsFzi  = 381
   INTEGER(IntKi), PARAMETER      :: B7WvsMxi  = 382
   INTEGER(IntKi), PARAMETER      :: B7WvsMyi  = 383
   INTEGER(IntKi), PARAMETER      :: B7WvsMzi  = 384
   INTEGER(IntKi), PARAMETER      :: B7HdSFxi  = 385
   INTEGER(IntKi), PARAMETER      :: B7HdSFyi  = 386
   INTEGER(IntKi), PARAMETER      :: B7HdSFzi  = 387
   INTEGER(IntKi), PARAMETER      :: B7HdSMxi  = 388
   INTEGER(IntKi), PARAMETER      :: B7HdSMyi  = 389
   INTEGER(IntKi), PARAMETER      :: B7HdSMzi  = 390
   INTEGER(IntKi), PARAMETER      :: B7RdtFxi  = 391
   INTEGER(IntKi), PARAMETER      :: B7RdtFyi  = 392
   INTEGER(IntKi), PARAMETER      :: B7RdtFzi  = 393
   INTEGER(IntKi), PARAMETER      :: B7RdtMxi  = 394
   INTEGER(IntKi), PARAMETER      :: B7RdtMyi  = 395
   INTEGER(IntKi), PARAMETER      :: B7RdtMzi  = 396
   INTEGER(IntKi), PARAMETER      :: B8AddFxi  = 397
   INTEGER(IntKi), PARAMETER      :: B8AddFyi  = 398
   INTEGER(IntKi), PARAMETER      :: B8AddFzi  = 399
   INTEGER(IntKi), PARAMETER      :: B8AddMxi  = 400
   INTEGER(IntKi), PARAMETER      :: B8AddMyi  = 401
   INTEGER(IntKi), PARAMETER      :: B8AddMzi  = 402
   INTEGER(IntKi), PARAMETER      :: B8WvsF1xi = 403
   INTEGER(IntKi), PARAMETER      :: B8WvsF1yi = 404
   INTEGER(IntKi), PARAMETER      :: B8WvsF1zi = 405
   INTEGER(IntKi), PARAMETER      :: B8WvsM1xi = 406
   INTEGER(IntKi), PARAMETER      :: B8WvsM1yi = 407
   INTEGER(IntKi), PARAMETER      :: B8WvsM1zi = 408
   INTEGER(IntKi), PARAMETER      :: B8WvsFxi  = 409
   INTEGER(IntKi), PARAMETER      :: B8WvsFyi  = 410
   INTEGER(IntKi), PARAMETER      :: B8WvsFzi  = 411
   INTEGER(IntKi), PARAMETER      :: B8WvsMxi  = 412
   INTEGER(IntKi), PARAMETER      :: B8WvsMyi  = 413
   INTEGER(IntKi), PARAMETER      :: B8WvsMzi  = 414
   INTEGER(IntKi), PARAMETER      :: B8HdSFxi  = 415
   INTEGER(IntKi), PARAMETER      :: B8HdSFyi  = 416
   INTEGER(IntKi), PARAMETER      :: B8HdSFzi  = 417
   INTEGER(IntKi), PARAMETER      :: B8HdSMxi  = 418
   INTEGER(IntKi), PARAMETER      :: B8HdSMyi  = 419
   INTEGER(IntKi), PARAMETER      :: B8HdSMzi  = 420
   INTEGER(IntKi), PARAMETER      :: B8RdtFxi  = 421
   INTEGER(IntKi), PARAMETER      :: B8RdtFyi  = 422
   INTEGER(IntKi), PARAMETER      :: B8RdtFzi  = 423
   INTEGER(IntKi), PARAMETER      :: B8RdtMxi  = 424
   INTEGER(IntKi), PARAMETER      :: B8RdtMyi  = 425
   INTEGER(IntKi), PARAMETER      :: B8RdtMzi  = 426
   INTEGER(IntKi), PARAMETER      :: B9AddFxi  = 427
   INTEGER(IntKi), PARAMETER      :: B9AddFyi  = 428
   INTEGER(IntKi), PARAMETER      :: B9AddFzi  = 429
   INTEGER(IntKi), PARAMETER      :: B9AddMxi  = 430
   INTEGER(IntKi), PARAMETER      :: B9AddMyi  = 431
   INTEGER(IntKi), PARAMETER      :: B9AddMzi  = 432
   INTEGER(IntKi), PARAMETER      :: B9WvsF1xi = 433
   INTEGER(IntKi), PARAMETER      :: B9WvsF1yi = 434
   INTEGER(IntKi), PARAMETER      :: B9WvsF1zi = 435
   INTEGER(IntKi), PARAMETER      :: B9WvsM1xi = 436
   INTEGER(IntKi), PARAMETER      :: B9WvsM1yi = 437
   INTEGER(IntKi), PARAMETER      :: B9WvsM1zi = 438
   INTEGER(IntKi), PARAMETER      :: B9WvsFxi  = 439
   INTEGER(IntKi), PARAMETER      :: B9WvsFyi  = 440
   INTEGER(IntKi), PARAMETER      :: B9WvsFzi  = 441
   INTEGER(IntKi), PARAMETER      :: B9WvsMxi  = 442
   INTEGER(IntKi), PARAMETER      :: B9WvsMyi  = 443
   INTEGER(IntKi), PARAMETER      :: B9WvsMzi  = 444
   INTEGER(IntKi), PARAMETER      :: B9HdSFxi  = 445
   INTEGER(IntKi), PARAMETER      :: B9HdSFyi  = 446
   INTEGER(IntKi), PARAMETER      :: B9HdSFzi  = 447
   INTEGER(IntKi), PARAMETER      :: B9HdSMxi  = 448
   INTEGER(IntKi), PARAMETER      :: B9HdSMyi  = 449
   INTEGER(IntKi), PARAMETER      :: B9HdSMzi  = 450
   INTEGER(IntKi), PARAMETER      :: B9RdtFxi  = 451
   INTEGER(IntKi), PARAMETER      :: B9RdtFyi  = 452
   INTEGER(IntKi), PARAMETER      :: B9RdtFzi  = 453
   INTEGER(IntKi), PARAMETER      :: B9RdtMxi  = 454
   INTEGER(IntKi), PARAMETER      :: B9RdtMyi  = 455
   INTEGER(IntKi), PARAMETER      :: B9RdtMzi  = 456
   INTEGER(IntKi), PARAMETER      :: B1WvsF2xi = 457
   INTEGER(IntKi), PARAMETER      :: B1WvsF2yi = 458
   INTEGER(IntKi), PARAMETER      :: B1WvsF2zi = 459
   INTEGER(IntKi), PARAMETER      :: B1WvsM2xi = 460
   INTEGER(IntKi), PARAMETER      :: B1WvsM2yi = 461
   INTEGER(IntKi), PARAMETER      :: B1WvsM2zi = 462
   INTEGER(IntKi), PARAMETER      :: B2WvsF2xi = 463
   INTEGER(IntKi), PARAMETER      :: B2WvsF2yi = 464
   INTEGER(IntKi), PARAMETER      :: B2WvsF2zi = 465
   INTEGER(IntKi), PARAMETER      :: B2WvsM2xi = 466
   INTEGER(IntKi), PARAMETER      :: B2WvsM2yi = 467
   INTEGER(IntKi), PARAMETER      :: B2WvsM2zi = 468
   INTEGER(IntKi), PARAMETER      :: B3WvsF2xi = 469
   INTEGER(IntKi), PARAMETER      :: B3WvsF2yi = 470
   INTEGER(IntKi), PARAMETER      :: B3WvsF2zi = 471
   INTEGER(IntKi), PARAMETER      :: B3WvsM2xi = 472
   INTEGER(IntKi), PARAMETER      :: B3WvsM2yi = 473
   INTEGER(IntKi), PARAMETER      :: B3WvsM2zi = 474
   INTEGER(IntKi), PARAMETER      :: B4WvsF2xi = 475
   INTEGER(IntKi), PARAMETER      :: B4WvsF2yi = 476
   INTEGER(IntKi), PARAMETER      :: B4WvsF2zi = 477
   INTEGER(IntKi), PARAMETER      :: B4WvsM2xi = 478
   INTEGER(IntKi), PARAMETER      :: B4WvsM2yi = 479
   INTEGER(IntKi), PARAMETER      :: B4WvsM2zi = 480
   INTEGER(IntKi), PARAMETER      :: B5WvsF2xi = 481
   INTEGER(IntKi), PARAMETER      :: B5WvsF2yi = 482
   INTEGER(IntKi), PARAMETER      :: B5WvsF2zi = 483
   INTEGER(IntKi), PARAMETER      :: B5WvsM2xi = 484
   INTEGER(IntKi), PARAMETER      :: B5WvsM2yi = 485
   INTEGER(IntKi), PARAMETER      :: B5WvsM2zi = 486
   INTEGER(IntKi), PARAMETER      :: B6WvsF2xi = 487
   INTEGER(IntKi), PARAMETER      :: B6WvsF2yi = 488
   INTEGER(IntKi), PARAMETER      :: B6WvsF2zi = 489
   INTEGER(IntKi), PARAMETER      :: B6WvsM2xi = 490
   INTEGER(IntKi), PARAMETER      :: B6WvsM2yi = 491
   INTEGER(IntKi), PARAMETER      :: B6WvsM2zi = 492
   INTEGER(IntKi), PARAMETER      :: B7WvsF2xi = 493
   INTEGER(IntKi), PARAMETER      :: B7WvsF2yi = 494
   INTEGER(IntKi), PARAMETER      :: B7WvsF2zi = 495
   INTEGER(IntKi), PARAMETER      :: B7WvsM2xi = 496
   INTEGER(IntKi), PARAMETER      :: B7WvsM2yi = 497
   INTEGER(IntKi), PARAMETER      :: B7WvsM2zi = 498
   INTEGER(IntKi), PARAMETER      :: B8WvsF2xi = 499
   INTEGER(IntKi), PARAMETER      :: B8WvsF2yi = 500
   INTEGER(IntKi), PARAMETER      :: B8WvsF2zi = 501
   INTEGER(IntKi), PARAMETER      :: B8WvsM2xi = 502
   INTEGER(IntKi), PARAMETER      :: B8WvsM2yi = 503
   INTEGER(IntKi), PARAMETER      :: B8WvsM2zi = 504
   INTEGER(IntKi), PARAMETER      :: B9WvsF2xi = 505
   INTEGER(IntKi), PARAMETER      :: B9WvsF2yi = 506
   INTEGER(IntKi), PARAMETER      :: B9WvsF2zi = 507
   INTEGER(IntKi), PARAMETER      :: B9WvsM2xi = 508
   INTEGER(IntKi), PARAMETER      :: B9WvsM2yi = 509
   INTEGER(IntKi), PARAMETER      :: B9WvsM2zi = 510


     ! Wave Elevations:

   INTEGER(IntKi), PARAMETER      :: Wave1Elev = 511
   INTEGER(IntKi), PARAMETER      :: Wave2Elev = 512
   INTEGER(IntKi), PARAMETER      :: Wave3Elev = 513
   INTEGER(IntKi), PARAMETER      :: Wave4Elev = 514
   INTEGER(IntKi), PARAMETER      :: Wave5Elev = 515
   INTEGER(IntKi), PARAMETER      :: Wave6Elev = 516
   INTEGER(IntKi), PARAMETER      :: Wave7Elev = 517
   INTEGER(IntKi), PARAMETER      :: Wave8Elev = 518
   INTEGER(IntKi), PARAMETER      :: Wave9Elev = 519
   INTEGER(IntKi), PARAMETER      :: Wave1Elv1 = 520
   INTEGER(IntKi), PARAMETER      :: Wave2Elv1 = 521
   INTEGER(IntKi), PARAMETER      :: Wave3Elv1 = 522
   INTEGER(IntKi), PARAMETER      :: Wave4Elv1 = 523
   INTEGER(IntKi), PARAMETER      :: Wave5Elv1 = 524
   INTEGER(IntKi), PARAMETER      :: Wave6Elv1 = 525
   INTEGER(IntKi), PARAMETER      :: Wave7Elv1 = 526
   INTEGER(IntKi), PARAMETER      :: Wave8Elv1 = 527
   INTEGER(IntKi), PARAMETER      :: Wave9Elv1 = 528
   INTEGER(IntKi), PARAMETER      :: Wave1Elv2 = 529
   INTEGER(IntKi), PARAMETER      :: Wave2Elv2 = 530
   INTEGER(IntKi), PARAMETER      :: Wave3Elv2 = 531
   INTEGER(IntKi), PARAMETER      :: Wave4Elv2 = 532
   INTEGER(IntKi), PARAMETER      :: Wave5Elv2 = 533
   INTEGER(IntKi), PARAMETER      :: Wave6Elv2 = 534
   INTEGER(IntKi), PARAMETER      :: Wave7Elv2 = 535
   INTEGER(IntKi), PARAMETER      :: Wave8Elv2 = 536
   INTEGER(IntKi), PARAMETER      :: Wave9Elv2 = 537


     ! The maximum number of output channels which can be output by the code.
   INTEGER(IntKi), PARAMETER      :: MaxOutPts = 537

!End of code generated by Matlab script
! ===================================================================================================   

    REAL(ReKi)               :: AllOuts(MaxHDOutputs)          ! Array of all possible outputs
   

   
   INTEGER, PARAMETER             :: FHydro(6)      = (/HydroFxi,HydroFyi,HydroFzi,HydroMxi,HydroMyi,HydroMzi/)

   INTEGER, PARAMETER             :: FAdd(6,9)     = transpose(reshape((/B1AddFxi,B2AddFxi,B3AddFxi,B4AddFxi,B5AddFxi,B6AddFxi,B7AddFxi,B8AddFxi,B9AddFxi,  &
                                                               B1AddFyi,B2AddFyi,B3AddFyi,B4AddFyi,B5AddFyi,B6AddFyi,B7AddFyi,B8AddFyi,B9AddFyi,  &
                                                               B1AddFzi,B2AddFzi,B3AddFzi,B4AddFzi,B5AddFzi,B6AddFzi,B7AddFzi,B8AddFzi,B9AddFzi,  &
                                                               B1AddMxi,B2AddMxi,B3AddMxi,B4AddMxi,B5AddMxi,B6AddMxi,B7AddMxi,B8AddMxi,B9AddMxi,  &
                                                               B1AddMyi,B2AddMyi,B3AddMyi,B4AddMyi,B5AddMyi,B6AddMyi,B7AddMyi,B8AddMyi,B9AddMyi,  &
                                                               B1AddMzi,B2AddMzi,B3AddMzi,B4AddMzi,B5AddMzi,B6AddMzi,B7AddMzi,B8AddMzi,B9AddMzi/), &
                                                               (/9,6/)))
   INTEGER, PARAMETER             :: FWaves1(6,9)  = transpose(reshape((/B1WvsF1xi,B2WvsF1xi,B3WvsF1xi,B4WvsF1xi,B5WvsF1xi,B6WvsF1xi,B7WvsF1xi,B8WvsF1xi,B9WvsF1xi,  &
                                                               B1WvsF1yi,B2WvsF1yi,B3WvsF1yi,B4WvsF1yi,B5WvsF1yi,B6WvsF1yi,B7WvsF1yi,B8WvsF1yi,B9WvsF1yi,  &
                                                               B1WvsF1zi,B2WvsF1zi,B3WvsF1zi,B4WvsF1zi,B5WvsF1zi,B6WvsF1zi,B7WvsF1zi,B8WvsF1zi,B9WvsF1zi,  &
                                                               B1WvsM1xi,B2WvsM1xi,B3WvsM1xi,B4WvsM1xi,B5WvsM1xi,B6WvsM1xi,B7WvsM1xi,B8WvsM1xi,B9WvsM1xi,  &
                                                               B1WvsM1yi,B2WvsM1yi,B3WvsM1yi,B4WvsM1yi,B5WvsM1yi,B6WvsM1yi,B7WvsM1yi,B8WvsM1yi,B9WvsM1yi,  &
                                                               B1WvsM1zi,B2WvsM1zi,B3WvsM1zi,B4WvsM1zi,B5WvsM1zi,B6WvsM1zi,B7WvsM1zi,B8WvsM1zi,B9WvsM1zi/), &
                                                               (/9,6/)))
   INTEGER, PARAMETER             :: FWaves2(6,9)  = transpose(reshape((/B1WvsF2xi,B2WvsF2xi,B3WvsF2xi,B4WvsF2xi,B5WvsF2xi,B6WvsF2xi,B7WvsF2xi,B8WvsF2xi,B9WvsF2xi,  &
                                                               B1WvsF2yi,B2WvsF2yi,B3WvsF2yi,B4WvsF2yi,B5WvsF2yi,B6WvsF2yi,B7WvsF2yi,B8WvsF2yi,B9WvsF2yi,  &
                                                               B1WvsF2zi,B2WvsF2zi,B3WvsF2zi,B4WvsF2zi,B5WvsF2zi,B6WvsF2zi,B7WvsF2zi,B8WvsF2zi,B9WvsF2zi,  &
                                                               B1WvsM2xi,B2WvsM2xi,B3WvsM2xi,B4WvsM2xi,B5WvsM2xi,B6WvsM2xi,B7WvsM2xi,B8WvsM2xi,B9WvsM2xi,  &
                                                               B1WvsM2yi,B2WvsM2yi,B3WvsM2yi,B4WvsM2yi,B5WvsM2yi,B6WvsM2yi,B7WvsM2yi,B8WvsM2yi,B9WvsM2yi,  &
                                                               B1WvsM2zi,B2WvsM2zi,B3WvsM2zi,B4WvsM2zi,B5WvsM2zi,B6WvsM2zi,B7WvsM2zi,B8WvsM2zi,B9WvsM2zi/), &
                                                               (/9,6/)))
   INTEGER, PARAMETER             :: FWavesTot(6,9)= transpose(reshape((/B1WvsFxi,B2WvsFxi,B3WvsFxi,B4WvsFxi,B5WvsFxi,B6WvsFxi,B7WvsFxi,B8WvsFxi,B9WvsFxi,  &
                                                               B1WvsFyi,B2WvsFyi,B3WvsFyi,B4WvsFyi,B5WvsFyi,B6WvsFyi,B7WvsFyi,B8WvsFyi,B9WvsFyi,  &
                                                               B1WvsFzi,B2WvsFzi,B3WvsFzi,B4WvsFzi,B5WvsFzi,B6WvsFzi,B7WvsFzi,B8WvsFzi,B9WvsFzi,  &
                                                               B1WvsMxi,B2WvsMxi,B3WvsMxi,B4WvsMxi,B5WvsMxi,B6WvsMxi,B7WvsMxi,B8WvsMxi,B9WvsMxi,  &
                                                               B1WvsMyi,B2WvsMyi,B3WvsMyi,B4WvsMyi,B5WvsMyi,B6WvsMyi,B7WvsMyi,B8WvsMyi,B9WvsMyi,  &
                                                               B1WvsMzi,B2WvsMzi,B3WvsMzi,B4WvsMzi,B5WvsMzi,B6WvsMzi,B7WvsMzi,B8WvsMzi,B9WvsMzi/), &
                                                               (/9,6/)))
   INTEGER, PARAMETER             :: FHdrSttc(6,9) = transpose(reshape((/B1HdSFxi,B2HdSFxi,B3HdSFxi,B4HdSFxi,B5HdSFxi,B6HdSFxi,B7HdSFxi,B8HdSFxi,B9HdSFxi,  &
                                                               B1HdSFyi,B2HdSFyi,B3HdSFyi,B4HdSFyi,B5HdSFyi,B6HdSFyi,B7HdSFyi,B8HdSFyi,B9HdSFyi,  &
                                                               B1HdSFzi,B2HdSFzi,B3HdSFzi,B4HdSFzi,B5HdSFzi,B6HdSFzi,B7HdSFzi,B8HdSFzi,B9HdSFzi,  &
                                                               B1HdSMxi,B2HdSMxi,B3HdSMxi,B4HdSMxi,B5HdSMxi,B6HdSMxi,B7HdSMxi,B8HdSMxi,B9HdSMxi,  &
                                                               B1HdSMyi,B2HdSMyi,B3HdSMyi,B4HdSMyi,B5HdSMyi,B6HdSMyi,B7HdSMyi,B8HdSMyi,B9HdSMyi,  &
                                                               B1HdSMzi,B2HdSMzi,B3HdSMzi,B4HdSMzi,B5HdSMzi,B6HdSMzi,B7HdSMzi,B8HdSMzi,B9HdSMzi/), &
                                                               (/9,6/)))
   INTEGER, PARAMETER             :: FRdtn(6,9)    = transpose(reshape((/B1RdtFxi,B2RdtFxi,B3RdtFxi,B4RdtFxi,B5RdtFxi,B6RdtFxi,B7RdtFxi,B8RdtFxi,B9RdtFxi,  &
                                                               B1RdtFyi,B2RdtFyi,B3RdtFyi,B4RdtFyi,B5RdtFyi,B6RdtFyi,B7RdtFyi,B8RdtFyi,B9RdtFyi,  &
                                                               B1RdtFzi,B2RdtFzi,B3RdtFzi,B4RdtFzi,B5RdtFzi,B6RdtFzi,B7RdtFzi,B8RdtFzi,B9RdtFzi,  &
                                                               B1RdtMxi,B2RdtMxi,B3RdtMxi,B4RdtMxi,B5RdtMxi,B6RdtMxi,B7RdtMxi,B8RdtMxi,B9RdtMxi,  &
                                                               B1RdtMyi,B2RdtMyi,B3RdtMyi,B4RdtMyi,B5RdtMyi,B6RdtMyi,B7RdtMyi,B8RdtMyi,B9RdtMyi,  &
                                                               B1RdtMzi,B2RdtMzi,B3RdtMzi,B4RdtMzi,B5RdtMzi,B6RdtMzi,B7RdtMzi,B8RdtMzi,B9RdtMzi/), &
                                                               (/9,6/)))
   
   INTEGER, PARAMETER            :: WBMotions(6,9) = transpose(reshape((/B1Surge,B2Surge,B3Surge,B4Surge,B5Surge,B6Surge,B7Surge,B8Surge,B9Surge,  &
                                                               B1Sway ,B2Sway ,B3Sway ,B4Sway ,B5Sway ,B6Sway ,B7Sway ,B8Sway ,B9Sway ,  &
                                                               B1Heave,B2Heave,B3Heave,B4Heave,B5Heave,B6Heave,B7Heave,B8Heave,B9Heave,  &
                                                               B1Roll ,B2Roll ,B3Roll ,B4Roll ,B5Roll ,B6Roll ,B7Roll ,B8Roll ,B9Roll ,  &
                                                               B1Pitch,B2Pitch,B3Pitch,B4Pitch,B5Pitch,B6Pitch,B7Pitch,B8Pitch,B9Pitch,  &
                                                               B1Yaw  ,B2Yaw  ,B3Yaw  ,B4Yaw  ,B5Yaw  ,B6Yaw  ,B7Yaw  ,B8Yaw  ,B9Yaw  /), &
                                                               (/9,6/)))
   
   INTEGER, PARAMETER             :: WBVel(6,9)    = transpose(reshape((/B1TVxi,B2TVxi,B3TVxi,B4TVxi,B5TVxi,B6TVxi,B7TVxi,B8TVxi,B9TVxi,  &
                                                               B1TVyi,B2TVyi,B3TVyi,B4TVyi,B5TVyi,B6TVyi,B7TVyi,B8TVyi,B9TVyi,  &
                                                               B1TVzi,B2TVzi,B3TVzi,B4TVzi,B5TVzi,B6TVzi,B7TVzi,B8TVzi,B9TVzi,  &
                                                               B1RVxi,B2RVxi,B3RVxi,B4RVxi,B5RVxi,B6RVxi,B7RVxi,B8RVxi,B9RVxi,  &
                                                               B1RVyi,B2RVyi,B3RVyi,B4RVyi,B5RVyi,B6RVyi,B7RVyi,B8RVyi,B9RVyi,  &
                                                               B1RVzi,B2RVzi,B3RVzi,B4RVzi,B5RVzi,B6RVzi,B7RVzi,B8RVzi,B9RVzi/), &
                                                               (/9,6/)))

   INTEGER, PARAMETER             :: WBAcc(6,9)    = transpose(reshape((/B1TAxi,B2TAxi,B3TAxi,B4TAxi,B5TAxi,B6TAxi,B7TAxi,B8TAxi,B9TAxi,  &
                                                               B1TAyi,B2TAyi,B3TAyi,B4TAyi,B5TAyi,B6TAyi,B7TAyi,B8TAyi,B9TAyi,  &
                                                               B1TAzi,B2TAzi,B3TAzi,B4TAzi,B5TAzi,B6TAzi,B7TAzi,B8TAzi,B9TAzi,  &
                                                               B1RAxi,B2RAxi,B3RAxi,B4RAxi,B5RAxi,B6RAxi,B7RAxi,B8RAxi,B9RAxi,  &
                                                               B1RAyi,B2RAyi,B3RAyi,B4RAyi,B5RAyi,B6RAyi,B7RAyi,B8RAyi,B9RAyi,  &
                                                               B1RAzi,B2RAzi,B3RAzi,B4RAzi,B5RAzi,B6RAzi,B7RAzi,B8RAzi,B9RAzi/), &
                                                               (/9,6/)))

   INTEGER, PARAMETER             :: WaveElevi(9)   = (/Wave1Elev,Wave2Elev,Wave3Elev,Wave4Elev,Wave5Elev,Wave6Elev,Wave7Elev,Wave8Elev,Wave9Elev/)
   INTEGER, PARAMETER             :: WaveElevi1(9)  = (/Wave1Elv1,Wave2Elv1,Wave3Elv1,Wave4Elv1,Wave5Elv1,Wave6Elv1,Wave7Elv1,Wave8Elv1,Wave9Elv1/)
   INTEGER, PARAMETER             :: WaveElevi2(9)  = (/Wave1Elv2,Wave2Elv2,Wave3Elv2,Wave4Elv2,Wave5Elv2,Wave6Elv2,Wave7Elv2,Wave8Elv2,Wave9Elv2/)

   INTEGER, PARAMETER             :: PRPMotions(6) = (/PRPSurge,PRPSway,PRPHeave,PRPRoll,PRPPitch,PRPYaw/)
   INTEGER, PARAMETER             :: PRPVel(6)     = (/PRPTVxi, PRPTVyi,PRPTVzi, PRPRVxi,PRPRVyi, PRPRVzi/)
   INTEGER, PARAMETER             :: PRPAcc(6)     = (/PRPTAxi, PRPTAyi,PRPTAzi, PRPRAxi,PRPRAyi, PRPRAzi/)
 
   

   CHARACTER(OutStrLenM1), PARAMETER  :: ValidParamAry(537) =  (/  &   ! This lists the names of the allowed parameters, which must be sorted alphabetically
                               "B1ADDFXI ","B1ADDFYI ","B1ADDFZI ","B1ADDMXI ","B1ADDMYI ","B1ADDMZI ","B1HDSFXI ","B1HDSFYI ", &
                               "B1HDSFZI ","B1HDSMXI ","B1HDSMYI ","B1HDSMZI ","B1HEAVE  ","B1PITCH  ","B1RAXI   ","B1RAYI   ", &
                               "B1RAZI   ","B1RDTFXI ","B1RDTFYI ","B1RDTFZI ","B1RDTMXI ","B1RDTMYI ","B1RDTMZI ","B1ROLL   ", &
                               "B1RVXI   ","B1RVYI   ","B1RVZI   ","B1SURGE  ","B1SWAY   ","B1TAXI   ","B1TAYI   ","B1TAZI   ", &
                               "B1TVXI   ","B1TVYI   ","B1TVZI   ","B1WVSF1XI","B1WVSF1YI","B1WVSF1ZI","B1WVSF2XI","B1WVSF2YI", &
                               "B1WVSF2ZI","B1WVSFXI ","B1WVSFYI ","B1WVSFZI ","B1WVSM1XI","B1WVSM1YI","B1WVSM1ZI","B1WVSM2XI", &
                               "B1WVSM2YI","B1WVSM2ZI","B1WVSMXI ","B1WVSMYI ","B1WVSMZI ","B1YAW    ","B2ADDFXI ","B2ADDFYI ", &
                               "B2ADDFZI ","B2ADDMXI ","B2ADDMYI ","B2ADDMZI ","B2HDSFXI ","B2HDSFYI ","B2HDSFZI ","B2HDSMXI ", &
                               "B2HDSMYI ","B2HDSMZI ","B2HEAVE  ","B2PITCH  ","B2RAXI   ","B2RAYI   ","B2RAZI   ","B2RDTFXI ", &
                               "B2RDTFYI ","B2RDTFZI ","B2RDTMXI ","B2RDTMYI ","B2RDTMZI ","B2ROLL   ","B2RVXI   ","B2RVYI   ", &
                               "B2RVZI   ","B2SURGE  ","B2SWAY   ","B2TAXI   ","B2TAYI   ","B2TAZI   ","B2TVXI   ","B2TVYI   ", &
                               "B2TVZI   ","B2WVSF1XI","B2WVSF1YI","B2WVSF1ZI","B2WVSF2XI","B2WVSF2YI","B2WVSF2ZI","B2WVSFXI ", &
                               "B2WVSFYI ","B2WVSFZI ","B2WVSM1XI","B2WVSM1YI","B2WVSM1ZI","B2WVSM2XI","B2WVSM2YI","B2WVSM2ZI", &
                               "B2WVSMXI ","B2WVSMYI ","B2WVSMZI ","B2YAW    ","B3ADDFXI ","B3ADDFYI ","B3ADDFZI ","B3ADDMXI ", &
                               "B3ADDMYI ","B3ADDMZI ","B3HDSFXI ","B3HDSFYI ","B3HDSFZI ","B3HDSMXI ","B3HDSMYI ","B3HDSMZI ", &
                               "B3HEAVE  ","B3PITCH  ","B3RAXI   ","B3RAYI   ","B3RAZI   ","B3RDTFXI ","B3RDTFYI ","B3RDTFZI ", &
                               "B3RDTMXI ","B3RDTMYI ","B3RDTMZI ","B3ROLL   ","B3RVXI   ","B3RVYI   ","B3RVZI   ","B3SURGE  ", &
                               "B3SWAY   ","B3TAXI   ","B3TAYI   ","B3TAZI   ","B3TVXI   ","B3TVYI   ","B3TVZI   ","B3WVSF1XI", &
                               "B3WVSF1YI","B3WVSF1ZI","B3WVSF2XI","B3WVSF2YI","B3WVSF2ZI","B3WVSFXI ","B3WVSFYI ","B3WVSFZI ", &
                               "B3WVSM1XI","B3WVSM1YI","B3WVSM1ZI","B3WVSM2XI","B3WVSM2YI","B3WVSM2ZI","B3WVSMXI ","B3WVSMYI ", &
                               "B3WVSMZI ","B3YAW    ","B4ADDFXI ","B4ADDFYI ","B4ADDFZI ","B4ADDMXI ","B4ADDMYI ","B4ADDMZI ", &
                               "B4HDSFXI ","B4HDSFYI ","B4HDSFZI ","B4HDSMXI ","B4HDSMYI ","B4HDSMZI ","B4HEAVE  ","B4PITCH  ", &
                               "B4RAXI   ","B4RAYI   ","B4RAZI   ","B4RDTFXI ","B4RDTFYI ","B4RDTFZI ","B4RDTMXI ","B4RDTMYI ", &
                               "B4RDTMZI ","B4ROLL   ","B4RVXI   ","B4RVYI   ","B4RVZI   ","B4SURGE  ","B4SWAY   ","B4TAXI   ", &
                               "B4TAYI   ","B4TAZI   ","B4TVXI   ","B4TVYI   ","B4TVZI   ","B4WVSF1XI","B4WVSF1YI","B4WVSF1ZI", &
                               "B4WVSF2XI","B4WVSF2YI","B4WVSF2ZI","B4WVSFXI ","B4WVSFYI ","B4WVSFZI ","B4WVSM1XI","B4WVSM1YI", &
                               "B4WVSM1ZI","B4WVSM2XI","B4WVSM2YI","B4WVSM2ZI","B4WVSMXI ","B4WVSMYI ","B4WVSMZI ","B4YAW    ", &
                               "B5ADDFXI ","B5ADDFYI ","B5ADDFZI ","B5ADDMXI ","B5ADDMYI ","B5ADDMZI ","B5HDSFXI ","B5HDSFYI ", &
                               "B5HDSFZI ","B5HDSMXI ","B5HDSMYI ","B5HDSMZI ","B5HEAVE  ","B5PITCH  ","B5RAXI   ","B5RAYI   ", &
                               "B5RAZI   ","B5RDTFXI ","B5RDTFYI ","B5RDTFZI ","B5RDTMXI ","B5RDTMYI ","B5RDTMZI ","B5ROLL   ", &
                               "B5RVXI   ","B5RVYI   ","B5RVZI   ","B5SURGE  ","B5SWAY   ","B5TAXI   ","B5TAYI   ","B5TAZI   ", &
                               "B5TVXI   ","B5TVYI   ","B5TVZI   ","B5WVSF1XI","B5WVSF1YI","B5WVSF1ZI","B5WVSF2XI","B5WVSF2YI", &
                               "B5WVSF2ZI","B5WVSFXI ","B5WVSFYI ","B5WVSFZI ","B5WVSM1XI","B5WVSM1YI","B5WVSM1ZI","B5WVSM2XI", &
                               "B5WVSM2YI","B5WVSM2ZI","B5WVSMXI ","B5WVSMYI ","B5WVSMZI ","B5YAW    ","B6ADDFXI ","B6ADDFYI ", &
                               "B6ADDFZI ","B6ADDMXI ","B6ADDMYI ","B6ADDMZI ","B6HDSFXI ","B6HDSFYI ","B6HDSFZI ","B6HDSMXI ", &
                               "B6HDSMYI ","B6HDSMZI ","B6HEAVE  ","B6PITCH  ","B6RAXI   ","B6RAYI   ","B6RAZI   ","B6RDTFXI ", &
                               "B6RDTFYI ","B6RDTFZI ","B6RDTMXI ","B6RDTMYI ","B6RDTMZI ","B6ROLL   ","B6RVXI   ","B6RVYI   ", &
                               "B6RVZI   ","B6SURGE  ","B6SWAY   ","B6TAXI   ","B6TAYI   ","B6TAZI   ","B6TVXI   ","B6TVYI   ", &
                               "B6TVZI   ","B6WVSF1XI","B6WVSF1YI","B6WVSF1ZI","B6WVSF2XI","B6WVSF2YI","B6WVSF2ZI","B6WVSFXI ", &
                               "B6WVSFYI ","B6WVSFZI ","B6WVSM1XI","B6WVSM1YI","B6WVSM1ZI","B6WVSM2XI","B6WVSM2YI","B6WVSM2ZI", &
                               "B6WVSMXI ","B6WVSMYI ","B6WVSMZI ","B6YAW    ","B7ADDFXI ","B7ADDFYI ","B7ADDFZI ","B7ADDMXI ", &
                               "B7ADDMYI ","B7ADDMZI ","B7HDSFXI ","B7HDSFYI ","B7HDSFZI ","B7HDSMXI ","B7HDSMYI ","B7HDSMZI ", &
                               "B7HEAVE  ","B7PITCH  ","B7RAXI   ","B7RAYI   ","B7RAZI   ","B7RDTFXI ","B7RDTFYI ","B7RDTFZI ", &
                               "B7RDTMXI ","B7RDTMYI ","B7RDTMZI ","B7ROLL   ","B7RVXI   ","B7RVYI   ","B7RVZI   ","B7SURGE  ", &
                               "B7SWAY   ","B7TAXI   ","B7TAYI   ","B7TAZI   ","B7TVXI   ","B7TVYI   ","B7TVZI   ","B7WVSF1XI", &
                               "B7WVSF1YI","B7WVSF1ZI","B7WVSF2XI","B7WVSF2YI","B7WVSF2ZI","B7WVSFXI ","B7WVSFYI ","B7WVSFZI ", &
                               "B7WVSM1XI","B7WVSM1YI","B7WVSM1ZI","B7WVSM2XI","B7WVSM2YI","B7WVSM2ZI","B7WVSMXI ","B7WVSMYI ", &
                               "B7WVSMZI ","B7YAW    ","B8ADDFXI ","B8ADDFYI ","B8ADDFZI ","B8ADDMXI ","B8ADDMYI ","B8ADDMZI ", &
                               "B8HDSFXI ","B8HDSFYI ","B8HDSFZI ","B8HDSMXI ","B8HDSMYI ","B8HDSMZI ","B8HEAVE  ","B8PITCH  ", &
                               "B8RAXI   ","B8RAYI   ","B8RAZI   ","B8RDTFXI ","B8RDTFYI ","B8RDTFZI ","B8RDTMXI ","B8RDTMYI ", &
                               "B8RDTMZI ","B8ROLL   ","B8RVXI   ","B8RVYI   ","B8RVZI   ","B8SURGE  ","B8SWAY   ","B8TAXI   ", &
                               "B8TAYI   ","B8TAZI   ","B8TVXI   ","B8TVYI   ","B8TVZI   ","B8WVSF1XI","B8WVSF1YI","B8WVSF1ZI", &
                               "B8WVSF2XI","B8WVSF2YI","B8WVSF2ZI","B8WVSFXI ","B8WVSFYI ","B8WVSFZI ","B8WVSM1XI","B8WVSM1YI", &
                               "B8WVSM1ZI","B8WVSM2XI","B8WVSM2YI","B8WVSM2ZI","B8WVSMXI ","B8WVSMYI ","B8WVSMZI ","B8YAW    ", &
                               "B9ADDFXI ","B9ADDFYI ","B9ADDFZI ","B9ADDMXI ","B9ADDMYI ","B9ADDMZI ","B9HDSFXI ","B9HDSFYI ", &
                               "B9HDSFZI ","B9HDSMXI ","B9HDSMYI ","B9HDSMZI ","B9HEAVE  ","B9PITCH  ","B9RAXI   ","B9RAYI   ", &
                               "B9RAZI   ","B9RDTFXI ","B9RDTFYI ","B9RDTFZI ","B9RDTMXI ","B9RDTMYI ","B9RDTMZI ","B9ROLL   ", &
                               "B9RVXI   ","B9RVYI   ","B9RVZI   ","B9SURGE  ","B9SWAY   ","B9TAXI   ","B9TAYI   ","B9TAZI   ", &
                               "B9TVXI   ","B9TVYI   ","B9TVZI   ","B9WVSF1XI","B9WVSF1YI","B9WVSF1ZI","B9WVSF2XI","B9WVSF2YI", &
                               "B9WVSF2ZI","B9WVSFXI ","B9WVSFYI ","B9WVSFZI ","B9WVSM1XI","B9WVSM1YI","B9WVSM1ZI","B9WVSM2XI", &
                               "B9WVSM2YI","B9WVSM2ZI","B9WVSMXI ","B9WVSMYI ","B9WVSMZI ","B9YAW    ","HYDROFXI ","HYDROFYI ", &
                               "HYDROFZI ","HYDROMXI ","HYDROMYI ","HYDROMZI ","PRPHEAVE ","PRPPITCH ","PRPRAXI  ","PRPRAYI  ", &
                               "PRPRAZI  ","PRPROLL  ","PRPRVXI  ","PRPRVYI  ","PRPRVZI  ","PRPSURGE ","PRPSWAY  ","PRPTAXI  ", &
                               "PRPTAYI  ","PRPTAZI  ","PRPTVXI  ","PRPTVYI  ","PRPTVZI  ","PRPYAW   ","WAVE1ELEV","WAVE1ELV1", &
                               "WAVE1ELV2","WAVE2ELEV","WAVE2ELV1","WAVE2ELV2","WAVE3ELEV","WAVE3ELV1","WAVE3ELV2","WAVE4ELEV", &
                               "WAVE4ELV1","WAVE4ELV2","WAVE5ELEV","WAVE5ELV1","WAVE5ELV2","WAVE6ELEV","WAVE6ELV1","WAVE6ELV2", &
                               "WAVE7ELEV","WAVE7ELV1","WAVE7ELV2","WAVE8ELEV","WAVE8ELV1","WAVE8ELV2","WAVE9ELEV","WAVE9ELV1", &
                               "WAVE9ELV2"/)
   INTEGER(IntKi), PARAMETER :: ParamIndxAry(537) =  (/ &                            ! This lists the index into AllOuts(:) of the allowed parameters ValidParamAry(:)
                                 B1AddFxi ,  B1AddFyi ,  B1AddFzi ,  B1AddMxi ,  B1AddMyi ,  B1AddMzi ,  B1HdSFxi ,  B1HdSFyi , &
                                 B1HdSFzi ,  B1HdSMxi ,  B1HdSMyi ,  B1HdSMzi ,   B1Heave ,   B1Pitch ,    B1RAxi ,    B1RAyi , &
                                   B1RAzi ,  B1RdtFxi ,  B1RdtFyi ,  B1RdtFzi ,  B1RdtMxi ,  B1RdtMyi ,  B1RdtMzi ,    B1Roll , &
                                   B1RVxi ,    B1RVyi ,    B1RVzi ,   B1Surge ,    B1Sway ,    B1TAxi ,    B1TAyi ,    B1TAzi , &
                                   B1TVxi ,    B1TVyi ,    B1TVzi , B1WvsF1xi , B1WvsF1yi , B1WvsF1zi , B1WvsF2xi , B1WvsF2yi , &
                                B1WvsF2zi ,  B1WvsFxi ,  B1WvsFyi ,  B1WvsFzi , B1WvsM1xi , B1WvsM1yi , B1WvsM1zi , B1WvsM2xi , &
                                B1WvsM2yi , B1WvsM2zi ,  B1WvsMxi ,  B1WvsMyi ,  B1WvsMzi ,     B1Yaw ,  B2AddFxi ,  B2AddFyi , &
                                 B2AddFzi ,  B2AddMxi ,  B2AddMyi ,  B2AddMzi ,  B2HdSFxi ,  B2HdSFyi ,  B2HdSFzi ,  B2HdSMxi , &
                                 B2HdSMyi ,  B2HdSMzi ,   B2Heave ,   B2Pitch ,    B2RAxi ,    B2RAyi ,    B2RAzi ,  B2RdtFxi , &
                                 B2RdtFyi ,  B2RdtFzi ,  B2RdtMxi ,  B2RdtMyi ,  B2RdtMzi ,    B2Roll ,    B2RVxi ,    B2RVyi , &
                                   B2RVzi ,   B2Surge ,    B2Sway ,    B2TAxi ,    B2TAyi ,    B2TAzi ,    B2TVxi ,    B2TVyi , &
                                   B2TVzi , B2WvsF1xi , B2WvsF1yi , B2WvsF1zi , B2WvsF2xi , B2WvsF2yi , B2WvsF2zi ,  B2WvsFxi , &
                                 B2WvsFyi ,  B2WvsFzi , B2WvsM1xi , B2WvsM1yi , B2WvsM1zi , B2WvsM2xi , B2WvsM2yi , B2WvsM2zi , &
                                 B2WvsMxi ,  B2WvsMyi ,  B2WvsMzi ,     B2Yaw ,  B3AddFxi ,  B3AddFyi ,  B3AddFzi ,  B3AddMxi , &
                                 B3AddMyi ,  B3AddMzi ,  B3HdSFxi ,  B3HdSFyi ,  B3HdSFzi ,  B3HdSMxi ,  B3HdSMyi ,  B3HdSMzi , &
                                  B3Heave ,   B3Pitch ,    B3RAxi ,    B3RAyi ,    B3RAzi ,  B3RdtFxi ,  B3RdtFyi ,  B3RdtFzi , &
                                 B3RdtMxi ,  B3RdtMyi ,  B3RdtMzi ,    B3Roll ,    B3RVxi ,    B3RVyi ,    B3RVzi ,   B3Surge , &
                                   B3Sway ,    B3TAxi ,    B3TAyi ,    B3TAzi ,    B3TVxi ,    B3TVyi ,    B3TVzi , B3WvsF1xi , &
                                B3WvsF1yi , B3WvsF1zi , B3WvsF2xi , B3WvsF2yi , B3WvsF2zi ,  B3WvsFxi ,  B3WvsFyi ,  B3WvsFzi , &
                                B3WvsM1xi , B3WvsM1yi , B3WvsM1zi , B3WvsM2xi , B3WvsM2yi , B3WvsM2zi ,  B3WvsMxi ,  B3WvsMyi , &
                                 B3WvsMzi ,     B3Yaw ,  B4AddFxi ,  B4AddFyi ,  B4AddFzi ,  B4AddMxi ,  B4AddMyi ,  B4AddMzi , &
                                 B4HdSFxi ,  B4HdSFyi ,  B4HdSFzi ,  B4HdSMxi ,  B4HdSMyi ,  B4HdSMzi ,   B4Heave ,   B4Pitch , &
                                   B4RAxi ,    B4RAyi ,    B4RAzi ,  B4RdtFxi ,  B4RdtFyi ,  B4RdtFzi ,  B4RdtMxi ,  B4RdtMyi , &
                                 B4RdtMzi ,    B4Roll ,    B4RVxi ,    B4RVyi ,    B4RVzi ,   B4Surge ,    B4Sway ,    B4TAxi , &
                                   B4TAyi ,    B4TAzi ,    B4TVxi ,    B4TVyi ,    B4TVzi , B4WvsF1xi , B4WvsF1yi , B4WvsF1zi , &
                                B4WvsF2xi , B4WvsF2yi , B4WvsF2zi ,  B4WvsFxi ,  B4WvsFyi ,  B4WvsFzi , B4WvsM1xi , B4WvsM1yi , &
                                B4WvsM1zi , B4WvsM2xi , B4WvsM2yi , B4WvsM2zi ,  B4WvsMxi ,  B4WvsMyi ,  B4WvsMzi ,     B4Yaw , &
                                 B5AddFxi ,  B5AddFyi ,  B5AddFzi ,  B5AddMxi ,  B5AddMyi ,  B5AddMzi ,  B5HdSFxi ,  B5HdSFyi , &
                                 B5HdSFzi ,  B5HdSMxi ,  B5HdSMyi ,  B5HdSMzi ,   B5Heave ,   B5Pitch ,    B5RAxi ,    B5RAyi , &
                                   B5RAzi ,  B5RdtFxi ,  B5RdtFyi ,  B5RdtFzi ,  B5RdtMxi ,  B5RdtMyi ,  B5RdtMzi ,    B5Roll , &
                                   B5RVxi ,    B5RVyi ,    B5RVzi ,   B5Surge ,    B5Sway ,    B5TAxi ,    B5TAyi ,    B5TAzi , &
                                   B5TVxi ,    B5TVyi ,    B5TVzi , B5WvsF1xi , B5WvsF1yi , B5WvsF1zi , B5WvsF2xi , B5WvsF2yi , &
                                B5WvsF2zi ,  B5WvsFxi ,  B5WvsFyi ,  B5WvsFzi , B5WvsM1xi , B5WvsM1yi , B5WvsM1zi , B5WvsM2xi , &
                                B5WvsM2yi , B5WvsM2zi ,  B5WvsMxi ,  B5WvsMyi ,  B5WvsMzi ,     B5Yaw ,  B6AddFxi ,  B6AddFyi , &
                                 B6AddFzi ,  B6AddMxi ,  B6AddMyi ,  B6AddMzi ,  B6HdSFxi ,  B6HdSFyi ,  B6HdSFzi ,  B6HdSMxi , &
                                 B6HdSMyi ,  B6HdSMzi ,   B6Heave ,   B6Pitch ,    B6RAxi ,    B6RAyi ,    B6RAzi ,  B6RdtFxi , &
                                 B6RdtFyi ,  B6RdtFzi ,  B6RdtMxi ,  B6RdtMyi ,  B6RdtMzi ,    B6Roll ,    B6RVxi ,    B6RVyi , &
                                   B6RVzi ,   B6Surge ,    B6Sway ,    B6TAxi ,    B6TAyi ,    B6TAzi ,    B6TVxi ,    B6TVyi , &
                                   B6TVzi , B6WvsF1xi , B6WvsF1yi , B6WvsF1zi , B6WvsF2xi , B6WvsF2yi , B6WvsF2zi ,  B6WvsFxi , &
                                 B6WvsFyi ,  B6WvsFzi , B6WvsM1xi , B6WvsM1yi , B6WvsM1zi , B6WvsM2xi , B6WvsM2yi , B6WvsM2zi , &
                                 B6WvsMxi ,  B6WvsMyi ,  B6WvsMzi ,     B6Yaw ,  B7AddFxi ,  B7AddFyi ,  B7AddFzi ,  B7AddMxi , &
                                 B7AddMyi ,  B7AddMzi ,  B7HdSFxi ,  B7HdSFyi ,  B7HdSFzi ,  B7HdSMxi ,  B7HdSMyi ,  B7HdSMzi , &
                                  B7Heave ,   B7Pitch ,    B7RAxi ,    B7RAyi ,    B7RAzi ,  B7RdtFxi ,  B7RdtFyi ,  B7RdtFzi , &
                                 B7RdtMxi ,  B7RdtMyi ,  B7RdtMzi ,    B7Roll ,    B7RVxi ,    B7RVyi ,    B7RVzi ,   B7Surge , &
                                   B7Sway ,    B7TAxi ,    B7TAyi ,    B7TAzi ,    B7TVxi ,    B7TVyi ,    B7TVzi , B7WvsF1xi , &
                                B7WvsF1yi , B7WvsF1zi , B7WvsF2xi , B7WvsF2yi , B7WvsF2zi ,  B7WvsFxi ,  B7WvsFyi ,  B7WvsFzi , &
                                B7WvsM1xi , B7WvsM1yi , B7WvsM1zi , B7WvsM2xi , B7WvsM2yi , B7WvsM2zi ,  B7WvsMxi ,  B7WvsMyi , &
                                 B7WvsMzi ,     B7Yaw ,  B8AddFxi ,  B8AddFyi ,  B8AddFzi ,  B8AddMxi ,  B8AddMyi ,  B8AddMzi , &
                                 B8HdSFxi ,  B8HdSFyi ,  B8HdSFzi ,  B8HdSMxi ,  B8HdSMyi ,  B8HdSMzi ,   B8Heave ,   B8Pitch , &
                                   B8RAxi ,    B8RAyi ,    B8RAzi ,  B8RdtFxi ,  B8RdtFyi ,  B8RdtFzi ,  B8RdtMxi ,  B8RdtMyi , &
                                 B8RdtMzi ,    B8Roll ,    B8RVxi ,    B8RVyi ,    B8RVzi ,   B8Surge ,    B8Sway ,    B8TAxi , &
                                   B8TAyi ,    B8TAzi ,    B8TVxi ,    B8TVyi ,    B8TVzi , B8WvsF1xi , B8WvsF1yi , B8WvsF1zi , &
                                B8WvsF2xi , B8WvsF2yi , B8WvsF2zi ,  B8WvsFxi ,  B8WvsFyi ,  B8WvsFzi , B8WvsM1xi , B8WvsM1yi , &
                                B8WvsM1zi , B8WvsM2xi , B8WvsM2yi , B8WvsM2zi ,  B8WvsMxi ,  B8WvsMyi ,  B8WvsMzi ,     B8Yaw , &
                                 B9AddFxi ,  B9AddFyi ,  B9AddFzi ,  B9AddMxi ,  B9AddMyi ,  B9AddMzi ,  B9HdSFxi ,  B9HdSFyi , &
                                 B9HdSFzi ,  B9HdSMxi ,  B9HdSMyi ,  B9HdSMzi ,   B9Heave ,   B9Pitch ,    B9RAxi ,    B9RAyi , &
                                   B9RAzi ,  B9RdtFxi ,  B9RdtFyi ,  B9RdtFzi ,  B9RdtMxi ,  B9RdtMyi ,  B9RdtMzi ,    B9Roll , &
                                   B9RVxi ,    B9RVyi ,    B9RVzi ,   B9Surge ,    B9Sway ,    B9TAxi ,    B9TAyi ,    B9TAzi , &
                                   B9TVxi ,    B9TVyi ,    B9TVzi , B9WvsF1xi , B9WvsF1yi , B9WvsF1zi , B9WvsF2xi , B9WvsF2yi , &
                                B9WvsF2zi ,  B9WvsFxi ,  B9WvsFyi ,  B9WvsFzi , B9WvsM1xi , B9WvsM1yi , B9WvsM1zi , B9WvsM2xi , &
                                B9WvsM2yi , B9WvsM2zi ,  B9WvsMxi ,  B9WvsMyi ,  B9WvsMzi ,     B9Yaw ,  HydroFxi ,  HydroFyi , &
                                 HydroFzi ,  HydroMxi ,  HydroMyi ,  HydroMzi ,  PRPHeave ,  PRPPitch ,   PRPRAxi ,   PRPRAyi , &
                                  PRPRAzi ,   PRPRoll ,   PRPRVxi ,   PRPRVyi ,   PRPRVzi ,  PRPSurge ,   PRPSway ,   PRPTAxi , &
                                  PRPTAyi ,   PRPTAzi ,   PRPTVxi ,   PRPTVyi ,   PRPTVzi ,    PRPYaw , Wave1Elev , Wave1Elv1 , &
                                Wave1Elv2 , Wave2Elev , Wave2Elv1 , Wave2Elv2 , Wave3Elev , Wave3Elv1 , Wave3Elv2 , Wave4Elev , &
                                Wave4Elv1 , Wave4Elv2 , Wave5Elev , Wave5Elv1 , Wave5Elv2 , Wave6Elev , Wave6Elv1 , Wave6Elv2 , &
                                Wave7Elev , Wave7Elv1 , Wave7Elv2 , Wave8Elev , Wave8Elv1 , Wave8Elv2 , Wave9Elev , Wave9Elv1 , &
                                Wave9Elv2 /)
   CHARACTER(ChanLen), PARAMETER :: ParamUnitsAry(537) =  (/  &  ! This lists the units corresponding to the allowed parameters
                               "(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)", &
                               "(rad/s^2)","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ", &
                               "(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ", &
                               "(m/s)    ","(m/s)    ","(m/s)    ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N)      ","(N)      ","(N)      ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ", &
                               "(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ", &
                               "(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ", &
                               "(m/s)    ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(N)      ","(N)      ","(N)      ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ","(N)      ","(N)      ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ", &
                               "(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ","(m/s)    ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(rad)    ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ", &
                               "(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ", &
                               "(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ","(m/s)    ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ", &
                               "(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)", &
                               "(rad/s^2)","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ", &
                               "(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ", &
                               "(m/s)    ","(m/s)    ","(m/s)    ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N)      ","(N)      ","(N)      ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ", &
                               "(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ", &
                               "(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ", &
                               "(m/s)    ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(N)      ","(N)      ","(N)      ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ","(N)      ","(N)      ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ", &
                               "(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ","(m/s)    ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(rad)    ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ", &
                               "(rad/s^2)","(rad/s^2)","(rad/s^2)","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(rad)    ","(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ", &
                               "(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ","(m/s)    ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ", &
                               "(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)", &
                               "(rad/s^2)","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ", &
                               "(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ","(m/s^2)  ","(m/s^2)  ", &
                               "(m/s)    ","(m/s)    ","(m/s)    ","(N)      ","(N)      ","(N)      ","(N)      ","(N)      ", &
                               "(N)      ","(N)      ","(N)      ","(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ", &
                               "(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(N-m)    ","(rad)    ","(N)      ","(N)      ", &
                               "(N)      ","(N-m)    ","(N-m)    ","(N-m)    ","(m)      ","(rad)    ","(rad/s^2)","(rad/s^2)", &
                               "(rad/s^2)","(rad)    ","(rad/s)  ","(rad/s)  ","(rad/s)  ","(m)      ","(m)      ","(m/s^2)  ", &
                               "(m/s^2)  ","(m/s^2)  ","(m/s)    ","(m/s)    ","(m/s)    ","(rad)    ","(m)      ","(m)      ", &
                               "(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ", &
                               "(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ", &
                               "(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ","(m)      ", &
                               "(m)      "/)
  
   
      ! ..... Public Subroutines ...................................................................................................
   PUBLIC :: HDOut_CloseSum
   PUBLIC :: HDOut_OpenSum
   PUBLIC :: HDOut_MapOutputs
   PUBLIC :: HDOut_WriteOutputs
   PUBLIC :: HDOut_OpenOutput
   PUBLIC :: HDOut_CloseOutput
   PUBLIC :: HDOut_GetChannels
   PUBLIC :: HDOUT_Init
   PUBLIC :: HDOut_WriteWvKinFiles
   
   CONTAINS



!====================================================================================================
SUBROUTINE HDOut_CloseSum( UnSum, ErrStat, ErrMsg )


      ! Passed variables
      
   INTEGER,                 INTENT( IN    )   :: UnSum                ! the unit number for the HydroDyn summary file          
   INTEGER,                 INTENT(   OUT )   :: ErrStat              ! returns a non-zero value when an error occurs  
   CHARACTER(*),            INTENT(   OUT )   :: ErrMsg               ! Error message if ErrStat /= ErrID_None
  

      ! Local variables
   LOGICAL                                :: Err                                       ! determines if an error exists      

      ! Initialize ErrStat
         
   ErrStat = ErrID_None         
   ErrMsg  = ""
   
   Err = .FALSE.

      ! Write any closing information in the summary file
      
   IF ( UnSum > 0 ) THEN
      WRITE (UnSum,'(/,A/)', IOSTAT=ErrStat)  'This summary file was closed on '//CurDate()//' at '//CurTime()//'.'
      IF (ErrStat /= 0) THEN
         Err = .TRUE.
         ErrMsg  = 'Problem writing to summary file'
      END IF
   END IF   
   
      ! Close the file
   
   CLOSE( UnSum, IOSTAT=ErrStat )
   IF (ErrStat /= 0) THEN
      Err = .TRUE.
      ErrMsg  = 'Problem closing summary file'
   END IF
   
   IF ( Err ) ErrStat = ErrID_Fatal
      
                      
END SUBROUTINE HDOut_CloseSum            

!====================================================================================================
SUBROUTINE HDOut_OpenSum( UnSum, SummaryName, HD_Prog, ErrStat, ErrMsg )


      ! Passed variables
      
   INTEGER,                 INTENT(   OUT )   :: UnSum                ! the unit number for the HydroDyn summary file          
   CHARACTER(*),            INTENT( IN    )   :: SummaryName          ! the name of the HydroDyn summary file
   TYPE(ProgDesc),          INTENT( IN    )   :: HD_Prog              ! the name/version/date of the hydrodynamics program
   INTEGER,                 INTENT(   OUT )   :: ErrStat              ! returns a non-zero value when an error occurs  
   CHARACTER(*),            INTENT(   OUT )   :: ErrMsg               ! Error message if ErrStat /= ErrID_None
           

       ! Initialize ErrStat
         
   ErrStat = ErrID_None         
   ErrMsg  = ""       
      

   CALL GetNewUnit( UnSum )

   CALL OpenFOutFile ( UnSum, SummaryName, ErrStat, ErrMsg ) 
   IF (ErrStat >=AbortErrLev) RETURN
      
      
         ! Write the summary file header
      
   WRITE (UnSum,'(/,A/)', IOSTAT=ErrStat)  'This summary file was generated by '//TRIM( HD_Prog%Name )//&
                     ' '//TRIM( HD_Prog%Ver )//' on '//CurDate()//' at '//CurTime()//'.'
                      
END SUBROUTINE HDOut_OpenSum 

!====================================================================================================
SUBROUTINE HDOut_WriteWvKinFiles( Rootname, HD_Prog, NStepWave, NNodes, NWaveElev, nodeInWater, WaveElev, WaveKinzi, &
                                    WaveTime, WaveVel, WaveAcc, WaveDynP, ErrStat, ErrMsg )

      ! Passed variables
   CHARACTER(*),                  INTENT( IN    )   :: Rootname             ! filename including full path, minus any file extension.
   TYPE(ProgDesc),                INTENT( IN    )   :: HD_Prog              ! the name/version/date of the hydrodynamics program
   INTEGER,                       INTENT( IN    )   :: NStepWave            ! Number of time steps for the wave kinematics arrays
   INTEGER,                       INTENT( IN    )   :: NNodes               ! Number of simulation nodes for the wave kinematics arrays
   INTEGER,                       INTENT( IN    )   :: NWaveElev            ! Number of locations where wave elevations were requested
   INTEGER,                       INTENT( IN    )   :: nodeInWater(0:,: )     !
   REAL(SiKi),                    INTENT( IN    )   :: WaveElev  (0:,: )     ! Instantaneous wave elevations at requested locations
   REAL(SiKi),                    INTENT( IN    )   :: WaveKinzi(:    )     ! The z-location of all the nodes
   REAL(SiKi),                    INTENT( IN    )   :: WaveTime (0:    )     ! The time values for the wave kinematics  (time)
   REAL(SiKi),                    INTENT( IN    )   :: WaveVel (0:,:,:)     ! The wave velocities (time,node,component)
   REAL(SiKi),                    INTENT( IN    )   :: WaveAcc (0:,:,:)     ! The wave accelerations (time,node,component)
   REAL(SiKi),                    INTENT( IN    )   :: WaveDynP(0:,:)       ! The wave dynamic pressure (time,node)
   INTEGER,                       INTENT(   OUT )   :: ErrStat              ! returns a non-zero value when an error occurs  
   CHARACTER(*),                  INTENT(   OUT )   :: ErrMsg               ! Error message if ErrStat /= ErrID_None
      
      ! Local variables
   INTEGER                                    :: UnWv                       ! file unit for writing the various wave kinematics files
   CHARACTER(1024)                            :: WvName                     ! complete filename for one of the output files
   CHARACTER(5)                               :: extension(7)     
   INTEGER                                    :: i, j, iFile
   CHARACTER(64)                              :: Frmt, Sfrmt
   CHARACTER(ChanLen)                         :: Delim
      ! Initialize ErrStat      
   ErrStat = ErrID_None         
   ErrMsg  = ""       
      
   extension  = (/'.Vxi ','.Vyi ','.Vzi ','.Axi ','.Ayi ','.Azi ','.DynP'/)
   Delim         = ''
   !Frmt = '('//TRIM(Int2LStr(NNodes))//'(:,A,ES11.4e2))'
   Frmt  = '(:,A,ES11.4e2)'
   Sfrmt = '(:,A,A11)'
   
   
         
   DO iFile = 1,7
      
      CALL GetNewUnit( UnWv )

      WvName = Rootname // TRIM(extension(iFile))
      CALL OpenFOutFile ( UnWv, WvName, ErrStat, ErrMsg ) 
         IF (ErrStat >=AbortErrLev) RETURN
      
      
      
            ! Write the summary file header    
     ! WRITE (UnWv,'(/,A/)', IOSTAT=ErrStat)  'This wave kinematics file was generated by '//TRIM( HD_Prog%Name )//&
      WRITE (UnWv,'(A)', IOSTAT=ErrStat)  'This wave kinematics file was generated by '//TRIM( HD_Prog%Name )//&
                        ' '//TRIM( HD_Prog%Ver )//' on '//CurDate()//' at '//CurTime()//'.'
        
      
      DO i= 0,NStepWave-1
         DO j = 1, NNodes
            IF ( nodeInWater(i,j) == 0 )  THEN
               WRITE(UnWv,Sfrmt,ADVANCE='no')   Delim,  '##########'
            ELSE
                  
               SELECT CASE (iFile)
                  CASE (1)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveVel (i,j,1)  
                  CASE (2)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveVel (i,j,2)  
                  CASE (3)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveVel (i,j,3)  
                  CASE (4)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveAcc (i,j,1)  
                  CASE (5)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveAcc (i,j,2)  
                  CASE (6)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveAcc (i,j,3)  
                  CASE (7)              
                     WRITE(UnWv,Frmt,ADVANCE='no')   Delim,  WaveDynP(i,j  )  
                  END SELECT
            END IF
         END DO
         WRITE (UnWv,'()', IOSTAT=ErrStat)          ! write the line return   
      END DO
      
      CLOSE( UnWv, IOSTAT=ErrStat )
      IF (ErrStat /= 0) THEN
         ErrStat = ErrID_Fatal
         ErrMsg  = 'Problem closing wave kinematics file'
         RETURN
      END IF      
   END DO
   
   IF ( NWaveElev > 0 ) THEN
   
      CALL GetNewUnit( UnWv )

      WvName = Rootname // '.Elev'
      CALL OpenFOutFile ( UnWv, WvName, ErrStat, ErrMsg ) 
         IF (ErrStat >=AbortErrLev) RETURN
      
      
      
            ! Write the summary file header    
      WRITE (UnWv,'(A)', IOSTAT=ErrStat)  'This wave kinematics file was generated by '//TRIM( HD_Prog%Name )//&
                        ' '//TRIM( HD_Prog%Ver )//' on '//CurDate()//' at '//CurTime()//'.'
        
      
      DO i= 0,NStepWave-1
         
         Frmt = '('//TRIM(Int2LStr(NWaveElev))//'(:,A,ES11.4e2))'
         WRITE(UnWv,Frmt)   ( Delim,  WaveElev(i,j)  , j=1,NWaveElev )   
         
      END DO
      
      CLOSE( UnWv, IOSTAT=ErrStat )
      IF (ErrStat /= 0) THEN
         ErrStat = ErrID_Fatal
         ErrMsg  = 'Problem closing wave elevations file'
         RETURN
      END IF     
      
   END IF
   
   
END SUBROUTINE HDOut_WriteWvKinFiles 

!====================================================================================================
SUBROUTINE HDOut_MapOutputs( CurrentTime, p, y, m_WAMIT, m_WAMIT2, NWaveElev, WaveElev, WaveElev1, WaveElev2, F_Add, F_Waves, F_Hydro, PRPmesh, q, qdot, qdotdot, AllOuts, ErrStat, ErrMsg )
! This subroutine writes the data stored in the y variable to the correct indexed postions in WriteOutput
! This is called by HydroDyn_CalcOutput() at each time step.
!---------------------------------------------------------------------------------------------------- 
   REAL(DbKi),                            INTENT( IN    )  :: CurrentTime    ! Current simulation time in seconds
   TYPE(HydroDyn_ParameterType),          INTENT( IN    )  :: p              ! HydroDyn's parameter data
   TYPE(HydroDyn_OutputType),             INTENT( INOUT )  :: y              ! HydroDyn's output data
   type(WAMIT_MiscVarType),  ALLOCATABLE, intent( in    )  :: m_WAMIT(:)     ! WAMIT object's MiscVar data
   type(WAMIT2_MiscVarType), ALLOCATABLE, intent( in    )  :: m_WAMIT2(:)    ! WAMIT2 object's MiscVar data
   INTEGER,                               INTENT( IN    )  :: NWaveElev      ! Number of wave elevation locations to output
   REAL(ReKi),                            INTENT( IN    )  :: WaveElev(:)    ! Instantaneous total elevation of incident waves at each of the NWaveElev points where the incident wave elevations can be output (meters)   
   REAL(ReKi),                            INTENT( IN    )  :: WaveElev1(:)    ! Instantaneous first order elevation of incident waves at each of the NWaveElev points where the incident wave elevations can be output (meters)   
   REAL(ReKi),                            INTENT( IN    )  :: WaveElev2(:)    ! Instantaneous second order elevation of incident waves at each of the NWaveElev points where the incident wave elevations can be output (meters)   
   REAL(ReKi),               ALLOCATABLE, INTENT( IN    )  :: F_Add(:)
   REAL(ReKi),               ALLOCATABLE, INTENT( IN    )  :: F_Waves(:)
   REAL(ReKi),                            INTENT( IN    )  :: F_Hydro(:)     ! All hydrodynamic loads integrated at (0,0,0) in the global coordinate system
   type(MeshType),                        INTENT( IN    )  :: PRPmesh        ! the PRP mesh -- for motions output
   REAL(ReKi),                            INTENT( IN    )  :: q(:)           ! WAMIT body translations and rotations
   REAL(ReKi),                            INTENT( IN    )  :: qdot(:)        ! WAMIT body translational and rotational velocities
   REAL(ReKi),                            INTENT( IN    )  :: qdotdot(:)     ! WAMIT body translational and rotational accelerations
   REAL(ReKi),                            INTENT(   OUT )  :: AllOuts(MaxHDOutputs)
   INTEGER(IntKi),                        INTENT(   OUT )  :: ErrStat        ! Error status of the operation
   CHARACTER(*),                          INTENT(   OUT )  :: ErrMsg         ! Error message if ErrStat /= ErrID_None

   INTEGER                                              :: I, iBody, startIndx, endIndx
   integer(IntKi)                                       :: ErrStat2
   character(ErrMsgLen)                                 :: ErrMsg2
   real(ReKi)                                           :: rotdisp(3)

   ErrStat = ErrID_None
   ErrMsg = ""
   
   ! Initialize all unused channels to zero (in case they don't get set, but are still requested)
   AllOuts  = 0.0_ReKi

   rotdisp = GetSmllRotAngs ( PRPMesh%Orientation(:,:,1), ErrStat2, ErrMsg2 )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, 'HDOut_MapOutputs' )
   AllOuts(PRPMotions)  = reshape((/real(PRPMesh%TranslationDisp(:,1),ReKi),rotdisp(:)/),(/6/))
   AllOuts(PRPVel)      = reshape((/PRPMesh%TranslationVel(:,1),PRPMesh%RotationVel(:,1)/),(/6/))
   AllOuts(PRPAcc)      = reshape((/PRPMesh%TranslationAcc(:,1),PRPMesh%RotationAcc(:,1)/),(/6/))

   ! Need to use individual components of force for output reporting, the y%mesh data has total forces from all contributions
   if ( p%potMod == 1 ) then
      if ( p%NBodyMod == 1 .or. p%NBody == 1 ) then
         do iBody = 1,p%NBody
            startIndx = 6*(iBody-1) + 1
            endIndx   = startIndx + 5
            AllOuts(FWaves1  (:,iBody)) = m_WAMIT(1)%F_Waves1(startIndx:endIndx)
            AllOuts(FHdrSttc (:,iBody)) = m_WAMIT(1)%F_HS(startIndx:endIndx)
            AllOuts(FRdtn    (:,iBody)) = m_WAMIT(1)%F_Rdtn(startIndx:endIndx) + m_WAMIT(1)%F_PtfmAM(startIndx:endIndx)
            if (p%WAMIT2used) AllOuts(FWaves2  (:,iBody)) = m_WAMIT2(1)%F_Waves2(startIndx:endIndx)  ! These are reported by the WAMIT2 module
            AllOuts(FAdd     (:,iBody)) = F_Add(startIndx:endIndx)
            AllOuts(FWavesTot(:,iBody)) = F_Waves(startIndx:endIndx)
            AllOuts(WBMotions(:,iBody)) = q(startIndx:endIndx)
            AllOuts(WBVel    (:,iBody)) = qdot(startIndx:endIndx)
            AllOuts(WBAcc    (:,iBody)) = qdotdot(startIndx:endIndx)     
         end do
      else
         
         ! This happens when NBodyMod > 1, in which case, each WAMIT object is for a single body, but there may be multiple bodies in the HydroDyn model, 
         !   so we need to use BodyID to determine the index into the complete HydroDyn list of WAMIT bodies
      
         do iBody = 1,p%NBody
            startIndx = 6*(iBody-1) + 1
            endIndx   = startIndx + 5
            AllOuts(FWaves1  (:,iBody)) = m_WAMIT(iBody)%F_Waves1
            AllOuts(FHdrSttc (:,iBody)) = m_WAMIT(iBody)%F_HS
            AllOuts(FRdtn    (:,iBody)) = m_WAMIT(iBody)%F_Rdtn + m_WAMIT(iBody)%F_PtfmAM
            if (p%WAMIT2used) AllOuts(FWaves2  (:,iBody)) = m_WAMIT2(iBody)%F_Waves2
            AllOuts(FAdd     (:,iBody)) = F_Add(startIndx:endIndx)
            AllOuts(FWavesTot(:,iBody)) = F_Waves(startIndx:endIndx)
            AllOuts(WBMotions(:,iBody)) = q(startIndx:endIndx)
            AllOuts(WBVel    (:,iBody)) = qdot(startIndx:endIndx)
            AllOuts(WBAcc    (:,iBody)) = qdotdot(startIndx:endIndx)     
         end do
      end if
   end if
   
   
   AllOuts(FHydro ) = F_Hydro
   
   DO I=1,NWaveElev
      AllOuts(WaveElevi(I)) = WaveElev(I)
      AllOuts(WaveElevi1(I))= WaveElev1(I)
      AllOuts(WaveElevi2(I))= WaveElev2(I)
   END DO
   
   
   
END SUBROUTINE HDOut_MapOutputs

!====================================================================================================
SUBROUTINE HDOut_WriteOutputs( Time, y, p, Decimate, ErrStat, ErrMsg )
! This subroutine writes the data stored in WriteOutputs (and indexed in OutParam) to the file
! opened in HDOut_Init()
!---------------------------------------------------------------------------------------------------- 

      ! Passed variables    
   REAL(DbKi),                   INTENT( IN    ) :: Time
   TYPE(HydroDyn_OutputType),    INTENT( INOUT ) :: y                    ! HydroDyn's output data
   TYPE(HydroDyn_ParameterType), INTENT( IN    ) :: p                    ! HydroDyn parameter data
   INTEGER,                      INTENT( INOUT ) :: Decimate             ! Output decimatation counter
   INTEGER,                      INTENT(   OUT ) :: ErrStat              ! returns a non-zero value when an error occurs  
   CHARACTER(*),                 INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None
   
      ! Local variables
   INTEGER                                :: I                           ! Generic loop counter
   CHARACTER(200)                         :: Frmt                        ! a string to hold a format statement
   integer(IntKi)                         :: ErrStat2
   character(ErrMsgLen)                   :: ErrMsg2
   
   
  IF (p%UnOutFile < 0 ) RETURN
  
      ! Initialize ErrStat and determine if it makes any sense to write output
!TODO: We should not have this check here, once per timestep!  This should be resolved during initialization. GJH 7/7/2014    
   IF ( ( (.NOT. ALLOCATED( p%OutParam )) .AND. (.NOT. ALLOCATED( p%WAMIT ) ) .AND. (.NOT. ALLOCATED( p%WAMIT2 ) )&
          .AND. (.NOT. ALLOCATED( p%Waves2%OutParam ) ) .AND. ( .NOT. ALLOCATED( p%Morison%OutParam ) ) ) )  THEN
      ErrStat = ErrID_Warn
      ErrMsg  = ' Cannot write output to file because there are not a valid output list.'
      RETURN
   ELSE
      ErrStat = ErrID_None
      ErrMsg  = ''
   END IF
   
   
      ! Write the output parameters to the file
      
   !Frmt = '(F8.3,'//TRIM(Int2LStr(p%WAMIT%NumOuts+p%Morison%NumOuts))//'(:,A,'//TRIM( p%OutFmt )//'))'
   !Frmt = '('//TRIM( p%OutFmt )//','//TRIM(Int2LStr(p%NumOuts))//'(:,A,'//TRIM( p%OutFmt )//'))'
   
   !WRITE(p%UnOutFile,Frmt) Time, ( p%Delim, y%WAMIT%WriteOutput(I), I=1,p%WAMIT%NumOuts), ( p%Delim, y%Morison%WriteOutput(I), I=1,p%Morison%NumOuts)
   
   IF ((Decimate .EQ. p%OutDec) .OR. (Decimate .EQ. 0))  THEN
      
      Decimate = 1  !reset counter  
            
      Frmt = '(F10.4)'
   
      WRITE(p%UnOutFile,Frmt,ADVANCE='no')  Time
      
      IF ( p%NumTotalOuts > 0 ) THEN
         Frmt = '('//TRIM(Int2LStr(p%NumTotalOuts))//'(:,A,'//TRIM( p%OutFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim,  y%WriteOutput(I)  , I=1,p%NumTotalOuts )   
      END IF
          
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat2)          ! write the line return -- ignore error status
   
   ELSE      
      Decimate = Decimate + 1
   ENDIF
   
   RETURN
   
END SUBROUTINE HDOut_WriteOutputs

!====================================================================================================
SUBROUTINE HDOUT_Init( HydroDyn_ProgDesc, OutRootName, InputFileData, y,  p, m, InitOut, ErrStat, ErrMsg )
! This subroutine initialized the output module, checking if the output parameter list (OutList)
! contains valid names, and opening the output file if there are any requested outputs
! NOTE: This routine must be called only after any sub-modules OUT_Init() subroutines have been called.
!----------------------------------------------------------------------------------------------------

   

      ! Passed variables

   TYPE(ProgDesc),                INTENT( IN    ) :: HydroDyn_ProgDesc    ! 
   CHARACTER(1024),               INTENT( IN    ) :: OutRootName          ! The name of the output file 
   TYPE(HydroDyn_InputFile ),     INTENT( IN    ) :: InputFileData        ! data needed to initialize the output module     
   TYPE(HydroDyn_OutputType),     INTENT( INOUT ) :: y                    ! This module's internal data
   TYPE(HydroDyn_ParameterType),  INTENT( INOUT ) :: p 
   TYPE(HydroDyn_MiscVarType),    INTENT( INOUT ) :: m
   TYPE(HydroDyn_InitOutputType), INTENT( INOUT ) :: InitOut
   INTEGER,                       INTENT(   OUT ) :: ErrStat              ! a non-zero value indicates an error occurred           
   CHARACTER(*),                  INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None
   
      ! Local variables
   INTEGER                                        :: I                    ! Generic loop counter      
   INTEGER                                        :: J                    ! Generic loop counter      
   INTEGER                                        :: iWAMIT                ! loop counter over WAMIT objects
!   INTEGER                                        :: Indx                 ! Counts the current index into the WaveKinNd array
!   CHARACTER(1024)                                :: OutFileName          ! The name of the output file  including the full path.
!   CHARACTER(200)                                 :: Frmt                 ! a string to hold a format statement
   LOGICAL                                        :: hasWAMITOuts         ! Are there any WAMIT-related outputs
   LOGICAL                                        :: hasWAMIT2Outs        ! Are there any WAMIT-related outputs
   LOGICAL                                        :: hasWaves2Outs        ! Are there any WAMIT-related outputs
   LOGICAL                                        :: hasMorisonOuts       ! Are there any Morison-related outputs
   
   
   
   
   
   !-------------------------------------------------------------------------------------------------      
   ! Initialize local variables
   !-------------------------------------------------------------------------------------------------      
     
         
   ErrStat = ErrID_None         
   ErrMsg  = ""  
      
      !  Sanity check that we didn't have an issue during the programing of this module.  The auto
      !  generated outlist at the top of this file sets the MaxOutPts value, but HD does not use
      !  that value, but rather has the maximum outputs hard coded in the HD registry file. This
      !  next test will hopefully help the developer catch any issues.
   if ( MaxOutPts /= MaxHDOutputs ) then
      call SetErrStat(ErrID_Fatal, ' HD outputs: the number of outputs given by the Write_ChckOutList.m '// &
         'script using the xlsx file does not match the number of outputs given by the HydroDyn.txt registry '// &
         'file.', ErrStat, ErrMsg, 'HDOUT_Init')
      return
   endif


   !-------------------------------------------------------------------------------------------------      
   ! Check that the variables in OutList are valid      
   !-------------------------------------------------------------------------------------------------      
      
   
   CALL HDOUT_ChkOutLst( InputFileData%OutList(1:p%NumOuts), y, p, ErrStat, ErrMsg )
   IF ( ErrStat /= 0 ) RETURN

         ! Aggregate the sub-module initialization outputs for the glue code

         hasWAMIT2Outs  = .FALSE.
         hasWaves2Outs  = .FALSE.
         hasMorisonOuts = .FALSE.
         p%NumTotalOuts = p%NumOuts
         m%LastOutTime  = 0.0_DbKi
         m%Decimate     = 0
         p%OutDec       = 1             !TODO: Remove this once the parameter has been added to the HD input file GJH 7/8/2014

         IF (ALLOCATED( p%Waves2%OutParam ) .AND. p%Waves2%NumOuts > 0) THEN
            hasWaves2Outs = .TRUE.
            p%NumTotalOuts = p%NumTotalOuts + p%Waves2%NumOuts       
         END IF
         IF (ALLOCATED( p%Morison%OutParam ) .AND. p%Morison%NumOuts > 0) THEN
            hasMorisonOuts = .TRUE.
            p%NumTotalOuts = p%NumTotalOuts + p%Morison%NumOuts       
         END IF
      
            ! Allocate the aggregate arrays
         
         ALLOCATE ( InitOut%WriteOutputHdr ( p%NumTotalOuts ) , STAT=ErrStat )
         IF ( ErrStat /= 0 )  THEN
            ErrMsg  = ' Error allocating memory for the WriteOutputHdr array.'
            ErrStat = ErrID_Fatal
            RETURN
         END IF
         
         ALLOCATE ( InitOut%WriteOutputUnt ( p%NumTotalOuts ) , STAT=ErrStat )
         IF ( ErrStat /= 0 )  THEN
            ErrMsg  = ' Error allocating memory for the WriteOutputUnt array.'
            ErrStat = ErrID_Fatal
            RETURN
         END IF
         
         ALLOCATE ( y%WriteOutput         ( p%NumTotalOuts ) , STAT=ErrStat )
         IF ( ErrStat /= 0 )  THEN
            ErrMsg  = ' Error allocating memory for the WriteOutput array.'
            ErrStat = ErrID_Fatal
            RETURN
         END IF
         y%WriteOutput = 0.0_ReKi  ! bjj added this only so the Intel Inspector wouldn't complain about uninitialized memory access (was harmless)
         
                  
            ! Initialize the HD-level Hdr and Unt elements
         DO I = 1,p%NumOuts
         
            InitOut%WriteOutputHdr(I) = TRIM( p%OutParam(I)%Name  )
            InitOut%WriteOutputUnt(I) = TRIM( p%OutParam(I)%Units )      
      
         END DO    
            
            
         J = p%NumOuts + 1
         
         IF ( hasWaves2Outs ) THEN
            DO I=1, p%Waves2%NumOuts
               InitOut%WriteOutputHdr(J) = InitOut%Waves2%WriteOutputHdr(I)
               InitOut%WriteOutputUnt(J) = InitOut%Waves2%WriteOutputUnt(I)
               J = J + 1
            END DO
         END IF
         
         IF ( hasMorisonOuts ) THEN
            DO I=1, p%Morison%NumOuts
               InitOut%WriteOutputHdr(J) = InitOut%Morison%WriteOutputHdr(I)
               InitOut%WriteOutputUnt(J) = InitOut%Morison%WriteOutputUnt(I)
               J = J + 1
            END DO
         END IF

      IF ( p%OutSwtch == 1 .OR. p%OutSwtch == 3 ) THEN
         CALL HDOut_OpenOutput( HydroDyn_ProgDesc, OutRootName, p, InitOut, ErrStat, ErrMsg )
         IF (ErrStat >= AbortErrLev ) RETURN
      END IF
      
      

   RETURN

END SUBROUTINE HDOUT_Init

!====================================================================================================
SUBROUTINE HDOut_OpenOutput( HydroDyn_ProgDesc, OutRootName,  p, InitOut, ErrStat, ErrMsg )
! This subroutine initialized the output module, checking if the output parameter list (OutList)
! contains valid names, and opening the output file if there are any requested outputs
!----------------------------------------------------------------------------------------------------

   

      ! Passed variables

   TYPE(ProgDesc)               , INTENT( IN    ) :: HydroDyn_ProgDesc
   CHARACTER(1024),               INTENT( IN    ) :: OutRootName          ! Root name for the output file
   TYPE(HydroDyn_ParameterType),  INTENT( INOUT ) :: p   
   TYPE(HydroDyn_InitOutPutType ),INTENT( IN    ) :: InitOut            !
   INTEGER,                       INTENT(   OUT ) :: ErrStat              ! a non-zero value indicates an error occurred           
   CHARACTER(*),                  INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None
   
      ! Local variables
   INTEGER                                        :: I                    ! Generic loop counter      
   INTEGER                                        :: iWAMIT               ! loop counter  for WAMIT Objects    
!   INTEGER                                        :: Indx                 ! Counts the current index into the WaveKinNd array
   CHARACTER(1024)                                ::  OutFileName         ! The name of the output file  including the full path.
   CHARACTER(200)                                 :: Frmt                 ! a string to hold a format statement
                
   !-------------------------------------------------------------------------------------------------      
   ! Initialize local variables
   !-------------------------------------------------------------------------------------------------      
   ErrStat = ErrID_None
   ErrMsg = ""
      
   
   
   !-------------------------------------------------------------------------------------------------      
   ! Open the output file, if necessary, and write the header
   !-------------------------------------------------------------------------------------------------      
   p%UnOutFile = -1
   IF ( (ALLOCATED( p%OutParam         ) .AND. p%NumOuts > 0         ) .OR. &
        (ALLOCATED( p%Waves2%OutParam  ) .AND. p%Waves2%NumOuts > 0  ) .OR. &
        (ALLOCATED( p%Morison%OutParam ) .AND. p%Morison%NumOuts > 0 ) ) THEN           ! Output has been requested so let's open an output file            
      
         ! Open the file for output
      OutFileName = TRIM(OutRootName)//'.HD.out'
      CALL GetNewUnit( p%UnOutFile )
   
      CALL OpenFOutFile ( p%UnOutFile, OutFileName, ErrStat, ErrMsg ) 
      IF (ErrStat >=AbortErrLev) RETURN
      
      
         ! Write the output file header
      
      WRITE (p%UnOutFile,'(/,A/)', IOSTAT=ErrStat)  'These predictions were generated by '//TRIM(HydroDyn_ProgDesc%Name)//&
                      ' on '//CurDate()//' at '//CurTime()//'.'

         ! Write three empty lines
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat)
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat)
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat)

         ! Write the names of the output parameters:
      Frmt = '(A8)'
      WRITE(p%UnOutFile,Frmt,ADVANCE='no')  TRIM( 'Time' )
      
      IF (ALLOCATED( p%OutParam ) .AND. p%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%WriteOutputHdr(I)   ), I=1,p%NumOuts )
      END IF
      
      IF (ALLOCATED( p%Waves2%OutParam ) .AND. p%Waves2%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%Waves2%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%Waves2%WriteOutputHdr(I)   ), I=1,p%Waves2%NumOuts )
      END IF
      
      IF (ALLOCATED( p%Morison%OutParam ) .AND. p%Morison%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%Morison%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%Morison%WriteOutputHdr(I) ), I=1,p%Morison%NumOuts )
      END IF
      
      
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat)          ! write the line return
      

         ! Write the units of the output parameters:
         
     
      Frmt = '(A8)'
      WRITE(p%UnOutFile,Frmt,ADVANCE='no')  TRIM( '(sec)' )
      
      IF (ALLOCATED( p%OutParam ) .AND. p%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%WriteOutputUnt(I)   ), I=1,p%NumOuts )
      END IF

      IF (ALLOCATED( p%Waves2%OutParam ) .AND. p%Waves2%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%Waves2%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%Waves2%WriteOutputUnt(I)   ), I=1,p%Waves2%NumOuts )
      END IF
      
      IF (ALLOCATED( p%Morison%OutParam ) .AND. p%Morison%NumOuts > 0) THEN
         Frmt = '('//TRIM(Int2LStr(p%Morison%NumOuts))//'(:,A,'//TRIM( p%OutSFmt )//'))'
         WRITE(p%UnOutFile,Frmt,ADVANCE='no')   ( p%Delim, TRIM( InitOut%Morison%WriteOutputUnt(I) ), I=1,p%Morison%NumOuts )
      END IF
      
     
      
      WRITE (p%UnOutFile,'()', IOSTAT=ErrStat)          ! write the line return                               
      
      
   
      
   END IF   ! there are any requested outputs   

   RETURN

END SUBROUTINE HDOut_OpenOutput

!====================================================================================================
FUNCTION   HDOut_GetChannels    ( NUserOutputs, UserOutputs, OutList, foundMask, ErrStat, ErrMsg )
! This routine checks the names of inputted output channels, checks to see if they
! below to the list of available Morison channels.

!----------------------------------------------------------------------------------------------------    
   INTEGER,                       INTENT( IN    ) :: NUserOutputs         ! Number of user-specified output channels
   CHARACTER(ChanLen),            INTENT( IN    ) :: UserOutputs (:)      ! An array holding the names of the requested output channels.
   CHARACTER(ChanLen),            INTENT(   OUT ) :: OutList (:)          ! An array holding the names of the matched WAMIT output channels. 
   LOGICAL,                       INTENT( INOUT ) :: foundMask (:)        ! A mask indicating whether a user requested channel belongs to a module's output channels.
   INTEGER,                       INTENT(   OUT ) :: ErrStat              ! a non-zero value indicates an error occurred           
   CHARACTER(*),                  INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None

   INTEGER                                           HDOut_GetChannels     ! The number of channels found in this module

   ! Local variables.
   
   INTEGER                                :: I                                         ! Generic loop-counting index.
   INTEGER                                :: count                                     ! Generic loop-counting index.
   INTEGER                                :: INDX                                      ! Index for valid arrays
   
   CHARACTER(ChanLen)                     :: OutListTmp                                ! A string to temporarily hold OutList(I).
   CHARACTER(28), PARAMETER               :: OutPFmt   = "( I4, 3X,A 10,1 X, A10 )"    ! Output format parameter output list.
   LOGICAL                                :: CheckOutListAgain
   LOGICAL                                :: newFoundMask (NUserOutputs)        ! A mask indicating whether a user requested channel belongs to a module's output channels.
       ! Initialize ErrStat
         
   ErrStat = ErrID_None         
   ErrMsg  = "" 
   HDOut_GetChannels = 0
   
   newFoundMask    = .FALSE.

    DO I = 1,NUserOutputs
      IF (.NOT. foundMask(I) ) THEN
      OutListTmp         = UserOutputs(I)

      CheckOutListAgain  = .FALSE.
      
      ! Reverse the sign (+/-) of the output channel if the user prefixed the
      !   channel name with a '-', '_', 'm', or 'M' character indicating "minus".
      
      
      
      IF      ( INDEX( '-_', OutListTmp(1:1) ) > 0 ) THEN
        
         OutListTmp                   = OutListTmp(2:)
      ELSE IF ( INDEX( 'mM', OutListTmp(1:1) ) > 0 ) THEN ! We'll assume this is a variable name for now, (if not, we will check later if OutListTmp(2:) is also a variable name)
         CheckOutListAgain            = .TRUE.
         
      END IF
      
      CALL Conv2UC( OutListTmp )    ! Convert OutListTmp to upper case
   
   
      Indx =  IndexCharAry( OutListTmp(1:9), ValidParamAry )
      
      IF ( CheckOutListAgain .AND. Indx < 1 ) THEN    ! Let's assume that "M" really meant "minus" and then test again         
           ! ex, 'MTipDxc1' causes the sign of TipDxc1 to be switched.
         OutListTmp                   = OutListTmp(2:)
         
         Indx = IndexCharAry( OutListTmp(1:9), ValidParamAry )         
      END IF
      
      IF ( Indx > 0 ) THEN     
            newFoundMask(I)    = .TRUE.
            foundMask(I)       = .TRUE.
            HDOut_GetChannels = HDOut_GetChannels + 1
        
      !ELSE
      !   foundMask(I) = .FALSE.           
      END IF
    END IF  
END DO
   
IF ( HDOut_GetChannels > 0 ) THEN
   
   count = 1
   
   IF ( ErrStat /= 0 )  THEN
      ErrMsg  = ' Error allocating memory for the OutList array in the GetHydroDynChannels function.'
      ErrStat = ErrID_Fatal
      RETURN
   END IF
   
   DO I = 1,NUserOutputs
      IF ( newFoundMask(I) ) THEN

         OutList(count) = UserOutputs(I)
         count = count + 1
      END IF
      
   END DO
   
END IF

END FUNCTION HDOut_GetChannels

!====================================================================================================
SUBROUTINE HDOut_ChkOutLst( OutList, y, p, ErrStat, ErrMsg )
! This routine checks the names of inputted output channels, checks to see if any of them are ill-
! conditioned (returning an error if so), and assigns the OutputDataType settings (i.e, the index,  
! name, and units of the output channels). 
! Note that the HydroDyn module must be initialized prior to calling this function (if it
! is being used) so that it can correctly determine if the Lines outputs are valid.
!----------------------------------------------------------------------------------------------------    
   
   
   
      ! Passed variables
      
   TYPE(HydroDyn_OutputType),     INTENT( INOUT ) :: y                                ! This module's internal data
   TYPE(HydroDyn_ParameterType),  INTENT( INOUT ) :: p                                   ! parameter data for this instance of the HD module   
!   INTEGER,                 INTENT(IN   ) :: NumMemberNodes(*)                         ! the number of nodes on each of the first 9 members
   CHARACTER(ChanLen),            INTENT( IN    ) :: OutList (:)                               ! An array holding the names of the requested output channels.         
   INTEGER,                       INTENT(   OUT ) :: ErrStat              ! a non-zero value indicates an error occurred           
   CHARACTER(*),                  INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None
   
      ! Local variables.
   
   INTEGER                                :: I                                         ! Generic loop-counting index.
!   INTEGER                                :: J                                         ! Generic loop-counting index.
   INTEGER                                :: INDX                                      ! Index for valid arrays
   
   CHARACTER(ChanLen)                     :: OutListTmp                                ! A string to temporarily hold OutList(I).
   CHARACTER(28), PARAMETER               :: OutPFmt = "( I4, 3X,A 10,1 X, A10 )"      ! Output format parameter output list.
   LOGICAL                                :: InvalidOutput(MaxHDOutputs)               ! This array determines if the output channel is valid for this configuration
   LOGICAL                                :: CheckOutListAgain
    
   !-------------------------------------------------------------------------------------------------
   ! Allocate and set index, name, and units for the output channels
   ! If a selected output channel is not available in this module, set error flag.
   !-------------------------------------------------------------------------------------------------

   ALLOCATE ( p%OutParam(0:p%NumOuts) , STAT=ErrStat )
   IF ( ErrStat /= 0_IntKi )  THEN
      ErrStat = ErrID_Fatal
      ErrMsg  = "Error allocating memory for the HydroDyn OutParam array."
      RETURN
   ELSE
      ErrStat = ErrID_None
      ErrMsg  = ""
   ENDIF

   InvalidOutput = .FALSE.
   

      ! Set index, name, and units for all of the output channels.
      ! If a selected output channel is not available by this module set ErrStat = ErrID_Warn.

   DO I = 1,p%NumOuts

      p%OutParam(I)%Name  = OutList(I)
      OutListTmp          = OutList(I)

      ! Reverse the sign (+/-) of the output channel if the user prefixed the
      !   channel name with a "-", "_", "m", or "M" character indicating "minus".


      CheckOutListAgain = .FALSE.

      IF      ( INDEX( "-_", OutListTmp(1:1) ) > 0 ) THEN
         p%OutParam(I)%SignM = -1                         ! ex, "-TipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)
      ELSE IF ( INDEX( "mM", OutListTmp(1:1) ) > 0 ) THEN ! We'll assume this is a variable name for now, (if not, we will check later if OutListTmp(2:) is also a variable name)
         CheckOutListAgain   = .TRUE.
         p%OutParam(I)%SignM = 1
      ELSE
         p%OutParam(I)%SignM = 1
      END IF

      CALL Conv2UC( OutListTmp )    ! Convert OutListTmp to upper case


      Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )


         ! If it started with an "M" (CheckOutListAgain) we didn't find the value in our list (Indx < 1)

      IF ( CheckOutListAgain .AND. Indx < 1 ) THEN    ! Let's assume that "M" really meant "minus" and then test again
         p%OutParam(I)%SignM = -1                     ! ex, "MTipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)

         Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )
      END IF


      IF ( Indx > 0 ) THEN ! we found the channel name
         p%OutParam(I)%Indx     = ParamIndxAry(Indx)
         IF ( InvalidOutput( ParamIndxAry(Indx) ) ) THEN  ! but, it isn't valid for these settings
            p%OutParam(I)%Units = "INVALID"
            p%OutParam(I)%SignM = 0
         ELSE
            p%OutParam(I)%Units = ParamUnitsAry(Indx) ! it's a valid output
         END IF
      ELSE ! this channel isn't valid
         p%OutParam(I)%Indx  = 1                 ! pick any valid channel 
         p%OutParam(I)%Units = "INVALID"
         p%OutParam(I)%SignM = 0                    ! multiply all results by zero

         ErrStat = ErrID_Warn
         ErrMsg  = p%OutParam(I)%Name//" is not an available output channel. "//TRIM(ErrMsg)
      END IF

   END DO

   RETURN
   
END SUBROUTINE HDOut_ChkOutLst


!====================================================================================================
SUBROUTINE HDOut_CloseOutput ( p, ErrStat, ErrMsg )
! This function cleans up after running the HydroDyn output module. It closes the output file,
! releases memory, and resets the number of outputs requested to 0.
!----------------------------------------------------------------------------------------------------

         ! Passed variables

   TYPE(HydroDyn_ParameterType),  INTENT( INOUT ) :: p                    ! parameter data for this instance of the HydroDyn module        
   INTEGER,                       INTENT(   OUT ) :: ErrStat              ! a non-zero value indicates an error occurred           
   CHARACTER(*),                  INTENT(   OUT ) :: ErrMsg               ! Error message if ErrStat /= ErrID_None

!      ! Internal variables
   LOGICAL                               :: Err


   !-------------------------------------------------------------------------------------------------
   ! Initialize error information
   !-------------------------------------------------------------------------------------------------
      
         
   ErrStat = ErrID_None         
   ErrMsg  = ""    
      
   Err     = .FALSE.

         ! Write the summary file header
   IF ( p%UnOutFile > -1 ) THEN   
      ! WRITE (p%UnOutFile,'(/,A/)', IOSTAT=ErrStat)  'This output file was closed on '//CurDate()//' at '//CurTime()//'.'
   
   !-------------------------------------------------------------------------------------------------
   ! Close our output file
   !-------------------------------------------------------------------------------------------------
      CLOSE( p%UnOutFile, IOSTAT = ErrStat )
      IF ( ErrStat /= 0 ) Err = .TRUE.

   END IF
 
   !-------------------------------------------------------------------------------------------------
   ! Make sure ErrStat is non-zero if an error occurred
   !-------------------------------------------------------------------------------------------------
   IF ( Err ) THEN
      ErrStat = ErrID_Fatal
      ErrMsg  = ' Error closing HydroDyn output file.'
   END IF
   
   RETURN

END SUBROUTINE HDOut_CloseOutput
!====================================================================================================


!====================================================================================================
END MODULE HydroDyn_Output
