!STARTOFREGISTRYGENERATEDFILE 'FEAMooring_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FEAMooring_Types
!.................................................................................................................................
! This file is part of FEAMooring.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FEAMooring. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FEAMooring_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
! =========  FEAM_InputFile  =======
  TYPE, PUBLIC :: FEAM_InputFile
    REAL(DbKi)  :: DT      !< Communication interval for mooring dynamics [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCI      !< Mooring line inertia coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCD      !< Mooring line drag coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LEAStiff      !< Mooring line axial stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LMassDen      !< Mooring line mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDMassDen      !< Mooring line displaced mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmStiff      !< Seabed spring stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LRadAnch      !< Anchor Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAngAnch      !< Anchor Angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDpthAnch      !< Anchor Depth [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LRadFair      !< Fairlead Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAngFair      !< Fairlead Radius [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDrftFair      !< Fairlead Draft [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LUnstrLen      !< Line unstretched length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Tension      !< Line Top Tension [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GSL      !< Linear spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GSR      !< Rotational spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GE      !< Reference tangent vector at fairlead [-]
    INTEGER(IntKi)  :: NumLines      !< Number of lines [-]
    INTEGER(IntKi)  :: NumElems      !< Number of elements [-]
    REAL(ReKi)  :: Eps      !< Tolerance for static iteration [-]
    REAL(ReKi)  :: Gravity      !< Gravity [-]
    REAL(ReKi)  :: WtrDens      !< Water density [-]
    INTEGER(IntKi)  :: MaxIter      !< Maximum number of iteration step for static analysis [-]
    LOGICAL  :: SumPrint      !< Print summary data to <RootName>.fsm? [-]
    INTEGER(IntKi)  :: OutFile      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim      !< Use tab delimiters in text tabular output file? [-]
    CHARACTER(20)  :: OutFmt      !< Format used for text tabular output (except time) [-]
    REAL(DbKi)  :: Tstart      !< Time to start module's tabular output [s]
    INTEGER(IntKi)  :: NumOuts      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
  END TYPE FEAM_InputFile
! =======================
! =========  FEAM_InitInputType  =======
  TYPE, PUBLIC :: FEAM_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PtfmInit      !< Platform Initial Position [-]
    INTEGER(IntKi)  :: NStepWave      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc0      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel0      !<  [-]
    REAL(ReKi)  :: Gravity      !< Gravity [-]
    REAL(ReKi)  :: WtrDens      !< Water density [-]
  END TYPE FEAM_InitInputType
! =======================
! =========  FEAM_InitOutputType  =======
  TYPE, PUBLIC :: FEAM_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchxi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchyi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LAnchzi      !< Anchor coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairxt      !< Fairlead coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairyt      !< Fairlead coordinate [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LFairzt      !< Fairlead coordinate [-]
  END TYPE FEAM_InitOutputType
! =======================
! =========  FEAM_ContinuousStateType  =======
  TYPE, PUBLIC :: FEAM_ContinuousStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLU      !< Global matrix U (displacement) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLDU      !< Global matrix DU (velocity) [-]
  END TYPE FEAM_ContinuousStateType
! =======================
! =========  FEAM_DiscreteStateType  =======
  TYPE, PUBLIC :: FEAM_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState      !< Remove this variable if you have discrete states [-]
  END TYPE FEAM_DiscreteStateType
! =======================
! =========  FEAM_ConstraintStateType  =======
  TYPE, PUBLIC :: FEAM_ConstraintStateType
    REAL(ReKi) , DIMENSION(1:3)  :: TSN      !< Lagrangian multiplier [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TZER      !< Lagrangian multiplier [-]
  END TYPE FEAM_ConstraintStateType
! =======================
! =========  FEAM_OtherStateType  =======
  TYPE, PUBLIC :: FEAM_OtherStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLU0      !< Global matrix U0 (previous state) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLDDU      !< Global matrix DDU (accleration) -- other state [-]
    LOGICAL  :: BottomTouch      !< Bottom touch flag [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GFORC0      !< Old element force matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: GMASS0      !< Old element mass matrix [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_FPA      !< Fairlead position - inputs from previous time step (we should replace this with a call to extrap-interp) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_RP      !< Fairlead tangent - part of output computation that was calculated in UpdateStates [-]
    INTEGER(IntKi)  :: INCR      !< FEAM step [-]
    REAL(ReKi) , DIMENSION(1:15)  :: RSDF      !< Line residue force - modifies values from previous call to FEAM_Solve [-]
    REAL(ReKi) , DIMENSION(1:15)  :: FORC0      !< - [Local old element force matrix]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: EMAS0      !< Local old element mass matrix [-]
  END TYPE FEAM_OtherStateType
! =======================
! =========  FEAM_MiscVarType  =======
  TYPE, PUBLIC :: FEAM_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GLF      !< Global forcing matrix [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GLK      !< Global stiffness matrix [-]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: EMASS      !< Line element mass [-]
    REAL(ReKi) , DIMENSION(1:15,1:15)  :: ESTIF      !< Line element stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAST_FP      !< Fairlead position at t+dt [-]
    REAL(ReKi) , DIMENSION(1:15)  :: FORCE      !< Line external force [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FP      !< Fairlead position - used in Couple routine [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: U      !< Local matrix U [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: U0      !< Local matrix U0 [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: DU      !< Local matrix DU [-]
    REAL(ReKi) , DIMENSION(1:3,1:4)  :: DDU      !< Local matrix DDU [-]
    REAL(ReKi) , DIMENSION(1:3)  :: R      !< POSITION VECTOR OF NODE OF ROD ELEMENT [-]
    REAL(ReKi) , DIMENSION(1:3)  :: RP      !< DR/DS AT R (TANGENT - NEED NOT BE UNIT VECTOR) [-]
    REAL(ReKi) , DIMENSION(1:6)  :: RHSR      !< RIGHT HAND SIDE CONTRIBUTION TO 6 DEGREES OF FREEDOM OF ROD NODE [-]
    REAL(ReKi) , DIMENSION(1:3)  :: SLIN      !< LINEAR SPRING CONSTANT - portion of p%GSL [(UNITS OF FORCE/LENGTH)]
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: STIFR      !< STIFFNESS COEFFICIENTS FOR 6 DEGREES OF FREEDOM OF ROD NODE (X,DX/DS,Y,DY/DS,Z,DZ/DS) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FAIR_ANG      !< Fairlead angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FAIR_T      !< Fairlead tension [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: ANCH_ANG      !< Anchor angle [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ANCH_T      !< Anchor tension [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Line_Coordinate      !< Mooring line coordinate [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Line_Tangent      !< Mooring line tangent vector [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F_Lines      !< Mooring restoring force [-]
    INTEGER(IntKi)  :: LastIndWave      !< FEAM step [-]
  END TYPE FEAM_MiscVarType
! =======================
! =========  FEAM_ParameterType  =======
  TYPE, PUBLIC :: FEAM_ParameterType
    REAL(DbKi)  :: DT      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(ReKi) , DIMENSION(1:3)  :: GRAV      !< Gravity [-]
    REAL(ReKi)  :: Eps      !< Tolerance for static iteration [-]
    REAL(ReKi)  :: Gravity      !< Gravity [-]
    REAL(ReKi)  :: WtrDens      !< Water density [-]
    INTEGER(IntKi)  :: MaxIter      !< Maximum number of iteration step for static analysis [-]
    INTEGER(IntKi)  :: NHBD      !< Bandwidth = (NBAND+1)/2 [-]
    INTEGER(IntKi)  :: NDIM      !< Dimension = 3 [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NEQ      !< Number of equation [-]
    INTEGER(IntKi)  :: NBAND      !< Bandwidth [-]
    INTEGER(IntKi)  :: NumLines      !< Number of lines [-]
    INTEGER(IntKi)  :: NumElems      !< Number of elements [-]
    INTEGER(IntKi)  :: NumNodes      !< Number of nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GSL      !< Linear spring stiffness at fairlead [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GP      !< Fairlead position [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Elength      !< Element length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmElev      !< Bottom elevation [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BottmStiff      !< Bottom stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LMassDen      !< Line mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LDMassDen      !< Line displaced mass per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LEAStiff      !< Line axial stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCI      !< Line inertia coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LineCD      !< Line drag coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Bvp      !< Boundary condtion [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveAcc0      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WaveTime      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: WaveVel0      !<  [-]
    INTEGER(IntKi)  :: NStepWave      !< Number of wave steps [-]
    REAL(ReKi) , DIMENSION(1:6,1:4)  :: SHAP      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:6,1:4)  :: SHAPS      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:6)  :: GAUSSW      !< Shape function [-]
    INTEGER(IntKi)  :: NGAUSS      !< 6 POINT GAUSSIAN QUADRATURE INTEGRATION [-]
    REAL(ReKi) , DIMENSION(1:10,1:4)  :: SHAPT      !< Shape function [-]
    REAL(ReKi) , DIMENSION(1:10,1:4)  :: SHAPTS      !< Shape function [-]
    INTEGER(IntKi)  :: NTRAP      !< 10 TRANPEZOIDE INTEGRATION point [-]
    REAL(ReKi) , DIMENSION(1:4,1:4)  :: SBEND      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:4,1:4)  :: STEN      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4,1:4)  :: RMASS      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4,1:4,1:4,1:4)  :: RADDM      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: PMPN      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:4)  :: AM      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3)  :: PM      !< Internal [-]
    INTEGER(IntKi) , DIMENSION(1:3,1:4)  :: IDOF      !< Internal [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: JDOF      !< Internal [-]
    REAL(ReKi) , DIMENSION(1:3,1:3,1:4)  :: PPA      !< Internal [-]
    REAL(ReKi)  :: PtfmRefzt      !< Platform reference [-]
    INTEGER(IntKi)  :: NumOuts      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: GLUZR      !< Line coordinate & direction cosine [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: GTZER      !< Line tension [-]
  END TYPE FEAM_ParameterType
! =======================
! =========  FEAM_InputType  =======
  TYPE, PUBLIC :: FEAM_InputType
    TYPE(MeshType)  :: HydroForceLineMesh      !< Meshed input data [-]
    TYPE(MeshType)  :: PtFairleadDisplacement      !< Meshed input data [-]
  END TYPE FEAM_InputType
! =======================
! =========  FEAM_OutputType  =======
  TYPE, PUBLIC :: FEAM_OutputType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    TYPE(MeshType)  :: PtFairleadLoad      !< Meshed output data [-]
    TYPE(MeshType)  :: LineMeshPosition      !< Meshed output data [-]
  END TYPE FEAM_OutputType
! =======================
CONTAINS
 SUBROUTINE FEAM_CopyInputFile( SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_InputFile), INTENT(IN) :: SrcInputFileData
   TYPE(FEAM_InputFile), INTENT(INOUT) :: DstInputFileData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyInputFile'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileData%DT = SrcInputFileData%DT
IF (ALLOCATED(SrcInputFileData%LineCI)) THEN
  i1_l = LBOUND(SrcInputFileData%LineCI,1)
  i1_u = UBOUND(SrcInputFileData%LineCI,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LineCI)) THEN 
    ALLOCATE(DstInputFileData%LineCI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LineCI.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LineCI = SrcInputFileData%LineCI
ENDIF
IF (ALLOCATED(SrcInputFileData%LineCD)) THEN
  i1_l = LBOUND(SrcInputFileData%LineCD,1)
  i1_u = UBOUND(SrcInputFileData%LineCD,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LineCD)) THEN 
    ALLOCATE(DstInputFileData%LineCD(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LineCD.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LineCD = SrcInputFileData%LineCD
ENDIF
IF (ALLOCATED(SrcInputFileData%LEAStiff)) THEN
  i1_l = LBOUND(SrcInputFileData%LEAStiff,1)
  i1_u = UBOUND(SrcInputFileData%LEAStiff,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LEAStiff)) THEN 
    ALLOCATE(DstInputFileData%LEAStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LEAStiff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LEAStiff = SrcInputFileData%LEAStiff
ENDIF
IF (ALLOCATED(SrcInputFileData%LMassDen)) THEN
  i1_l = LBOUND(SrcInputFileData%LMassDen,1)
  i1_u = UBOUND(SrcInputFileData%LMassDen,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LMassDen)) THEN 
    ALLOCATE(DstInputFileData%LMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LMassDen = SrcInputFileData%LMassDen
ENDIF
IF (ALLOCATED(SrcInputFileData%LDMassDen)) THEN
  i1_l = LBOUND(SrcInputFileData%LDMassDen,1)
  i1_u = UBOUND(SrcInputFileData%LDMassDen,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LDMassDen)) THEN 
    ALLOCATE(DstInputFileData%LDMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LDMassDen = SrcInputFileData%LDMassDen
ENDIF
IF (ALLOCATED(SrcInputFileData%BottmStiff)) THEN
  i1_l = LBOUND(SrcInputFileData%BottmStiff,1)
  i1_u = UBOUND(SrcInputFileData%BottmStiff,1)
  IF (.NOT. ALLOCATED(DstInputFileData%BottmStiff)) THEN 
    ALLOCATE(DstInputFileData%BottmStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BottmStiff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%BottmStiff = SrcInputFileData%BottmStiff
ENDIF
IF (ALLOCATED(SrcInputFileData%LRadAnch)) THEN
  i1_l = LBOUND(SrcInputFileData%LRadAnch,1)
  i1_u = UBOUND(SrcInputFileData%LRadAnch,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LRadAnch)) THEN 
    ALLOCATE(DstInputFileData%LRadAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LRadAnch.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LRadAnch = SrcInputFileData%LRadAnch
ENDIF
IF (ALLOCATED(SrcInputFileData%LAngAnch)) THEN
  i1_l = LBOUND(SrcInputFileData%LAngAnch,1)
  i1_u = UBOUND(SrcInputFileData%LAngAnch,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LAngAnch)) THEN 
    ALLOCATE(DstInputFileData%LAngAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LAngAnch.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LAngAnch = SrcInputFileData%LAngAnch
ENDIF
IF (ALLOCATED(SrcInputFileData%LDpthAnch)) THEN
  i1_l = LBOUND(SrcInputFileData%LDpthAnch,1)
  i1_u = UBOUND(SrcInputFileData%LDpthAnch,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LDpthAnch)) THEN 
    ALLOCATE(DstInputFileData%LDpthAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDpthAnch.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LDpthAnch = SrcInputFileData%LDpthAnch
ENDIF
IF (ALLOCATED(SrcInputFileData%LRadFair)) THEN
  i1_l = LBOUND(SrcInputFileData%LRadFair,1)
  i1_u = UBOUND(SrcInputFileData%LRadFair,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LRadFair)) THEN 
    ALLOCATE(DstInputFileData%LRadFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LRadFair.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LRadFair = SrcInputFileData%LRadFair
ENDIF
IF (ALLOCATED(SrcInputFileData%LAngFair)) THEN
  i1_l = LBOUND(SrcInputFileData%LAngFair,1)
  i1_u = UBOUND(SrcInputFileData%LAngFair,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LAngFair)) THEN 
    ALLOCATE(DstInputFileData%LAngFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LAngFair.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LAngFair = SrcInputFileData%LAngFair
ENDIF
IF (ALLOCATED(SrcInputFileData%LDrftFair)) THEN
  i1_l = LBOUND(SrcInputFileData%LDrftFair,1)
  i1_u = UBOUND(SrcInputFileData%LDrftFair,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LDrftFair)) THEN 
    ALLOCATE(DstInputFileData%LDrftFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LDrftFair.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LDrftFair = SrcInputFileData%LDrftFair
ENDIF
IF (ALLOCATED(SrcInputFileData%LUnstrLen)) THEN
  i1_l = LBOUND(SrcInputFileData%LUnstrLen,1)
  i1_u = UBOUND(SrcInputFileData%LUnstrLen,1)
  IF (.NOT. ALLOCATED(DstInputFileData%LUnstrLen)) THEN 
    ALLOCATE(DstInputFileData%LUnstrLen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%LUnstrLen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%LUnstrLen = SrcInputFileData%LUnstrLen
ENDIF
IF (ALLOCATED(SrcInputFileData%Tension)) THEN
  i1_l = LBOUND(SrcInputFileData%Tension,1)
  i1_u = UBOUND(SrcInputFileData%Tension,1)
  IF (.NOT. ALLOCATED(DstInputFileData%Tension)) THEN 
    ALLOCATE(DstInputFileData%Tension(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Tension.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Tension = SrcInputFileData%Tension
ENDIF
IF (ALLOCATED(SrcInputFileData%GSL)) THEN
  i1_l = LBOUND(SrcInputFileData%GSL,1)
  i1_u = UBOUND(SrcInputFileData%GSL,1)
  i2_l = LBOUND(SrcInputFileData%GSL,2)
  i2_u = UBOUND(SrcInputFileData%GSL,2)
  i3_l = LBOUND(SrcInputFileData%GSL,3)
  i3_u = UBOUND(SrcInputFileData%GSL,3)
  IF (.NOT. ALLOCATED(DstInputFileData%GSL)) THEN 
    ALLOCATE(DstInputFileData%GSL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GSL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%GSL = SrcInputFileData%GSL
ENDIF
IF (ALLOCATED(SrcInputFileData%GSR)) THEN
  i1_l = LBOUND(SrcInputFileData%GSR,1)
  i1_u = UBOUND(SrcInputFileData%GSR,1)
  i2_l = LBOUND(SrcInputFileData%GSR,2)
  i2_u = UBOUND(SrcInputFileData%GSR,2)
  IF (.NOT. ALLOCATED(DstInputFileData%GSR)) THEN 
    ALLOCATE(DstInputFileData%GSR(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GSR.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%GSR = SrcInputFileData%GSR
ENDIF
IF (ALLOCATED(SrcInputFileData%GE)) THEN
  i1_l = LBOUND(SrcInputFileData%GE,1)
  i1_u = UBOUND(SrcInputFileData%GE,1)
  i2_l = LBOUND(SrcInputFileData%GE,2)
  i2_u = UBOUND(SrcInputFileData%GE,2)
  i3_l = LBOUND(SrcInputFileData%GE,3)
  i3_u = UBOUND(SrcInputFileData%GE,3)
  IF (.NOT. ALLOCATED(DstInputFileData%GE)) THEN 
    ALLOCATE(DstInputFileData%GE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%GE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%GE = SrcInputFileData%GE
ENDIF
    DstInputFileData%NumLines = SrcInputFileData%NumLines
    DstInputFileData%NumElems = SrcInputFileData%NumElems
    DstInputFileData%Eps = SrcInputFileData%Eps
    DstInputFileData%Gravity = SrcInputFileData%Gravity
    DstInputFileData%WtrDens = SrcInputFileData%WtrDens
    DstInputFileData%MaxIter = SrcInputFileData%MaxIter
    DstInputFileData%SumPrint = SrcInputFileData%SumPrint
    DstInputFileData%OutFile = SrcInputFileData%OutFile
    DstInputFileData%TabDelim = SrcInputFileData%TabDelim
    DstInputFileData%OutFmt = SrcInputFileData%OutFmt
    DstInputFileData%Tstart = SrcInputFileData%Tstart
    DstInputFileData%NumOuts = SrcInputFileData%NumOuts
IF (ALLOCATED(SrcInputFileData%OutList)) THEN
  i1_l = LBOUND(SrcInputFileData%OutList,1)
  i1_u = UBOUND(SrcInputFileData%OutList,1)
  IF (.NOT. ALLOCATED(DstInputFileData%OutList)) THEN 
    ALLOCATE(DstInputFileData%OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%OutList = SrcInputFileData%OutList
ENDIF
 END SUBROUTINE FEAM_CopyInputFile

 SUBROUTINE FEAM_DestroyInputFile( InputFileData, ErrStat, ErrMsg )
  TYPE(FEAM_InputFile), INTENT(INOUT) :: InputFileData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyInputFile'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputFileData%LineCI)) THEN
  DEALLOCATE(InputFileData%LineCI)
ENDIF
IF (ALLOCATED(InputFileData%LineCD)) THEN
  DEALLOCATE(InputFileData%LineCD)
ENDIF
IF (ALLOCATED(InputFileData%LEAStiff)) THEN
  DEALLOCATE(InputFileData%LEAStiff)
ENDIF
IF (ALLOCATED(InputFileData%LMassDen)) THEN
  DEALLOCATE(InputFileData%LMassDen)
ENDIF
IF (ALLOCATED(InputFileData%LDMassDen)) THEN
  DEALLOCATE(InputFileData%LDMassDen)
ENDIF
IF (ALLOCATED(InputFileData%BottmStiff)) THEN
  DEALLOCATE(InputFileData%BottmStiff)
ENDIF
IF (ALLOCATED(InputFileData%LRadAnch)) THEN
  DEALLOCATE(InputFileData%LRadAnch)
ENDIF
IF (ALLOCATED(InputFileData%LAngAnch)) THEN
  DEALLOCATE(InputFileData%LAngAnch)
ENDIF
IF (ALLOCATED(InputFileData%LDpthAnch)) THEN
  DEALLOCATE(InputFileData%LDpthAnch)
ENDIF
IF (ALLOCATED(InputFileData%LRadFair)) THEN
  DEALLOCATE(InputFileData%LRadFair)
ENDIF
IF (ALLOCATED(InputFileData%LAngFair)) THEN
  DEALLOCATE(InputFileData%LAngFair)
ENDIF
IF (ALLOCATED(InputFileData%LDrftFair)) THEN
  DEALLOCATE(InputFileData%LDrftFair)
ENDIF
IF (ALLOCATED(InputFileData%LUnstrLen)) THEN
  DEALLOCATE(InputFileData%LUnstrLen)
ENDIF
IF (ALLOCATED(InputFileData%Tension)) THEN
  DEALLOCATE(InputFileData%Tension)
ENDIF
IF (ALLOCATED(InputFileData%GSL)) THEN
  DEALLOCATE(InputFileData%GSL)
ENDIF
IF (ALLOCATED(InputFileData%GSR)) THEN
  DEALLOCATE(InputFileData%GSR)
ENDIF
IF (ALLOCATED(InputFileData%GE)) THEN
  DEALLOCATE(InputFileData%GE)
ENDIF
IF (ALLOCATED(InputFileData%OutList)) THEN
  DEALLOCATE(InputFileData%OutList)
ENDIF
 END SUBROUTINE FEAM_DestroyInputFile

 SUBROUTINE FEAM_PackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_InputFile),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackInputFile'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
  Int_BufSz   = Int_BufSz   + 1     ! LineCI allocated yes/no
  IF ( ALLOCATED(InData%LineCI) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LineCI upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LineCI)  ! LineCI
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LineCD allocated yes/no
  IF ( ALLOCATED(InData%LineCD) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LineCD upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LineCD)  ! LineCD
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LEAStiff allocated yes/no
  IF ( ALLOCATED(InData%LEAStiff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LEAStiff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LEAStiff)  ! LEAStiff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LMassDen allocated yes/no
  IF ( ALLOCATED(InData%LMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LMassDen)  ! LMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LDMassDen allocated yes/no
  IF ( ALLOCATED(InData%LDMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LDMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LDMassDen)  ! LDMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BottmStiff allocated yes/no
  IF ( ALLOCATED(InData%BottmStiff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BottmStiff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BottmStiff)  ! BottmStiff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LRadAnch allocated yes/no
  IF ( ALLOCATED(InData%LRadAnch) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LRadAnch upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LRadAnch)  ! LRadAnch
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LAngAnch allocated yes/no
  IF ( ALLOCATED(InData%LAngAnch) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LAngAnch upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LAngAnch)  ! LAngAnch
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LDpthAnch allocated yes/no
  IF ( ALLOCATED(InData%LDpthAnch) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LDpthAnch upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LDpthAnch)  ! LDpthAnch
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LRadFair allocated yes/no
  IF ( ALLOCATED(InData%LRadFair) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LRadFair upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LRadFair)  ! LRadFair
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LAngFair allocated yes/no
  IF ( ALLOCATED(InData%LAngFair) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LAngFair upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LAngFair)  ! LAngFair
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LDrftFair allocated yes/no
  IF ( ALLOCATED(InData%LDrftFair) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LDrftFair upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LDrftFair)  ! LDrftFair
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LUnstrLen allocated yes/no
  IF ( ALLOCATED(InData%LUnstrLen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LUnstrLen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LUnstrLen)  ! LUnstrLen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Tension allocated yes/no
  IF ( ALLOCATED(InData%Tension) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Tension upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Tension)  ! Tension
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GSL allocated yes/no
  IF ( ALLOCATED(InData%GSL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GSL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GSL)  ! GSL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GSR allocated yes/no
  IF ( ALLOCATED(InData%GSR) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GSR upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GSR)  ! GSR
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GE allocated yes/no
  IF ( ALLOCATED(InData%GE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GE)  ! GE
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumLines
      Int_BufSz  = Int_BufSz  + 1  ! NumElems
      Re_BufSz   = Re_BufSz   + 1  ! Eps
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
      Int_BufSz  = Int_BufSz  + 1  ! MaxIter
      Int_BufSz  = Int_BufSz  + 1  ! SumPrint
      Int_BufSz  = Int_BufSz  + 1  ! OutFile
      Int_BufSz  = Int_BufSz  + 1  ! TabDelim
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFmt)  ! OutFmt
      Db_BufSz   = Db_BufSz   + 1  ! Tstart
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
  Int_BufSz   = Int_BufSz   + 1     ! OutList allocated yes/no
  IF ( ALLOCATED(InData%OutList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%OutList)*LEN(InData%OutList)  ! OutList
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%LineCI) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LineCI,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LineCI,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LineCI,1), UBOUND(InData%LineCI,1)
        ReKiBuf(Re_Xferred) = InData%LineCI(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LineCD) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LineCD,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LineCD,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LineCD,1), UBOUND(InData%LineCD,1)
        ReKiBuf(Re_Xferred) = InData%LineCD(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LEAStiff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LEAStiff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LEAStiff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LEAStiff,1), UBOUND(InData%LEAStiff,1)
        ReKiBuf(Re_Xferred) = InData%LEAStiff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LMassDen,1), UBOUND(InData%LMassDen,1)
        ReKiBuf(Re_Xferred) = InData%LMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LDMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LDMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LDMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LDMassDen,1), UBOUND(InData%LDMassDen,1)
        ReKiBuf(Re_Xferred) = InData%LDMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BottmStiff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BottmStiff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BottmStiff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BottmStiff,1), UBOUND(InData%BottmStiff,1)
        ReKiBuf(Re_Xferred) = InData%BottmStiff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LRadAnch) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LRadAnch,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LRadAnch,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LRadAnch,1), UBOUND(InData%LRadAnch,1)
        ReKiBuf(Re_Xferred) = InData%LRadAnch(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LAngAnch) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LAngAnch,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LAngAnch,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LAngAnch,1), UBOUND(InData%LAngAnch,1)
        ReKiBuf(Re_Xferred) = InData%LAngAnch(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LDpthAnch) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LDpthAnch,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LDpthAnch,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LDpthAnch,1), UBOUND(InData%LDpthAnch,1)
        ReKiBuf(Re_Xferred) = InData%LDpthAnch(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LRadFair) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LRadFair,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LRadFair,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LRadFair,1), UBOUND(InData%LRadFair,1)
        ReKiBuf(Re_Xferred) = InData%LRadFair(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LAngFair) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LAngFair,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LAngFair,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LAngFair,1), UBOUND(InData%LAngFair,1)
        ReKiBuf(Re_Xferred) = InData%LAngFair(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LDrftFair) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LDrftFair,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LDrftFair,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LDrftFair,1), UBOUND(InData%LDrftFair,1)
        ReKiBuf(Re_Xferred) = InData%LDrftFair(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LUnstrLen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LUnstrLen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LUnstrLen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LUnstrLen,1), UBOUND(InData%LUnstrLen,1)
        ReKiBuf(Re_Xferred) = InData%LUnstrLen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Tension) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Tension,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Tension,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Tension,1), UBOUND(InData%Tension,1)
        ReKiBuf(Re_Xferred) = InData%Tension(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GSL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GSL,3), UBOUND(InData%GSL,3)
        DO i2 = LBOUND(InData%GSL,2), UBOUND(InData%GSL,2)
          DO i1 = LBOUND(InData%GSL,1), UBOUND(InData%GSL,1)
            ReKiBuf(Re_Xferred) = InData%GSL(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GSR) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSR,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSR,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSR,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSR,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GSR,2), UBOUND(InData%GSR,2)
        DO i1 = LBOUND(InData%GSR,1), UBOUND(InData%GSR,1)
          ReKiBuf(Re_Xferred) = InData%GSR(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GE,3), UBOUND(InData%GE,3)
        DO i2 = LBOUND(InData%GE,2), UBOUND(InData%GE,2)
          DO i1 = LBOUND(InData%GE,1), UBOUND(InData%GE,1)
            ReKiBuf(Re_Xferred) = InData%GE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NumLines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumElems
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Eps
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MaxIter
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%SumPrint, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%OutFile
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TabDelim, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DbKiBuf(Db_Xferred) = InData%Tstart
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutList,1), UBOUND(InData%OutList,1)
        DO I = 1, LEN(InData%OutList)
          IntKiBuf(Int_Xferred) = ICHAR(InData%OutList(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE FEAM_PackInputFile

 SUBROUTINE FEAM_UnPackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_InputFile), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackInputFile'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LineCI not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LineCI)) DEALLOCATE(OutData%LineCI)
    ALLOCATE(OutData%LineCI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineCI.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LineCI,1), UBOUND(OutData%LineCI,1)
        OutData%LineCI(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LineCD not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LineCD)) DEALLOCATE(OutData%LineCD)
    ALLOCATE(OutData%LineCD(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineCD.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LineCD,1), UBOUND(OutData%LineCD,1)
        OutData%LineCD(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LEAStiff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LEAStiff)) DEALLOCATE(OutData%LEAStiff)
    ALLOCATE(OutData%LEAStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LEAStiff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LEAStiff,1), UBOUND(OutData%LEAStiff,1)
        OutData%LEAStiff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LMassDen)) DEALLOCATE(OutData%LMassDen)
    ALLOCATE(OutData%LMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LMassDen,1), UBOUND(OutData%LMassDen,1)
        OutData%LMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LDMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LDMassDen)) DEALLOCATE(OutData%LDMassDen)
    ALLOCATE(OutData%LDMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LDMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LDMassDen,1), UBOUND(OutData%LDMassDen,1)
        OutData%LDMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BottmStiff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BottmStiff)) DEALLOCATE(OutData%BottmStiff)
    ALLOCATE(OutData%BottmStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BottmStiff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BottmStiff,1), UBOUND(OutData%BottmStiff,1)
        OutData%BottmStiff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LRadAnch not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LRadAnch)) DEALLOCATE(OutData%LRadAnch)
    ALLOCATE(OutData%LRadAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LRadAnch.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LRadAnch,1), UBOUND(OutData%LRadAnch,1)
        OutData%LRadAnch(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LAngAnch not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LAngAnch)) DEALLOCATE(OutData%LAngAnch)
    ALLOCATE(OutData%LAngAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LAngAnch.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LAngAnch,1), UBOUND(OutData%LAngAnch,1)
        OutData%LAngAnch(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LDpthAnch not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LDpthAnch)) DEALLOCATE(OutData%LDpthAnch)
    ALLOCATE(OutData%LDpthAnch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LDpthAnch.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LDpthAnch,1), UBOUND(OutData%LDpthAnch,1)
        OutData%LDpthAnch(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LRadFair not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LRadFair)) DEALLOCATE(OutData%LRadFair)
    ALLOCATE(OutData%LRadFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LRadFair.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LRadFair,1), UBOUND(OutData%LRadFair,1)
        OutData%LRadFair(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LAngFair not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LAngFair)) DEALLOCATE(OutData%LAngFair)
    ALLOCATE(OutData%LAngFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LAngFair.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LAngFair,1), UBOUND(OutData%LAngFair,1)
        OutData%LAngFair(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LDrftFair not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LDrftFair)) DEALLOCATE(OutData%LDrftFair)
    ALLOCATE(OutData%LDrftFair(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LDrftFair.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LDrftFair,1), UBOUND(OutData%LDrftFair,1)
        OutData%LDrftFair(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LUnstrLen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LUnstrLen)) DEALLOCATE(OutData%LUnstrLen)
    ALLOCATE(OutData%LUnstrLen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LUnstrLen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LUnstrLen,1), UBOUND(OutData%LUnstrLen,1)
        OutData%LUnstrLen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Tension not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Tension)) DEALLOCATE(OutData%Tension)
    ALLOCATE(OutData%Tension(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Tension.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Tension,1), UBOUND(OutData%Tension,1)
        OutData%Tension(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GSL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GSL)) DEALLOCATE(OutData%GSL)
    ALLOCATE(OutData%GSL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GSL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GSL,3), UBOUND(OutData%GSL,3)
        DO i2 = LBOUND(OutData%GSL,2), UBOUND(OutData%GSL,2)
          DO i1 = LBOUND(OutData%GSL,1), UBOUND(OutData%GSL,1)
            OutData%GSL(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GSR not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GSR)) DEALLOCATE(OutData%GSR)
    ALLOCATE(OutData%GSR(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GSR.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GSR,2), UBOUND(OutData%GSR,2)
        DO i1 = LBOUND(OutData%GSR,1), UBOUND(OutData%GSR,1)
          OutData%GSR(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GE)) DEALLOCATE(OutData%GE)
    ALLOCATE(OutData%GE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GE,3), UBOUND(OutData%GE,3)
        DO i2 = LBOUND(OutData%GE,2), UBOUND(OutData%GE,2)
          DO i1 = LBOUND(OutData%GE,1), UBOUND(OutData%GE,1)
            OutData%GE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%NumLines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumElems = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Eps = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MaxIter = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%SumPrint = TRANSFER(IntKiBuf(Int_Xferred), OutData%SumPrint)
    Int_Xferred = Int_Xferred + 1
    OutData%OutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TabDelim = TRANSFER(IntKiBuf(Int_Xferred), OutData%TabDelim)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFmt)
      OutData%OutFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%Tstart = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutList)) DEALLOCATE(OutData%OutList)
    ALLOCATE(OutData%OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutList,1), UBOUND(OutData%OutList,1)
        DO I = 1, LEN(OutData%OutList)
          OutData%OutList(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE FEAM_UnPackInputFile

 SUBROUTINE FEAM_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(FEAM_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%InputFile = SrcInitInputData%InputFile
    DstInitInputData%RootName = SrcInitInputData%RootName
    DstInitInputData%PtfmInit = SrcInitInputData%PtfmInit
    DstInitInputData%NStepWave = SrcInitInputData%NStepWave
IF (ALLOCATED(SrcInitInputData%WaveAcc0)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveAcc0,1)
  i1_u = UBOUND(SrcInitInputData%WaveAcc0,1)
  i2_l = LBOUND(SrcInitInputData%WaveAcc0,2)
  i2_u = UBOUND(SrcInitInputData%WaveAcc0,2)
  i3_l = LBOUND(SrcInitInputData%WaveAcc0,3)
  i3_u = UBOUND(SrcInitInputData%WaveAcc0,3)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveAcc0)) THEN 
    ALLOCATE(DstInitInputData%WaveAcc0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveAcc0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveAcc0 = SrcInitInputData%WaveAcc0
ENDIF
IF (ALLOCATED(SrcInitInputData%WaveTime)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveTime,1)
  i1_u = UBOUND(SrcInitInputData%WaveTime,1)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveTime)) THEN 
    ALLOCATE(DstInitInputData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveTime.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveTime = SrcInitInputData%WaveTime
ENDIF
IF (ALLOCATED(SrcInitInputData%WaveVel0)) THEN
  i1_l = LBOUND(SrcInitInputData%WaveVel0,1)
  i1_u = UBOUND(SrcInitInputData%WaveVel0,1)
  i2_l = LBOUND(SrcInitInputData%WaveVel0,2)
  i2_u = UBOUND(SrcInitInputData%WaveVel0,2)
  i3_l = LBOUND(SrcInitInputData%WaveVel0,3)
  i3_u = UBOUND(SrcInitInputData%WaveVel0,3)
  IF (.NOT. ALLOCATED(DstInitInputData%WaveVel0)) THEN 
    ALLOCATE(DstInitInputData%WaveVel0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WaveVel0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%WaveVel0 = SrcInitInputData%WaveVel0
ENDIF
    DstInitInputData%Gravity = SrcInitInputData%Gravity
    DstInitInputData%WtrDens = SrcInitInputData%WtrDens
 END SUBROUTINE FEAM_CopyInitInput

 SUBROUTINE FEAM_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(FEAM_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%WaveAcc0)) THEN
  DEALLOCATE(InitInputData%WaveAcc0)
ENDIF
IF (ALLOCATED(InitInputData%WaveTime)) THEN
  DEALLOCATE(InitInputData%WaveTime)
ENDIF
IF (ALLOCATED(InitInputData%WaveVel0)) THEN
  DEALLOCATE(InitInputData%WaveVel0)
ENDIF
 END SUBROUTINE FEAM_DestroyInitInput

 SUBROUTINE FEAM_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%InputFile)  ! InputFile
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Re_BufSz   = Re_BufSz   + SIZE(InData%PtfmInit)  ! PtfmInit
      Int_BufSz  = Int_BufSz  + 1  ! NStepWave
  Int_BufSz   = Int_BufSz   + 1     ! WaveAcc0 allocated yes/no
  IF ( ALLOCATED(InData%WaveAcc0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveAcc0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveAcc0)  ! WaveAcc0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveTime allocated yes/no
  IF ( ALLOCATED(InData%WaveTime) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WaveTime upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveTime)  ! WaveTime
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveVel0 allocated yes/no
  IF ( ALLOCATED(InData%WaveVel0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveVel0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveVel0)  ! WaveVel0
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%InputFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%InputFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO i1 = LBOUND(InData%PtfmInit,1), UBOUND(InData%PtfmInit,1)
      ReKiBuf(Re_Xferred) = InData%PtfmInit(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%NStepWave
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%WaveAcc0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveAcc0,3), UBOUND(InData%WaveAcc0,3)
        DO i2 = LBOUND(InData%WaveAcc0,2), UBOUND(InData%WaveAcc0,2)
          DO i1 = LBOUND(InData%WaveAcc0,1), UBOUND(InData%WaveAcc0,1)
            ReKiBuf(Re_Xferred) = InData%WaveAcc0(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveTime) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveTime,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveTime,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WaveTime,1), UBOUND(InData%WaveTime,1)
        ReKiBuf(Re_Xferred) = InData%WaveTime(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveVel0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveVel0,3), UBOUND(InData%WaveVel0,3)
        DO i2 = LBOUND(InData%WaveVel0,2), UBOUND(InData%WaveVel0,2)
          DO i1 = LBOUND(InData%WaveVel0,1), UBOUND(InData%WaveVel0,1)
            ReKiBuf(Re_Xferred) = InData%WaveVel0(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FEAM_PackInitInput

 SUBROUTINE FEAM_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%InputFile)
      OutData%InputFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    i1_l = LBOUND(OutData%PtfmInit,1)
    i1_u = UBOUND(OutData%PtfmInit,1)
    DO i1 = LBOUND(OutData%PtfmInit,1), UBOUND(OutData%PtfmInit,1)
      OutData%PtfmInit(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%NStepWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveAcc0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveAcc0)) DEALLOCATE(OutData%WaveAcc0)
    ALLOCATE(OutData%WaveAcc0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveAcc0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveAcc0,3), UBOUND(OutData%WaveAcc0,3)
        DO i2 = LBOUND(OutData%WaveAcc0,2), UBOUND(OutData%WaveAcc0,2)
          DO i1 = LBOUND(OutData%WaveAcc0,1), UBOUND(OutData%WaveAcc0,1)
            OutData%WaveAcc0(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveTime not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveTime)) DEALLOCATE(OutData%WaveTime)
    ALLOCATE(OutData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveTime.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WaveTime,1), UBOUND(OutData%WaveTime,1)
        OutData%WaveTime(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveVel0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveVel0)) DEALLOCATE(OutData%WaveVel0)
    ALLOCATE(OutData%WaveVel0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveVel0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveVel0,3), UBOUND(OutData%WaveVel0,3)
        DO i2 = LBOUND(OutData%WaveVel0,2), UBOUND(OutData%WaveVel0,2)
          DO i1 = LBOUND(OutData%WaveVel0,1), UBOUND(OutData%WaveVel0,1)
            OutData%WaveVel0(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FEAM_UnPackInitInput

 SUBROUTINE FEAM_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(FEAM_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcInitOutputData%LAnchxi)) THEN
  i1_l = LBOUND(SrcInitOutputData%LAnchxi,1)
  i1_u = UBOUND(SrcInitOutputData%LAnchxi,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LAnchxi)) THEN 
    ALLOCATE(DstInitOutputData%LAnchxi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchxi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LAnchxi = SrcInitOutputData%LAnchxi
ENDIF
IF (ALLOCATED(SrcInitOutputData%LAnchyi)) THEN
  i1_l = LBOUND(SrcInitOutputData%LAnchyi,1)
  i1_u = UBOUND(SrcInitOutputData%LAnchyi,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LAnchyi)) THEN 
    ALLOCATE(DstInitOutputData%LAnchyi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchyi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LAnchyi = SrcInitOutputData%LAnchyi
ENDIF
IF (ALLOCATED(SrcInitOutputData%LAnchzi)) THEN
  i1_l = LBOUND(SrcInitOutputData%LAnchzi,1)
  i1_u = UBOUND(SrcInitOutputData%LAnchzi,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LAnchzi)) THEN 
    ALLOCATE(DstInitOutputData%LAnchzi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LAnchzi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LAnchzi = SrcInitOutputData%LAnchzi
ENDIF
IF (ALLOCATED(SrcInitOutputData%LFairxt)) THEN
  i1_l = LBOUND(SrcInitOutputData%LFairxt,1)
  i1_u = UBOUND(SrcInitOutputData%LFairxt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LFairxt)) THEN 
    ALLOCATE(DstInitOutputData%LFairxt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairxt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LFairxt = SrcInitOutputData%LFairxt
ENDIF
IF (ALLOCATED(SrcInitOutputData%LFairyt)) THEN
  i1_l = LBOUND(SrcInitOutputData%LFairyt,1)
  i1_u = UBOUND(SrcInitOutputData%LFairyt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LFairyt)) THEN 
    ALLOCATE(DstInitOutputData%LFairyt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairyt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LFairyt = SrcInitOutputData%LFairyt
ENDIF
IF (ALLOCATED(SrcInitOutputData%LFairzt)) THEN
  i1_l = LBOUND(SrcInitOutputData%LFairzt,1)
  i1_u = UBOUND(SrcInitOutputData%LFairzt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LFairzt)) THEN 
    ALLOCATE(DstInitOutputData%LFairzt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LFairzt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LFairzt = SrcInitOutputData%LFairzt
ENDIF
 END SUBROUTINE FEAM_CopyInitOutput

 SUBROUTINE FEAM_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(FEAM_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
IF (ALLOCATED(InitOutputData%LAnchxi)) THEN
  DEALLOCATE(InitOutputData%LAnchxi)
ENDIF
IF (ALLOCATED(InitOutputData%LAnchyi)) THEN
  DEALLOCATE(InitOutputData%LAnchyi)
ENDIF
IF (ALLOCATED(InitOutputData%LAnchzi)) THEN
  DEALLOCATE(InitOutputData%LAnchzi)
ENDIF
IF (ALLOCATED(InitOutputData%LFairxt)) THEN
  DEALLOCATE(InitOutputData%LFairxt)
ENDIF
IF (ALLOCATED(InitOutputData%LFairyt)) THEN
  DEALLOCATE(InitOutputData%LFairyt)
ENDIF
IF (ALLOCATED(InitOutputData%LFairzt)) THEN
  DEALLOCATE(InitOutputData%LFairzt)
ENDIF
 END SUBROUTINE FEAM_DestroyInitOutput

 SUBROUTINE FEAM_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! LAnchxi allocated yes/no
  IF ( ALLOCATED(InData%LAnchxi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LAnchxi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LAnchxi)  ! LAnchxi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LAnchyi allocated yes/no
  IF ( ALLOCATED(InData%LAnchyi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LAnchyi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LAnchyi)  ! LAnchyi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LAnchzi allocated yes/no
  IF ( ALLOCATED(InData%LAnchzi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LAnchzi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LAnchzi)  ! LAnchzi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LFairxt allocated yes/no
  IF ( ALLOCATED(InData%LFairxt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LFairxt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LFairxt)  ! LFairxt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LFairyt allocated yes/no
  IF ( ALLOCATED(InData%LFairyt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LFairyt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LFairyt)  ! LFairyt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LFairzt allocated yes/no
  IF ( ALLOCATED(InData%LFairzt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LFairzt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LFairzt)  ! LFairzt
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%LAnchxi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LAnchxi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LAnchxi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LAnchxi,1), UBOUND(InData%LAnchxi,1)
        ReKiBuf(Re_Xferred) = InData%LAnchxi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LAnchyi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LAnchyi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LAnchyi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LAnchyi,1), UBOUND(InData%LAnchyi,1)
        ReKiBuf(Re_Xferred) = InData%LAnchyi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LAnchzi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LAnchzi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LAnchzi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LAnchzi,1), UBOUND(InData%LAnchzi,1)
        ReKiBuf(Re_Xferred) = InData%LAnchzi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LFairxt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LFairxt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LFairxt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LFairxt,1), UBOUND(InData%LFairxt,1)
        ReKiBuf(Re_Xferred) = InData%LFairxt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LFairyt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LFairyt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LFairyt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LFairyt,1), UBOUND(InData%LFairyt,1)
        ReKiBuf(Re_Xferred) = InData%LFairyt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LFairzt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LFairzt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LFairzt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LFairzt,1), UBOUND(InData%LFairzt,1)
        ReKiBuf(Re_Xferred) = InData%LFairzt(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FEAM_PackInitOutput

 SUBROUTINE FEAM_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LAnchxi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LAnchxi)) DEALLOCATE(OutData%LAnchxi)
    ALLOCATE(OutData%LAnchxi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LAnchxi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LAnchxi,1), UBOUND(OutData%LAnchxi,1)
        OutData%LAnchxi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LAnchyi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LAnchyi)) DEALLOCATE(OutData%LAnchyi)
    ALLOCATE(OutData%LAnchyi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LAnchyi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LAnchyi,1), UBOUND(OutData%LAnchyi,1)
        OutData%LAnchyi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LAnchzi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LAnchzi)) DEALLOCATE(OutData%LAnchzi)
    ALLOCATE(OutData%LAnchzi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LAnchzi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LAnchzi,1), UBOUND(OutData%LAnchzi,1)
        OutData%LAnchzi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LFairxt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LFairxt)) DEALLOCATE(OutData%LFairxt)
    ALLOCATE(OutData%LFairxt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LFairxt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LFairxt,1), UBOUND(OutData%LFairxt,1)
        OutData%LFairxt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LFairyt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LFairyt)) DEALLOCATE(OutData%LFairyt)
    ALLOCATE(OutData%LFairyt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LFairyt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LFairyt,1), UBOUND(OutData%LFairyt,1)
        OutData%LFairyt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LFairzt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LFairzt)) DEALLOCATE(OutData%LFairzt)
    ALLOCATE(OutData%LFairzt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LFairzt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LFairzt,1), UBOUND(OutData%LFairzt,1)
        OutData%LFairzt(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FEAM_UnPackInitOutput

 SUBROUTINE FEAM_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(FEAM_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcContStateData%GLU)) THEN
  i1_l = LBOUND(SrcContStateData%GLU,1)
  i1_u = UBOUND(SrcContStateData%GLU,1)
  i2_l = LBOUND(SrcContStateData%GLU,2)
  i2_u = UBOUND(SrcContStateData%GLU,2)
  IF (.NOT. ALLOCATED(DstContStateData%GLU)) THEN 
    ALLOCATE(DstContStateData%GLU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%GLU.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstContStateData%GLU = SrcContStateData%GLU
ENDIF
IF (ALLOCATED(SrcContStateData%GLDU)) THEN
  i1_l = LBOUND(SrcContStateData%GLDU,1)
  i1_u = UBOUND(SrcContStateData%GLDU,1)
  i2_l = LBOUND(SrcContStateData%GLDU,2)
  i2_u = UBOUND(SrcContStateData%GLDU,2)
  IF (.NOT. ALLOCATED(DstContStateData%GLDU)) THEN 
    ALLOCATE(DstContStateData%GLDU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%GLDU.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstContStateData%GLDU = SrcContStateData%GLDU
ENDIF
 END SUBROUTINE FEAM_CopyContState

 SUBROUTINE FEAM_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(FEAM_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ContStateData%GLU)) THEN
  DEALLOCATE(ContStateData%GLU)
ENDIF
IF (ALLOCATED(ContStateData%GLDU)) THEN
  DEALLOCATE(ContStateData%GLDU)
ENDIF
 END SUBROUTINE FEAM_DestroyContState

 SUBROUTINE FEAM_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! GLU allocated yes/no
  IF ( ALLOCATED(InData%GLU) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GLU upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLU)  ! GLU
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GLDU allocated yes/no
  IF ( ALLOCATED(InData%GLDU) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GLDU upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLDU)  ! GLDU
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%GLU) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLU,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLU,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLU,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLU,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GLU,2), UBOUND(InData%GLU,2)
        DO i1 = LBOUND(InData%GLU,1), UBOUND(InData%GLU,1)
          ReKiBuf(Re_Xferred) = InData%GLU(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GLDU) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLDU,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLDU,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLDU,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLDU,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GLDU,2), UBOUND(InData%GLDU,2)
        DO i1 = LBOUND(InData%GLDU,1), UBOUND(InData%GLDU,1)
          ReKiBuf(Re_Xferred) = InData%GLDU(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FEAM_PackContState

 SUBROUTINE FEAM_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLU not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLU)) DEALLOCATE(OutData%GLU)
    ALLOCATE(OutData%GLU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLU.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GLU,2), UBOUND(OutData%GLU,2)
        DO i1 = LBOUND(OutData%GLU,1), UBOUND(OutData%GLU,1)
          OutData%GLU(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLDU not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLDU)) DEALLOCATE(OutData%GLDU)
    ALLOCATE(OutData%GLDU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLDU.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GLDU,2), UBOUND(OutData%GLDU,2)
        DO i1 = LBOUND(OutData%GLDU,1), UBOUND(OutData%GLDU,1)
          OutData%GLDU(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FEAM_UnPackContState

 SUBROUTINE FEAM_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(FEAM_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
 END SUBROUTINE FEAM_CopyDiscState

 SUBROUTINE FEAM_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(FEAM_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE FEAM_DestroyDiscState

 SUBROUTINE FEAM_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyDiscState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyDiscState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FEAM_PackDiscState

 SUBROUTINE FEAM_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyDiscState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FEAM_UnPackDiscState

 SUBROUTINE FEAM_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(FEAM_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%TSN = SrcConstrStateData%TSN
    DstConstrStateData%TZER = SrcConstrStateData%TZER
 END SUBROUTINE FEAM_CopyConstrState

 SUBROUTINE FEAM_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(FEAM_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE FEAM_DestroyConstrState

 SUBROUTINE FEAM_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + SIZE(InData%TSN)  ! TSN
      Re_BufSz   = Re_BufSz   + SIZE(InData%TZER)  ! TZER
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i1 = LBOUND(InData%TSN,1), UBOUND(InData%TSN,1)
      ReKiBuf(Re_Xferred) = InData%TSN(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%TZER,1), UBOUND(InData%TZER,1)
      ReKiBuf(Re_Xferred) = InData%TZER(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE FEAM_PackConstrState

 SUBROUTINE FEAM_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%TSN,1)
    i1_u = UBOUND(OutData%TSN,1)
    DO i1 = LBOUND(OutData%TSN,1), UBOUND(OutData%TSN,1)
      OutData%TSN(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TZER,1)
    i1_u = UBOUND(OutData%TZER,1)
    DO i1 = LBOUND(OutData%TZER,1), UBOUND(OutData%TZER,1)
      OutData%TZER(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE FEAM_UnPackConstrState

 SUBROUTINE FEAM_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(FEAM_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOtherStateData%GLU0)) THEN
  i1_l = LBOUND(SrcOtherStateData%GLU0,1)
  i1_u = UBOUND(SrcOtherStateData%GLU0,1)
  i2_l = LBOUND(SrcOtherStateData%GLU0,2)
  i2_u = UBOUND(SrcOtherStateData%GLU0,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%GLU0)) THEN 
    ALLOCATE(DstOtherStateData%GLU0(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GLU0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%GLU0 = SrcOtherStateData%GLU0
ENDIF
IF (ALLOCATED(SrcOtherStateData%GLDDU)) THEN
  i1_l = LBOUND(SrcOtherStateData%GLDDU,1)
  i1_u = UBOUND(SrcOtherStateData%GLDDU,1)
  i2_l = LBOUND(SrcOtherStateData%GLDDU,2)
  i2_u = UBOUND(SrcOtherStateData%GLDDU,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%GLDDU)) THEN 
    ALLOCATE(DstOtherStateData%GLDDU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GLDDU.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%GLDDU = SrcOtherStateData%GLDDU
ENDIF
    DstOtherStateData%BottomTouch = SrcOtherStateData%BottomTouch
IF (ALLOCATED(SrcOtherStateData%GFORC0)) THEN
  i1_l = LBOUND(SrcOtherStateData%GFORC0,1)
  i1_u = UBOUND(SrcOtherStateData%GFORC0,1)
  i2_l = LBOUND(SrcOtherStateData%GFORC0,2)
  i2_u = UBOUND(SrcOtherStateData%GFORC0,2)
  i3_l = LBOUND(SrcOtherStateData%GFORC0,3)
  i3_u = UBOUND(SrcOtherStateData%GFORC0,3)
  IF (.NOT. ALLOCATED(DstOtherStateData%GFORC0)) THEN 
    ALLOCATE(DstOtherStateData%GFORC0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GFORC0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%GFORC0 = SrcOtherStateData%GFORC0
ENDIF
IF (ALLOCATED(SrcOtherStateData%GMASS0)) THEN
  i1_l = LBOUND(SrcOtherStateData%GMASS0,1)
  i1_u = UBOUND(SrcOtherStateData%GMASS0,1)
  i2_l = LBOUND(SrcOtherStateData%GMASS0,2)
  i2_u = UBOUND(SrcOtherStateData%GMASS0,2)
  i3_l = LBOUND(SrcOtherStateData%GMASS0,3)
  i3_u = UBOUND(SrcOtherStateData%GMASS0,3)
  i4_l = LBOUND(SrcOtherStateData%GMASS0,4)
  i4_u = UBOUND(SrcOtherStateData%GMASS0,4)
  IF (.NOT. ALLOCATED(DstOtherStateData%GMASS0)) THEN 
    ALLOCATE(DstOtherStateData%GMASS0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%GMASS0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%GMASS0 = SrcOtherStateData%GMASS0
ENDIF
IF (ALLOCATED(SrcOtherStateData%FAST_FPA)) THEN
  i1_l = LBOUND(SrcOtherStateData%FAST_FPA,1)
  i1_u = UBOUND(SrcOtherStateData%FAST_FPA,1)
  i2_l = LBOUND(SrcOtherStateData%FAST_FPA,2)
  i2_u = UBOUND(SrcOtherStateData%FAST_FPA,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%FAST_FPA)) THEN 
    ALLOCATE(DstOtherStateData%FAST_FPA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FAST_FPA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%FAST_FPA = SrcOtherStateData%FAST_FPA
ENDIF
IF (ALLOCATED(SrcOtherStateData%FAST_RP)) THEN
  i1_l = LBOUND(SrcOtherStateData%FAST_RP,1)
  i1_u = UBOUND(SrcOtherStateData%FAST_RP,1)
  i2_l = LBOUND(SrcOtherStateData%FAST_RP,2)
  i2_u = UBOUND(SrcOtherStateData%FAST_RP,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%FAST_RP)) THEN 
    ALLOCATE(DstOtherStateData%FAST_RP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FAST_RP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%FAST_RP = SrcOtherStateData%FAST_RP
ENDIF
    DstOtherStateData%INCR = SrcOtherStateData%INCR
    DstOtherStateData%RSDF = SrcOtherStateData%RSDF
    DstOtherStateData%FORC0 = SrcOtherStateData%FORC0
    DstOtherStateData%EMAS0 = SrcOtherStateData%EMAS0
 END SUBROUTINE FEAM_CopyOtherState

 SUBROUTINE FEAM_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(FEAM_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OtherStateData%GLU0)) THEN
  DEALLOCATE(OtherStateData%GLU0)
ENDIF
IF (ALLOCATED(OtherStateData%GLDDU)) THEN
  DEALLOCATE(OtherStateData%GLDDU)
ENDIF
IF (ALLOCATED(OtherStateData%GFORC0)) THEN
  DEALLOCATE(OtherStateData%GFORC0)
ENDIF
IF (ALLOCATED(OtherStateData%GMASS0)) THEN
  DEALLOCATE(OtherStateData%GMASS0)
ENDIF
IF (ALLOCATED(OtherStateData%FAST_FPA)) THEN
  DEALLOCATE(OtherStateData%FAST_FPA)
ENDIF
IF (ALLOCATED(OtherStateData%FAST_RP)) THEN
  DEALLOCATE(OtherStateData%FAST_RP)
ENDIF
 END SUBROUTINE FEAM_DestroyOtherState

 SUBROUTINE FEAM_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! GLU0 allocated yes/no
  IF ( ALLOCATED(InData%GLU0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GLU0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLU0)  ! GLU0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GLDDU allocated yes/no
  IF ( ALLOCATED(InData%GLDDU) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GLDDU upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLDDU)  ! GLDDU
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! BottomTouch
  Int_BufSz   = Int_BufSz   + 1     ! GFORC0 allocated yes/no
  IF ( ALLOCATED(InData%GFORC0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GFORC0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GFORC0)  ! GFORC0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GMASS0 allocated yes/no
  IF ( ALLOCATED(InData%GMASS0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! GMASS0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GMASS0)  ! GMASS0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FAST_FPA allocated yes/no
  IF ( ALLOCATED(InData%FAST_FPA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FAST_FPA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAST_FPA)  ! FAST_FPA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FAST_RP allocated yes/no
  IF ( ALLOCATED(InData%FAST_RP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FAST_RP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAST_RP)  ! FAST_RP
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! INCR
      Re_BufSz   = Re_BufSz   + SIZE(InData%RSDF)  ! RSDF
      Re_BufSz   = Re_BufSz   + SIZE(InData%FORC0)  ! FORC0
      Re_BufSz   = Re_BufSz   + SIZE(InData%EMAS0)  ! EMAS0
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%GLU0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLU0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLU0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLU0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLU0,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GLU0,2), UBOUND(InData%GLU0,2)
        DO i1 = LBOUND(InData%GLU0,1), UBOUND(InData%GLU0,1)
          ReKiBuf(Re_Xferred) = InData%GLU0(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GLDDU) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLDDU,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLDDU,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLDDU,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLDDU,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GLDDU,2), UBOUND(InData%GLDDU,2)
        DO i1 = LBOUND(InData%GLDDU,1), UBOUND(InData%GLDDU,1)
          ReKiBuf(Re_Xferred) = InData%GLDDU(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%BottomTouch, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%GFORC0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GFORC0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GFORC0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GFORC0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GFORC0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GFORC0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GFORC0,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GFORC0,3), UBOUND(InData%GFORC0,3)
        DO i2 = LBOUND(InData%GFORC0,2), UBOUND(InData%GFORC0,2)
          DO i1 = LBOUND(InData%GFORC0,1), UBOUND(InData%GFORC0,1)
            ReKiBuf(Re_Xferred) = InData%GFORC0(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GMASS0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GMASS0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GMASS0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GMASS0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GMASS0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GMASS0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GMASS0,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GMASS0,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GMASS0,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%GMASS0,4), UBOUND(InData%GMASS0,4)
        DO i3 = LBOUND(InData%GMASS0,3), UBOUND(InData%GMASS0,3)
          DO i2 = LBOUND(InData%GMASS0,2), UBOUND(InData%GMASS0,2)
            DO i1 = LBOUND(InData%GMASS0,1), UBOUND(InData%GMASS0,1)
              ReKiBuf(Re_Xferred) = InData%GMASS0(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FAST_FPA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_FPA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_FPA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_FPA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_FPA,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FAST_FPA,2), UBOUND(InData%FAST_FPA,2)
        DO i1 = LBOUND(InData%FAST_FPA,1), UBOUND(InData%FAST_FPA,1)
          ReKiBuf(Re_Xferred) = InData%FAST_FPA(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FAST_RP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_RP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_RP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_RP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_RP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FAST_RP,2), UBOUND(InData%FAST_RP,2)
        DO i1 = LBOUND(InData%FAST_RP,1), UBOUND(InData%FAST_RP,1)
          ReKiBuf(Re_Xferred) = InData%FAST_RP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%INCR
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%RSDF,1), UBOUND(InData%RSDF,1)
      ReKiBuf(Re_Xferred) = InData%RSDF(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FORC0,1), UBOUND(InData%FORC0,1)
      ReKiBuf(Re_Xferred) = InData%FORC0(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%EMAS0,2), UBOUND(InData%EMAS0,2)
      DO i1 = LBOUND(InData%EMAS0,1), UBOUND(InData%EMAS0,1)
        ReKiBuf(Re_Xferred) = InData%EMAS0(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
 END SUBROUTINE FEAM_PackOtherState

 SUBROUTINE FEAM_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLU0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLU0)) DEALLOCATE(OutData%GLU0)
    ALLOCATE(OutData%GLU0(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLU0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GLU0,2), UBOUND(OutData%GLU0,2)
        DO i1 = LBOUND(OutData%GLU0,1), UBOUND(OutData%GLU0,1)
          OutData%GLU0(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLDDU not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLDDU)) DEALLOCATE(OutData%GLDDU)
    ALLOCATE(OutData%GLDDU(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLDDU.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GLDDU,2), UBOUND(OutData%GLDDU,2)
        DO i1 = LBOUND(OutData%GLDDU,1), UBOUND(OutData%GLDDU,1)
          OutData%GLDDU(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%BottomTouch = TRANSFER(IntKiBuf(Int_Xferred), OutData%BottomTouch)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GFORC0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GFORC0)) DEALLOCATE(OutData%GFORC0)
    ALLOCATE(OutData%GFORC0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GFORC0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GFORC0,3), UBOUND(OutData%GFORC0,3)
        DO i2 = LBOUND(OutData%GFORC0,2), UBOUND(OutData%GFORC0,2)
          DO i1 = LBOUND(OutData%GFORC0,1), UBOUND(OutData%GFORC0,1)
            OutData%GFORC0(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GMASS0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GMASS0)) DEALLOCATE(OutData%GMASS0)
    ALLOCATE(OutData%GMASS0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GMASS0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%GMASS0,4), UBOUND(OutData%GMASS0,4)
        DO i3 = LBOUND(OutData%GMASS0,3), UBOUND(OutData%GMASS0,3)
          DO i2 = LBOUND(OutData%GMASS0,2), UBOUND(OutData%GMASS0,2)
            DO i1 = LBOUND(OutData%GMASS0,1), UBOUND(OutData%GMASS0,1)
              OutData%GMASS0(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FAST_FPA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FAST_FPA)) DEALLOCATE(OutData%FAST_FPA)
    ALLOCATE(OutData%FAST_FPA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FAST_FPA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FAST_FPA,2), UBOUND(OutData%FAST_FPA,2)
        DO i1 = LBOUND(OutData%FAST_FPA,1), UBOUND(OutData%FAST_FPA,1)
          OutData%FAST_FPA(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FAST_RP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FAST_RP)) DEALLOCATE(OutData%FAST_RP)
    ALLOCATE(OutData%FAST_RP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FAST_RP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FAST_RP,2), UBOUND(OutData%FAST_RP,2)
        DO i1 = LBOUND(OutData%FAST_RP,1), UBOUND(OutData%FAST_RP,1)
          OutData%FAST_RP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%INCR = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%RSDF,1)
    i1_u = UBOUND(OutData%RSDF,1)
    DO i1 = LBOUND(OutData%RSDF,1), UBOUND(OutData%RSDF,1)
      OutData%RSDF(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FORC0,1)
    i1_u = UBOUND(OutData%FORC0,1)
    DO i1 = LBOUND(OutData%FORC0,1), UBOUND(OutData%FORC0,1)
      OutData%FORC0(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%EMAS0,1)
    i1_u = UBOUND(OutData%EMAS0,1)
    i2_l = LBOUND(OutData%EMAS0,2)
    i2_u = UBOUND(OutData%EMAS0,2)
    DO i2 = LBOUND(OutData%EMAS0,2), UBOUND(OutData%EMAS0,2)
      DO i1 = LBOUND(OutData%EMAS0,1), UBOUND(OutData%EMAS0,1)
        OutData%EMAS0(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
 END SUBROUTINE FEAM_UnPackOtherState

 SUBROUTINE FEAM_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(FEAM_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%GLF)) THEN
  i1_l = LBOUND(SrcMiscData%GLF,1)
  i1_u = UBOUND(SrcMiscData%GLF,1)
  i2_l = LBOUND(SrcMiscData%GLF,2)
  i2_u = UBOUND(SrcMiscData%GLF,2)
  IF (.NOT. ALLOCATED(DstMiscData%GLF)) THEN 
    ALLOCATE(DstMiscData%GLF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GLF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%GLF = SrcMiscData%GLF
ENDIF
IF (ALLOCATED(SrcMiscData%GLK)) THEN
  i1_l = LBOUND(SrcMiscData%GLK,1)
  i1_u = UBOUND(SrcMiscData%GLK,1)
  i2_l = LBOUND(SrcMiscData%GLK,2)
  i2_u = UBOUND(SrcMiscData%GLK,2)
  i3_l = LBOUND(SrcMiscData%GLK,3)
  i3_u = UBOUND(SrcMiscData%GLK,3)
  IF (.NOT. ALLOCATED(DstMiscData%GLK)) THEN 
    ALLOCATE(DstMiscData%GLK(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GLK.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%GLK = SrcMiscData%GLK
ENDIF
    DstMiscData%EMASS = SrcMiscData%EMASS
    DstMiscData%ESTIF = SrcMiscData%ESTIF
IF (ALLOCATED(SrcMiscData%FAST_FP)) THEN
  i1_l = LBOUND(SrcMiscData%FAST_FP,1)
  i1_u = UBOUND(SrcMiscData%FAST_FP,1)
  i2_l = LBOUND(SrcMiscData%FAST_FP,2)
  i2_u = UBOUND(SrcMiscData%FAST_FP,2)
  IF (.NOT. ALLOCATED(DstMiscData%FAST_FP)) THEN 
    ALLOCATE(DstMiscData%FAST_FP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAST_FP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FAST_FP = SrcMiscData%FAST_FP
ENDIF
    DstMiscData%FORCE = SrcMiscData%FORCE
    DstMiscData%FP = SrcMiscData%FP
    DstMiscData%U = SrcMiscData%U
    DstMiscData%U0 = SrcMiscData%U0
    DstMiscData%DU = SrcMiscData%DU
    DstMiscData%DDU = SrcMiscData%DDU
    DstMiscData%R = SrcMiscData%R
    DstMiscData%RP = SrcMiscData%RP
    DstMiscData%RHSR = SrcMiscData%RHSR
    DstMiscData%SLIN = SrcMiscData%SLIN
    DstMiscData%STIFR = SrcMiscData%STIFR
IF (ALLOCATED(SrcMiscData%FAIR_ANG)) THEN
  i1_l = LBOUND(SrcMiscData%FAIR_ANG,1)
  i1_u = UBOUND(SrcMiscData%FAIR_ANG,1)
  i2_l = LBOUND(SrcMiscData%FAIR_ANG,2)
  i2_u = UBOUND(SrcMiscData%FAIR_ANG,2)
  IF (.NOT. ALLOCATED(DstMiscData%FAIR_ANG)) THEN 
    ALLOCATE(DstMiscData%FAIR_ANG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAIR_ANG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FAIR_ANG = SrcMiscData%FAIR_ANG
ENDIF
IF (ALLOCATED(SrcMiscData%FAIR_T)) THEN
  i1_l = LBOUND(SrcMiscData%FAIR_T,1)
  i1_u = UBOUND(SrcMiscData%FAIR_T,1)
  IF (.NOT. ALLOCATED(DstMiscData%FAIR_T)) THEN 
    ALLOCATE(DstMiscData%FAIR_T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FAIR_T.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%FAIR_T = SrcMiscData%FAIR_T
ENDIF
IF (ALLOCATED(SrcMiscData%ANCH_ANG)) THEN
  i1_l = LBOUND(SrcMiscData%ANCH_ANG,1)
  i1_u = UBOUND(SrcMiscData%ANCH_ANG,1)
  i2_l = LBOUND(SrcMiscData%ANCH_ANG,2)
  i2_u = UBOUND(SrcMiscData%ANCH_ANG,2)
  IF (.NOT. ALLOCATED(DstMiscData%ANCH_ANG)) THEN 
    ALLOCATE(DstMiscData%ANCH_ANG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ANCH_ANG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%ANCH_ANG = SrcMiscData%ANCH_ANG
ENDIF
IF (ALLOCATED(SrcMiscData%ANCH_T)) THEN
  i1_l = LBOUND(SrcMiscData%ANCH_T,1)
  i1_u = UBOUND(SrcMiscData%ANCH_T,1)
  IF (.NOT. ALLOCATED(DstMiscData%ANCH_T)) THEN 
    ALLOCATE(DstMiscData%ANCH_T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ANCH_T.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%ANCH_T = SrcMiscData%ANCH_T
ENDIF
IF (ALLOCATED(SrcMiscData%Line_Coordinate)) THEN
  i1_l = LBOUND(SrcMiscData%Line_Coordinate,1)
  i1_u = UBOUND(SrcMiscData%Line_Coordinate,1)
  i2_l = LBOUND(SrcMiscData%Line_Coordinate,2)
  i2_u = UBOUND(SrcMiscData%Line_Coordinate,2)
  i3_l = LBOUND(SrcMiscData%Line_Coordinate,3)
  i3_u = UBOUND(SrcMiscData%Line_Coordinate,3)
  IF (.NOT. ALLOCATED(DstMiscData%Line_Coordinate)) THEN 
    ALLOCATE(DstMiscData%Line_Coordinate(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line_Coordinate.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Line_Coordinate = SrcMiscData%Line_Coordinate
ENDIF
IF (ALLOCATED(SrcMiscData%Line_Tangent)) THEN
  i1_l = LBOUND(SrcMiscData%Line_Tangent,1)
  i1_u = UBOUND(SrcMiscData%Line_Tangent,1)
  i2_l = LBOUND(SrcMiscData%Line_Tangent,2)
  i2_u = UBOUND(SrcMiscData%Line_Tangent,2)
  i3_l = LBOUND(SrcMiscData%Line_Tangent,3)
  i3_u = UBOUND(SrcMiscData%Line_Tangent,3)
  IF (.NOT. ALLOCATED(DstMiscData%Line_Tangent)) THEN 
    ALLOCATE(DstMiscData%Line_Tangent(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Line_Tangent.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Line_Tangent = SrcMiscData%Line_Tangent
ENDIF
IF (ALLOCATED(SrcMiscData%F_Lines)) THEN
  i1_l = LBOUND(SrcMiscData%F_Lines,1)
  i1_u = UBOUND(SrcMiscData%F_Lines,1)
  i2_l = LBOUND(SrcMiscData%F_Lines,2)
  i2_u = UBOUND(SrcMiscData%F_Lines,2)
  IF (.NOT. ALLOCATED(DstMiscData%F_Lines)) THEN 
    ALLOCATE(DstMiscData%F_Lines(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%F_Lines.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%F_Lines = SrcMiscData%F_Lines
ENDIF
    DstMiscData%LastIndWave = SrcMiscData%LastIndWave
 END SUBROUTINE FEAM_CopyMisc

 SUBROUTINE FEAM_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(FEAM_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%GLF)) THEN
  DEALLOCATE(MiscData%GLF)
ENDIF
IF (ALLOCATED(MiscData%GLK)) THEN
  DEALLOCATE(MiscData%GLK)
ENDIF
IF (ALLOCATED(MiscData%FAST_FP)) THEN
  DEALLOCATE(MiscData%FAST_FP)
ENDIF
IF (ALLOCATED(MiscData%FAIR_ANG)) THEN
  DEALLOCATE(MiscData%FAIR_ANG)
ENDIF
IF (ALLOCATED(MiscData%FAIR_T)) THEN
  DEALLOCATE(MiscData%FAIR_T)
ENDIF
IF (ALLOCATED(MiscData%ANCH_ANG)) THEN
  DEALLOCATE(MiscData%ANCH_ANG)
ENDIF
IF (ALLOCATED(MiscData%ANCH_T)) THEN
  DEALLOCATE(MiscData%ANCH_T)
ENDIF
IF (ALLOCATED(MiscData%Line_Coordinate)) THEN
  DEALLOCATE(MiscData%Line_Coordinate)
ENDIF
IF (ALLOCATED(MiscData%Line_Tangent)) THEN
  DEALLOCATE(MiscData%Line_Tangent)
ENDIF
IF (ALLOCATED(MiscData%F_Lines)) THEN
  DEALLOCATE(MiscData%F_Lines)
ENDIF
 END SUBROUTINE FEAM_DestroyMisc

 SUBROUTINE FEAM_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! GLF allocated yes/no
  IF ( ALLOCATED(InData%GLF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GLF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLF)  ! GLF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GLK allocated yes/no
  IF ( ALLOCATED(InData%GLK) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GLK upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLK)  ! GLK
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%EMASS)  ! EMASS
      Re_BufSz   = Re_BufSz   + SIZE(InData%ESTIF)  ! ESTIF
  Int_BufSz   = Int_BufSz   + 1     ! FAST_FP allocated yes/no
  IF ( ALLOCATED(InData%FAST_FP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FAST_FP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAST_FP)  ! FAST_FP
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%FORCE)  ! FORCE
      Re_BufSz   = Re_BufSz   + SIZE(InData%FP)  ! FP
      Re_BufSz   = Re_BufSz   + SIZE(InData%U)  ! U
      Re_BufSz   = Re_BufSz   + SIZE(InData%U0)  ! U0
      Re_BufSz   = Re_BufSz   + SIZE(InData%DU)  ! DU
      Re_BufSz   = Re_BufSz   + SIZE(InData%DDU)  ! DDU
      Re_BufSz   = Re_BufSz   + SIZE(InData%R)  ! R
      Re_BufSz   = Re_BufSz   + SIZE(InData%RP)  ! RP
      Re_BufSz   = Re_BufSz   + SIZE(InData%RHSR)  ! RHSR
      Re_BufSz   = Re_BufSz   + SIZE(InData%SLIN)  ! SLIN
      Re_BufSz   = Re_BufSz   + SIZE(InData%STIFR)  ! STIFR
  Int_BufSz   = Int_BufSz   + 1     ! FAIR_ANG allocated yes/no
  IF ( ALLOCATED(InData%FAIR_ANG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FAIR_ANG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAIR_ANG)  ! FAIR_ANG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FAIR_T allocated yes/no
  IF ( ALLOCATED(InData%FAIR_T) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FAIR_T upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAIR_T)  ! FAIR_T
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ANCH_ANG allocated yes/no
  IF ( ALLOCATED(InData%ANCH_ANG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! ANCH_ANG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ANCH_ANG)  ! ANCH_ANG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ANCH_T allocated yes/no
  IF ( ALLOCATED(InData%ANCH_T) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ANCH_T upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ANCH_T)  ! ANCH_T
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line_Coordinate allocated yes/no
  IF ( ALLOCATED(InData%Line_Coordinate) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Line_Coordinate upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Line_Coordinate)  ! Line_Coordinate
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Line_Tangent allocated yes/no
  IF ( ALLOCATED(InData%Line_Tangent) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Line_Tangent upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Line_Tangent)  ! Line_Tangent
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! F_Lines allocated yes/no
  IF ( ALLOCATED(InData%F_Lines) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! F_Lines upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%F_Lines)  ! F_Lines
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! LastIndWave
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%GLF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GLF,2), UBOUND(InData%GLF,2)
        DO i1 = LBOUND(InData%GLF,1), UBOUND(InData%GLF,1)
          ReKiBuf(Re_Xferred) = InData%GLF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GLK) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLK,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLK,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLK,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLK,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLK,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLK,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GLK,3), UBOUND(InData%GLK,3)
        DO i2 = LBOUND(InData%GLK,2), UBOUND(InData%GLK,2)
          DO i1 = LBOUND(InData%GLK,1), UBOUND(InData%GLK,1)
            ReKiBuf(Re_Xferred) = InData%GLK(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%EMASS,2), UBOUND(InData%EMASS,2)
      DO i1 = LBOUND(InData%EMASS,1), UBOUND(InData%EMASS,1)
        ReKiBuf(Re_Xferred) = InData%EMASS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%ESTIF,2), UBOUND(InData%ESTIF,2)
      DO i1 = LBOUND(InData%ESTIF,1), UBOUND(InData%ESTIF,1)
        ReKiBuf(Re_Xferred) = InData%ESTIF(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%FAST_FP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_FP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_FP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAST_FP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAST_FP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FAST_FP,2), UBOUND(InData%FAST_FP,2)
        DO i1 = LBOUND(InData%FAST_FP,1), UBOUND(InData%FAST_FP,1)
          ReKiBuf(Re_Xferred) = InData%FAST_FP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%FORCE,1), UBOUND(InData%FORCE,1)
      ReKiBuf(Re_Xferred) = InData%FORCE(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FP,1), UBOUND(InData%FP,1)
      ReKiBuf(Re_Xferred) = InData%FP(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%U,2), UBOUND(InData%U,2)
      DO i1 = LBOUND(InData%U,1), UBOUND(InData%U,1)
        ReKiBuf(Re_Xferred) = InData%U(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%U0,2), UBOUND(InData%U0,2)
      DO i1 = LBOUND(InData%U0,1), UBOUND(InData%U0,1)
        ReKiBuf(Re_Xferred) = InData%U0(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%DU,2), UBOUND(InData%DU,2)
      DO i1 = LBOUND(InData%DU,1), UBOUND(InData%DU,1)
        ReKiBuf(Re_Xferred) = InData%DU(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%DDU,2), UBOUND(InData%DDU,2)
      DO i1 = LBOUND(InData%DDU,1), UBOUND(InData%DDU,1)
        ReKiBuf(Re_Xferred) = InData%DDU(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i1 = LBOUND(InData%R,1), UBOUND(InData%R,1)
      ReKiBuf(Re_Xferred) = InData%R(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%RP,1), UBOUND(InData%RP,1)
      ReKiBuf(Re_Xferred) = InData%RP(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%RHSR,1), UBOUND(InData%RHSR,1)
      ReKiBuf(Re_Xferred) = InData%RHSR(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%SLIN,1), UBOUND(InData%SLIN,1)
      ReKiBuf(Re_Xferred) = InData%SLIN(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%STIFR,2), UBOUND(InData%STIFR,2)
      DO i1 = LBOUND(InData%STIFR,1), UBOUND(InData%STIFR,1)
        ReKiBuf(Re_Xferred) = InData%STIFR(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%FAIR_ANG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAIR_ANG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAIR_ANG,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAIR_ANG,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAIR_ANG,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FAIR_ANG,2), UBOUND(InData%FAIR_ANG,2)
        DO i1 = LBOUND(InData%FAIR_ANG,1), UBOUND(InData%FAIR_ANG,1)
          ReKiBuf(Re_Xferred) = InData%FAIR_ANG(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FAIR_T) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FAIR_T,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FAIR_T,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FAIR_T,1), UBOUND(InData%FAIR_T,1)
        ReKiBuf(Re_Xferred) = InData%FAIR_T(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ANCH_ANG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ANCH_ANG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ANCH_ANG,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ANCH_ANG,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ANCH_ANG,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%ANCH_ANG,2), UBOUND(InData%ANCH_ANG,2)
        DO i1 = LBOUND(InData%ANCH_ANG,1), UBOUND(InData%ANCH_ANG,1)
          ReKiBuf(Re_Xferred) = InData%ANCH_ANG(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ANCH_T) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ANCH_T,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ANCH_T,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ANCH_T,1), UBOUND(InData%ANCH_T,1)
        ReKiBuf(Re_Xferred) = InData%ANCH_T(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line_Coordinate) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Coordinate,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Coordinate,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Coordinate,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Coordinate,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Coordinate,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Coordinate,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Line_Coordinate,3), UBOUND(InData%Line_Coordinate,3)
        DO i2 = LBOUND(InData%Line_Coordinate,2), UBOUND(InData%Line_Coordinate,2)
          DO i1 = LBOUND(InData%Line_Coordinate,1), UBOUND(InData%Line_Coordinate,1)
            ReKiBuf(Re_Xferred) = InData%Line_Coordinate(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Line_Tangent) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Tangent,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Tangent,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Tangent,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Tangent,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Line_Tangent,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Line_Tangent,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Line_Tangent,3), UBOUND(InData%Line_Tangent,3)
        DO i2 = LBOUND(InData%Line_Tangent,2), UBOUND(InData%Line_Tangent,2)
          DO i1 = LBOUND(InData%Line_Tangent,1), UBOUND(InData%Line_Tangent,1)
            ReKiBuf(Re_Xferred) = InData%Line_Tangent(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%F_Lines) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_Lines,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_Lines,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%F_Lines,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%F_Lines,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%F_Lines,2), UBOUND(InData%F_Lines,2)
        DO i1 = LBOUND(InData%F_Lines,1), UBOUND(InData%F_Lines,1)
          ReKiBuf(Re_Xferred) = InData%F_Lines(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%LastIndWave
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FEAM_PackMisc

 SUBROUTINE FEAM_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLF)) DEALLOCATE(OutData%GLF)
    ALLOCATE(OutData%GLF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GLF,2), UBOUND(OutData%GLF,2)
        DO i1 = LBOUND(OutData%GLF,1), UBOUND(OutData%GLF,1)
          OutData%GLF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLK not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLK)) DEALLOCATE(OutData%GLK)
    ALLOCATE(OutData%GLK(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLK.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GLK,3), UBOUND(OutData%GLK,3)
        DO i2 = LBOUND(OutData%GLK,2), UBOUND(OutData%GLK,2)
          DO i1 = LBOUND(OutData%GLK,1), UBOUND(OutData%GLK,1)
            OutData%GLK(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%EMASS,1)
    i1_u = UBOUND(OutData%EMASS,1)
    i2_l = LBOUND(OutData%EMASS,2)
    i2_u = UBOUND(OutData%EMASS,2)
    DO i2 = LBOUND(OutData%EMASS,2), UBOUND(OutData%EMASS,2)
      DO i1 = LBOUND(OutData%EMASS,1), UBOUND(OutData%EMASS,1)
        OutData%EMASS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%ESTIF,1)
    i1_u = UBOUND(OutData%ESTIF,1)
    i2_l = LBOUND(OutData%ESTIF,2)
    i2_u = UBOUND(OutData%ESTIF,2)
    DO i2 = LBOUND(OutData%ESTIF,2), UBOUND(OutData%ESTIF,2)
      DO i1 = LBOUND(OutData%ESTIF,1), UBOUND(OutData%ESTIF,1)
        OutData%ESTIF(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FAST_FP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FAST_FP)) DEALLOCATE(OutData%FAST_FP)
    ALLOCATE(OutData%FAST_FP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FAST_FP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FAST_FP,2), UBOUND(OutData%FAST_FP,2)
        DO i1 = LBOUND(OutData%FAST_FP,1), UBOUND(OutData%FAST_FP,1)
          OutData%FAST_FP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%FORCE,1)
    i1_u = UBOUND(OutData%FORCE,1)
    DO i1 = LBOUND(OutData%FORCE,1), UBOUND(OutData%FORCE,1)
      OutData%FORCE(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FP,1)
    i1_u = UBOUND(OutData%FP,1)
    DO i1 = LBOUND(OutData%FP,1), UBOUND(OutData%FP,1)
      OutData%FP(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%U,1)
    i1_u = UBOUND(OutData%U,1)
    i2_l = LBOUND(OutData%U,2)
    i2_u = UBOUND(OutData%U,2)
    DO i2 = LBOUND(OutData%U,2), UBOUND(OutData%U,2)
      DO i1 = LBOUND(OutData%U,1), UBOUND(OutData%U,1)
        OutData%U(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%U0,1)
    i1_u = UBOUND(OutData%U0,1)
    i2_l = LBOUND(OutData%U0,2)
    i2_u = UBOUND(OutData%U0,2)
    DO i2 = LBOUND(OutData%U0,2), UBOUND(OutData%U0,2)
      DO i1 = LBOUND(OutData%U0,1), UBOUND(OutData%U0,1)
        OutData%U0(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%DU,1)
    i1_u = UBOUND(OutData%DU,1)
    i2_l = LBOUND(OutData%DU,2)
    i2_u = UBOUND(OutData%DU,2)
    DO i2 = LBOUND(OutData%DU,2), UBOUND(OutData%DU,2)
      DO i1 = LBOUND(OutData%DU,1), UBOUND(OutData%DU,1)
        OutData%DU(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%DDU,1)
    i1_u = UBOUND(OutData%DDU,1)
    i2_l = LBOUND(OutData%DDU,2)
    i2_u = UBOUND(OutData%DDU,2)
    DO i2 = LBOUND(OutData%DDU,2), UBOUND(OutData%DDU,2)
      DO i1 = LBOUND(OutData%DDU,1), UBOUND(OutData%DDU,1)
        OutData%DDU(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%R,1)
    i1_u = UBOUND(OutData%R,1)
    DO i1 = LBOUND(OutData%R,1), UBOUND(OutData%R,1)
      OutData%R(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%RP,1)
    i1_u = UBOUND(OutData%RP,1)
    DO i1 = LBOUND(OutData%RP,1), UBOUND(OutData%RP,1)
      OutData%RP(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%RHSR,1)
    i1_u = UBOUND(OutData%RHSR,1)
    DO i1 = LBOUND(OutData%RHSR,1), UBOUND(OutData%RHSR,1)
      OutData%RHSR(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%SLIN,1)
    i1_u = UBOUND(OutData%SLIN,1)
    DO i1 = LBOUND(OutData%SLIN,1), UBOUND(OutData%SLIN,1)
      OutData%SLIN(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%STIFR,1)
    i1_u = UBOUND(OutData%STIFR,1)
    i2_l = LBOUND(OutData%STIFR,2)
    i2_u = UBOUND(OutData%STIFR,2)
    DO i2 = LBOUND(OutData%STIFR,2), UBOUND(OutData%STIFR,2)
      DO i1 = LBOUND(OutData%STIFR,1), UBOUND(OutData%STIFR,1)
        OutData%STIFR(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FAIR_ANG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FAIR_ANG)) DEALLOCATE(OutData%FAIR_ANG)
    ALLOCATE(OutData%FAIR_ANG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FAIR_ANG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FAIR_ANG,2), UBOUND(OutData%FAIR_ANG,2)
        DO i1 = LBOUND(OutData%FAIR_ANG,1), UBOUND(OutData%FAIR_ANG,1)
          OutData%FAIR_ANG(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FAIR_T not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FAIR_T)) DEALLOCATE(OutData%FAIR_T)
    ALLOCATE(OutData%FAIR_T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FAIR_T.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FAIR_T,1), UBOUND(OutData%FAIR_T,1)
        OutData%FAIR_T(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ANCH_ANG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ANCH_ANG)) DEALLOCATE(OutData%ANCH_ANG)
    ALLOCATE(OutData%ANCH_ANG(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ANCH_ANG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%ANCH_ANG,2), UBOUND(OutData%ANCH_ANG,2)
        DO i1 = LBOUND(OutData%ANCH_ANG,1), UBOUND(OutData%ANCH_ANG,1)
          OutData%ANCH_ANG(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ANCH_T not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ANCH_T)) DEALLOCATE(OutData%ANCH_T)
    ALLOCATE(OutData%ANCH_T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ANCH_T.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ANCH_T,1), UBOUND(OutData%ANCH_T,1)
        OutData%ANCH_T(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line_Coordinate not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line_Coordinate)) DEALLOCATE(OutData%Line_Coordinate)
    ALLOCATE(OutData%Line_Coordinate(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line_Coordinate.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Line_Coordinate,3), UBOUND(OutData%Line_Coordinate,3)
        DO i2 = LBOUND(OutData%Line_Coordinate,2), UBOUND(OutData%Line_Coordinate,2)
          DO i1 = LBOUND(OutData%Line_Coordinate,1), UBOUND(OutData%Line_Coordinate,1)
            OutData%Line_Coordinate(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Line_Tangent not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Line_Tangent)) DEALLOCATE(OutData%Line_Tangent)
    ALLOCATE(OutData%Line_Tangent(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Line_Tangent.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Line_Tangent,3), UBOUND(OutData%Line_Tangent,3)
        DO i2 = LBOUND(OutData%Line_Tangent,2), UBOUND(OutData%Line_Tangent,2)
          DO i1 = LBOUND(OutData%Line_Tangent,1), UBOUND(OutData%Line_Tangent,1)
            OutData%Line_Tangent(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! F_Lines not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%F_Lines)) DEALLOCATE(OutData%F_Lines)
    ALLOCATE(OutData%F_Lines(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%F_Lines.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%F_Lines,2), UBOUND(OutData%F_Lines,2)
        DO i1 = LBOUND(OutData%F_Lines,1), UBOUND(OutData%F_Lines,1)
          OutData%F_Lines(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%LastIndWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FEAM_UnPackMisc

 SUBROUTINE FEAM_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(FEAM_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
    DstParamData%GRAV = SrcParamData%GRAV
    DstParamData%Eps = SrcParamData%Eps
    DstParamData%Gravity = SrcParamData%Gravity
    DstParamData%WtrDens = SrcParamData%WtrDens
    DstParamData%MaxIter = SrcParamData%MaxIter
    DstParamData%NHBD = SrcParamData%NHBD
    DstParamData%NDIM = SrcParamData%NDIM
IF (ALLOCATED(SrcParamData%NEQ)) THEN
  i1_l = LBOUND(SrcParamData%NEQ,1)
  i1_u = UBOUND(SrcParamData%NEQ,1)
  IF (.NOT. ALLOCATED(DstParamData%NEQ)) THEN 
    ALLOCATE(DstParamData%NEQ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%NEQ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%NEQ = SrcParamData%NEQ
ENDIF
    DstParamData%NBAND = SrcParamData%NBAND
    DstParamData%NumLines = SrcParamData%NumLines
    DstParamData%NumElems = SrcParamData%NumElems
    DstParamData%NumNodes = SrcParamData%NumNodes
IF (ALLOCATED(SrcParamData%GSL)) THEN
  i1_l = LBOUND(SrcParamData%GSL,1)
  i1_u = UBOUND(SrcParamData%GSL,1)
  i2_l = LBOUND(SrcParamData%GSL,2)
  i2_u = UBOUND(SrcParamData%GSL,2)
  i3_l = LBOUND(SrcParamData%GSL,3)
  i3_u = UBOUND(SrcParamData%GSL,3)
  IF (.NOT. ALLOCATED(DstParamData%GSL)) THEN 
    ALLOCATE(DstParamData%GSL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GSL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%GSL = SrcParamData%GSL
ENDIF
IF (ALLOCATED(SrcParamData%GP)) THEN
  i1_l = LBOUND(SrcParamData%GP,1)
  i1_u = UBOUND(SrcParamData%GP,1)
  i2_l = LBOUND(SrcParamData%GP,2)
  i2_u = UBOUND(SrcParamData%GP,2)
  IF (.NOT. ALLOCATED(DstParamData%GP)) THEN 
    ALLOCATE(DstParamData%GP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%GP = SrcParamData%GP
ENDIF
IF (ALLOCATED(SrcParamData%Elength)) THEN
  i1_l = LBOUND(SrcParamData%Elength,1)
  i1_u = UBOUND(SrcParamData%Elength,1)
  IF (.NOT. ALLOCATED(DstParamData%Elength)) THEN 
    ALLOCATE(DstParamData%Elength(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Elength.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Elength = SrcParamData%Elength
ENDIF
IF (ALLOCATED(SrcParamData%BottmElev)) THEN
  i1_l = LBOUND(SrcParamData%BottmElev,1)
  i1_u = UBOUND(SrcParamData%BottmElev,1)
  IF (.NOT. ALLOCATED(DstParamData%BottmElev)) THEN 
    ALLOCATE(DstParamData%BottmElev(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BottmElev.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BottmElev = SrcParamData%BottmElev
ENDIF
IF (ALLOCATED(SrcParamData%BottmStiff)) THEN
  i1_l = LBOUND(SrcParamData%BottmStiff,1)
  i1_u = UBOUND(SrcParamData%BottmStiff,1)
  IF (.NOT. ALLOCATED(DstParamData%BottmStiff)) THEN 
    ALLOCATE(DstParamData%BottmStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BottmStiff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BottmStiff = SrcParamData%BottmStiff
ENDIF
IF (ALLOCATED(SrcParamData%LMassDen)) THEN
  i1_l = LBOUND(SrcParamData%LMassDen,1)
  i1_u = UBOUND(SrcParamData%LMassDen,1)
  IF (.NOT. ALLOCATED(DstParamData%LMassDen)) THEN 
    ALLOCATE(DstParamData%LMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%LMassDen = SrcParamData%LMassDen
ENDIF
IF (ALLOCATED(SrcParamData%LDMassDen)) THEN
  i1_l = LBOUND(SrcParamData%LDMassDen,1)
  i1_u = UBOUND(SrcParamData%LDMassDen,1)
  IF (.NOT. ALLOCATED(DstParamData%LDMassDen)) THEN 
    ALLOCATE(DstParamData%LDMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LDMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%LDMassDen = SrcParamData%LDMassDen
ENDIF
IF (ALLOCATED(SrcParamData%LEAStiff)) THEN
  i1_l = LBOUND(SrcParamData%LEAStiff,1)
  i1_u = UBOUND(SrcParamData%LEAStiff,1)
  IF (.NOT. ALLOCATED(DstParamData%LEAStiff)) THEN 
    ALLOCATE(DstParamData%LEAStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LEAStiff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%LEAStiff = SrcParamData%LEAStiff
ENDIF
IF (ALLOCATED(SrcParamData%LineCI)) THEN
  i1_l = LBOUND(SrcParamData%LineCI,1)
  i1_u = UBOUND(SrcParamData%LineCI,1)
  IF (.NOT. ALLOCATED(DstParamData%LineCI)) THEN 
    ALLOCATE(DstParamData%LineCI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LineCI.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%LineCI = SrcParamData%LineCI
ENDIF
IF (ALLOCATED(SrcParamData%LineCD)) THEN
  i1_l = LBOUND(SrcParamData%LineCD,1)
  i1_u = UBOUND(SrcParamData%LineCD,1)
  IF (.NOT. ALLOCATED(DstParamData%LineCD)) THEN 
    ALLOCATE(DstParamData%LineCD(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%LineCD.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%LineCD = SrcParamData%LineCD
ENDIF
IF (ALLOCATED(SrcParamData%Bvp)) THEN
  i1_l = LBOUND(SrcParamData%Bvp,1)
  i1_u = UBOUND(SrcParamData%Bvp,1)
  i2_l = LBOUND(SrcParamData%Bvp,2)
  i2_u = UBOUND(SrcParamData%Bvp,2)
  IF (.NOT. ALLOCATED(DstParamData%Bvp)) THEN 
    ALLOCATE(DstParamData%Bvp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Bvp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Bvp = SrcParamData%Bvp
ENDIF
IF (ALLOCATED(SrcParamData%WaveAcc0)) THEN
  i1_l = LBOUND(SrcParamData%WaveAcc0,1)
  i1_u = UBOUND(SrcParamData%WaveAcc0,1)
  i2_l = LBOUND(SrcParamData%WaveAcc0,2)
  i2_u = UBOUND(SrcParamData%WaveAcc0,2)
  i3_l = LBOUND(SrcParamData%WaveAcc0,3)
  i3_u = UBOUND(SrcParamData%WaveAcc0,3)
  IF (.NOT. ALLOCATED(DstParamData%WaveAcc0)) THEN 
    ALLOCATE(DstParamData%WaveAcc0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveAcc0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveAcc0 = SrcParamData%WaveAcc0
ENDIF
IF (ALLOCATED(SrcParamData%WaveTime)) THEN
  i1_l = LBOUND(SrcParamData%WaveTime,1)
  i1_u = UBOUND(SrcParamData%WaveTime,1)
  IF (.NOT. ALLOCATED(DstParamData%WaveTime)) THEN 
    ALLOCATE(DstParamData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveTime.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveTime = SrcParamData%WaveTime
ENDIF
IF (ALLOCATED(SrcParamData%WaveVel0)) THEN
  i1_l = LBOUND(SrcParamData%WaveVel0,1)
  i1_u = UBOUND(SrcParamData%WaveVel0,1)
  i2_l = LBOUND(SrcParamData%WaveVel0,2)
  i2_u = UBOUND(SrcParamData%WaveVel0,2)
  i3_l = LBOUND(SrcParamData%WaveVel0,3)
  i3_u = UBOUND(SrcParamData%WaveVel0,3)
  IF (.NOT. ALLOCATED(DstParamData%WaveVel0)) THEN 
    ALLOCATE(DstParamData%WaveVel0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WaveVel0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WaveVel0 = SrcParamData%WaveVel0
ENDIF
    DstParamData%NStepWave = SrcParamData%NStepWave
    DstParamData%SHAP = SrcParamData%SHAP
    DstParamData%SHAPS = SrcParamData%SHAPS
    DstParamData%GAUSSW = SrcParamData%GAUSSW
    DstParamData%NGAUSS = SrcParamData%NGAUSS
    DstParamData%SHAPT = SrcParamData%SHAPT
    DstParamData%SHAPTS = SrcParamData%SHAPTS
    DstParamData%NTRAP = SrcParamData%NTRAP
    DstParamData%SBEND = SrcParamData%SBEND
    DstParamData%STEN = SrcParamData%STEN
    DstParamData%RMASS = SrcParamData%RMASS
    DstParamData%RADDM = SrcParamData%RADDM
    DstParamData%PMPN = SrcParamData%PMPN
    DstParamData%AM = SrcParamData%AM
    DstParamData%PM = SrcParamData%PM
    DstParamData%IDOF = SrcParamData%IDOF
    DstParamData%JDOF = SrcParamData%JDOF
    DstParamData%PPA = SrcParamData%PPA
    DstParamData%PtfmRefzt = SrcParamData%PtfmRefzt
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%RootName = SrcParamData%RootName
IF (ALLOCATED(SrcParamData%OutParam)) THEN
  i1_l = LBOUND(SrcParamData%OutParam,1)
  i1_u = UBOUND(SrcParamData%OutParam,1)
  IF (.NOT. ALLOCATED(DstParamData%OutParam)) THEN 
    ALLOCATE(DstParamData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%OutParam,1), UBOUND(SrcParamData%OutParam,1)
      CALL NWTC_Library_Copyoutparmtype( SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%Delim = SrcParamData%Delim
IF (ALLOCATED(SrcParamData%GLUZR)) THEN
  i1_l = LBOUND(SrcParamData%GLUZR,1)
  i1_u = UBOUND(SrcParamData%GLUZR,1)
  i2_l = LBOUND(SrcParamData%GLUZR,2)
  i2_u = UBOUND(SrcParamData%GLUZR,2)
  i3_l = LBOUND(SrcParamData%GLUZR,3)
  i3_u = UBOUND(SrcParamData%GLUZR,3)
  IF (.NOT. ALLOCATED(DstParamData%GLUZR)) THEN 
    ALLOCATE(DstParamData%GLUZR(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GLUZR.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%GLUZR = SrcParamData%GLUZR
ENDIF
IF (ALLOCATED(SrcParamData%GTZER)) THEN
  i1_l = LBOUND(SrcParamData%GTZER,1)
  i1_u = UBOUND(SrcParamData%GTZER,1)
  i2_l = LBOUND(SrcParamData%GTZER,2)
  i2_u = UBOUND(SrcParamData%GTZER,2)
  IF (.NOT. ALLOCATED(DstParamData%GTZER)) THEN 
    ALLOCATE(DstParamData%GTZER(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%GTZER.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%GTZER = SrcParamData%GTZER
ENDIF
 END SUBROUTINE FEAM_CopyParam

 SUBROUTINE FEAM_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(FEAM_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%NEQ)) THEN
  DEALLOCATE(ParamData%NEQ)
ENDIF
IF (ALLOCATED(ParamData%GSL)) THEN
  DEALLOCATE(ParamData%GSL)
ENDIF
IF (ALLOCATED(ParamData%GP)) THEN
  DEALLOCATE(ParamData%GP)
ENDIF
IF (ALLOCATED(ParamData%Elength)) THEN
  DEALLOCATE(ParamData%Elength)
ENDIF
IF (ALLOCATED(ParamData%BottmElev)) THEN
  DEALLOCATE(ParamData%BottmElev)
ENDIF
IF (ALLOCATED(ParamData%BottmStiff)) THEN
  DEALLOCATE(ParamData%BottmStiff)
ENDIF
IF (ALLOCATED(ParamData%LMassDen)) THEN
  DEALLOCATE(ParamData%LMassDen)
ENDIF
IF (ALLOCATED(ParamData%LDMassDen)) THEN
  DEALLOCATE(ParamData%LDMassDen)
ENDIF
IF (ALLOCATED(ParamData%LEAStiff)) THEN
  DEALLOCATE(ParamData%LEAStiff)
ENDIF
IF (ALLOCATED(ParamData%LineCI)) THEN
  DEALLOCATE(ParamData%LineCI)
ENDIF
IF (ALLOCATED(ParamData%LineCD)) THEN
  DEALLOCATE(ParamData%LineCD)
ENDIF
IF (ALLOCATED(ParamData%Bvp)) THEN
  DEALLOCATE(ParamData%Bvp)
ENDIF
IF (ALLOCATED(ParamData%WaveAcc0)) THEN
  DEALLOCATE(ParamData%WaveAcc0)
ENDIF
IF (ALLOCATED(ParamData%WaveTime)) THEN
  DEALLOCATE(ParamData%WaveTime)
ENDIF
IF (ALLOCATED(ParamData%WaveVel0)) THEN
  DEALLOCATE(ParamData%WaveVel0)
ENDIF
IF (ALLOCATED(ParamData%OutParam)) THEN
DO i1 = LBOUND(ParamData%OutParam,1), UBOUND(ParamData%OutParam,1)
  CALL NWTC_Library_Destroyoutparmtype( ParamData%OutParam(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%OutParam)
ENDIF
IF (ALLOCATED(ParamData%GLUZR)) THEN
  DEALLOCATE(ParamData%GLUZR)
ENDIF
IF (ALLOCATED(ParamData%GTZER)) THEN
  DEALLOCATE(ParamData%GTZER)
ENDIF
 END SUBROUTINE FEAM_DestroyParam

 SUBROUTINE FEAM_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Re_BufSz   = Re_BufSz   + SIZE(InData%GRAV)  ! GRAV
      Re_BufSz   = Re_BufSz   + 1  ! Eps
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
      Re_BufSz   = Re_BufSz   + 1  ! WtrDens
      Int_BufSz  = Int_BufSz  + 1  ! MaxIter
      Int_BufSz  = Int_BufSz  + 1  ! NHBD
      Int_BufSz  = Int_BufSz  + 1  ! NDIM
  Int_BufSz   = Int_BufSz   + 1     ! NEQ allocated yes/no
  IF ( ALLOCATED(InData%NEQ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NEQ upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%NEQ)  ! NEQ
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NBAND
      Int_BufSz  = Int_BufSz  + 1  ! NumLines
      Int_BufSz  = Int_BufSz  + 1  ! NumElems
      Int_BufSz  = Int_BufSz  + 1  ! NumNodes
  Int_BufSz   = Int_BufSz   + 1     ! GSL allocated yes/no
  IF ( ALLOCATED(InData%GSL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GSL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GSL)  ! GSL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GP allocated yes/no
  IF ( ALLOCATED(InData%GP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GP)  ! GP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Elength allocated yes/no
  IF ( ALLOCATED(InData%Elength) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Elength upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Elength)  ! Elength
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BottmElev allocated yes/no
  IF ( ALLOCATED(InData%BottmElev) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BottmElev upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BottmElev)  ! BottmElev
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BottmStiff allocated yes/no
  IF ( ALLOCATED(InData%BottmStiff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BottmStiff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BottmStiff)  ! BottmStiff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LMassDen allocated yes/no
  IF ( ALLOCATED(InData%LMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LMassDen)  ! LMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LDMassDen allocated yes/no
  IF ( ALLOCATED(InData%LDMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LDMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LDMassDen)  ! LDMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LEAStiff allocated yes/no
  IF ( ALLOCATED(InData%LEAStiff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LEAStiff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LEAStiff)  ! LEAStiff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LineCI allocated yes/no
  IF ( ALLOCATED(InData%LineCI) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LineCI upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LineCI)  ! LineCI
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LineCD allocated yes/no
  IF ( ALLOCATED(InData%LineCD) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LineCD upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LineCD)  ! LineCD
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Bvp allocated yes/no
  IF ( ALLOCATED(InData%Bvp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Bvp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Bvp)  ! Bvp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveAcc0 allocated yes/no
  IF ( ALLOCATED(InData%WaveAcc0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveAcc0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveAcc0)  ! WaveAcc0
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveTime allocated yes/no
  IF ( ALLOCATED(InData%WaveTime) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WaveTime upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveTime)  ! WaveTime
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WaveVel0 allocated yes/no
  IF ( ALLOCATED(InData%WaveVel0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! WaveVel0 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WaveVel0)  ! WaveVel0
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NStepWave
      Re_BufSz   = Re_BufSz   + SIZE(InData%SHAP)  ! SHAP
      Re_BufSz   = Re_BufSz   + SIZE(InData%SHAPS)  ! SHAPS
      Re_BufSz   = Re_BufSz   + SIZE(InData%GAUSSW)  ! GAUSSW
      Int_BufSz  = Int_BufSz  + 1  ! NGAUSS
      Re_BufSz   = Re_BufSz   + SIZE(InData%SHAPT)  ! SHAPT
      Re_BufSz   = Re_BufSz   + SIZE(InData%SHAPTS)  ! SHAPTS
      Int_BufSz  = Int_BufSz  + 1  ! NTRAP
      Re_BufSz   = Re_BufSz   + SIZE(InData%SBEND)  ! SBEND
      Re_BufSz   = Re_BufSz   + SIZE(InData%STEN)  ! STEN
      Re_BufSz   = Re_BufSz   + SIZE(InData%RMASS)  ! RMASS
      Re_BufSz   = Re_BufSz   + SIZE(InData%RADDM)  ! RADDM
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMPN)  ! PMPN
      Re_BufSz   = Re_BufSz   + SIZE(InData%AM)  ! AM
      Re_BufSz   = Re_BufSz   + SIZE(InData%PM)  ! PM
      Int_BufSz  = Int_BufSz  + SIZE(InData%IDOF)  ! IDOF
      Int_BufSz  = Int_BufSz  + SIZE(InData%JDOF)  ! JDOF
      Re_BufSz   = Re_BufSz   + SIZE(InData%PPA)  ! PPA
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRefzt
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
  Int_BufSz   = Int_BufSz   + 1     ! OutParam allocated yes/no
  IF ( ALLOCATED(InData%OutParam) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutParam upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      Int_BufSz   = Int_BufSz + 3  ! OutParam: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, .TRUE. ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! OutParam
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! OutParam
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! OutParam
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Delim)  ! Delim
  Int_BufSz   = Int_BufSz   + 1     ! GLUZR allocated yes/no
  IF ( ALLOCATED(InData%GLUZR) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! GLUZR upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GLUZR)  ! GLUZR
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GTZER allocated yes/no
  IF ( ALLOCATED(InData%GTZER) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! GTZER upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GTZER)  ! GTZER
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    DO i1 = LBOUND(InData%GRAV,1), UBOUND(InData%GRAV,1)
      ReKiBuf(Re_Xferred) = InData%GRAV(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    ReKiBuf(Re_Xferred) = InData%Eps
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WtrDens
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%MaxIter
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NHBD
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NDIM
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%NEQ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NEQ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NEQ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NEQ,1), UBOUND(InData%NEQ,1)
        IntKiBuf(Int_Xferred) = InData%NEQ(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NBAND
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumLines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumElems
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumNodes
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%GSL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GSL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GSL,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GSL,3), UBOUND(InData%GSL,3)
        DO i2 = LBOUND(InData%GSL,2), UBOUND(InData%GSL,2)
          DO i1 = LBOUND(InData%GSL,1), UBOUND(InData%GSL,1)
            ReKiBuf(Re_Xferred) = InData%GSL(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GP,2), UBOUND(InData%GP,2)
        DO i1 = LBOUND(InData%GP,1), UBOUND(InData%GP,1)
          ReKiBuf(Re_Xferred) = InData%GP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Elength) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Elength,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Elength,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Elength,1), UBOUND(InData%Elength,1)
        ReKiBuf(Re_Xferred) = InData%Elength(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BottmElev) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BottmElev,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BottmElev,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BottmElev,1), UBOUND(InData%BottmElev,1)
        ReKiBuf(Re_Xferred) = InData%BottmElev(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BottmStiff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BottmStiff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BottmStiff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BottmStiff,1), UBOUND(InData%BottmStiff,1)
        ReKiBuf(Re_Xferred) = InData%BottmStiff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LMassDen,1), UBOUND(InData%LMassDen,1)
        ReKiBuf(Re_Xferred) = InData%LMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LDMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LDMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LDMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LDMassDen,1), UBOUND(InData%LDMassDen,1)
        ReKiBuf(Re_Xferred) = InData%LDMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LEAStiff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LEAStiff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LEAStiff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LEAStiff,1), UBOUND(InData%LEAStiff,1)
        ReKiBuf(Re_Xferred) = InData%LEAStiff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LineCI) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LineCI,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LineCI,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LineCI,1), UBOUND(InData%LineCI,1)
        ReKiBuf(Re_Xferred) = InData%LineCI(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LineCD) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LineCD,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LineCD,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LineCD,1), UBOUND(InData%LineCD,1)
        ReKiBuf(Re_Xferred) = InData%LineCD(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Bvp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Bvp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Bvp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Bvp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Bvp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Bvp,2), UBOUND(InData%Bvp,2)
        DO i1 = LBOUND(InData%Bvp,1), UBOUND(InData%Bvp,1)
          ReKiBuf(Re_Xferred) = InData%Bvp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveAcc0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveAcc0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveAcc0,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveAcc0,3), UBOUND(InData%WaveAcc0,3)
        DO i2 = LBOUND(InData%WaveAcc0,2), UBOUND(InData%WaveAcc0,2)
          DO i1 = LBOUND(InData%WaveAcc0,1), UBOUND(InData%WaveAcc0,1)
            ReKiBuf(Re_Xferred) = InData%WaveAcc0(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveTime) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveTime,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveTime,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WaveTime,1), UBOUND(InData%WaveTime,1)
        ReKiBuf(Re_Xferred) = InData%WaveTime(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WaveVel0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WaveVel0,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WaveVel0,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%WaveVel0,3), UBOUND(InData%WaveVel0,3)
        DO i2 = LBOUND(InData%WaveVel0,2), UBOUND(InData%WaveVel0,2)
          DO i1 = LBOUND(InData%WaveVel0,1), UBOUND(InData%WaveVel0,1)
            ReKiBuf(Re_Xferred) = InData%WaveVel0(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NStepWave
    Int_Xferred = Int_Xferred + 1
    DO i2 = LBOUND(InData%SHAP,2), UBOUND(InData%SHAP,2)
      DO i1 = LBOUND(InData%SHAP,1), UBOUND(InData%SHAP,1)
        ReKiBuf(Re_Xferred) = InData%SHAP(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%SHAPS,2), UBOUND(InData%SHAPS,2)
      DO i1 = LBOUND(InData%SHAPS,1), UBOUND(InData%SHAPS,1)
        ReKiBuf(Re_Xferred) = InData%SHAPS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i1 = LBOUND(InData%GAUSSW,1), UBOUND(InData%GAUSSW,1)
      ReKiBuf(Re_Xferred) = InData%GAUSSW(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%NGAUSS
    Int_Xferred = Int_Xferred + 1
    DO i2 = LBOUND(InData%SHAPT,2), UBOUND(InData%SHAPT,2)
      DO i1 = LBOUND(InData%SHAPT,1), UBOUND(InData%SHAPT,1)
        ReKiBuf(Re_Xferred) = InData%SHAPT(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%SHAPTS,2), UBOUND(InData%SHAPTS,2)
      DO i1 = LBOUND(InData%SHAPTS,1), UBOUND(InData%SHAPTS,1)
        ReKiBuf(Re_Xferred) = InData%SHAPTS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    IntKiBuf(Int_Xferred) = InData%NTRAP
    Int_Xferred = Int_Xferred + 1
    DO i2 = LBOUND(InData%SBEND,2), UBOUND(InData%SBEND,2)
      DO i1 = LBOUND(InData%SBEND,1), UBOUND(InData%SBEND,1)
        ReKiBuf(Re_Xferred) = InData%SBEND(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i3 = LBOUND(InData%STEN,3), UBOUND(InData%STEN,3)
      DO i2 = LBOUND(InData%STEN,2), UBOUND(InData%STEN,2)
        DO i1 = LBOUND(InData%STEN,1), UBOUND(InData%STEN,1)
          ReKiBuf(Re_Xferred) = InData%STEN(i1,i2,i3)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
    END DO
    DO i2 = LBOUND(InData%RMASS,2), UBOUND(InData%RMASS,2)
      DO i1 = LBOUND(InData%RMASS,1), UBOUND(InData%RMASS,1)
        ReKiBuf(Re_Xferred) = InData%RMASS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i4 = LBOUND(InData%RADDM,4), UBOUND(InData%RADDM,4)
      DO i3 = LBOUND(InData%RADDM,3), UBOUND(InData%RADDM,3)
        DO i2 = LBOUND(InData%RADDM,2), UBOUND(InData%RADDM,2)
          DO i1 = LBOUND(InData%RADDM,1), UBOUND(InData%RADDM,1)
            ReKiBuf(Re_Xferred) = InData%RADDM(i1,i2,i3,i4)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
    END DO
    DO i2 = LBOUND(InData%PMPN,2), UBOUND(InData%PMPN,2)
      DO i1 = LBOUND(InData%PMPN,1), UBOUND(InData%PMPN,1)
        ReKiBuf(Re_Xferred) = InData%PMPN(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i1 = LBOUND(InData%AM,1), UBOUND(InData%AM,1)
      ReKiBuf(Re_Xferred) = InData%AM(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%PM,1), UBOUND(InData%PM,1)
      ReKiBuf(Re_Xferred) = InData%PM(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%IDOF,2), UBOUND(InData%IDOF,2)
      DO i1 = LBOUND(InData%IDOF,1), UBOUND(InData%IDOF,1)
        IntKiBuf(Int_Xferred) = InData%IDOF(i1,i2)
        Int_Xferred = Int_Xferred + 1
      END DO
    END DO
    DO i1 = LBOUND(InData%JDOF,1), UBOUND(InData%JDOF,1)
      IntKiBuf(Int_Xferred) = InData%JDOF(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    DO i3 = LBOUND(InData%PPA,3), UBOUND(InData%PPA,3)
      DO i2 = LBOUND(InData%PPA,2), UBOUND(InData%PPA,2)
        DO i1 = LBOUND(InData%PPA,1), UBOUND(InData%PPA,1)
          ReKiBuf(Re_Xferred) = InData%PPA(i1,i2,i3)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
    END DO
    ReKiBuf(Re_Xferred) = InData%PtfmRefzt
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%OutParam) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutParam,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutParam,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, OnlySize ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    DO I = 1, LEN(InData%Delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%GLUZR) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLUZR,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLUZR,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLUZR,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLUZR,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GLUZR,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GLUZR,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%GLUZR,3), UBOUND(InData%GLUZR,3)
        DO i2 = LBOUND(InData%GLUZR,2), UBOUND(InData%GLUZR,2)
          DO i1 = LBOUND(InData%GLUZR,1), UBOUND(InData%GLUZR,1)
            ReKiBuf(Re_Xferred) = InData%GLUZR(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GTZER) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GTZER,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GTZER,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GTZER,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GTZER,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%GTZER,2), UBOUND(InData%GTZER,2)
        DO i1 = LBOUND(InData%GTZER,1), UBOUND(InData%GTZER,1)
          ReKiBuf(Re_Xferred) = InData%GTZER(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FEAM_PackParam

 SUBROUTINE FEAM_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    i1_l = LBOUND(OutData%GRAV,1)
    i1_u = UBOUND(OutData%GRAV,1)
    DO i1 = LBOUND(OutData%GRAV,1), UBOUND(OutData%GRAV,1)
      OutData%GRAV(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%Eps = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WtrDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%MaxIter = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NHBD = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NDIM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NEQ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NEQ)) DEALLOCATE(OutData%NEQ)
    ALLOCATE(OutData%NEQ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NEQ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NEQ,1), UBOUND(OutData%NEQ,1)
        OutData%NEQ(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%NBAND = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumLines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumElems = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GSL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GSL)) DEALLOCATE(OutData%GSL)
    ALLOCATE(OutData%GSL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GSL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GSL,3), UBOUND(OutData%GSL,3)
        DO i2 = LBOUND(OutData%GSL,2), UBOUND(OutData%GSL,2)
          DO i1 = LBOUND(OutData%GSL,1), UBOUND(OutData%GSL,1)
            OutData%GSL(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GP)) DEALLOCATE(OutData%GP)
    ALLOCATE(OutData%GP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GP,2), UBOUND(OutData%GP,2)
        DO i1 = LBOUND(OutData%GP,1), UBOUND(OutData%GP,1)
          OutData%GP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Elength not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Elength)) DEALLOCATE(OutData%Elength)
    ALLOCATE(OutData%Elength(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Elength.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Elength,1), UBOUND(OutData%Elength,1)
        OutData%Elength(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BottmElev not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BottmElev)) DEALLOCATE(OutData%BottmElev)
    ALLOCATE(OutData%BottmElev(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BottmElev.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BottmElev,1), UBOUND(OutData%BottmElev,1)
        OutData%BottmElev(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BottmStiff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BottmStiff)) DEALLOCATE(OutData%BottmStiff)
    ALLOCATE(OutData%BottmStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BottmStiff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BottmStiff,1), UBOUND(OutData%BottmStiff,1)
        OutData%BottmStiff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LMassDen)) DEALLOCATE(OutData%LMassDen)
    ALLOCATE(OutData%LMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LMassDen,1), UBOUND(OutData%LMassDen,1)
        OutData%LMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LDMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LDMassDen)) DEALLOCATE(OutData%LDMassDen)
    ALLOCATE(OutData%LDMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LDMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LDMassDen,1), UBOUND(OutData%LDMassDen,1)
        OutData%LDMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LEAStiff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LEAStiff)) DEALLOCATE(OutData%LEAStiff)
    ALLOCATE(OutData%LEAStiff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LEAStiff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LEAStiff,1), UBOUND(OutData%LEAStiff,1)
        OutData%LEAStiff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LineCI not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LineCI)) DEALLOCATE(OutData%LineCI)
    ALLOCATE(OutData%LineCI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineCI.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LineCI,1), UBOUND(OutData%LineCI,1)
        OutData%LineCI(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LineCD not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LineCD)) DEALLOCATE(OutData%LineCD)
    ALLOCATE(OutData%LineCD(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LineCD.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LineCD,1), UBOUND(OutData%LineCD,1)
        OutData%LineCD(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Bvp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Bvp)) DEALLOCATE(OutData%Bvp)
    ALLOCATE(OutData%Bvp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Bvp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Bvp,2), UBOUND(OutData%Bvp,2)
        DO i1 = LBOUND(OutData%Bvp,1), UBOUND(OutData%Bvp,1)
          OutData%Bvp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveAcc0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveAcc0)) DEALLOCATE(OutData%WaveAcc0)
    ALLOCATE(OutData%WaveAcc0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveAcc0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveAcc0,3), UBOUND(OutData%WaveAcc0,3)
        DO i2 = LBOUND(OutData%WaveAcc0,2), UBOUND(OutData%WaveAcc0,2)
          DO i1 = LBOUND(OutData%WaveAcc0,1), UBOUND(OutData%WaveAcc0,1)
            OutData%WaveAcc0(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveTime not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveTime)) DEALLOCATE(OutData%WaveTime)
    ALLOCATE(OutData%WaveTime(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveTime.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WaveTime,1), UBOUND(OutData%WaveTime,1)
        OutData%WaveTime(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WaveVel0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WaveVel0)) DEALLOCATE(OutData%WaveVel0)
    ALLOCATE(OutData%WaveVel0(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WaveVel0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%WaveVel0,3), UBOUND(OutData%WaveVel0,3)
        DO i2 = LBOUND(OutData%WaveVel0,2), UBOUND(OutData%WaveVel0,2)
          DO i1 = LBOUND(OutData%WaveVel0,1), UBOUND(OutData%WaveVel0,1)
            OutData%WaveVel0(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%NStepWave = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%SHAP,1)
    i1_u = UBOUND(OutData%SHAP,1)
    i2_l = LBOUND(OutData%SHAP,2)
    i2_u = UBOUND(OutData%SHAP,2)
    DO i2 = LBOUND(OutData%SHAP,2), UBOUND(OutData%SHAP,2)
      DO i1 = LBOUND(OutData%SHAP,1), UBOUND(OutData%SHAP,1)
        OutData%SHAP(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%SHAPS,1)
    i1_u = UBOUND(OutData%SHAPS,1)
    i2_l = LBOUND(OutData%SHAPS,2)
    i2_u = UBOUND(OutData%SHAPS,2)
    DO i2 = LBOUND(OutData%SHAPS,2), UBOUND(OutData%SHAPS,2)
      DO i1 = LBOUND(OutData%SHAPS,1), UBOUND(OutData%SHAPS,1)
        OutData%SHAPS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%GAUSSW,1)
    i1_u = UBOUND(OutData%GAUSSW,1)
    DO i1 = LBOUND(OutData%GAUSSW,1), UBOUND(OutData%GAUSSW,1)
      OutData%GAUSSW(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%NGAUSS = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%SHAPT,1)
    i1_u = UBOUND(OutData%SHAPT,1)
    i2_l = LBOUND(OutData%SHAPT,2)
    i2_u = UBOUND(OutData%SHAPT,2)
    DO i2 = LBOUND(OutData%SHAPT,2), UBOUND(OutData%SHAPT,2)
      DO i1 = LBOUND(OutData%SHAPT,1), UBOUND(OutData%SHAPT,1)
        OutData%SHAPT(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%SHAPTS,1)
    i1_u = UBOUND(OutData%SHAPTS,1)
    i2_l = LBOUND(OutData%SHAPTS,2)
    i2_u = UBOUND(OutData%SHAPTS,2)
    DO i2 = LBOUND(OutData%SHAPTS,2), UBOUND(OutData%SHAPTS,2)
      DO i1 = LBOUND(OutData%SHAPTS,1), UBOUND(OutData%SHAPTS,1)
        OutData%SHAPTS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    OutData%NTRAP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%SBEND,1)
    i1_u = UBOUND(OutData%SBEND,1)
    i2_l = LBOUND(OutData%SBEND,2)
    i2_u = UBOUND(OutData%SBEND,2)
    DO i2 = LBOUND(OutData%SBEND,2), UBOUND(OutData%SBEND,2)
      DO i1 = LBOUND(OutData%SBEND,1), UBOUND(OutData%SBEND,1)
        OutData%SBEND(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%STEN,1)
    i1_u = UBOUND(OutData%STEN,1)
    i2_l = LBOUND(OutData%STEN,2)
    i2_u = UBOUND(OutData%STEN,2)
    i3_l = LBOUND(OutData%STEN,3)
    i3_u = UBOUND(OutData%STEN,3)
    DO i3 = LBOUND(OutData%STEN,3), UBOUND(OutData%STEN,3)
      DO i2 = LBOUND(OutData%STEN,2), UBOUND(OutData%STEN,2)
        DO i1 = LBOUND(OutData%STEN,1), UBOUND(OutData%STEN,1)
          OutData%STEN(i1,i2,i3) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
    END DO
    i1_l = LBOUND(OutData%RMASS,1)
    i1_u = UBOUND(OutData%RMASS,1)
    i2_l = LBOUND(OutData%RMASS,2)
    i2_u = UBOUND(OutData%RMASS,2)
    DO i2 = LBOUND(OutData%RMASS,2), UBOUND(OutData%RMASS,2)
      DO i1 = LBOUND(OutData%RMASS,1), UBOUND(OutData%RMASS,1)
        OutData%RMASS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%RADDM,1)
    i1_u = UBOUND(OutData%RADDM,1)
    i2_l = LBOUND(OutData%RADDM,2)
    i2_u = UBOUND(OutData%RADDM,2)
    i3_l = LBOUND(OutData%RADDM,3)
    i3_u = UBOUND(OutData%RADDM,3)
    i4_l = LBOUND(OutData%RADDM,4)
    i4_u = UBOUND(OutData%RADDM,4)
    DO i4 = LBOUND(OutData%RADDM,4), UBOUND(OutData%RADDM,4)
      DO i3 = LBOUND(OutData%RADDM,3), UBOUND(OutData%RADDM,3)
        DO i2 = LBOUND(OutData%RADDM,2), UBOUND(OutData%RADDM,2)
          DO i1 = LBOUND(OutData%RADDM,1), UBOUND(OutData%RADDM,1)
            OutData%RADDM(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
    END DO
    i1_l = LBOUND(OutData%PMPN,1)
    i1_u = UBOUND(OutData%PMPN,1)
    i2_l = LBOUND(OutData%PMPN,2)
    i2_u = UBOUND(OutData%PMPN,2)
    DO i2 = LBOUND(OutData%PMPN,2), UBOUND(OutData%PMPN,2)
      DO i1 = LBOUND(OutData%PMPN,1), UBOUND(OutData%PMPN,1)
        OutData%PMPN(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%AM,1)
    i1_u = UBOUND(OutData%AM,1)
    DO i1 = LBOUND(OutData%AM,1), UBOUND(OutData%AM,1)
      OutData%AM(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%PM,1)
    i1_u = UBOUND(OutData%PM,1)
    DO i1 = LBOUND(OutData%PM,1), UBOUND(OutData%PM,1)
      OutData%PM(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%IDOF,1)
    i1_u = UBOUND(OutData%IDOF,1)
    i2_l = LBOUND(OutData%IDOF,2)
    i2_u = UBOUND(OutData%IDOF,2)
    DO i2 = LBOUND(OutData%IDOF,2), UBOUND(OutData%IDOF,2)
      DO i1 = LBOUND(OutData%IDOF,1), UBOUND(OutData%IDOF,1)
        OutData%IDOF(i1,i2) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%JDOF,1)
    i1_u = UBOUND(OutData%JDOF,1)
    DO i1 = LBOUND(OutData%JDOF,1), UBOUND(OutData%JDOF,1)
      OutData%JDOF(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%PPA,1)
    i1_u = UBOUND(OutData%PPA,1)
    i2_l = LBOUND(OutData%PPA,2)
    i2_u = UBOUND(OutData%PPA,2)
    i3_l = LBOUND(OutData%PPA,3)
    i3_u = UBOUND(OutData%PPA,3)
    DO i3 = LBOUND(OutData%PPA,3), UBOUND(OutData%PPA,3)
      DO i2 = LBOUND(OutData%PPA,2), UBOUND(OutData%PPA,2)
        DO i1 = LBOUND(OutData%PPA,1), UBOUND(OutData%PPA,1)
          OutData%PPA(i1,i2,i3) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
    END DO
    OutData%PtfmRefzt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutParam not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutParam)) DEALLOCATE(OutData%OutParam)
    ALLOCATE(OutData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%OutParam,1), UBOUND(OutData%OutParam,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackoutparmtype( Re_Buf, Db_Buf, Int_Buf, OutData%OutParam(i1), ErrStat2, ErrMsg2 ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    DO I = 1, LEN(OutData%Delim)
      OutData%Delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GLUZR not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GLUZR)) DEALLOCATE(OutData%GLUZR)
    ALLOCATE(OutData%GLUZR(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GLUZR.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%GLUZR,3), UBOUND(OutData%GLUZR,3)
        DO i2 = LBOUND(OutData%GLUZR,2), UBOUND(OutData%GLUZR,2)
          DO i1 = LBOUND(OutData%GLUZR,1), UBOUND(OutData%GLUZR,1)
            OutData%GLUZR(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GTZER not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GTZER)) DEALLOCATE(OutData%GTZER)
    ALLOCATE(OutData%GTZER(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GTZER.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%GTZER,2), UBOUND(OutData%GTZER,2)
        DO i1 = LBOUND(OutData%GTZER,1), UBOUND(OutData%GTZER,1)
          OutData%GTZER(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FEAM_UnPackParam

 SUBROUTINE FEAM_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(FEAM_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL MeshCopy( SrcInputData%HydroForceLineMesh, DstInputData%HydroForceLineMesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MeshCopy( SrcInputData%PtFairleadDisplacement, DstInputData%PtFairleadDisplacement, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE FEAM_CopyInput

 SUBROUTINE FEAM_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(FEAM_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL MeshDestroy( InputData%HydroForceLineMesh, ErrStat, ErrMsg )
  CALL MeshDestroy( InputData%PtFairleadDisplacement, ErrStat, ErrMsg )
 END SUBROUTINE FEAM_DestroyInput

 SUBROUTINE FEAM_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! HydroForceLineMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%HydroForceLineMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! HydroForceLineMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! HydroForceLineMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! HydroForceLineMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! HydroForceLineMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! PtFairleadDisplacement: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PtFairleadDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PtFairleadDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PtFairleadDisplacement
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PtFairleadDisplacement
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PtFairleadDisplacement
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL MeshPack( InData%HydroForceLineMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! HydroForceLineMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MeshPack( InData%PtFairleadDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PtFairleadDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE FEAM_PackInput

 SUBROUTINE FEAM_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%HydroForceLineMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! HydroForceLineMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%PtFairleadDisplacement, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! PtFairleadDisplacement 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE FEAM_UnPackInput

 SUBROUTINE FEAM_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FEAM_OutputType), INTENT(INOUT) :: SrcOutputData
   TYPE(FEAM_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
      CALL MeshCopy( SrcOutputData%PtFairleadLoad, DstOutputData%PtFairleadLoad, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MeshCopy( SrcOutputData%LineMeshPosition, DstOutputData%LineMeshPosition, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE FEAM_CopyOutput

 SUBROUTINE FEAM_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(FEAM_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FEAM_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
  CALL MeshDestroy( OutputData%PtFairleadLoad, ErrStat, ErrMsg )
  CALL MeshDestroy( OutputData%LineMeshPosition, ErrStat, ErrMsg )
 END SUBROUTINE FEAM_DestroyOutput

 SUBROUTINE FEAM_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FEAM_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! PtFairleadLoad: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PtFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PtFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PtFairleadLoad
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PtFairleadLoad
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PtFairleadLoad
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! LineMeshPosition: size of buffers for each call to pack subtype
      CALL MeshPack( InData%LineMeshPosition, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! LineMeshPosition 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! LineMeshPosition
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! LineMeshPosition
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! LineMeshPosition
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      CALL MeshPack( InData%PtFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PtFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MeshPack( InData%LineMeshPosition, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! LineMeshPosition 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE FEAM_PackOutput

 SUBROUTINE FEAM_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FEAM_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FEAM_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%PtFairleadLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! PtFairleadLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%LineMeshPosition, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! LineMeshPosition 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE FEAM_UnPackOutput


 SUBROUTINE FEAM_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(FEAM_InputType), INTENT(INOUT)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'FEAM_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL FEAM_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL FEAM_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL FEAM_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE FEAM_Input_ExtrapInterp


 SUBROUTINE FEAM_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(FEAM_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'FEAM_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
      CALL MeshExtrapInterp1(u1%HydroForceLineMesh, u2%HydroForceLineMesh, tin, u_out%HydroForceLineMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      CALL MeshExtrapInterp1(u1%PtFairleadDisplacement, u2%PtFairleadDisplacement, tin, u_out%PtFairleadDisplacement, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE FEAM_Input_ExtrapInterp1


 SUBROUTINE FEAM_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(FEAM_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(FEAM_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'FEAM_Input_ExtrapInterp2'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
      CALL MeshExtrapInterp2(u1%HydroForceLineMesh, u2%HydroForceLineMesh, u3%HydroForceLineMesh, tin, u_out%HydroForceLineMesh, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      CALL MeshExtrapInterp2(u1%PtFairleadDisplacement, u2%PtFairleadDisplacement, u3%PtFairleadDisplacement, tin, u_out%PtFairleadDisplacement, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE FEAM_Input_ExtrapInterp2


 SUBROUTINE FEAM_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'FEAM_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL FEAM_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL FEAM_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL FEAM_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE FEAM_Output_ExtrapInterp


 SUBROUTINE FEAM_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'FEAM_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp1(y1%PtFairleadLoad, y2%PtFairleadLoad, tin, y_out%PtFairleadLoad, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      CALL MeshExtrapInterp1(y1%LineMeshPosition, y2%LineMeshPosition, tin, y_out%LineMeshPosition, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE FEAM_Output_ExtrapInterp1


 SUBROUTINE FEAM_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(FEAM_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'FEAM_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
      CALL MeshExtrapInterp2(y1%PtFairleadLoad, y2%PtFairleadLoad, y3%PtFairleadLoad, tin, y_out%PtFairleadLoad, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      CALL MeshExtrapInterp2(y1%LineMeshPosition, y2%LineMeshPosition, y3%LineMeshPosition, tin, y_out%LineMeshPosition, tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 END SUBROUTINE FEAM_Output_ExtrapInterp2

END MODULE FEAMooring_Types
!ENDOFREGISTRYGENERATEDFILE
