!STARTOFREGISTRYGENERATEDFILE 'ElastoDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! ElastoDyn_Types
!.................................................................................................................................
! This file is part of ElastoDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in ElastoDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE ElastoDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ED_NMX = 4      ! Used in updating predictor-corrector values (size of state history) [-]
! =========  ED_InitInputType  =======
  TYPE, PUBLIC :: ED_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    CHARACTER(1024)  :: ADInputFile      !< Name of the AeroDyn input file (in this verison, that is where we'll get the blade mesh info [-]
    LOGICAL  :: CompElast      !< flag to determine if ElastoDyn is computing blade loads (true) or BeamDyn is (false) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi)  :: Gravity      !< Gravitational acceleration [m/s^2]
  END TYPE ED_InitInputType
! =======================
! =========  ED_InitOutputType  =======
  TYPE, PUBLIC :: ED_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: NumBl      !< Number of blades on the turbine [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: BladeLength      !< Blade length (for AeroDyn) [meters]
    REAL(ReKi)  :: TowerHeight      !< Tower Height [meters]
    REAL(ReKi)  :: TowerBaseHeight      !< Tower Base Height [meters]
    REAL(ReKi)  :: HubHt      !< Height of the hub [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldRNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrHNodes      !< Location of variable-spaced tower nodes (relative to the tower rigid base height [-]
    REAL(ReKi) , DIMENSION(1:6)  :: PlatformPos      !< Initial platform position (6 DOFs) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TwrBaseRefPos      !< initial position of the tower base (for SrvD) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: TwrBaseTransDisp      !< initial displacement of the tower base (for SrvD) [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseRefOrient      !< reference orientation of the tower base (for SrvD) [-]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: TwrBaseOrient      !< initial orientation of the tower base (for SrvD) [-]
    REAL(ReKi)  :: HubRad      !< Preconed hub radius (distance from the rotor apex to the blade root) [m]
    REAL(ReKi)  :: RotSpeed      !< Initial or fixed rotor speed [rad/s]
    LOGICAL  :: isFixed_GenDOF      !< whether the generator is fixed or free [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
  END TYPE ED_InitOutputType
! =======================
! =========  BladeInputData  =======
  TYPE, PUBLIC :: BladeInputData
    INTEGER(IntKi)  :: NBlInpSt      !< Number of blade input stations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlFract      !< Blade fractional radius for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PitchAx      !< Pitch axis for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StrcTwst      !< Structural twist for distributed input data [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BMassDen      !< Blade mass density for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FlpStff      !< Blade flap stiffness for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgStff      !< Blade edge stiffness for distributed input data [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: GJStff      !< Blade torsional stiffness for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EAStff      !< Blade extensional stiffness for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Alpha      !< Blade coupling coefficient between flap and twist for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FlpIner      !< Blade flap (about local structural yb-axis) mass inertia per unit length for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgIner      !< Blade edge (about local structural xb-axis) mass inertia per unit length for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PrecrvRef      !< Offset for defining the reference axis from the pitch axis for precurved blades at a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PreswpRef      !< Offset for defining the reference axis from the pitch axis for preswept blades at a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FlpcgOf      !< Blade flap (along local aerodynamic xb-axis) mass cg offset for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgcgOf      !< Blade edge (along local aerodynamic yb-axis) mass cg offset for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FlpEAOf      !< Blade flap (along local aerodynamic xb-axis) elastic axis offset for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgEAOf      !< Blade edge (along local aerodynamic yb-axis) elastic axis offset for a given input station [-]
    REAL(ReKi) , DIMENSION(1:2)  :: BldFlDmp      !< Blade structural damping ratios in flapwise direction [-]
    REAL(ReKi) , DIMENSION(1:1)  :: BldEdDmp      !< Blade structural damping ratios in edgewise direction [-]
    REAL(ReKi) , DIMENSION(1:2)  :: FlStTunr      !< Blade flapwise modal stiffness tuners (input) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldFl1Sh      !< Blade-flap-mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldFl2Sh      !< Blade-flap-mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldEdgSh      !< Blade-edge-mode shape coefficients [-]
  END TYPE BladeInputData
! =======================
! =========  ED_BladeMeshInputData  =======
  TYPE, PUBLIC :: ED_BladeMeshInputData
    INTEGER(IntKi)  :: BldNodes      !< Number of blade nodes used for analysis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AeroTwst      !< Aerodynamic twist of the blade at the analysis nodes [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Chord      !< Chord of the blade at the analysis nodes [-]
  END TYPE ED_BladeMeshInputData
! =======================
! =========  ED_InputFile  =======
  TYPE, PUBLIC :: ED_InputFile
    REAL(DbKi)  :: DT      !< Requested integration time for ElastoDyn [seconds]
    LOGICAL  :: FlapDOF1      !< First flapwise blade mode DOF [-]
    LOGICAL  :: FlapDOF2      !< Second flapwise blade mode DOF [-]
    LOGICAL  :: EdgeDOF      !< Edgewise blade mode DOF [-]
    LOGICAL  :: TeetDOF      !< Rotor-teeter DOF [-]
    LOGICAL  :: DrTrDOF      !< Drivetrain rotational-flexibility DOF [-]
    LOGICAL  :: GenDOF      !< Generator DOF [-]
    LOGICAL  :: YawDOF      !< Nacelle-yaw DOF [-]
    LOGICAL  :: TwFADOF1      !< First tower fore-aft bending-mode DOF [-]
    LOGICAL  :: TwFADOF2      !< Second tower fore-aft bending-mode DOF [-]
    LOGICAL  :: TwSSDOF1      !< First tower side-to-side bending-mode DOF [-]
    LOGICAL  :: TwSSDOF2      !< Second tower side-to-side bending-mode DOF [-]
    LOGICAL  :: PtfmSgDOF      !< Platform horizontal surge translation DOF [-]
    LOGICAL  :: PtfmSwDOF      !< Platform horizontal sway translation DOF [-]
    LOGICAL  :: PtfmHvDOF      !< Platform vertical heave translation DOF [-]
    LOGICAL  :: PtfmRDOF      !< Platform roll tilt rotation DOF [-]
    LOGICAL  :: PtfmPDOF      !< Platform pitch tilt rotation DOF [-]
    LOGICAL  :: PtfmYDOF      !< Platform yaw rotation DOF [-]
    REAL(ReKi)  :: OoPDefl      !< Initial out-of-plane blade-tip displacement [meters]
    REAL(ReKi)  :: IPDefl      !< Initial in-plane blade-tip deflection [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Initial blade pitch angles [radians]
    REAL(ReKi)  :: TeetDefl      !< Initial teeter angle [radians]
    REAL(R8Ki)  :: Azimuth      !< Initial azimuth angle for blade 1 [radians]
    REAL(ReKi)  :: RotSpeed      !< Initial rotor speed [rad/s]
    REAL(ReKi)  :: NacYaw      !< Initial nacelle-yaw angle [radians]
    REAL(ReKi)  :: TTDspFA      !< Initial fore-aft tower-top displacement [meters]
    REAL(ReKi)  :: TTDspSS      !< Initial side-to-side tower-top displacement [meters]
    REAL(ReKi)  :: PtfmSurge      !< Initial horizontal surge translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmSway      !< Initial horizontal sway translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmHeave      !< Initial vertical heave translational displacement of platform [meters]
    REAL(ReKi)  :: PtfmRoll      !< Initial roll tilt rotational displacement of platform [radians]
    REAL(ReKi)  :: PtfmPitch      !< Initial pitch tilt rotational displacement of platform [radians]
    REAL(ReKi)  :: PtfmYaw      !< Initial yaw rotational displacement of platform [radians]
    INTEGER(IntKi)  :: NumBl      !< Number of blades [-]
    REAL(ReKi)  :: TipRad      !< Preconed blade-tip radius (distance from the rotor apex to the blade tip) [meters]
    REAL(ReKi)  :: HubRad      !< Preconed hub radius (distance from the rotor apex to the blade root) [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PreCone      !< Rotor precone angles [radians]
    REAL(ReKi)  :: HubCM      !< Distance from rotor apex to hub mass [meters]
    REAL(ReKi)  :: UndSling      !< Undersling length [meters]
    REAL(ReKi)  :: Delta3      !< Delta-3 angle for teetering rotors [radians]
    REAL(R8Ki)  :: AzimB1Up      !< Azimuth value to use for I/O when blade 1 points up [radians]
    REAL(ReKi)  :: OverHang      !< Distance from yaw axis to rotor apex or teeter pin [meters]
    REAL(ReKi)  :: ShftGagL      !< Distance from hub or teeter pin to shaft strain gages [meters]
    REAL(ReKi)  :: ShftTilt      !< Rotor shaft tilt angle [radians]
    REAL(ReKi)  :: NacCMxn      !< Downwind distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NacCMyn      !< Lateral distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NacCMzn      !< Vertical distance from tower-top to nacelle CM [meters]
    REAL(ReKi)  :: NcIMUxn      !< Downwind distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: NcIMUyn      !< Lateral distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: NcIMUzn      !< Vertical distance from the tower-top to the nacelle IMU [meters]
    REAL(ReKi)  :: Twr2Shft      !< Vertical distance from the tower-top to the rotor shaft [meters]
    REAL(ReKi)  :: TowerHt      !< Height of tower above ground level [onshore] or MSL [offshore] [meters]
    REAL(ReKi)  :: TowerBsHt      !< Height of tower base above ground level [onshore] or MSL [offshore] [meters]
    REAL(ReKi)  :: PtfmCMxt      !< Downwind distance from the ground [onshore] or MSL [offshore] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMyt      !< Lateral distance from the ground [onshore] or MSL [offshore] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMzt      !< Vertical distance from the ground [onshore] or MSL [offshore] to the platform CM [meters]
    REAL(ReKi)  :: PtfmRefzt      !< Vertical distance from the ground [onshore] or MSL [offshore] to the platform reference point [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TipMass      !< Tip-brake masses [kg]
    REAL(ReKi)  :: HubMass      !< Hub mass [kg]
    REAL(ReKi)  :: HubIner      !< Hub inertia about teeter axis (2-blader) or rotor axis (3-blader) [kg m^2]
    REAL(ReKi)  :: GenIner      !< Generator inertia about HSS [kg m^2]
    REAL(ReKi)  :: NacMass      !< Nacelle mass [kg]
    REAL(ReKi)  :: NacYIner      !< Nacelle yaw inertia [kg m^2]
    REAL(ReKi)  :: YawBrMass      !< Yaw bearing mass [kg]
    REAL(ReKi)  :: PtfmMass      !< Platform mass [kg]
    REAL(ReKi)  :: PtfmRIner      !< Platform inertia for roll tilt rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmPIner      !< Platform inertia for pitch tilt rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: PtfmYIner      !< Platform inertia for yaw rotation about the platform CM [kg m^2]
    REAL(ReKi)  :: BldNodes      !< Number of blade nodes (per blade) used for analysis [-]
    TYPE(ED_BladeMeshInputData) , DIMENSION(:), ALLOCATABLE  :: InpBlMesh      !< Input data for blade discretizations (could be on each blade) [see BladeMeshInputData]
    TYPE(BladeInputData) , DIMENSION(:), ALLOCATABLE  :: InpBl      !< Input data for individual blades [see BladeInputData type]
    INTEGER(IntKi)  :: TeetMod      !< Rotor-teeter spring/damper model switch [-]
    REAL(ReKi)  :: TeetDmpP      !< Rotor-teeter damper position [radians]
    REAL(ReKi)  :: TeetDmp      !< Rotor-teeter damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TeetCDmp      !< Rotor-teeter rate-independent Coulomb-damping [N-m]
    REAL(ReKi)  :: TeetSStP      !< Rotor-teeter soft-stop position [radians]
    REAL(ReKi)  :: TeetHStP      !< Rotor-teeter hard-stop position [radians]
    REAL(ReKi)  :: TeetSSSp      !< Rotor-teeter soft-stop linear-spring constant [N-m/rad]
    REAL(ReKi)  :: TeetHSSp      !< Rotor-teeter hard-stop linear-spring constant [N-m/rad]
    REAL(ReKi)  :: GBoxEff      !< Gearbox efficiency [%]
    REAL(ReKi)  :: GBRatio      !< Gearbox ratio [-]
    REAL(ReKi)  :: DTTorSpr      !< Drivetrain torsional spring [N-m/rad]
    REAL(ReKi)  :: DTTorDmp      !< Drivetrain torsional damper [N-m/(rad/s)]
    LOGICAL  :: Furling      !< Use Additional Furling parameters? [-]
    INTEGER(IntKi)  :: TwrNodes      !< Number of tower nodes used in the analysis [-]
    LOGICAL  :: SumPrint      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: OutFile      !< Switch to determine where output will be placed: (1: in module output file only; 2: in glue code output file only; 3: both) [-]
    LOGICAL  :: TabDelim      !< Flag to cause tab-delimited text output (delimited by space otherwise) [-]
    CHARACTER(20)  :: OutFmt      !< Format used for module's text tabular output (except time); resulting field should be 10 characters [-]
    REAL(DbKi)  :: Tstart      !< Time to start module's tabular output [seconds]
    INTEGER(IntKi)  :: DecFact      !< Decimation factor for module's tabular output (1=output every step) [-]
    INTEGER(IntKi)  :: NTwGages      !< Number of tower strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwrGagNd      !< Nodes closest to the tower strain gages [-]
    INTEGER(IntKi)  :: NBlGages      !< Number of blade strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BldGagNd      !< Nodes closest to the blade strain gages [-]
    INTEGER(IntKi)  :: NumOuts      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    INTEGER(IntKi)  :: NTwInpSt      !< Number of tower input stations [-]
    REAL(ReKi) , DIMENSION(1:2)  :: TwrFADmp      !< Tower fore-aft structural damping ratios [%]
    REAL(ReKi) , DIMENSION(1:2)  :: TwrSSDmp      !< Tower side-to-side structural damping ratios [%]
    REAL(ReKi) , DIMENSION(1:2)  :: FAStTunr      !< Tower fore-aft modal stiffness tuners [-]
    REAL(ReKi) , DIMENSION(1:2)  :: SSStTunr      !< Tower side-to-side modal stiffness tuners [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HtFract      !< Fractional height of the flexible portion of tower for a given input station [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TMassDen      !< Tower mass density for a given input station [kg/m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAStif      !< Tower fore-aft stiffness for a given input station [Nm^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSStif      !< Tower side-to-side stiffness for a given input station [Nm^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAM1Sh      !< Tower fore-aft mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAM2Sh      !< Tower fore-aft mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSM1Sh      !< Tower side-to-side mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSM2Sh      !< Tower side-to-side mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwGJStif      !< Tower torsional stiffness for a given input station [Nm^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwEAStif      !< Tower extensional stiffness for a given input station [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAIner      !< Tower fore-aft (about yt-axis) mass inertia per unit length for a given input station [kg m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSSIner      !< Tower side-to-side (about xt-axis) mass inertia per unit length for a given input station [kg m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwFAcgOf      !< Tower fore-aft (along the xt-axis) mass cg offset for a given input station [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwSScgOf      !< Tower fore-aft (along the yt-axis) mass cg offset for a given input station [meters]
    LOGICAL  :: RFrlDOF      !< Rotor-furl DOF [-]
    LOGICAL  :: TFrlDOF      !< Tail-furl DOF [-]
    REAL(ReKi)  :: RotFurl      !< Initial or fixed rotor-furl angle [radians]
    REAL(ReKi)  :: TailFurl      !< Initial or fixed tail-furl angle [radians]
    REAL(ReKi)  :: Yaw2Shft      !< Lateral distance from the yaw axis to the rotor shaft [meters]
    REAL(ReKi)  :: ShftSkew      !< Rotor shaft skew angle [radians]
    REAL(ReKi)  :: RFrlCMxn      !< Downwind distance from tower-top to rotor-furl CM [meters]
    REAL(ReKi)  :: RFrlCMyn      !< Lateral distance from tower-top to rotor-furl CM [meters]
    REAL(ReKi)  :: RFrlCMzn      !< Vertical distance from tower-top to rotor-furl CM [meters]
    REAL(ReKi)  :: BoomCMxn      !< Downwind distance from tower-top to tail boom CM [meters]
    REAL(ReKi)  :: BoomCMyn      !< Lateral distance from tower-top to tail boom CM [meters]
    REAL(ReKi)  :: BoomCMzn      !< Vertical distance from tower-top to tail boom CM [meters]
    REAL(ReKi)  :: TFinCMxn      !< Downwind distance from tower-top to tail fin CM [meters]
    REAL(ReKi)  :: TFinCMyn      !< Lateral distance from tower-top to tail fin CM [meters]
    REAL(ReKi)  :: TFinCMzn      !< Vertical distance from tower-top to tail fin CM [meters]
    REAL(ReKi)  :: TFinCPxn      !< Downwind distance from tower-top to tail fin CP [meters]
    REAL(ReKi)  :: TFinCPyn      !< Lateral distance from tower-top to tail fin CP [meters]
    REAL(ReKi)  :: TFinCPzn      !< Vertical distance from tower-top to tail fin CP [meters]
    REAL(ReKi)  :: TFinSkew      !< Tail fin chordline skew angle [radians]
    REAL(ReKi)  :: TFinTilt      !< Tail fin chordline tilt angle [radians]
    REAL(ReKi)  :: TFinBank      !< Tail fin planform bank angle [radians]
    REAL(ReKi)  :: RFrlPntxn      !< Downwind distance from tower-top to arbitrary point on rotor-furl axis [meters]
    REAL(ReKi)  :: RFrlPntyn      !< Lateral distance from tower-top to arbitrary point on rotor-furl axis [meters]
    REAL(ReKi)  :: RFrlPntzn      !< Vertical distance from tower-top to arbitrary point on rotor-furl axis [meters]
    REAL(ReKi)  :: RFrlSkew      !< Rotor-furl axis skew angle [radians]
    REAL(ReKi)  :: RFrlTilt      !< Rotor-furl axis tilt angle [radians]
    REAL(ReKi)  :: TFrlPntxn      !< Downwind distance from tower-top to arbitrary point on tail-furl axis [meters]
    REAL(ReKi)  :: TFrlPntyn      !< Lateral distance from tower-top to arbitrary point on tail-furl axis [meters]
    REAL(ReKi)  :: TFrlPntzn      !< Vertical distance from tower-top to arbitrary point on tail-furl axis [meters]
    REAL(ReKi)  :: TFrlSkew      !< Rotor-furl axis skew angle [radians]
    REAL(ReKi)  :: TFrlTilt      !< Rotor-furl axis tilt angle [radians]
    REAL(ReKi)  :: RFrlMass      !< Rotor-furl mass [kg]
    REAL(ReKi)  :: BoomMass      !< Tail boom mass [kg]
    REAL(ReKi)  :: TFinMass      !< Tail fin mass [kg]
    REAL(ReKi)  :: RFrlIner      !< Rotor-furl inertia about rotor-furl axis [kg m^2]
    REAL(ReKi)  :: TFrlIner      !< Tail boom inertia about tail-furl axis [kg m^2]
    INTEGER(IntKi)  :: RFrlMod      !< Rotor-furl spring/damper model switch [-]
    REAL(ReKi)  :: RFrlSpr      !< Rotor-furl spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlDmp      !< Rotor-furl damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: RFrlCDmp      !< Rotor-furl rate-independent Coulomb-damping moment [N-m]
    REAL(ReKi)  :: RFrlUSSP      !< Rotor-furl up-stop spring position [radians]
    REAL(ReKi)  :: RFrlDSSP      !< Rotor-furl down-stop spring position [radians]
    REAL(ReKi)  :: RFrlUSSpr      !< Rotor-furl up-stop spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlDSSpr      !< Rotor-furl down-stop spring constant [N-m/rad]
    REAL(ReKi)  :: RFrlUSDP      !< Rotor-furl up-stop damper position [radians]
    REAL(ReKi)  :: RFrlDSDP      !< Rotor-furl down-stop damper position [radians]
    REAL(ReKi)  :: RFrlUSDmp      !< Rotor-furl up-stop damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: RFrlDSDmp      !< Rotor-furl down-stop damping constant [N-m/(rad/s)]
    INTEGER(IntKi)  :: TFrlMod      !< Tail-furl spring/damper model switch [-]
    REAL(ReKi)  :: TFrlSpr      !< Tail-furl spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlDmp      !< Tail-furl damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TFrlCDmp      !< Tail-furl rate-independent Coulomb-damping moment [N-m]
    REAL(ReKi)  :: TFrlUSSP      !< Tail-furl up-stop spring position [radians]
    REAL(ReKi)  :: TFrlDSSP      !< Tail-furl down-stop spring position [radians]
    REAL(ReKi)  :: TFrlUSSpr      !< Tail-furl up-stop spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlDSSpr      !< Tail-furl down-stop spring constant [N-m/rad]
    REAL(ReKi)  :: TFrlUSDP      !< Tail-furl up-stop damper position [radians]
    REAL(ReKi)  :: TFrlDSDP      !< Tail-furl down-stop damper position [radians]
    REAL(ReKi)  :: TFrlUSDmp      !< Tail-furl up-stop damping constant [N-m/(rad/s)]
    REAL(ReKi)  :: TFrlDSDmp      !< Tail-furl down-stop damping constant [N-m/(rad/s)]
    INTEGER(IntKi)  :: method      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    INTEGER(IntKi)  :: BldNd_NumOuts      !< Number of requested output channels per blade node (ED_AllBldNdOuts) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutList      !< List of user-requested output channels (ED_AllBldNdOuts) [-]
    CHARACTER(1024)  :: BldNd_BlOutNd_Str      !< String to parse for the blade nodes to actually output (ED_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_BladesOut      !< The blades to output (ED_AllBldNdOuts) [-]
  END TYPE ED_InputFile
! =======================
! =========  ED_CoordSys  =======
  TYPE, PUBLIC :: ED_CoordSys
    REAL(R8Ki) , DIMENSION(1:3)  :: a1      !< Vector / direction a1 (=  xt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: a2      !< Vector / direction a2 (=  zt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: a3      !< Vector / direction a3 (= -yt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b1      !< Vector / direction b1 (=  xp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b2      !< Vector / direction b2 (=  zp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: b3      !< Vector / direction b3 (= -yp from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c1      !< Vector / direction c1 (=  xs from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c2      !< Vector / direction c2 (=  zs from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: c3      !< Vector / direction c3 (= -ys from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d1      !< Vector / direction d1 (=  xn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d2      !< Vector / direction d2 (=  zn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: d3      !< Vector / direction d3 (= -yn from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e1      !< Vector / direction e1 (=  xa from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e2      !< Vector / direction e2 (=  ya from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: e3      !< Vector / direction e3 (=  za from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f1      !< Vector / direction f1 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f2      !< Vector / direction f2 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: f3      !< Vector / direction f3 [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g1      !< Vector / direction g1 (=  xh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g2      !< Vector / direction g2 (=  yh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: g3      !< Vector / direction g3 (=  zh from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i1      !< i1(K,:) = vector / direction i1 for blade K (=  xcK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i2      !< i2(K,:) = vector / direction i2 for blade K (=  ycK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: i3      !< i3(K,:) = vector / direction i3 for blade K (=  zcK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j1      !< j1(K,:) = vector / direction j1 for blade K (=  xbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j2      !< j2(K,:) = vector / direction j2 for blade K (=  ybK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: j3      !< j3(K,:) = vector / direction j3 for blade K (=  zbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m1      !< m1(K,J,:) = vector / direction m1 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m2      !< m2(K,J,:) = vector / direction m2 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: m3      !< m3(K,J,:) = vector / direction m3 for node J of blade K (used to calc. and return aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n1      !< n1(K,J,:) = vector / direction n1 for node J of blade K (= LxbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n2      !< n2(K,J,:) = vector / direction n2 for node J of blade K (= LybK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: n3      !< n3(K,J,:) = vector / direction n3 for node J of blade K (= LzbK from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: p1      !< Vector / direction p1 (used to calc. and return tail aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: p2      !< Vector / direction p2 (used to calc. and return tail aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: p3      !< Vector / direction p3 (used to calc. and return tail aerodynamic loads from AeroDyn) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf1      !< Vector / direction rf1 (rotor-furl coordinate system = d1 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf2      !< Vector / direction rf2 (rotor-furl coordinate system = d2 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rf3      !< Vector / direction rf3 (rotor-furl coordinate system = d3 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: rfa      !< Vector / direction of the rotor-furl axis [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t1      !< Vector / direction t1 for tower node J (=  Lxt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t2      !< Vector / direction t2 for tower node J (=  Lzt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: t3      !< Vector / direction t3 for tower node J (= -Lyt from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te1      !< te1(K,J,:) = vector / direction te1 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te2      !< te2(K,J,:) = vector / direction te2 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: te3      !< te3(K,J,:) = vector / direction te3 for node J of blade K (used to calc. noise) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf1      !< Vector / direction tf1 (tail-furl coordinate system = d1 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf2      !< Vector / direction tf2 (tail-furl coordinate system = d2 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tf3      !< Vector / direction tf3 (tail-furl coordinate system = d3 when rotor-furl angle = 0) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: tfa      !< Vector / direction of the tail-furl axis [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z1      !< Vector / direction z1 (=  xi from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z2      !< Vector / direction z2 (=  zi from the IEC coord. system) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: z3      !< Vector / direction z3 (= -yi from the IEC coord. system) [-]
  END TYPE ED_CoordSys
! =======================
! =========  ED_ActiveDOFs  =======
  TYPE, PUBLIC :: ED_ActiveDOFs
    INTEGER(IntKi)  :: NActvDOF      !< The number of active (enabled) DOFs in the model [-]
    INTEGER(IntKi)  :: NPCE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the hub center of mass (point C) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPDE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPIE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the tail boom center of mass (point I) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPTE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPTTE      !< Number of tower DOFs that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NPSBE      !< Number of blade DOFs that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: NPSE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPUE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the nacelle center of mass (point U) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi)  :: NPYE      !< Number of DOFs that contribute to the QD2T-related linear accelerations of the platform center of mass (point Y) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PCE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the hub center of mass (point C) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PDE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PIE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tail boom center of mass (point I) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PTE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PTTE      !< Array of tower DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the tower nodes (point T) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PS      !< Array of DOF indices (pointers) to the active (enabled) DOFs/states [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PSBE      !< Array of blade DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PSE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the blade nodes (point S) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PUE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the nacelle center of mass (point U) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PYE      !< Array of DOF indices (pointers) that contribute to the QD2T-related linear accelerations of the platform center of mass (point Y) in the inertia frame, based on which DOFs are presently enabled [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: SrtPS      !< Sorted (from smallest to largest DOF index) version of PS() [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: SrtPSNAUG      !< SrtPS() with the additional value of NAUG [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: Diag      !< Array containing the indices of SrtPS() associated with each enabled DOF; that is, SrtPS(Diag(I)) = I [-]
  END TYPE ED_ActiveDOFs
! =======================
! =========  ED_RtHndSide  =======
  TYPE, PUBLIC :: ED_RtHndSide
    REAL(R8Ki) , DIMENSION(1:3)  :: rO      !< Position vector from inertial frame origin to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rQS      !< Position vector from the apex of rotation (point Q) to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rS      !< Position vector from inertial frame origin to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: rS0S      !< Position vector from the blade root (point S(0)) to a point on a blade (point S) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rT      !< Position vector from inertial frame origin to the current node (point T(HNodes(J)) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rT0O      !< Position vector from the tower base (point T(0)) to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rT0T      !< Position vector from a height of TowerBsHt (base of flexible portion of tower) (point T(0)) to a point on the tower (point T) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZ      !< Position vector from inertia frame origin to platform reference (point Z) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZO      !< Position vector from platform reference (point Z) to tower-top / base plate (point O) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rZT      !< Position vector from platform reference (point Z) to a point on a tower (point T) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rPQ      !< Position vector from teeter pin (point P) to apex of rotation (point Q) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rP      !< Position vector from inertial frame origin to teeter pin (point P) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rV      !< Position vector from inertial frame origin to specified point on rotor-furl axis (point V) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZY      !< Position vector from platform reference (point Z) to platform mass center (point Y) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOU      !< Position vector from tower-top / base plate (point O) to nacelle center of mass (point U). [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOV      !< Position vector from tower-top / base plate (point O) to specified point on rotor-furl axis (point V) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVD      !< Position vector from specified point on rotor-furl axis (point V) to center of mass of structure that furls with the rotor (not including rotor) (point D) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rOW      !< Position vector from tower-top / base plate (point O) to specified point on  tail-furl axis (point W) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rPC      !< Position vector from teeter pin (point P) to hub center of mass (point C) [m]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: rPS0      !< Position vector from teeter pin (point P) to blade root (point S(0)) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rQ      !< Position vector from inertial frame origin to apex of rotation (point Q) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rQC      !< Position vector from apex of rotation (point Q) to hub center of mass (point C) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVIMU      !< Position vector from specified point on rotor-furl axis (point V) to nacelle IMU (point IMU) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rVP      !< Position vector from specified point on rotor-furl axis (point V) to teeter pin (point P) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rWI      !< Position vector from specified point on  tail-furl axis (point W) to tail boom center of mass     (point I) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rWJ      !< Position vector from specified point on  tail-furl axis (point W) to tail fin  center of mass     (point J) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rWK      !< Position vector from specified point on  tail-furl axis (point W) to tail fin  center of pressure (point K) [m]
    REAL(R8Ki) , DIMENSION(1:3)  :: rZT0      !< Position vector from platform reference (point Z) to tower base (point T(0)) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngPosEF      !< Angular position of the current point on the tower (body F) in the inertial frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngPosXF      !< Angular position of the current point on the tower (body F) in the platform (body X) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngPosHM      !< Angular position of eleMent J of blade K (body M) in the hub (body H) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngPosXB      !< Angular position of the base plate (body B) in the platform (body X) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngPosEX      !< Angular position of the platform                   (body X) in the inertial frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEA      !< Partial angular velocity (and its 1st time derivative) of the tail (body A) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PAngVelEF      !< Partial angular velocity (and its 1st time derivative) of tower element J (body F) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEG      !< Partial angular velocity (and its 1st time derivative) of the generator (body G) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEH      !< Partial angular velocity (and its 1st time derivative) of the hub (body H) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEL      !< Partial angular velocity (and its 1st time derivative) of the low-speed shaft (body L) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: PAngVelEM      !< Partial angular velocity (and its 1st time derivative) of eleMent J of blade K (body M) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngVelEM      !< Angular velocity of of eleMent J of blade K (body M) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEN      !< Partial angular velocity (and its 1st time derivative) of the nacelle (body N) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEA      !< Angular velocity of the tail (body A) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEB      !< Partial angular velocity (and its 1st time derivative) of the base plate (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelER      !< Partial angular velocity (and its 1st time derivative) of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PAngVelEX      !< Partial angular velocity (and its 1st time derivative) of the platform (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEG      !< Angular velocity of the generator (body G) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEH      !< Angular velocity of the hub (body H) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEL      !< Angular velocity of the low-speed shaft (body L) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEN      !< Angular velocity of the nacelle (body N) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEB      !< Angular velocity of the base plate (body B) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelER      !< Angular velocity of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngVelEX      !< Angular velocity of the platform (body X) in the inertia frame (body E for earth) [-]
    REAL(R8Ki)  :: TeetAngVel      !< Angular velocity of the teeter motion [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEBt      !< Portion of the angular acceleration of the base plate (body B) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccERt      !< Portion of the angular acceleration of the structure that furls with the rotor (not including rotor) (body R) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEXt      !< Portion of the angular acceleration of the platform (body X) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngAccEFt      !< Portion of the angular acceleration of tower element J (body F) in the inertia frame (body E for earth) associated with everything but the QD2T()s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AngVelEF      !< Angular velocity of the current point on the tower (body F) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngVelHM      !< Angular velocity of the current point on the blade in the inertia frame  [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEAt      !< Portion of the angular acceleration of the tail (body A) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEGt      !< Portion of the angular acceleration of the generator (body G) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccEHt      !< Portion of the angular acceleration of the hub (body H) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AngAccEKt      !< Portion of the angular acceleration of the blade in the inertia frame associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AngAccENt      !< Portion of the angular acceleration of the nacelle (body N) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccECt      !< Portion of the linear acceleration of the hub center of mass (point C) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEDt      !< Portion of the linear acceleration of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEIt      !< Portion of the linear acceleration of the tail boom center of mass (point I) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEJt      !< Portion of the linear acceleration of the tail fin  center of mass (point J) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEUt      !< Portion of the linear acceleration of the nacelle center of mass (point U) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEYt      !< Portion of the linear acceleration of the platform center of mass (point Y) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LinVelES      !< Linear velocity of current point on the current blade (point S) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEQ      !< Linear velocity of of the apex of rotation (point Q) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LinVelET      !< Linear velocity of current point on the tower (point T) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: LinVelESm2      !< The m2-component (closest to tip) of LinVelES [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEIMU      !< Partial linear velocity (and its 1st time derivative) of the nacelle IMU (point IMU) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEO      !< Partial linear velocity (and its 1st time derivative) of the base plate (point O) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: PLinVelES      !< Partial linear velocity (and its 1st time derivative) of a point on a blade (point S) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: PLinVelET      !< Partial linear velocity (and its 1st time derivative) of a point on the tower (point T) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEZ      !< Partial linear velocity (and its 1st time derivative) of the platform reference point (point Z) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEC      !< Partial linear velocity (and its 1st time derivative) of the hub center of mass (point C) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelED      !< Partial linear velocity (and its 1st time derivative) of the center of mass of the structure that furls with the rotor (not including rotor) (point D) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEI      !< Partial linear velocity (and its 1st time derivative) of the tail boom center of mass (point I) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEJ      !< Partial linear velocity (and its 1st time derivative) of the tail fin center of mass (point J) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEK      !< Partial linear velocity (and its 1st time derivative) of the tail fin center of pressure(point K) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEP      !< Partial linear velocity (and its 1st time derivative) of the teeter pin (point P) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEQ      !< Partial linear velocity (and its 1st time derivative) of the apex of rotation (point Q) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEU      !< Partial linear velocity (and its 1st time derivative) of the nacelle center of mass (point U) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEV      !< Partial linear velocity (and its 1st time derivative) of the selected point on the rotor-furl axis (point V) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEW      !< Partial linear velocity (and its 1st time derivative) of the selected point on the tail-furl axis (point W) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PLinVelEY      !< Partial linear velocity (and its 1st time derivative) of the platform mass center (point Y) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEIMUt      !< Portion of the linear acceleration of the nacelle IMU (point IMU) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEOt      !< Portion of the linear acceleration of the base plate (point O) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LinAccESt      !< Portion of the linear acceleration of a point on a blade (point S) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LinAccETt      !< Portion of the linear acceleration of a point on the tower (point T) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinAccEZt      !< Portion of the linear acceleration of the platform reference (point Z) in the inertia frame (body E for earth) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEIMU      !< Linear velocity of the nacelle IMU (point IMU) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEZ      !< Linear velocity of platform reference (point Z) in the inertia frame [-]
    REAL(ReKi) , DIMENSION(1:3)  :: LinVelEO      !< Linear velocity of the base plate (point O) in the inertia frame (body E for earth) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcONcRtt      !< Portion of the force at yaw bearing (point O) due to the nacelle, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcPRott      !< Portion of the force at the teeter pin (point P) due to the rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FrcS0Bt      !< Portion of the force at the blade root (point S(0)) due to the blade associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcT0Trbt      !< Portion of the force at tower base (point T(0)) due to the turbine associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FSAero      !< The aerodynamic force per unit span acting on a blade at point S [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FSTipDrag      !< The aerodynamic force at a blade tip resulting from tip drag [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FTHydrot      !< Portion of the hydrodynamic force (& all other external forces, including aerodynamic) per unit length acting on the tower at point T associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FZHydrot      !< Portion of the platform hydrodynamic force at the platform reference (point Z) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MFHydrot      !< Portion of the hydrodynamic moment (and all other external moments, including aerodynamic) per unit length acting on a tower element (body F) at point T associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomBNcRtt      !< Portion of the moment at the base plate (body B) / yaw bearing (point O) due to the nacelle, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MomH0Bt      !< Portion of the moment at the hub (body H) / blade root (point S(0)) due to the blade associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomLPRott      !< Portion of the moment at the teeter pin (point P) on the low-speed shaft (body L) due to the rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomNGnRtt      !< Portion of the moment at the nacelle (body N) / selected point on rotor-furl axis (point V) due the structure that furls with the rotor, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomNTailt      !< Portion of the moment at the nacelle (body N) / selected point on tail-furl axis (point W) due the tail associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomX0Trbt      !< Portion of the moment at the platform (body X) / tower base (point T(0)) due to the turbine associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: MMAero      !< The aerodynamic moment per unit span acting on a blade at point S [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MXHydrot      !< Portion of the platform hydrodynamic moment acting at the platform (body X) / platform reference (point Z) associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcONcRt      !< Partial force at the yaw bearing (point O) due to the nacelle, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcPRot      !< Partial force at the teeter pin (point P) due to the rotor [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PFrcS0B      !< Partial force at the blade root (point S(0)) due to the blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcT0Trb      !< Partial force at the tower base (point T(0)) due to the turbine [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PFTHydro      !< Partial hydrodynamic force per unit length acting on the tower at point T [-]
    REAL(ReKi) , DIMENSION(1:6,1:3)  :: PFZHydro      !< Partial platform hydrodynamic force at the platform reference (point Z) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PMFHydro      !< Partial hydrodynamic moment per unit length acting on a tower element (body F) at point T [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomBNcRt      !< Partial moment at the base plate (body B) / yaw bearing (point O) due the nacelle, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: PMomH0B      !< Partial moment at the hub (body H) / blade root (point S(0)) due to the blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomLPRot      !< Partial moment at the teeter pin (point P) on the low-speed shaft (body L) due to the rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomNGnRt      !< Partial moment at the nacelle (body N) / selected point on rotor-furl axis (point V) due the structure that furls with the rotor, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomNTail      !< Partial moment at the nacelle (body N) / selected point on tail-furl axis (point W) due the tail [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomX0Trb      !< Partial moment at the platform (body X) / tower base (point T(0)) due to the turbine [-]
    REAL(ReKi) , DIMENSION(1:6,1:3)  :: PMXHydro      !< Partial platform hydrodynamic moment at the platform (body X) / platform reference (point Z) [-]
    REAL(R8Ki)  :: TeetAng      !< Current teeter angle = QT(DOF_Teet) for 2-blader or 0 for 3-blader (this is used in place of QT(DOF_Teet) throughout RtHS() [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcVGnRtt      !< Portion of the force at the rotor-furl axis (point V) due to the structure that furls with the rotor, generator, and rotor associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcWTailt      !< Portion of the force at the tail-furl axis (point W) due to the tail associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: FrcZAllt      !< Portion of the force at platform reference (point Z) due to everything associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: MomXAllt      !< Portion of the moment at the platform (body X) / platform reference (point Z) due to everything associated with everything but the QD2T()'s [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcVGnRt      !< Partial force at the rotor-furl axis (point V) due to the structure that furls with the rotor, generator, and rotor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcWTail      !< Partial force at the tail-furl axis (point W) due to the tail [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PFrcZAll      !< Partial force at the platform reference (point Z) due to everything [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PMomXAll      !< Partial moment at the platform (body X) / platform reference (point Z) due to the everything [-]
    REAL(ReKi)  :: TeetMom      !< The total moment supplied by the stop, spring, and damper of the teeter mechanism [-]
    REAL(ReKi)  :: TFrlMom      !< The total tail-furl spring and damper moment [-]
    REAL(ReKi)  :: RFrlMom      !< The total rotor-furl spring and damper moment [-]
    REAL(ReKi)  :: GBoxEffFac      !< The factor used to apply the gearbox efficiency effects to the equation associated with the generator DOF [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rSAerCen      !< aerodynamic pitching moment arm (i.e., the position vector from point S on the blade to the aerodynamic center of the element) [-]
  END TYPE ED_RtHndSide
! =======================
! =========  ED_ContinuousStateType  =======
  TYPE, PUBLIC :: ED_ContinuousStateType
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QT      !< Current estimate of Q (displacement matrix) for each degree of freedom [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QDT      !< Current estimate of QD (velocity matrix) for each degree of freedom [-]
  END TYPE ED_ContinuousStateType
! =======================
! =========  ED_DiscreteStateType  =======
  TYPE, PUBLIC :: ED_DiscreteStateType
    REAL(ReKi)  :: DummyDiscState      !< Remove this variable if you have discrete states [-]
  END TYPE ED_DiscreteStateType
! =======================
! =========  ED_ConstraintStateType  =======
  TYPE, PUBLIC :: ED_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState      !< Remove this variable if you have constraint states [-]
  END TYPE ED_ConstraintStateType
! =======================
! =========  ED_OtherStateType  =======
  TYPE, PUBLIC :: ED_OtherStateType
    INTEGER(IntKi)  :: n      !< tracks time step for which OtherState was updated [-]
    TYPE(ED_ContinuousStateType) , DIMENSION(ED_NMX)  :: xdot      !< previous state deriv for multi-step [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: IC      !< Array which stores pointers to predictor-corrector results [-]
    REAL(ReKi)  :: HSSBrTrq      !< HSSBrTrq from update states; a hack to get this working with a single integrator [-]
    REAL(ReKi)  :: HSSBrTrqC      !< Commanded HSS brake torque (adjusted for sign) [N-m]
    INTEGER(IntKi)  :: SgnPrvLSTQ      !< The sign of the low-speed shaft torque from the previous call to RtHS().  This is calculated at the end of RtHS().  NOTE: The low-speed shaft torque is assumed to be positive at the beginning of the run! [-]
    INTEGER(IntKi) , DIMENSION(ED_NMX)  :: SgnLSTQ      !< history of sign of LSTQ [-]
  END TYPE ED_OtherStateType
! =======================
! =========  ED_MiscVarType  =======
  TYPE, PUBLIC :: ED_MiscVarType
    TYPE(ED_CoordSys)  :: CoordSys      !< Coordinate systems in the FAST framework [-]
    TYPE(ED_RtHndSide)  :: RtHS      !< Values used in calculating the right-hand-side RtHS (and outputs) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: AugMat      !< The augmented matrix used for the solution of the QD2T()s [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: AugMat_factor      !< factored version of AugMat matrix [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: SolnVec      !< b in the equation Ax=b (last column of AugMat) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: AugMat_pivot      !< Pivot column for AugMat in LAPACK factorization [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OgnlGeAzRo      !< Original DOF_GeAz row in AugMat [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: QD2T      !< Solution (acceleration) vector; the first time derivative of QDT [-]
    LOGICAL  :: IgnoreMod      !< whether to ignore the modulo in ED outputs (necessary for linearization perturbations) [-]
  END TYPE ED_MiscVarType
! =======================
! =========  ED_ParameterType  =======
  TYPE, PUBLIC :: ED_ParameterType
    REAL(DbKi)  :: DT      !< Time step for continuous state integration & discrete state update [seconds]
    REAL(DbKi)  :: DT24      !< =DT/24 (used in loose coupling) [seconds]
    INTEGER(IntKi)  :: BldNodes      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: TipNode      !< Index of the additional node located at the blade tip = BldNodes + 1 [-]
    INTEGER(IntKi)  :: NDOF      !< Number of total degrees of freedom (DOFs) [-]
    REAL(R8Ki)  :: TwoPiNB      !< Two pi divided by the number of blades [radians]
    INTEGER(IntKi)  :: NAug      !< Dimension of augmented solution matrix [-]
    INTEGER(IntKi)  :: NPH      !< Number of DOFs that contribute to the angular velocity of the hub (body H) in the inertia frame [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: PH      !< Array of DOF indices (pointers) that contribute to the angular velocity of the hub (body H) in the inertia frame [-]
    INTEGER(IntKi)  :: NPM      !< Number of DOFs that contribute to the angular velocity of the blade elements (body M) in the inertia frame [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: PM      !< Array of DOF indices (pointers) that contribute to the angular velocity of the blade elements (body M) in the inertia frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: DOF_Flag      !< Array which stores values of the feature flags for each DOF [-]
    CHARACTER(99) , DIMENSION(:), ALLOCATABLE  :: DOF_Desc      !< Array which stores descriptions of each DOF [-]
    TYPE(ED_ActiveDOFs)  :: DOFs      !< Active degrees of freedom in the model [-]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(20)  :: OutFmt      !< Output format for tabular data [-]
    INTEGER(IntKi)  :: NBlGages = 0      !< Number of blade strain gages [-]
    INTEGER(IntKi)  :: NTwGages = 0      !< Number of tower strain gages [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    CHARACTER(1)  :: Delim      !< Column delimiter for output text files [-]
    REAL(ReKi)  :: AvgNrmTpRd      !< Average tip radius normal to the shaft [meters]
    REAL(R8Ki)  :: AzimB1Up      !< Azimuth value to use for I/O when blade 1 points up [radians]
    REAL(R8Ki)  :: CosDel3 = 1.0      !< Cosine of the Delta-3 angle for teetering rotors [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: CosPreC      !< Cosines of the precone angles [-]
    REAL(R8Ki)  :: CRFrlSkew      !< Cosine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CRFrlSkw2      !< Cosine-squared of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CRFrlTilt      !< Cosine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CRFrlTlt2      !< Cosine-squared of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CShftSkew      !< Cosine of the shaft skew angle [-]
    REAL(R8Ki)  :: CShftTilt      !< Cosine of the shaft tilt angle [-]
    REAL(R8Ki)  :: CSRFrlSkw      !< Cosine*Sine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: CSRFrlTlt      !< Cosine*Sine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: CSTFrlSkw      !< Cosine*Sine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CSTFrlTlt      !< Cosine*Sine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: CTFinBank      !< Cosine of the tail fin planform bank angle [-]
    REAL(R8Ki)  :: CTFinSkew      !< Cosine of the tail fin chordline skew angle [-]
    REAL(R8Ki)  :: CTFinTilt      !< Cosine of the tail fin chordline tilt angle [-]
    REAL(R8Ki)  :: CTFrlSkew      !< Cosine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CTFrlSkw2      !< Cosine-squared of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: CTFrlTilt      !< Cosine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: CTFrlTlt2      !< Cosine-squared of the tail-furl axis tilt angle [-]
    REAL(ReKi)  :: HubHt      !< Hub-height as computed using FAST inputs [= TowerHt + Twr2Shft + OverHang*SIN( ShftTilt ) ] (was FASTHH) [-]
    REAL(ReKi)  :: HubCM      !< Distance from rotor apex to hub mass [-]
    REAL(ReKi)  :: HubRad      !< Preconed hub radius [-]
    REAL(ReKi)  :: NacCMxn      !< Downwind distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: NacCMyn      !< Lateral distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: NacCMzn      !< Vertical distance from tower-top to nacelle CM [-]
    REAL(ReKi)  :: OverHang      !< Distance from yaw axis to rotor apex or teeter pin [-]
    REAL(ReKi)  :: ProjArea      !< Swept area of the rotor projected onto the rotor plane (the plane normal to the low-speed shaft) [-]
    REAL(ReKi)  :: PtfmRefzt      !< Vertical distance from the ground [onshore] or MSL [offshore] to the platform reference point [-]
    REAL(ReKi)  :: RefTwrHt      !< Vertical distance between FAST's undisplaced tower height (variable TowerHt) and FAST's inertia frame reference point (variable PtfmRef); that is, RefTwrHt = TowerHt - PtfmRefzt [-]
    REAL(ReKi)  :: RFrlPntxn      !< Downwind distance from tower-top to arbitrary point on rotor-furl axis [-]
    REAL(ReKi)  :: RFrlPntyn      !< Lateral distance from tower-top to arbitrary point on rotor-furl axis [-]
    REAL(ReKi)  :: RFrlPntzn      !< Vertical distance from tower-top to arbitrary point on rotor-furl axis [-]
    REAL(ReKi)  :: rVDxn      !< xn-component of position vector Rvd [-]
    REAL(ReKi)  :: rVDyn      !< yn-component of position vector rVD [-]
    REAL(ReKi)  :: rVDzn      !< zn-component of position vector rVD [-]
    REAL(ReKi)  :: rVIMUxn      !< xn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVIMUyn      !< yn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVIMUzn      !< zn-component of position vector rVIMU [-]
    REAL(ReKi)  :: rVPxn      !< xn-component of position vector rVP [-]
    REAL(ReKi)  :: rVPyn      !< yn-component of position vector rVP [-]
    REAL(ReKi)  :: rVPzn      !< zn-component of position vector rVP [-]
    REAL(ReKi)  :: rWIxn      !< xn-component of position vector rWI [-]
    REAL(ReKi)  :: rWIyn      !< yn-component of position vector rWI [-]
    REAL(ReKi)  :: rWIzn      !< zn-component of position vector rWI [-]
    REAL(ReKi)  :: rWJxn      !< xn-component of position vector rWJ [-]
    REAL(ReKi)  :: rWJyn      !< yn-component of position vector rWJ [-]
    REAL(ReKi)  :: rWJzn      !< zn-component of position vector rWJ [-]
    REAL(ReKi)  :: rWKxn      !< xn-component of position vector rWK [-]
    REAL(ReKi)  :: rWKyn      !< yn-component of position vector rWK [-]
    REAL(ReKi)  :: rWKzn      !< zn-component of position vector rWK [-]
    REAL(ReKi)  :: rZT0zt      !< zt-component of position vector rZT0 [-]
    REAL(ReKi)  :: rZYzt      !< zt-component of position vector rZY [-]
    REAL(R8Ki)  :: SinDel3      !< Sine of the Delta-3 angle for teetering rotors [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: SinPreC      !< Sines of the precone angles [-]
    REAL(R8Ki)  :: SRFrlSkew      !< Sine of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: SRFrlSkw2      !< Sine-squared of the rotor-furl axis skew angle [-]
    REAL(R8Ki)  :: SRFrlTilt      !< Sine of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: SRFrlTlt2      !< Sine-squared of the rotor-furl axis tilt angle [-]
    REAL(R8Ki)  :: SShftSkew      !< Sine of the shaft skew angle [-]
    REAL(R8Ki)  :: SShftTilt      !< Sine of the shaft tilt angle [-]
    REAL(R8Ki)  :: STFinBank      !< Sine of the tail fin planform bank angle [-]
    REAL(R8Ki)  :: STFinSkew      !< Sine of the tail fin chordline skew angle [-]
    REAL(R8Ki)  :: STFinTilt      !< Sine of the tail fin chordline tilt angle [-]
    REAL(R8Ki)  :: STFrlSkew      !< Sine of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: STFrlSkw2      !< Sine-squared of the tail-furl axis skew angle [-]
    REAL(R8Ki)  :: STFrlTilt      !< Sine of the tail-furl axis tilt angle [-]
    REAL(R8Ki)  :: STFrlTlt2      !< Sine-squared of the tail-furl axis tilt angle [-]
    REAL(ReKi)  :: TFrlPntxn      !< Downwind distance from tower-top to arbitrary point on tail-furl axis [-]
    REAL(ReKi)  :: TFrlPntyn      !< Lateral distance from tower-top to arbitrary point on tail-furl axis [-]
    REAL(ReKi)  :: TFrlPntzn      !< Vertical distance from tower-top to arbitrary point on tail-furl axis [-]
    REAL(ReKi)  :: TipRad      !< Preconed blade-tip radius [-]
    REAL(ReKi)  :: TowerHt      !< Height of tower above ground level [-]
    REAL(ReKi)  :: TowerBsHt      !< Height of tower base above ground level [onshore] or MSL [offshore] [meters]
    REAL(ReKi)  :: UndSling      !< Undersling length [-]
    INTEGER(IntKi)  :: NumBl      !< Number of turbine blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AxRedTFA      !< The axial-reduction terms for the fore-aft tower mode shapes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AxRedTSS      !< The axial-reduction terms for the side-to-side tower mode shapes [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: CTFA      !< Generalized damping of tower in fore-aft direction [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: CTSS      !< Generalized damping of tower in side-to-side direction [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DHNodes      !< Length of variable-length tower elements [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HNodes      !< Location of variable-spaced tower nodes (relative to the tower rigid base height [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HNodesNorm      !< Normalized location of variable-spaced tower nodes (relative to the tower rigid base height) (0 < HNodesNorm(:) < 1) [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: KTFA      !< Generalized stiffness of tower in fore-aft direction [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: KTSS      !< Generalized stiffness of tower in side-to-side direction [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: MassT      !< Interpolated lineal mass density of tower [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTSS      !< Interpolated side-side tower stiffness [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrFASF      !< Tower fore-aft shape functions [-]
    REAL(ReKi)  :: TwrFlexL      !< Height / length of the flexible portion of the tower [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrSSSF      !< Tower side-to-side shape functions [-]
    INTEGER(IntKi)  :: TTopNode      !< Index of the additional node located at the tower-top = TwrNodes + 1 [-]
    INTEGER(IntKi)  :: TwrNodes      !< Number of tower nodes used in the analysis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: InerTFA      !< Interpolated tower fore-aft (about yt-axis) mass inertia per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: InerTSS      !< Interpolated tower side-to-side (about xt-axis) mass inertia per unit length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTGJ      !< Interpolated tower torsional stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTEA      !< Interpolated tower extensional stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: StiffTFA      !< Interpolated fore-aft tower stiffness [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: cgOffTFA      !< Interpolated tower fore-aft mass cg offset [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: cgOffTSS      !< Interpolated tower side-to-side mass cg offset [-]
    REAL(ReKi)  :: AtfaIner      !< Inertia of tail boom about the tail-furl axis whose origin is the tail boom center of mass [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldCG      !< Blade center of mass wrt the blade root [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BldMass      !< Blade masses [-]
    REAL(ReKi)  :: BoomMass      !< Tail boom mass [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FirstMom      !< First mass moment of inertia of blades wrt the root [-]
    REAL(ReKi)  :: GenIner      !< Generator inertia about HSS [-]
    REAL(ReKi)  :: Hubg1Iner      !< Inertia of hub about g1-axis (rotor centerline) [-]
    REAL(ReKi)  :: Hubg2Iner      !< Inertia of hub about g2-axis (transverse to the cyclinder and passing through its c.g.) [-]
    REAL(ReKi)  :: HubMass      !< Hub mass [-]
    REAL(ReKi)  :: Nacd2Iner      !< Inertia of nacelle about the d2-axis whose origin is the nacelle center of mass [-]
    REAL(ReKi)  :: NacMass      !< Nacelle mass [-]
    REAL(ReKi)  :: PtfmMass      !< Platform mass [-]
    REAL(ReKi)  :: PtfmPIner      !< Platform inertia for pitch tilt rotation about the platform CM. [-]
    REAL(ReKi)  :: PtfmRIner      !< Platform inertia for roll tilt rotation about the platform CM. [-]
    REAL(ReKi)  :: PtfmYIner      !< Platform inertia for yaw rotation about the platform CM. [-]
    REAL(ReKi)  :: RFrlMass      !< Rotor-furl mass [-]
    REAL(ReKi)  :: RotIner      !< Inertia of rotor about its centerline [-]
    REAL(ReKi)  :: RotMass      !< Rotor mass (blades, tips, and hub) [-]
    REAL(ReKi)  :: RrfaIner      !< Inertia of structure that furls with the rotor (not including rotor) about the rotor-furl axis whose origin is the center of mass of the structure that furls with the rotor (not including rotor) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SecondMom      !< Second mass moment of inertia of blades wrt the root [-]
    REAL(ReKi)  :: TFinMass      !< Tail fin mass [-]
    REAL(ReKi)  :: TFrlIner      !< Tail boom inertia about tail-furl axis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TipMass      !< Tip-brake masses [-]
    REAL(ReKi)  :: TurbMass      !< Mass of turbine (tower + rotor + nacelle) [-]
    REAL(ReKi)  :: TwrMass      !< Mass of tower [-]
    REAL(ReKi)  :: TwrTpMass      !< Tower-top mass (rotor + nacelle) [-]
    REAL(ReKi)  :: YawBrMass      !< Yaw bearing mass [-]
    REAL(ReKi)  :: Gravity      !< Gravitational acceleration [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PitchAxis      !< Pitch axis for analysis nodes [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AeroTwst      !< Aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: AxRedBld      !< The axial-reduction terms of the blade shape function [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BAlpha      !< Interpolated blade coupling coefficient between flap and twist [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldEDamp      !< Blade edgewise damping coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFDamp      !< Blade flapwise damping coefficients [-]
    REAL(ReKi)  :: BldFlexL      !< Flexible blade length [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CAeroTwst      !< Cosine of the aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CBE      !< Generalized edgewise damping of the blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CBF      !< Generalized flapwise damping of the blades [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: cgOffBEdg      !< Interpolated blade edge (along local aerodynamic yb-axis) mass cg offset [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: cgOffBFlp      !< Interpolated blade flap (along local aerodynamic xb-axis) mass cg offset [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Chord      !< Chord of the blade at the analysis nodes [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: CThetaS      !< COS( ThetaS ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DRNodes      !< Length of variable-spaced blade elements [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: EAOffBEdg      !< Interpolated blade edge (along local aerodynamic yb-axis) elastic axis offset [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: EAOffBFlp      !< Interpolated blade flap (along local aerodynamic xb-axis) elastic axis offset [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: FStTunr      !< Blade flapwise modal stiffness tuners (stored for all blades) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InerBEdg      !< Interpolated blade edge (about local structural xb-axis) mass inertia per unit length [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InerBFlp      !< Interpolated blade flap (about local structural yb-axis) mass inertia per unit length [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: KBE      !< Generalized edgewise stiffness of the blades [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: KBF      !< Generalized flapwise stiffness of the blades [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MassB      !< Interpolated lineal blade mass density [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: RefAxisxb      !< Interpolated Offset for defining the reference axis from the pitch axis for precurved blades at a given input station (along xb-axis) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: RefAxisyb      !< Interpolated Offset for defining the reference axis from the pitch axis for preswept blades at a given input station (along yb-axis) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodes      !< Radius to analysis nodes relative to hub ( 0 < RNodes(:) < BldFlexL ) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RNodesNorm      !< Normalized radius to analysis nodes relative to hub ( 0 < RNodesNorm(:) < 1 ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rSAerCenn1      !< Distance from point S on a blade to the aerodynamic center in the n1 direction (m) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rSAerCenn2      !< Distance from point S on a blade to the aerodynamic center in the n2 direction (m) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SAeroTwst      !< Sine of the aerodynamic twist of the blade at the analysis nodes [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBE      !< Interpolated edgewise blade stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBEA      !< Interpolated blade extensional stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBF      !< Interpolated flapwise blade stiffness [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StiffBGJ      !< Interpolated blade torsional stiffness [-]
    REAL(R8Ki) , DIMENSION(:,:), ALLOCATABLE  :: SThetaS      !< SIN( ThetaS ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: ThetaS      !< Structural twist for analysis nodes [radians]
    REAL(ReKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: TwistedSF      !< Interpolated lineal blade mass density [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFl1Sh      !< Blade-flap-mode-1 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldFl2Sh      !< Blade-flap-mode-2 shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BldEdgSh      !< Blade-edge-mode shape coefficients [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FreqBE      !< Blade edgewise natural frequencies (both w/ and w/o centrifugal stiffening) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: FreqBF      !< Blade flapwise natural frequencies (both w/ and w/o centrifugal stiffening) [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: FreqTFA      !< Computed fore-aft tower natural frequencies [-]
    REAL(ReKi) , DIMENSION(1:2,1:2)  :: FreqTSS      !< Computed side-to-side tower natural frequencies [-]
    REAL(ReKi)  :: TeetCDmp      !< Rotor-teeter rate-independent Coulomb-damping [-]
    REAL(ReKi)  :: TeetDmp      !< Rotor-teeter damping constant [-]
    REAL(ReKi)  :: TeetDmpP      !< Rotor-teeter damper position [-]
    REAL(ReKi)  :: TeetHSSp      !< Rotor-teeter hard-stop linear-spring constant [-]
    REAL(ReKi)  :: TeetHStP      !< Rotor-teeter hard-stop position [-]
    REAL(ReKi)  :: TeetSSSp      !< Rotor-teeter soft-stop linear-spring constant [-]
    REAL(ReKi)  :: TeetSStP      !< Rotor-teeter soft-stop position [-]
    INTEGER(IntKi)  :: TeetMod      !< Rotor-teeter spring/damper model switch [-]
    REAL(ReKi)  :: TFrlCDmp      !< Tail-furl rate-independent Coulomb-damping moment [-]
    REAL(ReKi)  :: TFrlDmp      !< Tail-furl damping constant [-]
    REAL(ReKi)  :: TFrlDSDmp      !< Tail-furl down-stop damping constant [-]
    REAL(ReKi)  :: TFrlDSDP      !< Tail-furl down-stop damper position [-]
    REAL(ReKi)  :: TFrlDSSP      !< Tail-furl down-stop spring position [-]
    REAL(ReKi)  :: TFrlDSSpr      !< Tail-furl down-stop spring constant [-]
    REAL(ReKi)  :: TFrlSpr      !< Tail-furl spring constant [-]
    REAL(ReKi)  :: TFrlUSDmp      !< Tail-furl up-stop damping constant [-]
    REAL(ReKi)  :: TFrlUSDP      !< Tail-furl up-stop damper position [-]
    REAL(ReKi)  :: TFrlUSSP      !< Tail-furl up-stop spring position [-]
    REAL(ReKi)  :: TFrlUSSpr      !< Tail-furl up-stop spring constant [-]
    INTEGER(IntKi)  :: TFrlMod      !< Tail-furl spring/damper model switch [-]
    REAL(ReKi)  :: RFrlCDmp      !< Rotor-furl rate-independent Coulomb-damping moment [-]
    REAL(ReKi)  :: RFrlDmp      !< Rotor-furl damping constant [-]
    REAL(ReKi)  :: RFrlDSDmp      !< Rotor-furl down-stop damping constant [-]
    REAL(ReKi)  :: RFrlDSDP      !< Rotor-furl down-stop damper position [-]
    REAL(ReKi)  :: RFrlDSSP      !< Rotor-furl down-stop spring position [-]
    REAL(ReKi)  :: RFrlDSSpr      !< Rotor-furl down-stop spring constant [-]
    REAL(ReKi)  :: RFrlSpr      !< Rotor-furl spring constant [-]
    REAL(ReKi)  :: RFrlUSDmp      !< Rotor-furl up-stop damping constant [-]
    REAL(ReKi)  :: RFrlUSDP      !< Rotor-furl up-stop damper position [-]
    REAL(ReKi)  :: RFrlUSSP      !< Rotor-furl up-stop spring position [-]
    REAL(ReKi)  :: RFrlUSSpr      !< Rotor-furl up-stop spring constant [-]
    INTEGER(IntKi)  :: RFrlMod      !< Rotor-furl spring/damper model switch [-]
    REAL(ReKi)  :: ShftGagL      !< Distance from hub or teeter pin to shaft strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BldGagNd      !< Nodes closest to the blade strain gages [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwrGagNd      !< Nodes closest to the tower strain gages [-]
    REAL(DbKi)  :: TStart      !< Time to begin tabular output [-]
    REAL(ReKi)  :: DTTorDmp      !< Drivetrain torsional damper [-]
    REAL(ReKi)  :: DTTorSpr      !< Drivetrain torsional spring [-]
    REAL(ReKi)  :: GBRatio      !< Gearbox ratio [-]
    REAL(ReKi)  :: GBoxEff      !< Gearbox efficiency [-]
    REAL(ReKi)  :: RotSpeed      !< Initial or fixed rotor speed [rad/s]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BElmntMass      !< Mass of the blade elements [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TElmntMass      !< Mass of the tower elements [-]
    INTEGER(IntKi)  :: method      !< Identifier for integration method (1 [RK4], 2 [AB4], or 3 [ABM4]) [-]
    REAL(ReKi)  :: PtfmCMxt      !< Downwind distance from the ground [onshore] or MSL [offshore] to the platform CM [meters]
    REAL(ReKi)  :: PtfmCMyt      !< Lateral distance from the ground [onshore] or MSL [offshore] to the platform CM [meters]
    LOGICAL  :: BD4Blades      !< flag to determine if BeamDyn is computing blade loads (true) or ElastoDyn is (false) [-]
    LOGICAL  :: UseAD14      !< flag to determine if AeroDyn14 is being used. Will remove this later when we've replaced AD14. [-]
    INTEGER(IntKi)  :: BldNd_NumOuts      !< Number of requested output channels per blade node (ED_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_TotNumOuts      !< Total number of requested output channels of blade node information (BldNd_NumOuts * BldNd_BlOutNd * BldNd_BladesOut -- ED_AllBldNdOuts) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi)  :: BldNd_BladesOut      !< The blades to output (ED_AllBldNdOuts) [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(R8Ki) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny      !< number of outputs in jacobian matrix [-]
  END TYPE ED_ParameterType
! =======================
! =========  ED_InputType  =======
  TYPE, PUBLIC :: ED_InputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladePtLoads      !< A mesh on each blade, containing aerodynamic forces and moments (formerly AeroBladeForce and AeroBladeMoment) [-]
    TYPE(MeshType)  :: PlatformPtMesh      !< A mesh at the platform reference (point Z), containing force: surge/xi (1), sway/yi (2), and heave/zi (3)-components; and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components acting at the platform (body X) / platform reference (point Z) associated with everything but the QD2T()s [N]
    TYPE(MeshType)  :: TowerPtLoads      !< Tower line2 mesh with forces: surge/xi (1), sway/yi (2), and heave/zi (3)-components of the portion of the tower force at the current tower node (point T); and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components of the portion of the tower moment acting at the current tower node [N/m]
    TYPE(MeshType)  :: HubPtLoad      !< A mesh at the teeter pin, containing forces: surge/xi (1), sway/yi (2), and heave/zi (3)-components; and moments: roll/xi (1), pitch/yi (2), and yaw/zi (3)-components acting at the hub. Passed from BeamDyn [-]
    TYPE(MeshType)  :: NacelleLoads      !< From ServoDyn/TMD: loads on the nacelle. [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: TwrAddedMass      !< 6-by-6 added mass matrix of the tower elements, per unit length-bjj: place on a mesh [per unit length]
    REAL(ReKi) , DIMENSION(1:6,1:6)  :: PtfmAddedMass      !< Platform added mass matrix [kg, kg-m, kg-m^2]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitchCom      !< Commanded blade pitch angles [radians]
    REAL(ReKi)  :: YawMom      !< Torque transmitted through the yaw bearing [N-m]
    REAL(ReKi)  :: GenTrq      !< Electrical generator torque [N-m]
    REAL(ReKi)  :: HSSBrTrqC      !< Commanded HSS brake torque [N-m]
  END TYPE ED_InputType
! =======================
! =========  ED_OutputType  =======
  TYPE, PUBLIC :: ED_OutputType
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLn2Mesh      !< A mesh on each blade, containing positions and orientations of the blade elements [-]
    TYPE(MeshType)  :: PlatformPtMesh      !< Platform reference point positions/orientations/velocities/accelerations [-]
    TYPE(MeshType)  :: TowerLn2Mesh      !< Tower line2 mesh with positions/orientations/velocities/accelerations [-]
    TYPE(MeshType)  :: HubPtMotion14      !< For AeroDyn v14: motions of the hub [-]
    TYPE(MeshType)  :: HubPtMotion      !< For AeroDyn and Lidar(InflowWind): motions of the hub [-]
    TYPE(MeshType)  :: BladeRootMotion14      !< For AeroDyn v14: motions of the blade roots [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< For AeroDyn/BeamDyn: motions at the blade roots [-]
    TYPE(MeshType)  :: RotorFurlMotion14      !< For AeroDyn14: motions of the rotor furl point. [-]
    TYPE(MeshType)  :: NacelleMotion      !< For AeroDyn14 & ServoDyn/TMD: motions of the nacelle. [-]
    TYPE(MeshType)  :: TowerBaseMotion14      !< For AeroDyn 14: motions of the tower base [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlPitch      !< Current blade pitch angles [radians]
    REAL(ReKi)  :: Yaw      !< Current nacelle yaw [radians]
    REAL(ReKi)  :: YawRate      !< Current nacelle yaw rate [rad/s]
    REAL(ReKi)  :: LSS_Spd      !< Low-speed shaft (LSS) speed at entrance to gearbox [rad/s]
    REAL(ReKi)  :: HSS_Spd      !< High-speed shaft (HSS) speed [rad/s]
    REAL(ReKi)  :: RotSpeed      !< Rotor azimuth angular speed [rad/s]
    REAL(ReKi)  :: TwrAccel      !< Tower acceleration for tower feedback control (user routine only) [m/s^2]
    REAL(ReKi)  :: YawAngle      !< Yaw angle to be used for yaw error calculations [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMyc      !< Out-of-plane moment (i.e., the moment caused by out-of-plane forces) at the blade root for each of the blades (max 3) [N-m]
    REAL(ReKi)  :: YawBrTAxp      !< Tower-top / yaw bearing fore-aft (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: YawBrTAyp      !< Tower-top / yaw bearing side-to-side (translational) acceleration (absolute) [m/s^2]
    REAL(ReKi)  :: LSSTipPxa      !< Rotor azimuth angle (position) [radians]
    REAL(ReKi) , DIMENSION(1:3)  :: RootMxc      !< In-plane moment (i.e., the moment caused by in-plane forces) at the blade root [N-m]
    REAL(ReKi)  :: LSSTipMxa      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMya      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMza      !< Rotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMys      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: LSSTipMzs      !< Nonrotating low-speed shaft bending moment at the shaft tip (teeter pin for 2-blader, apex of rotation for 3-blader) [N-m]
    REAL(ReKi)  :: YawBrMyn      !< Rotating (with nacelle) tower-top / yaw bearing pitch moment [N-m]
    REAL(ReKi)  :: YawBrMzn      !< Tower-top / yaw bearing yaw moment [N-m]
    REAL(ReKi)  :: NcIMURAxs      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAys      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: NcIMURAzs      !< Nacelle inertial measurement unit angular (rotational) acceleration (absolute) [rad/s^2]
    REAL(ReKi)  :: RotPwr      !< Rotor power (this is equivalent to the low-speed shaft power) [W]
    REAL(ReKi)  :: LSShftFxa      !< Rotating low-speed shaft force x [N]
    REAL(ReKi)  :: LSShftFys      !< Nonrotating low-speed shaft force y [N]
    REAL(ReKi)  :: LSShftFzs      !< Nonrotating low-speed shaft force z [N]
  END TYPE ED_OutputType
! =======================
CONTAINS
 SUBROUTINE ED_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(ED_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%InputFile = SrcInitInputData%InputFile
    DstInitInputData%Linearize = SrcInitInputData%Linearize
    DstInitInputData%ADInputFile = SrcInitInputData%ADInputFile
    DstInitInputData%CompElast = SrcInitInputData%CompElast
    DstInitInputData%RootName = SrcInitInputData%RootName
    DstInitInputData%Gravity = SrcInitInputData%Gravity
 END SUBROUTINE ED_CopyInitInput

 SUBROUTINE ED_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(ED_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE ED_DestroyInitInput

 SUBROUTINE ED_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%InputFile)  ! InputFile
      Int_BufSz  = Int_BufSz  + 1  ! Linearize
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%ADInputFile)  ! ADInputFile
      Int_BufSz  = Int_BufSz  + 1  ! CompElast
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%InputFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%InputFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Linearize, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%ADInputFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%ADInputFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = TRANSFER(InData%CompElast, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_PackInitInput

 SUBROUTINE ED_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%InputFile)
      OutData%InputFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%Linearize = TRANSFER(IntKiBuf(Int_Xferred), OutData%Linearize)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%ADInputFile)
      OutData%ADInputFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%CompElast = TRANSFER(IntKiBuf(Int_Xferred), OutData%CompElast)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_UnPackInitInput

 SUBROUTINE ED_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(ED_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstInitOutputData%NumBl = SrcInitOutputData%NumBl
IF (ALLOCATED(SrcInitOutputData%BlPitch)) THEN
  i1_l = LBOUND(SrcInitOutputData%BlPitch,1)
  i1_u = UBOUND(SrcInitOutputData%BlPitch,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%BlPitch)) THEN 
    ALLOCATE(DstInitOutputData%BlPitch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%BlPitch.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%BlPitch = SrcInitOutputData%BlPitch
ENDIF
    DstInitOutputData%BladeLength = SrcInitOutputData%BladeLength
    DstInitOutputData%TowerHeight = SrcInitOutputData%TowerHeight
    DstInitOutputData%TowerBaseHeight = SrcInitOutputData%TowerBaseHeight
    DstInitOutputData%HubHt = SrcInitOutputData%HubHt
IF (ALLOCATED(SrcInitOutputData%BldRNodes)) THEN
  i1_l = LBOUND(SrcInitOutputData%BldRNodes,1)
  i1_u = UBOUND(SrcInitOutputData%BldRNodes,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%BldRNodes)) THEN 
    ALLOCATE(DstInitOutputData%BldRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%BldRNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%BldRNodes = SrcInitOutputData%BldRNodes
ENDIF
IF (ALLOCATED(SrcInitOutputData%TwrHNodes)) THEN
  i1_l = LBOUND(SrcInitOutputData%TwrHNodes,1)
  i1_u = UBOUND(SrcInitOutputData%TwrHNodes,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%TwrHNodes)) THEN 
    ALLOCATE(DstInitOutputData%TwrHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%TwrHNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%TwrHNodes = SrcInitOutputData%TwrHNodes
ENDIF
    DstInitOutputData%PlatformPos = SrcInitOutputData%PlatformPos
    DstInitOutputData%TwrBaseRefPos = SrcInitOutputData%TwrBaseRefPos
    DstInitOutputData%TwrBaseTransDisp = SrcInitOutputData%TwrBaseTransDisp
    DstInitOutputData%TwrBaseRefOrient = SrcInitOutputData%TwrBaseRefOrient
    DstInitOutputData%TwrBaseOrient = SrcInitOutputData%TwrBaseOrient
    DstInitOutputData%HubRad = SrcInitOutputData%HubRad
    DstInitOutputData%RotSpeed = SrcInitOutputData%RotSpeed
    DstInitOutputData%isFixed_GenDOF = SrcInitOutputData%isFixed_GenDOF
IF (ALLOCATED(SrcInitOutputData%LinNames_y)) THEN
  i1_l = LBOUND(SrcInitOutputData%LinNames_y,1)
  i1_u = UBOUND(SrcInitOutputData%LinNames_y,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LinNames_y)) THEN 
    ALLOCATE(DstInitOutputData%LinNames_y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_y.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LinNames_y = SrcInitOutputData%LinNames_y
ENDIF
IF (ALLOCATED(SrcInitOutputData%LinNames_x)) THEN
  i1_l = LBOUND(SrcInitOutputData%LinNames_x,1)
  i1_u = UBOUND(SrcInitOutputData%LinNames_x,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LinNames_x)) THEN 
    ALLOCATE(DstInitOutputData%LinNames_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LinNames_x = SrcInitOutputData%LinNames_x
ENDIF
IF (ALLOCATED(SrcInitOutputData%LinNames_u)) THEN
  i1_l = LBOUND(SrcInitOutputData%LinNames_u,1)
  i1_u = UBOUND(SrcInitOutputData%LinNames_u,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%LinNames_u)) THEN 
    ALLOCATE(DstInitOutputData%LinNames_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%LinNames_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%LinNames_u = SrcInitOutputData%LinNames_u
ENDIF
IF (ALLOCATED(SrcInitOutputData%RotFrame_y)) THEN
  i1_l = LBOUND(SrcInitOutputData%RotFrame_y,1)
  i1_u = UBOUND(SrcInitOutputData%RotFrame_y,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%RotFrame_y)) THEN 
    ALLOCATE(DstInitOutputData%RotFrame_y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_y.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%RotFrame_y = SrcInitOutputData%RotFrame_y
ENDIF
IF (ALLOCATED(SrcInitOutputData%RotFrame_x)) THEN
  i1_l = LBOUND(SrcInitOutputData%RotFrame_x,1)
  i1_u = UBOUND(SrcInitOutputData%RotFrame_x,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%RotFrame_x)) THEN 
    ALLOCATE(DstInitOutputData%RotFrame_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%RotFrame_x = SrcInitOutputData%RotFrame_x
ENDIF
IF (ALLOCATED(SrcInitOutputData%DerivOrder_x)) THEN
  i1_l = LBOUND(SrcInitOutputData%DerivOrder_x,1)
  i1_u = UBOUND(SrcInitOutputData%DerivOrder_x,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%DerivOrder_x)) THEN 
    ALLOCATE(DstInitOutputData%DerivOrder_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%DerivOrder_x.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%DerivOrder_x = SrcInitOutputData%DerivOrder_x
ENDIF
IF (ALLOCATED(SrcInitOutputData%RotFrame_u)) THEN
  i1_l = LBOUND(SrcInitOutputData%RotFrame_u,1)
  i1_u = UBOUND(SrcInitOutputData%RotFrame_u,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%RotFrame_u)) THEN 
    ALLOCATE(DstInitOutputData%RotFrame_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%RotFrame_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%RotFrame_u = SrcInitOutputData%RotFrame_u
ENDIF
IF (ALLOCATED(SrcInitOutputData%IsLoad_u)) THEN
  i1_l = LBOUND(SrcInitOutputData%IsLoad_u,1)
  i1_u = UBOUND(SrcInitOutputData%IsLoad_u,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%IsLoad_u)) THEN 
    ALLOCATE(DstInitOutputData%IsLoad_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%IsLoad_u.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%IsLoad_u = SrcInitOutputData%IsLoad_u
ENDIF
 END SUBROUTINE ED_CopyInitOutput

 SUBROUTINE ED_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(ED_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
IF (ALLOCATED(InitOutputData%BlPitch)) THEN
  DEALLOCATE(InitOutputData%BlPitch)
ENDIF
IF (ALLOCATED(InitOutputData%BldRNodes)) THEN
  DEALLOCATE(InitOutputData%BldRNodes)
ENDIF
IF (ALLOCATED(InitOutputData%TwrHNodes)) THEN
  DEALLOCATE(InitOutputData%TwrHNodes)
ENDIF
IF (ALLOCATED(InitOutputData%LinNames_y)) THEN
  DEALLOCATE(InitOutputData%LinNames_y)
ENDIF
IF (ALLOCATED(InitOutputData%LinNames_x)) THEN
  DEALLOCATE(InitOutputData%LinNames_x)
ENDIF
IF (ALLOCATED(InitOutputData%LinNames_u)) THEN
  DEALLOCATE(InitOutputData%LinNames_u)
ENDIF
IF (ALLOCATED(InitOutputData%RotFrame_y)) THEN
  DEALLOCATE(InitOutputData%RotFrame_y)
ENDIF
IF (ALLOCATED(InitOutputData%RotFrame_x)) THEN
  DEALLOCATE(InitOutputData%RotFrame_x)
ENDIF
IF (ALLOCATED(InitOutputData%DerivOrder_x)) THEN
  DEALLOCATE(InitOutputData%DerivOrder_x)
ENDIF
IF (ALLOCATED(InitOutputData%RotFrame_u)) THEN
  DEALLOCATE(InitOutputData%RotFrame_u)
ENDIF
IF (ALLOCATED(InitOutputData%IsLoad_u)) THEN
  DEALLOCATE(InitOutputData%IsLoad_u)
ENDIF
 END SUBROUTINE ED_DestroyInitOutput

 SUBROUTINE ED_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumBl
  Int_BufSz   = Int_BufSz   + 1     ! BlPitch allocated yes/no
  IF ( ALLOCATED(InData%BlPitch) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BlPitch upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlPitch)  ! BlPitch
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BladeLength
      Re_BufSz   = Re_BufSz   + 1  ! TowerHeight
      Re_BufSz   = Re_BufSz   + 1  ! TowerBaseHeight
      Re_BufSz   = Re_BufSz   + 1  ! HubHt
  Int_BufSz   = Int_BufSz   + 1     ! BldRNodes allocated yes/no
  IF ( ALLOCATED(InData%BldRNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldRNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldRNodes)  ! BldRNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwrHNodes allocated yes/no
  IF ( ALLOCATED(InData%TwrHNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwrHNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrHNodes)  ! TwrHNodes
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%PlatformPos)  ! PlatformPos
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrBaseRefPos)  ! TwrBaseRefPos
      Db_BufSz   = Db_BufSz   + SIZE(InData%TwrBaseTransDisp)  ! TwrBaseTransDisp
      Db_BufSz   = Db_BufSz   + SIZE(InData%TwrBaseRefOrient)  ! TwrBaseRefOrient
      Db_BufSz   = Db_BufSz   + SIZE(InData%TwrBaseOrient)  ! TwrBaseOrient
      Re_BufSz   = Re_BufSz   + 1  ! HubRad
      Re_BufSz   = Re_BufSz   + 1  ! RotSpeed
      Int_BufSz  = Int_BufSz  + 1  ! isFixed_GenDOF
  Int_BufSz   = Int_BufSz   + 1     ! LinNames_y allocated yes/no
  IF ( ALLOCATED(InData%LinNames_y) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LinNames_y upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%LinNames_y)*LEN(InData%LinNames_y)  ! LinNames_y
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LinNames_x allocated yes/no
  IF ( ALLOCATED(InData%LinNames_x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LinNames_x upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%LinNames_x)*LEN(InData%LinNames_x)  ! LinNames_x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LinNames_u allocated yes/no
  IF ( ALLOCATED(InData%LinNames_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LinNames_u upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%LinNames_u)*LEN(InData%LinNames_u)  ! LinNames_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RotFrame_y allocated yes/no
  IF ( ALLOCATED(InData%RotFrame_y) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RotFrame_y upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%RotFrame_y)  ! RotFrame_y
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RotFrame_x allocated yes/no
  IF ( ALLOCATED(InData%RotFrame_x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RotFrame_x upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%RotFrame_x)  ! RotFrame_x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DerivOrder_x allocated yes/no
  IF ( ALLOCATED(InData%DerivOrder_x) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DerivOrder_x upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%DerivOrder_x)  ! DerivOrder_x
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RotFrame_u allocated yes/no
  IF ( ALLOCATED(InData%RotFrame_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RotFrame_u upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%RotFrame_u)  ! RotFrame_u
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! IsLoad_u allocated yes/no
  IF ( ALLOCATED(InData%IsLoad_u) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IsLoad_u upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%IsLoad_u)  ! IsLoad_u
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = InData%NumBl
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BlPitch) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlPitch,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlPitch,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BlPitch,1), UBOUND(InData%BlPitch,1)
        ReKiBuf(Re_Xferred) = InData%BlPitch(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BladeLength
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerHeight
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerBaseHeight
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubHt
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BldRNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldRNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldRNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldRNodes,1), UBOUND(InData%BldRNodes,1)
        ReKiBuf(Re_Xferred) = InData%BldRNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwrHNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrHNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrHNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwrHNodes,1), UBOUND(InData%TwrHNodes,1)
        ReKiBuf(Re_Xferred) = InData%TwrHNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DO i1 = LBOUND(InData%PlatformPos,1), UBOUND(InData%PlatformPos,1)
      ReKiBuf(Re_Xferred) = InData%PlatformPos(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%TwrBaseRefPos,1), UBOUND(InData%TwrBaseRefPos,1)
      ReKiBuf(Re_Xferred) = InData%TwrBaseRefPos(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%TwrBaseTransDisp,1), UBOUND(InData%TwrBaseTransDisp,1)
      DbKiBuf(Db_Xferred) = InData%TwrBaseTransDisp(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i2 = LBOUND(InData%TwrBaseRefOrient,2), UBOUND(InData%TwrBaseRefOrient,2)
      DO i1 = LBOUND(InData%TwrBaseRefOrient,1), UBOUND(InData%TwrBaseRefOrient,1)
        DbKiBuf(Db_Xferred) = InData%TwrBaseRefOrient(i1,i2)
        Db_Xferred = Db_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%TwrBaseOrient,2), UBOUND(InData%TwrBaseOrient,2)
      DO i1 = LBOUND(InData%TwrBaseOrient,1), UBOUND(InData%TwrBaseOrient,1)
        DbKiBuf(Db_Xferred) = InData%TwrBaseOrient(i1,i2)
        Db_Xferred = Db_Xferred + 1
      END DO
    END DO
    ReKiBuf(Re_Xferred) = InData%HubRad
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotSpeed
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%isFixed_GenDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%LinNames_y) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinNames_y,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinNames_y,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LinNames_y,1), UBOUND(InData%LinNames_y,1)
        DO I = 1, LEN(InData%LinNames_y)
          IntKiBuf(Int_Xferred) = ICHAR(InData%LinNames_y(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LinNames_x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinNames_x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinNames_x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LinNames_x,1), UBOUND(InData%LinNames_x,1)
        DO I = 1, LEN(InData%LinNames_x)
          IntKiBuf(Int_Xferred) = ICHAR(InData%LinNames_x(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LinNames_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinNames_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinNames_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LinNames_u,1), UBOUND(InData%LinNames_u,1)
        DO I = 1, LEN(InData%LinNames_u)
          IntKiBuf(Int_Xferred) = ICHAR(InData%LinNames_u(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RotFrame_y) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotFrame_y,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotFrame_y,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RotFrame_y,1), UBOUND(InData%RotFrame_y,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%RotFrame_y(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RotFrame_x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotFrame_x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotFrame_x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RotFrame_x,1), UBOUND(InData%RotFrame_x,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%RotFrame_x(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DerivOrder_x) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DerivOrder_x,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DerivOrder_x,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DerivOrder_x,1), UBOUND(InData%DerivOrder_x,1)
        IntKiBuf(Int_Xferred) = InData%DerivOrder_x(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RotFrame_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotFrame_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotFrame_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RotFrame_u,1), UBOUND(InData%RotFrame_u,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%RotFrame_u(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%IsLoad_u) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IsLoad_u,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IsLoad_u,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%IsLoad_u,1), UBOUND(InData%IsLoad_u,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%IsLoad_u(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_PackInitOutput

 SUBROUTINE ED_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%NumBl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlPitch not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlPitch)) DEALLOCATE(OutData%BlPitch)
    ALLOCATE(OutData%BlPitch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlPitch.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BlPitch,1), UBOUND(OutData%BlPitch,1)
        OutData%BlPitch(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%BladeLength = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerBaseHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldRNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldRNodes)) DEALLOCATE(OutData%BldRNodes)
    ALLOCATE(OutData%BldRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldRNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldRNodes,1), UBOUND(OutData%BldRNodes,1)
        OutData%BldRNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwrHNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwrHNodes)) DEALLOCATE(OutData%TwrHNodes)
    ALLOCATE(OutData%TwrHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwrHNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwrHNodes,1), UBOUND(OutData%TwrHNodes,1)
        OutData%TwrHNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    i1_l = LBOUND(OutData%PlatformPos,1)
    i1_u = UBOUND(OutData%PlatformPos,1)
    DO i1 = LBOUND(OutData%PlatformPos,1), UBOUND(OutData%PlatformPos,1)
      OutData%PlatformPos(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TwrBaseRefPos,1)
    i1_u = UBOUND(OutData%TwrBaseRefPos,1)
    DO i1 = LBOUND(OutData%TwrBaseRefPos,1), UBOUND(OutData%TwrBaseRefPos,1)
      OutData%TwrBaseRefPos(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TwrBaseTransDisp,1)
    i1_u = UBOUND(OutData%TwrBaseTransDisp,1)
    DO i1 = LBOUND(OutData%TwrBaseTransDisp,1), UBOUND(OutData%TwrBaseTransDisp,1)
      OutData%TwrBaseTransDisp(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TwrBaseRefOrient,1)
    i1_u = UBOUND(OutData%TwrBaseRefOrient,1)
    i2_l = LBOUND(OutData%TwrBaseRefOrient,2)
    i2_u = UBOUND(OutData%TwrBaseRefOrient,2)
    DO i2 = LBOUND(OutData%TwrBaseRefOrient,2), UBOUND(OutData%TwrBaseRefOrient,2)
      DO i1 = LBOUND(OutData%TwrBaseRefOrient,1), UBOUND(OutData%TwrBaseRefOrient,1)
        OutData%TwrBaseRefOrient(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%TwrBaseOrient,1)
    i1_u = UBOUND(OutData%TwrBaseOrient,1)
    i2_l = LBOUND(OutData%TwrBaseOrient,2)
    i2_u = UBOUND(OutData%TwrBaseOrient,2)
    DO i2 = LBOUND(OutData%TwrBaseOrient,2), UBOUND(OutData%TwrBaseOrient,2)
      DO i1 = LBOUND(OutData%TwrBaseOrient,1), UBOUND(OutData%TwrBaseOrient,1)
        OutData%TwrBaseOrient(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
    END DO
    OutData%HubRad = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RotSpeed = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%isFixed_GenDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%isFixed_GenDOF)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinNames_y not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinNames_y)) DEALLOCATE(OutData%LinNames_y)
    ALLOCATE(OutData%LinNames_y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinNames_y.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LinNames_y,1), UBOUND(OutData%LinNames_y,1)
        DO I = 1, LEN(OutData%LinNames_y)
          OutData%LinNames_y(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinNames_x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinNames_x)) DEALLOCATE(OutData%LinNames_x)
    ALLOCATE(OutData%LinNames_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinNames_x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LinNames_x,1), UBOUND(OutData%LinNames_x,1)
        DO I = 1, LEN(OutData%LinNames_x)
          OutData%LinNames_x(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinNames_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinNames_u)) DEALLOCATE(OutData%LinNames_u)
    ALLOCATE(OutData%LinNames_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinNames_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LinNames_u,1), UBOUND(OutData%LinNames_u,1)
        DO I = 1, LEN(OutData%LinNames_u)
          OutData%LinNames_u(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RotFrame_y not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RotFrame_y)) DEALLOCATE(OutData%RotFrame_y)
    ALLOCATE(OutData%RotFrame_y(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RotFrame_y.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RotFrame_y,1), UBOUND(OutData%RotFrame_y,1)
        OutData%RotFrame_y(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%RotFrame_y(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RotFrame_x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RotFrame_x)) DEALLOCATE(OutData%RotFrame_x)
    ALLOCATE(OutData%RotFrame_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RotFrame_x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RotFrame_x,1), UBOUND(OutData%RotFrame_x,1)
        OutData%RotFrame_x(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%RotFrame_x(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DerivOrder_x not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DerivOrder_x)) DEALLOCATE(OutData%DerivOrder_x)
    ALLOCATE(OutData%DerivOrder_x(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DerivOrder_x.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DerivOrder_x,1), UBOUND(OutData%DerivOrder_x,1)
        OutData%DerivOrder_x(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RotFrame_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RotFrame_u)) DEALLOCATE(OutData%RotFrame_u)
    ALLOCATE(OutData%RotFrame_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RotFrame_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RotFrame_u,1), UBOUND(OutData%RotFrame_u,1)
        OutData%RotFrame_u(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%RotFrame_u(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IsLoad_u not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IsLoad_u)) DEALLOCATE(OutData%IsLoad_u)
    ALLOCATE(OutData%IsLoad_u(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IsLoad_u.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%IsLoad_u,1), UBOUND(OutData%IsLoad_u,1)
        OutData%IsLoad_u(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%IsLoad_u(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_UnPackInitOutput

 SUBROUTINE ED_CopyBladeInputData( SrcBladeInputDataData, DstBladeInputDataData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BladeInputData), INTENT(IN) :: SrcBladeInputDataData
   TYPE(BladeInputData), INTENT(INOUT) :: DstBladeInputDataData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyBladeInputData'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstBladeInputDataData%NBlInpSt = SrcBladeInputDataData%NBlInpSt
IF (ALLOCATED(SrcBladeInputDataData%BlFract)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%BlFract,1)
  i1_u = UBOUND(SrcBladeInputDataData%BlFract,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%BlFract)) THEN 
    ALLOCATE(DstBladeInputDataData%BlFract(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BlFract.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%BlFract = SrcBladeInputDataData%BlFract
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%PitchAx)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%PitchAx,1)
  i1_u = UBOUND(SrcBladeInputDataData%PitchAx,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%PitchAx)) THEN 
    ALLOCATE(DstBladeInputDataData%PitchAx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%PitchAx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%PitchAx = SrcBladeInputDataData%PitchAx
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%StrcTwst)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%StrcTwst,1)
  i1_u = UBOUND(SrcBladeInputDataData%StrcTwst,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%StrcTwst)) THEN 
    ALLOCATE(DstBladeInputDataData%StrcTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%StrcTwst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%StrcTwst = SrcBladeInputDataData%StrcTwst
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%BMassDen)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%BMassDen,1)
  i1_u = UBOUND(SrcBladeInputDataData%BMassDen,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%BMassDen)) THEN 
    ALLOCATE(DstBladeInputDataData%BMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%BMassDen = SrcBladeInputDataData%BMassDen
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%FlpStff)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%FlpStff,1)
  i1_u = UBOUND(SrcBladeInputDataData%FlpStff,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%FlpStff)) THEN 
    ALLOCATE(DstBladeInputDataData%FlpStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%FlpStff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%FlpStff = SrcBladeInputDataData%FlpStff
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%EdgStff)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%EdgStff,1)
  i1_u = UBOUND(SrcBladeInputDataData%EdgStff,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%EdgStff)) THEN 
    ALLOCATE(DstBladeInputDataData%EdgStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EdgStff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%EdgStff = SrcBladeInputDataData%EdgStff
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%GJStff)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%GJStff,1)
  i1_u = UBOUND(SrcBladeInputDataData%GJStff,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%GJStff)) THEN 
    ALLOCATE(DstBladeInputDataData%GJStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%GJStff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%GJStff = SrcBladeInputDataData%GJStff
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%EAStff)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%EAStff,1)
  i1_u = UBOUND(SrcBladeInputDataData%EAStff,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%EAStff)) THEN 
    ALLOCATE(DstBladeInputDataData%EAStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EAStff.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%EAStff = SrcBladeInputDataData%EAStff
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%Alpha)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%Alpha,1)
  i1_u = UBOUND(SrcBladeInputDataData%Alpha,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%Alpha)) THEN 
    ALLOCATE(DstBladeInputDataData%Alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%Alpha.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%Alpha = SrcBladeInputDataData%Alpha
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%FlpIner)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%FlpIner,1)
  i1_u = UBOUND(SrcBladeInputDataData%FlpIner,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%FlpIner)) THEN 
    ALLOCATE(DstBladeInputDataData%FlpIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%FlpIner.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%FlpIner = SrcBladeInputDataData%FlpIner
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%EdgIner)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%EdgIner,1)
  i1_u = UBOUND(SrcBladeInputDataData%EdgIner,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%EdgIner)) THEN 
    ALLOCATE(DstBladeInputDataData%EdgIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EdgIner.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%EdgIner = SrcBladeInputDataData%EdgIner
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%PrecrvRef)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%PrecrvRef,1)
  i1_u = UBOUND(SrcBladeInputDataData%PrecrvRef,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%PrecrvRef)) THEN 
    ALLOCATE(DstBladeInputDataData%PrecrvRef(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%PrecrvRef.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%PrecrvRef = SrcBladeInputDataData%PrecrvRef
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%PreswpRef)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%PreswpRef,1)
  i1_u = UBOUND(SrcBladeInputDataData%PreswpRef,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%PreswpRef)) THEN 
    ALLOCATE(DstBladeInputDataData%PreswpRef(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%PreswpRef.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%PreswpRef = SrcBladeInputDataData%PreswpRef
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%FlpcgOf)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%FlpcgOf,1)
  i1_u = UBOUND(SrcBladeInputDataData%FlpcgOf,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%FlpcgOf)) THEN 
    ALLOCATE(DstBladeInputDataData%FlpcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%FlpcgOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%FlpcgOf = SrcBladeInputDataData%FlpcgOf
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%EdgcgOf)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%EdgcgOf,1)
  i1_u = UBOUND(SrcBladeInputDataData%EdgcgOf,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%EdgcgOf)) THEN 
    ALLOCATE(DstBladeInputDataData%EdgcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EdgcgOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%EdgcgOf = SrcBladeInputDataData%EdgcgOf
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%FlpEAOf)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%FlpEAOf,1)
  i1_u = UBOUND(SrcBladeInputDataData%FlpEAOf,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%FlpEAOf)) THEN 
    ALLOCATE(DstBladeInputDataData%FlpEAOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%FlpEAOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%FlpEAOf = SrcBladeInputDataData%FlpEAOf
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%EdgEAOf)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%EdgEAOf,1)
  i1_u = UBOUND(SrcBladeInputDataData%EdgEAOf,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%EdgEAOf)) THEN 
    ALLOCATE(DstBladeInputDataData%EdgEAOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%EdgEAOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%EdgEAOf = SrcBladeInputDataData%EdgEAOf
ENDIF
    DstBladeInputDataData%BldFlDmp = SrcBladeInputDataData%BldFlDmp
    DstBladeInputDataData%BldEdDmp = SrcBladeInputDataData%BldEdDmp
    DstBladeInputDataData%FlStTunr = SrcBladeInputDataData%FlStTunr
IF (ALLOCATED(SrcBladeInputDataData%BldFl1Sh)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%BldFl1Sh,1)
  i1_u = UBOUND(SrcBladeInputDataData%BldFl1Sh,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%BldFl1Sh)) THEN 
    ALLOCATE(DstBladeInputDataData%BldFl1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldFl1Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%BldFl1Sh = SrcBladeInputDataData%BldFl1Sh
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%BldFl2Sh)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%BldFl2Sh,1)
  i1_u = UBOUND(SrcBladeInputDataData%BldFl2Sh,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%BldFl2Sh)) THEN 
    ALLOCATE(DstBladeInputDataData%BldFl2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldFl2Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%BldFl2Sh = SrcBladeInputDataData%BldFl2Sh
ENDIF
IF (ALLOCATED(SrcBladeInputDataData%BldEdgSh)) THEN
  i1_l = LBOUND(SrcBladeInputDataData%BldEdgSh,1)
  i1_u = UBOUND(SrcBladeInputDataData%BldEdgSh,1)
  IF (.NOT. ALLOCATED(DstBladeInputDataData%BldEdgSh)) THEN 
    ALLOCATE(DstBladeInputDataData%BldEdgSh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeInputDataData%BldEdgSh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeInputDataData%BldEdgSh = SrcBladeInputDataData%BldEdgSh
ENDIF
 END SUBROUTINE ED_CopyBladeInputData

 SUBROUTINE ED_DestroyBladeInputData( BladeInputDataData, ErrStat, ErrMsg )
  TYPE(BladeInputData), INTENT(INOUT) :: BladeInputDataData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyBladeInputData'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(BladeInputDataData%BlFract)) THEN
  DEALLOCATE(BladeInputDataData%BlFract)
ENDIF
IF (ALLOCATED(BladeInputDataData%PitchAx)) THEN
  DEALLOCATE(BladeInputDataData%PitchAx)
ENDIF
IF (ALLOCATED(BladeInputDataData%StrcTwst)) THEN
  DEALLOCATE(BladeInputDataData%StrcTwst)
ENDIF
IF (ALLOCATED(BladeInputDataData%BMassDen)) THEN
  DEALLOCATE(BladeInputDataData%BMassDen)
ENDIF
IF (ALLOCATED(BladeInputDataData%FlpStff)) THEN
  DEALLOCATE(BladeInputDataData%FlpStff)
ENDIF
IF (ALLOCATED(BladeInputDataData%EdgStff)) THEN
  DEALLOCATE(BladeInputDataData%EdgStff)
ENDIF
IF (ALLOCATED(BladeInputDataData%GJStff)) THEN
  DEALLOCATE(BladeInputDataData%GJStff)
ENDIF
IF (ALLOCATED(BladeInputDataData%EAStff)) THEN
  DEALLOCATE(BladeInputDataData%EAStff)
ENDIF
IF (ALLOCATED(BladeInputDataData%Alpha)) THEN
  DEALLOCATE(BladeInputDataData%Alpha)
ENDIF
IF (ALLOCATED(BladeInputDataData%FlpIner)) THEN
  DEALLOCATE(BladeInputDataData%FlpIner)
ENDIF
IF (ALLOCATED(BladeInputDataData%EdgIner)) THEN
  DEALLOCATE(BladeInputDataData%EdgIner)
ENDIF
IF (ALLOCATED(BladeInputDataData%PrecrvRef)) THEN
  DEALLOCATE(BladeInputDataData%PrecrvRef)
ENDIF
IF (ALLOCATED(BladeInputDataData%PreswpRef)) THEN
  DEALLOCATE(BladeInputDataData%PreswpRef)
ENDIF
IF (ALLOCATED(BladeInputDataData%FlpcgOf)) THEN
  DEALLOCATE(BladeInputDataData%FlpcgOf)
ENDIF
IF (ALLOCATED(BladeInputDataData%EdgcgOf)) THEN
  DEALLOCATE(BladeInputDataData%EdgcgOf)
ENDIF
IF (ALLOCATED(BladeInputDataData%FlpEAOf)) THEN
  DEALLOCATE(BladeInputDataData%FlpEAOf)
ENDIF
IF (ALLOCATED(BladeInputDataData%EdgEAOf)) THEN
  DEALLOCATE(BladeInputDataData%EdgEAOf)
ENDIF
IF (ALLOCATED(BladeInputDataData%BldFl1Sh)) THEN
  DEALLOCATE(BladeInputDataData%BldFl1Sh)
ENDIF
IF (ALLOCATED(BladeInputDataData%BldFl2Sh)) THEN
  DEALLOCATE(BladeInputDataData%BldFl2Sh)
ENDIF
IF (ALLOCATED(BladeInputDataData%BldEdgSh)) THEN
  DEALLOCATE(BladeInputDataData%BldEdgSh)
ENDIF
 END SUBROUTINE ED_DestroyBladeInputData

 SUBROUTINE ED_PackBladeInputData( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BladeInputData),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackBladeInputData'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NBlInpSt
  Int_BufSz   = Int_BufSz   + 1     ! BlFract allocated yes/no
  IF ( ALLOCATED(InData%BlFract) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BlFract upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlFract)  ! BlFract
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PitchAx allocated yes/no
  IF ( ALLOCATED(InData%PitchAx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PitchAx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PitchAx)  ! PitchAx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StrcTwst allocated yes/no
  IF ( ALLOCATED(InData%StrcTwst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StrcTwst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StrcTwst)  ! StrcTwst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BMassDen allocated yes/no
  IF ( ALLOCATED(InData%BMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BMassDen)  ! BMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FlpStff allocated yes/no
  IF ( ALLOCATED(InData%FlpStff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FlpStff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FlpStff)  ! FlpStff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgStff allocated yes/no
  IF ( ALLOCATED(InData%EdgStff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EdgStff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgStff)  ! EdgStff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GJStff allocated yes/no
  IF ( ALLOCATED(InData%GJStff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! GJStff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%GJStff)  ! GJStff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EAStff allocated yes/no
  IF ( ALLOCATED(InData%EAStff) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EAStff upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EAStff)  ! EAStff
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Alpha allocated yes/no
  IF ( ALLOCATED(InData%Alpha) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Alpha upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Alpha)  ! Alpha
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FlpIner allocated yes/no
  IF ( ALLOCATED(InData%FlpIner) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FlpIner upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FlpIner)  ! FlpIner
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgIner allocated yes/no
  IF ( ALLOCATED(InData%EdgIner) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EdgIner upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgIner)  ! EdgIner
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PrecrvRef allocated yes/no
  IF ( ALLOCATED(InData%PrecrvRef) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PrecrvRef upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PrecrvRef)  ! PrecrvRef
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PreswpRef allocated yes/no
  IF ( ALLOCATED(InData%PreswpRef) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PreswpRef upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PreswpRef)  ! PreswpRef
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FlpcgOf allocated yes/no
  IF ( ALLOCATED(InData%FlpcgOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FlpcgOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FlpcgOf)  ! FlpcgOf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgcgOf allocated yes/no
  IF ( ALLOCATED(InData%EdgcgOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EdgcgOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgcgOf)  ! EdgcgOf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FlpEAOf allocated yes/no
  IF ( ALLOCATED(InData%FlpEAOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FlpEAOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FlpEAOf)  ! FlpEAOf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgEAOf allocated yes/no
  IF ( ALLOCATED(InData%EdgEAOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EdgEAOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgEAOf)  ! EdgEAOf
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFlDmp)  ! BldFlDmp
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldEdDmp)  ! BldEdDmp
      Re_BufSz   = Re_BufSz   + SIZE(InData%FlStTunr)  ! FlStTunr
  Int_BufSz   = Int_BufSz   + 1     ! BldFl1Sh allocated yes/no
  IF ( ALLOCATED(InData%BldFl1Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldFl1Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFl1Sh)  ! BldFl1Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldFl2Sh allocated yes/no
  IF ( ALLOCATED(InData%BldFl2Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldFl2Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFl2Sh)  ! BldFl2Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldEdgSh allocated yes/no
  IF ( ALLOCATED(InData%BldEdgSh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldEdgSh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldEdgSh)  ! BldEdgSh
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NBlInpSt
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BlFract) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlFract,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlFract,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BlFract,1), UBOUND(InData%BlFract,1)
        ReKiBuf(Re_Xferred) = InData%BlFract(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PitchAx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PitchAx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PitchAx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PitchAx,1), UBOUND(InData%PitchAx,1)
        ReKiBuf(Re_Xferred) = InData%PitchAx(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StrcTwst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StrcTwst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StrcTwst,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StrcTwst,1), UBOUND(InData%StrcTwst,1)
        ReKiBuf(Re_Xferred) = InData%StrcTwst(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BMassDen,1), UBOUND(InData%BMassDen,1)
        ReKiBuf(Re_Xferred) = InData%BMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FlpStff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FlpStff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FlpStff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FlpStff,1), UBOUND(InData%FlpStff,1)
        ReKiBuf(Re_Xferred) = InData%FlpStff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgStff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgStff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgStff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EdgStff,1), UBOUND(InData%EdgStff,1)
        ReKiBuf(Re_Xferred) = InData%EdgStff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GJStff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GJStff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GJStff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%GJStff,1), UBOUND(InData%GJStff,1)
        ReKiBuf(Re_Xferred) = InData%GJStff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EAStff) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EAStff,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EAStff,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EAStff,1), UBOUND(InData%EAStff,1)
        ReKiBuf(Re_Xferred) = InData%EAStff(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Alpha) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Alpha,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Alpha,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Alpha,1), UBOUND(InData%Alpha,1)
        ReKiBuf(Re_Xferred) = InData%Alpha(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FlpIner) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FlpIner,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FlpIner,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FlpIner,1), UBOUND(InData%FlpIner,1)
        ReKiBuf(Re_Xferred) = InData%FlpIner(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgIner) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgIner,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgIner,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EdgIner,1), UBOUND(InData%EdgIner,1)
        ReKiBuf(Re_Xferred) = InData%EdgIner(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PrecrvRef) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PrecrvRef,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PrecrvRef,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PrecrvRef,1), UBOUND(InData%PrecrvRef,1)
        ReKiBuf(Re_Xferred) = InData%PrecrvRef(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PreswpRef) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PreswpRef,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PreswpRef,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PreswpRef,1), UBOUND(InData%PreswpRef,1)
        ReKiBuf(Re_Xferred) = InData%PreswpRef(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FlpcgOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FlpcgOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FlpcgOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FlpcgOf,1), UBOUND(InData%FlpcgOf,1)
        ReKiBuf(Re_Xferred) = InData%FlpcgOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgcgOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgcgOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgcgOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EdgcgOf,1), UBOUND(InData%EdgcgOf,1)
        ReKiBuf(Re_Xferred) = InData%EdgcgOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FlpEAOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FlpEAOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FlpEAOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FlpEAOf,1), UBOUND(InData%FlpEAOf,1)
        ReKiBuf(Re_Xferred) = InData%FlpEAOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgEAOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgEAOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgEAOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EdgEAOf,1), UBOUND(InData%EdgEAOf,1)
        ReKiBuf(Re_Xferred) = InData%EdgEAOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DO i1 = LBOUND(InData%BldFlDmp,1), UBOUND(InData%BldFlDmp,1)
      ReKiBuf(Re_Xferred) = InData%BldFlDmp(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%BldEdDmp,1), UBOUND(InData%BldEdDmp,1)
      ReKiBuf(Re_Xferred) = InData%BldEdDmp(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FlStTunr,1), UBOUND(InData%FlStTunr,1)
      ReKiBuf(Re_Xferred) = InData%FlStTunr(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%BldFl1Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl1Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl1Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldFl1Sh,1), UBOUND(InData%BldFl1Sh,1)
        ReKiBuf(Re_Xferred) = InData%BldFl1Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldFl2Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl2Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl2Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldFl2Sh,1), UBOUND(InData%BldFl2Sh,1)
        ReKiBuf(Re_Xferred) = InData%BldFl2Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldEdgSh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldEdgSh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldEdgSh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldEdgSh,1), UBOUND(InData%BldEdgSh,1)
        ReKiBuf(Re_Xferred) = InData%BldEdgSh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_PackBladeInputData

 SUBROUTINE ED_UnPackBladeInputData( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BladeInputData), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackBladeInputData'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NBlInpSt = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlFract not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlFract)) DEALLOCATE(OutData%BlFract)
    ALLOCATE(OutData%BlFract(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlFract.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BlFract,1), UBOUND(OutData%BlFract,1)
        OutData%BlFract(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PitchAx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PitchAx)) DEALLOCATE(OutData%PitchAx)
    ALLOCATE(OutData%PitchAx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PitchAx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PitchAx,1), UBOUND(OutData%PitchAx,1)
        OutData%PitchAx(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StrcTwst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StrcTwst)) DEALLOCATE(OutData%StrcTwst)
    ALLOCATE(OutData%StrcTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StrcTwst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StrcTwst,1), UBOUND(OutData%StrcTwst,1)
        OutData%StrcTwst(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BMassDen)) DEALLOCATE(OutData%BMassDen)
    ALLOCATE(OutData%BMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BMassDen,1), UBOUND(OutData%BMassDen,1)
        OutData%BMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FlpStff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FlpStff)) DEALLOCATE(OutData%FlpStff)
    ALLOCATE(OutData%FlpStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlpStff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FlpStff,1), UBOUND(OutData%FlpStff,1)
        OutData%FlpStff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgStff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgStff)) DEALLOCATE(OutData%EdgStff)
    ALLOCATE(OutData%EdgStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgStff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EdgStff,1), UBOUND(OutData%EdgStff,1)
        OutData%EdgStff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GJStff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GJStff)) DEALLOCATE(OutData%GJStff)
    ALLOCATE(OutData%GJStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GJStff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%GJStff,1), UBOUND(OutData%GJStff,1)
        OutData%GJStff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EAStff not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EAStff)) DEALLOCATE(OutData%EAStff)
    ALLOCATE(OutData%EAStff(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EAStff.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EAStff,1), UBOUND(OutData%EAStff,1)
        OutData%EAStff(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Alpha not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Alpha)) DEALLOCATE(OutData%Alpha)
    ALLOCATE(OutData%Alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Alpha.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Alpha,1), UBOUND(OutData%Alpha,1)
        OutData%Alpha(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FlpIner not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FlpIner)) DEALLOCATE(OutData%FlpIner)
    ALLOCATE(OutData%FlpIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlpIner.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FlpIner,1), UBOUND(OutData%FlpIner,1)
        OutData%FlpIner(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgIner not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgIner)) DEALLOCATE(OutData%EdgIner)
    ALLOCATE(OutData%EdgIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgIner.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EdgIner,1), UBOUND(OutData%EdgIner,1)
        OutData%EdgIner(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PrecrvRef not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PrecrvRef)) DEALLOCATE(OutData%PrecrvRef)
    ALLOCATE(OutData%PrecrvRef(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PrecrvRef.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PrecrvRef,1), UBOUND(OutData%PrecrvRef,1)
        OutData%PrecrvRef(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PreswpRef not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PreswpRef)) DEALLOCATE(OutData%PreswpRef)
    ALLOCATE(OutData%PreswpRef(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PreswpRef.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PreswpRef,1), UBOUND(OutData%PreswpRef,1)
        OutData%PreswpRef(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FlpcgOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FlpcgOf)) DEALLOCATE(OutData%FlpcgOf)
    ALLOCATE(OutData%FlpcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlpcgOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FlpcgOf,1), UBOUND(OutData%FlpcgOf,1)
        OutData%FlpcgOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgcgOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgcgOf)) DEALLOCATE(OutData%EdgcgOf)
    ALLOCATE(OutData%EdgcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgcgOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EdgcgOf,1), UBOUND(OutData%EdgcgOf,1)
        OutData%EdgcgOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FlpEAOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FlpEAOf)) DEALLOCATE(OutData%FlpEAOf)
    ALLOCATE(OutData%FlpEAOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlpEAOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FlpEAOf,1), UBOUND(OutData%FlpEAOf,1)
        OutData%FlpEAOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgEAOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgEAOf)) DEALLOCATE(OutData%EdgEAOf)
    ALLOCATE(OutData%EdgEAOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgEAOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EdgEAOf,1), UBOUND(OutData%EdgEAOf,1)
        OutData%EdgEAOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    i1_l = LBOUND(OutData%BldFlDmp,1)
    i1_u = UBOUND(OutData%BldFlDmp,1)
    DO i1 = LBOUND(OutData%BldFlDmp,1), UBOUND(OutData%BldFlDmp,1)
      OutData%BldFlDmp(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%BldEdDmp,1)
    i1_u = UBOUND(OutData%BldEdDmp,1)
    DO i1 = LBOUND(OutData%BldEdDmp,1), UBOUND(OutData%BldEdDmp,1)
      OutData%BldEdDmp(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FlStTunr,1)
    i1_u = UBOUND(OutData%FlStTunr,1)
    DO i1 = LBOUND(OutData%FlStTunr,1), UBOUND(OutData%FlStTunr,1)
      OutData%FlStTunr(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldFl1Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldFl1Sh)) DEALLOCATE(OutData%BldFl1Sh)
    ALLOCATE(OutData%BldFl1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldFl1Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldFl1Sh,1), UBOUND(OutData%BldFl1Sh,1)
        OutData%BldFl1Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldFl2Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldFl2Sh)) DEALLOCATE(OutData%BldFl2Sh)
    ALLOCATE(OutData%BldFl2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldFl2Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldFl2Sh,1), UBOUND(OutData%BldFl2Sh,1)
        OutData%BldFl2Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldEdgSh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldEdgSh)) DEALLOCATE(OutData%BldEdgSh)
    ALLOCATE(OutData%BldEdgSh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldEdgSh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldEdgSh,1), UBOUND(OutData%BldEdgSh,1)
        OutData%BldEdgSh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_UnPackBladeInputData

 SUBROUTINE ED_CopyBladeMeshInputData( SrcBladeMeshInputDataData, DstBladeMeshInputDataData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_BladeMeshInputData), INTENT(IN) :: SrcBladeMeshInputDataData
   TYPE(ED_BladeMeshInputData), INTENT(INOUT) :: DstBladeMeshInputDataData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyBladeMeshInputData'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstBladeMeshInputDataData%BldNodes = SrcBladeMeshInputDataData%BldNodes
IF (ALLOCATED(SrcBladeMeshInputDataData%RNodes)) THEN
  i1_l = LBOUND(SrcBladeMeshInputDataData%RNodes,1)
  i1_u = UBOUND(SrcBladeMeshInputDataData%RNodes,1)
  IF (.NOT. ALLOCATED(DstBladeMeshInputDataData%RNodes)) THEN 
    ALLOCATE(DstBladeMeshInputDataData%RNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%RNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeMeshInputDataData%RNodes = SrcBladeMeshInputDataData%RNodes
ENDIF
IF (ALLOCATED(SrcBladeMeshInputDataData%AeroTwst)) THEN
  i1_l = LBOUND(SrcBladeMeshInputDataData%AeroTwst,1)
  i1_u = UBOUND(SrcBladeMeshInputDataData%AeroTwst,1)
  IF (.NOT. ALLOCATED(DstBladeMeshInputDataData%AeroTwst)) THEN 
    ALLOCATE(DstBladeMeshInputDataData%AeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%AeroTwst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeMeshInputDataData%AeroTwst = SrcBladeMeshInputDataData%AeroTwst
ENDIF
IF (ALLOCATED(SrcBladeMeshInputDataData%Chord)) THEN
  i1_l = LBOUND(SrcBladeMeshInputDataData%Chord,1)
  i1_u = UBOUND(SrcBladeMeshInputDataData%Chord,1)
  IF (.NOT. ALLOCATED(DstBladeMeshInputDataData%Chord)) THEN 
    ALLOCATE(DstBladeMeshInputDataData%Chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstBladeMeshInputDataData%Chord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstBladeMeshInputDataData%Chord = SrcBladeMeshInputDataData%Chord
ENDIF
 END SUBROUTINE ED_CopyBladeMeshInputData

 SUBROUTINE ED_DestroyBladeMeshInputData( BladeMeshInputDataData, ErrStat, ErrMsg )
  TYPE(ED_BladeMeshInputData), INTENT(INOUT) :: BladeMeshInputDataData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyBladeMeshInputData'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(BladeMeshInputDataData%RNodes)) THEN
  DEALLOCATE(BladeMeshInputDataData%RNodes)
ENDIF
IF (ALLOCATED(BladeMeshInputDataData%AeroTwst)) THEN
  DEALLOCATE(BladeMeshInputDataData%AeroTwst)
ENDIF
IF (ALLOCATED(BladeMeshInputDataData%Chord)) THEN
  DEALLOCATE(BladeMeshInputDataData%Chord)
ENDIF
 END SUBROUTINE ED_DestroyBladeMeshInputData

 SUBROUTINE ED_PackBladeMeshInputData( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_BladeMeshInputData),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackBladeMeshInputData'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! BldNodes
  Int_BufSz   = Int_BufSz   + 1     ! RNodes allocated yes/no
  IF ( ALLOCATED(InData%RNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RNodes)  ! RNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AeroTwst allocated yes/no
  IF ( ALLOCATED(InData%AeroTwst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AeroTwst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AeroTwst)  ! AeroTwst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Chord allocated yes/no
  IF ( ALLOCATED(InData%Chord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Chord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Chord)  ! Chord
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%BldNodes
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%RNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RNodes,1), UBOUND(InData%RNodes,1)
        ReKiBuf(Re_Xferred) = InData%RNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AeroTwst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AeroTwst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AeroTwst,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AeroTwst,1), UBOUND(InData%AeroTwst,1)
        ReKiBuf(Re_Xferred) = InData%AeroTwst(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Chord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Chord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Chord,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Chord,1), UBOUND(InData%Chord,1)
        ReKiBuf(Re_Xferred) = InData%Chord(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_PackBladeMeshInputData

 SUBROUTINE ED_UnPackBladeMeshInputData( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_BladeMeshInputData), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackBladeMeshInputData'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%BldNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RNodes)) DEALLOCATE(OutData%RNodes)
    ALLOCATE(OutData%RNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RNodes,1), UBOUND(OutData%RNodes,1)
        OutData%RNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AeroTwst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AeroTwst)) DEALLOCATE(OutData%AeroTwst)
    ALLOCATE(OutData%AeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AeroTwst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AeroTwst,1), UBOUND(OutData%AeroTwst,1)
        OutData%AeroTwst(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Chord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Chord)) DEALLOCATE(OutData%Chord)
    ALLOCATE(OutData%Chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Chord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Chord,1), UBOUND(OutData%Chord,1)
        OutData%Chord(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_UnPackBladeMeshInputData

 SUBROUTINE ED_CopyInputFile( SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_InputFile), INTENT(IN) :: SrcInputFileData
   TYPE(ED_InputFile), INTENT(INOUT) :: DstInputFileData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyInputFile'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileData%DT = SrcInputFileData%DT
    DstInputFileData%FlapDOF1 = SrcInputFileData%FlapDOF1
    DstInputFileData%FlapDOF2 = SrcInputFileData%FlapDOF2
    DstInputFileData%EdgeDOF = SrcInputFileData%EdgeDOF
    DstInputFileData%TeetDOF = SrcInputFileData%TeetDOF
    DstInputFileData%DrTrDOF = SrcInputFileData%DrTrDOF
    DstInputFileData%GenDOF = SrcInputFileData%GenDOF
    DstInputFileData%YawDOF = SrcInputFileData%YawDOF
    DstInputFileData%TwFADOF1 = SrcInputFileData%TwFADOF1
    DstInputFileData%TwFADOF2 = SrcInputFileData%TwFADOF2
    DstInputFileData%TwSSDOF1 = SrcInputFileData%TwSSDOF1
    DstInputFileData%TwSSDOF2 = SrcInputFileData%TwSSDOF2
    DstInputFileData%PtfmSgDOF = SrcInputFileData%PtfmSgDOF
    DstInputFileData%PtfmSwDOF = SrcInputFileData%PtfmSwDOF
    DstInputFileData%PtfmHvDOF = SrcInputFileData%PtfmHvDOF
    DstInputFileData%PtfmRDOF = SrcInputFileData%PtfmRDOF
    DstInputFileData%PtfmPDOF = SrcInputFileData%PtfmPDOF
    DstInputFileData%PtfmYDOF = SrcInputFileData%PtfmYDOF
    DstInputFileData%OoPDefl = SrcInputFileData%OoPDefl
    DstInputFileData%IPDefl = SrcInputFileData%IPDefl
IF (ALLOCATED(SrcInputFileData%BlPitch)) THEN
  i1_l = LBOUND(SrcInputFileData%BlPitch,1)
  i1_u = UBOUND(SrcInputFileData%BlPitch,1)
  IF (.NOT. ALLOCATED(DstInputFileData%BlPitch)) THEN 
    ALLOCATE(DstInputFileData%BlPitch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BlPitch.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%BlPitch = SrcInputFileData%BlPitch
ENDIF
    DstInputFileData%TeetDefl = SrcInputFileData%TeetDefl
    DstInputFileData%Azimuth = SrcInputFileData%Azimuth
    DstInputFileData%RotSpeed = SrcInputFileData%RotSpeed
    DstInputFileData%NacYaw = SrcInputFileData%NacYaw
    DstInputFileData%TTDspFA = SrcInputFileData%TTDspFA
    DstInputFileData%TTDspSS = SrcInputFileData%TTDspSS
    DstInputFileData%PtfmSurge = SrcInputFileData%PtfmSurge
    DstInputFileData%PtfmSway = SrcInputFileData%PtfmSway
    DstInputFileData%PtfmHeave = SrcInputFileData%PtfmHeave
    DstInputFileData%PtfmRoll = SrcInputFileData%PtfmRoll
    DstInputFileData%PtfmPitch = SrcInputFileData%PtfmPitch
    DstInputFileData%PtfmYaw = SrcInputFileData%PtfmYaw
    DstInputFileData%NumBl = SrcInputFileData%NumBl
    DstInputFileData%TipRad = SrcInputFileData%TipRad
    DstInputFileData%HubRad = SrcInputFileData%HubRad
IF (ALLOCATED(SrcInputFileData%PreCone)) THEN
  i1_l = LBOUND(SrcInputFileData%PreCone,1)
  i1_u = UBOUND(SrcInputFileData%PreCone,1)
  IF (.NOT. ALLOCATED(DstInputFileData%PreCone)) THEN 
    ALLOCATE(DstInputFileData%PreCone(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%PreCone.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%PreCone = SrcInputFileData%PreCone
ENDIF
    DstInputFileData%HubCM = SrcInputFileData%HubCM
    DstInputFileData%UndSling = SrcInputFileData%UndSling
    DstInputFileData%Delta3 = SrcInputFileData%Delta3
    DstInputFileData%AzimB1Up = SrcInputFileData%AzimB1Up
    DstInputFileData%OverHang = SrcInputFileData%OverHang
    DstInputFileData%ShftGagL = SrcInputFileData%ShftGagL
    DstInputFileData%ShftTilt = SrcInputFileData%ShftTilt
    DstInputFileData%NacCMxn = SrcInputFileData%NacCMxn
    DstInputFileData%NacCMyn = SrcInputFileData%NacCMyn
    DstInputFileData%NacCMzn = SrcInputFileData%NacCMzn
    DstInputFileData%NcIMUxn = SrcInputFileData%NcIMUxn
    DstInputFileData%NcIMUyn = SrcInputFileData%NcIMUyn
    DstInputFileData%NcIMUzn = SrcInputFileData%NcIMUzn
    DstInputFileData%Twr2Shft = SrcInputFileData%Twr2Shft
    DstInputFileData%TowerHt = SrcInputFileData%TowerHt
    DstInputFileData%TowerBsHt = SrcInputFileData%TowerBsHt
    DstInputFileData%PtfmCMxt = SrcInputFileData%PtfmCMxt
    DstInputFileData%PtfmCMyt = SrcInputFileData%PtfmCMyt
    DstInputFileData%PtfmCMzt = SrcInputFileData%PtfmCMzt
    DstInputFileData%PtfmRefzt = SrcInputFileData%PtfmRefzt
IF (ALLOCATED(SrcInputFileData%TipMass)) THEN
  i1_l = LBOUND(SrcInputFileData%TipMass,1)
  i1_u = UBOUND(SrcInputFileData%TipMass,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TipMass)) THEN 
    ALLOCATE(DstInputFileData%TipMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TipMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TipMass = SrcInputFileData%TipMass
ENDIF
    DstInputFileData%HubMass = SrcInputFileData%HubMass
    DstInputFileData%HubIner = SrcInputFileData%HubIner
    DstInputFileData%GenIner = SrcInputFileData%GenIner
    DstInputFileData%NacMass = SrcInputFileData%NacMass
    DstInputFileData%NacYIner = SrcInputFileData%NacYIner
    DstInputFileData%YawBrMass = SrcInputFileData%YawBrMass
    DstInputFileData%PtfmMass = SrcInputFileData%PtfmMass
    DstInputFileData%PtfmRIner = SrcInputFileData%PtfmRIner
    DstInputFileData%PtfmPIner = SrcInputFileData%PtfmPIner
    DstInputFileData%PtfmYIner = SrcInputFileData%PtfmYIner
    DstInputFileData%BldNodes = SrcInputFileData%BldNodes
IF (ALLOCATED(SrcInputFileData%InpBlMesh)) THEN
  i1_l = LBOUND(SrcInputFileData%InpBlMesh,1)
  i1_u = UBOUND(SrcInputFileData%InpBlMesh,1)
  IF (.NOT. ALLOCATED(DstInputFileData%InpBlMesh)) THEN 
    ALLOCATE(DstInputFileData%InpBlMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InpBlMesh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputFileData%InpBlMesh,1), UBOUND(SrcInputFileData%InpBlMesh,1)
      CALL ED_Copyblademeshinputdata( SrcInputFileData%InpBlMesh(i1), DstInputFileData%InpBlMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInputFileData%InpBl)) THEN
  i1_l = LBOUND(SrcInputFileData%InpBl,1)
  i1_u = UBOUND(SrcInputFileData%InpBl,1)
  IF (.NOT. ALLOCATED(DstInputFileData%InpBl)) THEN 
    ALLOCATE(DstInputFileData%InpBl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%InpBl.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputFileData%InpBl,1), UBOUND(SrcInputFileData%InpBl,1)
      CALL ED_Copybladeinputdata( SrcInputFileData%InpBl(i1), DstInputFileData%InpBl(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInputFileData%TeetMod = SrcInputFileData%TeetMod
    DstInputFileData%TeetDmpP = SrcInputFileData%TeetDmpP
    DstInputFileData%TeetDmp = SrcInputFileData%TeetDmp
    DstInputFileData%TeetCDmp = SrcInputFileData%TeetCDmp
    DstInputFileData%TeetSStP = SrcInputFileData%TeetSStP
    DstInputFileData%TeetHStP = SrcInputFileData%TeetHStP
    DstInputFileData%TeetSSSp = SrcInputFileData%TeetSSSp
    DstInputFileData%TeetHSSp = SrcInputFileData%TeetHSSp
    DstInputFileData%GBoxEff = SrcInputFileData%GBoxEff
    DstInputFileData%GBRatio = SrcInputFileData%GBRatio
    DstInputFileData%DTTorSpr = SrcInputFileData%DTTorSpr
    DstInputFileData%DTTorDmp = SrcInputFileData%DTTorDmp
    DstInputFileData%Furling = SrcInputFileData%Furling
    DstInputFileData%TwrNodes = SrcInputFileData%TwrNodes
    DstInputFileData%SumPrint = SrcInputFileData%SumPrint
    DstInputFileData%OutFile = SrcInputFileData%OutFile
    DstInputFileData%TabDelim = SrcInputFileData%TabDelim
    DstInputFileData%OutFmt = SrcInputFileData%OutFmt
    DstInputFileData%Tstart = SrcInputFileData%Tstart
    DstInputFileData%DecFact = SrcInputFileData%DecFact
    DstInputFileData%NTwGages = SrcInputFileData%NTwGages
    DstInputFileData%TwrGagNd = SrcInputFileData%TwrGagNd
    DstInputFileData%NBlGages = SrcInputFileData%NBlGages
    DstInputFileData%BldGagNd = SrcInputFileData%BldGagNd
    DstInputFileData%NumOuts = SrcInputFileData%NumOuts
IF (ALLOCATED(SrcInputFileData%OutList)) THEN
  i1_l = LBOUND(SrcInputFileData%OutList,1)
  i1_u = UBOUND(SrcInputFileData%OutList,1)
  IF (.NOT. ALLOCATED(DstInputFileData%OutList)) THEN 
    ALLOCATE(DstInputFileData%OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%OutList = SrcInputFileData%OutList
ENDIF
    DstInputFileData%NTwInpSt = SrcInputFileData%NTwInpSt
    DstInputFileData%TwrFADmp = SrcInputFileData%TwrFADmp
    DstInputFileData%TwrSSDmp = SrcInputFileData%TwrSSDmp
    DstInputFileData%FAStTunr = SrcInputFileData%FAStTunr
    DstInputFileData%SSStTunr = SrcInputFileData%SSStTunr
IF (ALLOCATED(SrcInputFileData%HtFract)) THEN
  i1_l = LBOUND(SrcInputFileData%HtFract,1)
  i1_u = UBOUND(SrcInputFileData%HtFract,1)
  IF (.NOT. ALLOCATED(DstInputFileData%HtFract)) THEN 
    ALLOCATE(DstInputFileData%HtFract(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%HtFract.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%HtFract = SrcInputFileData%HtFract
ENDIF
IF (ALLOCATED(SrcInputFileData%TMassDen)) THEN
  i1_l = LBOUND(SrcInputFileData%TMassDen,1)
  i1_u = UBOUND(SrcInputFileData%TMassDen,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TMassDen)) THEN 
    ALLOCATE(DstInputFileData%TMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TMassDen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TMassDen = SrcInputFileData%TMassDen
ENDIF
IF (ALLOCATED(SrcInputFileData%TwFAStif)) THEN
  i1_l = LBOUND(SrcInputFileData%TwFAStif,1)
  i1_u = UBOUND(SrcInputFileData%TwFAStif,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwFAStif)) THEN 
    ALLOCATE(DstInputFileData%TwFAStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAStif.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwFAStif = SrcInputFileData%TwFAStif
ENDIF
IF (ALLOCATED(SrcInputFileData%TwSSStif)) THEN
  i1_l = LBOUND(SrcInputFileData%TwSSStif,1)
  i1_u = UBOUND(SrcInputFileData%TwSSStif,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwSSStif)) THEN 
    ALLOCATE(DstInputFileData%TwSSStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSStif.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwSSStif = SrcInputFileData%TwSSStif
ENDIF
IF (ALLOCATED(SrcInputFileData%TwFAM1Sh)) THEN
  i1_l = LBOUND(SrcInputFileData%TwFAM1Sh,1)
  i1_u = UBOUND(SrcInputFileData%TwFAM1Sh,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwFAM1Sh)) THEN 
    ALLOCATE(DstInputFileData%TwFAM1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAM1Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwFAM1Sh = SrcInputFileData%TwFAM1Sh
ENDIF
IF (ALLOCATED(SrcInputFileData%TwFAM2Sh)) THEN
  i1_l = LBOUND(SrcInputFileData%TwFAM2Sh,1)
  i1_u = UBOUND(SrcInputFileData%TwFAM2Sh,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwFAM2Sh)) THEN 
    ALLOCATE(DstInputFileData%TwFAM2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAM2Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwFAM2Sh = SrcInputFileData%TwFAM2Sh
ENDIF
IF (ALLOCATED(SrcInputFileData%TwSSM1Sh)) THEN
  i1_l = LBOUND(SrcInputFileData%TwSSM1Sh,1)
  i1_u = UBOUND(SrcInputFileData%TwSSM1Sh,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwSSM1Sh)) THEN 
    ALLOCATE(DstInputFileData%TwSSM1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSM1Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwSSM1Sh = SrcInputFileData%TwSSM1Sh
ENDIF
IF (ALLOCATED(SrcInputFileData%TwSSM2Sh)) THEN
  i1_l = LBOUND(SrcInputFileData%TwSSM2Sh,1)
  i1_u = UBOUND(SrcInputFileData%TwSSM2Sh,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwSSM2Sh)) THEN 
    ALLOCATE(DstInputFileData%TwSSM2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSM2Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwSSM2Sh = SrcInputFileData%TwSSM2Sh
ENDIF
IF (ALLOCATED(SrcInputFileData%TwGJStif)) THEN
  i1_l = LBOUND(SrcInputFileData%TwGJStif,1)
  i1_u = UBOUND(SrcInputFileData%TwGJStif,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwGJStif)) THEN 
    ALLOCATE(DstInputFileData%TwGJStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwGJStif.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwGJStif = SrcInputFileData%TwGJStif
ENDIF
IF (ALLOCATED(SrcInputFileData%TwEAStif)) THEN
  i1_l = LBOUND(SrcInputFileData%TwEAStif,1)
  i1_u = UBOUND(SrcInputFileData%TwEAStif,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwEAStif)) THEN 
    ALLOCATE(DstInputFileData%TwEAStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwEAStif.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwEAStif = SrcInputFileData%TwEAStif
ENDIF
IF (ALLOCATED(SrcInputFileData%TwFAIner)) THEN
  i1_l = LBOUND(SrcInputFileData%TwFAIner,1)
  i1_u = UBOUND(SrcInputFileData%TwFAIner,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwFAIner)) THEN 
    ALLOCATE(DstInputFileData%TwFAIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAIner.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwFAIner = SrcInputFileData%TwFAIner
ENDIF
IF (ALLOCATED(SrcInputFileData%TwSSIner)) THEN
  i1_l = LBOUND(SrcInputFileData%TwSSIner,1)
  i1_u = UBOUND(SrcInputFileData%TwSSIner,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwSSIner)) THEN 
    ALLOCATE(DstInputFileData%TwSSIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSSIner.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwSSIner = SrcInputFileData%TwSSIner
ENDIF
IF (ALLOCATED(SrcInputFileData%TwFAcgOf)) THEN
  i1_l = LBOUND(SrcInputFileData%TwFAcgOf,1)
  i1_u = UBOUND(SrcInputFileData%TwFAcgOf,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwFAcgOf)) THEN 
    ALLOCATE(DstInputFileData%TwFAcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwFAcgOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwFAcgOf = SrcInputFileData%TwFAcgOf
ENDIF
IF (ALLOCATED(SrcInputFileData%TwSScgOf)) THEN
  i1_l = LBOUND(SrcInputFileData%TwSScgOf,1)
  i1_u = UBOUND(SrcInputFileData%TwSScgOf,1)
  IF (.NOT. ALLOCATED(DstInputFileData%TwSScgOf)) THEN 
    ALLOCATE(DstInputFileData%TwSScgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TwSScgOf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TwSScgOf = SrcInputFileData%TwSScgOf
ENDIF
    DstInputFileData%RFrlDOF = SrcInputFileData%RFrlDOF
    DstInputFileData%TFrlDOF = SrcInputFileData%TFrlDOF
    DstInputFileData%RotFurl = SrcInputFileData%RotFurl
    DstInputFileData%TailFurl = SrcInputFileData%TailFurl
    DstInputFileData%Yaw2Shft = SrcInputFileData%Yaw2Shft
    DstInputFileData%ShftSkew = SrcInputFileData%ShftSkew
    DstInputFileData%RFrlCMxn = SrcInputFileData%RFrlCMxn
    DstInputFileData%RFrlCMyn = SrcInputFileData%RFrlCMyn
    DstInputFileData%RFrlCMzn = SrcInputFileData%RFrlCMzn
    DstInputFileData%BoomCMxn = SrcInputFileData%BoomCMxn
    DstInputFileData%BoomCMyn = SrcInputFileData%BoomCMyn
    DstInputFileData%BoomCMzn = SrcInputFileData%BoomCMzn
    DstInputFileData%TFinCMxn = SrcInputFileData%TFinCMxn
    DstInputFileData%TFinCMyn = SrcInputFileData%TFinCMyn
    DstInputFileData%TFinCMzn = SrcInputFileData%TFinCMzn
    DstInputFileData%TFinCPxn = SrcInputFileData%TFinCPxn
    DstInputFileData%TFinCPyn = SrcInputFileData%TFinCPyn
    DstInputFileData%TFinCPzn = SrcInputFileData%TFinCPzn
    DstInputFileData%TFinSkew = SrcInputFileData%TFinSkew
    DstInputFileData%TFinTilt = SrcInputFileData%TFinTilt
    DstInputFileData%TFinBank = SrcInputFileData%TFinBank
    DstInputFileData%RFrlPntxn = SrcInputFileData%RFrlPntxn
    DstInputFileData%RFrlPntyn = SrcInputFileData%RFrlPntyn
    DstInputFileData%RFrlPntzn = SrcInputFileData%RFrlPntzn
    DstInputFileData%RFrlSkew = SrcInputFileData%RFrlSkew
    DstInputFileData%RFrlTilt = SrcInputFileData%RFrlTilt
    DstInputFileData%TFrlPntxn = SrcInputFileData%TFrlPntxn
    DstInputFileData%TFrlPntyn = SrcInputFileData%TFrlPntyn
    DstInputFileData%TFrlPntzn = SrcInputFileData%TFrlPntzn
    DstInputFileData%TFrlSkew = SrcInputFileData%TFrlSkew
    DstInputFileData%TFrlTilt = SrcInputFileData%TFrlTilt
    DstInputFileData%RFrlMass = SrcInputFileData%RFrlMass
    DstInputFileData%BoomMass = SrcInputFileData%BoomMass
    DstInputFileData%TFinMass = SrcInputFileData%TFinMass
    DstInputFileData%RFrlIner = SrcInputFileData%RFrlIner
    DstInputFileData%TFrlIner = SrcInputFileData%TFrlIner
    DstInputFileData%RFrlMod = SrcInputFileData%RFrlMod
    DstInputFileData%RFrlSpr = SrcInputFileData%RFrlSpr
    DstInputFileData%RFrlDmp = SrcInputFileData%RFrlDmp
    DstInputFileData%RFrlCDmp = SrcInputFileData%RFrlCDmp
    DstInputFileData%RFrlUSSP = SrcInputFileData%RFrlUSSP
    DstInputFileData%RFrlDSSP = SrcInputFileData%RFrlDSSP
    DstInputFileData%RFrlUSSpr = SrcInputFileData%RFrlUSSpr
    DstInputFileData%RFrlDSSpr = SrcInputFileData%RFrlDSSpr
    DstInputFileData%RFrlUSDP = SrcInputFileData%RFrlUSDP
    DstInputFileData%RFrlDSDP = SrcInputFileData%RFrlDSDP
    DstInputFileData%RFrlUSDmp = SrcInputFileData%RFrlUSDmp
    DstInputFileData%RFrlDSDmp = SrcInputFileData%RFrlDSDmp
    DstInputFileData%TFrlMod = SrcInputFileData%TFrlMod
    DstInputFileData%TFrlSpr = SrcInputFileData%TFrlSpr
    DstInputFileData%TFrlDmp = SrcInputFileData%TFrlDmp
    DstInputFileData%TFrlCDmp = SrcInputFileData%TFrlCDmp
    DstInputFileData%TFrlUSSP = SrcInputFileData%TFrlUSSP
    DstInputFileData%TFrlDSSP = SrcInputFileData%TFrlDSSP
    DstInputFileData%TFrlUSSpr = SrcInputFileData%TFrlUSSpr
    DstInputFileData%TFrlDSSpr = SrcInputFileData%TFrlDSSpr
    DstInputFileData%TFrlUSDP = SrcInputFileData%TFrlUSDP
    DstInputFileData%TFrlDSDP = SrcInputFileData%TFrlDSDP
    DstInputFileData%TFrlUSDmp = SrcInputFileData%TFrlUSDmp
    DstInputFileData%TFrlDSDmp = SrcInputFileData%TFrlDSDmp
    DstInputFileData%method = SrcInputFileData%method
    DstInputFileData%BldNd_NumOuts = SrcInputFileData%BldNd_NumOuts
IF (ALLOCATED(SrcInputFileData%BldNd_OutList)) THEN
  i1_l = LBOUND(SrcInputFileData%BldNd_OutList,1)
  i1_u = UBOUND(SrcInputFileData%BldNd_OutList,1)
  IF (.NOT. ALLOCATED(DstInputFileData%BldNd_OutList)) THEN 
    ALLOCATE(DstInputFileData%BldNd_OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BldNd_OutList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%BldNd_OutList = SrcInputFileData%BldNd_OutList
ENDIF
    DstInputFileData%BldNd_BlOutNd_Str = SrcInputFileData%BldNd_BlOutNd_Str
    DstInputFileData%BldNd_BladesOut = SrcInputFileData%BldNd_BladesOut
 END SUBROUTINE ED_CopyInputFile

 SUBROUTINE ED_DestroyInputFile( InputFileData, ErrStat, ErrMsg )
  TYPE(ED_InputFile), INTENT(INOUT) :: InputFileData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyInputFile'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputFileData%BlPitch)) THEN
  DEALLOCATE(InputFileData%BlPitch)
ENDIF
IF (ALLOCATED(InputFileData%PreCone)) THEN
  DEALLOCATE(InputFileData%PreCone)
ENDIF
IF (ALLOCATED(InputFileData%TipMass)) THEN
  DEALLOCATE(InputFileData%TipMass)
ENDIF
IF (ALLOCATED(InputFileData%InpBlMesh)) THEN
DO i1 = LBOUND(InputFileData%InpBlMesh,1), UBOUND(InputFileData%InpBlMesh,1)
  CALL ED_Destroyblademeshinputdata( InputFileData%InpBlMesh(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputFileData%InpBlMesh)
ENDIF
IF (ALLOCATED(InputFileData%InpBl)) THEN
DO i1 = LBOUND(InputFileData%InpBl,1), UBOUND(InputFileData%InpBl,1)
  CALL ED_Destroybladeinputdata( InputFileData%InpBl(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputFileData%InpBl)
ENDIF
IF (ALLOCATED(InputFileData%OutList)) THEN
  DEALLOCATE(InputFileData%OutList)
ENDIF
IF (ALLOCATED(InputFileData%HtFract)) THEN
  DEALLOCATE(InputFileData%HtFract)
ENDIF
IF (ALLOCATED(InputFileData%TMassDen)) THEN
  DEALLOCATE(InputFileData%TMassDen)
ENDIF
IF (ALLOCATED(InputFileData%TwFAStif)) THEN
  DEALLOCATE(InputFileData%TwFAStif)
ENDIF
IF (ALLOCATED(InputFileData%TwSSStif)) THEN
  DEALLOCATE(InputFileData%TwSSStif)
ENDIF
IF (ALLOCATED(InputFileData%TwFAM1Sh)) THEN
  DEALLOCATE(InputFileData%TwFAM1Sh)
ENDIF
IF (ALLOCATED(InputFileData%TwFAM2Sh)) THEN
  DEALLOCATE(InputFileData%TwFAM2Sh)
ENDIF
IF (ALLOCATED(InputFileData%TwSSM1Sh)) THEN
  DEALLOCATE(InputFileData%TwSSM1Sh)
ENDIF
IF (ALLOCATED(InputFileData%TwSSM2Sh)) THEN
  DEALLOCATE(InputFileData%TwSSM2Sh)
ENDIF
IF (ALLOCATED(InputFileData%TwGJStif)) THEN
  DEALLOCATE(InputFileData%TwGJStif)
ENDIF
IF (ALLOCATED(InputFileData%TwEAStif)) THEN
  DEALLOCATE(InputFileData%TwEAStif)
ENDIF
IF (ALLOCATED(InputFileData%TwFAIner)) THEN
  DEALLOCATE(InputFileData%TwFAIner)
ENDIF
IF (ALLOCATED(InputFileData%TwSSIner)) THEN
  DEALLOCATE(InputFileData%TwSSIner)
ENDIF
IF (ALLOCATED(InputFileData%TwFAcgOf)) THEN
  DEALLOCATE(InputFileData%TwFAcgOf)
ENDIF
IF (ALLOCATED(InputFileData%TwSScgOf)) THEN
  DEALLOCATE(InputFileData%TwSScgOf)
ENDIF
IF (ALLOCATED(InputFileData%BldNd_OutList)) THEN
  DEALLOCATE(InputFileData%BldNd_OutList)
ENDIF
 END SUBROUTINE ED_DestroyInputFile

 SUBROUTINE ED_PackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_InputFile),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackInputFile'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Int_BufSz  = Int_BufSz  + 1  ! FlapDOF1
      Int_BufSz  = Int_BufSz  + 1  ! FlapDOF2
      Int_BufSz  = Int_BufSz  + 1  ! EdgeDOF
      Int_BufSz  = Int_BufSz  + 1  ! TeetDOF
      Int_BufSz  = Int_BufSz  + 1  ! DrTrDOF
      Int_BufSz  = Int_BufSz  + 1  ! GenDOF
      Int_BufSz  = Int_BufSz  + 1  ! YawDOF
      Int_BufSz  = Int_BufSz  + 1  ! TwFADOF1
      Int_BufSz  = Int_BufSz  + 1  ! TwFADOF2
      Int_BufSz  = Int_BufSz  + 1  ! TwSSDOF1
      Int_BufSz  = Int_BufSz  + 1  ! TwSSDOF2
      Int_BufSz  = Int_BufSz  + 1  ! PtfmSgDOF
      Int_BufSz  = Int_BufSz  + 1  ! PtfmSwDOF
      Int_BufSz  = Int_BufSz  + 1  ! PtfmHvDOF
      Int_BufSz  = Int_BufSz  + 1  ! PtfmRDOF
      Int_BufSz  = Int_BufSz  + 1  ! PtfmPDOF
      Int_BufSz  = Int_BufSz  + 1  ! PtfmYDOF
      Re_BufSz   = Re_BufSz   + 1  ! OoPDefl
      Re_BufSz   = Re_BufSz   + 1  ! IPDefl
  Int_BufSz   = Int_BufSz   + 1     ! BlPitch allocated yes/no
  IF ( ALLOCATED(InData%BlPitch) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BlPitch upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlPitch)  ! BlPitch
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! TeetDefl
      Db_BufSz   = Db_BufSz   + 1  ! Azimuth
      Re_BufSz   = Re_BufSz   + 1  ! RotSpeed
      Re_BufSz   = Re_BufSz   + 1  ! NacYaw
      Re_BufSz   = Re_BufSz   + 1  ! TTDspFA
      Re_BufSz   = Re_BufSz   + 1  ! TTDspSS
      Re_BufSz   = Re_BufSz   + 1  ! PtfmSurge
      Re_BufSz   = Re_BufSz   + 1  ! PtfmSway
      Re_BufSz   = Re_BufSz   + 1  ! PtfmHeave
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRoll
      Re_BufSz   = Re_BufSz   + 1  ! PtfmPitch
      Re_BufSz   = Re_BufSz   + 1  ! PtfmYaw
      Int_BufSz  = Int_BufSz  + 1  ! NumBl
      Re_BufSz   = Re_BufSz   + 1  ! TipRad
      Re_BufSz   = Re_BufSz   + 1  ! HubRad
  Int_BufSz   = Int_BufSz   + 1     ! PreCone allocated yes/no
  IF ( ALLOCATED(InData%PreCone) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PreCone upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PreCone)  ! PreCone
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! HubCM
      Re_BufSz   = Re_BufSz   + 1  ! UndSling
      Re_BufSz   = Re_BufSz   + 1  ! Delta3
      Db_BufSz   = Db_BufSz   + 1  ! AzimB1Up
      Re_BufSz   = Re_BufSz   + 1  ! OverHang
      Re_BufSz   = Re_BufSz   + 1  ! ShftGagL
      Re_BufSz   = Re_BufSz   + 1  ! ShftTilt
      Re_BufSz   = Re_BufSz   + 1  ! NacCMxn
      Re_BufSz   = Re_BufSz   + 1  ! NacCMyn
      Re_BufSz   = Re_BufSz   + 1  ! NacCMzn
      Re_BufSz   = Re_BufSz   + 1  ! NcIMUxn
      Re_BufSz   = Re_BufSz   + 1  ! NcIMUyn
      Re_BufSz   = Re_BufSz   + 1  ! NcIMUzn
      Re_BufSz   = Re_BufSz   + 1  ! Twr2Shft
      Re_BufSz   = Re_BufSz   + 1  ! TowerHt
      Re_BufSz   = Re_BufSz   + 1  ! TowerBsHt
      Re_BufSz   = Re_BufSz   + 1  ! PtfmCMxt
      Re_BufSz   = Re_BufSz   + 1  ! PtfmCMyt
      Re_BufSz   = Re_BufSz   + 1  ! PtfmCMzt
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRefzt
  Int_BufSz   = Int_BufSz   + 1     ! TipMass allocated yes/no
  IF ( ALLOCATED(InData%TipMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TipMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TipMass)  ! TipMass
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! HubMass
      Re_BufSz   = Re_BufSz   + 1  ! HubIner
      Re_BufSz   = Re_BufSz   + 1  ! GenIner
      Re_BufSz   = Re_BufSz   + 1  ! NacMass
      Re_BufSz   = Re_BufSz   + 1  ! NacYIner
      Re_BufSz   = Re_BufSz   + 1  ! YawBrMass
      Re_BufSz   = Re_BufSz   + 1  ! PtfmMass
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRIner
      Re_BufSz   = Re_BufSz   + 1  ! PtfmPIner
      Re_BufSz   = Re_BufSz   + 1  ! PtfmYIner
      Re_BufSz   = Re_BufSz   + 1  ! BldNodes
  Int_BufSz   = Int_BufSz   + 1     ! InpBlMesh allocated yes/no
  IF ( ALLOCATED(InData%InpBlMesh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InpBlMesh upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%InpBlMesh,1), UBOUND(InData%InpBlMesh,1)
      Int_BufSz   = Int_BufSz + 3  ! InpBlMesh: size of buffers for each call to pack subtype
      CALL ED_Packblademeshinputdata( Re_Buf, Db_Buf, Int_Buf, InData%InpBlMesh(i1), ErrStat2, ErrMsg2, .TRUE. ) ! InpBlMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InpBlMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InpBlMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InpBlMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! InpBl allocated yes/no
  IF ( ALLOCATED(InData%InpBl) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InpBl upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%InpBl,1), UBOUND(InData%InpBl,1)
      Int_BufSz   = Int_BufSz + 3  ! InpBl: size of buffers for each call to pack subtype
      CALL ED_Packbladeinputdata( Re_Buf, Db_Buf, Int_Buf, InData%InpBl(i1), ErrStat2, ErrMsg2, .TRUE. ) ! InpBl 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InpBl
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InpBl
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InpBl
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! TeetMod
      Re_BufSz   = Re_BufSz   + 1  ! TeetDmpP
      Re_BufSz   = Re_BufSz   + 1  ! TeetDmp
      Re_BufSz   = Re_BufSz   + 1  ! TeetCDmp
      Re_BufSz   = Re_BufSz   + 1  ! TeetSStP
      Re_BufSz   = Re_BufSz   + 1  ! TeetHStP
      Re_BufSz   = Re_BufSz   + 1  ! TeetSSSp
      Re_BufSz   = Re_BufSz   + 1  ! TeetHSSp
      Re_BufSz   = Re_BufSz   + 1  ! GBoxEff
      Re_BufSz   = Re_BufSz   + 1  ! GBRatio
      Re_BufSz   = Re_BufSz   + 1  ! DTTorSpr
      Re_BufSz   = Re_BufSz   + 1  ! DTTorDmp
      Int_BufSz  = Int_BufSz  + 1  ! Furling
      Int_BufSz  = Int_BufSz  + 1  ! TwrNodes
      Int_BufSz  = Int_BufSz  + 1  ! SumPrint
      Int_BufSz  = Int_BufSz  + 1  ! OutFile
      Int_BufSz  = Int_BufSz  + 1  ! TabDelim
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFmt)  ! OutFmt
      Db_BufSz   = Db_BufSz   + 1  ! Tstart
      Int_BufSz  = Int_BufSz  + 1  ! DecFact
      Int_BufSz  = Int_BufSz  + 1  ! NTwGages
      Int_BufSz  = Int_BufSz  + SIZE(InData%TwrGagNd)  ! TwrGagNd
      Int_BufSz  = Int_BufSz  + 1  ! NBlGages
      Int_BufSz  = Int_BufSz  + SIZE(InData%BldGagNd)  ! BldGagNd
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
  Int_BufSz   = Int_BufSz   + 1     ! OutList allocated yes/no
  IF ( ALLOCATED(InData%OutList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%OutList)*LEN(InData%OutList)  ! OutList
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NTwInpSt
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrFADmp)  ! TwrFADmp
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrSSDmp)  ! TwrSSDmp
      Re_BufSz   = Re_BufSz   + SIZE(InData%FAStTunr)  ! FAStTunr
      Re_BufSz   = Re_BufSz   + SIZE(InData%SSStTunr)  ! SSStTunr
  Int_BufSz   = Int_BufSz   + 1     ! HtFract allocated yes/no
  IF ( ALLOCATED(InData%HtFract) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! HtFract upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%HtFract)  ! HtFract
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TMassDen allocated yes/no
  IF ( ALLOCATED(InData%TMassDen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TMassDen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TMassDen)  ! TMassDen
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwFAStif allocated yes/no
  IF ( ALLOCATED(InData%TwFAStif) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwFAStif upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwFAStif)  ! TwFAStif
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwSSStif allocated yes/no
  IF ( ALLOCATED(InData%TwSSStif) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwSSStif upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwSSStif)  ! TwSSStif
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwFAM1Sh allocated yes/no
  IF ( ALLOCATED(InData%TwFAM1Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwFAM1Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwFAM1Sh)  ! TwFAM1Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwFAM2Sh allocated yes/no
  IF ( ALLOCATED(InData%TwFAM2Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwFAM2Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwFAM2Sh)  ! TwFAM2Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwSSM1Sh allocated yes/no
  IF ( ALLOCATED(InData%TwSSM1Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwSSM1Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwSSM1Sh)  ! TwSSM1Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwSSM2Sh allocated yes/no
  IF ( ALLOCATED(InData%TwSSM2Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwSSM2Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwSSM2Sh)  ! TwSSM2Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwGJStif allocated yes/no
  IF ( ALLOCATED(InData%TwGJStif) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwGJStif upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwGJStif)  ! TwGJStif
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwEAStif allocated yes/no
  IF ( ALLOCATED(InData%TwEAStif) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwEAStif upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwEAStif)  ! TwEAStif
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwFAIner allocated yes/no
  IF ( ALLOCATED(InData%TwFAIner) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwFAIner upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwFAIner)  ! TwFAIner
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwSSIner allocated yes/no
  IF ( ALLOCATED(InData%TwSSIner) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwSSIner upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwSSIner)  ! TwSSIner
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwFAcgOf allocated yes/no
  IF ( ALLOCATED(InData%TwFAcgOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwFAcgOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwFAcgOf)  ! TwFAcgOf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwSScgOf allocated yes/no
  IF ( ALLOCATED(InData%TwSScgOf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TwSScgOf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwSScgOf)  ! TwSScgOf
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! RFrlDOF
      Int_BufSz  = Int_BufSz  + 1  ! TFrlDOF
      Re_BufSz   = Re_BufSz   + 1  ! RotFurl
      Re_BufSz   = Re_BufSz   + 1  ! TailFurl
      Re_BufSz   = Re_BufSz   + 1  ! Yaw2Shft
      Re_BufSz   = Re_BufSz   + 1  ! ShftSkew
      Re_BufSz   = Re_BufSz   + 1  ! RFrlCMxn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlCMyn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlCMzn
      Re_BufSz   = Re_BufSz   + 1  ! BoomCMxn
      Re_BufSz   = Re_BufSz   + 1  ! BoomCMyn
      Re_BufSz   = Re_BufSz   + 1  ! BoomCMzn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCMxn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCMyn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCMzn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCPxn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCPyn
      Re_BufSz   = Re_BufSz   + 1  ! TFinCPzn
      Re_BufSz   = Re_BufSz   + 1  ! TFinSkew
      Re_BufSz   = Re_BufSz   + 1  ! TFinTilt
      Re_BufSz   = Re_BufSz   + 1  ! TFinBank
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntxn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntyn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntzn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlSkew
      Re_BufSz   = Re_BufSz   + 1  ! RFrlTilt
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntxn
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntyn
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntzn
      Re_BufSz   = Re_BufSz   + 1  ! TFrlSkew
      Re_BufSz   = Re_BufSz   + 1  ! TFrlTilt
      Re_BufSz   = Re_BufSz   + 1  ! RFrlMass
      Re_BufSz   = Re_BufSz   + 1  ! BoomMass
      Re_BufSz   = Re_BufSz   + 1  ! TFinMass
      Re_BufSz   = Re_BufSz   + 1  ! RFrlIner
      Re_BufSz   = Re_BufSz   + 1  ! TFrlIner
      Int_BufSz  = Int_BufSz  + 1  ! RFrlMod
      Re_BufSz   = Re_BufSz   + 1  ! RFrlSpr
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlCDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSSP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSSP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSSpr
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSSpr
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSDP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSDP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSDmp
      Int_BufSz  = Int_BufSz  + 1  ! TFrlMod
      Re_BufSz   = Re_BufSz   + 1  ! TFrlSpr
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlCDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSSP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSSP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSSpr
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSSpr
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSDP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSDP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSDmp
      Int_BufSz  = Int_BufSz  + 1  ! method
      Int_BufSz  = Int_BufSz  + 1  ! BldNd_NumOuts
  Int_BufSz   = Int_BufSz   + 1     ! BldNd_OutList allocated yes/no
  IF ( ALLOCATED(InData%BldNd_OutList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldNd_OutList upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%BldNd_OutList)*LEN(InData%BldNd_OutList)  ! BldNd_OutList
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%BldNd_BlOutNd_Str)  ! BldNd_BlOutNd_Str
      Int_BufSz  = Int_BufSz  + 1  ! BldNd_BladesOut
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FlapDOF1, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FlapDOF2, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%EdgeDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TeetDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%DrTrDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%GenDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%YawDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwFADOF1, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwFADOF2, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwSSDOF1, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwSSDOF2, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmSgDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmSwDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmHvDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmRDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmPDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%PtfmYDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%OoPDefl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%IPDefl
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BlPitch) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlPitch,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlPitch,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BlPitch,1), UBOUND(InData%BlPitch,1)
        ReKiBuf(Re_Xferred) = InData%BlPitch(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%TeetDefl
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%Azimuth
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotSpeed
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacYaw
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TTDspFA
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TTDspSS
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmSurge
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmSway
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmHeave
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmRoll
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmPitch
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmYaw
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBl
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TipRad
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubRad
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PreCone) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PreCone,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PreCone,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PreCone,1), UBOUND(InData%PreCone,1)
        ReKiBuf(Re_Xferred) = InData%PreCone(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%HubCM
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%UndSling
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Delta3
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%AzimB1Up
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%OverHang
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ShftGagL
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ShftTilt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NcIMUxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NcIMUyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NcIMUzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Twr2Shft
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerBsHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmCMxt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmCMyt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmCMzt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmRefzt
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%TipMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TipMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TipMass,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TipMass,1), UBOUND(InData%TipMass,1)
        ReKiBuf(Re_Xferred) = InData%TipMass(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%HubMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GenIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacYIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%YawBrMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmRIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmPIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmYIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%BldNodes
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%InpBlMesh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InpBlMesh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InpBlMesh,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%InpBlMesh,1), UBOUND(InData%InpBlMesh,1)
      CALL ED_Packblademeshinputdata( Re_Buf, Db_Buf, Int_Buf, InData%InpBlMesh(i1), ErrStat2, ErrMsg2, OnlySize ) ! InpBlMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%InpBl) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InpBl,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InpBl,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%InpBl,1), UBOUND(InData%InpBl,1)
      CALL ED_Packbladeinputdata( Re_Buf, Db_Buf, Int_Buf, InData%InpBl(i1), ErrStat2, ErrMsg2, OnlySize ) ! InpBl 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%TeetMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetDmpP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetSStP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetHStP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetSSSp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetHSSp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GBoxEff
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GBRatio
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DTTorSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DTTorDmp
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Furling, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TwrNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%SumPrint, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%OutFile
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TabDelim, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DbKiBuf(Db_Xferred) = InData%Tstart
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%DecFact
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NTwGages
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%TwrGagNd,1), UBOUND(InData%TwrGagNd,1)
      IntKiBuf(Int_Xferred) = InData%TwrGagNd(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%NBlGages
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%BldGagNd,1), UBOUND(InData%BldGagNd,1)
      IntKiBuf(Int_Xferred) = InData%BldGagNd(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutList,1), UBOUND(InData%OutList,1)
        DO I = 1, LEN(InData%OutList)
          IntKiBuf(Int_Xferred) = ICHAR(InData%OutList(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NTwInpSt
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%TwrFADmp,1), UBOUND(InData%TwrFADmp,1)
      ReKiBuf(Re_Xferred) = InData%TwrFADmp(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%TwrSSDmp,1), UBOUND(InData%TwrSSDmp,1)
      ReKiBuf(Re_Xferred) = InData%TwrSSDmp(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FAStTunr,1), UBOUND(InData%FAStTunr,1)
      ReKiBuf(Re_Xferred) = InData%FAStTunr(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%SSStTunr,1), UBOUND(InData%SSStTunr,1)
      ReKiBuf(Re_Xferred) = InData%SSStTunr(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%HtFract) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%HtFract,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%HtFract,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%HtFract,1), UBOUND(InData%HtFract,1)
        ReKiBuf(Re_Xferred) = InData%HtFract(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TMassDen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TMassDen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TMassDen,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TMassDen,1), UBOUND(InData%TMassDen,1)
        ReKiBuf(Re_Xferred) = InData%TMassDen(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwFAStif) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwFAStif,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwFAStif,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwFAStif,1), UBOUND(InData%TwFAStif,1)
        ReKiBuf(Re_Xferred) = InData%TwFAStif(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwSSStif) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwSSStif,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwSSStif,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwSSStif,1), UBOUND(InData%TwSSStif,1)
        ReKiBuf(Re_Xferred) = InData%TwSSStif(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwFAM1Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwFAM1Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwFAM1Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwFAM1Sh,1), UBOUND(InData%TwFAM1Sh,1)
        ReKiBuf(Re_Xferred) = InData%TwFAM1Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwFAM2Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwFAM2Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwFAM2Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwFAM2Sh,1), UBOUND(InData%TwFAM2Sh,1)
        ReKiBuf(Re_Xferred) = InData%TwFAM2Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwSSM1Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwSSM1Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwSSM1Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwSSM1Sh,1), UBOUND(InData%TwSSM1Sh,1)
        ReKiBuf(Re_Xferred) = InData%TwSSM1Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwSSM2Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwSSM2Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwSSM2Sh,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwSSM2Sh,1), UBOUND(InData%TwSSM2Sh,1)
        ReKiBuf(Re_Xferred) = InData%TwSSM2Sh(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwGJStif) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwGJStif,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwGJStif,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwGJStif,1), UBOUND(InData%TwGJStif,1)
        ReKiBuf(Re_Xferred) = InData%TwGJStif(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwEAStif) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwEAStif,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwEAStif,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwEAStif,1), UBOUND(InData%TwEAStif,1)
        ReKiBuf(Re_Xferred) = InData%TwEAStif(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwFAIner) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwFAIner,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwFAIner,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwFAIner,1), UBOUND(InData%TwFAIner,1)
        ReKiBuf(Re_Xferred) = InData%TwFAIner(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwSSIner) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwSSIner,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwSSIner,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwSSIner,1), UBOUND(InData%TwSSIner,1)
        ReKiBuf(Re_Xferred) = InData%TwSSIner(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwFAcgOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwFAcgOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwFAcgOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwFAcgOf,1), UBOUND(InData%TwFAcgOf,1)
        ReKiBuf(Re_Xferred) = InData%TwFAcgOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwSScgOf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwSScgOf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwSScgOf,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TwSScgOf,1), UBOUND(InData%TwSScgOf,1)
        ReKiBuf(Re_Xferred) = InData%TwSScgOf(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%RFrlDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TFrlDOF, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotFurl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TailFurl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Yaw2Shft
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ShftSkew
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlCMxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlCMyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlCMzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%BoomCMxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%BoomCMyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%BoomCMzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCMxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCMyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCMzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCPxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCPyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinCPzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinSkew
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinTilt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinBank
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlSkew
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlTilt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlSkew
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlTilt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%BoomMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFinMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlIner
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RFrlMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSDmp
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TFrlMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSDmp
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%method
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%BldNd_NumOuts
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BldNd_OutList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldNd_OutList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldNd_OutList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldNd_OutList,1), UBOUND(InData%BldNd_OutList,1)
        DO I = 1, LEN(InData%BldNd_OutList)
          IntKiBuf(Int_Xferred) = ICHAR(InData%BldNd_OutList(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(InData%BldNd_BlOutNd_Str)
      IntKiBuf(Int_Xferred) = ICHAR(InData%BldNd_BlOutNd_Str(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%BldNd_BladesOut
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_PackInputFile

 SUBROUTINE ED_UnPackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_InputFile), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackInputFile'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%FlapDOF1 = TRANSFER(IntKiBuf(Int_Xferred), OutData%FlapDOF1)
    Int_Xferred = Int_Xferred + 1
    OutData%FlapDOF2 = TRANSFER(IntKiBuf(Int_Xferred), OutData%FlapDOF2)
    Int_Xferred = Int_Xferred + 1
    OutData%EdgeDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%EdgeDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%TeetDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%TeetDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%DrTrDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%DrTrDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%GenDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%GenDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%YawDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%YawDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%TwFADOF1 = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwFADOF1)
    Int_Xferred = Int_Xferred + 1
    OutData%TwFADOF2 = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwFADOF2)
    Int_Xferred = Int_Xferred + 1
    OutData%TwSSDOF1 = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwSSDOF1)
    Int_Xferred = Int_Xferred + 1
    OutData%TwSSDOF2 = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwSSDOF2)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmSgDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmSgDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmSwDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmSwDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmHvDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmHvDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmRDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmRDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmPDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmPDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmYDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%PtfmYDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%OoPDefl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%IPDefl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlPitch not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlPitch)) DEALLOCATE(OutData%BlPitch)
    ALLOCATE(OutData%BlPitch(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlPitch.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BlPitch,1), UBOUND(OutData%BlPitch,1)
        OutData%BlPitch(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%TeetDefl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Azimuth = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%RotSpeed = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacYaw = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TTDspFA = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TTDspSS = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmSurge = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmSway = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmHeave = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmRoll = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmPitch = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmYaw = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumBl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TipRad = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubRad = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PreCone not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PreCone)) DEALLOCATE(OutData%PreCone)
    ALLOCATE(OutData%PreCone(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PreCone.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PreCone,1), UBOUND(OutData%PreCone,1)
        OutData%PreCone(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%HubCM = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%UndSling = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Delta3 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AzimB1Up = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%OverHang = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ShftGagL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ShftTilt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NcIMUxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NcIMUyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NcIMUzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Twr2Shft = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerBsHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmCMxt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmCMyt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmCMzt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmRefzt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TipMass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TipMass)) DEALLOCATE(OutData%TipMass)
    ALLOCATE(OutData%TipMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TipMass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TipMass,1), UBOUND(OutData%TipMass,1)
        OutData%TipMass(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%HubMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GenIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacYIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%YawBrMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmRIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmPIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmYIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BldNodes = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InpBlMesh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InpBlMesh)) DEALLOCATE(OutData%InpBlMesh)
    ALLOCATE(OutData%InpBlMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpBlMesh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%InpBlMesh,1), UBOUND(OutData%InpBlMesh,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_Unpackblademeshinputdata( Re_Buf, Db_Buf, Int_Buf, OutData%InpBlMesh(i1), ErrStat2, ErrMsg2 ) ! InpBlMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InpBl not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InpBl)) DEALLOCATE(OutData%InpBl)
    ALLOCATE(OutData%InpBl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InpBl.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%InpBl,1), UBOUND(OutData%InpBl,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_Unpackbladeinputdata( Re_Buf, Db_Buf, Int_Buf, OutData%InpBl(i1), ErrStat2, ErrMsg2 ) ! InpBl 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%TeetMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TeetDmpP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetSStP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetHStP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetSSSp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetHSSp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GBoxEff = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GBRatio = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DTTorSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DTTorDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Furling = TRANSFER(IntKiBuf(Int_Xferred), OutData%Furling)
    Int_Xferred = Int_Xferred + 1
    OutData%TwrNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%SumPrint = TRANSFER(IntKiBuf(Int_Xferred), OutData%SumPrint)
    Int_Xferred = Int_Xferred + 1
    OutData%OutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TabDelim = TRANSFER(IntKiBuf(Int_Xferred), OutData%TabDelim)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFmt)
      OutData%OutFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%Tstart = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%DecFact = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NTwGages = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%TwrGagNd,1)
    i1_u = UBOUND(OutData%TwrGagNd,1)
    DO i1 = LBOUND(OutData%TwrGagNd,1), UBOUND(OutData%TwrGagNd,1)
      OutData%TwrGagNd(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    OutData%NBlGages = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%BldGagNd,1)
    i1_u = UBOUND(OutData%BldGagNd,1)
    DO i1 = LBOUND(OutData%BldGagNd,1), UBOUND(OutData%BldGagNd,1)
      OutData%BldGagNd(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutList)) DEALLOCATE(OutData%OutList)
    ALLOCATE(OutData%OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutList,1), UBOUND(OutData%OutList,1)
        DO I = 1, LEN(OutData%OutList)
          OutData%OutList(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    OutData%NTwInpSt = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%TwrFADmp,1)
    i1_u = UBOUND(OutData%TwrFADmp,1)
    DO i1 = LBOUND(OutData%TwrFADmp,1), UBOUND(OutData%TwrFADmp,1)
      OutData%TwrFADmp(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TwrSSDmp,1)
    i1_u = UBOUND(OutData%TwrSSDmp,1)
    DO i1 = LBOUND(OutData%TwrSSDmp,1), UBOUND(OutData%TwrSSDmp,1)
      OutData%TwrSSDmp(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FAStTunr,1)
    i1_u = UBOUND(OutData%FAStTunr,1)
    DO i1 = LBOUND(OutData%FAStTunr,1), UBOUND(OutData%FAStTunr,1)
      OutData%FAStTunr(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%SSStTunr,1)
    i1_u = UBOUND(OutData%SSStTunr,1)
    DO i1 = LBOUND(OutData%SSStTunr,1), UBOUND(OutData%SSStTunr,1)
      OutData%SSStTunr(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! HtFract not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%HtFract)) DEALLOCATE(OutData%HtFract)
    ALLOCATE(OutData%HtFract(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%HtFract.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%HtFract,1), UBOUND(OutData%HtFract,1)
        OutData%HtFract(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TMassDen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TMassDen)) DEALLOCATE(OutData%TMassDen)
    ALLOCATE(OutData%TMassDen(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TMassDen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TMassDen,1), UBOUND(OutData%TMassDen,1)
        OutData%TMassDen(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwFAStif not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwFAStif)) DEALLOCATE(OutData%TwFAStif)
    ALLOCATE(OutData%TwFAStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwFAStif.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwFAStif,1), UBOUND(OutData%TwFAStif,1)
        OutData%TwFAStif(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwSSStif not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwSSStif)) DEALLOCATE(OutData%TwSSStif)
    ALLOCATE(OutData%TwSSStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwSSStif.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwSSStif,1), UBOUND(OutData%TwSSStif,1)
        OutData%TwSSStif(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwFAM1Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwFAM1Sh)) DEALLOCATE(OutData%TwFAM1Sh)
    ALLOCATE(OutData%TwFAM1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwFAM1Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwFAM1Sh,1), UBOUND(OutData%TwFAM1Sh,1)
        OutData%TwFAM1Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwFAM2Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwFAM2Sh)) DEALLOCATE(OutData%TwFAM2Sh)
    ALLOCATE(OutData%TwFAM2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwFAM2Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwFAM2Sh,1), UBOUND(OutData%TwFAM2Sh,1)
        OutData%TwFAM2Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwSSM1Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwSSM1Sh)) DEALLOCATE(OutData%TwSSM1Sh)
    ALLOCATE(OutData%TwSSM1Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwSSM1Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwSSM1Sh,1), UBOUND(OutData%TwSSM1Sh,1)
        OutData%TwSSM1Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwSSM2Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwSSM2Sh)) DEALLOCATE(OutData%TwSSM2Sh)
    ALLOCATE(OutData%TwSSM2Sh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwSSM2Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwSSM2Sh,1), UBOUND(OutData%TwSSM2Sh,1)
        OutData%TwSSM2Sh(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwGJStif not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwGJStif)) DEALLOCATE(OutData%TwGJStif)
    ALLOCATE(OutData%TwGJStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwGJStif.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwGJStif,1), UBOUND(OutData%TwGJStif,1)
        OutData%TwGJStif(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwEAStif not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwEAStif)) DEALLOCATE(OutData%TwEAStif)
    ALLOCATE(OutData%TwEAStif(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwEAStif.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwEAStif,1), UBOUND(OutData%TwEAStif,1)
        OutData%TwEAStif(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwFAIner not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwFAIner)) DEALLOCATE(OutData%TwFAIner)
    ALLOCATE(OutData%TwFAIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwFAIner.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwFAIner,1), UBOUND(OutData%TwFAIner,1)
        OutData%TwFAIner(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwSSIner not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwSSIner)) DEALLOCATE(OutData%TwSSIner)
    ALLOCATE(OutData%TwSSIner(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwSSIner.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwSSIner,1), UBOUND(OutData%TwSSIner,1)
        OutData%TwSSIner(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwFAcgOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwFAcgOf)) DEALLOCATE(OutData%TwFAcgOf)
    ALLOCATE(OutData%TwFAcgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwFAcgOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwFAcgOf,1), UBOUND(OutData%TwFAcgOf,1)
        OutData%TwFAcgOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwSScgOf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwSScgOf)) DEALLOCATE(OutData%TwSScgOf)
    ALLOCATE(OutData%TwSScgOf(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwSScgOf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TwSScgOf,1), UBOUND(OutData%TwSScgOf,1)
        OutData%TwSScgOf(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%RFrlDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%RFrlDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%TFrlDOF = TRANSFER(IntKiBuf(Int_Xferred), OutData%TFrlDOF)
    Int_Xferred = Int_Xferred + 1
    OutData%RotFurl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TailFurl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Yaw2Shft = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ShftSkew = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlCMxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlCMyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlCMzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BoomCMxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BoomCMyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BoomCMzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCMxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCMyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCMzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCPxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCPyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinCPzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinSkew = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinTilt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinBank = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlSkew = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlTilt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlPntxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlPntyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlPntzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlSkew = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlTilt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BoomMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFinMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RFrlSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TFrlSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%method = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%BldNd_NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldNd_OutList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldNd_OutList)) DEALLOCATE(OutData%BldNd_OutList)
    ALLOCATE(OutData%BldNd_OutList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldNd_OutList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldNd_OutList,1), UBOUND(OutData%BldNd_OutList,1)
        DO I = 1, LEN(OutData%BldNd_OutList)
          OutData%BldNd_OutList(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(OutData%BldNd_BlOutNd_Str)
      OutData%BldNd_BlOutNd_Str(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%BldNd_BladesOut = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_UnPackInputFile

 SUBROUTINE ED_CopyCoordSys( SrcCoordSysData, DstCoordSysData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_CoordSys), INTENT(IN) :: SrcCoordSysData
   TYPE(ED_CoordSys), INTENT(INOUT) :: DstCoordSysData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyCoordSys'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstCoordSysData%a1 = SrcCoordSysData%a1
    DstCoordSysData%a2 = SrcCoordSysData%a2
    DstCoordSysData%a3 = SrcCoordSysData%a3
    DstCoordSysData%b1 = SrcCoordSysData%b1
    DstCoordSysData%b2 = SrcCoordSysData%b2
    DstCoordSysData%b3 = SrcCoordSysData%b3
    DstCoordSysData%c1 = SrcCoordSysData%c1
    DstCoordSysData%c2 = SrcCoordSysData%c2
    DstCoordSysData%c3 = SrcCoordSysData%c3
    DstCoordSysData%d1 = SrcCoordSysData%d1
    DstCoordSysData%d2 = SrcCoordSysData%d2
    DstCoordSysData%d3 = SrcCoordSysData%d3
    DstCoordSysData%e1 = SrcCoordSysData%e1
    DstCoordSysData%e2 = SrcCoordSysData%e2
    DstCoordSysData%e3 = SrcCoordSysData%e3
    DstCoordSysData%f1 = SrcCoordSysData%f1
    DstCoordSysData%f2 = SrcCoordSysData%f2
    DstCoordSysData%f3 = SrcCoordSysData%f3
    DstCoordSysData%g1 = SrcCoordSysData%g1
    DstCoordSysData%g2 = SrcCoordSysData%g2
    DstCoordSysData%g3 = SrcCoordSysData%g3
IF (ALLOCATED(SrcCoordSysData%i1)) THEN
  i1_l = LBOUND(SrcCoordSysData%i1,1)
  i1_u = UBOUND(SrcCoordSysData%i1,1)
  i2_l = LBOUND(SrcCoordSysData%i1,2)
  i2_u = UBOUND(SrcCoordSysData%i1,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%i1)) THEN 
    ALLOCATE(DstCoordSysData%i1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%i1 = SrcCoordSysData%i1
ENDIF
IF (ALLOCATED(SrcCoordSysData%i2)) THEN
  i1_l = LBOUND(SrcCoordSysData%i2,1)
  i1_u = UBOUND(SrcCoordSysData%i2,1)
  i2_l = LBOUND(SrcCoordSysData%i2,2)
  i2_u = UBOUND(SrcCoordSysData%i2,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%i2)) THEN 
    ALLOCATE(DstCoordSysData%i2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%i2 = SrcCoordSysData%i2
ENDIF
IF (ALLOCATED(SrcCoordSysData%i3)) THEN
  i1_l = LBOUND(SrcCoordSysData%i3,1)
  i1_u = UBOUND(SrcCoordSysData%i3,1)
  i2_l = LBOUND(SrcCoordSysData%i3,2)
  i2_u = UBOUND(SrcCoordSysData%i3,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%i3)) THEN 
    ALLOCATE(DstCoordSysData%i3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%i3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%i3 = SrcCoordSysData%i3
ENDIF
IF (ALLOCATED(SrcCoordSysData%j1)) THEN
  i1_l = LBOUND(SrcCoordSysData%j1,1)
  i1_u = UBOUND(SrcCoordSysData%j1,1)
  i2_l = LBOUND(SrcCoordSysData%j1,2)
  i2_u = UBOUND(SrcCoordSysData%j1,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%j1)) THEN 
    ALLOCATE(DstCoordSysData%j1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%j1 = SrcCoordSysData%j1
ENDIF
IF (ALLOCATED(SrcCoordSysData%j2)) THEN
  i1_l = LBOUND(SrcCoordSysData%j2,1)
  i1_u = UBOUND(SrcCoordSysData%j2,1)
  i2_l = LBOUND(SrcCoordSysData%j2,2)
  i2_u = UBOUND(SrcCoordSysData%j2,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%j2)) THEN 
    ALLOCATE(DstCoordSysData%j2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%j2 = SrcCoordSysData%j2
ENDIF
IF (ALLOCATED(SrcCoordSysData%j3)) THEN
  i1_l = LBOUND(SrcCoordSysData%j3,1)
  i1_u = UBOUND(SrcCoordSysData%j3,1)
  i2_l = LBOUND(SrcCoordSysData%j3,2)
  i2_u = UBOUND(SrcCoordSysData%j3,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%j3)) THEN 
    ALLOCATE(DstCoordSysData%j3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%j3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%j3 = SrcCoordSysData%j3
ENDIF
IF (ALLOCATED(SrcCoordSysData%m1)) THEN
  i1_l = LBOUND(SrcCoordSysData%m1,1)
  i1_u = UBOUND(SrcCoordSysData%m1,1)
  i2_l = LBOUND(SrcCoordSysData%m1,2)
  i2_u = UBOUND(SrcCoordSysData%m1,2)
  i3_l = LBOUND(SrcCoordSysData%m1,3)
  i3_u = UBOUND(SrcCoordSysData%m1,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%m1)) THEN 
    ALLOCATE(DstCoordSysData%m1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%m1 = SrcCoordSysData%m1
ENDIF
IF (ALLOCATED(SrcCoordSysData%m2)) THEN
  i1_l = LBOUND(SrcCoordSysData%m2,1)
  i1_u = UBOUND(SrcCoordSysData%m2,1)
  i2_l = LBOUND(SrcCoordSysData%m2,2)
  i2_u = UBOUND(SrcCoordSysData%m2,2)
  i3_l = LBOUND(SrcCoordSysData%m2,3)
  i3_u = UBOUND(SrcCoordSysData%m2,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%m2)) THEN 
    ALLOCATE(DstCoordSysData%m2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%m2 = SrcCoordSysData%m2
ENDIF
IF (ALLOCATED(SrcCoordSysData%m3)) THEN
  i1_l = LBOUND(SrcCoordSysData%m3,1)
  i1_u = UBOUND(SrcCoordSysData%m3,1)
  i2_l = LBOUND(SrcCoordSysData%m3,2)
  i2_u = UBOUND(SrcCoordSysData%m3,2)
  i3_l = LBOUND(SrcCoordSysData%m3,3)
  i3_u = UBOUND(SrcCoordSysData%m3,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%m3)) THEN 
    ALLOCATE(DstCoordSysData%m3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%m3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%m3 = SrcCoordSysData%m3
ENDIF
IF (ALLOCATED(SrcCoordSysData%n1)) THEN
  i1_l = LBOUND(SrcCoordSysData%n1,1)
  i1_u = UBOUND(SrcCoordSysData%n1,1)
  i2_l = LBOUND(SrcCoordSysData%n1,2)
  i2_u = UBOUND(SrcCoordSysData%n1,2)
  i3_l = LBOUND(SrcCoordSysData%n1,3)
  i3_u = UBOUND(SrcCoordSysData%n1,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%n1)) THEN 
    ALLOCATE(DstCoordSysData%n1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%n1 = SrcCoordSysData%n1
ENDIF
IF (ALLOCATED(SrcCoordSysData%n2)) THEN
  i1_l = LBOUND(SrcCoordSysData%n2,1)
  i1_u = UBOUND(SrcCoordSysData%n2,1)
  i2_l = LBOUND(SrcCoordSysData%n2,2)
  i2_u = UBOUND(SrcCoordSysData%n2,2)
  i3_l = LBOUND(SrcCoordSysData%n2,3)
  i3_u = UBOUND(SrcCoordSysData%n2,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%n2)) THEN 
    ALLOCATE(DstCoordSysData%n2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%n2 = SrcCoordSysData%n2
ENDIF
IF (ALLOCATED(SrcCoordSysData%n3)) THEN
  i1_l = LBOUND(SrcCoordSysData%n3,1)
  i1_u = UBOUND(SrcCoordSysData%n3,1)
  i2_l = LBOUND(SrcCoordSysData%n3,2)
  i2_u = UBOUND(SrcCoordSysData%n3,2)
  i3_l = LBOUND(SrcCoordSysData%n3,3)
  i3_u = UBOUND(SrcCoordSysData%n3,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%n3)) THEN 
    ALLOCATE(DstCoordSysData%n3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%n3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%n3 = SrcCoordSysData%n3
ENDIF
    DstCoordSysData%p1 = SrcCoordSysData%p1
    DstCoordSysData%p2 = SrcCoordSysData%p2
    DstCoordSysData%p3 = SrcCoordSysData%p3
    DstCoordSysData%rf1 = SrcCoordSysData%rf1
    DstCoordSysData%rf2 = SrcCoordSysData%rf2
    DstCoordSysData%rf3 = SrcCoordSysData%rf3
    DstCoordSysData%rfa = SrcCoordSysData%rfa
IF (ALLOCATED(SrcCoordSysData%t1)) THEN
  i1_l = LBOUND(SrcCoordSysData%t1,1)
  i1_u = UBOUND(SrcCoordSysData%t1,1)
  i2_l = LBOUND(SrcCoordSysData%t1,2)
  i2_u = UBOUND(SrcCoordSysData%t1,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%t1)) THEN 
    ALLOCATE(DstCoordSysData%t1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%t1 = SrcCoordSysData%t1
ENDIF
IF (ALLOCATED(SrcCoordSysData%t2)) THEN
  i1_l = LBOUND(SrcCoordSysData%t2,1)
  i1_u = UBOUND(SrcCoordSysData%t2,1)
  i2_l = LBOUND(SrcCoordSysData%t2,2)
  i2_u = UBOUND(SrcCoordSysData%t2,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%t2)) THEN 
    ALLOCATE(DstCoordSysData%t2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%t2 = SrcCoordSysData%t2
ENDIF
IF (ALLOCATED(SrcCoordSysData%t3)) THEN
  i1_l = LBOUND(SrcCoordSysData%t3,1)
  i1_u = UBOUND(SrcCoordSysData%t3,1)
  i2_l = LBOUND(SrcCoordSysData%t3,2)
  i2_u = UBOUND(SrcCoordSysData%t3,2)
  IF (.NOT. ALLOCATED(DstCoordSysData%t3)) THEN 
    ALLOCATE(DstCoordSysData%t3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%t3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%t3 = SrcCoordSysData%t3
ENDIF
IF (ALLOCATED(SrcCoordSysData%te1)) THEN
  i1_l = LBOUND(SrcCoordSysData%te1,1)
  i1_u = UBOUND(SrcCoordSysData%te1,1)
  i2_l = LBOUND(SrcCoordSysData%te1,2)
  i2_u = UBOUND(SrcCoordSysData%te1,2)
  i3_l = LBOUND(SrcCoordSysData%te1,3)
  i3_u = UBOUND(SrcCoordSysData%te1,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%te1)) THEN 
    ALLOCATE(DstCoordSysData%te1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%te1 = SrcCoordSysData%te1
ENDIF
IF (ALLOCATED(SrcCoordSysData%te2)) THEN
  i1_l = LBOUND(SrcCoordSysData%te2,1)
  i1_u = UBOUND(SrcCoordSysData%te2,1)
  i2_l = LBOUND(SrcCoordSysData%te2,2)
  i2_u = UBOUND(SrcCoordSysData%te2,2)
  i3_l = LBOUND(SrcCoordSysData%te2,3)
  i3_u = UBOUND(SrcCoordSysData%te2,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%te2)) THEN 
    ALLOCATE(DstCoordSysData%te2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%te2 = SrcCoordSysData%te2
ENDIF
IF (ALLOCATED(SrcCoordSysData%te3)) THEN
  i1_l = LBOUND(SrcCoordSysData%te3,1)
  i1_u = UBOUND(SrcCoordSysData%te3,1)
  i2_l = LBOUND(SrcCoordSysData%te3,2)
  i2_u = UBOUND(SrcCoordSysData%te3,2)
  i3_l = LBOUND(SrcCoordSysData%te3,3)
  i3_u = UBOUND(SrcCoordSysData%te3,3)
  IF (.NOT. ALLOCATED(DstCoordSysData%te3)) THEN 
    ALLOCATE(DstCoordSysData%te3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstCoordSysData%te3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstCoordSysData%te3 = SrcCoordSysData%te3
ENDIF
    DstCoordSysData%tf1 = SrcCoordSysData%tf1
    DstCoordSysData%tf2 = SrcCoordSysData%tf2
    DstCoordSysData%tf3 = SrcCoordSysData%tf3
    DstCoordSysData%tfa = SrcCoordSysData%tfa
    DstCoordSysData%z1 = SrcCoordSysData%z1
    DstCoordSysData%z2 = SrcCoordSysData%z2
    DstCoordSysData%z3 = SrcCoordSysData%z3
 END SUBROUTINE ED_CopyCoordSys

 SUBROUTINE ED_DestroyCoordSys( CoordSysData, ErrStat, ErrMsg )
  TYPE(ED_CoordSys), INTENT(INOUT) :: CoordSysData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyCoordSys'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(CoordSysData%i1)) THEN
  DEALLOCATE(CoordSysData%i1)
ENDIF
IF (ALLOCATED(CoordSysData%i2)) THEN
  DEALLOCATE(CoordSysData%i2)
ENDIF
IF (ALLOCATED(CoordSysData%i3)) THEN
  DEALLOCATE(CoordSysData%i3)
ENDIF
IF (ALLOCATED(CoordSysData%j1)) THEN
  DEALLOCATE(CoordSysData%j1)
ENDIF
IF (ALLOCATED(CoordSysData%j2)) THEN
  DEALLOCATE(CoordSysData%j2)
ENDIF
IF (ALLOCATED(CoordSysData%j3)) THEN
  DEALLOCATE(CoordSysData%j3)
ENDIF
IF (ALLOCATED(CoordSysData%m1)) THEN
  DEALLOCATE(CoordSysData%m1)
ENDIF
IF (ALLOCATED(CoordSysData%m2)) THEN
  DEALLOCATE(CoordSysData%m2)
ENDIF
IF (ALLOCATED(CoordSysData%m3)) THEN
  DEALLOCATE(CoordSysData%m3)
ENDIF
IF (ALLOCATED(CoordSysData%n1)) THEN
  DEALLOCATE(CoordSysData%n1)
ENDIF
IF (ALLOCATED(CoordSysData%n2)) THEN
  DEALLOCATE(CoordSysData%n2)
ENDIF
IF (ALLOCATED(CoordSysData%n3)) THEN
  DEALLOCATE(CoordSysData%n3)
ENDIF
IF (ALLOCATED(CoordSysData%t1)) THEN
  DEALLOCATE(CoordSysData%t1)
ENDIF
IF (ALLOCATED(CoordSysData%t2)) THEN
  DEALLOCATE(CoordSysData%t2)
ENDIF
IF (ALLOCATED(CoordSysData%t3)) THEN
  DEALLOCATE(CoordSysData%t3)
ENDIF
IF (ALLOCATED(CoordSysData%te1)) THEN
  DEALLOCATE(CoordSysData%te1)
ENDIF
IF (ALLOCATED(CoordSysData%te2)) THEN
  DEALLOCATE(CoordSysData%te2)
ENDIF
IF (ALLOCATED(CoordSysData%te3)) THEN
  DEALLOCATE(CoordSysData%te3)
ENDIF
 END SUBROUTINE ED_DestroyCoordSys

 SUBROUTINE ED_PackCoordSys( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_CoordSys),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackCoordSys'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + SIZE(InData%a1)  ! a1
      Db_BufSz   = Db_BufSz   + SIZE(InData%a2)  ! a2
      Db_BufSz   = Db_BufSz   + SIZE(InData%a3)  ! a3
      Db_BufSz   = Db_BufSz   + SIZE(InData%b1)  ! b1
      Db_BufSz   = Db_BufSz   + SIZE(InData%b2)  ! b2
      Db_BufSz   = Db_BufSz   + SIZE(InData%b3)  ! b3
      Db_BufSz   = Db_BufSz   + SIZE(InData%c1)  ! c1
      Db_BufSz   = Db_BufSz   + SIZE(InData%c2)  ! c2
      Db_BufSz   = Db_BufSz   + SIZE(InData%c3)  ! c3
      Db_BufSz   = Db_BufSz   + SIZE(InData%d1)  ! d1
      Db_BufSz   = Db_BufSz   + SIZE(InData%d2)  ! d2
      Db_BufSz   = Db_BufSz   + SIZE(InData%d3)  ! d3
      Db_BufSz   = Db_BufSz   + SIZE(InData%e1)  ! e1
      Db_BufSz   = Db_BufSz   + SIZE(InData%e2)  ! e2
      Db_BufSz   = Db_BufSz   + SIZE(InData%e3)  ! e3
      Db_BufSz   = Db_BufSz   + SIZE(InData%f1)  ! f1
      Db_BufSz   = Db_BufSz   + SIZE(InData%f2)  ! f2
      Db_BufSz   = Db_BufSz   + SIZE(InData%f3)  ! f3
      Db_BufSz   = Db_BufSz   + SIZE(InData%g1)  ! g1
      Db_BufSz   = Db_BufSz   + SIZE(InData%g2)  ! g2
      Db_BufSz   = Db_BufSz   + SIZE(InData%g3)  ! g3
  Int_BufSz   = Int_BufSz   + 1     ! i1 allocated yes/no
  IF ( ALLOCATED(InData%i1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! i1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%i1)  ! i1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! i2 allocated yes/no
  IF ( ALLOCATED(InData%i2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! i2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%i2)  ! i2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! i3 allocated yes/no
  IF ( ALLOCATED(InData%i3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! i3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%i3)  ! i3
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! j1 allocated yes/no
  IF ( ALLOCATED(InData%j1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! j1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%j1)  ! j1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! j2 allocated yes/no
  IF ( ALLOCATED(InData%j2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! j2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%j2)  ! j2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! j3 allocated yes/no
  IF ( ALLOCATED(InData%j3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! j3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%j3)  ! j3
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m1 allocated yes/no
  IF ( ALLOCATED(InData%m1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! m1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%m1)  ! m1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m2 allocated yes/no
  IF ( ALLOCATED(InData%m2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! m2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%m2)  ! m2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! m3 allocated yes/no
  IF ( ALLOCATED(InData%m3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! m3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%m3)  ! m3
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! n1 allocated yes/no
  IF ( ALLOCATED(InData%n1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! n1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%n1)  ! n1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! n2 allocated yes/no
  IF ( ALLOCATED(InData%n2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! n2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%n2)  ! n2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! n3 allocated yes/no
  IF ( ALLOCATED(InData%n3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! n3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%n3)  ! n3
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%p1)  ! p1
      Db_BufSz   = Db_BufSz   + SIZE(InData%p2)  ! p2
      Db_BufSz   = Db_BufSz   + SIZE(InData%p3)  ! p3
      Db_BufSz   = Db_BufSz   + SIZE(InData%rf1)  ! rf1
      Db_BufSz   = Db_BufSz   + SIZE(InData%rf2)  ! rf2
      Db_BufSz   = Db_BufSz   + SIZE(InData%rf3)  ! rf3
      Db_BufSz   = Db_BufSz   + SIZE(InData%rfa)  ! rfa
  Int_BufSz   = Int_BufSz   + 1     ! t1 allocated yes/no
  IF ( ALLOCATED(InData%t1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! t1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%t1)  ! t1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! t2 allocated yes/no
  IF ( ALLOCATED(InData%t2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! t2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%t2)  ! t2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! t3 allocated yes/no
  IF ( ALLOCATED(InData%t3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! t3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%t3)  ! t3
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! te1 allocated yes/no
  IF ( ALLOCATED(InData%te1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! te1 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%te1)  ! te1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! te2 allocated yes/no
  IF ( ALLOCATED(InData%te2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! te2 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%te2)  ! te2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! te3 allocated yes/no
  IF ( ALLOCATED(InData%te3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! te3 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%te3)  ! te3
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%tf1)  ! tf1
      Db_BufSz   = Db_BufSz   + SIZE(InData%tf2)  ! tf2
      Db_BufSz   = Db_BufSz   + SIZE(InData%tf3)  ! tf3
      Db_BufSz   = Db_BufSz   + SIZE(InData%tfa)  ! tfa
      Db_BufSz   = Db_BufSz   + SIZE(InData%z1)  ! z1
      Db_BufSz   = Db_BufSz   + SIZE(InData%z2)  ! z2
      Db_BufSz   = Db_BufSz   + SIZE(InData%z3)  ! z3
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i1 = LBOUND(InData%a1,1), UBOUND(InData%a1,1)
      DbKiBuf(Db_Xferred) = InData%a1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%a2,1), UBOUND(InData%a2,1)
      DbKiBuf(Db_Xferred) = InData%a2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%a3,1), UBOUND(InData%a3,1)
      DbKiBuf(Db_Xferred) = InData%a3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%b1,1), UBOUND(InData%b1,1)
      DbKiBuf(Db_Xferred) = InData%b1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%b2,1), UBOUND(InData%b2,1)
      DbKiBuf(Db_Xferred) = InData%b2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%b3,1), UBOUND(InData%b3,1)
      DbKiBuf(Db_Xferred) = InData%b3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%c1,1), UBOUND(InData%c1,1)
      DbKiBuf(Db_Xferred) = InData%c1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%c2,1), UBOUND(InData%c2,1)
      DbKiBuf(Db_Xferred) = InData%c2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%c3,1), UBOUND(InData%c3,1)
      DbKiBuf(Db_Xferred) = InData%c3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%d1,1), UBOUND(InData%d1,1)
      DbKiBuf(Db_Xferred) = InData%d1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%d2,1), UBOUND(InData%d2,1)
      DbKiBuf(Db_Xferred) = InData%d2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%d3,1), UBOUND(InData%d3,1)
      DbKiBuf(Db_Xferred) = InData%d3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%e1,1), UBOUND(InData%e1,1)
      DbKiBuf(Db_Xferred) = InData%e1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%e2,1), UBOUND(InData%e2,1)
      DbKiBuf(Db_Xferred) = InData%e2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%e3,1), UBOUND(InData%e3,1)
      DbKiBuf(Db_Xferred) = InData%e3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%f1,1), UBOUND(InData%f1,1)
      DbKiBuf(Db_Xferred) = InData%f1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%f2,1), UBOUND(InData%f2,1)
      DbKiBuf(Db_Xferred) = InData%f2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%f3,1), UBOUND(InData%f3,1)
      DbKiBuf(Db_Xferred) = InData%f3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%g1,1), UBOUND(InData%g1,1)
      DbKiBuf(Db_Xferred) = InData%g1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%g2,1), UBOUND(InData%g2,1)
      DbKiBuf(Db_Xferred) = InData%g2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%g3,1), UBOUND(InData%g3,1)
      DbKiBuf(Db_Xferred) = InData%g3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%i1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%i1,2), UBOUND(InData%i1,2)
        DO i1 = LBOUND(InData%i1,1), UBOUND(InData%i1,1)
          DbKiBuf(Db_Xferred) = InData%i1(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%i2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i2,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%i2,2), UBOUND(InData%i2,2)
        DO i1 = LBOUND(InData%i2,1), UBOUND(InData%i2,1)
          DbKiBuf(Db_Xferred) = InData%i2(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%i3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%i3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%i3,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%i3,2), UBOUND(InData%i3,2)
        DO i1 = LBOUND(InData%i3,1), UBOUND(InData%i3,1)
          DbKiBuf(Db_Xferred) = InData%i3(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%j1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%j1,2), UBOUND(InData%j1,2)
        DO i1 = LBOUND(InData%j1,1), UBOUND(InData%j1,1)
          DbKiBuf(Db_Xferred) = InData%j1(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%j2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j2,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%j2,2), UBOUND(InData%j2,2)
        DO i1 = LBOUND(InData%j2,1), UBOUND(InData%j2,1)
          DbKiBuf(Db_Xferred) = InData%j2(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%j3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%j3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%j3,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%j3,2), UBOUND(InData%j3,2)
        DO i1 = LBOUND(InData%j3,1), UBOUND(InData%j3,1)
          DbKiBuf(Db_Xferred) = InData%j3(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%m1,3), UBOUND(InData%m1,3)
        DO i2 = LBOUND(InData%m1,2), UBOUND(InData%m1,2)
          DO i1 = LBOUND(InData%m1,1), UBOUND(InData%m1,1)
            DbKiBuf(Db_Xferred) = InData%m1(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%m2,3), UBOUND(InData%m2,3)
        DO i2 = LBOUND(InData%m2,2), UBOUND(InData%m2,2)
          DO i1 = LBOUND(InData%m2,1), UBOUND(InData%m2,1)
            DbKiBuf(Db_Xferred) = InData%m2(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%m3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m3,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%m3,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%m3,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%m3,3), UBOUND(InData%m3,3)
        DO i2 = LBOUND(InData%m3,2), UBOUND(InData%m3,2)
          DO i1 = LBOUND(InData%m3,1), UBOUND(InData%m3,1)
            DbKiBuf(Db_Xferred) = InData%m3(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%n1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%n1,3), UBOUND(InData%n1,3)
        DO i2 = LBOUND(InData%n1,2), UBOUND(InData%n1,2)
          DO i1 = LBOUND(InData%n1,1), UBOUND(InData%n1,1)
            DbKiBuf(Db_Xferred) = InData%n1(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%n2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%n2,3), UBOUND(InData%n2,3)
        DO i2 = LBOUND(InData%n2,2), UBOUND(InData%n2,2)
          DO i1 = LBOUND(InData%n2,1), UBOUND(InData%n2,1)
            DbKiBuf(Db_Xferred) = InData%n2(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%n3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n3,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n3,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n3,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%n3,3), UBOUND(InData%n3,3)
        DO i2 = LBOUND(InData%n3,2), UBOUND(InData%n3,2)
          DO i1 = LBOUND(InData%n3,1), UBOUND(InData%n3,1)
            DbKiBuf(Db_Xferred) = InData%n3(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%p1,1), UBOUND(InData%p1,1)
      DbKiBuf(Db_Xferred) = InData%p1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%p2,1), UBOUND(InData%p2,1)
      DbKiBuf(Db_Xferred) = InData%p2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%p3,1), UBOUND(InData%p3,1)
      DbKiBuf(Db_Xferred) = InData%p3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rf1,1), UBOUND(InData%rf1,1)
      DbKiBuf(Db_Xferred) = InData%rf1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rf2,1), UBOUND(InData%rf2,1)
      DbKiBuf(Db_Xferred) = InData%rf2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rf3,1), UBOUND(InData%rf3,1)
      DbKiBuf(Db_Xferred) = InData%rf3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rfa,1), UBOUND(InData%rfa,1)
      DbKiBuf(Db_Xferred) = InData%rfa(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%t1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%t1,2), UBOUND(InData%t1,2)
        DO i1 = LBOUND(InData%t1,1), UBOUND(InData%t1,1)
          DbKiBuf(Db_Xferred) = InData%t1(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%t2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t2,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%t2,2), UBOUND(InData%t2,2)
        DO i1 = LBOUND(InData%t2,1), UBOUND(InData%t2,1)
          DbKiBuf(Db_Xferred) = InData%t2(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%t3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t3,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%t3,2), UBOUND(InData%t3,2)
        DO i1 = LBOUND(InData%t3,1), UBOUND(InData%t3,1)
          DbKiBuf(Db_Xferred) = InData%t3(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%te1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%te1,3), UBOUND(InData%te1,3)
        DO i2 = LBOUND(InData%te1,2), UBOUND(InData%te1,2)
          DO i1 = LBOUND(InData%te1,1), UBOUND(InData%te1,1)
            DbKiBuf(Db_Xferred) = InData%te1(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%te2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%te2,3), UBOUND(InData%te2,3)
        DO i2 = LBOUND(InData%te2,2), UBOUND(InData%te2,2)
          DO i1 = LBOUND(InData%te2,1), UBOUND(InData%te2,1)
            DbKiBuf(Db_Xferred) = InData%te2(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%te3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te3,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%te3,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%te3,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%te3,3), UBOUND(InData%te3,3)
        DO i2 = LBOUND(InData%te3,2), UBOUND(InData%te3,2)
          DO i1 = LBOUND(InData%te3,1), UBOUND(InData%te3,1)
            DbKiBuf(Db_Xferred) = InData%te3(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%tf1,1), UBOUND(InData%tf1,1)
      DbKiBuf(Db_Xferred) = InData%tf1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%tf2,1), UBOUND(InData%tf2,1)
      DbKiBuf(Db_Xferred) = InData%tf2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%tf3,1), UBOUND(InData%tf3,1)
      DbKiBuf(Db_Xferred) = InData%tf3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%tfa,1), UBOUND(InData%tfa,1)
      DbKiBuf(Db_Xferred) = InData%tfa(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%z1,1), UBOUND(InData%z1,1)
      DbKiBuf(Db_Xferred) = InData%z1(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%z2,1), UBOUND(InData%z2,1)
      DbKiBuf(Db_Xferred) = InData%z2(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%z3,1), UBOUND(InData%z3,1)
      DbKiBuf(Db_Xferred) = InData%z3(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
 END SUBROUTINE ED_PackCoordSys

 SUBROUTINE ED_UnPackCoordSys( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_CoordSys), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackCoordSys'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%a1,1)
    i1_u = UBOUND(OutData%a1,1)
    DO i1 = LBOUND(OutData%a1,1), UBOUND(OutData%a1,1)
      OutData%a1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%a2,1)
    i1_u = UBOUND(OutData%a2,1)
    DO i1 = LBOUND(OutData%a2,1), UBOUND(OutData%a2,1)
      OutData%a2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%a3,1)
    i1_u = UBOUND(OutData%a3,1)
    DO i1 = LBOUND(OutData%a3,1), UBOUND(OutData%a3,1)
      OutData%a3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%b1,1)
    i1_u = UBOUND(OutData%b1,1)
    DO i1 = LBOUND(OutData%b1,1), UBOUND(OutData%b1,1)
      OutData%b1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%b2,1)
    i1_u = UBOUND(OutData%b2,1)
    DO i1 = LBOUND(OutData%b2,1), UBOUND(OutData%b2,1)
      OutData%b2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%b3,1)
    i1_u = UBOUND(OutData%b3,1)
    DO i1 = LBOUND(OutData%b3,1), UBOUND(OutData%b3,1)
      OutData%b3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%c1,1)
    i1_u = UBOUND(OutData%c1,1)
    DO i1 = LBOUND(OutData%c1,1), UBOUND(OutData%c1,1)
      OutData%c1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%c2,1)
    i1_u = UBOUND(OutData%c2,1)
    DO i1 = LBOUND(OutData%c2,1), UBOUND(OutData%c2,1)
      OutData%c2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%c3,1)
    i1_u = UBOUND(OutData%c3,1)
    DO i1 = LBOUND(OutData%c3,1), UBOUND(OutData%c3,1)
      OutData%c3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%d1,1)
    i1_u = UBOUND(OutData%d1,1)
    DO i1 = LBOUND(OutData%d1,1), UBOUND(OutData%d1,1)
      OutData%d1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%d2,1)
    i1_u = UBOUND(OutData%d2,1)
    DO i1 = LBOUND(OutData%d2,1), UBOUND(OutData%d2,1)
      OutData%d2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%d3,1)
    i1_u = UBOUND(OutData%d3,1)
    DO i1 = LBOUND(OutData%d3,1), UBOUND(OutData%d3,1)
      OutData%d3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%e1,1)
    i1_u = UBOUND(OutData%e1,1)
    DO i1 = LBOUND(OutData%e1,1), UBOUND(OutData%e1,1)
      OutData%e1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%e2,1)
    i1_u = UBOUND(OutData%e2,1)
    DO i1 = LBOUND(OutData%e2,1), UBOUND(OutData%e2,1)
      OutData%e2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%e3,1)
    i1_u = UBOUND(OutData%e3,1)
    DO i1 = LBOUND(OutData%e3,1), UBOUND(OutData%e3,1)
      OutData%e3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%f1,1)
    i1_u = UBOUND(OutData%f1,1)
    DO i1 = LBOUND(OutData%f1,1), UBOUND(OutData%f1,1)
      OutData%f1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%f2,1)
    i1_u = UBOUND(OutData%f2,1)
    DO i1 = LBOUND(OutData%f2,1), UBOUND(OutData%f2,1)
      OutData%f2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%f3,1)
    i1_u = UBOUND(OutData%f3,1)
    DO i1 = LBOUND(OutData%f3,1), UBOUND(OutData%f3,1)
      OutData%f3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%g1,1)
    i1_u = UBOUND(OutData%g1,1)
    DO i1 = LBOUND(OutData%g1,1), UBOUND(OutData%g1,1)
      OutData%g1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%g2,1)
    i1_u = UBOUND(OutData%g2,1)
    DO i1 = LBOUND(OutData%g2,1), UBOUND(OutData%g2,1)
      OutData%g2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%g3,1)
    i1_u = UBOUND(OutData%g3,1)
    DO i1 = LBOUND(OutData%g3,1), UBOUND(OutData%g3,1)
      OutData%g3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! i1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%i1)) DEALLOCATE(OutData%i1)
    ALLOCATE(OutData%i1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%i1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%i1,2), UBOUND(OutData%i1,2)
        DO i1 = LBOUND(OutData%i1,1), UBOUND(OutData%i1,1)
          OutData%i1(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! i2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%i2)) DEALLOCATE(OutData%i2)
    ALLOCATE(OutData%i2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%i2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%i2,2), UBOUND(OutData%i2,2)
        DO i1 = LBOUND(OutData%i2,1), UBOUND(OutData%i2,1)
          OutData%i2(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! i3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%i3)) DEALLOCATE(OutData%i3)
    ALLOCATE(OutData%i3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%i3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%i3,2), UBOUND(OutData%i3,2)
        DO i1 = LBOUND(OutData%i3,1), UBOUND(OutData%i3,1)
          OutData%i3(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! j1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%j1)) DEALLOCATE(OutData%j1)
    ALLOCATE(OutData%j1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%j1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%j1,2), UBOUND(OutData%j1,2)
        DO i1 = LBOUND(OutData%j1,1), UBOUND(OutData%j1,1)
          OutData%j1(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! j2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%j2)) DEALLOCATE(OutData%j2)
    ALLOCATE(OutData%j2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%j2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%j2,2), UBOUND(OutData%j2,2)
        DO i1 = LBOUND(OutData%j2,1), UBOUND(OutData%j2,1)
          OutData%j2(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! j3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%j3)) DEALLOCATE(OutData%j3)
    ALLOCATE(OutData%j3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%j3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%j3,2), UBOUND(OutData%j3,2)
        DO i1 = LBOUND(OutData%j3,1), UBOUND(OutData%j3,1)
          OutData%j3(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m1)) DEALLOCATE(OutData%m1)
    ALLOCATE(OutData%m1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%m1,3), UBOUND(OutData%m1,3)
        DO i2 = LBOUND(OutData%m1,2), UBOUND(OutData%m1,2)
          DO i1 = LBOUND(OutData%m1,1), UBOUND(OutData%m1,1)
            OutData%m1(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m2)) DEALLOCATE(OutData%m2)
    ALLOCATE(OutData%m2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%m2,3), UBOUND(OutData%m2,3)
        DO i2 = LBOUND(OutData%m2,2), UBOUND(OutData%m2,2)
          DO i1 = LBOUND(OutData%m2,1), UBOUND(OutData%m2,1)
            OutData%m2(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! m3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%m3)) DEALLOCATE(OutData%m3)
    ALLOCATE(OutData%m3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%m3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%m3,3), UBOUND(OutData%m3,3)
        DO i2 = LBOUND(OutData%m3,2), UBOUND(OutData%m3,2)
          DO i1 = LBOUND(OutData%m3,1), UBOUND(OutData%m3,1)
            OutData%m3(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! n1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%n1)) DEALLOCATE(OutData%n1)
    ALLOCATE(OutData%n1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%n1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%n1,3), UBOUND(OutData%n1,3)
        DO i2 = LBOUND(OutData%n1,2), UBOUND(OutData%n1,2)
          DO i1 = LBOUND(OutData%n1,1), UBOUND(OutData%n1,1)
            OutData%n1(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! n2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%n2)) DEALLOCATE(OutData%n2)
    ALLOCATE(OutData%n2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%n2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%n2,3), UBOUND(OutData%n2,3)
        DO i2 = LBOUND(OutData%n2,2), UBOUND(OutData%n2,2)
          DO i1 = LBOUND(OutData%n2,1), UBOUND(OutData%n2,1)
            OutData%n2(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! n3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%n3)) DEALLOCATE(OutData%n3)
    ALLOCATE(OutData%n3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%n3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%n3,3), UBOUND(OutData%n3,3)
        DO i2 = LBOUND(OutData%n3,2), UBOUND(OutData%n3,2)
          DO i1 = LBOUND(OutData%n3,1), UBOUND(OutData%n3,1)
            OutData%n3(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%p1,1)
    i1_u = UBOUND(OutData%p1,1)
    DO i1 = LBOUND(OutData%p1,1), UBOUND(OutData%p1,1)
      OutData%p1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%p2,1)
    i1_u = UBOUND(OutData%p2,1)
    DO i1 = LBOUND(OutData%p2,1), UBOUND(OutData%p2,1)
      OutData%p2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%p3,1)
    i1_u = UBOUND(OutData%p3,1)
    DO i1 = LBOUND(OutData%p3,1), UBOUND(OutData%p3,1)
      OutData%p3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rf1,1)
    i1_u = UBOUND(OutData%rf1,1)
    DO i1 = LBOUND(OutData%rf1,1), UBOUND(OutData%rf1,1)
      OutData%rf1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rf2,1)
    i1_u = UBOUND(OutData%rf2,1)
    DO i1 = LBOUND(OutData%rf2,1), UBOUND(OutData%rf2,1)
      OutData%rf2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rf3,1)
    i1_u = UBOUND(OutData%rf3,1)
    DO i1 = LBOUND(OutData%rf3,1), UBOUND(OutData%rf3,1)
      OutData%rf3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rfa,1)
    i1_u = UBOUND(OutData%rfa,1)
    DO i1 = LBOUND(OutData%rfa,1), UBOUND(OutData%rfa,1)
      OutData%rfa(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! t1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%t1)) DEALLOCATE(OutData%t1)
    ALLOCATE(OutData%t1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%t1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%t1,2), UBOUND(OutData%t1,2)
        DO i1 = LBOUND(OutData%t1,1), UBOUND(OutData%t1,1)
          OutData%t1(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! t2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%t2)) DEALLOCATE(OutData%t2)
    ALLOCATE(OutData%t2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%t2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%t2,2), UBOUND(OutData%t2,2)
        DO i1 = LBOUND(OutData%t2,1), UBOUND(OutData%t2,1)
          OutData%t2(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! t3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%t3)) DEALLOCATE(OutData%t3)
    ALLOCATE(OutData%t3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%t3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%t3,2), UBOUND(OutData%t3,2)
        DO i1 = LBOUND(OutData%t3,1), UBOUND(OutData%t3,1)
          OutData%t3(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! te1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%te1)) DEALLOCATE(OutData%te1)
    ALLOCATE(OutData%te1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%te1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%te1,3), UBOUND(OutData%te1,3)
        DO i2 = LBOUND(OutData%te1,2), UBOUND(OutData%te1,2)
          DO i1 = LBOUND(OutData%te1,1), UBOUND(OutData%te1,1)
            OutData%te1(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! te2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%te2)) DEALLOCATE(OutData%te2)
    ALLOCATE(OutData%te2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%te2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%te2,3), UBOUND(OutData%te2,3)
        DO i2 = LBOUND(OutData%te2,2), UBOUND(OutData%te2,2)
          DO i1 = LBOUND(OutData%te2,1), UBOUND(OutData%te2,1)
            OutData%te2(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! te3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%te3)) DEALLOCATE(OutData%te3)
    ALLOCATE(OutData%te3(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%te3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%te3,3), UBOUND(OutData%te3,3)
        DO i2 = LBOUND(OutData%te3,2), UBOUND(OutData%te3,2)
          DO i1 = LBOUND(OutData%te3,1), UBOUND(OutData%te3,1)
            OutData%te3(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%tf1,1)
    i1_u = UBOUND(OutData%tf1,1)
    DO i1 = LBOUND(OutData%tf1,1), UBOUND(OutData%tf1,1)
      OutData%tf1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%tf2,1)
    i1_u = UBOUND(OutData%tf2,1)
    DO i1 = LBOUND(OutData%tf2,1), UBOUND(OutData%tf2,1)
      OutData%tf2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%tf3,1)
    i1_u = UBOUND(OutData%tf3,1)
    DO i1 = LBOUND(OutData%tf3,1), UBOUND(OutData%tf3,1)
      OutData%tf3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%tfa,1)
    i1_u = UBOUND(OutData%tfa,1)
    DO i1 = LBOUND(OutData%tfa,1), UBOUND(OutData%tfa,1)
      OutData%tfa(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%z1,1)
    i1_u = UBOUND(OutData%z1,1)
    DO i1 = LBOUND(OutData%z1,1), UBOUND(OutData%z1,1)
      OutData%z1(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%z2,1)
    i1_u = UBOUND(OutData%z2,1)
    DO i1 = LBOUND(OutData%z2,1), UBOUND(OutData%z2,1)
      OutData%z2(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%z3,1)
    i1_u = UBOUND(OutData%z3,1)
    DO i1 = LBOUND(OutData%z3,1), UBOUND(OutData%z3,1)
      OutData%z3(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
 END SUBROUTINE ED_UnPackCoordSys

 SUBROUTINE ED_CopyActiveDOFs( SrcActiveDOFsData, DstActiveDOFsData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_ActiveDOFs), INTENT(IN) :: SrcActiveDOFsData
   TYPE(ED_ActiveDOFs), INTENT(INOUT) :: DstActiveDOFsData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyActiveDOFs'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstActiveDOFsData%NActvDOF = SrcActiveDOFsData%NActvDOF
    DstActiveDOFsData%NPCE = SrcActiveDOFsData%NPCE
    DstActiveDOFsData%NPDE = SrcActiveDOFsData%NPDE
    DstActiveDOFsData%NPIE = SrcActiveDOFsData%NPIE
    DstActiveDOFsData%NPTE = SrcActiveDOFsData%NPTE
    DstActiveDOFsData%NPTTE = SrcActiveDOFsData%NPTTE
IF (ALLOCATED(SrcActiveDOFsData%NPSBE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%NPSBE,1)
  i1_u = UBOUND(SrcActiveDOFsData%NPSBE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%NPSBE)) THEN 
    ALLOCATE(DstActiveDOFsData%NPSBE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%NPSBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%NPSBE = SrcActiveDOFsData%NPSBE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%NPSE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%NPSE,1)
  i1_u = UBOUND(SrcActiveDOFsData%NPSE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%NPSE)) THEN 
    ALLOCATE(DstActiveDOFsData%NPSE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%NPSE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%NPSE = SrcActiveDOFsData%NPSE
ENDIF
    DstActiveDOFsData%NPUE = SrcActiveDOFsData%NPUE
    DstActiveDOFsData%NPYE = SrcActiveDOFsData%NPYE
IF (ALLOCATED(SrcActiveDOFsData%PCE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PCE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PCE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PCE)) THEN 
    ALLOCATE(DstActiveDOFsData%PCE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PCE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PCE = SrcActiveDOFsData%PCE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PDE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PDE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PDE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PDE)) THEN 
    ALLOCATE(DstActiveDOFsData%PDE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PDE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PDE = SrcActiveDOFsData%PDE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PIE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PIE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PIE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PIE)) THEN 
    ALLOCATE(DstActiveDOFsData%PIE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PIE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PIE = SrcActiveDOFsData%PIE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PTE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PTE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PTE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PTE)) THEN 
    ALLOCATE(DstActiveDOFsData%PTE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PTE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PTE = SrcActiveDOFsData%PTE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PTTE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PTTE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PTTE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PTTE)) THEN 
    ALLOCATE(DstActiveDOFsData%PTTE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PTTE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PTTE = SrcActiveDOFsData%PTTE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PS)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PS,1)
  i1_u = UBOUND(SrcActiveDOFsData%PS,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PS)) THEN 
    ALLOCATE(DstActiveDOFsData%PS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PS = SrcActiveDOFsData%PS
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PSBE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PSBE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PSBE,1)
  i2_l = LBOUND(SrcActiveDOFsData%PSBE,2)
  i2_u = UBOUND(SrcActiveDOFsData%PSBE,2)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PSBE)) THEN 
    ALLOCATE(DstActiveDOFsData%PSBE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PSBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PSBE = SrcActiveDOFsData%PSBE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PSE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PSE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PSE,1)
  i2_l = LBOUND(SrcActiveDOFsData%PSE,2)
  i2_u = UBOUND(SrcActiveDOFsData%PSE,2)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PSE)) THEN 
    ALLOCATE(DstActiveDOFsData%PSE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PSE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PSE = SrcActiveDOFsData%PSE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PUE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PUE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PUE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PUE)) THEN 
    ALLOCATE(DstActiveDOFsData%PUE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PUE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PUE = SrcActiveDOFsData%PUE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%PYE)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%PYE,1)
  i1_u = UBOUND(SrcActiveDOFsData%PYE,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%PYE)) THEN 
    ALLOCATE(DstActiveDOFsData%PYE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%PYE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%PYE = SrcActiveDOFsData%PYE
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%SrtPS)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%SrtPS,1)
  i1_u = UBOUND(SrcActiveDOFsData%SrtPS,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%SrtPS)) THEN 
    ALLOCATE(DstActiveDOFsData%SrtPS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%SrtPS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%SrtPS = SrcActiveDOFsData%SrtPS
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%SrtPSNAUG)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%SrtPSNAUG,1)
  i1_u = UBOUND(SrcActiveDOFsData%SrtPSNAUG,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%SrtPSNAUG)) THEN 
    ALLOCATE(DstActiveDOFsData%SrtPSNAUG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%SrtPSNAUG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%SrtPSNAUG = SrcActiveDOFsData%SrtPSNAUG
ENDIF
IF (ALLOCATED(SrcActiveDOFsData%Diag)) THEN
  i1_l = LBOUND(SrcActiveDOFsData%Diag,1)
  i1_u = UBOUND(SrcActiveDOFsData%Diag,1)
  IF (.NOT. ALLOCATED(DstActiveDOFsData%Diag)) THEN 
    ALLOCATE(DstActiveDOFsData%Diag(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstActiveDOFsData%Diag.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstActiveDOFsData%Diag = SrcActiveDOFsData%Diag
ENDIF
 END SUBROUTINE ED_CopyActiveDOFs

 SUBROUTINE ED_DestroyActiveDOFs( ActiveDOFsData, ErrStat, ErrMsg )
  TYPE(ED_ActiveDOFs), INTENT(INOUT) :: ActiveDOFsData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyActiveDOFs'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ActiveDOFsData%NPSBE)) THEN
  DEALLOCATE(ActiveDOFsData%NPSBE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%NPSE)) THEN
  DEALLOCATE(ActiveDOFsData%NPSE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PCE)) THEN
  DEALLOCATE(ActiveDOFsData%PCE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PDE)) THEN
  DEALLOCATE(ActiveDOFsData%PDE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PIE)) THEN
  DEALLOCATE(ActiveDOFsData%PIE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PTE)) THEN
  DEALLOCATE(ActiveDOFsData%PTE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PTTE)) THEN
  DEALLOCATE(ActiveDOFsData%PTTE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PS)) THEN
  DEALLOCATE(ActiveDOFsData%PS)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PSBE)) THEN
  DEALLOCATE(ActiveDOFsData%PSBE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PSE)) THEN
  DEALLOCATE(ActiveDOFsData%PSE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PUE)) THEN
  DEALLOCATE(ActiveDOFsData%PUE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%PYE)) THEN
  DEALLOCATE(ActiveDOFsData%PYE)
ENDIF
IF (ALLOCATED(ActiveDOFsData%SrtPS)) THEN
  DEALLOCATE(ActiveDOFsData%SrtPS)
ENDIF
IF (ALLOCATED(ActiveDOFsData%SrtPSNAUG)) THEN
  DEALLOCATE(ActiveDOFsData%SrtPSNAUG)
ENDIF
IF (ALLOCATED(ActiveDOFsData%Diag)) THEN
  DEALLOCATE(ActiveDOFsData%Diag)
ENDIF
 END SUBROUTINE ED_DestroyActiveDOFs

 SUBROUTINE ED_PackActiveDOFs( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_ActiveDOFs),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackActiveDOFs'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NActvDOF
      Int_BufSz  = Int_BufSz  + 1  ! NPCE
      Int_BufSz  = Int_BufSz  + 1  ! NPDE
      Int_BufSz  = Int_BufSz  + 1  ! NPIE
      Int_BufSz  = Int_BufSz  + 1  ! NPTE
      Int_BufSz  = Int_BufSz  + 1  ! NPTTE
  Int_BufSz   = Int_BufSz   + 1     ! NPSBE allocated yes/no
  IF ( ALLOCATED(InData%NPSBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NPSBE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%NPSBE)  ! NPSBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! NPSE allocated yes/no
  IF ( ALLOCATED(InData%NPSE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! NPSE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%NPSE)  ! NPSE
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NPUE
      Int_BufSz  = Int_BufSz  + 1  ! NPYE
  Int_BufSz   = Int_BufSz   + 1     ! PCE allocated yes/no
  IF ( ALLOCATED(InData%PCE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PCE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PCE)  ! PCE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PDE allocated yes/no
  IF ( ALLOCATED(InData%PDE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PDE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PDE)  ! PDE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PIE allocated yes/no
  IF ( ALLOCATED(InData%PIE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PIE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PIE)  ! PIE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PTE allocated yes/no
  IF ( ALLOCATED(InData%PTE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PTE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PTE)  ! PTE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PTTE allocated yes/no
  IF ( ALLOCATED(InData%PTTE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PTTE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PTTE)  ! PTTE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PS allocated yes/no
  IF ( ALLOCATED(InData%PS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PS upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PS)  ! PS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PSBE allocated yes/no
  IF ( ALLOCATED(InData%PSBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PSBE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PSBE)  ! PSBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PSE allocated yes/no
  IF ( ALLOCATED(InData%PSE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PSE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PSE)  ! PSE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PUE allocated yes/no
  IF ( ALLOCATED(InData%PUE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PUE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PUE)  ! PUE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PYE allocated yes/no
  IF ( ALLOCATED(InData%PYE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PYE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PYE)  ! PYE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SrtPS allocated yes/no
  IF ( ALLOCATED(InData%SrtPS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SrtPS upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%SrtPS)  ! SrtPS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SrtPSNAUG allocated yes/no
  IF ( ALLOCATED(InData%SrtPSNAUG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SrtPSNAUG upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%SrtPSNAUG)  ! SrtPSNAUG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Diag allocated yes/no
  IF ( ALLOCATED(InData%Diag) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Diag upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Diag)  ! Diag
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NActvDOF
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPCE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPDE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPIE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPTE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPTTE
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%NPSBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NPSBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NPSBE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NPSBE,1), UBOUND(InData%NPSBE,1)
        IntKiBuf(Int_Xferred) = InData%NPSBE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%NPSE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%NPSE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%NPSE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%NPSE,1), UBOUND(InData%NPSE,1)
        IntKiBuf(Int_Xferred) = InData%NPSE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NPUE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPYE
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PCE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PCE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PCE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PCE,1), UBOUND(InData%PCE,1)
        IntKiBuf(Int_Xferred) = InData%PCE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PDE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PDE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PDE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PDE,1), UBOUND(InData%PDE,1)
        IntKiBuf(Int_Xferred) = InData%PDE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PIE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PIE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PIE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PIE,1), UBOUND(InData%PIE,1)
        IntKiBuf(Int_Xferred) = InData%PIE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PTE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PTE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PTE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PTE,1), UBOUND(InData%PTE,1)
        IntKiBuf(Int_Xferred) = InData%PTE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PTTE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PTTE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PTTE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PTTE,1), UBOUND(InData%PTTE,1)
        IntKiBuf(Int_Xferred) = InData%PTTE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PS,1), UBOUND(InData%PS,1)
        IntKiBuf(Int_Xferred) = InData%PS(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PSBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PSBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PSBE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PSBE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PSBE,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PSBE,2), UBOUND(InData%PSBE,2)
        DO i1 = LBOUND(InData%PSBE,1), UBOUND(InData%PSBE,1)
          IntKiBuf(Int_Xferred) = InData%PSBE(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PSE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PSE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PSE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PSE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PSE,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PSE,2), UBOUND(InData%PSE,2)
        DO i1 = LBOUND(InData%PSE,1), UBOUND(InData%PSE,1)
          IntKiBuf(Int_Xferred) = InData%PSE(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PUE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PUE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PUE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PUE,1), UBOUND(InData%PUE,1)
        IntKiBuf(Int_Xferred) = InData%PUE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PYE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PYE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PYE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PYE,1), UBOUND(InData%PYE,1)
        IntKiBuf(Int_Xferred) = InData%PYE(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SrtPS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SrtPS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SrtPS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SrtPS,1), UBOUND(InData%SrtPS,1)
        IntKiBuf(Int_Xferred) = InData%SrtPS(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SrtPSNAUG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SrtPSNAUG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SrtPSNAUG,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SrtPSNAUG,1), UBOUND(InData%SrtPSNAUG,1)
        IntKiBuf(Int_Xferred) = InData%SrtPSNAUG(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Diag) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Diag,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Diag,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Diag,1), UBOUND(InData%Diag,1)
        IntKiBuf(Int_Xferred) = InData%Diag(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_PackActiveDOFs

 SUBROUTINE ED_UnPackActiveDOFs( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_ActiveDOFs), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackActiveDOFs'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NActvDOF = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPCE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPDE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPIE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPTE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPTTE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NPSBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NPSBE)) DEALLOCATE(OutData%NPSBE)
    ALLOCATE(OutData%NPSBE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NPSBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NPSBE,1), UBOUND(OutData%NPSBE,1)
        OutData%NPSBE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! NPSE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%NPSE)) DEALLOCATE(OutData%NPSE)
    ALLOCATE(OutData%NPSE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%NPSE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%NPSE,1), UBOUND(OutData%NPSE,1)
        OutData%NPSE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%NPUE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPYE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PCE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PCE)) DEALLOCATE(OutData%PCE)
    ALLOCATE(OutData%PCE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PCE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PCE,1), UBOUND(OutData%PCE,1)
        OutData%PCE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PDE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PDE)) DEALLOCATE(OutData%PDE)
    ALLOCATE(OutData%PDE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PDE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PDE,1), UBOUND(OutData%PDE,1)
        OutData%PDE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PIE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PIE)) DEALLOCATE(OutData%PIE)
    ALLOCATE(OutData%PIE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PIE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PIE,1), UBOUND(OutData%PIE,1)
        OutData%PIE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PTE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PTE)) DEALLOCATE(OutData%PTE)
    ALLOCATE(OutData%PTE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PTE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PTE,1), UBOUND(OutData%PTE,1)
        OutData%PTE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PTTE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PTTE)) DEALLOCATE(OutData%PTTE)
    ALLOCATE(OutData%PTTE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PTTE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PTTE,1), UBOUND(OutData%PTTE,1)
        OutData%PTTE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PS)) DEALLOCATE(OutData%PS)
    ALLOCATE(OutData%PS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PS,1), UBOUND(OutData%PS,1)
        OutData%PS(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PSBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PSBE)) DEALLOCATE(OutData%PSBE)
    ALLOCATE(OutData%PSBE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PSBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PSBE,2), UBOUND(OutData%PSBE,2)
        DO i1 = LBOUND(OutData%PSBE,1), UBOUND(OutData%PSBE,1)
          OutData%PSBE(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PSE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PSE)) DEALLOCATE(OutData%PSE)
    ALLOCATE(OutData%PSE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PSE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PSE,2), UBOUND(OutData%PSE,2)
        DO i1 = LBOUND(OutData%PSE,1), UBOUND(OutData%PSE,1)
          OutData%PSE(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PUE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PUE)) DEALLOCATE(OutData%PUE)
    ALLOCATE(OutData%PUE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PUE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PUE,1), UBOUND(OutData%PUE,1)
        OutData%PUE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PYE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PYE)) DEALLOCATE(OutData%PYE)
    ALLOCATE(OutData%PYE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PYE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PYE,1), UBOUND(OutData%PYE,1)
        OutData%PYE(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SrtPS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SrtPS)) DEALLOCATE(OutData%SrtPS)
    ALLOCATE(OutData%SrtPS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SrtPS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SrtPS,1), UBOUND(OutData%SrtPS,1)
        OutData%SrtPS(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SrtPSNAUG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SrtPSNAUG)) DEALLOCATE(OutData%SrtPSNAUG)
    ALLOCATE(OutData%SrtPSNAUG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SrtPSNAUG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SrtPSNAUG,1), UBOUND(OutData%SrtPSNAUG,1)
        OutData%SrtPSNAUG(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Diag not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Diag)) DEALLOCATE(OutData%Diag)
    ALLOCATE(OutData%Diag(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Diag.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Diag,1), UBOUND(OutData%Diag,1)
        OutData%Diag(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_UnPackActiveDOFs

 SUBROUTINE ED_CopyRtHndSide( SrcRtHndSideData, DstRtHndSideData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_RtHndSide), INTENT(IN) :: SrcRtHndSideData
   TYPE(ED_RtHndSide), INTENT(INOUT) :: DstRtHndSideData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyRtHndSide'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstRtHndSideData%rO = SrcRtHndSideData%rO
IF (ALLOCATED(SrcRtHndSideData%rQS)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rQS,1)
  i1_u = UBOUND(SrcRtHndSideData%rQS,1)
  i2_l = LBOUND(SrcRtHndSideData%rQS,2)
  i2_u = UBOUND(SrcRtHndSideData%rQS,2)
  i3_l = LBOUND(SrcRtHndSideData%rQS,3)
  i3_u = UBOUND(SrcRtHndSideData%rQS,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rQS)) THEN 
    ALLOCATE(DstRtHndSideData%rQS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rQS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rQS = SrcRtHndSideData%rQS
ENDIF
IF (ALLOCATED(SrcRtHndSideData%rS)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rS,1)
  i1_u = UBOUND(SrcRtHndSideData%rS,1)
  i2_l = LBOUND(SrcRtHndSideData%rS,2)
  i2_u = UBOUND(SrcRtHndSideData%rS,2)
  i3_l = LBOUND(SrcRtHndSideData%rS,3)
  i3_u = UBOUND(SrcRtHndSideData%rS,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rS)) THEN 
    ALLOCATE(DstRtHndSideData%rS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rS = SrcRtHndSideData%rS
ENDIF
IF (ALLOCATED(SrcRtHndSideData%rS0S)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rS0S,1)
  i1_u = UBOUND(SrcRtHndSideData%rS0S,1)
  i2_l = LBOUND(SrcRtHndSideData%rS0S,2)
  i2_u = UBOUND(SrcRtHndSideData%rS0S,2)
  i3_l = LBOUND(SrcRtHndSideData%rS0S,3)
  i3_u = UBOUND(SrcRtHndSideData%rS0S,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rS0S)) THEN 
    ALLOCATE(DstRtHndSideData%rS0S(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rS0S.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rS0S = SrcRtHndSideData%rS0S
ENDIF
IF (ALLOCATED(SrcRtHndSideData%rT)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rT,1)
  i1_u = UBOUND(SrcRtHndSideData%rT,1)
  i2_l = LBOUND(SrcRtHndSideData%rT,2)
  i2_u = UBOUND(SrcRtHndSideData%rT,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rT)) THEN 
    ALLOCATE(DstRtHndSideData%rT(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rT = SrcRtHndSideData%rT
ENDIF
    DstRtHndSideData%rT0O = SrcRtHndSideData%rT0O
IF (ALLOCATED(SrcRtHndSideData%rT0T)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rT0T,1)
  i1_u = UBOUND(SrcRtHndSideData%rT0T,1)
  i2_l = LBOUND(SrcRtHndSideData%rT0T,2)
  i2_u = UBOUND(SrcRtHndSideData%rT0T,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rT0T)) THEN 
    ALLOCATE(DstRtHndSideData%rT0T(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rT0T.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rT0T = SrcRtHndSideData%rT0T
ENDIF
    DstRtHndSideData%rZ = SrcRtHndSideData%rZ
    DstRtHndSideData%rZO = SrcRtHndSideData%rZO
IF (ALLOCATED(SrcRtHndSideData%rZT)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rZT,1)
  i1_u = UBOUND(SrcRtHndSideData%rZT,1)
  i2_l = LBOUND(SrcRtHndSideData%rZT,2)
  i2_u = UBOUND(SrcRtHndSideData%rZT,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rZT)) THEN 
    ALLOCATE(DstRtHndSideData%rZT(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rZT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rZT = SrcRtHndSideData%rZT
ENDIF
    DstRtHndSideData%rPQ = SrcRtHndSideData%rPQ
    DstRtHndSideData%rP = SrcRtHndSideData%rP
    DstRtHndSideData%rV = SrcRtHndSideData%rV
    DstRtHndSideData%rZY = SrcRtHndSideData%rZY
    DstRtHndSideData%rOU = SrcRtHndSideData%rOU
    DstRtHndSideData%rOV = SrcRtHndSideData%rOV
    DstRtHndSideData%rVD = SrcRtHndSideData%rVD
    DstRtHndSideData%rOW = SrcRtHndSideData%rOW
    DstRtHndSideData%rPC = SrcRtHndSideData%rPC
IF (ALLOCATED(SrcRtHndSideData%rPS0)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rPS0,1)
  i1_u = UBOUND(SrcRtHndSideData%rPS0,1)
  i2_l = LBOUND(SrcRtHndSideData%rPS0,2)
  i2_u = UBOUND(SrcRtHndSideData%rPS0,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rPS0)) THEN 
    ALLOCATE(DstRtHndSideData%rPS0(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rPS0.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rPS0 = SrcRtHndSideData%rPS0
ENDIF
    DstRtHndSideData%rQ = SrcRtHndSideData%rQ
    DstRtHndSideData%rQC = SrcRtHndSideData%rQC
    DstRtHndSideData%rVIMU = SrcRtHndSideData%rVIMU
    DstRtHndSideData%rVP = SrcRtHndSideData%rVP
    DstRtHndSideData%rWI = SrcRtHndSideData%rWI
    DstRtHndSideData%rWJ = SrcRtHndSideData%rWJ
    DstRtHndSideData%rWK = SrcRtHndSideData%rWK
    DstRtHndSideData%rZT0 = SrcRtHndSideData%rZT0
IF (ALLOCATED(SrcRtHndSideData%AngPosEF)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngPosEF,1)
  i1_u = UBOUND(SrcRtHndSideData%AngPosEF,1)
  i2_l = LBOUND(SrcRtHndSideData%AngPosEF,2)
  i2_u = UBOUND(SrcRtHndSideData%AngPosEF,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngPosEF)) THEN 
    ALLOCATE(DstRtHndSideData%AngPosEF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosEF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngPosEF = SrcRtHndSideData%AngPosEF
ENDIF
IF (ALLOCATED(SrcRtHndSideData%AngPosXF)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngPosXF,1)
  i1_u = UBOUND(SrcRtHndSideData%AngPosXF,1)
  i2_l = LBOUND(SrcRtHndSideData%AngPosXF,2)
  i2_u = UBOUND(SrcRtHndSideData%AngPosXF,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngPosXF)) THEN 
    ALLOCATE(DstRtHndSideData%AngPosXF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosXF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngPosXF = SrcRtHndSideData%AngPosXF
ENDIF
IF (ALLOCATED(SrcRtHndSideData%AngPosHM)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngPosHM,1)
  i1_u = UBOUND(SrcRtHndSideData%AngPosHM,1)
  i2_l = LBOUND(SrcRtHndSideData%AngPosHM,2)
  i2_u = UBOUND(SrcRtHndSideData%AngPosHM,2)
  i3_l = LBOUND(SrcRtHndSideData%AngPosHM,3)
  i3_u = UBOUND(SrcRtHndSideData%AngPosHM,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngPosHM)) THEN 
    ALLOCATE(DstRtHndSideData%AngPosHM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngPosHM.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngPosHM = SrcRtHndSideData%AngPosHM
ENDIF
    DstRtHndSideData%AngPosXB = SrcRtHndSideData%AngPosXB
    DstRtHndSideData%AngPosEX = SrcRtHndSideData%AngPosEX
IF (ALLOCATED(SrcRtHndSideData%PAngVelEA)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEA,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEA,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEA,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEA,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEA,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEA,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEA)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEA = SrcRtHndSideData%PAngVelEA
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEF)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEF,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEF,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEF,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEF,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEF,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEF,3)
  i4_l = LBOUND(SrcRtHndSideData%PAngVelEF,4)
  i4_u = UBOUND(SrcRtHndSideData%PAngVelEF,4)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEF)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEF = SrcRtHndSideData%PAngVelEF
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEG)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEG,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEG,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEG,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEG,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEG,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEG,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEG)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEG(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEG = SrcRtHndSideData%PAngVelEG
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEH)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEH,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEH,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEH,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEH,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEH,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEH,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEH)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEH(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEH.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEH = SrcRtHndSideData%PAngVelEH
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEL)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEL,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEL,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEL,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEL,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEL,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEL,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEL)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEL = SrcRtHndSideData%PAngVelEL
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEM)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEM,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEM,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEM,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEM,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEM,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEM,3)
  i4_l = LBOUND(SrcRtHndSideData%PAngVelEM,4)
  i4_u = UBOUND(SrcRtHndSideData%PAngVelEM,4)
  i5_l = LBOUND(SrcRtHndSideData%PAngVelEM,5)
  i5_u = UBOUND(SrcRtHndSideData%PAngVelEM,5)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEM)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEM.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEM = SrcRtHndSideData%PAngVelEM
ENDIF
IF (ALLOCATED(SrcRtHndSideData%AngVelEM)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngVelEM,1)
  i1_u = UBOUND(SrcRtHndSideData%AngVelEM,1)
  i2_l = LBOUND(SrcRtHndSideData%AngVelEM,2)
  i2_u = UBOUND(SrcRtHndSideData%AngVelEM,2)
  i3_l = LBOUND(SrcRtHndSideData%AngVelEM,3)
  i3_u = UBOUND(SrcRtHndSideData%AngVelEM,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngVelEM)) THEN 
    ALLOCATE(DstRtHndSideData%AngVelEM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelEM.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngVelEM = SrcRtHndSideData%AngVelEM
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEN)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEN,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEN,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEN,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEN,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEN,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEN,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEN)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEN(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEN.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEN = SrcRtHndSideData%PAngVelEN
ENDIF
    DstRtHndSideData%AngVelEA = SrcRtHndSideData%AngVelEA
IF (ALLOCATED(SrcRtHndSideData%PAngVelEB)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEB,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEB,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEB,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEB,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEB,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEB,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEB)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEB(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEB.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEB = SrcRtHndSideData%PAngVelEB
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelER)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelER,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelER,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelER,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelER,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelER,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelER,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelER)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelER(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelER.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelER = SrcRtHndSideData%PAngVelER
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PAngVelEX)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PAngVelEX,1)
  i1_u = UBOUND(SrcRtHndSideData%PAngVelEX,1)
  i2_l = LBOUND(SrcRtHndSideData%PAngVelEX,2)
  i2_u = UBOUND(SrcRtHndSideData%PAngVelEX,2)
  i3_l = LBOUND(SrcRtHndSideData%PAngVelEX,3)
  i3_u = UBOUND(SrcRtHndSideData%PAngVelEX,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PAngVelEX)) THEN 
    ALLOCATE(DstRtHndSideData%PAngVelEX(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PAngVelEX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PAngVelEX = SrcRtHndSideData%PAngVelEX
ENDIF
    DstRtHndSideData%AngVelEG = SrcRtHndSideData%AngVelEG
    DstRtHndSideData%AngVelEH = SrcRtHndSideData%AngVelEH
    DstRtHndSideData%AngVelEL = SrcRtHndSideData%AngVelEL
    DstRtHndSideData%AngVelEN = SrcRtHndSideData%AngVelEN
    DstRtHndSideData%AngVelEB = SrcRtHndSideData%AngVelEB
    DstRtHndSideData%AngVelER = SrcRtHndSideData%AngVelER
    DstRtHndSideData%AngVelEX = SrcRtHndSideData%AngVelEX
    DstRtHndSideData%TeetAngVel = SrcRtHndSideData%TeetAngVel
    DstRtHndSideData%AngAccEBt = SrcRtHndSideData%AngAccEBt
    DstRtHndSideData%AngAccERt = SrcRtHndSideData%AngAccERt
    DstRtHndSideData%AngAccEXt = SrcRtHndSideData%AngAccEXt
IF (ALLOCATED(SrcRtHndSideData%AngAccEFt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngAccEFt,1)
  i1_u = UBOUND(SrcRtHndSideData%AngAccEFt,1)
  i2_l = LBOUND(SrcRtHndSideData%AngAccEFt,2)
  i2_u = UBOUND(SrcRtHndSideData%AngAccEFt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngAccEFt)) THEN 
    ALLOCATE(DstRtHndSideData%AngAccEFt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngAccEFt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngAccEFt = SrcRtHndSideData%AngAccEFt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%AngVelEF)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngVelEF,1)
  i1_u = UBOUND(SrcRtHndSideData%AngVelEF,1)
  i2_l = LBOUND(SrcRtHndSideData%AngVelEF,2)
  i2_u = UBOUND(SrcRtHndSideData%AngVelEF,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngVelEF)) THEN 
    ALLOCATE(DstRtHndSideData%AngVelEF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelEF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngVelEF = SrcRtHndSideData%AngVelEF
ENDIF
IF (ALLOCATED(SrcRtHndSideData%AngVelHM)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngVelHM,1)
  i1_u = UBOUND(SrcRtHndSideData%AngVelHM,1)
  i2_l = LBOUND(SrcRtHndSideData%AngVelHM,2)
  i2_u = UBOUND(SrcRtHndSideData%AngVelHM,2)
  i3_l = LBOUND(SrcRtHndSideData%AngVelHM,3)
  i3_u = UBOUND(SrcRtHndSideData%AngVelHM,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngVelHM)) THEN 
    ALLOCATE(DstRtHndSideData%AngVelHM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngVelHM.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngVelHM = SrcRtHndSideData%AngVelHM
ENDIF
    DstRtHndSideData%AngAccEAt = SrcRtHndSideData%AngAccEAt
    DstRtHndSideData%AngAccEGt = SrcRtHndSideData%AngAccEGt
    DstRtHndSideData%AngAccEHt = SrcRtHndSideData%AngAccEHt
IF (ALLOCATED(SrcRtHndSideData%AngAccEKt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%AngAccEKt,1)
  i1_u = UBOUND(SrcRtHndSideData%AngAccEKt,1)
  i2_l = LBOUND(SrcRtHndSideData%AngAccEKt,2)
  i2_u = UBOUND(SrcRtHndSideData%AngAccEKt,2)
  i3_l = LBOUND(SrcRtHndSideData%AngAccEKt,3)
  i3_u = UBOUND(SrcRtHndSideData%AngAccEKt,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%AngAccEKt)) THEN 
    ALLOCATE(DstRtHndSideData%AngAccEKt(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%AngAccEKt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%AngAccEKt = SrcRtHndSideData%AngAccEKt
ENDIF
    DstRtHndSideData%AngAccENt = SrcRtHndSideData%AngAccENt
    DstRtHndSideData%LinAccECt = SrcRtHndSideData%LinAccECt
    DstRtHndSideData%LinAccEDt = SrcRtHndSideData%LinAccEDt
    DstRtHndSideData%LinAccEIt = SrcRtHndSideData%LinAccEIt
    DstRtHndSideData%LinAccEJt = SrcRtHndSideData%LinAccEJt
    DstRtHndSideData%LinAccEUt = SrcRtHndSideData%LinAccEUt
    DstRtHndSideData%LinAccEYt = SrcRtHndSideData%LinAccEYt
IF (ALLOCATED(SrcRtHndSideData%LinVelES)) THEN
  i1_l = LBOUND(SrcRtHndSideData%LinVelES,1)
  i1_u = UBOUND(SrcRtHndSideData%LinVelES,1)
  i2_l = LBOUND(SrcRtHndSideData%LinVelES,2)
  i2_u = UBOUND(SrcRtHndSideData%LinVelES,2)
  i3_l = LBOUND(SrcRtHndSideData%LinVelES,3)
  i3_u = UBOUND(SrcRtHndSideData%LinVelES,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%LinVelES)) THEN 
    ALLOCATE(DstRtHndSideData%LinVelES(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelES.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%LinVelES = SrcRtHndSideData%LinVelES
ENDIF
    DstRtHndSideData%LinVelEQ = SrcRtHndSideData%LinVelEQ
IF (ALLOCATED(SrcRtHndSideData%LinVelET)) THEN
  i1_l = LBOUND(SrcRtHndSideData%LinVelET,1)
  i1_u = UBOUND(SrcRtHndSideData%LinVelET,1)
  i2_l = LBOUND(SrcRtHndSideData%LinVelET,2)
  i2_u = UBOUND(SrcRtHndSideData%LinVelET,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%LinVelET)) THEN 
    ALLOCATE(DstRtHndSideData%LinVelET(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelET.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%LinVelET = SrcRtHndSideData%LinVelET
ENDIF
IF (ALLOCATED(SrcRtHndSideData%LinVelESm2)) THEN
  i1_l = LBOUND(SrcRtHndSideData%LinVelESm2,1)
  i1_u = UBOUND(SrcRtHndSideData%LinVelESm2,1)
  IF (.NOT. ALLOCATED(DstRtHndSideData%LinVelESm2)) THEN 
    ALLOCATE(DstRtHndSideData%LinVelESm2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinVelESm2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%LinVelESm2 = SrcRtHndSideData%LinVelESm2
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEIMU)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEIMU,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEIMU,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEIMU,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEIMU,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEIMU,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEIMU,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEIMU)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEIMU(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEIMU.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEIMU = SrcRtHndSideData%PLinVelEIMU
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEO)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEO,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEO,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEO,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEO,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEO,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEO,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEO)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEO(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEO.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEO = SrcRtHndSideData%PLinVelEO
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelES)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelES,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelES,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelES,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelES,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelES,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelES,3)
  i4_l = LBOUND(SrcRtHndSideData%PLinVelES,4)
  i4_u = UBOUND(SrcRtHndSideData%PLinVelES,4)
  i5_l = LBOUND(SrcRtHndSideData%PLinVelES,5)
  i5_u = UBOUND(SrcRtHndSideData%PLinVelES,5)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelES)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelES(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelES.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelES = SrcRtHndSideData%PLinVelES
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelET)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelET,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelET,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelET,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelET,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelET,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelET,3)
  i4_l = LBOUND(SrcRtHndSideData%PLinVelET,4)
  i4_u = UBOUND(SrcRtHndSideData%PLinVelET,4)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelET)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelET(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelET.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelET = SrcRtHndSideData%PLinVelET
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEZ)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEZ,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEZ,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEZ,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEZ,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEZ,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEZ,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEZ)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEZ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEZ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEZ = SrcRtHndSideData%PLinVelEZ
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEC)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEC,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEC,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEC,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEC,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEC,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEC,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEC)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEC(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEC = SrcRtHndSideData%PLinVelEC
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelED)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelED,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelED,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelED,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelED,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelED,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelED,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelED)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelED(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelED.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelED = SrcRtHndSideData%PLinVelED
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEI)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEI,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEI,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEI,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEI,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEI,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEI,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEI)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEI(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEI.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEI = SrcRtHndSideData%PLinVelEI
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEJ)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEJ,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEJ,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEJ,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEJ,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEJ,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEJ,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEJ)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEJ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEJ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEJ = SrcRtHndSideData%PLinVelEJ
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEK)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEK,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEK,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEK,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEK,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEK,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEK,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEK)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEK(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEK.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEK = SrcRtHndSideData%PLinVelEK
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEP)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEP,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEP,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEP,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEP,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEP,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEP,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEP)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEP(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEP = SrcRtHndSideData%PLinVelEP
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEQ)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEQ,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEQ,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEQ,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEQ,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEQ,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEQ,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEQ)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEQ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEQ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEQ = SrcRtHndSideData%PLinVelEQ
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEU)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEU,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEU,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEU,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEU,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEU,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEU,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEU)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEU(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEU.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEU = SrcRtHndSideData%PLinVelEU
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEV)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEV,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEV,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEV,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEV,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEV,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEV,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEV)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEV(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEV.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEV = SrcRtHndSideData%PLinVelEV
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEW)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEW,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEW,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEW,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEW,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEW,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEW,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEW)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEW = SrcRtHndSideData%PLinVelEW
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PLinVelEY)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PLinVelEY,1)
  i1_u = UBOUND(SrcRtHndSideData%PLinVelEY,1)
  i2_l = LBOUND(SrcRtHndSideData%PLinVelEY,2)
  i2_u = UBOUND(SrcRtHndSideData%PLinVelEY,2)
  i3_l = LBOUND(SrcRtHndSideData%PLinVelEY,3)
  i3_u = UBOUND(SrcRtHndSideData%PLinVelEY,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PLinVelEY)) THEN 
    ALLOCATE(DstRtHndSideData%PLinVelEY(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PLinVelEY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PLinVelEY = SrcRtHndSideData%PLinVelEY
ENDIF
    DstRtHndSideData%LinAccEIMUt = SrcRtHndSideData%LinAccEIMUt
    DstRtHndSideData%LinAccEOt = SrcRtHndSideData%LinAccEOt
IF (ALLOCATED(SrcRtHndSideData%LinAccESt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%LinAccESt,1)
  i1_u = UBOUND(SrcRtHndSideData%LinAccESt,1)
  i2_l = LBOUND(SrcRtHndSideData%LinAccESt,2)
  i2_u = UBOUND(SrcRtHndSideData%LinAccESt,2)
  i3_l = LBOUND(SrcRtHndSideData%LinAccESt,3)
  i3_u = UBOUND(SrcRtHndSideData%LinAccESt,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%LinAccESt)) THEN 
    ALLOCATE(DstRtHndSideData%LinAccESt(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinAccESt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%LinAccESt = SrcRtHndSideData%LinAccESt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%LinAccETt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%LinAccETt,1)
  i1_u = UBOUND(SrcRtHndSideData%LinAccETt,1)
  i2_l = LBOUND(SrcRtHndSideData%LinAccETt,2)
  i2_u = UBOUND(SrcRtHndSideData%LinAccETt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%LinAccETt)) THEN 
    ALLOCATE(DstRtHndSideData%LinAccETt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%LinAccETt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%LinAccETt = SrcRtHndSideData%LinAccETt
ENDIF
    DstRtHndSideData%LinAccEZt = SrcRtHndSideData%LinAccEZt
    DstRtHndSideData%LinVelEIMU = SrcRtHndSideData%LinVelEIMU
    DstRtHndSideData%LinVelEZ = SrcRtHndSideData%LinVelEZ
    DstRtHndSideData%LinVelEO = SrcRtHndSideData%LinVelEO
    DstRtHndSideData%FrcONcRtt = SrcRtHndSideData%FrcONcRtt
    DstRtHndSideData%FrcPRott = SrcRtHndSideData%FrcPRott
IF (ALLOCATED(SrcRtHndSideData%FrcS0Bt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%FrcS0Bt,1)
  i1_u = UBOUND(SrcRtHndSideData%FrcS0Bt,1)
  i2_l = LBOUND(SrcRtHndSideData%FrcS0Bt,2)
  i2_u = UBOUND(SrcRtHndSideData%FrcS0Bt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%FrcS0Bt)) THEN 
    ALLOCATE(DstRtHndSideData%FrcS0Bt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FrcS0Bt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%FrcS0Bt = SrcRtHndSideData%FrcS0Bt
ENDIF
    DstRtHndSideData%FrcT0Trbt = SrcRtHndSideData%FrcT0Trbt
IF (ALLOCATED(SrcRtHndSideData%FSAero)) THEN
  i1_l = LBOUND(SrcRtHndSideData%FSAero,1)
  i1_u = UBOUND(SrcRtHndSideData%FSAero,1)
  i2_l = LBOUND(SrcRtHndSideData%FSAero,2)
  i2_u = UBOUND(SrcRtHndSideData%FSAero,2)
  i3_l = LBOUND(SrcRtHndSideData%FSAero,3)
  i3_u = UBOUND(SrcRtHndSideData%FSAero,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%FSAero)) THEN 
    ALLOCATE(DstRtHndSideData%FSAero(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FSAero.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%FSAero = SrcRtHndSideData%FSAero
ENDIF
IF (ALLOCATED(SrcRtHndSideData%FSTipDrag)) THEN
  i1_l = LBOUND(SrcRtHndSideData%FSTipDrag,1)
  i1_u = UBOUND(SrcRtHndSideData%FSTipDrag,1)
  i2_l = LBOUND(SrcRtHndSideData%FSTipDrag,2)
  i2_u = UBOUND(SrcRtHndSideData%FSTipDrag,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%FSTipDrag)) THEN 
    ALLOCATE(DstRtHndSideData%FSTipDrag(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FSTipDrag.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%FSTipDrag = SrcRtHndSideData%FSTipDrag
ENDIF
IF (ALLOCATED(SrcRtHndSideData%FTHydrot)) THEN
  i1_l = LBOUND(SrcRtHndSideData%FTHydrot,1)
  i1_u = UBOUND(SrcRtHndSideData%FTHydrot,1)
  i2_l = LBOUND(SrcRtHndSideData%FTHydrot,2)
  i2_u = UBOUND(SrcRtHndSideData%FTHydrot,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%FTHydrot)) THEN 
    ALLOCATE(DstRtHndSideData%FTHydrot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%FTHydrot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%FTHydrot = SrcRtHndSideData%FTHydrot
ENDIF
    DstRtHndSideData%FZHydrot = SrcRtHndSideData%FZHydrot
IF (ALLOCATED(SrcRtHndSideData%MFHydrot)) THEN
  i1_l = LBOUND(SrcRtHndSideData%MFHydrot,1)
  i1_u = UBOUND(SrcRtHndSideData%MFHydrot,1)
  i2_l = LBOUND(SrcRtHndSideData%MFHydrot,2)
  i2_u = UBOUND(SrcRtHndSideData%MFHydrot,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%MFHydrot)) THEN 
    ALLOCATE(DstRtHndSideData%MFHydrot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MFHydrot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%MFHydrot = SrcRtHndSideData%MFHydrot
ENDIF
    DstRtHndSideData%MomBNcRtt = SrcRtHndSideData%MomBNcRtt
IF (ALLOCATED(SrcRtHndSideData%MomH0Bt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%MomH0Bt,1)
  i1_u = UBOUND(SrcRtHndSideData%MomH0Bt,1)
  i2_l = LBOUND(SrcRtHndSideData%MomH0Bt,2)
  i2_u = UBOUND(SrcRtHndSideData%MomH0Bt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%MomH0Bt)) THEN 
    ALLOCATE(DstRtHndSideData%MomH0Bt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MomH0Bt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%MomH0Bt = SrcRtHndSideData%MomH0Bt
ENDIF
    DstRtHndSideData%MomLPRott = SrcRtHndSideData%MomLPRott
    DstRtHndSideData%MomNGnRtt = SrcRtHndSideData%MomNGnRtt
    DstRtHndSideData%MomNTailt = SrcRtHndSideData%MomNTailt
    DstRtHndSideData%MomX0Trbt = SrcRtHndSideData%MomX0Trbt
IF (ALLOCATED(SrcRtHndSideData%MMAero)) THEN
  i1_l = LBOUND(SrcRtHndSideData%MMAero,1)
  i1_u = UBOUND(SrcRtHndSideData%MMAero,1)
  i2_l = LBOUND(SrcRtHndSideData%MMAero,2)
  i2_u = UBOUND(SrcRtHndSideData%MMAero,2)
  i3_l = LBOUND(SrcRtHndSideData%MMAero,3)
  i3_u = UBOUND(SrcRtHndSideData%MMAero,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%MMAero)) THEN 
    ALLOCATE(DstRtHndSideData%MMAero(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%MMAero.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%MMAero = SrcRtHndSideData%MMAero
ENDIF
    DstRtHndSideData%MXHydrot = SrcRtHndSideData%MXHydrot
IF (ALLOCATED(SrcRtHndSideData%PFrcONcRt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcONcRt,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcONcRt,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcONcRt,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcONcRt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcONcRt)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcONcRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcONcRt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcONcRt = SrcRtHndSideData%PFrcONcRt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFrcPRot)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcPRot,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcPRot,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcPRot,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcPRot,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcPRot)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcPRot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcPRot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcPRot = SrcRtHndSideData%PFrcPRot
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFrcS0B)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcS0B,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcS0B,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcS0B,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcS0B,2)
  i3_l = LBOUND(SrcRtHndSideData%PFrcS0B,3)
  i3_u = UBOUND(SrcRtHndSideData%PFrcS0B,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcS0B)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcS0B(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcS0B.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcS0B = SrcRtHndSideData%PFrcS0B
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFrcT0Trb)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcT0Trb,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcT0Trb,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcT0Trb,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcT0Trb,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcT0Trb)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcT0Trb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcT0Trb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcT0Trb = SrcRtHndSideData%PFrcT0Trb
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFTHydro)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFTHydro,1)
  i1_u = UBOUND(SrcRtHndSideData%PFTHydro,1)
  i2_l = LBOUND(SrcRtHndSideData%PFTHydro,2)
  i2_u = UBOUND(SrcRtHndSideData%PFTHydro,2)
  i3_l = LBOUND(SrcRtHndSideData%PFTHydro,3)
  i3_u = UBOUND(SrcRtHndSideData%PFTHydro,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFTHydro)) THEN 
    ALLOCATE(DstRtHndSideData%PFTHydro(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFTHydro.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFTHydro = SrcRtHndSideData%PFTHydro
ENDIF
    DstRtHndSideData%PFZHydro = SrcRtHndSideData%PFZHydro
IF (ALLOCATED(SrcRtHndSideData%PMFHydro)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMFHydro,1)
  i1_u = UBOUND(SrcRtHndSideData%PMFHydro,1)
  i2_l = LBOUND(SrcRtHndSideData%PMFHydro,2)
  i2_u = UBOUND(SrcRtHndSideData%PMFHydro,2)
  i3_l = LBOUND(SrcRtHndSideData%PMFHydro,3)
  i3_u = UBOUND(SrcRtHndSideData%PMFHydro,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMFHydro)) THEN 
    ALLOCATE(DstRtHndSideData%PMFHydro(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMFHydro.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMFHydro = SrcRtHndSideData%PMFHydro
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomBNcRt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomBNcRt,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomBNcRt,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomBNcRt,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomBNcRt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomBNcRt)) THEN 
    ALLOCATE(DstRtHndSideData%PMomBNcRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomBNcRt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomBNcRt = SrcRtHndSideData%PMomBNcRt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomH0B)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomH0B,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomH0B,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomH0B,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomH0B,2)
  i3_l = LBOUND(SrcRtHndSideData%PMomH0B,3)
  i3_u = UBOUND(SrcRtHndSideData%PMomH0B,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomH0B)) THEN 
    ALLOCATE(DstRtHndSideData%PMomH0B(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomH0B.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomH0B = SrcRtHndSideData%PMomH0B
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomLPRot)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomLPRot,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomLPRot,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomLPRot,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomLPRot,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomLPRot)) THEN 
    ALLOCATE(DstRtHndSideData%PMomLPRot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomLPRot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomLPRot = SrcRtHndSideData%PMomLPRot
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomNGnRt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomNGnRt,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomNGnRt,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomNGnRt,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomNGnRt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomNGnRt)) THEN 
    ALLOCATE(DstRtHndSideData%PMomNGnRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomNGnRt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomNGnRt = SrcRtHndSideData%PMomNGnRt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomNTail)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomNTail,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomNTail,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomNTail,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomNTail,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomNTail)) THEN 
    ALLOCATE(DstRtHndSideData%PMomNTail(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomNTail.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomNTail = SrcRtHndSideData%PMomNTail
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomX0Trb)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomX0Trb,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomX0Trb,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomX0Trb,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomX0Trb,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomX0Trb)) THEN 
    ALLOCATE(DstRtHndSideData%PMomX0Trb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomX0Trb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomX0Trb = SrcRtHndSideData%PMomX0Trb
ENDIF
    DstRtHndSideData%PMXHydro = SrcRtHndSideData%PMXHydro
    DstRtHndSideData%TeetAng = SrcRtHndSideData%TeetAng
    DstRtHndSideData%FrcVGnRtt = SrcRtHndSideData%FrcVGnRtt
    DstRtHndSideData%FrcWTailt = SrcRtHndSideData%FrcWTailt
    DstRtHndSideData%FrcZAllt = SrcRtHndSideData%FrcZAllt
    DstRtHndSideData%MomXAllt = SrcRtHndSideData%MomXAllt
IF (ALLOCATED(SrcRtHndSideData%PFrcVGnRt)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcVGnRt,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcVGnRt,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcVGnRt,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcVGnRt,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcVGnRt)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcVGnRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcVGnRt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcVGnRt = SrcRtHndSideData%PFrcVGnRt
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFrcWTail)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcWTail,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcWTail,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcWTail,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcWTail,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcWTail)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcWTail(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcWTail.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcWTail = SrcRtHndSideData%PFrcWTail
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PFrcZAll)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PFrcZAll,1)
  i1_u = UBOUND(SrcRtHndSideData%PFrcZAll,1)
  i2_l = LBOUND(SrcRtHndSideData%PFrcZAll,2)
  i2_u = UBOUND(SrcRtHndSideData%PFrcZAll,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PFrcZAll)) THEN 
    ALLOCATE(DstRtHndSideData%PFrcZAll(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PFrcZAll.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PFrcZAll = SrcRtHndSideData%PFrcZAll
ENDIF
IF (ALLOCATED(SrcRtHndSideData%PMomXAll)) THEN
  i1_l = LBOUND(SrcRtHndSideData%PMomXAll,1)
  i1_u = UBOUND(SrcRtHndSideData%PMomXAll,1)
  i2_l = LBOUND(SrcRtHndSideData%PMomXAll,2)
  i2_u = UBOUND(SrcRtHndSideData%PMomXAll,2)
  IF (.NOT. ALLOCATED(DstRtHndSideData%PMomXAll)) THEN 
    ALLOCATE(DstRtHndSideData%PMomXAll(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%PMomXAll.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%PMomXAll = SrcRtHndSideData%PMomXAll
ENDIF
    DstRtHndSideData%TeetMom = SrcRtHndSideData%TeetMom
    DstRtHndSideData%TFrlMom = SrcRtHndSideData%TFrlMom
    DstRtHndSideData%RFrlMom = SrcRtHndSideData%RFrlMom
    DstRtHndSideData%GBoxEffFac = SrcRtHndSideData%GBoxEffFac
IF (ALLOCATED(SrcRtHndSideData%rSAerCen)) THEN
  i1_l = LBOUND(SrcRtHndSideData%rSAerCen,1)
  i1_u = UBOUND(SrcRtHndSideData%rSAerCen,1)
  i2_l = LBOUND(SrcRtHndSideData%rSAerCen,2)
  i2_u = UBOUND(SrcRtHndSideData%rSAerCen,2)
  i3_l = LBOUND(SrcRtHndSideData%rSAerCen,3)
  i3_u = UBOUND(SrcRtHndSideData%rSAerCen,3)
  IF (.NOT. ALLOCATED(DstRtHndSideData%rSAerCen)) THEN 
    ALLOCATE(DstRtHndSideData%rSAerCen(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstRtHndSideData%rSAerCen.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstRtHndSideData%rSAerCen = SrcRtHndSideData%rSAerCen
ENDIF
 END SUBROUTINE ED_CopyRtHndSide

 SUBROUTINE ED_DestroyRtHndSide( RtHndSideData, ErrStat, ErrMsg )
  TYPE(ED_RtHndSide), INTENT(INOUT) :: RtHndSideData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyRtHndSide'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(RtHndSideData%rQS)) THEN
  DEALLOCATE(RtHndSideData%rQS)
ENDIF
IF (ALLOCATED(RtHndSideData%rS)) THEN
  DEALLOCATE(RtHndSideData%rS)
ENDIF
IF (ALLOCATED(RtHndSideData%rS0S)) THEN
  DEALLOCATE(RtHndSideData%rS0S)
ENDIF
IF (ALLOCATED(RtHndSideData%rT)) THEN
  DEALLOCATE(RtHndSideData%rT)
ENDIF
IF (ALLOCATED(RtHndSideData%rT0T)) THEN
  DEALLOCATE(RtHndSideData%rT0T)
ENDIF
IF (ALLOCATED(RtHndSideData%rZT)) THEN
  DEALLOCATE(RtHndSideData%rZT)
ENDIF
IF (ALLOCATED(RtHndSideData%rPS0)) THEN
  DEALLOCATE(RtHndSideData%rPS0)
ENDIF
IF (ALLOCATED(RtHndSideData%AngPosEF)) THEN
  DEALLOCATE(RtHndSideData%AngPosEF)
ENDIF
IF (ALLOCATED(RtHndSideData%AngPosXF)) THEN
  DEALLOCATE(RtHndSideData%AngPosXF)
ENDIF
IF (ALLOCATED(RtHndSideData%AngPosHM)) THEN
  DEALLOCATE(RtHndSideData%AngPosHM)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEA)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEA)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEF)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEF)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEG)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEG)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEH)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEH)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEL)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEL)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEM)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEM)
ENDIF
IF (ALLOCATED(RtHndSideData%AngVelEM)) THEN
  DEALLOCATE(RtHndSideData%AngVelEM)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEN)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEN)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEB)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEB)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelER)) THEN
  DEALLOCATE(RtHndSideData%PAngVelER)
ENDIF
IF (ALLOCATED(RtHndSideData%PAngVelEX)) THEN
  DEALLOCATE(RtHndSideData%PAngVelEX)
ENDIF
IF (ALLOCATED(RtHndSideData%AngAccEFt)) THEN
  DEALLOCATE(RtHndSideData%AngAccEFt)
ENDIF
IF (ALLOCATED(RtHndSideData%AngVelEF)) THEN
  DEALLOCATE(RtHndSideData%AngVelEF)
ENDIF
IF (ALLOCATED(RtHndSideData%AngVelHM)) THEN
  DEALLOCATE(RtHndSideData%AngVelHM)
ENDIF
IF (ALLOCATED(RtHndSideData%AngAccEKt)) THEN
  DEALLOCATE(RtHndSideData%AngAccEKt)
ENDIF
IF (ALLOCATED(RtHndSideData%LinVelES)) THEN
  DEALLOCATE(RtHndSideData%LinVelES)
ENDIF
IF (ALLOCATED(RtHndSideData%LinVelET)) THEN
  DEALLOCATE(RtHndSideData%LinVelET)
ENDIF
IF (ALLOCATED(RtHndSideData%LinVelESm2)) THEN
  DEALLOCATE(RtHndSideData%LinVelESm2)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEIMU)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEIMU)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEO)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEO)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelES)) THEN
  DEALLOCATE(RtHndSideData%PLinVelES)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelET)) THEN
  DEALLOCATE(RtHndSideData%PLinVelET)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEZ)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEZ)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEC)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEC)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelED)) THEN
  DEALLOCATE(RtHndSideData%PLinVelED)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEI)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEI)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEJ)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEJ)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEK)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEK)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEP)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEP)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEQ)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEQ)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEU)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEU)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEV)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEV)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEW)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEW)
ENDIF
IF (ALLOCATED(RtHndSideData%PLinVelEY)) THEN
  DEALLOCATE(RtHndSideData%PLinVelEY)
ENDIF
IF (ALLOCATED(RtHndSideData%LinAccESt)) THEN
  DEALLOCATE(RtHndSideData%LinAccESt)
ENDIF
IF (ALLOCATED(RtHndSideData%LinAccETt)) THEN
  DEALLOCATE(RtHndSideData%LinAccETt)
ENDIF
IF (ALLOCATED(RtHndSideData%FrcS0Bt)) THEN
  DEALLOCATE(RtHndSideData%FrcS0Bt)
ENDIF
IF (ALLOCATED(RtHndSideData%FSAero)) THEN
  DEALLOCATE(RtHndSideData%FSAero)
ENDIF
IF (ALLOCATED(RtHndSideData%FSTipDrag)) THEN
  DEALLOCATE(RtHndSideData%FSTipDrag)
ENDIF
IF (ALLOCATED(RtHndSideData%FTHydrot)) THEN
  DEALLOCATE(RtHndSideData%FTHydrot)
ENDIF
IF (ALLOCATED(RtHndSideData%MFHydrot)) THEN
  DEALLOCATE(RtHndSideData%MFHydrot)
ENDIF
IF (ALLOCATED(RtHndSideData%MomH0Bt)) THEN
  DEALLOCATE(RtHndSideData%MomH0Bt)
ENDIF
IF (ALLOCATED(RtHndSideData%MMAero)) THEN
  DEALLOCATE(RtHndSideData%MMAero)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcONcRt)) THEN
  DEALLOCATE(RtHndSideData%PFrcONcRt)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcPRot)) THEN
  DEALLOCATE(RtHndSideData%PFrcPRot)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcS0B)) THEN
  DEALLOCATE(RtHndSideData%PFrcS0B)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcT0Trb)) THEN
  DEALLOCATE(RtHndSideData%PFrcT0Trb)
ENDIF
IF (ALLOCATED(RtHndSideData%PFTHydro)) THEN
  DEALLOCATE(RtHndSideData%PFTHydro)
ENDIF
IF (ALLOCATED(RtHndSideData%PMFHydro)) THEN
  DEALLOCATE(RtHndSideData%PMFHydro)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomBNcRt)) THEN
  DEALLOCATE(RtHndSideData%PMomBNcRt)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomH0B)) THEN
  DEALLOCATE(RtHndSideData%PMomH0B)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomLPRot)) THEN
  DEALLOCATE(RtHndSideData%PMomLPRot)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomNGnRt)) THEN
  DEALLOCATE(RtHndSideData%PMomNGnRt)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomNTail)) THEN
  DEALLOCATE(RtHndSideData%PMomNTail)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomX0Trb)) THEN
  DEALLOCATE(RtHndSideData%PMomX0Trb)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcVGnRt)) THEN
  DEALLOCATE(RtHndSideData%PFrcVGnRt)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcWTail)) THEN
  DEALLOCATE(RtHndSideData%PFrcWTail)
ENDIF
IF (ALLOCATED(RtHndSideData%PFrcZAll)) THEN
  DEALLOCATE(RtHndSideData%PFrcZAll)
ENDIF
IF (ALLOCATED(RtHndSideData%PMomXAll)) THEN
  DEALLOCATE(RtHndSideData%PMomXAll)
ENDIF
IF (ALLOCATED(RtHndSideData%rSAerCen)) THEN
  DEALLOCATE(RtHndSideData%rSAerCen)
ENDIF
 END SUBROUTINE ED_DestroyRtHndSide

 SUBROUTINE ED_PackRtHndSide( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_RtHndSide),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackRtHndSide'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + SIZE(InData%rO)  ! rO
  Int_BufSz   = Int_BufSz   + 1     ! rQS allocated yes/no
  IF ( ALLOCATED(InData%rQS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rQS upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rQS)  ! rQS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rS allocated yes/no
  IF ( ALLOCATED(InData%rS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rS upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rS)  ! rS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rS0S allocated yes/no
  IF ( ALLOCATED(InData%rS0S) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rS0S upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rS0S)  ! rS0S
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rT allocated yes/no
  IF ( ALLOCATED(InData%rT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rT upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rT)  ! rT
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%rT0O)  ! rT0O
  Int_BufSz   = Int_BufSz   + 1     ! rT0T allocated yes/no
  IF ( ALLOCATED(InData%rT0T) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rT0T upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rT0T)  ! rT0T
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%rZ)  ! rZ
      Db_BufSz   = Db_BufSz   + SIZE(InData%rZO)  ! rZO
  Int_BufSz   = Int_BufSz   + 1     ! rZT allocated yes/no
  IF ( ALLOCATED(InData%rZT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rZT upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rZT)  ! rZT
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%rPQ)  ! rPQ
      Db_BufSz   = Db_BufSz   + SIZE(InData%rP)  ! rP
      Db_BufSz   = Db_BufSz   + SIZE(InData%rV)  ! rV
      Db_BufSz   = Db_BufSz   + SIZE(InData%rZY)  ! rZY
      Db_BufSz   = Db_BufSz   + SIZE(InData%rOU)  ! rOU
      Db_BufSz   = Db_BufSz   + SIZE(InData%rOV)  ! rOV
      Db_BufSz   = Db_BufSz   + SIZE(InData%rVD)  ! rVD
      Db_BufSz   = Db_BufSz   + SIZE(InData%rOW)  ! rOW
      Db_BufSz   = Db_BufSz   + SIZE(InData%rPC)  ! rPC
  Int_BufSz   = Int_BufSz   + 1     ! rPS0 allocated yes/no
  IF ( ALLOCATED(InData%rPS0) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rPS0 upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%rPS0)  ! rPS0
  END IF
      Db_BufSz   = Db_BufSz   + SIZE(InData%rQ)  ! rQ
      Db_BufSz   = Db_BufSz   + SIZE(InData%rQC)  ! rQC
      Db_BufSz   = Db_BufSz   + SIZE(InData%rVIMU)  ! rVIMU
      Db_BufSz   = Db_BufSz   + SIZE(InData%rVP)  ! rVP
      Db_BufSz   = Db_BufSz   + SIZE(InData%rWI)  ! rWI
      Db_BufSz   = Db_BufSz   + SIZE(InData%rWJ)  ! rWJ
      Db_BufSz   = Db_BufSz   + SIZE(InData%rWK)  ! rWK
      Db_BufSz   = Db_BufSz   + SIZE(InData%rZT0)  ! rZT0
  Int_BufSz   = Int_BufSz   + 1     ! AngPosEF allocated yes/no
  IF ( ALLOCATED(InData%AngPosEF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AngPosEF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngPosEF)  ! AngPosEF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AngPosXF allocated yes/no
  IF ( ALLOCATED(InData%AngPosXF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AngPosXF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngPosXF)  ! AngPosXF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AngPosHM allocated yes/no
  IF ( ALLOCATED(InData%AngPosHM) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AngPosHM upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngPosHM)  ! AngPosHM
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngPosXB)  ! AngPosXB
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngPosEX)  ! AngPosEX
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEA allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEA)  ! PAngVelEA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEF allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! PAngVelEF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEF)  ! PAngVelEF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEG allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEG)  ! PAngVelEG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEH allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEH) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEH upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEH)  ! PAngVelEH
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEL allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEL)  ! PAngVelEL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEM allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEM) ) THEN
    Int_BufSz   = Int_BufSz   + 2*5  ! PAngVelEM upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEM)  ! PAngVelEM
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AngVelEM allocated yes/no
  IF ( ALLOCATED(InData%AngVelEM) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AngVelEM upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEM)  ! AngVelEM
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEN allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEN) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEN upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEN)  ! PAngVelEN
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEA)  ! AngVelEA
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEB allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEB) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEB upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEB)  ! PAngVelEB
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelER allocated yes/no
  IF ( ALLOCATED(InData%PAngVelER) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelER upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelER)  ! PAngVelER
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PAngVelEX allocated yes/no
  IF ( ALLOCATED(InData%PAngVelEX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PAngVelEX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PAngVelEX)  ! PAngVelEX
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEG)  ! AngVelEG
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEH)  ! AngVelEH
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEL)  ! AngVelEL
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEN)  ! AngVelEN
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEB)  ! AngVelEB
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelER)  ! AngVelER
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEX)  ! AngVelEX
      Db_BufSz   = Db_BufSz   + 1  ! TeetAngVel
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEBt)  ! AngAccEBt
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccERt)  ! AngAccERt
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEXt)  ! AngAccEXt
  Int_BufSz   = Int_BufSz   + 1     ! AngAccEFt allocated yes/no
  IF ( ALLOCATED(InData%AngAccEFt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AngAccEFt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEFt)  ! AngAccEFt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AngVelEF allocated yes/no
  IF ( ALLOCATED(InData%AngVelEF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AngVelEF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelEF)  ! AngVelEF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AngVelHM allocated yes/no
  IF ( ALLOCATED(InData%AngVelHM) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AngVelHM upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngVelHM)  ! AngVelHM
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEAt)  ! AngAccEAt
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEGt)  ! AngAccEGt
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEHt)  ! AngAccEHt
  Int_BufSz   = Int_BufSz   + 1     ! AngAccEKt allocated yes/no
  IF ( ALLOCATED(InData%AngAccEKt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AngAccEKt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccEKt)  ! AngAccEKt
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%AngAccENt)  ! AngAccENt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccECt)  ! LinAccECt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEDt)  ! LinAccEDt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEIt)  ! LinAccEIt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEJt)  ! LinAccEJt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEUt)  ! LinAccEUt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEYt)  ! LinAccEYt
  Int_BufSz   = Int_BufSz   + 1     ! LinVelES allocated yes/no
  IF ( ALLOCATED(InData%LinVelES) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! LinVelES upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelES)  ! LinVelES
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelEQ)  ! LinVelEQ
  Int_BufSz   = Int_BufSz   + 1     ! LinVelET allocated yes/no
  IF ( ALLOCATED(InData%LinVelET) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! LinVelET upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelET)  ! LinVelET
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LinVelESm2 allocated yes/no
  IF ( ALLOCATED(InData%LinVelESm2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! LinVelESm2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelESm2)  ! LinVelESm2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEIMU allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEIMU) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEIMU upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEIMU)  ! PLinVelEIMU
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEO allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEO) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEO upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEO)  ! PLinVelEO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelES allocated yes/no
  IF ( ALLOCATED(InData%PLinVelES) ) THEN
    Int_BufSz   = Int_BufSz   + 2*5  ! PLinVelES upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelES)  ! PLinVelES
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelET allocated yes/no
  IF ( ALLOCATED(InData%PLinVelET) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! PLinVelET upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelET)  ! PLinVelET
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEZ allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEZ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEZ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEZ)  ! PLinVelEZ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEC allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEC upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEC)  ! PLinVelEC
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelED allocated yes/no
  IF ( ALLOCATED(InData%PLinVelED) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelED upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelED)  ! PLinVelED
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEI allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEI) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEI upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEI)  ! PLinVelEI
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEJ allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEJ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEJ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEJ)  ! PLinVelEJ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEK allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEK) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEK upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEK)  ! PLinVelEK
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEP allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEP)  ! PLinVelEP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEQ allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEQ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEQ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEQ)  ! PLinVelEQ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEU allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEU) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEU upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEU)  ! PLinVelEU
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEV allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEV) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEV upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEV)  ! PLinVelEV
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEW allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEW)  ! PLinVelEW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PLinVelEY allocated yes/no
  IF ( ALLOCATED(InData%PLinVelEY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PLinVelEY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PLinVelEY)  ! PLinVelEY
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEIMUt)  ! LinAccEIMUt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEOt)  ! LinAccEOt
  Int_BufSz   = Int_BufSz   + 1     ! LinAccESt allocated yes/no
  IF ( ALLOCATED(InData%LinAccESt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! LinAccESt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccESt)  ! LinAccESt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LinAccETt allocated yes/no
  IF ( ALLOCATED(InData%LinAccETt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! LinAccETt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccETt)  ! LinAccETt
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinAccEZt)  ! LinAccEZt
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelEIMU)  ! LinVelEIMU
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelEZ)  ! LinVelEZ
      Re_BufSz   = Re_BufSz   + SIZE(InData%LinVelEO)  ! LinVelEO
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcONcRtt)  ! FrcONcRtt
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcPRott)  ! FrcPRott
  Int_BufSz   = Int_BufSz   + 1     ! FrcS0Bt allocated yes/no
  IF ( ALLOCATED(InData%FrcS0Bt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FrcS0Bt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcS0Bt)  ! FrcS0Bt
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcT0Trbt)  ! FrcT0Trbt
  Int_BufSz   = Int_BufSz   + 1     ! FSAero allocated yes/no
  IF ( ALLOCATED(InData%FSAero) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! FSAero upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FSAero)  ! FSAero
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FSTipDrag allocated yes/no
  IF ( ALLOCATED(InData%FSTipDrag) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FSTipDrag upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FSTipDrag)  ! FSTipDrag
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FTHydrot allocated yes/no
  IF ( ALLOCATED(InData%FTHydrot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FTHydrot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FTHydrot)  ! FTHydrot
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%FZHydrot)  ! FZHydrot
  Int_BufSz   = Int_BufSz   + 1     ! MFHydrot allocated yes/no
  IF ( ALLOCATED(InData%MFHydrot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! MFHydrot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MFHydrot)  ! MFHydrot
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomBNcRtt)  ! MomBNcRtt
  Int_BufSz   = Int_BufSz   + 1     ! MomH0Bt allocated yes/no
  IF ( ALLOCATED(InData%MomH0Bt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! MomH0Bt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomH0Bt)  ! MomH0Bt
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomLPRott)  ! MomLPRott
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomNGnRtt)  ! MomNGnRtt
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomNTailt)  ! MomNTailt
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomX0Trbt)  ! MomX0Trbt
  Int_BufSz   = Int_BufSz   + 1     ! MMAero allocated yes/no
  IF ( ALLOCATED(InData%MMAero) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! MMAero upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MMAero)  ! MMAero
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%MXHydrot)  ! MXHydrot
  Int_BufSz   = Int_BufSz   + 1     ! PFrcONcRt allocated yes/no
  IF ( ALLOCATED(InData%PFrcONcRt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcONcRt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcONcRt)  ! PFrcONcRt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFrcPRot allocated yes/no
  IF ( ALLOCATED(InData%PFrcPRot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcPRot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcPRot)  ! PFrcPRot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFrcS0B allocated yes/no
  IF ( ALLOCATED(InData%PFrcS0B) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PFrcS0B upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcS0B)  ! PFrcS0B
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFrcT0Trb allocated yes/no
  IF ( ALLOCATED(InData%PFrcT0Trb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcT0Trb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcT0Trb)  ! PFrcT0Trb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFTHydro allocated yes/no
  IF ( ALLOCATED(InData%PFTHydro) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PFTHydro upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFTHydro)  ! PFTHydro
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFZHydro)  ! PFZHydro
  Int_BufSz   = Int_BufSz   + 1     ! PMFHydro allocated yes/no
  IF ( ALLOCATED(InData%PMFHydro) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PMFHydro upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMFHydro)  ! PMFHydro
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomBNcRt allocated yes/no
  IF ( ALLOCATED(InData%PMomBNcRt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomBNcRt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomBNcRt)  ! PMomBNcRt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomH0B allocated yes/no
  IF ( ALLOCATED(InData%PMomH0B) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! PMomH0B upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomH0B)  ! PMomH0B
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomLPRot allocated yes/no
  IF ( ALLOCATED(InData%PMomLPRot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomLPRot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomLPRot)  ! PMomLPRot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomNGnRt allocated yes/no
  IF ( ALLOCATED(InData%PMomNGnRt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomNGnRt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomNGnRt)  ! PMomNGnRt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomNTail allocated yes/no
  IF ( ALLOCATED(InData%PMomNTail) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomNTail upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomNTail)  ! PMomNTail
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomX0Trb allocated yes/no
  IF ( ALLOCATED(InData%PMomX0Trb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomX0Trb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomX0Trb)  ! PMomX0Trb
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMXHydro)  ! PMXHydro
      Db_BufSz   = Db_BufSz   + 1  ! TeetAng
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcVGnRtt)  ! FrcVGnRtt
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcWTailt)  ! FrcWTailt
      Re_BufSz   = Re_BufSz   + SIZE(InData%FrcZAllt)  ! FrcZAllt
      Re_BufSz   = Re_BufSz   + SIZE(InData%MomXAllt)  ! MomXAllt
  Int_BufSz   = Int_BufSz   + 1     ! PFrcVGnRt allocated yes/no
  IF ( ALLOCATED(InData%PFrcVGnRt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcVGnRt upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcVGnRt)  ! PFrcVGnRt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFrcWTail allocated yes/no
  IF ( ALLOCATED(InData%PFrcWTail) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcWTail upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcWTail)  ! PFrcWTail
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PFrcZAll allocated yes/no
  IF ( ALLOCATED(InData%PFrcZAll) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PFrcZAll upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PFrcZAll)  ! PFrcZAll
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PMomXAll allocated yes/no
  IF ( ALLOCATED(InData%PMomXAll) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PMomXAll upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PMomXAll)  ! PMomXAll
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! TeetMom
      Re_BufSz   = Re_BufSz   + 1  ! TFrlMom
      Re_BufSz   = Re_BufSz   + 1  ! RFrlMom
      Re_BufSz   = Re_BufSz   + 1  ! GBoxEffFac
  Int_BufSz   = Int_BufSz   + 1     ! rSAerCen allocated yes/no
  IF ( ALLOCATED(InData%rSAerCen) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rSAerCen upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rSAerCen)  ! rSAerCen
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i1 = LBOUND(InData%rO,1), UBOUND(InData%rO,1)
      DbKiBuf(Db_Xferred) = InData%rO(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%rQS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rQS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rQS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rQS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rQS,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rQS,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rQS,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rQS,3), UBOUND(InData%rQS,3)
        DO i2 = LBOUND(InData%rQS,2), UBOUND(InData%rQS,2)
          DO i1 = LBOUND(InData%rQS,1), UBOUND(InData%rQS,1)
            DbKiBuf(Db_Xferred) = InData%rQS(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rS,3), UBOUND(InData%rS,3)
        DO i2 = LBOUND(InData%rS,2), UBOUND(InData%rS,2)
          DO i1 = LBOUND(InData%rS,1), UBOUND(InData%rS,1)
            DbKiBuf(Db_Xferred) = InData%rS(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rS0S) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS0S,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS0S,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS0S,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS0S,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rS0S,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rS0S,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rS0S,3), UBOUND(InData%rS0S,3)
        DO i2 = LBOUND(InData%rS0S,2), UBOUND(InData%rS0S,2)
          DO i1 = LBOUND(InData%rS0S,1), UBOUND(InData%rS0S,1)
            DbKiBuf(Db_Xferred) = InData%rS0S(i1,i2,i3)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rT,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rT,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rT,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rT,2), UBOUND(InData%rT,2)
        DO i1 = LBOUND(InData%rT,1), UBOUND(InData%rT,1)
          DbKiBuf(Db_Xferred) = InData%rT(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%rT0O,1), UBOUND(InData%rT0O,1)
      DbKiBuf(Db_Xferred) = InData%rT0O(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%rT0T) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rT0T,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rT0T,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rT0T,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rT0T,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rT0T,2), UBOUND(InData%rT0T,2)
        DO i1 = LBOUND(InData%rT0T,1), UBOUND(InData%rT0T,1)
          DbKiBuf(Db_Xferred) = InData%rT0T(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%rZ,1), UBOUND(InData%rZ,1)
      DbKiBuf(Db_Xferred) = InData%rZ(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rZO,1), UBOUND(InData%rZO,1)
      DbKiBuf(Db_Xferred) = InData%rZO(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%rZT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rZT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rZT,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rZT,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rZT,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rZT,2), UBOUND(InData%rZT,2)
        DO i1 = LBOUND(InData%rZT,1), UBOUND(InData%rZT,1)
          DbKiBuf(Db_Xferred) = InData%rZT(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%rPQ,1), UBOUND(InData%rPQ,1)
      DbKiBuf(Db_Xferred) = InData%rPQ(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rP,1), UBOUND(InData%rP,1)
      DbKiBuf(Db_Xferred) = InData%rP(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rV,1), UBOUND(InData%rV,1)
      DbKiBuf(Db_Xferred) = InData%rV(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rZY,1), UBOUND(InData%rZY,1)
      DbKiBuf(Db_Xferred) = InData%rZY(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rOU,1), UBOUND(InData%rOU,1)
      DbKiBuf(Db_Xferred) = InData%rOU(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rOV,1), UBOUND(InData%rOV,1)
      DbKiBuf(Db_Xferred) = InData%rOV(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rVD,1), UBOUND(InData%rVD,1)
      DbKiBuf(Db_Xferred) = InData%rVD(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rOW,1), UBOUND(InData%rOW,1)
      DbKiBuf(Db_Xferred) = InData%rOW(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rPC,1), UBOUND(InData%rPC,1)
      DbKiBuf(Db_Xferred) = InData%rPC(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%rPS0) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rPS0,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rPS0,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rPS0,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rPS0,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rPS0,2), UBOUND(InData%rPS0,2)
        DO i1 = LBOUND(InData%rPS0,1), UBOUND(InData%rPS0,1)
          DbKiBuf(Db_Xferred) = InData%rPS0(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%rQ,1), UBOUND(InData%rQ,1)
      DbKiBuf(Db_Xferred) = InData%rQ(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rQC,1), UBOUND(InData%rQC,1)
      DbKiBuf(Db_Xferred) = InData%rQC(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rVIMU,1), UBOUND(InData%rVIMU,1)
      DbKiBuf(Db_Xferred) = InData%rVIMU(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rVP,1), UBOUND(InData%rVP,1)
      DbKiBuf(Db_Xferred) = InData%rVP(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rWI,1), UBOUND(InData%rWI,1)
      DbKiBuf(Db_Xferred) = InData%rWI(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rWJ,1), UBOUND(InData%rWJ,1)
      DbKiBuf(Db_Xferred) = InData%rWJ(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rWK,1), UBOUND(InData%rWK,1)
      DbKiBuf(Db_Xferred) = InData%rWK(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%rZT0,1), UBOUND(InData%rZT0,1)
      DbKiBuf(Db_Xferred) = InData%rZT0(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%AngPosEF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosEF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosEF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosEF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosEF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AngPosEF,2), UBOUND(InData%AngPosEF,2)
        DO i1 = LBOUND(InData%AngPosEF,1), UBOUND(InData%AngPosEF,1)
          ReKiBuf(Re_Xferred) = InData%AngPosEF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AngPosXF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosXF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosXF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosXF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosXF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AngPosXF,2), UBOUND(InData%AngPosXF,2)
        DO i1 = LBOUND(InData%AngPosXF,1), UBOUND(InData%AngPosXF,1)
          ReKiBuf(Re_Xferred) = InData%AngPosXF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AngPosHM) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosHM,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosHM,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosHM,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosHM,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngPosHM,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngPosHM,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AngPosHM,3), UBOUND(InData%AngPosHM,3)
        DO i2 = LBOUND(InData%AngPosHM,2), UBOUND(InData%AngPosHM,2)
          DO i1 = LBOUND(InData%AngPosHM,1), UBOUND(InData%AngPosHM,1)
            ReKiBuf(Re_Xferred) = InData%AngPosHM(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%AngPosXB,1), UBOUND(InData%AngPosXB,1)
      ReKiBuf(Re_Xferred) = InData%AngPosXB(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngPosEX,1), UBOUND(InData%AngPosEX,1)
      ReKiBuf(Re_Xferred) = InData%AngPosEX(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%PAngVelEA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEA,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEA,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEA,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEA,3), UBOUND(InData%PAngVelEA,3)
        DO i2 = LBOUND(InData%PAngVelEA,2), UBOUND(InData%PAngVelEA,2)
          DO i1 = LBOUND(InData%PAngVelEA,1), UBOUND(InData%PAngVelEA,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEA(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEF,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEF,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEF,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%PAngVelEF,4), UBOUND(InData%PAngVelEF,4)
        DO i3 = LBOUND(InData%PAngVelEF,3), UBOUND(InData%PAngVelEF,3)
          DO i2 = LBOUND(InData%PAngVelEF,2), UBOUND(InData%PAngVelEF,2)
            DO i1 = LBOUND(InData%PAngVelEF,1), UBOUND(InData%PAngVelEF,1)
              ReKiBuf(Re_Xferred) = InData%PAngVelEF(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEG,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEG,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEG,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEG,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEG,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEG,3), UBOUND(InData%PAngVelEG,3)
        DO i2 = LBOUND(InData%PAngVelEG,2), UBOUND(InData%PAngVelEG,2)
          DO i1 = LBOUND(InData%PAngVelEG,1), UBOUND(InData%PAngVelEG,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEG(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEH) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEH,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEH,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEH,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEH,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEH,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEH,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEH,3), UBOUND(InData%PAngVelEH,3)
        DO i2 = LBOUND(InData%PAngVelEH,2), UBOUND(InData%PAngVelEH,2)
          DO i1 = LBOUND(InData%PAngVelEH,1), UBOUND(InData%PAngVelEH,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEH(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEL,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEL,3), UBOUND(InData%PAngVelEL,3)
        DO i2 = LBOUND(InData%PAngVelEL,2), UBOUND(InData%PAngVelEL,2)
          DO i1 = LBOUND(InData%PAngVelEL,1), UBOUND(InData%PAngVelEL,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEL(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEM) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEM,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEM,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEM,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEM,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEM,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEM,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEM,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEM,4)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEM,5)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEM,5)
    Int_Xferred = Int_Xferred + 2

      DO i5 = LBOUND(InData%PAngVelEM,5), UBOUND(InData%PAngVelEM,5)
        DO i4 = LBOUND(InData%PAngVelEM,4), UBOUND(InData%PAngVelEM,4)
          DO i3 = LBOUND(InData%PAngVelEM,3), UBOUND(InData%PAngVelEM,3)
            DO i2 = LBOUND(InData%PAngVelEM,2), UBOUND(InData%PAngVelEM,2)
              DO i1 = LBOUND(InData%PAngVelEM,1), UBOUND(InData%PAngVelEM,1)
                ReKiBuf(Re_Xferred) = InData%PAngVelEM(i1,i2,i3,i4,i5)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AngVelEM) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelEM,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelEM,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelEM,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelEM,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelEM,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelEM,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AngVelEM,3), UBOUND(InData%AngVelEM,3)
        DO i2 = LBOUND(InData%AngVelEM,2), UBOUND(InData%AngVelEM,2)
          DO i1 = LBOUND(InData%AngVelEM,1), UBOUND(InData%AngVelEM,1)
            ReKiBuf(Re_Xferred) = InData%AngVelEM(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEN) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEN,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEN,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEN,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEN,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEN,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEN,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEN,3), UBOUND(InData%PAngVelEN,3)
        DO i2 = LBOUND(InData%PAngVelEN,2), UBOUND(InData%PAngVelEN,2)
          DO i1 = LBOUND(InData%PAngVelEN,1), UBOUND(InData%PAngVelEN,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEN(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%AngVelEA,1), UBOUND(InData%AngVelEA,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEA(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%PAngVelEB) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEB,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEB,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEB,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEB,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEB,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEB,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEB,3), UBOUND(InData%PAngVelEB,3)
        DO i2 = LBOUND(InData%PAngVelEB,2), UBOUND(InData%PAngVelEB,2)
          DO i1 = LBOUND(InData%PAngVelEB,1), UBOUND(InData%PAngVelEB,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEB(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelER) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelER,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelER,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelER,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelER,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelER,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelER,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelER,3), UBOUND(InData%PAngVelER,3)
        DO i2 = LBOUND(InData%PAngVelER,2), UBOUND(InData%PAngVelER,2)
          DO i1 = LBOUND(InData%PAngVelER,1), UBOUND(InData%PAngVelER,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelER(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PAngVelEX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEX,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEX,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEX,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PAngVelEX,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PAngVelEX,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PAngVelEX,3), UBOUND(InData%PAngVelEX,3)
        DO i2 = LBOUND(InData%PAngVelEX,2), UBOUND(InData%PAngVelEX,2)
          DO i1 = LBOUND(InData%PAngVelEX,1), UBOUND(InData%PAngVelEX,1)
            ReKiBuf(Re_Xferred) = InData%PAngVelEX(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%AngVelEG,1), UBOUND(InData%AngVelEG,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEG(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelEH,1), UBOUND(InData%AngVelEH,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEH(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelEL,1), UBOUND(InData%AngVelEL,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEL(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelEN,1), UBOUND(InData%AngVelEN,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEN(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelEB,1), UBOUND(InData%AngVelEB,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEB(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelER,1), UBOUND(InData%AngVelER,1)
      ReKiBuf(Re_Xferred) = InData%AngVelER(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngVelEX,1), UBOUND(InData%AngVelEX,1)
      ReKiBuf(Re_Xferred) = InData%AngVelEX(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DbKiBuf(Db_Xferred) = InData%TeetAngVel
    Db_Xferred = Db_Xferred + 1
    DO i1 = LBOUND(InData%AngAccEBt,1), UBOUND(InData%AngAccEBt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccEBt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngAccERt,1), UBOUND(InData%AngAccERt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccERt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngAccEXt,1), UBOUND(InData%AngAccEXt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccEXt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%AngAccEFt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngAccEFt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngAccEFt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngAccEFt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngAccEFt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AngAccEFt,2), UBOUND(InData%AngAccEFt,2)
        DO i1 = LBOUND(InData%AngAccEFt,1), UBOUND(InData%AngAccEFt,1)
          ReKiBuf(Re_Xferred) = InData%AngAccEFt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AngVelEF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelEF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelEF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelEF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelEF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AngVelEF,2), UBOUND(InData%AngVelEF,2)
        DO i1 = LBOUND(InData%AngVelEF,1), UBOUND(InData%AngVelEF,1)
          ReKiBuf(Re_Xferred) = InData%AngVelEF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AngVelHM) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelHM,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelHM,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelHM,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelHM,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngVelHM,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngVelHM,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AngVelHM,3), UBOUND(InData%AngVelHM,3)
        DO i2 = LBOUND(InData%AngVelHM,2), UBOUND(InData%AngVelHM,2)
          DO i1 = LBOUND(InData%AngVelHM,1), UBOUND(InData%AngVelHM,1)
            ReKiBuf(Re_Xferred) = InData%AngVelHM(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%AngAccEAt,1), UBOUND(InData%AngAccEAt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccEAt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngAccEGt,1), UBOUND(InData%AngAccEGt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccEGt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%AngAccEHt,1), UBOUND(InData%AngAccEHt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccEHt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%AngAccEKt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngAccEKt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngAccEKt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngAccEKt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngAccEKt,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AngAccEKt,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AngAccEKt,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AngAccEKt,3), UBOUND(InData%AngAccEKt,3)
        DO i2 = LBOUND(InData%AngAccEKt,2), UBOUND(InData%AngAccEKt,2)
          DO i1 = LBOUND(InData%AngAccEKt,1), UBOUND(InData%AngAccEKt,1)
            ReKiBuf(Re_Xferred) = InData%AngAccEKt(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%AngAccENt,1), UBOUND(InData%AngAccENt,1)
      ReKiBuf(Re_Xferred) = InData%AngAccENt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccECt,1), UBOUND(InData%LinAccECt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccECt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEDt,1), UBOUND(InData%LinAccEDt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEDt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEIt,1), UBOUND(InData%LinAccEIt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEIt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEJt,1), UBOUND(InData%LinAccEJt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEJt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEUt,1), UBOUND(InData%LinAccEUt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEUt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEYt,1), UBOUND(InData%LinAccEYt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEYt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%LinVelES) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelES,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelES,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelES,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelES,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelES,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelES,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%LinVelES,3), UBOUND(InData%LinVelES,3)
        DO i2 = LBOUND(InData%LinVelES,2), UBOUND(InData%LinVelES,2)
          DO i1 = LBOUND(InData%LinVelES,1), UBOUND(InData%LinVelES,1)
            ReKiBuf(Re_Xferred) = InData%LinVelES(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%LinVelEQ,1), UBOUND(InData%LinVelEQ,1)
      ReKiBuf(Re_Xferred) = InData%LinVelEQ(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%LinVelET) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelET,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelET,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelET,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelET,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%LinVelET,2), UBOUND(InData%LinVelET,2)
        DO i1 = LBOUND(InData%LinVelET,1), UBOUND(InData%LinVelET,1)
          ReKiBuf(Re_Xferred) = InData%LinVelET(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LinVelESm2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinVelESm2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinVelESm2,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%LinVelESm2,1), UBOUND(InData%LinVelESm2,1)
        ReKiBuf(Re_Xferred) = InData%LinVelESm2(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEIMU) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEIMU,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEIMU,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEIMU,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEIMU,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEIMU,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEIMU,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEIMU,3), UBOUND(InData%PLinVelEIMU,3)
        DO i2 = LBOUND(InData%PLinVelEIMU,2), UBOUND(InData%PLinVelEIMU,2)
          DO i1 = LBOUND(InData%PLinVelEIMU,1), UBOUND(InData%PLinVelEIMU,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEIMU(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEO) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEO,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEO,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEO,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEO,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEO,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEO,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEO,3), UBOUND(InData%PLinVelEO,3)
        DO i2 = LBOUND(InData%PLinVelEO,2), UBOUND(InData%PLinVelEO,2)
          DO i1 = LBOUND(InData%PLinVelEO,1), UBOUND(InData%PLinVelEO,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEO(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelES) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelES,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelES,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelES,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelES,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelES,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelES,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelES,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelES,4)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelES,5)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelES,5)
    Int_Xferred = Int_Xferred + 2

      DO i5 = LBOUND(InData%PLinVelES,5), UBOUND(InData%PLinVelES,5)
        DO i4 = LBOUND(InData%PLinVelES,4), UBOUND(InData%PLinVelES,4)
          DO i3 = LBOUND(InData%PLinVelES,3), UBOUND(InData%PLinVelES,3)
            DO i2 = LBOUND(InData%PLinVelES,2), UBOUND(InData%PLinVelES,2)
              DO i1 = LBOUND(InData%PLinVelES,1), UBOUND(InData%PLinVelES,1)
                ReKiBuf(Re_Xferred) = InData%PLinVelES(i1,i2,i3,i4,i5)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelET) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelET,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelET,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelET,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelET,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelET,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelET,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelET,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelET,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%PLinVelET,4), UBOUND(InData%PLinVelET,4)
        DO i3 = LBOUND(InData%PLinVelET,3), UBOUND(InData%PLinVelET,3)
          DO i2 = LBOUND(InData%PLinVelET,2), UBOUND(InData%PLinVelET,2)
            DO i1 = LBOUND(InData%PLinVelET,1), UBOUND(InData%PLinVelET,1)
              ReKiBuf(Re_Xferred) = InData%PLinVelET(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEZ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEZ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEZ,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEZ,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEZ,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEZ,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEZ,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEZ,3), UBOUND(InData%PLinVelEZ,3)
        DO i2 = LBOUND(InData%PLinVelEZ,2), UBOUND(InData%PLinVelEZ,2)
          DO i1 = LBOUND(InData%PLinVelEZ,1), UBOUND(InData%PLinVelEZ,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEZ(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEC,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEC,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEC,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEC,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEC,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEC,3), UBOUND(InData%PLinVelEC,3)
        DO i2 = LBOUND(InData%PLinVelEC,2), UBOUND(InData%PLinVelEC,2)
          DO i1 = LBOUND(InData%PLinVelEC,1), UBOUND(InData%PLinVelEC,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEC(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelED) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelED,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelED,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelED,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelED,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelED,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelED,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelED,3), UBOUND(InData%PLinVelED,3)
        DO i2 = LBOUND(InData%PLinVelED,2), UBOUND(InData%PLinVelED,2)
          DO i1 = LBOUND(InData%PLinVelED,1), UBOUND(InData%PLinVelED,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelED(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEI) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEI,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEI,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEI,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEI,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEI,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEI,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEI,3), UBOUND(InData%PLinVelEI,3)
        DO i2 = LBOUND(InData%PLinVelEI,2), UBOUND(InData%PLinVelEI,2)
          DO i1 = LBOUND(InData%PLinVelEI,1), UBOUND(InData%PLinVelEI,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEI(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEJ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEJ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEJ,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEJ,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEJ,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEJ,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEJ,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEJ,3), UBOUND(InData%PLinVelEJ,3)
        DO i2 = LBOUND(InData%PLinVelEJ,2), UBOUND(InData%PLinVelEJ,2)
          DO i1 = LBOUND(InData%PLinVelEJ,1), UBOUND(InData%PLinVelEJ,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEJ(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEK) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEK,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEK,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEK,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEK,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEK,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEK,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEK,3), UBOUND(InData%PLinVelEK,3)
        DO i2 = LBOUND(InData%PLinVelEK,2), UBOUND(InData%PLinVelEK,2)
          DO i1 = LBOUND(InData%PLinVelEK,1), UBOUND(InData%PLinVelEK,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEK(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEP,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEP,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEP,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEP,3), UBOUND(InData%PLinVelEP,3)
        DO i2 = LBOUND(InData%PLinVelEP,2), UBOUND(InData%PLinVelEP,2)
          DO i1 = LBOUND(InData%PLinVelEP,1), UBOUND(InData%PLinVelEP,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEP(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEQ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEQ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEQ,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEQ,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEQ,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEQ,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEQ,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEQ,3), UBOUND(InData%PLinVelEQ,3)
        DO i2 = LBOUND(InData%PLinVelEQ,2), UBOUND(InData%PLinVelEQ,2)
          DO i1 = LBOUND(InData%PLinVelEQ,1), UBOUND(InData%PLinVelEQ,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEQ(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEU) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEU,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEU,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEU,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEU,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEU,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEU,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEU,3), UBOUND(InData%PLinVelEU,3)
        DO i2 = LBOUND(InData%PLinVelEU,2), UBOUND(InData%PLinVelEU,2)
          DO i1 = LBOUND(InData%PLinVelEU,1), UBOUND(InData%PLinVelEU,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEU(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEV) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEV,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEV,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEV,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEV,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEV,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEV,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEV,3), UBOUND(InData%PLinVelEV,3)
        DO i2 = LBOUND(InData%PLinVelEV,2), UBOUND(InData%PLinVelEV,2)
          DO i1 = LBOUND(InData%PLinVelEV,1), UBOUND(InData%PLinVelEV,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEV(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEW,3), UBOUND(InData%PLinVelEW,3)
        DO i2 = LBOUND(InData%PLinVelEW,2), UBOUND(InData%PLinVelEW,2)
          DO i1 = LBOUND(InData%PLinVelEW,1), UBOUND(InData%PLinVelEW,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PLinVelEY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEY,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEY,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEY,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PLinVelEY,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PLinVelEY,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PLinVelEY,3), UBOUND(InData%PLinVelEY,3)
        DO i2 = LBOUND(InData%PLinVelEY,2), UBOUND(InData%PLinVelEY,2)
          DO i1 = LBOUND(InData%PLinVelEY,1), UBOUND(InData%PLinVelEY,1)
            ReKiBuf(Re_Xferred) = InData%PLinVelEY(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%LinAccEIMUt,1), UBOUND(InData%LinAccEIMUt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEIMUt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinAccEOt,1), UBOUND(InData%LinAccEOt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEOt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%LinAccESt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinAccESt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinAccESt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinAccESt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinAccESt,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinAccESt,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinAccESt,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%LinAccESt,3), UBOUND(InData%LinAccESt,3)
        DO i2 = LBOUND(InData%LinAccESt,2), UBOUND(InData%LinAccESt,2)
          DO i1 = LBOUND(InData%LinAccESt,1), UBOUND(InData%LinAccESt,1)
            ReKiBuf(Re_Xferred) = InData%LinAccESt(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LinAccETt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinAccETt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinAccETt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LinAccETt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LinAccETt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%LinAccETt,2), UBOUND(InData%LinAccETt,2)
        DO i1 = LBOUND(InData%LinAccETt,1), UBOUND(InData%LinAccETt,1)
          ReKiBuf(Re_Xferred) = InData%LinAccETt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%LinAccEZt,1), UBOUND(InData%LinAccEZt,1)
      ReKiBuf(Re_Xferred) = InData%LinAccEZt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinVelEIMU,1), UBOUND(InData%LinVelEIMU,1)
      ReKiBuf(Re_Xferred) = InData%LinVelEIMU(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinVelEZ,1), UBOUND(InData%LinVelEZ,1)
      ReKiBuf(Re_Xferred) = InData%LinVelEZ(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%LinVelEO,1), UBOUND(InData%LinVelEO,1)
      ReKiBuf(Re_Xferred) = InData%LinVelEO(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FrcONcRtt,1), UBOUND(InData%FrcONcRtt,1)
      ReKiBuf(Re_Xferred) = InData%FrcONcRtt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FrcPRott,1), UBOUND(InData%FrcPRott,1)
      ReKiBuf(Re_Xferred) = InData%FrcPRott(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%FrcS0Bt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FrcS0Bt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FrcS0Bt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FrcS0Bt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FrcS0Bt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FrcS0Bt,2), UBOUND(InData%FrcS0Bt,2)
        DO i1 = LBOUND(InData%FrcS0Bt,1), UBOUND(InData%FrcS0Bt,1)
          ReKiBuf(Re_Xferred) = InData%FrcS0Bt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%FrcT0Trbt,1), UBOUND(InData%FrcT0Trbt,1)
      ReKiBuf(Re_Xferred) = InData%FrcT0Trbt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%FSAero) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FSAero,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FSAero,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FSAero,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FSAero,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FSAero,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FSAero,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%FSAero,3), UBOUND(InData%FSAero,3)
        DO i2 = LBOUND(InData%FSAero,2), UBOUND(InData%FSAero,2)
          DO i1 = LBOUND(InData%FSAero,1), UBOUND(InData%FSAero,1)
            ReKiBuf(Re_Xferred) = InData%FSAero(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FSTipDrag) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FSTipDrag,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FSTipDrag,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FSTipDrag,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FSTipDrag,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FSTipDrag,2), UBOUND(InData%FSTipDrag,2)
        DO i1 = LBOUND(InData%FSTipDrag,1), UBOUND(InData%FSTipDrag,1)
          ReKiBuf(Re_Xferred) = InData%FSTipDrag(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FTHydrot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FTHydrot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FTHydrot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FTHydrot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FTHydrot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FTHydrot,2), UBOUND(InData%FTHydrot,2)
        DO i1 = LBOUND(InData%FTHydrot,1), UBOUND(InData%FTHydrot,1)
          ReKiBuf(Re_Xferred) = InData%FTHydrot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%FZHydrot,1), UBOUND(InData%FZHydrot,1)
      ReKiBuf(Re_Xferred) = InData%FZHydrot(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%MFHydrot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MFHydrot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MFHydrot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MFHydrot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MFHydrot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%MFHydrot,2), UBOUND(InData%MFHydrot,2)
        DO i1 = LBOUND(InData%MFHydrot,1), UBOUND(InData%MFHydrot,1)
          ReKiBuf(Re_Xferred) = InData%MFHydrot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%MomBNcRtt,1), UBOUND(InData%MomBNcRtt,1)
      ReKiBuf(Re_Xferred) = InData%MomBNcRtt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%MomH0Bt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MomH0Bt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MomH0Bt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MomH0Bt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MomH0Bt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%MomH0Bt,2), UBOUND(InData%MomH0Bt,2)
        DO i1 = LBOUND(InData%MomH0Bt,1), UBOUND(InData%MomH0Bt,1)
          ReKiBuf(Re_Xferred) = InData%MomH0Bt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%MomLPRott,1), UBOUND(InData%MomLPRott,1)
      ReKiBuf(Re_Xferred) = InData%MomLPRott(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%MomNGnRtt,1), UBOUND(InData%MomNGnRtt,1)
      ReKiBuf(Re_Xferred) = InData%MomNGnRtt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%MomNTailt,1), UBOUND(InData%MomNTailt,1)
      ReKiBuf(Re_Xferred) = InData%MomNTailt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%MomX0Trbt,1), UBOUND(InData%MomX0Trbt,1)
      ReKiBuf(Re_Xferred) = InData%MomX0Trbt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%MMAero) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MMAero,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MMAero,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MMAero,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MMAero,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MMAero,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MMAero,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%MMAero,3), UBOUND(InData%MMAero,3)
        DO i2 = LBOUND(InData%MMAero,2), UBOUND(InData%MMAero,2)
          DO i1 = LBOUND(InData%MMAero,1), UBOUND(InData%MMAero,1)
            ReKiBuf(Re_Xferred) = InData%MMAero(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%MXHydrot,1), UBOUND(InData%MXHydrot,1)
      ReKiBuf(Re_Xferred) = InData%MXHydrot(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%PFrcONcRt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcONcRt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcONcRt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcONcRt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcONcRt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcONcRt,2), UBOUND(InData%PFrcONcRt,2)
        DO i1 = LBOUND(InData%PFrcONcRt,1), UBOUND(InData%PFrcONcRt,1)
          ReKiBuf(Re_Xferred) = InData%PFrcONcRt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFrcPRot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcPRot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcPRot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcPRot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcPRot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcPRot,2), UBOUND(InData%PFrcPRot,2)
        DO i1 = LBOUND(InData%PFrcPRot,1), UBOUND(InData%PFrcPRot,1)
          ReKiBuf(Re_Xferred) = InData%PFrcPRot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFrcS0B) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcS0B,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcS0B,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcS0B,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcS0B,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcS0B,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcS0B,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PFrcS0B,3), UBOUND(InData%PFrcS0B,3)
        DO i2 = LBOUND(InData%PFrcS0B,2), UBOUND(InData%PFrcS0B,2)
          DO i1 = LBOUND(InData%PFrcS0B,1), UBOUND(InData%PFrcS0B,1)
            ReKiBuf(Re_Xferred) = InData%PFrcS0B(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFrcT0Trb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcT0Trb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcT0Trb,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcT0Trb,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcT0Trb,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcT0Trb,2), UBOUND(InData%PFrcT0Trb,2)
        DO i1 = LBOUND(InData%PFrcT0Trb,1), UBOUND(InData%PFrcT0Trb,1)
          ReKiBuf(Re_Xferred) = InData%PFrcT0Trb(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFTHydro) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFTHydro,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFTHydro,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFTHydro,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFTHydro,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFTHydro,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFTHydro,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PFTHydro,3), UBOUND(InData%PFTHydro,3)
        DO i2 = LBOUND(InData%PFTHydro,2), UBOUND(InData%PFTHydro,2)
          DO i1 = LBOUND(InData%PFTHydro,1), UBOUND(InData%PFTHydro,1)
            ReKiBuf(Re_Xferred) = InData%PFTHydro(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%PFZHydro,2), UBOUND(InData%PFZHydro,2)
      DO i1 = LBOUND(InData%PFZHydro,1), UBOUND(InData%PFZHydro,1)
        ReKiBuf(Re_Xferred) = InData%PFZHydro(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%PMFHydro) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMFHydro,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMFHydro,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMFHydro,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMFHydro,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMFHydro,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMFHydro,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PMFHydro,3), UBOUND(InData%PMFHydro,3)
        DO i2 = LBOUND(InData%PMFHydro,2), UBOUND(InData%PMFHydro,2)
          DO i1 = LBOUND(InData%PMFHydro,1), UBOUND(InData%PMFHydro,1)
            ReKiBuf(Re_Xferred) = InData%PMFHydro(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomBNcRt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomBNcRt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomBNcRt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomBNcRt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomBNcRt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomBNcRt,2), UBOUND(InData%PMomBNcRt,2)
        DO i1 = LBOUND(InData%PMomBNcRt,1), UBOUND(InData%PMomBNcRt,1)
          ReKiBuf(Re_Xferred) = InData%PMomBNcRt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomH0B) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomH0B,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomH0B,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomH0B,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomH0B,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomH0B,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomH0B,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%PMomH0B,3), UBOUND(InData%PMomH0B,3)
        DO i2 = LBOUND(InData%PMomH0B,2), UBOUND(InData%PMomH0B,2)
          DO i1 = LBOUND(InData%PMomH0B,1), UBOUND(InData%PMomH0B,1)
            ReKiBuf(Re_Xferred) = InData%PMomH0B(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomLPRot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomLPRot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomLPRot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomLPRot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomLPRot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomLPRot,2), UBOUND(InData%PMomLPRot,2)
        DO i1 = LBOUND(InData%PMomLPRot,1), UBOUND(InData%PMomLPRot,1)
          ReKiBuf(Re_Xferred) = InData%PMomLPRot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomNGnRt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomNGnRt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomNGnRt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomNGnRt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomNGnRt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomNGnRt,2), UBOUND(InData%PMomNGnRt,2)
        DO i1 = LBOUND(InData%PMomNGnRt,1), UBOUND(InData%PMomNGnRt,1)
          ReKiBuf(Re_Xferred) = InData%PMomNGnRt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomNTail) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomNTail,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomNTail,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomNTail,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomNTail,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomNTail,2), UBOUND(InData%PMomNTail,2)
        DO i1 = LBOUND(InData%PMomNTail,1), UBOUND(InData%PMomNTail,1)
          ReKiBuf(Re_Xferred) = InData%PMomNTail(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomX0Trb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomX0Trb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomX0Trb,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomX0Trb,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomX0Trb,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomX0Trb,2), UBOUND(InData%PMomX0Trb,2)
        DO i1 = LBOUND(InData%PMomX0Trb,1), UBOUND(InData%PMomX0Trb,1)
          ReKiBuf(Re_Xferred) = InData%PMomX0Trb(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%PMXHydro,2), UBOUND(InData%PMXHydro,2)
      DO i1 = LBOUND(InData%PMXHydro,1), UBOUND(InData%PMXHydro,1)
        ReKiBuf(Re_Xferred) = InData%PMXHydro(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DbKiBuf(Db_Xferred) = InData%TeetAng
    Db_Xferred = Db_Xferred + 1
    DO i1 = LBOUND(InData%FrcVGnRtt,1), UBOUND(InData%FrcVGnRtt,1)
      ReKiBuf(Re_Xferred) = InData%FrcVGnRtt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FrcWTailt,1), UBOUND(InData%FrcWTailt,1)
      ReKiBuf(Re_Xferred) = InData%FrcWTailt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%FrcZAllt,1), UBOUND(InData%FrcZAllt,1)
      ReKiBuf(Re_Xferred) = InData%FrcZAllt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%MomXAllt,1), UBOUND(InData%MomXAllt,1)
      ReKiBuf(Re_Xferred) = InData%MomXAllt(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( .NOT. ALLOCATED(InData%PFrcVGnRt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcVGnRt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcVGnRt,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcVGnRt,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcVGnRt,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcVGnRt,2), UBOUND(InData%PFrcVGnRt,2)
        DO i1 = LBOUND(InData%PFrcVGnRt,1), UBOUND(InData%PFrcVGnRt,1)
          ReKiBuf(Re_Xferred) = InData%PFrcVGnRt(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFrcWTail) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcWTail,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcWTail,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcWTail,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcWTail,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcWTail,2), UBOUND(InData%PFrcWTail,2)
        DO i1 = LBOUND(InData%PFrcWTail,1), UBOUND(InData%PFrcWTail,1)
          ReKiBuf(Re_Xferred) = InData%PFrcWTail(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PFrcZAll) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcZAll,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcZAll,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PFrcZAll,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PFrcZAll,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PFrcZAll,2), UBOUND(InData%PFrcZAll,2)
        DO i1 = LBOUND(InData%PFrcZAll,1), UBOUND(InData%PFrcZAll,1)
          ReKiBuf(Re_Xferred) = InData%PFrcZAll(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PMomXAll) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomXAll,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomXAll,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PMomXAll,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PMomXAll,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PMomXAll,2), UBOUND(InData%PMomXAll,2)
        DO i1 = LBOUND(InData%PMomXAll,1), UBOUND(InData%PMomXAll,1)
          ReKiBuf(Re_Xferred) = InData%PMomXAll(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%TeetMom
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlMom
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlMom
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GBoxEffFac
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%rSAerCen) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCen,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCen,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCen,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCen,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCen,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCen,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rSAerCen,3), UBOUND(InData%rSAerCen,3)
        DO i2 = LBOUND(InData%rSAerCen,2), UBOUND(InData%rSAerCen,2)
          DO i1 = LBOUND(InData%rSAerCen,1), UBOUND(InData%rSAerCen,1)
            ReKiBuf(Re_Xferred) = InData%rSAerCen(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE ED_PackRtHndSide

 SUBROUTINE ED_UnPackRtHndSide( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_RtHndSide), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackRtHndSide'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%rO,1)
    i1_u = UBOUND(OutData%rO,1)
    DO i1 = LBOUND(OutData%rO,1), UBOUND(OutData%rO,1)
      OutData%rO(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rQS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rQS)) DEALLOCATE(OutData%rQS)
    ALLOCATE(OutData%rQS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rQS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rQS,3), UBOUND(OutData%rQS,3)
        DO i2 = LBOUND(OutData%rQS,2), UBOUND(OutData%rQS,2)
          DO i1 = LBOUND(OutData%rQS,1), UBOUND(OutData%rQS,1)
            OutData%rQS(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rS)) DEALLOCATE(OutData%rS)
    ALLOCATE(OutData%rS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rS,3), UBOUND(OutData%rS,3)
        DO i2 = LBOUND(OutData%rS,2), UBOUND(OutData%rS,2)
          DO i1 = LBOUND(OutData%rS,1), UBOUND(OutData%rS,1)
            OutData%rS(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rS0S not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rS0S)) DEALLOCATE(OutData%rS0S)
    ALLOCATE(OutData%rS0S(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rS0S.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rS0S,3), UBOUND(OutData%rS0S,3)
        DO i2 = LBOUND(OutData%rS0S,2), UBOUND(OutData%rS0S,2)
          DO i1 = LBOUND(OutData%rS0S,1), UBOUND(OutData%rS0S,1)
            OutData%rS0S(i1,i2,i3) = REAL(DbKiBuf(Db_Xferred), R8Ki)
            Db_Xferred = Db_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rT)) DEALLOCATE(OutData%rT)
    ALLOCATE(OutData%rT(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rT,2), UBOUND(OutData%rT,2)
        DO i1 = LBOUND(OutData%rT,1), UBOUND(OutData%rT,1)
          OutData%rT(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%rT0O,1)
    i1_u = UBOUND(OutData%rT0O,1)
    DO i1 = LBOUND(OutData%rT0O,1), UBOUND(OutData%rT0O,1)
      OutData%rT0O(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rT0T not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rT0T)) DEALLOCATE(OutData%rT0T)
    ALLOCATE(OutData%rT0T(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rT0T.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rT0T,2), UBOUND(OutData%rT0T,2)
        DO i1 = LBOUND(OutData%rT0T,1), UBOUND(OutData%rT0T,1)
          OutData%rT0T(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%rZ,1)
    i1_u = UBOUND(OutData%rZ,1)
    DO i1 = LBOUND(OutData%rZ,1), UBOUND(OutData%rZ,1)
      OutData%rZ(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rZO,1)
    i1_u = UBOUND(OutData%rZO,1)
    DO i1 = LBOUND(OutData%rZO,1), UBOUND(OutData%rZO,1)
      OutData%rZO(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rZT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rZT)) DEALLOCATE(OutData%rZT)
    ALLOCATE(OutData%rZT(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rZT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rZT,2), UBOUND(OutData%rZT,2)
        DO i1 = LBOUND(OutData%rZT,1), UBOUND(OutData%rZT,1)
          OutData%rZT(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%rPQ,1)
    i1_u = UBOUND(OutData%rPQ,1)
    DO i1 = LBOUND(OutData%rPQ,1), UBOUND(OutData%rPQ,1)
      OutData%rPQ(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rP,1)
    i1_u = UBOUND(OutData%rP,1)
    DO i1 = LBOUND(OutData%rP,1), UBOUND(OutData%rP,1)
      OutData%rP(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rV,1)
    i1_u = UBOUND(OutData%rV,1)
    DO i1 = LBOUND(OutData%rV,1), UBOUND(OutData%rV,1)
      OutData%rV(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rZY,1)
    i1_u = UBOUND(OutData%rZY,1)
    DO i1 = LBOUND(OutData%rZY,1), UBOUND(OutData%rZY,1)
      OutData%rZY(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rOU,1)
    i1_u = UBOUND(OutData%rOU,1)
    DO i1 = LBOUND(OutData%rOU,1), UBOUND(OutData%rOU,1)
      OutData%rOU(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rOV,1)
    i1_u = UBOUND(OutData%rOV,1)
    DO i1 = LBOUND(OutData%rOV,1), UBOUND(OutData%rOV,1)
      OutData%rOV(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rVD,1)
    i1_u = UBOUND(OutData%rVD,1)
    DO i1 = LBOUND(OutData%rVD,1), UBOUND(OutData%rVD,1)
      OutData%rVD(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rOW,1)
    i1_u = UBOUND(OutData%rOW,1)
    DO i1 = LBOUND(OutData%rOW,1), UBOUND(OutData%rOW,1)
      OutData%rOW(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rPC,1)
    i1_u = UBOUND(OutData%rPC,1)
    DO i1 = LBOUND(OutData%rPC,1), UBOUND(OutData%rPC,1)
      OutData%rPC(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rPS0 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rPS0)) DEALLOCATE(OutData%rPS0)
    ALLOCATE(OutData%rPS0(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rPS0.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rPS0,2), UBOUND(OutData%rPS0,2)
        DO i1 = LBOUND(OutData%rPS0,1), UBOUND(OutData%rPS0,1)
          OutData%rPS0(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%rQ,1)
    i1_u = UBOUND(OutData%rQ,1)
    DO i1 = LBOUND(OutData%rQ,1), UBOUND(OutData%rQ,1)
      OutData%rQ(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rQC,1)
    i1_u = UBOUND(OutData%rQC,1)
    DO i1 = LBOUND(OutData%rQC,1), UBOUND(OutData%rQC,1)
      OutData%rQC(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rVIMU,1)
    i1_u = UBOUND(OutData%rVIMU,1)
    DO i1 = LBOUND(OutData%rVIMU,1), UBOUND(OutData%rVIMU,1)
      OutData%rVIMU(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rVP,1)
    i1_u = UBOUND(OutData%rVP,1)
    DO i1 = LBOUND(OutData%rVP,1), UBOUND(OutData%rVP,1)
      OutData%rVP(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rWI,1)
    i1_u = UBOUND(OutData%rWI,1)
    DO i1 = LBOUND(OutData%rWI,1), UBOUND(OutData%rWI,1)
      OutData%rWI(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rWJ,1)
    i1_u = UBOUND(OutData%rWJ,1)
    DO i1 = LBOUND(OutData%rWJ,1), UBOUND(OutData%rWJ,1)
      OutData%rWJ(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rWK,1)
    i1_u = UBOUND(OutData%rWK,1)
    DO i1 = LBOUND(OutData%rWK,1), UBOUND(OutData%rWK,1)
      OutData%rWK(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%rZT0,1)
    i1_u = UBOUND(OutData%rZT0,1)
    DO i1 = LBOUND(OutData%rZT0,1), UBOUND(OutData%rZT0,1)
      OutData%rZT0(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngPosEF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngPosEF)) DEALLOCATE(OutData%AngPosEF)
    ALLOCATE(OutData%AngPosEF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngPosEF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AngPosEF,2), UBOUND(OutData%AngPosEF,2)
        DO i1 = LBOUND(OutData%AngPosEF,1), UBOUND(OutData%AngPosEF,1)
          OutData%AngPosEF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngPosXF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngPosXF)) DEALLOCATE(OutData%AngPosXF)
    ALLOCATE(OutData%AngPosXF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngPosXF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AngPosXF,2), UBOUND(OutData%AngPosXF,2)
        DO i1 = LBOUND(OutData%AngPosXF,1), UBOUND(OutData%AngPosXF,1)
          OutData%AngPosXF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngPosHM not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngPosHM)) DEALLOCATE(OutData%AngPosHM)
    ALLOCATE(OutData%AngPosHM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngPosHM.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AngPosHM,3), UBOUND(OutData%AngPosHM,3)
        DO i2 = LBOUND(OutData%AngPosHM,2), UBOUND(OutData%AngPosHM,2)
          DO i1 = LBOUND(OutData%AngPosHM,1), UBOUND(OutData%AngPosHM,1)
            OutData%AngPosHM(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%AngPosXB,1)
    i1_u = UBOUND(OutData%AngPosXB,1)
    DO i1 = LBOUND(OutData%AngPosXB,1), UBOUND(OutData%AngPosXB,1)
      OutData%AngPosXB(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngPosEX,1)
    i1_u = UBOUND(OutData%AngPosEX,1)
    DO i1 = LBOUND(OutData%AngPosEX,1), UBOUND(OutData%AngPosEX,1)
      OutData%AngPosEX(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEA)) DEALLOCATE(OutData%PAngVelEA)
    ALLOCATE(OutData%PAngVelEA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEA,3), UBOUND(OutData%PAngVelEA,3)
        DO i2 = LBOUND(OutData%PAngVelEA,2), UBOUND(OutData%PAngVelEA,2)
          DO i1 = LBOUND(OutData%PAngVelEA,1), UBOUND(OutData%PAngVelEA,1)
            OutData%PAngVelEA(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEF)) DEALLOCATE(OutData%PAngVelEF)
    ALLOCATE(OutData%PAngVelEF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%PAngVelEF,4), UBOUND(OutData%PAngVelEF,4)
        DO i3 = LBOUND(OutData%PAngVelEF,3), UBOUND(OutData%PAngVelEF,3)
          DO i2 = LBOUND(OutData%PAngVelEF,2), UBOUND(OutData%PAngVelEF,2)
            DO i1 = LBOUND(OutData%PAngVelEF,1), UBOUND(OutData%PAngVelEF,1)
              OutData%PAngVelEF(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEG)) DEALLOCATE(OutData%PAngVelEG)
    ALLOCATE(OutData%PAngVelEG(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEG,3), UBOUND(OutData%PAngVelEG,3)
        DO i2 = LBOUND(OutData%PAngVelEG,2), UBOUND(OutData%PAngVelEG,2)
          DO i1 = LBOUND(OutData%PAngVelEG,1), UBOUND(OutData%PAngVelEG,1)
            OutData%PAngVelEG(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEH not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEH)) DEALLOCATE(OutData%PAngVelEH)
    ALLOCATE(OutData%PAngVelEH(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEH.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEH,3), UBOUND(OutData%PAngVelEH,3)
        DO i2 = LBOUND(OutData%PAngVelEH,2), UBOUND(OutData%PAngVelEH,2)
          DO i1 = LBOUND(OutData%PAngVelEH,1), UBOUND(OutData%PAngVelEH,1)
            OutData%PAngVelEH(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEL)) DEALLOCATE(OutData%PAngVelEL)
    ALLOCATE(OutData%PAngVelEL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEL,3), UBOUND(OutData%PAngVelEL,3)
        DO i2 = LBOUND(OutData%PAngVelEL,2), UBOUND(OutData%PAngVelEL,2)
          DO i1 = LBOUND(OutData%PAngVelEL,1), UBOUND(OutData%PAngVelEL,1)
            OutData%PAngVelEL(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEM not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i5_l = IntKiBuf( Int_Xferred    )
    i5_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEM)) DEALLOCATE(OutData%PAngVelEM)
    ALLOCATE(OutData%PAngVelEM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEM.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i5 = LBOUND(OutData%PAngVelEM,5), UBOUND(OutData%PAngVelEM,5)
        DO i4 = LBOUND(OutData%PAngVelEM,4), UBOUND(OutData%PAngVelEM,4)
          DO i3 = LBOUND(OutData%PAngVelEM,3), UBOUND(OutData%PAngVelEM,3)
            DO i2 = LBOUND(OutData%PAngVelEM,2), UBOUND(OutData%PAngVelEM,2)
              DO i1 = LBOUND(OutData%PAngVelEM,1), UBOUND(OutData%PAngVelEM,1)
                OutData%PAngVelEM(i1,i2,i3,i4,i5) = ReKiBuf(Re_Xferred)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngVelEM not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngVelEM)) DEALLOCATE(OutData%AngVelEM)
    ALLOCATE(OutData%AngVelEM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngVelEM.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AngVelEM,3), UBOUND(OutData%AngVelEM,3)
        DO i2 = LBOUND(OutData%AngVelEM,2), UBOUND(OutData%AngVelEM,2)
          DO i1 = LBOUND(OutData%AngVelEM,1), UBOUND(OutData%AngVelEM,1)
            OutData%AngVelEM(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEN not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEN)) DEALLOCATE(OutData%PAngVelEN)
    ALLOCATE(OutData%PAngVelEN(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEN.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEN,3), UBOUND(OutData%PAngVelEN,3)
        DO i2 = LBOUND(OutData%PAngVelEN,2), UBOUND(OutData%PAngVelEN,2)
          DO i1 = LBOUND(OutData%PAngVelEN,1), UBOUND(OutData%PAngVelEN,1)
            OutData%PAngVelEN(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%AngVelEA,1)
    i1_u = UBOUND(OutData%AngVelEA,1)
    DO i1 = LBOUND(OutData%AngVelEA,1), UBOUND(OutData%AngVelEA,1)
      OutData%AngVelEA(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEB not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEB)) DEALLOCATE(OutData%PAngVelEB)
    ALLOCATE(OutData%PAngVelEB(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEB.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEB,3), UBOUND(OutData%PAngVelEB,3)
        DO i2 = LBOUND(OutData%PAngVelEB,2), UBOUND(OutData%PAngVelEB,2)
          DO i1 = LBOUND(OutData%PAngVelEB,1), UBOUND(OutData%PAngVelEB,1)
            OutData%PAngVelEB(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelER not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelER)) DEALLOCATE(OutData%PAngVelER)
    ALLOCATE(OutData%PAngVelER(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelER.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelER,3), UBOUND(OutData%PAngVelER,3)
        DO i2 = LBOUND(OutData%PAngVelER,2), UBOUND(OutData%PAngVelER,2)
          DO i1 = LBOUND(OutData%PAngVelER,1), UBOUND(OutData%PAngVelER,1)
            OutData%PAngVelER(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PAngVelEX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PAngVelEX)) DEALLOCATE(OutData%PAngVelEX)
    ALLOCATE(OutData%PAngVelEX(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PAngVelEX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PAngVelEX,3), UBOUND(OutData%PAngVelEX,3)
        DO i2 = LBOUND(OutData%PAngVelEX,2), UBOUND(OutData%PAngVelEX,2)
          DO i1 = LBOUND(OutData%PAngVelEX,1), UBOUND(OutData%PAngVelEX,1)
            OutData%PAngVelEX(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%AngVelEG,1)
    i1_u = UBOUND(OutData%AngVelEG,1)
    DO i1 = LBOUND(OutData%AngVelEG,1), UBOUND(OutData%AngVelEG,1)
      OutData%AngVelEG(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelEH,1)
    i1_u = UBOUND(OutData%AngVelEH,1)
    DO i1 = LBOUND(OutData%AngVelEH,1), UBOUND(OutData%AngVelEH,1)
      OutData%AngVelEH(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelEL,1)
    i1_u = UBOUND(OutData%AngVelEL,1)
    DO i1 = LBOUND(OutData%AngVelEL,1), UBOUND(OutData%AngVelEL,1)
      OutData%AngVelEL(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelEN,1)
    i1_u = UBOUND(OutData%AngVelEN,1)
    DO i1 = LBOUND(OutData%AngVelEN,1), UBOUND(OutData%AngVelEN,1)
      OutData%AngVelEN(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelEB,1)
    i1_u = UBOUND(OutData%AngVelEB,1)
    DO i1 = LBOUND(OutData%AngVelEB,1), UBOUND(OutData%AngVelEB,1)
      OutData%AngVelEB(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelER,1)
    i1_u = UBOUND(OutData%AngVelER,1)
    DO i1 = LBOUND(OutData%AngVelER,1), UBOUND(OutData%AngVelER,1)
      OutData%AngVelER(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngVelEX,1)
    i1_u = UBOUND(OutData%AngVelEX,1)
    DO i1 = LBOUND(OutData%AngVelEX,1), UBOUND(OutData%AngVelEX,1)
      OutData%AngVelEX(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%TeetAngVel = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    i1_l = LBOUND(OutData%AngAccEBt,1)
    i1_u = UBOUND(OutData%AngAccEBt,1)
    DO i1 = LBOUND(OutData%AngAccEBt,1), UBOUND(OutData%AngAccEBt,1)
      OutData%AngAccEBt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngAccERt,1)
    i1_u = UBOUND(OutData%AngAccERt,1)
    DO i1 = LBOUND(OutData%AngAccERt,1), UBOUND(OutData%AngAccERt,1)
      OutData%AngAccERt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngAccEXt,1)
    i1_u = UBOUND(OutData%AngAccEXt,1)
    DO i1 = LBOUND(OutData%AngAccEXt,1), UBOUND(OutData%AngAccEXt,1)
      OutData%AngAccEXt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngAccEFt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngAccEFt)) DEALLOCATE(OutData%AngAccEFt)
    ALLOCATE(OutData%AngAccEFt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngAccEFt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AngAccEFt,2), UBOUND(OutData%AngAccEFt,2)
        DO i1 = LBOUND(OutData%AngAccEFt,1), UBOUND(OutData%AngAccEFt,1)
          OutData%AngAccEFt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngVelEF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngVelEF)) DEALLOCATE(OutData%AngVelEF)
    ALLOCATE(OutData%AngVelEF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngVelEF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AngVelEF,2), UBOUND(OutData%AngVelEF,2)
        DO i1 = LBOUND(OutData%AngVelEF,1), UBOUND(OutData%AngVelEF,1)
          OutData%AngVelEF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngVelHM not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngVelHM)) DEALLOCATE(OutData%AngVelHM)
    ALLOCATE(OutData%AngVelHM(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngVelHM.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AngVelHM,3), UBOUND(OutData%AngVelHM,3)
        DO i2 = LBOUND(OutData%AngVelHM,2), UBOUND(OutData%AngVelHM,2)
          DO i1 = LBOUND(OutData%AngVelHM,1), UBOUND(OutData%AngVelHM,1)
            OutData%AngVelHM(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%AngAccEAt,1)
    i1_u = UBOUND(OutData%AngAccEAt,1)
    DO i1 = LBOUND(OutData%AngAccEAt,1), UBOUND(OutData%AngAccEAt,1)
      OutData%AngAccEAt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngAccEGt,1)
    i1_u = UBOUND(OutData%AngAccEGt,1)
    DO i1 = LBOUND(OutData%AngAccEGt,1), UBOUND(OutData%AngAccEGt,1)
      OutData%AngAccEGt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%AngAccEHt,1)
    i1_u = UBOUND(OutData%AngAccEHt,1)
    DO i1 = LBOUND(OutData%AngAccEHt,1), UBOUND(OutData%AngAccEHt,1)
      OutData%AngAccEHt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AngAccEKt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AngAccEKt)) DEALLOCATE(OutData%AngAccEKt)
    ALLOCATE(OutData%AngAccEKt(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AngAccEKt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AngAccEKt,3), UBOUND(OutData%AngAccEKt,3)
        DO i2 = LBOUND(OutData%AngAccEKt,2), UBOUND(OutData%AngAccEKt,2)
          DO i1 = LBOUND(OutData%AngAccEKt,1), UBOUND(OutData%AngAccEKt,1)
            OutData%AngAccEKt(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%AngAccENt,1)
    i1_u = UBOUND(OutData%AngAccENt,1)
    DO i1 = LBOUND(OutData%AngAccENt,1), UBOUND(OutData%AngAccENt,1)
      OutData%AngAccENt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccECt,1)
    i1_u = UBOUND(OutData%LinAccECt,1)
    DO i1 = LBOUND(OutData%LinAccECt,1), UBOUND(OutData%LinAccECt,1)
      OutData%LinAccECt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEDt,1)
    i1_u = UBOUND(OutData%LinAccEDt,1)
    DO i1 = LBOUND(OutData%LinAccEDt,1), UBOUND(OutData%LinAccEDt,1)
      OutData%LinAccEDt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEIt,1)
    i1_u = UBOUND(OutData%LinAccEIt,1)
    DO i1 = LBOUND(OutData%LinAccEIt,1), UBOUND(OutData%LinAccEIt,1)
      OutData%LinAccEIt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEJt,1)
    i1_u = UBOUND(OutData%LinAccEJt,1)
    DO i1 = LBOUND(OutData%LinAccEJt,1), UBOUND(OutData%LinAccEJt,1)
      OutData%LinAccEJt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEUt,1)
    i1_u = UBOUND(OutData%LinAccEUt,1)
    DO i1 = LBOUND(OutData%LinAccEUt,1), UBOUND(OutData%LinAccEUt,1)
      OutData%LinAccEUt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEYt,1)
    i1_u = UBOUND(OutData%LinAccEYt,1)
    DO i1 = LBOUND(OutData%LinAccEYt,1), UBOUND(OutData%LinAccEYt,1)
      OutData%LinAccEYt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinVelES not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinVelES)) DEALLOCATE(OutData%LinVelES)
    ALLOCATE(OutData%LinVelES(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinVelES.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%LinVelES,3), UBOUND(OutData%LinVelES,3)
        DO i2 = LBOUND(OutData%LinVelES,2), UBOUND(OutData%LinVelES,2)
          DO i1 = LBOUND(OutData%LinVelES,1), UBOUND(OutData%LinVelES,1)
            OutData%LinVelES(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%LinVelEQ,1)
    i1_u = UBOUND(OutData%LinVelEQ,1)
    DO i1 = LBOUND(OutData%LinVelEQ,1), UBOUND(OutData%LinVelEQ,1)
      OutData%LinVelEQ(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinVelET not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinVelET)) DEALLOCATE(OutData%LinVelET)
    ALLOCATE(OutData%LinVelET(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinVelET.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%LinVelET,2), UBOUND(OutData%LinVelET,2)
        DO i1 = LBOUND(OutData%LinVelET,1), UBOUND(OutData%LinVelET,1)
          OutData%LinVelET(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinVelESm2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinVelESm2)) DEALLOCATE(OutData%LinVelESm2)
    ALLOCATE(OutData%LinVelESm2(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinVelESm2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%LinVelESm2,1), UBOUND(OutData%LinVelESm2,1)
        OutData%LinVelESm2(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEIMU not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEIMU)) DEALLOCATE(OutData%PLinVelEIMU)
    ALLOCATE(OutData%PLinVelEIMU(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEIMU.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEIMU,3), UBOUND(OutData%PLinVelEIMU,3)
        DO i2 = LBOUND(OutData%PLinVelEIMU,2), UBOUND(OutData%PLinVelEIMU,2)
          DO i1 = LBOUND(OutData%PLinVelEIMU,1), UBOUND(OutData%PLinVelEIMU,1)
            OutData%PLinVelEIMU(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEO not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEO)) DEALLOCATE(OutData%PLinVelEO)
    ALLOCATE(OutData%PLinVelEO(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEO.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEO,3), UBOUND(OutData%PLinVelEO,3)
        DO i2 = LBOUND(OutData%PLinVelEO,2), UBOUND(OutData%PLinVelEO,2)
          DO i1 = LBOUND(OutData%PLinVelEO,1), UBOUND(OutData%PLinVelEO,1)
            OutData%PLinVelEO(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelES not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i5_l = IntKiBuf( Int_Xferred    )
    i5_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelES)) DEALLOCATE(OutData%PLinVelES)
    ALLOCATE(OutData%PLinVelES(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelES.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i5 = LBOUND(OutData%PLinVelES,5), UBOUND(OutData%PLinVelES,5)
        DO i4 = LBOUND(OutData%PLinVelES,4), UBOUND(OutData%PLinVelES,4)
          DO i3 = LBOUND(OutData%PLinVelES,3), UBOUND(OutData%PLinVelES,3)
            DO i2 = LBOUND(OutData%PLinVelES,2), UBOUND(OutData%PLinVelES,2)
              DO i1 = LBOUND(OutData%PLinVelES,1), UBOUND(OutData%PLinVelES,1)
                OutData%PLinVelES(i1,i2,i3,i4,i5) = ReKiBuf(Re_Xferred)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelET not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelET)) DEALLOCATE(OutData%PLinVelET)
    ALLOCATE(OutData%PLinVelET(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelET.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%PLinVelET,4), UBOUND(OutData%PLinVelET,4)
        DO i3 = LBOUND(OutData%PLinVelET,3), UBOUND(OutData%PLinVelET,3)
          DO i2 = LBOUND(OutData%PLinVelET,2), UBOUND(OutData%PLinVelET,2)
            DO i1 = LBOUND(OutData%PLinVelET,1), UBOUND(OutData%PLinVelET,1)
              OutData%PLinVelET(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEZ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEZ)) DEALLOCATE(OutData%PLinVelEZ)
    ALLOCATE(OutData%PLinVelEZ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEZ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEZ,3), UBOUND(OutData%PLinVelEZ,3)
        DO i2 = LBOUND(OutData%PLinVelEZ,2), UBOUND(OutData%PLinVelEZ,2)
          DO i1 = LBOUND(OutData%PLinVelEZ,1), UBOUND(OutData%PLinVelEZ,1)
            OutData%PLinVelEZ(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEC)) DEALLOCATE(OutData%PLinVelEC)
    ALLOCATE(OutData%PLinVelEC(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEC,3), UBOUND(OutData%PLinVelEC,3)
        DO i2 = LBOUND(OutData%PLinVelEC,2), UBOUND(OutData%PLinVelEC,2)
          DO i1 = LBOUND(OutData%PLinVelEC,1), UBOUND(OutData%PLinVelEC,1)
            OutData%PLinVelEC(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelED not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelED)) DEALLOCATE(OutData%PLinVelED)
    ALLOCATE(OutData%PLinVelED(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelED.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelED,3), UBOUND(OutData%PLinVelED,3)
        DO i2 = LBOUND(OutData%PLinVelED,2), UBOUND(OutData%PLinVelED,2)
          DO i1 = LBOUND(OutData%PLinVelED,1), UBOUND(OutData%PLinVelED,1)
            OutData%PLinVelED(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEI not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEI)) DEALLOCATE(OutData%PLinVelEI)
    ALLOCATE(OutData%PLinVelEI(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEI.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEI,3), UBOUND(OutData%PLinVelEI,3)
        DO i2 = LBOUND(OutData%PLinVelEI,2), UBOUND(OutData%PLinVelEI,2)
          DO i1 = LBOUND(OutData%PLinVelEI,1), UBOUND(OutData%PLinVelEI,1)
            OutData%PLinVelEI(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEJ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEJ)) DEALLOCATE(OutData%PLinVelEJ)
    ALLOCATE(OutData%PLinVelEJ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEJ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEJ,3), UBOUND(OutData%PLinVelEJ,3)
        DO i2 = LBOUND(OutData%PLinVelEJ,2), UBOUND(OutData%PLinVelEJ,2)
          DO i1 = LBOUND(OutData%PLinVelEJ,1), UBOUND(OutData%PLinVelEJ,1)
            OutData%PLinVelEJ(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEK not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEK)) DEALLOCATE(OutData%PLinVelEK)
    ALLOCATE(OutData%PLinVelEK(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEK.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEK,3), UBOUND(OutData%PLinVelEK,3)
        DO i2 = LBOUND(OutData%PLinVelEK,2), UBOUND(OutData%PLinVelEK,2)
          DO i1 = LBOUND(OutData%PLinVelEK,1), UBOUND(OutData%PLinVelEK,1)
            OutData%PLinVelEK(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEP)) DEALLOCATE(OutData%PLinVelEP)
    ALLOCATE(OutData%PLinVelEP(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEP,3), UBOUND(OutData%PLinVelEP,3)
        DO i2 = LBOUND(OutData%PLinVelEP,2), UBOUND(OutData%PLinVelEP,2)
          DO i1 = LBOUND(OutData%PLinVelEP,1), UBOUND(OutData%PLinVelEP,1)
            OutData%PLinVelEP(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEQ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEQ)) DEALLOCATE(OutData%PLinVelEQ)
    ALLOCATE(OutData%PLinVelEQ(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEQ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEQ,3), UBOUND(OutData%PLinVelEQ,3)
        DO i2 = LBOUND(OutData%PLinVelEQ,2), UBOUND(OutData%PLinVelEQ,2)
          DO i1 = LBOUND(OutData%PLinVelEQ,1), UBOUND(OutData%PLinVelEQ,1)
            OutData%PLinVelEQ(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEU not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEU)) DEALLOCATE(OutData%PLinVelEU)
    ALLOCATE(OutData%PLinVelEU(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEU.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEU,3), UBOUND(OutData%PLinVelEU,3)
        DO i2 = LBOUND(OutData%PLinVelEU,2), UBOUND(OutData%PLinVelEU,2)
          DO i1 = LBOUND(OutData%PLinVelEU,1), UBOUND(OutData%PLinVelEU,1)
            OutData%PLinVelEU(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEV not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEV)) DEALLOCATE(OutData%PLinVelEV)
    ALLOCATE(OutData%PLinVelEV(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEV.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEV,3), UBOUND(OutData%PLinVelEV,3)
        DO i2 = LBOUND(OutData%PLinVelEV,2), UBOUND(OutData%PLinVelEV,2)
          DO i1 = LBOUND(OutData%PLinVelEV,1), UBOUND(OutData%PLinVelEV,1)
            OutData%PLinVelEV(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEW)) DEALLOCATE(OutData%PLinVelEW)
    ALLOCATE(OutData%PLinVelEW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEW,3), UBOUND(OutData%PLinVelEW,3)
        DO i2 = LBOUND(OutData%PLinVelEW,2), UBOUND(OutData%PLinVelEW,2)
          DO i1 = LBOUND(OutData%PLinVelEW,1), UBOUND(OutData%PLinVelEW,1)
            OutData%PLinVelEW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PLinVelEY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PLinVelEY)) DEALLOCATE(OutData%PLinVelEY)
    ALLOCATE(OutData%PLinVelEY(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PLinVelEY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PLinVelEY,3), UBOUND(OutData%PLinVelEY,3)
        DO i2 = LBOUND(OutData%PLinVelEY,2), UBOUND(OutData%PLinVelEY,2)
          DO i1 = LBOUND(OutData%PLinVelEY,1), UBOUND(OutData%PLinVelEY,1)
            OutData%PLinVelEY(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%LinAccEIMUt,1)
    i1_u = UBOUND(OutData%LinAccEIMUt,1)
    DO i1 = LBOUND(OutData%LinAccEIMUt,1), UBOUND(OutData%LinAccEIMUt,1)
      OutData%LinAccEIMUt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinAccEOt,1)
    i1_u = UBOUND(OutData%LinAccEOt,1)
    DO i1 = LBOUND(OutData%LinAccEOt,1), UBOUND(OutData%LinAccEOt,1)
      OutData%LinAccEOt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinAccESt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinAccESt)) DEALLOCATE(OutData%LinAccESt)
    ALLOCATE(OutData%LinAccESt(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinAccESt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%LinAccESt,3), UBOUND(OutData%LinAccESt,3)
        DO i2 = LBOUND(OutData%LinAccESt,2), UBOUND(OutData%LinAccESt,2)
          DO i1 = LBOUND(OutData%LinAccESt,1), UBOUND(OutData%LinAccESt,1)
            OutData%LinAccESt(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LinAccETt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LinAccETt)) DEALLOCATE(OutData%LinAccETt)
    ALLOCATE(OutData%LinAccETt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LinAccETt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%LinAccETt,2), UBOUND(OutData%LinAccETt,2)
        DO i1 = LBOUND(OutData%LinAccETt,1), UBOUND(OutData%LinAccETt,1)
          OutData%LinAccETt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%LinAccEZt,1)
    i1_u = UBOUND(OutData%LinAccEZt,1)
    DO i1 = LBOUND(OutData%LinAccEZt,1), UBOUND(OutData%LinAccEZt,1)
      OutData%LinAccEZt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinVelEIMU,1)
    i1_u = UBOUND(OutData%LinVelEIMU,1)
    DO i1 = LBOUND(OutData%LinVelEIMU,1), UBOUND(OutData%LinVelEIMU,1)
      OutData%LinVelEIMU(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinVelEZ,1)
    i1_u = UBOUND(OutData%LinVelEZ,1)
    DO i1 = LBOUND(OutData%LinVelEZ,1), UBOUND(OutData%LinVelEZ,1)
      OutData%LinVelEZ(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%LinVelEO,1)
    i1_u = UBOUND(OutData%LinVelEO,1)
    DO i1 = LBOUND(OutData%LinVelEO,1), UBOUND(OutData%LinVelEO,1)
      OutData%LinVelEO(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FrcONcRtt,1)
    i1_u = UBOUND(OutData%FrcONcRtt,1)
    DO i1 = LBOUND(OutData%FrcONcRtt,1), UBOUND(OutData%FrcONcRtt,1)
      OutData%FrcONcRtt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FrcPRott,1)
    i1_u = UBOUND(OutData%FrcPRott,1)
    DO i1 = LBOUND(OutData%FrcPRott,1), UBOUND(OutData%FrcPRott,1)
      OutData%FrcPRott(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FrcS0Bt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FrcS0Bt)) DEALLOCATE(OutData%FrcS0Bt)
    ALLOCATE(OutData%FrcS0Bt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FrcS0Bt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FrcS0Bt,2), UBOUND(OutData%FrcS0Bt,2)
        DO i1 = LBOUND(OutData%FrcS0Bt,1), UBOUND(OutData%FrcS0Bt,1)
          OutData%FrcS0Bt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%FrcT0Trbt,1)
    i1_u = UBOUND(OutData%FrcT0Trbt,1)
    DO i1 = LBOUND(OutData%FrcT0Trbt,1), UBOUND(OutData%FrcT0Trbt,1)
      OutData%FrcT0Trbt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FSAero not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FSAero)) DEALLOCATE(OutData%FSAero)
    ALLOCATE(OutData%FSAero(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FSAero.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%FSAero,3), UBOUND(OutData%FSAero,3)
        DO i2 = LBOUND(OutData%FSAero,2), UBOUND(OutData%FSAero,2)
          DO i1 = LBOUND(OutData%FSAero,1), UBOUND(OutData%FSAero,1)
            OutData%FSAero(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FSTipDrag not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FSTipDrag)) DEALLOCATE(OutData%FSTipDrag)
    ALLOCATE(OutData%FSTipDrag(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FSTipDrag.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FSTipDrag,2), UBOUND(OutData%FSTipDrag,2)
        DO i1 = LBOUND(OutData%FSTipDrag,1), UBOUND(OutData%FSTipDrag,1)
          OutData%FSTipDrag(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FTHydrot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FTHydrot)) DEALLOCATE(OutData%FTHydrot)
    ALLOCATE(OutData%FTHydrot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FTHydrot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FTHydrot,2), UBOUND(OutData%FTHydrot,2)
        DO i1 = LBOUND(OutData%FTHydrot,1), UBOUND(OutData%FTHydrot,1)
          OutData%FTHydrot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%FZHydrot,1)
    i1_u = UBOUND(OutData%FZHydrot,1)
    DO i1 = LBOUND(OutData%FZHydrot,1), UBOUND(OutData%FZHydrot,1)
      OutData%FZHydrot(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MFHydrot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MFHydrot)) DEALLOCATE(OutData%MFHydrot)
    ALLOCATE(OutData%MFHydrot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MFHydrot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%MFHydrot,2), UBOUND(OutData%MFHydrot,2)
        DO i1 = LBOUND(OutData%MFHydrot,1), UBOUND(OutData%MFHydrot,1)
          OutData%MFHydrot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%MomBNcRtt,1)
    i1_u = UBOUND(OutData%MomBNcRtt,1)
    DO i1 = LBOUND(OutData%MomBNcRtt,1), UBOUND(OutData%MomBNcRtt,1)
      OutData%MomBNcRtt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MomH0Bt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MomH0Bt)) DEALLOCATE(OutData%MomH0Bt)
    ALLOCATE(OutData%MomH0Bt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MomH0Bt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%MomH0Bt,2), UBOUND(OutData%MomH0Bt,2)
        DO i1 = LBOUND(OutData%MomH0Bt,1), UBOUND(OutData%MomH0Bt,1)
          OutData%MomH0Bt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%MomLPRott,1)
    i1_u = UBOUND(OutData%MomLPRott,1)
    DO i1 = LBOUND(OutData%MomLPRott,1), UBOUND(OutData%MomLPRott,1)
      OutData%MomLPRott(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%MomNGnRtt,1)
    i1_u = UBOUND(OutData%MomNGnRtt,1)
    DO i1 = LBOUND(OutData%MomNGnRtt,1), UBOUND(OutData%MomNGnRtt,1)
      OutData%MomNGnRtt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%MomNTailt,1)
    i1_u = UBOUND(OutData%MomNTailt,1)
    DO i1 = LBOUND(OutData%MomNTailt,1), UBOUND(OutData%MomNTailt,1)
      OutData%MomNTailt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%MomX0Trbt,1)
    i1_u = UBOUND(OutData%MomX0Trbt,1)
    DO i1 = LBOUND(OutData%MomX0Trbt,1), UBOUND(OutData%MomX0Trbt,1)
      OutData%MomX0Trbt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MMAero not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MMAero)) DEALLOCATE(OutData%MMAero)
    ALLOCATE(OutData%MMAero(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MMAero.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%MMAero,3), UBOUND(OutData%MMAero,3)
        DO i2 = LBOUND(OutData%MMAero,2), UBOUND(OutData%MMAero,2)
          DO i1 = LBOUND(OutData%MMAero,1), UBOUND(OutData%MMAero,1)
            OutData%MMAero(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%MXHydrot,1)
    i1_u = UBOUND(OutData%MXHydrot,1)
    DO i1 = LBOUND(OutData%MXHydrot,1), UBOUND(OutData%MXHydrot,1)
      OutData%MXHydrot(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcONcRt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcONcRt)) DEALLOCATE(OutData%PFrcONcRt)
    ALLOCATE(OutData%PFrcONcRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcONcRt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcONcRt,2), UBOUND(OutData%PFrcONcRt,2)
        DO i1 = LBOUND(OutData%PFrcONcRt,1), UBOUND(OutData%PFrcONcRt,1)
          OutData%PFrcONcRt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcPRot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcPRot)) DEALLOCATE(OutData%PFrcPRot)
    ALLOCATE(OutData%PFrcPRot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcPRot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcPRot,2), UBOUND(OutData%PFrcPRot,2)
        DO i1 = LBOUND(OutData%PFrcPRot,1), UBOUND(OutData%PFrcPRot,1)
          OutData%PFrcPRot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcS0B not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcS0B)) DEALLOCATE(OutData%PFrcS0B)
    ALLOCATE(OutData%PFrcS0B(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcS0B.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PFrcS0B,3), UBOUND(OutData%PFrcS0B,3)
        DO i2 = LBOUND(OutData%PFrcS0B,2), UBOUND(OutData%PFrcS0B,2)
          DO i1 = LBOUND(OutData%PFrcS0B,1), UBOUND(OutData%PFrcS0B,1)
            OutData%PFrcS0B(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcT0Trb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcT0Trb)) DEALLOCATE(OutData%PFrcT0Trb)
    ALLOCATE(OutData%PFrcT0Trb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcT0Trb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcT0Trb,2), UBOUND(OutData%PFrcT0Trb,2)
        DO i1 = LBOUND(OutData%PFrcT0Trb,1), UBOUND(OutData%PFrcT0Trb,1)
          OutData%PFrcT0Trb(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFTHydro not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFTHydro)) DEALLOCATE(OutData%PFTHydro)
    ALLOCATE(OutData%PFTHydro(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFTHydro.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PFTHydro,3), UBOUND(OutData%PFTHydro,3)
        DO i2 = LBOUND(OutData%PFTHydro,2), UBOUND(OutData%PFTHydro,2)
          DO i1 = LBOUND(OutData%PFTHydro,1), UBOUND(OutData%PFTHydro,1)
            OutData%PFTHydro(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%PFZHydro,1)
    i1_u = UBOUND(OutData%PFZHydro,1)
    i2_l = LBOUND(OutData%PFZHydro,2)
    i2_u = UBOUND(OutData%PFZHydro,2)
    DO i2 = LBOUND(OutData%PFZHydro,2), UBOUND(OutData%PFZHydro,2)
      DO i1 = LBOUND(OutData%PFZHydro,1), UBOUND(OutData%PFZHydro,1)
        OutData%PFZHydro(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMFHydro not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMFHydro)) DEALLOCATE(OutData%PMFHydro)
    ALLOCATE(OutData%PMFHydro(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMFHydro.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PMFHydro,3), UBOUND(OutData%PMFHydro,3)
        DO i2 = LBOUND(OutData%PMFHydro,2), UBOUND(OutData%PMFHydro,2)
          DO i1 = LBOUND(OutData%PMFHydro,1), UBOUND(OutData%PMFHydro,1)
            OutData%PMFHydro(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomBNcRt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomBNcRt)) DEALLOCATE(OutData%PMomBNcRt)
    ALLOCATE(OutData%PMomBNcRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomBNcRt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomBNcRt,2), UBOUND(OutData%PMomBNcRt,2)
        DO i1 = LBOUND(OutData%PMomBNcRt,1), UBOUND(OutData%PMomBNcRt,1)
          OutData%PMomBNcRt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomH0B not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomH0B)) DEALLOCATE(OutData%PMomH0B)
    ALLOCATE(OutData%PMomH0B(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomH0B.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%PMomH0B,3), UBOUND(OutData%PMomH0B,3)
        DO i2 = LBOUND(OutData%PMomH0B,2), UBOUND(OutData%PMomH0B,2)
          DO i1 = LBOUND(OutData%PMomH0B,1), UBOUND(OutData%PMomH0B,1)
            OutData%PMomH0B(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomLPRot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomLPRot)) DEALLOCATE(OutData%PMomLPRot)
    ALLOCATE(OutData%PMomLPRot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomLPRot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomLPRot,2), UBOUND(OutData%PMomLPRot,2)
        DO i1 = LBOUND(OutData%PMomLPRot,1), UBOUND(OutData%PMomLPRot,1)
          OutData%PMomLPRot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomNGnRt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomNGnRt)) DEALLOCATE(OutData%PMomNGnRt)
    ALLOCATE(OutData%PMomNGnRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomNGnRt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomNGnRt,2), UBOUND(OutData%PMomNGnRt,2)
        DO i1 = LBOUND(OutData%PMomNGnRt,1), UBOUND(OutData%PMomNGnRt,1)
          OutData%PMomNGnRt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomNTail not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomNTail)) DEALLOCATE(OutData%PMomNTail)
    ALLOCATE(OutData%PMomNTail(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomNTail.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomNTail,2), UBOUND(OutData%PMomNTail,2)
        DO i1 = LBOUND(OutData%PMomNTail,1), UBOUND(OutData%PMomNTail,1)
          OutData%PMomNTail(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomX0Trb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomX0Trb)) DEALLOCATE(OutData%PMomX0Trb)
    ALLOCATE(OutData%PMomX0Trb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomX0Trb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomX0Trb,2), UBOUND(OutData%PMomX0Trb,2)
        DO i1 = LBOUND(OutData%PMomX0Trb,1), UBOUND(OutData%PMomX0Trb,1)
          OutData%PMomX0Trb(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%PMXHydro,1)
    i1_u = UBOUND(OutData%PMXHydro,1)
    i2_l = LBOUND(OutData%PMXHydro,2)
    i2_u = UBOUND(OutData%PMXHydro,2)
    DO i2 = LBOUND(OutData%PMXHydro,2), UBOUND(OutData%PMXHydro,2)
      DO i1 = LBOUND(OutData%PMXHydro,1), UBOUND(OutData%PMXHydro,1)
        OutData%PMXHydro(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    OutData%TeetAng = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    i1_l = LBOUND(OutData%FrcVGnRtt,1)
    i1_u = UBOUND(OutData%FrcVGnRtt,1)
    DO i1 = LBOUND(OutData%FrcVGnRtt,1), UBOUND(OutData%FrcVGnRtt,1)
      OutData%FrcVGnRtt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FrcWTailt,1)
    i1_u = UBOUND(OutData%FrcWTailt,1)
    DO i1 = LBOUND(OutData%FrcWTailt,1), UBOUND(OutData%FrcWTailt,1)
      OutData%FrcWTailt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%FrcZAllt,1)
    i1_u = UBOUND(OutData%FrcZAllt,1)
    DO i1 = LBOUND(OutData%FrcZAllt,1), UBOUND(OutData%FrcZAllt,1)
      OutData%FrcZAllt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%MomXAllt,1)
    i1_u = UBOUND(OutData%MomXAllt,1)
    DO i1 = LBOUND(OutData%MomXAllt,1), UBOUND(OutData%MomXAllt,1)
      OutData%MomXAllt(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcVGnRt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcVGnRt)) DEALLOCATE(OutData%PFrcVGnRt)
    ALLOCATE(OutData%PFrcVGnRt(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcVGnRt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcVGnRt,2), UBOUND(OutData%PFrcVGnRt,2)
        DO i1 = LBOUND(OutData%PFrcVGnRt,1), UBOUND(OutData%PFrcVGnRt,1)
          OutData%PFrcVGnRt(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcWTail not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcWTail)) DEALLOCATE(OutData%PFrcWTail)
    ALLOCATE(OutData%PFrcWTail(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcWTail.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcWTail,2), UBOUND(OutData%PFrcWTail,2)
        DO i1 = LBOUND(OutData%PFrcWTail,1), UBOUND(OutData%PFrcWTail,1)
          OutData%PFrcWTail(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PFrcZAll not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PFrcZAll)) DEALLOCATE(OutData%PFrcZAll)
    ALLOCATE(OutData%PFrcZAll(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PFrcZAll.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PFrcZAll,2), UBOUND(OutData%PFrcZAll,2)
        DO i1 = LBOUND(OutData%PFrcZAll,1), UBOUND(OutData%PFrcZAll,1)
          OutData%PFrcZAll(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PMomXAll not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PMomXAll)) DEALLOCATE(OutData%PMomXAll)
    ALLOCATE(OutData%PMomXAll(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PMomXAll.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PMomXAll,2), UBOUND(OutData%PMomXAll,2)
        DO i1 = LBOUND(OutData%PMomXAll,1), UBOUND(OutData%PMomXAll,1)
          OutData%PMomXAll(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%TeetMom = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlMom = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlMom = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GBoxEffFac = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rSAerCen not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rSAerCen)) DEALLOCATE(OutData%rSAerCen)
    ALLOCATE(OutData%rSAerCen(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rSAerCen.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rSAerCen,3), UBOUND(OutData%rSAerCen,3)
        DO i2 = LBOUND(OutData%rSAerCen,2), UBOUND(OutData%rSAerCen,2)
          DO i1 = LBOUND(OutData%rSAerCen,1), UBOUND(OutData%rSAerCen,1)
            OutData%rSAerCen(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE ED_UnPackRtHndSide

 SUBROUTINE ED_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(ED_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcContStateData%QT)) THEN
  i1_l = LBOUND(SrcContStateData%QT,1)
  i1_u = UBOUND(SrcContStateData%QT,1)
  IF (.NOT. ALLOCATED(DstContStateData%QT)) THEN 
    ALLOCATE(DstContStateData%QT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstContStateData%QT = SrcContStateData%QT
ENDIF
IF (ALLOCATED(SrcContStateData%QDT)) THEN
  i1_l = LBOUND(SrcContStateData%QDT,1)
  i1_u = UBOUND(SrcContStateData%QDT,1)
  IF (.NOT. ALLOCATED(DstContStateData%QDT)) THEN 
    ALLOCATE(DstContStateData%QDT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%QDT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstContStateData%QDT = SrcContStateData%QDT
ENDIF
 END SUBROUTINE ED_CopyContState

 SUBROUTINE ED_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(ED_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ContStateData%QT)) THEN
  DEALLOCATE(ContStateData%QT)
ENDIF
IF (ALLOCATED(ContStateData%QDT)) THEN
  DEALLOCATE(ContStateData%QDT)
ENDIF
 END SUBROUTINE ED_DestroyContState

 SUBROUTINE ED_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! QT allocated yes/no
  IF ( ALLOCATED(InData%QT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! QT upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%QT)  ! QT
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! QDT allocated yes/no
  IF ( ALLOCATED(InData%QDT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! QDT upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%QDT)  ! QDT
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%QT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%QT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%QT,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%QT,1), UBOUND(InData%QT,1)
        DbKiBuf(Db_Xferred) = InData%QT(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%QDT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%QDT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%QDT,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%QDT,1), UBOUND(InData%QDT,1)
        DbKiBuf(Db_Xferred) = InData%QDT(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_PackContState

 SUBROUTINE ED_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! QT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%QT)) DEALLOCATE(OutData%QT)
    ALLOCATE(OutData%QT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%QT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%QT,1), UBOUND(OutData%QT,1)
        OutData%QT(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! QDT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%QDT)) DEALLOCATE(OutData%QDT)
    ALLOCATE(OutData%QDT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%QDT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%QDT,1), UBOUND(OutData%QDT,1)
        OutData%QDT(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
 END SUBROUTINE ED_UnPackContState

 SUBROUTINE ED_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(ED_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%DummyDiscState = SrcDiscStateData%DummyDiscState
 END SUBROUTINE ED_CopyDiscState

 SUBROUTINE ED_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(ED_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE ED_DestroyDiscState

 SUBROUTINE ED_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyDiscState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyDiscState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_PackDiscState

 SUBROUTINE ED_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyDiscState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_UnPackDiscState

 SUBROUTINE ED_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(ED_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
 END SUBROUTINE ED_CopyConstrState

 SUBROUTINE ED_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(ED_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE ED_DestroyConstrState

 SUBROUTINE ED_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstrState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstrState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_PackConstrState

 SUBROUTINE ED_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstrState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_UnPackConstrState

 SUBROUTINE ED_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(ED_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%n = SrcOtherStateData%n
    DO i1 = LBOUND(SrcOtherStateData%xdot,1), UBOUND(SrcOtherStateData%xdot,1)
      CALL ED_CopyContState( SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
IF (ALLOCATED(SrcOtherStateData%IC)) THEN
  i1_l = LBOUND(SrcOtherStateData%IC,1)
  i1_u = UBOUND(SrcOtherStateData%IC,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%IC)) THEN 
    ALLOCATE(DstOtherStateData%IC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%IC = SrcOtherStateData%IC
ENDIF
    DstOtherStateData%HSSBrTrq = SrcOtherStateData%HSSBrTrq
    DstOtherStateData%HSSBrTrqC = SrcOtherStateData%HSSBrTrqC
    DstOtherStateData%SgnPrvLSTQ = SrcOtherStateData%SgnPrvLSTQ
    DstOtherStateData%SgnLSTQ = SrcOtherStateData%SgnLSTQ
 END SUBROUTINE ED_CopyOtherState

 SUBROUTINE ED_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(ED_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
DO i1 = LBOUND(OtherStateData%xdot,1), UBOUND(OtherStateData%xdot,1)
  CALL ED_DestroyContState( OtherStateData%xdot(i1), ErrStat, ErrMsg )
ENDDO
IF (ALLOCATED(OtherStateData%IC)) THEN
  DEALLOCATE(OtherStateData%IC)
ENDIF
 END SUBROUTINE ED_DestroyOtherState

 SUBROUTINE ED_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! n
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      Int_BufSz   = Int_BufSz + 3  ! xdot: size of buffers for each call to pack subtype
      CALL ED_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, .TRUE. ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! xdot
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! xdot
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! xdot
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  Int_BufSz   = Int_BufSz   + 1     ! IC allocated yes/no
  IF ( ALLOCATED(InData%IC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IC upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%IC)  ! IC
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! HSSBrTrq
      Re_BufSz   = Re_BufSz   + 1  ! HSSBrTrqC
      Int_BufSz  = Int_BufSz  + 1  ! SgnPrvLSTQ
      Int_BufSz  = Int_BufSz  + SIZE(InData%SgnLSTQ)  ! SgnLSTQ
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%n
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      CALL ED_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, OnlySize ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  IF ( .NOT. ALLOCATED(InData%IC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%IC,1), UBOUND(InData%IC,1)
        IntKiBuf(Int_Xferred) = InData%IC(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%HSSBrTrq
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HSSBrTrqC
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%SgnPrvLSTQ
    Int_Xferred = Int_Xferred + 1
    DO i1 = LBOUND(InData%SgnLSTQ,1), UBOUND(InData%SgnLSTQ,1)
      IntKiBuf(Int_Xferred) = InData%SgnLSTQ(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
 END SUBROUTINE ED_PackOtherState

 SUBROUTINE ED_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%n = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%xdot,1)
    i1_u = UBOUND(OutData%xdot,1)
    DO i1 = LBOUND(OutData%xdot,1), UBOUND(OutData%xdot,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%xdot(i1), ErrStat2, ErrMsg2 ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IC)) DEALLOCATE(OutData%IC)
    ALLOCATE(OutData%IC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%IC,1), UBOUND(OutData%IC,1)
        OutData%IC(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%HSSBrTrq = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HSSBrTrqC = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SgnPrvLSTQ = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    i1_l = LBOUND(OutData%SgnLSTQ,1)
    i1_u = UBOUND(OutData%SgnLSTQ,1)
    DO i1 = LBOUND(OutData%SgnLSTQ,1), UBOUND(OutData%SgnLSTQ,1)
      OutData%SgnLSTQ(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
 END SUBROUTINE ED_UnPackOtherState

 SUBROUTINE ED_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(ED_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL ED_Copycoordsys( SrcMiscData%CoordSys, DstMiscData%CoordSys, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL ED_Copyrthndside( SrcMiscData%RtHS, DstMiscData%RtHS, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcMiscData%AllOuts)) THEN
  i1_l = LBOUND(SrcMiscData%AllOuts,1)
  i1_u = UBOUND(SrcMiscData%AllOuts,1)
  IF (.NOT. ALLOCATED(DstMiscData%AllOuts)) THEN 
    ALLOCATE(DstMiscData%AllOuts(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AllOuts = SrcMiscData%AllOuts
ENDIF
IF (ALLOCATED(SrcMiscData%AugMat)) THEN
  i1_l = LBOUND(SrcMiscData%AugMat,1)
  i1_u = UBOUND(SrcMiscData%AugMat,1)
  i2_l = LBOUND(SrcMiscData%AugMat,2)
  i2_u = UBOUND(SrcMiscData%AugMat,2)
  IF (.NOT. ALLOCATED(DstMiscData%AugMat)) THEN 
    ALLOCATE(DstMiscData%AugMat(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AugMat = SrcMiscData%AugMat
ENDIF
IF (ALLOCATED(SrcMiscData%AugMat_factor)) THEN
  i1_l = LBOUND(SrcMiscData%AugMat_factor,1)
  i1_u = UBOUND(SrcMiscData%AugMat_factor,1)
  i2_l = LBOUND(SrcMiscData%AugMat_factor,2)
  i2_u = UBOUND(SrcMiscData%AugMat_factor,2)
  IF (.NOT. ALLOCATED(DstMiscData%AugMat_factor)) THEN 
    ALLOCATE(DstMiscData%AugMat_factor(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat_factor.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AugMat_factor = SrcMiscData%AugMat_factor
ENDIF
IF (ALLOCATED(SrcMiscData%SolnVec)) THEN
  i1_l = LBOUND(SrcMiscData%SolnVec,1)
  i1_u = UBOUND(SrcMiscData%SolnVec,1)
  IF (.NOT. ALLOCATED(DstMiscData%SolnVec)) THEN 
    ALLOCATE(DstMiscData%SolnVec(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SolnVec.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SolnVec = SrcMiscData%SolnVec
ENDIF
IF (ALLOCATED(SrcMiscData%AugMat_pivot)) THEN
  i1_l = LBOUND(SrcMiscData%AugMat_pivot,1)
  i1_u = UBOUND(SrcMiscData%AugMat_pivot,1)
  IF (.NOT. ALLOCATED(DstMiscData%AugMat_pivot)) THEN 
    ALLOCATE(DstMiscData%AugMat_pivot(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AugMat_pivot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AugMat_pivot = SrcMiscData%AugMat_pivot
ENDIF
IF (ALLOCATED(SrcMiscData%OgnlGeAzRo)) THEN
  i1_l = LBOUND(SrcMiscData%OgnlGeAzRo,1)
  i1_u = UBOUND(SrcMiscData%OgnlGeAzRo,1)
  IF (.NOT. ALLOCATED(DstMiscData%OgnlGeAzRo)) THEN 
    ALLOCATE(DstMiscData%OgnlGeAzRo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%OgnlGeAzRo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%OgnlGeAzRo = SrcMiscData%OgnlGeAzRo
ENDIF
IF (ALLOCATED(SrcMiscData%QD2T)) THEN
  i1_l = LBOUND(SrcMiscData%QD2T,1)
  i1_u = UBOUND(SrcMiscData%QD2T,1)
  IF (.NOT. ALLOCATED(DstMiscData%QD2T)) THEN 
    ALLOCATE(DstMiscData%QD2T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%QD2T.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%QD2T = SrcMiscData%QD2T
ENDIF
    DstMiscData%IgnoreMod = SrcMiscData%IgnoreMod
 END SUBROUTINE ED_CopyMisc

 SUBROUTINE ED_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(ED_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL ED_Destroycoordsys( MiscData%CoordSys, ErrStat, ErrMsg )
  CALL ED_Destroyrthndside( MiscData%RtHS, ErrStat, ErrMsg )
IF (ALLOCATED(MiscData%AllOuts)) THEN
  DEALLOCATE(MiscData%AllOuts)
ENDIF
IF (ALLOCATED(MiscData%AugMat)) THEN
  DEALLOCATE(MiscData%AugMat)
ENDIF
IF (ALLOCATED(MiscData%AugMat_factor)) THEN
  DEALLOCATE(MiscData%AugMat_factor)
ENDIF
IF (ALLOCATED(MiscData%SolnVec)) THEN
  DEALLOCATE(MiscData%SolnVec)
ENDIF
IF (ALLOCATED(MiscData%AugMat_pivot)) THEN
  DEALLOCATE(MiscData%AugMat_pivot)
ENDIF
IF (ALLOCATED(MiscData%OgnlGeAzRo)) THEN
  DEALLOCATE(MiscData%OgnlGeAzRo)
ENDIF
IF (ALLOCATED(MiscData%QD2T)) THEN
  DEALLOCATE(MiscData%QD2T)
ENDIF
 END SUBROUTINE ED_DestroyMisc

 SUBROUTINE ED_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! CoordSys: size of buffers for each call to pack subtype
      CALL ED_Packcoordsys( Re_Buf, Db_Buf, Int_Buf, InData%CoordSys, ErrStat2, ErrMsg2, .TRUE. ) ! CoordSys 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! CoordSys
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! CoordSys
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! CoordSys
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! RtHS: size of buffers for each call to pack subtype
      CALL ED_Packrthndside( Re_Buf, Db_Buf, Int_Buf, InData%RtHS, ErrStat2, ErrMsg2, .TRUE. ) ! RtHS 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! RtHS
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! RtHS
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! RtHS
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! AllOuts allocated yes/no
  IF ( ALLOCATED(InData%AllOuts) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AllOuts upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AllOuts)  ! AllOuts
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AugMat allocated yes/no
  IF ( ALLOCATED(InData%AugMat) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AugMat upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%AugMat)  ! AugMat
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AugMat_factor allocated yes/no
  IF ( ALLOCATED(InData%AugMat_factor) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AugMat_factor upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%AugMat_factor)  ! AugMat_factor
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SolnVec allocated yes/no
  IF ( ALLOCATED(InData%SolnVec) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SolnVec upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%SolnVec)  ! SolnVec
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AugMat_pivot allocated yes/no
  IF ( ALLOCATED(InData%AugMat_pivot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AugMat_pivot upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AugMat_pivot)  ! AugMat_pivot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OgnlGeAzRo allocated yes/no
  IF ( ALLOCATED(InData%OgnlGeAzRo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OgnlGeAzRo upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OgnlGeAzRo)  ! OgnlGeAzRo
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! QD2T allocated yes/no
  IF ( ALLOCATED(InData%QD2T) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! QD2T upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%QD2T)  ! QD2T
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! IgnoreMod
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL ED_Packcoordsys( Re_Buf, Db_Buf, Int_Buf, InData%CoordSys, ErrStat2, ErrMsg2, OnlySize ) ! CoordSys 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL ED_Packrthndside( Re_Buf, Db_Buf, Int_Buf, InData%RtHS, ErrStat2, ErrMsg2, OnlySize ) ! RtHS 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%AllOuts) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AllOuts,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AllOuts,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AllOuts,1), UBOUND(InData%AllOuts,1)
        ReKiBuf(Re_Xferred) = InData%AllOuts(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AugMat) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AugMat,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AugMat,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AugMat,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AugMat,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AugMat,2), UBOUND(InData%AugMat,2)
        DO i1 = LBOUND(InData%AugMat,1), UBOUND(InData%AugMat,1)
          DbKiBuf(Db_Xferred) = InData%AugMat(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AugMat_factor) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AugMat_factor,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AugMat_factor,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AugMat_factor,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AugMat_factor,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AugMat_factor,2), UBOUND(InData%AugMat_factor,2)
        DO i1 = LBOUND(InData%AugMat_factor,1), UBOUND(InData%AugMat_factor,1)
          DbKiBuf(Db_Xferred) = InData%AugMat_factor(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SolnVec) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SolnVec,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SolnVec,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SolnVec,1), UBOUND(InData%SolnVec,1)
        DbKiBuf(Db_Xferred) = InData%SolnVec(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AugMat_pivot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AugMat_pivot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AugMat_pivot,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AugMat_pivot,1), UBOUND(InData%AugMat_pivot,1)
        IntKiBuf(Int_Xferred) = InData%AugMat_pivot(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OgnlGeAzRo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OgnlGeAzRo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OgnlGeAzRo,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OgnlGeAzRo,1), UBOUND(InData%OgnlGeAzRo,1)
        ReKiBuf(Re_Xferred) = InData%OgnlGeAzRo(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%QD2T) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%QD2T,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%QD2T,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%QD2T,1), UBOUND(InData%QD2T,1)
        DbKiBuf(Db_Xferred) = InData%QD2T(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%IgnoreMod, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_PackMisc

 SUBROUTINE ED_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_Unpackcoordsys( Re_Buf, Db_Buf, Int_Buf, OutData%CoordSys, ErrStat2, ErrMsg2 ) ! CoordSys 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_Unpackrthndside( Re_Buf, Db_Buf, Int_Buf, OutData%RtHS, ErrStat2, ErrMsg2 ) ! RtHS 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AllOuts not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AllOuts)) DEALLOCATE(OutData%AllOuts)
    ALLOCATE(OutData%AllOuts(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AllOuts.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AllOuts,1), UBOUND(OutData%AllOuts,1)
        OutData%AllOuts(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AugMat not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AugMat)) DEALLOCATE(OutData%AugMat)
    ALLOCATE(OutData%AugMat(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AugMat.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AugMat,2), UBOUND(OutData%AugMat,2)
        DO i1 = LBOUND(OutData%AugMat,1), UBOUND(OutData%AugMat,1)
          OutData%AugMat(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AugMat_factor not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AugMat_factor)) DEALLOCATE(OutData%AugMat_factor)
    ALLOCATE(OutData%AugMat_factor(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AugMat_factor.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AugMat_factor,2), UBOUND(OutData%AugMat_factor,2)
        DO i1 = LBOUND(OutData%AugMat_factor,1), UBOUND(OutData%AugMat_factor,1)
          OutData%AugMat_factor(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SolnVec not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SolnVec)) DEALLOCATE(OutData%SolnVec)
    ALLOCATE(OutData%SolnVec(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SolnVec.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SolnVec,1), UBOUND(OutData%SolnVec,1)
        OutData%SolnVec(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AugMat_pivot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AugMat_pivot)) DEALLOCATE(OutData%AugMat_pivot)
    ALLOCATE(OutData%AugMat_pivot(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AugMat_pivot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AugMat_pivot,1), UBOUND(OutData%AugMat_pivot,1)
        OutData%AugMat_pivot(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OgnlGeAzRo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OgnlGeAzRo)) DEALLOCATE(OutData%OgnlGeAzRo)
    ALLOCATE(OutData%OgnlGeAzRo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OgnlGeAzRo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OgnlGeAzRo,1), UBOUND(OutData%OgnlGeAzRo,1)
        OutData%OgnlGeAzRo(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! QD2T not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%QD2T)) DEALLOCATE(OutData%QD2T)
    ALLOCATE(OutData%QD2T(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%QD2T.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%QD2T,1), UBOUND(OutData%QD2T,1)
        OutData%QD2T(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    OutData%IgnoreMod = TRANSFER(IntKiBuf(Int_Xferred), OutData%IgnoreMod)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_UnPackMisc

 SUBROUTINE ED_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(ED_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
    DstParamData%DT24 = SrcParamData%DT24
    DstParamData%BldNodes = SrcParamData%BldNodes
    DstParamData%TipNode = SrcParamData%TipNode
    DstParamData%NDOF = SrcParamData%NDOF
    DstParamData%TwoPiNB = SrcParamData%TwoPiNB
    DstParamData%NAug = SrcParamData%NAug
    DstParamData%NPH = SrcParamData%NPH
IF (ALLOCATED(SrcParamData%PH)) THEN
  i1_l = LBOUND(SrcParamData%PH,1)
  i1_u = UBOUND(SrcParamData%PH,1)
  IF (.NOT. ALLOCATED(DstParamData%PH)) THEN 
    ALLOCATE(DstParamData%PH(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PH.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%PH = SrcParamData%PH
ENDIF
    DstParamData%NPM = SrcParamData%NPM
IF (ALLOCATED(SrcParamData%PM)) THEN
  i1_l = LBOUND(SrcParamData%PM,1)
  i1_u = UBOUND(SrcParamData%PM,1)
  i2_l = LBOUND(SrcParamData%PM,2)
  i2_u = UBOUND(SrcParamData%PM,2)
  IF (.NOT. ALLOCATED(DstParamData%PM)) THEN 
    ALLOCATE(DstParamData%PM(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PM.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%PM = SrcParamData%PM
ENDIF
IF (ALLOCATED(SrcParamData%DOF_Flag)) THEN
  i1_l = LBOUND(SrcParamData%DOF_Flag,1)
  i1_u = UBOUND(SrcParamData%DOF_Flag,1)
  IF (.NOT. ALLOCATED(DstParamData%DOF_Flag)) THEN 
    ALLOCATE(DstParamData%DOF_Flag(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DOF_Flag.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DOF_Flag = SrcParamData%DOF_Flag
ENDIF
IF (ALLOCATED(SrcParamData%DOF_Desc)) THEN
  i1_l = LBOUND(SrcParamData%DOF_Desc,1)
  i1_u = UBOUND(SrcParamData%DOF_Desc,1)
  IF (.NOT. ALLOCATED(DstParamData%DOF_Desc)) THEN 
    ALLOCATE(DstParamData%DOF_Desc(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DOF_Desc.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DOF_Desc = SrcParamData%DOF_Desc
ENDIF
      CALL ED_Copyactivedofs( SrcParamData%DOFs, DstParamData%DOFs, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%OutFmt = SrcParamData%OutFmt
    DstParamData%NBlGages = SrcParamData%NBlGages
    DstParamData%NTwGages = SrcParamData%NTwGages
IF (ALLOCATED(SrcParamData%OutParam)) THEN
  i1_l = LBOUND(SrcParamData%OutParam,1)
  i1_u = UBOUND(SrcParamData%OutParam,1)
  IF (.NOT. ALLOCATED(DstParamData%OutParam)) THEN 
    ALLOCATE(DstParamData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%OutParam,1), UBOUND(SrcParamData%OutParam,1)
      CALL NWTC_Library_Copyoutparmtype( SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%Delim = SrcParamData%Delim
    DstParamData%AvgNrmTpRd = SrcParamData%AvgNrmTpRd
    DstParamData%AzimB1Up = SrcParamData%AzimB1Up
    DstParamData%CosDel3 = SrcParamData%CosDel3
IF (ALLOCATED(SrcParamData%CosPreC)) THEN
  i1_l = LBOUND(SrcParamData%CosPreC,1)
  i1_u = UBOUND(SrcParamData%CosPreC,1)
  IF (.NOT. ALLOCATED(DstParamData%CosPreC)) THEN 
    ALLOCATE(DstParamData%CosPreC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CosPreC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CosPreC = SrcParamData%CosPreC
ENDIF
    DstParamData%CRFrlSkew = SrcParamData%CRFrlSkew
    DstParamData%CRFrlSkw2 = SrcParamData%CRFrlSkw2
    DstParamData%CRFrlTilt = SrcParamData%CRFrlTilt
    DstParamData%CRFrlTlt2 = SrcParamData%CRFrlTlt2
    DstParamData%CShftSkew = SrcParamData%CShftSkew
    DstParamData%CShftTilt = SrcParamData%CShftTilt
    DstParamData%CSRFrlSkw = SrcParamData%CSRFrlSkw
    DstParamData%CSRFrlTlt = SrcParamData%CSRFrlTlt
    DstParamData%CSTFrlSkw = SrcParamData%CSTFrlSkw
    DstParamData%CSTFrlTlt = SrcParamData%CSTFrlTlt
    DstParamData%CTFinBank = SrcParamData%CTFinBank
    DstParamData%CTFinSkew = SrcParamData%CTFinSkew
    DstParamData%CTFinTilt = SrcParamData%CTFinTilt
    DstParamData%CTFrlSkew = SrcParamData%CTFrlSkew
    DstParamData%CTFrlSkw2 = SrcParamData%CTFrlSkw2
    DstParamData%CTFrlTilt = SrcParamData%CTFrlTilt
    DstParamData%CTFrlTlt2 = SrcParamData%CTFrlTlt2
    DstParamData%HubHt = SrcParamData%HubHt
    DstParamData%HubCM = SrcParamData%HubCM
    DstParamData%HubRad = SrcParamData%HubRad
    DstParamData%NacCMxn = SrcParamData%NacCMxn
    DstParamData%NacCMyn = SrcParamData%NacCMyn
    DstParamData%NacCMzn = SrcParamData%NacCMzn
    DstParamData%OverHang = SrcParamData%OverHang
    DstParamData%ProjArea = SrcParamData%ProjArea
    DstParamData%PtfmRefzt = SrcParamData%PtfmRefzt
    DstParamData%RefTwrHt = SrcParamData%RefTwrHt
    DstParamData%RFrlPntxn = SrcParamData%RFrlPntxn
    DstParamData%RFrlPntyn = SrcParamData%RFrlPntyn
    DstParamData%RFrlPntzn = SrcParamData%RFrlPntzn
    DstParamData%rVDxn = SrcParamData%rVDxn
    DstParamData%rVDyn = SrcParamData%rVDyn
    DstParamData%rVDzn = SrcParamData%rVDzn
    DstParamData%rVIMUxn = SrcParamData%rVIMUxn
    DstParamData%rVIMUyn = SrcParamData%rVIMUyn
    DstParamData%rVIMUzn = SrcParamData%rVIMUzn
    DstParamData%rVPxn = SrcParamData%rVPxn
    DstParamData%rVPyn = SrcParamData%rVPyn
    DstParamData%rVPzn = SrcParamData%rVPzn
    DstParamData%rWIxn = SrcParamData%rWIxn
    DstParamData%rWIyn = SrcParamData%rWIyn
    DstParamData%rWIzn = SrcParamData%rWIzn
    DstParamData%rWJxn = SrcParamData%rWJxn
    DstParamData%rWJyn = SrcParamData%rWJyn
    DstParamData%rWJzn = SrcParamData%rWJzn
    DstParamData%rWKxn = SrcParamData%rWKxn
    DstParamData%rWKyn = SrcParamData%rWKyn
    DstParamData%rWKzn = SrcParamData%rWKzn
    DstParamData%rZT0zt = SrcParamData%rZT0zt
    DstParamData%rZYzt = SrcParamData%rZYzt
    DstParamData%SinDel3 = SrcParamData%SinDel3
IF (ALLOCATED(SrcParamData%SinPreC)) THEN
  i1_l = LBOUND(SrcParamData%SinPreC,1)
  i1_u = UBOUND(SrcParamData%SinPreC,1)
  IF (.NOT. ALLOCATED(DstParamData%SinPreC)) THEN 
    ALLOCATE(DstParamData%SinPreC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SinPreC.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%SinPreC = SrcParamData%SinPreC
ENDIF
    DstParamData%SRFrlSkew = SrcParamData%SRFrlSkew
    DstParamData%SRFrlSkw2 = SrcParamData%SRFrlSkw2
    DstParamData%SRFrlTilt = SrcParamData%SRFrlTilt
    DstParamData%SRFrlTlt2 = SrcParamData%SRFrlTlt2
    DstParamData%SShftSkew = SrcParamData%SShftSkew
    DstParamData%SShftTilt = SrcParamData%SShftTilt
    DstParamData%STFinBank = SrcParamData%STFinBank
    DstParamData%STFinSkew = SrcParamData%STFinSkew
    DstParamData%STFinTilt = SrcParamData%STFinTilt
    DstParamData%STFrlSkew = SrcParamData%STFrlSkew
    DstParamData%STFrlSkw2 = SrcParamData%STFrlSkw2
    DstParamData%STFrlTilt = SrcParamData%STFrlTilt
    DstParamData%STFrlTlt2 = SrcParamData%STFrlTlt2
    DstParamData%TFrlPntxn = SrcParamData%TFrlPntxn
    DstParamData%TFrlPntyn = SrcParamData%TFrlPntyn
    DstParamData%TFrlPntzn = SrcParamData%TFrlPntzn
    DstParamData%TipRad = SrcParamData%TipRad
    DstParamData%TowerHt = SrcParamData%TowerHt
    DstParamData%TowerBsHt = SrcParamData%TowerBsHt
    DstParamData%UndSling = SrcParamData%UndSling
    DstParamData%NumBl = SrcParamData%NumBl
IF (ALLOCATED(SrcParamData%AxRedTFA)) THEN
  i1_l = LBOUND(SrcParamData%AxRedTFA,1)
  i1_u = UBOUND(SrcParamData%AxRedTFA,1)
  i2_l = LBOUND(SrcParamData%AxRedTFA,2)
  i2_u = UBOUND(SrcParamData%AxRedTFA,2)
  i3_l = LBOUND(SrcParamData%AxRedTFA,3)
  i3_u = UBOUND(SrcParamData%AxRedTFA,3)
  IF (.NOT. ALLOCATED(DstParamData%AxRedTFA)) THEN 
    ALLOCATE(DstParamData%AxRedTFA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedTFA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AxRedTFA = SrcParamData%AxRedTFA
ENDIF
IF (ALLOCATED(SrcParamData%AxRedTSS)) THEN
  i1_l = LBOUND(SrcParamData%AxRedTSS,1)
  i1_u = UBOUND(SrcParamData%AxRedTSS,1)
  i2_l = LBOUND(SrcParamData%AxRedTSS,2)
  i2_u = UBOUND(SrcParamData%AxRedTSS,2)
  i3_l = LBOUND(SrcParamData%AxRedTSS,3)
  i3_u = UBOUND(SrcParamData%AxRedTSS,3)
  IF (.NOT. ALLOCATED(DstParamData%AxRedTSS)) THEN 
    ALLOCATE(DstParamData%AxRedTSS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedTSS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AxRedTSS = SrcParamData%AxRedTSS
ENDIF
    DstParamData%CTFA = SrcParamData%CTFA
    DstParamData%CTSS = SrcParamData%CTSS
IF (ALLOCATED(SrcParamData%DHNodes)) THEN
  i1_l = LBOUND(SrcParamData%DHNodes,1)
  i1_u = UBOUND(SrcParamData%DHNodes,1)
  IF (.NOT. ALLOCATED(DstParamData%DHNodes)) THEN 
    ALLOCATE(DstParamData%DHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DHNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DHNodes = SrcParamData%DHNodes
ENDIF
IF (ALLOCATED(SrcParamData%HNodes)) THEN
  i1_l = LBOUND(SrcParamData%HNodes,1)
  i1_u = UBOUND(SrcParamData%HNodes,1)
  IF (.NOT. ALLOCATED(DstParamData%HNodes)) THEN 
    ALLOCATE(DstParamData%HNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%HNodes = SrcParamData%HNodes
ENDIF
IF (ALLOCATED(SrcParamData%HNodesNorm)) THEN
  i1_l = LBOUND(SrcParamData%HNodesNorm,1)
  i1_u = UBOUND(SrcParamData%HNodesNorm,1)
  IF (.NOT. ALLOCATED(DstParamData%HNodesNorm)) THEN 
    ALLOCATE(DstParamData%HNodesNorm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%HNodesNorm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%HNodesNorm = SrcParamData%HNodesNorm
ENDIF
    DstParamData%KTFA = SrcParamData%KTFA
    DstParamData%KTSS = SrcParamData%KTSS
IF (ALLOCATED(SrcParamData%MassT)) THEN
  i1_l = LBOUND(SrcParamData%MassT,1)
  i1_u = UBOUND(SrcParamData%MassT,1)
  IF (.NOT. ALLOCATED(DstParamData%MassT)) THEN 
    ALLOCATE(DstParamData%MassT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MassT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%MassT = SrcParamData%MassT
ENDIF
IF (ALLOCATED(SrcParamData%StiffTSS)) THEN
  i1_l = LBOUND(SrcParamData%StiffTSS,1)
  i1_u = UBOUND(SrcParamData%StiffTSS,1)
  IF (.NOT. ALLOCATED(DstParamData%StiffTSS)) THEN 
    ALLOCATE(DstParamData%StiffTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTSS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffTSS = SrcParamData%StiffTSS
ENDIF
IF (ALLOCATED(SrcParamData%TwrFASF)) THEN
  i1_l = LBOUND(SrcParamData%TwrFASF,1)
  i1_u = UBOUND(SrcParamData%TwrFASF,1)
  i2_l = LBOUND(SrcParamData%TwrFASF,2)
  i2_u = UBOUND(SrcParamData%TwrFASF,2)
  i3_l = LBOUND(SrcParamData%TwrFASF,3)
  i3_u = UBOUND(SrcParamData%TwrFASF,3)
  IF (.NOT. ALLOCATED(DstParamData%TwrFASF)) THEN 
    ALLOCATE(DstParamData%TwrFASF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwrFASF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TwrFASF = SrcParamData%TwrFASF
ENDIF
    DstParamData%TwrFlexL = SrcParamData%TwrFlexL
IF (ALLOCATED(SrcParamData%TwrSSSF)) THEN
  i1_l = LBOUND(SrcParamData%TwrSSSF,1)
  i1_u = UBOUND(SrcParamData%TwrSSSF,1)
  i2_l = LBOUND(SrcParamData%TwrSSSF,2)
  i2_u = UBOUND(SrcParamData%TwrSSSF,2)
  i3_l = LBOUND(SrcParamData%TwrSSSF,3)
  i3_u = UBOUND(SrcParamData%TwrSSSF,3)
  IF (.NOT. ALLOCATED(DstParamData%TwrSSSF)) THEN 
    ALLOCATE(DstParamData%TwrSSSF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwrSSSF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TwrSSSF = SrcParamData%TwrSSSF
ENDIF
    DstParamData%TTopNode = SrcParamData%TTopNode
    DstParamData%TwrNodes = SrcParamData%TwrNodes
IF (ALLOCATED(SrcParamData%InerTFA)) THEN
  i1_l = LBOUND(SrcParamData%InerTFA,1)
  i1_u = UBOUND(SrcParamData%InerTFA,1)
  IF (.NOT. ALLOCATED(DstParamData%InerTFA)) THEN 
    ALLOCATE(DstParamData%InerTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%InerTFA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%InerTFA = SrcParamData%InerTFA
ENDIF
IF (ALLOCATED(SrcParamData%InerTSS)) THEN
  i1_l = LBOUND(SrcParamData%InerTSS,1)
  i1_u = UBOUND(SrcParamData%InerTSS,1)
  IF (.NOT. ALLOCATED(DstParamData%InerTSS)) THEN 
    ALLOCATE(DstParamData%InerTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%InerTSS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%InerTSS = SrcParamData%InerTSS
ENDIF
IF (ALLOCATED(SrcParamData%StiffTGJ)) THEN
  i1_l = LBOUND(SrcParamData%StiffTGJ,1)
  i1_u = UBOUND(SrcParamData%StiffTGJ,1)
  IF (.NOT. ALLOCATED(DstParamData%StiffTGJ)) THEN 
    ALLOCATE(DstParamData%StiffTGJ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTGJ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffTGJ = SrcParamData%StiffTGJ
ENDIF
IF (ALLOCATED(SrcParamData%StiffTEA)) THEN
  i1_l = LBOUND(SrcParamData%StiffTEA,1)
  i1_u = UBOUND(SrcParamData%StiffTEA,1)
  IF (.NOT. ALLOCATED(DstParamData%StiffTEA)) THEN 
    ALLOCATE(DstParamData%StiffTEA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTEA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffTEA = SrcParamData%StiffTEA
ENDIF
IF (ALLOCATED(SrcParamData%StiffTFA)) THEN
  i1_l = LBOUND(SrcParamData%StiffTFA,1)
  i1_u = UBOUND(SrcParamData%StiffTFA,1)
  IF (.NOT. ALLOCATED(DstParamData%StiffTFA)) THEN 
    ALLOCATE(DstParamData%StiffTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffTFA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffTFA = SrcParamData%StiffTFA
ENDIF
IF (ALLOCATED(SrcParamData%cgOffTFA)) THEN
  i1_l = LBOUND(SrcParamData%cgOffTFA,1)
  i1_u = UBOUND(SrcParamData%cgOffTFA,1)
  IF (.NOT. ALLOCATED(DstParamData%cgOffTFA)) THEN 
    ALLOCATE(DstParamData%cgOffTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%cgOffTFA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%cgOffTFA = SrcParamData%cgOffTFA
ENDIF
IF (ALLOCATED(SrcParamData%cgOffTSS)) THEN
  i1_l = LBOUND(SrcParamData%cgOffTSS,1)
  i1_u = UBOUND(SrcParamData%cgOffTSS,1)
  IF (.NOT. ALLOCATED(DstParamData%cgOffTSS)) THEN 
    ALLOCATE(DstParamData%cgOffTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%cgOffTSS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%cgOffTSS = SrcParamData%cgOffTSS
ENDIF
    DstParamData%AtfaIner = SrcParamData%AtfaIner
IF (ALLOCATED(SrcParamData%BldCG)) THEN
  i1_l = LBOUND(SrcParamData%BldCG,1)
  i1_u = UBOUND(SrcParamData%BldCG,1)
  IF (.NOT. ALLOCATED(DstParamData%BldCG)) THEN 
    ALLOCATE(DstParamData%BldCG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldCG.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldCG = SrcParamData%BldCG
ENDIF
IF (ALLOCATED(SrcParamData%BldMass)) THEN
  i1_l = LBOUND(SrcParamData%BldMass,1)
  i1_u = UBOUND(SrcParamData%BldMass,1)
  IF (.NOT. ALLOCATED(DstParamData%BldMass)) THEN 
    ALLOCATE(DstParamData%BldMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldMass = SrcParamData%BldMass
ENDIF
    DstParamData%BoomMass = SrcParamData%BoomMass
IF (ALLOCATED(SrcParamData%FirstMom)) THEN
  i1_l = LBOUND(SrcParamData%FirstMom,1)
  i1_u = UBOUND(SrcParamData%FirstMom,1)
  IF (.NOT. ALLOCATED(DstParamData%FirstMom)) THEN 
    ALLOCATE(DstParamData%FirstMom(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FirstMom.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FirstMom = SrcParamData%FirstMom
ENDIF
    DstParamData%GenIner = SrcParamData%GenIner
    DstParamData%Hubg1Iner = SrcParamData%Hubg1Iner
    DstParamData%Hubg2Iner = SrcParamData%Hubg2Iner
    DstParamData%HubMass = SrcParamData%HubMass
    DstParamData%Nacd2Iner = SrcParamData%Nacd2Iner
    DstParamData%NacMass = SrcParamData%NacMass
    DstParamData%PtfmMass = SrcParamData%PtfmMass
    DstParamData%PtfmPIner = SrcParamData%PtfmPIner
    DstParamData%PtfmRIner = SrcParamData%PtfmRIner
    DstParamData%PtfmYIner = SrcParamData%PtfmYIner
    DstParamData%RFrlMass = SrcParamData%RFrlMass
    DstParamData%RotIner = SrcParamData%RotIner
    DstParamData%RotMass = SrcParamData%RotMass
    DstParamData%RrfaIner = SrcParamData%RrfaIner
IF (ALLOCATED(SrcParamData%SecondMom)) THEN
  i1_l = LBOUND(SrcParamData%SecondMom,1)
  i1_u = UBOUND(SrcParamData%SecondMom,1)
  IF (.NOT. ALLOCATED(DstParamData%SecondMom)) THEN 
    ALLOCATE(DstParamData%SecondMom(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SecondMom.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%SecondMom = SrcParamData%SecondMom
ENDIF
    DstParamData%TFinMass = SrcParamData%TFinMass
    DstParamData%TFrlIner = SrcParamData%TFrlIner
IF (ALLOCATED(SrcParamData%TipMass)) THEN
  i1_l = LBOUND(SrcParamData%TipMass,1)
  i1_u = UBOUND(SrcParamData%TipMass,1)
  IF (.NOT. ALLOCATED(DstParamData%TipMass)) THEN 
    ALLOCATE(DstParamData%TipMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TipMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TipMass = SrcParamData%TipMass
ENDIF
    DstParamData%TurbMass = SrcParamData%TurbMass
    DstParamData%TwrMass = SrcParamData%TwrMass
    DstParamData%TwrTpMass = SrcParamData%TwrTpMass
    DstParamData%YawBrMass = SrcParamData%YawBrMass
    DstParamData%Gravity = SrcParamData%Gravity
IF (ALLOCATED(SrcParamData%PitchAxis)) THEN
  i1_l = LBOUND(SrcParamData%PitchAxis,1)
  i1_u = UBOUND(SrcParamData%PitchAxis,1)
  i2_l = LBOUND(SrcParamData%PitchAxis,2)
  i2_u = UBOUND(SrcParamData%PitchAxis,2)
  IF (.NOT. ALLOCATED(DstParamData%PitchAxis)) THEN 
    ALLOCATE(DstParamData%PitchAxis(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%PitchAxis.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%PitchAxis = SrcParamData%PitchAxis
ENDIF
IF (ALLOCATED(SrcParamData%AeroTwst)) THEN
  i1_l = LBOUND(SrcParamData%AeroTwst,1)
  i1_u = UBOUND(SrcParamData%AeroTwst,1)
  IF (.NOT. ALLOCATED(DstParamData%AeroTwst)) THEN 
    ALLOCATE(DstParamData%AeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AeroTwst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AeroTwst = SrcParamData%AeroTwst
ENDIF
IF (ALLOCATED(SrcParamData%AxRedBld)) THEN
  i1_l = LBOUND(SrcParamData%AxRedBld,1)
  i1_u = UBOUND(SrcParamData%AxRedBld,1)
  i2_l = LBOUND(SrcParamData%AxRedBld,2)
  i2_u = UBOUND(SrcParamData%AxRedBld,2)
  i3_l = LBOUND(SrcParamData%AxRedBld,3)
  i3_u = UBOUND(SrcParamData%AxRedBld,3)
  i4_l = LBOUND(SrcParamData%AxRedBld,4)
  i4_u = UBOUND(SrcParamData%AxRedBld,4)
  IF (.NOT. ALLOCATED(DstParamData%AxRedBld)) THEN 
    ALLOCATE(DstParamData%AxRedBld(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AxRedBld.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AxRedBld = SrcParamData%AxRedBld
ENDIF
IF (ALLOCATED(SrcParamData%BAlpha)) THEN
  i1_l = LBOUND(SrcParamData%BAlpha,1)
  i1_u = UBOUND(SrcParamData%BAlpha,1)
  i2_l = LBOUND(SrcParamData%BAlpha,2)
  i2_u = UBOUND(SrcParamData%BAlpha,2)
  IF (.NOT. ALLOCATED(DstParamData%BAlpha)) THEN 
    ALLOCATE(DstParamData%BAlpha(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BAlpha.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BAlpha = SrcParamData%BAlpha
ENDIF
IF (ALLOCATED(SrcParamData%BldEDamp)) THEN
  i1_l = LBOUND(SrcParamData%BldEDamp,1)
  i1_u = UBOUND(SrcParamData%BldEDamp,1)
  i2_l = LBOUND(SrcParamData%BldEDamp,2)
  i2_u = UBOUND(SrcParamData%BldEDamp,2)
  IF (.NOT. ALLOCATED(DstParamData%BldEDamp)) THEN 
    ALLOCATE(DstParamData%BldEDamp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldEDamp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldEDamp = SrcParamData%BldEDamp
ENDIF
IF (ALLOCATED(SrcParamData%BldFDamp)) THEN
  i1_l = LBOUND(SrcParamData%BldFDamp,1)
  i1_u = UBOUND(SrcParamData%BldFDamp,1)
  i2_l = LBOUND(SrcParamData%BldFDamp,2)
  i2_u = UBOUND(SrcParamData%BldFDamp,2)
  IF (.NOT. ALLOCATED(DstParamData%BldFDamp)) THEN 
    ALLOCATE(DstParamData%BldFDamp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFDamp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldFDamp = SrcParamData%BldFDamp
ENDIF
    DstParamData%BldFlexL = SrcParamData%BldFlexL
IF (ALLOCATED(SrcParamData%CAeroTwst)) THEN
  i1_l = LBOUND(SrcParamData%CAeroTwst,1)
  i1_u = UBOUND(SrcParamData%CAeroTwst,1)
  IF (.NOT. ALLOCATED(DstParamData%CAeroTwst)) THEN 
    ALLOCATE(DstParamData%CAeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CAeroTwst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CAeroTwst = SrcParamData%CAeroTwst
ENDIF
IF (ALLOCATED(SrcParamData%CBE)) THEN
  i1_l = LBOUND(SrcParamData%CBE,1)
  i1_u = UBOUND(SrcParamData%CBE,1)
  i2_l = LBOUND(SrcParamData%CBE,2)
  i2_u = UBOUND(SrcParamData%CBE,2)
  i3_l = LBOUND(SrcParamData%CBE,3)
  i3_u = UBOUND(SrcParamData%CBE,3)
  IF (.NOT. ALLOCATED(DstParamData%CBE)) THEN 
    ALLOCATE(DstParamData%CBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CBE = SrcParamData%CBE
ENDIF
IF (ALLOCATED(SrcParamData%CBF)) THEN
  i1_l = LBOUND(SrcParamData%CBF,1)
  i1_u = UBOUND(SrcParamData%CBF,1)
  i2_l = LBOUND(SrcParamData%CBF,2)
  i2_u = UBOUND(SrcParamData%CBF,2)
  i3_l = LBOUND(SrcParamData%CBF,3)
  i3_u = UBOUND(SrcParamData%CBF,3)
  IF (.NOT. ALLOCATED(DstParamData%CBF)) THEN 
    ALLOCATE(DstParamData%CBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CBF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CBF = SrcParamData%CBF
ENDIF
IF (ALLOCATED(SrcParamData%cgOffBEdg)) THEN
  i1_l = LBOUND(SrcParamData%cgOffBEdg,1)
  i1_u = UBOUND(SrcParamData%cgOffBEdg,1)
  i2_l = LBOUND(SrcParamData%cgOffBEdg,2)
  i2_u = UBOUND(SrcParamData%cgOffBEdg,2)
  IF (.NOT. ALLOCATED(DstParamData%cgOffBEdg)) THEN 
    ALLOCATE(DstParamData%cgOffBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%cgOffBEdg.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%cgOffBEdg = SrcParamData%cgOffBEdg
ENDIF
IF (ALLOCATED(SrcParamData%cgOffBFlp)) THEN
  i1_l = LBOUND(SrcParamData%cgOffBFlp,1)
  i1_u = UBOUND(SrcParamData%cgOffBFlp,1)
  i2_l = LBOUND(SrcParamData%cgOffBFlp,2)
  i2_u = UBOUND(SrcParamData%cgOffBFlp,2)
  IF (.NOT. ALLOCATED(DstParamData%cgOffBFlp)) THEN 
    ALLOCATE(DstParamData%cgOffBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%cgOffBFlp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%cgOffBFlp = SrcParamData%cgOffBFlp
ENDIF
IF (ALLOCATED(SrcParamData%Chord)) THEN
  i1_l = LBOUND(SrcParamData%Chord,1)
  i1_u = UBOUND(SrcParamData%Chord,1)
  IF (.NOT. ALLOCATED(DstParamData%Chord)) THEN 
    ALLOCATE(DstParamData%Chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Chord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Chord = SrcParamData%Chord
ENDIF
IF (ALLOCATED(SrcParamData%CThetaS)) THEN
  i1_l = LBOUND(SrcParamData%CThetaS,1)
  i1_u = UBOUND(SrcParamData%CThetaS,1)
  i2_l = LBOUND(SrcParamData%CThetaS,2)
  i2_u = UBOUND(SrcParamData%CThetaS,2)
  IF (.NOT. ALLOCATED(DstParamData%CThetaS)) THEN 
    ALLOCATE(DstParamData%CThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CThetaS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CThetaS = SrcParamData%CThetaS
ENDIF
IF (ALLOCATED(SrcParamData%DRNodes)) THEN
  i1_l = LBOUND(SrcParamData%DRNodes,1)
  i1_u = UBOUND(SrcParamData%DRNodes,1)
  IF (.NOT. ALLOCATED(DstParamData%DRNodes)) THEN 
    ALLOCATE(DstParamData%DRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DRNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%DRNodes = SrcParamData%DRNodes
ENDIF
IF (ALLOCATED(SrcParamData%EAOffBEdg)) THEN
  i1_l = LBOUND(SrcParamData%EAOffBEdg,1)
  i1_u = UBOUND(SrcParamData%EAOffBEdg,1)
  i2_l = LBOUND(SrcParamData%EAOffBEdg,2)
  i2_u = UBOUND(SrcParamData%EAOffBEdg,2)
  IF (.NOT. ALLOCATED(DstParamData%EAOffBEdg)) THEN 
    ALLOCATE(DstParamData%EAOffBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EAOffBEdg.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%EAOffBEdg = SrcParamData%EAOffBEdg
ENDIF
IF (ALLOCATED(SrcParamData%EAOffBFlp)) THEN
  i1_l = LBOUND(SrcParamData%EAOffBFlp,1)
  i1_u = UBOUND(SrcParamData%EAOffBFlp,1)
  i2_l = LBOUND(SrcParamData%EAOffBFlp,2)
  i2_u = UBOUND(SrcParamData%EAOffBFlp,2)
  IF (.NOT. ALLOCATED(DstParamData%EAOffBFlp)) THEN 
    ALLOCATE(DstParamData%EAOffBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EAOffBFlp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%EAOffBFlp = SrcParamData%EAOffBFlp
ENDIF
IF (ALLOCATED(SrcParamData%FStTunr)) THEN
  i1_l = LBOUND(SrcParamData%FStTunr,1)
  i1_u = UBOUND(SrcParamData%FStTunr,1)
  i2_l = LBOUND(SrcParamData%FStTunr,2)
  i2_u = UBOUND(SrcParamData%FStTunr,2)
  IF (.NOT. ALLOCATED(DstParamData%FStTunr)) THEN 
    ALLOCATE(DstParamData%FStTunr(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FStTunr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FStTunr = SrcParamData%FStTunr
ENDIF
IF (ALLOCATED(SrcParamData%InerBEdg)) THEN
  i1_l = LBOUND(SrcParamData%InerBEdg,1)
  i1_u = UBOUND(SrcParamData%InerBEdg,1)
  i2_l = LBOUND(SrcParamData%InerBEdg,2)
  i2_u = UBOUND(SrcParamData%InerBEdg,2)
  IF (.NOT. ALLOCATED(DstParamData%InerBEdg)) THEN 
    ALLOCATE(DstParamData%InerBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%InerBEdg.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%InerBEdg = SrcParamData%InerBEdg
ENDIF
IF (ALLOCATED(SrcParamData%InerBFlp)) THEN
  i1_l = LBOUND(SrcParamData%InerBFlp,1)
  i1_u = UBOUND(SrcParamData%InerBFlp,1)
  i2_l = LBOUND(SrcParamData%InerBFlp,2)
  i2_u = UBOUND(SrcParamData%InerBFlp,2)
  IF (.NOT. ALLOCATED(DstParamData%InerBFlp)) THEN 
    ALLOCATE(DstParamData%InerBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%InerBFlp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%InerBFlp = SrcParamData%InerBFlp
ENDIF
IF (ALLOCATED(SrcParamData%KBE)) THEN
  i1_l = LBOUND(SrcParamData%KBE,1)
  i1_u = UBOUND(SrcParamData%KBE,1)
  i2_l = LBOUND(SrcParamData%KBE,2)
  i2_u = UBOUND(SrcParamData%KBE,2)
  i3_l = LBOUND(SrcParamData%KBE,3)
  i3_u = UBOUND(SrcParamData%KBE,3)
  IF (.NOT. ALLOCATED(DstParamData%KBE)) THEN 
    ALLOCATE(DstParamData%KBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%KBE = SrcParamData%KBE
ENDIF
IF (ALLOCATED(SrcParamData%KBF)) THEN
  i1_l = LBOUND(SrcParamData%KBF,1)
  i1_u = UBOUND(SrcParamData%KBF,1)
  i2_l = LBOUND(SrcParamData%KBF,2)
  i2_u = UBOUND(SrcParamData%KBF,2)
  i3_l = LBOUND(SrcParamData%KBF,3)
  i3_u = UBOUND(SrcParamData%KBF,3)
  IF (.NOT. ALLOCATED(DstParamData%KBF)) THEN 
    ALLOCATE(DstParamData%KBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%KBF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%KBF = SrcParamData%KBF
ENDIF
IF (ALLOCATED(SrcParamData%MassB)) THEN
  i1_l = LBOUND(SrcParamData%MassB,1)
  i1_u = UBOUND(SrcParamData%MassB,1)
  i2_l = LBOUND(SrcParamData%MassB,2)
  i2_u = UBOUND(SrcParamData%MassB,2)
  IF (.NOT. ALLOCATED(DstParamData%MassB)) THEN 
    ALLOCATE(DstParamData%MassB(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%MassB.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%MassB = SrcParamData%MassB
ENDIF
IF (ALLOCATED(SrcParamData%RefAxisxb)) THEN
  i1_l = LBOUND(SrcParamData%RefAxisxb,1)
  i1_u = UBOUND(SrcParamData%RefAxisxb,1)
  i2_l = LBOUND(SrcParamData%RefAxisxb,2)
  i2_u = UBOUND(SrcParamData%RefAxisxb,2)
  IF (.NOT. ALLOCATED(DstParamData%RefAxisxb)) THEN 
    ALLOCATE(DstParamData%RefAxisxb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RefAxisxb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%RefAxisxb = SrcParamData%RefAxisxb
ENDIF
IF (ALLOCATED(SrcParamData%RefAxisyb)) THEN
  i1_l = LBOUND(SrcParamData%RefAxisyb,1)
  i1_u = UBOUND(SrcParamData%RefAxisyb,1)
  i2_l = LBOUND(SrcParamData%RefAxisyb,2)
  i2_u = UBOUND(SrcParamData%RefAxisyb,2)
  IF (.NOT. ALLOCATED(DstParamData%RefAxisyb)) THEN 
    ALLOCATE(DstParamData%RefAxisyb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RefAxisyb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%RefAxisyb = SrcParamData%RefAxisyb
ENDIF
IF (ALLOCATED(SrcParamData%RNodes)) THEN
  i1_l = LBOUND(SrcParamData%RNodes,1)
  i1_u = UBOUND(SrcParamData%RNodes,1)
  IF (.NOT. ALLOCATED(DstParamData%RNodes)) THEN 
    ALLOCATE(DstParamData%RNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%RNodes = SrcParamData%RNodes
ENDIF
IF (ALLOCATED(SrcParamData%RNodesNorm)) THEN
  i1_l = LBOUND(SrcParamData%RNodesNorm,1)
  i1_u = UBOUND(SrcParamData%RNodesNorm,1)
  IF (.NOT. ALLOCATED(DstParamData%RNodesNorm)) THEN 
    ALLOCATE(DstParamData%RNodesNorm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%RNodesNorm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%RNodesNorm = SrcParamData%RNodesNorm
ENDIF
IF (ALLOCATED(SrcParamData%rSAerCenn1)) THEN
  i1_l = LBOUND(SrcParamData%rSAerCenn1,1)
  i1_u = UBOUND(SrcParamData%rSAerCenn1,1)
  i2_l = LBOUND(SrcParamData%rSAerCenn1,2)
  i2_u = UBOUND(SrcParamData%rSAerCenn1,2)
  IF (.NOT. ALLOCATED(DstParamData%rSAerCenn1)) THEN 
    ALLOCATE(DstParamData%rSAerCenn1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rSAerCenn1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rSAerCenn1 = SrcParamData%rSAerCenn1
ENDIF
IF (ALLOCATED(SrcParamData%rSAerCenn2)) THEN
  i1_l = LBOUND(SrcParamData%rSAerCenn2,1)
  i1_u = UBOUND(SrcParamData%rSAerCenn2,1)
  i2_l = LBOUND(SrcParamData%rSAerCenn2,2)
  i2_u = UBOUND(SrcParamData%rSAerCenn2,2)
  IF (.NOT. ALLOCATED(DstParamData%rSAerCenn2)) THEN 
    ALLOCATE(DstParamData%rSAerCenn2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rSAerCenn2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rSAerCenn2 = SrcParamData%rSAerCenn2
ENDIF
IF (ALLOCATED(SrcParamData%SAeroTwst)) THEN
  i1_l = LBOUND(SrcParamData%SAeroTwst,1)
  i1_u = UBOUND(SrcParamData%SAeroTwst,1)
  IF (.NOT. ALLOCATED(DstParamData%SAeroTwst)) THEN 
    ALLOCATE(DstParamData%SAeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SAeroTwst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%SAeroTwst = SrcParamData%SAeroTwst
ENDIF
IF (ALLOCATED(SrcParamData%StiffBE)) THEN
  i1_l = LBOUND(SrcParamData%StiffBE,1)
  i1_u = UBOUND(SrcParamData%StiffBE,1)
  i2_l = LBOUND(SrcParamData%StiffBE,2)
  i2_u = UBOUND(SrcParamData%StiffBE,2)
  IF (.NOT. ALLOCATED(DstParamData%StiffBE)) THEN 
    ALLOCATE(DstParamData%StiffBE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffBE = SrcParamData%StiffBE
ENDIF
IF (ALLOCATED(SrcParamData%StiffBEA)) THEN
  i1_l = LBOUND(SrcParamData%StiffBEA,1)
  i1_u = UBOUND(SrcParamData%StiffBEA,1)
  i2_l = LBOUND(SrcParamData%StiffBEA,2)
  i2_u = UBOUND(SrcParamData%StiffBEA,2)
  IF (.NOT. ALLOCATED(DstParamData%StiffBEA)) THEN 
    ALLOCATE(DstParamData%StiffBEA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBEA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffBEA = SrcParamData%StiffBEA
ENDIF
IF (ALLOCATED(SrcParamData%StiffBF)) THEN
  i1_l = LBOUND(SrcParamData%StiffBF,1)
  i1_u = UBOUND(SrcParamData%StiffBF,1)
  i2_l = LBOUND(SrcParamData%StiffBF,2)
  i2_u = UBOUND(SrcParamData%StiffBF,2)
  IF (.NOT. ALLOCATED(DstParamData%StiffBF)) THEN 
    ALLOCATE(DstParamData%StiffBF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffBF = SrcParamData%StiffBF
ENDIF
IF (ALLOCATED(SrcParamData%StiffBGJ)) THEN
  i1_l = LBOUND(SrcParamData%StiffBGJ,1)
  i1_u = UBOUND(SrcParamData%StiffBGJ,1)
  i2_l = LBOUND(SrcParamData%StiffBGJ,2)
  i2_u = UBOUND(SrcParamData%StiffBGJ,2)
  IF (.NOT. ALLOCATED(DstParamData%StiffBGJ)) THEN 
    ALLOCATE(DstParamData%StiffBGJ(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StiffBGJ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StiffBGJ = SrcParamData%StiffBGJ
ENDIF
IF (ALLOCATED(SrcParamData%SThetaS)) THEN
  i1_l = LBOUND(SrcParamData%SThetaS,1)
  i1_u = UBOUND(SrcParamData%SThetaS,1)
  i2_l = LBOUND(SrcParamData%SThetaS,2)
  i2_u = UBOUND(SrcParamData%SThetaS,2)
  IF (.NOT. ALLOCATED(DstParamData%SThetaS)) THEN 
    ALLOCATE(DstParamData%SThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%SThetaS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%SThetaS = SrcParamData%SThetaS
ENDIF
IF (ALLOCATED(SrcParamData%ThetaS)) THEN
  i1_l = LBOUND(SrcParamData%ThetaS,1)
  i1_u = UBOUND(SrcParamData%ThetaS,1)
  i2_l = LBOUND(SrcParamData%ThetaS,2)
  i2_u = UBOUND(SrcParamData%ThetaS,2)
  IF (.NOT. ALLOCATED(DstParamData%ThetaS)) THEN 
    ALLOCATE(DstParamData%ThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ThetaS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ThetaS = SrcParamData%ThetaS
ENDIF
IF (ALLOCATED(SrcParamData%TwistedSF)) THEN
  i1_l = LBOUND(SrcParamData%TwistedSF,1)
  i1_u = UBOUND(SrcParamData%TwistedSF,1)
  i2_l = LBOUND(SrcParamData%TwistedSF,2)
  i2_u = UBOUND(SrcParamData%TwistedSF,2)
  i3_l = LBOUND(SrcParamData%TwistedSF,3)
  i3_u = UBOUND(SrcParamData%TwistedSF,3)
  i4_l = LBOUND(SrcParamData%TwistedSF,4)
  i4_u = UBOUND(SrcParamData%TwistedSF,4)
  i5_l = LBOUND(SrcParamData%TwistedSF,5)
  i5_u = UBOUND(SrcParamData%TwistedSF,5)
  IF (.NOT. ALLOCATED(DstParamData%TwistedSF)) THEN 
    ALLOCATE(DstParamData%TwistedSF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TwistedSF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TwistedSF = SrcParamData%TwistedSF
ENDIF
IF (ALLOCATED(SrcParamData%BldFl1Sh)) THEN
  i1_l = LBOUND(SrcParamData%BldFl1Sh,1)
  i1_u = UBOUND(SrcParamData%BldFl1Sh,1)
  i2_l = LBOUND(SrcParamData%BldFl1Sh,2)
  i2_u = UBOUND(SrcParamData%BldFl1Sh,2)
  IF (.NOT. ALLOCATED(DstParamData%BldFl1Sh)) THEN 
    ALLOCATE(DstParamData%BldFl1Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFl1Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldFl1Sh = SrcParamData%BldFl1Sh
ENDIF
IF (ALLOCATED(SrcParamData%BldFl2Sh)) THEN
  i1_l = LBOUND(SrcParamData%BldFl2Sh,1)
  i1_u = UBOUND(SrcParamData%BldFl2Sh,1)
  i2_l = LBOUND(SrcParamData%BldFl2Sh,2)
  i2_u = UBOUND(SrcParamData%BldFl2Sh,2)
  IF (.NOT. ALLOCATED(DstParamData%BldFl2Sh)) THEN 
    ALLOCATE(DstParamData%BldFl2Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldFl2Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldFl2Sh = SrcParamData%BldFl2Sh
ENDIF
IF (ALLOCATED(SrcParamData%BldEdgSh)) THEN
  i1_l = LBOUND(SrcParamData%BldEdgSh,1)
  i1_u = UBOUND(SrcParamData%BldEdgSh,1)
  i2_l = LBOUND(SrcParamData%BldEdgSh,2)
  i2_u = UBOUND(SrcParamData%BldEdgSh,2)
  IF (.NOT. ALLOCATED(DstParamData%BldEdgSh)) THEN 
    ALLOCATE(DstParamData%BldEdgSh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldEdgSh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BldEdgSh = SrcParamData%BldEdgSh
ENDIF
IF (ALLOCATED(SrcParamData%FreqBE)) THEN
  i1_l = LBOUND(SrcParamData%FreqBE,1)
  i1_u = UBOUND(SrcParamData%FreqBE,1)
  i2_l = LBOUND(SrcParamData%FreqBE,2)
  i2_u = UBOUND(SrcParamData%FreqBE,2)
  i3_l = LBOUND(SrcParamData%FreqBE,3)
  i3_u = UBOUND(SrcParamData%FreqBE,3)
  IF (.NOT. ALLOCATED(DstParamData%FreqBE)) THEN 
    ALLOCATE(DstParamData%FreqBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqBE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FreqBE = SrcParamData%FreqBE
ENDIF
IF (ALLOCATED(SrcParamData%FreqBF)) THEN
  i1_l = LBOUND(SrcParamData%FreqBF,1)
  i1_u = UBOUND(SrcParamData%FreqBF,1)
  i2_l = LBOUND(SrcParamData%FreqBF,2)
  i2_u = UBOUND(SrcParamData%FreqBF,2)
  i3_l = LBOUND(SrcParamData%FreqBF,3)
  i3_u = UBOUND(SrcParamData%FreqBF,3)
  IF (.NOT. ALLOCATED(DstParamData%FreqBF)) THEN 
    ALLOCATE(DstParamData%FreqBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqBF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FreqBF = SrcParamData%FreqBF
ENDIF
    DstParamData%FreqTFA = SrcParamData%FreqTFA
    DstParamData%FreqTSS = SrcParamData%FreqTSS
    DstParamData%TeetCDmp = SrcParamData%TeetCDmp
    DstParamData%TeetDmp = SrcParamData%TeetDmp
    DstParamData%TeetDmpP = SrcParamData%TeetDmpP
    DstParamData%TeetHSSp = SrcParamData%TeetHSSp
    DstParamData%TeetHStP = SrcParamData%TeetHStP
    DstParamData%TeetSSSp = SrcParamData%TeetSSSp
    DstParamData%TeetSStP = SrcParamData%TeetSStP
    DstParamData%TeetMod = SrcParamData%TeetMod
    DstParamData%TFrlCDmp = SrcParamData%TFrlCDmp
    DstParamData%TFrlDmp = SrcParamData%TFrlDmp
    DstParamData%TFrlDSDmp = SrcParamData%TFrlDSDmp
    DstParamData%TFrlDSDP = SrcParamData%TFrlDSDP
    DstParamData%TFrlDSSP = SrcParamData%TFrlDSSP
    DstParamData%TFrlDSSpr = SrcParamData%TFrlDSSpr
    DstParamData%TFrlSpr = SrcParamData%TFrlSpr
    DstParamData%TFrlUSDmp = SrcParamData%TFrlUSDmp
    DstParamData%TFrlUSDP = SrcParamData%TFrlUSDP
    DstParamData%TFrlUSSP = SrcParamData%TFrlUSSP
    DstParamData%TFrlUSSpr = SrcParamData%TFrlUSSpr
    DstParamData%TFrlMod = SrcParamData%TFrlMod
    DstParamData%RFrlCDmp = SrcParamData%RFrlCDmp
    DstParamData%RFrlDmp = SrcParamData%RFrlDmp
    DstParamData%RFrlDSDmp = SrcParamData%RFrlDSDmp
    DstParamData%RFrlDSDP = SrcParamData%RFrlDSDP
    DstParamData%RFrlDSSP = SrcParamData%RFrlDSSP
    DstParamData%RFrlDSSpr = SrcParamData%RFrlDSSpr
    DstParamData%RFrlSpr = SrcParamData%RFrlSpr
    DstParamData%RFrlUSDmp = SrcParamData%RFrlUSDmp
    DstParamData%RFrlUSDP = SrcParamData%RFrlUSDP
    DstParamData%RFrlUSSP = SrcParamData%RFrlUSSP
    DstParamData%RFrlUSSpr = SrcParamData%RFrlUSSpr
    DstParamData%RFrlMod = SrcParamData%RFrlMod
    DstParamData%ShftGagL = SrcParamData%ShftGagL
    DstParamData%BldGagNd = SrcParamData%BldGagNd
    DstParamData%TwrGagNd = SrcParamData%TwrGagNd
    DstParamData%TStart = SrcParamData%TStart
    DstParamData%DTTorDmp = SrcParamData%DTTorDmp
    DstParamData%DTTorSpr = SrcParamData%DTTorSpr
    DstParamData%GBRatio = SrcParamData%GBRatio
    DstParamData%GBoxEff = SrcParamData%GBoxEff
    DstParamData%RotSpeed = SrcParamData%RotSpeed
    DstParamData%RootName = SrcParamData%RootName
IF (ALLOCATED(SrcParamData%BElmntMass)) THEN
  i1_l = LBOUND(SrcParamData%BElmntMass,1)
  i1_u = UBOUND(SrcParamData%BElmntMass,1)
  i2_l = LBOUND(SrcParamData%BElmntMass,2)
  i2_u = UBOUND(SrcParamData%BElmntMass,2)
  IF (.NOT. ALLOCATED(DstParamData%BElmntMass)) THEN 
    ALLOCATE(DstParamData%BElmntMass(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BElmntMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BElmntMass = SrcParamData%BElmntMass
ENDIF
IF (ALLOCATED(SrcParamData%TElmntMass)) THEN
  i1_l = LBOUND(SrcParamData%TElmntMass,1)
  i1_u = UBOUND(SrcParamData%TElmntMass,1)
  IF (.NOT. ALLOCATED(DstParamData%TElmntMass)) THEN 
    ALLOCATE(DstParamData%TElmntMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TElmntMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TElmntMass = SrcParamData%TElmntMass
ENDIF
    DstParamData%method = SrcParamData%method
    DstParamData%PtfmCMxt = SrcParamData%PtfmCMxt
    DstParamData%PtfmCMyt = SrcParamData%PtfmCMyt
    DstParamData%BD4Blades = SrcParamData%BD4Blades
    DstParamData%UseAD14 = SrcParamData%UseAD14
    DstParamData%BldNd_NumOuts = SrcParamData%BldNd_NumOuts
    DstParamData%BldNd_TotNumOuts = SrcParamData%BldNd_TotNumOuts
IF (ALLOCATED(SrcParamData%BldNd_OutParam)) THEN
  i1_l = LBOUND(SrcParamData%BldNd_OutParam,1)
  i1_u = UBOUND(SrcParamData%BldNd_OutParam,1)
  IF (.NOT. ALLOCATED(DstParamData%BldNd_OutParam)) THEN 
    ALLOCATE(DstParamData%BldNd_OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BldNd_OutParam.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%BldNd_OutParam,1), UBOUND(SrcParamData%BldNd_OutParam,1)
      CALL NWTC_Library_Copyoutparmtype( SrcParamData%BldNd_OutParam(i1), DstParamData%BldNd_OutParam(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%BldNd_BladesOut = SrcParamData%BldNd_BladesOut
IF (ALLOCATED(SrcParamData%Jac_u_indx)) THEN
  i1_l = LBOUND(SrcParamData%Jac_u_indx,1)
  i1_u = UBOUND(SrcParamData%Jac_u_indx,1)
  i2_l = LBOUND(SrcParamData%Jac_u_indx,2)
  i2_u = UBOUND(SrcParamData%Jac_u_indx,2)
  IF (.NOT. ALLOCATED(DstParamData%Jac_u_indx)) THEN 
    ALLOCATE(DstParamData%Jac_u_indx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Jac_u_indx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Jac_u_indx = SrcParamData%Jac_u_indx
ENDIF
IF (ALLOCATED(SrcParamData%du)) THEN
  i1_l = LBOUND(SrcParamData%du,1)
  i1_u = UBOUND(SrcParamData%du,1)
  IF (.NOT. ALLOCATED(DstParamData%du)) THEN 
    ALLOCATE(DstParamData%du(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%du.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%du = SrcParamData%du
ENDIF
IF (ALLOCATED(SrcParamData%dx)) THEN
  i1_l = LBOUND(SrcParamData%dx,1)
  i1_u = UBOUND(SrcParamData%dx,1)
  IF (.NOT. ALLOCATED(DstParamData%dx)) THEN 
    ALLOCATE(DstParamData%dx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dx = SrcParamData%dx
ENDIF
    DstParamData%Jac_ny = SrcParamData%Jac_ny
 END SUBROUTINE ED_CopyParam

 SUBROUTINE ED_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(ED_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%PH)) THEN
  DEALLOCATE(ParamData%PH)
ENDIF
IF (ALLOCATED(ParamData%PM)) THEN
  DEALLOCATE(ParamData%PM)
ENDIF
IF (ALLOCATED(ParamData%DOF_Flag)) THEN
  DEALLOCATE(ParamData%DOF_Flag)
ENDIF
IF (ALLOCATED(ParamData%DOF_Desc)) THEN
  DEALLOCATE(ParamData%DOF_Desc)
ENDIF
  CALL ED_Destroyactivedofs( ParamData%DOFs, ErrStat, ErrMsg )
IF (ALLOCATED(ParamData%OutParam)) THEN
DO i1 = LBOUND(ParamData%OutParam,1), UBOUND(ParamData%OutParam,1)
  CALL NWTC_Library_Destroyoutparmtype( ParamData%OutParam(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%OutParam)
ENDIF
IF (ALLOCATED(ParamData%CosPreC)) THEN
  DEALLOCATE(ParamData%CosPreC)
ENDIF
IF (ALLOCATED(ParamData%SinPreC)) THEN
  DEALLOCATE(ParamData%SinPreC)
ENDIF
IF (ALLOCATED(ParamData%AxRedTFA)) THEN
  DEALLOCATE(ParamData%AxRedTFA)
ENDIF
IF (ALLOCATED(ParamData%AxRedTSS)) THEN
  DEALLOCATE(ParamData%AxRedTSS)
ENDIF
IF (ALLOCATED(ParamData%DHNodes)) THEN
  DEALLOCATE(ParamData%DHNodes)
ENDIF
IF (ALLOCATED(ParamData%HNodes)) THEN
  DEALLOCATE(ParamData%HNodes)
ENDIF
IF (ALLOCATED(ParamData%HNodesNorm)) THEN
  DEALLOCATE(ParamData%HNodesNorm)
ENDIF
IF (ALLOCATED(ParamData%MassT)) THEN
  DEALLOCATE(ParamData%MassT)
ENDIF
IF (ALLOCATED(ParamData%StiffTSS)) THEN
  DEALLOCATE(ParamData%StiffTSS)
ENDIF
IF (ALLOCATED(ParamData%TwrFASF)) THEN
  DEALLOCATE(ParamData%TwrFASF)
ENDIF
IF (ALLOCATED(ParamData%TwrSSSF)) THEN
  DEALLOCATE(ParamData%TwrSSSF)
ENDIF
IF (ALLOCATED(ParamData%InerTFA)) THEN
  DEALLOCATE(ParamData%InerTFA)
ENDIF
IF (ALLOCATED(ParamData%InerTSS)) THEN
  DEALLOCATE(ParamData%InerTSS)
ENDIF
IF (ALLOCATED(ParamData%StiffTGJ)) THEN
  DEALLOCATE(ParamData%StiffTGJ)
ENDIF
IF (ALLOCATED(ParamData%StiffTEA)) THEN
  DEALLOCATE(ParamData%StiffTEA)
ENDIF
IF (ALLOCATED(ParamData%StiffTFA)) THEN
  DEALLOCATE(ParamData%StiffTFA)
ENDIF
IF (ALLOCATED(ParamData%cgOffTFA)) THEN
  DEALLOCATE(ParamData%cgOffTFA)
ENDIF
IF (ALLOCATED(ParamData%cgOffTSS)) THEN
  DEALLOCATE(ParamData%cgOffTSS)
ENDIF
IF (ALLOCATED(ParamData%BldCG)) THEN
  DEALLOCATE(ParamData%BldCG)
ENDIF
IF (ALLOCATED(ParamData%BldMass)) THEN
  DEALLOCATE(ParamData%BldMass)
ENDIF
IF (ALLOCATED(ParamData%FirstMom)) THEN
  DEALLOCATE(ParamData%FirstMom)
ENDIF
IF (ALLOCATED(ParamData%SecondMom)) THEN
  DEALLOCATE(ParamData%SecondMom)
ENDIF
IF (ALLOCATED(ParamData%TipMass)) THEN
  DEALLOCATE(ParamData%TipMass)
ENDIF
IF (ALLOCATED(ParamData%PitchAxis)) THEN
  DEALLOCATE(ParamData%PitchAxis)
ENDIF
IF (ALLOCATED(ParamData%AeroTwst)) THEN
  DEALLOCATE(ParamData%AeroTwst)
ENDIF
IF (ALLOCATED(ParamData%AxRedBld)) THEN
  DEALLOCATE(ParamData%AxRedBld)
ENDIF
IF (ALLOCATED(ParamData%BAlpha)) THEN
  DEALLOCATE(ParamData%BAlpha)
ENDIF
IF (ALLOCATED(ParamData%BldEDamp)) THEN
  DEALLOCATE(ParamData%BldEDamp)
ENDIF
IF (ALLOCATED(ParamData%BldFDamp)) THEN
  DEALLOCATE(ParamData%BldFDamp)
ENDIF
IF (ALLOCATED(ParamData%CAeroTwst)) THEN
  DEALLOCATE(ParamData%CAeroTwst)
ENDIF
IF (ALLOCATED(ParamData%CBE)) THEN
  DEALLOCATE(ParamData%CBE)
ENDIF
IF (ALLOCATED(ParamData%CBF)) THEN
  DEALLOCATE(ParamData%CBF)
ENDIF
IF (ALLOCATED(ParamData%cgOffBEdg)) THEN
  DEALLOCATE(ParamData%cgOffBEdg)
ENDIF
IF (ALLOCATED(ParamData%cgOffBFlp)) THEN
  DEALLOCATE(ParamData%cgOffBFlp)
ENDIF
IF (ALLOCATED(ParamData%Chord)) THEN
  DEALLOCATE(ParamData%Chord)
ENDIF
IF (ALLOCATED(ParamData%CThetaS)) THEN
  DEALLOCATE(ParamData%CThetaS)
ENDIF
IF (ALLOCATED(ParamData%DRNodes)) THEN
  DEALLOCATE(ParamData%DRNodes)
ENDIF
IF (ALLOCATED(ParamData%EAOffBEdg)) THEN
  DEALLOCATE(ParamData%EAOffBEdg)
ENDIF
IF (ALLOCATED(ParamData%EAOffBFlp)) THEN
  DEALLOCATE(ParamData%EAOffBFlp)
ENDIF
IF (ALLOCATED(ParamData%FStTunr)) THEN
  DEALLOCATE(ParamData%FStTunr)
ENDIF
IF (ALLOCATED(ParamData%InerBEdg)) THEN
  DEALLOCATE(ParamData%InerBEdg)
ENDIF
IF (ALLOCATED(ParamData%InerBFlp)) THEN
  DEALLOCATE(ParamData%InerBFlp)
ENDIF
IF (ALLOCATED(ParamData%KBE)) THEN
  DEALLOCATE(ParamData%KBE)
ENDIF
IF (ALLOCATED(ParamData%KBF)) THEN
  DEALLOCATE(ParamData%KBF)
ENDIF
IF (ALLOCATED(ParamData%MassB)) THEN
  DEALLOCATE(ParamData%MassB)
ENDIF
IF (ALLOCATED(ParamData%RefAxisxb)) THEN
  DEALLOCATE(ParamData%RefAxisxb)
ENDIF
IF (ALLOCATED(ParamData%RefAxisyb)) THEN
  DEALLOCATE(ParamData%RefAxisyb)
ENDIF
IF (ALLOCATED(ParamData%RNodes)) THEN
  DEALLOCATE(ParamData%RNodes)
ENDIF
IF (ALLOCATED(ParamData%RNodesNorm)) THEN
  DEALLOCATE(ParamData%RNodesNorm)
ENDIF
IF (ALLOCATED(ParamData%rSAerCenn1)) THEN
  DEALLOCATE(ParamData%rSAerCenn1)
ENDIF
IF (ALLOCATED(ParamData%rSAerCenn2)) THEN
  DEALLOCATE(ParamData%rSAerCenn2)
ENDIF
IF (ALLOCATED(ParamData%SAeroTwst)) THEN
  DEALLOCATE(ParamData%SAeroTwst)
ENDIF
IF (ALLOCATED(ParamData%StiffBE)) THEN
  DEALLOCATE(ParamData%StiffBE)
ENDIF
IF (ALLOCATED(ParamData%StiffBEA)) THEN
  DEALLOCATE(ParamData%StiffBEA)
ENDIF
IF (ALLOCATED(ParamData%StiffBF)) THEN
  DEALLOCATE(ParamData%StiffBF)
ENDIF
IF (ALLOCATED(ParamData%StiffBGJ)) THEN
  DEALLOCATE(ParamData%StiffBGJ)
ENDIF
IF (ALLOCATED(ParamData%SThetaS)) THEN
  DEALLOCATE(ParamData%SThetaS)
ENDIF
IF (ALLOCATED(ParamData%ThetaS)) THEN
  DEALLOCATE(ParamData%ThetaS)
ENDIF
IF (ALLOCATED(ParamData%TwistedSF)) THEN
  DEALLOCATE(ParamData%TwistedSF)
ENDIF
IF (ALLOCATED(ParamData%BldFl1Sh)) THEN
  DEALLOCATE(ParamData%BldFl1Sh)
ENDIF
IF (ALLOCATED(ParamData%BldFl2Sh)) THEN
  DEALLOCATE(ParamData%BldFl2Sh)
ENDIF
IF (ALLOCATED(ParamData%BldEdgSh)) THEN
  DEALLOCATE(ParamData%BldEdgSh)
ENDIF
IF (ALLOCATED(ParamData%FreqBE)) THEN
  DEALLOCATE(ParamData%FreqBE)
ENDIF
IF (ALLOCATED(ParamData%FreqBF)) THEN
  DEALLOCATE(ParamData%FreqBF)
ENDIF
IF (ALLOCATED(ParamData%BElmntMass)) THEN
  DEALLOCATE(ParamData%BElmntMass)
ENDIF
IF (ALLOCATED(ParamData%TElmntMass)) THEN
  DEALLOCATE(ParamData%TElmntMass)
ENDIF
IF (ALLOCATED(ParamData%BldNd_OutParam)) THEN
DO i1 = LBOUND(ParamData%BldNd_OutParam,1), UBOUND(ParamData%BldNd_OutParam,1)
  CALL NWTC_Library_Destroyoutparmtype( ParamData%BldNd_OutParam(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%BldNd_OutParam)
ENDIF
IF (ALLOCATED(ParamData%Jac_u_indx)) THEN
  DEALLOCATE(ParamData%Jac_u_indx)
ENDIF
IF (ALLOCATED(ParamData%du)) THEN
  DEALLOCATE(ParamData%du)
ENDIF
IF (ALLOCATED(ParamData%dx)) THEN
  DEALLOCATE(ParamData%dx)
ENDIF
 END SUBROUTINE ED_DestroyParam

 SUBROUTINE ED_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Db_BufSz   = Db_BufSz   + 1  ! DT24
      Int_BufSz  = Int_BufSz  + 1  ! BldNodes
      Int_BufSz  = Int_BufSz  + 1  ! TipNode
      Int_BufSz  = Int_BufSz  + 1  ! NDOF
      Db_BufSz   = Db_BufSz   + 1  ! TwoPiNB
      Int_BufSz  = Int_BufSz  + 1  ! NAug
      Int_BufSz  = Int_BufSz  + 1  ! NPH
  Int_BufSz   = Int_BufSz   + 1     ! PH allocated yes/no
  IF ( ALLOCATED(InData%PH) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PH upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PH)  ! PH
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NPM
  Int_BufSz   = Int_BufSz   + 1     ! PM allocated yes/no
  IF ( ALLOCATED(InData%PM) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PM upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PM)  ! PM
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DOF_Flag allocated yes/no
  IF ( ALLOCATED(InData%DOF_Flag) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DOF_Flag upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%DOF_Flag)  ! DOF_Flag
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DOF_Desc allocated yes/no
  IF ( ALLOCATED(InData%DOF_Desc) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DOF_Desc upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%DOF_Desc)*LEN(InData%DOF_Desc)  ! DOF_Desc
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! DOFs: size of buffers for each call to pack subtype
      CALL ED_Packactivedofs( Re_Buf, Db_Buf, Int_Buf, InData%DOFs, ErrStat2, ErrMsg2, .TRUE. ) ! DOFs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DOFs
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DOFs
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DOFs
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFmt)  ! OutFmt
      Int_BufSz  = Int_BufSz  + 1  ! NBlGages
      Int_BufSz  = Int_BufSz  + 1  ! NTwGages
  Int_BufSz   = Int_BufSz   + 1     ! OutParam allocated yes/no
  IF ( ALLOCATED(InData%OutParam) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutParam upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      Int_BufSz   = Int_BufSz + 3  ! OutParam: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, .TRUE. ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! OutParam
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! OutParam
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! OutParam
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Delim)  ! Delim
      Re_BufSz   = Re_BufSz   + 1  ! AvgNrmTpRd
      Db_BufSz   = Db_BufSz   + 1  ! AzimB1Up
      Db_BufSz   = Db_BufSz   + 1  ! CosDel3
  Int_BufSz   = Int_BufSz   + 1     ! CosPreC allocated yes/no
  IF ( ALLOCATED(InData%CosPreC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CosPreC upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%CosPreC)  ! CosPreC
  END IF
      Db_BufSz   = Db_BufSz   + 1  ! CRFrlSkew
      Db_BufSz   = Db_BufSz   + 1  ! CRFrlSkw2
      Db_BufSz   = Db_BufSz   + 1  ! CRFrlTilt
      Db_BufSz   = Db_BufSz   + 1  ! CRFrlTlt2
      Db_BufSz   = Db_BufSz   + 1  ! CShftSkew
      Db_BufSz   = Db_BufSz   + 1  ! CShftTilt
      Db_BufSz   = Db_BufSz   + 1  ! CSRFrlSkw
      Db_BufSz   = Db_BufSz   + 1  ! CSRFrlTlt
      Db_BufSz   = Db_BufSz   + 1  ! CSTFrlSkw
      Db_BufSz   = Db_BufSz   + 1  ! CSTFrlTlt
      Db_BufSz   = Db_BufSz   + 1  ! CTFinBank
      Db_BufSz   = Db_BufSz   + 1  ! CTFinSkew
      Db_BufSz   = Db_BufSz   + 1  ! CTFinTilt
      Db_BufSz   = Db_BufSz   + 1  ! CTFrlSkew
      Db_BufSz   = Db_BufSz   + 1  ! CTFrlSkw2
      Db_BufSz   = Db_BufSz   + 1  ! CTFrlTilt
      Db_BufSz   = Db_BufSz   + 1  ! CTFrlTlt2
      Re_BufSz   = Re_BufSz   + 1  ! HubHt
      Re_BufSz   = Re_BufSz   + 1  ! HubCM
      Re_BufSz   = Re_BufSz   + 1  ! HubRad
      Re_BufSz   = Re_BufSz   + 1  ! NacCMxn
      Re_BufSz   = Re_BufSz   + 1  ! NacCMyn
      Re_BufSz   = Re_BufSz   + 1  ! NacCMzn
      Re_BufSz   = Re_BufSz   + 1  ! OverHang
      Re_BufSz   = Re_BufSz   + 1  ! ProjArea
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRefzt
      Re_BufSz   = Re_BufSz   + 1  ! RefTwrHt
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntxn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntyn
      Re_BufSz   = Re_BufSz   + 1  ! RFrlPntzn
      Re_BufSz   = Re_BufSz   + 1  ! rVDxn
      Re_BufSz   = Re_BufSz   + 1  ! rVDyn
      Re_BufSz   = Re_BufSz   + 1  ! rVDzn
      Re_BufSz   = Re_BufSz   + 1  ! rVIMUxn
      Re_BufSz   = Re_BufSz   + 1  ! rVIMUyn
      Re_BufSz   = Re_BufSz   + 1  ! rVIMUzn
      Re_BufSz   = Re_BufSz   + 1  ! rVPxn
      Re_BufSz   = Re_BufSz   + 1  ! rVPyn
      Re_BufSz   = Re_BufSz   + 1  ! rVPzn
      Re_BufSz   = Re_BufSz   + 1  ! rWIxn
      Re_BufSz   = Re_BufSz   + 1  ! rWIyn
      Re_BufSz   = Re_BufSz   + 1  ! rWIzn
      Re_BufSz   = Re_BufSz   + 1  ! rWJxn
      Re_BufSz   = Re_BufSz   + 1  ! rWJyn
      Re_BufSz   = Re_BufSz   + 1  ! rWJzn
      Re_BufSz   = Re_BufSz   + 1  ! rWKxn
      Re_BufSz   = Re_BufSz   + 1  ! rWKyn
      Re_BufSz   = Re_BufSz   + 1  ! rWKzn
      Re_BufSz   = Re_BufSz   + 1  ! rZT0zt
      Re_BufSz   = Re_BufSz   + 1  ! rZYzt
      Db_BufSz   = Db_BufSz   + 1  ! SinDel3
  Int_BufSz   = Int_BufSz   + 1     ! SinPreC allocated yes/no
  IF ( ALLOCATED(InData%SinPreC) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SinPreC upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%SinPreC)  ! SinPreC
  END IF
      Db_BufSz   = Db_BufSz   + 1  ! SRFrlSkew
      Db_BufSz   = Db_BufSz   + 1  ! SRFrlSkw2
      Db_BufSz   = Db_BufSz   + 1  ! SRFrlTilt
      Db_BufSz   = Db_BufSz   + 1  ! SRFrlTlt2
      Db_BufSz   = Db_BufSz   + 1  ! SShftSkew
      Db_BufSz   = Db_BufSz   + 1  ! SShftTilt
      Db_BufSz   = Db_BufSz   + 1  ! STFinBank
      Db_BufSz   = Db_BufSz   + 1  ! STFinSkew
      Db_BufSz   = Db_BufSz   + 1  ! STFinTilt
      Db_BufSz   = Db_BufSz   + 1  ! STFrlSkew
      Db_BufSz   = Db_BufSz   + 1  ! STFrlSkw2
      Db_BufSz   = Db_BufSz   + 1  ! STFrlTilt
      Db_BufSz   = Db_BufSz   + 1  ! STFrlTlt2
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntxn
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntyn
      Re_BufSz   = Re_BufSz   + 1  ! TFrlPntzn
      Re_BufSz   = Re_BufSz   + 1  ! TipRad
      Re_BufSz   = Re_BufSz   + 1  ! TowerHt
      Re_BufSz   = Re_BufSz   + 1  ! TowerBsHt
      Re_BufSz   = Re_BufSz   + 1  ! UndSling
      Int_BufSz  = Int_BufSz  + 1  ! NumBl
  Int_BufSz   = Int_BufSz   + 1     ! AxRedTFA allocated yes/no
  IF ( ALLOCATED(InData%AxRedTFA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AxRedTFA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxRedTFA)  ! AxRedTFA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxRedTSS allocated yes/no
  IF ( ALLOCATED(InData%AxRedTSS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AxRedTSS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxRedTSS)  ! AxRedTSS
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%CTFA)  ! CTFA
      Re_BufSz   = Re_BufSz   + SIZE(InData%CTSS)  ! CTSS
  Int_BufSz   = Int_BufSz   + 1     ! DHNodes allocated yes/no
  IF ( ALLOCATED(InData%DHNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DHNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%DHNodes)  ! DHNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! HNodes allocated yes/no
  IF ( ALLOCATED(InData%HNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! HNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%HNodes)  ! HNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! HNodesNorm allocated yes/no
  IF ( ALLOCATED(InData%HNodesNorm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! HNodesNorm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%HNodesNorm)  ! HNodesNorm
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%KTFA)  ! KTFA
      Re_BufSz   = Re_BufSz   + SIZE(InData%KTSS)  ! KTSS
  Int_BufSz   = Int_BufSz   + 1     ! MassT allocated yes/no
  IF ( ALLOCATED(InData%MassT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! MassT upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MassT)  ! MassT
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffTSS allocated yes/no
  IF ( ALLOCATED(InData%StiffTSS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StiffTSS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffTSS)  ! StiffTSS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwrFASF allocated yes/no
  IF ( ALLOCATED(InData%TwrFASF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! TwrFASF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrFASF)  ! TwrFASF
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! TwrFlexL
  Int_BufSz   = Int_BufSz   + 1     ! TwrSSSF allocated yes/no
  IF ( ALLOCATED(InData%TwrSSSF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! TwrSSSF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrSSSF)  ! TwrSSSF
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! TTopNode
      Int_BufSz  = Int_BufSz  + 1  ! TwrNodes
  Int_BufSz   = Int_BufSz   + 1     ! InerTFA allocated yes/no
  IF ( ALLOCATED(InData%InerTFA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InerTFA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%InerTFA)  ! InerTFA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! InerTSS allocated yes/no
  IF ( ALLOCATED(InData%InerTSS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! InerTSS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%InerTSS)  ! InerTSS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffTGJ allocated yes/no
  IF ( ALLOCATED(InData%StiffTGJ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StiffTGJ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffTGJ)  ! StiffTGJ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffTEA allocated yes/no
  IF ( ALLOCATED(InData%StiffTEA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StiffTEA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffTEA)  ! StiffTEA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffTFA allocated yes/no
  IF ( ALLOCATED(InData%StiffTFA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! StiffTFA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffTFA)  ! StiffTFA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! cgOffTFA allocated yes/no
  IF ( ALLOCATED(InData%cgOffTFA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! cgOffTFA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%cgOffTFA)  ! cgOffTFA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! cgOffTSS allocated yes/no
  IF ( ALLOCATED(InData%cgOffTSS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! cgOffTSS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%cgOffTSS)  ! cgOffTSS
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! AtfaIner
  Int_BufSz   = Int_BufSz   + 1     ! BldCG allocated yes/no
  IF ( ALLOCATED(InData%BldCG) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldCG upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldCG)  ! BldCG
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldMass allocated yes/no
  IF ( ALLOCATED(InData%BldMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldMass)  ! BldMass
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BoomMass
  Int_BufSz   = Int_BufSz   + 1     ! FirstMom allocated yes/no
  IF ( ALLOCATED(InData%FirstMom) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FirstMom upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FirstMom)  ! FirstMom
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! GenIner
      Re_BufSz   = Re_BufSz   + 1  ! Hubg1Iner
      Re_BufSz   = Re_BufSz   + 1  ! Hubg2Iner
      Re_BufSz   = Re_BufSz   + 1  ! HubMass
      Re_BufSz   = Re_BufSz   + 1  ! Nacd2Iner
      Re_BufSz   = Re_BufSz   + 1  ! NacMass
      Re_BufSz   = Re_BufSz   + 1  ! PtfmMass
      Re_BufSz   = Re_BufSz   + 1  ! PtfmPIner
      Re_BufSz   = Re_BufSz   + 1  ! PtfmRIner
      Re_BufSz   = Re_BufSz   + 1  ! PtfmYIner
      Re_BufSz   = Re_BufSz   + 1  ! RFrlMass
      Re_BufSz   = Re_BufSz   + 1  ! RotIner
      Re_BufSz   = Re_BufSz   + 1  ! RotMass
      Re_BufSz   = Re_BufSz   + 1  ! RrfaIner
  Int_BufSz   = Int_BufSz   + 1     ! SecondMom allocated yes/no
  IF ( ALLOCATED(InData%SecondMom) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SecondMom upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SecondMom)  ! SecondMom
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! TFinMass
      Re_BufSz   = Re_BufSz   + 1  ! TFrlIner
  Int_BufSz   = Int_BufSz   + 1     ! TipMass allocated yes/no
  IF ( ALLOCATED(InData%TipMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TipMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TipMass)  ! TipMass
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! TurbMass
      Re_BufSz   = Re_BufSz   + 1  ! TwrMass
      Re_BufSz   = Re_BufSz   + 1  ! TwrTpMass
      Re_BufSz   = Re_BufSz   + 1  ! YawBrMass
      Re_BufSz   = Re_BufSz   + 1  ! Gravity
  Int_BufSz   = Int_BufSz   + 1     ! PitchAxis allocated yes/no
  IF ( ALLOCATED(InData%PitchAxis) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PitchAxis upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PitchAxis)  ! PitchAxis
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AeroTwst allocated yes/no
  IF ( ALLOCATED(InData%AeroTwst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AeroTwst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AeroTwst)  ! AeroTwst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxRedBld allocated yes/no
  IF ( ALLOCATED(InData%AxRedBld) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! AxRedBld upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxRedBld)  ! AxRedBld
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BAlpha allocated yes/no
  IF ( ALLOCATED(InData%BAlpha) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BAlpha upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BAlpha)  ! BAlpha
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldEDamp allocated yes/no
  IF ( ALLOCATED(InData%BldEDamp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BldEDamp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldEDamp)  ! BldEDamp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldFDamp allocated yes/no
  IF ( ALLOCATED(InData%BldFDamp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BldFDamp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFDamp)  ! BldFDamp
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BldFlexL
  Int_BufSz   = Int_BufSz   + 1     ! CAeroTwst allocated yes/no
  IF ( ALLOCATED(InData%CAeroTwst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CAeroTwst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CAeroTwst)  ! CAeroTwst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CBE allocated yes/no
  IF ( ALLOCATED(InData%CBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! CBE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CBE)  ! CBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CBF allocated yes/no
  IF ( ALLOCATED(InData%CBF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! CBF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CBF)  ! CBF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! cgOffBEdg allocated yes/no
  IF ( ALLOCATED(InData%cgOffBEdg) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! cgOffBEdg upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%cgOffBEdg)  ! cgOffBEdg
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! cgOffBFlp allocated yes/no
  IF ( ALLOCATED(InData%cgOffBFlp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! cgOffBFlp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%cgOffBFlp)  ! cgOffBFlp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Chord allocated yes/no
  IF ( ALLOCATED(InData%Chord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Chord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Chord)  ! Chord
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CThetaS allocated yes/no
  IF ( ALLOCATED(InData%CThetaS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! CThetaS upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%CThetaS)  ! CThetaS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DRNodes allocated yes/no
  IF ( ALLOCATED(InData%DRNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DRNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%DRNodes)  ! DRNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EAOffBEdg allocated yes/no
  IF ( ALLOCATED(InData%EAOffBEdg) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! EAOffBEdg upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EAOffBEdg)  ! EAOffBEdg
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EAOffBFlp allocated yes/no
  IF ( ALLOCATED(InData%EAOffBFlp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! EAOffBFlp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EAOffBFlp)  ! EAOffBFlp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FStTunr allocated yes/no
  IF ( ALLOCATED(InData%FStTunr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FStTunr upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FStTunr)  ! FStTunr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! InerBEdg allocated yes/no
  IF ( ALLOCATED(InData%InerBEdg) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! InerBEdg upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%InerBEdg)  ! InerBEdg
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! InerBFlp allocated yes/no
  IF ( ALLOCATED(InData%InerBFlp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! InerBFlp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%InerBFlp)  ! InerBFlp
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! KBE allocated yes/no
  IF ( ALLOCATED(InData%KBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! KBE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%KBE)  ! KBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! KBF allocated yes/no
  IF ( ALLOCATED(InData%KBF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! KBF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%KBF)  ! KBF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MassB allocated yes/no
  IF ( ALLOCATED(InData%MassB) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! MassB upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MassB)  ! MassB
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RefAxisxb allocated yes/no
  IF ( ALLOCATED(InData%RefAxisxb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! RefAxisxb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RefAxisxb)  ! RefAxisxb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RefAxisyb allocated yes/no
  IF ( ALLOCATED(InData%RefAxisyb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! RefAxisyb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RefAxisyb)  ! RefAxisyb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RNodes allocated yes/no
  IF ( ALLOCATED(InData%RNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RNodes upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RNodes)  ! RNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RNodesNorm allocated yes/no
  IF ( ALLOCATED(InData%RNodesNorm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RNodesNorm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RNodesNorm)  ! RNodesNorm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rSAerCenn1 allocated yes/no
  IF ( ALLOCATED(InData%rSAerCenn1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rSAerCenn1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rSAerCenn1)  ! rSAerCenn1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rSAerCenn2 allocated yes/no
  IF ( ALLOCATED(InData%rSAerCenn2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rSAerCenn2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rSAerCenn2)  ! rSAerCenn2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SAeroTwst allocated yes/no
  IF ( ALLOCATED(InData%SAeroTwst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SAeroTwst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SAeroTwst)  ! SAeroTwst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffBE allocated yes/no
  IF ( ALLOCATED(InData%StiffBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! StiffBE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffBE)  ! StiffBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffBEA allocated yes/no
  IF ( ALLOCATED(InData%StiffBEA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! StiffBEA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffBEA)  ! StiffBEA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffBF allocated yes/no
  IF ( ALLOCATED(InData%StiffBF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! StiffBF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffBF)  ! StiffBF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StiffBGJ allocated yes/no
  IF ( ALLOCATED(InData%StiffBGJ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! StiffBGJ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StiffBGJ)  ! StiffBGJ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SThetaS allocated yes/no
  IF ( ALLOCATED(InData%SThetaS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! SThetaS upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%SThetaS)  ! SThetaS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ThetaS allocated yes/no
  IF ( ALLOCATED(InData%ThetaS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! ThetaS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ThetaS)  ! ThetaS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwistedSF allocated yes/no
  IF ( ALLOCATED(InData%TwistedSF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*5  ! TwistedSF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwistedSF)  ! TwistedSF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldFl1Sh allocated yes/no
  IF ( ALLOCATED(InData%BldFl1Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BldFl1Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFl1Sh)  ! BldFl1Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldFl2Sh allocated yes/no
  IF ( ALLOCATED(InData%BldFl2Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BldFl2Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldFl2Sh)  ! BldFl2Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BldEdgSh allocated yes/no
  IF ( ALLOCATED(InData%BldEdgSh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BldEdgSh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BldEdgSh)  ! BldEdgSh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FreqBE allocated yes/no
  IF ( ALLOCATED(InData%FreqBE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! FreqBE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FreqBE)  ! FreqBE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FreqBF allocated yes/no
  IF ( ALLOCATED(InData%FreqBF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! FreqBF upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FreqBF)  ! FreqBF
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%FreqTFA)  ! FreqTFA
      Re_BufSz   = Re_BufSz   + SIZE(InData%FreqTSS)  ! FreqTSS
      Re_BufSz   = Re_BufSz   + 1  ! TeetCDmp
      Re_BufSz   = Re_BufSz   + 1  ! TeetDmp
      Re_BufSz   = Re_BufSz   + 1  ! TeetDmpP
      Re_BufSz   = Re_BufSz   + 1  ! TeetHSSp
      Re_BufSz   = Re_BufSz   + 1  ! TeetHStP
      Re_BufSz   = Re_BufSz   + 1  ! TeetSSSp
      Re_BufSz   = Re_BufSz   + 1  ! TeetSStP
      Int_BufSz  = Int_BufSz  + 1  ! TeetMod
      Re_BufSz   = Re_BufSz   + 1  ! TFrlCDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSDP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSSP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlDSSpr
      Re_BufSz   = Re_BufSz   + 1  ! TFrlSpr
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSDmp
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSDP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSSP
      Re_BufSz   = Re_BufSz   + 1  ! TFrlUSSpr
      Int_BufSz  = Int_BufSz  + 1  ! TFrlMod
      Re_BufSz   = Re_BufSz   + 1  ! RFrlCDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSDP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSSP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlDSSpr
      Re_BufSz   = Re_BufSz   + 1  ! RFrlSpr
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSDmp
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSDP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSSP
      Re_BufSz   = Re_BufSz   + 1  ! RFrlUSSpr
      Int_BufSz  = Int_BufSz  + 1  ! RFrlMod
      Re_BufSz   = Re_BufSz   + 1  ! ShftGagL
      Int_BufSz  = Int_BufSz  + SIZE(InData%BldGagNd)  ! BldGagNd
      Int_BufSz  = Int_BufSz  + SIZE(InData%TwrGagNd)  ! TwrGagNd
      Db_BufSz   = Db_BufSz   + 1  ! TStart
      Re_BufSz   = Re_BufSz   + 1  ! DTTorDmp
      Re_BufSz   = Re_BufSz   + 1  ! DTTorSpr
      Re_BufSz   = Re_BufSz   + 1  ! GBRatio
      Re_BufSz   = Re_BufSz   + 1  ! GBoxEff
      Re_BufSz   = Re_BufSz   + 1  ! RotSpeed
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
  Int_BufSz   = Int_BufSz   + 1     ! BElmntMass allocated yes/no
  IF ( ALLOCATED(InData%BElmntMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BElmntMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BElmntMass)  ! BElmntMass
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TElmntMass allocated yes/no
  IF ( ALLOCATED(InData%TElmntMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TElmntMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TElmntMass)  ! TElmntMass
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! method
      Re_BufSz   = Re_BufSz   + 1  ! PtfmCMxt
      Re_BufSz   = Re_BufSz   + 1  ! PtfmCMyt
      Int_BufSz  = Int_BufSz  + 1  ! BD4Blades
      Int_BufSz  = Int_BufSz  + 1  ! UseAD14
      Int_BufSz  = Int_BufSz  + 1  ! BldNd_NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! BldNd_TotNumOuts
  Int_BufSz   = Int_BufSz   + 1     ! BldNd_OutParam allocated yes/no
  IF ( ALLOCATED(InData%BldNd_OutParam) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BldNd_OutParam upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%BldNd_OutParam,1), UBOUND(InData%BldNd_OutParam,1)
      Int_BufSz   = Int_BufSz + 3  ! BldNd_OutParam: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%BldNd_OutParam(i1), ErrStat2, ErrMsg2, .TRUE. ) ! BldNd_OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! BldNd_OutParam
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! BldNd_OutParam
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! BldNd_OutParam
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! BldNd_BladesOut
  Int_BufSz   = Int_BufSz   + 1     ! Jac_u_indx allocated yes/no
  IF ( ALLOCATED(InData%Jac_u_indx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Jac_u_indx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Jac_u_indx)  ! Jac_u_indx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! du allocated yes/no
  IF ( ALLOCATED(InData%du) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! du upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%du)  ! du
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dx allocated yes/no
  IF ( ALLOCATED(InData%dx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dx upper/lower bounds for each dimension
      Db_BufSz   = Db_BufSz   + SIZE(InData%dx)  ! dx
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! Jac_ny
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DT24
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%BldNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TipNode
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NDOF
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%TwoPiNB
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NAug
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NPH
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PH) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PH,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PH,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PH,1), UBOUND(InData%PH,1)
        IntKiBuf(Int_Xferred) = InData%PH(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NPM
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PM) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PM,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PM,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PM,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PM,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PM,2), UBOUND(InData%PM,2)
        DO i1 = LBOUND(InData%PM,1), UBOUND(InData%PM,1)
          IntKiBuf(Int_Xferred) = InData%PM(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DOF_Flag) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DOF_Flag,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DOF_Flag,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DOF_Flag,1), UBOUND(InData%DOF_Flag,1)
        IntKiBuf(Int_Xferred) = TRANSFER(InData%DOF_Flag(i1), IntKiBuf(1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DOF_Desc) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DOF_Desc,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DOF_Desc,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DOF_Desc,1), UBOUND(InData%DOF_Desc,1)
        DO I = 1, LEN(InData%DOF_Desc)
          IntKiBuf(Int_Xferred) = ICHAR(InData%DOF_Desc(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      CALL ED_Packactivedofs( Re_Buf, Db_Buf, Int_Buf, InData%DOFs, ErrStat2, ErrMsg2, OnlySize ) ! DOFs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NBlGages
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NTwGages
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutParam) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutParam,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutParam,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, OnlySize ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    DO I = 1, LEN(InData%Delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    ReKiBuf(Re_Xferred) = InData%AvgNrmTpRd
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%AzimB1Up
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CosDel3
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%CosPreC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CosPreC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CosPreC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%CosPreC,1), UBOUND(InData%CosPreC,1)
        DbKiBuf(Db_Xferred) = InData%CosPreC(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    DbKiBuf(Db_Xferred) = InData%CRFrlSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CRFrlSkw2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CRFrlTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CRFrlTlt2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CShftSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CShftTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CSRFrlSkw
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CSRFrlTlt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CSTFrlSkw
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CSTFrlTlt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFinBank
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFinSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFinTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFrlSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFrlSkw2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFrlTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%CTFrlTlt2
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubCM
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubRad
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacCMzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%OverHang
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ProjArea
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmRefzt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RefTwrHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlPntzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVDxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVDyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVDzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVIMUxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVIMUyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVIMUzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVPxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVPyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rVPzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWIxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWIyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWIzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWJxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWJyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWJzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWKxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWKyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rWKzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rZT0zt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%rZYzt
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SinDel3
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%SinPreC) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SinPreC,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SinPreC,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SinPreC,1), UBOUND(InData%SinPreC,1)
        DbKiBuf(Db_Xferred) = InData%SinPreC(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    DbKiBuf(Db_Xferred) = InData%SRFrlSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SRFrlSkw2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SRFrlTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SRFrlTlt2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SShftSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%SShftTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFinBank
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFinSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFinTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFrlSkew
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFrlSkw2
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFrlTilt
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%STFrlTlt2
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntxn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntyn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlPntzn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TipRad
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TowerBsHt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%UndSling
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBl
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AxRedTFA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTFA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTFA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTFA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTFA,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTFA,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTFA,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AxRedTFA,3), UBOUND(InData%AxRedTFA,3)
        DO i2 = LBOUND(InData%AxRedTFA,2), UBOUND(InData%AxRedTFA,2)
          DO i1 = LBOUND(InData%AxRedTFA,1), UBOUND(InData%AxRedTFA,1)
            ReKiBuf(Re_Xferred) = InData%AxRedTFA(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxRedTSS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTSS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTSS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTSS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTSS,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedTSS,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedTSS,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AxRedTSS,3), UBOUND(InData%AxRedTSS,3)
        DO i2 = LBOUND(InData%AxRedTSS,2), UBOUND(InData%AxRedTSS,2)
          DO i1 = LBOUND(InData%AxRedTSS,1), UBOUND(InData%AxRedTSS,1)
            ReKiBuf(Re_Xferred) = InData%AxRedTSS(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%CTFA,2), UBOUND(InData%CTFA,2)
      DO i1 = LBOUND(InData%CTFA,1), UBOUND(InData%CTFA,1)
        ReKiBuf(Re_Xferred) = InData%CTFA(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%CTSS,2), UBOUND(InData%CTSS,2)
      DO i1 = LBOUND(InData%CTSS,1), UBOUND(InData%CTSS,1)
        ReKiBuf(Re_Xferred) = InData%CTSS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%DHNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DHNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DHNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DHNodes,1), UBOUND(InData%DHNodes,1)
        ReKiBuf(Re_Xferred) = InData%DHNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%HNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%HNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%HNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%HNodes,1), UBOUND(InData%HNodes,1)
        ReKiBuf(Re_Xferred) = InData%HNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%HNodesNorm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%HNodesNorm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%HNodesNorm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%HNodesNorm,1), UBOUND(InData%HNodesNorm,1)
        ReKiBuf(Re_Xferred) = InData%HNodesNorm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DO i2 = LBOUND(InData%KTFA,2), UBOUND(InData%KTFA,2)
      DO i1 = LBOUND(InData%KTFA,1), UBOUND(InData%KTFA,1)
        ReKiBuf(Re_Xferred) = InData%KTFA(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%KTSS,2), UBOUND(InData%KTSS,2)
      DO i1 = LBOUND(InData%KTSS,1), UBOUND(InData%KTSS,1)
        ReKiBuf(Re_Xferred) = InData%KTSS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%MassT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MassT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MassT,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%MassT,1), UBOUND(InData%MassT,1)
        ReKiBuf(Re_Xferred) = InData%MassT(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffTSS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffTSS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffTSS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StiffTSS,1), UBOUND(InData%StiffTSS,1)
        ReKiBuf(Re_Xferred) = InData%StiffTSS(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwrFASF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrFASF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrFASF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrFASF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrFASF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrFASF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrFASF,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%TwrFASF,3), UBOUND(InData%TwrFASF,3)
        DO i2 = LBOUND(InData%TwrFASF,2), UBOUND(InData%TwrFASF,2)
          DO i1 = LBOUND(InData%TwrFASF,1), UBOUND(InData%TwrFASF,1)
            ReKiBuf(Re_Xferred) = InData%TwrFASF(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%TwrFlexL
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%TwrSSSF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrSSSF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrSSSF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrSSSF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrSSSF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrSSSF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrSSSF,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%TwrSSSF,3), UBOUND(InData%TwrSSSF,3)
        DO i2 = LBOUND(InData%TwrSSSF,2), UBOUND(InData%TwrSSSF,2)
          DO i1 = LBOUND(InData%TwrSSSF,1), UBOUND(InData%TwrSSSF,1)
            ReKiBuf(Re_Xferred) = InData%TwrSSSF(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%TTopNode
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TwrNodes
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%InerTFA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerTFA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerTFA,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%InerTFA,1), UBOUND(InData%InerTFA,1)
        ReKiBuf(Re_Xferred) = InData%InerTFA(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%InerTSS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerTSS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerTSS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%InerTSS,1), UBOUND(InData%InerTSS,1)
        ReKiBuf(Re_Xferred) = InData%InerTSS(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffTGJ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffTGJ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffTGJ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StiffTGJ,1), UBOUND(InData%StiffTGJ,1)
        ReKiBuf(Re_Xferred) = InData%StiffTGJ(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffTEA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffTEA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffTEA,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StiffTEA,1), UBOUND(InData%StiffTEA,1)
        ReKiBuf(Re_Xferred) = InData%StiffTEA(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffTFA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffTFA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffTFA,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%StiffTFA,1), UBOUND(InData%StiffTFA,1)
        ReKiBuf(Re_Xferred) = InData%StiffTFA(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%cgOffTFA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffTFA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffTFA,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%cgOffTFA,1), UBOUND(InData%cgOffTFA,1)
        ReKiBuf(Re_Xferred) = InData%cgOffTFA(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%cgOffTSS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffTSS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffTSS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%cgOffTSS,1), UBOUND(InData%cgOffTSS,1)
        ReKiBuf(Re_Xferred) = InData%cgOffTSS(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%AtfaIner
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BldCG) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldCG,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldCG,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldCG,1), UBOUND(InData%BldCG,1)
        ReKiBuf(Re_Xferred) = InData%BldCG(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldMass,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BldMass,1), UBOUND(InData%BldMass,1)
        ReKiBuf(Re_Xferred) = InData%BldMass(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BoomMass
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%FirstMom) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FirstMom,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FirstMom,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FirstMom,1), UBOUND(InData%FirstMom,1)
        ReKiBuf(Re_Xferred) = InData%FirstMom(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%GenIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Hubg1Iner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Hubg2Iner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Nacd2Iner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%NacMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmPIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmRIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmYIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotIner
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RrfaIner
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%SecondMom) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SecondMom,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SecondMom,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SecondMom,1), UBOUND(InData%SecondMom,1)
        ReKiBuf(Re_Xferred) = InData%SecondMom(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%TFinMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlIner
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%TipMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TipMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TipMass,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TipMass,1), UBOUND(InData%TipMass,1)
        ReKiBuf(Re_Xferred) = InData%TipMass(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%TurbMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TwrMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TwrTpMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%YawBrMass
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Gravity
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PitchAxis) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PitchAxis,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PitchAxis,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PitchAxis,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PitchAxis,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PitchAxis,2), UBOUND(InData%PitchAxis,2)
        DO i1 = LBOUND(InData%PitchAxis,1), UBOUND(InData%PitchAxis,1)
          ReKiBuf(Re_Xferred) = InData%PitchAxis(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AeroTwst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AeroTwst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AeroTwst,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AeroTwst,1), UBOUND(InData%AeroTwst,1)
        ReKiBuf(Re_Xferred) = InData%AeroTwst(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxRedBld) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedBld,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedBld,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedBld,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedBld,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedBld,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedBld,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxRedBld,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxRedBld,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%AxRedBld,4), UBOUND(InData%AxRedBld,4)
        DO i3 = LBOUND(InData%AxRedBld,3), UBOUND(InData%AxRedBld,3)
          DO i2 = LBOUND(InData%AxRedBld,2), UBOUND(InData%AxRedBld,2)
            DO i1 = LBOUND(InData%AxRedBld,1), UBOUND(InData%AxRedBld,1)
              ReKiBuf(Re_Xferred) = InData%AxRedBld(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BAlpha) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BAlpha,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BAlpha,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BAlpha,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BAlpha,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BAlpha,2), UBOUND(InData%BAlpha,2)
        DO i1 = LBOUND(InData%BAlpha,1), UBOUND(InData%BAlpha,1)
          ReKiBuf(Re_Xferred) = InData%BAlpha(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldEDamp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldEDamp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldEDamp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldEDamp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldEDamp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BldEDamp,2), UBOUND(InData%BldEDamp,2)
        DO i1 = LBOUND(InData%BldEDamp,1), UBOUND(InData%BldEDamp,1)
          ReKiBuf(Re_Xferred) = InData%BldEDamp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldFDamp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFDamp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFDamp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFDamp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFDamp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BldFDamp,2), UBOUND(InData%BldFDamp,2)
        DO i1 = LBOUND(InData%BldFDamp,1), UBOUND(InData%BldFDamp,1)
          ReKiBuf(Re_Xferred) = InData%BldFDamp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BldFlexL
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%CAeroTwst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CAeroTwst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CAeroTwst,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%CAeroTwst,1), UBOUND(InData%CAeroTwst,1)
        ReKiBuf(Re_Xferred) = InData%CAeroTwst(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%CBE,3), UBOUND(InData%CBE,3)
        DO i2 = LBOUND(InData%CBE,2), UBOUND(InData%CBE,2)
          DO i1 = LBOUND(InData%CBE,1), UBOUND(InData%CBE,1)
            ReKiBuf(Re_Xferred) = InData%CBE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CBF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CBF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CBF,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%CBF,3), UBOUND(InData%CBF,3)
        DO i2 = LBOUND(InData%CBF,2), UBOUND(InData%CBF,2)
          DO i1 = LBOUND(InData%CBF,1), UBOUND(InData%CBF,1)
            ReKiBuf(Re_Xferred) = InData%CBF(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%cgOffBEdg) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffBEdg,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffBEdg,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffBEdg,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffBEdg,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%cgOffBEdg,2), UBOUND(InData%cgOffBEdg,2)
        DO i1 = LBOUND(InData%cgOffBEdg,1), UBOUND(InData%cgOffBEdg,1)
          ReKiBuf(Re_Xferred) = InData%cgOffBEdg(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%cgOffBFlp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffBFlp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffBFlp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%cgOffBFlp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%cgOffBFlp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%cgOffBFlp,2), UBOUND(InData%cgOffBFlp,2)
        DO i1 = LBOUND(InData%cgOffBFlp,1), UBOUND(InData%cgOffBFlp,1)
          ReKiBuf(Re_Xferred) = InData%cgOffBFlp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Chord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Chord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Chord,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Chord,1), UBOUND(InData%Chord,1)
        ReKiBuf(Re_Xferred) = InData%Chord(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CThetaS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CThetaS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CThetaS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CThetaS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CThetaS,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%CThetaS,2), UBOUND(InData%CThetaS,2)
        DO i1 = LBOUND(InData%CThetaS,1), UBOUND(InData%CThetaS,1)
          DbKiBuf(Db_Xferred) = InData%CThetaS(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DRNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DRNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DRNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DRNodes,1), UBOUND(InData%DRNodes,1)
        ReKiBuf(Re_Xferred) = InData%DRNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EAOffBEdg) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EAOffBEdg,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EAOffBEdg,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EAOffBEdg,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EAOffBEdg,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%EAOffBEdg,2), UBOUND(InData%EAOffBEdg,2)
        DO i1 = LBOUND(InData%EAOffBEdg,1), UBOUND(InData%EAOffBEdg,1)
          ReKiBuf(Re_Xferred) = InData%EAOffBEdg(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EAOffBFlp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EAOffBFlp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EAOffBFlp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EAOffBFlp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EAOffBFlp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%EAOffBFlp,2), UBOUND(InData%EAOffBFlp,2)
        DO i1 = LBOUND(InData%EAOffBFlp,1), UBOUND(InData%EAOffBFlp,1)
          ReKiBuf(Re_Xferred) = InData%EAOffBFlp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FStTunr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FStTunr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FStTunr,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FStTunr,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FStTunr,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FStTunr,2), UBOUND(InData%FStTunr,2)
        DO i1 = LBOUND(InData%FStTunr,1), UBOUND(InData%FStTunr,1)
          ReKiBuf(Re_Xferred) = InData%FStTunr(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%InerBEdg) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerBEdg,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerBEdg,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerBEdg,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerBEdg,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%InerBEdg,2), UBOUND(InData%InerBEdg,2)
        DO i1 = LBOUND(InData%InerBEdg,1), UBOUND(InData%InerBEdg,1)
          ReKiBuf(Re_Xferred) = InData%InerBEdg(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%InerBFlp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerBFlp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerBFlp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%InerBFlp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%InerBFlp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%InerBFlp,2), UBOUND(InData%InerBFlp,2)
        DO i1 = LBOUND(InData%InerBFlp,1), UBOUND(InData%InerBFlp,1)
          ReKiBuf(Re_Xferred) = InData%InerBFlp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%KBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%KBE,3), UBOUND(InData%KBE,3)
        DO i2 = LBOUND(InData%KBE,2), UBOUND(InData%KBE,2)
          DO i1 = LBOUND(InData%KBE,1), UBOUND(InData%KBE,1)
            ReKiBuf(Re_Xferred) = InData%KBE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%KBF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%KBF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%KBF,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%KBF,3), UBOUND(InData%KBF,3)
        DO i2 = LBOUND(InData%KBF,2), UBOUND(InData%KBF,2)
          DO i1 = LBOUND(InData%KBF,1), UBOUND(InData%KBF,1)
            ReKiBuf(Re_Xferred) = InData%KBF(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MassB) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MassB,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MassB,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MassB,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MassB,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%MassB,2), UBOUND(InData%MassB,2)
        DO i1 = LBOUND(InData%MassB,1), UBOUND(InData%MassB,1)
          ReKiBuf(Re_Xferred) = InData%MassB(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RefAxisxb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RefAxisxb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RefAxisxb,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RefAxisxb,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RefAxisxb,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%RefAxisxb,2), UBOUND(InData%RefAxisxb,2)
        DO i1 = LBOUND(InData%RefAxisxb,1), UBOUND(InData%RefAxisxb,1)
          ReKiBuf(Re_Xferred) = InData%RefAxisxb(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RefAxisyb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RefAxisyb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RefAxisyb,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RefAxisyb,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RefAxisyb,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%RefAxisyb,2), UBOUND(InData%RefAxisyb,2)
        DO i1 = LBOUND(InData%RefAxisyb,1), UBOUND(InData%RefAxisyb,1)
          ReKiBuf(Re_Xferred) = InData%RefAxisyb(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RNodes,1), UBOUND(InData%RNodes,1)
        ReKiBuf(Re_Xferred) = InData%RNodes(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RNodesNorm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RNodesNorm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RNodesNorm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RNodesNorm,1), UBOUND(InData%RNodesNorm,1)
        ReKiBuf(Re_Xferred) = InData%RNodesNorm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rSAerCenn1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCenn1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCenn1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCenn1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCenn1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rSAerCenn1,2), UBOUND(InData%rSAerCenn1,2)
        DO i1 = LBOUND(InData%rSAerCenn1,1), UBOUND(InData%rSAerCenn1,1)
          ReKiBuf(Re_Xferred) = InData%rSAerCenn1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rSAerCenn2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCenn2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCenn2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rSAerCenn2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rSAerCenn2,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rSAerCenn2,2), UBOUND(InData%rSAerCenn2,2)
        DO i1 = LBOUND(InData%rSAerCenn2,1), UBOUND(InData%rSAerCenn2,1)
          ReKiBuf(Re_Xferred) = InData%rSAerCenn2(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SAeroTwst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SAeroTwst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SAeroTwst,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SAeroTwst,1), UBOUND(InData%SAeroTwst,1)
        ReKiBuf(Re_Xferred) = InData%SAeroTwst(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBE,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%StiffBE,2), UBOUND(InData%StiffBE,2)
        DO i1 = LBOUND(InData%StiffBE,1), UBOUND(InData%StiffBE,1)
          ReKiBuf(Re_Xferred) = InData%StiffBE(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffBEA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBEA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBEA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBEA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBEA,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%StiffBEA,2), UBOUND(InData%StiffBEA,2)
        DO i1 = LBOUND(InData%StiffBEA,1), UBOUND(InData%StiffBEA,1)
          ReKiBuf(Re_Xferred) = InData%StiffBEA(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffBF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%StiffBF,2), UBOUND(InData%StiffBF,2)
        DO i1 = LBOUND(InData%StiffBF,1), UBOUND(InData%StiffBF,1)
          ReKiBuf(Re_Xferred) = InData%StiffBF(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StiffBGJ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBGJ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBGJ,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StiffBGJ,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StiffBGJ,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%StiffBGJ,2), UBOUND(InData%StiffBGJ,2)
        DO i1 = LBOUND(InData%StiffBGJ,1), UBOUND(InData%StiffBGJ,1)
          ReKiBuf(Re_Xferred) = InData%StiffBGJ(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SThetaS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SThetaS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SThetaS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SThetaS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SThetaS,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%SThetaS,2), UBOUND(InData%SThetaS,2)
        DO i1 = LBOUND(InData%SThetaS,1), UBOUND(InData%SThetaS,1)
          DbKiBuf(Db_Xferred) = InData%SThetaS(i1,i2)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ThetaS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ThetaS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ThetaS,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ThetaS,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ThetaS,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%ThetaS,2), UBOUND(InData%ThetaS,2)
        DO i1 = LBOUND(InData%ThetaS,1), UBOUND(InData%ThetaS,1)
          ReKiBuf(Re_Xferred) = InData%ThetaS(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TwistedSF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwistedSF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwistedSF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwistedSF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwistedSF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwistedSF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwistedSF,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwistedSF,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwistedSF,4)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwistedSF,5)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwistedSF,5)
    Int_Xferred = Int_Xferred + 2

      DO i5 = LBOUND(InData%TwistedSF,5), UBOUND(InData%TwistedSF,5)
        DO i4 = LBOUND(InData%TwistedSF,4), UBOUND(InData%TwistedSF,4)
          DO i3 = LBOUND(InData%TwistedSF,3), UBOUND(InData%TwistedSF,3)
            DO i2 = LBOUND(InData%TwistedSF,2), UBOUND(InData%TwistedSF,2)
              DO i1 = LBOUND(InData%TwistedSF,1), UBOUND(InData%TwistedSF,1)
                ReKiBuf(Re_Xferred) = InData%TwistedSF(i1,i2,i3,i4,i5)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldFl1Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl1Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl1Sh,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl1Sh,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl1Sh,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BldFl1Sh,2), UBOUND(InData%BldFl1Sh,2)
        DO i1 = LBOUND(InData%BldFl1Sh,1), UBOUND(InData%BldFl1Sh,1)
          ReKiBuf(Re_Xferred) = InData%BldFl1Sh(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldFl2Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl2Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl2Sh,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldFl2Sh,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldFl2Sh,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BldFl2Sh,2), UBOUND(InData%BldFl2Sh,2)
        DO i1 = LBOUND(InData%BldFl2Sh,1), UBOUND(InData%BldFl2Sh,1)
          ReKiBuf(Re_Xferred) = InData%BldFl2Sh(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BldEdgSh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldEdgSh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldEdgSh,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldEdgSh,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldEdgSh,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BldEdgSh,2), UBOUND(InData%BldEdgSh,2)
        DO i1 = LBOUND(InData%BldEdgSh,1), UBOUND(InData%BldEdgSh,1)
          ReKiBuf(Re_Xferred) = InData%BldEdgSh(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FreqBE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%FreqBE,3), UBOUND(InData%FreqBE,3)
        DO i2 = LBOUND(InData%FreqBE,2), UBOUND(InData%FreqBE,2)
          DO i1 = LBOUND(InData%FreqBE,1), UBOUND(InData%FreqBE,1)
            ReKiBuf(Re_Xferred) = InData%FreqBE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FreqBF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBF,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqBF,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqBF,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%FreqBF,3), UBOUND(InData%FreqBF,3)
        DO i2 = LBOUND(InData%FreqBF,2), UBOUND(InData%FreqBF,2)
          DO i1 = LBOUND(InData%FreqBF,1), UBOUND(InData%FreqBF,1)
            ReKiBuf(Re_Xferred) = InData%FreqBF(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%FreqTFA,2), UBOUND(InData%FreqTFA,2)
      DO i1 = LBOUND(InData%FreqTFA,1), UBOUND(InData%FreqTFA,1)
        ReKiBuf(Re_Xferred) = InData%FreqTFA(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i2 = LBOUND(InData%FreqTSS,2), UBOUND(InData%FreqTSS,2)
      DO i1 = LBOUND(InData%FreqTSS,1), UBOUND(InData%FreqTSS,1)
        ReKiBuf(Re_Xferred) = InData%FreqTSS(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    ReKiBuf(Re_Xferred) = InData%TeetCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetDmpP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetHSSp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetHStP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetSSSp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TeetSStP
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TeetMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlDSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TFrlUSSpr
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TFrlMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlCDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlDSSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSDP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSSP
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RFrlUSSpr
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RFrlMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ShftGagL
    Re_Xferred = Re_Xferred + 1
    DO i1 = LBOUND(InData%BldGagNd,1), UBOUND(InData%BldGagNd,1)
      IntKiBuf(Int_Xferred) = InData%BldGagNd(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    DO i1 = LBOUND(InData%TwrGagNd,1), UBOUND(InData%TwrGagNd,1)
      IntKiBuf(Int_Xferred) = InData%TwrGagNd(i1)
      Int_Xferred = Int_Xferred + 1
    END DO
    DbKiBuf(Db_Xferred) = InData%TStart
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DTTorDmp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DTTorSpr
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GBRatio
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GBoxEff
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%RotSpeed
    Re_Xferred = Re_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%BElmntMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BElmntMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BElmntMass,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BElmntMass,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BElmntMass,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BElmntMass,2), UBOUND(InData%BElmntMass,2)
        DO i1 = LBOUND(InData%BElmntMass,1), UBOUND(InData%BElmntMass,1)
          ReKiBuf(Re_Xferred) = InData%BElmntMass(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TElmntMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TElmntMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TElmntMass,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TElmntMass,1), UBOUND(InData%TElmntMass,1)
        ReKiBuf(Re_Xferred) = InData%TElmntMass(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%method
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmCMxt
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%PtfmCMyt
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%BD4Blades, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UseAD14, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%BldNd_NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%BldNd_TotNumOuts
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BldNd_OutParam) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BldNd_OutParam,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BldNd_OutParam,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%BldNd_OutParam,1), UBOUND(InData%BldNd_OutParam,1)
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%BldNd_OutParam(i1), ErrStat2, ErrMsg2, OnlySize ) ! BldNd_OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%BldNd_BladesOut
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Jac_u_indx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Jac_u_indx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Jac_u_indx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Jac_u_indx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Jac_u_indx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Jac_u_indx,2), UBOUND(InData%Jac_u_indx,2)
        DO i1 = LBOUND(InData%Jac_u_indx,1), UBOUND(InData%Jac_u_indx,1)
          IntKiBuf(Int_Xferred) = InData%Jac_u_indx(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%du) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%du,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%du,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%du,1), UBOUND(InData%du,1)
        DbKiBuf(Db_Xferred) = InData%du(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dx,1), UBOUND(InData%dx,1)
        DbKiBuf(Db_Xferred) = InData%dx(i1)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%Jac_ny
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_PackParam

 SUBROUTINE ED_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%DT24 = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%BldNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TipNode = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NDOF = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TwoPiNB = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%NAug = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NPH = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PH not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PH)) DEALLOCATE(OutData%PH)
    ALLOCATE(OutData%PH(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PH.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PH,1), UBOUND(OutData%PH,1)
        OutData%PH(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    OutData%NPM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PM not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PM)) DEALLOCATE(OutData%PM)
    ALLOCATE(OutData%PM(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PM.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PM,2), UBOUND(OutData%PM,2)
        DO i1 = LBOUND(OutData%PM,1), UBOUND(OutData%PM,1)
          OutData%PM(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DOF_Flag not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DOF_Flag)) DEALLOCATE(OutData%DOF_Flag)
    ALLOCATE(OutData%DOF_Flag(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DOF_Flag.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DOF_Flag,1), UBOUND(OutData%DOF_Flag,1)
        OutData%DOF_Flag(i1) = TRANSFER(IntKiBuf(Int_Xferred), OutData%DOF_Flag(i1))
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DOF_Desc not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DOF_Desc)) DEALLOCATE(OutData%DOF_Desc)
    ALLOCATE(OutData%DOF_Desc(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DOF_Desc.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DOF_Desc,1), UBOUND(OutData%DOF_Desc,1)
        DO I = 1, LEN(OutData%DOF_Desc)
          OutData%DOF_Desc(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL ED_Unpackactivedofs( Re_Buf, Db_Buf, Int_Buf, OutData%DOFs, ErrStat2, ErrMsg2 ) ! DOFs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFmt)
      OutData%OutFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NBlGages = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NTwGages = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutParam not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutParam)) DEALLOCATE(OutData%OutParam)
    ALLOCATE(OutData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%OutParam,1), UBOUND(OutData%OutParam,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackoutparmtype( Re_Buf, Db_Buf, Int_Buf, OutData%OutParam(i1), ErrStat2, ErrMsg2 ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    DO I = 1, LEN(OutData%Delim)
      OutData%Delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%AvgNrmTpRd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AzimB1Up = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CosDel3 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CosPreC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CosPreC)) DEALLOCATE(OutData%CosPreC)
    ALLOCATE(OutData%CosPreC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CosPreC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%CosPreC,1), UBOUND(OutData%CosPreC,1)
        OutData%CosPreC(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    OutData%CRFrlSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CRFrlSkw2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CRFrlTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CRFrlTlt2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CShftSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CShftTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CSRFrlSkw = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CSRFrlTlt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CSTFrlSkw = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CSTFrlTlt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFinBank = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFinSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFinTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFrlSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFrlSkw2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFrlTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%CTFrlTlt2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%HubHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubCM = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubRad = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacCMzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%OverHang = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ProjArea = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmRefzt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RefTwrHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlPntzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVDxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVDyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVDzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVIMUxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVIMUyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVIMUzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVPxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVPyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rVPzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWIxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWIyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWIzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWJxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWJyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWJzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWKxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWKyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rWKzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rZT0zt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%rZYzt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SinDel3 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SinPreC not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SinPreC)) DEALLOCATE(OutData%SinPreC)
    ALLOCATE(OutData%SinPreC(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SinPreC.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SinPreC,1), UBOUND(OutData%SinPreC,1)
        OutData%SinPreC(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    OutData%SRFrlSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%SRFrlSkw2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%SRFrlTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%SRFrlTlt2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%SShftSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%SShftTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFinBank = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFinSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFinTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFrlSkew = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFrlSkw2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFrlTilt = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%STFrlTlt2 = REAL(DbKiBuf(Db_Xferred), R8Ki)
    Db_Xferred = Db_Xferred + 1
    OutData%TFrlPntxn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlPntyn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlPntzn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TipRad = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TowerBsHt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%UndSling = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumBl = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxRedTFA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxRedTFA)) DEALLOCATE(OutData%AxRedTFA)
    ALLOCATE(OutData%AxRedTFA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxRedTFA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AxRedTFA,3), UBOUND(OutData%AxRedTFA,3)
        DO i2 = LBOUND(OutData%AxRedTFA,2), UBOUND(OutData%AxRedTFA,2)
          DO i1 = LBOUND(OutData%AxRedTFA,1), UBOUND(OutData%AxRedTFA,1)
            OutData%AxRedTFA(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxRedTSS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxRedTSS)) DEALLOCATE(OutData%AxRedTSS)
    ALLOCATE(OutData%AxRedTSS(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxRedTSS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AxRedTSS,3), UBOUND(OutData%AxRedTSS,3)
        DO i2 = LBOUND(OutData%AxRedTSS,2), UBOUND(OutData%AxRedTSS,2)
          DO i1 = LBOUND(OutData%AxRedTSS,1), UBOUND(OutData%AxRedTSS,1)
            OutData%AxRedTSS(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%CTFA,1)
    i1_u = UBOUND(OutData%CTFA,1)
    i2_l = LBOUND(OutData%CTFA,2)
    i2_u = UBOUND(OutData%CTFA,2)
    DO i2 = LBOUND(OutData%CTFA,2), UBOUND(OutData%CTFA,2)
      DO i1 = LBOUND(OutData%CTFA,1), UBOUND(OutData%CTFA,1)
        OutData%CTFA(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%CTSS,1)
    i1_u = UBOUND(OutData%CTSS,1)
    i2_l = LBOUND(OutData%CTSS,2)
    i2_u = UBOUND(OutData%CTSS,2)
    DO i2 = LBOUND(OutData%CTSS,2), UBOUND(OutData%CTSS,2)
      DO i1 = LBOUND(OutData%CTSS,1), UBOUND(OutData%CTSS,1)
        OutData%CTSS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DHNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DHNodes)) DEALLOCATE(OutData%DHNodes)
    ALLOCATE(OutData%DHNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DHNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DHNodes,1), UBOUND(OutData%DHNodes,1)
        OutData%DHNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! HNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%HNodes)) DEALLOCATE(OutData%HNodes)
    ALLOCATE(OutData%HNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%HNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%HNodes,1), UBOUND(OutData%HNodes,1)
        OutData%HNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! HNodesNorm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%HNodesNorm)) DEALLOCATE(OutData%HNodesNorm)
    ALLOCATE(OutData%HNodesNorm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%HNodesNorm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%HNodesNorm,1), UBOUND(OutData%HNodesNorm,1)
        OutData%HNodesNorm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    i1_l = LBOUND(OutData%KTFA,1)
    i1_u = UBOUND(OutData%KTFA,1)
    i2_l = LBOUND(OutData%KTFA,2)
    i2_u = UBOUND(OutData%KTFA,2)
    DO i2 = LBOUND(OutData%KTFA,2), UBOUND(OutData%KTFA,2)
      DO i1 = LBOUND(OutData%KTFA,1), UBOUND(OutData%KTFA,1)
        OutData%KTFA(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%KTSS,1)
    i1_u = UBOUND(OutData%KTSS,1)
    i2_l = LBOUND(OutData%KTSS,2)
    i2_u = UBOUND(OutData%KTSS,2)
    DO i2 = LBOUND(OutData%KTSS,2), UBOUND(OutData%KTSS,2)
      DO i1 = LBOUND(OutData%KTSS,1), UBOUND(OutData%KTSS,1)
        OutData%KTSS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MassT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MassT)) DEALLOCATE(OutData%MassT)
    ALLOCATE(OutData%MassT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MassT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%MassT,1), UBOUND(OutData%MassT,1)
        OutData%MassT(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffTSS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffTSS)) DEALLOCATE(OutData%StiffTSS)
    ALLOCATE(OutData%StiffTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffTSS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StiffTSS,1), UBOUND(OutData%StiffTSS,1)
        OutData%StiffTSS(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwrFASF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwrFASF)) DEALLOCATE(OutData%TwrFASF)
    ALLOCATE(OutData%TwrFASF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwrFASF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%TwrFASF,3), UBOUND(OutData%TwrFASF,3)
        DO i2 = LBOUND(OutData%TwrFASF,2), UBOUND(OutData%TwrFASF,2)
          DO i1 = LBOUND(OutData%TwrFASF,1), UBOUND(OutData%TwrFASF,1)
            OutData%TwrFASF(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%TwrFlexL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwrSSSF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwrSSSF)) DEALLOCATE(OutData%TwrSSSF)
    ALLOCATE(OutData%TwrSSSF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwrSSSF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%TwrSSSF,3), UBOUND(OutData%TwrSSSF,3)
        DO i2 = LBOUND(OutData%TwrSSSF,2), UBOUND(OutData%TwrSSSF,2)
          DO i1 = LBOUND(OutData%TwrSSSF,1), UBOUND(OutData%TwrSSSF,1)
            OutData%TwrSSSF(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%TTopNode = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TwrNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InerTFA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InerTFA)) DEALLOCATE(OutData%InerTFA)
    ALLOCATE(OutData%InerTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InerTFA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%InerTFA,1), UBOUND(OutData%InerTFA,1)
        OutData%InerTFA(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InerTSS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InerTSS)) DEALLOCATE(OutData%InerTSS)
    ALLOCATE(OutData%InerTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InerTSS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%InerTSS,1), UBOUND(OutData%InerTSS,1)
        OutData%InerTSS(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffTGJ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffTGJ)) DEALLOCATE(OutData%StiffTGJ)
    ALLOCATE(OutData%StiffTGJ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffTGJ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StiffTGJ,1), UBOUND(OutData%StiffTGJ,1)
        OutData%StiffTGJ(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffTEA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffTEA)) DEALLOCATE(OutData%StiffTEA)
    ALLOCATE(OutData%StiffTEA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffTEA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StiffTEA,1), UBOUND(OutData%StiffTEA,1)
        OutData%StiffTEA(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffTFA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffTFA)) DEALLOCATE(OutData%StiffTFA)
    ALLOCATE(OutData%StiffTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffTFA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%StiffTFA,1), UBOUND(OutData%StiffTFA,1)
        OutData%StiffTFA(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! cgOffTFA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%cgOffTFA)) DEALLOCATE(OutData%cgOffTFA)
    ALLOCATE(OutData%cgOffTFA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%cgOffTFA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%cgOffTFA,1), UBOUND(OutData%cgOffTFA,1)
        OutData%cgOffTFA(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! cgOffTSS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%cgOffTSS)) DEALLOCATE(OutData%cgOffTSS)
    ALLOCATE(OutData%cgOffTSS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%cgOffTSS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%cgOffTSS,1), UBOUND(OutData%cgOffTSS,1)
        OutData%cgOffTSS(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%AtfaIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldCG not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldCG)) DEALLOCATE(OutData%BldCG)
    ALLOCATE(OutData%BldCG(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldCG.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldCG,1), UBOUND(OutData%BldCG,1)
        OutData%BldCG(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldMass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldMass)) DEALLOCATE(OutData%BldMass)
    ALLOCATE(OutData%BldMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldMass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BldMass,1), UBOUND(OutData%BldMass,1)
        OutData%BldMass(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%BoomMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FirstMom not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FirstMom)) DEALLOCATE(OutData%FirstMom)
    ALLOCATE(OutData%FirstMom(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FirstMom.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FirstMom,1), UBOUND(OutData%FirstMom,1)
        OutData%FirstMom(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%GenIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Hubg1Iner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Hubg2Iner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Nacd2Iner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NacMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmPIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmRIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmYIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RotIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RotMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RrfaIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SecondMom not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SecondMom)) DEALLOCATE(OutData%SecondMom)
    ALLOCATE(OutData%SecondMom(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SecondMom.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SecondMom,1), UBOUND(OutData%SecondMom,1)
        OutData%SecondMom(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%TFinMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlIner = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TipMass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TipMass)) DEALLOCATE(OutData%TipMass)
    ALLOCATE(OutData%TipMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TipMass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TipMass,1), UBOUND(OutData%TipMass,1)
        OutData%TipMass(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%TurbMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TwrMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TwrTpMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%YawBrMass = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Gravity = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PitchAxis not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PitchAxis)) DEALLOCATE(OutData%PitchAxis)
    ALLOCATE(OutData%PitchAxis(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PitchAxis.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PitchAxis,2), UBOUND(OutData%PitchAxis,2)
        DO i1 = LBOUND(OutData%PitchAxis,1), UBOUND(OutData%PitchAxis,1)
          OutData%PitchAxis(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AeroTwst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AeroTwst)) DEALLOCATE(OutData%AeroTwst)
    ALLOCATE(OutData%AeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AeroTwst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AeroTwst,1), UBOUND(OutData%AeroTwst,1)
        OutData%AeroTwst(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxRedBld not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxRedBld)) DEALLOCATE(OutData%AxRedBld)
    ALLOCATE(OutData%AxRedBld(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxRedBld.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%AxRedBld,4), UBOUND(OutData%AxRedBld,4)
        DO i3 = LBOUND(OutData%AxRedBld,3), UBOUND(OutData%AxRedBld,3)
          DO i2 = LBOUND(OutData%AxRedBld,2), UBOUND(OutData%AxRedBld,2)
            DO i1 = LBOUND(OutData%AxRedBld,1), UBOUND(OutData%AxRedBld,1)
              OutData%AxRedBld(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BAlpha not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BAlpha)) DEALLOCATE(OutData%BAlpha)
    ALLOCATE(OutData%BAlpha(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BAlpha.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BAlpha,2), UBOUND(OutData%BAlpha,2)
        DO i1 = LBOUND(OutData%BAlpha,1), UBOUND(OutData%BAlpha,1)
          OutData%BAlpha(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldEDamp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldEDamp)) DEALLOCATE(OutData%BldEDamp)
    ALLOCATE(OutData%BldEDamp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldEDamp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BldEDamp,2), UBOUND(OutData%BldEDamp,2)
        DO i1 = LBOUND(OutData%BldEDamp,1), UBOUND(OutData%BldEDamp,1)
          OutData%BldEDamp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldFDamp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldFDamp)) DEALLOCATE(OutData%BldFDamp)
    ALLOCATE(OutData%BldFDamp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldFDamp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BldFDamp,2), UBOUND(OutData%BldFDamp,2)
        DO i1 = LBOUND(OutData%BldFDamp,1), UBOUND(OutData%BldFDamp,1)
          OutData%BldFDamp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%BldFlexL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CAeroTwst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CAeroTwst)) DEALLOCATE(OutData%CAeroTwst)
    ALLOCATE(OutData%CAeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CAeroTwst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%CAeroTwst,1), UBOUND(OutData%CAeroTwst,1)
        OutData%CAeroTwst(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CBE)) DEALLOCATE(OutData%CBE)
    ALLOCATE(OutData%CBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%CBE,3), UBOUND(OutData%CBE,3)
        DO i2 = LBOUND(OutData%CBE,2), UBOUND(OutData%CBE,2)
          DO i1 = LBOUND(OutData%CBE,1), UBOUND(OutData%CBE,1)
            OutData%CBE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CBF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CBF)) DEALLOCATE(OutData%CBF)
    ALLOCATE(OutData%CBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CBF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%CBF,3), UBOUND(OutData%CBF,3)
        DO i2 = LBOUND(OutData%CBF,2), UBOUND(OutData%CBF,2)
          DO i1 = LBOUND(OutData%CBF,1), UBOUND(OutData%CBF,1)
            OutData%CBF(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! cgOffBEdg not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%cgOffBEdg)) DEALLOCATE(OutData%cgOffBEdg)
    ALLOCATE(OutData%cgOffBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%cgOffBEdg.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%cgOffBEdg,2), UBOUND(OutData%cgOffBEdg,2)
        DO i1 = LBOUND(OutData%cgOffBEdg,1), UBOUND(OutData%cgOffBEdg,1)
          OutData%cgOffBEdg(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! cgOffBFlp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%cgOffBFlp)) DEALLOCATE(OutData%cgOffBFlp)
    ALLOCATE(OutData%cgOffBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%cgOffBFlp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%cgOffBFlp,2), UBOUND(OutData%cgOffBFlp,2)
        DO i1 = LBOUND(OutData%cgOffBFlp,1), UBOUND(OutData%cgOffBFlp,1)
          OutData%cgOffBFlp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Chord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Chord)) DEALLOCATE(OutData%Chord)
    ALLOCATE(OutData%Chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Chord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Chord,1), UBOUND(OutData%Chord,1)
        OutData%Chord(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CThetaS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CThetaS)) DEALLOCATE(OutData%CThetaS)
    ALLOCATE(OutData%CThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CThetaS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%CThetaS,2), UBOUND(OutData%CThetaS,2)
        DO i1 = LBOUND(OutData%CThetaS,1), UBOUND(OutData%CThetaS,1)
          OutData%CThetaS(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DRNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DRNodes)) DEALLOCATE(OutData%DRNodes)
    ALLOCATE(OutData%DRNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DRNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DRNodes,1), UBOUND(OutData%DRNodes,1)
        OutData%DRNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EAOffBEdg not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EAOffBEdg)) DEALLOCATE(OutData%EAOffBEdg)
    ALLOCATE(OutData%EAOffBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EAOffBEdg.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%EAOffBEdg,2), UBOUND(OutData%EAOffBEdg,2)
        DO i1 = LBOUND(OutData%EAOffBEdg,1), UBOUND(OutData%EAOffBEdg,1)
          OutData%EAOffBEdg(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EAOffBFlp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EAOffBFlp)) DEALLOCATE(OutData%EAOffBFlp)
    ALLOCATE(OutData%EAOffBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EAOffBFlp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%EAOffBFlp,2), UBOUND(OutData%EAOffBFlp,2)
        DO i1 = LBOUND(OutData%EAOffBFlp,1), UBOUND(OutData%EAOffBFlp,1)
          OutData%EAOffBFlp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FStTunr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FStTunr)) DEALLOCATE(OutData%FStTunr)
    ALLOCATE(OutData%FStTunr(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FStTunr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FStTunr,2), UBOUND(OutData%FStTunr,2)
        DO i1 = LBOUND(OutData%FStTunr,1), UBOUND(OutData%FStTunr,1)
          OutData%FStTunr(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InerBEdg not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InerBEdg)) DEALLOCATE(OutData%InerBEdg)
    ALLOCATE(OutData%InerBEdg(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InerBEdg.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%InerBEdg,2), UBOUND(OutData%InerBEdg,2)
        DO i1 = LBOUND(OutData%InerBEdg,1), UBOUND(OutData%InerBEdg,1)
          OutData%InerBEdg(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! InerBFlp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%InerBFlp)) DEALLOCATE(OutData%InerBFlp)
    ALLOCATE(OutData%InerBFlp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%InerBFlp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%InerBFlp,2), UBOUND(OutData%InerBFlp,2)
        DO i1 = LBOUND(OutData%InerBFlp,1), UBOUND(OutData%InerBFlp,1)
          OutData%InerBFlp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! KBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%KBE)) DEALLOCATE(OutData%KBE)
    ALLOCATE(OutData%KBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%KBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%KBE,3), UBOUND(OutData%KBE,3)
        DO i2 = LBOUND(OutData%KBE,2), UBOUND(OutData%KBE,2)
          DO i1 = LBOUND(OutData%KBE,1), UBOUND(OutData%KBE,1)
            OutData%KBE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! KBF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%KBF)) DEALLOCATE(OutData%KBF)
    ALLOCATE(OutData%KBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%KBF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%KBF,3), UBOUND(OutData%KBF,3)
        DO i2 = LBOUND(OutData%KBF,2), UBOUND(OutData%KBF,2)
          DO i1 = LBOUND(OutData%KBF,1), UBOUND(OutData%KBF,1)
            OutData%KBF(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MassB not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MassB)) DEALLOCATE(OutData%MassB)
    ALLOCATE(OutData%MassB(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MassB.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%MassB,2), UBOUND(OutData%MassB,2)
        DO i1 = LBOUND(OutData%MassB,1), UBOUND(OutData%MassB,1)
          OutData%MassB(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RefAxisxb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RefAxisxb)) DEALLOCATE(OutData%RefAxisxb)
    ALLOCATE(OutData%RefAxisxb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RefAxisxb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%RefAxisxb,2), UBOUND(OutData%RefAxisxb,2)
        DO i1 = LBOUND(OutData%RefAxisxb,1), UBOUND(OutData%RefAxisxb,1)
          OutData%RefAxisxb(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RefAxisyb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RefAxisyb)) DEALLOCATE(OutData%RefAxisyb)
    ALLOCATE(OutData%RefAxisyb(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RefAxisyb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%RefAxisyb,2), UBOUND(OutData%RefAxisyb,2)
        DO i1 = LBOUND(OutData%RefAxisyb,1), UBOUND(OutData%RefAxisyb,1)
          OutData%RefAxisyb(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RNodes)) DEALLOCATE(OutData%RNodes)
    ALLOCATE(OutData%RNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RNodes,1), UBOUND(OutData%RNodes,1)
        OutData%RNodes(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RNodesNorm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RNodesNorm)) DEALLOCATE(OutData%RNodesNorm)
    ALLOCATE(OutData%RNodesNorm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RNodesNorm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RNodesNorm,1), UBOUND(OutData%RNodesNorm,1)
        OutData%RNodesNorm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rSAerCenn1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rSAerCenn1)) DEALLOCATE(OutData%rSAerCenn1)
    ALLOCATE(OutData%rSAerCenn1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rSAerCenn1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rSAerCenn1,2), UBOUND(OutData%rSAerCenn1,2)
        DO i1 = LBOUND(OutData%rSAerCenn1,1), UBOUND(OutData%rSAerCenn1,1)
          OutData%rSAerCenn1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rSAerCenn2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rSAerCenn2)) DEALLOCATE(OutData%rSAerCenn2)
    ALLOCATE(OutData%rSAerCenn2(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rSAerCenn2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rSAerCenn2,2), UBOUND(OutData%rSAerCenn2,2)
        DO i1 = LBOUND(OutData%rSAerCenn2,1), UBOUND(OutData%rSAerCenn2,1)
          OutData%rSAerCenn2(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SAeroTwst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SAeroTwst)) DEALLOCATE(OutData%SAeroTwst)
    ALLOCATE(OutData%SAeroTwst(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SAeroTwst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SAeroTwst,1), UBOUND(OutData%SAeroTwst,1)
        OutData%SAeroTwst(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffBE)) DEALLOCATE(OutData%StiffBE)
    ALLOCATE(OutData%StiffBE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%StiffBE,2), UBOUND(OutData%StiffBE,2)
        DO i1 = LBOUND(OutData%StiffBE,1), UBOUND(OutData%StiffBE,1)
          OutData%StiffBE(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffBEA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffBEA)) DEALLOCATE(OutData%StiffBEA)
    ALLOCATE(OutData%StiffBEA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffBEA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%StiffBEA,2), UBOUND(OutData%StiffBEA,2)
        DO i1 = LBOUND(OutData%StiffBEA,1), UBOUND(OutData%StiffBEA,1)
          OutData%StiffBEA(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffBF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffBF)) DEALLOCATE(OutData%StiffBF)
    ALLOCATE(OutData%StiffBF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffBF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%StiffBF,2), UBOUND(OutData%StiffBF,2)
        DO i1 = LBOUND(OutData%StiffBF,1), UBOUND(OutData%StiffBF,1)
          OutData%StiffBF(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StiffBGJ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StiffBGJ)) DEALLOCATE(OutData%StiffBGJ)
    ALLOCATE(OutData%StiffBGJ(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StiffBGJ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%StiffBGJ,2), UBOUND(OutData%StiffBGJ,2)
        DO i1 = LBOUND(OutData%StiffBGJ,1), UBOUND(OutData%StiffBGJ,1)
          OutData%StiffBGJ(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SThetaS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SThetaS)) DEALLOCATE(OutData%SThetaS)
    ALLOCATE(OutData%SThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SThetaS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%SThetaS,2), UBOUND(OutData%SThetaS,2)
        DO i1 = LBOUND(OutData%SThetaS,1), UBOUND(OutData%SThetaS,1)
          OutData%SThetaS(i1,i2) = REAL(DbKiBuf(Db_Xferred), R8Ki)
          Db_Xferred = Db_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ThetaS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ThetaS)) DEALLOCATE(OutData%ThetaS)
    ALLOCATE(OutData%ThetaS(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ThetaS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%ThetaS,2), UBOUND(OutData%ThetaS,2)
        DO i1 = LBOUND(OutData%ThetaS,1), UBOUND(OutData%ThetaS,1)
          OutData%ThetaS(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TwistedSF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i5_l = IntKiBuf( Int_Xferred    )
    i5_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TwistedSF)) DEALLOCATE(OutData%TwistedSF)
    ALLOCATE(OutData%TwistedSF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TwistedSF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i5 = LBOUND(OutData%TwistedSF,5), UBOUND(OutData%TwistedSF,5)
        DO i4 = LBOUND(OutData%TwistedSF,4), UBOUND(OutData%TwistedSF,4)
          DO i3 = LBOUND(OutData%TwistedSF,3), UBOUND(OutData%TwistedSF,3)
            DO i2 = LBOUND(OutData%TwistedSF,2), UBOUND(OutData%TwistedSF,2)
              DO i1 = LBOUND(OutData%TwistedSF,1), UBOUND(OutData%TwistedSF,1)
                OutData%TwistedSF(i1,i2,i3,i4,i5) = ReKiBuf(Re_Xferred)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldFl1Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldFl1Sh)) DEALLOCATE(OutData%BldFl1Sh)
    ALLOCATE(OutData%BldFl1Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldFl1Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BldFl1Sh,2), UBOUND(OutData%BldFl1Sh,2)
        DO i1 = LBOUND(OutData%BldFl1Sh,1), UBOUND(OutData%BldFl1Sh,1)
          OutData%BldFl1Sh(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldFl2Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldFl2Sh)) DEALLOCATE(OutData%BldFl2Sh)
    ALLOCATE(OutData%BldFl2Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldFl2Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BldFl2Sh,2), UBOUND(OutData%BldFl2Sh,2)
        DO i1 = LBOUND(OutData%BldFl2Sh,1), UBOUND(OutData%BldFl2Sh,1)
          OutData%BldFl2Sh(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldEdgSh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldEdgSh)) DEALLOCATE(OutData%BldEdgSh)
    ALLOCATE(OutData%BldEdgSh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldEdgSh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BldEdgSh,2), UBOUND(OutData%BldEdgSh,2)
        DO i1 = LBOUND(OutData%BldEdgSh,1), UBOUND(OutData%BldEdgSh,1)
          OutData%BldEdgSh(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FreqBE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FreqBE)) DEALLOCATE(OutData%FreqBE)
    ALLOCATE(OutData%FreqBE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FreqBE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%FreqBE,3), UBOUND(OutData%FreqBE,3)
        DO i2 = LBOUND(OutData%FreqBE,2), UBOUND(OutData%FreqBE,2)
          DO i1 = LBOUND(OutData%FreqBE,1), UBOUND(OutData%FreqBE,1)
            OutData%FreqBE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FreqBF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FreqBF)) DEALLOCATE(OutData%FreqBF)
    ALLOCATE(OutData%FreqBF(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FreqBF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%FreqBF,3), UBOUND(OutData%FreqBF,3)
        DO i2 = LBOUND(OutData%FreqBF,2), UBOUND(OutData%FreqBF,2)
          DO i1 = LBOUND(OutData%FreqBF,1), UBOUND(OutData%FreqBF,1)
            OutData%FreqBF(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%FreqTFA,1)
    i1_u = UBOUND(OutData%FreqTFA,1)
    i2_l = LBOUND(OutData%FreqTFA,2)
    i2_u = UBOUND(OutData%FreqTFA,2)
    DO i2 = LBOUND(OutData%FreqTFA,2), UBOUND(OutData%FreqTFA,2)
      DO i1 = LBOUND(OutData%FreqTFA,1), UBOUND(OutData%FreqTFA,1)
        OutData%FreqTFA(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%FreqTSS,1)
    i1_u = UBOUND(OutData%FreqTSS,1)
    i2_l = LBOUND(OutData%FreqTSS,2)
    i2_u = UBOUND(OutData%FreqTSS,2)
    DO i2 = LBOUND(OutData%FreqTSS,2), UBOUND(OutData%FreqTSS,2)
      DO i1 = LBOUND(OutData%FreqTSS,1), UBOUND(OutData%FreqTSS,1)
        OutData%FreqTSS(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    OutData%TeetCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetDmpP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetHSSp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetHStP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetSSSp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetSStP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TeetMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TFrlCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlDSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlUSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TFrlMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RFrlCDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlDSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSDP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSSP = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlUSSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RFrlMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ShftGagL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    i1_l = LBOUND(OutData%BldGagNd,1)
    i1_u = UBOUND(OutData%BldGagNd,1)
    DO i1 = LBOUND(OutData%BldGagNd,1), UBOUND(OutData%BldGagNd,1)
      OutData%BldGagNd(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    i1_l = LBOUND(OutData%TwrGagNd,1)
    i1_u = UBOUND(OutData%TwrGagNd,1)
    DO i1 = LBOUND(OutData%TwrGagNd,1), UBOUND(OutData%TwrGagNd,1)
      OutData%TwrGagNd(i1) = IntKiBuf(Int_Xferred)
      Int_Xferred = Int_Xferred + 1
    END DO
    OutData%TStart = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%DTTorDmp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DTTorSpr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GBRatio = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%GBoxEff = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RotSpeed = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BElmntMass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BElmntMass)) DEALLOCATE(OutData%BElmntMass)
    ALLOCATE(OutData%BElmntMass(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BElmntMass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BElmntMass,2), UBOUND(OutData%BElmntMass,2)
        DO i1 = LBOUND(OutData%BElmntMass,1), UBOUND(OutData%BElmntMass,1)
          OutData%BElmntMass(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TElmntMass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TElmntMass)) DEALLOCATE(OutData%TElmntMass)
    ALLOCATE(OutData%TElmntMass(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TElmntMass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TElmntMass,1), UBOUND(OutData%TElmntMass,1)
        OutData%TElmntMass(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%method = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%PtfmCMxt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PtfmCMyt = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%BD4Blades = TRANSFER(IntKiBuf(Int_Xferred), OutData%BD4Blades)
    Int_Xferred = Int_Xferred + 1
    OutData%UseAD14 = TRANSFER(IntKiBuf(Int_Xferred), OutData%UseAD14)
    Int_Xferred = Int_Xferred + 1
    OutData%BldNd_NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%BldNd_TotNumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BldNd_OutParam not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BldNd_OutParam)) DEALLOCATE(OutData%BldNd_OutParam)
    ALLOCATE(OutData%BldNd_OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldNd_OutParam.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%BldNd_OutParam,1), UBOUND(OutData%BldNd_OutParam,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackoutparmtype( Re_Buf, Db_Buf, Int_Buf, OutData%BldNd_OutParam(i1), ErrStat2, ErrMsg2 ) ! BldNd_OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%BldNd_BladesOut = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Jac_u_indx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Jac_u_indx)) DEALLOCATE(OutData%Jac_u_indx)
    ALLOCATE(OutData%Jac_u_indx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Jac_u_indx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Jac_u_indx,2), UBOUND(OutData%Jac_u_indx,2)
        DO i1 = LBOUND(OutData%Jac_u_indx,1), UBOUND(OutData%Jac_u_indx,1)
          OutData%Jac_u_indx(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! du not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%du)) DEALLOCATE(OutData%du)
    ALLOCATE(OutData%du(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%du.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%du,1), UBOUND(OutData%du,1)
        OutData%du(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dx)) DEALLOCATE(OutData%dx)
    ALLOCATE(OutData%dx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dx,1), UBOUND(OutData%dx,1)
        OutData%dx(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
        Db_Xferred = Db_Xferred + 1
      END DO
  END IF
    OutData%Jac_ny = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE ED_UnPackParam

 SUBROUTINE ED_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(ED_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(ED_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'ED_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInputData%BladePtLoads)) THEN
  i1_l = LBOUND(SrcInputData%BladePtLoads,1)
  i1_u = UBOUND(SrcInputData%BladePtLoads,1)
  IF (.NOT. ALLOCATED(DstInputData%BladePtLoads)) THEN 
    ALLOCATE(DstInputData%BladePtLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BladePtLoads.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputData%BladePtLoads,1), UBOUND(SrcInputData%BladePtLoads,1)
      CALL MeshCopy( SrcInputData%BladePtLoads(i1), DstInputData%BladePtLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
      CALL MeshCopy( SrcInputData%PlatformPtMesh, DstInputData%PlatformPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MeshCopy( SrcInputData%TowerPtLoads, DstInputData%TowerPtLoads, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MeshCopy( SrcInputData%HubPtLoad, DstInputData%HubPtLoad, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL MeshCopy( SrcInputData%NacelleLoads, DstInputData%NacelleLoads, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcInputData%TwrAddedMass)) THEN
  i1_l = LBOUND(SrcInputData%TwrAddedMass,1)
  i1_u = UBOUND(SrcInputData%TwrAddedMass,1)
  i2_l = LBOUND(SrcInputData%TwrAddedMass,2)
  i2_u = UBOUND(SrcInputData%TwrAddedMass,2)
  i3_l = LBOUND(SrcInputData%TwrAddedMass,3)
  i3_u = UBOUND(SrcInputData%TwrAddedMass,3)
  IF (.NOT. ALLOCATED(DstInputData%TwrAddedMass)) THEN 
    ALLOCATE(DstInputData%TwrAddedMass(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%TwrAddedMass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%TwrAddedMass = SrcInputData%TwrAddedMass
ENDIF
    DstInputData%PtfmAddedMass = SrcInputData%PtfmAddedMass
IF (ALLOCATED(SrcInputData%BlPitchCom)) THEN
  i1_l = LBOUND(SrcInputData%BlPitchCom,1)
  i1_u = UBOUND(SrcInputData%BlPitchCom,1)
  IF (.NOT. ALLOCATED(DstInputData%BlPitchCom)) THEN 
    ALLOCATE(DstInputData%BlPitchCom(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%BlPitchCom.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%BlPitchCom = SrcInputData%BlPitchCom
ENDIF
    DstInputData%YawMom = SrcInputData%YawMom
    DstInputData%GenTrq = SrcInputData%GenTrq
    DstInputData%HSSBrTrqC = SrcInputData%HSSBrTrqC
 END SUBROUTINE ED_CopyInput

 SUBROUTINE ED_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(ED_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'ED_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%BladePtLoads)) THEN
DO i1 = LBOUND(InputData%BladePtLoads,1), UBOUND(InputData%BladePtLoads,1)
  CALL MeshDestroy( InputData%BladePtLoads(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputData%BladePtLoads)
ENDIF
  CALL MeshDestroy( InputData%PlatformPtMesh, ErrStat, ErrMsg )
  CALL MeshDestroy( InputData%TowerPtLoads, ErrStat, ErrMsg )
  CALL MeshDestroy( InputData%HubPtLoad, ErrStat, ErrMsg )
  CALL MeshDestroy( InputData%NacelleLoads, ErrStat, ErrMsg )
IF (ALLOCATED(InputData%TwrAddedMass)) THEN
  DEALLOCATE(InputData%TwrAddedMass)
ENDIF
IF (ALLOCATED(InputData%BlPitchCom)) THEN
  DEALLOCATE(InputData%BlPitchCom)
ENDIF
 END SUBROUTINE ED_DestroyInput

 SUBROUTINE ED_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(ED_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! BladePtLoads allocated yes/no
  IF ( ALLOCATED(InData%BladePtLoads) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BladePtLoads upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%BladePtLoads,1), UBOUND(InData%BladePtLoads,1)
      Int_BufSz   = Int_BufSz + 3  ! BladePtLoads: size of buffers for each call to pack subtype
      CALL MeshPack( InData%BladePtLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! BladePtLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! BladePtLoads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! BladePtLoads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! BladePtLoads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz   = Int_BufSz + 3  ! PlatformPtMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%PlatformPtMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! PlatformPtMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! PlatformPtMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! PlatformPtMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! PlatformPtMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! TowerPtLoads: size of buffers for each call to pack subtype
      CALL MeshPack( InData%TowerPtLoads, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! TowerPtLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! TowerPtLoads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! TowerPtLoads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! TowerPtLoads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! HubPtLoad: size of buffers for each call to pack subtype
      CALL MeshPack( InData%HubPtLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! HubPtLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! HubPtLoad
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! HubPtLoad
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! HubPtLoad
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! NacelleLoads: size of buffers for each call to pack subtype
      CALL MeshPack( InData%NacelleLoads, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! NacelleLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! NacelleLoads
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! NacelleLoads
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! NacelleLoads
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! TwrAddedMass allocated yes/no
  IF ( ALLOCATED(InData%TwrAddedMass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! TwrAddedMass upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TwrAddedMass)  ! TwrAddedMass
  END IF
      Re_BufSz   = Re_BufSz   + SIZE(InData%PtfmAddedMass)  ! PtfmAddedMass
  Int_BufSz   = Int_BufSz   + 1     ! BlPitchCom allocated yes/no
  IF ( ALLOCATED(InData%BlPitchCom) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BlPitchCom upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlPitchCom)  ! BlPitchCom
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! YawMom
      Re_BufSz   = Re_BufSz   + 1  ! GenTrq
      Re_BufSz   = Re_BufSz   + 1  ! HSSBrTrqC
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%BladePtLoads) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BladePtLoads,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BladePtLoads,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%BladePtLoads,1), UBOUND(InData%BladePtLoads,1)
      CALL MeshPack( InData%BladePtLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! BladePtLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
      CALL MeshPack( InData%PlatformPtMesh, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! PlatformPtMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MeshPack( InData%TowerPtLoads, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! TowerPtLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MeshPack( InData%HubPtLoad, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! HubPtLoad 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL MeshPack( InData%NacelleLoads, Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! NacelleLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%TwrAddedMass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrAddedMass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrAddedMass,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrAddedMass,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrAddedMass,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TwrAddedMass,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TwrAddedMass,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%TwrAddedMass,3), UBOUND(InData%TwrAddedMass,3)
        DO i2 = LBOUND(InData%TwrAddedMass,2), UBOUND(InData%TwrAddedMass,2)
          DO i1 = LBOUND(InData%TwrAddedMass,1), UBOUND(InData%TwrAddedMass,1)
            ReKiBuf(Re_Xferred) = InData%TwrAddedMass(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    DO i2 = LBOUND(InData%PtfmAddedMass,2), UBOUND(InData%PtfmAddedMass,2)
      DO i1 = LBOUND(InData%PtfmAddedMass,1), UBOUND(InData%PtfmAddedMass,1)
        ReKiBuf(Re_Xferred) = InData%PtfmAddedMass(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
  IF ( .NOT. ALLOCATED(InData%BlPitchCom) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlPitchCom,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlPitchCom,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BlPitchCom,1), UBOUND(InData%BlPitchCom,1)
        ReKiBuf(Re_Xferred) = InData%BlPitchCom(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%YawMom
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%GenTrq
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HSSBrTrqC
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE ED_PackInput

 SUBROUTINE ED_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(ED_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'ED_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BladePtLoads not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BladePtLoads)) DEALLOCATE(OutData%BladePtLoads)
    ALLOCATE(OutData%BladePtLoads(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladePtLoads.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%BladePtLoads,1), UBOUND(OutData%BladePtLoads,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%BladePtLoads(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! BladePtLoads 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf