@test
subroutine test_BD_GenerateGLL()
  ! test branches
  ! - p = 2, boundaries only
  ! - p = 5, odd number
  ! - p = 6, even number
  ! - p = 97, large, prime number
      
    use pFUnit_mod
    use BeamDyn_Subs
    use NWTC_Num
    use test_tools
    
    implicit none
    
    integer                    :: p
    real(BDKi), allocatable    :: gll_nodes(:), baseline(:)
    integer(IntKi)             :: ErrStat
    character                  :: ErrMsg
    character(1024)            :: testname
    real(BDKi)                 :: tolerance
    
    ! initialize NWTC_Num constants
    call SetConstants()
    
    tolerance = 1e-14
  
    
    ! the baseline solutions for this unit test can be calculated using the Gauss-Lobatto quadrature
    ! this website provides the nodes and weights:
    ! http://keisan.casio.com/exec/system/1280801905
  
    
    ! --------------------------------------------------------------------------
    testname = "p = 2, boundaries only:"
    p = 2
    allocate(baseline(p))
    baseline = (/ -1.0, 1.0 /)
    
    call AllocAry(gll_nodes, p, "GLL points array", ErrStat, ErrMsg)
    call BD_GenerateGLL(p, gll_nodes, ErrStat, ErrMsg)
    
    @assertEqual(baseline, gll_nodes, tolerance, testname)
    
    deallocate(baseline)
    deallocate(gll_nodes)
    
    ! --------------------------------------------------------------------------
    testname = "p = 5, odd number:"
    p = 5
    allocate(baseline(p))
    baseline = (/ -1.0, -0.6546536707079771437983, 0.0, 0.654653670707977143798, 1.0 /)

    call AllocAry(gll_nodes, p, "GLL points array", ErrStat, ErrMsg)
    call BD_GenerateGLL(p, gll_nodes, ErrStat, ErrMsg)
    
    @assertEqual(baseline, gll_nodes, tolerance, testname)
    
    deallocate(baseline)
    deallocate(gll_nodes)
    
    
    ! --------------------------------------------------------------------------
    testname = "p = 6, even number:"
    p = 6
    allocate(baseline(p))
    baseline = (/ -1.0, -0.765055323929464692851, -0.2852315164806450963142, 0.2852315164806450963142, 0.765055323929464692851, 1.0 /)

    call AllocAry(gll_nodes, p, "GLL points array", ErrStat, ErrMsg)
    call BD_GenerateGLL(p, gll_nodes, ErrStat, ErrMsg)
    
    @assertEqual(baseline, gll_nodes, tolerance, testname)
    
    deallocate(baseline)
    deallocate(gll_nodes)
    
    
    ! --------------------------------------------------------------------------
    testname = "p = 97, large, prime number:"
    p = 97
    allocate(baseline(p))
    baseline = (/                                                                                                          & 
     -1.0,                          -0.9992117675187679372925,     -0.997358420211575308381,     -0.994447829238317218534, &
     -0.9904833045655763827779,     -0.9854690874505481580336,     -0.9794105031099910659294,    -0.972313976393383949863, &
     -0.964187029755659609253,      -0.955038276712134050045,      -0.944877413224633009627,     -0.933715207638498109806, &
     -0.921563489367936527388,      -0.9084351364079280548151,     -0.8943440617122115723236,    -0.8793051984632038831786,&
     -0.8633344842547974738284,     -0.8464488442074511804343,     -0.8286661730348553921423,    -0.810005316081936147328, &
     -0.7904860493547251817926,     -0.7701290585635136140501,     -0.748955917201652598455,     -0.7269890636833281333,   &
     -0.704251777564599720681,      -0.6807681548729427782946,     -0.6565630825714660926978,    -0.631662212184884059709, &
     -0.6060919326152061877601,     -0.579879342175961313997,      -0.553052219874599625586,     -0.5256389959735105979894,&
     -0.4976687218608582506373,     -0.4691710392631656985371,     -0.440176148832277959663,     -0.4107147781399945491769,&
     -0.3808181491142908001982,     -0.350517944951638397684,      -0.3198462765404906463777,    -0.2888356484315159109028,&
     -0.257518924390642905356,      -0.2259292925714235538959,     -0.1941002303436225183436,    -0.1620654688153067619161,&
     -0.1298589570860333006308,     -0.09751482626901823919031,    -0.0650673533204149925476,    -0.032550924714033997197, &
      0.0,                           0.032550924714033997197,       0.0650673533204149925476,     0.0975148262690182391903,&
      0.1298589570860333006308,      0.1620654688153067619161,      0.194100230343622518344,      0.225929292571423553896, &
      0.257518924390642905356,       0.2888356484315159109028,      0.3198462765404906463777,     0.3505179449516383976839,&
      0.3808181491142908001982,      0.410714778139994549177,       0.4401761488322779596629,     0.4691710392631656985371,&
      0.4976687218608582506373,      0.5256389959735105979894,      0.5530522198745996255862,     0.579879342175961313997, &
      0.6060919326152061877601,      0.6316622121848840597089,      0.6565630825714660926978,     0.6807681548729427782946,&
      0.7042517775645997206813,      0.7269890636833281332999,      0.7489559172016525984547,     0.7701290585635136140501,&
      0.7904860493547251817926,      0.8100053160819361473279,      0.8286661730348553921423,     0.8464488442074511804343,&
      0.8633344842547974738284,      0.8793051984632038831786,      0.8943440617122115723236,     0.9084351364079280548151,&
      0.9215634893679365273879,      0.933715207638498109806,       0.9448774132246330096275,     0.955038276712134050045, &
      0.9641870297556596092534,      0.9723139763933839498625,      0.9794105031099910659294,     0.9854690874505481580336,&
      0.9904833045655763827779,      0.9944478292383172185338,      0.9973584202115753083808,     0.9992117675187679372925,&
      1.0 /)
    
    call AllocAry(gll_nodes, p, "GLL points array", ErrStat, ErrMsg)
    call BD_GenerateGLL(p, gll_nodes, ErrStat, ErrMsg)
    
    @assertEqual(baseline, gll_nodes, tolerance, testname)
    
    deallocate(baseline)
    deallocate(gll_nodes)
    
end subroutine
