!STARTOFREGISTRYGENERATEDFILE 'AWAE_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AWAE_Types
!.................................................................................................................................
! This file is part of AWAE.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AWAE. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AWAE_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE InflowWind_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: XYSlice = 1      ! Extract an XY slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: YZSlice = 2      ! Extract an YZ slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: XZSlice = 3      ! Extract an XZ slice of data from the 3D grid [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_Uniform = 1      ! Spatial filter model for wake meandering: uniform [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_TruncJinc = 2      ! Spatial filter model for wake meandering: truncated jinc [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: MeanderMod_WndwdJinc = 3      ! Spatial filter model for wake meandering: windowed jinc [-]
! =========  AWAE_HighWindGrid  =======
  TYPE, PUBLIC :: AWAE_HighWindGrid
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: data      !< UVW components of wind data across the high-res regularly-spaced grid [m/s]
  END TYPE AWAE_HighWindGrid
! =======================
! =========  AWAE_InputFileType  =======
  TYPE, PUBLIC :: AWAE_InputFileType
    REAL(ReKi)  :: dr      !< Radial increment of radial finite-difference grid [>0.0] [m]
    REAL(DbKi)  :: dt_low      !< Low-resolution (FAST.Farm driver/glue code) time step [s]
    INTEGER(IntKi)  :: NumTurbines      !< Number of wind turbines in the farm [>=1] [-]
    INTEGER(IntKi)  :: NumRadii      !< Number of radii in the radial finite-difference grid  [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes      !< Number of wake planes downwind of the rotor where the wake is propagated [>=2] [-]
    CHARACTER(1024)  :: WindFilePath      !< Path name to the Root folder containing the wind data files from ABLSolver precursor [-]
    LOGICAL  :: WrDisWind      !< Write disturbed wind data to <WindFilePath>/Low/Dis.t<n>.vtk etc.? [-]
    INTEGER(IntKi)  :: NOutDisWindXY      !< Number of XY planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXY.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindZ      !< Z coordinates of XY planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXY] [meters]
    INTEGER(IntKi)  :: NOutDisWindYZ      !< Number of YZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisYZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindX      !< X coordinates of YZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindYZ] [meters]
    INTEGER(IntKi)  :: NOutDisWindXZ      !< Number of XZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindY      !< Y coordinates of XZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXZ] [meters]
    REAL(DbKi)  :: WrDisDT      !< The time between vtk outputs [must be a multiple of the low resolution time step] [s]
    LOGICAL  :: ChkWndFiles      !< Check all the ambient wind files for data consistency (flag) [-]
    INTEGER(IntKi)  :: Mod_Meander      !< Spatial filter model for wake meandering {1: uniform, 2: truncated jinc, 3: windowed jinc} [DEFAULT=2] [-]
    REAL(ReKi)  :: C_Meander      !< Calibrated parameter for wake meandering [>=1.0] [DEFAULT=1.9] [-]
    INTEGER(IntKi)  :: Mod_AmbWind      !< Ambient wind model {1: high-fidelity precursor in VTK format, 2: InflowWind module} [-]
    CHARACTER(1024)  :: InflowFile      !< Name of file containing InflowWind module input parameters [-]
    REAL(DbKi)  :: dt_high      !< High-resolution (FAST) time step [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: dX_low      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low      !< The spacing of the low-resolution nodes in Z direction [m]
    INTEGER(IntKi)  :: nX_low      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low      !< Number of low-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: X0_low      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low      !< Z-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WT_Position      !< X-Y-Z position of each wind turbine; index 1 = XYZ; index 2 = turbine number [meters]
  END TYPE AWAE_InputFileType
! =======================
! =========  AWAE_InitInputType  =======
  TYPE, PUBLIC :: AWAE_InitInputType
    TYPE(AWAE_InputFileType)  :: InputFileData      !< FAST.Farm input-file data for AWAE module [-]
    INTEGER(IntKi)  :: n_high_low      !< Number of high-resolution time steps per low [-]
    INTEGER(IntKi)  :: NumDT      !< Number of low-resolution (FAST.Farm driver/glue code) time steps [-]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
  END TYPE AWAE_InitInputType
! =======================
! =========  AWAE_InitOutputType  =======
  TYPE, PUBLIC :: AWAE_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: dX_low      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low      !< The spacing of the low-resolution nodes in Z direction [m]
    INTEGER(IntKi)  :: nX_low      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low      !< Number of low-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: X0_low      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low      !< Z-component of the origin of the low-resolution spatial domain [m]
  END TYPE AWAE_InitOutputType
! =======================
! =========  AWAE_ContinuousStateType  =======
  TYPE, PUBLIC :: AWAE_ContinuousStateType
    TYPE(InflowWind_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW continuous states [-]
  END TYPE AWAE_ContinuousStateType
! =======================
! =========  AWAE_DiscreteStateType  =======
  TYPE, PUBLIC :: AWAE_DiscreteStateType
    TYPE(InflowWind_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW discrete states [-]
  END TYPE AWAE_DiscreteStateType
! =======================
! =========  AWAE_ConstraintStateType  =======
  TYPE, PUBLIC :: AWAE_ConstraintStateType
    TYPE(InflowWind_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW  constraint states [-]
  END TYPE AWAE_ConstraintStateType
! =======================
! =========  AWAE_OtherStateType  =======
  TYPE, PUBLIC :: AWAE_OtherStateType
    TYPE(InflowWind_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< Dummy IfW   other states [-]
  END TYPE AWAE_OtherStateType
! =======================
! =========  AWAE_MiscVarType  =======
  TYPE, PUBLIC :: AWAE_MiscVarType
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vamb_low      !< UVW components of ambient wind across the low-resolution domain throughout the farm [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vamb_lowpol      !< UVW components of disturbed wind (ambient + wakes) at points in the polar grid for each wake plane for each turbine [m/s]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: Vdist_low      !< UVW components of disturbed wind (ambient + deficits) across the low-resolution domain throughout the farm [m/s]
    TYPE(AWAE_HighWindGrid) , DIMENSION(:), ALLOCATABLE  :: Vamb_High      !< UVW components of ambient wind across each high-resolution domain around a turbine (one for each turbine) for each high-resolution time step within a low-resolution time step [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes, associated with a given point in the wind spatial domain Orientations of wake planes, normal to wake planes, associated with a given point in the wind spatial domain [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rhat_plane      !<  [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: parallelFlag      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_s      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_e      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rhat_s      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rhat_e      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: pvec_cs      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: pvec_ce      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_wake      !<  [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vr_wake      !<  [m/s]
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizXYPlane 
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizYZPlane 
    REAL(SiKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: outVizXZPlane 
    TYPE(InflowWind_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< InflowWind module misc vars [-]
    TYPE(InflowWind_InputType)  :: u_IfW_Low      !< InflowWind module inputs for the low-resolution grid [-]
    TYPE(InflowWind_InputType)  :: u_IfW_High      !< InflowWind module inputs for the high-resolution grid [-]
    TYPE(InflowWind_OutputType)  :: y_IfW_Low      !< InflowWind module outputs for the low-resolution grid [-]
    TYPE(InflowWind_OutputType)  :: y_IfW_High      !< InflowWind module outputs for the high-resolution grid [-]
  END TYPE AWAE_MiscVarType
! =======================
! =========  AWAE_ParameterType  =======
  TYPE, PUBLIC :: AWAE_ParameterType
    CHARACTER(1024)  :: WindFilePath      !< Path name to the Root folder containing the wind data files from ABLSolver precursor [-]
    INTEGER(IntKi)  :: NumTurbines      !< Number of wind turbines in the farm [>=1] [-]
    INTEGER(IntKi)  :: NumRadii      !< Number of radii in the radial finite-difference grid  [>=2] [-]
    INTEGER(IntKi)  :: NumPlanes      !< Number of wake planes downwind of the rotor where the wake is propagated [>=2] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r      !< Discretization of radial finite-difference grid [m]
    INTEGER(IntKi)  :: Mod_AmbWind      !< Ambient wind model {1: high-fidelity precursor in VTK format, 2: InflowWind module} [-]
    INTEGER(IntKi)  :: nX_low      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low      !< Number of low-resolution spatial nodes in Z direction [-]
    INTEGER(IntKi)  :: NumGrid_low      !< Total number of low-resolution spatial nodes [-]
    INTEGER(IntKi)  :: n_rp_max      !< Maximum possible number of points in the polar grid for the wake plane at each rotor [-]
    REAL(ReKi)  :: dpol      !< Spatial resolution of the polar grid for each wake plane of each turbine [m]
    REAL(ReKi) , DIMENSION(1:3)  :: dXYZ_low      !< XYZ-components of the spatial increment of the low-resolution domain [m]
    REAL(ReKi)  :: dX_low      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low      !< The spacing of the low-resolution nodes in Z direction [m]
    REAL(ReKi)  :: X0_low      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low      !< Z-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X0_high      !< X-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y0_high      !< Y-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Z0_high      !< Z-component of the origin of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dX_high      !< X-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dY_high      !< Y-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dZ_high      !< Z-component of the spatial increment of the high-resolution spatial domain for each turbine [m]
    INTEGER(IntKi)  :: nX_high      !< Number of high-resolution spatial nodes in X direction  [-]
    INTEGER(IntKi)  :: nY_high      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Grid_low      !< XYZ components (global positions) of the spatial discretization of the low-resolution spatial domain [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Grid_high      !< XYZ components (global positions) of the spatial discretization of the high-resolution spatial domain for each turbine  [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WT_Position      !< X-Y-Z position of each wind turbine; index 1 = XYZ; index 2 = turbine number [meters]
    INTEGER(IntKi)  :: n_high_low      !< Number of high-resolution time steps per low [-]
    REAL(DbKi)  :: dt_low      !< Low-resolution (FAST.Farm driver/glue code) time step [s]
    REAL(DbKi)  :: dt_high      !< High-resolution (FAST) time step [s]
    INTEGER(IntKi)  :: NumDT      !< Number of low-resolution (FAST.Farm driver/glue code) time steps [-]
    INTEGER(IntKi)  :: Mod_Meander      !< Spatial filter model for wake meandering [-]
    REAL(ReKi)  :: C_Meander      !< Calibrated parameter for wake meandering [-]
    REAL(ReKi)  :: C_ScaleDiam      !< Normalized wake volume radius for wake meandering (normalized by the wake diameter) [-]
    TYPE(InflowWind_ParameterType) , DIMENSION(:), ALLOCATABLE  :: IfW      !< InflowWind module parameters [-]
    INTEGER(IntKi)  :: WrDisSkp1      !< Number of time steps to skip plus one [-]
    LOGICAL  :: WrDisWind      !< Write disturbed wind data to <WindFilePath>/Low/Dis.t<n>.vtk etc.? [-]
    INTEGER(IntKi)  :: NOutDisWindXY      !< Number of XY planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXY.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindZ      !< Z coordinates of XY planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXY] [meters]
    INTEGER(IntKi)  :: NOutDisWindYZ      !< Number of YZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisYZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindX      !< X coordinates of YZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindYZ] [meters]
    INTEGER(IntKi)  :: NOutDisWindXZ      !< Number of XZ planes for output of disturbed wind data across the low-resolution domain to <WindFilePath>/Low/DisXZ.<n_out>.t<n>.vtk [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDisWindY      !< Y coordinates of XZ planes for output of disturbed wind data across the low-resolution domain [1 to NOutDisWindXZ] [meters]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
    CHARACTER(1024)  :: OutFileVTKRoot      !< The root name for VTK outputs [-]
    INTEGER(IntKi)  :: VTK_tWidth      !< Number of characters for VTK timestamp outputs [-]
  END TYPE AWAE_ParameterType
! =======================
! =========  AWAE_OutputType  =======
  TYPE, PUBLIC :: AWAE_OutputType
    TYPE(AWAE_HighWindGrid) , DIMENSION(:), ALLOCATABLE  :: Vdist_High      !< Wind velocity of disturbed wind (ambient + wakes) across each high-resolution domain around a turbine for each high-resolution step within a low-resolution step [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: V_plane      !< Advection, deflection, and meandering velocity of wake planes for each turbine [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TI_amb      !< Ambient turbulence intensity of wind at rotor disk for each turbine [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vx_wind_disk      !< Rotor-disk-averaged ambient wind speed, normal to disk, for each turbine [m/s]
  END TYPE AWAE_OutputType
! =======================
! =========  AWAE_InputType  =======
  TYPE, PUBLIC :: AWAE_InputType
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: xhat_plane      !< Orientations of wake planes, normal to wake planes, for each turbine [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: p_plane      !< Center positions of wake planes for each turbine [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vx_wake      !< Axial wake velocity deficit at wake planes, distributed radially, for each turbine [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vr_wake      !< Radial wake velocity deficit at wake planes, distributed radially, for each turbine [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: D_wake      !< Wake diameters at wake planes for each turbine [m]
  END TYPE AWAE_InputType
! =======================
CONTAINS
 SUBROUTINE AWAE_CopyHighWindGrid( SrcHighWindGridData, DstHighWindGridData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_HighWindGrid), INTENT(IN) :: SrcHighWindGridData
   TYPE(AWAE_HighWindGrid), INTENT(INOUT) :: DstHighWindGridData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyHighWindGrid'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcHighWindGridData%data)) THEN
  i1_l = LBOUND(SrcHighWindGridData%data,1)
  i1_u = UBOUND(SrcHighWindGridData%data,1)
  i2_l = LBOUND(SrcHighWindGridData%data,2)
  i2_u = UBOUND(SrcHighWindGridData%data,2)
  i3_l = LBOUND(SrcHighWindGridData%data,3)
  i3_u = UBOUND(SrcHighWindGridData%data,3)
  i4_l = LBOUND(SrcHighWindGridData%data,4)
  i4_u = UBOUND(SrcHighWindGridData%data,4)
  i5_l = LBOUND(SrcHighWindGridData%data,5)
  i5_u = UBOUND(SrcHighWindGridData%data,5)
  IF (.NOT. ALLOCATED(DstHighWindGridData%data)) THEN 
    ALLOCATE(DstHighWindGridData%data(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstHighWindGridData%data.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstHighWindGridData%data = SrcHighWindGridData%data
ENDIF
 END SUBROUTINE AWAE_CopyHighWindGrid

 SUBROUTINE AWAE_DestroyHighWindGrid( HighWindGridData, ErrStat, ErrMsg )
  TYPE(AWAE_HighWindGrid), INTENT(INOUT) :: HighWindGridData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyHighWindGrid'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(HighWindGridData%data)) THEN
  DEALLOCATE(HighWindGridData%data)
ENDIF
 END SUBROUTINE AWAE_DestroyHighWindGrid

 SUBROUTINE AWAE_PackHighWindGrid( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_HighWindGrid),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackHighWindGrid'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! data allocated yes/no
  IF ( ALLOCATED(InData%data) ) THEN
    Int_BufSz   = Int_BufSz   + 2*5  ! data upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%data)  ! data
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%data) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%data,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%data,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%data,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%data,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%data,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%data,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%data,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%data,4)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%data,5)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%data,5)
    Int_Xferred = Int_Xferred + 2

      DO i5 = LBOUND(InData%data,5), UBOUND(InData%data,5)
        DO i4 = LBOUND(InData%data,4), UBOUND(InData%data,4)
          DO i3 = LBOUND(InData%data,3), UBOUND(InData%data,3)
            DO i2 = LBOUND(InData%data,2), UBOUND(InData%data,2)
              DO i1 = LBOUND(InData%data,1), UBOUND(InData%data,1)
                ReKiBuf(Re_Xferred) = InData%data(i1,i2,i3,i4,i5)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_PackHighWindGrid

 SUBROUTINE AWAE_UnPackHighWindGrid( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_HighWindGrid), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: i5, i5_l, i5_u  !  bounds (upper/lower) for an array dimension 5
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackHighWindGrid'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! data not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i5_l = IntKiBuf( Int_Xferred    )
    i5_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%data)) DEALLOCATE(OutData%data)
    ALLOCATE(OutData%data(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u,i5_l:i5_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%data.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i5 = LBOUND(OutData%data,5), UBOUND(OutData%data,5)
        DO i4 = LBOUND(OutData%data,4), UBOUND(OutData%data,4)
          DO i3 = LBOUND(OutData%data,3), UBOUND(OutData%data,3)
            DO i2 = LBOUND(OutData%data,2), UBOUND(OutData%data,2)
              DO i1 = LBOUND(OutData%data,1), UBOUND(OutData%data,1)
                OutData%data(i1,i2,i3,i4,i5) = REAL(ReKiBuf(Re_Xferred), SiKi)
                Re_Xferred = Re_Xferred + 1
              END DO
            END DO
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_UnPackHighWindGrid

 SUBROUTINE AWAE_CopyInputFileType( SrcInputFileTypeData, DstInputFileTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_InputFileType), INTENT(IN) :: SrcInputFileTypeData
   TYPE(AWAE_InputFileType), INTENT(INOUT) :: DstInputFileTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyInputFileType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileTypeData%dr = SrcInputFileTypeData%dr
    DstInputFileTypeData%dt_low = SrcInputFileTypeData%dt_low
    DstInputFileTypeData%NumTurbines = SrcInputFileTypeData%NumTurbines
    DstInputFileTypeData%NumRadii = SrcInputFileTypeData%NumRadii
    DstInputFileTypeData%NumPlanes = SrcInputFileTypeData%NumPlanes
    DstInputFileTypeData%WindFilePath = SrcInputFileTypeData%WindFilePath
    DstInputFileTypeData%WrDisWind = SrcInputFileTypeData%WrDisWind
    DstInputFileTypeData%NOutDisWindXY = SrcInputFileTypeData%NOutDisWindXY
IF (ALLOCATED(SrcInputFileTypeData%OutDisWindZ)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%OutDisWindZ,1)
  i1_u = UBOUND(SrcInputFileTypeData%OutDisWindZ,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%OutDisWindZ)) THEN 
    ALLOCATE(DstInputFileTypeData%OutDisWindZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindZ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%OutDisWindZ = SrcInputFileTypeData%OutDisWindZ
ENDIF
    DstInputFileTypeData%NOutDisWindYZ = SrcInputFileTypeData%NOutDisWindYZ
IF (ALLOCATED(SrcInputFileTypeData%OutDisWindX)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%OutDisWindX,1)
  i1_u = UBOUND(SrcInputFileTypeData%OutDisWindX,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%OutDisWindX)) THEN 
    ALLOCATE(DstInputFileTypeData%OutDisWindX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%OutDisWindX = SrcInputFileTypeData%OutDisWindX
ENDIF
    DstInputFileTypeData%NOutDisWindXZ = SrcInputFileTypeData%NOutDisWindXZ
IF (ALLOCATED(SrcInputFileTypeData%OutDisWindY)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%OutDisWindY,1)
  i1_u = UBOUND(SrcInputFileTypeData%OutDisWindY,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%OutDisWindY)) THEN 
    ALLOCATE(DstInputFileTypeData%OutDisWindY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%OutDisWindY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%OutDisWindY = SrcInputFileTypeData%OutDisWindY
ENDIF
    DstInputFileTypeData%WrDisDT = SrcInputFileTypeData%WrDisDT
    DstInputFileTypeData%ChkWndFiles = SrcInputFileTypeData%ChkWndFiles
    DstInputFileTypeData%Mod_Meander = SrcInputFileTypeData%Mod_Meander
    DstInputFileTypeData%C_Meander = SrcInputFileTypeData%C_Meander
    DstInputFileTypeData%Mod_AmbWind = SrcInputFileTypeData%Mod_AmbWind
    DstInputFileTypeData%InflowFile = SrcInputFileTypeData%InflowFile
    DstInputFileTypeData%dt_high = SrcInputFileTypeData%dt_high
IF (ALLOCATED(SrcInputFileTypeData%X0_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%X0_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%X0_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%X0_high)) THEN 
    ALLOCATE(DstInputFileTypeData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%X0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%X0_high = SrcInputFileTypeData%X0_high
ENDIF
IF (ALLOCATED(SrcInputFileTypeData%Y0_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%Y0_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%Y0_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%Y0_high)) THEN 
    ALLOCATE(DstInputFileTypeData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%Y0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%Y0_high = SrcInputFileTypeData%Y0_high
ENDIF
IF (ALLOCATED(SrcInputFileTypeData%Z0_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%Z0_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%Z0_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%Z0_high)) THEN 
    ALLOCATE(DstInputFileTypeData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%Z0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%Z0_high = SrcInputFileTypeData%Z0_high
ENDIF
IF (ALLOCATED(SrcInputFileTypeData%dX_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%dX_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%dX_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%dX_high)) THEN 
    ALLOCATE(DstInputFileTypeData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dX_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%dX_high = SrcInputFileTypeData%dX_high
ENDIF
IF (ALLOCATED(SrcInputFileTypeData%dY_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%dY_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%dY_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%dY_high)) THEN 
    ALLOCATE(DstInputFileTypeData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dY_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%dY_high = SrcInputFileTypeData%dY_high
ENDIF
IF (ALLOCATED(SrcInputFileTypeData%dZ_high)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%dZ_high,1)
  i1_u = UBOUND(SrcInputFileTypeData%dZ_high,1)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%dZ_high)) THEN 
    ALLOCATE(DstInputFileTypeData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%dZ_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%dZ_high = SrcInputFileTypeData%dZ_high
ENDIF
    DstInputFileTypeData%nX_high = SrcInputFileTypeData%nX_high
    DstInputFileTypeData%nY_high = SrcInputFileTypeData%nY_high
    DstInputFileTypeData%nZ_high = SrcInputFileTypeData%nZ_high
    DstInputFileTypeData%dX_low = SrcInputFileTypeData%dX_low
    DstInputFileTypeData%dY_low = SrcInputFileTypeData%dY_low
    DstInputFileTypeData%dZ_low = SrcInputFileTypeData%dZ_low
    DstInputFileTypeData%nX_low = SrcInputFileTypeData%nX_low
    DstInputFileTypeData%nY_low = SrcInputFileTypeData%nY_low
    DstInputFileTypeData%nZ_low = SrcInputFileTypeData%nZ_low
    DstInputFileTypeData%X0_low = SrcInputFileTypeData%X0_low
    DstInputFileTypeData%Y0_low = SrcInputFileTypeData%Y0_low
    DstInputFileTypeData%Z0_low = SrcInputFileTypeData%Z0_low
IF (ALLOCATED(SrcInputFileTypeData%WT_Position)) THEN
  i1_l = LBOUND(SrcInputFileTypeData%WT_Position,1)
  i1_u = UBOUND(SrcInputFileTypeData%WT_Position,1)
  i2_l = LBOUND(SrcInputFileTypeData%WT_Position,2)
  i2_u = UBOUND(SrcInputFileTypeData%WT_Position,2)
  IF (.NOT. ALLOCATED(DstInputFileTypeData%WT_Position)) THEN 
    ALLOCATE(DstInputFileTypeData%WT_Position(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileTypeData%WT_Position.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileTypeData%WT_Position = SrcInputFileTypeData%WT_Position
ENDIF
 END SUBROUTINE AWAE_CopyInputFileType

 SUBROUTINE AWAE_DestroyInputFileType( InputFileTypeData, ErrStat, ErrMsg )
  TYPE(AWAE_InputFileType), INTENT(INOUT) :: InputFileTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyInputFileType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputFileTypeData%OutDisWindZ)) THEN
  DEALLOCATE(InputFileTypeData%OutDisWindZ)
ENDIF
IF (ALLOCATED(InputFileTypeData%OutDisWindX)) THEN
  DEALLOCATE(InputFileTypeData%OutDisWindX)
ENDIF
IF (ALLOCATED(InputFileTypeData%OutDisWindY)) THEN
  DEALLOCATE(InputFileTypeData%OutDisWindY)
ENDIF
IF (ALLOCATED(InputFileTypeData%X0_high)) THEN
  DEALLOCATE(InputFileTypeData%X0_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%Y0_high)) THEN
  DEALLOCATE(InputFileTypeData%Y0_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%Z0_high)) THEN
  DEALLOCATE(InputFileTypeData%Z0_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%dX_high)) THEN
  DEALLOCATE(InputFileTypeData%dX_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%dY_high)) THEN
  DEALLOCATE(InputFileTypeData%dY_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%dZ_high)) THEN
  DEALLOCATE(InputFileTypeData%dZ_high)
ENDIF
IF (ALLOCATED(InputFileTypeData%WT_Position)) THEN
  DEALLOCATE(InputFileTypeData%WT_Position)
ENDIF
 END SUBROUTINE AWAE_DestroyInputFileType

 SUBROUTINE AWAE_PackInputFileType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_InputFileType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackInputFileType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! dr
      Db_BufSz   = Db_BufSz   + 1  ! dt_low
      Int_BufSz  = Int_BufSz  + 1  ! NumTurbines
      Int_BufSz  = Int_BufSz  + 1  ! NumRadii
      Int_BufSz  = Int_BufSz  + 1  ! NumPlanes
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%WindFilePath)  ! WindFilePath
      Int_BufSz  = Int_BufSz  + 1  ! WrDisWind
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindXY
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindZ allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindZ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindZ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindZ)  ! OutDisWindZ
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindYZ
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindX allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindX)  ! OutDisWindX
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindXZ
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindY allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindY)  ! OutDisWindY
  END IF
      Db_BufSz   = Db_BufSz   + 1  ! WrDisDT
      Int_BufSz  = Int_BufSz  + 1  ! ChkWndFiles
      Int_BufSz  = Int_BufSz  + 1  ! Mod_Meander
      Re_BufSz   = Re_BufSz   + 1  ! C_Meander
      Int_BufSz  = Int_BufSz  + 1  ! Mod_AmbWind
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%InflowFile)  ! InflowFile
      Db_BufSz   = Db_BufSz   + 1  ! dt_high
  Int_BufSz   = Int_BufSz   + 1     ! X0_high allocated yes/no
  IF ( ALLOCATED(InData%X0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! X0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X0_high)  ! X0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Y0_high allocated yes/no
  IF ( ALLOCATED(InData%Y0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Y0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Y0_high)  ! Y0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Z0_high allocated yes/no
  IF ( ALLOCATED(InData%Z0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Z0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Z0_high)  ! Z0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dX_high allocated yes/no
  IF ( ALLOCATED(InData%dX_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dX_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dX_high)  ! dX_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dY_high allocated yes/no
  IF ( ALLOCATED(InData%dY_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dY_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dY_high)  ! dY_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dZ_high allocated yes/no
  IF ( ALLOCATED(InData%dZ_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dZ_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dZ_high)  ! dZ_high
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! nX_high
      Int_BufSz  = Int_BufSz  + 1  ! nY_high
      Int_BufSz  = Int_BufSz  + 1  ! nZ_high
      Re_BufSz   = Re_BufSz   + 1  ! dX_low
      Re_BufSz   = Re_BufSz   + 1  ! dY_low
      Re_BufSz   = Re_BufSz   + 1  ! dZ_low
      Int_BufSz  = Int_BufSz  + 1  ! nX_low
      Int_BufSz  = Int_BufSz  + 1  ! nY_low
      Int_BufSz  = Int_BufSz  + 1  ! nZ_low
      Re_BufSz   = Re_BufSz   + 1  ! X0_low
      Re_BufSz   = Re_BufSz   + 1  ! Y0_low
      Re_BufSz   = Re_BufSz   + 1  ! Z0_low
  Int_BufSz   = Int_BufSz   + 1     ! WT_Position allocated yes/no
  IF ( ALLOCATED(InData%WT_Position) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! WT_Position upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WT_Position)  ! WT_Position
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%dr
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%dt_low
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumTurbines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumRadii
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumPlanes
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%WindFilePath)
      IntKiBuf(Int_Xferred) = ICHAR(InData%WindFilePath(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = TRANSFER(InData%WrDisWind, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NOutDisWindXY
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindZ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindZ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindZ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindZ,1), UBOUND(InData%OutDisWindZ,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindZ(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NOutDisWindYZ
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindX,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindX,1), UBOUND(InData%OutDisWindX,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindX(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NOutDisWindXZ
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindY,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindY,1), UBOUND(InData%OutDisWindY,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindY(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DbKiBuf(Db_Xferred) = InData%WrDisDT
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ChkWndFiles, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Mod_Meander
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_Meander
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Mod_AmbWind
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%InflowFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%InflowFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DbKiBuf(Db_Xferred) = InData%dt_high
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%X0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%X0_high,1), UBOUND(InData%X0_high,1)
        ReKiBuf(Re_Xferred) = InData%X0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Y0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Y0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Y0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Y0_high,1), UBOUND(InData%Y0_high,1)
        ReKiBuf(Re_Xferred) = InData%Y0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Z0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Z0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Z0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Z0_high,1), UBOUND(InData%Z0_high,1)
        ReKiBuf(Re_Xferred) = InData%Z0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dX_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dX_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dX_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dX_high,1), UBOUND(InData%dX_high,1)
        ReKiBuf(Re_Xferred) = InData%dX_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dY_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dY_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dY_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dY_high,1), UBOUND(InData%dY_high,1)
        ReKiBuf(Re_Xferred) = InData%dY_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dZ_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dZ_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dZ_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dZ_high,1), UBOUND(InData%dZ_high,1)
        ReKiBuf(Re_Xferred) = InData%dZ_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%nX_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_high
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dX_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dY_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dZ_low
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nX_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_low
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Y0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Z0_low
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%WT_Position) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WT_Position,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WT_Position,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WT_Position,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WT_Position,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%WT_Position,2), UBOUND(InData%WT_Position,2)
        DO i1 = LBOUND(InData%WT_Position,1), UBOUND(InData%WT_Position,1)
          ReKiBuf(Re_Xferred) = InData%WT_Position(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_PackInputFileType

 SUBROUTINE AWAE_UnPackInputFileType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_InputFileType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackInputFileType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dr = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dt_low = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%NumTurbines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumRadii = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumPlanes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%WindFilePath)
      OutData%WindFilePath(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%WrDisWind = TRANSFER(IntKiBuf(Int_Xferred), OutData%WrDisWind)
    Int_Xferred = Int_Xferred + 1
    OutData%NOutDisWindXY = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindZ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindZ)) DEALLOCATE(OutData%OutDisWindZ)
    ALLOCATE(OutData%OutDisWindZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindZ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindZ,1), UBOUND(OutData%OutDisWindZ,1)
        OutData%OutDisWindZ(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%NOutDisWindYZ = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindX)) DEALLOCATE(OutData%OutDisWindX)
    ALLOCATE(OutData%OutDisWindX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindX,1), UBOUND(OutData%OutDisWindX,1)
        OutData%OutDisWindX(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%NOutDisWindXZ = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindY)) DEALLOCATE(OutData%OutDisWindY)
    ALLOCATE(OutData%OutDisWindY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindY,1), UBOUND(OutData%OutDisWindY,1)
        OutData%OutDisWindY(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%WrDisDT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%ChkWndFiles = TRANSFER(IntKiBuf(Int_Xferred), OutData%ChkWndFiles)
    Int_Xferred = Int_Xferred + 1
    OutData%Mod_Meander = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%C_Meander = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Mod_AmbWind = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%InflowFile)
      OutData%InflowFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%dt_high = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X0_high)) DEALLOCATE(OutData%X0_high)
    ALLOCATE(OutData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%X0_high,1), UBOUND(OutData%X0_high,1)
        OutData%X0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Y0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Y0_high)) DEALLOCATE(OutData%Y0_high)
    ALLOCATE(OutData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Y0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Y0_high,1), UBOUND(OutData%Y0_high,1)
        OutData%Y0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Z0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Z0_high)) DEALLOCATE(OutData%Z0_high)
    ALLOCATE(OutData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Z0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Z0_high,1), UBOUND(OutData%Z0_high,1)
        OutData%Z0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dX_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dX_high)) DEALLOCATE(OutData%dX_high)
    ALLOCATE(OutData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dX_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dX_high,1), UBOUND(OutData%dX_high,1)
        OutData%dX_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dY_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dY_high)) DEALLOCATE(OutData%dY_high)
    ALLOCATE(OutData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dY_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dY_high,1), UBOUND(OutData%dY_high,1)
        OutData%dY_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dZ_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dZ_high)) DEALLOCATE(OutData%dZ_high)
    ALLOCATE(OutData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dZ_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dZ_high,1), UBOUND(OutData%dZ_high,1)
        OutData%dZ_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%nX_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dX_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dY_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dZ_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%nX_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%X0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Y0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Z0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WT_Position not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WT_Position)) DEALLOCATE(OutData%WT_Position)
    ALLOCATE(OutData%WT_Position(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WT_Position.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%WT_Position,2), UBOUND(OutData%WT_Position,2)
        DO i1 = LBOUND(OutData%WT_Position,1), UBOUND(OutData%WT_Position,1)
          OutData%WT_Position(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_UnPackInputFileType

 SUBROUTINE AWAE_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(AWAE_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL AWAE_Copyinputfiletype( SrcInitInputData%InputFileData, DstInitInputData%InputFileData, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstInitInputData%n_high_low = SrcInitInputData%n_high_low
    DstInitInputData%NumDT = SrcInitInputData%NumDT
    DstInitInputData%OutFileRoot = SrcInitInputData%OutFileRoot
 END SUBROUTINE AWAE_CopyInitInput

 SUBROUTINE AWAE_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(AWAE_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL AWAE_Destroyinputfiletype( InitInputData%InputFileData, ErrStat, ErrMsg )
 END SUBROUTINE AWAE_DestroyInitInput

 SUBROUTINE AWAE_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! InputFileData: size of buffers for each call to pack subtype
      CALL AWAE_Packinputfiletype( Re_Buf, Db_Buf, Int_Buf, InData%InputFileData, ErrStat2, ErrMsg2, .TRUE. ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! InputFileData
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! InputFileData
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! InputFileData
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! n_high_low
      Int_BufSz  = Int_BufSz  + 1  ! NumDT
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFileRoot)  ! OutFileRoot
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL AWAE_Packinputfiletype( Re_Buf, Db_Buf, Int_Buf, InData%InputFileData, ErrStat2, ErrMsg2, OnlySize ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = InData%n_high_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumDT
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFileRoot)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFileRoot(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE AWAE_PackInitInput

 SUBROUTINE AWAE_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AWAE_Unpackinputfiletype( Re_Buf, Db_Buf, Int_Buf, OutData%InputFileData, ErrStat2, ErrMsg2 ) ! InputFileData 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%n_high_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumDT = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFileRoot)
      OutData%OutFileRoot(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
 END SUBROUTINE AWAE_UnPackInitInput

 SUBROUTINE AWAE_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(AWAE_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcInitOutputData%X0_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%X0_high,1)
  i1_u = UBOUND(SrcInitOutputData%X0_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%X0_high)) THEN 
    ALLOCATE(DstInitOutputData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%X0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%X0_high = SrcInitOutputData%X0_high
ENDIF
IF (ALLOCATED(SrcInitOutputData%Y0_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%Y0_high,1)
  i1_u = UBOUND(SrcInitOutputData%Y0_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%Y0_high)) THEN 
    ALLOCATE(DstInitOutputData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%Y0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%Y0_high = SrcInitOutputData%Y0_high
ENDIF
IF (ALLOCATED(SrcInitOutputData%Z0_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%Z0_high,1)
  i1_u = UBOUND(SrcInitOutputData%Z0_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%Z0_high)) THEN 
    ALLOCATE(DstInitOutputData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%Z0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%Z0_high = SrcInitOutputData%Z0_high
ENDIF
IF (ALLOCATED(SrcInitOutputData%dX_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%dX_high,1)
  i1_u = UBOUND(SrcInitOutputData%dX_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%dX_high)) THEN 
    ALLOCATE(DstInitOutputData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dX_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%dX_high = SrcInitOutputData%dX_high
ENDIF
IF (ALLOCATED(SrcInitOutputData%dY_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%dY_high,1)
  i1_u = UBOUND(SrcInitOutputData%dY_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%dY_high)) THEN 
    ALLOCATE(DstInitOutputData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dY_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%dY_high = SrcInitOutputData%dY_high
ENDIF
IF (ALLOCATED(SrcInitOutputData%dZ_high)) THEN
  i1_l = LBOUND(SrcInitOutputData%dZ_high,1)
  i1_u = UBOUND(SrcInitOutputData%dZ_high,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%dZ_high)) THEN 
    ALLOCATE(DstInitOutputData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%dZ_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%dZ_high = SrcInitOutputData%dZ_high
ENDIF
    DstInitOutputData%nX_high = SrcInitOutputData%nX_high
    DstInitOutputData%nY_high = SrcInitOutputData%nY_high
    DstInitOutputData%nZ_high = SrcInitOutputData%nZ_high
    DstInitOutputData%dX_low = SrcInitOutputData%dX_low
    DstInitOutputData%dY_low = SrcInitOutputData%dY_low
    DstInitOutputData%dZ_low = SrcInitOutputData%dZ_low
    DstInitOutputData%nX_low = SrcInitOutputData%nX_low
    DstInitOutputData%nY_low = SrcInitOutputData%nY_low
    DstInitOutputData%nZ_low = SrcInitOutputData%nZ_low
    DstInitOutputData%X0_low = SrcInitOutputData%X0_low
    DstInitOutputData%Y0_low = SrcInitOutputData%Y0_low
    DstInitOutputData%Z0_low = SrcInitOutputData%Z0_low
 END SUBROUTINE AWAE_CopyInitOutput

 SUBROUTINE AWAE_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(AWAE_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
IF (ALLOCATED(InitOutputData%X0_high)) THEN
  DEALLOCATE(InitOutputData%X0_high)
ENDIF
IF (ALLOCATED(InitOutputData%Y0_high)) THEN
  DEALLOCATE(InitOutputData%Y0_high)
ENDIF
IF (ALLOCATED(InitOutputData%Z0_high)) THEN
  DEALLOCATE(InitOutputData%Z0_high)
ENDIF
IF (ALLOCATED(InitOutputData%dX_high)) THEN
  DEALLOCATE(InitOutputData%dX_high)
ENDIF
IF (ALLOCATED(InitOutputData%dY_high)) THEN
  DEALLOCATE(InitOutputData%dY_high)
ENDIF
IF (ALLOCATED(InitOutputData%dZ_high)) THEN
  DEALLOCATE(InitOutputData%dZ_high)
ENDIF
 END SUBROUTINE AWAE_DestroyInitOutput

 SUBROUTINE AWAE_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! X0_high allocated yes/no
  IF ( ALLOCATED(InData%X0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! X0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X0_high)  ! X0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Y0_high allocated yes/no
  IF ( ALLOCATED(InData%Y0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Y0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Y0_high)  ! Y0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Z0_high allocated yes/no
  IF ( ALLOCATED(InData%Z0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Z0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Z0_high)  ! Z0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dX_high allocated yes/no
  IF ( ALLOCATED(InData%dX_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dX_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dX_high)  ! dX_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dY_high allocated yes/no
  IF ( ALLOCATED(InData%dY_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dY_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dY_high)  ! dY_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dZ_high allocated yes/no
  IF ( ALLOCATED(InData%dZ_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dZ_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dZ_high)  ! dZ_high
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! nX_high
      Int_BufSz  = Int_BufSz  + 1  ! nY_high
      Int_BufSz  = Int_BufSz  + 1  ! nZ_high
      Re_BufSz   = Re_BufSz   + 1  ! dX_low
      Re_BufSz   = Re_BufSz   + 1  ! dY_low
      Re_BufSz   = Re_BufSz   + 1  ! dZ_low
      Int_BufSz  = Int_BufSz  + 1  ! nX_low
      Int_BufSz  = Int_BufSz  + 1  ! nY_low
      Int_BufSz  = Int_BufSz  + 1  ! nZ_low
      Re_BufSz   = Re_BufSz   + 1  ! X0_low
      Re_BufSz   = Re_BufSz   + 1  ! Y0_low
      Re_BufSz   = Re_BufSz   + 1  ! Z0_low
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%X0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%X0_high,1), UBOUND(InData%X0_high,1)
        ReKiBuf(Re_Xferred) = InData%X0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Y0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Y0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Y0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Y0_high,1), UBOUND(InData%Y0_high,1)
        ReKiBuf(Re_Xferred) = InData%Y0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Z0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Z0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Z0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Z0_high,1), UBOUND(InData%Z0_high,1)
        ReKiBuf(Re_Xferred) = InData%Z0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dX_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dX_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dX_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dX_high,1), UBOUND(InData%dX_high,1)
        ReKiBuf(Re_Xferred) = InData%dX_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dY_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dY_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dY_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dY_high,1), UBOUND(InData%dY_high,1)
        ReKiBuf(Re_Xferred) = InData%dY_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dZ_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dZ_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dZ_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dZ_high,1), UBOUND(InData%dZ_high,1)
        ReKiBuf(Re_Xferred) = InData%dZ_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%nX_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_high
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dX_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dY_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dZ_low
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nX_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_low
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Y0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Z0_low
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AWAE_PackInitOutput

 SUBROUTINE AWAE_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X0_high)) DEALLOCATE(OutData%X0_high)
    ALLOCATE(OutData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%X0_high,1), UBOUND(OutData%X0_high,1)
        OutData%X0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Y0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Y0_high)) DEALLOCATE(OutData%Y0_high)
    ALLOCATE(OutData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Y0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Y0_high,1), UBOUND(OutData%Y0_high,1)
        OutData%Y0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Z0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Z0_high)) DEALLOCATE(OutData%Z0_high)
    ALLOCATE(OutData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Z0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Z0_high,1), UBOUND(OutData%Z0_high,1)
        OutData%Z0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dX_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dX_high)) DEALLOCATE(OutData%dX_high)
    ALLOCATE(OutData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dX_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dX_high,1), UBOUND(OutData%dX_high,1)
        OutData%dX_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dY_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dY_high)) DEALLOCATE(OutData%dY_high)
    ALLOCATE(OutData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dY_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dY_high,1), UBOUND(OutData%dY_high,1)
        OutData%dY_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dZ_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dZ_high)) DEALLOCATE(OutData%dZ_high)
    ALLOCATE(OutData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dZ_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dZ_high,1), UBOUND(OutData%dZ_high,1)
        OutData%dZ_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%nX_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dX_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dY_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dZ_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%nX_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%X0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Y0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Z0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AWAE_UnPackInitOutput

 SUBROUTINE AWAE_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(AWAE_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcContStateData%IfW)) THEN
  i1_l = LBOUND(SrcContStateData%IfW,1)
  i1_u = UBOUND(SrcContStateData%IfW,1)
  IF (.NOT. ALLOCATED(DstContStateData%IfW)) THEN 
    ALLOCATE(DstContStateData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcContStateData%IfW,1), UBOUND(SrcContStateData%IfW,1)
      CALL InflowWind_CopyContState( SrcContStateData%IfW(i1), DstContStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE AWAE_CopyContState

 SUBROUTINE AWAE_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(AWAE_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ContStateData%IfW)) THEN
DO i1 = LBOUND(ContStateData%IfW,1), UBOUND(ContStateData%IfW,1)
  CALL InflowWind_DestroyContState( ContStateData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ContStateData%IfW)
ENDIF
 END SUBROUTINE AWAE_DestroyContState

 SUBROUTINE AWAE_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE AWAE_PackContState

 SUBROUTINE AWAE_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE AWAE_UnPackContState

 SUBROUTINE AWAE_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(AWAE_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcDiscStateData%IfW)) THEN
  i1_l = LBOUND(SrcDiscStateData%IfW,1)
  i1_u = UBOUND(SrcDiscStateData%IfW,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%IfW)) THEN 
    ALLOCATE(DstDiscStateData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcDiscStateData%IfW,1), UBOUND(SrcDiscStateData%IfW,1)
      CALL InflowWind_CopyDiscState( SrcDiscStateData%IfW(i1), DstDiscStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE AWAE_CopyDiscState

 SUBROUTINE AWAE_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(AWAE_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(DiscStateData%IfW)) THEN
DO i1 = LBOUND(DiscStateData%IfW,1), UBOUND(DiscStateData%IfW,1)
  CALL InflowWind_DestroyDiscState( DiscStateData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(DiscStateData%IfW)
ENDIF
 END SUBROUTINE AWAE_DestroyDiscState

 SUBROUTINE AWAE_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE AWAE_PackDiscState

 SUBROUTINE AWAE_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackDiscState( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE AWAE_UnPackDiscState

 SUBROUTINE AWAE_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(AWAE_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcConstrStateData%IfW)) THEN
  i1_l = LBOUND(SrcConstrStateData%IfW,1)
  i1_u = UBOUND(SrcConstrStateData%IfW,1)
  IF (.NOT. ALLOCATED(DstConstrStateData%IfW)) THEN 
    ALLOCATE(DstConstrStateData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcConstrStateData%IfW,1), UBOUND(SrcConstrStateData%IfW,1)
      CALL InflowWind_CopyConstrState( SrcConstrStateData%IfW(i1), DstConstrStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE AWAE_CopyConstrState

 SUBROUTINE AWAE_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(AWAE_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ConstrStateData%IfW)) THEN
DO i1 = LBOUND(ConstrStateData%IfW,1), UBOUND(ConstrStateData%IfW,1)
  CALL InflowWind_DestroyConstrState( ConstrStateData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ConstrStateData%IfW)
ENDIF
 END SUBROUTINE AWAE_DestroyConstrState

 SUBROUTINE AWAE_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackConstrState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackConstrState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE AWAE_PackConstrState

 SUBROUTINE AWAE_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackConstrState( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE AWAE_UnPackConstrState

 SUBROUTINE AWAE_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(AWAE_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOtherStateData%IfW)) THEN
  i1_l = LBOUND(SrcOtherStateData%IfW,1)
  i1_u = UBOUND(SrcOtherStateData%IfW,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%IfW)) THEN 
    ALLOCATE(DstOtherStateData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcOtherStateData%IfW,1), UBOUND(SrcOtherStateData%IfW,1)
      CALL InflowWind_CopyOtherState( SrcOtherStateData%IfW(i1), DstOtherStateData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE AWAE_CopyOtherState

 SUBROUTINE AWAE_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(AWAE_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OtherStateData%IfW)) THEN
DO i1 = LBOUND(OtherStateData%IfW,1), UBOUND(OtherStateData%IfW,1)
  CALL InflowWind_DestroyOtherState( OtherStateData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(OtherStateData%IfW)
ENDIF
 END SUBROUTINE AWAE_DestroyOtherState

 SUBROUTINE AWAE_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE AWAE_PackOtherState

 SUBROUTINE AWAE_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackOtherState( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE AWAE_UnPackOtherState

 SUBROUTINE AWAE_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(AWAE_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%Vamb_low)) THEN
  i1_l = LBOUND(SrcMiscData%Vamb_low,1)
  i1_u = UBOUND(SrcMiscData%Vamb_low,1)
  i2_l = LBOUND(SrcMiscData%Vamb_low,2)
  i2_u = UBOUND(SrcMiscData%Vamb_low,2)
  i3_l = LBOUND(SrcMiscData%Vamb_low,3)
  i3_u = UBOUND(SrcMiscData%Vamb_low,3)
  i4_l = LBOUND(SrcMiscData%Vamb_low,4)
  i4_u = UBOUND(SrcMiscData%Vamb_low,4)
  IF (.NOT. ALLOCATED(DstMiscData%Vamb_low)) THEN 
    ALLOCATE(DstMiscData%Vamb_low(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_low.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vamb_low = SrcMiscData%Vamb_low
ENDIF
IF (ALLOCATED(SrcMiscData%Vamb_lowpol)) THEN
  i1_l = LBOUND(SrcMiscData%Vamb_lowpol,1)
  i1_u = UBOUND(SrcMiscData%Vamb_lowpol,1)
  i2_l = LBOUND(SrcMiscData%Vamb_lowpol,2)
  i2_u = UBOUND(SrcMiscData%Vamb_lowpol,2)
  IF (.NOT. ALLOCATED(DstMiscData%Vamb_lowpol)) THEN 
    ALLOCATE(DstMiscData%Vamb_lowpol(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_lowpol.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vamb_lowpol = SrcMiscData%Vamb_lowpol
ENDIF
IF (ALLOCATED(SrcMiscData%Vdist_low)) THEN
  i1_l = LBOUND(SrcMiscData%Vdist_low,1)
  i1_u = UBOUND(SrcMiscData%Vdist_low,1)
  i2_l = LBOUND(SrcMiscData%Vdist_low,2)
  i2_u = UBOUND(SrcMiscData%Vdist_low,2)
  i3_l = LBOUND(SrcMiscData%Vdist_low,3)
  i3_u = UBOUND(SrcMiscData%Vdist_low,3)
  i4_l = LBOUND(SrcMiscData%Vdist_low,4)
  i4_u = UBOUND(SrcMiscData%Vdist_low,4)
  IF (.NOT. ALLOCATED(DstMiscData%Vdist_low)) THEN 
    ALLOCATE(DstMiscData%Vdist_low(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vdist_low.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vdist_low = SrcMiscData%Vdist_low
ENDIF
IF (ALLOCATED(SrcMiscData%Vamb_High)) THEN
  i1_l = LBOUND(SrcMiscData%Vamb_High,1)
  i1_u = UBOUND(SrcMiscData%Vamb_High,1)
  IF (.NOT. ALLOCATED(DstMiscData%Vamb_High)) THEN 
    ALLOCATE(DstMiscData%Vamb_High(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vamb_High.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%Vamb_High,1), UBOUND(SrcMiscData%Vamb_High,1)
      CALL AWAE_Copyhighwindgrid( SrcMiscData%Vamb_High(i1), DstMiscData%Vamb_High(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%xhat_plane)) THEN
  i1_l = LBOUND(SrcMiscData%xhat_plane,1)
  i1_u = UBOUND(SrcMiscData%xhat_plane,1)
  i2_l = LBOUND(SrcMiscData%xhat_plane,2)
  i2_u = UBOUND(SrcMiscData%xhat_plane,2)
  IF (.NOT. ALLOCATED(DstMiscData%xhat_plane)) THEN 
    ALLOCATE(DstMiscData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%xhat_plane = SrcMiscData%xhat_plane
ENDIF
IF (ALLOCATED(SrcMiscData%rhat_plane)) THEN
  i1_l = LBOUND(SrcMiscData%rhat_plane,1)
  i1_u = UBOUND(SrcMiscData%rhat_plane,1)
  i2_l = LBOUND(SrcMiscData%rhat_plane,2)
  i2_u = UBOUND(SrcMiscData%rhat_plane,2)
  IF (.NOT. ALLOCATED(DstMiscData%rhat_plane)) THEN 
    ALLOCATE(DstMiscData%rhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rhat_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%rhat_plane = SrcMiscData%rhat_plane
ENDIF
IF (ALLOCATED(SrcMiscData%parallelFlag)) THEN
  i1_l = LBOUND(SrcMiscData%parallelFlag,1)
  i1_u = UBOUND(SrcMiscData%parallelFlag,1)
  i2_l = LBOUND(SrcMiscData%parallelFlag,2)
  i2_u = UBOUND(SrcMiscData%parallelFlag,2)
  IF (.NOT. ALLOCATED(DstMiscData%parallelFlag)) THEN 
    ALLOCATE(DstMiscData%parallelFlag(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%parallelFlag.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%parallelFlag = SrcMiscData%parallelFlag
ENDIF
IF (ALLOCATED(SrcMiscData%r_s)) THEN
  i1_l = LBOUND(SrcMiscData%r_s,1)
  i1_u = UBOUND(SrcMiscData%r_s,1)
  i2_l = LBOUND(SrcMiscData%r_s,2)
  i2_u = UBOUND(SrcMiscData%r_s,2)
  IF (.NOT. ALLOCATED(DstMiscData%r_s)) THEN 
    ALLOCATE(DstMiscData%r_s(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_s.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%r_s = SrcMiscData%r_s
ENDIF
IF (ALLOCATED(SrcMiscData%r_e)) THEN
  i1_l = LBOUND(SrcMiscData%r_e,1)
  i1_u = UBOUND(SrcMiscData%r_e,1)
  i2_l = LBOUND(SrcMiscData%r_e,2)
  i2_u = UBOUND(SrcMiscData%r_e,2)
  IF (.NOT. ALLOCATED(DstMiscData%r_e)) THEN 
    ALLOCATE(DstMiscData%r_e(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_e.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%r_e = SrcMiscData%r_e
ENDIF
IF (ALLOCATED(SrcMiscData%rhat_s)) THEN
  i1_l = LBOUND(SrcMiscData%rhat_s,1)
  i1_u = UBOUND(SrcMiscData%rhat_s,1)
  i2_l = LBOUND(SrcMiscData%rhat_s,2)
  i2_u = UBOUND(SrcMiscData%rhat_s,2)
  i3_l = LBOUND(SrcMiscData%rhat_s,3)
  i3_u = UBOUND(SrcMiscData%rhat_s,3)
  IF (.NOT. ALLOCATED(DstMiscData%rhat_s)) THEN 
    ALLOCATE(DstMiscData%rhat_s(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rhat_s.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%rhat_s = SrcMiscData%rhat_s
ENDIF
IF (ALLOCATED(SrcMiscData%rhat_e)) THEN
  i1_l = LBOUND(SrcMiscData%rhat_e,1)
  i1_u = UBOUND(SrcMiscData%rhat_e,1)
  i2_l = LBOUND(SrcMiscData%rhat_e,2)
  i2_u = UBOUND(SrcMiscData%rhat_e,2)
  i3_l = LBOUND(SrcMiscData%rhat_e,3)
  i3_u = UBOUND(SrcMiscData%rhat_e,3)
  IF (.NOT. ALLOCATED(DstMiscData%rhat_e)) THEN 
    ALLOCATE(DstMiscData%rhat_e(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rhat_e.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%rhat_e = SrcMiscData%rhat_e
ENDIF
IF (ALLOCATED(SrcMiscData%pvec_cs)) THEN
  i1_l = LBOUND(SrcMiscData%pvec_cs,1)
  i1_u = UBOUND(SrcMiscData%pvec_cs,1)
  i2_l = LBOUND(SrcMiscData%pvec_cs,2)
  i2_u = UBOUND(SrcMiscData%pvec_cs,2)
  i3_l = LBOUND(SrcMiscData%pvec_cs,3)
  i3_u = UBOUND(SrcMiscData%pvec_cs,3)
  IF (.NOT. ALLOCATED(DstMiscData%pvec_cs)) THEN 
    ALLOCATE(DstMiscData%pvec_cs(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%pvec_cs.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%pvec_cs = SrcMiscData%pvec_cs
ENDIF
IF (ALLOCATED(SrcMiscData%pvec_ce)) THEN
  i1_l = LBOUND(SrcMiscData%pvec_ce,1)
  i1_u = UBOUND(SrcMiscData%pvec_ce,1)
  i2_l = LBOUND(SrcMiscData%pvec_ce,2)
  i2_u = UBOUND(SrcMiscData%pvec_ce,2)
  i3_l = LBOUND(SrcMiscData%pvec_ce,3)
  i3_u = UBOUND(SrcMiscData%pvec_ce,3)
  IF (.NOT. ALLOCATED(DstMiscData%pvec_ce)) THEN 
    ALLOCATE(DstMiscData%pvec_ce(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%pvec_ce.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%pvec_ce = SrcMiscData%pvec_ce
ENDIF
IF (ALLOCATED(SrcMiscData%Vx_wake)) THEN
  i1_l = LBOUND(SrcMiscData%Vx_wake,1)
  i1_u = UBOUND(SrcMiscData%Vx_wake,1)
  IF (.NOT. ALLOCATED(DstMiscData%Vx_wake)) THEN 
    ALLOCATE(DstMiscData%Vx_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vx_wake = SrcMiscData%Vx_wake
ENDIF
IF (ALLOCATED(SrcMiscData%Vr_wake)) THEN
  i1_l = LBOUND(SrcMiscData%Vr_wake,1)
  i1_u = UBOUND(SrcMiscData%Vr_wake,1)
  IF (.NOT. ALLOCATED(DstMiscData%Vr_wake)) THEN 
    ALLOCATE(DstMiscData%Vr_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Vr_wake = SrcMiscData%Vr_wake
ENDIF
IF (ALLOCATED(SrcMiscData%outVizXYPlane)) THEN
  i1_l = LBOUND(SrcMiscData%outVizXYPlane,1)
  i1_u = UBOUND(SrcMiscData%outVizXYPlane,1)
  i2_l = LBOUND(SrcMiscData%outVizXYPlane,2)
  i2_u = UBOUND(SrcMiscData%outVizXYPlane,2)
  i3_l = LBOUND(SrcMiscData%outVizXYPlane,3)
  i3_u = UBOUND(SrcMiscData%outVizXYPlane,3)
  i4_l = LBOUND(SrcMiscData%outVizXYPlane,4)
  i4_u = UBOUND(SrcMiscData%outVizXYPlane,4)
  IF (.NOT. ALLOCATED(DstMiscData%outVizXYPlane)) THEN 
    ALLOCATE(DstMiscData%outVizXYPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizXYPlane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%outVizXYPlane = SrcMiscData%outVizXYPlane
ENDIF
IF (ALLOCATED(SrcMiscData%outVizYZPlane)) THEN
  i1_l = LBOUND(SrcMiscData%outVizYZPlane,1)
  i1_u = UBOUND(SrcMiscData%outVizYZPlane,1)
  i2_l = LBOUND(SrcMiscData%outVizYZPlane,2)
  i2_u = UBOUND(SrcMiscData%outVizYZPlane,2)
  i3_l = LBOUND(SrcMiscData%outVizYZPlane,3)
  i3_u = UBOUND(SrcMiscData%outVizYZPlane,3)
  i4_l = LBOUND(SrcMiscData%outVizYZPlane,4)
  i4_u = UBOUND(SrcMiscData%outVizYZPlane,4)
  IF (.NOT. ALLOCATED(DstMiscData%outVizYZPlane)) THEN 
    ALLOCATE(DstMiscData%outVizYZPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizYZPlane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%outVizYZPlane = SrcMiscData%outVizYZPlane
ENDIF
IF (ALLOCATED(SrcMiscData%outVizXZPlane)) THEN
  i1_l = LBOUND(SrcMiscData%outVizXZPlane,1)
  i1_u = UBOUND(SrcMiscData%outVizXZPlane,1)
  i2_l = LBOUND(SrcMiscData%outVizXZPlane,2)
  i2_u = UBOUND(SrcMiscData%outVizXZPlane,2)
  i3_l = LBOUND(SrcMiscData%outVizXZPlane,3)
  i3_u = UBOUND(SrcMiscData%outVizXZPlane,3)
  i4_l = LBOUND(SrcMiscData%outVizXZPlane,4)
  i4_u = UBOUND(SrcMiscData%outVizXZPlane,4)
  IF (.NOT. ALLOCATED(DstMiscData%outVizXZPlane)) THEN 
    ALLOCATE(DstMiscData%outVizXZPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%outVizXZPlane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%outVizXZPlane = SrcMiscData%outVizXZPlane
ENDIF
IF (ALLOCATED(SrcMiscData%IfW)) THEN
  i1_l = LBOUND(SrcMiscData%IfW,1)
  i1_u = UBOUND(SrcMiscData%IfW,1)
  IF (.NOT. ALLOCATED(DstMiscData%IfW)) THEN 
    ALLOCATE(DstMiscData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%IfW,1), UBOUND(SrcMiscData%IfW,1)
      CALL InflowWind_CopyMisc( SrcMiscData%IfW(i1), DstMiscData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
      CALL InflowWind_CopyInput( SrcMiscData%u_IfW_Low, DstMiscData%u_IfW_Low, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL InflowWind_CopyInput( SrcMiscData%u_IfW_High, DstMiscData%u_IfW_High, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL InflowWind_CopyOutput( SrcMiscData%y_IfW_Low, DstMiscData%y_IfW_Low, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL InflowWind_CopyOutput( SrcMiscData%y_IfW_High, DstMiscData%y_IfW_High, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE AWAE_CopyMisc

 SUBROUTINE AWAE_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(AWAE_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%Vamb_low)) THEN
  DEALLOCATE(MiscData%Vamb_low)
ENDIF
IF (ALLOCATED(MiscData%Vamb_lowpol)) THEN
  DEALLOCATE(MiscData%Vamb_lowpol)
ENDIF
IF (ALLOCATED(MiscData%Vdist_low)) THEN
  DEALLOCATE(MiscData%Vdist_low)
ENDIF
IF (ALLOCATED(MiscData%Vamb_High)) THEN
DO i1 = LBOUND(MiscData%Vamb_High,1), UBOUND(MiscData%Vamb_High,1)
  CALL AWAE_Destroyhighwindgrid( MiscData%Vamb_High(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%Vamb_High)
ENDIF
IF (ALLOCATED(MiscData%xhat_plane)) THEN
  DEALLOCATE(MiscData%xhat_plane)
ENDIF
IF (ALLOCATED(MiscData%rhat_plane)) THEN
  DEALLOCATE(MiscData%rhat_plane)
ENDIF
IF (ALLOCATED(MiscData%parallelFlag)) THEN
  DEALLOCATE(MiscData%parallelFlag)
ENDIF
IF (ALLOCATED(MiscData%r_s)) THEN
  DEALLOCATE(MiscData%r_s)
ENDIF
IF (ALLOCATED(MiscData%r_e)) THEN
  DEALLOCATE(MiscData%r_e)
ENDIF
IF (ALLOCATED(MiscData%rhat_s)) THEN
  DEALLOCATE(MiscData%rhat_s)
ENDIF
IF (ALLOCATED(MiscData%rhat_e)) THEN
  DEALLOCATE(MiscData%rhat_e)
ENDIF
IF (ALLOCATED(MiscData%pvec_cs)) THEN
  DEALLOCATE(MiscData%pvec_cs)
ENDIF
IF (ALLOCATED(MiscData%pvec_ce)) THEN
  DEALLOCATE(MiscData%pvec_ce)
ENDIF
IF (ALLOCATED(MiscData%Vx_wake)) THEN
  DEALLOCATE(MiscData%Vx_wake)
ENDIF
IF (ALLOCATED(MiscData%Vr_wake)) THEN
  DEALLOCATE(MiscData%Vr_wake)
ENDIF
IF (ALLOCATED(MiscData%outVizXYPlane)) THEN
  DEALLOCATE(MiscData%outVizXYPlane)
ENDIF
IF (ALLOCATED(MiscData%outVizYZPlane)) THEN
  DEALLOCATE(MiscData%outVizYZPlane)
ENDIF
IF (ALLOCATED(MiscData%outVizXZPlane)) THEN
  DEALLOCATE(MiscData%outVizXZPlane)
ENDIF
IF (ALLOCATED(MiscData%IfW)) THEN
DO i1 = LBOUND(MiscData%IfW,1), UBOUND(MiscData%IfW,1)
  CALL InflowWind_DestroyMisc( MiscData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%IfW)
ENDIF
  CALL InflowWind_DestroyInput( MiscData%u_IfW_Low, ErrStat, ErrMsg )
  CALL InflowWind_DestroyInput( MiscData%u_IfW_High, ErrStat, ErrMsg )
  CALL InflowWind_DestroyOutput( MiscData%y_IfW_Low, ErrStat, ErrMsg )
  CALL InflowWind_DestroyOutput( MiscData%y_IfW_High, ErrStat, ErrMsg )
 END SUBROUTINE AWAE_DestroyMisc

 SUBROUTINE AWAE_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Vamb_low allocated yes/no
  IF ( ALLOCATED(InData%Vamb_low) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! Vamb_low upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vamb_low)  ! Vamb_low
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vamb_lowpol allocated yes/no
  IF ( ALLOCATED(InData%Vamb_lowpol) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vamb_lowpol upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vamb_lowpol)  ! Vamb_lowpol
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vdist_low allocated yes/no
  IF ( ALLOCATED(InData%Vdist_low) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! Vdist_low upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vdist_low)  ! Vdist_low
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vamb_High allocated yes/no
  IF ( ALLOCATED(InData%Vamb_High) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vamb_High upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%Vamb_High,1), UBOUND(InData%Vamb_High,1)
      Int_BufSz   = Int_BufSz + 3  ! Vamb_High: size of buffers for each call to pack subtype
      CALL AWAE_Packhighwindgrid( Re_Buf, Db_Buf, Int_Buf, InData%Vamb_High(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Vamb_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Vamb_High
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Vamb_High
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Vamb_High
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! xhat_plane allocated yes/no
  IF ( ALLOCATED(InData%xhat_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! xhat_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%xhat_plane)  ! xhat_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rhat_plane allocated yes/no
  IF ( ALLOCATED(InData%rhat_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rhat_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rhat_plane)  ! rhat_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! parallelFlag allocated yes/no
  IF ( ALLOCATED(InData%parallelFlag) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! parallelFlag upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%parallelFlag)  ! parallelFlag
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_s allocated yes/no
  IF ( ALLOCATED(InData%r_s) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! r_s upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_s)  ! r_s
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_e allocated yes/no
  IF ( ALLOCATED(InData%r_e) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! r_e upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_e)  ! r_e
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rhat_s allocated yes/no
  IF ( ALLOCATED(InData%rhat_s) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rhat_s upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rhat_s)  ! rhat_s
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rhat_e allocated yes/no
  IF ( ALLOCATED(InData%rhat_e) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rhat_e upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rhat_e)  ! rhat_e
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pvec_cs allocated yes/no
  IF ( ALLOCATED(InData%pvec_cs) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! pvec_cs upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pvec_cs)  ! pvec_cs
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! pvec_ce allocated yes/no
  IF ( ALLOCATED(InData%pvec_ce) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! pvec_ce upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%pvec_ce)  ! pvec_ce
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wake allocated yes/no
  IF ( ALLOCATED(InData%Vx_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vx_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wake)  ! Vx_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vr_wake allocated yes/no
  IF ( ALLOCATED(InData%Vr_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vr_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vr_wake)  ! Vr_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! outVizXYPlane allocated yes/no
  IF ( ALLOCATED(InData%outVizXYPlane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! outVizXYPlane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%outVizXYPlane)  ! outVizXYPlane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! outVizYZPlane allocated yes/no
  IF ( ALLOCATED(InData%outVizYZPlane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! outVizYZPlane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%outVizYZPlane)  ! outVizYZPlane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! outVizXZPlane allocated yes/no
  IF ( ALLOCATED(InData%outVizXZPlane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! outVizXZPlane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%outVizXZPlane)  ! outVizXZPlane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz   = Int_BufSz + 3  ! u_IfW_Low: size of buffers for each call to pack subtype
      CALL InflowWind_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_IfW_Low, ErrStat2, ErrMsg2, .TRUE. ) ! u_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! u_IfW_Low
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! u_IfW_Low
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! u_IfW_Low
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! u_IfW_High: size of buffers for each call to pack subtype
      CALL InflowWind_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_IfW_High, ErrStat2, ErrMsg2, .TRUE. ) ! u_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! u_IfW_High
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! u_IfW_High
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! u_IfW_High
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! y_IfW_Low: size of buffers for each call to pack subtype
      CALL InflowWind_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_IfW_Low, ErrStat2, ErrMsg2, .TRUE. ) ! y_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! y_IfW_Low
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! y_IfW_Low
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! y_IfW_Low
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! y_IfW_High: size of buffers for each call to pack subtype
      CALL InflowWind_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_IfW_High, ErrStat2, ErrMsg2, .TRUE. ) ! y_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! y_IfW_High
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! y_IfW_High
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! y_IfW_High
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Vamb_low) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_low,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_low,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_low,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_low,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_low,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_low,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_low,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_low,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%Vamb_low,4), UBOUND(InData%Vamb_low,4)
        DO i3 = LBOUND(InData%Vamb_low,3), UBOUND(InData%Vamb_low,3)
          DO i2 = LBOUND(InData%Vamb_low,2), UBOUND(InData%Vamb_low,2)
            DO i1 = LBOUND(InData%Vamb_low,1), UBOUND(InData%Vamb_low,1)
              ReKiBuf(Re_Xferred) = InData%Vamb_low(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vamb_lowpol) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_lowpol,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_lowpol,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_lowpol,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_lowpol,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vamb_lowpol,2), UBOUND(InData%Vamb_lowpol,2)
        DO i1 = LBOUND(InData%Vamb_lowpol,1), UBOUND(InData%Vamb_lowpol,1)
          ReKiBuf(Re_Xferred) = InData%Vamb_lowpol(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vdist_low) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vdist_low,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vdist_low,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vdist_low,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vdist_low,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vdist_low,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vdist_low,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vdist_low,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vdist_low,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%Vdist_low,4), UBOUND(InData%Vdist_low,4)
        DO i3 = LBOUND(InData%Vdist_low,3), UBOUND(InData%Vdist_low,3)
          DO i2 = LBOUND(InData%Vdist_low,2), UBOUND(InData%Vdist_low,2)
            DO i1 = LBOUND(InData%Vdist_low,1), UBOUND(InData%Vdist_low,1)
              ReKiBuf(Re_Xferred) = InData%Vdist_low(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vamb_High) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vamb_High,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vamb_High,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Vamb_High,1), UBOUND(InData%Vamb_High,1)
      CALL AWAE_Packhighwindgrid( Re_Buf, Db_Buf, Int_Buf, InData%Vamb_High(i1), ErrStat2, ErrMsg2, OnlySize ) ! Vamb_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%xhat_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%xhat_plane,2), UBOUND(InData%xhat_plane,2)
        DO i1 = LBOUND(InData%xhat_plane,1), UBOUND(InData%xhat_plane,1)
          ReKiBuf(Re_Xferred) = InData%xhat_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rhat_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_plane,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rhat_plane,2), UBOUND(InData%rhat_plane,2)
        DO i1 = LBOUND(InData%rhat_plane,1), UBOUND(InData%rhat_plane,1)
          ReKiBuf(Re_Xferred) = InData%rhat_plane(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%parallelFlag) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%parallelFlag,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%parallelFlag,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%parallelFlag,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%parallelFlag,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%parallelFlag,2), UBOUND(InData%parallelFlag,2)
        DO i1 = LBOUND(InData%parallelFlag,1), UBOUND(InData%parallelFlag,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%parallelFlag(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_s) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_s,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_s,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_s,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_s,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%r_s,2), UBOUND(InData%r_s,2)
        DO i1 = LBOUND(InData%r_s,1), UBOUND(InData%r_s,1)
          ReKiBuf(Re_Xferred) = InData%r_s(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_e) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_e,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_e,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_e,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_e,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%r_e,2), UBOUND(InData%r_e,2)
        DO i1 = LBOUND(InData%r_e,1), UBOUND(InData%r_e,1)
          ReKiBuf(Re_Xferred) = InData%r_e(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rhat_s) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_s,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_s,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_s,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_s,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_s,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_s,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rhat_s,3), UBOUND(InData%rhat_s,3)
        DO i2 = LBOUND(InData%rhat_s,2), UBOUND(InData%rhat_s,2)
          DO i1 = LBOUND(InData%rhat_s,1), UBOUND(InData%rhat_s,1)
            ReKiBuf(Re_Xferred) = InData%rhat_s(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rhat_e) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_e,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_e,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_e,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_e,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rhat_e,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rhat_e,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rhat_e,3), UBOUND(InData%rhat_e,3)
        DO i2 = LBOUND(InData%rhat_e,2), UBOUND(InData%rhat_e,2)
          DO i1 = LBOUND(InData%rhat_e,1), UBOUND(InData%rhat_e,1)
            ReKiBuf(Re_Xferred) = InData%rhat_e(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%pvec_cs) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_cs,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_cs,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_cs,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_cs,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_cs,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_cs,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%pvec_cs,3), UBOUND(InData%pvec_cs,3)
        DO i2 = LBOUND(InData%pvec_cs,2), UBOUND(InData%pvec_cs,2)
          DO i1 = LBOUND(InData%pvec_cs,1), UBOUND(InData%pvec_cs,1)
            ReKiBuf(Re_Xferred) = InData%pvec_cs(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%pvec_ce) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_ce,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_ce,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_ce,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_ce,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%pvec_ce,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%pvec_ce,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%pvec_ce,3), UBOUND(InData%pvec_ce,3)
        DO i2 = LBOUND(InData%pvec_ce,2), UBOUND(InData%pvec_ce,2)
          DO i1 = LBOUND(InData%pvec_ce,1), UBOUND(InData%pvec_ce,1)
            ReKiBuf(Re_Xferred) = InData%pvec_ce(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vx_wake,1), UBOUND(InData%Vx_wake,1)
        ReKiBuf(Re_Xferred) = InData%Vx_wake(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vr_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vr_wake,1), UBOUND(InData%Vr_wake,1)
        ReKiBuf(Re_Xferred) = InData%Vr_wake(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%outVizXYPlane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXYPlane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXYPlane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXYPlane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXYPlane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXYPlane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXYPlane,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXYPlane,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXYPlane,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%outVizXYPlane,4), UBOUND(InData%outVizXYPlane,4)
        DO i3 = LBOUND(InData%outVizXYPlane,3), UBOUND(InData%outVizXYPlane,3)
          DO i2 = LBOUND(InData%outVizXYPlane,2), UBOUND(InData%outVizXYPlane,2)
            DO i1 = LBOUND(InData%outVizXYPlane,1), UBOUND(InData%outVizXYPlane,1)
              ReKiBuf(Re_Xferred) = InData%outVizXYPlane(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%outVizYZPlane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizYZPlane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizYZPlane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizYZPlane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizYZPlane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizYZPlane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizYZPlane,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizYZPlane,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizYZPlane,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%outVizYZPlane,4), UBOUND(InData%outVizYZPlane,4)
        DO i3 = LBOUND(InData%outVizYZPlane,3), UBOUND(InData%outVizYZPlane,3)
          DO i2 = LBOUND(InData%outVizYZPlane,2), UBOUND(InData%outVizYZPlane,2)
            DO i1 = LBOUND(InData%outVizYZPlane,1), UBOUND(InData%outVizYZPlane,1)
              ReKiBuf(Re_Xferred) = InData%outVizYZPlane(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%outVizXZPlane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXZPlane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXZPlane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXZPlane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXZPlane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXZPlane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXZPlane,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%outVizXZPlane,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%outVizXZPlane,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%outVizXZPlane,4), UBOUND(InData%outVizXZPlane,4)
        DO i3 = LBOUND(InData%outVizXZPlane,3), UBOUND(InData%outVizXZPlane,3)
          DO i2 = LBOUND(InData%outVizXZPlane,2), UBOUND(InData%outVizXZPlane,2)
            DO i1 = LBOUND(InData%outVizXZPlane,1), UBOUND(InData%outVizXZPlane,1)
              ReKiBuf(Re_Xferred) = InData%outVizXZPlane(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
      CALL InflowWind_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_IfW_Low, ErrStat2, ErrMsg2, OnlySize ) ! u_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL InflowWind_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_IfW_High, ErrStat2, ErrMsg2, OnlySize ) ! u_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL InflowWind_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_IfW_Low, ErrStat2, ErrMsg2, OnlySize ) ! y_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL InflowWind_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_IfW_High, ErrStat2, ErrMsg2, OnlySize ) ! y_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE AWAE_PackMisc

 SUBROUTINE AWAE_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vamb_low not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vamb_low)) DEALLOCATE(OutData%Vamb_low)
    ALLOCATE(OutData%Vamb_low(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vamb_low.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%Vamb_low,4), UBOUND(OutData%Vamb_low,4)
        DO i3 = LBOUND(OutData%Vamb_low,3), UBOUND(OutData%Vamb_low,3)
          DO i2 = LBOUND(OutData%Vamb_low,2), UBOUND(OutData%Vamb_low,2)
            DO i1 = LBOUND(OutData%Vamb_low,1), UBOUND(OutData%Vamb_low,1)
              OutData%Vamb_low(i1,i2,i3,i4) = REAL(ReKiBuf(Re_Xferred), SiKi)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vamb_lowpol not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vamb_lowpol)) DEALLOCATE(OutData%Vamb_lowpol)
    ALLOCATE(OutData%Vamb_lowpol(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vamb_lowpol.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vamb_lowpol,2), UBOUND(OutData%Vamb_lowpol,2)
        DO i1 = LBOUND(OutData%Vamb_lowpol,1), UBOUND(OutData%Vamb_lowpol,1)
          OutData%Vamb_lowpol(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vdist_low not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vdist_low)) DEALLOCATE(OutData%Vdist_low)
    ALLOCATE(OutData%Vdist_low(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vdist_low.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%Vdist_low,4), UBOUND(OutData%Vdist_low,4)
        DO i3 = LBOUND(OutData%Vdist_low,3), UBOUND(OutData%Vdist_low,3)
          DO i2 = LBOUND(OutData%Vdist_low,2), UBOUND(OutData%Vdist_low,2)
            DO i1 = LBOUND(OutData%Vdist_low,1), UBOUND(OutData%Vdist_low,1)
              OutData%Vdist_low(i1,i2,i3,i4) = REAL(ReKiBuf(Re_Xferred), SiKi)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vamb_High not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vamb_High)) DEALLOCATE(OutData%Vamb_High)
    ALLOCATE(OutData%Vamb_High(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vamb_High.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Vamb_High,1), UBOUND(OutData%Vamb_High,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AWAE_Unpackhighwindgrid( Re_Buf, Db_Buf, Int_Buf, OutData%Vamb_High(i1), ErrStat2, ErrMsg2 ) ! Vamb_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xhat_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%xhat_plane)) DEALLOCATE(OutData%xhat_plane)
    ALLOCATE(OutData%xhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%xhat_plane,2), UBOUND(OutData%xhat_plane,2)
        DO i1 = LBOUND(OutData%xhat_plane,1), UBOUND(OutData%xhat_plane,1)
          OutData%xhat_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rhat_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rhat_plane)) DEALLOCATE(OutData%rhat_plane)
    ALLOCATE(OutData%rhat_plane(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rhat_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rhat_plane,2), UBOUND(OutData%rhat_plane,2)
        DO i1 = LBOUND(OutData%rhat_plane,1), UBOUND(OutData%rhat_plane,1)
          OutData%rhat_plane(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! parallelFlag not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%parallelFlag)) DEALLOCATE(OutData%parallelFlag)
    ALLOCATE(OutData%parallelFlag(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%parallelFlag.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%parallelFlag,2), UBOUND(OutData%parallelFlag,2)
        DO i1 = LBOUND(OutData%parallelFlag,1), UBOUND(OutData%parallelFlag,1)
          OutData%parallelFlag(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%parallelFlag(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_s not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_s)) DEALLOCATE(OutData%r_s)
    ALLOCATE(OutData%r_s(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_s.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%r_s,2), UBOUND(OutData%r_s,2)
        DO i1 = LBOUND(OutData%r_s,1), UBOUND(OutData%r_s,1)
          OutData%r_s(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_e not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_e)) DEALLOCATE(OutData%r_e)
    ALLOCATE(OutData%r_e(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_e.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%r_e,2), UBOUND(OutData%r_e,2)
        DO i1 = LBOUND(OutData%r_e,1), UBOUND(OutData%r_e,1)
          OutData%r_e(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rhat_s not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rhat_s)) DEALLOCATE(OutData%rhat_s)
    ALLOCATE(OutData%rhat_s(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rhat_s.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rhat_s,3), UBOUND(OutData%rhat_s,3)
        DO i2 = LBOUND(OutData%rhat_s,2), UBOUND(OutData%rhat_s,2)
          DO i1 = LBOUND(OutData%rhat_s,1), UBOUND(OutData%rhat_s,1)
            OutData%rhat_s(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rhat_e not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rhat_e)) DEALLOCATE(OutData%rhat_e)
    ALLOCATE(OutData%rhat_e(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rhat_e.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rhat_e,3), UBOUND(OutData%rhat_e,3)
        DO i2 = LBOUND(OutData%rhat_e,2), UBOUND(OutData%rhat_e,2)
          DO i1 = LBOUND(OutData%rhat_e,1), UBOUND(OutData%rhat_e,1)
            OutData%rhat_e(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pvec_cs not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%pvec_cs)) DEALLOCATE(OutData%pvec_cs)
    ALLOCATE(OutData%pvec_cs(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pvec_cs.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%pvec_cs,3), UBOUND(OutData%pvec_cs,3)
        DO i2 = LBOUND(OutData%pvec_cs,2), UBOUND(OutData%pvec_cs,2)
          DO i1 = LBOUND(OutData%pvec_cs,1), UBOUND(OutData%pvec_cs,1)
            OutData%pvec_cs(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! pvec_ce not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%pvec_ce)) DEALLOCATE(OutData%pvec_ce)
    ALLOCATE(OutData%pvec_ce(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%pvec_ce.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%pvec_ce,3), UBOUND(OutData%pvec_ce,3)
        DO i2 = LBOUND(OutData%pvec_ce,2), UBOUND(OutData%pvec_ce,2)
          DO i1 = LBOUND(OutData%pvec_ce,1), UBOUND(OutData%pvec_ce,1)
            OutData%pvec_ce(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wake)) DEALLOCATE(OutData%Vx_wake)
    ALLOCATE(OutData%Vx_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vx_wake,1), UBOUND(OutData%Vx_wake,1)
        OutData%Vx_wake(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vr_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vr_wake)) DEALLOCATE(OutData%Vr_wake)
    ALLOCATE(OutData%Vr_wake(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vr_wake,1), UBOUND(OutData%Vr_wake,1)
        OutData%Vr_wake(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! outVizXYPlane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%outVizXYPlane)) DEALLOCATE(OutData%outVizXYPlane)
    ALLOCATE(OutData%outVizXYPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%outVizXYPlane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%outVizXYPlane,4), UBOUND(OutData%outVizXYPlane,4)
        DO i3 = LBOUND(OutData%outVizXYPlane,3), UBOUND(OutData%outVizXYPlane,3)
          DO i2 = LBOUND(OutData%outVizXYPlane,2), UBOUND(OutData%outVizXYPlane,2)
            DO i1 = LBOUND(OutData%outVizXYPlane,1), UBOUND(OutData%outVizXYPlane,1)
              OutData%outVizXYPlane(i1,i2,i3,i4) = REAL(ReKiBuf(Re_Xferred), SiKi)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! outVizYZPlane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%outVizYZPlane)) DEALLOCATE(OutData%outVizYZPlane)
    ALLOCATE(OutData%outVizYZPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%outVizYZPlane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%outVizYZPlane,4), UBOUND(OutData%outVizYZPlane,4)
        DO i3 = LBOUND(OutData%outVizYZPlane,3), UBOUND(OutData%outVizYZPlane,3)
          DO i2 = LBOUND(OutData%outVizYZPlane,2), UBOUND(OutData%outVizYZPlane,2)
            DO i1 = LBOUND(OutData%outVizYZPlane,1), UBOUND(OutData%outVizYZPlane,1)
              OutData%outVizYZPlane(i1,i2,i3,i4) = REAL(ReKiBuf(Re_Xferred), SiKi)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! outVizXZPlane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%outVizXZPlane)) DEALLOCATE(OutData%outVizXZPlane)
    ALLOCATE(OutData%outVizXZPlane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%outVizXZPlane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%outVizXZPlane,4), UBOUND(OutData%outVizXZPlane,4)
        DO i3 = LBOUND(OutData%outVizXZPlane,3), UBOUND(OutData%outVizXZPlane,3)
          DO i2 = LBOUND(OutData%outVizXZPlane,2), UBOUND(OutData%outVizXZPlane,2)
            DO i1 = LBOUND(OutData%outVizXZPlane,1), UBOUND(OutData%outVizXZPlane,1)
              OutData%outVizXZPlane(i1,i2,i3,i4) = REAL(ReKiBuf(Re_Xferred), SiKi)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackMisc( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackInput( Re_Buf, Db_Buf, Int_Buf, OutData%u_IfW_Low, ErrStat2, ErrMsg2 ) ! u_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackInput( Re_Buf, Db_Buf, Int_Buf, OutData%u_IfW_High, ErrStat2, ErrMsg2 ) ! u_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackOutput( Re_Buf, Db_Buf, Int_Buf, OutData%y_IfW_Low, ErrStat2, ErrMsg2 ) ! y_IfW_Low 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackOutput( Re_Buf, Db_Buf, Int_Buf, OutData%y_IfW_High, ErrStat2, ErrMsg2 ) ! y_IfW_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE AWAE_UnPackMisc

 SUBROUTINE AWAE_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(AWAE_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%WindFilePath = SrcParamData%WindFilePath
    DstParamData%NumTurbines = SrcParamData%NumTurbines
    DstParamData%NumRadii = SrcParamData%NumRadii
    DstParamData%NumPlanes = SrcParamData%NumPlanes
IF (ALLOCATED(SrcParamData%r)) THEN
  i1_l = LBOUND(SrcParamData%r,1)
  i1_u = UBOUND(SrcParamData%r,1)
  IF (.NOT. ALLOCATED(DstParamData%r)) THEN 
    ALLOCATE(DstParamData%r(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%r.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%r = SrcParamData%r
ENDIF
    DstParamData%Mod_AmbWind = SrcParamData%Mod_AmbWind
    DstParamData%nX_low = SrcParamData%nX_low
    DstParamData%nY_low = SrcParamData%nY_low
    DstParamData%nZ_low = SrcParamData%nZ_low
    DstParamData%NumGrid_low = SrcParamData%NumGrid_low
    DstParamData%n_rp_max = SrcParamData%n_rp_max
    DstParamData%dpol = SrcParamData%dpol
    DstParamData%dXYZ_low = SrcParamData%dXYZ_low
    DstParamData%dX_low = SrcParamData%dX_low
    DstParamData%dY_low = SrcParamData%dY_low
    DstParamData%dZ_low = SrcParamData%dZ_low
    DstParamData%X0_low = SrcParamData%X0_low
    DstParamData%Y0_low = SrcParamData%Y0_low
    DstParamData%Z0_low = SrcParamData%Z0_low
IF (ALLOCATED(SrcParamData%X0_high)) THEN
  i1_l = LBOUND(SrcParamData%X0_high,1)
  i1_u = UBOUND(SrcParamData%X0_high,1)
  IF (.NOT. ALLOCATED(DstParamData%X0_high)) THEN 
    ALLOCATE(DstParamData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%X0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%X0_high = SrcParamData%X0_high
ENDIF
IF (ALLOCATED(SrcParamData%Y0_high)) THEN
  i1_l = LBOUND(SrcParamData%Y0_high,1)
  i1_u = UBOUND(SrcParamData%Y0_high,1)
  IF (.NOT. ALLOCATED(DstParamData%Y0_high)) THEN 
    ALLOCATE(DstParamData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Y0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Y0_high = SrcParamData%Y0_high
ENDIF
IF (ALLOCATED(SrcParamData%Z0_high)) THEN
  i1_l = LBOUND(SrcParamData%Z0_high,1)
  i1_u = UBOUND(SrcParamData%Z0_high,1)
  IF (.NOT. ALLOCATED(DstParamData%Z0_high)) THEN 
    ALLOCATE(DstParamData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Z0_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Z0_high = SrcParamData%Z0_high
ENDIF
IF (ALLOCATED(SrcParamData%dX_high)) THEN
  i1_l = LBOUND(SrcParamData%dX_high,1)
  i1_u = UBOUND(SrcParamData%dX_high,1)
  IF (.NOT. ALLOCATED(DstParamData%dX_high)) THEN 
    ALLOCATE(DstParamData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dX_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dX_high = SrcParamData%dX_high
ENDIF
IF (ALLOCATED(SrcParamData%dY_high)) THEN
  i1_l = LBOUND(SrcParamData%dY_high,1)
  i1_u = UBOUND(SrcParamData%dY_high,1)
  IF (.NOT. ALLOCATED(DstParamData%dY_high)) THEN 
    ALLOCATE(DstParamData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dY_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dY_high = SrcParamData%dY_high
ENDIF
IF (ALLOCATED(SrcParamData%dZ_high)) THEN
  i1_l = LBOUND(SrcParamData%dZ_high,1)
  i1_u = UBOUND(SrcParamData%dZ_high,1)
  IF (.NOT. ALLOCATED(DstParamData%dZ_high)) THEN 
    ALLOCATE(DstParamData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dZ_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dZ_high = SrcParamData%dZ_high
ENDIF
    DstParamData%nX_high = SrcParamData%nX_high
    DstParamData%nY_high = SrcParamData%nY_high
    DstParamData%nZ_high = SrcParamData%nZ_high
IF (ALLOCATED(SrcParamData%Grid_low)) THEN
  i1_l = LBOUND(SrcParamData%Grid_low,1)
  i1_u = UBOUND(SrcParamData%Grid_low,1)
  i2_l = LBOUND(SrcParamData%Grid_low,2)
  i2_u = UBOUND(SrcParamData%Grid_low,2)
  IF (.NOT. ALLOCATED(DstParamData%Grid_low)) THEN 
    ALLOCATE(DstParamData%Grid_low(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Grid_low.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Grid_low = SrcParamData%Grid_low
ENDIF
IF (ALLOCATED(SrcParamData%Grid_high)) THEN
  i1_l = LBOUND(SrcParamData%Grid_high,1)
  i1_u = UBOUND(SrcParamData%Grid_high,1)
  i2_l = LBOUND(SrcParamData%Grid_high,2)
  i2_u = UBOUND(SrcParamData%Grid_high,2)
  i3_l = LBOUND(SrcParamData%Grid_high,3)
  i3_u = UBOUND(SrcParamData%Grid_high,3)
  IF (.NOT. ALLOCATED(DstParamData%Grid_high)) THEN 
    ALLOCATE(DstParamData%Grid_high(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Grid_high.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Grid_high = SrcParamData%Grid_high
ENDIF
IF (ALLOCATED(SrcParamData%WT_Position)) THEN
  i1_l = LBOUND(SrcParamData%WT_Position,1)
  i1_u = UBOUND(SrcParamData%WT_Position,1)
  i2_l = LBOUND(SrcParamData%WT_Position,2)
  i2_u = UBOUND(SrcParamData%WT_Position,2)
  IF (.NOT. ALLOCATED(DstParamData%WT_Position)) THEN 
    ALLOCATE(DstParamData%WT_Position(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WT_Position.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%WT_Position = SrcParamData%WT_Position
ENDIF
    DstParamData%n_high_low = SrcParamData%n_high_low
    DstParamData%dt_low = SrcParamData%dt_low
    DstParamData%dt_high = SrcParamData%dt_high
    DstParamData%NumDT = SrcParamData%NumDT
    DstParamData%Mod_Meander = SrcParamData%Mod_Meander
    DstParamData%C_Meander = SrcParamData%C_Meander
    DstParamData%C_ScaleDiam = SrcParamData%C_ScaleDiam
IF (ALLOCATED(SrcParamData%IfW)) THEN
  i1_l = LBOUND(SrcParamData%IfW,1)
  i1_u = UBOUND(SrcParamData%IfW,1)
  IF (.NOT. ALLOCATED(DstParamData%IfW)) THEN 
    ALLOCATE(DstParamData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IfW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%IfW,1), UBOUND(SrcParamData%IfW,1)
      CALL InflowWind_CopyParam( SrcParamData%IfW(i1), DstParamData%IfW(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstParamData%WrDisSkp1 = SrcParamData%WrDisSkp1
    DstParamData%WrDisWind = SrcParamData%WrDisWind
    DstParamData%NOutDisWindXY = SrcParamData%NOutDisWindXY
IF (ALLOCATED(SrcParamData%OutDisWindZ)) THEN
  i1_l = LBOUND(SrcParamData%OutDisWindZ,1)
  i1_u = UBOUND(SrcParamData%OutDisWindZ,1)
  IF (.NOT. ALLOCATED(DstParamData%OutDisWindZ)) THEN 
    ALLOCATE(DstParamData%OutDisWindZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindZ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%OutDisWindZ = SrcParamData%OutDisWindZ
ENDIF
    DstParamData%NOutDisWindYZ = SrcParamData%NOutDisWindYZ
IF (ALLOCATED(SrcParamData%OutDisWindX)) THEN
  i1_l = LBOUND(SrcParamData%OutDisWindX,1)
  i1_u = UBOUND(SrcParamData%OutDisWindX,1)
  IF (.NOT. ALLOCATED(DstParamData%OutDisWindX)) THEN 
    ALLOCATE(DstParamData%OutDisWindX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%OutDisWindX = SrcParamData%OutDisWindX
ENDIF
    DstParamData%NOutDisWindXZ = SrcParamData%NOutDisWindXZ
IF (ALLOCATED(SrcParamData%OutDisWindY)) THEN
  i1_l = LBOUND(SrcParamData%OutDisWindY,1)
  i1_u = UBOUND(SrcParamData%OutDisWindY,1)
  IF (.NOT. ALLOCATED(DstParamData%OutDisWindY)) THEN 
    ALLOCATE(DstParamData%OutDisWindY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDisWindY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%OutDisWindY = SrcParamData%OutDisWindY
ENDIF
    DstParamData%OutFileRoot = SrcParamData%OutFileRoot
    DstParamData%OutFileVTKRoot = SrcParamData%OutFileVTKRoot
    DstParamData%VTK_tWidth = SrcParamData%VTK_tWidth
 END SUBROUTINE AWAE_CopyParam

 SUBROUTINE AWAE_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(AWAE_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%r)) THEN
  DEALLOCATE(ParamData%r)
ENDIF
IF (ALLOCATED(ParamData%X0_high)) THEN
  DEALLOCATE(ParamData%X0_high)
ENDIF
IF (ALLOCATED(ParamData%Y0_high)) THEN
  DEALLOCATE(ParamData%Y0_high)
ENDIF
IF (ALLOCATED(ParamData%Z0_high)) THEN
  DEALLOCATE(ParamData%Z0_high)
ENDIF
IF (ALLOCATED(ParamData%dX_high)) THEN
  DEALLOCATE(ParamData%dX_high)
ENDIF
IF (ALLOCATED(ParamData%dY_high)) THEN
  DEALLOCATE(ParamData%dY_high)
ENDIF
IF (ALLOCATED(ParamData%dZ_high)) THEN
  DEALLOCATE(ParamData%dZ_high)
ENDIF
IF (ALLOCATED(ParamData%Grid_low)) THEN
  DEALLOCATE(ParamData%Grid_low)
ENDIF
IF (ALLOCATED(ParamData%Grid_high)) THEN
  DEALLOCATE(ParamData%Grid_high)
ENDIF
IF (ALLOCATED(ParamData%WT_Position)) THEN
  DEALLOCATE(ParamData%WT_Position)
ENDIF
IF (ALLOCATED(ParamData%IfW)) THEN
DO i1 = LBOUND(ParamData%IfW,1), UBOUND(ParamData%IfW,1)
  CALL InflowWind_DestroyParam( ParamData%IfW(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%IfW)
ENDIF
IF (ALLOCATED(ParamData%OutDisWindZ)) THEN
  DEALLOCATE(ParamData%OutDisWindZ)
ENDIF
IF (ALLOCATED(ParamData%OutDisWindX)) THEN
  DEALLOCATE(ParamData%OutDisWindX)
ENDIF
IF (ALLOCATED(ParamData%OutDisWindY)) THEN
  DEALLOCATE(ParamData%OutDisWindY)
ENDIF
 END SUBROUTINE AWAE_DestroyParam

 SUBROUTINE AWAE_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%WindFilePath)  ! WindFilePath
      Int_BufSz  = Int_BufSz  + 1  ! NumTurbines
      Int_BufSz  = Int_BufSz  + 1  ! NumRadii
      Int_BufSz  = Int_BufSz  + 1  ! NumPlanes
  Int_BufSz   = Int_BufSz   + 1     ! r allocated yes/no
  IF ( ALLOCATED(InData%r) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! r upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r)  ! r
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! Mod_AmbWind
      Int_BufSz  = Int_BufSz  + 1  ! nX_low
      Int_BufSz  = Int_BufSz  + 1  ! nY_low
      Int_BufSz  = Int_BufSz  + 1  ! nZ_low
      Int_BufSz  = Int_BufSz  + 1  ! NumGrid_low
      Int_BufSz  = Int_BufSz  + 1  ! n_rp_max
      Re_BufSz   = Re_BufSz   + 1  ! dpol
      Re_BufSz   = Re_BufSz   + SIZE(InData%dXYZ_low)  ! dXYZ_low
      Re_BufSz   = Re_BufSz   + 1  ! dX_low
      Re_BufSz   = Re_BufSz   + 1  ! dY_low
      Re_BufSz   = Re_BufSz   + 1  ! dZ_low
      Re_BufSz   = Re_BufSz   + 1  ! X0_low
      Re_BufSz   = Re_BufSz   + 1  ! Y0_low
      Re_BufSz   = Re_BufSz   + 1  ! Z0_low
  Int_BufSz   = Int_BufSz   + 1     ! X0_high allocated yes/no
  IF ( ALLOCATED(InData%X0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! X0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X0_high)  ! X0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Y0_high allocated yes/no
  IF ( ALLOCATED(InData%Y0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Y0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Y0_high)  ! Y0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Z0_high allocated yes/no
  IF ( ALLOCATED(InData%Z0_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Z0_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Z0_high)  ! Z0_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dX_high allocated yes/no
  IF ( ALLOCATED(InData%dX_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dX_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dX_high)  ! dX_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dY_high allocated yes/no
  IF ( ALLOCATED(InData%dY_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dY_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dY_high)  ! dY_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dZ_high allocated yes/no
  IF ( ALLOCATED(InData%dZ_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dZ_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dZ_high)  ! dZ_high
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! nX_high
      Int_BufSz  = Int_BufSz  + 1  ! nY_high
      Int_BufSz  = Int_BufSz  + 1  ! nZ_high
  Int_BufSz   = Int_BufSz   + 1     ! Grid_low allocated yes/no
  IF ( ALLOCATED(InData%Grid_low) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Grid_low upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Grid_low)  ! Grid_low
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Grid_high allocated yes/no
  IF ( ALLOCATED(InData%Grid_high) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Grid_high upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Grid_high)  ! Grid_high
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WT_Position allocated yes/no
  IF ( ALLOCATED(InData%WT_Position) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! WT_Position upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WT_Position)  ! WT_Position
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! n_high_low
      Db_BufSz   = Db_BufSz   + 1  ! dt_low
      Db_BufSz   = Db_BufSz   + 1  ! dt_high
      Int_BufSz  = Int_BufSz  + 1  ! NumDT
      Int_BufSz  = Int_BufSz  + 1  ! Mod_Meander
      Re_BufSz   = Re_BufSz   + 1  ! C_Meander
      Re_BufSz   = Re_BufSz   + 1  ! C_ScaleDiam
  Int_BufSz   = Int_BufSz   + 1     ! IfW allocated yes/no
  IF ( ALLOCATED(InData%IfW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! IfW upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      Int_BufSz   = Int_BufSz + 3  ! IfW: size of buffers for each call to pack subtype
      CALL InflowWind_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, .TRUE. ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! IfW
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! IfW
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! IfW
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! WrDisSkp1
      Int_BufSz  = Int_BufSz  + 1  ! WrDisWind
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindXY
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindZ allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindZ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindZ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindZ)  ! OutDisWindZ
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindYZ
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindX allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindX)  ! OutDisWindX
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NOutDisWindXZ
  Int_BufSz   = Int_BufSz   + 1     ! OutDisWindY allocated yes/no
  IF ( ALLOCATED(InData%OutDisWindY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutDisWindY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutDisWindY)  ! OutDisWindY
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFileRoot)  ! OutFileRoot
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFileVTKRoot)  ! OutFileVTKRoot
      Int_BufSz  = Int_BufSz  + 1  ! VTK_tWidth
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%WindFilePath)
      IntKiBuf(Int_Xferred) = ICHAR(InData%WindFilePath(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NumTurbines
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumRadii
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumPlanes
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%r) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%r,1), UBOUND(InData%r,1)
        ReKiBuf(Re_Xferred) = InData%r(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%Mod_AmbWind
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nX_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumGrid_low
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%n_rp_max
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dpol
    Re_Xferred = Re_Xferred + 1
    DO i1 = LBOUND(InData%dXYZ_low,1), UBOUND(InData%dXYZ_low,1)
      ReKiBuf(Re_Xferred) = InData%dXYZ_low(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    ReKiBuf(Re_Xferred) = InData%dX_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dY_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dZ_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Y0_low
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Z0_low
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%X0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%X0_high,1), UBOUND(InData%X0_high,1)
        ReKiBuf(Re_Xferred) = InData%X0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Y0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Y0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Y0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Y0_high,1), UBOUND(InData%Y0_high,1)
        ReKiBuf(Re_Xferred) = InData%Y0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Z0_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Z0_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Z0_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Z0_high,1), UBOUND(InData%Z0_high,1)
        ReKiBuf(Re_Xferred) = InData%Z0_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dX_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dX_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dX_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dX_high,1), UBOUND(InData%dX_high,1)
        ReKiBuf(Re_Xferred) = InData%dX_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dY_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dY_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dY_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dY_high,1), UBOUND(InData%dY_high,1)
        ReKiBuf(Re_Xferred) = InData%dY_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dZ_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dZ_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dZ_high,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dZ_high,1), UBOUND(InData%dZ_high,1)
        ReKiBuf(Re_Xferred) = InData%dZ_high(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%nX_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nY_high
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nZ_high
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Grid_low) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Grid_low,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Grid_low,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Grid_low,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Grid_low,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Grid_low,2), UBOUND(InData%Grid_low,2)
        DO i1 = LBOUND(InData%Grid_low,1), UBOUND(InData%Grid_low,1)
          ReKiBuf(Re_Xferred) = InData%Grid_low(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Grid_high) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Grid_high,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Grid_high,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Grid_high,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Grid_high,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Grid_high,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Grid_high,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Grid_high,3), UBOUND(InData%Grid_high,3)
        DO i2 = LBOUND(InData%Grid_high,2), UBOUND(InData%Grid_high,2)
          DO i1 = LBOUND(InData%Grid_high,1), UBOUND(InData%Grid_high,1)
            ReKiBuf(Re_Xferred) = InData%Grid_high(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WT_Position) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WT_Position,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WT_Position,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WT_Position,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WT_Position,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%WT_Position,2), UBOUND(InData%WT_Position,2)
        DO i1 = LBOUND(InData%WT_Position,1), UBOUND(InData%WT_Position,1)
          ReKiBuf(Re_Xferred) = InData%WT_Position(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%n_high_low
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%dt_low
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%dt_high
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumDT
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%Mod_Meander
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_Meander
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_ScaleDiam
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%IfW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%IfW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%IfW,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%IfW,1), UBOUND(InData%IfW,1)
      CALL InflowWind_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%IfW(i1), ErrStat2, ErrMsg2, OnlySize ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%WrDisSkp1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%WrDisWind, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NOutDisWindXY
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindZ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindZ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindZ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindZ,1), UBOUND(InData%OutDisWindZ,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindZ(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NOutDisWindYZ
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindX,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindX,1), UBOUND(InData%OutDisWindX,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindX(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NOutDisWindXZ
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%OutDisWindY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutDisWindY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutDisWindY,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%OutDisWindY,1), UBOUND(InData%OutDisWindY,1)
        ReKiBuf(Re_Xferred) = InData%OutDisWindY(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(InData%OutFileRoot)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFileRoot(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%OutFileVTKRoot)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFileVTKRoot(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%VTK_tWidth
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE AWAE_PackParam

 SUBROUTINE AWAE_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%WindFilePath)
      OutData%WindFilePath(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NumTurbines = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumRadii = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumPlanes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r)) DEALLOCATE(OutData%r)
    ALLOCATE(OutData%r(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%r,1), UBOUND(OutData%r,1)
        OutData%r(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Mod_AmbWind = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nX_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumGrid_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%n_rp_max = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dpol = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    i1_l = LBOUND(OutData%dXYZ_low,1)
    i1_u = UBOUND(OutData%dXYZ_low,1)
    DO i1 = LBOUND(OutData%dXYZ_low,1), UBOUND(OutData%dXYZ_low,1)
      OutData%dXYZ_low(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%dX_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dY_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dZ_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%X0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Y0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Z0_low = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X0_high)) DEALLOCATE(OutData%X0_high)
    ALLOCATE(OutData%X0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%X0_high,1), UBOUND(OutData%X0_high,1)
        OutData%X0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Y0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Y0_high)) DEALLOCATE(OutData%Y0_high)
    ALLOCATE(OutData%Y0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Y0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Y0_high,1), UBOUND(OutData%Y0_high,1)
        OutData%Y0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Z0_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Z0_high)) DEALLOCATE(OutData%Z0_high)
    ALLOCATE(OutData%Z0_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Z0_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Z0_high,1), UBOUND(OutData%Z0_high,1)
        OutData%Z0_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dX_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dX_high)) DEALLOCATE(OutData%dX_high)
    ALLOCATE(OutData%dX_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dX_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dX_high,1), UBOUND(OutData%dX_high,1)
        OutData%dX_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dY_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dY_high)) DEALLOCATE(OutData%dY_high)
    ALLOCATE(OutData%dY_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dY_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dY_high,1), UBOUND(OutData%dY_high,1)
        OutData%dY_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dZ_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dZ_high)) DEALLOCATE(OutData%dZ_high)
    ALLOCATE(OutData%dZ_high(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dZ_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dZ_high,1), UBOUND(OutData%dZ_high,1)
        OutData%dZ_high(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%nX_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nY_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nZ_high = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Grid_low not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Grid_low)) DEALLOCATE(OutData%Grid_low)
    ALLOCATE(OutData%Grid_low(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Grid_low.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Grid_low,2), UBOUND(OutData%Grid_low,2)
        DO i1 = LBOUND(OutData%Grid_low,1), UBOUND(OutData%Grid_low,1)
          OutData%Grid_low(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Grid_high not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Grid_high)) DEALLOCATE(OutData%Grid_high)
    ALLOCATE(OutData%Grid_high(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Grid_high.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Grid_high,3), UBOUND(OutData%Grid_high,3)
        DO i2 = LBOUND(OutData%Grid_high,2), UBOUND(OutData%Grid_high,2)
          DO i1 = LBOUND(OutData%Grid_high,1), UBOUND(OutData%Grid_high,1)
            OutData%Grid_high(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WT_Position not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WT_Position)) DEALLOCATE(OutData%WT_Position)
    ALLOCATE(OutData%WT_Position(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WT_Position.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%WT_Position,2), UBOUND(OutData%WT_Position,2)
        DO i1 = LBOUND(OutData%WT_Position,1), UBOUND(OutData%WT_Position,1)
          OutData%WT_Position(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%n_high_low = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%dt_low = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%dt_high = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%NumDT = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Mod_Meander = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%C_Meander = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_ScaleDiam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! IfW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%IfW)) DEALLOCATE(OutData%IfW)
    ALLOCATE(OutData%IfW(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%IfW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%IfW,1), UBOUND(OutData%IfW,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL InflowWind_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%IfW(i1), ErrStat2, ErrMsg2 ) ! IfW 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%WrDisSkp1 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WrDisWind = TRANSFER(IntKiBuf(Int_Xferred), OutData%WrDisWind)
    Int_Xferred = Int_Xferred + 1
    OutData%NOutDisWindXY = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindZ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindZ)) DEALLOCATE(OutData%OutDisWindZ)
    ALLOCATE(OutData%OutDisWindZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindZ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindZ,1), UBOUND(OutData%OutDisWindZ,1)
        OutData%OutDisWindZ(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%NOutDisWindYZ = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindX)) DEALLOCATE(OutData%OutDisWindX)
    ALLOCATE(OutData%OutDisWindX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindX,1), UBOUND(OutData%OutDisWindX,1)
        OutData%OutDisWindX(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%NOutDisWindXZ = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutDisWindY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutDisWindY)) DEALLOCATE(OutData%OutDisWindY)
    ALLOCATE(OutData%OutDisWindY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutDisWindY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%OutDisWindY,1), UBOUND(OutData%OutDisWindY,1)
        OutData%OutDisWindY(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(OutData%OutFileRoot)
      OutData%OutFileRoot(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%OutFileVTKRoot)
      OutData%OutFileVTKRoot(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%VTK_tWidth = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE AWAE_UnPackParam

 SUBROUTINE AWAE_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(AWAE_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%Vdist_High)) THEN
  i1_l = LBOUND(SrcOutputData%Vdist_High,1)
  i1_u = UBOUND(SrcOutputData%Vdist_High,1)
  IF (.NOT. ALLOCATED(DstOutputData%Vdist_High)) THEN 
    ALLOCATE(DstOutputData%Vdist_High(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vdist_High.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcOutputData%Vdist_High,1), UBOUND(SrcOutputData%Vdist_High,1)
      CALL AWAE_Copyhighwindgrid( SrcOutputData%Vdist_High(i1), DstOutputData%Vdist_High(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcOutputData%V_plane)) THEN
  i1_l = LBOUND(SrcOutputData%V_plane,1)
  i1_u = UBOUND(SrcOutputData%V_plane,1)
  i2_l = LBOUND(SrcOutputData%V_plane,2)
  i2_u = UBOUND(SrcOutputData%V_plane,2)
  i3_l = LBOUND(SrcOutputData%V_plane,3)
  i3_u = UBOUND(SrcOutputData%V_plane,3)
  IF (.NOT. ALLOCATED(DstOutputData%V_plane)) THEN 
    ALLOCATE(DstOutputData%V_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%V_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%V_plane = SrcOutputData%V_plane
ENDIF
IF (ALLOCATED(SrcOutputData%TI_amb)) THEN
  i1_l = LBOUND(SrcOutputData%TI_amb,1)
  i1_u = UBOUND(SrcOutputData%TI_amb,1)
  IF (.NOT. ALLOCATED(DstOutputData%TI_amb)) THEN 
    ALLOCATE(DstOutputData%TI_amb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%TI_amb.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%TI_amb = SrcOutputData%TI_amb
ENDIF
IF (ALLOCATED(SrcOutputData%Vx_wind_disk)) THEN
  i1_l = LBOUND(SrcOutputData%Vx_wind_disk,1)
  i1_u = UBOUND(SrcOutputData%Vx_wind_disk,1)
  IF (.NOT. ALLOCATED(DstOutputData%Vx_wind_disk)) THEN 
    ALLOCATE(DstOutputData%Vx_wind_disk(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vx_wind_disk.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Vx_wind_disk = SrcOutputData%Vx_wind_disk
ENDIF
 END SUBROUTINE AWAE_CopyOutput

 SUBROUTINE AWAE_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(AWAE_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%Vdist_High)) THEN
DO i1 = LBOUND(OutputData%Vdist_High,1), UBOUND(OutputData%Vdist_High,1)
  CALL AWAE_Destroyhighwindgrid( OutputData%Vdist_High(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(OutputData%Vdist_High)
ENDIF
IF (ALLOCATED(OutputData%V_plane)) THEN
  DEALLOCATE(OutputData%V_plane)
ENDIF
IF (ALLOCATED(OutputData%TI_amb)) THEN
  DEALLOCATE(OutputData%TI_amb)
ENDIF
IF (ALLOCATED(OutputData%Vx_wind_disk)) THEN
  DEALLOCATE(OutputData%Vx_wind_disk)
ENDIF
 END SUBROUTINE AWAE_DestroyOutput

 SUBROUTINE AWAE_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Vdist_High allocated yes/no
  IF ( ALLOCATED(InData%Vdist_High) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vdist_High upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%Vdist_High,1), UBOUND(InData%Vdist_High,1)
      Int_BufSz   = Int_BufSz + 3  ! Vdist_High: size of buffers for each call to pack subtype
      CALL AWAE_Packhighwindgrid( Re_Buf, Db_Buf, Int_Buf, InData%Vdist_High(i1), ErrStat2, ErrMsg2, .TRUE. ) ! Vdist_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Vdist_High
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Vdist_High
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Vdist_High
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! V_plane allocated yes/no
  IF ( ALLOCATED(InData%V_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! V_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%V_plane)  ! V_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TI_amb allocated yes/no
  IF ( ALLOCATED(InData%TI_amb) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! TI_amb upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TI_amb)  ! TI_amb
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wind_disk allocated yes/no
  IF ( ALLOCATED(InData%Vx_wind_disk) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vx_wind_disk upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wind_disk)  ! Vx_wind_disk
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Vdist_High) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vdist_High,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vdist_High,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%Vdist_High,1), UBOUND(InData%Vdist_High,1)
      CALL AWAE_Packhighwindgrid( Re_Buf, Db_Buf, Int_Buf, InData%Vdist_High(i1), ErrStat2, ErrMsg2, OnlySize ) ! Vdist_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%V_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_plane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_plane,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%V_plane,3), UBOUND(InData%V_plane,3)
        DO i2 = LBOUND(InData%V_plane,2), UBOUND(InData%V_plane,2)
          DO i1 = LBOUND(InData%V_plane,1), UBOUND(InData%V_plane,1)
            ReKiBuf(Re_Xferred) = InData%V_plane(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TI_amb) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_amb,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_amb,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%TI_amb,1), UBOUND(InData%TI_amb,1)
        ReKiBuf(Re_Xferred) = InData%TI_amb(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wind_disk) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wind_disk,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wind_disk,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vx_wind_disk,1), UBOUND(InData%Vx_wind_disk,1)
        ReKiBuf(Re_Xferred) = InData%Vx_wind_disk(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE AWAE_PackOutput

 SUBROUTINE AWAE_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vdist_High not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vdist_High)) DEALLOCATE(OutData%Vdist_High)
    ALLOCATE(OutData%Vdist_High(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vdist_High.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%Vdist_High,1), UBOUND(OutData%Vdist_High,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AWAE_Unpackhighwindgrid( Re_Buf, Db_Buf, Int_Buf, OutData%Vdist_High(i1), ErrStat2, ErrMsg2 ) ! Vdist_High 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%V_plane)) DEALLOCATE(OutData%V_plane)
    ALLOCATE(OutData%V_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%V_plane,3), UBOUND(OutData%V_plane,3)
        DO i2 = LBOUND(OutData%V_plane,2), UBOUND(OutData%V_plane,2)
          DO i1 = LBOUND(OutData%V_plane,1), UBOUND(OutData%V_plane,1)
            OutData%V_plane(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TI_amb not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TI_amb)) DEALLOCATE(OutData%TI_amb)
    ALLOCATE(OutData%TI_amb(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TI_amb.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%TI_amb,1), UBOUND(OutData%TI_amb,1)
        OutData%TI_amb(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wind_disk not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wind_disk)) DEALLOCATE(OutData%Vx_wind_disk)
    ALLOCATE(OutData%Vx_wind_disk(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wind_disk.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vx_wind_disk,1), UBOUND(OutData%Vx_wind_disk,1)
        OutData%Vx_wind_disk(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE AWAE_UnPackOutput

 SUBROUTINE AWAE_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AWAE_InputType), INTENT(IN) :: SrcInputData
   TYPE(AWAE_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInputData%xhat_plane)) THEN
  i1_l = LBOUND(SrcInputData%xhat_plane,1)
  i1_u = UBOUND(SrcInputData%xhat_plane,1)
  i2_l = LBOUND(SrcInputData%xhat_plane,2)
  i2_u = UBOUND(SrcInputData%xhat_plane,2)
  i3_l = LBOUND(SrcInputData%xhat_plane,3)
  i3_u = UBOUND(SrcInputData%xhat_plane,3)
  IF (.NOT. ALLOCATED(DstInputData%xhat_plane)) THEN 
    ALLOCATE(DstInputData%xhat_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%xhat_plane = SrcInputData%xhat_plane
ENDIF
IF (ALLOCATED(SrcInputData%p_plane)) THEN
  i1_l = LBOUND(SrcInputData%p_plane,1)
  i1_u = UBOUND(SrcInputData%p_plane,1)
  i2_l = LBOUND(SrcInputData%p_plane,2)
  i2_u = UBOUND(SrcInputData%p_plane,2)
  i3_l = LBOUND(SrcInputData%p_plane,3)
  i3_u = UBOUND(SrcInputData%p_plane,3)
  IF (.NOT. ALLOCATED(DstInputData%p_plane)) THEN 
    ALLOCATE(DstInputData%p_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%p_plane.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%p_plane = SrcInputData%p_plane
ENDIF
IF (ALLOCATED(SrcInputData%Vx_wake)) THEN
  i1_l = LBOUND(SrcInputData%Vx_wake,1)
  i1_u = UBOUND(SrcInputData%Vx_wake,1)
  i2_l = LBOUND(SrcInputData%Vx_wake,2)
  i2_u = UBOUND(SrcInputData%Vx_wake,2)
  i3_l = LBOUND(SrcInputData%Vx_wake,3)
  i3_u = UBOUND(SrcInputData%Vx_wake,3)
  IF (.NOT. ALLOCATED(DstInputData%Vx_wake)) THEN 
    ALLOCATE(DstInputData%Vx_wake(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vx_wake = SrcInputData%Vx_wake
ENDIF
IF (ALLOCATED(SrcInputData%Vr_wake)) THEN
  i1_l = LBOUND(SrcInputData%Vr_wake,1)
  i1_u = UBOUND(SrcInputData%Vr_wake,1)
  i2_l = LBOUND(SrcInputData%Vr_wake,2)
  i2_u = UBOUND(SrcInputData%Vr_wake,2)
  i3_l = LBOUND(SrcInputData%Vr_wake,3)
  i3_u = UBOUND(SrcInputData%Vr_wake,3)
  IF (.NOT. ALLOCATED(DstInputData%Vr_wake)) THEN 
    ALLOCATE(DstInputData%Vr_wake(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vr_wake = SrcInputData%Vr_wake
ENDIF
IF (ALLOCATED(SrcInputData%D_wake)) THEN
  i1_l = LBOUND(SrcInputData%D_wake,1)
  i1_u = UBOUND(SrcInputData%D_wake,1)
  i2_l = LBOUND(SrcInputData%D_wake,2)
  i2_u = UBOUND(SrcInputData%D_wake,2)
  IF (.NOT. ALLOCATED(DstInputData%D_wake)) THEN 
    ALLOCATE(DstInputData%D_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%D_wake.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%D_wake = SrcInputData%D_wake
ENDIF
 END SUBROUTINE AWAE_CopyInput

 SUBROUTINE AWAE_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(AWAE_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AWAE_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%xhat_plane)) THEN
  DEALLOCATE(InputData%xhat_plane)
ENDIF
IF (ALLOCATED(InputData%p_plane)) THEN
  DEALLOCATE(InputData%p_plane)
ENDIF
IF (ALLOCATED(InputData%Vx_wake)) THEN
  DEALLOCATE(InputData%Vx_wake)
ENDIF
IF (ALLOCATED(InputData%Vr_wake)) THEN
  DEALLOCATE(InputData%Vr_wake)
ENDIF
IF (ALLOCATED(InputData%D_wake)) THEN
  DEALLOCATE(InputData%D_wake)
ENDIF
 END SUBROUTINE AWAE_DestroyInput

 SUBROUTINE AWAE_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AWAE_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! xhat_plane allocated yes/no
  IF ( ALLOCATED(InData%xhat_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! xhat_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%xhat_plane)  ! xhat_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! p_plane allocated yes/no
  IF ( ALLOCATED(InData%p_plane) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! p_plane upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%p_plane)  ! p_plane
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_wake allocated yes/no
  IF ( ALLOCATED(InData%Vx_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vx_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_wake)  ! Vx_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vr_wake allocated yes/no
  IF ( ALLOCATED(InData%Vr_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vr_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vr_wake)  ! Vr_wake
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! D_wake allocated yes/no
  IF ( ALLOCATED(InData%D_wake) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! D_wake upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%D_wake)  ! D_wake
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%xhat_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%xhat_plane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%xhat_plane,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%xhat_plane,3), UBOUND(InData%xhat_plane,3)
        DO i2 = LBOUND(InData%xhat_plane,2), UBOUND(InData%xhat_plane,2)
          DO i1 = LBOUND(InData%xhat_plane,1), UBOUND(InData%xhat_plane,1)
            ReKiBuf(Re_Xferred) = InData%xhat_plane(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%p_plane) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%p_plane,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%p_plane,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%p_plane,3), UBOUND(InData%p_plane,3)
        DO i2 = LBOUND(InData%p_plane,2), UBOUND(InData%p_plane,2)
          DO i1 = LBOUND(InData%p_plane,1), UBOUND(InData%p_plane,1)
            ReKiBuf(Re_Xferred) = InData%p_plane(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_wake,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_wake,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vx_wake,3), UBOUND(InData%Vx_wake,3)
        DO i2 = LBOUND(InData%Vx_wake,2), UBOUND(InData%Vx_wake,2)
          DO i1 = LBOUND(InData%Vx_wake,1), UBOUND(InData%Vx_wake,1)
            ReKiBuf(Re_Xferred) = InData%Vx_wake(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vr_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vr_wake,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vr_wake,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vr_wake,3), UBOUND(InData%Vr_wake,3)
        DO i2 = LBOUND(InData%Vr_wake,2), UBOUND(InData%Vr_wake,2)
          DO i1 = LBOUND(InData%Vr_wake,1), UBOUND(InData%Vr_wake,1)
            ReKiBuf(Re_Xferred) = InData%Vr_wake(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%D_wake) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%D_wake,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%D_wake,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%D_wake,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%D_wake,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%D_wake,2), UBOUND(InData%D_wake,2)
        DO i1 = LBOUND(InData%D_wake,1), UBOUND(InData%D_wake,1)
          ReKiBuf(Re_Xferred) = InData%D_wake(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_PackInput

 SUBROUTINE AWAE_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AWAE_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AWAE_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! xhat_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%xhat_plane)) DEALLOCATE(OutData%xhat_plane)
    ALLOCATE(OutData%xhat_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%xhat_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%xhat_plane,3), UBOUND(OutData%xhat_plane,3)
        DO i2 = LBOUND(OutData%xhat_plane,2), UBOUND(OutData%xhat_plane,2)
          DO i1 = LBOUND(OutData%xhat_plane,1), UBOUND(OutData%xhat_plane,1)
            OutData%xhat_plane(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! p_plane not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%p_plane)) DEALLOCATE(OutData%p_plane)
    ALLOCATE(OutData%p_plane(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%p_plane.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%p_plane,3), UBOUND(OutData%p_plane,3)
        DO i2 = LBOUND(OutData%p_plane,2), UBOUND(OutData%p_plane,2)
          DO i1 = LBOUND(OutData%p_plane,1), UBOUND(OutData%p_plane,1)
            OutData%p_plane(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_wake)) DEALLOCATE(OutData%Vx_wake)
    ALLOCATE(OutData%Vx_wake(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vx_wake,3), UBOUND(OutData%Vx_wake,3)
        DO i2 = LBOUND(OutData%Vx_wake,2), UBOUND(OutData%Vx_wake,2)
          DO i1 = LBOUND(OutData%Vx_wake,1), UBOUND(OutData%Vx_wake,1)
            OutData%Vx_wake(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vr_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vr_wake)) DEALLOCATE(OutData%Vr_wake)
    ALLOCATE(OutData%Vr_wake(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vr_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vr_wake,3), UBOUND(OutData%Vr_wake,3)
        DO i2 = LBOUND(OutData%Vr_wake,2), UBOUND(OutData%Vr_wake,2)
          DO i1 = LBOUND(OutData%Vr_wake,1), UBOUND(OutData%Vr_wake,1)
            OutData%Vr_wake(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! D_wake not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%D_wake)) DEALLOCATE(OutData%D_wake)
    ALLOCATE(OutData%D_wake(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%D_wake.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%D_wake,2), UBOUND(OutData%D_wake,2)
        DO i1 = LBOUND(OutData%D_wake,1), UBOUND(OutData%D_wake,1)
          OutData%D_wake(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AWAE_UnPackInput

END MODULE AWAE_Types
!ENDOFREGISTRYGENERATEDFILE
