!STARTOFREGISTRYGENERATEDFILE 'UnsteadyAero_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! UnsteadyAero_Types
!.................................................................................................................................
! This file is part of UnsteadyAero.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in UnsteadyAero. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE UnsteadyAero_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Baseline = 1      ! UAMod = 1 [Baseline model (Original)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Gonzalez = 2      ! UAMod = 2 [Gonzalez's variant (changes in Cn,Cc,Cm)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_MinnemaPierce = 3      ! [Minnema/Pierce variant (changes in Cc and Cm)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_HGM = 4      ! [continuous variant of HGM (Hansen) model] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_HGMV = 5      ! [continuous variant of HGM (Hansen) model with vortex modifications] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Oye = 6      ! Stieg Oye dynamic stall model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_BV = 7      ! Boeing-Vertol dynamic stall model (e.g. used in CACTUS) [-]
! =========  UA_InitInputType  =======
  TYPE, PUBLIC :: UA_InitInputType
    REAL(DbKi)  :: dt      !< time step [s]
    CHARACTER(1024)  :: OutRootName      !< Supplied by Driver:  The name of the root file (without extension) including the full path [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: c      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades      !< Number nodes of all blades [-]
    INTEGER(IntKi)  :: nNodesPerBlade      !< Number nodes per blades [-]
    INTEGER(IntKi)  :: UAMod      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    REAL(ReKi)  :: a_s      !< speed of sound [m/s]
    LOGICAL  :: Flookup      !< Use table lookup for f' and f''  [-]
    LOGICAL  :: ShedEffect = .True.      !< Include the effect of shed vorticity. If False, the input alpha is assumed to already contain this effect (e.g. vortex methods) [-]
    LOGICAL  :: WrSum = .false.      !< Write UA AFI parameters to summary file? [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_innerNode      !< Last node on each blade where UA should be turned off based on span location from blade root (0 if always on) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_outerNode      !< First node on each blade where UA should be turned off based on span location from blade tip (>nNodesPerBlade if always on) [-]
  END TYPE UA_InitInputType
! =======================
! =========  UA_InitOutputType  =======
  TYPE, PUBLIC :: UA_InitOutputType
    TYPE(ProgDesc)  :: Version      !< Version structure [-]
    CHARACTER(19) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< The is the list of all UA-related output channel header strings (includes all sub-module channels) [-]
    CHARACTER(19) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< The is the list of all UA-related output channel unit strings (includes all sub-module channels) [-]
  END TYPE UA_InitOutputType
! =======================
! =========  UA_KelvinChainType  =======
  TYPE, PUBLIC :: UA_KelvinChainType
    REAL(ReKi)  :: Cn_prime      !<  [-]
    REAL(ReKi)  :: C_nalpha_circ      !< slope of the circulatory normal force coefficient vs alpha curve [-]
    REAL(ReKi)  :: Kalpha_f      !< filtered  backwards finite difference of alpha (xd%Kalpha_f_minus1) [-]
    REAL(ReKi)  :: Kq_f      !< filtered  backwards finite difference of q [-]
    REAL(ReKi)  :: alpha_filt_cur      !< filtered angle of attack [-]
    REAL(ReKi)  :: alpha_e      !< effective angle of attack at 3/4 chord  TODO: verify 3/4 and not 1/4 [-]
    REAL(ReKi)  :: dalpha0      !<  [-]
    REAL(ReKi)  :: alpha_f      !<  [-]
    REAL(ReKi)  :: Kq      !<  [-]
    REAL(ReKi)  :: q_cur      !<  [-]
    REAL(ReKi)  :: q_f_cur      !<  [-]
    REAL(ReKi)  :: X1      !<  [-]
    REAL(ReKi)  :: X2      !<  [-]
    REAL(ReKi)  :: X3      !<  [-]
    REAL(ReKi)  :: X4      !<  [-]
    REAL(ReKi)  :: Kprime_alpha      !<  [-]
    REAL(ReKi)  :: Kprime_q      !<  [-]
    REAL(ReKi)  :: K3prime_q      !<  [-]
    REAL(ReKi)  :: Kprimeprime_q      !<  [-]
    REAL(ReKi)  :: Dp      !<  [-]
    REAL(ReKi)  :: Cn_pot      !<  [-]
    REAL(ReKi)  :: Cc_pot      !<  [-]
    REAL(ReKi)  :: Cn_alpha_q_circ      !<  [-]
    REAL(ReKi)  :: Cn_alpha_q_nc      !< non-circulatory component of normal force coefficient response to step change in alpha and q [-]
    REAL(ReKi)  :: Cm_q_circ      !<  [-]
    REAL(ReKi)  :: Cn_alpha_nc      !< non-circulatory component of the normal force coefficient response to step change in alpha [-]
    REAL(ReKi)  :: Cn_q_circ      !<  [-]
    REAL(ReKi)  :: Cn_q_nc      !<  [-]
    REAL(ReKi)  :: Cm_q_nc      !< non-circulatory component of the moment coefficient response to step change in q [-]
    REAL(ReKi)  :: fprimeprime      !<  [-]
    REAL(ReKi)  :: Df      !<  [-]
    REAL(ReKi)  :: Df_c      !<  [-]
    REAL(ReKi)  :: Df_m      !<  [-]
    REAL(ReKi)  :: Dalphaf      !<  [-]
    REAL(ReKi)  :: fprime      !<  [-]
    REAL(ReKi)  :: fprime_c      !<  [-]
    REAL(ReKi)  :: fprimeprime_c      !<  [-]
    REAL(ReKi)  :: fprime_m      !<  [-]
    REAL(ReKi)  :: fprimeprime_m      !<  [-]
    REAL(ReKi)  :: Cn_v      !< normal force coefficient due to the presence of LE vortex [-]
    REAL(ReKi)  :: C_V      !< contribution to the normal force coefficient due to accumulated vorticity in the LE vortex [-]
    REAL(ReKi)  :: Cn_FS      !<  [-]
    REAL(ReKi)  :: T_f      !<  [-]
    REAL(ReKi)  :: T_fc      !<  [-]
    REAL(ReKi)  :: T_fm      !<  [-]
    REAL(ReKi)  :: T_V      !< backwards finite difference of the non-dimensionalized distance parameter [-]
    REAL(ReKi)  :: k_alpha      !<  [-]
    REAL(ReKi)  :: k_q      !<  [-]
    REAL(ReKi)  :: T_alpha      !<  [-]
    REAL(ReKi)  :: T_q      !<  [-]
    REAL(ReKi)  :: ds      !< non-dimensionalized distance parameter [-]
  END TYPE UA_KelvinChainType
! =======================
! =========  UA_ElementContinuousStateType  =======
  TYPE, PUBLIC :: UA_ElementContinuousStateType
    REAL(R8Ki) , DIMENSION(1:5)  :: x      !< continuous states when UA_Mod=4 (x1 and x2:Downwash memory terms; x3:Clp', Lift coefficient with a time lag to the attached lift coeff; x4: f'' , Final separation point function) [{rad, rad, - -}]
  END TYPE UA_ElementContinuousStateType
! =======================
! =========  UA_ContinuousStateType  =======
  TYPE, PUBLIC :: UA_ContinuousStateType
    TYPE(UA_ElementContinuousStateType) , DIMENSION(:,:), ALLOCATABLE  :: element      !< continuous states when UA_Mod=4 for each blade/node [-]
  END TYPE UA_ContinuousStateType
! =======================
! =========  UA_DiscreteStateType  =======
  TYPE, PUBLIC :: UA_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_minus1      !< angle of attack, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_filt_minus1      !< filtered angle of attack, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_dot      !< Rate of change of angle of attack (filtered) [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alpha_dot_minus1      !< Rate of change of angle of attack (filtered) [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: q_minus1      !< non-dimensional pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kalpha_f_minus1      !< filtered pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kq_f_minus1      !< filtered pitching acceleration, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: q_f_minus1      !< filtered non-dimensional pitching rate, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X1_minus1      !< deficiency function used in the development of Cn_alpha_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X2_minus1      !< deficiency function used in the development of Cn_alpha_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X3_minus1      !< deficiency function used in the development of Cn_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X4_minus1      !< deficiency function used in the development of Cn_q_circ, previous time step [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprime_alpha_minus1      !< deficiency function used in the development of Cn_alpha_nc, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprime_q_minus1      !< deficiency function used in the development of Cn_q_nc, previous time step [rad/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Kprimeprime_q_minus1      !< deficiency function used in the development of Cm_q_nc, previous time step [rad/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: K3prime_q_minus1      !< deficiency function used in the development of Cm_q_circ, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Dp_minus1      !< deficiency function used in the development of Cm_q_circ, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_pot_minus1      !< deficiency function used in the development of Cn_prime [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_minus1      !< lagged version of fprime, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_c_minus1      !< lagged version of fprime_c, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprimeprime_m_minus1      !< lagged version of fprime_m, accounting for unsteady boundary layer response, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_c_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Df_m_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Dalphaf_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: alphaf_minus1      !< deficiency function used in the development of fprime, previous time step [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_minus1      !< separation point Cn distance from leading edge, expressed in cord fraction, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_c_minus1      !< separation point Ct distance from leading edge, expressed in cord fraction, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: fprime_m_minus1      !< Distance application of Cn with respect to Cm, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tau_V      !< time variable, tracking the travel of the LE vortex over the airfoil suction surface [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tau_V_minus1      !< time variable, tracking the travel of the LE vortex over the airfoil suction surface [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_v_minus1      !< normal force coefficient due to the presence of LE vortex, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: C_V_minus1      !< contribution to the normal force coefficient due to accumulated vorticity in the LE vortex, previous time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cn_prime_minus1      !< difference between Cn_prime and Cn_prime_minus1, previous time step [rad]
  END TYPE UA_DiscreteStateType
! =======================
! =========  UA_ConstraintStateType  =======
  TYPE, PUBLIC :: UA_ConstraintStateType
    REAL(ReKi)  :: DummyConstraintState      !<  [-]
  END TYPE UA_ConstraintStateType
! =======================
! =========  UA_OtherStateType  =======
  TYPE, PUBLIC :: UA_OtherStateType
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: FirstPass      !< logical flag indicating if this is the first time step [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1      !< multiplier for T_fn [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1c      !< multiplier for T_fc [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma1m      !< multiplier for T_fm [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: sigma3      !< multiplier for T_V [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: n      !< counter for continuous state integration [-]
    TYPE(UA_ContinuousStateType) , DIMENSION(1:4)  :: xdot      !< history states for continuous state integration [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: t_vortexBegin      !< HGMV model: simulation time when vortex lift term became active [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: SignOfOmega      !< HGMV model: sign of omega when vortex lift term became active  [s]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: PositivePressure      !< HGMV model: logical flag indicating if the vortex lift became active because of positive pressure (or negative) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: vortexOn      !< HGMV model: logical flag indicating if the vortex lift term is active [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: BelowThreshold      !< HGMV model: logical flag indicating if cn fell below threshold to form another vortex [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: activeL      !< BV model: logical flag indicating if the lift stall is active [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: activeD      !< BV model: logical flag indicating if the drag stall is active [-]
  END TYPE UA_OtherStateType
! =======================
! =========  UA_MiscVarType  =======
  TYPE, PUBLIC :: UA_MiscVarType
    LOGICAL  :: FirstWarn_M      !< flag so Mach number warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_UA      !< flag so UA state warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_UA_off      !< flag so UA state warning doesn't get repeated forever [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: TESF      !< logical flag indicating if trailing edge separation is possible [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: LESF      !< logical flag indicating if leading edge separation is possible [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: VRTX      !< logical flag indicating if a vortex is being processed [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: T_Sh      !< shedding frequency [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: BEDSEP      !< logical flag indicating if this is undergoing separated flow (for compison with AD14) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: weight      !< value between 0 and 1 indicating if UA is on (1) or off (0) or somewhere in between [-]
  END TYPE UA_MiscVarType
! =======================
! =========  UA_ParameterType  =======
  TYPE, PUBLIC :: UA_ParameterType
    REAL(DbKi)  :: dt      !< time step [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: c      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades      !< Number nodes of all blades [-]
    INTEGER(IntKi)  :: nNodesPerBlade      !< Number nodes per blades [-]
    INTEGER(IntKi)  :: UAMod      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    LOGICAL  :: Flookup      !< Use table lookup for f' and f''  [-]
    REAL(ReKi)  :: a_s      !< speed of sound [m/s]
    INTEGER(IntKi)  :: NumOuts = 0      !< Number of outputs [-]
    INTEGER(IntKi)  :: OutSwtch      !< Output requested channels to: [1=Unsteady.out 2=GlueCode.out  3=both files] [-]
    CHARACTER(20)  :: OutFmt      !< Output format for numerical results [-]
    CHARACTER(20)  :: OutSFmt      !< Output format for header strings [-]
    CHARACTER(1)  :: Delim      !< Delimiter string for outputs, defaults to tab-delimiters [-]
    INTEGER(IntKi)  :: UnOutFile = 0      !< File unit for the UnsteadyAero outputs [-]
    LOGICAL  :: ShedEffect      !< Include the effect of shed vorticity. If False, the input alpha is assumed to already contain this effect (e.g. vortex methods) [-]
    INTEGER(IntKi)  :: lin_nx = 0      !< Number of continuous states for linearization [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: UA_off_forGood      !< logical flag indicating if UA is off for good [-]
  END TYPE UA_ParameterType
! =======================
! =========  UA_InputType  =======
  TYPE, PUBLIC :: UA_InputType
    REAL(ReKi)  :: U      !< air velocity magnitude relative to the airfoil [m/s]
    REAL(ReKi)  :: alpha      !< angle of attack [rad]
    REAL(ReKi)  :: Re      !< Reynold's number [-]
    REAL(ReKi)  :: UserProp = 0.0      !< UserProp value for interpolating airfoil tables [-]
    REAL(ReKi) , DIMENSION(1:2)  :: v_ac      !< Relative fluid velocity at the aerodynamic center (UAMod=4) [m/s]
    REAL(ReKi)  :: omega      !< pitching/twisting rate of the airfoil section (UAMod=4) [rad/s]
  END TYPE UA_InputType
! =======================
! =========  UA_OutputType  =======
  TYPE, PUBLIC :: UA_OutputType
    REAL(ReKi)  :: Cn      !< 2D, normal to chord, force coefficient [-]
    REAL(ReKi)  :: Cc      !< 2D, tangent to chord, force coefficient [-]
    REAL(ReKi)  :: Cm      !< 2D pitching moment coefficient about the 1/4 chord, positive when nose is up [-]
    REAL(ReKi)  :: Cl      !< 2D lift coefficient [-]
    REAL(ReKi)  :: Cd      !< 2D drag coefficient [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< outputs to be written to a file [-]
  END TYPE UA_OutputType
! =======================
CONTAINS
 SUBROUTINE UA_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(UA_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%dt = SrcInitInputData%dt
    DstInitInputData%OutRootName = SrcInitInputData%OutRootName
IF (ALLOCATED(SrcInitInputData%c)) THEN
  i1_l = LBOUND(SrcInitInputData%c,1)
  i1_u = UBOUND(SrcInitInputData%c,1)
  i2_l = LBOUND(SrcInitInputData%c,2)
  i2_u = UBOUND(SrcInitInputData%c,2)
  IF (.NOT. ALLOCATED(DstInitInputData%c)) THEN 
    ALLOCATE(DstInitInputData%c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%c.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%c = SrcInitInputData%c
ENDIF
    DstInitInputData%numBlades = SrcInitInputData%numBlades
    DstInitInputData%nNodesPerBlade = SrcInitInputData%nNodesPerBlade
    DstInitInputData%UAMod = SrcInitInputData%UAMod
    DstInitInputData%a_s = SrcInitInputData%a_s
    DstInitInputData%Flookup = SrcInitInputData%Flookup
    DstInitInputData%ShedEffect = SrcInitInputData%ShedEffect
    DstInitInputData%WrSum = SrcInitInputData%WrSum
IF (ALLOCATED(SrcInitInputData%UAOff_innerNode)) THEN
  i1_l = LBOUND(SrcInitInputData%UAOff_innerNode,1)
  i1_u = UBOUND(SrcInitInputData%UAOff_innerNode,1)
  IF (.NOT. ALLOCATED(DstInitInputData%UAOff_innerNode)) THEN 
    ALLOCATE(DstInitInputData%UAOff_innerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_innerNode.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%UAOff_innerNode = SrcInitInputData%UAOff_innerNode
ENDIF
IF (ALLOCATED(SrcInitInputData%UAOff_outerNode)) THEN
  i1_l = LBOUND(SrcInitInputData%UAOff_outerNode,1)
  i1_u = UBOUND(SrcInitInputData%UAOff_outerNode,1)
  IF (.NOT. ALLOCATED(DstInitInputData%UAOff_outerNode)) THEN 
    ALLOCATE(DstInitInputData%UAOff_outerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_outerNode.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%UAOff_outerNode = SrcInitInputData%UAOff_outerNode
ENDIF
 END SUBROUTINE UA_CopyInitInput

 SUBROUTINE UA_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(UA_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%c)) THEN
  DEALLOCATE(InitInputData%c)
ENDIF
IF (ALLOCATED(InitInputData%UAOff_innerNode)) THEN
  DEALLOCATE(InitInputData%UAOff_innerNode)
ENDIF
IF (ALLOCATED(InitInputData%UAOff_outerNode)) THEN
  DEALLOCATE(InitInputData%UAOff_outerNode)
ENDIF
 END SUBROUTINE UA_DestroyInitInput

 SUBROUTINE UA_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! dt
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutRootName)  ! OutRootName
  Int_BufSz   = Int_BufSz   + 1     ! c allocated yes/no
  IF ( ALLOCATED(InData%c) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! c upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%c)  ! c
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numBlades
      Int_BufSz  = Int_BufSz  + 1  ! nNodesPerBlade
      Int_BufSz  = Int_BufSz  + 1  ! UAMod
      Re_BufSz   = Re_BufSz   + 1  ! a_s
      Int_BufSz  = Int_BufSz  + 1  ! Flookup
      Int_BufSz  = Int_BufSz  + 1  ! ShedEffect
      Int_BufSz  = Int_BufSz  + 1  ! WrSum
  Int_BufSz   = Int_BufSz   + 1     ! UAOff_innerNode allocated yes/no
  IF ( ALLOCATED(InData%UAOff_innerNode) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UAOff_innerNode upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%UAOff_innerNode)  ! UAOff_innerNode
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! UAOff_outerNode allocated yes/no
  IF ( ALLOCATED(InData%UAOff_outerNode) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UAOff_outerNode upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%UAOff_outerNode)  ! UAOff_outerNode
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%dt
    Db_Xferred = Db_Xferred + 1
    DO I = 1, LEN(InData%OutRootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutRootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%c) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%c,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%c,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%c,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%c,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%c,2), UBOUND(InData%c,2)
        DO i1 = LBOUND(InData%c,1), UBOUND(InData%c,1)
          ReKiBuf(Re_Xferred) = InData%c(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numBlades
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nNodesPerBlade
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UAMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%a_s
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Flookup, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ShedEffect, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%WrSum, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UAOff_innerNode) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UAOff_innerNode,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UAOff_innerNode,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%UAOff_innerNode,1), UBOUND(InData%UAOff_innerNode,1)
        IntKiBuf(Int_Xferred) = InData%UAOff_innerNode(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%UAOff_outerNode) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UAOff_outerNode,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UAOff_outerNode,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%UAOff_outerNode,1), UBOUND(InData%UAOff_outerNode,1)
        IntKiBuf(Int_Xferred) = InData%UAOff_outerNode(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE UA_PackInitInput

 SUBROUTINE UA_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dt = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    DO I = 1, LEN(OutData%OutRootName)
      OutData%OutRootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! c not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%c)) DEALLOCATE(OutData%c)
    ALLOCATE(OutData%c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%c.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%c,2), UBOUND(OutData%c,2)
        DO i1 = LBOUND(OutData%c,1), UBOUND(OutData%c,1)
          OutData%c(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%numBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nNodesPerBlade = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UAMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%a_s = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Flookup = TRANSFER(IntKiBuf(Int_Xferred), OutData%Flookup)
    Int_Xferred = Int_Xferred + 1
    OutData%ShedEffect = TRANSFER(IntKiBuf(Int_Xferred), OutData%ShedEffect)
    Int_Xferred = Int_Xferred + 1
    OutData%WrSum = TRANSFER(IntKiBuf(Int_Xferred), OutData%WrSum)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UAOff_innerNode not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UAOff_innerNode)) DEALLOCATE(OutData%UAOff_innerNode)
    ALLOCATE(OutData%UAOff_innerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UAOff_innerNode.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%UAOff_innerNode,1), UBOUND(OutData%UAOff_innerNode,1)
        OutData%UAOff_innerNode(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UAOff_outerNode not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UAOff_outerNode)) DEALLOCATE(OutData%UAOff_outerNode)
    ALLOCATE(OutData%UAOff_outerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UAOff_outerNode.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%UAOff_outerNode,1), UBOUND(OutData%UAOff_outerNode,1)
        OutData%UAOff_outerNode(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
 END SUBROUTINE UA_UnPackInitInput

 SUBROUTINE UA_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(UA_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Version, DstInitOutputData%Version, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
 END SUBROUTINE UA_CopyInitOutput

 SUBROUTINE UA_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(UA_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Version, ErrStat, ErrMsg )
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
 END SUBROUTINE UA_DestroyInitOutput

 SUBROUTINE UA_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Version: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Version, ErrStat2, ErrMsg2, .TRUE. ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Version
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Version
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Version
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Version, ErrStat2, ErrMsg2, OnlySize ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE UA_PackInitOutput

 SUBROUTINE UA_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Version, ErrStat2, ErrMsg2 ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
 END SUBROUTINE UA_UnPackInitOutput

 SUBROUTINE UA_CopyKelvinChainType( SrcKelvinChainTypeData, DstKelvinChainTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_KelvinChainType), INTENT(IN) :: SrcKelvinChainTypeData
   TYPE(UA_KelvinChainType), INTENT(INOUT) :: DstKelvinChainTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyKelvinChainType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstKelvinChainTypeData%Cn_prime = SrcKelvinChainTypeData%Cn_prime
    DstKelvinChainTypeData%C_nalpha_circ = SrcKelvinChainTypeData%C_nalpha_circ
    DstKelvinChainTypeData%Kalpha_f = SrcKelvinChainTypeData%Kalpha_f
    DstKelvinChainTypeData%Kq_f = SrcKelvinChainTypeData%Kq_f
    DstKelvinChainTypeData%alpha_filt_cur = SrcKelvinChainTypeData%alpha_filt_cur
    DstKelvinChainTypeData%alpha_e = SrcKelvinChainTypeData%alpha_e
    DstKelvinChainTypeData%dalpha0 = SrcKelvinChainTypeData%dalpha0
    DstKelvinChainTypeData%alpha_f = SrcKelvinChainTypeData%alpha_f
    DstKelvinChainTypeData%Kq = SrcKelvinChainTypeData%Kq
    DstKelvinChainTypeData%q_cur = SrcKelvinChainTypeData%q_cur
    DstKelvinChainTypeData%q_f_cur = SrcKelvinChainTypeData%q_f_cur
    DstKelvinChainTypeData%X1 = SrcKelvinChainTypeData%X1
    DstKelvinChainTypeData%X2 = SrcKelvinChainTypeData%X2
    DstKelvinChainTypeData%X3 = SrcKelvinChainTypeData%X3
    DstKelvinChainTypeData%X4 = SrcKelvinChainTypeData%X4
    DstKelvinChainTypeData%Kprime_alpha = SrcKelvinChainTypeData%Kprime_alpha
    DstKelvinChainTypeData%Kprime_q = SrcKelvinChainTypeData%Kprime_q
    DstKelvinChainTypeData%K3prime_q = SrcKelvinChainTypeData%K3prime_q
    DstKelvinChainTypeData%Kprimeprime_q = SrcKelvinChainTypeData%Kprimeprime_q
    DstKelvinChainTypeData%Dp = SrcKelvinChainTypeData%Dp
    DstKelvinChainTypeData%Cn_pot = SrcKelvinChainTypeData%Cn_pot
    DstKelvinChainTypeData%Cc_pot = SrcKelvinChainTypeData%Cc_pot
    DstKelvinChainTypeData%Cn_alpha_q_circ = SrcKelvinChainTypeData%Cn_alpha_q_circ
    DstKelvinChainTypeData%Cn_alpha_q_nc = SrcKelvinChainTypeData%Cn_alpha_q_nc
    DstKelvinChainTypeData%Cm_q_circ = SrcKelvinChainTypeData%Cm_q_circ
    DstKelvinChainTypeData%Cn_alpha_nc = SrcKelvinChainTypeData%Cn_alpha_nc
    DstKelvinChainTypeData%Cn_q_circ = SrcKelvinChainTypeData%Cn_q_circ
    DstKelvinChainTypeData%Cn_q_nc = SrcKelvinChainTypeData%Cn_q_nc
    DstKelvinChainTypeData%Cm_q_nc = SrcKelvinChainTypeData%Cm_q_nc
    DstKelvinChainTypeData%fprimeprime = SrcKelvinChainTypeData%fprimeprime
    DstKelvinChainTypeData%Df = SrcKelvinChainTypeData%Df
    DstKelvinChainTypeData%Df_c = SrcKelvinChainTypeData%Df_c
    DstKelvinChainTypeData%Df_m = SrcKelvinChainTypeData%Df_m
    DstKelvinChainTypeData%Dalphaf = SrcKelvinChainTypeData%Dalphaf
    DstKelvinChainTypeData%fprime = SrcKelvinChainTypeData%fprime
    DstKelvinChainTypeData%fprime_c = SrcKelvinChainTypeData%fprime_c
    DstKelvinChainTypeData%fprimeprime_c = SrcKelvinChainTypeData%fprimeprime_c
    DstKelvinChainTypeData%fprime_m = SrcKelvinChainTypeData%fprime_m
    DstKelvinChainTypeData%fprimeprime_m = SrcKelvinChainTypeData%fprimeprime_m
    DstKelvinChainTypeData%Cn_v = SrcKelvinChainTypeData%Cn_v
    DstKelvinChainTypeData%C_V = SrcKelvinChainTypeData%C_V
    DstKelvinChainTypeData%Cn_FS = SrcKelvinChainTypeData%Cn_FS
    DstKelvinChainTypeData%T_f = SrcKelvinChainTypeData%T_f
    DstKelvinChainTypeData%T_fc = SrcKelvinChainTypeData%T_fc
    DstKelvinChainTypeData%T_fm = SrcKelvinChainTypeData%T_fm
    DstKelvinChainTypeData%T_V = SrcKelvinChainTypeData%T_V
    DstKelvinChainTypeData%k_alpha = SrcKelvinChainTypeData%k_alpha
    DstKelvinChainTypeData%k_q = SrcKelvinChainTypeData%k_q
    DstKelvinChainTypeData%T_alpha = SrcKelvinChainTypeData%T_alpha
    DstKelvinChainTypeData%T_q = SrcKelvinChainTypeData%T_q
    DstKelvinChainTypeData%ds = SrcKelvinChainTypeData%ds
 END SUBROUTINE UA_CopyKelvinChainType

 SUBROUTINE UA_DestroyKelvinChainType( KelvinChainTypeData, ErrStat, ErrMsg )
  TYPE(UA_KelvinChainType), INTENT(INOUT) :: KelvinChainTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyKelvinChainType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE UA_DestroyKelvinChainType

 SUBROUTINE UA_PackKelvinChainType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_KelvinChainType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackKelvinChainType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Cn_prime
      Re_BufSz   = Re_BufSz   + 1  ! C_nalpha_circ
      Re_BufSz   = Re_BufSz   + 1  ! Kalpha_f
      Re_BufSz   = Re_BufSz   + 1  ! Kq_f
      Re_BufSz   = Re_BufSz   + 1  ! alpha_filt_cur
      Re_BufSz   = Re_BufSz   + 1  ! alpha_e
      Re_BufSz   = Re_BufSz   + 1  ! dalpha0
      Re_BufSz   = Re_BufSz   + 1  ! alpha_f
      Re_BufSz   = Re_BufSz   + 1  ! Kq
      Re_BufSz   = Re_BufSz   + 1  ! q_cur
      Re_BufSz   = Re_BufSz   + 1  ! q_f_cur
      Re_BufSz   = Re_BufSz   + 1  ! X1
      Re_BufSz   = Re_BufSz   + 1  ! X2
      Re_BufSz   = Re_BufSz   + 1  ! X3
      Re_BufSz   = Re_BufSz   + 1  ! X4
      Re_BufSz   = Re_BufSz   + 1  ! Kprime_alpha
      Re_BufSz   = Re_BufSz   + 1  ! Kprime_q
      Re_BufSz   = Re_BufSz   + 1  ! K3prime_q
      Re_BufSz   = Re_BufSz   + 1  ! Kprimeprime_q
      Re_BufSz   = Re_BufSz   + 1  ! Dp
      Re_BufSz   = Re_BufSz   + 1  ! Cn_pot
      Re_BufSz   = Re_BufSz   + 1  ! Cc_pot
      Re_BufSz   = Re_BufSz   + 1  ! Cn_alpha_q_circ
      Re_BufSz   = Re_BufSz   + 1  ! Cn_alpha_q_nc
      Re_BufSz   = Re_BufSz   + 1  ! Cm_q_circ
      Re_BufSz   = Re_BufSz   + 1  ! Cn_alpha_nc
      Re_BufSz   = Re_BufSz   + 1  ! Cn_q_circ
      Re_BufSz   = Re_BufSz   + 1  ! Cn_q_nc
      Re_BufSz   = Re_BufSz   + 1  ! Cm_q_nc
      Re_BufSz   = Re_BufSz   + 1  ! fprimeprime
      Re_BufSz   = Re_BufSz   + 1  ! Df
      Re_BufSz   = Re_BufSz   + 1  ! Df_c
      Re_BufSz   = Re_BufSz   + 1  ! Df_m
      Re_BufSz   = Re_BufSz   + 1  ! Dalphaf
      Re_BufSz   = Re_BufSz   + 1  ! fprime
      Re_BufSz   = Re_BufSz   + 1  ! fprime_c
      Re_BufSz   = Re_BufSz   + 1  ! fprimeprime_c
      Re_BufSz   = Re_BufSz   + 1  ! fprime_m
      Re_BufSz   = Re_BufSz   + 1  ! fprimeprime_m
      Re_BufSz   = Re_BufSz   + 1  ! Cn_v
      Re_BufSz   = Re_BufSz   + 1  ! C_V
      Re_BufSz   = Re_BufSz   + 1  ! Cn_FS
      Re_BufSz   = Re_BufSz   + 1  ! T_f
      Re_BufSz   = Re_BufSz   + 1  ! T_fc
      Re_BufSz   = Re_BufSz   + 1  ! T_fm
      Re_BufSz   = Re_BufSz   + 1  ! T_V
      Re_BufSz   = Re_BufSz   + 1  ! k_alpha
      Re_BufSz   = Re_BufSz   + 1  ! k_q
      Re_BufSz   = Re_BufSz   + 1  ! T_alpha
      Re_BufSz   = Re_BufSz   + 1  ! T_q
      Re_BufSz   = Re_BufSz   + 1  ! ds
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Cn_prime
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_nalpha_circ
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kalpha_f
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kq_f
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alpha_filt_cur
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alpha_e
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dalpha0
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alpha_f
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kq
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%q_cur
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%q_f_cur
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X1
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X2
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X3
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%X4
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kprime_alpha
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kprime_q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%K3prime_q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Kprimeprime_q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Dp
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_pot
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cc_pot
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_alpha_q_circ
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_alpha_q_nc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cm_q_circ
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_alpha_nc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_q_circ
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_q_nc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cm_q_nc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprimeprime
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Df
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Df_c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Df_m
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Dalphaf
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprime
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprime_c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprimeprime_c
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprime_m
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%fprimeprime_m
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_v
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%C_V
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cn_FS
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_f
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_fc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_fm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_V
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_alpha
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%k_q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_alpha
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%T_q
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ds
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_PackKelvinChainType

 SUBROUTINE UA_UnPackKelvinChainType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_KelvinChainType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackKelvinChainType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Cn_prime = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_nalpha_circ = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kalpha_f = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kq_f = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alpha_filt_cur = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alpha_e = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dalpha0 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alpha_f = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kq = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%q_cur = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%q_f_cur = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%X1 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%X2 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%X3 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%X4 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kprime_alpha = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kprime_q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%K3prime_q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Kprimeprime_q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Dp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_pot = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cc_pot = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_alpha_q_circ = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_alpha_q_nc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cm_q_circ = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_alpha_nc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_q_circ = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_q_nc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cm_q_nc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprimeprime = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Df = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Df_c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Df_m = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Dalphaf = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprime = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprime_c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprimeprime_c = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprime_m = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%fprimeprime_m = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_v = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%C_V = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cn_FS = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_f = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_fc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_fm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_V = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_alpha = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%k_q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_alpha = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%T_q = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ds = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_UnPackKelvinChainType

 SUBROUTINE UA_CopyElementContinuousStateType( SrcElementContinuousStateTypeData, DstElementContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_ElementContinuousStateType), INTENT(IN) :: SrcElementContinuousStateTypeData
   TYPE(UA_ElementContinuousStateType), INTENT(INOUT) :: DstElementContinuousStateTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyElementContinuousStateType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstElementContinuousStateTypeData%x = SrcElementContinuousStateTypeData%x
 END SUBROUTINE UA_CopyElementContinuousStateType

 SUBROUTINE UA_DestroyElementContinuousStateType( ElementContinuousStateTypeData, ErrStat, ErrMsg )
  TYPE(UA_ElementContinuousStateType), INTENT(INOUT) :: ElementContinuousStateTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyElementContinuousStateType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE UA_DestroyElementContinuousStateType

 SUBROUTINE UA_PackElementContinuousStateType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_ElementContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackElementContinuousStateType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + SIZE(InData%x)  ! x
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i1 = LBOUND(InData%x,1), UBOUND(InData%x,1)
      DbKiBuf(Db_Xferred) = InData%x(i1)
      Db_Xferred = Db_Xferred + 1
    END DO
 END SUBROUTINE UA_PackElementContinuousStateType

 SUBROUTINE UA_UnPackElementContinuousStateType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_ElementContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackElementContinuousStateType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%x,1)
    i1_u = UBOUND(OutData%x,1)
    DO i1 = LBOUND(OutData%x,1), UBOUND(OutData%x,1)
      OutData%x(i1) = REAL(DbKiBuf(Db_Xferred), R8Ki)
      Db_Xferred = Db_Xferred + 1
    END DO
 END SUBROUTINE UA_UnPackElementContinuousStateType

 SUBROUTINE UA_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(UA_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcContStateData%element)) THEN
  i1_l = LBOUND(SrcContStateData%element,1)
  i1_u = UBOUND(SrcContStateData%element,1)
  i2_l = LBOUND(SrcContStateData%element,2)
  i2_u = UBOUND(SrcContStateData%element,2)
  IF (.NOT. ALLOCATED(DstContStateData%element)) THEN 
    ALLOCATE(DstContStateData%element(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%element.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i2 = LBOUND(SrcContStateData%element,2), UBOUND(SrcContStateData%element,2)
    DO i1 = LBOUND(SrcContStateData%element,1), UBOUND(SrcContStateData%element,1)
      CALL UA_Copyelementcontinuousstatetype( SrcContStateData%element(i1,i2), DstContStateData%element(i1,i2), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
    ENDDO
ENDIF
 END SUBROUTINE UA_CopyContState

 SUBROUTINE UA_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(UA_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ContStateData%element)) THEN
DO i2 = LBOUND(ContStateData%element,2), UBOUND(ContStateData%element,2)
DO i1 = LBOUND(ContStateData%element,1), UBOUND(ContStateData%element,1)
  CALL UA_Destroyelementcontinuousstatetype( ContStateData%element(i1,i2), ErrStat, ErrMsg )
ENDDO
ENDDO
  DEALLOCATE(ContStateData%element)
ENDIF
 END SUBROUTINE UA_DestroyContState

 SUBROUTINE UA_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! element allocated yes/no
  IF ( ALLOCATED(InData%element) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! element upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i2 = LBOUND(InData%element,2), UBOUND(InData%element,2)
    DO i1 = LBOUND(InData%element,1), UBOUND(InData%element,1)
      Int_BufSz   = Int_BufSz + 3  ! element: size of buffers for each call to pack subtype
      CALL UA_Packelementcontinuousstatetype( Re_Buf, Db_Buf, Int_Buf, InData%element(i1,i2), ErrStat2, ErrMsg2, .TRUE. ) ! element 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! element
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! element
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! element
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%element) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%element,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%element,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%element,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%element,2)
    Int_Xferred = Int_Xferred + 2

    DO i2 = LBOUND(InData%element,2), UBOUND(InData%element,2)
    DO i1 = LBOUND(InData%element,1), UBOUND(InData%element,1)
      CALL UA_Packelementcontinuousstatetype( Re_Buf, Db_Buf, Int_Buf, InData%element(i1,i2), ErrStat2, ErrMsg2, OnlySize ) ! element 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
    END DO
  END IF
 END SUBROUTINE UA_PackContState

 SUBROUTINE UA_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! element not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%element)) DEALLOCATE(OutData%element)
    ALLOCATE(OutData%element(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%element.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i2 = LBOUND(OutData%element,2), UBOUND(OutData%element,2)
    DO i1 = LBOUND(OutData%element,1), UBOUND(OutData%element,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_Unpackelementcontinuousstatetype( Re_Buf, Db_Buf, Int_Buf, OutData%element(i1,i2), ErrStat2, ErrMsg2 ) ! element 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
    END DO
  END IF
 END SUBROUTINE UA_UnPackContState

 SUBROUTINE UA_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(UA_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcDiscStateData%alpha_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%alpha_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%alpha_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%alpha_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%alpha_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%alpha_minus1)) THEN 
    ALLOCATE(DstDiscStateData%alpha_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%alpha_minus1 = SrcDiscStateData%alpha_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%alpha_filt_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%alpha_filt_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%alpha_filt_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%alpha_filt_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%alpha_filt_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%alpha_filt_minus1)) THEN 
    ALLOCATE(DstDiscStateData%alpha_filt_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_filt_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%alpha_filt_minus1 = SrcDiscStateData%alpha_filt_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%alpha_dot)) THEN
  i1_l = LBOUND(SrcDiscStateData%alpha_dot,1)
  i1_u = UBOUND(SrcDiscStateData%alpha_dot,1)
  i2_l = LBOUND(SrcDiscStateData%alpha_dot,2)
  i2_u = UBOUND(SrcDiscStateData%alpha_dot,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%alpha_dot)) THEN 
    ALLOCATE(DstDiscStateData%alpha_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_dot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%alpha_dot = SrcDiscStateData%alpha_dot
ENDIF
IF (ALLOCATED(SrcDiscStateData%alpha_dot_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%alpha_dot_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%alpha_dot_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%alpha_dot_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%alpha_dot_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%alpha_dot_minus1)) THEN 
    ALLOCATE(DstDiscStateData%alpha_dot_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alpha_dot_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%alpha_dot_minus1 = SrcDiscStateData%alpha_dot_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%q_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%q_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%q_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%q_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%q_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%q_minus1)) THEN 
    ALLOCATE(DstDiscStateData%q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%q_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%q_minus1 = SrcDiscStateData%q_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Kalpha_f_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Kalpha_f_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Kalpha_f_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Kalpha_f_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Kalpha_f_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Kalpha_f_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Kalpha_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kalpha_f_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Kalpha_f_minus1 = SrcDiscStateData%Kalpha_f_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Kq_f_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Kq_f_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Kq_f_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Kq_f_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Kq_f_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Kq_f_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Kq_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kq_f_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Kq_f_minus1 = SrcDiscStateData%Kq_f_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%q_f_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%q_f_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%q_f_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%q_f_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%q_f_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%q_f_minus1)) THEN 
    ALLOCATE(DstDiscStateData%q_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%q_f_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%q_f_minus1 = SrcDiscStateData%q_f_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%X1_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%X1_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%X1_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%X1_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%X1_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%X1_minus1)) THEN 
    ALLOCATE(DstDiscStateData%X1_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X1_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%X1_minus1 = SrcDiscStateData%X1_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%X2_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%X2_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%X2_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%X2_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%X2_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%X2_minus1)) THEN 
    ALLOCATE(DstDiscStateData%X2_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X2_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%X2_minus1 = SrcDiscStateData%X2_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%X3_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%X3_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%X3_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%X3_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%X3_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%X3_minus1)) THEN 
    ALLOCATE(DstDiscStateData%X3_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X3_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%X3_minus1 = SrcDiscStateData%X3_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%X4_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%X4_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%X4_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%X4_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%X4_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%X4_minus1)) THEN 
    ALLOCATE(DstDiscStateData%X4_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%X4_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%X4_minus1 = SrcDiscStateData%X4_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Kprime_alpha_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Kprime_alpha_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Kprime_alpha_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Kprime_alpha_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Kprime_alpha_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Kprime_alpha_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Kprime_alpha_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprime_alpha_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Kprime_alpha_minus1 = SrcDiscStateData%Kprime_alpha_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Kprime_q_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Kprime_q_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Kprime_q_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Kprime_q_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Kprime_q_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Kprime_q_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Kprime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprime_q_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Kprime_q_minus1 = SrcDiscStateData%Kprime_q_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Kprimeprime_q_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Kprimeprime_q_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Kprimeprime_q_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Kprimeprime_q_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Kprimeprime_q_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Kprimeprime_q_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Kprimeprime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Kprimeprime_q_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Kprimeprime_q_minus1 = SrcDiscStateData%Kprimeprime_q_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%K3prime_q_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%K3prime_q_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%K3prime_q_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%K3prime_q_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%K3prime_q_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%K3prime_q_minus1)) THEN 
    ALLOCATE(DstDiscStateData%K3prime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%K3prime_q_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%K3prime_q_minus1 = SrcDiscStateData%K3prime_q_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Dp_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Dp_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Dp_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Dp_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Dp_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Dp_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Dp_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Dp_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Dp_minus1 = SrcDiscStateData%Dp_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Cn_pot_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Cn_pot_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Cn_pot_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Cn_pot_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Cn_pot_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Cn_pot_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Cn_pot_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_pot_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Cn_pot_minus1 = SrcDiscStateData%Cn_pot_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprimeprime_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprimeprime_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprimeprime_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprimeprime_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprimeprime_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprimeprime_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprimeprime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprimeprime_minus1 = SrcDiscStateData%fprimeprime_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprimeprime_c_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprimeprime_c_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprimeprime_c_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprimeprime_c_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprimeprime_c_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprimeprime_c_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprimeprime_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_c_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprimeprime_c_minus1 = SrcDiscStateData%fprimeprime_c_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprimeprime_m_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprimeprime_m_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprimeprime_m_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprimeprime_m_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprimeprime_m_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprimeprime_m_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprimeprime_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprimeprime_m_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprimeprime_m_minus1 = SrcDiscStateData%fprimeprime_m_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Df_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Df_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Df_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Df_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Df_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Df_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Df_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Df_minus1 = SrcDiscStateData%Df_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Df_c_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Df_c_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Df_c_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Df_c_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Df_c_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Df_c_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Df_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_c_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Df_c_minus1 = SrcDiscStateData%Df_c_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Df_m_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Df_m_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Df_m_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Df_m_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Df_m_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Df_m_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Df_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Df_m_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Df_m_minus1 = SrcDiscStateData%Df_m_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Dalphaf_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Dalphaf_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Dalphaf_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Dalphaf_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Dalphaf_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Dalphaf_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Dalphaf_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Dalphaf_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Dalphaf_minus1 = SrcDiscStateData%Dalphaf_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%alphaf_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%alphaf_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%alphaf_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%alphaf_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%alphaf_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%alphaf_minus1)) THEN 
    ALLOCATE(DstDiscStateData%alphaf_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%alphaf_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%alphaf_minus1 = SrcDiscStateData%alphaf_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprime_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprime_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprime_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprime_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprime_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprime_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprime_minus1 = SrcDiscStateData%fprime_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprime_c_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprime_c_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprime_c_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprime_c_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprime_c_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprime_c_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprime_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_c_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprime_c_minus1 = SrcDiscStateData%fprime_c_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%fprime_m_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%fprime_m_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%fprime_m_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%fprime_m_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%fprime_m_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%fprime_m_minus1)) THEN 
    ALLOCATE(DstDiscStateData%fprime_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%fprime_m_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%fprime_m_minus1 = SrcDiscStateData%fprime_m_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%tau_V)) THEN
  i1_l = LBOUND(SrcDiscStateData%tau_V,1)
  i1_u = UBOUND(SrcDiscStateData%tau_V,1)
  i2_l = LBOUND(SrcDiscStateData%tau_V,2)
  i2_u = UBOUND(SrcDiscStateData%tau_V,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%tau_V)) THEN 
    ALLOCATE(DstDiscStateData%tau_V(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%tau_V.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%tau_V = SrcDiscStateData%tau_V
ENDIF
IF (ALLOCATED(SrcDiscStateData%tau_V_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%tau_V_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%tau_V_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%tau_V_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%tau_V_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%tau_V_minus1)) THEN 
    ALLOCATE(DstDiscStateData%tau_V_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%tau_V_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%tau_V_minus1 = SrcDiscStateData%tau_V_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Cn_v_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Cn_v_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Cn_v_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Cn_v_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Cn_v_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Cn_v_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Cn_v_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_v_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Cn_v_minus1 = SrcDiscStateData%Cn_v_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%C_V_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%C_V_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%C_V_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%C_V_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%C_V_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%C_V_minus1)) THEN 
    ALLOCATE(DstDiscStateData%C_V_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%C_V_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%C_V_minus1 = SrcDiscStateData%C_V_minus1
ENDIF
IF (ALLOCATED(SrcDiscStateData%Cn_prime_minus1)) THEN
  i1_l = LBOUND(SrcDiscStateData%Cn_prime_minus1,1)
  i1_u = UBOUND(SrcDiscStateData%Cn_prime_minus1,1)
  i2_l = LBOUND(SrcDiscStateData%Cn_prime_minus1,2)
  i2_u = UBOUND(SrcDiscStateData%Cn_prime_minus1,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%Cn_prime_minus1)) THEN 
    ALLOCATE(DstDiscStateData%Cn_prime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%Cn_prime_minus1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%Cn_prime_minus1 = SrcDiscStateData%Cn_prime_minus1
ENDIF
 END SUBROUTINE UA_CopyDiscState

 SUBROUTINE UA_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(UA_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(DiscStateData%alpha_minus1)) THEN
  DEALLOCATE(DiscStateData%alpha_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%alpha_filt_minus1)) THEN
  DEALLOCATE(DiscStateData%alpha_filt_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%alpha_dot)) THEN
  DEALLOCATE(DiscStateData%alpha_dot)
ENDIF
IF (ALLOCATED(DiscStateData%alpha_dot_minus1)) THEN
  DEALLOCATE(DiscStateData%alpha_dot_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%q_minus1)) THEN
  DEALLOCATE(DiscStateData%q_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Kalpha_f_minus1)) THEN
  DEALLOCATE(DiscStateData%Kalpha_f_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Kq_f_minus1)) THEN
  DEALLOCATE(DiscStateData%Kq_f_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%q_f_minus1)) THEN
  DEALLOCATE(DiscStateData%q_f_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%X1_minus1)) THEN
  DEALLOCATE(DiscStateData%X1_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%X2_minus1)) THEN
  DEALLOCATE(DiscStateData%X2_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%X3_minus1)) THEN
  DEALLOCATE(DiscStateData%X3_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%X4_minus1)) THEN
  DEALLOCATE(DiscStateData%X4_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Kprime_alpha_minus1)) THEN
  DEALLOCATE(DiscStateData%Kprime_alpha_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Kprime_q_minus1)) THEN
  DEALLOCATE(DiscStateData%Kprime_q_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Kprimeprime_q_minus1)) THEN
  DEALLOCATE(DiscStateData%Kprimeprime_q_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%K3prime_q_minus1)) THEN
  DEALLOCATE(DiscStateData%K3prime_q_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Dp_minus1)) THEN
  DEALLOCATE(DiscStateData%Dp_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Cn_pot_minus1)) THEN
  DEALLOCATE(DiscStateData%Cn_pot_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprimeprime_minus1)) THEN
  DEALLOCATE(DiscStateData%fprimeprime_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprimeprime_c_minus1)) THEN
  DEALLOCATE(DiscStateData%fprimeprime_c_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprimeprime_m_minus1)) THEN
  DEALLOCATE(DiscStateData%fprimeprime_m_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Df_minus1)) THEN
  DEALLOCATE(DiscStateData%Df_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Df_c_minus1)) THEN
  DEALLOCATE(DiscStateData%Df_c_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Df_m_minus1)) THEN
  DEALLOCATE(DiscStateData%Df_m_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Dalphaf_minus1)) THEN
  DEALLOCATE(DiscStateData%Dalphaf_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%alphaf_minus1)) THEN
  DEALLOCATE(DiscStateData%alphaf_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprime_minus1)) THEN
  DEALLOCATE(DiscStateData%fprime_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprime_c_minus1)) THEN
  DEALLOCATE(DiscStateData%fprime_c_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%fprime_m_minus1)) THEN
  DEALLOCATE(DiscStateData%fprime_m_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%tau_V)) THEN
  DEALLOCATE(DiscStateData%tau_V)
ENDIF
IF (ALLOCATED(DiscStateData%tau_V_minus1)) THEN
  DEALLOCATE(DiscStateData%tau_V_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Cn_v_minus1)) THEN
  DEALLOCATE(DiscStateData%Cn_v_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%C_V_minus1)) THEN
  DEALLOCATE(DiscStateData%C_V_minus1)
ENDIF
IF (ALLOCATED(DiscStateData%Cn_prime_minus1)) THEN
  DEALLOCATE(DiscStateData%Cn_prime_minus1)
ENDIF
 END SUBROUTINE UA_DestroyDiscState

 SUBROUTINE UA_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! alpha_minus1 allocated yes/no
  IF ( ALLOCATED(InData%alpha_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! alpha_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_minus1)  ! alpha_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha_filt_minus1 allocated yes/no
  IF ( ALLOCATED(InData%alpha_filt_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! alpha_filt_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_filt_minus1)  ! alpha_filt_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha_dot allocated yes/no
  IF ( ALLOCATED(InData%alpha_dot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! alpha_dot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_dot)  ! alpha_dot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alpha_dot_minus1 allocated yes/no
  IF ( ALLOCATED(InData%alpha_dot_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! alpha_dot_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_dot_minus1)  ! alpha_dot_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! q_minus1 allocated yes/no
  IF ( ALLOCATED(InData%q_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! q_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%q_minus1)  ! q_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Kalpha_f_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Kalpha_f_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Kalpha_f_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Kalpha_f_minus1)  ! Kalpha_f_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Kq_f_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Kq_f_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Kq_f_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Kq_f_minus1)  ! Kq_f_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! q_f_minus1 allocated yes/no
  IF ( ALLOCATED(InData%q_f_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! q_f_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%q_f_minus1)  ! q_f_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! X1_minus1 allocated yes/no
  IF ( ALLOCATED(InData%X1_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! X1_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X1_minus1)  ! X1_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! X2_minus1 allocated yes/no
  IF ( ALLOCATED(InData%X2_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! X2_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X2_minus1)  ! X2_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! X3_minus1 allocated yes/no
  IF ( ALLOCATED(InData%X3_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! X3_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X3_minus1)  ! X3_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! X4_minus1 allocated yes/no
  IF ( ALLOCATED(InData%X4_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! X4_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%X4_minus1)  ! X4_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Kprime_alpha_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Kprime_alpha_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Kprime_alpha_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Kprime_alpha_minus1)  ! Kprime_alpha_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Kprime_q_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Kprime_q_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Kprime_q_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Kprime_q_minus1)  ! Kprime_q_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Kprimeprime_q_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Kprimeprime_q_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Kprimeprime_q_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Kprimeprime_q_minus1)  ! Kprimeprime_q_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! K3prime_q_minus1 allocated yes/no
  IF ( ALLOCATED(InData%K3prime_q_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! K3prime_q_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%K3prime_q_minus1)  ! K3prime_q_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Dp_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Dp_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Dp_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Dp_minus1)  ! Dp_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cn_pot_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Cn_pot_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cn_pot_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cn_pot_minus1)  ! Cn_pot_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprimeprime_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprimeprime_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprimeprime_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprimeprime_minus1)  ! fprimeprime_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprimeprime_c_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprimeprime_c_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprimeprime_c_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprimeprime_c_minus1)  ! fprimeprime_c_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprimeprime_m_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprimeprime_m_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprimeprime_m_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprimeprime_m_minus1)  ! fprimeprime_m_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Df_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Df_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Df_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Df_minus1)  ! Df_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Df_c_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Df_c_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Df_c_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Df_c_minus1)  ! Df_c_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Df_m_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Df_m_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Df_m_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Df_m_minus1)  ! Df_m_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Dalphaf_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Dalphaf_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Dalphaf_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Dalphaf_minus1)  ! Dalphaf_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! alphaf_minus1 allocated yes/no
  IF ( ALLOCATED(InData%alphaf_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! alphaf_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alphaf_minus1)  ! alphaf_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprime_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprime_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprime_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprime_minus1)  ! fprime_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprime_c_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprime_c_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprime_c_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprime_c_minus1)  ! fprime_c_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! fprime_m_minus1 allocated yes/no
  IF ( ALLOCATED(InData%fprime_m_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! fprime_m_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%fprime_m_minus1)  ! fprime_m_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! tau_V allocated yes/no
  IF ( ALLOCATED(InData%tau_V) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! tau_V upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%tau_V)  ! tau_V
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! tau_V_minus1 allocated yes/no
  IF ( ALLOCATED(InData%tau_V_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! tau_V_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%tau_V_minus1)  ! tau_V_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cn_v_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Cn_v_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cn_v_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cn_v_minus1)  ! Cn_v_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! C_V_minus1 allocated yes/no
  IF ( ALLOCATED(InData%C_V_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! C_V_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%C_V_minus1)  ! C_V_minus1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cn_prime_minus1 allocated yes/no
  IF ( ALLOCATED(InData%Cn_prime_minus1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cn_prime_minus1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cn_prime_minus1)  ! Cn_prime_minus1
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%alpha_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%alpha_minus1,2), UBOUND(InData%alpha_minus1,2)
        DO i1 = LBOUND(InData%alpha_minus1,1), UBOUND(InData%alpha_minus1,1)
          ReKiBuf(Re_Xferred) = InData%alpha_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha_filt_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_filt_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_filt_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_filt_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_filt_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%alpha_filt_minus1,2), UBOUND(InData%alpha_filt_minus1,2)
        DO i1 = LBOUND(InData%alpha_filt_minus1,1), UBOUND(InData%alpha_filt_minus1,1)
          ReKiBuf(Re_Xferred) = InData%alpha_filt_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha_dot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_dot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_dot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_dot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_dot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%alpha_dot,2), UBOUND(InData%alpha_dot,2)
        DO i1 = LBOUND(InData%alpha_dot,1), UBOUND(InData%alpha_dot,1)
          ReKiBuf(Re_Xferred) = InData%alpha_dot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alpha_dot_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_dot_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_dot_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_dot_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_dot_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%alpha_dot_minus1,2), UBOUND(InData%alpha_dot_minus1,2)
        DO i1 = LBOUND(InData%alpha_dot_minus1,1), UBOUND(InData%alpha_dot_minus1,1)
          ReKiBuf(Re_Xferred) = InData%alpha_dot_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%q_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%q_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%q_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%q_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%q_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%q_minus1,2), UBOUND(InData%q_minus1,2)
        DO i1 = LBOUND(InData%q_minus1,1), UBOUND(InData%q_minus1,1)
          ReKiBuf(Re_Xferred) = InData%q_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Kalpha_f_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kalpha_f_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kalpha_f_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kalpha_f_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kalpha_f_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Kalpha_f_minus1,2), UBOUND(InData%Kalpha_f_minus1,2)
        DO i1 = LBOUND(InData%Kalpha_f_minus1,1), UBOUND(InData%Kalpha_f_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Kalpha_f_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Kq_f_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kq_f_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kq_f_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kq_f_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kq_f_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Kq_f_minus1,2), UBOUND(InData%Kq_f_minus1,2)
        DO i1 = LBOUND(InData%Kq_f_minus1,1), UBOUND(InData%Kq_f_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Kq_f_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%q_f_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%q_f_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%q_f_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%q_f_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%q_f_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%q_f_minus1,2), UBOUND(InData%q_f_minus1,2)
        DO i1 = LBOUND(InData%q_f_minus1,1), UBOUND(InData%q_f_minus1,1)
          ReKiBuf(Re_Xferred) = InData%q_f_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%X1_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X1_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X1_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X1_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X1_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%X1_minus1,2), UBOUND(InData%X1_minus1,2)
        DO i1 = LBOUND(InData%X1_minus1,1), UBOUND(InData%X1_minus1,1)
          ReKiBuf(Re_Xferred) = InData%X1_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%X2_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X2_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X2_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X2_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X2_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%X2_minus1,2), UBOUND(InData%X2_minus1,2)
        DO i1 = LBOUND(InData%X2_minus1,1), UBOUND(InData%X2_minus1,1)
          ReKiBuf(Re_Xferred) = InData%X2_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%X3_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X3_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X3_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X3_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X3_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%X3_minus1,2), UBOUND(InData%X3_minus1,2)
        DO i1 = LBOUND(InData%X3_minus1,1), UBOUND(InData%X3_minus1,1)
          ReKiBuf(Re_Xferred) = InData%X3_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%X4_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X4_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X4_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%X4_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%X4_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%X4_minus1,2), UBOUND(InData%X4_minus1,2)
        DO i1 = LBOUND(InData%X4_minus1,1), UBOUND(InData%X4_minus1,1)
          ReKiBuf(Re_Xferred) = InData%X4_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Kprime_alpha_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprime_alpha_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprime_alpha_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprime_alpha_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprime_alpha_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Kprime_alpha_minus1,2), UBOUND(InData%Kprime_alpha_minus1,2)
        DO i1 = LBOUND(InData%Kprime_alpha_minus1,1), UBOUND(InData%Kprime_alpha_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Kprime_alpha_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Kprime_q_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprime_q_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprime_q_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprime_q_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprime_q_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Kprime_q_minus1,2), UBOUND(InData%Kprime_q_minus1,2)
        DO i1 = LBOUND(InData%Kprime_q_minus1,1), UBOUND(InData%Kprime_q_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Kprime_q_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Kprimeprime_q_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprimeprime_q_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprimeprime_q_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Kprimeprime_q_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Kprimeprime_q_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Kprimeprime_q_minus1,2), UBOUND(InData%Kprimeprime_q_minus1,2)
        DO i1 = LBOUND(InData%Kprimeprime_q_minus1,1), UBOUND(InData%Kprimeprime_q_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Kprimeprime_q_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%K3prime_q_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%K3prime_q_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%K3prime_q_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%K3prime_q_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%K3prime_q_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%K3prime_q_minus1,2), UBOUND(InData%K3prime_q_minus1,2)
        DO i1 = LBOUND(InData%K3prime_q_minus1,1), UBOUND(InData%K3prime_q_minus1,1)
          ReKiBuf(Re_Xferred) = InData%K3prime_q_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Dp_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Dp_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Dp_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Dp_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Dp_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Dp_minus1,2), UBOUND(InData%Dp_minus1,2)
        DO i1 = LBOUND(InData%Dp_minus1,1), UBOUND(InData%Dp_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Dp_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cn_pot_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_pot_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_pot_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_pot_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_pot_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cn_pot_minus1,2), UBOUND(InData%Cn_pot_minus1,2)
        DO i1 = LBOUND(InData%Cn_pot_minus1,1), UBOUND(InData%Cn_pot_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Cn_pot_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprimeprime_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprimeprime_minus1,2), UBOUND(InData%fprimeprime_minus1,2)
        DO i1 = LBOUND(InData%fprimeprime_minus1,1), UBOUND(InData%fprimeprime_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprimeprime_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprimeprime_c_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_c_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_c_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_c_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_c_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprimeprime_c_minus1,2), UBOUND(InData%fprimeprime_c_minus1,2)
        DO i1 = LBOUND(InData%fprimeprime_c_minus1,1), UBOUND(InData%fprimeprime_c_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprimeprime_c_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprimeprime_m_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_m_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_m_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprimeprime_m_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprimeprime_m_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprimeprime_m_minus1,2), UBOUND(InData%fprimeprime_m_minus1,2)
        DO i1 = LBOUND(InData%fprimeprime_m_minus1,1), UBOUND(InData%fprimeprime_m_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprimeprime_m_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Df_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Df_minus1,2), UBOUND(InData%Df_minus1,2)
        DO i1 = LBOUND(InData%Df_minus1,1), UBOUND(InData%Df_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Df_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Df_c_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_c_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_c_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_c_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_c_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Df_c_minus1,2), UBOUND(InData%Df_c_minus1,2)
        DO i1 = LBOUND(InData%Df_c_minus1,1), UBOUND(InData%Df_c_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Df_c_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Df_m_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_m_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_m_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Df_m_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Df_m_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Df_m_minus1,2), UBOUND(InData%Df_m_minus1,2)
        DO i1 = LBOUND(InData%Df_m_minus1,1), UBOUND(InData%Df_m_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Df_m_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Dalphaf_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Dalphaf_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Dalphaf_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Dalphaf_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Dalphaf_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Dalphaf_minus1,2), UBOUND(InData%Dalphaf_minus1,2)
        DO i1 = LBOUND(InData%Dalphaf_minus1,1), UBOUND(InData%Dalphaf_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Dalphaf_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%alphaf_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alphaf_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alphaf_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alphaf_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alphaf_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%alphaf_minus1,2), UBOUND(InData%alphaf_minus1,2)
        DO i1 = LBOUND(InData%alphaf_minus1,1), UBOUND(InData%alphaf_minus1,1)
          ReKiBuf(Re_Xferred) = InData%alphaf_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprime_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprime_minus1,2), UBOUND(InData%fprime_minus1,2)
        DO i1 = LBOUND(InData%fprime_minus1,1), UBOUND(InData%fprime_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprime_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprime_c_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_c_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_c_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_c_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_c_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprime_c_minus1,2), UBOUND(InData%fprime_c_minus1,2)
        DO i1 = LBOUND(InData%fprime_c_minus1,1), UBOUND(InData%fprime_c_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprime_c_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%fprime_m_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_m_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_m_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%fprime_m_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%fprime_m_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%fprime_m_minus1,2), UBOUND(InData%fprime_m_minus1,2)
        DO i1 = LBOUND(InData%fprime_m_minus1,1), UBOUND(InData%fprime_m_minus1,1)
          ReKiBuf(Re_Xferred) = InData%fprime_m_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%tau_V) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tau_V,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tau_V,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tau_V,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tau_V,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%tau_V,2), UBOUND(InData%tau_V,2)
        DO i1 = LBOUND(InData%tau_V,1), UBOUND(InData%tau_V,1)
          ReKiBuf(Re_Xferred) = InData%tau_V(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%tau_V_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tau_V_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tau_V_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tau_V_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tau_V_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%tau_V_minus1,2), UBOUND(InData%tau_V_minus1,2)
        DO i1 = LBOUND(InData%tau_V_minus1,1), UBOUND(InData%tau_V_minus1,1)
          ReKiBuf(Re_Xferred) = InData%tau_V_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cn_v_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_v_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_v_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_v_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_v_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cn_v_minus1,2), UBOUND(InData%Cn_v_minus1,2)
        DO i1 = LBOUND(InData%Cn_v_minus1,1), UBOUND(InData%Cn_v_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Cn_v_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%C_V_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%C_V_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%C_V_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%C_V_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%C_V_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%C_V_minus1,2), UBOUND(InData%C_V_minus1,2)
        DO i1 = LBOUND(InData%C_V_minus1,1), UBOUND(InData%C_V_minus1,1)
          ReKiBuf(Re_Xferred) = InData%C_V_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cn_prime_minus1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_prime_minus1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_prime_minus1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cn_prime_minus1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cn_prime_minus1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cn_prime_minus1,2), UBOUND(InData%Cn_prime_minus1,2)
        DO i1 = LBOUND(InData%Cn_prime_minus1,1), UBOUND(InData%Cn_prime_minus1,1)
          ReKiBuf(Re_Xferred) = InData%Cn_prime_minus1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_PackDiscState

 SUBROUTINE UA_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_minus1)) DEALLOCATE(OutData%alpha_minus1)
    ALLOCATE(OutData%alpha_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%alpha_minus1,2), UBOUND(OutData%alpha_minus1,2)
        DO i1 = LBOUND(OutData%alpha_minus1,1), UBOUND(OutData%alpha_minus1,1)
          OutData%alpha_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_filt_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_filt_minus1)) DEALLOCATE(OutData%alpha_filt_minus1)
    ALLOCATE(OutData%alpha_filt_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_filt_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%alpha_filt_minus1,2), UBOUND(OutData%alpha_filt_minus1,2)
        DO i1 = LBOUND(OutData%alpha_filt_minus1,1), UBOUND(OutData%alpha_filt_minus1,1)
          OutData%alpha_filt_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_dot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_dot)) DEALLOCATE(OutData%alpha_dot)
    ALLOCATE(OutData%alpha_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_dot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%alpha_dot,2), UBOUND(OutData%alpha_dot,2)
        DO i1 = LBOUND(OutData%alpha_dot,1), UBOUND(OutData%alpha_dot,1)
          OutData%alpha_dot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_dot_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_dot_minus1)) DEALLOCATE(OutData%alpha_dot_minus1)
    ALLOCATE(OutData%alpha_dot_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_dot_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%alpha_dot_minus1,2), UBOUND(OutData%alpha_dot_minus1,2)
        DO i1 = LBOUND(OutData%alpha_dot_minus1,1), UBOUND(OutData%alpha_dot_minus1,1)
          OutData%alpha_dot_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! q_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%q_minus1)) DEALLOCATE(OutData%q_minus1)
    ALLOCATE(OutData%q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%q_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%q_minus1,2), UBOUND(OutData%q_minus1,2)
        DO i1 = LBOUND(OutData%q_minus1,1), UBOUND(OutData%q_minus1,1)
          OutData%q_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Kalpha_f_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Kalpha_f_minus1)) DEALLOCATE(OutData%Kalpha_f_minus1)
    ALLOCATE(OutData%Kalpha_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Kalpha_f_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Kalpha_f_minus1,2), UBOUND(OutData%Kalpha_f_minus1,2)
        DO i1 = LBOUND(OutData%Kalpha_f_minus1,1), UBOUND(OutData%Kalpha_f_minus1,1)
          OutData%Kalpha_f_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Kq_f_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Kq_f_minus1)) DEALLOCATE(OutData%Kq_f_minus1)
    ALLOCATE(OutData%Kq_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Kq_f_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Kq_f_minus1,2), UBOUND(OutData%Kq_f_minus1,2)
        DO i1 = LBOUND(OutData%Kq_f_minus1,1), UBOUND(OutData%Kq_f_minus1,1)
          OutData%Kq_f_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! q_f_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%q_f_minus1)) DEALLOCATE(OutData%q_f_minus1)
    ALLOCATE(OutData%q_f_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%q_f_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%q_f_minus1,2), UBOUND(OutData%q_f_minus1,2)
        DO i1 = LBOUND(OutData%q_f_minus1,1), UBOUND(OutData%q_f_minus1,1)
          OutData%q_f_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X1_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X1_minus1)) DEALLOCATE(OutData%X1_minus1)
    ALLOCATE(OutData%X1_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X1_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%X1_minus1,2), UBOUND(OutData%X1_minus1,2)
        DO i1 = LBOUND(OutData%X1_minus1,1), UBOUND(OutData%X1_minus1,1)
          OutData%X1_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X2_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X2_minus1)) DEALLOCATE(OutData%X2_minus1)
    ALLOCATE(OutData%X2_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X2_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%X2_minus1,2), UBOUND(OutData%X2_minus1,2)
        DO i1 = LBOUND(OutData%X2_minus1,1), UBOUND(OutData%X2_minus1,1)
          OutData%X2_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X3_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X3_minus1)) DEALLOCATE(OutData%X3_minus1)
    ALLOCATE(OutData%X3_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X3_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%X3_minus1,2), UBOUND(OutData%X3_minus1,2)
        DO i1 = LBOUND(OutData%X3_minus1,1), UBOUND(OutData%X3_minus1,1)
          OutData%X3_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! X4_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%X4_minus1)) DEALLOCATE(OutData%X4_minus1)
    ALLOCATE(OutData%X4_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%X4_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%X4_minus1,2), UBOUND(OutData%X4_minus1,2)
        DO i1 = LBOUND(OutData%X4_minus1,1), UBOUND(OutData%X4_minus1,1)
          OutData%X4_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Kprime_alpha_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Kprime_alpha_minus1)) DEALLOCATE(OutData%Kprime_alpha_minus1)
    ALLOCATE(OutData%Kprime_alpha_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Kprime_alpha_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Kprime_alpha_minus1,2), UBOUND(OutData%Kprime_alpha_minus1,2)
        DO i1 = LBOUND(OutData%Kprime_alpha_minus1,1), UBOUND(OutData%Kprime_alpha_minus1,1)
          OutData%Kprime_alpha_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Kprime_q_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Kprime_q_minus1)) DEALLOCATE(OutData%Kprime_q_minus1)
    ALLOCATE(OutData%Kprime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Kprime_q_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Kprime_q_minus1,2), UBOUND(OutData%Kprime_q_minus1,2)
        DO i1 = LBOUND(OutData%Kprime_q_minus1,1), UBOUND(OutData%Kprime_q_minus1,1)
          OutData%Kprime_q_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Kprimeprime_q_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Kprimeprime_q_minus1)) DEALLOCATE(OutData%Kprimeprime_q_minus1)
    ALLOCATE(OutData%Kprimeprime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Kprimeprime_q_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Kprimeprime_q_minus1,2), UBOUND(OutData%Kprimeprime_q_minus1,2)
        DO i1 = LBOUND(OutData%Kprimeprime_q_minus1,1), UBOUND(OutData%Kprimeprime_q_minus1,1)
          OutData%Kprimeprime_q_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! K3prime_q_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%K3prime_q_minus1)) DEALLOCATE(OutData%K3prime_q_minus1)
    ALLOCATE(OutData%K3prime_q_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%K3prime_q_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%K3prime_q_minus1,2), UBOUND(OutData%K3prime_q_minus1,2)
        DO i1 = LBOUND(OutData%K3prime_q_minus1,1), UBOUND(OutData%K3prime_q_minus1,1)
          OutData%K3prime_q_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Dp_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Dp_minus1)) DEALLOCATE(OutData%Dp_minus1)
    ALLOCATE(OutData%Dp_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Dp_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Dp_minus1,2), UBOUND(OutData%Dp_minus1,2)
        DO i1 = LBOUND(OutData%Dp_minus1,1), UBOUND(OutData%Dp_minus1,1)
          OutData%Dp_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cn_pot_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cn_pot_minus1)) DEALLOCATE(OutData%Cn_pot_minus1)
    ALLOCATE(OutData%Cn_pot_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cn_pot_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cn_pot_minus1,2), UBOUND(OutData%Cn_pot_minus1,2)
        DO i1 = LBOUND(OutData%Cn_pot_minus1,1), UBOUND(OutData%Cn_pot_minus1,1)
          OutData%Cn_pot_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprimeprime_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprimeprime_minus1)) DEALLOCATE(OutData%fprimeprime_minus1)
    ALLOCATE(OutData%fprimeprime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprimeprime_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprimeprime_minus1,2), UBOUND(OutData%fprimeprime_minus1,2)
        DO i1 = LBOUND(OutData%fprimeprime_minus1,1), UBOUND(OutData%fprimeprime_minus1,1)
          OutData%fprimeprime_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprimeprime_c_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprimeprime_c_minus1)) DEALLOCATE(OutData%fprimeprime_c_minus1)
    ALLOCATE(OutData%fprimeprime_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprimeprime_c_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprimeprime_c_minus1,2), UBOUND(OutData%fprimeprime_c_minus1,2)
        DO i1 = LBOUND(OutData%fprimeprime_c_minus1,1), UBOUND(OutData%fprimeprime_c_minus1,1)
          OutData%fprimeprime_c_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprimeprime_m_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprimeprime_m_minus1)) DEALLOCATE(OutData%fprimeprime_m_minus1)
    ALLOCATE(OutData%fprimeprime_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprimeprime_m_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprimeprime_m_minus1,2), UBOUND(OutData%fprimeprime_m_minus1,2)
        DO i1 = LBOUND(OutData%fprimeprime_m_minus1,1), UBOUND(OutData%fprimeprime_m_minus1,1)
          OutData%fprimeprime_m_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Df_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Df_minus1)) DEALLOCATE(OutData%Df_minus1)
    ALLOCATE(OutData%Df_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Df_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Df_minus1,2), UBOUND(OutData%Df_minus1,2)
        DO i1 = LBOUND(OutData%Df_minus1,1), UBOUND(OutData%Df_minus1,1)
          OutData%Df_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Df_c_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Df_c_minus1)) DEALLOCATE(OutData%Df_c_minus1)
    ALLOCATE(OutData%Df_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Df_c_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Df_c_minus1,2), UBOUND(OutData%Df_c_minus1,2)
        DO i1 = LBOUND(OutData%Df_c_minus1,1), UBOUND(OutData%Df_c_minus1,1)
          OutData%Df_c_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Df_m_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Df_m_minus1)) DEALLOCATE(OutData%Df_m_minus1)
    ALLOCATE(OutData%Df_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Df_m_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Df_m_minus1,2), UBOUND(OutData%Df_m_minus1,2)
        DO i1 = LBOUND(OutData%Df_m_minus1,1), UBOUND(OutData%Df_m_minus1,1)
          OutData%Df_m_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Dalphaf_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Dalphaf_minus1)) DEALLOCATE(OutData%Dalphaf_minus1)
    ALLOCATE(OutData%Dalphaf_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Dalphaf_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Dalphaf_minus1,2), UBOUND(OutData%Dalphaf_minus1,2)
        DO i1 = LBOUND(OutData%Dalphaf_minus1,1), UBOUND(OutData%Dalphaf_minus1,1)
          OutData%Dalphaf_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alphaf_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alphaf_minus1)) DEALLOCATE(OutData%alphaf_minus1)
    ALLOCATE(OutData%alphaf_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alphaf_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%alphaf_minus1,2), UBOUND(OutData%alphaf_minus1,2)
        DO i1 = LBOUND(OutData%alphaf_minus1,1), UBOUND(OutData%alphaf_minus1,1)
          OutData%alphaf_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprime_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprime_minus1)) DEALLOCATE(OutData%fprime_minus1)
    ALLOCATE(OutData%fprime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprime_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprime_minus1,2), UBOUND(OutData%fprime_minus1,2)
        DO i1 = LBOUND(OutData%fprime_minus1,1), UBOUND(OutData%fprime_minus1,1)
          OutData%fprime_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprime_c_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprime_c_minus1)) DEALLOCATE(OutData%fprime_c_minus1)
    ALLOCATE(OutData%fprime_c_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprime_c_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprime_c_minus1,2), UBOUND(OutData%fprime_c_minus1,2)
        DO i1 = LBOUND(OutData%fprime_c_minus1,1), UBOUND(OutData%fprime_c_minus1,1)
          OutData%fprime_c_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! fprime_m_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%fprime_m_minus1)) DEALLOCATE(OutData%fprime_m_minus1)
    ALLOCATE(OutData%fprime_m_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%fprime_m_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%fprime_m_minus1,2), UBOUND(OutData%fprime_m_minus1,2)
        DO i1 = LBOUND(OutData%fprime_m_minus1,1), UBOUND(OutData%fprime_m_minus1,1)
          OutData%fprime_m_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! tau_V not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%tau_V)) DEALLOCATE(OutData%tau_V)
    ALLOCATE(OutData%tau_V(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%tau_V.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%tau_V,2), UBOUND(OutData%tau_V,2)
        DO i1 = LBOUND(OutData%tau_V,1), UBOUND(OutData%tau_V,1)
          OutData%tau_V(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! tau_V_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%tau_V_minus1)) DEALLOCATE(OutData%tau_V_minus1)
    ALLOCATE(OutData%tau_V_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%tau_V_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%tau_V_minus1,2), UBOUND(OutData%tau_V_minus1,2)
        DO i1 = LBOUND(OutData%tau_V_minus1,1), UBOUND(OutData%tau_V_minus1,1)
          OutData%tau_V_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cn_v_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cn_v_minus1)) DEALLOCATE(OutData%Cn_v_minus1)
    ALLOCATE(OutData%Cn_v_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cn_v_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cn_v_minus1,2), UBOUND(OutData%Cn_v_minus1,2)
        DO i1 = LBOUND(OutData%Cn_v_minus1,1), UBOUND(OutData%Cn_v_minus1,1)
          OutData%Cn_v_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! C_V_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%C_V_minus1)) DEALLOCATE(OutData%C_V_minus1)
    ALLOCATE(OutData%C_V_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%C_V_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%C_V_minus1,2), UBOUND(OutData%C_V_minus1,2)
        DO i1 = LBOUND(OutData%C_V_minus1,1), UBOUND(OutData%C_V_minus1,1)
          OutData%C_V_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cn_prime_minus1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cn_prime_minus1)) DEALLOCATE(OutData%Cn_prime_minus1)
    ALLOCATE(OutData%Cn_prime_minus1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cn_prime_minus1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cn_prime_minus1,2), UBOUND(OutData%Cn_prime_minus1,2)
        DO i1 = LBOUND(OutData%Cn_prime_minus1,1), UBOUND(OutData%Cn_prime_minus1,1)
          OutData%Cn_prime_minus1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_UnPackDiscState

 SUBROUTINE UA_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(UA_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstraintState = SrcConstrStateData%DummyConstraintState
 END SUBROUTINE UA_CopyConstrState

 SUBROUTINE UA_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(UA_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE UA_DestroyConstrState

 SUBROUTINE UA_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstraintState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstraintState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_PackConstrState

 SUBROUTINE UA_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstraintState = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_UnPackConstrState

 SUBROUTINE UA_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(UA_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOtherStateData%FirstPass)) THEN
  i1_l = LBOUND(SrcOtherStateData%FirstPass,1)
  i1_u = UBOUND(SrcOtherStateData%FirstPass,1)
  i2_l = LBOUND(SrcOtherStateData%FirstPass,2)
  i2_u = UBOUND(SrcOtherStateData%FirstPass,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%FirstPass)) THEN 
    ALLOCATE(DstOtherStateData%FirstPass(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%FirstPass.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%FirstPass = SrcOtherStateData%FirstPass
ENDIF
IF (ALLOCATED(SrcOtherStateData%sigma1)) THEN
  i1_l = LBOUND(SrcOtherStateData%sigma1,1)
  i1_u = UBOUND(SrcOtherStateData%sigma1,1)
  i2_l = LBOUND(SrcOtherStateData%sigma1,2)
  i2_u = UBOUND(SrcOtherStateData%sigma1,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%sigma1)) THEN 
    ALLOCATE(DstOtherStateData%sigma1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%sigma1 = SrcOtherStateData%sigma1
ENDIF
IF (ALLOCATED(SrcOtherStateData%sigma1c)) THEN
  i1_l = LBOUND(SrcOtherStateData%sigma1c,1)
  i1_u = UBOUND(SrcOtherStateData%sigma1c,1)
  i2_l = LBOUND(SrcOtherStateData%sigma1c,2)
  i2_u = UBOUND(SrcOtherStateData%sigma1c,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%sigma1c)) THEN 
    ALLOCATE(DstOtherStateData%sigma1c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1c.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%sigma1c = SrcOtherStateData%sigma1c
ENDIF
IF (ALLOCATED(SrcOtherStateData%sigma1m)) THEN
  i1_l = LBOUND(SrcOtherStateData%sigma1m,1)
  i1_u = UBOUND(SrcOtherStateData%sigma1m,1)
  i2_l = LBOUND(SrcOtherStateData%sigma1m,2)
  i2_u = UBOUND(SrcOtherStateData%sigma1m,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%sigma1m)) THEN 
    ALLOCATE(DstOtherStateData%sigma1m(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma1m.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%sigma1m = SrcOtherStateData%sigma1m
ENDIF
IF (ALLOCATED(SrcOtherStateData%sigma3)) THEN
  i1_l = LBOUND(SrcOtherStateData%sigma3,1)
  i1_u = UBOUND(SrcOtherStateData%sigma3,1)
  i2_l = LBOUND(SrcOtherStateData%sigma3,2)
  i2_u = UBOUND(SrcOtherStateData%sigma3,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%sigma3)) THEN 
    ALLOCATE(DstOtherStateData%sigma3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%sigma3.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%sigma3 = SrcOtherStateData%sigma3
ENDIF
IF (ALLOCATED(SrcOtherStateData%n)) THEN
  i1_l = LBOUND(SrcOtherStateData%n,1)
  i1_u = UBOUND(SrcOtherStateData%n,1)
  i2_l = LBOUND(SrcOtherStateData%n,2)
  i2_u = UBOUND(SrcOtherStateData%n,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%n)) THEN 
    ALLOCATE(DstOtherStateData%n(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%n.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%n = SrcOtherStateData%n
ENDIF
    DO i1 = LBOUND(SrcOtherStateData%xdot,1), UBOUND(SrcOtherStateData%xdot,1)
      CALL UA_CopyContState( SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
IF (ALLOCATED(SrcOtherStateData%t_vortexBegin)) THEN
  i1_l = LBOUND(SrcOtherStateData%t_vortexBegin,1)
  i1_u = UBOUND(SrcOtherStateData%t_vortexBegin,1)
  i2_l = LBOUND(SrcOtherStateData%t_vortexBegin,2)
  i2_u = UBOUND(SrcOtherStateData%t_vortexBegin,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%t_vortexBegin)) THEN 
    ALLOCATE(DstOtherStateData%t_vortexBegin(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%t_vortexBegin.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%t_vortexBegin = SrcOtherStateData%t_vortexBegin
ENDIF
IF (ALLOCATED(SrcOtherStateData%SignOfOmega)) THEN
  i1_l = LBOUND(SrcOtherStateData%SignOfOmega,1)
  i1_u = UBOUND(SrcOtherStateData%SignOfOmega,1)
  i2_l = LBOUND(SrcOtherStateData%SignOfOmega,2)
  i2_u = UBOUND(SrcOtherStateData%SignOfOmega,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%SignOfOmega)) THEN 
    ALLOCATE(DstOtherStateData%SignOfOmega(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%SignOfOmega.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%SignOfOmega = SrcOtherStateData%SignOfOmega
ENDIF
IF (ALLOCATED(SrcOtherStateData%PositivePressure)) THEN
  i1_l = LBOUND(SrcOtherStateData%PositivePressure,1)
  i1_u = UBOUND(SrcOtherStateData%PositivePressure,1)
  i2_l = LBOUND(SrcOtherStateData%PositivePressure,2)
  i2_u = UBOUND(SrcOtherStateData%PositivePressure,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%PositivePressure)) THEN 
    ALLOCATE(DstOtherStateData%PositivePressure(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%PositivePressure.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%PositivePressure = SrcOtherStateData%PositivePressure
ENDIF
IF (ALLOCATED(SrcOtherStateData%vortexOn)) THEN
  i1_l = LBOUND(SrcOtherStateData%vortexOn,1)
  i1_u = UBOUND(SrcOtherStateData%vortexOn,1)
  i2_l = LBOUND(SrcOtherStateData%vortexOn,2)
  i2_u = UBOUND(SrcOtherStateData%vortexOn,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%vortexOn)) THEN 
    ALLOCATE(DstOtherStateData%vortexOn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%vortexOn.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%vortexOn = SrcOtherStateData%vortexOn
ENDIF
IF (ALLOCATED(SrcOtherStateData%BelowThreshold)) THEN
  i1_l = LBOUND(SrcOtherStateData%BelowThreshold,1)
  i1_u = UBOUND(SrcOtherStateData%BelowThreshold,1)
  i2_l = LBOUND(SrcOtherStateData%BelowThreshold,2)
  i2_u = UBOUND(SrcOtherStateData%BelowThreshold,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%BelowThreshold)) THEN 
    ALLOCATE(DstOtherStateData%BelowThreshold(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%BelowThreshold.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%BelowThreshold = SrcOtherStateData%BelowThreshold
ENDIF
IF (ALLOCATED(SrcOtherStateData%activeL)) THEN
  i1_l = LBOUND(SrcOtherStateData%activeL,1)
  i1_u = UBOUND(SrcOtherStateData%activeL,1)
  i2_l = LBOUND(SrcOtherStateData%activeL,2)
  i2_u = UBOUND(SrcOtherStateData%activeL,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%activeL)) THEN 
    ALLOCATE(DstOtherStateData%activeL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%activeL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%activeL = SrcOtherStateData%activeL
ENDIF
IF (ALLOCATED(SrcOtherStateData%activeD)) THEN
  i1_l = LBOUND(SrcOtherStateData%activeD,1)
  i1_u = UBOUND(SrcOtherStateData%activeD,1)
  i2_l = LBOUND(SrcOtherStateData%activeD,2)
  i2_u = UBOUND(SrcOtherStateData%activeD,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%activeD)) THEN 
    ALLOCATE(DstOtherStateData%activeD(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%activeD.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%activeD = SrcOtherStateData%activeD
ENDIF
 END SUBROUTINE UA_CopyOtherState

 SUBROUTINE UA_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(UA_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OtherStateData%FirstPass)) THEN
  DEALLOCATE(OtherStateData%FirstPass)
ENDIF
IF (ALLOCATED(OtherStateData%sigma1)) THEN
  DEALLOCATE(OtherStateData%sigma1)
ENDIF
IF (ALLOCATED(OtherStateData%sigma1c)) THEN
  DEALLOCATE(OtherStateData%sigma1c)
ENDIF
IF (ALLOCATED(OtherStateData%sigma1m)) THEN
  DEALLOCATE(OtherStateData%sigma1m)
ENDIF
IF (ALLOCATED(OtherStateData%sigma3)) THEN
  DEALLOCATE(OtherStateData%sigma3)
ENDIF
IF (ALLOCATED(OtherStateData%n)) THEN
  DEALLOCATE(OtherStateData%n)
ENDIF
DO i1 = LBOUND(OtherStateData%xdot,1), UBOUND(OtherStateData%xdot,1)
  CALL UA_DestroyContState( OtherStateData%xdot(i1), ErrStat, ErrMsg )
ENDDO
IF (ALLOCATED(OtherStateData%t_vortexBegin)) THEN
  DEALLOCATE(OtherStateData%t_vortexBegin)
ENDIF
IF (ALLOCATED(OtherStateData%SignOfOmega)) THEN
  DEALLOCATE(OtherStateData%SignOfOmega)
ENDIF
IF (ALLOCATED(OtherStateData%PositivePressure)) THEN
  DEALLOCATE(OtherStateData%PositivePressure)
ENDIF
IF (ALLOCATED(OtherStateData%vortexOn)) THEN
  DEALLOCATE(OtherStateData%vortexOn)
ENDIF
IF (ALLOCATED(OtherStateData%BelowThreshold)) THEN
  DEALLOCATE(OtherStateData%BelowThreshold)
ENDIF
IF (ALLOCATED(OtherStateData%activeL)) THEN
  DEALLOCATE(OtherStateData%activeL)
ENDIF
IF (ALLOCATED(OtherStateData%activeD)) THEN
  DEALLOCATE(OtherStateData%activeD)
ENDIF
 END SUBROUTINE UA_DestroyOtherState

 SUBROUTINE UA_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! FirstPass allocated yes/no
  IF ( ALLOCATED(InData%FirstPass) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FirstPass upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FirstPass)  ! FirstPass
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! sigma1 allocated yes/no
  IF ( ALLOCATED(InData%sigma1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! sigma1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%sigma1)  ! sigma1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! sigma1c allocated yes/no
  IF ( ALLOCATED(InData%sigma1c) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! sigma1c upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%sigma1c)  ! sigma1c
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! sigma1m allocated yes/no
  IF ( ALLOCATED(InData%sigma1m) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! sigma1m upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%sigma1m)  ! sigma1m
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! sigma3 allocated yes/no
  IF ( ALLOCATED(InData%sigma3) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! sigma3 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%sigma3)  ! sigma3
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! n allocated yes/no
  IF ( ALLOCATED(InData%n) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! n upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%n)  ! n
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      Int_BufSz   = Int_BufSz + 3  ! xdot: size of buffers for each call to pack subtype
      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, .TRUE. ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! xdot
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! xdot
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! xdot
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  Int_BufSz   = Int_BufSz   + 1     ! t_vortexBegin allocated yes/no
  IF ( ALLOCATED(InData%t_vortexBegin) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! t_vortexBegin upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%t_vortexBegin)  ! t_vortexBegin
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SignOfOmega allocated yes/no
  IF ( ALLOCATED(InData%SignOfOmega) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! SignOfOmega upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SignOfOmega)  ! SignOfOmega
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PositivePressure allocated yes/no
  IF ( ALLOCATED(InData%PositivePressure) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PositivePressure upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%PositivePressure)  ! PositivePressure
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! vortexOn allocated yes/no
  IF ( ALLOCATED(InData%vortexOn) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! vortexOn upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%vortexOn)  ! vortexOn
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BelowThreshold allocated yes/no
  IF ( ALLOCATED(InData%BelowThreshold) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BelowThreshold upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%BelowThreshold)  ! BelowThreshold
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! activeL allocated yes/no
  IF ( ALLOCATED(InData%activeL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! activeL upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%activeL)  ! activeL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! activeD allocated yes/no
  IF ( ALLOCATED(InData%activeD) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! activeD upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%activeD)  ! activeD
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%FirstPass) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FirstPass,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FirstPass,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FirstPass,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FirstPass,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FirstPass,2), UBOUND(InData%FirstPass,2)
        DO i1 = LBOUND(InData%FirstPass,1), UBOUND(InData%FirstPass,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstPass(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%sigma1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%sigma1,2), UBOUND(InData%sigma1,2)
        DO i1 = LBOUND(InData%sigma1,1), UBOUND(InData%sigma1,1)
          ReKiBuf(Re_Xferred) = InData%sigma1(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%sigma1c) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1c,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1c,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1c,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1c,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%sigma1c,2), UBOUND(InData%sigma1c,2)
        DO i1 = LBOUND(InData%sigma1c,1), UBOUND(InData%sigma1c,1)
          ReKiBuf(Re_Xferred) = InData%sigma1c(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%sigma1m) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1m,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1m,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma1m,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma1m,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%sigma1m,2), UBOUND(InData%sigma1m,2)
        DO i1 = LBOUND(InData%sigma1m,1), UBOUND(InData%sigma1m,1)
          ReKiBuf(Re_Xferred) = InData%sigma1m(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%sigma3) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma3,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma3,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%sigma3,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%sigma3,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%sigma3,2), UBOUND(InData%sigma3,2)
        DO i1 = LBOUND(InData%sigma3,1), UBOUND(InData%sigma3,1)
          ReKiBuf(Re_Xferred) = InData%sigma3(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%n) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%n,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%n,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%n,2), UBOUND(InData%n,2)
        DO i1 = LBOUND(InData%n,1), UBOUND(InData%n,1)
          IntKiBuf(Int_Xferred) = InData%n(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    DO i1 = LBOUND(InData%xdot,1), UBOUND(InData%xdot,1)
      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%xdot(i1), ErrStat2, ErrMsg2, OnlySize ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  IF ( .NOT. ALLOCATED(InData%t_vortexBegin) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t_vortexBegin,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t_vortexBegin,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%t_vortexBegin,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%t_vortexBegin,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%t_vortexBegin,2), UBOUND(InData%t_vortexBegin,2)
        DO i1 = LBOUND(InData%t_vortexBegin,1), UBOUND(InData%t_vortexBegin,1)
          ReKiBuf(Re_Xferred) = InData%t_vortexBegin(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SignOfOmega) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SignOfOmega,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SignOfOmega,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SignOfOmega,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SignOfOmega,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%SignOfOmega,2), UBOUND(InData%SignOfOmega,2)
        DO i1 = LBOUND(InData%SignOfOmega,1), UBOUND(InData%SignOfOmega,1)
          ReKiBuf(Re_Xferred) = InData%SignOfOmega(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PositivePressure) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PositivePressure,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PositivePressure,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PositivePressure,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PositivePressure,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PositivePressure,2), UBOUND(InData%PositivePressure,2)
        DO i1 = LBOUND(InData%PositivePressure,1), UBOUND(InData%PositivePressure,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%PositivePressure(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%vortexOn) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vortexOn,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vortexOn,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%vortexOn,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%vortexOn,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%vortexOn,2), UBOUND(InData%vortexOn,2)
        DO i1 = LBOUND(InData%vortexOn,1), UBOUND(InData%vortexOn,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%vortexOn(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BelowThreshold) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BelowThreshold,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BelowThreshold,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BelowThreshold,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BelowThreshold,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BelowThreshold,2), UBOUND(InData%BelowThreshold,2)
        DO i1 = LBOUND(InData%BelowThreshold,1), UBOUND(InData%BelowThreshold,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%BelowThreshold(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%activeL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%activeL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%activeL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%activeL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%activeL,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%activeL,2), UBOUND(InData%activeL,2)
        DO i1 = LBOUND(InData%activeL,1), UBOUND(InData%activeL,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%activeL(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%activeD) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%activeD,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%activeD,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%activeD,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%activeD,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%activeD,2), UBOUND(InData%activeD,2)
        DO i1 = LBOUND(InData%activeD,1), UBOUND(InData%activeD,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%activeD(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_PackOtherState

 SUBROUTINE UA_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FirstPass not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FirstPass)) DEALLOCATE(OutData%FirstPass)
    ALLOCATE(OutData%FirstPass(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FirstPass.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FirstPass,2), UBOUND(OutData%FirstPass,2)
        DO i1 = LBOUND(OutData%FirstPass,1), UBOUND(OutData%FirstPass,1)
          OutData%FirstPass(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstPass(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! sigma1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%sigma1)) DEALLOCATE(OutData%sigma1)
    ALLOCATE(OutData%sigma1(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%sigma1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%sigma1,2), UBOUND(OutData%sigma1,2)
        DO i1 = LBOUND(OutData%sigma1,1), UBOUND(OutData%sigma1,1)
          OutData%sigma1(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! sigma1c not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%sigma1c)) DEALLOCATE(OutData%sigma1c)
    ALLOCATE(OutData%sigma1c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%sigma1c.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%sigma1c,2), UBOUND(OutData%sigma1c,2)
        DO i1 = LBOUND(OutData%sigma1c,1), UBOUND(OutData%sigma1c,1)
          OutData%sigma1c(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! sigma1m not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%sigma1m)) DEALLOCATE(OutData%sigma1m)
    ALLOCATE(OutData%sigma1m(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%sigma1m.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%sigma1m,2), UBOUND(OutData%sigma1m,2)
        DO i1 = LBOUND(OutData%sigma1m,1), UBOUND(OutData%sigma1m,1)
          OutData%sigma1m(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! sigma3 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%sigma3)) DEALLOCATE(OutData%sigma3)
    ALLOCATE(OutData%sigma3(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%sigma3.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%sigma3,2), UBOUND(OutData%sigma3,2)
        DO i1 = LBOUND(OutData%sigma3,1), UBOUND(OutData%sigma3,1)
          OutData%sigma3(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! n not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%n)) DEALLOCATE(OutData%n)
    ALLOCATE(OutData%n(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%n.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%n,2), UBOUND(OutData%n,2)
        DO i1 = LBOUND(OutData%n,1), UBOUND(OutData%n,1)
          OutData%n(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    i1_l = LBOUND(OutData%xdot,1)
    i1_u = UBOUND(OutData%xdot,1)
    DO i1 = LBOUND(OutData%xdot,1), UBOUND(OutData%xdot,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%xdot(i1), ErrStat2, ErrMsg2 ) ! xdot 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! t_vortexBegin not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%t_vortexBegin)) DEALLOCATE(OutData%t_vortexBegin)
    ALLOCATE(OutData%t_vortexBegin(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%t_vortexBegin.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%t_vortexBegin,2), UBOUND(OutData%t_vortexBegin,2)
        DO i1 = LBOUND(OutData%t_vortexBegin,1), UBOUND(OutData%t_vortexBegin,1)
          OutData%t_vortexBegin(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SignOfOmega not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SignOfOmega)) DEALLOCATE(OutData%SignOfOmega)
    ALLOCATE(OutData%SignOfOmega(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SignOfOmega.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%SignOfOmega,2), UBOUND(OutData%SignOfOmega,2)
        DO i1 = LBOUND(OutData%SignOfOmega,1), UBOUND(OutData%SignOfOmega,1)
          OutData%SignOfOmega(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PositivePressure not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PositivePressure)) DEALLOCATE(OutData%PositivePressure)
    ALLOCATE(OutData%PositivePressure(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PositivePressure.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PositivePressure,2), UBOUND(OutData%PositivePressure,2)
        DO i1 = LBOUND(OutData%PositivePressure,1), UBOUND(OutData%PositivePressure,1)
          OutData%PositivePressure(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%PositivePressure(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! vortexOn not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%vortexOn)) DEALLOCATE(OutData%vortexOn)
    ALLOCATE(OutData%vortexOn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%vortexOn.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%vortexOn,2), UBOUND(OutData%vortexOn,2)
        DO i1 = LBOUND(OutData%vortexOn,1), UBOUND(OutData%vortexOn,1)
          OutData%vortexOn(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%vortexOn(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BelowThreshold not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BelowThreshold)) DEALLOCATE(OutData%BelowThreshold)
    ALLOCATE(OutData%BelowThreshold(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BelowThreshold.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BelowThreshold,2), UBOUND(OutData%BelowThreshold,2)
        DO i1 = LBOUND(OutData%BelowThreshold,1), UBOUND(OutData%BelowThreshold,1)
          OutData%BelowThreshold(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%BelowThreshold(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! activeL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%activeL)) DEALLOCATE(OutData%activeL)
    ALLOCATE(OutData%activeL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%activeL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%activeL,2), UBOUND(OutData%activeL,2)
        DO i1 = LBOUND(OutData%activeL,1), UBOUND(OutData%activeL,1)
          OutData%activeL(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%activeL(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! activeD not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%activeD)) DEALLOCATE(OutData%activeD)
    ALLOCATE(OutData%activeD(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%activeD.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%activeD,2), UBOUND(OutData%activeD,2)
        DO i1 = LBOUND(OutData%activeD,1), UBOUND(OutData%activeD,1)
          OutData%activeD(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%activeD(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_UnPackOtherState

 SUBROUTINE UA_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(UA_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMiscData%FirstWarn_M = SrcMiscData%FirstWarn_M
    DstMiscData%FirstWarn_UA = SrcMiscData%FirstWarn_UA
    DstMiscData%FirstWarn_UA_off = SrcMiscData%FirstWarn_UA_off
IF (ALLOCATED(SrcMiscData%TESF)) THEN
  i1_l = LBOUND(SrcMiscData%TESF,1)
  i1_u = UBOUND(SrcMiscData%TESF,1)
  i2_l = LBOUND(SrcMiscData%TESF,2)
  i2_u = UBOUND(SrcMiscData%TESF,2)
  IF (.NOT. ALLOCATED(DstMiscData%TESF)) THEN 
    ALLOCATE(DstMiscData%TESF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TESF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%TESF = SrcMiscData%TESF
ENDIF
IF (ALLOCATED(SrcMiscData%LESF)) THEN
  i1_l = LBOUND(SrcMiscData%LESF,1)
  i1_u = UBOUND(SrcMiscData%LESF,1)
  i2_l = LBOUND(SrcMiscData%LESF,2)
  i2_u = UBOUND(SrcMiscData%LESF,2)
  IF (.NOT. ALLOCATED(DstMiscData%LESF)) THEN 
    ALLOCATE(DstMiscData%LESF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LESF.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%LESF = SrcMiscData%LESF
ENDIF
IF (ALLOCATED(SrcMiscData%VRTX)) THEN
  i1_l = LBOUND(SrcMiscData%VRTX,1)
  i1_u = UBOUND(SrcMiscData%VRTX,1)
  i2_l = LBOUND(SrcMiscData%VRTX,2)
  i2_u = UBOUND(SrcMiscData%VRTX,2)
  IF (.NOT. ALLOCATED(DstMiscData%VRTX)) THEN 
    ALLOCATE(DstMiscData%VRTX(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%VRTX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%VRTX = SrcMiscData%VRTX
ENDIF
IF (ALLOCATED(SrcMiscData%T_Sh)) THEN
  i1_l = LBOUND(SrcMiscData%T_Sh,1)
  i1_u = UBOUND(SrcMiscData%T_Sh,1)
  i2_l = LBOUND(SrcMiscData%T_Sh,2)
  i2_u = UBOUND(SrcMiscData%T_Sh,2)
  IF (.NOT. ALLOCATED(DstMiscData%T_Sh)) THEN 
    ALLOCATE(DstMiscData%T_Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%T_Sh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%T_Sh = SrcMiscData%T_Sh
ENDIF
IF (ALLOCATED(SrcMiscData%BEDSEP)) THEN
  i1_l = LBOUND(SrcMiscData%BEDSEP,1)
  i1_u = UBOUND(SrcMiscData%BEDSEP,1)
  i2_l = LBOUND(SrcMiscData%BEDSEP,2)
  i2_u = UBOUND(SrcMiscData%BEDSEP,2)
  IF (.NOT. ALLOCATED(DstMiscData%BEDSEP)) THEN 
    ALLOCATE(DstMiscData%BEDSEP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%BEDSEP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%BEDSEP = SrcMiscData%BEDSEP
ENDIF
IF (ALLOCATED(SrcMiscData%weight)) THEN
  i1_l = LBOUND(SrcMiscData%weight,1)
  i1_u = UBOUND(SrcMiscData%weight,1)
  i2_l = LBOUND(SrcMiscData%weight,2)
  i2_u = UBOUND(SrcMiscData%weight,2)
  IF (.NOT. ALLOCATED(DstMiscData%weight)) THEN 
    ALLOCATE(DstMiscData%weight(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%weight.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%weight = SrcMiscData%weight
ENDIF
 END SUBROUTINE UA_CopyMisc

 SUBROUTINE UA_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(UA_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%TESF)) THEN
  DEALLOCATE(MiscData%TESF)
ENDIF
IF (ALLOCATED(MiscData%LESF)) THEN
  DEALLOCATE(MiscData%LESF)
ENDIF
IF (ALLOCATED(MiscData%VRTX)) THEN
  DEALLOCATE(MiscData%VRTX)
ENDIF
IF (ALLOCATED(MiscData%T_Sh)) THEN
  DEALLOCATE(MiscData%T_Sh)
ENDIF
IF (ALLOCATED(MiscData%BEDSEP)) THEN
  DEALLOCATE(MiscData%BEDSEP)
ENDIF
IF (ALLOCATED(MiscData%weight)) THEN
  DEALLOCATE(MiscData%weight)
ENDIF
 END SUBROUTINE UA_DestroyMisc

 SUBROUTINE UA_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_M
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_UA
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_UA_off
  Int_BufSz   = Int_BufSz   + 1     ! TESF allocated yes/no
  IF ( ALLOCATED(InData%TESF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TESF upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%TESF)  ! TESF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LESF allocated yes/no
  IF ( ALLOCATED(InData%LESF) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! LESF upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%LESF)  ! LESF
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! VRTX allocated yes/no
  IF ( ALLOCATED(InData%VRTX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! VRTX upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%VRTX)  ! VRTX
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! T_Sh allocated yes/no
  IF ( ALLOCATED(InData%T_Sh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! T_Sh upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%T_Sh)  ! T_Sh
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BEDSEP allocated yes/no
  IF ( ALLOCATED(InData%BEDSEP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BEDSEP upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%BEDSEP)  ! BEDSEP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! weight allocated yes/no
  IF ( ALLOCATED(InData%weight) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! weight upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%weight)  ! weight
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_M, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_UA, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_UA_off, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%TESF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TESF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TESF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TESF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TESF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TESF,2), UBOUND(InData%TESF,2)
        DO i1 = LBOUND(InData%TESF,1), UBOUND(InData%TESF,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%TESF(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LESF) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LESF,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LESF,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LESF,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LESF,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%LESF,2), UBOUND(InData%LESF,2)
        DO i1 = LBOUND(InData%LESF,1), UBOUND(InData%LESF,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%LESF(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%VRTX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VRTX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VRTX,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VRTX,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VRTX,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%VRTX,2), UBOUND(InData%VRTX,2)
        DO i1 = LBOUND(InData%VRTX,1), UBOUND(InData%VRTX,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%VRTX(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%T_Sh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%T_Sh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%T_Sh,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%T_Sh,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%T_Sh,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%T_Sh,2), UBOUND(InData%T_Sh,2)
        DO i1 = LBOUND(InData%T_Sh,1), UBOUND(InData%T_Sh,1)
          ReKiBuf(Re_Xferred) = InData%T_Sh(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BEDSEP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BEDSEP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BEDSEP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BEDSEP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BEDSEP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BEDSEP,2), UBOUND(InData%BEDSEP,2)
        DO i1 = LBOUND(InData%BEDSEP,1), UBOUND(InData%BEDSEP,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%BEDSEP(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%weight) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%weight,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%weight,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%weight,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%weight,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%weight,2), UBOUND(InData%weight,2)
        DO i1 = LBOUND(InData%weight,1), UBOUND(InData%weight,1)
          ReKiBuf(Re_Xferred) = InData%weight(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_PackMisc

 SUBROUTINE UA_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%FirstWarn_M = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_M)
    Int_Xferred = Int_Xferred + 1
    OutData%FirstWarn_UA = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_UA)
    Int_Xferred = Int_Xferred + 1
    OutData%FirstWarn_UA_off = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_UA_off)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TESF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TESF)) DEALLOCATE(OutData%TESF)
    ALLOCATE(OutData%TESF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TESF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TESF,2), UBOUND(OutData%TESF,2)
        DO i1 = LBOUND(OutData%TESF,1), UBOUND(OutData%TESF,1)
          OutData%TESF(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%TESF(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LESF not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LESF)) DEALLOCATE(OutData%LESF)
    ALLOCATE(OutData%LESF(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LESF.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%LESF,2), UBOUND(OutData%LESF,2)
        DO i1 = LBOUND(OutData%LESF,1), UBOUND(OutData%LESF,1)
          OutData%LESF(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%LESF(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! VRTX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%VRTX)) DEALLOCATE(OutData%VRTX)
    ALLOCATE(OutData%VRTX(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%VRTX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%VRTX,2), UBOUND(OutData%VRTX,2)
        DO i1 = LBOUND(OutData%VRTX,1), UBOUND(OutData%VRTX,1)
          OutData%VRTX(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%VRTX(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! T_Sh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%T_Sh)) DEALLOCATE(OutData%T_Sh)
    ALLOCATE(OutData%T_Sh(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%T_Sh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%T_Sh,2), UBOUND(OutData%T_Sh,2)
        DO i1 = LBOUND(OutData%T_Sh,1), UBOUND(OutData%T_Sh,1)
          OutData%T_Sh(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BEDSEP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BEDSEP)) DEALLOCATE(OutData%BEDSEP)
    ALLOCATE(OutData%BEDSEP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BEDSEP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BEDSEP,2), UBOUND(OutData%BEDSEP,2)
        DO i1 = LBOUND(OutData%BEDSEP,1), UBOUND(OutData%BEDSEP,1)
          OutData%BEDSEP(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%BEDSEP(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! weight not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%weight)) DEALLOCATE(OutData%weight)
    ALLOCATE(OutData%weight(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%weight.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%weight,2), UBOUND(OutData%weight,2)
        DO i1 = LBOUND(OutData%weight,1), UBOUND(OutData%weight,1)
          OutData%weight(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_UnPackMisc

 SUBROUTINE UA_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(UA_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%dt = SrcParamData%dt
IF (ALLOCATED(SrcParamData%c)) THEN
  i1_l = LBOUND(SrcParamData%c,1)
  i1_u = UBOUND(SrcParamData%c,1)
  i2_l = LBOUND(SrcParamData%c,2)
  i2_u = UBOUND(SrcParamData%c,2)
  IF (.NOT. ALLOCATED(DstParamData%c)) THEN 
    ALLOCATE(DstParamData%c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%c.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%c = SrcParamData%c
ENDIF
    DstParamData%numBlades = SrcParamData%numBlades
    DstParamData%nNodesPerBlade = SrcParamData%nNodesPerBlade
    DstParamData%UAMod = SrcParamData%UAMod
    DstParamData%Flookup = SrcParamData%Flookup
    DstParamData%a_s = SrcParamData%a_s
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%OutSwtch = SrcParamData%OutSwtch
    DstParamData%OutFmt = SrcParamData%OutFmt
    DstParamData%OutSFmt = SrcParamData%OutSFmt
    DstParamData%Delim = SrcParamData%Delim
    DstParamData%UnOutFile = SrcParamData%UnOutFile
    DstParamData%ShedEffect = SrcParamData%ShedEffect
    DstParamData%lin_nx = SrcParamData%lin_nx
IF (ALLOCATED(SrcParamData%UA_off_forGood)) THEN
  i1_l = LBOUND(SrcParamData%UA_off_forGood,1)
  i1_u = UBOUND(SrcParamData%UA_off_forGood,1)
  i2_l = LBOUND(SrcParamData%UA_off_forGood,2)
  i2_u = UBOUND(SrcParamData%UA_off_forGood,2)
  IF (.NOT. ALLOCATED(DstParamData%UA_off_forGood)) THEN 
    ALLOCATE(DstParamData%UA_off_forGood(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%UA_off_forGood.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%UA_off_forGood = SrcParamData%UA_off_forGood
ENDIF
 END SUBROUTINE UA_CopyParam

 SUBROUTINE UA_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(UA_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%c)) THEN
  DEALLOCATE(ParamData%c)
ENDIF
IF (ALLOCATED(ParamData%UA_off_forGood)) THEN
  DEALLOCATE(ParamData%UA_off_forGood)
ENDIF
 END SUBROUTINE UA_DestroyParam

 SUBROUTINE UA_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! dt
  Int_BufSz   = Int_BufSz   + 1     ! c allocated yes/no
  IF ( ALLOCATED(InData%c) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! c upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%c)  ! c
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numBlades
      Int_BufSz  = Int_BufSz  + 1  ! nNodesPerBlade
      Int_BufSz  = Int_BufSz  + 1  ! UAMod
      Int_BufSz  = Int_BufSz  + 1  ! Flookup
      Re_BufSz   = Re_BufSz   + 1  ! a_s
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! OutSwtch
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutFmt)  ! OutFmt
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%OutSFmt)  ! OutSFmt
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%Delim)  ! Delim
      Int_BufSz  = Int_BufSz  + 1  ! UnOutFile
      Int_BufSz  = Int_BufSz  + 1  ! ShedEffect
      Int_BufSz  = Int_BufSz  + 1  ! lin_nx
  Int_BufSz   = Int_BufSz   + 1     ! UA_off_forGood allocated yes/no
  IF ( ALLOCATED(InData%UA_off_forGood) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! UA_off_forGood upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%UA_off_forGood)  ! UA_off_forGood
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%dt
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%c) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%c,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%c,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%c,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%c,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%c,2), UBOUND(InData%c,2)
        DO i1 = LBOUND(InData%c,1), UBOUND(InData%c,1)
          ReKiBuf(Re_Xferred) = InData%c(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numBlades
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nNodesPerBlade
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UAMod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Flookup, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%a_s
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%OutSwtch
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%OutFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%OutSFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%OutSFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%Delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%Delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%UnOutFile
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ShedEffect, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%lin_nx
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UA_off_forGood) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UA_off_forGood,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UA_off_forGood,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UA_off_forGood,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UA_off_forGood,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%UA_off_forGood,2), UBOUND(InData%UA_off_forGood,2)
        DO i1 = LBOUND(InData%UA_off_forGood,1), UBOUND(InData%UA_off_forGood,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%UA_off_forGood(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_PackParam

 SUBROUTINE UA_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%dt = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! c not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%c)) DEALLOCATE(OutData%c)
    ALLOCATE(OutData%c(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%c.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%c,2), UBOUND(OutData%c,2)
        DO i1 = LBOUND(OutData%c,1), UBOUND(OutData%c,1)
          OutData%c(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%numBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nNodesPerBlade = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UAMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Flookup = TRANSFER(IntKiBuf(Int_Xferred), OutData%Flookup)
    Int_Xferred = Int_Xferred + 1
    OutData%a_s = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%OutSwtch = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%OutFmt)
      OutData%OutFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%OutSFmt)
      OutData%OutSFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%Delim)
      OutData%Delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%UnOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ShedEffect = TRANSFER(IntKiBuf(Int_Xferred), OutData%ShedEffect)
    Int_Xferred = Int_Xferred + 1
    OutData%lin_nx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UA_off_forGood not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UA_off_forGood)) DEALLOCATE(OutData%UA_off_forGood)
    ALLOCATE(OutData%UA_off_forGood(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA_off_forGood.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%UA_off_forGood,2), UBOUND(OutData%UA_off_forGood,2)
        DO i1 = LBOUND(OutData%UA_off_forGood,1), UBOUND(OutData%UA_off_forGood,1)
          OutData%UA_off_forGood(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%UA_off_forGood(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE UA_UnPackParam

 SUBROUTINE UA_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_InputType), INTENT(IN) :: SrcInputData
   TYPE(UA_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputData%U = SrcInputData%U
    DstInputData%alpha = SrcInputData%alpha
    DstInputData%Re = SrcInputData%Re
    DstInputData%UserProp = SrcInputData%UserProp
    DstInputData%v_ac = SrcInputData%v_ac
    DstInputData%omega = SrcInputData%omega
 END SUBROUTINE UA_CopyInput

 SUBROUTINE UA_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(UA_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE UA_DestroyInput

 SUBROUTINE UA_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! U
      Re_BufSz   = Re_BufSz   + 1  ! alpha
      Re_BufSz   = Re_BufSz   + 1  ! Re
      Re_BufSz   = Re_BufSz   + 1  ! UserProp
      Re_BufSz   = Re_BufSz   + SIZE(InData%v_ac)  ! v_ac
      Re_BufSz   = Re_BufSz   + 1  ! omega
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%U
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%alpha
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Re
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%UserProp
    Re_Xferred = Re_Xferred + 1
    DO i1 = LBOUND(InData%v_ac,1), UBOUND(InData%v_ac,1)
      ReKiBuf(Re_Xferred) = InData%v_ac(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
    ReKiBuf(Re_Xferred) = InData%omega
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_PackInput

 SUBROUTINE UA_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%U = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%alpha = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Re = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%UserProp = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    i1_l = LBOUND(OutData%v_ac,1)
    i1_u = UBOUND(OutData%v_ac,1)
    DO i1 = LBOUND(OutData%v_ac,1), UBOUND(OutData%v_ac,1)
      OutData%v_ac(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
    OutData%omega = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE UA_UnPackInput

 SUBROUTINE UA_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(UA_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(UA_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'UA_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOutputData%Cn = SrcOutputData%Cn
    DstOutputData%Cc = SrcOutputData%Cc
    DstOutputData%Cm = SrcOutputData%Cm
    DstOutputData%Cl = SrcOutputData%Cl
    DstOutputData%Cd = SrcOutputData%Cd
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
 END SUBROUTINE UA_CopyOutput

 SUBROUTINE UA_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(UA_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'UA_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
 END SUBROUTINE UA_DestroyOutput

 SUBROUTINE UA_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(UA_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! Cn
      Re_BufSz   = Re_BufSz   + 1  ! Cc
      Re_BufSz   = Re_BufSz   + 1  ! Cm
      Re_BufSz   = Re_BufSz   + 1  ! Cl
      Re_BufSz   = Re_BufSz   + 1  ! Cd
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%Cn
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cm
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cl
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Cd
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE UA_PackOutput

 SUBROUTINE UA_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(UA_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'UA_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Cn = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cm = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cl = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%Cd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE UA_UnPackOutput


 SUBROUTINE UA_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(UA_InputType), INTENT(IN)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(UA_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'UA_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL UA_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL UA_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL UA_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE UA_Input_ExtrapInterp


 SUBROUTINE UA_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(UA_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
 TYPE(UA_InputType), INTENT(IN)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(UA_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'UA_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
  b = -(u1%U - u2%U)
  u_out%U = u1%U + b * ScaleFactor
  CALL Angles_ExtrapInterp( u1%alpha, u2%alpha, tin, u_out%alpha, tin_out )
  b = -(u1%Re - u2%Re)
  u_out%Re = u1%Re + b * ScaleFactor
  b = -(u1%UserProp - u2%UserProp)
  u_out%UserProp = u1%UserProp + b * ScaleFactor
  DO i1 = LBOUND(u_out%v_ac,1),UBOUND(u_out%v_ac,1)
    b = -(u1%v_ac(i1) - u2%v_ac(i1))
    u_out%v_ac(i1) = u1%v_ac(i1) + b * ScaleFactor
  END DO
  b = -(u1%omega - u2%omega)
  u_out%omega = u1%omega + b * ScaleFactor
 END SUBROUTINE UA_Input_ExtrapInterp1


 SUBROUTINE UA_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(UA_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
 TYPE(UA_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
 TYPE(UA_InputType), INTENT(IN)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(UA_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'UA_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
  b = (t(3)**2*(u1%U - u2%U) + t(2)**2*(-u1%U + u3%U))* scaleFactor
  c = ( (t(2)-t(3))*u1%U + t(3)*u2%U - t(2)*u3%U ) * scaleFactor
  u_out%U = u1%U + b  + c * t_out
  CALL Angles_ExtrapInterp( u1%alpha, u2%alpha, u3%alpha, tin, u_out%alpha, tin_out )
  b = (t(3)**2*(u1%Re - u2%Re) + t(2)**2*(-u1%Re + u3%Re))* scaleFactor
  c = ( (t(2)-t(3))*u1%Re + t(3)*u2%Re - t(2)*u3%Re ) * scaleFactor
  u_out%Re = u1%Re + b  + c * t_out
  b = (t(3)**2*(u1%UserProp - u2%UserProp) + t(2)**2*(-u1%UserProp + u3%UserProp))* scaleFactor
  c = ( (t(2)-t(3))*u1%UserProp + t(3)*u2%UserProp - t(2)*u3%UserProp ) * scaleFactor
  u_out%UserProp = u1%UserProp + b  + c * t_out
  DO i1 = LBOUND(u_out%v_ac,1),UBOUND(u_out%v_ac,1)
    b = (t(3)**2*(u1%v_ac(i1) - u2%v_ac(i1)) + t(2)**2*(-u1%v_ac(i1) + u3%v_ac(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%v_ac(i1) + t(3)*u2%v_ac(i1) - t(2)*u3%v_ac(i1) ) * scaleFactor
    u_out%v_ac(i1) = u1%v_ac(i1) + b  + c * t_out
  END DO
  b = (t(3)**2*(u1%omega - u2%omega) + t(2)**2*(-u1%omega + u3%omega))* scaleFactor
  c = ( (t(2)-t(3))*u1%omega + t(3)*u2%omega - t(2)*u3%omega ) * scaleFactor
  u_out%omega = u1%omega + b  + c * t_out
 END SUBROUTINE UA_Input_ExtrapInterp2


 SUBROUTINE UA_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(UA_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(UA_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'UA_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL UA_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL UA_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL UA_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE UA_Output_ExtrapInterp


 SUBROUTINE UA_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(UA_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(UA_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(UA_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'UA_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
  b = -(y1%Cn - y2%Cn)
  y_out%Cn = y1%Cn + b * ScaleFactor
  b = -(y1%Cc - y2%Cc)
  y_out%Cc = y1%Cc + b * ScaleFactor
  b = -(y1%Cm - y2%Cm)
  y_out%Cm = y1%Cm + b * ScaleFactor
  b = -(y1%Cl - y2%Cl)
  y_out%Cl = y1%Cl + b * ScaleFactor
  b = -(y1%Cd - y2%Cd)
  y_out%Cd = y1%Cd + b * ScaleFactor
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE UA_Output_ExtrapInterp1


 SUBROUTINE UA_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(UA_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(UA_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(UA_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(UA_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'UA_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
  b = (t(3)**2*(y1%Cn - y2%Cn) + t(2)**2*(-y1%Cn + y3%Cn))* scaleFactor
  c = ( (t(2)-t(3))*y1%Cn + t(3)*y2%Cn - t(2)*y3%Cn ) * scaleFactor
  y_out%Cn = y1%Cn + b  + c * t_out
  b = (t(3)**2*(y1%Cc - y2%Cc) + t(2)**2*(-y1%Cc + y3%Cc))* scaleFactor
  c = ( (t(2)-t(3))*y1%Cc + t(3)*y2%Cc - t(2)*y3%Cc ) * scaleFactor
  y_out%Cc = y1%Cc + b  + c * t_out
  b = (t(3)**2*(y1%Cm - y2%Cm) + t(2)**2*(-y1%Cm + y3%Cm))* scaleFactor
  c = ( (t(2)-t(3))*y1%Cm + t(3)*y2%Cm - t(2)*y3%Cm ) * scaleFactor
  y_out%Cm = y1%Cm + b  + c * t_out
  b = (t(3)**2*(y1%Cl - y2%Cl) + t(2)**2*(-y1%Cl + y3%Cl))* scaleFactor
  c = ( (t(2)-t(3))*y1%Cl + t(3)*y2%Cl - t(2)*y3%Cl ) * scaleFactor
  y_out%Cl = y1%Cl + b  + c * t_out
  b = (t(3)**2*(y1%Cd - y2%Cd) + t(2)**2*(-y1%Cd + y3%Cd))* scaleFactor
  c = ( (t(2)-t(3))*y1%Cd + t(3)*y2%Cd - t(2)*y3%Cd ) * scaleFactor
  y_out%Cd = y1%Cd + b  + c * t_out
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE UA_Output_ExtrapInterp2

END MODULE UnsteadyAero_Types
!ENDOFREGISTRYGENERATEDFILE
