!STARTOFREGISTRYGENERATEDFILE 'FVW_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FVW_Types
!.................................................................................................................................
! This file is part of FVW.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FVW. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FVW_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE UnsteadyAero_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: idGridVelocity = 1      ! Grid stores velocity field [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: idGridVelVorticity = 2      ! Grid stores velocity and vorticity [-]
! =========  GridOutType  =======
  TYPE, PUBLIC :: GridOutType
    CHARACTER(100)  :: name      !< Grid name [-]
    INTEGER(IntKi)  :: type      !< Grid type [-]
    REAL(ReKi)  :: tStart      !< Time at which outputs starts [-]
    REAL(ReKi)  :: tEnd      !< Time at which outputs ends [-]
    REAL(ReKi)  :: DTout      !< Output frequency of grid [-]
    REAL(ReKi)  :: xStart      !< xStart [-]
    REAL(ReKi)  :: yStart      !< yStart [-]
    REAL(ReKi)  :: zStart      !< zStart [-]
    REAL(ReKi)  :: xEnd      !< xEnd [-]
    REAL(ReKi)  :: yEnd      !< yEnd [-]
    REAL(ReKi)  :: zEnd      !< zEnd [-]
    INTEGER(IntKi)  :: nx      !< nx [-]
    INTEGER(IntKi)  :: ny      !< ny [-]
    INTEGER(IntKi)  :: nz      !< nz [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: uGrid      !< Grid velocity 3 x nz x ny x nx [-]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: omGrid      !< Grid vorticity 3 x nz x ny x nx [-]
    REAL(DbKi)  :: tLastOutput      !< Last output time [-]
  END TYPE GridOutType
! =======================
! =========  T_Sgmt  =======
  TYPE, PUBLIC :: T_Sgmt
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Points      !< Points delimiting the segments [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Connct      !< Connectivity of segments [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Gamma      !< Segment circulations [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Epsilon      !< Segment regularization parameter [-]
    INTEGER(IntKi)  :: RegFunction      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: nAct      !< Number of active segments [-]
    INTEGER(IntKi)  :: nActP      !< Number of active segment points [-]
  END TYPE T_Sgmt
! =======================
! =========  Wng_ParameterType  =======
  TYPE, PUBLIC :: Wng_ParameterType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord_LL      !< Chord of each blade element from input file [idx1=BladeNode, idx2=Blade number] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord_CP      !< Chord on LL cp  [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s_LL      !< Spanwise coordinate of LL elements [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: s_CP      !< Spanwise coordinate of LL CP [m]
    INTEGER(IntKi)  :: iRotor      !< Index of rotor the wing belong to [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index to the airfoils from AD15 [BladeNode,BladeIndex=1] [-]
    INTEGER(IntKi)  :: nSpan      !< TODO, should be defined per wing. Number of spanwise element [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PrescribedCirculation      !< Prescribed circulation on all lifting lines [m/s]
  END TYPE Wng_ParameterType
! =======================
! =========  FVW_ParameterType  =======
  TYPE, PUBLIC :: FVW_ParameterType
    INTEGER(IntKi)  :: nRotors      !< Number of Wings [-]
    INTEGER(IntKi)  :: nWings      !< Number of Wings [-]
    TYPE(Wng_ParameterType) , DIMENSION(:), ALLOCATABLE  :: W      !< Wings parameters [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Bld2Wings      !< Index mapping from blades to wings [-]
    INTEGER(IntKi)  :: iNWStart      !< Index where NW start in r_NW. (iNWStart=2, the first panel contains the lifting line panel, otherwise, start at 1) [-]
    INTEGER(IntKi)  :: nNWMax      !< Maximum number of nw panels, per wing [-]
    INTEGER(IntKi)  :: nFWMax      !< Maximum number of fw panels, per wing [-]
    INTEGER(IntKi)  :: nFWFree      !< Number of fw panels that are free, per wing [-]
    LOGICAL  :: FWShedVorticity      !< Include shed vorticity in the far wake [-]
    INTEGER(IntKi)  :: IntMethod      !< Integration Method (1=RK4, 2=AB4, 3=ABM4, 5=Euler1) [-]
    REAL(ReKi)  :: FreeWakeStart      !< Time when wake starts convecting (rolling up) [s]
    REAL(ReKi)  :: FullCirculationStart      !< Time when the circulation is full [s]
    INTEGER(IntKi)  :: CirculationMethod      !< Method to determine the circulation [-]
    INTEGER(IntKi)  :: CircSolvMaxIter      !< Maximum number of iterations for circulation solving [-]
    REAL(ReKi)  :: CircSolvConvCrit      !< Convergence criterion for circulation solving [-]
    REAL(ReKi)  :: CircSolvRelaxation      !< Relaxation factor for circulation solving [-]
    INTEGER(IntKi)  :: CircSolvPolar      !< (0=Use AD polars, 1=2PiAlpha, 2=sin(2pialpha) [-]
    INTEGER(IntKi)  :: DiffusionMethod      !< Diffusion method (None, CoreSpreading, PSE) [-]
    REAL(ReKi)  :: CoreSpreadEddyVisc      !< Eddy viscosity used in the core spreading method [-]
    INTEGER(IntKi)  :: RegDeterMethod      !< Regularization determinatino method (manual, automatic) [-]
    INTEGER(IntKi)  :: RegFunction      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: WakeRegMethod      !< Method for regularization (constant, stretching, age, etc.) [-]
    REAL(ReKi)  :: WakeRegParam      !< Initial value of the regularization parameter [-]
    REAL(ReKi)  :: WingRegParam      !< Regularization parameter of the wing [-]
    INTEGER(IntKi)  :: ShearModel      !< Option for shear modelling [-]
    LOGICAL  :: TwrShadowOnWake      !< Include tower shadow effects on wake [-]
    INTEGER(IntKi)  :: VelocityMethod      !< Velocity calculation method [-]
    REAL(ReKi)  :: TreeBranchFactor      !< Factor used to determine if a point is far enough [-]
    INTEGER(IntKi)  :: PartPerSegment      !< Number of particles per segment, e.g. for tree method [-]
    REAL(DbKi)  :: DTaero      !< Time interval for calls calculations [s]
    REAL(DbKi)  :: DTfvw      !< Time interval for calculating wake induced velocities [s]
    REAL(ReKi)  :: KinVisc      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: WrVTK      !< Outputs VTK at each calcoutput call, even if main fst doesnt do it [-]
    INTEGER(IntKi)  :: VTKBlades      !< Outputs VTk for each blade 0=no blade, 1=Bld 1 [-]
    REAL(DbKi)  :: DTvtk      !< DT between vtk writes [s]
    INTEGER(IntKi)  :: VTKCoord      !< Switch for VTK outputs coordinate  system [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    CHARACTER(1024)  :: VTK_OutFileRoot      !< Rootdirectory for writing VTK files [-]
    CHARACTER(1024)  :: VTK_OutFileBase      !< Basename for writing VTK files [-]
    INTEGER(IntKi)  :: nGridOut      !< Number of VTK grid to output [-]
    LOGICAL  :: InductionAtCP      !< Compute induced velocities at nodes or CP [-]
    LOGICAL  :: WakeAtTE      !< Start the wake at the trailing edge, or at the LL [-]
    LOGICAL  :: DStallOnWake      !< Dynamic stall has influence on wake [-]
    LOGICAL  :: Induction      !< Compute induction [-]
  END TYPE FVW_ParameterType
! =======================
! =========  Wng_ContinuousStateType  =======
  TYPE, PUBLIC :: Wng_ContinuousStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Gamma_NW      !< Circulation of the near wake panels (    nSpan     x nNW  ) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Gamma_FW      !< Circulation of the far  wake panels (    nFWSpan   x nFW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Eps_NW      !< Reg param   of the near wake panels (3 x nSpan     x nNW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Eps_FW      !< Reg param   of the far  wake panels (3 x nFWSpan   x nFW  ) [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_NW      !< Position    of the near wake panels (3 x nSpan+1   x nNW+1)  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_FW      !< Position    of the far  wake panels (3 x nFWSpan+1 x nFW+1) [-]
  END TYPE Wng_ContinuousStateType
! =======================
! =========  FVW_ContinuousStateType  =======
  TYPE, PUBLIC :: FVW_ContinuousStateType
    TYPE(Wng_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: W      !< Circulation of the near wake panels (    nSpan     x nNW ) [-]
    TYPE(UA_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< states for UnsteadyAero [-]
  END TYPE FVW_ContinuousStateType
! =======================
! =========  Wng_OutputType  =======
  TYPE, PUBLIC :: Wng_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind      !< TODO mesh  - Induced velocity vector at AeroDyn nodes.  [-]
  END TYPE Wng_OutputType
! =======================
! =========  FVW_OutputType  =======
  TYPE, PUBLIC :: FVW_OutputType
    TYPE(Wng_OutputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Induced velocity vector at AeroDyn nodes for all wings.  [-]
  END TYPE FVW_OutputType
! =======================
! =========  Wng_MiscVarType  =======
  TYPE, PUBLIC :: Wng_MiscVarType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: LE      !< Leading edge points [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TE      !< Trailing edge points [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: r_LL      !< Position    of the Lifting line panels [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CP      !< Coordinates of LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Tang      !< Unit Tangential vector on LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Norm      !< Unit Normal vector on LL CP     [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Orth      !< Unit Orthogonal vector on LL CP [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: dl      !< Vector of elementary length along the LL [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Area      !< Area of each LL panel [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: diag_LL      !< Diagonal length of each LL panel [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind_CP      !< Induced velocity on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vtot_CP      !< Total velocity on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vstr_CP      !< Structural velocity on LL CP [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vwnd_CP      !< Wind on lifting line control points [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vwnd_NW      !< Wind on near wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vwnd_FW      !< Wind on far  wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vind_NW      !< Induced velocity on near wake panels [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vind_FW      !< Induced velocity on far  wake panels [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: PitchAndTwist      !< Twist angle (includes all sources of twist)  [Array of size (NumBlNds,numBlades)] [rad]
    INTEGER(IntKi)  :: iTip      !< Index where tip vorticity will be placed. TODO, per blade [-]
    INTEGER(IntKi)  :: iRoot      !< Index where root vorticity will be placed [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: alpha_LL      !< Angle of attack at lifting line CP, only computed with CircPolarData method [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Vreln_LL      !< Norm of Vrel on the lifting line [-]
    TYPE(UA_InputType) , DIMENSION(:,:), ALLOCATABLE  :: u_UA      !< inputs to UnsteadyAero  numNode x 2 (t and t+dt) [-]
    TYPE(UA_MiscVarType)  :: m_UA      !< misc vars for UnsteadyAero [-]
    TYPE(UA_OutputType)  :: y_UA      !< outputs from UnsteadyAero [-]
    TYPE(UA_ParameterType)  :: p_UA      !< parameters for UnsteadyAero [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vind_LL      !< Induced velocity on lifting line nodes [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_AxInd      !< Axial induction [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_TanInd      !< Tangential induction [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Vrel      !< Relative velocity [size (NumBlNds,numBlades)] [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_alpha      !< Angle of attack [size (NumBlNds,numBlades)] [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_phi      !< angle between the plane of rotation and the direction of the local wind [size (NumBlNds,numBlades)] [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Re      !< Reynolds number [size (NumBlNds,numBlades)] [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BN_URelWind_s      !< Relative wind velocity in section coordinates [size (3,NumBlNds,numBlades)] [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cl_Static      !< Coefficient lift,   excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cd_Static      !< Coefficient drag.   excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cm_Static      !< Coefficient moment, excluding unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cl      !< Coefficient lift,   including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cd      !< Coefficient drag,   including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cm      !< Coefficient moment, including unsteady aero effects [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cx      !< normal force coefficient (normal to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BN_Cy      !< tangential force coefficient (tangential to the plane, not chord) of the jth node in the kth blade [-]
  END TYPE Wng_MiscVarType
! =======================
! =========  FVW_MiscVarType  =======
  TYPE, PUBLIC :: FVW_MiscVarType
    TYPE(Wng_MiscVarType) , DIMENSION(:), ALLOCATABLE  :: W      !< Misc for all wings [-]
    LOGICAL  :: FirstCall      !< True if this is the first call to update state (used in CalcOutput) [-]
    INTEGER(IntKi)  :: nNW      !< Number of active near wake panels [-]
    INTEGER(IntKi)  :: nFW      !< Number of active far  wake panels [-]
    INTEGER(IntKi)  :: iStep      !< Current step number used for update state [-]
    INTEGER(IntKi)  :: VTKstep      !< Current vtk output step number [-]
    REAL(DbKi)  :: VTKlastTime      !< Time the last VTK file set was written out [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: r_wind      !< List of points where wind is requested for next time step [-]
    LOGICAL  :: ComputeWakeInduced      !< Compute induced velocities on this timestep [-]
    REAL(DbKi)  :: OldWakeTime      !< Time the wake induction velocities were last calculated [s]
    TYPE(FVW_ContinuousStateType)  :: dxdt      !< State time derivatie, stored for overcycling and convenience [-]
    TYPE(FVW_ContinuousStateType)  :: x1      !< States at t (for overcycling)  [-]
    TYPE(FVW_ContinuousStateType)  :: x2      !< States at t+DTFVW (for overcycling) [-]
    REAL(DbKi)  :: t1      !< Time of x1 (for overcycling)  [-]
    REAL(DbKi)  :: t2      !< Time of x2 t+DTFVW (for overcycling) [-]
    LOGICAL  :: UA_Flag      !< logical flag indicating whether to use UnsteadyAero [-]
    TYPE(T_Sgmt)  :: Sgmt      !< Segments storage [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CPs      !< Control points used for wake rollup computation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Uind      !< Induced velocities obtained at control points [-]
    TYPE(GridOutType) , DIMENSION(:), ALLOCATABLE  :: GridOutputs      !< Number of VTK grid to output [-]
  END TYPE FVW_MiscVarType
! =======================
! =========  Rot_InputType  =======
  TYPE, PUBLIC :: Rot_InputType
    REAL(ReKi) , DIMENSION(1:3,1:3)  :: HubOrientation      !< Orientation of hub coordinate system (for output only) [-]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition      !< Origin of hub (for output only) [-]
  END TYPE Rot_InputType
! =======================
! =========  Wng_InputType  =======
  TYPE, PUBLIC :: Wng_InputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vwnd_LL      !< Disturbed wind at LL mesh points (not CP), for UA only [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: omega_z      !< rotation of no-sweep-pitch-twist coordinate system around z (for CDBEMT and CUA) [rad/s]
  END TYPE Wng_InputType
! =======================
! =========  FVW_InputType  =======
  TYPE, PUBLIC :: FVW_InputType
    TYPE(Rot_InputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Rotors inputs [-]
    TYPE(Wng_InputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Wings inputs [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: WingsMesh      !< Input Mesh defining position and orientation of wings (nSpan+1)  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: V_wind      !< Wind at requested points (r_wind) [-]
  END TYPE FVW_InputType
! =======================
! =========  FVW_DiscreteStateType  =======
  TYPE, PUBLIC :: FVW_DiscreteStateType
    REAL(ReKi)  :: NULL      !< Empty to satisfy framework [-]
    TYPE(UA_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< states for UnsteadyAero for each Wing [-]
  END TYPE FVW_DiscreteStateType
! =======================
! =========  Wng_ConstraintStateType  =======
  TYPE, PUBLIC :: Wng_ConstraintStateType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Gamma_LL      !< Circulation on the wing lifting line [-]
  END TYPE Wng_ConstraintStateType
! =======================
! =========  FVW_ConstraintStateType  =======
  TYPE, PUBLIC :: FVW_ConstraintStateType
    TYPE(Wng_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: W      !< rotors constr. states [-]
    REAL(ReKi)  :: residual      !< Residual [-]
  END TYPE FVW_ConstraintStateType
! =======================
! =========  FVW_OtherStateType  =======
  TYPE, PUBLIC :: FVW_OtherStateType
    INTEGER(IntKi)  :: NULL      !< Number of active near wake panels [-]
    TYPE(UA_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: UA      !< other states for UnsteadyAero for each wing [-]
  END TYPE FVW_OtherStateType
! =======================
! =========  Wng_InitInputType  =======
  TYPE, PUBLIC :: Wng_InitInputType
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index to the airfoils from AD15 [idx1=BladeNode, idx2=Blade number=1] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: chord      !< Chord of each blade element from input file [idx1=BladeNode, idx2=Blade number] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: RElm      !< radius of center of each element [-]
    INTEGER(IntKi)  :: iRotor      !< Index of rotor the wing belong to [-]
    INTEGER(IntKi)  :: UAOff_innerNode      !< Last node on each blade where UA should be turned off based on span location from blade root (0 if always on) [-]
    INTEGER(IntKi)  :: UAOff_outerNode      !< First node on each blade where UA should be turned off based on span location from blade tip (>nNodesPerBlade if always on) [-]
  END TYPE Wng_InitInputType
! =======================
! =========  FVW_InitInputType  =======
  TYPE, PUBLIC :: FVW_InitInputType
    CHARACTER(1024)  :: FVWFileName      !< Main FVW input file name [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(Wng_InitInputType) , DIMENSION(:), ALLOCATABLE  :: W      !< Number of blades [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: WingsMesh      !< Input Mesh defining position and orientation of wings (nSpan+1)  [-]
    INTEGER(IntKi)  :: numBladeNodes      !< Number of nodes on each blade [-]
    REAL(DbKi)  :: DTaero      !< Time interval for calls (from AD15) [s]
    REAL(ReKi)  :: KinVisc      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: UAMod      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    LOGICAL  :: UA_Flag      !< logical flag indicating whether to use UnsteadyAero [-]
    LOGICAL  :: Flookup      !< Use table lookup for f' and f''  [-]
    REAL(ReKi)  :: a_s      !< speed of sound [m/s]
    LOGICAL  :: SumPrint      !< Whether to print summary file (primarially in in UA) [-]
  END TYPE FVW_InitInputType
! =======================
! =========  FVW_InputFile  =======
  TYPE, PUBLIC :: FVW_InputFile
    INTEGER(IntKi)  :: CirculationMethod      !< Method to determine the circulation [-]
    CHARACTER(1024)  :: CirculationFile      !< Prescribed circulation file [-]
    INTEGER(IntKi)  :: CircSolvMaxIter      !< Maximum number of iterations for circulation solving [-]
    REAL(ReKi)  :: CircSolvConvCrit      !< Convergence criterion for circulation solving [-]
    REAL(ReKi)  :: CircSolvRelaxation      !< Relaxation factor for circulation solving [-]
    INTEGER(IntKi)  :: IntMethod      !< Integration Method (1=RK4, 2=AB4, 3=ABM4, 5=Euler1, 7=Corrector/Predictor) [-]
    LOGICAL  :: FreeWake      !< Disable roll up, wake convects with wind only (flag) [-]
    REAL(ReKi)  :: FreeWakeStart      !< Time when wake starts convecting (rolling up) [s]
    REAL(ReKi)  :: FullCirculationStart      !< Time when the circulation is full [s]
    REAL(DbKi)  :: DTfvw      !< Time interval for calculating wake induced velocities [s]
    INTEGER(IntKi)  :: CircSolvPolar      !< (0=Use AD polars, 1=2PiAlpha, 2=sin(2pialpha) [-]
    INTEGER(IntKi)  :: nNWPanels      !< Number of nw panels [-]
    INTEGER(IntKi)  :: nFWPanels      !< Number of fw panels [-]
    INTEGER(IntKi)  :: nFWPanelsFree      !< Number of fw panels that are free [-]
    LOGICAL  :: FWShedVorticity      !< Include shed vorticity in the far wake [-]
    INTEGER(IntKi)  :: DiffusionMethod      !< Diffusion method (None, CoreSpreading, PSE) [-]
    REAL(ReKi)  :: CoreSpreadEddyVisc      !< Eddy viscosity used in the core spreading method [-]
    INTEGER(IntKi)  :: RegDeterMethod      !< Regularization determinatino method (manual, automatic) [-]
    INTEGER(IntKi)  :: RegFunction      !< Type of regularizaion function (LambOseen, Vatistas, see FVW_BiotSavart) [-]
    INTEGER(IntKi)  :: WakeRegMethod      !< Method for regularization (constant, stretching, age, etc.) [-]
    REAL(ReKi)  :: WakeRegParam      !< Factor used in the regularization  [-]
    REAL(ReKi)  :: WingRegParam      !< Factor used in the regularization  [-]
    INTEGER(IntKi)  :: ShearModel      !< Option for shear modelling [-]
    LOGICAL  :: TwrShadowOnWake      !< Include tower shadow effects on wake [-]
    INTEGER(IntKi)  :: VelocityMethod      !< Velocity calculation method [-]
    REAL(ReKi)  :: TreeBranchFactor      !< Factor used to determine if a point is far enough [-]
    INTEGER(IntKi)  :: PartPerSegment      !< Number of particles per segment, e.g. for tree method [-]
    INTEGER(IntKi)  :: WrVTK      !< Outputs VTK at each calcoutput call, even if main fst doesnt do it [-]
    INTEGER(IntKi)  :: VTKBlades      !< Outputs VTk for each blade 0=no blade, 1=Bld 1 [-]
    REAL(DbKi)  :: DTvtk      !< Requested timestep between VTK outputs (calculated from the VTK_fps read in) [s]
    INTEGER(IntKi)  :: VTKCoord      !< Switch for VTK outputs coordinate  system [-]
  END TYPE FVW_InputFile
! =======================
! =========  FVW_InitOutputType  =======
  TYPE, PUBLIC :: FVW_InitOutputType
    INTEGER(IntKi)  :: Null      !< Empty parameter to satisfy framework [-]
  END TYPE FVW_InitOutputType
! =======================
CONTAINS
 SUBROUTINE FVW_CopyGridOutType( SrcGridOutTypeData, DstGridOutTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(GridOutType), INTENT(IN) :: SrcGridOutTypeData
   TYPE(GridOutType), INTENT(INOUT) :: DstGridOutTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyGridOutType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstGridOutTypeData%name = SrcGridOutTypeData%name
    DstGridOutTypeData%type = SrcGridOutTypeData%type
    DstGridOutTypeData%tStart = SrcGridOutTypeData%tStart
    DstGridOutTypeData%tEnd = SrcGridOutTypeData%tEnd
    DstGridOutTypeData%DTout = SrcGridOutTypeData%DTout
    DstGridOutTypeData%xStart = SrcGridOutTypeData%xStart
    DstGridOutTypeData%yStart = SrcGridOutTypeData%yStart
    DstGridOutTypeData%zStart = SrcGridOutTypeData%zStart
    DstGridOutTypeData%xEnd = SrcGridOutTypeData%xEnd
    DstGridOutTypeData%yEnd = SrcGridOutTypeData%yEnd
    DstGridOutTypeData%zEnd = SrcGridOutTypeData%zEnd
    DstGridOutTypeData%nx = SrcGridOutTypeData%nx
    DstGridOutTypeData%ny = SrcGridOutTypeData%ny
    DstGridOutTypeData%nz = SrcGridOutTypeData%nz
IF (ALLOCATED(SrcGridOutTypeData%uGrid)) THEN
  i1_l = LBOUND(SrcGridOutTypeData%uGrid,1)
  i1_u = UBOUND(SrcGridOutTypeData%uGrid,1)
  i2_l = LBOUND(SrcGridOutTypeData%uGrid,2)
  i2_u = UBOUND(SrcGridOutTypeData%uGrid,2)
  i3_l = LBOUND(SrcGridOutTypeData%uGrid,3)
  i3_u = UBOUND(SrcGridOutTypeData%uGrid,3)
  i4_l = LBOUND(SrcGridOutTypeData%uGrid,4)
  i4_u = UBOUND(SrcGridOutTypeData%uGrid,4)
  IF (.NOT. ALLOCATED(DstGridOutTypeData%uGrid)) THEN 
    ALLOCATE(DstGridOutTypeData%uGrid(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstGridOutTypeData%uGrid.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstGridOutTypeData%uGrid = SrcGridOutTypeData%uGrid
ENDIF
IF (ALLOCATED(SrcGridOutTypeData%omGrid)) THEN
  i1_l = LBOUND(SrcGridOutTypeData%omGrid,1)
  i1_u = UBOUND(SrcGridOutTypeData%omGrid,1)
  i2_l = LBOUND(SrcGridOutTypeData%omGrid,2)
  i2_u = UBOUND(SrcGridOutTypeData%omGrid,2)
  i3_l = LBOUND(SrcGridOutTypeData%omGrid,3)
  i3_u = UBOUND(SrcGridOutTypeData%omGrid,3)
  i4_l = LBOUND(SrcGridOutTypeData%omGrid,4)
  i4_u = UBOUND(SrcGridOutTypeData%omGrid,4)
  IF (.NOT. ALLOCATED(DstGridOutTypeData%omGrid)) THEN 
    ALLOCATE(DstGridOutTypeData%omGrid(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstGridOutTypeData%omGrid.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstGridOutTypeData%omGrid = SrcGridOutTypeData%omGrid
ENDIF
    DstGridOutTypeData%tLastOutput = SrcGridOutTypeData%tLastOutput
 END SUBROUTINE FVW_CopyGridOutType

 SUBROUTINE FVW_DestroyGridOutType( GridOutTypeData, ErrStat, ErrMsg )
  TYPE(GridOutType), INTENT(INOUT) :: GridOutTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyGridOutType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(GridOutTypeData%uGrid)) THEN
  DEALLOCATE(GridOutTypeData%uGrid)
ENDIF
IF (ALLOCATED(GridOutTypeData%omGrid)) THEN
  DEALLOCATE(GridOutTypeData%omGrid)
ENDIF
 END SUBROUTINE FVW_DestroyGridOutType

 SUBROUTINE FVW_PackGridOutType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(GridOutType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackGridOutType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%name)  ! name
      Int_BufSz  = Int_BufSz  + 1  ! type
      Re_BufSz   = Re_BufSz   + 1  ! tStart
      Re_BufSz   = Re_BufSz   + 1  ! tEnd
      Re_BufSz   = Re_BufSz   + 1  ! DTout
      Re_BufSz   = Re_BufSz   + 1  ! xStart
      Re_BufSz   = Re_BufSz   + 1  ! yStart
      Re_BufSz   = Re_BufSz   + 1  ! zStart
      Re_BufSz   = Re_BufSz   + 1  ! xEnd
      Re_BufSz   = Re_BufSz   + 1  ! yEnd
      Re_BufSz   = Re_BufSz   + 1  ! zEnd
      Int_BufSz  = Int_BufSz  + 1  ! nx
      Int_BufSz  = Int_BufSz  + 1  ! ny
      Int_BufSz  = Int_BufSz  + 1  ! nz
  Int_BufSz   = Int_BufSz   + 1     ! uGrid allocated yes/no
  IF ( ALLOCATED(InData%uGrid) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! uGrid upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%uGrid)  ! uGrid
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! omGrid allocated yes/no
  IF ( ALLOCATED(InData%omGrid) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! omGrid upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%omGrid)  ! omGrid
  END IF
      Db_BufSz   = Db_BufSz   + 1  ! tLastOutput
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%name)
      IntKiBuf(Int_Xferred) = ICHAR(InData%name(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%type
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tEnd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%DTout
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%xStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%yStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%zStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%xEnd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%yEnd
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%zEnd
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nx
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ny
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nz
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%uGrid) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%uGrid,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%uGrid,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%uGrid,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%uGrid,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%uGrid,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%uGrid,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%uGrid,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%uGrid,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%uGrid,4), UBOUND(InData%uGrid,4)
        DO i3 = LBOUND(InData%uGrid,3), UBOUND(InData%uGrid,3)
          DO i2 = LBOUND(InData%uGrid,2), UBOUND(InData%uGrid,2)
            DO i1 = LBOUND(InData%uGrid,1), UBOUND(InData%uGrid,1)
              ReKiBuf(Re_Xferred) = InData%uGrid(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%omGrid) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omGrid,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omGrid,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omGrid,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omGrid,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omGrid,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omGrid,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omGrid,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omGrid,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%omGrid,4), UBOUND(InData%omGrid,4)
        DO i3 = LBOUND(InData%omGrid,3), UBOUND(InData%omGrid,3)
          DO i2 = LBOUND(InData%omGrid,2), UBOUND(InData%omGrid,2)
            DO i1 = LBOUND(InData%omGrid,1), UBOUND(InData%omGrid,1)
              ReKiBuf(Re_Xferred) = InData%omGrid(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
    DbKiBuf(Db_Xferred) = InData%tLastOutput
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE FVW_PackGridOutType

 SUBROUTINE FVW_UnPackGridOutType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(GridOutType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackGridOutType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%name)
      OutData%name(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%type = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%tStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%tEnd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DTout = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%xStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%yStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%zStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%xEnd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%yEnd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%zEnd = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%nx = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ny = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nz = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! uGrid not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%uGrid)) DEALLOCATE(OutData%uGrid)
    ALLOCATE(OutData%uGrid(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%uGrid.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%uGrid,4), UBOUND(OutData%uGrid,4)
        DO i3 = LBOUND(OutData%uGrid,3), UBOUND(OutData%uGrid,3)
          DO i2 = LBOUND(OutData%uGrid,2), UBOUND(OutData%uGrid,2)
            DO i1 = LBOUND(OutData%uGrid,1), UBOUND(OutData%uGrid,1)
              OutData%uGrid(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! omGrid not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%omGrid)) DEALLOCATE(OutData%omGrid)
    ALLOCATE(OutData%omGrid(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%omGrid.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%omGrid,4), UBOUND(OutData%omGrid,4)
        DO i3 = LBOUND(OutData%omGrid,3), UBOUND(OutData%omGrid,3)
          DO i2 = LBOUND(OutData%omGrid,2), UBOUND(OutData%omGrid,2)
            DO i1 = LBOUND(OutData%omGrid,1), UBOUND(OutData%omGrid,1)
              OutData%omGrid(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
    OutData%tLastOutput = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
 END SUBROUTINE FVW_UnPackGridOutType

 SUBROUTINE FVW_CopyT_Sgmt( SrcT_SgmtData, DstT_SgmtData, CtrlCode, ErrStat, ErrMsg )
   TYPE(T_Sgmt), INTENT(IN) :: SrcT_SgmtData
   TYPE(T_Sgmt), INTENT(INOUT) :: DstT_SgmtData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyT_Sgmt'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcT_SgmtData%Points)) THEN
  i1_l = LBOUND(SrcT_SgmtData%Points,1)
  i1_u = UBOUND(SrcT_SgmtData%Points,1)
  i2_l = LBOUND(SrcT_SgmtData%Points,2)
  i2_u = UBOUND(SrcT_SgmtData%Points,2)
  IF (.NOT. ALLOCATED(DstT_SgmtData%Points)) THEN 
    ALLOCATE(DstT_SgmtData%Points(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Points.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstT_SgmtData%Points = SrcT_SgmtData%Points
ENDIF
IF (ALLOCATED(SrcT_SgmtData%Connct)) THEN
  i1_l = LBOUND(SrcT_SgmtData%Connct,1)
  i1_u = UBOUND(SrcT_SgmtData%Connct,1)
  i2_l = LBOUND(SrcT_SgmtData%Connct,2)
  i2_u = UBOUND(SrcT_SgmtData%Connct,2)
  IF (.NOT. ALLOCATED(DstT_SgmtData%Connct)) THEN 
    ALLOCATE(DstT_SgmtData%Connct(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Connct.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstT_SgmtData%Connct = SrcT_SgmtData%Connct
ENDIF
IF (ALLOCATED(SrcT_SgmtData%Gamma)) THEN
  i1_l = LBOUND(SrcT_SgmtData%Gamma,1)
  i1_u = UBOUND(SrcT_SgmtData%Gamma,1)
  IF (.NOT. ALLOCATED(DstT_SgmtData%Gamma)) THEN 
    ALLOCATE(DstT_SgmtData%Gamma(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Gamma.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstT_SgmtData%Gamma = SrcT_SgmtData%Gamma
ENDIF
IF (ALLOCATED(SrcT_SgmtData%Epsilon)) THEN
  i1_l = LBOUND(SrcT_SgmtData%Epsilon,1)
  i1_u = UBOUND(SrcT_SgmtData%Epsilon,1)
  IF (.NOT. ALLOCATED(DstT_SgmtData%Epsilon)) THEN 
    ALLOCATE(DstT_SgmtData%Epsilon(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstT_SgmtData%Epsilon.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstT_SgmtData%Epsilon = SrcT_SgmtData%Epsilon
ENDIF
    DstT_SgmtData%RegFunction = SrcT_SgmtData%RegFunction
    DstT_SgmtData%nAct = SrcT_SgmtData%nAct
    DstT_SgmtData%nActP = SrcT_SgmtData%nActP
 END SUBROUTINE FVW_CopyT_Sgmt

 SUBROUTINE FVW_DestroyT_Sgmt( T_SgmtData, ErrStat, ErrMsg )
  TYPE(T_Sgmt), INTENT(INOUT) :: T_SgmtData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyT_Sgmt'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(T_SgmtData%Points)) THEN
  DEALLOCATE(T_SgmtData%Points)
ENDIF
IF (ALLOCATED(T_SgmtData%Connct)) THEN
  DEALLOCATE(T_SgmtData%Connct)
ENDIF
IF (ALLOCATED(T_SgmtData%Gamma)) THEN
  DEALLOCATE(T_SgmtData%Gamma)
ENDIF
IF (ALLOCATED(T_SgmtData%Epsilon)) THEN
  DEALLOCATE(T_SgmtData%Epsilon)
ENDIF
 END SUBROUTINE FVW_DestroyT_Sgmt

 SUBROUTINE FVW_PackT_Sgmt( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(T_Sgmt),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackT_Sgmt'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Points allocated yes/no
  IF ( ALLOCATED(InData%Points) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Points upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Points)  ! Points
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Connct allocated yes/no
  IF ( ALLOCATED(InData%Connct) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Connct upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Connct)  ! Connct
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Gamma allocated yes/no
  IF ( ALLOCATED(InData%Gamma) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Gamma upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Gamma)  ! Gamma
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Epsilon allocated yes/no
  IF ( ALLOCATED(InData%Epsilon) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Epsilon upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Epsilon)  ! Epsilon
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! RegFunction
      Int_BufSz  = Int_BufSz  + 1  ! nAct
      Int_BufSz  = Int_BufSz  + 1  ! nActP
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Points) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Points,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Points,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Points,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Points,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Points,2), UBOUND(InData%Points,2)
        DO i1 = LBOUND(InData%Points,1), UBOUND(InData%Points,1)
          ReKiBuf(Re_Xferred) = InData%Points(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Connct) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Connct,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Connct,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Connct,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Connct,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Connct,2), UBOUND(InData%Connct,2)
        DO i1 = LBOUND(InData%Connct,1), UBOUND(InData%Connct,1)
          IntKiBuf(Int_Xferred) = InData%Connct(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Gamma) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Gamma,1), UBOUND(InData%Gamma,1)
        ReKiBuf(Re_Xferred) = InData%Gamma(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Epsilon) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Epsilon,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Epsilon,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Epsilon,1), UBOUND(InData%Epsilon,1)
        ReKiBuf(Re_Xferred) = InData%Epsilon(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%RegFunction
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nAct
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nActP
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackT_Sgmt

 SUBROUTINE FVW_UnPackT_Sgmt( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(T_Sgmt), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackT_Sgmt'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Points not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Points)) DEALLOCATE(OutData%Points)
    ALLOCATE(OutData%Points(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Points.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Points,2), UBOUND(OutData%Points,2)
        DO i1 = LBOUND(OutData%Points,1), UBOUND(OutData%Points,1)
          OutData%Points(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Connct not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Connct)) DEALLOCATE(OutData%Connct)
    ALLOCATE(OutData%Connct(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Connct.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Connct,2), UBOUND(OutData%Connct,2)
        DO i1 = LBOUND(OutData%Connct,1), UBOUND(OutData%Connct,1)
          OutData%Connct(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Gamma not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Gamma)) DEALLOCATE(OutData%Gamma)
    ALLOCATE(OutData%Gamma(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Gamma.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Gamma,1), UBOUND(OutData%Gamma,1)
        OutData%Gamma(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Epsilon not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Epsilon)) DEALLOCATE(OutData%Epsilon)
    ALLOCATE(OutData%Epsilon(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Epsilon.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Epsilon,1), UBOUND(OutData%Epsilon,1)
        OutData%Epsilon(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%RegFunction = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nAct = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nActP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackT_Sgmt

 SUBROUTINE FVW_CopyWng_ParameterType( SrcWng_ParameterTypeData, DstWng_ParameterTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_ParameterType), INTENT(IN) :: SrcWng_ParameterTypeData
   TYPE(Wng_ParameterType), INTENT(INOUT) :: DstWng_ParameterTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_ParameterType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_ParameterTypeData%chord_LL)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%chord_LL,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%chord_LL,1)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%chord_LL)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%chord_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%chord_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%chord_LL = SrcWng_ParameterTypeData%chord_LL
ENDIF
IF (ALLOCATED(SrcWng_ParameterTypeData%chord_CP)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%chord_CP,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%chord_CP,1)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%chord_CP)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%chord_CP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%chord_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%chord_CP = SrcWng_ParameterTypeData%chord_CP
ENDIF
IF (ALLOCATED(SrcWng_ParameterTypeData%s_LL)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%s_LL,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%s_LL,1)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%s_LL)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%s_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%s_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%s_LL = SrcWng_ParameterTypeData%s_LL
ENDIF
IF (ALLOCATED(SrcWng_ParameterTypeData%s_CP)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%s_CP,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%s_CP,1)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%s_CP)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%s_CP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%s_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%s_CP = SrcWng_ParameterTypeData%s_CP
ENDIF
    DstWng_ParameterTypeData%iRotor = SrcWng_ParameterTypeData%iRotor
IF (ALLOCATED(SrcWng_ParameterTypeData%AFindx)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%AFindx,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%AFindx,1)
  i2_l = LBOUND(SrcWng_ParameterTypeData%AFindx,2)
  i2_u = UBOUND(SrcWng_ParameterTypeData%AFindx,2)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%AFindx)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%AFindx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%AFindx = SrcWng_ParameterTypeData%AFindx
ENDIF
    DstWng_ParameterTypeData%nSpan = SrcWng_ParameterTypeData%nSpan
IF (ALLOCATED(SrcWng_ParameterTypeData%PrescribedCirculation)) THEN
  i1_l = LBOUND(SrcWng_ParameterTypeData%PrescribedCirculation,1)
  i1_u = UBOUND(SrcWng_ParameterTypeData%PrescribedCirculation,1)
  IF (.NOT. ALLOCATED(DstWng_ParameterTypeData%PrescribedCirculation)) THEN 
    ALLOCATE(DstWng_ParameterTypeData%PrescribedCirculation(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ParameterTypeData%PrescribedCirculation.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ParameterTypeData%PrescribedCirculation = SrcWng_ParameterTypeData%PrescribedCirculation
ENDIF
 END SUBROUTINE FVW_CopyWng_ParameterType

 SUBROUTINE FVW_DestroyWng_ParameterType( Wng_ParameterTypeData, ErrStat, ErrMsg )
  TYPE(Wng_ParameterType), INTENT(INOUT) :: Wng_ParameterTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_ParameterType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_ParameterTypeData%chord_LL)) THEN
  DEALLOCATE(Wng_ParameterTypeData%chord_LL)
ENDIF
IF (ALLOCATED(Wng_ParameterTypeData%chord_CP)) THEN
  DEALLOCATE(Wng_ParameterTypeData%chord_CP)
ENDIF
IF (ALLOCATED(Wng_ParameterTypeData%s_LL)) THEN
  DEALLOCATE(Wng_ParameterTypeData%s_LL)
ENDIF
IF (ALLOCATED(Wng_ParameterTypeData%s_CP)) THEN
  DEALLOCATE(Wng_ParameterTypeData%s_CP)
ENDIF
IF (ALLOCATED(Wng_ParameterTypeData%AFindx)) THEN
  DEALLOCATE(Wng_ParameterTypeData%AFindx)
ENDIF
IF (ALLOCATED(Wng_ParameterTypeData%PrescribedCirculation)) THEN
  DEALLOCATE(Wng_ParameterTypeData%PrescribedCirculation)
ENDIF
 END SUBROUTINE FVW_DestroyWng_ParameterType

 SUBROUTINE FVW_PackWng_ParameterType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_ParameterType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! chord_LL allocated yes/no
  IF ( ALLOCATED(InData%chord_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! chord_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chord_LL)  ! chord_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! chord_CP allocated yes/no
  IF ( ALLOCATED(InData%chord_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! chord_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chord_CP)  ! chord_CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! s_LL allocated yes/no
  IF ( ALLOCATED(InData%s_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! s_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%s_LL)  ! s_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! s_CP allocated yes/no
  IF ( ALLOCATED(InData%s_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! s_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%s_CP)  ! s_CP
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! iRotor
  Int_BufSz   = Int_BufSz   + 1     ! AFindx allocated yes/no
  IF ( ALLOCATED(InData%AFindx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AFindx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AFindx)  ! AFindx
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! nSpan
  Int_BufSz   = Int_BufSz   + 1     ! PrescribedCirculation allocated yes/no
  IF ( ALLOCATED(InData%PrescribedCirculation) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PrescribedCirculation upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PrescribedCirculation)  ! PrescribedCirculation
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%chord_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%chord_LL,1), UBOUND(InData%chord_LL,1)
        ReKiBuf(Re_Xferred) = InData%chord_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%chord_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord_CP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%chord_CP,1), UBOUND(InData%chord_CP,1)
        ReKiBuf(Re_Xferred) = InData%chord_CP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%s_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%s_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%s_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%s_LL,1), UBOUND(InData%s_LL,1)
        ReKiBuf(Re_Xferred) = InData%s_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%s_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%s_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%s_CP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%s_CP,1), UBOUND(InData%s_CP,1)
        ReKiBuf(Re_Xferred) = InData%s_CP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%iRotor
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AFindx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AFindx,2), UBOUND(InData%AFindx,2)
        DO i1 = LBOUND(InData%AFindx,1), UBOUND(InData%AFindx,1)
          IntKiBuf(Int_Xferred) = InData%AFindx(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%nSpan
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%PrescribedCirculation) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PrescribedCirculation,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PrescribedCirculation,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PrescribedCirculation,1), UBOUND(InData%PrescribedCirculation,1)
        ReKiBuf(Re_Xferred) = InData%PrescribedCirculation(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_ParameterType

 SUBROUTINE FVW_UnPackWng_ParameterType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_ParameterType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chord_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chord_LL)) DEALLOCATE(OutData%chord_LL)
    ALLOCATE(OutData%chord_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chord_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%chord_LL,1), UBOUND(OutData%chord_LL,1)
        OutData%chord_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chord_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chord_CP)) DEALLOCATE(OutData%chord_CP)
    ALLOCATE(OutData%chord_CP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chord_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%chord_CP,1), UBOUND(OutData%chord_CP,1)
        OutData%chord_CP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! s_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%s_LL)) DEALLOCATE(OutData%s_LL)
    ALLOCATE(OutData%s_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%s_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%s_LL,1), UBOUND(OutData%s_LL,1)
        OutData%s_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! s_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%s_CP)) DEALLOCATE(OutData%s_CP)
    ALLOCATE(OutData%s_CP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%s_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%s_CP,1), UBOUND(OutData%s_CP,1)
        OutData%s_CP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%iRotor = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFindx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFindx)) DEALLOCATE(OutData%AFindx)
    ALLOCATE(OutData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFindx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AFindx,2), UBOUND(OutData%AFindx,2)
        DO i1 = LBOUND(OutData%AFindx,1), UBOUND(OutData%AFindx,1)
          OutData%AFindx(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    OutData%nSpan = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PrescribedCirculation not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PrescribedCirculation)) DEALLOCATE(OutData%PrescribedCirculation)
    ALLOCATE(OutData%PrescribedCirculation(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PrescribedCirculation.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PrescribedCirculation,1), UBOUND(OutData%PrescribedCirculation,1)
        OutData%PrescribedCirculation(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_ParameterType

 SUBROUTINE FVW_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(FVW_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%nRotors = SrcParamData%nRotors
    DstParamData%nWings = SrcParamData%nWings
IF (ALLOCATED(SrcParamData%W)) THEN
  i1_l = LBOUND(SrcParamData%W,1)
  i1_u = UBOUND(SrcParamData%W,1)
  IF (.NOT. ALLOCATED(DstParamData%W)) THEN 
    ALLOCATE(DstParamData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%W,1), UBOUND(SrcParamData%W,1)
      CALL FVW_Copywng_parametertype( SrcParamData%W(i1), DstParamData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcParamData%Bld2Wings)) THEN
  i1_l = LBOUND(SrcParamData%Bld2Wings,1)
  i1_u = UBOUND(SrcParamData%Bld2Wings,1)
  i2_l = LBOUND(SrcParamData%Bld2Wings,2)
  i2_u = UBOUND(SrcParamData%Bld2Wings,2)
  IF (.NOT. ALLOCATED(DstParamData%Bld2Wings)) THEN 
    ALLOCATE(DstParamData%Bld2Wings(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Bld2Wings.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Bld2Wings = SrcParamData%Bld2Wings
ENDIF
    DstParamData%iNWStart = SrcParamData%iNWStart
    DstParamData%nNWMax = SrcParamData%nNWMax
    DstParamData%nFWMax = SrcParamData%nFWMax
    DstParamData%nFWFree = SrcParamData%nFWFree
    DstParamData%FWShedVorticity = SrcParamData%FWShedVorticity
    DstParamData%IntMethod = SrcParamData%IntMethod
    DstParamData%FreeWakeStart = SrcParamData%FreeWakeStart
    DstParamData%FullCirculationStart = SrcParamData%FullCirculationStart
    DstParamData%CirculationMethod = SrcParamData%CirculationMethod
    DstParamData%CircSolvMaxIter = SrcParamData%CircSolvMaxIter
    DstParamData%CircSolvConvCrit = SrcParamData%CircSolvConvCrit
    DstParamData%CircSolvRelaxation = SrcParamData%CircSolvRelaxation
    DstParamData%CircSolvPolar = SrcParamData%CircSolvPolar
    DstParamData%DiffusionMethod = SrcParamData%DiffusionMethod
    DstParamData%CoreSpreadEddyVisc = SrcParamData%CoreSpreadEddyVisc
    DstParamData%RegDeterMethod = SrcParamData%RegDeterMethod
    DstParamData%RegFunction = SrcParamData%RegFunction
    DstParamData%WakeRegMethod = SrcParamData%WakeRegMethod
    DstParamData%WakeRegParam = SrcParamData%WakeRegParam
    DstParamData%WingRegParam = SrcParamData%WingRegParam
    DstParamData%ShearModel = SrcParamData%ShearModel
    DstParamData%TwrShadowOnWake = SrcParamData%TwrShadowOnWake
    DstParamData%VelocityMethod = SrcParamData%VelocityMethod
    DstParamData%TreeBranchFactor = SrcParamData%TreeBranchFactor
    DstParamData%PartPerSegment = SrcParamData%PartPerSegment
    DstParamData%DTaero = SrcParamData%DTaero
    DstParamData%DTfvw = SrcParamData%DTfvw
    DstParamData%KinVisc = SrcParamData%KinVisc
    DstParamData%WrVTK = SrcParamData%WrVTK
    DstParamData%VTKBlades = SrcParamData%VTKBlades
    DstParamData%DTvtk = SrcParamData%DTvtk
    DstParamData%VTKCoord = SrcParamData%VTKCoord
    DstParamData%RootName = SrcParamData%RootName
    DstParamData%VTK_OutFileRoot = SrcParamData%VTK_OutFileRoot
    DstParamData%VTK_OutFileBase = SrcParamData%VTK_OutFileBase
    DstParamData%nGridOut = SrcParamData%nGridOut
    DstParamData%InductionAtCP = SrcParamData%InductionAtCP
    DstParamData%WakeAtTE = SrcParamData%WakeAtTE
    DstParamData%DStallOnWake = SrcParamData%DStallOnWake
    DstParamData%Induction = SrcParamData%Induction
 END SUBROUTINE FVW_CopyParam

 SUBROUTINE FVW_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(FVW_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%W)) THEN
DO i1 = LBOUND(ParamData%W,1), UBOUND(ParamData%W,1)
  CALL FVW_Destroywng_parametertype( ParamData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%W)
ENDIF
IF (ALLOCATED(ParamData%Bld2Wings)) THEN
  DEALLOCATE(ParamData%Bld2Wings)
ENDIF
 END SUBROUTINE FVW_DestroyParam

 SUBROUTINE FVW_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! nRotors
      Int_BufSz  = Int_BufSz  + 1  ! nWings
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_parametertype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Bld2Wings allocated yes/no
  IF ( ALLOCATED(InData%Bld2Wings) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Bld2Wings upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%Bld2Wings)  ! Bld2Wings
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! iNWStart
      Int_BufSz  = Int_BufSz  + 1  ! nNWMax
      Int_BufSz  = Int_BufSz  + 1  ! nFWMax
      Int_BufSz  = Int_BufSz  + 1  ! nFWFree
      Int_BufSz  = Int_BufSz  + 1  ! FWShedVorticity
      Int_BufSz  = Int_BufSz  + 1  ! IntMethod
      Re_BufSz   = Re_BufSz   + 1  ! FreeWakeStart
      Re_BufSz   = Re_BufSz   + 1  ! FullCirculationStart
      Int_BufSz  = Int_BufSz  + 1  ! CirculationMethod
      Int_BufSz  = Int_BufSz  + 1  ! CircSolvMaxIter
      Re_BufSz   = Re_BufSz   + 1  ! CircSolvConvCrit
      Re_BufSz   = Re_BufSz   + 1  ! CircSolvRelaxation
      Int_BufSz  = Int_BufSz  + 1  ! CircSolvPolar
      Int_BufSz  = Int_BufSz  + 1  ! DiffusionMethod
      Re_BufSz   = Re_BufSz   + 1  ! CoreSpreadEddyVisc
      Int_BufSz  = Int_BufSz  + 1  ! RegDeterMethod
      Int_BufSz  = Int_BufSz  + 1  ! RegFunction
      Int_BufSz  = Int_BufSz  + 1  ! WakeRegMethod
      Re_BufSz   = Re_BufSz   + 1  ! WakeRegParam
      Re_BufSz   = Re_BufSz   + 1  ! WingRegParam
      Int_BufSz  = Int_BufSz  + 1  ! ShearModel
      Int_BufSz  = Int_BufSz  + 1  ! TwrShadowOnWake
      Int_BufSz  = Int_BufSz  + 1  ! VelocityMethod
      Re_BufSz   = Re_BufSz   + 1  ! TreeBranchFactor
      Int_BufSz  = Int_BufSz  + 1  ! PartPerSegment
      Db_BufSz   = Db_BufSz   + 1  ! DTaero
      Db_BufSz   = Db_BufSz   + 1  ! DTfvw
      Re_BufSz   = Re_BufSz   + 1  ! KinVisc
      Int_BufSz  = Int_BufSz  + 1  ! WrVTK
      Int_BufSz  = Int_BufSz  + 1  ! VTKBlades
      Db_BufSz   = Db_BufSz   + 1  ! DTvtk
      Int_BufSz  = Int_BufSz  + 1  ! VTKCoord
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%VTK_OutFileRoot)  ! VTK_OutFileRoot
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%VTK_OutFileBase)  ! VTK_OutFileBase
      Int_BufSz  = Int_BufSz  + 1  ! nGridOut
      Int_BufSz  = Int_BufSz  + 1  ! InductionAtCP
      Int_BufSz  = Int_BufSz  + 1  ! WakeAtTE
      Int_BufSz  = Int_BufSz  + 1  ! DStallOnWake
      Int_BufSz  = Int_BufSz  + 1  ! Induction
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%nRotors
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nWings
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_parametertype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Bld2Wings) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Bld2Wings,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Bld2Wings,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Bld2Wings,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Bld2Wings,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Bld2Wings,2), UBOUND(InData%Bld2Wings,2)
        DO i1 = LBOUND(InData%Bld2Wings,1), UBOUND(InData%Bld2Wings,1)
          IntKiBuf(Int_Xferred) = InData%Bld2Wings(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%iNWStart
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nNWMax
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nFWMax
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nFWFree
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FWShedVorticity, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IntMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FreeWakeStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FullCirculationStart
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%CirculationMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%CircSolvMaxIter
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CircSolvConvCrit
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CircSolvRelaxation
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%CircSolvPolar
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%DiffusionMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CoreSpreadEddyVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RegDeterMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RegFunction
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%WakeRegMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WakeRegParam
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WingRegParam
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ShearModel
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwrShadowOnWake, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VelocityMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TreeBranchFactor
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%PartPerSegment
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTaero
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTfvw
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%KinVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%WrVTK
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VTKBlades
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTvtk
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VTKCoord
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%VTK_OutFileRoot)
      IntKiBuf(Int_Xferred) = ICHAR(InData%VTK_OutFileRoot(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%VTK_OutFileBase)
      IntKiBuf(Int_Xferred) = ICHAR(InData%VTK_OutFileBase(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%nGridOut
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%InductionAtCP, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%WakeAtTE, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%DStallOnWake, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Induction, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackParam

 SUBROUTINE FVW_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%nRotors = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nWings = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_parametertype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Bld2Wings not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Bld2Wings)) DEALLOCATE(OutData%Bld2Wings)
    ALLOCATE(OutData%Bld2Wings(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Bld2Wings.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Bld2Wings,2), UBOUND(OutData%Bld2Wings,2)
        DO i1 = LBOUND(OutData%Bld2Wings,1), UBOUND(OutData%Bld2Wings,1)
          OutData%Bld2Wings(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    OutData%iNWStart = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nNWMax = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nFWMax = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nFWFree = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%FWShedVorticity = TRANSFER(IntKiBuf(Int_Xferred), OutData%FWShedVorticity)
    Int_Xferred = Int_Xferred + 1
    OutData%IntMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%FreeWakeStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FullCirculationStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%CirculationMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%CircSolvMaxIter = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%CircSolvConvCrit = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%CircSolvRelaxation = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%CircSolvPolar = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%DiffusionMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%CoreSpreadEddyVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RegDeterMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RegFunction = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WakeRegMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WakeRegParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WingRegParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ShearModel = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TwrShadowOnWake = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwrShadowOnWake)
    Int_Xferred = Int_Xferred + 1
    OutData%VelocityMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TreeBranchFactor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PartPerSegment = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%DTaero = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%DTfvw = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%KinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WrVTK = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%VTKBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%DTvtk = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%VTKCoord = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%VTK_OutFileRoot)
      OutData%VTK_OutFileRoot(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%VTK_OutFileBase)
      OutData%VTK_OutFileBase(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%nGridOut = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%InductionAtCP = TRANSFER(IntKiBuf(Int_Xferred), OutData%InductionAtCP)
    Int_Xferred = Int_Xferred + 1
    OutData%WakeAtTE = TRANSFER(IntKiBuf(Int_Xferred), OutData%WakeAtTE)
    Int_Xferred = Int_Xferred + 1
    OutData%DStallOnWake = TRANSFER(IntKiBuf(Int_Xferred), OutData%DStallOnWake)
    Int_Xferred = Int_Xferred + 1
    OutData%Induction = TRANSFER(IntKiBuf(Int_Xferred), OutData%Induction)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackParam

 SUBROUTINE FVW_CopyWng_ContinuousStateType( SrcWng_ContinuousStateTypeData, DstWng_ContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_ContinuousStateType), INTENT(IN) :: SrcWng_ContinuousStateTypeData
   TYPE(Wng_ContinuousStateType), INTENT(INOUT) :: DstWng_ContinuousStateTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_ContinuousStateType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%Gamma_NW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%Gamma_NW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%Gamma_NW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%Gamma_NW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%Gamma_NW,2)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%Gamma_NW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%Gamma_NW(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Gamma_NW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%Gamma_NW = SrcWng_ContinuousStateTypeData%Gamma_NW
ENDIF
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%Gamma_FW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%Gamma_FW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%Gamma_FW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%Gamma_FW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%Gamma_FW,2)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%Gamma_FW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%Gamma_FW(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Gamma_FW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%Gamma_FW = SrcWng_ContinuousStateTypeData%Gamma_FW
ENDIF
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%Eps_NW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,2)
  i3_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,3)
  i3_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_NW,3)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%Eps_NW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%Eps_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Eps_NW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%Eps_NW = SrcWng_ContinuousStateTypeData%Eps_NW
ENDIF
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%Eps_FW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,2)
  i3_l = LBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,3)
  i3_u = UBOUND(SrcWng_ContinuousStateTypeData%Eps_FW,3)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%Eps_FW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%Eps_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%Eps_FW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%Eps_FW = SrcWng_ContinuousStateTypeData%Eps_FW
ENDIF
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%r_NW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%r_NW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%r_NW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%r_NW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%r_NW,2)
  i3_l = LBOUND(SrcWng_ContinuousStateTypeData%r_NW,3)
  i3_u = UBOUND(SrcWng_ContinuousStateTypeData%r_NW,3)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%r_NW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%r_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%r_NW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%r_NW = SrcWng_ContinuousStateTypeData%r_NW
ENDIF
IF (ALLOCATED(SrcWng_ContinuousStateTypeData%r_FW)) THEN
  i1_l = LBOUND(SrcWng_ContinuousStateTypeData%r_FW,1)
  i1_u = UBOUND(SrcWng_ContinuousStateTypeData%r_FW,1)
  i2_l = LBOUND(SrcWng_ContinuousStateTypeData%r_FW,2)
  i2_u = UBOUND(SrcWng_ContinuousStateTypeData%r_FW,2)
  i3_l = LBOUND(SrcWng_ContinuousStateTypeData%r_FW,3)
  i3_u = UBOUND(SrcWng_ContinuousStateTypeData%r_FW,3)
  IF (.NOT. ALLOCATED(DstWng_ContinuousStateTypeData%r_FW)) THEN 
    ALLOCATE(DstWng_ContinuousStateTypeData%r_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ContinuousStateTypeData%r_FW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ContinuousStateTypeData%r_FW = SrcWng_ContinuousStateTypeData%r_FW
ENDIF
 END SUBROUTINE FVW_CopyWng_ContinuousStateType

 SUBROUTINE FVW_DestroyWng_ContinuousStateType( Wng_ContinuousStateTypeData, ErrStat, ErrMsg )
  TYPE(Wng_ContinuousStateType), INTENT(INOUT) :: Wng_ContinuousStateTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_ContinuousStateType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_ContinuousStateTypeData%Gamma_NW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%Gamma_NW)
ENDIF
IF (ALLOCATED(Wng_ContinuousStateTypeData%Gamma_FW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%Gamma_FW)
ENDIF
IF (ALLOCATED(Wng_ContinuousStateTypeData%Eps_NW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%Eps_NW)
ENDIF
IF (ALLOCATED(Wng_ContinuousStateTypeData%Eps_FW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%Eps_FW)
ENDIF
IF (ALLOCATED(Wng_ContinuousStateTypeData%r_NW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%r_NW)
ENDIF
IF (ALLOCATED(Wng_ContinuousStateTypeData%r_FW)) THEN
  DEALLOCATE(Wng_ContinuousStateTypeData%r_FW)
ENDIF
 END SUBROUTINE FVW_DestroyWng_ContinuousStateType

 SUBROUTINE FVW_PackWng_ContinuousStateType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_ContinuousStateType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Gamma_NW allocated yes/no
  IF ( ALLOCATED(InData%Gamma_NW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Gamma_NW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Gamma_NW)  ! Gamma_NW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Gamma_FW allocated yes/no
  IF ( ALLOCATED(InData%Gamma_FW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Gamma_FW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Gamma_FW)  ! Gamma_FW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Eps_NW allocated yes/no
  IF ( ALLOCATED(InData%Eps_NW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Eps_NW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Eps_NW)  ! Eps_NW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Eps_FW allocated yes/no
  IF ( ALLOCATED(InData%Eps_FW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Eps_FW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Eps_FW)  ! Eps_FW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_NW allocated yes/no
  IF ( ALLOCATED(InData%r_NW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! r_NW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_NW)  ! r_NW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_FW allocated yes/no
  IF ( ALLOCATED(InData%r_FW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! r_FW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_FW)  ! r_FW
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Gamma_NW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma_NW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma_NW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma_NW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma_NW,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Gamma_NW,2), UBOUND(InData%Gamma_NW,2)
        DO i1 = LBOUND(InData%Gamma_NW,1), UBOUND(InData%Gamma_NW,1)
          ReKiBuf(Re_Xferred) = InData%Gamma_NW(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Gamma_FW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma_FW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma_FW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma_FW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma_FW,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Gamma_FW,2), UBOUND(InData%Gamma_FW,2)
        DO i1 = LBOUND(InData%Gamma_FW,1), UBOUND(InData%Gamma_FW,1)
          ReKiBuf(Re_Xferred) = InData%Gamma_FW(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Eps_NW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_NW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_NW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_NW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_NW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_NW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_NW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Eps_NW,3), UBOUND(InData%Eps_NW,3)
        DO i2 = LBOUND(InData%Eps_NW,2), UBOUND(InData%Eps_NW,2)
          DO i1 = LBOUND(InData%Eps_NW,1), UBOUND(InData%Eps_NW,1)
            ReKiBuf(Re_Xferred) = InData%Eps_NW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Eps_FW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_FW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_FW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_FW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_FW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Eps_FW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Eps_FW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Eps_FW,3), UBOUND(InData%Eps_FW,3)
        DO i2 = LBOUND(InData%Eps_FW,2), UBOUND(InData%Eps_FW,2)
          DO i1 = LBOUND(InData%Eps_FW,1), UBOUND(InData%Eps_FW,1)
            ReKiBuf(Re_Xferred) = InData%Eps_FW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_NW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_NW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_NW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_NW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_NW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_NW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_NW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%r_NW,3), UBOUND(InData%r_NW,3)
        DO i2 = LBOUND(InData%r_NW,2), UBOUND(InData%r_NW,2)
          DO i1 = LBOUND(InData%r_NW,1), UBOUND(InData%r_NW,1)
            ReKiBuf(Re_Xferred) = InData%r_NW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_FW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_FW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_FW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_FW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_FW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_FW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_FW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%r_FW,3), UBOUND(InData%r_FW,3)
        DO i2 = LBOUND(InData%r_FW,2), UBOUND(InData%r_FW,2)
          DO i1 = LBOUND(InData%r_FW,1), UBOUND(InData%r_FW,1)
            ReKiBuf(Re_Xferred) = InData%r_FW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_ContinuousStateType

 SUBROUTINE FVW_UnPackWng_ContinuousStateType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_ContinuousStateType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Gamma_NW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Gamma_NW)) DEALLOCATE(OutData%Gamma_NW)
    ALLOCATE(OutData%Gamma_NW(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Gamma_NW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Gamma_NW,2), UBOUND(OutData%Gamma_NW,2)
        DO i1 = LBOUND(OutData%Gamma_NW,1), UBOUND(OutData%Gamma_NW,1)
          OutData%Gamma_NW(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Gamma_FW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Gamma_FW)) DEALLOCATE(OutData%Gamma_FW)
    ALLOCATE(OutData%Gamma_FW(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Gamma_FW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Gamma_FW,2), UBOUND(OutData%Gamma_FW,2)
        DO i1 = LBOUND(OutData%Gamma_FW,1), UBOUND(OutData%Gamma_FW,1)
          OutData%Gamma_FW(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Eps_NW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Eps_NW)) DEALLOCATE(OutData%Eps_NW)
    ALLOCATE(OutData%Eps_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Eps_NW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Eps_NW,3), UBOUND(OutData%Eps_NW,3)
        DO i2 = LBOUND(OutData%Eps_NW,2), UBOUND(OutData%Eps_NW,2)
          DO i1 = LBOUND(OutData%Eps_NW,1), UBOUND(OutData%Eps_NW,1)
            OutData%Eps_NW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Eps_FW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Eps_FW)) DEALLOCATE(OutData%Eps_FW)
    ALLOCATE(OutData%Eps_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Eps_FW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Eps_FW,3), UBOUND(OutData%Eps_FW,3)
        DO i2 = LBOUND(OutData%Eps_FW,2), UBOUND(OutData%Eps_FW,2)
          DO i1 = LBOUND(OutData%Eps_FW,1), UBOUND(OutData%Eps_FW,1)
            OutData%Eps_FW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_NW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_NW)) DEALLOCATE(OutData%r_NW)
    ALLOCATE(OutData%r_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_NW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%r_NW,3), UBOUND(OutData%r_NW,3)
        DO i2 = LBOUND(OutData%r_NW,2), UBOUND(OutData%r_NW,2)
          DO i1 = LBOUND(OutData%r_NW,1), UBOUND(OutData%r_NW,1)
            OutData%r_NW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_FW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_FW)) DEALLOCATE(OutData%r_FW)
    ALLOCATE(OutData%r_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_FW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%r_FW,3), UBOUND(OutData%r_FW,3)
        DO i2 = LBOUND(OutData%r_FW,2), UBOUND(OutData%r_FW,2)
          DO i1 = LBOUND(OutData%r_FW,1), UBOUND(OutData%r_FW,1)
            OutData%r_FW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_ContinuousStateType

 SUBROUTINE FVW_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(FVW_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcContStateData%W)) THEN
  i1_l = LBOUND(SrcContStateData%W,1)
  i1_u = UBOUND(SrcContStateData%W,1)
  IF (.NOT. ALLOCATED(DstContStateData%W)) THEN 
    ALLOCATE(DstContStateData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcContStateData%W,1), UBOUND(SrcContStateData%W,1)
      CALL FVW_Copywng_continuousstatetype( SrcContStateData%W(i1), DstContStateData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcContStateData%UA)) THEN
  i1_l = LBOUND(SrcContStateData%UA,1)
  i1_u = UBOUND(SrcContStateData%UA,1)
  IF (.NOT. ALLOCATED(DstContStateData%UA)) THEN 
    ALLOCATE(DstContStateData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%UA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcContStateData%UA,1), UBOUND(SrcContStateData%UA,1)
      CALL UA_CopyContState( SrcContStateData%UA(i1), DstContStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE FVW_CopyContState

 SUBROUTINE FVW_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(FVW_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ContStateData%W)) THEN
DO i1 = LBOUND(ContStateData%W,1), UBOUND(ContStateData%W,1)
  CALL FVW_Destroywng_continuousstatetype( ContStateData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ContStateData%W)
ENDIF
IF (ALLOCATED(ContStateData%UA)) THEN
DO i1 = LBOUND(ContStateData%UA,1), UBOUND(ContStateData%UA,1)
  CALL UA_DestroyContState( ContStateData%UA(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ContStateData%UA)
ENDIF
 END SUBROUTINE FVW_DestroyContState

 SUBROUTINE FVW_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_continuousstatetype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! UA allocated yes/no
  IF ( ALLOCATED(InData%UA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UA upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_continuousstatetype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%UA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UA,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE FVW_PackContState

 SUBROUTINE FVW_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_continuousstatetype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UA)) DEALLOCATE(OutData%UA)
    ALLOCATE(OutData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%UA,1), UBOUND(OutData%UA,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%UA(i1), ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE FVW_UnPackContState

 SUBROUTINE FVW_CopyWng_OutputType( SrcWng_OutputTypeData, DstWng_OutputTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_OutputType), INTENT(IN) :: SrcWng_OutputTypeData
   TYPE(Wng_OutputType), INTENT(INOUT) :: DstWng_OutputTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_OutputType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_OutputTypeData%Vind)) THEN
  i1_l = LBOUND(SrcWng_OutputTypeData%Vind,1)
  i1_u = UBOUND(SrcWng_OutputTypeData%Vind,1)
  i2_l = LBOUND(SrcWng_OutputTypeData%Vind,2)
  i2_u = UBOUND(SrcWng_OutputTypeData%Vind,2)
  IF (.NOT. ALLOCATED(DstWng_OutputTypeData%Vind)) THEN 
    ALLOCATE(DstWng_OutputTypeData%Vind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_OutputTypeData%Vind.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_OutputTypeData%Vind = SrcWng_OutputTypeData%Vind
ENDIF
 END SUBROUTINE FVW_CopyWng_OutputType

 SUBROUTINE FVW_DestroyWng_OutputType( Wng_OutputTypeData, ErrStat, ErrMsg )
  TYPE(Wng_OutputType), INTENT(INOUT) :: Wng_OutputTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_OutputType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_OutputTypeData%Vind)) THEN
  DEALLOCATE(Wng_OutputTypeData%Vind)
ENDIF
 END SUBROUTINE FVW_DestroyWng_OutputType

 SUBROUTINE FVW_PackWng_OutputType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_OutputType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Vind allocated yes/no
  IF ( ALLOCATED(InData%Vind) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vind upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vind)  ! Vind
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Vind) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vind,2), UBOUND(InData%Vind,2)
        DO i1 = LBOUND(InData%Vind,1), UBOUND(InData%Vind,1)
          ReKiBuf(Re_Xferred) = InData%Vind(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_OutputType

 SUBROUTINE FVW_UnPackWng_OutputType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_OutputType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vind not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vind)) DEALLOCATE(OutData%Vind)
    ALLOCATE(OutData%Vind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vind.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vind,2), UBOUND(OutData%Vind,2)
        DO i1 = LBOUND(OutData%Vind,1), UBOUND(OutData%Vind,1)
          OutData%Vind(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_OutputType

 SUBROUTINE FVW_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(FVW_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%W)) THEN
  i1_l = LBOUND(SrcOutputData%W,1)
  i1_u = UBOUND(SrcOutputData%W,1)
  IF (.NOT. ALLOCATED(DstOutputData%W)) THEN 
    ALLOCATE(DstOutputData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcOutputData%W,1), UBOUND(SrcOutputData%W,1)
      CALL FVW_Copywng_outputtype( SrcOutputData%W(i1), DstOutputData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE FVW_CopyOutput

 SUBROUTINE FVW_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(FVW_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%W)) THEN
DO i1 = LBOUND(OutputData%W,1), UBOUND(OutputData%W,1)
  CALL FVW_Destroywng_outputtype( OutputData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(OutputData%W)
ENDIF
 END SUBROUTINE FVW_DestroyOutput

 SUBROUTINE FVW_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_outputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_outputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE FVW_PackOutput

 SUBROUTINE FVW_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_outputtype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE FVW_UnPackOutput

 SUBROUTINE FVW_CopyWng_MiscVarType( SrcWng_MiscVarTypeData, DstWng_MiscVarTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_MiscVarType), INTENT(IN) :: SrcWng_MiscVarTypeData
   TYPE(Wng_MiscVarType), INTENT(INOUT) :: DstWng_MiscVarTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_MiscVarType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_MiscVarTypeData%LE)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%LE,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%LE,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%LE,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%LE,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%LE)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%LE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%LE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%LE = SrcWng_MiscVarTypeData%LE
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%TE)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%TE,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%TE,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%TE,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%TE,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%TE)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%TE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%TE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%TE = SrcWng_MiscVarTypeData%TE
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%r_LL)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%r_LL,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%r_LL,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%r_LL,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%r_LL,2)
  i3_l = LBOUND(SrcWng_MiscVarTypeData%r_LL,3)
  i3_u = UBOUND(SrcWng_MiscVarTypeData%r_LL,3)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%r_LL)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%r_LL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%r_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%r_LL = SrcWng_MiscVarTypeData%r_LL
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%CP)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%CP,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%CP,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%CP,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%CP,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%CP)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%CP = SrcWng_MiscVarTypeData%CP
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Tang)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Tang,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Tang,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Tang,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Tang,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Tang)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Tang(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Tang.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Tang = SrcWng_MiscVarTypeData%Tang
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Norm)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Norm,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Norm,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Norm,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Norm,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Norm)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Norm(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Norm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Norm = SrcWng_MiscVarTypeData%Norm
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Orth)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Orth,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Orth,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Orth,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Orth,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Orth)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Orth(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Orth.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Orth = SrcWng_MiscVarTypeData%Orth
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%dl)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%dl,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%dl,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%dl,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%dl,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%dl)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%dl(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%dl.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%dl = SrcWng_MiscVarTypeData%dl
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Area)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Area,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Area,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Area)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Area(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Area.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Area = SrcWng_MiscVarTypeData%Area
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%diag_LL)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%diag_LL,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%diag_LL,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%diag_LL)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%diag_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%diag_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%diag_LL = SrcWng_MiscVarTypeData%diag_LL
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vind_CP)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vind_CP,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vind_CP,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vind_CP,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vind_CP,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vind_CP)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vind_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vind_CP = SrcWng_MiscVarTypeData%Vind_CP
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vtot_CP)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vtot_CP,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vtot_CP,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vtot_CP,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vtot_CP,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vtot_CP)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vtot_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vtot_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vtot_CP = SrcWng_MiscVarTypeData%Vtot_CP
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vstr_CP)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vstr_CP,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vstr_CP,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vstr_CP,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vstr_CP,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vstr_CP)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vstr_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vstr_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vstr_CP = SrcWng_MiscVarTypeData%Vstr_CP
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vwnd_CP)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_CP,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_CP,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_CP,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_CP,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vwnd_CP)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vwnd_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_CP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vwnd_CP = SrcWng_MiscVarTypeData%Vwnd_CP
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vwnd_NW)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,2)
  i3_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,3)
  i3_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_NW,3)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vwnd_NW)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vwnd_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_NW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vwnd_NW = SrcWng_MiscVarTypeData%Vwnd_NW
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vwnd_FW)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,2)
  i3_l = LBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,3)
  i3_u = UBOUND(SrcWng_MiscVarTypeData%Vwnd_FW,3)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vwnd_FW)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vwnd_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vwnd_FW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vwnd_FW = SrcWng_MiscVarTypeData%Vwnd_FW
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vind_NW)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vind_NW,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vind_NW,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vind_NW,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vind_NW,2)
  i3_l = LBOUND(SrcWng_MiscVarTypeData%Vind_NW,3)
  i3_u = UBOUND(SrcWng_MiscVarTypeData%Vind_NW,3)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vind_NW)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vind_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_NW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vind_NW = SrcWng_MiscVarTypeData%Vind_NW
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vind_FW)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vind_FW,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vind_FW,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vind_FW,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vind_FW,2)
  i3_l = LBOUND(SrcWng_MiscVarTypeData%Vind_FW,3)
  i3_u = UBOUND(SrcWng_MiscVarTypeData%Vind_FW,3)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vind_FW)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vind_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_FW.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vind_FW = SrcWng_MiscVarTypeData%Vind_FW
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%PitchAndTwist)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%PitchAndTwist,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%PitchAndTwist,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%PitchAndTwist)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%PitchAndTwist(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%PitchAndTwist.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%PitchAndTwist = SrcWng_MiscVarTypeData%PitchAndTwist
ENDIF
    DstWng_MiscVarTypeData%iTip = SrcWng_MiscVarTypeData%iTip
    DstWng_MiscVarTypeData%iRoot = SrcWng_MiscVarTypeData%iRoot
IF (ALLOCATED(SrcWng_MiscVarTypeData%alpha_LL)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%alpha_LL,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%alpha_LL,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%alpha_LL)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%alpha_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%alpha_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%alpha_LL = SrcWng_MiscVarTypeData%alpha_LL
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vreln_LL)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vreln_LL,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vreln_LL,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vreln_LL)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vreln_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vreln_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vreln_LL = SrcWng_MiscVarTypeData%Vreln_LL
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%u_UA)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%u_UA,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%u_UA,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%u_UA,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%u_UA,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%u_UA)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%u_UA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%u_UA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i2 = LBOUND(SrcWng_MiscVarTypeData%u_UA,2), UBOUND(SrcWng_MiscVarTypeData%u_UA,2)
    DO i1 = LBOUND(SrcWng_MiscVarTypeData%u_UA,1), UBOUND(SrcWng_MiscVarTypeData%u_UA,1)
      CALL UA_CopyInput( SrcWng_MiscVarTypeData%u_UA(i1,i2), DstWng_MiscVarTypeData%u_UA(i1,i2), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
    ENDDO
ENDIF
      CALL UA_CopyMisc( SrcWng_MiscVarTypeData%m_UA, DstWng_MiscVarTypeData%m_UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL UA_CopyOutput( SrcWng_MiscVarTypeData%y_UA, DstWng_MiscVarTypeData%y_UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL UA_CopyParam( SrcWng_MiscVarTypeData%p_UA, DstWng_MiscVarTypeData%p_UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcWng_MiscVarTypeData%Vind_LL)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%Vind_LL,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%Vind_LL,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%Vind_LL,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%Vind_LL,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%Vind_LL)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%Vind_LL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%Vind_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%Vind_LL = SrcWng_MiscVarTypeData%Vind_LL
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_AxInd)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_AxInd,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_AxInd,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_AxInd)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_AxInd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_AxInd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_AxInd = SrcWng_MiscVarTypeData%BN_AxInd
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_TanInd)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_TanInd,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_TanInd,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_TanInd)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_TanInd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_TanInd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_TanInd = SrcWng_MiscVarTypeData%BN_TanInd
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Vrel)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Vrel,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Vrel,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Vrel)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Vrel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Vrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Vrel = SrcWng_MiscVarTypeData%BN_Vrel
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_alpha)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_alpha,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_alpha,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_alpha)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_alpha.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_alpha = SrcWng_MiscVarTypeData%BN_alpha
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_phi)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_phi,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_phi,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_phi)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_phi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_phi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_phi = SrcWng_MiscVarTypeData%BN_phi
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Re)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Re,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Re,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Re)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Re(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Re.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Re = SrcWng_MiscVarTypeData%BN_Re
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_URelWind_s)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_URelWind_s,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_URelWind_s,1)
  i2_l = LBOUND(SrcWng_MiscVarTypeData%BN_URelWind_s,2)
  i2_u = UBOUND(SrcWng_MiscVarTypeData%BN_URelWind_s,2)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_URelWind_s)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_URelWind_s(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_URelWind_s.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_URelWind_s = SrcWng_MiscVarTypeData%BN_URelWind_s
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cl_Static)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cl_Static,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cl_Static,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cl_Static)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cl_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cl_Static.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cl_Static = SrcWng_MiscVarTypeData%BN_Cl_Static
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cd_Static)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cd_Static,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cd_Static,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cd_Static)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cd_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cd_Static.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cd_Static = SrcWng_MiscVarTypeData%BN_Cd_Static
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cm_Static)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cm_Static,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cm_Static,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cm_Static)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cm_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cm_Static.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cm_Static = SrcWng_MiscVarTypeData%BN_Cm_Static
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cl)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cl,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cl,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cl)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cl.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cl = SrcWng_MiscVarTypeData%BN_Cl
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cd)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cd,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cd,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cd)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cd = SrcWng_MiscVarTypeData%BN_Cd
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cm)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cm,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cm,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cm)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cm = SrcWng_MiscVarTypeData%BN_Cm
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cx)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cx,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cx,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cx)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cx = SrcWng_MiscVarTypeData%BN_Cx
ENDIF
IF (ALLOCATED(SrcWng_MiscVarTypeData%BN_Cy)) THEN
  i1_l = LBOUND(SrcWng_MiscVarTypeData%BN_Cy,1)
  i1_u = UBOUND(SrcWng_MiscVarTypeData%BN_Cy,1)
  IF (.NOT. ALLOCATED(DstWng_MiscVarTypeData%BN_Cy)) THEN 
    ALLOCATE(DstWng_MiscVarTypeData%BN_Cy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_MiscVarTypeData%BN_Cy.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_MiscVarTypeData%BN_Cy = SrcWng_MiscVarTypeData%BN_Cy
ENDIF
 END SUBROUTINE FVW_CopyWng_MiscVarType

 SUBROUTINE FVW_DestroyWng_MiscVarType( Wng_MiscVarTypeData, ErrStat, ErrMsg )
  TYPE(Wng_MiscVarType), INTENT(INOUT) :: Wng_MiscVarTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_MiscVarType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_MiscVarTypeData%LE)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%LE)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%TE)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%TE)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%r_LL)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%r_LL)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%CP)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%CP)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Tang)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Tang)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Norm)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Norm)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Orth)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Orth)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%dl)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%dl)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Area)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Area)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%diag_LL)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%diag_LL)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vind_CP)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vind_CP)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vtot_CP)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vtot_CP)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vstr_CP)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vstr_CP)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vwnd_CP)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vwnd_CP)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vwnd_NW)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vwnd_NW)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vwnd_FW)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vwnd_FW)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vind_NW)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vind_NW)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vind_FW)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vind_FW)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%PitchAndTwist)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%PitchAndTwist)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%alpha_LL)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%alpha_LL)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%Vreln_LL)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vreln_LL)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%u_UA)) THEN
DO i2 = LBOUND(Wng_MiscVarTypeData%u_UA,2), UBOUND(Wng_MiscVarTypeData%u_UA,2)
DO i1 = LBOUND(Wng_MiscVarTypeData%u_UA,1), UBOUND(Wng_MiscVarTypeData%u_UA,1)
  CALL UA_DestroyInput( Wng_MiscVarTypeData%u_UA(i1,i2), ErrStat, ErrMsg )
ENDDO
ENDDO
  DEALLOCATE(Wng_MiscVarTypeData%u_UA)
ENDIF
  CALL UA_DestroyMisc( Wng_MiscVarTypeData%m_UA, ErrStat, ErrMsg )
  CALL UA_DestroyOutput( Wng_MiscVarTypeData%y_UA, ErrStat, ErrMsg )
  CALL UA_DestroyParam( Wng_MiscVarTypeData%p_UA, ErrStat, ErrMsg )
IF (ALLOCATED(Wng_MiscVarTypeData%Vind_LL)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%Vind_LL)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_AxInd)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_AxInd)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_TanInd)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_TanInd)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Vrel)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Vrel)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_alpha)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_alpha)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_phi)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_phi)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Re)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Re)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_URelWind_s)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_URelWind_s)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cl_Static)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cl_Static)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cd_Static)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cd_Static)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cm_Static)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cm_Static)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cl)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cl)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cd)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cd)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cm)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cm)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cx)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cx)
ENDIF
IF (ALLOCATED(Wng_MiscVarTypeData%BN_Cy)) THEN
  DEALLOCATE(Wng_MiscVarTypeData%BN_Cy)
ENDIF
 END SUBROUTINE FVW_DestroyWng_MiscVarType

 SUBROUTINE FVW_PackWng_MiscVarType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_MiscVarType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! LE allocated yes/no
  IF ( ALLOCATED(InData%LE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! LE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LE)  ! LE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TE allocated yes/no
  IF ( ALLOCATED(InData%TE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TE)  ! TE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! r_LL allocated yes/no
  IF ( ALLOCATED(InData%r_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! r_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_LL)  ! r_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CP allocated yes/no
  IF ( ALLOCATED(InData%CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CP)  ! CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Tang allocated yes/no
  IF ( ALLOCATED(InData%Tang) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Tang upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Tang)  ! Tang
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Norm allocated yes/no
  IF ( ALLOCATED(InData%Norm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Norm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Norm)  ! Norm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Orth allocated yes/no
  IF ( ALLOCATED(InData%Orth) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Orth upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Orth)  ! Orth
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dl allocated yes/no
  IF ( ALLOCATED(InData%dl) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! dl upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dl)  ! dl
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Area allocated yes/no
  IF ( ALLOCATED(InData%Area) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Area upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Area)  ! Area
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! diag_LL allocated yes/no
  IF ( ALLOCATED(InData%diag_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! diag_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%diag_LL)  ! diag_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vind_CP allocated yes/no
  IF ( ALLOCATED(InData%Vind_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vind_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vind_CP)  ! Vind_CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vtot_CP allocated yes/no
  IF ( ALLOCATED(InData%Vtot_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vtot_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vtot_CP)  ! Vtot_CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vstr_CP allocated yes/no
  IF ( ALLOCATED(InData%Vstr_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vstr_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vstr_CP)  ! Vstr_CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vwnd_CP allocated yes/no
  IF ( ALLOCATED(InData%Vwnd_CP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vwnd_CP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vwnd_CP)  ! Vwnd_CP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vwnd_NW allocated yes/no
  IF ( ALLOCATED(InData%Vwnd_NW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vwnd_NW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vwnd_NW)  ! Vwnd_NW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vwnd_FW allocated yes/no
  IF ( ALLOCATED(InData%Vwnd_FW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vwnd_FW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vwnd_FW)  ! Vwnd_FW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vind_NW allocated yes/no
  IF ( ALLOCATED(InData%Vind_NW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vind_NW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vind_NW)  ! Vind_NW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vind_FW allocated yes/no
  IF ( ALLOCATED(InData%Vind_FW) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Vind_FW upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vind_FW)  ! Vind_FW
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PitchAndTwist allocated yes/no
  IF ( ALLOCATED(InData%PitchAndTwist) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! PitchAndTwist upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PitchAndTwist)  ! PitchAndTwist
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! iTip
      Int_BufSz  = Int_BufSz  + 1  ! iRoot
  Int_BufSz   = Int_BufSz   + 1     ! alpha_LL allocated yes/no
  IF ( ALLOCATED(InData%alpha_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! alpha_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%alpha_LL)  ! alpha_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vreln_LL allocated yes/no
  IF ( ALLOCATED(InData%Vreln_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Vreln_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vreln_LL)  ! Vreln_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! u_UA allocated yes/no
  IF ( ALLOCATED(InData%u_UA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! u_UA upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i2 = LBOUND(InData%u_UA,2), UBOUND(InData%u_UA,2)
    DO i1 = LBOUND(InData%u_UA,1), UBOUND(InData%u_UA,1)
      Int_BufSz   = Int_BufSz + 3  ! u_UA: size of buffers for each call to pack subtype
      CALL UA_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_UA(i1,i2), ErrStat2, ErrMsg2, .TRUE. ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! u_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! u_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! u_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
    END DO
  END IF
      Int_BufSz   = Int_BufSz + 3  ! m_UA: size of buffers for each call to pack subtype
      CALL UA_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%m_UA, ErrStat2, ErrMsg2, .TRUE. ) ! m_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! m_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! m_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! m_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! y_UA: size of buffers for each call to pack subtype
      CALL UA_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_UA, ErrStat2, ErrMsg2, .TRUE. ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! y_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! y_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! y_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! p_UA: size of buffers for each call to pack subtype
      CALL UA_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%p_UA, ErrStat2, ErrMsg2, .TRUE. ) ! p_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! p_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! p_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! p_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vind_LL allocated yes/no
  IF ( ALLOCATED(InData%Vind_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vind_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vind_LL)  ! Vind_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_AxInd allocated yes/no
  IF ( ALLOCATED(InData%BN_AxInd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_AxInd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_AxInd)  ! BN_AxInd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_TanInd allocated yes/no
  IF ( ALLOCATED(InData%BN_TanInd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_TanInd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_TanInd)  ! BN_TanInd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Vrel allocated yes/no
  IF ( ALLOCATED(InData%BN_Vrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Vrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Vrel)  ! BN_Vrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_alpha allocated yes/no
  IF ( ALLOCATED(InData%BN_alpha) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_alpha upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_alpha)  ! BN_alpha
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_phi allocated yes/no
  IF ( ALLOCATED(InData%BN_phi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_phi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_phi)  ! BN_phi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Re allocated yes/no
  IF ( ALLOCATED(InData%BN_Re) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Re upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Re)  ! BN_Re
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_URelWind_s allocated yes/no
  IF ( ALLOCATED(InData%BN_URelWind_s) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BN_URelWind_s upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_URelWind_s)  ! BN_URelWind_s
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cl_Static allocated yes/no
  IF ( ALLOCATED(InData%BN_Cl_Static) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cl_Static upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cl_Static)  ! BN_Cl_Static
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cd_Static allocated yes/no
  IF ( ALLOCATED(InData%BN_Cd_Static) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cd_Static upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cd_Static)  ! BN_Cd_Static
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cm_Static allocated yes/no
  IF ( ALLOCATED(InData%BN_Cm_Static) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cm_Static upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cm_Static)  ! BN_Cm_Static
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cl allocated yes/no
  IF ( ALLOCATED(InData%BN_Cl) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cl upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cl)  ! BN_Cl
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cd allocated yes/no
  IF ( ALLOCATED(InData%BN_Cd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cd)  ! BN_Cd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cm allocated yes/no
  IF ( ALLOCATED(InData%BN_Cm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cm)  ! BN_Cm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cx allocated yes/no
  IF ( ALLOCATED(InData%BN_Cx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cx)  ! BN_Cx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BN_Cy allocated yes/no
  IF ( ALLOCATED(InData%BN_Cy) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BN_Cy upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BN_Cy)  ! BN_Cy
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%LE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LE,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%LE,2), UBOUND(InData%LE,2)
        DO i1 = LBOUND(InData%LE,1), UBOUND(InData%LE,1)
          ReKiBuf(Re_Xferred) = InData%LE(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TE,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TE,2), UBOUND(InData%TE,2)
        DO i1 = LBOUND(InData%TE,1), UBOUND(InData%TE,1)
          ReKiBuf(Re_Xferred) = InData%TE(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%r_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_LL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_LL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_LL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_LL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_LL,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%r_LL,3), UBOUND(InData%r_LL,3)
        DO i2 = LBOUND(InData%r_LL,2), UBOUND(InData%r_LL,2)
          DO i1 = LBOUND(InData%r_LL,1), UBOUND(InData%r_LL,1)
            ReKiBuf(Re_Xferred) = InData%r_LL(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%CP,2), UBOUND(InData%CP,2)
        DO i1 = LBOUND(InData%CP,1), UBOUND(InData%CP,1)
          ReKiBuf(Re_Xferred) = InData%CP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Tang) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Tang,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Tang,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Tang,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Tang,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Tang,2), UBOUND(InData%Tang,2)
        DO i1 = LBOUND(InData%Tang,1), UBOUND(InData%Tang,1)
          ReKiBuf(Re_Xferred) = InData%Tang(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Norm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Norm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Norm,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Norm,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Norm,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Norm,2), UBOUND(InData%Norm,2)
        DO i1 = LBOUND(InData%Norm,1), UBOUND(InData%Norm,1)
          ReKiBuf(Re_Xferred) = InData%Norm(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Orth) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Orth,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Orth,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Orth,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Orth,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Orth,2), UBOUND(InData%Orth,2)
        DO i1 = LBOUND(InData%Orth,1), UBOUND(InData%Orth,1)
          ReKiBuf(Re_Xferred) = InData%Orth(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dl) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dl,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dl,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dl,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dl,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%dl,2), UBOUND(InData%dl,2)
        DO i1 = LBOUND(InData%dl,1), UBOUND(InData%dl,1)
          ReKiBuf(Re_Xferred) = InData%dl(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Area) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Area,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Area,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Area,1), UBOUND(InData%Area,1)
        ReKiBuf(Re_Xferred) = InData%Area(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%diag_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%diag_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%diag_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%diag_LL,1), UBOUND(InData%diag_LL,1)
        ReKiBuf(Re_Xferred) = InData%diag_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vind_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_CP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_CP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_CP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vind_CP,2), UBOUND(InData%Vind_CP,2)
        DO i1 = LBOUND(InData%Vind_CP,1), UBOUND(InData%Vind_CP,1)
          ReKiBuf(Re_Xferred) = InData%Vind_CP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vtot_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vtot_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vtot_CP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vtot_CP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vtot_CP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vtot_CP,2), UBOUND(InData%Vtot_CP,2)
        DO i1 = LBOUND(InData%Vtot_CP,1), UBOUND(InData%Vtot_CP,1)
          ReKiBuf(Re_Xferred) = InData%Vtot_CP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vstr_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vstr_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vstr_CP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vstr_CP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vstr_CP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vstr_CP,2), UBOUND(InData%Vstr_CP,2)
        DO i1 = LBOUND(InData%Vstr_CP,1), UBOUND(InData%Vstr_CP,1)
          ReKiBuf(Re_Xferred) = InData%Vstr_CP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vwnd_CP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_CP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_CP,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_CP,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_CP,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vwnd_CP,2), UBOUND(InData%Vwnd_CP,2)
        DO i1 = LBOUND(InData%Vwnd_CP,1), UBOUND(InData%Vwnd_CP,1)
          ReKiBuf(Re_Xferred) = InData%Vwnd_CP(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vwnd_NW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_NW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_NW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_NW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_NW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_NW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_NW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vwnd_NW,3), UBOUND(InData%Vwnd_NW,3)
        DO i2 = LBOUND(InData%Vwnd_NW,2), UBOUND(InData%Vwnd_NW,2)
          DO i1 = LBOUND(InData%Vwnd_NW,1), UBOUND(InData%Vwnd_NW,1)
            ReKiBuf(Re_Xferred) = InData%Vwnd_NW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vwnd_FW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_FW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_FW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_FW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_FW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_FW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_FW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vwnd_FW,3), UBOUND(InData%Vwnd_FW,3)
        DO i2 = LBOUND(InData%Vwnd_FW,2), UBOUND(InData%Vwnd_FW,2)
          DO i1 = LBOUND(InData%Vwnd_FW,1), UBOUND(InData%Vwnd_FW,1)
            ReKiBuf(Re_Xferred) = InData%Vwnd_FW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vind_NW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_NW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_NW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_NW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_NW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_NW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_NW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vind_NW,3), UBOUND(InData%Vind_NW,3)
        DO i2 = LBOUND(InData%Vind_NW,2), UBOUND(InData%Vind_NW,2)
          DO i1 = LBOUND(InData%Vind_NW,1), UBOUND(InData%Vind_NW,1)
            ReKiBuf(Re_Xferred) = InData%Vind_NW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vind_FW) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_FW,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_FW,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_FW,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_FW,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_FW,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_FW,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Vind_FW,3), UBOUND(InData%Vind_FW,3)
        DO i2 = LBOUND(InData%Vind_FW,2), UBOUND(InData%Vind_FW,2)
          DO i1 = LBOUND(InData%Vind_FW,1), UBOUND(InData%Vind_FW,1)
            ReKiBuf(Re_Xferred) = InData%Vind_FW(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PitchAndTwist) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PitchAndTwist,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PitchAndTwist,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%PitchAndTwist,1), UBOUND(InData%PitchAndTwist,1)
        ReKiBuf(Re_Xferred) = InData%PitchAndTwist(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%iTip
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%iRoot
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%alpha_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%alpha_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%alpha_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%alpha_LL,1), UBOUND(InData%alpha_LL,1)
        ReKiBuf(Re_Xferred) = InData%alpha_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vreln_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vreln_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vreln_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Vreln_LL,1), UBOUND(InData%Vreln_LL,1)
        ReKiBuf(Re_Xferred) = InData%Vreln_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%u_UA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_UA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_UA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_UA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_UA,2)
    Int_Xferred = Int_Xferred + 2

    DO i2 = LBOUND(InData%u_UA,2), UBOUND(InData%u_UA,2)
    DO i1 = LBOUND(InData%u_UA,1), UBOUND(InData%u_UA,1)
      CALL UA_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_UA(i1,i2), ErrStat2, ErrMsg2, OnlySize ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
    END DO
  END IF
      CALL UA_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%m_UA, ErrStat2, ErrMsg2, OnlySize ) ! m_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL UA_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_UA, ErrStat2, ErrMsg2, OnlySize ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL UA_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%p_UA, ErrStat2, ErrMsg2, OnlySize ) ! p_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%Vind_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_LL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vind_LL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vind_LL,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vind_LL,2), UBOUND(InData%Vind_LL,2)
        DO i1 = LBOUND(InData%Vind_LL,1), UBOUND(InData%Vind_LL,1)
          ReKiBuf(Re_Xferred) = InData%Vind_LL(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_AxInd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_AxInd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_AxInd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_AxInd,1), UBOUND(InData%BN_AxInd,1)
        ReKiBuf(Re_Xferred) = InData%BN_AxInd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_TanInd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_TanInd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_TanInd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_TanInd,1), UBOUND(InData%BN_TanInd,1)
        ReKiBuf(Re_Xferred) = InData%BN_TanInd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Vrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Vrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Vrel,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Vrel,1), UBOUND(InData%BN_Vrel,1)
        ReKiBuf(Re_Xferred) = InData%BN_Vrel(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_alpha) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_alpha,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_alpha,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_alpha,1), UBOUND(InData%BN_alpha,1)
        ReKiBuf(Re_Xferred) = InData%BN_alpha(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_phi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_phi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_phi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_phi,1), UBOUND(InData%BN_phi,1)
        ReKiBuf(Re_Xferred) = InData%BN_phi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Re) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Re,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Re,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Re,1), UBOUND(InData%BN_Re,1)
        ReKiBuf(Re_Xferred) = InData%BN_Re(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_URelWind_s) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_URelWind_s,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_URelWind_s,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_URelWind_s,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_URelWind_s,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BN_URelWind_s,2), UBOUND(InData%BN_URelWind_s,2)
        DO i1 = LBOUND(InData%BN_URelWind_s,1), UBOUND(InData%BN_URelWind_s,1)
          ReKiBuf(Re_Xferred) = InData%BN_URelWind_s(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cl_Static) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cl_Static,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cl_Static,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cl_Static,1), UBOUND(InData%BN_Cl_Static,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cl_Static(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cd_Static) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cd_Static,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cd_Static,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cd_Static,1), UBOUND(InData%BN_Cd_Static,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cd_Static(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cm_Static) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cm_Static,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cm_Static,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cm_Static,1), UBOUND(InData%BN_Cm_Static,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cm_Static(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cl) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cl,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cl,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cl,1), UBOUND(InData%BN_Cl,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cl(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cd,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cd,1), UBOUND(InData%BN_Cd,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cd(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cm,1), UBOUND(InData%BN_Cm,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cx,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cx,1), UBOUND(InData%BN_Cx,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cx(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BN_Cy) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BN_Cy,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BN_Cy,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%BN_Cy,1), UBOUND(InData%BN_Cy,1)
        ReKiBuf(Re_Xferred) = InData%BN_Cy(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_MiscVarType

 SUBROUTINE FVW_UnPackWng_MiscVarType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_MiscVarType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LE)) DEALLOCATE(OutData%LE)
    ALLOCATE(OutData%LE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%LE,2), UBOUND(OutData%LE,2)
        DO i1 = LBOUND(OutData%LE,1), UBOUND(OutData%LE,1)
          OutData%LE(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TE)) DEALLOCATE(OutData%TE)
    ALLOCATE(OutData%TE(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TE,2), UBOUND(OutData%TE,2)
        DO i1 = LBOUND(OutData%TE,1), UBOUND(OutData%TE,1)
          OutData%TE(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_LL)) DEALLOCATE(OutData%r_LL)
    ALLOCATE(OutData%r_LL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%r_LL,3), UBOUND(OutData%r_LL,3)
        DO i2 = LBOUND(OutData%r_LL,2), UBOUND(OutData%r_LL,2)
          DO i1 = LBOUND(OutData%r_LL,1), UBOUND(OutData%r_LL,1)
            OutData%r_LL(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CP)) DEALLOCATE(OutData%CP)
    ALLOCATE(OutData%CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%CP,2), UBOUND(OutData%CP,2)
        DO i1 = LBOUND(OutData%CP,1), UBOUND(OutData%CP,1)
          OutData%CP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Tang not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Tang)) DEALLOCATE(OutData%Tang)
    ALLOCATE(OutData%Tang(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Tang.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Tang,2), UBOUND(OutData%Tang,2)
        DO i1 = LBOUND(OutData%Tang,1), UBOUND(OutData%Tang,1)
          OutData%Tang(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Norm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Norm)) DEALLOCATE(OutData%Norm)
    ALLOCATE(OutData%Norm(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Norm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Norm,2), UBOUND(OutData%Norm,2)
        DO i1 = LBOUND(OutData%Norm,1), UBOUND(OutData%Norm,1)
          OutData%Norm(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Orth not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Orth)) DEALLOCATE(OutData%Orth)
    ALLOCATE(OutData%Orth(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Orth.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Orth,2), UBOUND(OutData%Orth,2)
        DO i1 = LBOUND(OutData%Orth,1), UBOUND(OutData%Orth,1)
          OutData%Orth(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dl not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dl)) DEALLOCATE(OutData%dl)
    ALLOCATE(OutData%dl(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dl.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%dl,2), UBOUND(OutData%dl,2)
        DO i1 = LBOUND(OutData%dl,1), UBOUND(OutData%dl,1)
          OutData%dl(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Area not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Area)) DEALLOCATE(OutData%Area)
    ALLOCATE(OutData%Area(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Area.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Area,1), UBOUND(OutData%Area,1)
        OutData%Area(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! diag_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%diag_LL)) DEALLOCATE(OutData%diag_LL)
    ALLOCATE(OutData%diag_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%diag_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%diag_LL,1), UBOUND(OutData%diag_LL,1)
        OutData%diag_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vind_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vind_CP)) DEALLOCATE(OutData%Vind_CP)
    ALLOCATE(OutData%Vind_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vind_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vind_CP,2), UBOUND(OutData%Vind_CP,2)
        DO i1 = LBOUND(OutData%Vind_CP,1), UBOUND(OutData%Vind_CP,1)
          OutData%Vind_CP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vtot_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vtot_CP)) DEALLOCATE(OutData%Vtot_CP)
    ALLOCATE(OutData%Vtot_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vtot_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vtot_CP,2), UBOUND(OutData%Vtot_CP,2)
        DO i1 = LBOUND(OutData%Vtot_CP,1), UBOUND(OutData%Vtot_CP,1)
          OutData%Vtot_CP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vstr_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vstr_CP)) DEALLOCATE(OutData%Vstr_CP)
    ALLOCATE(OutData%Vstr_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vstr_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vstr_CP,2), UBOUND(OutData%Vstr_CP,2)
        DO i1 = LBOUND(OutData%Vstr_CP,1), UBOUND(OutData%Vstr_CP,1)
          OutData%Vstr_CP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vwnd_CP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vwnd_CP)) DEALLOCATE(OutData%Vwnd_CP)
    ALLOCATE(OutData%Vwnd_CP(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vwnd_CP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vwnd_CP,2), UBOUND(OutData%Vwnd_CP,2)
        DO i1 = LBOUND(OutData%Vwnd_CP,1), UBOUND(OutData%Vwnd_CP,1)
          OutData%Vwnd_CP(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vwnd_NW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vwnd_NW)) DEALLOCATE(OutData%Vwnd_NW)
    ALLOCATE(OutData%Vwnd_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vwnd_NW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vwnd_NW,3), UBOUND(OutData%Vwnd_NW,3)
        DO i2 = LBOUND(OutData%Vwnd_NW,2), UBOUND(OutData%Vwnd_NW,2)
          DO i1 = LBOUND(OutData%Vwnd_NW,1), UBOUND(OutData%Vwnd_NW,1)
            OutData%Vwnd_NW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vwnd_FW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vwnd_FW)) DEALLOCATE(OutData%Vwnd_FW)
    ALLOCATE(OutData%Vwnd_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vwnd_FW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vwnd_FW,3), UBOUND(OutData%Vwnd_FW,3)
        DO i2 = LBOUND(OutData%Vwnd_FW,2), UBOUND(OutData%Vwnd_FW,2)
          DO i1 = LBOUND(OutData%Vwnd_FW,1), UBOUND(OutData%Vwnd_FW,1)
            OutData%Vwnd_FW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vind_NW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vind_NW)) DEALLOCATE(OutData%Vind_NW)
    ALLOCATE(OutData%Vind_NW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vind_NW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vind_NW,3), UBOUND(OutData%Vind_NW,3)
        DO i2 = LBOUND(OutData%Vind_NW,2), UBOUND(OutData%Vind_NW,2)
          DO i1 = LBOUND(OutData%Vind_NW,1), UBOUND(OutData%Vind_NW,1)
            OutData%Vind_NW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vind_FW not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vind_FW)) DEALLOCATE(OutData%Vind_FW)
    ALLOCATE(OutData%Vind_FW(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vind_FW.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Vind_FW,3), UBOUND(OutData%Vind_FW,3)
        DO i2 = LBOUND(OutData%Vind_FW,2), UBOUND(OutData%Vind_FW,2)
          DO i1 = LBOUND(OutData%Vind_FW,1), UBOUND(OutData%Vind_FW,1)
            OutData%Vind_FW(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PitchAndTwist not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PitchAndTwist)) DEALLOCATE(OutData%PitchAndTwist)
    ALLOCATE(OutData%PitchAndTwist(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PitchAndTwist.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%PitchAndTwist,1), UBOUND(OutData%PitchAndTwist,1)
        OutData%PitchAndTwist(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%iTip = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%iRoot = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! alpha_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%alpha_LL)) DEALLOCATE(OutData%alpha_LL)
    ALLOCATE(OutData%alpha_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%alpha_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%alpha_LL,1), UBOUND(OutData%alpha_LL,1)
        OutData%alpha_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vreln_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vreln_LL)) DEALLOCATE(OutData%Vreln_LL)
    ALLOCATE(OutData%Vreln_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vreln_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Vreln_LL,1), UBOUND(OutData%Vreln_LL,1)
        OutData%Vreln_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! u_UA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%u_UA)) DEALLOCATE(OutData%u_UA)
    ALLOCATE(OutData%u_UA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_UA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i2 = LBOUND(OutData%u_UA,2), UBOUND(OutData%u_UA,2)
    DO i1 = LBOUND(OutData%u_UA,1), UBOUND(OutData%u_UA,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackInput( Re_Buf, Db_Buf, Int_Buf, OutData%u_UA(i1,i2), ErrStat2, ErrMsg2 ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
    END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackMisc( Re_Buf, Db_Buf, Int_Buf, OutData%m_UA, ErrStat2, ErrMsg2 ) ! m_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackOutput( Re_Buf, Db_Buf, Int_Buf, OutData%y_UA, ErrStat2, ErrMsg2 ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%p_UA, ErrStat2, ErrMsg2 ) ! p_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vind_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vind_LL)) DEALLOCATE(OutData%Vind_LL)
    ALLOCATE(OutData%Vind_LL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vind_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vind_LL,2), UBOUND(OutData%Vind_LL,2)
        DO i1 = LBOUND(OutData%Vind_LL,1), UBOUND(OutData%Vind_LL,1)
          OutData%Vind_LL(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_AxInd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_AxInd)) DEALLOCATE(OutData%BN_AxInd)
    ALLOCATE(OutData%BN_AxInd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_AxInd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_AxInd,1), UBOUND(OutData%BN_AxInd,1)
        OutData%BN_AxInd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_TanInd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_TanInd)) DEALLOCATE(OutData%BN_TanInd)
    ALLOCATE(OutData%BN_TanInd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_TanInd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_TanInd,1), UBOUND(OutData%BN_TanInd,1)
        OutData%BN_TanInd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Vrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Vrel)) DEALLOCATE(OutData%BN_Vrel)
    ALLOCATE(OutData%BN_Vrel(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Vrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Vrel,1), UBOUND(OutData%BN_Vrel,1)
        OutData%BN_Vrel(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_alpha not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_alpha)) DEALLOCATE(OutData%BN_alpha)
    ALLOCATE(OutData%BN_alpha(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_alpha.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_alpha,1), UBOUND(OutData%BN_alpha,1)
        OutData%BN_alpha(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_phi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_phi)) DEALLOCATE(OutData%BN_phi)
    ALLOCATE(OutData%BN_phi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_phi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_phi,1), UBOUND(OutData%BN_phi,1)
        OutData%BN_phi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Re not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Re)) DEALLOCATE(OutData%BN_Re)
    ALLOCATE(OutData%BN_Re(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Re.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Re,1), UBOUND(OutData%BN_Re,1)
        OutData%BN_Re(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_URelWind_s not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_URelWind_s)) DEALLOCATE(OutData%BN_URelWind_s)
    ALLOCATE(OutData%BN_URelWind_s(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_URelWind_s.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BN_URelWind_s,2), UBOUND(OutData%BN_URelWind_s,2)
        DO i1 = LBOUND(OutData%BN_URelWind_s,1), UBOUND(OutData%BN_URelWind_s,1)
          OutData%BN_URelWind_s(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cl_Static not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cl_Static)) DEALLOCATE(OutData%BN_Cl_Static)
    ALLOCATE(OutData%BN_Cl_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cl_Static.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cl_Static,1), UBOUND(OutData%BN_Cl_Static,1)
        OutData%BN_Cl_Static(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cd_Static not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cd_Static)) DEALLOCATE(OutData%BN_Cd_Static)
    ALLOCATE(OutData%BN_Cd_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cd_Static.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cd_Static,1), UBOUND(OutData%BN_Cd_Static,1)
        OutData%BN_Cd_Static(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cm_Static not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cm_Static)) DEALLOCATE(OutData%BN_Cm_Static)
    ALLOCATE(OutData%BN_Cm_Static(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cm_Static.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cm_Static,1), UBOUND(OutData%BN_Cm_Static,1)
        OutData%BN_Cm_Static(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cl not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cl)) DEALLOCATE(OutData%BN_Cl)
    ALLOCATE(OutData%BN_Cl(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cl.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cl,1), UBOUND(OutData%BN_Cl,1)
        OutData%BN_Cl(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cd)) DEALLOCATE(OutData%BN_Cd)
    ALLOCATE(OutData%BN_Cd(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cd,1), UBOUND(OutData%BN_Cd,1)
        OutData%BN_Cd(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cm)) DEALLOCATE(OutData%BN_Cm)
    ALLOCATE(OutData%BN_Cm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cm,1), UBOUND(OutData%BN_Cm,1)
        OutData%BN_Cm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cx)) DEALLOCATE(OutData%BN_Cx)
    ALLOCATE(OutData%BN_Cx(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cx,1), UBOUND(OutData%BN_Cx,1)
        OutData%BN_Cx(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BN_Cy not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BN_Cy)) DEALLOCATE(OutData%BN_Cy)
    ALLOCATE(OutData%BN_Cy(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BN_Cy.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%BN_Cy,1), UBOUND(OutData%BN_Cy,1)
        OutData%BN_Cy(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_MiscVarType

 SUBROUTINE FVW_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(FVW_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%W)) THEN
  i1_l = LBOUND(SrcMiscData%W,1)
  i1_u = UBOUND(SrcMiscData%W,1)
  IF (.NOT. ALLOCATED(DstMiscData%W)) THEN 
    ALLOCATE(DstMiscData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%W,1), UBOUND(SrcMiscData%W,1)
      CALL FVW_Copywng_miscvartype( SrcMiscData%W(i1), DstMiscData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstMiscData%FirstCall = SrcMiscData%FirstCall
    DstMiscData%nNW = SrcMiscData%nNW
    DstMiscData%nFW = SrcMiscData%nFW
    DstMiscData%iStep = SrcMiscData%iStep
    DstMiscData%VTKstep = SrcMiscData%VTKstep
    DstMiscData%VTKlastTime = SrcMiscData%VTKlastTime
IF (ALLOCATED(SrcMiscData%r_wind)) THEN
  i1_l = LBOUND(SrcMiscData%r_wind,1)
  i1_u = UBOUND(SrcMiscData%r_wind,1)
  i2_l = LBOUND(SrcMiscData%r_wind,2)
  i2_u = UBOUND(SrcMiscData%r_wind,2)
  IF (.NOT. ALLOCATED(DstMiscData%r_wind)) THEN 
    ALLOCATE(DstMiscData%r_wind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%r_wind.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%r_wind = SrcMiscData%r_wind
ENDIF
    DstMiscData%ComputeWakeInduced = SrcMiscData%ComputeWakeInduced
    DstMiscData%OldWakeTime = SrcMiscData%OldWakeTime
      CALL FVW_CopyContState( SrcMiscData%dxdt, DstMiscData%dxdt, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL FVW_CopyContState( SrcMiscData%x1, DstMiscData%x1, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL FVW_CopyContState( SrcMiscData%x2, DstMiscData%x2, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstMiscData%t1 = SrcMiscData%t1
    DstMiscData%t2 = SrcMiscData%t2
    DstMiscData%UA_Flag = SrcMiscData%UA_Flag
      CALL FVW_Copyt_sgmt( SrcMiscData%Sgmt, DstMiscData%Sgmt, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcMiscData%CPs)) THEN
  i1_l = LBOUND(SrcMiscData%CPs,1)
  i1_u = UBOUND(SrcMiscData%CPs,1)
  i2_l = LBOUND(SrcMiscData%CPs,2)
  i2_u = UBOUND(SrcMiscData%CPs,2)
  IF (.NOT. ALLOCATED(DstMiscData%CPs)) THEN 
    ALLOCATE(DstMiscData%CPs(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CPs.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%CPs = SrcMiscData%CPs
ENDIF
IF (ALLOCATED(SrcMiscData%Uind)) THEN
  i1_l = LBOUND(SrcMiscData%Uind,1)
  i1_u = UBOUND(SrcMiscData%Uind,1)
  i2_l = LBOUND(SrcMiscData%Uind,2)
  i2_u = UBOUND(SrcMiscData%Uind,2)
  IF (.NOT. ALLOCATED(DstMiscData%Uind)) THEN 
    ALLOCATE(DstMiscData%Uind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Uind.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Uind = SrcMiscData%Uind
ENDIF
IF (ALLOCATED(SrcMiscData%GridOutputs)) THEN
  i1_l = LBOUND(SrcMiscData%GridOutputs,1)
  i1_u = UBOUND(SrcMiscData%GridOutputs,1)
  IF (.NOT. ALLOCATED(DstMiscData%GridOutputs)) THEN 
    ALLOCATE(DstMiscData%GridOutputs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%GridOutputs.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%GridOutputs,1), UBOUND(SrcMiscData%GridOutputs,1)
      CALL FVW_Copygridouttype( SrcMiscData%GridOutputs(i1), DstMiscData%GridOutputs(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE FVW_CopyMisc

 SUBROUTINE FVW_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(FVW_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%W)) THEN
DO i1 = LBOUND(MiscData%W,1), UBOUND(MiscData%W,1)
  CALL FVW_Destroywng_miscvartype( MiscData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%W)
ENDIF
IF (ALLOCATED(MiscData%r_wind)) THEN
  DEALLOCATE(MiscData%r_wind)
ENDIF
  CALL FVW_DestroyContState( MiscData%dxdt, ErrStat, ErrMsg )
  CALL FVW_DestroyContState( MiscData%x1, ErrStat, ErrMsg )
  CALL FVW_DestroyContState( MiscData%x2, ErrStat, ErrMsg )
  CALL FVW_Destroyt_sgmt( MiscData%Sgmt, ErrStat, ErrMsg )
IF (ALLOCATED(MiscData%CPs)) THEN
  DEALLOCATE(MiscData%CPs)
ENDIF
IF (ALLOCATED(MiscData%Uind)) THEN
  DEALLOCATE(MiscData%Uind)
ENDIF
IF (ALLOCATED(MiscData%GridOutputs)) THEN
DO i1 = LBOUND(MiscData%GridOutputs,1), UBOUND(MiscData%GridOutputs,1)
  CALL FVW_Destroygridouttype( MiscData%GridOutputs(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%GridOutputs)
ENDIF
 END SUBROUTINE FVW_DestroyMisc

 SUBROUTINE FVW_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_miscvartype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! FirstCall
      Int_BufSz  = Int_BufSz  + 1  ! nNW
      Int_BufSz  = Int_BufSz  + 1  ! nFW
      Int_BufSz  = Int_BufSz  + 1  ! iStep
      Int_BufSz  = Int_BufSz  + 1  ! VTKstep
      Db_BufSz   = Db_BufSz   + 1  ! VTKlastTime
  Int_BufSz   = Int_BufSz   + 1     ! r_wind allocated yes/no
  IF ( ALLOCATED(InData%r_wind) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! r_wind upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%r_wind)  ! r_wind
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! ComputeWakeInduced
      Db_BufSz   = Db_BufSz   + 1  ! OldWakeTime
      Int_BufSz   = Int_BufSz + 3  ! dxdt: size of buffers for each call to pack subtype
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%dxdt, ErrStat2, ErrMsg2, .TRUE. ) ! dxdt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! dxdt
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! dxdt
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! dxdt
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! x1: size of buffers for each call to pack subtype
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%x1, ErrStat2, ErrMsg2, .TRUE. ) ! x1 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! x1
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! x1
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! x1
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! x2: size of buffers for each call to pack subtype
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%x2, ErrStat2, ErrMsg2, .TRUE. ) ! x2 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! x2
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! x2
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! x2
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Db_BufSz   = Db_BufSz   + 1  ! t1
      Db_BufSz   = Db_BufSz   + 1  ! t2
      Int_BufSz  = Int_BufSz  + 1  ! UA_Flag
      Int_BufSz   = Int_BufSz + 3  ! Sgmt: size of buffers for each call to pack subtype
      CALL FVW_Packt_sgmt( Re_Buf, Db_Buf, Int_Buf, InData%Sgmt, ErrStat2, ErrMsg2, .TRUE. ) ! Sgmt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Sgmt
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Sgmt
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Sgmt
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! CPs allocated yes/no
  IF ( ALLOCATED(InData%CPs) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! CPs upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CPs)  ! CPs
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Uind allocated yes/no
  IF ( ALLOCATED(InData%Uind) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Uind upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Uind)  ! Uind
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! GridOutputs allocated yes/no
  IF ( ALLOCATED(InData%GridOutputs) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! GridOutputs upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%GridOutputs,1), UBOUND(InData%GridOutputs,1)
      Int_BufSz   = Int_BufSz + 3  ! GridOutputs: size of buffers for each call to pack subtype
      CALL FVW_Packgridouttype( Re_Buf, Db_Buf, Int_Buf, InData%GridOutputs(i1), ErrStat2, ErrMsg2, .TRUE. ) ! GridOutputs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! GridOutputs
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! GridOutputs
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! GridOutputs
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_miscvartype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstCall, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nNW
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nFW
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%iStep
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VTKstep
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%VTKlastTime
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%r_wind) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_wind,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_wind,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%r_wind,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%r_wind,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%r_wind,2), UBOUND(InData%r_wind,2)
        DO i1 = LBOUND(InData%r_wind,1), UBOUND(InData%r_wind,1)
          ReKiBuf(Re_Xferred) = InData%r_wind(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ComputeWakeInduced, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%OldWakeTime
    Db_Xferred = Db_Xferred + 1
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%dxdt, ErrStat2, ErrMsg2, OnlySize ) ! dxdt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%x1, ErrStat2, ErrMsg2, OnlySize ) ! x1 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL FVW_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%x2, ErrStat2, ErrMsg2, OnlySize ) ! x2 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    DbKiBuf(Db_Xferred) = InData%t1
    Db_Xferred = Db_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%t2
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UA_Flag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
      CALL FVW_Packt_sgmt( Re_Buf, Db_Buf, Int_Buf, InData%Sgmt, ErrStat2, ErrMsg2, OnlySize ) ! Sgmt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%CPs) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CPs,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CPs,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CPs,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CPs,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%CPs,2), UBOUND(InData%CPs,2)
        DO i1 = LBOUND(InData%CPs,1), UBOUND(InData%CPs,1)
          ReKiBuf(Re_Xferred) = InData%CPs(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Uind) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Uind,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Uind,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Uind,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Uind,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Uind,2), UBOUND(InData%Uind,2)
        DO i1 = LBOUND(InData%Uind,1), UBOUND(InData%Uind,1)
          ReKiBuf(Re_Xferred) = InData%Uind(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%GridOutputs) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%GridOutputs,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%GridOutputs,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%GridOutputs,1), UBOUND(InData%GridOutputs,1)
      CALL FVW_Packgridouttype( Re_Buf, Db_Buf, Int_Buf, InData%GridOutputs(i1), ErrStat2, ErrMsg2, OnlySize ) ! GridOutputs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE FVW_PackMisc

 SUBROUTINE FVW_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_miscvartype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%FirstCall = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstCall)
    Int_Xferred = Int_Xferred + 1
    OutData%nNW = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nFW = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%iStep = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%VTKstep = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%VTKlastTime = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! r_wind not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%r_wind)) DEALLOCATE(OutData%r_wind)
    ALLOCATE(OutData%r_wind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%r_wind.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%r_wind,2), UBOUND(OutData%r_wind,2)
        DO i1 = LBOUND(OutData%r_wind,1), UBOUND(OutData%r_wind,1)
          OutData%r_wind(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%ComputeWakeInduced = TRANSFER(IntKiBuf(Int_Xferred), OutData%ComputeWakeInduced)
    Int_Xferred = Int_Xferred + 1
    OutData%OldWakeTime = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%dxdt, ErrStat2, ErrMsg2 ) ! dxdt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%x1, ErrStat2, ErrMsg2 ) ! x1 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%x2, ErrStat2, ErrMsg2 ) ! x2 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%t1 = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%t2 = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%UA_Flag = TRANSFER(IntKiBuf(Int_Xferred), OutData%UA_Flag)
    Int_Xferred = Int_Xferred + 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackt_sgmt( Re_Buf, Db_Buf, Int_Buf, OutData%Sgmt, ErrStat2, ErrMsg2 ) ! Sgmt 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CPs not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CPs)) DEALLOCATE(OutData%CPs)
    ALLOCATE(OutData%CPs(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CPs.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%CPs,2), UBOUND(OutData%CPs,2)
        DO i1 = LBOUND(OutData%CPs,1), UBOUND(OutData%CPs,1)
          OutData%CPs(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Uind not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Uind)) DEALLOCATE(OutData%Uind)
    ALLOCATE(OutData%Uind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Uind.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Uind,2), UBOUND(OutData%Uind,2)
        DO i1 = LBOUND(OutData%Uind,1), UBOUND(OutData%Uind,1)
          OutData%Uind(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! GridOutputs not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%GridOutputs)) DEALLOCATE(OutData%GridOutputs)
    ALLOCATE(OutData%GridOutputs(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%GridOutputs.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%GridOutputs,1), UBOUND(OutData%GridOutputs,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackgridouttype( Re_Buf, Db_Buf, Int_Buf, OutData%GridOutputs(i1), ErrStat2, ErrMsg2 ) ! GridOutputs 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE FVW_UnPackMisc

 SUBROUTINE FVW_CopyRot_InputType( SrcRot_InputTypeData, DstRot_InputTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Rot_InputType), INTENT(IN) :: SrcRot_InputTypeData
   TYPE(Rot_InputType), INTENT(INOUT) :: DstRot_InputTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyRot_InputType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstRot_InputTypeData%HubOrientation = SrcRot_InputTypeData%HubOrientation
    DstRot_InputTypeData%HubPosition = SrcRot_InputTypeData%HubPosition
 END SUBROUTINE FVW_CopyRot_InputType

 SUBROUTINE FVW_DestroyRot_InputType( Rot_InputTypeData, ErrStat, ErrMsg )
  TYPE(Rot_InputType), INTENT(INOUT) :: Rot_InputTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyRot_InputType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE FVW_DestroyRot_InputType

 SUBROUTINE FVW_PackRot_InputType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Rot_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackRot_InputType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + SIZE(InData%HubOrientation)  ! HubOrientation
      Re_BufSz   = Re_BufSz   + SIZE(InData%HubPosition)  ! HubPosition
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO i2 = LBOUND(InData%HubOrientation,2), UBOUND(InData%HubOrientation,2)
      DO i1 = LBOUND(InData%HubOrientation,1), UBOUND(InData%HubOrientation,1)
        ReKiBuf(Re_Xferred) = InData%HubOrientation(i1,i2)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    DO i1 = LBOUND(InData%HubPosition,1), UBOUND(InData%HubPosition,1)
      ReKiBuf(Re_Xferred) = InData%HubPosition(i1)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE FVW_PackRot_InputType

 SUBROUTINE FVW_UnPackRot_InputType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Rot_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackRot_InputType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    i1_l = LBOUND(OutData%HubOrientation,1)
    i1_u = UBOUND(OutData%HubOrientation,1)
    i2_l = LBOUND(OutData%HubOrientation,2)
    i2_u = UBOUND(OutData%HubOrientation,2)
    DO i2 = LBOUND(OutData%HubOrientation,2), UBOUND(OutData%HubOrientation,2)
      DO i1 = LBOUND(OutData%HubOrientation,1), UBOUND(OutData%HubOrientation,1)
        OutData%HubOrientation(i1,i2) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
    END DO
    i1_l = LBOUND(OutData%HubPosition,1)
    i1_u = UBOUND(OutData%HubPosition,1)
    DO i1 = LBOUND(OutData%HubPosition,1), UBOUND(OutData%HubPosition,1)
      OutData%HubPosition(i1) = ReKiBuf(Re_Xferred)
      Re_Xferred = Re_Xferred + 1
    END DO
 END SUBROUTINE FVW_UnPackRot_InputType

 SUBROUTINE FVW_CopyWng_InputType( SrcWng_InputTypeData, DstWng_InputTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_InputType), INTENT(IN) :: SrcWng_InputTypeData
   TYPE(Wng_InputType), INTENT(INOUT) :: DstWng_InputTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_InputType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_InputTypeData%Vwnd_LL)) THEN
  i1_l = LBOUND(SrcWng_InputTypeData%Vwnd_LL,1)
  i1_u = UBOUND(SrcWng_InputTypeData%Vwnd_LL,1)
  i2_l = LBOUND(SrcWng_InputTypeData%Vwnd_LL,2)
  i2_u = UBOUND(SrcWng_InputTypeData%Vwnd_LL,2)
  IF (.NOT. ALLOCATED(DstWng_InputTypeData%Vwnd_LL)) THEN 
    ALLOCATE(DstWng_InputTypeData%Vwnd_LL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InputTypeData%Vwnd_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_InputTypeData%Vwnd_LL = SrcWng_InputTypeData%Vwnd_LL
ENDIF
IF (ALLOCATED(SrcWng_InputTypeData%omega_z)) THEN
  i1_l = LBOUND(SrcWng_InputTypeData%omega_z,1)
  i1_u = UBOUND(SrcWng_InputTypeData%omega_z,1)
  IF (.NOT. ALLOCATED(DstWng_InputTypeData%omega_z)) THEN 
    ALLOCATE(DstWng_InputTypeData%omega_z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InputTypeData%omega_z.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_InputTypeData%omega_z = SrcWng_InputTypeData%omega_z
ENDIF
 END SUBROUTINE FVW_CopyWng_InputType

 SUBROUTINE FVW_DestroyWng_InputType( Wng_InputTypeData, ErrStat, ErrMsg )
  TYPE(Wng_InputType), INTENT(INOUT) :: Wng_InputTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_InputType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_InputTypeData%Vwnd_LL)) THEN
  DEALLOCATE(Wng_InputTypeData%Vwnd_LL)
ENDIF
IF (ALLOCATED(Wng_InputTypeData%omega_z)) THEN
  DEALLOCATE(Wng_InputTypeData%omega_z)
ENDIF
 END SUBROUTINE FVW_DestroyWng_InputType

 SUBROUTINE FVW_PackWng_InputType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_InputType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Vwnd_LL allocated yes/no
  IF ( ALLOCATED(InData%Vwnd_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vwnd_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vwnd_LL)  ! Vwnd_LL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! omega_z allocated yes/no
  IF ( ALLOCATED(InData%omega_z) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! omega_z upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%omega_z)  ! omega_z
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Vwnd_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_LL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vwnd_LL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vwnd_LL,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vwnd_LL,2), UBOUND(InData%Vwnd_LL,2)
        DO i1 = LBOUND(InData%Vwnd_LL,1), UBOUND(InData%Vwnd_LL,1)
          ReKiBuf(Re_Xferred) = InData%Vwnd_LL(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%omega_z) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omega_z,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omega_z,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%omega_z,1), UBOUND(InData%omega_z,1)
        ReKiBuf(Re_Xferred) = InData%omega_z(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_InputType

 SUBROUTINE FVW_UnPackWng_InputType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_InputType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vwnd_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vwnd_LL)) DEALLOCATE(OutData%Vwnd_LL)
    ALLOCATE(OutData%Vwnd_LL(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vwnd_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vwnd_LL,2), UBOUND(OutData%Vwnd_LL,2)
        DO i1 = LBOUND(OutData%Vwnd_LL,1), UBOUND(OutData%Vwnd_LL,1)
          OutData%Vwnd_LL(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! omega_z not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%omega_z)) DEALLOCATE(OutData%omega_z)
    ALLOCATE(OutData%omega_z(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%omega_z.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%omega_z,1), UBOUND(OutData%omega_z,1)
        OutData%omega_z(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_InputType

 SUBROUTINE FVW_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_InputType), INTENT(INOUT) :: SrcInputData
   TYPE(FVW_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInputData%rotors)) THEN
  i1_l = LBOUND(SrcInputData%rotors,1)
  i1_u = UBOUND(SrcInputData%rotors,1)
  IF (.NOT. ALLOCATED(DstInputData%rotors)) THEN 
    ALLOCATE(DstInputData%rotors(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%rotors.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputData%rotors,1), UBOUND(SrcInputData%rotors,1)
      CALL FVW_Copyrot_inputtype( SrcInputData%rotors(i1), DstInputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInputData%W)) THEN
  i1_l = LBOUND(SrcInputData%W,1)
  i1_u = UBOUND(SrcInputData%W,1)
  IF (.NOT. ALLOCATED(DstInputData%W)) THEN 
    ALLOCATE(DstInputData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputData%W,1), UBOUND(SrcInputData%W,1)
      CALL FVW_Copywng_inputtype( SrcInputData%W(i1), DstInputData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInputData%WingsMesh)) THEN
  i1_l = LBOUND(SrcInputData%WingsMesh,1)
  i1_u = UBOUND(SrcInputData%WingsMesh,1)
  IF (.NOT. ALLOCATED(DstInputData%WingsMesh)) THEN 
    ALLOCATE(DstInputData%WingsMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%WingsMesh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputData%WingsMesh,1), UBOUND(SrcInputData%WingsMesh,1)
      CALL MeshCopy( SrcInputData%WingsMesh(i1), DstInputData%WingsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInputData%V_wind)) THEN
  i1_l = LBOUND(SrcInputData%V_wind,1)
  i1_u = UBOUND(SrcInputData%V_wind,1)
  i2_l = LBOUND(SrcInputData%V_wind,2)
  i2_u = UBOUND(SrcInputData%V_wind,2)
  IF (.NOT. ALLOCATED(DstInputData%V_wind)) THEN 
    ALLOCATE(DstInputData%V_wind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%V_wind.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%V_wind = SrcInputData%V_wind
ENDIF
 END SUBROUTINE FVW_CopyInput

 SUBROUTINE FVW_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(FVW_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%rotors)) THEN
DO i1 = LBOUND(InputData%rotors,1), UBOUND(InputData%rotors,1)
  CALL FVW_Destroyrot_inputtype( InputData%rotors(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputData%rotors)
ENDIF
IF (ALLOCATED(InputData%W)) THEN
DO i1 = LBOUND(InputData%W,1), UBOUND(InputData%W,1)
  CALL FVW_Destroywng_inputtype( InputData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputData%W)
ENDIF
IF (ALLOCATED(InputData%WingsMesh)) THEN
DO i1 = LBOUND(InputData%WingsMesh,1), UBOUND(InputData%WingsMesh,1)
  CALL MeshDestroy( InputData%WingsMesh(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputData%WingsMesh)
ENDIF
IF (ALLOCATED(InputData%V_wind)) THEN
  DEALLOCATE(InputData%V_wind)
ENDIF
 END SUBROUTINE FVW_DestroyInput

 SUBROUTINE FVW_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! rotors allocated yes/no
  IF ( ALLOCATED(InData%rotors) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rotors upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%rotors,1), UBOUND(InData%rotors,1)
      Int_BufSz   = Int_BufSz + 3  ! rotors: size of buffers for each call to pack subtype
      CALL FVW_Packrot_inputtype( Re_Buf, Db_Buf, Int_Buf, InData%rotors(i1), ErrStat2, ErrMsg2, .TRUE. ) ! rotors 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! rotors
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! rotors
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! rotors
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_inputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WingsMesh allocated yes/no
  IF ( ALLOCATED(InData%WingsMesh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WingsMesh upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%WingsMesh,1), UBOUND(InData%WingsMesh,1)
      Int_BufSz   = Int_BufSz + 3  ! WingsMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! WingsMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! WingsMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! WingsMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! V_wind allocated yes/no
  IF ( ALLOCATED(InData%V_wind) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! V_wind upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%V_wind)  ! V_wind
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%rotors) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rotors,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rotors,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%rotors,1), UBOUND(InData%rotors,1)
      CALL FVW_Packrot_inputtype( Re_Buf, Db_Buf, Int_Buf, InData%rotors(i1), ErrStat2, ErrMsg2, OnlySize ) ! rotors 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_inputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WingsMesh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WingsMesh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WingsMesh,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%WingsMesh,1), UBOUND(InData%WingsMesh,1)
      CALL MeshPack( InData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%V_wind) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_wind,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_wind,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%V_wind,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%V_wind,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%V_wind,2), UBOUND(InData%V_wind,2)
        DO i1 = LBOUND(InData%V_wind,1), UBOUND(InData%V_wind,1)
          ReKiBuf(Re_Xferred) = InData%V_wind(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_PackInput

 SUBROUTINE FVW_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rotors not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rotors)) DEALLOCATE(OutData%rotors)
    ALLOCATE(OutData%rotors(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%rotors,1), UBOUND(OutData%rotors,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackrot_inputtype( Re_Buf, Db_Buf, Int_Buf, OutData%rotors(i1), ErrStat2, ErrMsg2 ) ! rotors 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_inputtype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WingsMesh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WingsMesh)) DEALLOCATE(OutData%WingsMesh)
    ALLOCATE(OutData%WingsMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WingsMesh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%WingsMesh,1), UBOUND(OutData%WingsMesh,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! V_wind not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%V_wind)) DEALLOCATE(OutData%V_wind)
    ALLOCATE(OutData%V_wind(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%V_wind.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%V_wind,2), UBOUND(OutData%V_wind,2)
        DO i1 = LBOUND(OutData%V_wind,1), UBOUND(OutData%V_wind,1)
          OutData%V_wind(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE FVW_UnPackInput

 SUBROUTINE FVW_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(FVW_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstDiscStateData%NULL = SrcDiscStateData%NULL
IF (ALLOCATED(SrcDiscStateData%UA)) THEN
  i1_l = LBOUND(SrcDiscStateData%UA,1)
  i1_u = UBOUND(SrcDiscStateData%UA,1)
  IF (.NOT. ALLOCATED(DstDiscStateData%UA)) THEN 
    ALLOCATE(DstDiscStateData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%UA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcDiscStateData%UA,1), UBOUND(SrcDiscStateData%UA,1)
      CALL UA_CopyDiscState( SrcDiscStateData%UA(i1), DstDiscStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE FVW_CopyDiscState

 SUBROUTINE FVW_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(FVW_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(DiscStateData%UA)) THEN
DO i1 = LBOUND(DiscStateData%UA,1), UBOUND(DiscStateData%UA,1)
  CALL UA_DestroyDiscState( DiscStateData%UA(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(DiscStateData%UA)
ENDIF
 END SUBROUTINE FVW_DestroyDiscState

 SUBROUTINE FVW_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! NULL
  Int_BufSz   = Int_BufSz   + 1     ! UA allocated yes/no
  IF ( ALLOCATED(InData%UA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UA upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%NULL
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UA,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      CALL UA_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE FVW_PackDiscState

 SUBROUTINE FVW_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NULL = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UA)) DEALLOCATE(OutData%UA)
    ALLOCATE(OutData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%UA,1), UBOUND(OutData%UA,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackDiscState( Re_Buf, Db_Buf, Int_Buf, OutData%UA(i1), ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE FVW_UnPackDiscState

 SUBROUTINE FVW_CopyWng_ConstraintStateType( SrcWng_ConstraintStateTypeData, DstWng_ConstraintStateTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_ConstraintStateType), INTENT(IN) :: SrcWng_ConstraintStateTypeData
   TYPE(Wng_ConstraintStateType), INTENT(INOUT) :: DstWng_ConstraintStateTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_ConstraintStateType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_ConstraintStateTypeData%Gamma_LL)) THEN
  i1_l = LBOUND(SrcWng_ConstraintStateTypeData%Gamma_LL,1)
  i1_u = UBOUND(SrcWng_ConstraintStateTypeData%Gamma_LL,1)
  IF (.NOT. ALLOCATED(DstWng_ConstraintStateTypeData%Gamma_LL)) THEN 
    ALLOCATE(DstWng_ConstraintStateTypeData%Gamma_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_ConstraintStateTypeData%Gamma_LL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_ConstraintStateTypeData%Gamma_LL = SrcWng_ConstraintStateTypeData%Gamma_LL
ENDIF
 END SUBROUTINE FVW_CopyWng_ConstraintStateType

 SUBROUTINE FVW_DestroyWng_ConstraintStateType( Wng_ConstraintStateTypeData, ErrStat, ErrMsg )
  TYPE(Wng_ConstraintStateType), INTENT(INOUT) :: Wng_ConstraintStateTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_ConstraintStateType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_ConstraintStateTypeData%Gamma_LL)) THEN
  DEALLOCATE(Wng_ConstraintStateTypeData%Gamma_LL)
ENDIF
 END SUBROUTINE FVW_DestroyWng_ConstraintStateType

 SUBROUTINE FVW_PackWng_ConstraintStateType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_ConstraintStateType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Gamma_LL allocated yes/no
  IF ( ALLOCATED(InData%Gamma_LL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Gamma_LL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Gamma_LL)  ! Gamma_LL
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Gamma_LL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Gamma_LL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Gamma_LL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Gamma_LL,1), UBOUND(InData%Gamma_LL,1)
        ReKiBuf(Re_Xferred) = InData%Gamma_LL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_PackWng_ConstraintStateType

 SUBROUTINE FVW_UnPackWng_ConstraintStateType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_ConstraintStateType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Gamma_LL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Gamma_LL)) DEALLOCATE(OutData%Gamma_LL)
    ALLOCATE(OutData%Gamma_LL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Gamma_LL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Gamma_LL,1), UBOUND(OutData%Gamma_LL,1)
        OutData%Gamma_LL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE FVW_UnPackWng_ConstraintStateType

 SUBROUTINE FVW_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(FVW_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcConstrStateData%W)) THEN
  i1_l = LBOUND(SrcConstrStateData%W,1)
  i1_u = UBOUND(SrcConstrStateData%W,1)
  IF (.NOT. ALLOCATED(DstConstrStateData%W)) THEN 
    ALLOCATE(DstConstrStateData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcConstrStateData%W,1), UBOUND(SrcConstrStateData%W,1)
      CALL FVW_Copywng_constraintstatetype( SrcConstrStateData%W(i1), DstConstrStateData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstConstrStateData%residual = SrcConstrStateData%residual
 END SUBROUTINE FVW_CopyConstrState

 SUBROUTINE FVW_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(FVW_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ConstrStateData%W)) THEN
DO i1 = LBOUND(ConstrStateData%W,1), UBOUND(ConstrStateData%W,1)
  CALL FVW_Destroywng_constraintstatetype( ConstrStateData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ConstrStateData%W)
ENDIF
 END SUBROUTINE FVW_DestroyConstrState

 SUBROUTINE FVW_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_constraintstatetype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! residual
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_constraintstatetype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%residual
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FVW_PackConstrState

 SUBROUTINE FVW_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_constraintstatetype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%residual = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE FVW_UnPackConstrState

 SUBROUTINE FVW_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(FVW_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%NULL = SrcOtherStateData%NULL
IF (ALLOCATED(SrcOtherStateData%UA)) THEN
  i1_l = LBOUND(SrcOtherStateData%UA,1)
  i1_u = UBOUND(SrcOtherStateData%UA,1)
  IF (.NOT. ALLOCATED(DstOtherStateData%UA)) THEN 
    ALLOCATE(DstOtherStateData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%UA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcOtherStateData%UA,1), UBOUND(SrcOtherStateData%UA,1)
      CALL UA_CopyOtherState( SrcOtherStateData%UA(i1), DstOtherStateData%UA(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE FVW_CopyOtherState

 SUBROUTINE FVW_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(FVW_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OtherStateData%UA)) THEN
DO i1 = LBOUND(OtherStateData%UA,1), UBOUND(OtherStateData%UA,1)
  CALL UA_DestroyOtherState( OtherStateData%UA(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(OtherStateData%UA)
ENDIF
 END SUBROUTINE FVW_DestroyOtherState

 SUBROUTINE FVW_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! NULL
  Int_BufSz   = Int_BufSz   + 1     ! UA allocated yes/no
  IF ( ALLOCATED(InData%UA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UA upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%NULL
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UA,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%UA,1), UBOUND(InData%UA,1)
      CALL UA_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%UA(i1), ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE FVW_PackOtherState

 SUBROUTINE FVW_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%NULL = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UA)) DEALLOCATE(OutData%UA)
    ALLOCATE(OutData%UA(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%UA,1), UBOUND(OutData%UA,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackOtherState( Re_Buf, Db_Buf, Int_Buf, OutData%UA(i1), ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE FVW_UnPackOtherState

 SUBROUTINE FVW_CopyWng_InitInputType( SrcWng_InitInputTypeData, DstWng_InitInputTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(Wng_InitInputType), INTENT(IN) :: SrcWng_InitInputTypeData
   TYPE(Wng_InitInputType), INTENT(INOUT) :: DstWng_InitInputTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyWng_InitInputType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcWng_InitInputTypeData%AFindx)) THEN
  i1_l = LBOUND(SrcWng_InitInputTypeData%AFindx,1)
  i1_u = UBOUND(SrcWng_InitInputTypeData%AFindx,1)
  i2_l = LBOUND(SrcWng_InitInputTypeData%AFindx,2)
  i2_u = UBOUND(SrcWng_InitInputTypeData%AFindx,2)
  IF (.NOT. ALLOCATED(DstWng_InitInputTypeData%AFindx)) THEN 
    ALLOCATE(DstWng_InitInputTypeData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%AFindx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_InitInputTypeData%AFindx = SrcWng_InitInputTypeData%AFindx
ENDIF
IF (ALLOCATED(SrcWng_InitInputTypeData%chord)) THEN
  i1_l = LBOUND(SrcWng_InitInputTypeData%chord,1)
  i1_u = UBOUND(SrcWng_InitInputTypeData%chord,1)
  IF (.NOT. ALLOCATED(DstWng_InitInputTypeData%chord)) THEN 
    ALLOCATE(DstWng_InitInputTypeData%chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%chord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_InitInputTypeData%chord = SrcWng_InitInputTypeData%chord
ENDIF
IF (ALLOCATED(SrcWng_InitInputTypeData%RElm)) THEN
  i1_l = LBOUND(SrcWng_InitInputTypeData%RElm,1)
  i1_u = UBOUND(SrcWng_InitInputTypeData%RElm,1)
  IF (.NOT. ALLOCATED(DstWng_InitInputTypeData%RElm)) THEN 
    ALLOCATE(DstWng_InitInputTypeData%RElm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstWng_InitInputTypeData%RElm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstWng_InitInputTypeData%RElm = SrcWng_InitInputTypeData%RElm
ENDIF
    DstWng_InitInputTypeData%iRotor = SrcWng_InitInputTypeData%iRotor
    DstWng_InitInputTypeData%UAOff_innerNode = SrcWng_InitInputTypeData%UAOff_innerNode
    DstWng_InitInputTypeData%UAOff_outerNode = SrcWng_InitInputTypeData%UAOff_outerNode
 END SUBROUTINE FVW_CopyWng_InitInputType

 SUBROUTINE FVW_DestroyWng_InitInputType( Wng_InitInputTypeData, ErrStat, ErrMsg )
  TYPE(Wng_InitInputType), INTENT(INOUT) :: Wng_InitInputTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyWng_InitInputType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(Wng_InitInputTypeData%AFindx)) THEN
  DEALLOCATE(Wng_InitInputTypeData%AFindx)
ENDIF
IF (ALLOCATED(Wng_InitInputTypeData%chord)) THEN
  DEALLOCATE(Wng_InitInputTypeData%chord)
ENDIF
IF (ALLOCATED(Wng_InitInputTypeData%RElm)) THEN
  DEALLOCATE(Wng_InitInputTypeData%RElm)
ENDIF
 END SUBROUTINE FVW_DestroyWng_InitInputType

 SUBROUTINE FVW_PackWng_InitInputType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(Wng_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackWng_InitInputType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! AFindx allocated yes/no
  IF ( ALLOCATED(InData%AFindx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AFindx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AFindx)  ! AFindx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! chord allocated yes/no
  IF ( ALLOCATED(InData%chord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! chord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chord)  ! chord
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RElm allocated yes/no
  IF ( ALLOCATED(InData%RElm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! RElm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RElm)  ! RElm
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! iRotor
      Int_BufSz  = Int_BufSz  + 1  ! UAOff_innerNode
      Int_BufSz  = Int_BufSz  + 1  ! UAOff_outerNode
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%AFindx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AFindx,2), UBOUND(InData%AFindx,2)
        DO i1 = LBOUND(InData%AFindx,1), UBOUND(InData%AFindx,1)
          IntKiBuf(Int_Xferred) = InData%AFindx(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%chord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%chord,1), UBOUND(InData%chord,1)
        ReKiBuf(Re_Xferred) = InData%chord(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RElm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RElm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RElm,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%RElm,1), UBOUND(InData%RElm,1)
        ReKiBuf(Re_Xferred) = InData%RElm(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%iRotor
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UAOff_innerNode
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UAOff_outerNode
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackWng_InitInputType

 SUBROUTINE FVW_UnPackWng_InitInputType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(Wng_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackWng_InitInputType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFindx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFindx)) DEALLOCATE(OutData%AFindx)
    ALLOCATE(OutData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFindx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AFindx,2), UBOUND(OutData%AFindx,2)
        DO i1 = LBOUND(OutData%AFindx,1), UBOUND(OutData%AFindx,1)
          OutData%AFindx(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chord)) DEALLOCATE(OutData%chord)
    ALLOCATE(OutData%chord(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%chord,1), UBOUND(OutData%chord,1)
        OutData%chord(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RElm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RElm)) DEALLOCATE(OutData%RElm)
    ALLOCATE(OutData%RElm(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RElm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%RElm,1), UBOUND(OutData%RElm,1)
        OutData%RElm(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%iRotor = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UAOff_innerNode = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UAOff_outerNode = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackWng_InitInputType

 SUBROUTINE FVW_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_InitInputType), INTENT(INOUT) :: SrcInitInputData
   TYPE(FVW_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%FVWFileName = SrcInitInputData%FVWFileName
    DstInitInputData%RootName = SrcInitInputData%RootName
IF (ALLOCATED(SrcInitInputData%W)) THEN
  i1_l = LBOUND(SrcInitInputData%W,1)
  i1_u = UBOUND(SrcInitInputData%W,1)
  IF (.NOT. ALLOCATED(DstInitInputData%W)) THEN 
    ALLOCATE(DstInitInputData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%W.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%W,1), UBOUND(SrcInitInputData%W,1)
      CALL FVW_Copywng_initinputtype( SrcInitInputData%W(i1), DstInitInputData%W(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcInitInputData%WingsMesh)) THEN
  i1_l = LBOUND(SrcInitInputData%WingsMesh,1)
  i1_u = UBOUND(SrcInitInputData%WingsMesh,1)
  IF (.NOT. ALLOCATED(DstInitInputData%WingsMesh)) THEN 
    ALLOCATE(DstInitInputData%WingsMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%WingsMesh.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%WingsMesh,1), UBOUND(SrcInitInputData%WingsMesh,1)
      CALL MeshCopy( SrcInitInputData%WingsMesh(i1), DstInitInputData%WingsMesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInitInputData%numBladeNodes = SrcInitInputData%numBladeNodes
    DstInitInputData%DTaero = SrcInitInputData%DTaero
    DstInitInputData%KinVisc = SrcInitInputData%KinVisc
    DstInitInputData%UAMod = SrcInitInputData%UAMod
    DstInitInputData%UA_Flag = SrcInitInputData%UA_Flag
    DstInitInputData%Flookup = SrcInitInputData%Flookup
    DstInitInputData%a_s = SrcInitInputData%a_s
    DstInitInputData%SumPrint = SrcInitInputData%SumPrint
 END SUBROUTINE FVW_CopyInitInput

 SUBROUTINE FVW_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(FVW_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%W)) THEN
DO i1 = LBOUND(InitInputData%W,1), UBOUND(InitInputData%W,1)
  CALL FVW_Destroywng_initinputtype( InitInputData%W(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%W)
ENDIF
IF (ALLOCATED(InitInputData%WingsMesh)) THEN
DO i1 = LBOUND(InitInputData%WingsMesh,1), UBOUND(InitInputData%WingsMesh,1)
  CALL MeshDestroy( InitInputData%WingsMesh(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%WingsMesh)
ENDIF
 END SUBROUTINE FVW_DestroyInitInput

 SUBROUTINE FVW_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%FVWFileName)  ! FVWFileName
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
  Int_BufSz   = Int_BufSz   + 1     ! W allocated yes/no
  IF ( ALLOCATED(InData%W) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! W upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      Int_BufSz   = Int_BufSz + 3  ! W: size of buffers for each call to pack subtype
      CALL FVW_Packwng_initinputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, .TRUE. ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! W
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! W
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! W
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WingsMesh allocated yes/no
  IF ( ALLOCATED(InData%WingsMesh) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WingsMesh upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%WingsMesh,1), UBOUND(InData%WingsMesh,1)
      Int_BufSz   = Int_BufSz + 3  ! WingsMesh: size of buffers for each call to pack subtype
      CALL MeshPack( InData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, .TRUE. ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! WingsMesh
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! WingsMesh
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! WingsMesh
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numBladeNodes
      Db_BufSz   = Db_BufSz   + 1  ! DTaero
      Re_BufSz   = Re_BufSz   + 1  ! KinVisc
      Int_BufSz  = Int_BufSz  + 1  ! UAMod
      Int_BufSz  = Int_BufSz  + 1  ! UA_Flag
      Int_BufSz  = Int_BufSz  + 1  ! Flookup
      Re_BufSz   = Re_BufSz   + 1  ! a_s
      Int_BufSz  = Int_BufSz  + 1  ! SumPrint
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%FVWFileName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%FVWFileName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%W) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%W,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%W,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%W,1), UBOUND(InData%W,1)
      CALL FVW_Packwng_initinputtype( Re_Buf, Db_Buf, Int_Buf, InData%W(i1), ErrStat2, ErrMsg2, OnlySize ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WingsMesh) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WingsMesh,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WingsMesh,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%WingsMesh,1), UBOUND(InData%WingsMesh,1)
      CALL MeshPack( InData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2, OnlySize ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numBladeNodes
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTaero
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%KinVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%UAMod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UA_Flag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Flookup, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%a_s
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%SumPrint, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackInitInput

 SUBROUTINE FVW_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%FVWFileName)
      OutData%FVWFileName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! W not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%W)) DEALLOCATE(OutData%W)
    ALLOCATE(OutData%W(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%W.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%W,1), UBOUND(OutData%W,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL FVW_Unpackwng_initinputtype( Re_Buf, Db_Buf, Int_Buf, OutData%W(i1), ErrStat2, ErrMsg2 ) ! W 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WingsMesh not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WingsMesh)) DEALLOCATE(OutData%WingsMesh)
    ALLOCATE(OutData%WingsMesh(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WingsMesh.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%WingsMesh,1), UBOUND(OutData%WingsMesh,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL MeshUnpack( OutData%WingsMesh(i1), Re_Buf, Db_Buf, Int_Buf, ErrStat2, ErrMsg2 ) ! WingsMesh 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%numBladeNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%DTaero = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%KinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%UAMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UA_Flag = TRANSFER(IntKiBuf(Int_Xferred), OutData%UA_Flag)
    Int_Xferred = Int_Xferred + 1
    OutData%Flookup = TRANSFER(IntKiBuf(Int_Xferred), OutData%Flookup)
    Int_Xferred = Int_Xferred + 1
    OutData%a_s = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SumPrint = TRANSFER(IntKiBuf(Int_Xferred), OutData%SumPrint)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackInitInput

 SUBROUTINE FVW_CopyInputFile( SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_InputFile), INTENT(IN) :: SrcInputFileData
   TYPE(FVW_InputFile), INTENT(INOUT) :: DstInputFileData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyInputFile'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileData%CirculationMethod = SrcInputFileData%CirculationMethod
    DstInputFileData%CirculationFile = SrcInputFileData%CirculationFile
    DstInputFileData%CircSolvMaxIter = SrcInputFileData%CircSolvMaxIter
    DstInputFileData%CircSolvConvCrit = SrcInputFileData%CircSolvConvCrit
    DstInputFileData%CircSolvRelaxation = SrcInputFileData%CircSolvRelaxation
    DstInputFileData%IntMethod = SrcInputFileData%IntMethod
    DstInputFileData%FreeWake = SrcInputFileData%FreeWake
    DstInputFileData%FreeWakeStart = SrcInputFileData%FreeWakeStart
    DstInputFileData%FullCirculationStart = SrcInputFileData%FullCirculationStart
    DstInputFileData%DTfvw = SrcInputFileData%DTfvw
    DstInputFileData%CircSolvPolar = SrcInputFileData%CircSolvPolar
    DstInputFileData%nNWPanels = SrcInputFileData%nNWPanels
    DstInputFileData%nFWPanels = SrcInputFileData%nFWPanels
    DstInputFileData%nFWPanelsFree = SrcInputFileData%nFWPanelsFree
    DstInputFileData%FWShedVorticity = SrcInputFileData%FWShedVorticity
    DstInputFileData%DiffusionMethod = SrcInputFileData%DiffusionMethod
    DstInputFileData%CoreSpreadEddyVisc = SrcInputFileData%CoreSpreadEddyVisc
    DstInputFileData%RegDeterMethod = SrcInputFileData%RegDeterMethod
    DstInputFileData%RegFunction = SrcInputFileData%RegFunction
    DstInputFileData%WakeRegMethod = SrcInputFileData%WakeRegMethod
    DstInputFileData%WakeRegParam = SrcInputFileData%WakeRegParam
    DstInputFileData%WingRegParam = SrcInputFileData%WingRegParam
    DstInputFileData%ShearModel = SrcInputFileData%ShearModel
    DstInputFileData%TwrShadowOnWake = SrcInputFileData%TwrShadowOnWake
    DstInputFileData%VelocityMethod = SrcInputFileData%VelocityMethod
    DstInputFileData%TreeBranchFactor = SrcInputFileData%TreeBranchFactor
    DstInputFileData%PartPerSegment = SrcInputFileData%PartPerSegment
    DstInputFileData%WrVTK = SrcInputFileData%WrVTK
    DstInputFileData%VTKBlades = SrcInputFileData%VTKBlades
    DstInputFileData%DTvtk = SrcInputFileData%DTvtk
    DstInputFileData%VTKCoord = SrcInputFileData%VTKCoord
 END SUBROUTINE FVW_CopyInputFile

 SUBROUTINE FVW_DestroyInputFile( InputFileData, ErrStat, ErrMsg )
  TYPE(FVW_InputFile), INTENT(INOUT) :: InputFileData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyInputFile'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE FVW_DestroyInputFile

 SUBROUTINE FVW_PackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_InputFile),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackInputFile'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! CirculationMethod
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%CirculationFile)  ! CirculationFile
      Int_BufSz  = Int_BufSz  + 1  ! CircSolvMaxIter
      Re_BufSz   = Re_BufSz   + 1  ! CircSolvConvCrit
      Re_BufSz   = Re_BufSz   + 1  ! CircSolvRelaxation
      Int_BufSz  = Int_BufSz  + 1  ! IntMethod
      Int_BufSz  = Int_BufSz  + 1  ! FreeWake
      Re_BufSz   = Re_BufSz   + 1  ! FreeWakeStart
      Re_BufSz   = Re_BufSz   + 1  ! FullCirculationStart
      Db_BufSz   = Db_BufSz   + 1  ! DTfvw
      Int_BufSz  = Int_BufSz  + 1  ! CircSolvPolar
      Int_BufSz  = Int_BufSz  + 1  ! nNWPanels
      Int_BufSz  = Int_BufSz  + 1  ! nFWPanels
      Int_BufSz  = Int_BufSz  + 1  ! nFWPanelsFree
      Int_BufSz  = Int_BufSz  + 1  ! FWShedVorticity
      Int_BufSz  = Int_BufSz  + 1  ! DiffusionMethod
      Re_BufSz   = Re_BufSz   + 1  ! CoreSpreadEddyVisc
      Int_BufSz  = Int_BufSz  + 1  ! RegDeterMethod
      Int_BufSz  = Int_BufSz  + 1  ! RegFunction
      Int_BufSz  = Int_BufSz  + 1  ! WakeRegMethod
      Re_BufSz   = Re_BufSz   + 1  ! WakeRegParam
      Re_BufSz   = Re_BufSz   + 1  ! WingRegParam
      Int_BufSz  = Int_BufSz  + 1  ! ShearModel
      Int_BufSz  = Int_BufSz  + 1  ! TwrShadowOnWake
      Int_BufSz  = Int_BufSz  + 1  ! VelocityMethod
      Re_BufSz   = Re_BufSz   + 1  ! TreeBranchFactor
      Int_BufSz  = Int_BufSz  + 1  ! PartPerSegment
      Int_BufSz  = Int_BufSz  + 1  ! WrVTK
      Int_BufSz  = Int_BufSz  + 1  ! VTKBlades
      Db_BufSz   = Db_BufSz   + 1  ! DTvtk
      Int_BufSz  = Int_BufSz  + 1  ! VTKCoord
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%CirculationMethod
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%CirculationFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%CirculationFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%CircSolvMaxIter
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CircSolvConvCrit
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CircSolvRelaxation
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IntMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FreeWake, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FreeWakeStart
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%FullCirculationStart
    Re_Xferred = Re_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTfvw
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%CircSolvPolar
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nNWPanels
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nFWPanels
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%nFWPanelsFree
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FWShedVorticity, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%DiffusionMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%CoreSpreadEddyVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RegDeterMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%RegFunction
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%WakeRegMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WakeRegParam
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%WingRegParam
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ShearModel
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TwrShadowOnWake, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VelocityMethod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TreeBranchFactor
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%PartPerSegment
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%WrVTK
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VTKBlades
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%DTvtk
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%VTKCoord
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackInputFile

 SUBROUTINE FVW_UnPackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_InputFile), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackInputFile'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%CirculationMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%CirculationFile)
      OutData%CirculationFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%CircSolvMaxIter = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%CircSolvConvCrit = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%CircSolvRelaxation = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%IntMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%FreeWake = TRANSFER(IntKiBuf(Int_Xferred), OutData%FreeWake)
    Int_Xferred = Int_Xferred + 1
    OutData%FreeWakeStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%FullCirculationStart = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DTfvw = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%CircSolvPolar = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nNWPanels = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nFWPanels = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%nFWPanelsFree = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%FWShedVorticity = TRANSFER(IntKiBuf(Int_Xferred), OutData%FWShedVorticity)
    Int_Xferred = Int_Xferred + 1
    OutData%DiffusionMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%CoreSpreadEddyVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%RegDeterMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%RegFunction = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WakeRegMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WakeRegParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%WingRegParam = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%ShearModel = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TwrShadowOnWake = TRANSFER(IntKiBuf(Int_Xferred), OutData%TwrShadowOnWake)
    Int_Xferred = Int_Xferred + 1
    OutData%VelocityMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TreeBranchFactor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%PartPerSegment = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%WrVTK = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%VTKBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%DTvtk = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%VTKCoord = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackInputFile

 SUBROUTINE FVW_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(FVW_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(FVW_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitOutputData%Null = SrcInitOutputData%Null
 END SUBROUTINE FVW_CopyInitOutput

 SUBROUTINE FVW_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(FVW_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'FVW_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE FVW_DestroyInitOutput

 SUBROUTINE FVW_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(FVW_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! Null
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = InData%Null
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_PackInitOutput

 SUBROUTINE FVW_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(FVW_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'FVW_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%Null = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE FVW_UnPackInitOutput


 SUBROUTINE FVW_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(FVW_InputType), INTENT(INOUT)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(FVW_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'FVW_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL FVW_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL FVW_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL FVW_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE FVW_Input_ExtrapInterp


 SUBROUTINE FVW_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(FVW_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
 TYPE(FVW_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(FVW_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'FVW_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
  DO i01 = LBOUND(u_out%rotors,1),UBOUND(u_out%rotors,1)
  DO i2 = LBOUND(u_out%rotors(i01)%HubOrientation,2),UBOUND(u_out%rotors(i01)%HubOrientation,2)
    DO i1 = LBOUND(u_out%rotors(i01)%HubOrientation,1),UBOUND(u_out%rotors(i01)%HubOrientation,1)
      b = -(u1%rotors(i01)%HubOrientation(i1,i2) - u2%rotors(i01)%HubOrientation(i1,i2))
      u_out%rotors(i01)%HubOrientation(i1,i2) = u1%rotors(i01)%HubOrientation(i1,i2) + b * ScaleFactor
    END DO
  END DO
  ENDDO
  DO i01 = LBOUND(u_out%rotors,1),UBOUND(u_out%rotors,1)
  DO i1 = LBOUND(u_out%rotors(i01)%HubPosition,1),UBOUND(u_out%rotors(i01)%HubPosition,1)
    b = -(u1%rotors(i01)%HubPosition(i1) - u2%rotors(i01)%HubPosition(i1))
    u_out%rotors(i01)%HubPosition(i1) = u1%rotors(i01)%HubPosition(i1) + b * ScaleFactor
  END DO
  ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%W) .AND. ALLOCATED(u1%W)) THEN
  DO i01 = LBOUND(u_out%W,1),UBOUND(u_out%W,1)
IF (ALLOCATED(u_out%W(i01)%Vwnd_LL) .AND. ALLOCATED(u1%W(i01)%Vwnd_LL)) THEN
  DO i2 = LBOUND(u_out%W(i01)%Vwnd_LL,2),UBOUND(u_out%W(i01)%Vwnd_LL,2)
    DO i1 = LBOUND(u_out%W(i01)%Vwnd_LL,1),UBOUND(u_out%W(i01)%Vwnd_LL,1)
      b = -(u1%W(i01)%Vwnd_LL(i1,i2) - u2%W(i01)%Vwnd_LL(i1,i2))
      u_out%W(i01)%Vwnd_LL(i1,i2) = u1%W(i01)%Vwnd_LL(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
  ENDDO
  DO i01 = LBOUND(u_out%W,1),UBOUND(u_out%W,1)
IF (ALLOCATED(u_out%W(i01)%omega_z) .AND. ALLOCATED(u1%W(i01)%omega_z)) THEN
  DO i1 = LBOUND(u_out%W(i01)%omega_z,1),UBOUND(u_out%W(i01)%omega_z,1)
    b = -(u1%W(i01)%omega_z(i1) - u2%W(i01)%omega_z(i1))
    u_out%W(i01)%omega_z(i1) = u1%W(i01)%omega_z(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
  ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%WingsMesh) .AND. ALLOCATED(u1%WingsMesh)) THEN
  DO i1 = LBOUND(u_out%WingsMesh,1),UBOUND(u_out%WingsMesh,1)
      CALL MeshExtrapInterp1(u1%WingsMesh(i1), u2%WingsMesh(i1), tin, u_out%WingsMesh(i1), tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%V_wind) .AND. ALLOCATED(u1%V_wind)) THEN
  DO i2 = LBOUND(u_out%V_wind,2),UBOUND(u_out%V_wind,2)
    DO i1 = LBOUND(u_out%V_wind,1),UBOUND(u_out%V_wind,1)
      b = -(u1%V_wind(i1,i2) - u2%V_wind(i1,i2))
      u_out%V_wind(i1,i2) = u1%V_wind(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE FVW_Input_ExtrapInterp1


 SUBROUTINE FVW_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(FVW_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
 TYPE(FVW_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
 TYPE(FVW_InputType), INTENT(INOUT)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(FVW_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'FVW_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
  DO i01 = LBOUND(u_out%rotors,1),UBOUND(u_out%rotors,1)
  DO i2 = LBOUND(u_out%rotors(i01)%HubOrientation,2),UBOUND(u_out%rotors(i01)%HubOrientation,2)
    DO i1 = LBOUND(u_out%rotors(i01)%HubOrientation,1),UBOUND(u_out%rotors(i01)%HubOrientation,1)
      b = (t(3)**2*(u1%rotors(i01)%HubOrientation(i1,i2) - u2%rotors(i01)%HubOrientation(i1,i2)) + t(2)**2*(-u1%rotors(i01)%HubOrientation(i1,i2) + u3%rotors(i01)%HubOrientation(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%rotors(i01)%HubOrientation(i1,i2) + t(3)*u2%rotors(i01)%HubOrientation(i1,i2) - t(2)*u3%rotors(i01)%HubOrientation(i1,i2) ) * scaleFactor
      u_out%rotors(i01)%HubOrientation(i1,i2) = u1%rotors(i01)%HubOrientation(i1,i2) + b  + c * t_out
    END DO
  END DO
  ENDDO
  DO i01 = LBOUND(u_out%rotors,1),UBOUND(u_out%rotors,1)
  DO i1 = LBOUND(u_out%rotors(i01)%HubPosition,1),UBOUND(u_out%rotors(i01)%HubPosition,1)
    b = (t(3)**2*(u1%rotors(i01)%HubPosition(i1) - u2%rotors(i01)%HubPosition(i1)) + t(2)**2*(-u1%rotors(i01)%HubPosition(i1) + u3%rotors(i01)%HubPosition(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%rotors(i01)%HubPosition(i1) + t(3)*u2%rotors(i01)%HubPosition(i1) - t(2)*u3%rotors(i01)%HubPosition(i1) ) * scaleFactor
    u_out%rotors(i01)%HubPosition(i1) = u1%rotors(i01)%HubPosition(i1) + b  + c * t_out
  END DO
  ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%W) .AND. ALLOCATED(u1%W)) THEN
  DO i01 = LBOUND(u_out%W,1),UBOUND(u_out%W,1)
IF (ALLOCATED(u_out%W(i01)%Vwnd_LL) .AND. ALLOCATED(u1%W(i01)%Vwnd_LL)) THEN
  DO i2 = LBOUND(u_out%W(i01)%Vwnd_LL,2),UBOUND(u_out%W(i01)%Vwnd_LL,2)
    DO i1 = LBOUND(u_out%W(i01)%Vwnd_LL,1),UBOUND(u_out%W(i01)%Vwnd_LL,1)
      b = (t(3)**2*(u1%W(i01)%Vwnd_LL(i1,i2) - u2%W(i01)%Vwnd_LL(i1,i2)) + t(2)**2*(-u1%W(i01)%Vwnd_LL(i1,i2) + u3%W(i01)%Vwnd_LL(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%W(i01)%Vwnd_LL(i1,i2) + t(3)*u2%W(i01)%Vwnd_LL(i1,i2) - t(2)*u3%W(i01)%Vwnd_LL(i1,i2) ) * scaleFactor
      u_out%W(i01)%Vwnd_LL(i1,i2) = u1%W(i01)%Vwnd_LL(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
  ENDDO
  DO i01 = LBOUND(u_out%W,1),UBOUND(u_out%W,1)
IF (ALLOCATED(u_out%W(i01)%omega_z) .AND. ALLOCATED(u1%W(i01)%omega_z)) THEN
  DO i1 = LBOUND(u_out%W(i01)%omega_z,1),UBOUND(u_out%W(i01)%omega_z,1)
    b = (t(3)**2*(u1%W(i01)%omega_z(i1) - u2%W(i01)%omega_z(i1)) + t(2)**2*(-u1%W(i01)%omega_z(i1) + u3%W(i01)%omega_z(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%W(i01)%omega_z(i1) + t(3)*u2%W(i01)%omega_z(i1) - t(2)*u3%W(i01)%omega_z(i1) ) * scaleFactor
    u_out%W(i01)%omega_z(i1) = u1%W(i01)%omega_z(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
  ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%WingsMesh) .AND. ALLOCATED(u1%WingsMesh)) THEN
  DO i1 = LBOUND(u_out%WingsMesh,1),UBOUND(u_out%WingsMesh,1)
      CALL MeshExtrapInterp2(u1%WingsMesh(i1), u2%WingsMesh(i1), u3%WingsMesh(i1), tin, u_out%WingsMesh(i1), tin_out, ErrStat2, ErrMsg2 )
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   ENDDO
END IF ! check if allocated
IF (ALLOCATED(u_out%V_wind) .AND. ALLOCATED(u1%V_wind)) THEN
  DO i2 = LBOUND(u_out%V_wind,2),UBOUND(u_out%V_wind,2)
    DO i1 = LBOUND(u_out%V_wind,1),UBOUND(u_out%V_wind,1)
      b = (t(3)**2*(u1%V_wind(i1,i2) - u2%V_wind(i1,i2)) + t(2)**2*(-u1%V_wind(i1,i2) + u3%V_wind(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%V_wind(i1,i2) + t(3)*u2%V_wind(i1,i2) - t(2)*u3%V_wind(i1,i2) ) * scaleFactor
      u_out%V_wind(i1,i2) = u1%V_wind(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE FVW_Input_ExtrapInterp2


 SUBROUTINE FVW_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(FVW_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(FVW_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'FVW_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL FVW_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL FVW_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL FVW_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE FVW_Output_ExtrapInterp


 SUBROUTINE FVW_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(FVW_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(FVW_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(FVW_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'FVW_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(y_out%W) .AND. ALLOCATED(y1%W)) THEN
  DO i01 = LBOUND(y_out%W,1),UBOUND(y_out%W,1)
IF (ALLOCATED(y_out%W(i01)%Vind) .AND. ALLOCATED(y1%W(i01)%Vind)) THEN
  DO i2 = LBOUND(y_out%W(i01)%Vind,2),UBOUND(y_out%W(i01)%Vind,2)
    DO i1 = LBOUND(y_out%W(i01)%Vind,1),UBOUND(y_out%W(i01)%Vind,1)
      b = -(y1%W(i01)%Vind(i1,i2) - y2%W(i01)%Vind(i1,i2))
      y_out%W(i01)%Vind(i1,i2) = y1%W(i01)%Vind(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
  ENDDO
END IF ! check if allocated
 END SUBROUTINE FVW_Output_ExtrapInterp1


 SUBROUTINE FVW_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(FVW_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(FVW_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(FVW_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(FVW_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'FVW_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(y_out%W) .AND. ALLOCATED(y1%W)) THEN
  DO i01 = LBOUND(y_out%W,1),UBOUND(y_out%W,1)
IF (ALLOCATED(y_out%W(i01)%Vind) .AND. ALLOCATED(y1%W(i01)%Vind)) THEN
  DO i2 = LBOUND(y_out%W(i01)%Vind,2),UBOUND(y_out%W(i01)%Vind,2)
    DO i1 = LBOUND(y_out%W(i01)%Vind,1),UBOUND(y_out%W(i01)%Vind,1)
      b = (t(3)**2*(y1%W(i01)%Vind(i1,i2) - y2%W(i01)%Vind(i1,i2)) + t(2)**2*(-y1%W(i01)%Vind(i1,i2) + y3%W(i01)%Vind(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%W(i01)%Vind(i1,i2) + t(3)*y2%W(i01)%Vind(i1,i2) - t(2)*y3%W(i01)%Vind(i1,i2) ) * scaleFactor
      y_out%W(i01)%Vind(i1,i2) = y1%W(i01)%Vind(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
  ENDDO
END IF ! check if allocated
 END SUBROUTINE FVW_Output_ExtrapInterp2

END MODULE FVW_Types
!ENDOFREGISTRYGENERATEDFILE
