!STARTOFREGISTRYGENERATEDFILE 'BEMT_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! BEMT_Types
!.................................................................................................................................
! This file is part of BEMT.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in BEMT. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE BEMT_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE UnsteadyAero_Types
USE DBEMT_Types
USE NWTC_Library
IMPLICIT NONE
! =========  BEMT_InitInputType  =======
  TYPE, PUBLIC :: BEMT_InitInputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chord      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades      !< Number of blades [-]
    REAL(ReKi)  :: airDens      !< Air density [kg/m^3]
    REAL(ReKi)  :: kinVisc      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: skewWakeMod      !< Type of skewed-wake correction model [switch] {1=uncoupled, 2=Pitt/Peters, 3=coupled} [-]
    REAL(ReKi)  :: aTol      !< Tolerance for the induction solution [-]
    LOGICAL  :: useTipLoss      !< Use the Prandtl tip-loss model?  [flag] [-]
    LOGICAL  :: useHubLoss      !< Use the Prandtl hub-loss model?  [flag] [-]
    LOGICAL  :: useInduction      !< Include induction in BEMT calculations [flag] { If FALSE then useTanInd will be set to FALSE} [-]
    LOGICAL  :: useTanInd      !< Include tangential induction in BEMT calculations [flag] [-]
    LOGICAL  :: useAIDrag      !< Include the drag term in the axial-induction calculation?  [flag] [-]
    LOGICAL  :: useTIDrag      !< Include the drag term in the tangential-induction calculation?  Ignored if TanInd is False.  [flag] [-]
    INTEGER(IntKi)  :: numBladeNodes      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: numReIterations      !< Number of iterations for finding the Reynolds number [-]
    INTEGER(IntKi)  :: maxIndIterations      !< Maximum number of iterations of induction factor solve [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index of airfoil data file for blade node location [array of numBladeNodes] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zHub      !< Distance to hub for each blade [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: zLocal      !< Distance to blade node, measured along the blade [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zTip      !< Distance to blade tip, measured along the blade [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rLocal      !< Radial distance to blade node from the center of rotation, measured in the rotor plane, needed for DBEMT [m]
    INTEGER(IntKi)  :: UAMod      !< Model for the dynamic stall equations [1 = Leishman/Beddoes, 2 = Gonzalez, 3 = Minnema] [-]
    LOGICAL  :: UA_Flag      !< logical flag indicating whether to use UnsteadyAero [-]
    LOGICAL  :: Flookup      !< Use table lookup for f' and f''  [-]
    REAL(ReKi)  :: a_s      !< speed of sound [m/s]
    INTEGER(IntKi)  :: DBEMT_Mod      !< DBEMT model.  1 = constant tau1, 2 = time dependent tau1 [-]
    REAL(ReKi)  :: tau1_const      !< DBEMT time constant (when DBEMT_Mod=1) [s]
    REAL(ReKi)  :: yawCorrFactor      !< constant used in Pitt/Peters skewed wake model (default is 15*pi/32) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_innerNode      !< Last node on each blade where UA should be turned off based on span location from blade root (0 if always on) [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: UAOff_outerNode      !< First node on each blade where UA should be turned off based on span location from blade tip (>nNodesPerBlade if always on) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: SumPrint      !< logical flag indicating whether to use UnsteadyAero [-]
  END TYPE BEMT_InitInputType
! =======================
! =========  BEMT_InitOutputType  =======
  TYPE, PUBLIC :: BEMT_InitOutputType
    TYPE(ProgDesc)  :: Version      !<  [-]
  END TYPE BEMT_InitOutputType
! =======================
! =========  BEMT_ContinuousStateType  =======
  TYPE, PUBLIC :: BEMT_ContinuousStateType
    TYPE(UA_ContinuousStateType)  :: UA      !< UA module continuous states [-]
    TYPE(DBEMT_ContinuousStateType)  :: DBEMT      !< DBEMT module continuous states [-]
  END TYPE BEMT_ContinuousStateType
! =======================
! =========  BEMT_DiscreteStateType  =======
  TYPE, PUBLIC :: BEMT_DiscreteStateType
    TYPE(UA_DiscreteStateType)  :: UA      !< states for UnsteadyAero [-]
  END TYPE BEMT_DiscreteStateType
! =======================
! =========  BEMT_ConstraintStateType  =======
  TYPE, PUBLIC :: BEMT_ConstraintStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< angle between the plane of rotation and the direction of the local wind [rad]
  END TYPE BEMT_ConstraintStateType
! =======================
! =========  BEMT_OtherStateType  =======
  TYPE, PUBLIC :: BEMT_OtherStateType
    TYPE(UA_OtherStateType)  :: UA      !< other states for UnsteadyAero [-]
    TYPE(DBEMT_OtherStateType)  :: DBEMT      !< other states for DBEMT [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: ValidPhi      !< set to indicate when there is no valid Phi for this node at this time (temporarially turn off induction when this is false) [-]
    LOGICAL  :: nodesInitialized      !< the node states have been initialized properly [-]
  END TYPE BEMT_OtherStateType
! =======================
! =========  BEMT_MiscVarType  =======
  TYPE, PUBLIC :: BEMT_MiscVarType
    LOGICAL  :: FirstWarn_Skew      !< flag so invalid skew warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_Phi      !< flag so Invalid Phi warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_BEMoff      !< flag to warn the BEM was turned off [-]
    TYPE(UA_MiscVarType)  :: UA      !< misc vars for UnsteadyAero [-]
    TYPE(DBEMT_MiscVarType)  :: DBEMT      !< misc vars for DBEMT [-]
    TYPE(UA_OutputType)  :: y_UA      !< outputs from UnsteadyAero [-]
    TYPE(UA_InputType) , DIMENSION(:,:,:), ALLOCATABLE  :: u_UA      !< inputs to UnsteadyAero at t and t+dt [-]
    TYPE(DBEMT_InputType) , DIMENSION(:), ALLOCATABLE  :: u_DBEMT      !< inputs to DBEMT [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TnInd_op      !< tangential induction at the operating point (for linearization with frozen wake assumption) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AxInd_op      !< axial induction at the operating point (for linearization) with frozen wake assumption [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AxInduction      !< axial induction used for code run-time optimization [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TanInduction      !< tangential induction used for code run-time optimization [-]
    LOGICAL  :: UseFrozenWake      !< flag set to determine if frozen values of TnInd_op and AxInd_op should be used for this calculation in the linearization process [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Rtip      !< maximum rlocal value for each blade (typically the value at the tip) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< temp variable used in update states for returning phi (to allow computing inputs and states at multiple times) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chi      !< temp variable used in update states for returning chi (to allow calling same routine from CalcOutput and UpdateStates) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: ValidPhi      !< temp variable used in calcOutput for ValidPhi (to allow calling same routine from CalcOutput and UpdateStates) [-]
    REAL(ReKi)  :: BEM_weight 
  END TYPE BEMT_MiscVarType
! =======================
! =========  BEMT_ParameterType  =======
  TYPE, PUBLIC :: BEMT_ParameterType
    REAL(DbKi)  :: DT      !< time step [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chord      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades      !< Number of blades [-]
    REAL(ReKi)  :: airDens      !< Air density [kg/m^3]
    REAL(ReKi)  :: kinVisc      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: skewWakeMod      !< Type of skewed-wake correction model [switch] {1=uncoupled, 2=Pitt/Peters, 3=coupled} [-]
    REAL(ReKi)  :: aTol      !< Tolerance for the induction solution [-]
    LOGICAL  :: useTipLoss      !< Use the Prandtl tip-loss model?  [flag] [-]
    LOGICAL  :: useHubLoss      !< Use the Prandtl hub-loss model?  [flag] [-]
    LOGICAL  :: useInduction      !< Include induction in BEMT calculations [flag] { If FALSE then useTanInd will be set to FALSE} [-]
    LOGICAL  :: useTanInd      !< Include tangential induction in BEMT calculations [flag] [-]
    LOGICAL  :: useAIDrag      !< Include the drag term in the axial-induction calculation?  [flag] [-]
    LOGICAL  :: useTIDrag      !< Include the drag term in the tangential-induction calculation?  Ignored if TanInd is False.  [flag] [-]
    INTEGER(IntKi)  :: numBladeNodes      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: numReIterations      !< Number of iterations for finding the Reynolds number [-]
    INTEGER(IntKi)  :: maxIndIterations      !< Maximum number of iterations of induction factor solve [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index of airfoil data file for blade node location [array of numBladeNodes] [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tipLossConst      !< A constant computed during initialization based on B*(zTip-zLocal)/(2*zLocal) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: hubLossConst      !< A constant computed during initialization based on B*(zLocal-zHub)/(2*zHub) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zHub      !< Distance to hub for each blade [m]
    TYPE(UA_ParameterType)  :: UA      !< parameters for UnsteadyAero [-]
    TYPE(DBEMT_ParameterType)  :: DBEMT      !< parameters for DBEMT [-]
    LOGICAL  :: UA_Flag      !< logical flag indicating whether to use UnsteadyAero [-]
    INTEGER(IntKi)  :: DBEMT_Mod      !< DBEMT Model.  0 = constant tau1, 1 = time dependent tau1 [-]
    REAL(ReKi)  :: yawCorrFactor      !< constant used in Pitt/Peters skewed wake model (default is 15*pi/32) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: FixedInductions      !< flag to determine if BEM inductions should be fixed and not modified by dbemt or skewed wake [-]
  END TYPE BEMT_ParameterType
! =======================
! =========  BEMT_InputType  =======
  TYPE, PUBLIC :: BEMT_InputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: theta      !< Twist angle (includes all sources of twist)  [Array of size (NumBlNds,numBlades)] [rad]
    REAL(ReKi)  :: chi0      !< Angle between the vector normal to the rotor plane and the wind vector (e.g., the yaw angle in the case of no tilt) [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: psi      !< Azimuth angle [rad]
    REAL(ReKi)  :: omega      !< Angular velocity of rotor [rad/s]
    REAL(ReKi)  :: TSR      !< Tip-speed ratio (to check if BEM should be turned off) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx      !< Local axial velocity at node [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vy      !< Local tangential velocity at node [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx_elast_dot      !< Local relative axial acceleration at node (for CDBEMT) [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vy_elast_dot      !< Local relative tangential acceleration at node (for CDBEMT) [m/s^2]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: omega_z      !< rotation of no-sweep-pitch-twist coordinate system around z (for CDBEMT and CUA) [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rLocal      !< Radial distance from center-of-rotation to node [m]
    REAL(ReKi)  :: Un_disk      !< disk-averaged velocity normal to the rotor disk (for input to DBEMT) [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: UserProp      !< Optional user property for interpolating airfoils (per element per blade) [-]
  END TYPE BEMT_InputType
! =======================
! =========  BEMT_OutputType  =======
  TYPE, PUBLIC :: BEMT_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vrel      !< Total local relative velocity [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< angle between the plane of rotation and the direction of the local wind [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: axInduction      !< axial induction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tanInduction      !< tangential induction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Re      !< Reynold's number [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AOA      !< angle of attack [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cx      !< normal force coefficient (normal to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cy      !< tangential force coefficient (tangential to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cm      !< pitching moment coefficient of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cl      !< lift coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cd      !< drag coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chi      !< wake skew angle [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cpmin      !< min Cpressure [-]
  END TYPE BEMT_OutputType
! =======================
CONTAINS
 SUBROUTINE BEMT_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(BEMT_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitInputData%chord)) THEN
  i1_l = LBOUND(SrcInitInputData%chord,1)
  i1_u = UBOUND(SrcInitInputData%chord,1)
  i2_l = LBOUND(SrcInitInputData%chord,2)
  i2_u = UBOUND(SrcInitInputData%chord,2)
  IF (.NOT. ALLOCATED(DstInitInputData%chord)) THEN 
    ALLOCATE(DstInitInputData%chord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%chord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%chord = SrcInitInputData%chord
ENDIF
    DstInitInputData%numBlades = SrcInitInputData%numBlades
    DstInitInputData%airDens = SrcInitInputData%airDens
    DstInitInputData%kinVisc = SrcInitInputData%kinVisc
    DstInitInputData%skewWakeMod = SrcInitInputData%skewWakeMod
    DstInitInputData%aTol = SrcInitInputData%aTol
    DstInitInputData%useTipLoss = SrcInitInputData%useTipLoss
    DstInitInputData%useHubLoss = SrcInitInputData%useHubLoss
    DstInitInputData%useInduction = SrcInitInputData%useInduction
    DstInitInputData%useTanInd = SrcInitInputData%useTanInd
    DstInitInputData%useAIDrag = SrcInitInputData%useAIDrag
    DstInitInputData%useTIDrag = SrcInitInputData%useTIDrag
    DstInitInputData%numBladeNodes = SrcInitInputData%numBladeNodes
    DstInitInputData%numReIterations = SrcInitInputData%numReIterations
    DstInitInputData%maxIndIterations = SrcInitInputData%maxIndIterations
IF (ALLOCATED(SrcInitInputData%AFindx)) THEN
  i1_l = LBOUND(SrcInitInputData%AFindx,1)
  i1_u = UBOUND(SrcInitInputData%AFindx,1)
  i2_l = LBOUND(SrcInitInputData%AFindx,2)
  i2_u = UBOUND(SrcInitInputData%AFindx,2)
  IF (.NOT. ALLOCATED(DstInitInputData%AFindx)) THEN 
    ALLOCATE(DstInitInputData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AFindx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%AFindx = SrcInitInputData%AFindx
ENDIF
IF (ALLOCATED(SrcInitInputData%zHub)) THEN
  i1_l = LBOUND(SrcInitInputData%zHub,1)
  i1_u = UBOUND(SrcInitInputData%zHub,1)
  IF (.NOT. ALLOCATED(DstInitInputData%zHub)) THEN 
    ALLOCATE(DstInitInputData%zHub(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zHub.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%zHub = SrcInitInputData%zHub
ENDIF
IF (ALLOCATED(SrcInitInputData%zLocal)) THEN
  i1_l = LBOUND(SrcInitInputData%zLocal,1)
  i1_u = UBOUND(SrcInitInputData%zLocal,1)
  i2_l = LBOUND(SrcInitInputData%zLocal,2)
  i2_u = UBOUND(SrcInitInputData%zLocal,2)
  IF (.NOT. ALLOCATED(DstInitInputData%zLocal)) THEN 
    ALLOCATE(DstInitInputData%zLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zLocal.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%zLocal = SrcInitInputData%zLocal
ENDIF
IF (ALLOCATED(SrcInitInputData%zTip)) THEN
  i1_l = LBOUND(SrcInitInputData%zTip,1)
  i1_u = UBOUND(SrcInitInputData%zTip,1)
  IF (.NOT. ALLOCATED(DstInitInputData%zTip)) THEN 
    ALLOCATE(DstInitInputData%zTip(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zTip.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%zTip = SrcInitInputData%zTip
ENDIF
IF (ALLOCATED(SrcInitInputData%rLocal)) THEN
  i1_l = LBOUND(SrcInitInputData%rLocal,1)
  i1_u = UBOUND(SrcInitInputData%rLocal,1)
  i2_l = LBOUND(SrcInitInputData%rLocal,2)
  i2_u = UBOUND(SrcInitInputData%rLocal,2)
  IF (.NOT. ALLOCATED(DstInitInputData%rLocal)) THEN 
    ALLOCATE(DstInitInputData%rLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%rLocal.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%rLocal = SrcInitInputData%rLocal
ENDIF
    DstInitInputData%UAMod = SrcInitInputData%UAMod
    DstInitInputData%UA_Flag = SrcInitInputData%UA_Flag
    DstInitInputData%Flookup = SrcInitInputData%Flookup
    DstInitInputData%a_s = SrcInitInputData%a_s
    DstInitInputData%DBEMT_Mod = SrcInitInputData%DBEMT_Mod
    DstInitInputData%tau1_const = SrcInitInputData%tau1_const
    DstInitInputData%yawCorrFactor = SrcInitInputData%yawCorrFactor
IF (ALLOCATED(SrcInitInputData%UAOff_innerNode)) THEN
  i1_l = LBOUND(SrcInitInputData%UAOff_innerNode,1)
  i1_u = UBOUND(SrcInitInputData%UAOff_innerNode,1)
  IF (.NOT. ALLOCATED(DstInitInputData%UAOff_innerNode)) THEN 
    ALLOCATE(DstInitInputData%UAOff_innerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_innerNode.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%UAOff_innerNode = SrcInitInputData%UAOff_innerNode
ENDIF
IF (ALLOCATED(SrcInitInputData%UAOff_outerNode)) THEN
  i1_l = LBOUND(SrcInitInputData%UAOff_outerNode,1)
  i1_u = UBOUND(SrcInitInputData%UAOff_outerNode,1)
  IF (.NOT. ALLOCATED(DstInitInputData%UAOff_outerNode)) THEN 
    ALLOCATE(DstInitInputData%UAOff_outerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%UAOff_outerNode.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%UAOff_outerNode = SrcInitInputData%UAOff_outerNode
ENDIF
    DstInitInputData%RootName = SrcInitInputData%RootName
    DstInitInputData%SumPrint = SrcInitInputData%SumPrint
 END SUBROUTINE BEMT_CopyInitInput

 SUBROUTINE BEMT_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(BEMT_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%chord)) THEN
  DEALLOCATE(InitInputData%chord)
ENDIF
IF (ALLOCATED(InitInputData%AFindx)) THEN
  DEALLOCATE(InitInputData%AFindx)
ENDIF
IF (ALLOCATED(InitInputData%zHub)) THEN
  DEALLOCATE(InitInputData%zHub)
ENDIF
IF (ALLOCATED(InitInputData%zLocal)) THEN
  DEALLOCATE(InitInputData%zLocal)
ENDIF
IF (ALLOCATED(InitInputData%zTip)) THEN
  DEALLOCATE(InitInputData%zTip)
ENDIF
IF (ALLOCATED(InitInputData%rLocal)) THEN
  DEALLOCATE(InitInputData%rLocal)
ENDIF
IF (ALLOCATED(InitInputData%UAOff_innerNode)) THEN
  DEALLOCATE(InitInputData%UAOff_innerNode)
ENDIF
IF (ALLOCATED(InitInputData%UAOff_outerNode)) THEN
  DEALLOCATE(InitInputData%UAOff_outerNode)
ENDIF
 END SUBROUTINE BEMT_DestroyInitInput

 SUBROUTINE BEMT_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! chord allocated yes/no
  IF ( ALLOCATED(InData%chord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! chord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chord)  ! chord
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numBlades
      Re_BufSz   = Re_BufSz   + 1  ! airDens
      Re_BufSz   = Re_BufSz   + 1  ! kinVisc
      Int_BufSz  = Int_BufSz  + 1  ! skewWakeMod
      Re_BufSz   = Re_BufSz   + 1  ! aTol
      Int_BufSz  = Int_BufSz  + 1  ! useTipLoss
      Int_BufSz  = Int_BufSz  + 1  ! useHubLoss
      Int_BufSz  = Int_BufSz  + 1  ! useInduction
      Int_BufSz  = Int_BufSz  + 1  ! useTanInd
      Int_BufSz  = Int_BufSz  + 1  ! useAIDrag
      Int_BufSz  = Int_BufSz  + 1  ! useTIDrag
      Int_BufSz  = Int_BufSz  + 1  ! numBladeNodes
      Int_BufSz  = Int_BufSz  + 1  ! numReIterations
      Int_BufSz  = Int_BufSz  + 1  ! maxIndIterations
  Int_BufSz   = Int_BufSz   + 1     ! AFindx allocated yes/no
  IF ( ALLOCATED(InData%AFindx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AFindx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AFindx)  ! AFindx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! zHub allocated yes/no
  IF ( ALLOCATED(InData%zHub) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! zHub upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%zHub)  ! zHub
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! zLocal allocated yes/no
  IF ( ALLOCATED(InData%zLocal) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! zLocal upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%zLocal)  ! zLocal
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! zTip allocated yes/no
  IF ( ALLOCATED(InData%zTip) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! zTip upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%zTip)  ! zTip
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rLocal allocated yes/no
  IF ( ALLOCATED(InData%rLocal) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rLocal upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rLocal)  ! rLocal
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! UAMod
      Int_BufSz  = Int_BufSz  + 1  ! UA_Flag
      Int_BufSz  = Int_BufSz  + 1  ! Flookup
      Re_BufSz   = Re_BufSz   + 1  ! a_s
      Int_BufSz  = Int_BufSz  + 1  ! DBEMT_Mod
      Re_BufSz   = Re_BufSz   + 1  ! tau1_const
      Re_BufSz   = Re_BufSz   + 1  ! yawCorrFactor
  Int_BufSz   = Int_BufSz   + 1     ! UAOff_innerNode allocated yes/no
  IF ( ALLOCATED(InData%UAOff_innerNode) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UAOff_innerNode upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%UAOff_innerNode)  ! UAOff_innerNode
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! UAOff_outerNode allocated yes/no
  IF ( ALLOCATED(InData%UAOff_outerNode) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! UAOff_outerNode upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%UAOff_outerNode)  ! UAOff_outerNode
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
      Int_BufSz  = Int_BufSz  + 1  ! SumPrint
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%chord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%chord,2), UBOUND(InData%chord,2)
        DO i1 = LBOUND(InData%chord,1), UBOUND(InData%chord,1)
          ReKiBuf(Re_Xferred) = InData%chord(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numBlades
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%airDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%kinVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%skewWakeMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%aTol
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTipLoss, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useHubLoss, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useInduction, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTanInd, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useAIDrag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTIDrag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%numBladeNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%numReIterations
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%maxIndIterations
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AFindx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AFindx,2), UBOUND(InData%AFindx,2)
        DO i1 = LBOUND(InData%AFindx,1), UBOUND(InData%AFindx,1)
          IntKiBuf(Int_Xferred) = InData%AFindx(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%zHub) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zHub,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zHub,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%zHub,1), UBOUND(InData%zHub,1)
        ReKiBuf(Re_Xferred) = InData%zHub(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%zLocal) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zLocal,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zLocal,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zLocal,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zLocal,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%zLocal,2), UBOUND(InData%zLocal,2)
        DO i1 = LBOUND(InData%zLocal,1), UBOUND(InData%zLocal,1)
          ReKiBuf(Re_Xferred) = InData%zLocal(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%zTip) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zTip,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zTip,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%zTip,1), UBOUND(InData%zTip,1)
        ReKiBuf(Re_Xferred) = InData%zTip(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rLocal) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLocal,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLocal,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLocal,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLocal,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rLocal,2), UBOUND(InData%rLocal,2)
        DO i1 = LBOUND(InData%rLocal,1), UBOUND(InData%rLocal,1)
          ReKiBuf(Re_Xferred) = InData%rLocal(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%UAMod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UA_Flag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%Flookup, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%a_s
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%DBEMT_Mod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%tau1_const
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%yawCorrFactor
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UAOff_innerNode) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UAOff_innerNode,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UAOff_innerNode,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%UAOff_innerNode,1), UBOUND(InData%UAOff_innerNode,1)
        IntKiBuf(Int_Xferred) = InData%UAOff_innerNode(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%UAOff_outerNode) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UAOff_outerNode,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UAOff_outerNode,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%UAOff_outerNode,1), UBOUND(InData%UAOff_outerNode,1)
        IntKiBuf(Int_Xferred) = InData%UAOff_outerNode(i1)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = TRANSFER(InData%SumPrint, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE BEMT_PackInitInput

 SUBROUTINE BEMT_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chord)) DEALLOCATE(OutData%chord)
    ALLOCATE(OutData%chord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%chord,2), UBOUND(OutData%chord,2)
        DO i1 = LBOUND(OutData%chord,1), UBOUND(OutData%chord,1)
          OutData%chord(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%numBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%airDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%kinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%skewWakeMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%aTol = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%useTipLoss = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTipLoss)
    Int_Xferred = Int_Xferred + 1
    OutData%useHubLoss = TRANSFER(IntKiBuf(Int_Xferred), OutData%useHubLoss)
    Int_Xferred = Int_Xferred + 1
    OutData%useInduction = TRANSFER(IntKiBuf(Int_Xferred), OutData%useInduction)
    Int_Xferred = Int_Xferred + 1
    OutData%useTanInd = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTanInd)
    Int_Xferred = Int_Xferred + 1
    OutData%useAIDrag = TRANSFER(IntKiBuf(Int_Xferred), OutData%useAIDrag)
    Int_Xferred = Int_Xferred + 1
    OutData%useTIDrag = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTIDrag)
    Int_Xferred = Int_Xferred + 1
    OutData%numBladeNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%numReIterations = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%maxIndIterations = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFindx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFindx)) DEALLOCATE(OutData%AFindx)
    ALLOCATE(OutData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFindx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AFindx,2), UBOUND(OutData%AFindx,2)
        DO i1 = LBOUND(OutData%AFindx,1), UBOUND(OutData%AFindx,1)
          OutData%AFindx(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! zHub not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%zHub)) DEALLOCATE(OutData%zHub)
    ALLOCATE(OutData%zHub(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%zHub.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%zHub,1), UBOUND(OutData%zHub,1)
        OutData%zHub(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! zLocal not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%zLocal)) DEALLOCATE(OutData%zLocal)
    ALLOCATE(OutData%zLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%zLocal.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%zLocal,2), UBOUND(OutData%zLocal,2)
        DO i1 = LBOUND(OutData%zLocal,1), UBOUND(OutData%zLocal,1)
          OutData%zLocal(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! zTip not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%zTip)) DEALLOCATE(OutData%zTip)
    ALLOCATE(OutData%zTip(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%zTip.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%zTip,1), UBOUND(OutData%zTip,1)
        OutData%zTip(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rLocal not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rLocal)) DEALLOCATE(OutData%rLocal)
    ALLOCATE(OutData%rLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rLocal.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rLocal,2), UBOUND(OutData%rLocal,2)
        DO i1 = LBOUND(OutData%rLocal,1), UBOUND(OutData%rLocal,1)
          OutData%rLocal(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%UAMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%UA_Flag = TRANSFER(IntKiBuf(Int_Xferred), OutData%UA_Flag)
    Int_Xferred = Int_Xferred + 1
    OutData%Flookup = TRANSFER(IntKiBuf(Int_Xferred), OutData%Flookup)
    Int_Xferred = Int_Xferred + 1
    OutData%a_s = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%DBEMT_Mod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%tau1_const = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%yawCorrFactor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UAOff_innerNode not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UAOff_innerNode)) DEALLOCATE(OutData%UAOff_innerNode)
    ALLOCATE(OutData%UAOff_innerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UAOff_innerNode.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%UAOff_innerNode,1), UBOUND(OutData%UAOff_innerNode,1)
        OutData%UAOff_innerNode(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UAOff_outerNode not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UAOff_outerNode)) DEALLOCATE(OutData%UAOff_outerNode)
    ALLOCATE(OutData%UAOff_outerNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UAOff_outerNode.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%UAOff_outerNode,1), UBOUND(OutData%UAOff_outerNode,1)
        OutData%UAOff_outerNode(i1) = IntKiBuf(Int_Xferred)
        Int_Xferred = Int_Xferred + 1
      END DO
  END IF
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%SumPrint = TRANSFER(IntKiBuf(Int_Xferred), OutData%SumPrint)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE BEMT_UnPackInitInput

 SUBROUTINE BEMT_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(BEMT_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Version, DstInitOutputData%Version, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE BEMT_CopyInitOutput

 SUBROUTINE BEMT_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(BEMT_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Version, ErrStat, ErrMsg )
 END SUBROUTINE BEMT_DestroyInitOutput

 SUBROUTINE BEMT_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Version: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Version, ErrStat2, ErrMsg2, .TRUE. ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Version
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Version
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Version
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Version, ErrStat2, ErrMsg2, OnlySize ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE BEMT_PackInitOutput

 SUBROUTINE BEMT_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Version, ErrStat2, ErrMsg2 ) ! Version 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE BEMT_UnPackInitOutput

 SUBROUTINE BEMT_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(BEMT_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL UA_CopyContState( SrcContStateData%UA, DstContStateData%UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL DBEMT_CopyContState( SrcContStateData%DBEMT, DstContStateData%DBEMT, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE BEMT_CopyContState

 SUBROUTINE BEMT_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(BEMT_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL UA_DestroyContState( ContStateData%UA, ErrStat, ErrMsg )
  CALL DBEMT_DestroyContState( ContStateData%DBEMT, ErrStat, ErrMsg )
 END SUBROUTINE BEMT_DestroyContState

 SUBROUTINE BEMT_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! DBEMT: size of buffers for each call to pack subtype
      CALL DBEMT_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, .TRUE. ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DBEMT
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DBEMT
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DBEMT
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL UA_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL DBEMT_PackContState( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, OnlySize ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE BEMT_PackContState

 SUBROUTINE BEMT_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%UA, ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DBEMT_UnpackContState( Re_Buf, Db_Buf, Int_Buf, OutData%DBEMT, ErrStat2, ErrMsg2 ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE BEMT_UnPackContState

 SUBROUTINE BEMT_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(BEMT_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL UA_CopyDiscState( SrcDiscStateData%UA, DstDiscStateData%UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
 END SUBROUTINE BEMT_CopyDiscState

 SUBROUTINE BEMT_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(BEMT_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL UA_DestroyDiscState( DiscStateData%UA, ErrStat, ErrMsg )
 END SUBROUTINE BEMT_DestroyDiscState

 SUBROUTINE BEMT_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL UA_PackDiscState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
 END SUBROUTINE BEMT_PackDiscState

 SUBROUTINE BEMT_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackDiscState( Re_Buf, Db_Buf, Int_Buf, OutData%UA, ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
 END SUBROUTINE BEMT_UnPackDiscState

 SUBROUTINE BEMT_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(BEMT_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcConstrStateData%phi)) THEN
  i1_l = LBOUND(SrcConstrStateData%phi,1)
  i1_u = UBOUND(SrcConstrStateData%phi,1)
  i2_l = LBOUND(SrcConstrStateData%phi,2)
  i2_u = UBOUND(SrcConstrStateData%phi,2)
  IF (.NOT. ALLOCATED(DstConstrStateData%phi)) THEN 
    ALLOCATE(DstConstrStateData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%phi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstConstrStateData%phi = SrcConstrStateData%phi
ENDIF
 END SUBROUTINE BEMT_CopyConstrState

 SUBROUTINE BEMT_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(BEMT_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ConstrStateData%phi)) THEN
  DEALLOCATE(ConstrStateData%phi)
ENDIF
 END SUBROUTINE BEMT_DestroyConstrState

 SUBROUTINE BEMT_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! phi allocated yes/no
  IF ( ALLOCATED(InData%phi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! phi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%phi)  ! phi
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%phi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%phi,2), UBOUND(InData%phi,2)
        DO i1 = LBOUND(InData%phi,1), UBOUND(InData%phi,1)
          ReKiBuf(Re_Xferred) = InData%phi(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_PackConstrState

 SUBROUTINE BEMT_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! phi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%phi)) DEALLOCATE(OutData%phi)
    ALLOCATE(OutData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%phi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%phi,2), UBOUND(OutData%phi,2)
        DO i1 = LBOUND(OutData%phi,1), UBOUND(OutData%phi,1)
          OutData%phi(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_UnPackConstrState

 SUBROUTINE BEMT_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(BEMT_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
      CALL UA_CopyOtherState( SrcOtherStateData%UA, DstOtherStateData%UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL DBEMT_CopyOtherState( SrcOtherStateData%DBEMT, DstOtherStateData%DBEMT, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcOtherStateData%ValidPhi)) THEN
  i1_l = LBOUND(SrcOtherStateData%ValidPhi,1)
  i1_u = UBOUND(SrcOtherStateData%ValidPhi,1)
  i2_l = LBOUND(SrcOtherStateData%ValidPhi,2)
  i2_u = UBOUND(SrcOtherStateData%ValidPhi,2)
  IF (.NOT. ALLOCATED(DstOtherStateData%ValidPhi)) THEN 
    ALLOCATE(DstOtherStateData%ValidPhi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%ValidPhi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOtherStateData%ValidPhi = SrcOtherStateData%ValidPhi
ENDIF
    DstOtherStateData%nodesInitialized = SrcOtherStateData%nodesInitialized
 END SUBROUTINE BEMT_CopyOtherState

 SUBROUTINE BEMT_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(BEMT_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL UA_DestroyOtherState( OtherStateData%UA, ErrStat, ErrMsg )
  CALL DBEMT_DestroyOtherState( OtherStateData%DBEMT, ErrStat, ErrMsg )
IF (ALLOCATED(OtherStateData%ValidPhi)) THEN
  DEALLOCATE(OtherStateData%ValidPhi)
ENDIF
 END SUBROUTINE BEMT_DestroyOtherState

 SUBROUTINE BEMT_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! DBEMT: size of buffers for each call to pack subtype
      CALL DBEMT_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, .TRUE. ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DBEMT
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DBEMT
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DBEMT
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! ValidPhi allocated yes/no
  IF ( ALLOCATED(InData%ValidPhi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! ValidPhi upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%ValidPhi)  ! ValidPhi
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! nodesInitialized
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

      CALL UA_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL DBEMT_PackOtherState( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, OnlySize ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%ValidPhi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ValidPhi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ValidPhi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ValidPhi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ValidPhi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%ValidPhi,2), UBOUND(InData%ValidPhi,2)
        DO i1 = LBOUND(InData%ValidPhi,1), UBOUND(InData%ValidPhi,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%ValidPhi(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%nodesInitialized, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE BEMT_PackOtherState

 SUBROUTINE BEMT_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackOtherState( Re_Buf, Db_Buf, Int_Buf, OutData%UA, ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DBEMT_UnpackOtherState( Re_Buf, Db_Buf, Int_Buf, OutData%DBEMT, ErrStat2, ErrMsg2 ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ValidPhi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ValidPhi)) DEALLOCATE(OutData%ValidPhi)
    ALLOCATE(OutData%ValidPhi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ValidPhi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%ValidPhi,2), UBOUND(OutData%ValidPhi,2)
        DO i1 = LBOUND(OutData%ValidPhi,1), UBOUND(OutData%ValidPhi,1)
          OutData%ValidPhi(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%ValidPhi(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    OutData%nodesInitialized = TRANSFER(IntKiBuf(Int_Xferred), OutData%nodesInitialized)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE BEMT_UnPackOtherState

 SUBROUTINE BEMT_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(BEMT_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstMiscData%FirstWarn_Skew = SrcMiscData%FirstWarn_Skew
    DstMiscData%FirstWarn_Phi = SrcMiscData%FirstWarn_Phi
    DstMiscData%FirstWarn_BEMoff = SrcMiscData%FirstWarn_BEMoff
      CALL UA_CopyMisc( SrcMiscData%UA, DstMiscData%UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL DBEMT_CopyMisc( SrcMiscData%DBEMT, DstMiscData%DBEMT, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL UA_CopyOutput( SrcMiscData%y_UA, DstMiscData%y_UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
IF (ALLOCATED(SrcMiscData%u_UA)) THEN
  i1_l = LBOUND(SrcMiscData%u_UA,1)
  i1_u = UBOUND(SrcMiscData%u_UA,1)
  i2_l = LBOUND(SrcMiscData%u_UA,2)
  i2_u = UBOUND(SrcMiscData%u_UA,2)
  i3_l = LBOUND(SrcMiscData%u_UA,3)
  i3_u = UBOUND(SrcMiscData%u_UA,3)
  IF (.NOT. ALLOCATED(DstMiscData%u_UA)) THEN 
    ALLOCATE(DstMiscData%u_UA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_UA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i3 = LBOUND(SrcMiscData%u_UA,3), UBOUND(SrcMiscData%u_UA,3)
    DO i2 = LBOUND(SrcMiscData%u_UA,2), UBOUND(SrcMiscData%u_UA,2)
    DO i1 = LBOUND(SrcMiscData%u_UA,1), UBOUND(SrcMiscData%u_UA,1)
      CALL UA_CopyInput( SrcMiscData%u_UA(i1,i2,i3), DstMiscData%u_UA(i1,i2,i3), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
    ENDDO
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%u_DBEMT)) THEN
  i1_l = LBOUND(SrcMiscData%u_DBEMT,1)
  i1_u = UBOUND(SrcMiscData%u_DBEMT,1)
  IF (.NOT. ALLOCATED(DstMiscData%u_DBEMT)) THEN 
    ALLOCATE(DstMiscData%u_DBEMT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_DBEMT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcMiscData%u_DBEMT,1), UBOUND(SrcMiscData%u_DBEMT,1)
      CALL DBEMT_CopyInput( SrcMiscData%u_DBEMT(i1), DstMiscData%u_DBEMT(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcMiscData%TnInd_op)) THEN
  i1_l = LBOUND(SrcMiscData%TnInd_op,1)
  i1_u = UBOUND(SrcMiscData%TnInd_op,1)
  i2_l = LBOUND(SrcMiscData%TnInd_op,2)
  i2_u = UBOUND(SrcMiscData%TnInd_op,2)
  IF (.NOT. ALLOCATED(DstMiscData%TnInd_op)) THEN 
    ALLOCATE(DstMiscData%TnInd_op(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TnInd_op.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%TnInd_op = SrcMiscData%TnInd_op
ENDIF
IF (ALLOCATED(SrcMiscData%AxInd_op)) THEN
  i1_l = LBOUND(SrcMiscData%AxInd_op,1)
  i1_u = UBOUND(SrcMiscData%AxInd_op,1)
  i2_l = LBOUND(SrcMiscData%AxInd_op,2)
  i2_u = UBOUND(SrcMiscData%AxInd_op,2)
  IF (.NOT. ALLOCATED(DstMiscData%AxInd_op)) THEN 
    ALLOCATE(DstMiscData%AxInd_op(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AxInd_op.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AxInd_op = SrcMiscData%AxInd_op
ENDIF
IF (ALLOCATED(SrcMiscData%AxInduction)) THEN
  i1_l = LBOUND(SrcMiscData%AxInduction,1)
  i1_u = UBOUND(SrcMiscData%AxInduction,1)
  i2_l = LBOUND(SrcMiscData%AxInduction,2)
  i2_u = UBOUND(SrcMiscData%AxInduction,2)
  IF (.NOT. ALLOCATED(DstMiscData%AxInduction)) THEN 
    ALLOCATE(DstMiscData%AxInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AxInduction.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AxInduction = SrcMiscData%AxInduction
ENDIF
IF (ALLOCATED(SrcMiscData%TanInduction)) THEN
  i1_l = LBOUND(SrcMiscData%TanInduction,1)
  i1_u = UBOUND(SrcMiscData%TanInduction,1)
  i2_l = LBOUND(SrcMiscData%TanInduction,2)
  i2_u = UBOUND(SrcMiscData%TanInduction,2)
  IF (.NOT. ALLOCATED(DstMiscData%TanInduction)) THEN 
    ALLOCATE(DstMiscData%TanInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TanInduction.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%TanInduction = SrcMiscData%TanInduction
ENDIF
    DstMiscData%UseFrozenWake = SrcMiscData%UseFrozenWake
IF (ALLOCATED(SrcMiscData%Rtip)) THEN
  i1_l = LBOUND(SrcMiscData%Rtip,1)
  i1_u = UBOUND(SrcMiscData%Rtip,1)
  IF (.NOT. ALLOCATED(DstMiscData%Rtip)) THEN 
    ALLOCATE(DstMiscData%Rtip(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Rtip.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%Rtip = SrcMiscData%Rtip
ENDIF
IF (ALLOCATED(SrcMiscData%phi)) THEN
  i1_l = LBOUND(SrcMiscData%phi,1)
  i1_u = UBOUND(SrcMiscData%phi,1)
  i2_l = LBOUND(SrcMiscData%phi,2)
  i2_u = UBOUND(SrcMiscData%phi,2)
  IF (.NOT. ALLOCATED(DstMiscData%phi)) THEN 
    ALLOCATE(DstMiscData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%phi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%phi = SrcMiscData%phi
ENDIF
IF (ALLOCATED(SrcMiscData%chi)) THEN
  i1_l = LBOUND(SrcMiscData%chi,1)
  i1_u = UBOUND(SrcMiscData%chi,1)
  i2_l = LBOUND(SrcMiscData%chi,2)
  i2_u = UBOUND(SrcMiscData%chi,2)
  IF (.NOT. ALLOCATED(DstMiscData%chi)) THEN 
    ALLOCATE(DstMiscData%chi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%chi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%chi = SrcMiscData%chi
ENDIF
IF (ALLOCATED(SrcMiscData%ValidPhi)) THEN
  i1_l = LBOUND(SrcMiscData%ValidPhi,1)
  i1_u = UBOUND(SrcMiscData%ValidPhi,1)
  i2_l = LBOUND(SrcMiscData%ValidPhi,2)
  i2_u = UBOUND(SrcMiscData%ValidPhi,2)
  IF (.NOT. ALLOCATED(DstMiscData%ValidPhi)) THEN 
    ALLOCATE(DstMiscData%ValidPhi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ValidPhi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%ValidPhi = SrcMiscData%ValidPhi
ENDIF
    DstMiscData%BEM_weight = SrcMiscData%BEM_weight
 END SUBROUTINE BEMT_CopyMisc

 SUBROUTINE BEMT_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(BEMT_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
  CALL UA_DestroyMisc( MiscData%UA, ErrStat, ErrMsg )
  CALL DBEMT_DestroyMisc( MiscData%DBEMT, ErrStat, ErrMsg )
  CALL UA_DestroyOutput( MiscData%y_UA, ErrStat, ErrMsg )
IF (ALLOCATED(MiscData%u_UA)) THEN
DO i3 = LBOUND(MiscData%u_UA,3), UBOUND(MiscData%u_UA,3)
DO i2 = LBOUND(MiscData%u_UA,2), UBOUND(MiscData%u_UA,2)
DO i1 = LBOUND(MiscData%u_UA,1), UBOUND(MiscData%u_UA,1)
  CALL UA_DestroyInput( MiscData%u_UA(i1,i2,i3), ErrStat, ErrMsg )
ENDDO
ENDDO
ENDDO
  DEALLOCATE(MiscData%u_UA)
ENDIF
IF (ALLOCATED(MiscData%u_DBEMT)) THEN
DO i1 = LBOUND(MiscData%u_DBEMT,1), UBOUND(MiscData%u_DBEMT,1)
  CALL DBEMT_DestroyInput( MiscData%u_DBEMT(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(MiscData%u_DBEMT)
ENDIF
IF (ALLOCATED(MiscData%TnInd_op)) THEN
  DEALLOCATE(MiscData%TnInd_op)
ENDIF
IF (ALLOCATED(MiscData%AxInd_op)) THEN
  DEALLOCATE(MiscData%AxInd_op)
ENDIF
IF (ALLOCATED(MiscData%AxInduction)) THEN
  DEALLOCATE(MiscData%AxInduction)
ENDIF
IF (ALLOCATED(MiscData%TanInduction)) THEN
  DEALLOCATE(MiscData%TanInduction)
ENDIF
IF (ALLOCATED(MiscData%Rtip)) THEN
  DEALLOCATE(MiscData%Rtip)
ENDIF
IF (ALLOCATED(MiscData%phi)) THEN
  DEALLOCATE(MiscData%phi)
ENDIF
IF (ALLOCATED(MiscData%chi)) THEN
  DEALLOCATE(MiscData%chi)
ENDIF
IF (ALLOCATED(MiscData%ValidPhi)) THEN
  DEALLOCATE(MiscData%ValidPhi)
ENDIF
 END SUBROUTINE BEMT_DestroyMisc

 SUBROUTINE BEMT_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_Skew
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_Phi
      Int_BufSz  = Int_BufSz  + 1  ! FirstWarn_BEMoff
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! DBEMT: size of buffers for each call to pack subtype
      CALL DBEMT_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, .TRUE. ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DBEMT
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DBEMT
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DBEMT
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! y_UA: size of buffers for each call to pack subtype
      CALL UA_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_UA, ErrStat2, ErrMsg2, .TRUE. ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! y_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! y_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! y_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
  Int_BufSz   = Int_BufSz   + 1     ! u_UA allocated yes/no
  IF ( ALLOCATED(InData%u_UA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! u_UA upper/lower bounds for each dimension
    DO i3 = LBOUND(InData%u_UA,3), UBOUND(InData%u_UA,3)
    DO i2 = LBOUND(InData%u_UA,2), UBOUND(InData%u_UA,2)
    DO i1 = LBOUND(InData%u_UA,1), UBOUND(InData%u_UA,1)
      Int_BufSz   = Int_BufSz + 3  ! u_UA: size of buffers for each call to pack subtype
      CALL UA_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_UA(i1,i2,i3), ErrStat2, ErrMsg2, .TRUE. ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! u_UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! u_UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! u_UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
    END DO
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! u_DBEMT allocated yes/no
  IF ( ALLOCATED(InData%u_DBEMT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! u_DBEMT upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%u_DBEMT,1), UBOUND(InData%u_DBEMT,1)
      Int_BufSz   = Int_BufSz + 3  ! u_DBEMT: size of buffers for each call to pack subtype
      CALL DBEMT_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_DBEMT(i1), ErrStat2, ErrMsg2, .TRUE. ) ! u_DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! u_DBEMT
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! u_DBEMT
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! u_DBEMT
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TnInd_op allocated yes/no
  IF ( ALLOCATED(InData%TnInd_op) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TnInd_op upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TnInd_op)  ! TnInd_op
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxInd_op allocated yes/no
  IF ( ALLOCATED(InData%AxInd_op) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AxInd_op upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxInd_op)  ! AxInd_op
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AxInduction allocated yes/no
  IF ( ALLOCATED(InData%AxInduction) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AxInduction upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AxInduction)  ! AxInduction
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TanInduction allocated yes/no
  IF ( ALLOCATED(InData%TanInduction) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TanInduction upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TanInduction)  ! TanInduction
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! UseFrozenWake
  Int_BufSz   = Int_BufSz   + 1     ! Rtip allocated yes/no
  IF ( ALLOCATED(InData%Rtip) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Rtip upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Rtip)  ! Rtip
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! phi allocated yes/no
  IF ( ALLOCATED(InData%phi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! phi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%phi)  ! phi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! chi allocated yes/no
  IF ( ALLOCATED(InData%chi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! chi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chi)  ! chi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ValidPhi allocated yes/no
  IF ( ALLOCATED(InData%ValidPhi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! ValidPhi upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%ValidPhi)  ! ValidPhi
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! BEM_weight
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_Skew, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_Phi, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%FirstWarn_BEMoff, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
      CALL UA_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL DBEMT_PackMisc( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, OnlySize ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL UA_PackOutput( Re_Buf, Db_Buf, Int_Buf, InData%y_UA, ErrStat2, ErrMsg2, OnlySize ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
  IF ( .NOT. ALLOCATED(InData%u_UA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_UA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_UA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_UA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_UA,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_UA,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_UA,3)
    Int_Xferred = Int_Xferred + 2

    DO i3 = LBOUND(InData%u_UA,3), UBOUND(InData%u_UA,3)
    DO i2 = LBOUND(InData%u_UA,2), UBOUND(InData%u_UA,2)
    DO i1 = LBOUND(InData%u_UA,1), UBOUND(InData%u_UA,1)
      CALL UA_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_UA(i1,i2,i3), ErrStat2, ErrMsg2, OnlySize ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
    END DO
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%u_DBEMT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%u_DBEMT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%u_DBEMT,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%u_DBEMT,1), UBOUND(InData%u_DBEMT,1)
      CALL DBEMT_PackInput( Re_Buf, Db_Buf, Int_Buf, InData%u_DBEMT(i1), ErrStat2, ErrMsg2, OnlySize ) ! u_DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TnInd_op) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TnInd_op,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TnInd_op,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TnInd_op,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TnInd_op,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TnInd_op,2), UBOUND(InData%TnInd_op,2)
        DO i1 = LBOUND(InData%TnInd_op,1), UBOUND(InData%TnInd_op,1)
          ReKiBuf(Re_Xferred) = InData%TnInd_op(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxInd_op) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxInd_op,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxInd_op,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxInd_op,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxInd_op,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AxInd_op,2), UBOUND(InData%AxInd_op,2)
        DO i1 = LBOUND(InData%AxInd_op,1), UBOUND(InData%AxInd_op,1)
          ReKiBuf(Re_Xferred) = InData%AxInd_op(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AxInduction) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxInduction,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxInduction,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AxInduction,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AxInduction,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AxInduction,2), UBOUND(InData%AxInduction,2)
        DO i1 = LBOUND(InData%AxInduction,1), UBOUND(InData%AxInduction,1)
          ReKiBuf(Re_Xferred) = InData%AxInduction(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TanInduction) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TanInduction,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TanInduction,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TanInduction,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TanInduction,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TanInduction,2), UBOUND(InData%TanInduction,2)
        DO i1 = LBOUND(InData%TanInduction,1), UBOUND(InData%TanInduction,1)
          ReKiBuf(Re_Xferred) = InData%TanInduction(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UseFrozenWake, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Rtip) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Rtip,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Rtip,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Rtip,1), UBOUND(InData%Rtip,1)
        ReKiBuf(Re_Xferred) = InData%Rtip(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%phi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%phi,2), UBOUND(InData%phi,2)
        DO i1 = LBOUND(InData%phi,1), UBOUND(InData%phi,1)
          ReKiBuf(Re_Xferred) = InData%phi(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%chi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%chi,2), UBOUND(InData%chi,2)
        DO i1 = LBOUND(InData%chi,1), UBOUND(InData%chi,1)
          ReKiBuf(Re_Xferred) = InData%chi(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ValidPhi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ValidPhi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ValidPhi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ValidPhi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ValidPhi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%ValidPhi,2), UBOUND(InData%ValidPhi,2)
        DO i1 = LBOUND(InData%ValidPhi,1), UBOUND(InData%ValidPhi,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%ValidPhi(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%BEM_weight
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE BEMT_PackMisc

 SUBROUTINE BEMT_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%FirstWarn_Skew = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_Skew)
    Int_Xferred = Int_Xferred + 1
    OutData%FirstWarn_Phi = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_Phi)
    Int_Xferred = Int_Xferred + 1
    OutData%FirstWarn_BEMoff = TRANSFER(IntKiBuf(Int_Xferred), OutData%FirstWarn_BEMoff)
    Int_Xferred = Int_Xferred + 1
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackMisc( Re_Buf, Db_Buf, Int_Buf, OutData%UA, ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DBEMT_UnpackMisc( Re_Buf, Db_Buf, Int_Buf, OutData%DBEMT, ErrStat2, ErrMsg2 ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackOutput( Re_Buf, Db_Buf, Int_Buf, OutData%y_UA, ErrStat2, ErrMsg2 ) ! y_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! u_UA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%u_UA)) DEALLOCATE(OutData%u_UA)
    ALLOCATE(OutData%u_UA(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_UA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i3 = LBOUND(OutData%u_UA,3), UBOUND(OutData%u_UA,3)
    DO i2 = LBOUND(OutData%u_UA,2), UBOUND(OutData%u_UA,2)
    DO i1 = LBOUND(OutData%u_UA,1), UBOUND(OutData%u_UA,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackInput( Re_Buf, Db_Buf, Int_Buf, OutData%u_UA(i1,i2,i3), ErrStat2, ErrMsg2 ) ! u_UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
    END DO
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! u_DBEMT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%u_DBEMT)) DEALLOCATE(OutData%u_DBEMT)
    ALLOCATE(OutData%u_DBEMT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_DBEMT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%u_DBEMT,1), UBOUND(OutData%u_DBEMT,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DBEMT_UnpackInput( Re_Buf, Db_Buf, Int_Buf, OutData%u_DBEMT(i1), ErrStat2, ErrMsg2 ) ! u_DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TnInd_op not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TnInd_op)) DEALLOCATE(OutData%TnInd_op)
    ALLOCATE(OutData%TnInd_op(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TnInd_op.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TnInd_op,2), UBOUND(OutData%TnInd_op,2)
        DO i1 = LBOUND(OutData%TnInd_op,1), UBOUND(OutData%TnInd_op,1)
          OutData%TnInd_op(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxInd_op not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxInd_op)) DEALLOCATE(OutData%AxInd_op)
    ALLOCATE(OutData%AxInd_op(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxInd_op.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AxInd_op,2), UBOUND(OutData%AxInd_op,2)
        DO i1 = LBOUND(OutData%AxInd_op,1), UBOUND(OutData%AxInd_op,1)
          OutData%AxInd_op(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AxInduction not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AxInduction)) DEALLOCATE(OutData%AxInduction)
    ALLOCATE(OutData%AxInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AxInduction.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AxInduction,2), UBOUND(OutData%AxInduction,2)
        DO i1 = LBOUND(OutData%AxInduction,1), UBOUND(OutData%AxInduction,1)
          OutData%AxInduction(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TanInduction not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TanInduction)) DEALLOCATE(OutData%TanInduction)
    ALLOCATE(OutData%TanInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TanInduction.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TanInduction,2), UBOUND(OutData%TanInduction,2)
        DO i1 = LBOUND(OutData%TanInduction,1), UBOUND(OutData%TanInduction,1)
          OutData%TanInduction(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%UseFrozenWake = TRANSFER(IntKiBuf(Int_Xferred), OutData%UseFrozenWake)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Rtip not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Rtip)) DEALLOCATE(OutData%Rtip)
    ALLOCATE(OutData%Rtip(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Rtip.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Rtip,1), UBOUND(OutData%Rtip,1)
        OutData%Rtip(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! phi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%phi)) DEALLOCATE(OutData%phi)
    ALLOCATE(OutData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%phi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%phi,2), UBOUND(OutData%phi,2)
        DO i1 = LBOUND(OutData%phi,1), UBOUND(OutData%phi,1)
          OutData%phi(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chi)) DEALLOCATE(OutData%chi)
    ALLOCATE(OutData%chi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%chi,2), UBOUND(OutData%chi,2)
        DO i1 = LBOUND(OutData%chi,1), UBOUND(OutData%chi,1)
          OutData%chi(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ValidPhi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ValidPhi)) DEALLOCATE(OutData%ValidPhi)
    ALLOCATE(OutData%ValidPhi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ValidPhi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%ValidPhi,2), UBOUND(OutData%ValidPhi,2)
        DO i1 = LBOUND(OutData%ValidPhi,1), UBOUND(OutData%ValidPhi,1)
          OutData%ValidPhi(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%ValidPhi(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
    OutData%BEM_weight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE BEMT_UnPackMisc

 SUBROUTINE BEMT_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(BEMT_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
IF (ALLOCATED(SrcParamData%chord)) THEN
  i1_l = LBOUND(SrcParamData%chord,1)
  i1_u = UBOUND(SrcParamData%chord,1)
  i2_l = LBOUND(SrcParamData%chord,2)
  i2_u = UBOUND(SrcParamData%chord,2)
  IF (.NOT. ALLOCATED(DstParamData%chord)) THEN 
    ALLOCATE(DstParamData%chord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%chord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%chord = SrcParamData%chord
ENDIF
    DstParamData%numBlades = SrcParamData%numBlades
    DstParamData%airDens = SrcParamData%airDens
    DstParamData%kinVisc = SrcParamData%kinVisc
    DstParamData%skewWakeMod = SrcParamData%skewWakeMod
    DstParamData%aTol = SrcParamData%aTol
    DstParamData%useTipLoss = SrcParamData%useTipLoss
    DstParamData%useHubLoss = SrcParamData%useHubLoss
    DstParamData%useInduction = SrcParamData%useInduction
    DstParamData%useTanInd = SrcParamData%useTanInd
    DstParamData%useAIDrag = SrcParamData%useAIDrag
    DstParamData%useTIDrag = SrcParamData%useTIDrag
    DstParamData%numBladeNodes = SrcParamData%numBladeNodes
    DstParamData%numReIterations = SrcParamData%numReIterations
    DstParamData%maxIndIterations = SrcParamData%maxIndIterations
IF (ALLOCATED(SrcParamData%AFindx)) THEN
  i1_l = LBOUND(SrcParamData%AFindx,1)
  i1_u = UBOUND(SrcParamData%AFindx,1)
  i2_l = LBOUND(SrcParamData%AFindx,2)
  i2_u = UBOUND(SrcParamData%AFindx,2)
  IF (.NOT. ALLOCATED(DstParamData%AFindx)) THEN 
    ALLOCATE(DstParamData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFindx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AFindx = SrcParamData%AFindx
ENDIF
IF (ALLOCATED(SrcParamData%tipLossConst)) THEN
  i1_l = LBOUND(SrcParamData%tipLossConst,1)
  i1_u = UBOUND(SrcParamData%tipLossConst,1)
  i2_l = LBOUND(SrcParamData%tipLossConst,2)
  i2_u = UBOUND(SrcParamData%tipLossConst,2)
  IF (.NOT. ALLOCATED(DstParamData%tipLossConst)) THEN 
    ALLOCATE(DstParamData%tipLossConst(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%tipLossConst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%tipLossConst = SrcParamData%tipLossConst
ENDIF
IF (ALLOCATED(SrcParamData%hubLossConst)) THEN
  i1_l = LBOUND(SrcParamData%hubLossConst,1)
  i1_u = UBOUND(SrcParamData%hubLossConst,1)
  i2_l = LBOUND(SrcParamData%hubLossConst,2)
  i2_u = UBOUND(SrcParamData%hubLossConst,2)
  IF (.NOT. ALLOCATED(DstParamData%hubLossConst)) THEN 
    ALLOCATE(DstParamData%hubLossConst(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%hubLossConst.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%hubLossConst = SrcParamData%hubLossConst
ENDIF
IF (ALLOCATED(SrcParamData%zHub)) THEN
  i1_l = LBOUND(SrcParamData%zHub,1)
  i1_u = UBOUND(SrcParamData%zHub,1)
  IF (.NOT. ALLOCATED(DstParamData%zHub)) THEN 
    ALLOCATE(DstParamData%zHub(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%zHub.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%zHub = SrcParamData%zHub
ENDIF
      CALL UA_CopyParam( SrcParamData%UA, DstParamData%UA, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
      CALL DBEMT_CopyParam( SrcParamData%DBEMT, DstParamData%DBEMT, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstParamData%UA_Flag = SrcParamData%UA_Flag
    DstParamData%DBEMT_Mod = SrcParamData%DBEMT_Mod
    DstParamData%yawCorrFactor = SrcParamData%yawCorrFactor
IF (ALLOCATED(SrcParamData%FixedInductions)) THEN
  i1_l = LBOUND(SrcParamData%FixedInductions,1)
  i1_u = UBOUND(SrcParamData%FixedInductions,1)
  i2_l = LBOUND(SrcParamData%FixedInductions,2)
  i2_u = UBOUND(SrcParamData%FixedInductions,2)
  IF (.NOT. ALLOCATED(DstParamData%FixedInductions)) THEN 
    ALLOCATE(DstParamData%FixedInductions(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FixedInductions.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FixedInductions = SrcParamData%FixedInductions
ENDIF
 END SUBROUTINE BEMT_CopyParam

 SUBROUTINE BEMT_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(BEMT_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%chord)) THEN
  DEALLOCATE(ParamData%chord)
ENDIF
IF (ALLOCATED(ParamData%AFindx)) THEN
  DEALLOCATE(ParamData%AFindx)
ENDIF
IF (ALLOCATED(ParamData%tipLossConst)) THEN
  DEALLOCATE(ParamData%tipLossConst)
ENDIF
IF (ALLOCATED(ParamData%hubLossConst)) THEN
  DEALLOCATE(ParamData%hubLossConst)
ENDIF
IF (ALLOCATED(ParamData%zHub)) THEN
  DEALLOCATE(ParamData%zHub)
ENDIF
  CALL UA_DestroyParam( ParamData%UA, ErrStat, ErrMsg )
  CALL DBEMT_DestroyParam( ParamData%DBEMT, ErrStat, ErrMsg )
IF (ALLOCATED(ParamData%FixedInductions)) THEN
  DEALLOCATE(ParamData%FixedInductions)
ENDIF
 END SUBROUTINE BEMT_DestroyParam

 SUBROUTINE BEMT_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
  Int_BufSz   = Int_BufSz   + 1     ! chord allocated yes/no
  IF ( ALLOCATED(InData%chord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! chord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chord)  ! chord
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! numBlades
      Re_BufSz   = Re_BufSz   + 1  ! airDens
      Re_BufSz   = Re_BufSz   + 1  ! kinVisc
      Int_BufSz  = Int_BufSz  + 1  ! skewWakeMod
      Re_BufSz   = Re_BufSz   + 1  ! aTol
      Int_BufSz  = Int_BufSz  + 1  ! useTipLoss
      Int_BufSz  = Int_BufSz  + 1  ! useHubLoss
      Int_BufSz  = Int_BufSz  + 1  ! useInduction
      Int_BufSz  = Int_BufSz  + 1  ! useTanInd
      Int_BufSz  = Int_BufSz  + 1  ! useAIDrag
      Int_BufSz  = Int_BufSz  + 1  ! useTIDrag
      Int_BufSz  = Int_BufSz  + 1  ! numBladeNodes
      Int_BufSz  = Int_BufSz  + 1  ! numReIterations
      Int_BufSz  = Int_BufSz  + 1  ! maxIndIterations
  Int_BufSz   = Int_BufSz   + 1     ! AFindx allocated yes/no
  IF ( ALLOCATED(InData%AFindx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AFindx upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AFindx)  ! AFindx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! tipLossConst allocated yes/no
  IF ( ALLOCATED(InData%tipLossConst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! tipLossConst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%tipLossConst)  ! tipLossConst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! hubLossConst allocated yes/no
  IF ( ALLOCATED(InData%hubLossConst) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! hubLossConst upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%hubLossConst)  ! hubLossConst
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! zHub allocated yes/no
  IF ( ALLOCATED(InData%zHub) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! zHub upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%zHub)  ! zHub
  END IF
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! UA: size of buffers for each call to pack subtype
      CALL UA_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, .TRUE. ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! UA
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! UA
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! UA
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz   = Int_BufSz + 3  ! DBEMT: size of buffers for each call to pack subtype
      CALL DBEMT_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, .TRUE. ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! DBEMT
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! DBEMT
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! DBEMT
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Int_BufSz  = Int_BufSz  + 1  ! UA_Flag
      Int_BufSz  = Int_BufSz  + 1  ! DBEMT_Mod
      Re_BufSz   = Re_BufSz   + 1  ! yawCorrFactor
  Int_BufSz   = Int_BufSz   + 1     ! FixedInductions allocated yes/no
  IF ( ALLOCATED(InData%FixedInductions) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! FixedInductions upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%FixedInductions)  ! FixedInductions
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%chord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chord,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chord,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%chord,2), UBOUND(InData%chord,2)
        DO i1 = LBOUND(InData%chord,1), UBOUND(InData%chord,1)
          ReKiBuf(Re_Xferred) = InData%chord(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%numBlades
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%airDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%kinVisc
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%skewWakeMod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%aTol
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTipLoss, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useHubLoss, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useInduction, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTanInd, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useAIDrag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%useTIDrag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%numBladeNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%numReIterations
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%maxIndIterations
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AFindx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFindx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFindx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AFindx,2), UBOUND(InData%AFindx,2)
        DO i1 = LBOUND(InData%AFindx,1), UBOUND(InData%AFindx,1)
          IntKiBuf(Int_Xferred) = InData%AFindx(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%tipLossConst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tipLossConst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tipLossConst,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tipLossConst,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tipLossConst,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%tipLossConst,2), UBOUND(InData%tipLossConst,2)
        DO i1 = LBOUND(InData%tipLossConst,1), UBOUND(InData%tipLossConst,1)
          ReKiBuf(Re_Xferred) = InData%tipLossConst(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%hubLossConst) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%hubLossConst,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%hubLossConst,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%hubLossConst,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%hubLossConst,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%hubLossConst,2), UBOUND(InData%hubLossConst,2)
        DO i1 = LBOUND(InData%hubLossConst,1), UBOUND(InData%hubLossConst,1)
          ReKiBuf(Re_Xferred) = InData%hubLossConst(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%zHub) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%zHub,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%zHub,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%zHub,1), UBOUND(InData%zHub,1)
        ReKiBuf(Re_Xferred) = InData%zHub(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      CALL UA_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%UA, ErrStat2, ErrMsg2, OnlySize ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      CALL DBEMT_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%DBEMT, ErrStat2, ErrMsg2, OnlySize ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    IntKiBuf(Int_Xferred) = TRANSFER(InData%UA_Flag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%DBEMT_Mod
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%yawCorrFactor
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%FixedInductions) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FixedInductions,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FixedInductions,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FixedInductions,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FixedInductions,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%FixedInductions,2), UBOUND(InData%FixedInductions,2)
        DO i1 = LBOUND(InData%FixedInductions,1), UBOUND(InData%FixedInductions,1)
          IntKiBuf(Int_Xferred) = TRANSFER(InData%FixedInductions(i1,i2), IntKiBuf(1))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_PackParam

 SUBROUTINE BEMT_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chord)) DEALLOCATE(OutData%chord)
    ALLOCATE(OutData%chord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%chord,2), UBOUND(OutData%chord,2)
        DO i1 = LBOUND(OutData%chord,1), UBOUND(OutData%chord,1)
          OutData%chord(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%numBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%airDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%kinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%skewWakeMod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%aTol = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%useTipLoss = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTipLoss)
    Int_Xferred = Int_Xferred + 1
    OutData%useHubLoss = TRANSFER(IntKiBuf(Int_Xferred), OutData%useHubLoss)
    Int_Xferred = Int_Xferred + 1
    OutData%useInduction = TRANSFER(IntKiBuf(Int_Xferred), OutData%useInduction)
    Int_Xferred = Int_Xferred + 1
    OutData%useTanInd = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTanInd)
    Int_Xferred = Int_Xferred + 1
    OutData%useAIDrag = TRANSFER(IntKiBuf(Int_Xferred), OutData%useAIDrag)
    Int_Xferred = Int_Xferred + 1
    OutData%useTIDrag = TRANSFER(IntKiBuf(Int_Xferred), OutData%useTIDrag)
    Int_Xferred = Int_Xferred + 1
    OutData%numBladeNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%numReIterations = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%maxIndIterations = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFindx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFindx)) DEALLOCATE(OutData%AFindx)
    ALLOCATE(OutData%AFindx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFindx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AFindx,2), UBOUND(OutData%AFindx,2)
        DO i1 = LBOUND(OutData%AFindx,1), UBOUND(OutData%AFindx,1)
          OutData%AFindx(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! tipLossConst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%tipLossConst)) DEALLOCATE(OutData%tipLossConst)
    ALLOCATE(OutData%tipLossConst(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%tipLossConst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%tipLossConst,2), UBOUND(OutData%tipLossConst,2)
        DO i1 = LBOUND(OutData%tipLossConst,1), UBOUND(OutData%tipLossConst,1)
          OutData%tipLossConst(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! hubLossConst not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%hubLossConst)) DEALLOCATE(OutData%hubLossConst)
    ALLOCATE(OutData%hubLossConst(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%hubLossConst.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%hubLossConst,2), UBOUND(OutData%hubLossConst,2)
        DO i1 = LBOUND(OutData%hubLossConst,1), UBOUND(OutData%hubLossConst,1)
          OutData%hubLossConst(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! zHub not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%zHub)) DEALLOCATE(OutData%zHub)
    ALLOCATE(OutData%zHub(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%zHub.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%zHub,1), UBOUND(OutData%zHub,1)
        OutData%zHub(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL UA_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%UA, ErrStat2, ErrMsg2 ) ! UA 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL DBEMT_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%DBEMT, ErrStat2, ErrMsg2 ) ! DBEMT 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%UA_Flag = TRANSFER(IntKiBuf(Int_Xferred), OutData%UA_Flag)
    Int_Xferred = Int_Xferred + 1
    OutData%DBEMT_Mod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%yawCorrFactor = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FixedInductions not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FixedInductions)) DEALLOCATE(OutData%FixedInductions)
    ALLOCATE(OutData%FixedInductions(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FixedInductions.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%FixedInductions,2), UBOUND(OutData%FixedInductions,2)
        DO i1 = LBOUND(OutData%FixedInductions,1), UBOUND(OutData%FixedInductions,1)
          OutData%FixedInductions(i1,i2) = TRANSFER(IntKiBuf(Int_Xferred), OutData%FixedInductions(i1,i2))
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_UnPackParam

 SUBROUTINE BEMT_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_InputType), INTENT(IN) :: SrcInputData
   TYPE(BEMT_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInputData%theta)) THEN
  i1_l = LBOUND(SrcInputData%theta,1)
  i1_u = UBOUND(SrcInputData%theta,1)
  i2_l = LBOUND(SrcInputData%theta,2)
  i2_u = UBOUND(SrcInputData%theta,2)
  IF (.NOT. ALLOCATED(DstInputData%theta)) THEN 
    ALLOCATE(DstInputData%theta(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%theta.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%theta = SrcInputData%theta
ENDIF
    DstInputData%chi0 = SrcInputData%chi0
IF (ALLOCATED(SrcInputData%psi)) THEN
  i1_l = LBOUND(SrcInputData%psi,1)
  i1_u = UBOUND(SrcInputData%psi,1)
  IF (.NOT. ALLOCATED(DstInputData%psi)) THEN 
    ALLOCATE(DstInputData%psi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%psi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%psi = SrcInputData%psi
ENDIF
    DstInputData%omega = SrcInputData%omega
    DstInputData%TSR = SrcInputData%TSR
IF (ALLOCATED(SrcInputData%Vx)) THEN
  i1_l = LBOUND(SrcInputData%Vx,1)
  i1_u = UBOUND(SrcInputData%Vx,1)
  i2_l = LBOUND(SrcInputData%Vx,2)
  i2_u = UBOUND(SrcInputData%Vx,2)
  IF (.NOT. ALLOCATED(DstInputData%Vx)) THEN 
    ALLOCATE(DstInputData%Vx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vx = SrcInputData%Vx
ENDIF
IF (ALLOCATED(SrcInputData%Vy)) THEN
  i1_l = LBOUND(SrcInputData%Vy,1)
  i1_u = UBOUND(SrcInputData%Vy,1)
  i2_l = LBOUND(SrcInputData%Vy,2)
  i2_u = UBOUND(SrcInputData%Vy,2)
  IF (.NOT. ALLOCATED(DstInputData%Vy)) THEN 
    ALLOCATE(DstInputData%Vy(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vy.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vy = SrcInputData%Vy
ENDIF
IF (ALLOCATED(SrcInputData%Vx_elast_dot)) THEN
  i1_l = LBOUND(SrcInputData%Vx_elast_dot,1)
  i1_u = UBOUND(SrcInputData%Vx_elast_dot,1)
  i2_l = LBOUND(SrcInputData%Vx_elast_dot,2)
  i2_u = UBOUND(SrcInputData%Vx_elast_dot,2)
  IF (.NOT. ALLOCATED(DstInputData%Vx_elast_dot)) THEN 
    ALLOCATE(DstInputData%Vx_elast_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vx_elast_dot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vx_elast_dot = SrcInputData%Vx_elast_dot
ENDIF
IF (ALLOCATED(SrcInputData%Vy_elast_dot)) THEN
  i1_l = LBOUND(SrcInputData%Vy_elast_dot,1)
  i1_u = UBOUND(SrcInputData%Vy_elast_dot,1)
  i2_l = LBOUND(SrcInputData%Vy_elast_dot,2)
  i2_u = UBOUND(SrcInputData%Vy_elast_dot,2)
  IF (.NOT. ALLOCATED(DstInputData%Vy_elast_dot)) THEN 
    ALLOCATE(DstInputData%Vy_elast_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vy_elast_dot.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vy_elast_dot = SrcInputData%Vy_elast_dot
ENDIF
IF (ALLOCATED(SrcInputData%omega_z)) THEN
  i1_l = LBOUND(SrcInputData%omega_z,1)
  i1_u = UBOUND(SrcInputData%omega_z,1)
  i2_l = LBOUND(SrcInputData%omega_z,2)
  i2_u = UBOUND(SrcInputData%omega_z,2)
  IF (.NOT. ALLOCATED(DstInputData%omega_z)) THEN 
    ALLOCATE(DstInputData%omega_z(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%omega_z.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%omega_z = SrcInputData%omega_z
ENDIF
IF (ALLOCATED(SrcInputData%rLocal)) THEN
  i1_l = LBOUND(SrcInputData%rLocal,1)
  i1_u = UBOUND(SrcInputData%rLocal,1)
  i2_l = LBOUND(SrcInputData%rLocal,2)
  i2_u = UBOUND(SrcInputData%rLocal,2)
  IF (.NOT. ALLOCATED(DstInputData%rLocal)) THEN 
    ALLOCATE(DstInputData%rLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%rLocal.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%rLocal = SrcInputData%rLocal
ENDIF
    DstInputData%Un_disk = SrcInputData%Un_disk
IF (ALLOCATED(SrcInputData%UserProp)) THEN
  i1_l = LBOUND(SrcInputData%UserProp,1)
  i1_u = UBOUND(SrcInputData%UserProp,1)
  i2_l = LBOUND(SrcInputData%UserProp,2)
  i2_u = UBOUND(SrcInputData%UserProp,2)
  IF (.NOT. ALLOCATED(DstInputData%UserProp)) THEN 
    ALLOCATE(DstInputData%UserProp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%UserProp.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%UserProp = SrcInputData%UserProp
ENDIF
 END SUBROUTINE BEMT_CopyInput

 SUBROUTINE BEMT_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(BEMT_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%theta)) THEN
  DEALLOCATE(InputData%theta)
ENDIF
IF (ALLOCATED(InputData%psi)) THEN
  DEALLOCATE(InputData%psi)
ENDIF
IF (ALLOCATED(InputData%Vx)) THEN
  DEALLOCATE(InputData%Vx)
ENDIF
IF (ALLOCATED(InputData%Vy)) THEN
  DEALLOCATE(InputData%Vy)
ENDIF
IF (ALLOCATED(InputData%Vx_elast_dot)) THEN
  DEALLOCATE(InputData%Vx_elast_dot)
ENDIF
IF (ALLOCATED(InputData%Vy_elast_dot)) THEN
  DEALLOCATE(InputData%Vy_elast_dot)
ENDIF
IF (ALLOCATED(InputData%omega_z)) THEN
  DEALLOCATE(InputData%omega_z)
ENDIF
IF (ALLOCATED(InputData%rLocal)) THEN
  DEALLOCATE(InputData%rLocal)
ENDIF
IF (ALLOCATED(InputData%UserProp)) THEN
  DEALLOCATE(InputData%UserProp)
ENDIF
 END SUBROUTINE BEMT_DestroyInput

 SUBROUTINE BEMT_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! theta allocated yes/no
  IF ( ALLOCATED(InData%theta) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! theta upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%theta)  ! theta
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! chi0
  Int_BufSz   = Int_BufSz   + 1     ! psi allocated yes/no
  IF ( ALLOCATED(InData%psi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! psi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%psi)  ! psi
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! omega
      Re_BufSz   = Re_BufSz   + 1  ! TSR
  Int_BufSz   = Int_BufSz   + 1     ! Vx allocated yes/no
  IF ( ALLOCATED(InData%Vx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx)  ! Vx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vy allocated yes/no
  IF ( ALLOCATED(InData%Vy) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vy upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vy)  ! Vy
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vx_elast_dot allocated yes/no
  IF ( ALLOCATED(InData%Vx_elast_dot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vx_elast_dot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vx_elast_dot)  ! Vx_elast_dot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vy_elast_dot allocated yes/no
  IF ( ALLOCATED(InData%Vy_elast_dot) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vy_elast_dot upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vy_elast_dot)  ! Vy_elast_dot
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! omega_z allocated yes/no
  IF ( ALLOCATED(InData%omega_z) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! omega_z upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%omega_z)  ! omega_z
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rLocal allocated yes/no
  IF ( ALLOCATED(InData%rLocal) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! rLocal upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rLocal)  ! rLocal
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Un_disk
  Int_BufSz   = Int_BufSz   + 1     ! UserProp allocated yes/no
  IF ( ALLOCATED(InData%UserProp) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! UserProp upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%UserProp)  ! UserProp
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%theta) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%theta,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%theta,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%theta,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%theta,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%theta,2), UBOUND(InData%theta,2)
        DO i1 = LBOUND(InData%theta,1), UBOUND(InData%theta,1)
          ReKiBuf(Re_Xferred) = InData%theta(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%chi0
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%psi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%psi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%psi,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%psi,1), UBOUND(InData%psi,1)
        ReKiBuf(Re_Xferred) = InData%psi(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%omega
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TSR
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%Vx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vx,2), UBOUND(InData%Vx,2)
        DO i1 = LBOUND(InData%Vx,1), UBOUND(InData%Vx,1)
          ReKiBuf(Re_Xferred) = InData%Vx(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vy) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vy,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vy,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vy,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vy,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vy,2), UBOUND(InData%Vy,2)
        DO i1 = LBOUND(InData%Vy,1), UBOUND(InData%Vy,1)
          ReKiBuf(Re_Xferred) = InData%Vy(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vx_elast_dot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_elast_dot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_elast_dot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vx_elast_dot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vx_elast_dot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vx_elast_dot,2), UBOUND(InData%Vx_elast_dot,2)
        DO i1 = LBOUND(InData%Vx_elast_dot,1), UBOUND(InData%Vx_elast_dot,1)
          ReKiBuf(Re_Xferred) = InData%Vx_elast_dot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vy_elast_dot) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vy_elast_dot,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vy_elast_dot,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vy_elast_dot,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vy_elast_dot,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vy_elast_dot,2), UBOUND(InData%Vy_elast_dot,2)
        DO i1 = LBOUND(InData%Vy_elast_dot,1), UBOUND(InData%Vy_elast_dot,1)
          ReKiBuf(Re_Xferred) = InData%Vy_elast_dot(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%omega_z) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omega_z,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omega_z,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%omega_z,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%omega_z,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%omega_z,2), UBOUND(InData%omega_z,2)
        DO i1 = LBOUND(InData%omega_z,1), UBOUND(InData%omega_z,1)
          ReKiBuf(Re_Xferred) = InData%omega_z(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rLocal) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLocal,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLocal,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLocal,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLocal,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%rLocal,2), UBOUND(InData%rLocal,2)
        DO i1 = LBOUND(InData%rLocal,1), UBOUND(InData%rLocal,1)
          ReKiBuf(Re_Xferred) = InData%rLocal(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Un_disk
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%UserProp) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UserProp,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UserProp,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%UserProp,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%UserProp,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%UserProp,2), UBOUND(InData%UserProp,2)
        DO i1 = LBOUND(InData%UserProp,1), UBOUND(InData%UserProp,1)
          ReKiBuf(Re_Xferred) = InData%UserProp(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_PackInput

 SUBROUTINE BEMT_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! theta not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%theta)) DEALLOCATE(OutData%theta)
    ALLOCATE(OutData%theta(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%theta.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%theta,2), UBOUND(OutData%theta,2)
        DO i1 = LBOUND(OutData%theta,1), UBOUND(OutData%theta,1)
          OutData%theta(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%chi0 = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! psi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%psi)) DEALLOCATE(OutData%psi)
    ALLOCATE(OutData%psi(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%psi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%psi,1), UBOUND(OutData%psi,1)
        OutData%psi(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%omega = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TSR = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx)) DEALLOCATE(OutData%Vx)
    ALLOCATE(OutData%Vx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vx,2), UBOUND(OutData%Vx,2)
        DO i1 = LBOUND(OutData%Vx,1), UBOUND(OutData%Vx,1)
          OutData%Vx(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vy not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vy)) DEALLOCATE(OutData%Vy)
    ALLOCATE(OutData%Vy(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vy.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vy,2), UBOUND(OutData%Vy,2)
        DO i1 = LBOUND(OutData%Vy,1), UBOUND(OutData%Vy,1)
          OutData%Vy(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vx_elast_dot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vx_elast_dot)) DEALLOCATE(OutData%Vx_elast_dot)
    ALLOCATE(OutData%Vx_elast_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vx_elast_dot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vx_elast_dot,2), UBOUND(OutData%Vx_elast_dot,2)
        DO i1 = LBOUND(OutData%Vx_elast_dot,1), UBOUND(OutData%Vx_elast_dot,1)
          OutData%Vx_elast_dot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vy_elast_dot not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vy_elast_dot)) DEALLOCATE(OutData%Vy_elast_dot)
    ALLOCATE(OutData%Vy_elast_dot(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vy_elast_dot.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vy_elast_dot,2), UBOUND(OutData%Vy_elast_dot,2)
        DO i1 = LBOUND(OutData%Vy_elast_dot,1), UBOUND(OutData%Vy_elast_dot,1)
          OutData%Vy_elast_dot(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! omega_z not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%omega_z)) DEALLOCATE(OutData%omega_z)
    ALLOCATE(OutData%omega_z(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%omega_z.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%omega_z,2), UBOUND(OutData%omega_z,2)
        DO i1 = LBOUND(OutData%omega_z,1), UBOUND(OutData%omega_z,1)
          OutData%omega_z(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rLocal not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rLocal)) DEALLOCATE(OutData%rLocal)
    ALLOCATE(OutData%rLocal(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rLocal.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%rLocal,2), UBOUND(OutData%rLocal,2)
        DO i1 = LBOUND(OutData%rLocal,1), UBOUND(OutData%rLocal,1)
          OutData%rLocal(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%Un_disk = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! UserProp not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%UserProp)) DEALLOCATE(OutData%UserProp)
    ALLOCATE(OutData%UserProp(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%UserProp.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%UserProp,2), UBOUND(OutData%UserProp,2)
        DO i1 = LBOUND(OutData%UserProp,1), UBOUND(OutData%UserProp,1)
          OutData%UserProp(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_UnPackInput

 SUBROUTINE BEMT_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(BEMT_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(BEMT_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%Vrel)) THEN
  i1_l = LBOUND(SrcOutputData%Vrel,1)
  i1_u = UBOUND(SrcOutputData%Vrel,1)
  i2_l = LBOUND(SrcOutputData%Vrel,2)
  i2_u = UBOUND(SrcOutputData%Vrel,2)
  IF (.NOT. ALLOCATED(DstOutputData%Vrel)) THEN 
    ALLOCATE(DstOutputData%Vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Vrel = SrcOutputData%Vrel
ENDIF
IF (ALLOCATED(SrcOutputData%phi)) THEN
  i1_l = LBOUND(SrcOutputData%phi,1)
  i1_u = UBOUND(SrcOutputData%phi,1)
  i2_l = LBOUND(SrcOutputData%phi,2)
  i2_u = UBOUND(SrcOutputData%phi,2)
  IF (.NOT. ALLOCATED(DstOutputData%phi)) THEN 
    ALLOCATE(DstOutputData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%phi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%phi = SrcOutputData%phi
ENDIF
IF (ALLOCATED(SrcOutputData%axInduction)) THEN
  i1_l = LBOUND(SrcOutputData%axInduction,1)
  i1_u = UBOUND(SrcOutputData%axInduction,1)
  i2_l = LBOUND(SrcOutputData%axInduction,2)
  i2_u = UBOUND(SrcOutputData%axInduction,2)
  IF (.NOT. ALLOCATED(DstOutputData%axInduction)) THEN 
    ALLOCATE(DstOutputData%axInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%axInduction.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%axInduction = SrcOutputData%axInduction
ENDIF
IF (ALLOCATED(SrcOutputData%tanInduction)) THEN
  i1_l = LBOUND(SrcOutputData%tanInduction,1)
  i1_u = UBOUND(SrcOutputData%tanInduction,1)
  i2_l = LBOUND(SrcOutputData%tanInduction,2)
  i2_u = UBOUND(SrcOutputData%tanInduction,2)
  IF (.NOT. ALLOCATED(DstOutputData%tanInduction)) THEN 
    ALLOCATE(DstOutputData%tanInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%tanInduction.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%tanInduction = SrcOutputData%tanInduction
ENDIF
IF (ALLOCATED(SrcOutputData%Re)) THEN
  i1_l = LBOUND(SrcOutputData%Re,1)
  i1_u = UBOUND(SrcOutputData%Re,1)
  i2_l = LBOUND(SrcOutputData%Re,2)
  i2_u = UBOUND(SrcOutputData%Re,2)
  IF (.NOT. ALLOCATED(DstOutputData%Re)) THEN 
    ALLOCATE(DstOutputData%Re(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Re.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Re = SrcOutputData%Re
ENDIF
IF (ALLOCATED(SrcOutputData%AOA)) THEN
  i1_l = LBOUND(SrcOutputData%AOA,1)
  i1_u = UBOUND(SrcOutputData%AOA,1)
  i2_l = LBOUND(SrcOutputData%AOA,2)
  i2_u = UBOUND(SrcOutputData%AOA,2)
  IF (.NOT. ALLOCATED(DstOutputData%AOA)) THEN 
    ALLOCATE(DstOutputData%AOA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%AOA.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%AOA = SrcOutputData%AOA
ENDIF
IF (ALLOCATED(SrcOutputData%Cx)) THEN
  i1_l = LBOUND(SrcOutputData%Cx,1)
  i1_u = UBOUND(SrcOutputData%Cx,1)
  i2_l = LBOUND(SrcOutputData%Cx,2)
  i2_u = UBOUND(SrcOutputData%Cx,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cx)) THEN 
    ALLOCATE(DstOutputData%Cx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cx = SrcOutputData%Cx
ENDIF
IF (ALLOCATED(SrcOutputData%Cy)) THEN
  i1_l = LBOUND(SrcOutputData%Cy,1)
  i1_u = UBOUND(SrcOutputData%Cy,1)
  i2_l = LBOUND(SrcOutputData%Cy,2)
  i2_u = UBOUND(SrcOutputData%Cy,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cy)) THEN 
    ALLOCATE(DstOutputData%Cy(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cy.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cy = SrcOutputData%Cy
ENDIF
IF (ALLOCATED(SrcOutputData%Cm)) THEN
  i1_l = LBOUND(SrcOutputData%Cm,1)
  i1_u = UBOUND(SrcOutputData%Cm,1)
  i2_l = LBOUND(SrcOutputData%Cm,2)
  i2_u = UBOUND(SrcOutputData%Cm,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cm)) THEN 
    ALLOCATE(DstOutputData%Cm(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cm.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cm = SrcOutputData%Cm
ENDIF
IF (ALLOCATED(SrcOutputData%Cl)) THEN
  i1_l = LBOUND(SrcOutputData%Cl,1)
  i1_u = UBOUND(SrcOutputData%Cl,1)
  i2_l = LBOUND(SrcOutputData%Cl,2)
  i2_u = UBOUND(SrcOutputData%Cl,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cl)) THEN 
    ALLOCATE(DstOutputData%Cl(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cl.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cl = SrcOutputData%Cl
ENDIF
IF (ALLOCATED(SrcOutputData%Cd)) THEN
  i1_l = LBOUND(SrcOutputData%Cd,1)
  i1_u = UBOUND(SrcOutputData%Cd,1)
  i2_l = LBOUND(SrcOutputData%Cd,2)
  i2_u = UBOUND(SrcOutputData%Cd,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cd)) THEN 
    ALLOCATE(DstOutputData%Cd(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cd.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cd = SrcOutputData%Cd
ENDIF
IF (ALLOCATED(SrcOutputData%chi)) THEN
  i1_l = LBOUND(SrcOutputData%chi,1)
  i1_u = UBOUND(SrcOutputData%chi,1)
  i2_l = LBOUND(SrcOutputData%chi,2)
  i2_u = UBOUND(SrcOutputData%chi,2)
  IF (.NOT. ALLOCATED(DstOutputData%chi)) THEN 
    ALLOCATE(DstOutputData%chi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%chi.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%chi = SrcOutputData%chi
ENDIF
IF (ALLOCATED(SrcOutputData%Cpmin)) THEN
  i1_l = LBOUND(SrcOutputData%Cpmin,1)
  i1_u = UBOUND(SrcOutputData%Cpmin,1)
  i2_l = LBOUND(SrcOutputData%Cpmin,2)
  i2_u = UBOUND(SrcOutputData%Cpmin,2)
  IF (.NOT. ALLOCATED(DstOutputData%Cpmin)) THEN 
    ALLOCATE(DstOutputData%Cpmin(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cpmin.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%Cpmin = SrcOutputData%Cpmin
ENDIF
 END SUBROUTINE BEMT_CopyOutput

 SUBROUTINE BEMT_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(BEMT_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'BEMT_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%Vrel)) THEN
  DEALLOCATE(OutputData%Vrel)
ENDIF
IF (ALLOCATED(OutputData%phi)) THEN
  DEALLOCATE(OutputData%phi)
ENDIF
IF (ALLOCATED(OutputData%axInduction)) THEN
  DEALLOCATE(OutputData%axInduction)
ENDIF
IF (ALLOCATED(OutputData%tanInduction)) THEN
  DEALLOCATE(OutputData%tanInduction)
ENDIF
IF (ALLOCATED(OutputData%Re)) THEN
  DEALLOCATE(OutputData%Re)
ENDIF
IF (ALLOCATED(OutputData%AOA)) THEN
  DEALLOCATE(OutputData%AOA)
ENDIF
IF (ALLOCATED(OutputData%Cx)) THEN
  DEALLOCATE(OutputData%Cx)
ENDIF
IF (ALLOCATED(OutputData%Cy)) THEN
  DEALLOCATE(OutputData%Cy)
ENDIF
IF (ALLOCATED(OutputData%Cm)) THEN
  DEALLOCATE(OutputData%Cm)
ENDIF
IF (ALLOCATED(OutputData%Cl)) THEN
  DEALLOCATE(OutputData%Cl)
ENDIF
IF (ALLOCATED(OutputData%Cd)) THEN
  DEALLOCATE(OutputData%Cd)
ENDIF
IF (ALLOCATED(OutputData%chi)) THEN
  DEALLOCATE(OutputData%chi)
ENDIF
IF (ALLOCATED(OutputData%Cpmin)) THEN
  DEALLOCATE(OutputData%Cpmin)
ENDIF
 END SUBROUTINE BEMT_DestroyOutput

 SUBROUTINE BEMT_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(BEMT_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! Vrel allocated yes/no
  IF ( ALLOCATED(InData%Vrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vrel)  ! Vrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! phi allocated yes/no
  IF ( ALLOCATED(InData%phi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! phi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%phi)  ! phi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! axInduction allocated yes/no
  IF ( ALLOCATED(InData%axInduction) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! axInduction upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%axInduction)  ! axInduction
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! tanInduction allocated yes/no
  IF ( ALLOCATED(InData%tanInduction) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! tanInduction upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%tanInduction)  ! tanInduction
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Re allocated yes/no
  IF ( ALLOCATED(InData%Re) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Re upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Re)  ! Re
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AOA allocated yes/no
  IF ( ALLOCATED(InData%AOA) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AOA upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AOA)  ! AOA
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cx allocated yes/no
  IF ( ALLOCATED(InData%Cx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cx)  ! Cx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cy allocated yes/no
  IF ( ALLOCATED(InData%Cy) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cy upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cy)  ! Cy
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cm allocated yes/no
  IF ( ALLOCATED(InData%Cm) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cm upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cm)  ! Cm
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cl allocated yes/no
  IF ( ALLOCATED(InData%Cl) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cl upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cl)  ! Cl
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cd allocated yes/no
  IF ( ALLOCATED(InData%Cd) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cd upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cd)  ! Cd
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! chi allocated yes/no
  IF ( ALLOCATED(InData%chi) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! chi upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%chi)  ! chi
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Cpmin allocated yes/no
  IF ( ALLOCATED(InData%Cpmin) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Cpmin upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Cpmin)  ! Cpmin
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%Vrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vrel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vrel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vrel,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vrel,2), UBOUND(InData%Vrel,2)
        DO i1 = LBOUND(InData%Vrel,1), UBOUND(InData%Vrel,1)
          ReKiBuf(Re_Xferred) = InData%Vrel(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%phi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%phi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%phi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%phi,2), UBOUND(InData%phi,2)
        DO i1 = LBOUND(InData%phi,1), UBOUND(InData%phi,1)
          ReKiBuf(Re_Xferred) = InData%phi(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%axInduction) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%axInduction,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%axInduction,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%axInduction,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%axInduction,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%axInduction,2), UBOUND(InData%axInduction,2)
        DO i1 = LBOUND(InData%axInduction,1), UBOUND(InData%axInduction,1)
          ReKiBuf(Re_Xferred) = InData%axInduction(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%tanInduction) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tanInduction,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tanInduction,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%tanInduction,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%tanInduction,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%tanInduction,2), UBOUND(InData%tanInduction,2)
        DO i1 = LBOUND(InData%tanInduction,1), UBOUND(InData%tanInduction,1)
          ReKiBuf(Re_Xferred) = InData%tanInduction(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Re) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Re,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Re,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Re,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Re,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Re,2), UBOUND(InData%Re,2)
        DO i1 = LBOUND(InData%Re,1), UBOUND(InData%Re,1)
          ReKiBuf(Re_Xferred) = InData%Re(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AOA) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AOA,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AOA,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AOA,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AOA,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AOA,2), UBOUND(InData%AOA,2)
        DO i1 = LBOUND(InData%AOA,1), UBOUND(InData%AOA,1)
          ReKiBuf(Re_Xferred) = InData%AOA(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cx,2), UBOUND(InData%Cx,2)
        DO i1 = LBOUND(InData%Cx,1), UBOUND(InData%Cx,1)
          ReKiBuf(Re_Xferred) = InData%Cx(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cy) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cy,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cy,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cy,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cy,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cy,2), UBOUND(InData%Cy,2)
        DO i1 = LBOUND(InData%Cy,1), UBOUND(InData%Cy,1)
          ReKiBuf(Re_Xferred) = InData%Cy(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cm) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cm,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cm,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cm,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cm,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cm,2), UBOUND(InData%Cm,2)
        DO i1 = LBOUND(InData%Cm,1), UBOUND(InData%Cm,1)
          ReKiBuf(Re_Xferred) = InData%Cm(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cl) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cl,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cl,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cl,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cl,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cl,2), UBOUND(InData%Cl,2)
        DO i1 = LBOUND(InData%Cl,1), UBOUND(InData%Cl,1)
          ReKiBuf(Re_Xferred) = InData%Cl(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cd) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cd,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cd,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cd,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cd,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cd,2), UBOUND(InData%Cd,2)
        DO i1 = LBOUND(InData%Cd,1), UBOUND(InData%Cd,1)
          ReKiBuf(Re_Xferred) = InData%Cd(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%chi) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chi,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chi,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%chi,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%chi,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%chi,2), UBOUND(InData%chi,2)
        DO i1 = LBOUND(InData%chi,1), UBOUND(InData%chi,1)
          ReKiBuf(Re_Xferred) = InData%chi(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Cpmin) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cpmin,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cpmin,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Cpmin,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Cpmin,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Cpmin,2), UBOUND(InData%Cpmin,2)
        DO i1 = LBOUND(InData%Cpmin,1), UBOUND(InData%Cpmin,1)
          ReKiBuf(Re_Xferred) = InData%Cpmin(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_PackOutput

 SUBROUTINE BEMT_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(BEMT_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'BEMT_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vrel)) DEALLOCATE(OutData%Vrel)
    ALLOCATE(OutData%Vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vrel,2), UBOUND(OutData%Vrel,2)
        DO i1 = LBOUND(OutData%Vrel,1), UBOUND(OutData%Vrel,1)
          OutData%Vrel(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! phi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%phi)) DEALLOCATE(OutData%phi)
    ALLOCATE(OutData%phi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%phi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%phi,2), UBOUND(OutData%phi,2)
        DO i1 = LBOUND(OutData%phi,1), UBOUND(OutData%phi,1)
          OutData%phi(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! axInduction not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%axInduction)) DEALLOCATE(OutData%axInduction)
    ALLOCATE(OutData%axInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%axInduction.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%axInduction,2), UBOUND(OutData%axInduction,2)
        DO i1 = LBOUND(OutData%axInduction,1), UBOUND(OutData%axInduction,1)
          OutData%axInduction(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! tanInduction not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%tanInduction)) DEALLOCATE(OutData%tanInduction)
    ALLOCATE(OutData%tanInduction(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%tanInduction.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%tanInduction,2), UBOUND(OutData%tanInduction,2)
        DO i1 = LBOUND(OutData%tanInduction,1), UBOUND(OutData%tanInduction,1)
          OutData%tanInduction(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Re not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Re)) DEALLOCATE(OutData%Re)
    ALLOCATE(OutData%Re(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Re.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Re,2), UBOUND(OutData%Re,2)
        DO i1 = LBOUND(OutData%Re,1), UBOUND(OutData%Re,1)
          OutData%Re(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AOA not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AOA)) DEALLOCATE(OutData%AOA)
    ALLOCATE(OutData%AOA(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AOA.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AOA,2), UBOUND(OutData%AOA,2)
        DO i1 = LBOUND(OutData%AOA,1), UBOUND(OutData%AOA,1)
          OutData%AOA(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cx)) DEALLOCATE(OutData%Cx)
    ALLOCATE(OutData%Cx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cx,2), UBOUND(OutData%Cx,2)
        DO i1 = LBOUND(OutData%Cx,1), UBOUND(OutData%Cx,1)
          OutData%Cx(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cy not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cy)) DEALLOCATE(OutData%Cy)
    ALLOCATE(OutData%Cy(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cy.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cy,2), UBOUND(OutData%Cy,2)
        DO i1 = LBOUND(OutData%Cy,1), UBOUND(OutData%Cy,1)
          OutData%Cy(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cm not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cm)) DEALLOCATE(OutData%Cm)
    ALLOCATE(OutData%Cm(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cm.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cm,2), UBOUND(OutData%Cm,2)
        DO i1 = LBOUND(OutData%Cm,1), UBOUND(OutData%Cm,1)
          OutData%Cm(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cl not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cl)) DEALLOCATE(OutData%Cl)
    ALLOCATE(OutData%Cl(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cl.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cl,2), UBOUND(OutData%Cl,2)
        DO i1 = LBOUND(OutData%Cl,1), UBOUND(OutData%Cl,1)
          OutData%Cl(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cd not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cd)) DEALLOCATE(OutData%Cd)
    ALLOCATE(OutData%Cd(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cd.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cd,2), UBOUND(OutData%Cd,2)
        DO i1 = LBOUND(OutData%Cd,1), UBOUND(OutData%Cd,1)
          OutData%Cd(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! chi not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%chi)) DEALLOCATE(OutData%chi)
    ALLOCATE(OutData%chi(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%chi.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%chi,2), UBOUND(OutData%chi,2)
        DO i1 = LBOUND(OutData%chi,1), UBOUND(OutData%chi,1)
          OutData%chi(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Cpmin not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Cpmin)) DEALLOCATE(OutData%Cpmin)
    ALLOCATE(OutData%Cpmin(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cpmin.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Cpmin,2), UBOUND(OutData%Cpmin,2)
        DO i1 = LBOUND(OutData%Cpmin,1), UBOUND(OutData%Cpmin,1)
          OutData%Cpmin(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE BEMT_UnPackOutput


 SUBROUTINE BEMT_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(BEMT_InputType), INTENT(IN)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(BEMT_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'BEMT_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL BEMT_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL BEMT_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL BEMT_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE BEMT_Input_ExtrapInterp


 SUBROUTINE BEMT_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(BEMT_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
 TYPE(BEMT_InputType), INTENT(IN)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(BEMT_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'BEMT_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(u_out%theta) .AND. ALLOCATED(u1%theta)) THEN
  DO i2 = LBOUND(u_out%theta,2),UBOUND(u_out%theta,2)
    DO i1 = LBOUND(u_out%theta,1),UBOUND(u_out%theta,1)
      b = -(u1%theta(i1,i2) - u2%theta(i1,i2))
      u_out%theta(i1,i2) = u1%theta(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
  b = -(u1%chi0 - u2%chi0)
  u_out%chi0 = u1%chi0 + b * ScaleFactor
IF (ALLOCATED(u_out%psi) .AND. ALLOCATED(u1%psi)) THEN
  DO i1 = LBOUND(u_out%psi,1),UBOUND(u_out%psi,1)
    b = -(u1%psi(i1) - u2%psi(i1))
    u_out%psi(i1) = u1%psi(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
  b = -(u1%omega - u2%omega)
  u_out%omega = u1%omega + b * ScaleFactor
  b = -(u1%TSR - u2%TSR)
  u_out%TSR = u1%TSR + b * ScaleFactor
IF (ALLOCATED(u_out%Vx) .AND. ALLOCATED(u1%Vx)) THEN
  DO i2 = LBOUND(u_out%Vx,2),UBOUND(u_out%Vx,2)
    DO i1 = LBOUND(u_out%Vx,1),UBOUND(u_out%Vx,1)
      b = -(u1%Vx(i1,i2) - u2%Vx(i1,i2))
      u_out%Vx(i1,i2) = u1%Vx(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vy) .AND. ALLOCATED(u1%Vy)) THEN
  DO i2 = LBOUND(u_out%Vy,2),UBOUND(u_out%Vy,2)
    DO i1 = LBOUND(u_out%Vy,1),UBOUND(u_out%Vy,1)
      b = -(u1%Vy(i1,i2) - u2%Vy(i1,i2))
      u_out%Vy(i1,i2) = u1%Vy(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vx_elast_dot) .AND. ALLOCATED(u1%Vx_elast_dot)) THEN
  DO i2 = LBOUND(u_out%Vx_elast_dot,2),UBOUND(u_out%Vx_elast_dot,2)
    DO i1 = LBOUND(u_out%Vx_elast_dot,1),UBOUND(u_out%Vx_elast_dot,1)
      b = -(u1%Vx_elast_dot(i1,i2) - u2%Vx_elast_dot(i1,i2))
      u_out%Vx_elast_dot(i1,i2) = u1%Vx_elast_dot(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vy_elast_dot) .AND. ALLOCATED(u1%Vy_elast_dot)) THEN
  DO i2 = LBOUND(u_out%Vy_elast_dot,2),UBOUND(u_out%Vy_elast_dot,2)
    DO i1 = LBOUND(u_out%Vy_elast_dot,1),UBOUND(u_out%Vy_elast_dot,1)
      b = -(u1%Vy_elast_dot(i1,i2) - u2%Vy_elast_dot(i1,i2))
      u_out%Vy_elast_dot(i1,i2) = u1%Vy_elast_dot(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%omega_z) .AND. ALLOCATED(u1%omega_z)) THEN
  DO i2 = LBOUND(u_out%omega_z,2),UBOUND(u_out%omega_z,2)
    DO i1 = LBOUND(u_out%omega_z,1),UBOUND(u_out%omega_z,1)
      b = -(u1%omega_z(i1,i2) - u2%omega_z(i1,i2))
      u_out%omega_z(i1,i2) = u1%omega_z(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%rLocal) .AND. ALLOCATED(u1%rLocal)) THEN
  DO i2 = LBOUND(u_out%rLocal,2),UBOUND(u_out%rLocal,2)
    DO i1 = LBOUND(u_out%rLocal,1),UBOUND(u_out%rLocal,1)
      b = -(u1%rLocal(i1,i2) - u2%rLocal(i1,i2))
      u_out%rLocal(i1,i2) = u1%rLocal(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
  b = -(u1%Un_disk - u2%Un_disk)
  u_out%Un_disk = u1%Un_disk + b * ScaleFactor
IF (ALLOCATED(u_out%UserProp) .AND. ALLOCATED(u1%UserProp)) THEN
  DO i2 = LBOUND(u_out%UserProp,2),UBOUND(u_out%UserProp,2)
    DO i1 = LBOUND(u_out%UserProp,1),UBOUND(u_out%UserProp,1)
      b = -(u1%UserProp(i1,i2) - u2%UserProp(i1,i2))
      u_out%UserProp(i1,i2) = u1%UserProp(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE BEMT_Input_ExtrapInterp1


 SUBROUTINE BEMT_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(BEMT_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
 TYPE(BEMT_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
 TYPE(BEMT_InputType), INTENT(IN)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(BEMT_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'BEMT_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(u_out%theta) .AND. ALLOCATED(u1%theta)) THEN
  DO i2 = LBOUND(u_out%theta,2),UBOUND(u_out%theta,2)
    DO i1 = LBOUND(u_out%theta,1),UBOUND(u_out%theta,1)
      b = (t(3)**2*(u1%theta(i1,i2) - u2%theta(i1,i2)) + t(2)**2*(-u1%theta(i1,i2) + u3%theta(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%theta(i1,i2) + t(3)*u2%theta(i1,i2) - t(2)*u3%theta(i1,i2) ) * scaleFactor
      u_out%theta(i1,i2) = u1%theta(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
  b = (t(3)**2*(u1%chi0 - u2%chi0) + t(2)**2*(-u1%chi0 + u3%chi0))* scaleFactor
  c = ( (t(2)-t(3))*u1%chi0 + t(3)*u2%chi0 - t(2)*u3%chi0 ) * scaleFactor
  u_out%chi0 = u1%chi0 + b  + c * t_out
IF (ALLOCATED(u_out%psi) .AND. ALLOCATED(u1%psi)) THEN
  DO i1 = LBOUND(u_out%psi,1),UBOUND(u_out%psi,1)
    b = (t(3)**2*(u1%psi(i1) - u2%psi(i1)) + t(2)**2*(-u1%psi(i1) + u3%psi(i1)))* scaleFactor
    c = ( (t(2)-t(3))*u1%psi(i1) + t(3)*u2%psi(i1) - t(2)*u3%psi(i1) ) * scaleFactor
    u_out%psi(i1) = u1%psi(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
  b = (t(3)**2*(u1%omega - u2%omega) + t(2)**2*(-u1%omega + u3%omega))* scaleFactor
  c = ( (t(2)-t(3))*u1%omega + t(3)*u2%omega - t(2)*u3%omega ) * scaleFactor
  u_out%omega = u1%omega + b  + c * t_out
  b = (t(3)**2*(u1%TSR - u2%TSR) + t(2)**2*(-u1%TSR + u3%TSR))* scaleFactor
  c = ( (t(2)-t(3))*u1%TSR + t(3)*u2%TSR - t(2)*u3%TSR ) * scaleFactor
  u_out%TSR = u1%TSR + b  + c * t_out
IF (ALLOCATED(u_out%Vx) .AND. ALLOCATED(u1%Vx)) THEN
  DO i2 = LBOUND(u_out%Vx,2),UBOUND(u_out%Vx,2)
    DO i1 = LBOUND(u_out%Vx,1),UBOUND(u_out%Vx,1)
      b = (t(3)**2*(u1%Vx(i1,i2) - u2%Vx(i1,i2)) + t(2)**2*(-u1%Vx(i1,i2) + u3%Vx(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%Vx(i1,i2) + t(3)*u2%Vx(i1,i2) - t(2)*u3%Vx(i1,i2) ) * scaleFactor
      u_out%Vx(i1,i2) = u1%Vx(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vy) .AND. ALLOCATED(u1%Vy)) THEN
  DO i2 = LBOUND(u_out%Vy,2),UBOUND(u_out%Vy,2)
    DO i1 = LBOUND(u_out%Vy,1),UBOUND(u_out%Vy,1)
      b = (t(3)**2*(u1%Vy(i1,i2) - u2%Vy(i1,i2)) + t(2)**2*(-u1%Vy(i1,i2) + u3%Vy(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%Vy(i1,i2) + t(3)*u2%Vy(i1,i2) - t(2)*u3%Vy(i1,i2) ) * scaleFactor
      u_out%Vy(i1,i2) = u1%Vy(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vx_elast_dot) .AND. ALLOCATED(u1%Vx_elast_dot)) THEN
  DO i2 = LBOUND(u_out%Vx_elast_dot,2),UBOUND(u_out%Vx_elast_dot,2)
    DO i1 = LBOUND(u_out%Vx_elast_dot,1),UBOUND(u_out%Vx_elast_dot,1)
      b = (t(3)**2*(u1%Vx_elast_dot(i1,i2) - u2%Vx_elast_dot(i1,i2)) + t(2)**2*(-u1%Vx_elast_dot(i1,i2) + u3%Vx_elast_dot(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%Vx_elast_dot(i1,i2) + t(3)*u2%Vx_elast_dot(i1,i2) - t(2)*u3%Vx_elast_dot(i1,i2) ) * scaleFactor
      u_out%Vx_elast_dot(i1,i2) = u1%Vx_elast_dot(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vy_elast_dot) .AND. ALLOCATED(u1%Vy_elast_dot)) THEN
  DO i2 = LBOUND(u_out%Vy_elast_dot,2),UBOUND(u_out%Vy_elast_dot,2)
    DO i1 = LBOUND(u_out%Vy_elast_dot,1),UBOUND(u_out%Vy_elast_dot,1)
      b = (t(3)**2*(u1%Vy_elast_dot(i1,i2) - u2%Vy_elast_dot(i1,i2)) + t(2)**2*(-u1%Vy_elast_dot(i1,i2) + u3%Vy_elast_dot(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%Vy_elast_dot(i1,i2) + t(3)*u2%Vy_elast_dot(i1,i2) - t(2)*u3%Vy_elast_dot(i1,i2) ) * scaleFactor
      u_out%Vy_elast_dot(i1,i2) = u1%Vy_elast_dot(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%omega_z) .AND. ALLOCATED(u1%omega_z)) THEN
  DO i2 = LBOUND(u_out%omega_z,2),UBOUND(u_out%omega_z,2)
    DO i1 = LBOUND(u_out%omega_z,1),UBOUND(u_out%omega_z,1)
      b = (t(3)**2*(u1%omega_z(i1,i2) - u2%omega_z(i1,i2)) + t(2)**2*(-u1%omega_z(i1,i2) + u3%omega_z(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%omega_z(i1,i2) + t(3)*u2%omega_z(i1,i2) - t(2)*u3%omega_z(i1,i2) ) * scaleFactor
      u_out%omega_z(i1,i2) = u1%omega_z(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%rLocal) .AND. ALLOCATED(u1%rLocal)) THEN
  DO i2 = LBOUND(u_out%rLocal,2),UBOUND(u_out%rLocal,2)
    DO i1 = LBOUND(u_out%rLocal,1),UBOUND(u_out%rLocal,1)
      b = (t(3)**2*(u1%rLocal(i1,i2) - u2%rLocal(i1,i2)) + t(2)**2*(-u1%rLocal(i1,i2) + u3%rLocal(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%rLocal(i1,i2) + t(3)*u2%rLocal(i1,i2) - t(2)*u3%rLocal(i1,i2) ) * scaleFactor
      u_out%rLocal(i1,i2) = u1%rLocal(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
  b = (t(3)**2*(u1%Un_disk - u2%Un_disk) + t(2)**2*(-u1%Un_disk + u3%Un_disk))* scaleFactor
  c = ( (t(2)-t(3))*u1%Un_disk + t(3)*u2%Un_disk - t(2)*u3%Un_disk ) * scaleFactor
  u_out%Un_disk = u1%Un_disk + b  + c * t_out
IF (ALLOCATED(u_out%UserProp) .AND. ALLOCATED(u1%UserProp)) THEN
  DO i2 = LBOUND(u_out%UserProp,2),UBOUND(u_out%UserProp,2)
    DO i1 = LBOUND(u_out%UserProp,1),UBOUND(u_out%UserProp,1)
      b = (t(3)**2*(u1%UserProp(i1,i2) - u2%UserProp(i1,i2)) + t(2)**2*(-u1%UserProp(i1,i2) + u3%UserProp(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%UserProp(i1,i2) + t(3)*u2%UserProp(i1,i2) - t(2)*u3%UserProp(i1,i2) ) * scaleFactor
      u_out%UserProp(i1,i2) = u1%UserProp(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE BEMT_Input_ExtrapInterp2


 SUBROUTINE BEMT_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(BEMT_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(BEMT_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'BEMT_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL BEMT_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL BEMT_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL BEMT_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE BEMT_Output_ExtrapInterp


 SUBROUTINE BEMT_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(BEMT_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(BEMT_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(BEMT_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'BEMT_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(y_out%Vrel) .AND. ALLOCATED(y1%Vrel)) THEN
  DO i2 = LBOUND(y_out%Vrel,2),UBOUND(y_out%Vrel,2)
    DO i1 = LBOUND(y_out%Vrel,1),UBOUND(y_out%Vrel,1)
      b = -(y1%Vrel(i1,i2) - y2%Vrel(i1,i2))
      y_out%Vrel(i1,i2) = y1%Vrel(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%phi) .AND. ALLOCATED(y1%phi)) THEN
  DO i2 = LBOUND(y_out%phi,2),UBOUND(y_out%phi,2)
    DO i1 = LBOUND(y_out%phi,1),UBOUND(y_out%phi,1)
      b = -(y1%phi(i1,i2) - y2%phi(i1,i2))
      y_out%phi(i1,i2) = y1%phi(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%axInduction) .AND. ALLOCATED(y1%axInduction)) THEN
  DO i2 = LBOUND(y_out%axInduction,2),UBOUND(y_out%axInduction,2)
    DO i1 = LBOUND(y_out%axInduction,1),UBOUND(y_out%axInduction,1)
      b = -(y1%axInduction(i1,i2) - y2%axInduction(i1,i2))
      y_out%axInduction(i1,i2) = y1%axInduction(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%tanInduction) .AND. ALLOCATED(y1%tanInduction)) THEN
  DO i2 = LBOUND(y_out%tanInduction,2),UBOUND(y_out%tanInduction,2)
    DO i1 = LBOUND(y_out%tanInduction,1),UBOUND(y_out%tanInduction,1)
      b = -(y1%tanInduction(i1,i2) - y2%tanInduction(i1,i2))
      y_out%tanInduction(i1,i2) = y1%tanInduction(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Re) .AND. ALLOCATED(y1%Re)) THEN
  DO i2 = LBOUND(y_out%Re,2),UBOUND(y_out%Re,2)
    DO i1 = LBOUND(y_out%Re,1),UBOUND(y_out%Re,1)
      b = -(y1%Re(i1,i2) - y2%Re(i1,i2))
      y_out%Re(i1,i2) = y1%Re(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%AOA) .AND. ALLOCATED(y1%AOA)) THEN
  DO i2 = LBOUND(y_out%AOA,2),UBOUND(y_out%AOA,2)
    DO i1 = LBOUND(y_out%AOA,1),UBOUND(y_out%AOA,1)
      b = -(y1%AOA(i1,i2) - y2%AOA(i1,i2))
      y_out%AOA(i1,i2) = y1%AOA(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cx) .AND. ALLOCATED(y1%Cx)) THEN
  DO i2 = LBOUND(y_out%Cx,2),UBOUND(y_out%Cx,2)
    DO i1 = LBOUND(y_out%Cx,1),UBOUND(y_out%Cx,1)
      b = -(y1%Cx(i1,i2) - y2%Cx(i1,i2))
      y_out%Cx(i1,i2) = y1%Cx(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cy) .AND. ALLOCATED(y1%Cy)) THEN
  DO i2 = LBOUND(y_out%Cy,2),UBOUND(y_out%Cy,2)
    DO i1 = LBOUND(y_out%Cy,1),UBOUND(y_out%Cy,1)
      b = -(y1%Cy(i1,i2) - y2%Cy(i1,i2))
      y_out%Cy(i1,i2) = y1%Cy(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cm) .AND. ALLOCATED(y1%Cm)) THEN
  DO i2 = LBOUND(y_out%Cm,2),UBOUND(y_out%Cm,2)
    DO i1 = LBOUND(y_out%Cm,1),UBOUND(y_out%Cm,1)
      b = -(y1%Cm(i1,i2) - y2%Cm(i1,i2))
      y_out%Cm(i1,i2) = y1%Cm(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cl) .AND. ALLOCATED(y1%Cl)) THEN
  DO i2 = LBOUND(y_out%Cl,2),UBOUND(y_out%Cl,2)
    DO i1 = LBOUND(y_out%Cl,1),UBOUND(y_out%Cl,1)
      b = -(y1%Cl(i1,i2) - y2%Cl(i1,i2))
      y_out%Cl(i1,i2) = y1%Cl(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cd) .AND. ALLOCATED(y1%Cd)) THEN
  DO i2 = LBOUND(y_out%Cd,2),UBOUND(y_out%Cd,2)
    DO i1 = LBOUND(y_out%Cd,1),UBOUND(y_out%Cd,1)
      b = -(y1%Cd(i1,i2) - y2%Cd(i1,i2))
      y_out%Cd(i1,i2) = y1%Cd(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%chi) .AND. ALLOCATED(y1%chi)) THEN
  DO i2 = LBOUND(y_out%chi,2),UBOUND(y_out%chi,2)
    DO i1 = LBOUND(y_out%chi,1),UBOUND(y_out%chi,1)
      b = -(y1%chi(i1,i2) - y2%chi(i1,i2))
      y_out%chi(i1,i2) = y1%chi(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cpmin) .AND. ALLOCATED(y1%Cpmin)) THEN
  DO i2 = LBOUND(y_out%Cpmin,2),UBOUND(y_out%Cpmin,2)
    DO i1 = LBOUND(y_out%Cpmin,1),UBOUND(y_out%Cpmin,1)
      b = -(y1%Cpmin(i1,i2) - y2%Cpmin(i1,i2))
      y_out%Cpmin(i1,i2) = y1%Cpmin(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE BEMT_Output_ExtrapInterp1


 SUBROUTINE BEMT_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(BEMT_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(BEMT_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(BEMT_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(BEMT_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'BEMT_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(y_out%Vrel) .AND. ALLOCATED(y1%Vrel)) THEN
  DO i2 = LBOUND(y_out%Vrel,2),UBOUND(y_out%Vrel,2)
    DO i1 = LBOUND(y_out%Vrel,1),UBOUND(y_out%Vrel,1)
      b = (t(3)**2*(y1%Vrel(i1,i2) - y2%Vrel(i1,i2)) + t(2)**2*(-y1%Vrel(i1,i2) + y3%Vrel(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Vrel(i1,i2) + t(3)*y2%Vrel(i1,i2) - t(2)*y3%Vrel(i1,i2) ) * scaleFactor
      y_out%Vrel(i1,i2) = y1%Vrel(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%phi) .AND. ALLOCATED(y1%phi)) THEN
  DO i2 = LBOUND(y_out%phi,2),UBOUND(y_out%phi,2)
    DO i1 = LBOUND(y_out%phi,1),UBOUND(y_out%phi,1)
      b = (t(3)**2*(y1%phi(i1,i2) - y2%phi(i1,i2)) + t(2)**2*(-y1%phi(i1,i2) + y3%phi(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%phi(i1,i2) + t(3)*y2%phi(i1,i2) - t(2)*y3%phi(i1,i2) ) * scaleFactor
      y_out%phi(i1,i2) = y1%phi(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%axInduction) .AND. ALLOCATED(y1%axInduction)) THEN
  DO i2 = LBOUND(y_out%axInduction,2),UBOUND(y_out%axInduction,2)
    DO i1 = LBOUND(y_out%axInduction,1),UBOUND(y_out%axInduction,1)
      b = (t(3)**2*(y1%axInduction(i1,i2) - y2%axInduction(i1,i2)) + t(2)**2*(-y1%axInduction(i1,i2) + y3%axInduction(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%axInduction(i1,i2) + t(3)*y2%axInduction(i1,i2) - t(2)*y3%axInduction(i1,i2) ) * scaleFactor
      y_out%axInduction(i1,i2) = y1%axInduction(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%tanInduction) .AND. ALLOCATED(y1%tanInduction)) THEN
  DO i2 = LBOUND(y_out%tanInduction,2),UBOUND(y_out%tanInduction,2)
    DO i1 = LBOUND(y_out%tanInduction,1),UBOUND(y_out%tanInduction,1)
      b = (t(3)**2*(y1%tanInduction(i1,i2) - y2%tanInduction(i1,i2)) + t(2)**2*(-y1%tanInduction(i1,i2) + y3%tanInduction(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%tanInduction(i1,i2) + t(3)*y2%tanInduction(i1,i2) - t(2)*y3%tanInduction(i1,i2) ) * scaleFactor
      y_out%tanInduction(i1,i2) = y1%tanInduction(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Re) .AND. ALLOCATED(y1%Re)) THEN
  DO i2 = LBOUND(y_out%Re,2),UBOUND(y_out%Re,2)
    DO i1 = LBOUND(y_out%Re,1),UBOUND(y_out%Re,1)
      b = (t(3)**2*(y1%Re(i1,i2) - y2%Re(i1,i2)) + t(2)**2*(-y1%Re(i1,i2) + y3%Re(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Re(i1,i2) + t(3)*y2%Re(i1,i2) - t(2)*y3%Re(i1,i2) ) * scaleFactor
      y_out%Re(i1,i2) = y1%Re(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%AOA) .AND. ALLOCATED(y1%AOA)) THEN
  DO i2 = LBOUND(y_out%AOA,2),UBOUND(y_out%AOA,2)
    DO i1 = LBOUND(y_out%AOA,1),UBOUND(y_out%AOA,1)
      b = (t(3)**2*(y1%AOA(i1,i2) - y2%AOA(i1,i2)) + t(2)**2*(-y1%AOA(i1,i2) + y3%AOA(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%AOA(i1,i2) + t(3)*y2%AOA(i1,i2) - t(2)*y3%AOA(i1,i2) ) * scaleFactor
      y_out%AOA(i1,i2) = y1%AOA(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cx) .AND. ALLOCATED(y1%Cx)) THEN
  DO i2 = LBOUND(y_out%Cx,2),UBOUND(y_out%Cx,2)
    DO i1 = LBOUND(y_out%Cx,1),UBOUND(y_out%Cx,1)
      b = (t(3)**2*(y1%Cx(i1,i2) - y2%Cx(i1,i2)) + t(2)**2*(-y1%Cx(i1,i2) + y3%Cx(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cx(i1,i2) + t(3)*y2%Cx(i1,i2) - t(2)*y3%Cx(i1,i2) ) * scaleFactor
      y_out%Cx(i1,i2) = y1%Cx(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cy) .AND. ALLOCATED(y1%Cy)) THEN
  DO i2 = LBOUND(y_out%Cy,2),UBOUND(y_out%Cy,2)
    DO i1 = LBOUND(y_out%Cy,1),UBOUND(y_out%Cy,1)
      b = (t(3)**2*(y1%Cy(i1,i2) - y2%Cy(i1,i2)) + t(2)**2*(-y1%Cy(i1,i2) + y3%Cy(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cy(i1,i2) + t(3)*y2%Cy(i1,i2) - t(2)*y3%Cy(i1,i2) ) * scaleFactor
      y_out%Cy(i1,i2) = y1%Cy(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cm) .AND. ALLOCATED(y1%Cm)) THEN
  DO i2 = LBOUND(y_out%Cm,2),UBOUND(y_out%Cm,2)
    DO i1 = LBOUND(y_out%Cm,1),UBOUND(y_out%Cm,1)
      b = (t(3)**2*(y1%Cm(i1,i2) - y2%Cm(i1,i2)) + t(2)**2*(-y1%Cm(i1,i2) + y3%Cm(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cm(i1,i2) + t(3)*y2%Cm(i1,i2) - t(2)*y3%Cm(i1,i2) ) * scaleFactor
      y_out%Cm(i1,i2) = y1%Cm(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cl) .AND. ALLOCATED(y1%Cl)) THEN
  DO i2 = LBOUND(y_out%Cl,2),UBOUND(y_out%Cl,2)
    DO i1 = LBOUND(y_out%Cl,1),UBOUND(y_out%Cl,1)
      b = (t(3)**2*(y1%Cl(i1,i2) - y2%Cl(i1,i2)) + t(2)**2*(-y1%Cl(i1,i2) + y3%Cl(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cl(i1,i2) + t(3)*y2%Cl(i1,i2) - t(2)*y3%Cl(i1,i2) ) * scaleFactor
      y_out%Cl(i1,i2) = y1%Cl(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cd) .AND. ALLOCATED(y1%Cd)) THEN
  DO i2 = LBOUND(y_out%Cd,2),UBOUND(y_out%Cd,2)
    DO i1 = LBOUND(y_out%Cd,1),UBOUND(y_out%Cd,1)
      b = (t(3)**2*(y1%Cd(i1,i2) - y2%Cd(i1,i2)) + t(2)**2*(-y1%Cd(i1,i2) + y3%Cd(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cd(i1,i2) + t(3)*y2%Cd(i1,i2) - t(2)*y3%Cd(i1,i2) ) * scaleFactor
      y_out%Cd(i1,i2) = y1%Cd(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%chi) .AND. ALLOCATED(y1%chi)) THEN
  DO i2 = LBOUND(y_out%chi,2),UBOUND(y_out%chi,2)
    DO i1 = LBOUND(y_out%chi,1),UBOUND(y_out%chi,1)
      b = (t(3)**2*(y1%chi(i1,i2) - y2%chi(i1,i2)) + t(2)**2*(-y1%chi(i1,i2) + y3%chi(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%chi(i1,i2) + t(3)*y2%chi(i1,i2) - t(2)*y3%chi(i1,i2) ) * scaleFactor
      y_out%chi(i1,i2) = y1%chi(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%Cpmin) .AND. ALLOCATED(y1%Cpmin)) THEN
  DO i2 = LBOUND(y_out%Cpmin,2),UBOUND(y_out%Cpmin,2)
    DO i1 = LBOUND(y_out%Cpmin,1),UBOUND(y_out%Cpmin,1)
      b = (t(3)**2*(y1%Cpmin(i1,i2) - y2%Cpmin(i1,i2)) + t(2)**2*(-y1%Cpmin(i1,i2) + y3%Cpmin(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%Cpmin(i1,i2) + t(3)*y2%Cpmin(i1,i2) - t(2)*y3%Cpmin(i1,i2) ) * scaleFactor
      y_out%Cpmin(i1,i2) = y1%Cpmin(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE BEMT_Output_ExtrapInterp2

END MODULE BEMT_Types
!ENDOFREGISTRYGENERATEDFILE
