!**********************************************************************************************************************************
! LICENSING
! Copyright (C) 2015-2016  National Renewable Energy Laboratory
! Copyright (C) 2016-2017  Envision Energy USA, LTD
!
!    This file is part of AeroDyn.
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!**********************************************************************************************************************************
MODULE AeroDyn_IO
 
   use NWTC_Library
   use AeroDyn_Types
   use BEMTUncoupled, only : SkewMod_Orthogonal, SkewMod_Uncoupled, SkewMod_PittPeters, VelocityIsZero
   use FVW_Subs,      only : FVW_AeroOuts

   USE AeroDyn_AllBldNdOuts_IO
   
   implicit none

   type(ProgDesc), parameter  :: AD_Ver = ProgDesc( 'AeroDyn', '', '' )
   character(*),   parameter  :: AD_Nickname = 'AD'
      

! ===================================================================================================
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary.
! ===================================================================================================
! This code was generated by Write_ChckOutLst.m at 01-Mar-2022 11:16:33.


     ! Parameters related to output length (number of characters allowed in the output data headers):

   INTEGER(IntKi), PARAMETER      :: OutStrLenM1 = ChanLen - 1


     ! Indices for computing output channels:
     ! NOTES:
     !    (1) These parameters are in the order stored in "OutListParameters.xlsx"
     !    (2) Array AllOuts() must be dimensioned to the value of the largest output parameter

     !  Time:

   INTEGER(IntKi), PARAMETER      :: Time      =    0


     ! Tower:

   INTEGER(IntKi), PARAMETER      :: TwN1VUndx =    1
   INTEGER(IntKi), PARAMETER      :: TwN1VUndy =    2
   INTEGER(IntKi), PARAMETER      :: TwN1VUndz =    3
   INTEGER(IntKi), PARAMETER      :: TwN2VUndx =    4
   INTEGER(IntKi), PARAMETER      :: TwN2VUndy =    5
   INTEGER(IntKi), PARAMETER      :: TwN2VUndz =    6
   INTEGER(IntKi), PARAMETER      :: TwN3VUndx =    7
   INTEGER(IntKi), PARAMETER      :: TwN3VUndy =    8
   INTEGER(IntKi), PARAMETER      :: TwN3VUndz =    9
   INTEGER(IntKi), PARAMETER      :: TwN4VUndx =   10
   INTEGER(IntKi), PARAMETER      :: TwN4VUndy =   11
   INTEGER(IntKi), PARAMETER      :: TwN4VUndz =   12
   INTEGER(IntKi), PARAMETER      :: TwN5VUndx =   13
   INTEGER(IntKi), PARAMETER      :: TwN5VUndy =   14
   INTEGER(IntKi), PARAMETER      :: TwN5VUndz =   15
   INTEGER(IntKi), PARAMETER      :: TwN6VUndx =   16
   INTEGER(IntKi), PARAMETER      :: TwN6VUndy =   17
   INTEGER(IntKi), PARAMETER      :: TwN6VUndz =   18
   INTEGER(IntKi), PARAMETER      :: TwN7VUndx =   19
   INTEGER(IntKi), PARAMETER      :: TwN7VUndy =   20
   INTEGER(IntKi), PARAMETER      :: TwN7VUndz =   21
   INTEGER(IntKi), PARAMETER      :: TwN8VUndx =   22
   INTEGER(IntKi), PARAMETER      :: TwN8VUndy =   23
   INTEGER(IntKi), PARAMETER      :: TwN8VUndz =   24
   INTEGER(IntKi), PARAMETER      :: TwN9VUndx =   25
   INTEGER(IntKi), PARAMETER      :: TwN9VUndy =   26
   INTEGER(IntKi), PARAMETER      :: TwN9VUndz =   27
   INTEGER(IntKi), PARAMETER      :: TwN1STVx  =   28
   INTEGER(IntKi), PARAMETER      :: TwN1STVy  =   29
   INTEGER(IntKi), PARAMETER      :: TwN1STVz  =   30
   INTEGER(IntKi), PARAMETER      :: TwN2STVx  =   31
   INTEGER(IntKi), PARAMETER      :: TwN2STVy  =   32
   INTEGER(IntKi), PARAMETER      :: TwN2STVz  =   33
   INTEGER(IntKi), PARAMETER      :: TwN3STVx  =   34
   INTEGER(IntKi), PARAMETER      :: TwN3STVy  =   35
   INTEGER(IntKi), PARAMETER      :: TwN3STVz  =   36
   INTEGER(IntKi), PARAMETER      :: TwN4STVx  =   37
   INTEGER(IntKi), PARAMETER      :: TwN4STVy  =   38
   INTEGER(IntKi), PARAMETER      :: TwN4STVz  =   39
   INTEGER(IntKi), PARAMETER      :: TwN5STVx  =   40
   INTEGER(IntKi), PARAMETER      :: TwN5STVy  =   41
   INTEGER(IntKi), PARAMETER      :: TwN5STVz  =   42
   INTEGER(IntKi), PARAMETER      :: TwN6STVx  =   43
   INTEGER(IntKi), PARAMETER      :: TwN6STVy  =   44
   INTEGER(IntKi), PARAMETER      :: TwN6STVz  =   45
   INTEGER(IntKi), PARAMETER      :: TwN7STVx  =   46
   INTEGER(IntKi), PARAMETER      :: TwN7STVy  =   47
   INTEGER(IntKi), PARAMETER      :: TwN7STVz  =   48
   INTEGER(IntKi), PARAMETER      :: TwN8STVx  =   49
   INTEGER(IntKi), PARAMETER      :: TwN8STVy  =   50
   INTEGER(IntKi), PARAMETER      :: TwN8STVz  =   51
   INTEGER(IntKi), PARAMETER      :: TwN9STVx  =   52
   INTEGER(IntKi), PARAMETER      :: TwN9STVy  =   53
   INTEGER(IntKi), PARAMETER      :: TwN9STVz  =   54
   INTEGER(IntKi), PARAMETER      :: TwN1Vrel  =   55
   INTEGER(IntKi), PARAMETER      :: TwN2Vrel  =   56
   INTEGER(IntKi), PARAMETER      :: TwN3Vrel  =   57
   INTEGER(IntKi), PARAMETER      :: TwN4Vrel  =   58
   INTEGER(IntKi), PARAMETER      :: TwN5Vrel  =   59
   INTEGER(IntKi), PARAMETER      :: TwN6Vrel  =   60
   INTEGER(IntKi), PARAMETER      :: TwN7Vrel  =   61
   INTEGER(IntKi), PARAMETER      :: TwN8Vrel  =   62
   INTEGER(IntKi), PARAMETER      :: TwN9Vrel  =   63
   INTEGER(IntKi), PARAMETER      :: TwN1DynP  =   64
   INTEGER(IntKi), PARAMETER      :: TwN2DynP  =   65
   INTEGER(IntKi), PARAMETER      :: TwN3DynP  =   66
   INTEGER(IntKi), PARAMETER      :: TwN4DynP  =   67
   INTEGER(IntKi), PARAMETER      :: TwN5DynP  =   68
   INTEGER(IntKi), PARAMETER      :: TwN6DynP  =   69
   INTEGER(IntKi), PARAMETER      :: TwN7DynP  =   70
   INTEGER(IntKi), PARAMETER      :: TwN8DynP  =   71
   INTEGER(IntKi), PARAMETER      :: TwN9DynP  =   72
   INTEGER(IntKi), PARAMETER      :: TwN1Re    =   73
   INTEGER(IntKi), PARAMETER      :: TwN2Re    =   74
   INTEGER(IntKi), PARAMETER      :: TwN3Re    =   75
   INTEGER(IntKi), PARAMETER      :: TwN4Re    =   76
   INTEGER(IntKi), PARAMETER      :: TwN5Re    =   77
   INTEGER(IntKi), PARAMETER      :: TwN6Re    =   78
   INTEGER(IntKi), PARAMETER      :: TwN7Re    =   79
   INTEGER(IntKi), PARAMETER      :: TwN8Re    =   80
   INTEGER(IntKi), PARAMETER      :: TwN9Re    =   81
   INTEGER(IntKi), PARAMETER      :: TwN1M     =   82
   INTEGER(IntKi), PARAMETER      :: TwN2M     =   83
   INTEGER(IntKi), PARAMETER      :: TwN3M     =   84
   INTEGER(IntKi), PARAMETER      :: TwN4M     =   85
   INTEGER(IntKi), PARAMETER      :: TwN5M     =   86
   INTEGER(IntKi), PARAMETER      :: TwN6M     =   87
   INTEGER(IntKi), PARAMETER      :: TwN7M     =   88
   INTEGER(IntKi), PARAMETER      :: TwN8M     =   89
   INTEGER(IntKi), PARAMETER      :: TwN9M     =   90
   INTEGER(IntKi), PARAMETER      :: TwN1Fdx   =   91
   INTEGER(IntKi), PARAMETER      :: TwN2Fdx   =   92
   INTEGER(IntKi), PARAMETER      :: TwN3Fdx   =   93
   INTEGER(IntKi), PARAMETER      :: TwN4Fdx   =   94
   INTEGER(IntKi), PARAMETER      :: TwN5Fdx   =   95
   INTEGER(IntKi), PARAMETER      :: TwN6Fdx   =   96
   INTEGER(IntKi), PARAMETER      :: TwN7Fdx   =   97
   INTEGER(IntKi), PARAMETER      :: TwN8Fdx   =   98
   INTEGER(IntKi), PARAMETER      :: TwN9Fdx   =   99
   INTEGER(IntKi), PARAMETER      :: TwN1Fdy   =  100
   INTEGER(IntKi), PARAMETER      :: TwN2Fdy   =  101
   INTEGER(IntKi), PARAMETER      :: TwN3Fdy   =  102
   INTEGER(IntKi), PARAMETER      :: TwN4Fdy   =  103
   INTEGER(IntKi), PARAMETER      :: TwN5Fdy   =  104
   INTEGER(IntKi), PARAMETER      :: TwN6Fdy   =  105
   INTEGER(IntKi), PARAMETER      :: TwN7Fdy   =  106
   INTEGER(IntKi), PARAMETER      :: TwN8Fdy   =  107
   INTEGER(IntKi), PARAMETER      :: TwN9Fdy   =  108


     ! Blade:

   INTEGER(IntKi), PARAMETER      :: B1Azimuth =  109
   INTEGER(IntKi), PARAMETER      :: B2Azimuth =  110
   INTEGER(IntKi), PARAMETER      :: B3Azimuth =  111
   INTEGER(IntKi), PARAMETER      :: B1Pitch   =  112
   INTEGER(IntKi), PARAMETER      :: B2Pitch   =  113
   INTEGER(IntKi), PARAMETER      :: B3Pitch   =  114
   INTEGER(IntKi), PARAMETER      :: B1AeroFx  =  115
   INTEGER(IntKi), PARAMETER      :: B1AeroFy  =  116
   INTEGER(IntKi), PARAMETER      :: B1AeroFz  =  117
   INTEGER(IntKi), PARAMETER      :: B1AeroMx  =  118
   INTEGER(IntKi), PARAMETER      :: B1AeroMy  =  119
   INTEGER(IntKi), PARAMETER      :: B1AeroMz  =  120
   INTEGER(IntKi), PARAMETER      :: B1AeroPwr =  121
   INTEGER(IntKi), PARAMETER      :: B2AeroFx  =  122
   INTEGER(IntKi), PARAMETER      :: B2AeroFy  =  123
   INTEGER(IntKi), PARAMETER      :: B2AeroFz  =  124
   INTEGER(IntKi), PARAMETER      :: B2AeroMx  =  125
   INTEGER(IntKi), PARAMETER      :: B2AeroMy  =  126
   INTEGER(IntKi), PARAMETER      :: B2AeroMz  =  127
   INTEGER(IntKi), PARAMETER      :: B2AeroPwr =  128
   INTEGER(IntKi), PARAMETER      :: B3AeroFx  =  129
   INTEGER(IntKi), PARAMETER      :: B3AeroFy  =  130
   INTEGER(IntKi), PARAMETER      :: B3AeroFz  =  131
   INTEGER(IntKi), PARAMETER      :: B3AeroMx  =  132
   INTEGER(IntKi), PARAMETER      :: B3AeroMy  =  133
   INTEGER(IntKi), PARAMETER      :: B3AeroMz  =  134
   INTEGER(IntKi), PARAMETER      :: B3AeroPwr =  135
   INTEGER(IntKi), PARAMETER      :: B4AeroFx  =  136
   INTEGER(IntKi), PARAMETER      :: B4AeroFy  =  137
   INTEGER(IntKi), PARAMETER      :: B4AeroFz  =  138
   INTEGER(IntKi), PARAMETER      :: B4AeroMx  =  139
   INTEGER(IntKi), PARAMETER      :: B4AeroMy  =  140
   INTEGER(IntKi), PARAMETER      :: B4AeroMz  =  141
   INTEGER(IntKi), PARAMETER      :: B4AeroPwr =  142
   INTEGER(IntKi), PARAMETER      :: B1AeroFxg =  143
   INTEGER(IntKi), PARAMETER      :: B1AeroFyg =  144
   INTEGER(IntKi), PARAMETER      :: B1AeroFzg =  145
   INTEGER(IntKi), PARAMETER      :: B1AeroMxg =  146
   INTEGER(IntKi), PARAMETER      :: B1AeroMyg =  147
   INTEGER(IntKi), PARAMETER      :: B1AeroMzg =  148
   INTEGER(IntKi), PARAMETER      :: B2AeroFxg =  149
   INTEGER(IntKi), PARAMETER      :: B2AeroFyg =  150
   INTEGER(IntKi), PARAMETER      :: B2AeroFzg =  151
   INTEGER(IntKi), PARAMETER      :: B2AeroMxg =  152
   INTEGER(IntKi), PARAMETER      :: B2AeroMyg =  153
   INTEGER(IntKi), PARAMETER      :: B2AeroMzg =  154
   INTEGER(IntKi), PARAMETER      :: B3AeroFxg =  155
   INTEGER(IntKi), PARAMETER      :: B3AeroFyg =  156
   INTEGER(IntKi), PARAMETER      :: B3AeroFzg =  157
   INTEGER(IntKi), PARAMETER      :: B3AeroMxg =  158
   INTEGER(IntKi), PARAMETER      :: B3AeroMyg =  159
   INTEGER(IntKi), PARAMETER      :: B3AeroMzg =  160
   INTEGER(IntKi), PARAMETER      :: B4AeroFxg =  161
   INTEGER(IntKi), PARAMETER      :: B4AeroFyg =  162
   INTEGER(IntKi), PARAMETER      :: B4AeroFzg =  163
   INTEGER(IntKi), PARAMETER      :: B4AeroMxg =  164
   INTEGER(IntKi), PARAMETER      :: B4AeroMyg =  165
   INTEGER(IntKi), PARAMETER      :: B4AeroMzg =  166


     ! Blade Nodal outputs:

   INTEGER(IntKi), PARAMETER      :: B1N1VUndx =  167
   INTEGER(IntKi), PARAMETER      :: B1N2VUndx =  168
   INTEGER(IntKi), PARAMETER      :: B1N3VUndx =  169
   INTEGER(IntKi), PARAMETER      :: B1N4VUndx =  170
   INTEGER(IntKi), PARAMETER      :: B1N5VUndx =  171
   INTEGER(IntKi), PARAMETER      :: B1N6VUndx =  172
   INTEGER(IntKi), PARAMETER      :: B1N7VUndx =  173
   INTEGER(IntKi), PARAMETER      :: B1N8VUndx =  174
   INTEGER(IntKi), PARAMETER      :: B1N9VUndx =  175
   INTEGER(IntKi), PARAMETER      :: B1N1VUndy =  176
   INTEGER(IntKi), PARAMETER      :: B1N2VUndy =  177
   INTEGER(IntKi), PARAMETER      :: B1N3VUndy =  178
   INTEGER(IntKi), PARAMETER      :: B1N4VUndy =  179
   INTEGER(IntKi), PARAMETER      :: B1N5VUndy =  180
   INTEGER(IntKi), PARAMETER      :: B1N6VUndy =  181
   INTEGER(IntKi), PARAMETER      :: B1N7VUndy =  182
   INTEGER(IntKi), PARAMETER      :: B1N8VUndy =  183
   INTEGER(IntKi), PARAMETER      :: B1N9VUndy =  184
   INTEGER(IntKi), PARAMETER      :: B1N1VUndz =  185
   INTEGER(IntKi), PARAMETER      :: B1N2VUndz =  186
   INTEGER(IntKi), PARAMETER      :: B1N3VUndz =  187
   INTEGER(IntKi), PARAMETER      :: B1N4VUndz =  188
   INTEGER(IntKi), PARAMETER      :: B1N5VUndz =  189
   INTEGER(IntKi), PARAMETER      :: B1N6VUndz =  190
   INTEGER(IntKi), PARAMETER      :: B1N7VUndz =  191
   INTEGER(IntKi), PARAMETER      :: B1N8VUndz =  192
   INTEGER(IntKi), PARAMETER      :: B1N9VUndz =  193
   INTEGER(IntKi), PARAMETER      :: B2N1VUndx =  194
   INTEGER(IntKi), PARAMETER      :: B2N2VUndx =  195
   INTEGER(IntKi), PARAMETER      :: B2N3VUndx =  196
   INTEGER(IntKi), PARAMETER      :: B2N4VUndx =  197
   INTEGER(IntKi), PARAMETER      :: B2N5VUndx =  198
   INTEGER(IntKi), PARAMETER      :: B2N6VUndx =  199
   INTEGER(IntKi), PARAMETER      :: B2N7VUndx =  200
   INTEGER(IntKi), PARAMETER      :: B2N8VUndx =  201
   INTEGER(IntKi), PARAMETER      :: B2N9VUndx =  202
   INTEGER(IntKi), PARAMETER      :: B2N1VUndy =  203
   INTEGER(IntKi), PARAMETER      :: B2N2VUndy =  204
   INTEGER(IntKi), PARAMETER      :: B2N3VUndy =  205
   INTEGER(IntKi), PARAMETER      :: B2N4VUndy =  206
   INTEGER(IntKi), PARAMETER      :: B2N5VUndy =  207
   INTEGER(IntKi), PARAMETER      :: B2N6VUndy =  208
   INTEGER(IntKi), PARAMETER      :: B2N7VUndy =  209
   INTEGER(IntKi), PARAMETER      :: B2N8VUndy =  210
   INTEGER(IntKi), PARAMETER      :: B2N9VUndy =  211
   INTEGER(IntKi), PARAMETER      :: B2N1VUndz =  212
   INTEGER(IntKi), PARAMETER      :: B2N2VUndz =  213
   INTEGER(IntKi), PARAMETER      :: B2N3VUndz =  214
   INTEGER(IntKi), PARAMETER      :: B2N4VUndz =  215
   INTEGER(IntKi), PARAMETER      :: B2N5VUndz =  216
   INTEGER(IntKi), PARAMETER      :: B2N6VUndz =  217
   INTEGER(IntKi), PARAMETER      :: B2N7VUndz =  218
   INTEGER(IntKi), PARAMETER      :: B2N8VUndz =  219
   INTEGER(IntKi), PARAMETER      :: B2N9VUndz =  220
   INTEGER(IntKi), PARAMETER      :: B3N1VUndx =  221
   INTEGER(IntKi), PARAMETER      :: B3N2VUndx =  222
   INTEGER(IntKi), PARAMETER      :: B3N3VUndx =  223
   INTEGER(IntKi), PARAMETER      :: B3N4VUndx =  224
   INTEGER(IntKi), PARAMETER      :: B3N5VUndx =  225
   INTEGER(IntKi), PARAMETER      :: B3N6VUndx =  226
   INTEGER(IntKi), PARAMETER      :: B3N7VUndx =  227
   INTEGER(IntKi), PARAMETER      :: B3N8VUndx =  228
   INTEGER(IntKi), PARAMETER      :: B3N9VUndx =  229
   INTEGER(IntKi), PARAMETER      :: B3N1VUndy =  230
   INTEGER(IntKi), PARAMETER      :: B3N2VUndy =  231
   INTEGER(IntKi), PARAMETER      :: B3N3VUndy =  232
   INTEGER(IntKi), PARAMETER      :: B3N4VUndy =  233
   INTEGER(IntKi), PARAMETER      :: B3N5VUndy =  234
   INTEGER(IntKi), PARAMETER      :: B3N6VUndy =  235
   INTEGER(IntKi), PARAMETER      :: B3N7VUndy =  236
   INTEGER(IntKi), PARAMETER      :: B3N8VUndy =  237
   INTEGER(IntKi), PARAMETER      :: B3N9VUndy =  238
   INTEGER(IntKi), PARAMETER      :: B3N1VUndz =  239
   INTEGER(IntKi), PARAMETER      :: B3N2VUndz =  240
   INTEGER(IntKi), PARAMETER      :: B3N3VUndz =  241
   INTEGER(IntKi), PARAMETER      :: B3N4VUndz =  242
   INTEGER(IntKi), PARAMETER      :: B3N5VUndz =  243
   INTEGER(IntKi), PARAMETER      :: B3N6VUndz =  244
   INTEGER(IntKi), PARAMETER      :: B3N7VUndz =  245
   INTEGER(IntKi), PARAMETER      :: B3N8VUndz =  246
   INTEGER(IntKi), PARAMETER      :: B3N9VUndz =  247
   INTEGER(IntKi), PARAMETER      :: B1N1VDisx =  248
   INTEGER(IntKi), PARAMETER      :: B1N2VDisx =  249
   INTEGER(IntKi), PARAMETER      :: B1N3VDisx =  250
   INTEGER(IntKi), PARAMETER      :: B1N4VDisx =  251
   INTEGER(IntKi), PARAMETER      :: B1N5VDisx =  252
   INTEGER(IntKi), PARAMETER      :: B1N6VDisx =  253
   INTEGER(IntKi), PARAMETER      :: B1N7VDisx =  254
   INTEGER(IntKi), PARAMETER      :: B1N8VDisx =  255
   INTEGER(IntKi), PARAMETER      :: B1N9VDisx =  256
   INTEGER(IntKi), PARAMETER      :: B1N1VDisy =  257
   INTEGER(IntKi), PARAMETER      :: B1N2VDisy =  258
   INTEGER(IntKi), PARAMETER      :: B1N3VDisy =  259
   INTEGER(IntKi), PARAMETER      :: B1N4VDisy =  260
   INTEGER(IntKi), PARAMETER      :: B1N5VDisy =  261
   INTEGER(IntKi), PARAMETER      :: B1N6VDisy =  262
   INTEGER(IntKi), PARAMETER      :: B1N7VDisy =  263
   INTEGER(IntKi), PARAMETER      :: B1N8VDisy =  264
   INTEGER(IntKi), PARAMETER      :: B1N9VDisy =  265
   INTEGER(IntKi), PARAMETER      :: B1N1VDisz =  266
   INTEGER(IntKi), PARAMETER      :: B1N2VDisz =  267
   INTEGER(IntKi), PARAMETER      :: B1N3VDisz =  268
   INTEGER(IntKi), PARAMETER      :: B1N4VDisz =  269
   INTEGER(IntKi), PARAMETER      :: B1N5VDisz =  270
   INTEGER(IntKi), PARAMETER      :: B1N6VDisz =  271
   INTEGER(IntKi), PARAMETER      :: B1N7VDisz =  272
   INTEGER(IntKi), PARAMETER      :: B1N8VDisz =  273
   INTEGER(IntKi), PARAMETER      :: B1N9VDisz =  274
   INTEGER(IntKi), PARAMETER      :: B2N1VDisx =  275
   INTEGER(IntKi), PARAMETER      :: B2N2VDisx =  276
   INTEGER(IntKi), PARAMETER      :: B2N3VDisx =  277
   INTEGER(IntKi), PARAMETER      :: B2N4VDisx =  278
   INTEGER(IntKi), PARAMETER      :: B2N5VDisx =  279
   INTEGER(IntKi), PARAMETER      :: B2N6VDisx =  280
   INTEGER(IntKi), PARAMETER      :: B2N7VDisx =  281
   INTEGER(IntKi), PARAMETER      :: B2N8VDisx =  282
   INTEGER(IntKi), PARAMETER      :: B2N9VDisx =  283
   INTEGER(IntKi), PARAMETER      :: B2N1VDisy =  284
   INTEGER(IntKi), PARAMETER      :: B2N2VDisy =  285
   INTEGER(IntKi), PARAMETER      :: B2N3VDisy =  286
   INTEGER(IntKi), PARAMETER      :: B2N4VDisy =  287
   INTEGER(IntKi), PARAMETER      :: B2N5VDisy =  288
   INTEGER(IntKi), PARAMETER      :: B2N6VDisy =  289
   INTEGER(IntKi), PARAMETER      :: B2N7VDisy =  290
   INTEGER(IntKi), PARAMETER      :: B2N8VDisy =  291
   INTEGER(IntKi), PARAMETER      :: B2N9VDisy =  292
   INTEGER(IntKi), PARAMETER      :: B2N1VDisz =  293
   INTEGER(IntKi), PARAMETER      :: B2N2VDisz =  294
   INTEGER(IntKi), PARAMETER      :: B2N3VDisz =  295
   INTEGER(IntKi), PARAMETER      :: B2N4VDisz =  296
   INTEGER(IntKi), PARAMETER      :: B2N5VDisz =  297
   INTEGER(IntKi), PARAMETER      :: B2N6VDisz =  298
   INTEGER(IntKi), PARAMETER      :: B2N7VDisz =  299
   INTEGER(IntKi), PARAMETER      :: B2N8VDisz =  300
   INTEGER(IntKi), PARAMETER      :: B2N9VDisz =  301
   INTEGER(IntKi), PARAMETER      :: B3N1VDisx =  302
   INTEGER(IntKi), PARAMETER      :: B3N2VDisx =  303
   INTEGER(IntKi), PARAMETER      :: B3N3VDisx =  304
   INTEGER(IntKi), PARAMETER      :: B3N4VDisx =  305
   INTEGER(IntKi), PARAMETER      :: B3N5VDisx =  306
   INTEGER(IntKi), PARAMETER      :: B3N6VDisx =  307
   INTEGER(IntKi), PARAMETER      :: B3N7VDisx =  308
   INTEGER(IntKi), PARAMETER      :: B3N8VDisx =  309
   INTEGER(IntKi), PARAMETER      :: B3N9VDisx =  310
   INTEGER(IntKi), PARAMETER      :: B3N1VDisy =  311
   INTEGER(IntKi), PARAMETER      :: B3N2VDisy =  312
   INTEGER(IntKi), PARAMETER      :: B3N3VDisy =  313
   INTEGER(IntKi), PARAMETER      :: B3N4VDisy =  314
   INTEGER(IntKi), PARAMETER      :: B3N5VDisy =  315
   INTEGER(IntKi), PARAMETER      :: B3N6VDisy =  316
   INTEGER(IntKi), PARAMETER      :: B3N7VDisy =  317
   INTEGER(IntKi), PARAMETER      :: B3N8VDisy =  318
   INTEGER(IntKi), PARAMETER      :: B3N9VDisy =  319
   INTEGER(IntKi), PARAMETER      :: B3N1VDisz =  320
   INTEGER(IntKi), PARAMETER      :: B3N2VDisz =  321
   INTEGER(IntKi), PARAMETER      :: B3N3VDisz =  322
   INTEGER(IntKi), PARAMETER      :: B3N4VDisz =  323
   INTEGER(IntKi), PARAMETER      :: B3N5VDisz =  324
   INTEGER(IntKi), PARAMETER      :: B3N6VDisz =  325
   INTEGER(IntKi), PARAMETER      :: B3N7VDisz =  326
   INTEGER(IntKi), PARAMETER      :: B3N8VDisz =  327
   INTEGER(IntKi), PARAMETER      :: B3N9VDisz =  328
   INTEGER(IntKi), PARAMETER      :: B1N1STVx  =  329
   INTEGER(IntKi), PARAMETER      :: B1N2STVx  =  330
   INTEGER(IntKi), PARAMETER      :: B1N3STVx  =  331
   INTEGER(IntKi), PARAMETER      :: B1N4STVx  =  332
   INTEGER(IntKi), PARAMETER      :: B1N5STVx  =  333
   INTEGER(IntKi), PARAMETER      :: B1N6STVx  =  334
   INTEGER(IntKi), PARAMETER      :: B1N7STVx  =  335
   INTEGER(IntKi), PARAMETER      :: B1N8STVx  =  336
   INTEGER(IntKi), PARAMETER      :: B1N9STVx  =  337
   INTEGER(IntKi), PARAMETER      :: B1N1STVy  =  338
   INTEGER(IntKi), PARAMETER      :: B1N2STVy  =  339
   INTEGER(IntKi), PARAMETER      :: B1N3STVy  =  340
   INTEGER(IntKi), PARAMETER      :: B1N4STVy  =  341
   INTEGER(IntKi), PARAMETER      :: B1N5STVy  =  342
   INTEGER(IntKi), PARAMETER      :: B1N6STVy  =  343
   INTEGER(IntKi), PARAMETER      :: B1N7STVy  =  344
   INTEGER(IntKi), PARAMETER      :: B1N8STVy  =  345
   INTEGER(IntKi), PARAMETER      :: B1N9STVy  =  346
   INTEGER(IntKi), PARAMETER      :: B1N1STVz  =  347
   INTEGER(IntKi), PARAMETER      :: B1N2STVz  =  348
   INTEGER(IntKi), PARAMETER      :: B1N3STVz  =  349
   INTEGER(IntKi), PARAMETER      :: B1N4STVz  =  350
   INTEGER(IntKi), PARAMETER      :: B1N5STVz  =  351
   INTEGER(IntKi), PARAMETER      :: B1N6STVz  =  352
   INTEGER(IntKi), PARAMETER      :: B1N7STVz  =  353
   INTEGER(IntKi), PARAMETER      :: B1N8STVz  =  354
   INTEGER(IntKi), PARAMETER      :: B1N9STVz  =  355
   INTEGER(IntKi), PARAMETER      :: B2N1STVx  =  356
   INTEGER(IntKi), PARAMETER      :: B2N2STVx  =  357
   INTEGER(IntKi), PARAMETER      :: B2N3STVx  =  358
   INTEGER(IntKi), PARAMETER      :: B2N4STVx  =  359
   INTEGER(IntKi), PARAMETER      :: B2N5STVx  =  360
   INTEGER(IntKi), PARAMETER      :: B2N6STVx  =  361
   INTEGER(IntKi), PARAMETER      :: B2N7STVx  =  362
   INTEGER(IntKi), PARAMETER      :: B2N8STVx  =  363
   INTEGER(IntKi), PARAMETER      :: B2N9STVx  =  364
   INTEGER(IntKi), PARAMETER      :: B2N1STVy  =  365
   INTEGER(IntKi), PARAMETER      :: B2N2STVy  =  366
   INTEGER(IntKi), PARAMETER      :: B2N3STVy  =  367
   INTEGER(IntKi), PARAMETER      :: B2N4STVy  =  368
   INTEGER(IntKi), PARAMETER      :: B2N5STVy  =  369
   INTEGER(IntKi), PARAMETER      :: B2N6STVy  =  370
   INTEGER(IntKi), PARAMETER      :: B2N7STVy  =  371
   INTEGER(IntKi), PARAMETER      :: B2N8STVy  =  372
   INTEGER(IntKi), PARAMETER      :: B2N9STVy  =  373
   INTEGER(IntKi), PARAMETER      :: B2N1STVz  =  374
   INTEGER(IntKi), PARAMETER      :: B2N2STVz  =  375
   INTEGER(IntKi), PARAMETER      :: B2N3STVz  =  376
   INTEGER(IntKi), PARAMETER      :: B2N4STVz  =  377
   INTEGER(IntKi), PARAMETER      :: B2N5STVz  =  378
   INTEGER(IntKi), PARAMETER      :: B2N6STVz  =  379
   INTEGER(IntKi), PARAMETER      :: B2N7STVz  =  380
   INTEGER(IntKi), PARAMETER      :: B2N8STVz  =  381
   INTEGER(IntKi), PARAMETER      :: B2N9STVz  =  382
   INTEGER(IntKi), PARAMETER      :: B3N1STVx  =  383
   INTEGER(IntKi), PARAMETER      :: B3N2STVx  =  384
   INTEGER(IntKi), PARAMETER      :: B3N3STVx  =  385
   INTEGER(IntKi), PARAMETER      :: B3N4STVx  =  386
   INTEGER(IntKi), PARAMETER      :: B3N5STVx  =  387
   INTEGER(IntKi), PARAMETER      :: B3N6STVx  =  388
   INTEGER(IntKi), PARAMETER      :: B3N7STVx  =  389
   INTEGER(IntKi), PARAMETER      :: B3N8STVx  =  390
   INTEGER(IntKi), PARAMETER      :: B3N9STVx  =  391
   INTEGER(IntKi), PARAMETER      :: B3N1STVy  =  392
   INTEGER(IntKi), PARAMETER      :: B3N2STVy  =  393
   INTEGER(IntKi), PARAMETER      :: B3N3STVy  =  394
   INTEGER(IntKi), PARAMETER      :: B3N4STVy  =  395
   INTEGER(IntKi), PARAMETER      :: B3N5STVy  =  396
   INTEGER(IntKi), PARAMETER      :: B3N6STVy  =  397
   INTEGER(IntKi), PARAMETER      :: B3N7STVy  =  398
   INTEGER(IntKi), PARAMETER      :: B3N8STVy  =  399
   INTEGER(IntKi), PARAMETER      :: B3N9STVy  =  400
   INTEGER(IntKi), PARAMETER      :: B3N1STVz  =  401
   INTEGER(IntKi), PARAMETER      :: B3N2STVz  =  402
   INTEGER(IntKi), PARAMETER      :: B3N3STVz  =  403
   INTEGER(IntKi), PARAMETER      :: B3N4STVz  =  404
   INTEGER(IntKi), PARAMETER      :: B3N5STVz  =  405
   INTEGER(IntKi), PARAMETER      :: B3N6STVz  =  406
   INTEGER(IntKi), PARAMETER      :: B3N7STVz  =  407
   INTEGER(IntKi), PARAMETER      :: B3N8STVz  =  408
   INTEGER(IntKi), PARAMETER      :: B3N9STVz  =  409
   INTEGER(IntKi), PARAMETER      :: B1N1VRel  =  410
   INTEGER(IntKi), PARAMETER      :: B1N2VRel  =  411
   INTEGER(IntKi), PARAMETER      :: B1N3VRel  =  412
   INTEGER(IntKi), PARAMETER      :: B1N4VRel  =  413
   INTEGER(IntKi), PARAMETER      :: B1N5VRel  =  414
   INTEGER(IntKi), PARAMETER      :: B1N6VRel  =  415
   INTEGER(IntKi), PARAMETER      :: B1N7VRel  =  416
   INTEGER(IntKi), PARAMETER      :: B1N8VRel  =  417
   INTEGER(IntKi), PARAMETER      :: B1N9VRel  =  418
   INTEGER(IntKi), PARAMETER      :: B2N1VRel  =  419
   INTEGER(IntKi), PARAMETER      :: B2N2VRel  =  420
   INTEGER(IntKi), PARAMETER      :: B2N3VRel  =  421
   INTEGER(IntKi), PARAMETER      :: B2N4VRel  =  422
   INTEGER(IntKi), PARAMETER      :: B2N5VRel  =  423
   INTEGER(IntKi), PARAMETER      :: B2N6VRel  =  424
   INTEGER(IntKi), PARAMETER      :: B2N7VRel  =  425
   INTEGER(IntKi), PARAMETER      :: B2N8VRel  =  426
   INTEGER(IntKi), PARAMETER      :: B2N9VRel  =  427
   INTEGER(IntKi), PARAMETER      :: B3N1VRel  =  428
   INTEGER(IntKi), PARAMETER      :: B3N2VRel  =  429
   INTEGER(IntKi), PARAMETER      :: B3N3VRel  =  430
   INTEGER(IntKi), PARAMETER      :: B3N4VRel  =  431
   INTEGER(IntKi), PARAMETER      :: B3N5VRel  =  432
   INTEGER(IntKi), PARAMETER      :: B3N6VRel  =  433
   INTEGER(IntKi), PARAMETER      :: B3N7VRel  =  434
   INTEGER(IntKi), PARAMETER      :: B3N8VRel  =  435
   INTEGER(IntKi), PARAMETER      :: B3N9VRel  =  436
   INTEGER(IntKi), PARAMETER      :: B1N1DynP  =  437
   INTEGER(IntKi), PARAMETER      :: B1N2DynP  =  438
   INTEGER(IntKi), PARAMETER      :: B1N3DynP  =  439
   INTEGER(IntKi), PARAMETER      :: B1N4DynP  =  440
   INTEGER(IntKi), PARAMETER      :: B1N5DynP  =  441
   INTEGER(IntKi), PARAMETER      :: B1N6DynP  =  442
   INTEGER(IntKi), PARAMETER      :: B1N7DynP  =  443
   INTEGER(IntKi), PARAMETER      :: B1N8DynP  =  444
   INTEGER(IntKi), PARAMETER      :: B1N9DynP  =  445
   INTEGER(IntKi), PARAMETER      :: B2N1DynP  =  446
   INTEGER(IntKi), PARAMETER      :: B2N2DynP  =  447
   INTEGER(IntKi), PARAMETER      :: B2N3DynP  =  448
   INTEGER(IntKi), PARAMETER      :: B2N4DynP  =  449
   INTEGER(IntKi), PARAMETER      :: B2N5DynP  =  450
   INTEGER(IntKi), PARAMETER      :: B2N6DynP  =  451
   INTEGER(IntKi), PARAMETER      :: B2N7DynP  =  452
   INTEGER(IntKi), PARAMETER      :: B2N8DynP  =  453
   INTEGER(IntKi), PARAMETER      :: B2N9DynP  =  454
   INTEGER(IntKi), PARAMETER      :: B3N1DynP  =  455
   INTEGER(IntKi), PARAMETER      :: B3N2DynP  =  456
   INTEGER(IntKi), PARAMETER      :: B3N3DynP  =  457
   INTEGER(IntKi), PARAMETER      :: B3N4DynP  =  458
   INTEGER(IntKi), PARAMETER      :: B3N5DynP  =  459
   INTEGER(IntKi), PARAMETER      :: B3N6DynP  =  460
   INTEGER(IntKi), PARAMETER      :: B3N7DynP  =  461
   INTEGER(IntKi), PARAMETER      :: B3N8DynP  =  462
   INTEGER(IntKi), PARAMETER      :: B3N9DynP  =  463
   INTEGER(IntKi), PARAMETER      :: B1N1Re    =  464
   INTEGER(IntKi), PARAMETER      :: B1N2Re    =  465
   INTEGER(IntKi), PARAMETER      :: B1N3Re    =  466
   INTEGER(IntKi), PARAMETER      :: B1N4Re    =  467
   INTEGER(IntKi), PARAMETER      :: B1N5Re    =  468
   INTEGER(IntKi), PARAMETER      :: B1N6Re    =  469
   INTEGER(IntKi), PARAMETER      :: B1N7Re    =  470
   INTEGER(IntKi), PARAMETER      :: B1N8Re    =  471
   INTEGER(IntKi), PARAMETER      :: B1N9Re    =  472
   INTEGER(IntKi), PARAMETER      :: B2N1Re    =  473
   INTEGER(IntKi), PARAMETER      :: B2N2Re    =  474
   INTEGER(IntKi), PARAMETER      :: B2N3Re    =  475
   INTEGER(IntKi), PARAMETER      :: B2N4Re    =  476
   INTEGER(IntKi), PARAMETER      :: B2N5Re    =  477
   INTEGER(IntKi), PARAMETER      :: B2N6Re    =  478
   INTEGER(IntKi), PARAMETER      :: B2N7Re    =  479
   INTEGER(IntKi), PARAMETER      :: B2N8Re    =  480
   INTEGER(IntKi), PARAMETER      :: B2N9Re    =  481
   INTEGER(IntKi), PARAMETER      :: B3N1Re    =  482
   INTEGER(IntKi), PARAMETER      :: B3N2Re    =  483
   INTEGER(IntKi), PARAMETER      :: B3N3Re    =  484
   INTEGER(IntKi), PARAMETER      :: B3N4Re    =  485
   INTEGER(IntKi), PARAMETER      :: B3N5Re    =  486
   INTEGER(IntKi), PARAMETER      :: B3N6Re    =  487
   INTEGER(IntKi), PARAMETER      :: B3N7Re    =  488
   INTEGER(IntKi), PARAMETER      :: B3N8Re    =  489
   INTEGER(IntKi), PARAMETER      :: B3N9Re    =  490
   INTEGER(IntKi), PARAMETER      :: B1N1M     =  491
   INTEGER(IntKi), PARAMETER      :: B1N2M     =  492
   INTEGER(IntKi), PARAMETER      :: B1N3M     =  493
   INTEGER(IntKi), PARAMETER      :: B1N4M     =  494
   INTEGER(IntKi), PARAMETER      :: B1N5M     =  495
   INTEGER(IntKi), PARAMETER      :: B1N6M     =  496
   INTEGER(IntKi), PARAMETER      :: B1N7M     =  497
   INTEGER(IntKi), PARAMETER      :: B1N8M     =  498
   INTEGER(IntKi), PARAMETER      :: B1N9M     =  499
   INTEGER(IntKi), PARAMETER      :: B2N1M     =  500
   INTEGER(IntKi), PARAMETER      :: B2N2M     =  501
   INTEGER(IntKi), PARAMETER      :: B2N3M     =  502
   INTEGER(IntKi), PARAMETER      :: B2N4M     =  503
   INTEGER(IntKi), PARAMETER      :: B2N5M     =  504
   INTEGER(IntKi), PARAMETER      :: B2N6M     =  505
   INTEGER(IntKi), PARAMETER      :: B2N7M     =  506
   INTEGER(IntKi), PARAMETER      :: B2N8M     =  507
   INTEGER(IntKi), PARAMETER      :: B2N9M     =  508
   INTEGER(IntKi), PARAMETER      :: B3N1M     =  509
   INTEGER(IntKi), PARAMETER      :: B3N2M     =  510
   INTEGER(IntKi), PARAMETER      :: B3N3M     =  511
   INTEGER(IntKi), PARAMETER      :: B3N4M     =  512
   INTEGER(IntKi), PARAMETER      :: B3N5M     =  513
   INTEGER(IntKi), PARAMETER      :: B3N6M     =  514
   INTEGER(IntKi), PARAMETER      :: B3N7M     =  515
   INTEGER(IntKi), PARAMETER      :: B3N8M     =  516
   INTEGER(IntKi), PARAMETER      :: B3N9M     =  517
   INTEGER(IntKi), PARAMETER      :: B1N1Vindx =  518
   INTEGER(IntKi), PARAMETER      :: B1N2Vindx =  519
   INTEGER(IntKi), PARAMETER      :: B1N3Vindx =  520
   INTEGER(IntKi), PARAMETER      :: B1N4Vindx =  521
   INTEGER(IntKi), PARAMETER      :: B1N5Vindx =  522
   INTEGER(IntKi), PARAMETER      :: B1N6Vindx =  523
   INTEGER(IntKi), PARAMETER      :: B1N7Vindx =  524
   INTEGER(IntKi), PARAMETER      :: B1N8Vindx =  525
   INTEGER(IntKi), PARAMETER      :: B1N9Vindx =  526
   INTEGER(IntKi), PARAMETER      :: B2N1Vindx =  527
   INTEGER(IntKi), PARAMETER      :: B2N2Vindx =  528
   INTEGER(IntKi), PARAMETER      :: B2N3Vindx =  529
   INTEGER(IntKi), PARAMETER      :: B2N4Vindx =  530
   INTEGER(IntKi), PARAMETER      :: B2N5Vindx =  531
   INTEGER(IntKi), PARAMETER      :: B2N6Vindx =  532
   INTEGER(IntKi), PARAMETER      :: B2N7Vindx =  533
   INTEGER(IntKi), PARAMETER      :: B2N8Vindx =  534
   INTEGER(IntKi), PARAMETER      :: B2N9Vindx =  535
   INTEGER(IntKi), PARAMETER      :: B3N1Vindx =  536
   INTEGER(IntKi), PARAMETER      :: B3N2Vindx =  537
   INTEGER(IntKi), PARAMETER      :: B3N3Vindx =  538
   INTEGER(IntKi), PARAMETER      :: B3N4Vindx =  539
   INTEGER(IntKi), PARAMETER      :: B3N5Vindx =  540
   INTEGER(IntKi), PARAMETER      :: B3N6Vindx =  541
   INTEGER(IntKi), PARAMETER      :: B3N7Vindx =  542
   INTEGER(IntKi), PARAMETER      :: B3N8Vindx =  543
   INTEGER(IntKi), PARAMETER      :: B3N9Vindx =  544
   INTEGER(IntKi), PARAMETER      :: B1N1Vindy =  545
   INTEGER(IntKi), PARAMETER      :: B1N2Vindy =  546
   INTEGER(IntKi), PARAMETER      :: B1N3Vindy =  547
   INTEGER(IntKi), PARAMETER      :: B1N4Vindy =  548
   INTEGER(IntKi), PARAMETER      :: B1N5Vindy =  549
   INTEGER(IntKi), PARAMETER      :: B1N6Vindy =  550
   INTEGER(IntKi), PARAMETER      :: B1N7Vindy =  551
   INTEGER(IntKi), PARAMETER      :: B1N8Vindy =  552
   INTEGER(IntKi), PARAMETER      :: B1N9Vindy =  553
   INTEGER(IntKi), PARAMETER      :: B2N1Vindy =  554
   INTEGER(IntKi), PARAMETER      :: B2N2Vindy =  555
   INTEGER(IntKi), PARAMETER      :: B2N3Vindy =  556
   INTEGER(IntKi), PARAMETER      :: B2N4Vindy =  557
   INTEGER(IntKi), PARAMETER      :: B2N5Vindy =  558
   INTEGER(IntKi), PARAMETER      :: B2N6Vindy =  559
   INTEGER(IntKi), PARAMETER      :: B2N7Vindy =  560
   INTEGER(IntKi), PARAMETER      :: B2N8Vindy =  561
   INTEGER(IntKi), PARAMETER      :: B2N9Vindy =  562
   INTEGER(IntKi), PARAMETER      :: B3N1Vindy =  563
   INTEGER(IntKi), PARAMETER      :: B3N2Vindy =  564
   INTEGER(IntKi), PARAMETER      :: B3N3Vindy =  565
   INTEGER(IntKi), PARAMETER      :: B3N4Vindy =  566
   INTEGER(IntKi), PARAMETER      :: B3N5Vindy =  567
   INTEGER(IntKi), PARAMETER      :: B3N6Vindy =  568
   INTEGER(IntKi), PARAMETER      :: B3N7Vindy =  569
   INTEGER(IntKi), PARAMETER      :: B3N8Vindy =  570
   INTEGER(IntKi), PARAMETER      :: B3N9Vindy =  571
   INTEGER(IntKi), PARAMETER      :: B1N1AxInd =  572
   INTEGER(IntKi), PARAMETER      :: B1N2AxInd =  573
   INTEGER(IntKi), PARAMETER      :: B1N3AxInd =  574
   INTEGER(IntKi), PARAMETER      :: B1N4AxInd =  575
   INTEGER(IntKi), PARAMETER      :: B1N5AxInd =  576
   INTEGER(IntKi), PARAMETER      :: B1N6AxInd =  577
   INTEGER(IntKi), PARAMETER      :: B1N7AxInd =  578
   INTEGER(IntKi), PARAMETER      :: B1N8AxInd =  579
   INTEGER(IntKi), PARAMETER      :: B1N9AxInd =  580
   INTEGER(IntKi), PARAMETER      :: B2N1AxInd =  581
   INTEGER(IntKi), PARAMETER      :: B2N2AxInd =  582
   INTEGER(IntKi), PARAMETER      :: B2N3AxInd =  583
   INTEGER(IntKi), PARAMETER      :: B2N4AxInd =  584
   INTEGER(IntKi), PARAMETER      :: B2N5AxInd =  585
   INTEGER(IntKi), PARAMETER      :: B2N6AxInd =  586
   INTEGER(IntKi), PARAMETER      :: B2N7AxInd =  587
   INTEGER(IntKi), PARAMETER      :: B2N8AxInd =  588
   INTEGER(IntKi), PARAMETER      :: B2N9AxInd =  589
   INTEGER(IntKi), PARAMETER      :: B3N1AxInd =  590
   INTEGER(IntKi), PARAMETER      :: B3N2AxInd =  591
   INTEGER(IntKi), PARAMETER      :: B3N3AxInd =  592
   INTEGER(IntKi), PARAMETER      :: B3N4AxInd =  593
   INTEGER(IntKi), PARAMETER      :: B3N5AxInd =  594
   INTEGER(IntKi), PARAMETER      :: B3N6AxInd =  595
   INTEGER(IntKi), PARAMETER      :: B3N7AxInd =  596
   INTEGER(IntKi), PARAMETER      :: B3N8AxInd =  597
   INTEGER(IntKi), PARAMETER      :: B3N9AxInd =  598
   INTEGER(IntKi), PARAMETER      :: B1N1TnInd =  599
   INTEGER(IntKi), PARAMETER      :: B1N2TnInd =  600
   INTEGER(IntKi), PARAMETER      :: B1N3TnInd =  601
   INTEGER(IntKi), PARAMETER      :: B1N4TnInd =  602
   INTEGER(IntKi), PARAMETER      :: B1N5TnInd =  603
   INTEGER(IntKi), PARAMETER      :: B1N6TnInd =  604
   INTEGER(IntKi), PARAMETER      :: B1N7TnInd =  605
   INTEGER(IntKi), PARAMETER      :: B1N8TnInd =  606
   INTEGER(IntKi), PARAMETER      :: B1N9TnInd =  607
   INTEGER(IntKi), PARAMETER      :: B2N1TnInd =  608
   INTEGER(IntKi), PARAMETER      :: B2N2TnInd =  609
   INTEGER(IntKi), PARAMETER      :: B2N3TnInd =  610
   INTEGER(IntKi), PARAMETER      :: B2N4TnInd =  611
   INTEGER(IntKi), PARAMETER      :: B2N5TnInd =  612
   INTEGER(IntKi), PARAMETER      :: B2N6TnInd =  613
   INTEGER(IntKi), PARAMETER      :: B2N7TnInd =  614
   INTEGER(IntKi), PARAMETER      :: B2N8TnInd =  615
   INTEGER(IntKi), PARAMETER      :: B2N9TnInd =  616
   INTEGER(IntKi), PARAMETER      :: B3N1TnInd =  617
   INTEGER(IntKi), PARAMETER      :: B3N2TnInd =  618
   INTEGER(IntKi), PARAMETER      :: B3N3TnInd =  619
   INTEGER(IntKi), PARAMETER      :: B3N4TnInd =  620
   INTEGER(IntKi), PARAMETER      :: B3N5TnInd =  621
   INTEGER(IntKi), PARAMETER      :: B3N6TnInd =  622
   INTEGER(IntKi), PARAMETER      :: B3N7TnInd =  623
   INTEGER(IntKi), PARAMETER      :: B3N8TnInd =  624
   INTEGER(IntKi), PARAMETER      :: B3N9TnInd =  625
   INTEGER(IntKi), PARAMETER      :: B1N1Alpha =  626
   INTEGER(IntKi), PARAMETER      :: B1N2Alpha =  627
   INTEGER(IntKi), PARAMETER      :: B1N3Alpha =  628
   INTEGER(IntKi), PARAMETER      :: B1N4Alpha =  629
   INTEGER(IntKi), PARAMETER      :: B1N5Alpha =  630
   INTEGER(IntKi), PARAMETER      :: B1N6Alpha =  631
   INTEGER(IntKi), PARAMETER      :: B1N7Alpha =  632
   INTEGER(IntKi), PARAMETER      :: B1N8Alpha =  633
   INTEGER(IntKi), PARAMETER      :: B1N9Alpha =  634
   INTEGER(IntKi), PARAMETER      :: B2N1Alpha =  635
   INTEGER(IntKi), PARAMETER      :: B2N2Alpha =  636
   INTEGER(IntKi), PARAMETER      :: B2N3Alpha =  637
   INTEGER(IntKi), PARAMETER      :: B2N4Alpha =  638
   INTEGER(IntKi), PARAMETER      :: B2N5Alpha =  639
   INTEGER(IntKi), PARAMETER      :: B2N6Alpha =  640
   INTEGER(IntKi), PARAMETER      :: B2N7Alpha =  641
   INTEGER(IntKi), PARAMETER      :: B2N8Alpha =  642
   INTEGER(IntKi), PARAMETER      :: B2N9Alpha =  643
   INTEGER(IntKi), PARAMETER      :: B3N1Alpha =  644
   INTEGER(IntKi), PARAMETER      :: B3N2Alpha =  645
   INTEGER(IntKi), PARAMETER      :: B3N3Alpha =  646
   INTEGER(IntKi), PARAMETER      :: B3N4Alpha =  647
   INTEGER(IntKi), PARAMETER      :: B3N5Alpha =  648
   INTEGER(IntKi), PARAMETER      :: B3N6Alpha =  649
   INTEGER(IntKi), PARAMETER      :: B3N7Alpha =  650
   INTEGER(IntKi), PARAMETER      :: B3N8Alpha =  651
   INTEGER(IntKi), PARAMETER      :: B3N9Alpha =  652
   INTEGER(IntKi), PARAMETER      :: B1N1Theta =  653
   INTEGER(IntKi), PARAMETER      :: B1N2Theta =  654
   INTEGER(IntKi), PARAMETER      :: B1N3Theta =  655
   INTEGER(IntKi), PARAMETER      :: B1N4Theta =  656
   INTEGER(IntKi), PARAMETER      :: B1N5Theta =  657
   INTEGER(IntKi), PARAMETER      :: B1N6Theta =  658
   INTEGER(IntKi), PARAMETER      :: B1N7Theta =  659
   INTEGER(IntKi), PARAMETER      :: B1N8Theta =  660
   INTEGER(IntKi), PARAMETER      :: B1N9Theta =  661
   INTEGER(IntKi), PARAMETER      :: B2N1Theta =  662
   INTEGER(IntKi), PARAMETER      :: B2N2Theta =  663
   INTEGER(IntKi), PARAMETER      :: B2N3Theta =  664
   INTEGER(IntKi), PARAMETER      :: B2N4Theta =  665
   INTEGER(IntKi), PARAMETER      :: B2N5Theta =  666
   INTEGER(IntKi), PARAMETER      :: B2N6Theta =  667
   INTEGER(IntKi), PARAMETER      :: B2N7Theta =  668
   INTEGER(IntKi), PARAMETER      :: B2N8Theta =  669
   INTEGER(IntKi), PARAMETER      :: B2N9Theta =  670
   INTEGER(IntKi), PARAMETER      :: B3N1Theta =  671
   INTEGER(IntKi), PARAMETER      :: B3N2Theta =  672
   INTEGER(IntKi), PARAMETER      :: B3N3Theta =  673
   INTEGER(IntKi), PARAMETER      :: B3N4Theta =  674
   INTEGER(IntKi), PARAMETER      :: B3N5Theta =  675
   INTEGER(IntKi), PARAMETER      :: B3N6Theta =  676
   INTEGER(IntKi), PARAMETER      :: B3N7Theta =  677
   INTEGER(IntKi), PARAMETER      :: B3N8Theta =  678
   INTEGER(IntKi), PARAMETER      :: B3N9Theta =  679
   INTEGER(IntKi), PARAMETER      :: B1N1Phi   =  680
   INTEGER(IntKi), PARAMETER      :: B1N2Phi   =  681
   INTEGER(IntKi), PARAMETER      :: B1N3Phi   =  682
   INTEGER(IntKi), PARAMETER      :: B1N4Phi   =  683
   INTEGER(IntKi), PARAMETER      :: B1N5Phi   =  684
   INTEGER(IntKi), PARAMETER      :: B1N6Phi   =  685
   INTEGER(IntKi), PARAMETER      :: B1N7Phi   =  686
   INTEGER(IntKi), PARAMETER      :: B1N8Phi   =  687
   INTEGER(IntKi), PARAMETER      :: B1N9Phi   =  688
   INTEGER(IntKi), PARAMETER      :: B2N1Phi   =  689
   INTEGER(IntKi), PARAMETER      :: B2N2Phi   =  690
   INTEGER(IntKi), PARAMETER      :: B2N3Phi   =  691
   INTEGER(IntKi), PARAMETER      :: B2N4Phi   =  692
   INTEGER(IntKi), PARAMETER      :: B2N5Phi   =  693
   INTEGER(IntKi), PARAMETER      :: B2N6Phi   =  694
   INTEGER(IntKi), PARAMETER      :: B2N7Phi   =  695
   INTEGER(IntKi), PARAMETER      :: B2N8Phi   =  696
   INTEGER(IntKi), PARAMETER      :: B2N9Phi   =  697
   INTEGER(IntKi), PARAMETER      :: B3N1Phi   =  698
   INTEGER(IntKi), PARAMETER      :: B3N2Phi   =  699
   INTEGER(IntKi), PARAMETER      :: B3N3Phi   =  700
   INTEGER(IntKi), PARAMETER      :: B3N4Phi   =  701
   INTEGER(IntKi), PARAMETER      :: B3N5Phi   =  702
   INTEGER(IntKi), PARAMETER      :: B3N6Phi   =  703
   INTEGER(IntKi), PARAMETER      :: B3N7Phi   =  704
   INTEGER(IntKi), PARAMETER      :: B3N8Phi   =  705
   INTEGER(IntKi), PARAMETER      :: B3N9Phi   =  706
   INTEGER(IntKi), PARAMETER      :: B1N1Curve =  707
   INTEGER(IntKi), PARAMETER      :: B1N2Curve =  708
   INTEGER(IntKi), PARAMETER      :: B1N3Curve =  709
   INTEGER(IntKi), PARAMETER      :: B1N4Curve =  710
   INTEGER(IntKi), PARAMETER      :: B1N5Curve =  711
   INTEGER(IntKi), PARAMETER      :: B1N6Curve =  712
   INTEGER(IntKi), PARAMETER      :: B1N7Curve =  713
   INTEGER(IntKi), PARAMETER      :: B1N8Curve =  714
   INTEGER(IntKi), PARAMETER      :: B1N9Curve =  715
   INTEGER(IntKi), PARAMETER      :: B2N1Curve =  716
   INTEGER(IntKi), PARAMETER      :: B2N2Curve =  717
   INTEGER(IntKi), PARAMETER      :: B2N3Curve =  718
   INTEGER(IntKi), PARAMETER      :: B2N4Curve =  719
   INTEGER(IntKi), PARAMETER      :: B2N5Curve =  720
   INTEGER(IntKi), PARAMETER      :: B2N6Curve =  721
   INTEGER(IntKi), PARAMETER      :: B2N7Curve =  722
   INTEGER(IntKi), PARAMETER      :: B2N8Curve =  723
   INTEGER(IntKi), PARAMETER      :: B2N9Curve =  724
   INTEGER(IntKi), PARAMETER      :: B3N1Curve =  725
   INTEGER(IntKi), PARAMETER      :: B3N2Curve =  726
   INTEGER(IntKi), PARAMETER      :: B3N3Curve =  727
   INTEGER(IntKi), PARAMETER      :: B3N4Curve =  728
   INTEGER(IntKi), PARAMETER      :: B3N5Curve =  729
   INTEGER(IntKi), PARAMETER      :: B3N6Curve =  730
   INTEGER(IntKi), PARAMETER      :: B3N7Curve =  731
   INTEGER(IntKi), PARAMETER      :: B3N8Curve =  732
   INTEGER(IntKi), PARAMETER      :: B3N9Curve =  733
   INTEGER(IntKi), PARAMETER      :: B1N1Cl    =  734
   INTEGER(IntKi), PARAMETER      :: B1N2Cl    =  735
   INTEGER(IntKi), PARAMETER      :: B1N3Cl    =  736
   INTEGER(IntKi), PARAMETER      :: B1N4Cl    =  737
   INTEGER(IntKi), PARAMETER      :: B1N5Cl    =  738
   INTEGER(IntKi), PARAMETER      :: B1N6Cl    =  739
   INTEGER(IntKi), PARAMETER      :: B1N7Cl    =  740
   INTEGER(IntKi), PARAMETER      :: B1N8Cl    =  741
   INTEGER(IntKi), PARAMETER      :: B1N9Cl    =  742
   INTEGER(IntKi), PARAMETER      :: B2N1Cl    =  743
   INTEGER(IntKi), PARAMETER      :: B2N2Cl    =  744
   INTEGER(IntKi), PARAMETER      :: B2N3Cl    =  745
   INTEGER(IntKi), PARAMETER      :: B2N4Cl    =  746
   INTEGER(IntKi), PARAMETER      :: B2N5Cl    =  747
   INTEGER(IntKi), PARAMETER      :: B2N6Cl    =  748
   INTEGER(IntKi), PARAMETER      :: B2N7Cl    =  749
   INTEGER(IntKi), PARAMETER      :: B2N8Cl    =  750
   INTEGER(IntKi), PARAMETER      :: B2N9Cl    =  751
   INTEGER(IntKi), PARAMETER      :: B3N1Cl    =  752
   INTEGER(IntKi), PARAMETER      :: B3N2Cl    =  753
   INTEGER(IntKi), PARAMETER      :: B3N3Cl    =  754
   INTEGER(IntKi), PARAMETER      :: B3N4Cl    =  755
   INTEGER(IntKi), PARAMETER      :: B3N5Cl    =  756
   INTEGER(IntKi), PARAMETER      :: B3N6Cl    =  757
   INTEGER(IntKi), PARAMETER      :: B3N7Cl    =  758
   INTEGER(IntKi), PARAMETER      :: B3N8Cl    =  759
   INTEGER(IntKi), PARAMETER      :: B3N9Cl    =  760
   INTEGER(IntKi), PARAMETER      :: B1N1Cd    =  761
   INTEGER(IntKi), PARAMETER      :: B1N2Cd    =  762
   INTEGER(IntKi), PARAMETER      :: B1N3Cd    =  763
   INTEGER(IntKi), PARAMETER      :: B1N4Cd    =  764
   INTEGER(IntKi), PARAMETER      :: B1N5Cd    =  765
   INTEGER(IntKi), PARAMETER      :: B1N6Cd    =  766
   INTEGER(IntKi), PARAMETER      :: B1N7Cd    =  767
   INTEGER(IntKi), PARAMETER      :: B1N8Cd    =  768
   INTEGER(IntKi), PARAMETER      :: B1N9Cd    =  769
   INTEGER(IntKi), PARAMETER      :: B2N1Cd    =  770
   INTEGER(IntKi), PARAMETER      :: B2N2Cd    =  771
   INTEGER(IntKi), PARAMETER      :: B2N3Cd    =  772
   INTEGER(IntKi), PARAMETER      :: B2N4Cd    =  773
   INTEGER(IntKi), PARAMETER      :: B2N5Cd    =  774
   INTEGER(IntKi), PARAMETER      :: B2N6Cd    =  775
   INTEGER(IntKi), PARAMETER      :: B2N7Cd    =  776
   INTEGER(IntKi), PARAMETER      :: B2N8Cd    =  777
   INTEGER(IntKi), PARAMETER      :: B2N9Cd    =  778
   INTEGER(IntKi), PARAMETER      :: B3N1Cd    =  779
   INTEGER(IntKi), PARAMETER      :: B3N2Cd    =  780
   INTEGER(IntKi), PARAMETER      :: B3N3Cd    =  781
   INTEGER(IntKi), PARAMETER      :: B3N4Cd    =  782
   INTEGER(IntKi), PARAMETER      :: B3N5Cd    =  783
   INTEGER(IntKi), PARAMETER      :: B3N6Cd    =  784
   INTEGER(IntKi), PARAMETER      :: B3N7Cd    =  785
   INTEGER(IntKi), PARAMETER      :: B3N8Cd    =  786
   INTEGER(IntKi), PARAMETER      :: B3N9Cd    =  787
   INTEGER(IntKi), PARAMETER      :: B1N1Cm    =  788
   INTEGER(IntKi), PARAMETER      :: B1N2Cm    =  789
   INTEGER(IntKi), PARAMETER      :: B1N3Cm    =  790
   INTEGER(IntKi), PARAMETER      :: B1N4Cm    =  791
   INTEGER(IntKi), PARAMETER      :: B1N5Cm    =  792
   INTEGER(IntKi), PARAMETER      :: B1N6Cm    =  793
   INTEGER(IntKi), PARAMETER      :: B1N7Cm    =  794
   INTEGER(IntKi), PARAMETER      :: B1N8Cm    =  795
   INTEGER(IntKi), PARAMETER      :: B1N9Cm    =  796
   INTEGER(IntKi), PARAMETER      :: B2N1Cm    =  797
   INTEGER(IntKi), PARAMETER      :: B2N2Cm    =  798
   INTEGER(IntKi), PARAMETER      :: B2N3Cm    =  799
   INTEGER(IntKi), PARAMETER      :: B2N4Cm    =  800
   INTEGER(IntKi), PARAMETER      :: B2N5Cm    =  801
   INTEGER(IntKi), PARAMETER      :: B2N6Cm    =  802
   INTEGER(IntKi), PARAMETER      :: B2N7Cm    =  803
   INTEGER(IntKi), PARAMETER      :: B2N8Cm    =  804
   INTEGER(IntKi), PARAMETER      :: B2N9Cm    =  805
   INTEGER(IntKi), PARAMETER      :: B3N1Cm    =  806
   INTEGER(IntKi), PARAMETER      :: B3N2Cm    =  807
   INTEGER(IntKi), PARAMETER      :: B3N3Cm    =  808
   INTEGER(IntKi), PARAMETER      :: B3N4Cm    =  809
   INTEGER(IntKi), PARAMETER      :: B3N5Cm    =  810
   INTEGER(IntKi), PARAMETER      :: B3N6Cm    =  811
   INTEGER(IntKi), PARAMETER      :: B3N7Cm    =  812
   INTEGER(IntKi), PARAMETER      :: B3N8Cm    =  813
   INTEGER(IntKi), PARAMETER      :: B3N9Cm    =  814
   INTEGER(IntKi), PARAMETER      :: B1N1Cx    =  815
   INTEGER(IntKi), PARAMETER      :: B1N2Cx    =  816
   INTEGER(IntKi), PARAMETER      :: B1N3Cx    =  817
   INTEGER(IntKi), PARAMETER      :: B1N4Cx    =  818
   INTEGER(IntKi), PARAMETER      :: B1N5Cx    =  819
   INTEGER(IntKi), PARAMETER      :: B1N6Cx    =  820
   INTEGER(IntKi), PARAMETER      :: B1N7Cx    =  821
   INTEGER(IntKi), PARAMETER      :: B1N8Cx    =  822
   INTEGER(IntKi), PARAMETER      :: B1N9Cx    =  823
   INTEGER(IntKi), PARAMETER      :: B2N1Cx    =  824
   INTEGER(IntKi), PARAMETER      :: B2N2Cx    =  825
   INTEGER(IntKi), PARAMETER      :: B2N3Cx    =  826
   INTEGER(IntKi), PARAMETER      :: B2N4Cx    =  827
   INTEGER(IntKi), PARAMETER      :: B2N5Cx    =  828
   INTEGER(IntKi), PARAMETER      :: B2N6Cx    =  829
   INTEGER(IntKi), PARAMETER      :: B2N7Cx    =  830
   INTEGER(IntKi), PARAMETER      :: B2N8Cx    =  831
   INTEGER(IntKi), PARAMETER      :: B2N9Cx    =  832
   INTEGER(IntKi), PARAMETER      :: B3N1Cx    =  833
   INTEGER(IntKi), PARAMETER      :: B3N2Cx    =  834
   INTEGER(IntKi), PARAMETER      :: B3N3Cx    =  835
   INTEGER(IntKi), PARAMETER      :: B3N4Cx    =  836
   INTEGER(IntKi), PARAMETER      :: B3N5Cx    =  837
   INTEGER(IntKi), PARAMETER      :: B3N6Cx    =  838
   INTEGER(IntKi), PARAMETER      :: B3N7Cx    =  839
   INTEGER(IntKi), PARAMETER      :: B3N8Cx    =  840
   INTEGER(IntKi), PARAMETER      :: B3N9Cx    =  841
   INTEGER(IntKi), PARAMETER      :: B1N1Cy    =  842
   INTEGER(IntKi), PARAMETER      :: B1N2Cy    =  843
   INTEGER(IntKi), PARAMETER      :: B1N3Cy    =  844
   INTEGER(IntKi), PARAMETER      :: B1N4Cy    =  845
   INTEGER(IntKi), PARAMETER      :: B1N5Cy    =  846
   INTEGER(IntKi), PARAMETER      :: B1N6Cy    =  847
   INTEGER(IntKi), PARAMETER      :: B1N7Cy    =  848
   INTEGER(IntKi), PARAMETER      :: B1N8Cy    =  849
   INTEGER(IntKi), PARAMETER      :: B1N9Cy    =  850
   INTEGER(IntKi), PARAMETER      :: B2N1Cy    =  851
   INTEGER(IntKi), PARAMETER      :: B2N2Cy    =  852
   INTEGER(IntKi), PARAMETER      :: B2N3Cy    =  853
   INTEGER(IntKi), PARAMETER      :: B2N4Cy    =  854
   INTEGER(IntKi), PARAMETER      :: B2N5Cy    =  855
   INTEGER(IntKi), PARAMETER      :: B2N6Cy    =  856
   INTEGER(IntKi), PARAMETER      :: B2N7Cy    =  857
   INTEGER(IntKi), PARAMETER      :: B2N8Cy    =  858
   INTEGER(IntKi), PARAMETER      :: B2N9Cy    =  859
   INTEGER(IntKi), PARAMETER      :: B3N1Cy    =  860
   INTEGER(IntKi), PARAMETER      :: B3N2Cy    =  861
   INTEGER(IntKi), PARAMETER      :: B3N3Cy    =  862
   INTEGER(IntKi), PARAMETER      :: B3N4Cy    =  863
   INTEGER(IntKi), PARAMETER      :: B3N5Cy    =  864
   INTEGER(IntKi), PARAMETER      :: B3N6Cy    =  865
   INTEGER(IntKi), PARAMETER      :: B3N7Cy    =  866
   INTEGER(IntKi), PARAMETER      :: B3N8Cy    =  867
   INTEGER(IntKi), PARAMETER      :: B3N9Cy    =  868
   INTEGER(IntKi), PARAMETER      :: B1N1Cn    =  869
   INTEGER(IntKi), PARAMETER      :: B1N2Cn    =  870
   INTEGER(IntKi), PARAMETER      :: B1N3Cn    =  871
   INTEGER(IntKi), PARAMETER      :: B1N4Cn    =  872
   INTEGER(IntKi), PARAMETER      :: B1N5Cn    =  873
   INTEGER(IntKi), PARAMETER      :: B1N6Cn    =  874
   INTEGER(IntKi), PARAMETER      :: B1N7Cn    =  875
   INTEGER(IntKi), PARAMETER      :: B1N8Cn    =  876
   INTEGER(IntKi), PARAMETER      :: B1N9Cn    =  877
   INTEGER(IntKi), PARAMETER      :: B2N1Cn    =  878
   INTEGER(IntKi), PARAMETER      :: B2N2Cn    =  879
   INTEGER(IntKi), PARAMETER      :: B2N3Cn    =  880
   INTEGER(IntKi), PARAMETER      :: B2N4Cn    =  881
   INTEGER(IntKi), PARAMETER      :: B2N5Cn    =  882
   INTEGER(IntKi), PARAMETER      :: B2N6Cn    =  883
   INTEGER(IntKi), PARAMETER      :: B2N7Cn    =  884
   INTEGER(IntKi), PARAMETER      :: B2N8Cn    =  885
   INTEGER(IntKi), PARAMETER      :: B2N9Cn    =  886
   INTEGER(IntKi), PARAMETER      :: B3N1Cn    =  887
   INTEGER(IntKi), PARAMETER      :: B3N2Cn    =  888
   INTEGER(IntKi), PARAMETER      :: B3N3Cn    =  889
   INTEGER(IntKi), PARAMETER      :: B3N4Cn    =  890
   INTEGER(IntKi), PARAMETER      :: B3N5Cn    =  891
   INTEGER(IntKi), PARAMETER      :: B3N6Cn    =  892
   INTEGER(IntKi), PARAMETER      :: B3N7Cn    =  893
   INTEGER(IntKi), PARAMETER      :: B3N8Cn    =  894
   INTEGER(IntKi), PARAMETER      :: B3N9Cn    =  895
   INTEGER(IntKi), PARAMETER      :: B1N1Ct    =  896
   INTEGER(IntKi), PARAMETER      :: B1N2Ct    =  897
   INTEGER(IntKi), PARAMETER      :: B1N3Ct    =  898
   INTEGER(IntKi), PARAMETER      :: B1N4Ct    =  899
   INTEGER(IntKi), PARAMETER      :: B1N5Ct    =  900
   INTEGER(IntKi), PARAMETER      :: B1N6Ct    =  901
   INTEGER(IntKi), PARAMETER      :: B1N7Ct    =  902
   INTEGER(IntKi), PARAMETER      :: B1N8Ct    =  903
   INTEGER(IntKi), PARAMETER      :: B1N9Ct    =  904
   INTEGER(IntKi), PARAMETER      :: B2N1Ct    =  905
   INTEGER(IntKi), PARAMETER      :: B2N2Ct    =  906
   INTEGER(IntKi), PARAMETER      :: B2N3Ct    =  907
   INTEGER(IntKi), PARAMETER      :: B2N4Ct    =  908
   INTEGER(IntKi), PARAMETER      :: B2N5Ct    =  909
   INTEGER(IntKi), PARAMETER      :: B2N6Ct    =  910
   INTEGER(IntKi), PARAMETER      :: B2N7Ct    =  911
   INTEGER(IntKi), PARAMETER      :: B2N8Ct    =  912
   INTEGER(IntKi), PARAMETER      :: B2N9Ct    =  913
   INTEGER(IntKi), PARAMETER      :: B3N1Ct    =  914
   INTEGER(IntKi), PARAMETER      :: B3N2Ct    =  915
   INTEGER(IntKi), PARAMETER      :: B3N3Ct    =  916
   INTEGER(IntKi), PARAMETER      :: B3N4Ct    =  917
   INTEGER(IntKi), PARAMETER      :: B3N5Ct    =  918
   INTEGER(IntKi), PARAMETER      :: B3N6Ct    =  919
   INTEGER(IntKi), PARAMETER      :: B3N7Ct    =  920
   INTEGER(IntKi), PARAMETER      :: B3N8Ct    =  921
   INTEGER(IntKi), PARAMETER      :: B3N9Ct    =  922
   INTEGER(IntKi), PARAMETER      :: B1N1Fl    =  923
   INTEGER(IntKi), PARAMETER      :: B1N2Fl    =  924
   INTEGER(IntKi), PARAMETER      :: B1N3Fl    =  925
   INTEGER(IntKi), PARAMETER      :: B1N4Fl    =  926
   INTEGER(IntKi), PARAMETER      :: B1N5Fl    =  927
   INTEGER(IntKi), PARAMETER      :: B1N6Fl    =  928
   INTEGER(IntKi), PARAMETER      :: B1N7Fl    =  929
   INTEGER(IntKi), PARAMETER      :: B1N8Fl    =  930
   INTEGER(IntKi), PARAMETER      :: B1N9Fl    =  931
   INTEGER(IntKi), PARAMETER      :: B2N1Fl    =  932
   INTEGER(IntKi), PARAMETER      :: B2N2Fl    =  933
   INTEGER(IntKi), PARAMETER      :: B2N3Fl    =  934
   INTEGER(IntKi), PARAMETER      :: B2N4Fl    =  935
   INTEGER(IntKi), PARAMETER      :: B2N5Fl    =  936
   INTEGER(IntKi), PARAMETER      :: B2N6Fl    =  937
   INTEGER(IntKi), PARAMETER      :: B2N7Fl    =  938
   INTEGER(IntKi), PARAMETER      :: B2N8Fl    =  939
   INTEGER(IntKi), PARAMETER      :: B2N9Fl    =  940
   INTEGER(IntKi), PARAMETER      :: B3N1Fl    =  941
   INTEGER(IntKi), PARAMETER      :: B3N2Fl    =  942
   INTEGER(IntKi), PARAMETER      :: B3N3Fl    =  943
   INTEGER(IntKi), PARAMETER      :: B3N4Fl    =  944
   INTEGER(IntKi), PARAMETER      :: B3N5Fl    =  945
   INTEGER(IntKi), PARAMETER      :: B3N6Fl    =  946
   INTEGER(IntKi), PARAMETER      :: B3N7Fl    =  947
   INTEGER(IntKi), PARAMETER      :: B3N8Fl    =  948
   INTEGER(IntKi), PARAMETER      :: B3N9Fl    =  949
   INTEGER(IntKi), PARAMETER      :: B1N1Fd    =  950
   INTEGER(IntKi), PARAMETER      :: B1N2Fd    =  951
   INTEGER(IntKi), PARAMETER      :: B1N3Fd    =  952
   INTEGER(IntKi), PARAMETER      :: B1N4Fd    =  953
   INTEGER(IntKi), PARAMETER      :: B1N5Fd    =  954
   INTEGER(IntKi), PARAMETER      :: B1N6Fd    =  955
   INTEGER(IntKi), PARAMETER      :: B1N7Fd    =  956
   INTEGER(IntKi), PARAMETER      :: B1N8Fd    =  957
   INTEGER(IntKi), PARAMETER      :: B1N9Fd    =  958
   INTEGER(IntKi), PARAMETER      :: B2N1Fd    =  959
   INTEGER(IntKi), PARAMETER      :: B2N2Fd    =  960
   INTEGER(IntKi), PARAMETER      :: B2N3Fd    =  961
   INTEGER(IntKi), PARAMETER      :: B2N4Fd    =  962
   INTEGER(IntKi), PARAMETER      :: B2N5Fd    =  963
   INTEGER(IntKi), PARAMETER      :: B2N6Fd    =  964
   INTEGER(IntKi), PARAMETER      :: B2N7Fd    =  965
   INTEGER(IntKi), PARAMETER      :: B2N8Fd    =  966
   INTEGER(IntKi), PARAMETER      :: B2N9Fd    =  967
   INTEGER(IntKi), PARAMETER      :: B3N1Fd    =  968
   INTEGER(IntKi), PARAMETER      :: B3N2Fd    =  969
   INTEGER(IntKi), PARAMETER      :: B3N3Fd    =  970
   INTEGER(IntKi), PARAMETER      :: B3N4Fd    =  971
   INTEGER(IntKi), PARAMETER      :: B3N5Fd    =  972
   INTEGER(IntKi), PARAMETER      :: B3N6Fd    =  973
   INTEGER(IntKi), PARAMETER      :: B3N7Fd    =  974
   INTEGER(IntKi), PARAMETER      :: B3N8Fd    =  975
   INTEGER(IntKi), PARAMETER      :: B3N9Fd    =  976
   INTEGER(IntKi), PARAMETER      :: B1N1Mm    =  977
   INTEGER(IntKi), PARAMETER      :: B1N2Mm    =  978
   INTEGER(IntKi), PARAMETER      :: B1N3Mm    =  979
   INTEGER(IntKi), PARAMETER      :: B1N4Mm    =  980
   INTEGER(IntKi), PARAMETER      :: B1N5Mm    =  981
   INTEGER(IntKi), PARAMETER      :: B1N6Mm    =  982
   INTEGER(IntKi), PARAMETER      :: B1N7Mm    =  983
   INTEGER(IntKi), PARAMETER      :: B1N8Mm    =  984
   INTEGER(IntKi), PARAMETER      :: B1N9Mm    =  985
   INTEGER(IntKi), PARAMETER      :: B2N1Mm    =  986
   INTEGER(IntKi), PARAMETER      :: B2N2Mm    =  987
   INTEGER(IntKi), PARAMETER      :: B2N3Mm    =  988
   INTEGER(IntKi), PARAMETER      :: B2N4Mm    =  989
   INTEGER(IntKi), PARAMETER      :: B2N5Mm    =  990
   INTEGER(IntKi), PARAMETER      :: B2N6Mm    =  991
   INTEGER(IntKi), PARAMETER      :: B2N7Mm    =  992
   INTEGER(IntKi), PARAMETER      :: B2N8Mm    =  993
   INTEGER(IntKi), PARAMETER      :: B2N9Mm    =  994
   INTEGER(IntKi), PARAMETER      :: B3N1Mm    =  995
   INTEGER(IntKi), PARAMETER      :: B3N2Mm    =  996
   INTEGER(IntKi), PARAMETER      :: B3N3Mm    =  997
   INTEGER(IntKi), PARAMETER      :: B3N4Mm    =  998
   INTEGER(IntKi), PARAMETER      :: B3N5Mm    =  999
   INTEGER(IntKi), PARAMETER      :: B3N6Mm    = 1000
   INTEGER(IntKi), PARAMETER      :: B3N7Mm    = 1001
   INTEGER(IntKi), PARAMETER      :: B3N8Mm    = 1002
   INTEGER(IntKi), PARAMETER      :: B3N9Mm    = 1003
   INTEGER(IntKi), PARAMETER      :: B1N1Fx    = 1004
   INTEGER(IntKi), PARAMETER      :: B1N2Fx    = 1005
   INTEGER(IntKi), PARAMETER      :: B1N3Fx    = 1006
   INTEGER(IntKi), PARAMETER      :: B1N4Fx    = 1007
   INTEGER(IntKi), PARAMETER      :: B1N5Fx    = 1008
   INTEGER(IntKi), PARAMETER      :: B1N6Fx    = 1009
   INTEGER(IntKi), PARAMETER      :: B1N7Fx    = 1010
   INTEGER(IntKi), PARAMETER      :: B1N8Fx    = 1011
   INTEGER(IntKi), PARAMETER      :: B1N9Fx    = 1012
   INTEGER(IntKi), PARAMETER      :: B2N1Fx    = 1013
   INTEGER(IntKi), PARAMETER      :: B2N2Fx    = 1014
   INTEGER(IntKi), PARAMETER      :: B2N3Fx    = 1015
   INTEGER(IntKi), PARAMETER      :: B2N4Fx    = 1016
   INTEGER(IntKi), PARAMETER      :: B2N5Fx    = 1017
   INTEGER(IntKi), PARAMETER      :: B2N6Fx    = 1018
   INTEGER(IntKi), PARAMETER      :: B2N7Fx    = 1019
   INTEGER(IntKi), PARAMETER      :: B2N8Fx    = 1020
   INTEGER(IntKi), PARAMETER      :: B2N9Fx    = 1021
   INTEGER(IntKi), PARAMETER      :: B3N1Fx    = 1022
   INTEGER(IntKi), PARAMETER      :: B3N2Fx    = 1023
   INTEGER(IntKi), PARAMETER      :: B3N3Fx    = 1024
   INTEGER(IntKi), PARAMETER      :: B3N4Fx    = 1025
   INTEGER(IntKi), PARAMETER      :: B3N5Fx    = 1026
   INTEGER(IntKi), PARAMETER      :: B3N6Fx    = 1027
   INTEGER(IntKi), PARAMETER      :: B3N7Fx    = 1028
   INTEGER(IntKi), PARAMETER      :: B3N8Fx    = 1029
   INTEGER(IntKi), PARAMETER      :: B3N9Fx    = 1030
   INTEGER(IntKi), PARAMETER      :: B1N1Fy    = 1031
   INTEGER(IntKi), PARAMETER      :: B1N2Fy    = 1032
   INTEGER(IntKi), PARAMETER      :: B1N3Fy    = 1033
   INTEGER(IntKi), PARAMETER      :: B1N4Fy    = 1034
   INTEGER(IntKi), PARAMETER      :: B1N5Fy    = 1035
   INTEGER(IntKi), PARAMETER      :: B1N6Fy    = 1036
   INTEGER(IntKi), PARAMETER      :: B1N7Fy    = 1037
   INTEGER(IntKi), PARAMETER      :: B1N8Fy    = 1038
   INTEGER(IntKi), PARAMETER      :: B1N9Fy    = 1039
   INTEGER(IntKi), PARAMETER      :: B2N1Fy    = 1040
   INTEGER(IntKi), PARAMETER      :: B2N2Fy    = 1041
   INTEGER(IntKi), PARAMETER      :: B2N3Fy    = 1042
   INTEGER(IntKi), PARAMETER      :: B2N4Fy    = 1043
   INTEGER(IntKi), PARAMETER      :: B2N5Fy    = 1044
   INTEGER(IntKi), PARAMETER      :: B2N6Fy    = 1045
   INTEGER(IntKi), PARAMETER      :: B2N7Fy    = 1046
   INTEGER(IntKi), PARAMETER      :: B2N8Fy    = 1047
   INTEGER(IntKi), PARAMETER      :: B2N9Fy    = 1048
   INTEGER(IntKi), PARAMETER      :: B3N1Fy    = 1049
   INTEGER(IntKi), PARAMETER      :: B3N2Fy    = 1050
   INTEGER(IntKi), PARAMETER      :: B3N3Fy    = 1051
   INTEGER(IntKi), PARAMETER      :: B3N4Fy    = 1052
   INTEGER(IntKi), PARAMETER      :: B3N5Fy    = 1053
   INTEGER(IntKi), PARAMETER      :: B3N6Fy    = 1054
   INTEGER(IntKi), PARAMETER      :: B3N7Fy    = 1055
   INTEGER(IntKi), PARAMETER      :: B3N8Fy    = 1056
   INTEGER(IntKi), PARAMETER      :: B3N9Fy    = 1057
   INTEGER(IntKi), PARAMETER      :: B1N1Fn    = 1058
   INTEGER(IntKi), PARAMETER      :: B1N2Fn    = 1059
   INTEGER(IntKi), PARAMETER      :: B1N3Fn    = 1060
   INTEGER(IntKi), PARAMETER      :: B1N4Fn    = 1061
   INTEGER(IntKi), PARAMETER      :: B1N5Fn    = 1062
   INTEGER(IntKi), PARAMETER      :: B1N6Fn    = 1063
   INTEGER(IntKi), PARAMETER      :: B1N7Fn    = 1064
   INTEGER(IntKi), PARAMETER      :: B1N8Fn    = 1065
   INTEGER(IntKi), PARAMETER      :: B1N9Fn    = 1066
   INTEGER(IntKi), PARAMETER      :: B2N1Fn    = 1067
   INTEGER(IntKi), PARAMETER      :: B2N2Fn    = 1068
   INTEGER(IntKi), PARAMETER      :: B2N3Fn    = 1069
   INTEGER(IntKi), PARAMETER      :: B2N4Fn    = 1070
   INTEGER(IntKi), PARAMETER      :: B2N5Fn    = 1071
   INTEGER(IntKi), PARAMETER      :: B2N6Fn    = 1072
   INTEGER(IntKi), PARAMETER      :: B2N7Fn    = 1073
   INTEGER(IntKi), PARAMETER      :: B2N8Fn    = 1074
   INTEGER(IntKi), PARAMETER      :: B2N9Fn    = 1075
   INTEGER(IntKi), PARAMETER      :: B3N1Fn    = 1076
   INTEGER(IntKi), PARAMETER      :: B3N2Fn    = 1077
   INTEGER(IntKi), PARAMETER      :: B3N3Fn    = 1078
   INTEGER(IntKi), PARAMETER      :: B3N4Fn    = 1079
   INTEGER(IntKi), PARAMETER      :: B3N5Fn    = 1080
   INTEGER(IntKi), PARAMETER      :: B3N6Fn    = 1081
   INTEGER(IntKi), PARAMETER      :: B3N7Fn    = 1082
   INTEGER(IntKi), PARAMETER      :: B3N8Fn    = 1083
   INTEGER(IntKi), PARAMETER      :: B3N9Fn    = 1084
   INTEGER(IntKi), PARAMETER      :: B1N1Ft    = 1085
   INTEGER(IntKi), PARAMETER      :: B1N2Ft    = 1086
   INTEGER(IntKi), PARAMETER      :: B1N3Ft    = 1087
   INTEGER(IntKi), PARAMETER      :: B1N4Ft    = 1088
   INTEGER(IntKi), PARAMETER      :: B1N5Ft    = 1089
   INTEGER(IntKi), PARAMETER      :: B1N6Ft    = 1090
   INTEGER(IntKi), PARAMETER      :: B1N7Ft    = 1091
   INTEGER(IntKi), PARAMETER      :: B1N8Ft    = 1092
   INTEGER(IntKi), PARAMETER      :: B1N9Ft    = 1093
   INTEGER(IntKi), PARAMETER      :: B2N1Ft    = 1094
   INTEGER(IntKi), PARAMETER      :: B2N2Ft    = 1095
   INTEGER(IntKi), PARAMETER      :: B2N3Ft    = 1096
   INTEGER(IntKi), PARAMETER      :: B2N4Ft    = 1097
   INTEGER(IntKi), PARAMETER      :: B2N5Ft    = 1098
   INTEGER(IntKi), PARAMETER      :: B2N6Ft    = 1099
   INTEGER(IntKi), PARAMETER      :: B2N7Ft    = 1100
   INTEGER(IntKi), PARAMETER      :: B2N8Ft    = 1101
   INTEGER(IntKi), PARAMETER      :: B2N9Ft    = 1102
   INTEGER(IntKi), PARAMETER      :: B3N1Ft    = 1103
   INTEGER(IntKi), PARAMETER      :: B3N2Ft    = 1104
   INTEGER(IntKi), PARAMETER      :: B3N3Ft    = 1105
   INTEGER(IntKi), PARAMETER      :: B3N4Ft    = 1106
   INTEGER(IntKi), PARAMETER      :: B3N5Ft    = 1107
   INTEGER(IntKi), PARAMETER      :: B3N6Ft    = 1108
   INTEGER(IntKi), PARAMETER      :: B3N7Ft    = 1109
   INTEGER(IntKi), PARAMETER      :: B3N8Ft    = 1110
   INTEGER(IntKi), PARAMETER      :: B3N9Ft    = 1111
   INTEGER(IntKi), PARAMETER      :: B1N1Clrnc = 1112
   INTEGER(IntKi), PARAMETER      :: B1N2Clrnc = 1113
   INTEGER(IntKi), PARAMETER      :: B1N3Clrnc = 1114
   INTEGER(IntKi), PARAMETER      :: B1N4Clrnc = 1115
   INTEGER(IntKi), PARAMETER      :: B1N5Clrnc = 1116
   INTEGER(IntKi), PARAMETER      :: B1N6Clrnc = 1117
   INTEGER(IntKi), PARAMETER      :: B1N7Clrnc = 1118
   INTEGER(IntKi), PARAMETER      :: B1N8Clrnc = 1119
   INTEGER(IntKi), PARAMETER      :: B1N9Clrnc = 1120
   INTEGER(IntKi), PARAMETER      :: B2N1Clrnc = 1121
   INTEGER(IntKi), PARAMETER      :: B2N2Clrnc = 1122
   INTEGER(IntKi), PARAMETER      :: B2N3Clrnc = 1123
   INTEGER(IntKi), PARAMETER      :: B2N4Clrnc = 1124
   INTEGER(IntKi), PARAMETER      :: B2N5Clrnc = 1125
   INTEGER(IntKi), PARAMETER      :: B2N6Clrnc = 1126
   INTEGER(IntKi), PARAMETER      :: B2N7Clrnc = 1127
   INTEGER(IntKi), PARAMETER      :: B2N8Clrnc = 1128
   INTEGER(IntKi), PARAMETER      :: B2N9Clrnc = 1129
   INTEGER(IntKi), PARAMETER      :: B3N1Clrnc = 1130
   INTEGER(IntKi), PARAMETER      :: B3N2Clrnc = 1131
   INTEGER(IntKi), PARAMETER      :: B3N3Clrnc = 1132
   INTEGER(IntKi), PARAMETER      :: B3N4Clrnc = 1133
   INTEGER(IntKi), PARAMETER      :: B3N5Clrnc = 1134
   INTEGER(IntKi), PARAMETER      :: B3N6Clrnc = 1135
   INTEGER(IntKi), PARAMETER      :: B3N7Clrnc = 1136
   INTEGER(IntKi), PARAMETER      :: B3N8Clrnc = 1137
   INTEGER(IntKi), PARAMETER      :: B3N9Clrnc = 1138
   INTEGER(IntKi), PARAMETER      :: B1N1Cpmin = 1139
   INTEGER(IntKi), PARAMETER      :: B1N2Cpmin = 1140
   INTEGER(IntKi), PARAMETER      :: B1N3Cpmin = 1141
   INTEGER(IntKi), PARAMETER      :: B1N4Cpmin = 1142
   INTEGER(IntKi), PARAMETER      :: B1N5Cpmin = 1143
   INTEGER(IntKi), PARAMETER      :: B1N6Cpmin = 1144
   INTEGER(IntKi), PARAMETER      :: B1N7Cpmin = 1145
   INTEGER(IntKi), PARAMETER      :: B1N8Cpmin = 1146
   INTEGER(IntKi), PARAMETER      :: B1N9Cpmin = 1147
   INTEGER(IntKi), PARAMETER      :: B2N1Cpmin = 1148
   INTEGER(IntKi), PARAMETER      :: B2N2Cpmin = 1149
   INTEGER(IntKi), PARAMETER      :: B2N3Cpmin = 1150
   INTEGER(IntKi), PARAMETER      :: B2N4Cpmin = 1151
   INTEGER(IntKi), PARAMETER      :: B2N5Cpmin = 1152
   INTEGER(IntKi), PARAMETER      :: B2N6Cpmin = 1153
   INTEGER(IntKi), PARAMETER      :: B2N7Cpmin = 1154
   INTEGER(IntKi), PARAMETER      :: B2N8Cpmin = 1155
   INTEGER(IntKi), PARAMETER      :: B2N9Cpmin = 1156
   INTEGER(IntKi), PARAMETER      :: B3N1Cpmin = 1157
   INTEGER(IntKi), PARAMETER      :: B3N2Cpmin = 1158
   INTEGER(IntKi), PARAMETER      :: B3N3Cpmin = 1159
   INTEGER(IntKi), PARAMETER      :: B3N4Cpmin = 1160
   INTEGER(IntKi), PARAMETER      :: B3N5Cpmin = 1161
   INTEGER(IntKi), PARAMETER      :: B3N6Cpmin = 1162
   INTEGER(IntKi), PARAMETER      :: B3N7Cpmin = 1163
   INTEGER(IntKi), PARAMETER      :: B3N8Cpmin = 1164
   INTEGER(IntKi), PARAMETER      :: B3N9Cpmin = 1165
   INTEGER(IntKi), PARAMETER      :: B1N1SigCr = 1166
   INTEGER(IntKi), PARAMETER      :: B1N2SigCr = 1167
   INTEGER(IntKi), PARAMETER      :: B1N3SigCr = 1168
   INTEGER(IntKi), PARAMETER      :: B1N4SigCr = 1169
   INTEGER(IntKi), PARAMETER      :: B1N5SigCr = 1170
   INTEGER(IntKi), PARAMETER      :: B1N6SigCr = 1171
   INTEGER(IntKi), PARAMETER      :: B1N7SigCr = 1172
   INTEGER(IntKi), PARAMETER      :: B1N8SigCr = 1173
   INTEGER(IntKi), PARAMETER      :: B1N9SigCr = 1174
   INTEGER(IntKi), PARAMETER      :: B2N1SigCr = 1175
   INTEGER(IntKi), PARAMETER      :: B2N2SigCr = 1176
   INTEGER(IntKi), PARAMETER      :: B2N3SigCr = 1177
   INTEGER(IntKi), PARAMETER      :: B2N4SigCr = 1178
   INTEGER(IntKi), PARAMETER      :: B2N5SigCr = 1179
   INTEGER(IntKi), PARAMETER      :: B2N6SigCr = 1180
   INTEGER(IntKi), PARAMETER      :: B2N7SigCr = 1181
   INTEGER(IntKi), PARAMETER      :: B2N8SigCr = 1182
   INTEGER(IntKi), PARAMETER      :: B2N9SigCr = 1183
   INTEGER(IntKi), PARAMETER      :: B3N1SigCr = 1184
   INTEGER(IntKi), PARAMETER      :: B3N2SigCr = 1185
   INTEGER(IntKi), PARAMETER      :: B3N3SigCr = 1186
   INTEGER(IntKi), PARAMETER      :: B3N4SigCr = 1187
   INTEGER(IntKi), PARAMETER      :: B3N5SigCr = 1188
   INTEGER(IntKi), PARAMETER      :: B3N6SigCr = 1189
   INTEGER(IntKi), PARAMETER      :: B3N7SigCr = 1190
   INTEGER(IntKi), PARAMETER      :: B3N8SigCr = 1191
   INTEGER(IntKi), PARAMETER      :: B3N9SigCr = 1192
   INTEGER(IntKi), PARAMETER      :: B1N1SgCav = 1193
   INTEGER(IntKi), PARAMETER      :: B1N2SgCav = 1194
   INTEGER(IntKi), PARAMETER      :: B1N3SgCav = 1195
   INTEGER(IntKi), PARAMETER      :: B1N4SgCav = 1196
   INTEGER(IntKi), PARAMETER      :: B1N5SgCav = 1197
   INTEGER(IntKi), PARAMETER      :: B1N6SgCav = 1198
   INTEGER(IntKi), PARAMETER      :: B1N7SgCav = 1199
   INTEGER(IntKi), PARAMETER      :: B1N8SgCav = 1200
   INTEGER(IntKi), PARAMETER      :: B1N9SgCav = 1201
   INTEGER(IntKi), PARAMETER      :: B2N1SgCav = 1202
   INTEGER(IntKi), PARAMETER      :: B2N2SgCav = 1203
   INTEGER(IntKi), PARAMETER      :: B2N3SgCav = 1204
   INTEGER(IntKi), PARAMETER      :: B2N4SgCav = 1205
   INTEGER(IntKi), PARAMETER      :: B2N5SgCav = 1206
   INTEGER(IntKi), PARAMETER      :: B2N6SgCav = 1207
   INTEGER(IntKi), PARAMETER      :: B2N7SgCav = 1208
   INTEGER(IntKi), PARAMETER      :: B2N8SgCav = 1209
   INTEGER(IntKi), PARAMETER      :: B2N9SgCav = 1210
   INTEGER(IntKi), PARAMETER      :: B3N1SgCav = 1211
   INTEGER(IntKi), PARAMETER      :: B3N2SgCav = 1212
   INTEGER(IntKi), PARAMETER      :: B3N3SgCav = 1213
   INTEGER(IntKi), PARAMETER      :: B3N4SgCav = 1214
   INTEGER(IntKi), PARAMETER      :: B3N5SgCav = 1215
   INTEGER(IntKi), PARAMETER      :: B3N6SgCav = 1216
   INTEGER(IntKi), PARAMETER      :: B3N7SgCav = 1217
   INTEGER(IntKi), PARAMETER      :: B3N8SgCav = 1218
   INTEGER(IntKi), PARAMETER      :: B3N9SgCav = 1219
   INTEGER(IntKi), PARAMETER      :: B1N1Gam   = 1220
   INTEGER(IntKi), PARAMETER      :: B1N2Gam   = 1221
   INTEGER(IntKi), PARAMETER      :: B1N3Gam   = 1222
   INTEGER(IntKi), PARAMETER      :: B1N4Gam   = 1223
   INTEGER(IntKi), PARAMETER      :: B1N5Gam   = 1224
   INTEGER(IntKi), PARAMETER      :: B1N6Gam   = 1225
   INTEGER(IntKi), PARAMETER      :: B1N7Gam   = 1226
   INTEGER(IntKi), PARAMETER      :: B1N8Gam   = 1227
   INTEGER(IntKi), PARAMETER      :: B1N9Gam   = 1228
   INTEGER(IntKi), PARAMETER      :: B2N1Gam   = 1229
   INTEGER(IntKi), PARAMETER      :: B2N2Gam   = 1230
   INTEGER(IntKi), PARAMETER      :: B2N3Gam   = 1231
   INTEGER(IntKi), PARAMETER      :: B2N4Gam   = 1232
   INTEGER(IntKi), PARAMETER      :: B2N5Gam   = 1233
   INTEGER(IntKi), PARAMETER      :: B2N6Gam   = 1234
   INTEGER(IntKi), PARAMETER      :: B2N7Gam   = 1235
   INTEGER(IntKi), PARAMETER      :: B2N8Gam   = 1236
   INTEGER(IntKi), PARAMETER      :: B2N9Gam   = 1237
   INTEGER(IntKi), PARAMETER      :: B3N1Gam   = 1238
   INTEGER(IntKi), PARAMETER      :: B3N2Gam   = 1239
   INTEGER(IntKi), PARAMETER      :: B3N3Gam   = 1240
   INTEGER(IntKi), PARAMETER      :: B3N4Gam   = 1241
   INTEGER(IntKi), PARAMETER      :: B3N5Gam   = 1242
   INTEGER(IntKi), PARAMETER      :: B3N6Gam   = 1243
   INTEGER(IntKi), PARAMETER      :: B3N7Gam   = 1244
   INTEGER(IntKi), PARAMETER      :: B3N8Gam   = 1245
   INTEGER(IntKi), PARAMETER      :: B3N9Gam   = 1246


     ! Rotor:

   INTEGER(IntKi), PARAMETER      :: RtSpeed   = 1247
   INTEGER(IntKi), PARAMETER      :: RtTSR     = 1248
   INTEGER(IntKi), PARAMETER      :: RtVAvgxh  = 1249
   INTEGER(IntKi), PARAMETER      :: RtVAvgyh  = 1250
   INTEGER(IntKi), PARAMETER      :: RtVAvgzh  = 1251
   INTEGER(IntKi), PARAMETER      :: RtSkew    = 1252
   INTEGER(IntKi), PARAMETER      :: RtAeroFxh = 1253
   INTEGER(IntKi), PARAMETER      :: RtAeroFyh = 1254
   INTEGER(IntKi), PARAMETER      :: RtAeroFzh = 1255
   INTEGER(IntKi), PARAMETER      :: RtAeroMxh = 1256
   INTEGER(IntKi), PARAMETER      :: RtAeroMyh = 1257
   INTEGER(IntKi), PARAMETER      :: RtAeroMzh = 1258
   INTEGER(IntKi), PARAMETER      :: RtAeroPwr = 1259
   INTEGER(IntKi), PARAMETER      :: RtArea    = 1260
   INTEGER(IntKi), PARAMETER      :: RtAeroCp  = 1261
   INTEGER(IntKi), PARAMETER      :: RtAeroCq  = 1262
   INTEGER(IntKi), PARAMETER      :: RtAeroCt  = 1263
   INTEGER(IntKi), PARAMETER      :: DBEMTau1  = 1264
   INTEGER(IntKi), PARAMETER      :: RtAeroFxg = 1265
   INTEGER(IntKi), PARAMETER      :: RtAeroFyg = 1266
   INTEGER(IntKi), PARAMETER      :: RtAeroFzg = 1267
   INTEGER(IntKi), PARAMETER      :: RtAeroMxg = 1268
   INTEGER(IntKi), PARAMETER      :: RtAeroMyg = 1269
   INTEGER(IntKi), PARAMETER      :: RtAeroMzg = 1270


     ! The maximum number of output channels which can be output by the code.
   INTEGER(IntKi), PARAMETER      :: MaxOutPts = 1270

!End of code generated by Matlab script
! ===================================================================================================
   
   INTEGER,  PARAMETER          :: TwNVUnd(3, 9) = RESHAPE( (/ &           ! Undisturbed wind velocity
                                     TwN1VUndx,TwN1VUndy,TwN1VUndz, &
                                     TwN2VUndx,TwN2VUndy,TwN2VUndz, &
                                     TwN3VUndx,TwN3VUndy,TwN3VUndz, &
                                     TwN4VUndx,TwN4VUndy,TwN4VUndz, &
                                     TwN5VUndx,TwN5VUndy,TwN5VUndz, &
                                     TwN6VUndx,TwN6VUndy,TwN6VUndz, &
                                     TwN7VUndx,TwN7VUndy,TwN7VUndz, &
                                     TwN8VUndx,TwN8VUndy,TwN8VUndz, &
                                     TwN9VUndx,TwN9VUndy,TwN9VUndz  &
                                   /), (/3, 9/) )
   INTEGER,  PARAMETER          :: TwNSTV(3, 9) = RESHAPE( (/ &            ! Structural translational velocity
                                     TwN1STVx,TwN1STVy,TwN1STVz, &
                                     TwN2STVx,TwN2STVy,TwN2STVz, &
                                     TwN3STVx,TwN3STVy,TwN3STVz, &
                                     TwN4STVx,TwN4STVy,TwN4STVz, &
                                     TwN5STVx,TwN5STVy,TwN5STVz, &
                                     TwN6STVx,TwN6STVy,TwN6STVz, &
                                     TwN7STVx,TwN7STVy,TwN7STVz, &
                                     TwN8STVx,TwN8STVy,TwN8STVz, &
                                     TwN9STVx,TwN9STVy,TwN9STVz  &
                                   /), (/3, 9/) )
   INTEGER,  PARAMETER          :: TwNVRel(9) = (/TwN1VRel,TwN2VRel,TwN3VRel,TwN4VRel,TwN5VRel,TwN6VRel,TwN7VRel,TwN8VRel,TwN9VRel/)   ! relative wind speed
   INTEGER,  PARAMETER          :: TwNDynP(9) = (/TwN1DynP,TwN2DynP,TwN3DynP,TwN4DynP,TwN5DynP,TwN6DynP,TwN7DynP,TwN8DynP,TwN9DynP/)   ! dynamic pressure
   INTEGER,  PARAMETER          :: TwNRe(9)   = (/TwN1Re,TwN2Re,TwN3Re,TwN4Re,TwN5Re,TwN6Re,TwN7Re,TwN8Re,TwN9Re/)                     ! Reynolds number
   INTEGER,  PARAMETER          :: TwNM(9)    = (/TwN1M,TwN2M,TwN3M,TwN4M,TwN5M,TwN6M,TwN7M,TwN8M,TwN9M/)                              ! Mach number
   INTEGER,  PARAMETER          :: TwNFdx(9)  = (/TwN1Fdx,TwN2Fdx,TwN3Fdx,TwN4Fdx,TwN5Fdx,TwN6Fdx,TwN7Fdx,TwN8Fdx,TwN9Fdx/)            ! x-component drag force per unit length   
   INTEGER,  PARAMETER          :: TwNFdy(9)  = (/TwN1Fdy,TwN2Fdy,TwN3Fdy,TwN4Fdy,TwN5Fdy,TwN6Fdy,TwN7Fdy,TwN8Fdy,TwN9Fdy/)            ! y-component drag force per unit length
   INTEGER,  PARAMETER          :: BAzimuth(3) = (/B1Azimuth,B2Azimuth,B3Azimuth/)                                                     ! azimuth angle 
   INTEGER,  PARAMETER          :: BPitch(3)   = (/B1Pitch,  B2Pitch,  B3Pitch/)                                                       ! pitch 
   
  INTEGER,  PARAMETER          :: BAeroFx(4)  = (/B1AeroFx,  B2AeroFx,  B3AeroFx, B4AeroFx/)                                                   ! x-component of total blade root aero force
  INTEGER,  PARAMETER          :: BAeroFy(4)  = (/B1AeroFy,  B2AeroFy,  B3AeroFy, B4AeroFy/)                                                   ! y-component of total blade root aero force 
  INTEGER,  PARAMETER          :: BAeroFz(4)  = (/B1AeroFz,  B2AeroFz,  B3AeroFz, B4AeroFz/)                                                   ! z-component of total blade root aero force 
  INTEGER,  PARAMETER          :: BAeroMx(4)  = (/B1AeroMx,  B2AeroMx,  B3AeroMx, B4AeroMx/)                                                   ! x-component of total blade root aero moment
  INTEGER,  PARAMETER          :: BAeroMy(4)  = (/B1AeroMy,  B2AeroMy,  B3AeroMy, B4AeroMy/)                                                   ! y-component of total blade root aero moment
  INTEGER,  PARAMETER          :: BAeroMz(4)  = (/B1AeroMz,  B2AeroMz,  B3AeroMz, B4AeroMz/)                                                   ! z-component of total blade root aero moment 
  INTEGER,  PARAMETER          :: BAeroPwr(4) = (/B1AeroPwr,  B2AeroPwr,  B3AeroPwr, B4AeroPwr/)                                               ! Blade contribution to power
  INTEGER,  PARAMETER          :: BAeroFxg(4)  = (/B1AeroFxg,  B2AeroFxg,  B3AeroFxg, B4AeroFxg/)                                              ! x-component of total blade root aero force in global
  INTEGER,  PARAMETER          :: BAeroFyg(4)  = (/B1AeroFyg,  B2AeroFyg,  B3AeroFyg, B4AeroFyg/)                                              ! y-component of total blade root aero force in global
  INTEGER,  PARAMETER          :: BAeroFzg(4)  = (/B1AeroFzg,  B2AeroFzg,  B3AeroFzg, B4AeroFzg/)                                              ! z-component of total blade root aero force in global
  INTEGER,  PARAMETER          :: BAeroMxg(4)  = (/B1AeroMxg,  B2AeroMxg,  B3AeroMxg, B4AeroMxg/)                                              ! x-component of total blade root aero moment wrt hub in global
  INTEGER,  PARAMETER          :: BAeroMyg(4)  = (/B1AeroMyg,  B2AeroMyg,  B3AeroMyg, B4AeroMyg/)                                              ! y-component of total blade root aero moment wrt hub in global
  INTEGER,  PARAMETER          :: BAeroMzg(4)  = (/B1AeroMzg,  B2AeroMzg,  B3AeroMzg, B4AeroMzg/)                                              ! z-component of total blade root aero moment wrt hub in global
   
   INTEGER,  PARAMETER          :: BNVUndx(9, 3) = RESHAPE( (/ &      ! undisturbed wind velocity (x component)
                                     B1N1VUndx,B1N2VUndx,B1N3VUndx,B1N4VUndx,B1N5VUndx,B1N6VUndx,B1N7VUndx,B1N8VUndx,B1N9VUndx, &
                                     B2N1VUndx,B2N2VUndx,B2N3VUndx,B2N4VUndx,B2N5VUndx,B2N6VUndx,B2N7VUndx,B2N8VUndx,B2N9VUndx, &
                                     B3N1VUndx,B3N2VUndx,B3N3VUndx,B3N4VUndx,B3N5VUndx,B3N6VUndx,B3N7VUndx,B3N8VUndx,B3N9VUndx  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNVUndy(9, 3) = RESHAPE( (/ &      ! undisturbed wind velocity (y component)
                                     B1N1VUndy,B1N2VUndy,B1N3VUndy,B1N4VUndy,B1N5VUndy,B1N6VUndy,B1N7VUndy,B1N8VUndy,B1N9VUndy, &
                                     B2N1VUndy,B2N2VUndy,B2N3VUndy,B2N4VUndy,B2N5VUndy,B2N6VUndy,B2N7VUndy,B2N8VUndy,B2N9VUndy, &
                                     B3N1VUndy,B3N2VUndy,B3N3VUndy,B3N4VUndy,B3N5VUndy,B3N6VUndy,B3N7VUndy,B3N8VUndy,B3N9VUndy  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNVUndz(9, 3) = RESHAPE( (/ &      ! undisturbed wind velocity (z component)
                                     B1N1VUndz,B1N2VUndz,B1N3VUndz,B1N4VUndz,B1N5VUndz,B1N6VUndz,B1N7VUndz,B1N8VUndz,B1N9VUndz, &
                                     B2N1VUndz,B2N2VUndz,B2N3VUndz,B2N4VUndz,B2N5VUndz,B2N6VUndz,B2N7VUndz,B2N8VUndz,B2N9VUndz, &
                                     B3N1VUndz,B3N2VUndz,B3N3VUndz,B3N4VUndz,B3N5VUndz,B3N6VUndz,B3N7VUndz,B3N8VUndz,B3N9VUndz  &
                                   /), (/9, 3/) )
    
   INTEGER,  PARAMETER          :: BNVDisx(9, 3) = RESHAPE( (/ &     ! disturbed wind velocity (x component)
                                     B1N1VDisx,B1N2VDisx,B1N3VDisx,B1N4VDisx,B1N5VDisx,B1N6VDisx,B1N7VDisx,B1N8VDisx,B1N9VDisx, &
                                     B2N1VDisx,B2N2VDisx,B2N3VDisx,B2N4VDisx,B2N5VDisx,B2N6VDisx,B2N7VDisx,B2N8VDisx,B2N9VDisx, &
                                     B3N1VDisx,B3N2VDisx,B3N3VDisx,B3N4VDisx,B3N5VDisx,B3N6VDisx,B3N7VDisx,B3N8VDisx,B3N9VDisx  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNVDisy(9, 3) = RESHAPE( (/ &     ! disturbed wind velocity (y component)
                                     B1N1VDisy,B1N2VDisy,B1N3VDisy,B1N4VDisy,B1N5VDisy,B1N6VDisy,B1N7VDisy,B1N8VDisy,B1N9VDisy, &
                                     B2N1VDisy,B2N2VDisy,B2N3VDisy,B2N4VDisy,B2N5VDisy,B2N6VDisy,B2N7VDisy,B2N8VDisy,B2N9VDisy, &
                                     B3N1VDisy,B3N2VDisy,B3N3VDisy,B3N4VDisy,B3N5VDisy,B3N6VDisy,B3N7VDisy,B3N8VDisy,B3N9VDisy  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNVDisz(9, 3) = RESHAPE( (/ &     ! disturbed wind velocity (z component)
                                     B1N1VDisz,B1N2VDisz,B1N3VDisz,B1N4VDisz,B1N5VDisz,B1N6VDisz,B1N7VDisz,B1N8VDisz,B1N9VDisz, &
                                     B2N1VDisz,B2N2VDisz,B2N3VDisz,B2N4VDisz,B2N5VDisz,B2N6VDisz,B2N7VDisz,B2N8VDisz,B2N9VDisz, &
                                     B3N1VDisz,B3N2VDisz,B3N3VDisz,B3N4VDisz,B3N5VDisz,B3N6VDisz,B3N7VDisz,B3N8VDisz,B3N9VDisz  &
                                   /), (/9, 3/) )
   
   INTEGER,  PARAMETER          :: BNSTVx(9, 3) = RESHAPE( (/ &      ! structural translational velocity (x component)
                                     B1N1STVx,B1N2STVx,B1N3STVx,B1N4STVx,B1N5STVx,B1N6STVx,B1N7STVx,B1N8STVx,B1N9STVx, &
                                     B2N1STVx,B2N2STVx,B2N3STVx,B2N4STVx,B2N5STVx,B2N6STVx,B2N7STVx,B2N8STVx,B2N9STVx, &
                                     B3N1STVx,B3N2STVx,B3N3STVx,B3N4STVx,B3N5STVx,B3N6STVx,B3N7STVx,B3N8STVx,B3N9STVx  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNSTVy(9, 3) = RESHAPE( (/ &      ! structural translational velocity (y component)
                                     B1N1STVy,B1N2STVy,B1N3STVy,B1N4STVy,B1N5STVy,B1N6STVy,B1N7STVy,B1N8STVy,B1N9STVy, &
                                     B2N1STVy,B2N2STVy,B2N3STVy,B2N4STVy,B2N5STVy,B2N6STVy,B2N7STVy,B2N8STVy,B2N9STVy, &
                                     B3N1STVy,B3N2STVy,B3N3STVy,B3N4STVy,B3N5STVy,B3N6STVy,B3N7STVy,B3N8STVy,B3N9STVy  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNSTVz(9, 3) = RESHAPE( (/ &      ! structural translational velocity (z component)
                                     B1N1STVz,B1N2STVz,B1N3STVz,B1N4STVz,B1N5STVz,B1N6STVz,B1N7STVz,B1N8STVz,B1N9STVz, &
                                     B2N1STVz,B2N2STVz,B2N3STVz,B2N4STVz,B2N5STVz,B2N6STVz,B2N7STVz,B2N8STVz,B2N9STVz, &
                                     B3N1STVz,B3N2STVz,B3N3STVz,B3N4STVz,B3N5STVz,B3N6STVz,B3N7STVz,B3N8STVz,B3N9STVz  &
                                   /), (/9, 3/) )
   
   INTEGER,  PARAMETER          :: BNVRel(9, 3) = RESHAPE( (/ &      ! relative wind speed
                                     B1N1VRel,B1N2VRel,B1N3VRel,B1N4VRel,B1N5VRel,B1N6VRel,B1N7VRel,B1N8VRel,B1N9VRel, &
                                     B2N1VRel,B2N2VRel,B2N3VRel,B2N4VRel,B2N5VRel,B2N6VRel,B2N7VRel,B2N8VRel,B2N9VRel, &
                                     B3N1VRel,B3N2VRel,B3N3VRel,B3N4VRel,B3N5VRel,B3N6VRel,B3N7VRel,B3N8VRel,B3N9VRel  &
                                   /), (/9, 3/) )
   
   INTEGER,  PARAMETER          :: BNDynP(9, 3) = RESHAPE( (/ &      ! dynamic pressure
                                     B1N1DynP,B1N2DynP,B1N3DynP,B1N4DynP,B1N5DynP,B1N6DynP,B1N7DynP,B1N8DynP,B1N9DynP, &
                                     B2N1DynP,B2N2DynP,B2N3DynP,B2N4DynP,B2N5DynP,B2N6DynP,B2N7DynP,B2N8DynP,B2N9DynP, &
                                     B3N1DynP,B3N2DynP,B3N3DynP,B3N4DynP,B3N5DynP,B3N6DynP,B3N7DynP,B3N8DynP,B3N9DynP  &
                                   /), (/9, 3/) )
   
   INTEGER,  PARAMETER          :: BNRe(9, 3) = RESHAPE( (/ &        ! Reynolds number
                                     B1N1Re,B1N2Re,B1N3Re,B1N4Re,B1N5Re,B1N6Re,B1N7Re,B1N8Re,B1N9Re, &
                                     B2N1Re,B2N2Re,B2N3Re,B2N4Re,B2N5Re,B2N6Re,B2N7Re,B2N8Re,B2N9Re, &
                                     B3N1Re,B3N2Re,B3N3Re,B3N4Re,B3N5Re,B3N6Re,B3N7Re,B3N8Re,B3N9Re  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNM(9, 3) = RESHAPE( (/ &         ! Mach number
                                     B1N1M,B1N2M,B1N3M,B1N4M,B1N5M,B1N6M,B1N7M,B1N8M,B1N9M, &
                                     B2N1M,B2N2M,B2N3M,B2N4M,B2N5M,B2N6M,B2N7M,B2N8M,B2N9M, &
                                     B3N1M,B3N2M,B3N3M,B3N4M,B3N5M,B3N6M,B3N7M,B3N8M,B3N9M  &
                                   /), (/9, 3/) )
   INTEGER,  PARAMETER          :: BNVIndx(9, 3) = RESHAPE( (/ &     ! axial induced wind velocity
                                     B1N1VIndx,B1N2VIndx,B1N3VIndx,B1N4VIndx,B1N5VIndx,B1N6VIndx,B1N7VIndx,B1N8VIndx,B1N9VIndx, &
                                     B2N1VIndx,B2N2VIndx,B2N3VIndx,B2N4VIndx,B2N5VIndx,B2N6VIndx,B2N7VIndx,B2N8VIndx,B2N9VIndx, &
                                     B3N1VIndx,B3N2VIndx,B3N3VIndx,B3N4VIndx,B3N5VIndx,B3N6VIndx,B3N7VIndx,B3N8VIndx,B3N9VIndx  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNVIndy(9, 3) = RESHAPE( (/ &     ! tangential induced wind velocity
                                     B1N1VIndy,B1N2VIndy,B1N3VIndy,B1N4VIndy,B1N5VIndy,B1N6VIndy,B1N7VIndy,B1N8VIndy,B1N9VIndy, &
                                     B2N1VIndy,B2N2VIndy,B2N3VIndy,B2N4VIndy,B2N5VIndy,B2N6VIndy,B2N7VIndy,B2N8VIndy,B2N9VIndy, &
                                     B3N1VIndy,B3N2VIndy,B3N3VIndy,B3N4VIndy,B3N5VIndy,B3N6VIndy,B3N7VIndy,B3N8VIndy,B3N9VIndy  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNAxInd(9, 3) = RESHAPE( (/ &     ! axial induction factor
                                     B1N1AxInd,B1N2AxInd,B1N3AxInd,B1N4AxInd,B1N5AxInd,B1N6AxInd,B1N7AxInd,B1N8AxInd,B1N9AxInd, &
                                     B2N1AxInd,B2N2AxInd,B2N3AxInd,B2N4AxInd,B2N5AxInd,B2N6AxInd,B2N7AxInd,B2N8AxInd,B2N9AxInd, &
                                     B3N1AxInd,B3N2AxInd,B3N3AxInd,B3N4AxInd,B3N5AxInd,B3N6AxInd,B3N7AxInd,B3N8AxInd,B3N9AxInd  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNTnInd(9, 3) = RESHAPE( (/ &     ! tangential induction factor
                                     B1N1TnInd,B1N2TnInd,B1N3TnInd,B1N4TnInd,B1N5TnInd,B1N6TnInd,B1N7TnInd,B1N8TnInd,B1N9TnInd, &
                                     B2N1TnInd,B2N2TnInd,B2N3TnInd,B2N4TnInd,B2N5TnInd,B2N6TnInd,B2N7TnInd,B2N8TnInd,B2N9TnInd, &
                                     B3N1TnInd,B3N2TnInd,B3N3TnInd,B3N4TnInd,B3N5TnInd,B3N6TnInd,B3N7TnInd,B3N8TnInd,B3N9TnInd  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNAlpha(9, 3) = RESHAPE( (/ &     ! angle of attach
                                     B1N1Alpha,B1N2Alpha,B1N3Alpha,B1N4Alpha,B1N5Alpha,B1N6Alpha,B1N7Alpha,B1N8Alpha,B1N9Alpha, &
                                     B2N1Alpha,B2N2Alpha,B2N3Alpha,B2N4Alpha,B2N5Alpha,B2N6Alpha,B2N7Alpha,B2N8Alpha,B2N9Alpha, &
                                     B3N1Alpha,B3N2Alpha,B3N3Alpha,B3N4Alpha,B3N5Alpha,B3N6Alpha,B3N7Alpha,B3N8Alpha,B3N9Alpha  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNTheta(9, 3) = RESHAPE( (/ &     ! pitch+twist angle
                                     B1N1Theta,B1N2Theta,B1N3Theta,B1N4Theta,B1N5Theta,B1N6Theta,B1N7Theta,B1N8Theta,B1N9Theta, &
                                     B2N1Theta,B2N2Theta,B2N3Theta,B2N4Theta,B2N5Theta,B2N6Theta,B2N7Theta,B2N8Theta,B2N9Theta, &
                                     B3N1Theta,B3N2Theta,B3N3Theta,B3N4Theta,B3N5Theta,B3N6Theta,B3N7Theta,B3N8Theta,B3N9Theta  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNPhi(9, 3) = RESHAPE( (/ &      ! inflow angle
                                     B1N1Phi,B1N2Phi,B1N3Phi,B1N4Phi,B1N5Phi,B1N6Phi,B1N7Phi,B1N8Phi,B1N9Phi, &
                                     B2N1Phi,B2N2Phi,B2N3Phi,B2N4Phi,B2N5Phi,B2N6Phi,B2N7Phi,B2N8Phi,B2N9Phi, &
                                     B3N1Phi,B3N2Phi,B3N3Phi,B3N4Phi,B3N5Phi,B3N6Phi,B3N7Phi,B3N8Phi,B3N9Phi  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCurve(9, 3) = RESHAPE( (/ &    ! curvature angle
                                     B1N1Curve,B1N2Curve,B1N3Curve,B1N4Curve,B1N5Curve,B1N6Curve,B1N7Curve,B1N8Curve,B1N9Curve, &
                                     B2N1Curve,B2N2Curve,B2N3Curve,B2N4Curve,B2N5Curve,B2N6Curve,B2N7Curve,B2N8Curve,B2N9Curve, &
                                     B3N1Curve,B3N2Curve,B3N3Curve,B3N4Curve,B3N5Curve,B3N6Curve,B3N7Curve,B3N8Curve,B3N9Curve  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCl(9, 3) = RESHAPE( (/ &    ! lift force coefficient
                                     B1N1Cl,B1N2Cl,B1N3Cl,B1N4Cl,B1N5Cl,B1N6Cl,B1N7Cl,B1N8Cl,B1N9Cl, &
                                     B2N1Cl,B2N2Cl,B2N3Cl,B2N4Cl,B2N5Cl,B2N6Cl,B2N7Cl,B2N8Cl,B2N9Cl, &
                                     B3N1Cl,B3N2Cl,B3N3Cl,B3N4Cl,B3N5Cl,B3N6Cl,B3N7Cl,B3N8Cl,B3N9Cl  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCd(9, 3) = RESHAPE( (/ &    ! drag force coefficient
                                     B1N1Cd,B1N2Cd,B1N3Cd,B1N4Cd,B1N5Cd,B1N6Cd,B1N7Cd,B1N8Cd,B1N9Cd, &
                                     B2N1Cd,B2N2Cd,B2N3Cd,B2N4Cd,B2N5Cd,B2N6Cd,B2N7Cd,B2N8Cd,B2N9Cd, &
                                     B3N1Cd,B3N2Cd,B3N3Cd,B3N4Cd,B3N5Cd,B3N6Cd,B3N7Cd,B3N8Cd,B3N9Cd  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCm(9, 3) = RESHAPE( (/ &    ! pitching moment coefficient
                                     B1N1Cm,B1N2Cm,B1N3Cm,B1N4Cm,B1N5Cm,B1N6Cm,B1N7Cm,B1N8Cm,B1N9Cm, &
                                     B2N1Cm,B2N2Cm,B2N3Cm,B2N4Cm,B2N5Cm,B2N6Cm,B2N7Cm,B2N8Cm,B2N9Cm, &
                                     B3N1Cm,B3N2Cm,B3N3Cm,B3N4Cm,B3N5Cm,B3N6Cm,B3N7Cm,B3N8Cm,B3N9Cm  &
                                   /), (/9, 3/) )
    
    INTEGER,  PARAMETER          :: BNCpmin(9, 3) = RESHAPE( (/ &    ! pressure coefficient
                                     B1N1Cpmin,B1N2Cpmin,B1N3Cpmin,B1N4Cpmin,B1N5Cpmin,B1N6Cpmin,B1N7Cpmin,B1N8Cpmin,B1N9Cpmin, &
                                     B2N1Cpmin,B2N2Cpmin,B2N3Cpmin,B2N4Cpmin,B2N5Cpmin,B2N6Cpmin,B2N7Cpmin,B2N8Cpmin,B2N9Cpmin, &
                                     B3N1Cpmin,B3N2Cpmin,B3N3Cpmin,B3N4Cpmin,B3N5Cpmin,B3N6Cpmin,B3N7Cpmin,B3N8Cpmin,B3N9Cpmin  &
                                   /), (/9, 3/) )  
                                     
    INTEGER,  PARAMETER          :: BNSigCr(9, 3) = RESHAPE( (/ &    ! Critical cavitation number
                                     B1N1SigCr,B1N2SigCr,B1N3SigCr,B1N4SigCr,B1N5SigCr,B1N6SigCr,B1N7SigCr,B1N8SigCr,B1N9SigCr, &
                                     B2N1SigCr,B2N2SigCr,B2N3SigCr,B2N4SigCr,B2N5SigCr,B2N6SigCr,B2N7SigCr,B2N8SigCr,B2N9SigCr, &
                                     B3N1SigCr,B3N2SigCr,B3N3SigCr,B3N4SigCr,B3N5SigCr,B3N6SigCr,B3N7SigCr,B3N8SigCr,B3N9SigCr  &
                                   /), (/9, 3/) )   
                                     
    INTEGER,  PARAMETER          :: BNSgCav(9, 3) = RESHAPE( (/ &    !  Cavitation number
                                     B1N1SgCav,B1N2SgCav,B1N3SgCav,B1N4SgCav,B1N5SgCav,B1N6SgCav,B1N7SgCav,B1N8SgCav,B1N9SgCav, &
                                     B2N1SgCav,B2N2SgCav,B2N3SgCav,B2N4SgCav,B2N5SgCav,B2N6SgCav,B2N7SgCav,B2N8SgCav,B2N9SgCav, &
                                     B3N1SgCav,B3N2SgCav,B3N3SgCav,B3N4SgCav,B3N5SgCav,B3N6SgCav,B3N7SgCav,B3N8SgCav,B3N9SgCav  &
                                   /), (/9, 3/) )   
   
    INTEGER,  PARAMETER          :: BNCx(9, 3) = RESHAPE( (/ &    ! normal force (to plane) coefficient
                                     B1N1Cx,B1N2Cx,B1N3Cx,B1N4Cx,B1N5Cx,B1N6Cx,B1N7Cx,B1N8Cx,B1N9Cx, &
                                     B2N1Cx,B2N2Cx,B2N3Cx,B2N4Cx,B2N5Cx,B2N6Cx,B2N7Cx,B2N8Cx,B2N9Cx, &
                                     B3N1Cx,B3N2Cx,B3N3Cx,B3N4Cx,B3N5Cx,B3N6Cx,B3N7Cx,B3N8Cx,B3N9Cx  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCy(9, 3) = RESHAPE( (/ &    ! tangential force (to plane) coefficient
                                     B1N1Cy,B1N2Cy,B1N3Cy,B1N4Cy,B1N5Cy,B1N6Cy,B1N7Cy,B1N8Cy,B1N9Cy, &
                                     B2N1Cy,B2N2Cy,B2N3Cy,B2N4Cy,B2N5Cy,B2N6Cy,B2N7Cy,B2N8Cy,B2N9Cy, &
                                     B3N1Cy,B3N2Cy,B3N3Cy,B3N4Cy,B3N5Cy,B3N6Cy,B3N7Cy,B3N8Cy,B3N9Cy  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCn(9, 3) = RESHAPE( (/ &    ! normal force (to chord) coefficient
                                     B1N1Cn,B1N2Cn,B1N3Cn,B1N4Cn,B1N5Cn,B1N6Cn,B1N7Cn,B1N8Cn,B1N9Cn, &
                                     B2N1Cn,B2N2Cn,B2N3Cn,B2N4Cn,B2N5Cn,B2N6Cn,B2N7Cn,B2N8Cn,B2N9Cn, &
                                     B3N1Cn,B3N2Cn,B3N3Cn,B3N4Cn,B3N5Cn,B3N6Cn,B3N7Cn,B3N8Cn,B3N9Cn  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNCt(9, 3) = RESHAPE( (/ &    ! tangential force (to chord) coefficient
                                     B1N1Ct,B1N2Ct,B1N3Ct,B1N4Ct,B1N5Ct,B1N6Ct,B1N7Ct,B1N8Ct,B1N9Ct, &
                                     B2N1Ct,B2N2Ct,B2N3Ct,B2N4Ct,B2N5Ct,B2N6Ct,B2N7Ct,B2N8Ct,B2N9Ct, &
                                     B3N1Ct,B3N2Ct,B3N3Ct,B3N4Ct,B3N5Ct,B3N6Ct,B3N7Ct,B3N8Ct,B3N9Ct  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFl(9, 3) = RESHAPE( (/ &    ! lift force per unit length
                                     B1N1Fl,B1N2Fl,B1N3Fl,B1N4Fl,B1N5Fl,B1N6Fl,B1N7Fl,B1N8Fl,B1N9Fl, &
                                     B2N1Fl,B2N2Fl,B2N3Fl,B2N4Fl,B2N5Fl,B2N6Fl,B2N7Fl,B2N8Fl,B2N9Fl, &
                                     B3N1Fl,B3N2Fl,B3N3Fl,B3N4Fl,B3N5Fl,B3N6Fl,B3N7Fl,B3N8Fl,B3N9Fl  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFd(9, 3) = RESHAPE( (/ &    ! drag force per unit length
                                     B1N1Fd,B1N2Fd,B1N3Fd,B1N4Fd,B1N5Fd,B1N6Fd,B1N7Fd,B1N8Fd,B1N9Fd, &
                                     B2N1Fd,B2N2Fd,B2N3Fd,B2N4Fd,B2N5Fd,B2N6Fd,B2N7Fd,B2N8Fd,B2N9Fd, &
                                     B3N1Fd,B3N2Fd,B3N3Fd,B3N4Fd,B3N5Fd,B3N6Fd,B3N7Fd,B3N8Fd,B3N9Fd  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNMm(9, 3) = RESHAPE( (/ &    ! pitching moment per unit length
                                     B1N1Mm,B1N2Mm,B1N3Mm,B1N4Mm,B1N5Mm,B1N6Mm,B1N7Mm,B1N8Mm,B1N9Mm, &
                                     B2N1Mm,B2N2Mm,B2N3Mm,B2N4Mm,B2N5Mm,B2N6Mm,B2N7Mm,B2N8Mm,B2N9Mm, &
                                     B3N1Mm,B3N2Mm,B3N3Mm,B3N4Mm,B3N5Mm,B3N6Mm,B3N7Mm,B3N8Mm,B3N9Mm  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFx(9, 3) = RESHAPE( (/ &    ! normal force (to plane) per unit length
                                     B1N1Fx,B1N2Fx,B1N3Fx,B1N4Fx,B1N5Fx,B1N6Fx,B1N7Fx,B1N8Fx,B1N9Fx, &
                                     B2N1Fx,B2N2Fx,B2N3Fx,B2N4Fx,B2N5Fx,B2N6Fx,B2N7Fx,B2N8Fx,B2N9Fx, &
                                     B3N1Fx,B3N2Fx,B3N3Fx,B3N4Fx,B3N5Fx,B3N6Fx,B3N7Fx,B3N8Fx,B3N9Fx  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFy(9, 3) = RESHAPE( (/ &    ! tangential force (to plane) per unit length
                                     B1N1Fy,B1N2Fy,B1N3Fy,B1N4Fy,B1N5Fy,B1N6Fy,B1N7Fy,B1N8Fy,B1N9Fy, &
                                     B2N1Fy,B2N2Fy,B2N3Fy,B2N4Fy,B2N5Fy,B2N6Fy,B2N7Fy,B2N8Fy,B2N9Fy, &
                                     B3N1Fy,B3N2Fy,B3N3Fy,B3N4Fy,B3N5Fy,B3N6Fy,B3N7Fy,B3N8Fy,B3N9Fy  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFn(9, 3) = RESHAPE( (/ &    ! normal force (to chord) per unit length
                                     B1N1Fn,B1N2Fn,B1N3Fn,B1N4Fn,B1N5Fn,B1N6Fn,B1N7Fn,B1N8Fn,B1N9Fn, &
                                     B2N1Fn,B2N2Fn,B2N3Fn,B2N4Fn,B2N5Fn,B2N6Fn,B2N7Fn,B2N8Fn,B2N9Fn, &
                                     B3N1Fn,B3N2Fn,B3N3Fn,B3N4Fn,B3N5Fn,B3N6Fn,B3N7Fn,B3N8Fn,B3N9Fn  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNFt(9, 3) = RESHAPE( (/ &    ! tangential force (to chord) per unit length
                                     B1N1Ft,B1N2Ft,B1N3Ft,B1N4Ft,B1N5Ft,B1N6Ft,B1N7Ft,B1N8Ft,B1N9Ft, &
                                     B2N1Ft,B2N2Ft,B2N3Ft,B2N4Ft,B2N5Ft,B2N6Ft,B2N7Ft,B2N8Ft,B2N9Ft, &
                                     B3N1Ft,B3N2Ft,B3N3Ft,B3N4Ft,B3N5Ft,B3N6Ft,B3N7Ft,B3N8Ft,B3N9Ft  &
                                   /), (/9, 3/) )
    INTEGER,  PARAMETER          :: BNClrnc(9, 3) = RESHAPE( (/ &    ! tower clearance
                                     B1N1Clrnc,B1N2Clrnc,B1N3Clrnc,B1N4Clrnc,B1N5Clrnc,B1N6Clrnc,B1N7Clrnc,B1N8Clrnc,B1N9Clrnc, &
                                     B2N1Clrnc,B2N2Clrnc,B2N3Clrnc,B2N4Clrnc,B2N5Clrnc,B2N6Clrnc,B2N7Clrnc,B2N8Clrnc,B2N9Clrnc, &
                                     B3N1Clrnc,B3N2Clrnc,B3N3Clrnc,B3N4Clrnc,B3N5Clrnc,B3N6Clrnc,B3N7Clrnc,B3N8Clrnc,B3N9Clrnc  &
                                   /), (/9, 3/) )
   INTEGER, PARAMETER            :: BNGam(9,3) = RESHAPE( (/ &    ! Vorticity gamma
                                       B1N1Gam,B1N2Gam,B1N3Gam,B1N4Gam,B1N5Gam,B1N6Gam,B1N7Gam,B1N8Gam,B1N9Gam,   &
                                       B2N1Gam,B2N2Gam,B2N3Gam,B2N4Gam,B2N5Gam,B2N6Gam,B2N7Gam,B2N8Gam,B2N9Gam,   &
                                       B3N1Gam,B3N2Gam,B3N3Gam,B3N4Gam,B3N5Gam,B3N6Gam,B3N7Gam,B3N8Gam,B3N9Gam    &
                                    /), (/9,3/) )
 
   
   INTEGER(IntKi), PARAMETER        :: MaxBl    =  3                                   ! Maximum number of blades allowed in simulation
   
     
contains
   
!> Compute maximum radius over all blades (contains hub radius), in "projected rotor plane"
!! Solely based on AD inputs,  needed for FVW since rLocal is not stored
PURE REAL(ReKi) FUNCTION Calc_MaxRadius(p, u) result(rmax)
   implicit none
   TYPE(RotParameterType),    INTENT(IN   ) :: p    !< The module parameters
   TYPE(RotInputType),        INTENT(IN   ) :: u    !< Inputs
   real(ReKi)     :: y_hat_disk(3), z_hat_disk(3), dr_gl(3), rLocal
   integer(IntKi) :: iB, j
   y_hat_disk = u%HubMotion%Orientation(2,:,1)
   z_hat_disk = u%HubMotion%Orientation(3,:,1)
   rmax = 0.0_ReKi
   do iB=1,p%numBlades
      do j=1,p%NumBlNds
         dr_gl =  u%BladeMotion(iB)%Position(:,j) - u%HubMotion%Position(:,1) ! vector hub center to node j in global coord
         rLocal = sqrt( dot_product(dr_gl, y_hat_disk)**2 + dot_product(dr_gl, z_hat_disk)**2 )
         rmax   = max(rmax, rLocal)
      end do !j=nodes
   end do !iB=blades
END FUNCTION Calc_MaxRadius

!> Rotor speed
PURE REAL(ReKi) FUNCTION Calc_Omega(u)
   TYPE(RotInputType),        INTENT(IN   ) :: u    !< Inputs
   Calc_Omega = dot_product(u%HubMotion%RotationVel(:,1), u%HubMotion%Orientation(1,:,1))
END FUNCTION Calc_Omega

!> Mean skew angle
REAL(ReKi) FUNCTION Calc_Chi0(V_diskAvg, V_dot_x)
   implicit none
   REAL(ReKi), INTENT(IN  ) :: V_diskAvg(3)
   REAL(ReKi), INTENT(IN  ) :: V_dot_x
   REAL(ReKi) :: V_norm, sy 
   V_norm = TwoNorm( V_diskAvg )
   if ( EqualRealNos( V_norm, 0.0_ReKi ) ) then
      Calc_Chi0 = 0.0_ReKi
   else
      ! make sure we don't have numerical issues that make the ratio outside +/-1
      sy = min(  1.0_ReKi, V_dot_x / V_norm )
      sy = max( -1.0_ReKi, sy )
      Calc_Chi0 = acos( sy )
   end if
END FUNCTION Calc_Chi0


!----------------------------------------------------------------------------------------------------------------------------------
SUBROUTINE Calc_WriteOutput( p, p_AD, u, m, m_AD, y, OtherState, xd, indx, iRot, ErrStat, ErrMsg )
   
   TYPE(RotParameterType),       INTENT(IN   )  :: p                                 ! The rotor parameters
   TYPE(AD_ParameterType),       INTENT(IN   )  :: p_AD                              ! The module parameters
   TYPE(RotInputType),           INTENT(IN   )  :: u                                 ! inputs
   TYPE(RotMiscVarType),         INTENT(INOUT)  :: m                                 ! misc variables
   TYPE(AD_MiscVarType),         INTENT(INOUT)  :: m_AD                              ! misc variables
   TYPE(RotOutputType),          INTENT(IN   )  :: y                                 ! outputs
   TYPE(RotOtherStateType),      INTENT(IN   )  :: OtherState                        ! other states at t (for DBEMT and UA)
   TYPE(RotDiscreteStateType),   INTENT(IN   )  :: xd                                ! Discrete states
   integer,                      intent(in   )  :: indx                              ! index into m%BEMT_u(indx) array; 1=t and 2=t+dt (but not checked here)
   integer,                      intent(in   )  :: iRot                              ! Rotor index, needed for FVW
   INTEGER(IntKi),               INTENT(  OUT)  :: ErrStat                           ! The error status code
   CHARACTER(*),                 INTENT(  OUT)  :: ErrMsg                            ! The error message, if an error occurred

      ! local variables
   CHARACTER(*), PARAMETER                      :: RoutineName = 'Calc_WriteOutput'
   INTEGER(intKi)                               :: ErrStat2
   CHARACTER(ErrMsgLen)                         :: ErrMsg2
   
   INTEGER(IntKi)                               :: j,k,beta
   REAL(ReKi)                                   :: tmp(3)
   REAL(ReKi)                                   :: force(3)
   REAL(ReKi)                                   :: moment(3)
   REAL(ReKi)                                   :: denom, rmax, omega
   REAL(ReKi)                                   :: ct, st ! cosine, sine of theta
   REAL(ReKi)                                   :: cp, sp ! cosine, sine of phi
      
   
      ! start routine:
   ErrStat = ErrID_None
   ErrMsg  = ""
   

   ! Compute max radius and rotor speed
   if (p_AD%WakeMod /= WakeMod_FVW) then
      rmax = 0.0_ReKi
      do k=1,p%NumBlades
         do j=1,p%NumBlNds
            rmax = max(rmax, m%BEMT_u(indx)%rLocal(j,k) )
         end do !j=nodes
      end do !k=blades
      
!     rmax  = p%BEMT%rTipFixMax
      omega = m%BEMT_u(indx)%omega
   else
      rmax  = Calc_MaxRadius(p, u)
      omega = Calc_Omega(u)
   endif

   
   call Calc_WriteOutput_AD() ! need to call this before calling the BEMT vs FVW versions of outputs so that the integrated output quantities are known
   
   if (p_AD%WakeMod /= WakeMod_FVW) then
      call Calc_WriteOutput_BEMT()
   else
      call Calc_WriteOutput_FVW()
   endif

      ! set these for debugging
!   m%AllOuts( Debug1 ) = 0.0_ReKi !TwoNorm( m%BEMT%u_SkewWake(1)%v_qsw )
!   m%AllOuts( Debug2 ) = 0.0_ReKi !TwoNorm( x%BEMT%v_w )
!   m%AllOuts( Debug3 ) = 0.0_ReKi
   
CONTAINS
   !..........................................................................................
   subroutine Calc_WriteOutput_AD()
   
         ! tower outputs
      do beta=1,p%NTwOuts
         j = p%TwOutNd(beta)
      
         tmp = matmul( u%TowerMotion%Orientation(:,:,j) , u%InflowOnTower(:,j) )
         m%AllOuts( TwNVUnd(:,beta) ) = tmp
      
         tmp = matmul( u%TowerMotion%Orientation(:,:,j) , u%TowerMotion%TranslationVel(:,j) )
         m%AllOuts( TwNSTV(:,beta) ) = tmp
      
         m%AllOuts( TwNVrel(beta) ) = m%W_Twr(j)                           ! relative velocity   
         m%AllOuts( TwNDynP(beta) ) = 0.5 * p%AirDens * m%W_Twr(j)**2      ! dynamic pressure
         m%AllOuts( TwNRe(  beta) ) = p%TwrDiam(j) * m%W_Twr(j) / p%KinVisc / 1.0E6 ! reynolds number (in millions)
         m%AllOuts( TwNM(   beta) ) = m%W_Twr(j) / p%SpdSound               ! Mach number
         m%AllOuts( TwNFdx( beta) ) = m%X_Twr(j)         
         m%AllOuts( TwNFdy( beta) ) = m%Y_Twr(j)         
      
      end do ! out nodes


         ! blade outputs
      do k=1,min(p%numBlades,3)   ! limit this
         do beta=1,p%NBlOuts
            j=p%BlOutNd(beta)

            tmp = matmul( m%WithoutSweepPitchTwist(:,:,j,k), u%InflowOnBlade(:,j,k) )
            m%AllOuts( BNVUndx(beta,k) ) = tmp(1)
            m%AllOuts( BNVUndy(beta,k) ) = tmp(2)
            m%AllOuts( BNVUndz(beta,k) ) = tmp(3)

            tmp = matmul( m%WithoutSweepPitchTwist(:,:,j,k), m%DisturbedInflow(:,j,k) )
            m%AllOuts( BNVDisx(beta,k) ) = tmp(1)
            m%AllOuts( BNVDisy(beta,k) ) = tmp(2)
            m%AllOuts( BNVDisz(beta,k) ) = tmp(3)

            tmp = matmul( m%WithoutSweepPitchTwist(:,:,j,k), u%BladeMotion(k)%TranslationVel(:,j) )
            m%AllOuts( BNSTVx( beta,k) ) = tmp(1)
            m%AllOuts( BNSTVy( beta,k) ) = tmp(2)
            m%AllOuts( BNSTVz( beta,k) ) = tmp(3)
         
            m%AllOuts( BNCurve(beta,k) ) = m%Curve(j,k)*R2D
                  
            m%AllOuts( BNSigCr(   beta,k) ) = m%SigmaCavitCrit(j,k)
            m%AllOuts( BNSgCav(   beta,k) ) = m%SigmaCavit(j,k)

         end do ! nodes
      end do ! blades
   


      ! blade node tower clearance (requires tower influence calculation):
      if (p%TwrPotent /= TwrPotent_none .or. p%TwrShadow /= TwrShadow_none) then
         do k=1,p%numBlades
            do beta=1,p%NBlOuts
               j=p%BlOutNd(beta)
               m%AllOuts( BNClrnc( beta,k) ) = m%TwrClrnc(j,k)
            end do
         end do
      end if

   
   

      m%AllOuts( RtSpeed ) = omega*RPS2RPM
      m%AllOuts( RtArea  ) = pi * rmax**2
      
      tmp = matmul( u%HubMotion%Orientation(:,:,1), m%V_DiskAvg )
      m%AllOuts( RtVAvgxh ) = tmp(1)
      m%AllOuts( RtVAvgyh ) = tmp(2)
      m%AllOuts( RtVAvgzh ) = tmp(3)

      

         ! integrate force/moments over blades by performing mesh transfer to hub point:
      force  = 0.0_ReKi
      moment = 0.0_ReKi
      do k=1,p%NumBlades
         call Transfer_Line2_to_Point( y%BladeLoad(k), m%HubLoad, m%B_L_2_H_P(k), ErrStat2, ErrMsg2, u%BladeMotion(k), u%HubMotion )
         force  = force  + m%HubLoad%force( :,1)
         moment = moment + m%HubLoad%moment(:,1)
         
         if (k<=size(BAeroFxg)) then
            ! Power contribution of blade wrt hub
            tmp = matmul( u%HubMotion%Orientation(:,:,1), m%HubLoad%moment(:,1) )
            m%AllOuts( BAeroPwr(k) ) = omega * tmp(1)
            
            ! In global, wrt hub! 
            m%AllOuts( BAeroFxg(k) ) = m%HubLoad%force(1,1)
            m%AllOuts( BAeroFyg(k) ) = m%HubLoad%force(2,1)
            m%AllOuts( BAeroFzg(k) ) = m%HubLoad%force(3,1)
            m%AllOuts( BAeroMxg(k) ) = m%HubLoad%moment(1,1)
            m%AllOuts( BAeroMyg(k) ) = m%HubLoad%moment(2,1)
            m%AllOuts( BAeroMzg(k) ) = m%HubLoad%moment(3,1)
         end if
      end do

        ! In global
      m%AllOuts( RtAeroFxg ) = force(1)
      m%AllOuts( RtAeroFyg ) = force(2)
      m%AllOuts( RtAeroFzg ) = force(3)
      m%AllOuts( RtAeroMxg ) = moment(1)
      m%AllOuts( RtAeroMyg ) = moment(2)
      m%AllOuts( RtAeroMzg ) = moment(3)
      tmp = matmul( u%HubMotion%Orientation(:,:,1), force )
      m%AllOuts( RtAeroFxh ) = tmp(1)
      m%AllOuts( RtAeroFyh ) = tmp(2)
      m%AllOuts( RtAeroFzh ) = tmp(3)
   
      tmp = matmul( u%HubMotion%Orientation(:,:,1), moment )
      m%AllOuts( RtAeroMxh ) = tmp(1)
      m%AllOuts( RtAeroMyh ) = tmp(2)
      m%AllOuts( RtAeroMzh ) = tmp(3)
      
      m%AllOuts( RtAeroPwr ) = omega * m%AllOuts( RtAeroMxh )
      
     
   
      ! Integrate force/moments over blades by performing mesh transfer to blade root points:
      do k=1,p%NumBlades
         call Transfer_Line2_to_Point( y%BladeLoad(k), m%BladeRootLoad(k), m%B_L_2_R_P(k), ErrStat2, ErrMsg2, u%BladeMotion(k), u%BladeRootMotion(k) )
      end do
      do k=1,min(p%NumBlades,size(BAeroFx))
         ! Transform force vector to blade root coordinate system
         tmp = matmul( u%BladeRootMotion(k)%Orientation(:,:,1), m%BladeRootLoad(k)%force( :,1) )
         m%AllOuts( BAeroFx(k) ) = tmp(1)
         m%AllOuts( BAeroFy(k) ) = tmp(2)
         m%AllOuts( BAeroFz(k) ) = tmp(3)
      
         ! Transform moment vector to blade root coordinate system
         tmp = matmul( u%BladeRootMotion(k)%Orientation(:,:,1), m%BladeRootLoad(k)%moment( :,1) )
         m%AllOuts( BAeroMx(k) ) = tmp(1)
         m%AllOuts( BAeroMy(k) ) = tmp(2)
         m%AllOuts( BAeroMz(k) ) = tmp(3)
      end do  ! k=blades
   
         ! rotor outputs
      if ( EqualRealNos( m%V_dot_x, 0.0_ReKi ) ) then
         m%AllOuts( RtTSR )    = 0.0_ReKi
         m%AllOuts( RtAeroCp ) = 0.0_ReKi
         m%AllOuts( RtAeroCq ) = 0.0_ReKi
         m%AllOuts( RtAeroCt ) = 0.0_ReKi
      else
         m%AllOuts( RtTSR )    = omega * rmax / m%V_dot_x

         denom = 0.5*p%AirDens*m%AllOuts( RtArea )*m%V_dot_x**2
         m%AllOuts( RtAeroCp ) = m%AllOuts( RtAeroPwr ) / (denom * m%V_dot_x)
         m%AllOuts( RtAeroCq ) = m%AllOuts( RtAeroMxh ) / (denom * rmax )
         m%AllOuts( RtAeroCt ) = m%AllOuts( RtAeroFxh ) /  denom
      end if
      
            
   end subroutine Calc_WriteOutput_AD
   !..........................................................................................
   subroutine Calc_WriteOutput_BEMT()
      REAL(R8Ki)                                   :: orient(3,3)
      REAL(R8Ki)                                   :: theta(3)
      REAL(ReKi)                                   :: denom !, rmax
      REAL(ReKi)                                   :: ct, st ! cosine, sine of theta
      REAL(ReKi)                                   :: cp, sp ! cosine, sine of phi
 



   
         ! blade outputs
      do k=1,min(p%numBlades,size(BAzimuth) )    ! limit this
         m%AllOuts( BAzimuth(k) ) = MODULO( m%BEMT_u(indx)%psi(k)*R2D, 360.0_ReKi )
       ! m%AllOuts( BPitch(  k) ) = calculated in SetInputsForBEMT
      
         do beta=1,p%NBlOuts
         
            j=p%BlOutNd(beta)
                  
            m%AllOuts( BNVrel( beta,k) ) = m%BEMT_y%Vrel(j,k)
            m%AllOuts( BNDynP( beta,k) ) = 0.5 * p%airDens * m%BEMT_y%Vrel(j,k)**2
            m%AllOuts( BNRe(   beta,k) ) = p%BEMT%chord(j,k) * m%BEMT_y%Vrel(j,k) / p%KinVisc / 1.0E6
            m%AllOuts( BNM(    beta,k) ) = m%BEMT_y%Vrel(j,k) / p%SpdSound

            m%AllOuts( BNVIndx(beta,k) ) = - m%BEMT_u(indx)%Vx(j,k) * m%BEMT_y%axInduction( j,k)
            m%AllOuts( BNVIndy(beta,k) ) =   m%BEMT_u(indx)%Vy(j,k) * m%BEMT_y%tanInduction(j,k)

            m%AllOuts( BNAxInd(beta,k) ) = m%BEMT_y%axInduction(j,k)
            m%AllOuts( BNTnInd(beta,k) ) = m%BEMT_y%tanInduction(j,k)

            m%AllOuts( BNAlpha(beta,k) ) = Rad2M180to180Deg( m%BEMT_y%phi(j,k) - m%BEMT_u(indx)%theta(j,k) )
            m%AllOuts( BNTheta(beta,k) ) = m%BEMT_u(indx)%theta(j,k)*R2D
            m%AllOuts( BNPhi(  beta,k) ) = m%BEMT_y%phi(j,k)*R2D

   !        m%AllOuts( BNCurve(beta,k) ) = m%Curve(j,k)*R2D

            m%AllOuts( BNCpmin(   beta,k) ) = m%BEMT_y%Cpmin(j,k)
   !         m%AllOuts( BNSigCr(   beta,k) ) = m%SigmaCavitCrit(j,k)
   !         m%AllOuts( BNSgCav(   beta,k) ) = m%SigmaCavit(j,k)

            !m%AllOuts( BNCl(   beta,k) ) = m%BEMT_y%Cl(j,k)
            !m%AllOuts( BNCd(   beta,k) ) = m%BEMT_y%Cd(j,k)
            cp=cos(m%BEMT_y%phi(j,k))
            sp=sin(m%BEMT_y%phi(j,k))
            m%AllOuts( BNCl(   beta,k) ) = m%BEMT_y%Cx(j,k)*cp + m%BEMT_y%Cy(j,k)*sp
            m%AllOuts( BNCd(   beta,k) ) = m%BEMT_y%Cx(j,k)*sp - m%BEMT_y%Cy(j,k)*cp
            m%AllOuts( BNCm(   beta,k) ) = m%BEMT_y%Cm(j,k)
            m%AllOuts( BNCx(   beta,k) ) = m%BEMT_y%Cx(j,k)
            m%AllOuts( BNCy(   beta,k) ) = m%BEMT_y%Cy(j,k)

            ct=cos(m%BEMT_u(indx)%theta(j,k))
            st=sin(m%BEMT_u(indx)%theta(j,k))
            m%AllOuts( BNCn(   beta,k) ) = m%BEMT_y%Cx(j,k)*ct + m%BEMT_y%Cy(j,k)*st
            m%AllOuts( BNCt(   beta,k) ) =-m%BEMT_y%Cx(j,k)*st + m%BEMT_y%Cy(j,k)*ct

            m%AllOuts( BNFl(   beta,k) ) =  m%X(j,k)*cp - m%Y(j,k)*sp
            m%AllOuts( BNFd(   beta,k) ) =  m%X(j,k)*sp + m%Y(j,k)*cp
            m%AllOuts( BNMm(   beta,k) ) =  m%M(j,k)
            m%AllOuts( BNFx(   beta,k) ) =  m%X(j,k)
            m%AllOuts( BNFy(   beta,k) ) = -m%Y(j,k)
            m%AllOuts( BNFn(   beta,k) ) =  m%X(j,k)*ct - m%Y(j,k)*st
            m%AllOuts( BNFt(   beta,k) ) = -m%X(j,k)*st - m%Y(j,k)*ct

            m%AllOuts( BNGam(  beta,k) ) = 0.5_ReKi * p%BEMT%chord(j,k) * m%BEMT_y%Vrel(j,k) * m%BEMT_y%Cl(j,k) ! "Gam" [m^2/s]
            
         end do ! nodes
      end do ! blades
   

      ! rotor outputs:
   
      m%AllOuts( RtSkew   ) = m%BEMT_u(indx)%chi0*R2D
!     m%AllOuts( RtTSR    ) = m%BEMT_u(indx)%TSR
      m%AllOuts( DBEMTau1 ) = OtherState%BEMT%DBEMT%tau1

      
   end subroutine Calc_WriteOutput_BEMT

   !..........................................................................................
   !> Similar to Calc_WriteOutput_BEMT. TODO Merge me
   !! NOTE: relies on the prior calculation of m%V_dot_x, and m%V_diskAvg (done in DiskAvgValues)
   !!                                          m%DisturbedInflow (done in SetInputs)
   !!       Make sure these are set!
   subroutine Calc_WriteOutput_FVW
      integer    :: iW

         ! blade outputs
      do k=1,min(p%numBlades,3)
         iW=p_AD%FVW%Bld2Wings(iRot, k)

         do beta=1,p%NBlOuts
            j=p%BlOutNd(beta)

            m%AllOuts( BNVrel( beta,k) ) = m_AD%FVW%W(iW)%BN_Vrel(j)
            m%AllOuts( BNDynP( beta,k) ) = 0.5 * p%airDens * m_AD%FVW%W(iW)%BN_Vrel(j)**2
            m%AllOuts( BNRe(   beta,k) ) = m_AD%FVW%W(iW)%BN_Re(j)  / 1.0E6
            m%AllOuts( BNM(    beta,k) ) = m_AD%FVW%W(iW)%BN_Vrel(j) / p%SpdSound

            m%AllOuts( BNVIndx(beta,k) ) = -m_AD%FVW%W(iW)%BN_UrelWind_s(1,j) * m_AD%FVW%W(iW)%BN_AxInd(j)
            m%AllOuts( BNVIndy(beta,k) ) =  m_AD%FVW%W(iW)%BN_UrelWind_s(2,j) * m_AD%FVW%W(iW)%BN_TanInd(j)

            m%AllOuts( BNAxInd(beta,k) ) = m_AD%FVW%W(iW)%BN_AxInd(j)
            m%AllOuts( BNTnInd(beta,k) ) = m_AD%FVW%W(iW)%BN_TanInd(j)

            m%AllOuts( BNAlpha(beta,k) ) = m_AD%FVW%W(iW)%BN_alpha(j)*R2D
            m%AllOuts( BNTheta(beta,k) ) = m_AD%FVW%W(iW)%PitchAndTwist(j)*R2D
            m%AllOuts( BNPhi(  beta,k) ) = m_AD%FVW%W(iW)%BN_phi(j)*R2D
!             m%AllOuts( BNCurve(beta,k) ) = m%Curve(j,k)*R2D ! TODO

!             m%AllOuts( BNCpmin(   beta,k) ) = m%BEMT_y%Cpmin(jk) ! TODO
            m%AllOuts( BNCl(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cl(j)
            m%AllOuts( BNCd(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cd(j)
            m%AllOuts( BNCm(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cm(j)
            m%AllOuts( BNCx(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cx(j)
            m%AllOuts( BNCy(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cy(j)

            ct=cos(m_AD%FVW%W(iW)%PitchAndTwist(j))    ! cos(theta)
            st=sin(m_AD%FVW%W(iW)%PitchAndTwist(j))    ! sin(theta)
            m%AllOuts( BNCn(   beta,k) ) = m_AD%FVW%W(iW)%BN_Cx(j)*ct + m_AD%FVW%W(iW)%BN_Cy(j)*st
            m%AllOuts( BNCt(   beta,k) ) =-m_AD%FVW%W(iW)%BN_Cx(j)*st + m_AD%FVW%W(iW)%BN_Cy(j)*ct

            cp=cos(m_AD%FVW%W(iW)%BN_phi(j))
            sp=sin(m_AD%FVW%W(iW)%BN_phi(j))
            m%AllOuts( BNFl(   beta,k) ) =  m%X(j,k)*cp - m%Y(j,k)*sp
            m%AllOuts( BNFd(   beta,k) ) =  m%X(j,k)*sp + m%Y(j,k)*cp
            m%AllOuts( BNMm(   beta,k) ) =  m%M(j,k)
            m%AllOuts( BNFx(   beta,k) ) =  m%X(j,k)
            m%AllOuts( BNFy(   beta,k) ) = -m%Y(j,k)
            m%AllOuts( BNFn(   beta,k) ) =  m%X(j,k)*ct - m%Y(j,k)*st
            m%AllOuts( BNFt(   beta,k) ) = -m%X(j,k)*st - m%Y(j,k)*ct

            m%AllOuts( BNGam(  beta,k) ) = 0.5_ReKi * p_AD%FVW%W(iW)%chord_LL(j) * m_AD%FVW%W(iW)%BN_Vrel(j) * m_AD%FVW%W(iW)%BN_Cl(j) ! "Gam" [m^2/s]
         end do ! nodes
      end do ! blades


!     m%AllOuts( RtArea  ) = pi*rmax**2     ! TODO vertical axis
      m%AllOuts( RtSkew  ) = Calc_Chi0(m%V_diskAvg, m%V_dot_x) * R2D 

!      m%AllOuts( DBEMTau1 ) = 0.0_ReKi ! not valid with FVW

   end subroutine Calc_WriteOutput_FVW

END SUBROUTINE Calc_WriteOutput
!----------------------------------------------------------------------------------------------------------------------------------
SUBROUTINE ReadInputFiles( InputFileName, InputFileData, Default_DT, OutFileRoot, NumBlades, UnEcho, ErrStat, ErrMsg )
! This subroutine reads the input file and stores all the data in the AD_InputFile structure.
! It does not perform data validation.
!..................................................................................................................................

      ! Passed variables
   REAL(DbKi),              INTENT(IN)    :: Default_DT      ! The default DT (from glue code)

   CHARACTER(*),            INTENT(IN)    :: InputFileName   ! Name of the input file
   CHARACTER(*),            INTENT(IN)    :: OutFileRoot     ! The rootname of all the output files written by this routine.

   TYPE(AD_InputFile),      INTENT(INOUT) :: InputFileData   ! Data stored in the module's input file
   INTEGER(IntKi),          INTENT(INOUT) :: UnEcho          ! Unit number for the echo file

   INTEGER(IntKi),          INTENT(IN)    :: NumBlades(:)    ! Number of blades per rotor 
   INTEGER(IntKi),          INTENT(OUT)   :: ErrStat         ! The error status code
   CHARACTER(*),            INTENT(OUT)   :: ErrMsg          ! The error message, if an error occurred

      ! local variables

   INTEGER(IntKi)                         :: I
   INTEGER(IntKi)                         :: iR              ! Loop on rotor
   integer(IntKi)                         :: iBld            ! counter on blades
   INTEGER(IntKi)                         :: ErrStat2        ! The error status code
   CHARACTER(ErrMsgLen)                   :: ErrMsg2         ! The error message, if an error occurred

   CHARACTER(*), PARAMETER                :: RoutineName = 'ReadInputFiles'
   
   
      ! initialize values:

   ErrStat = ErrID_None
   ErrMsg  = ''
   InputFileData%DTAero = Default_DT  ! the glue code's suggested DT for the module (may be overwritten in ReadPrimaryFile())


      ! get the blade input-file data
   iBld=1
   do iR = 1, size(InputFileData%rotors)
      
      ALLOCATE( InputFileData%rotors(iR)%BladeProps( NumBlades(iR) ), STAT = ErrStat2 )
      IF (ErrStat2 /= 0) THEN
         CALL SetErrStat(ErrID_Fatal,"Error allocating memory for BladeProps.", ErrStat, ErrMsg, RoutineName)
         CALL Cleanup()
         RETURN
      END IF
         
   !FIXME: add options for passing the blade files.  This routine will need restructuring to handle that.
      DO I=1,NumBlades(iR)
         CALL ReadBladeInputs ( InputFileData%ADBlFile(iBld), InputFileData%rotors(iR)%BladeProps(I), UnEcho, ErrStat2, ErrMsg2 )
            CALL SetErrStat(ErrStat2,ErrMsg2, ErrStat, ErrMsg, RoutineName//TRIM(':Blade')//TRIM(Num2LStr(I)))
            IF ( ErrStat >= AbortErrLev ) THEN
               CALL Cleanup()
               RETURN
            END IF
         iBld = iBld+1 ! Increment blade counter
      END DO
   
   ENDDO ! Loop on rotors
      

   CALL Cleanup ( )


CONTAINS
   !...............................................................................................................................
   SUBROUTINE Cleanup()
   ! This subroutine cleans up before exiting this subroutine
   !...............................................................................................................................

      ! IF ( UnEcho > 0 ) CLOSE( UnEcho )

   END SUBROUTINE Cleanup

END SUBROUTINE ReadInputFiles
!----------------------------------------------------------------------------------------------------------------------------------
!> This routine parses the input file data stored in FileInfo_In and places it in the InputFileData structure for validating.
SUBROUTINE ParsePrimaryFileInfo( PriPath, InitInp, InputFile, RootName, NumBlades, interval, FileInfo_In, InputFileData, UnEc, ErrStat, ErrMsg )
   implicit    none

      ! Passed variables
   character(*),                    intent(in   )  :: PriPath           !< primary path
   type(AD_InitInputType),          intent(in   )  :: InitInp           !< Input data for initialization routine
   CHARACTER(*),                    intent(in   )  :: InputFile         !< Name of the file containing the primary input data
   CHARACTER(*),                    intent(in   )  :: RootName          !< The rootname of the echo file, possibly opened in this routine
   integer(IntKi),                  intent(in   )  :: NumBlades(:)      !< Number of blades per rotor we expect -- from InitInp
   real(DBKi),                      intent(in   )  :: interval          !< timestep
   type(AD_InputFile),              intent(inout)  :: InputFileData     !< All the data in the AD15 primary input file
   type(FileInfoType),              intent(in   )  :: FileInfo_In       !< The derived type for holding the file information.
   integer(IntKi),                  intent(  out)  :: UnEc              !< The local unit number for this module's echo file
   integer(IntKi),                  intent(  out)  :: ErrStat           !< Error status
   CHARACTER(ErrMsgLen),            intent(  out)  :: ErrMsg            !< Error message

      ! Local variables:
   integer(IntKi)                                  :: i                 !< generic counter
   integer(IntKi)                                  :: iR                !< Loop on rotors
   integer(IntKi)                                  :: numBladesTot      !< total number of blades
   integer(IntKi)                                  :: ErrStat2          !< Temporary Error status
   character(ErrMsgLen)                            :: ErrMsg2           !< Temporary Error message
   character(ErrMsgLen)                            :: ErrMsg_NoAllBldNdOuts
   integer(IntKi)                                  :: CurLine           !< current entry in FileInfo_In%Lines array
   real(ReKi)                                      :: TmpRe4(4)         !< temporary 4 number array for reading values in

   character(*), parameter                         :: RoutineName = 'ParsePrimaryFileInfo'

   ! Initialization
   ErrStat  =  ErrId_None
   ErrMsg   =  ""
   UnEc   = -1     ! Echo file unit.  >0 when used


   CALL AllocAry( InputFileData%OutList, MaxOutPts, "Outlist", ErrStat2, ErrMsg2 )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )

      ! Allocate array for holding the list of node outputs
   CALL AllocAry( InputFileData%BldNd_OutList, BldNd_MaxOutPts, "BldNd_Outlist", ErrStat2, ErrMsg2 )
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )

   numBladesTot=sum(NumBlades)

   !-------------------------------------------------------------------------------------------------
   ! General settings
   !-------------------------------------------------------------------------------------------------

   CurLine = 4    ! Skip the first three lines as they are known to be header lines and separators
   call ParseVar( FileInfo_In, CurLine, 'Echo', InputFileData%Echo, ErrStat2, ErrMsg2 )
         if (Failed()) return;

   if ( InputFileData%Echo ) then
      CALL OpenEcho ( UnEc, TRIM(RootName)//'.ech', ErrStat2, ErrMsg2 )
         if (Failed()) return;
      WRITE(UnEc, '(A)') 'Echo file for AeroDyn 15 primary input file: '//trim(InputFile)
      ! Write the first three lines into the echo file
      WRITE(UnEc, '(A)') FileInfo_In%Lines(1)
      WRITE(UnEc, '(A)') FileInfo_In%Lines(2)
      WRITE(UnEc, '(A)') FileInfo_In%Lines(3)

      CurLine = 4
      call ParseVar( FileInfo_In, CurLine, 'Echo', InputFileData%Echo, ErrStat2, ErrMsg2, UnEc )
         if (Failed()) return
   endif


      ! DTAero - Time interval for aerodynamic calculations {or default} (s):
   call ParseVarWDefault ( FileInfo_In, CurLine, "DTAero", InputFileData%DTAero, interval, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! WakeMod - Type of wake/induction model (switch) {0=none, 1=BEMT, 2=DBEMT, 3=OLAF}  [WakeMod cannot be 2 or 3 when linearizing]
   call ParseVar( FileInfo_In, CurLine, "WakeMod", InputFileData%WakeMod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! AFAeroMod - Type of blade airfoil aerodynamics model (switch) {1=steady model, 2=Beddoes-Leishman unsteady model} [AFAeroMod must be 1 when linearizing]
   call ParseVar( FileInfo_In, CurLine, "AFAeroMod", InputFileData%AFAeroMod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TwrPotent - Type of tower influence on wind based on potential flow around the tower (switch) {0=none, 1=baseline potential flow, 2=potential flow with Bak correction}
   call ParseVar( FileInfo_In, CurLine, "TwrPotent", InputFileData%TwrPotent, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TwrShadow - Type of tower influence on wind based on downstream tower shadow {0=none, 1=Powles model, 2=Eames model}
   call ParseVar( FileInfo_In, CurLine, "TwrShadow", InputFileData%TwrShadow, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TwrAero - Calculate tower aerodynamic loads? (flag)
   call ParseVar( FileInfo_In, CurLine, "TwrAero", InputFileData%TwrAero, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! FrozenWake - Assume frozen wake during linearization? (flag) [used only when WakeMod=1 and when linearizing]
   call ParseVar( FileInfo_In, CurLine, "FrozenWake", InputFileData%FrozenWake, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! CavitCheck - Perform cavitation check? (flag) [AFAeroMod must be 1 when CavitCheck=true]
   call ParseVar( FileInfo_In, CurLine, "CavitCheck", InputFileData%CavitCheck, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! CompAA - Flag to compute AeroAcoustics calculation [only used when WakeMod=1 or 2]
   call ParseVar( FileInfo_In, CurLine, "CompAA", InputFileData%CompAA, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! AA_InputFile - Aeroacoustics input file
   call ParseVar( FileInfo_In, CurLine, "AA_InputFile", InputFileData%AA_InputFile, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      IF ( PathIsRelative( InputFileData%AA_InputFile ) ) InputFileData%AA_InputFile = TRIM(PriPath)//TRIM(InputFileData%AA_InputFile)

   !======  Environmental Conditions  ===================================================================
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! AirDens - Air density {or default} (kg/m^3)
   call ParseVarWDefault( FileInfo_In, CurLine, "AirDens", InputFileData%AirDens, InitInp%defFldDens, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! KinVisc - Kinematic air viscosity {or default} (m^2/s)
   call ParseVarWDefault( FileInfo_In, CurLine, "KinVisc", InputFileData%KinVisc, InitInp%defKinVisc, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! SpdSound - Speed of sound {or default} (m/s)
   call ParseVarWDefault( FileInfo_In, CurLine, "SpdSound", InputFileData%SpdSound, InitInp%defSpdSound, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! Patm - Atmospheric pressure {or default} (Pa) [used only when CavitCheck=True]
   call ParseVarWDefault( FileInfo_In, CurLine, "Patm", InputFileData%Patm, InitInp%defPatm, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! Pvap - Vapour pressure of fluid {or default} (Pa) [used only when CavitCheck=True]
   call ParseVarWDefault( FileInfo_In, CurLine, "Pvap", InputFileData%Pvap, InitInp%defPvap, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return

   !======  Blade-Element/Momentum Theory Options  ====================================================== [unused when WakeMod=0 or 3]
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! SkewMod - Type of skewed-wake correction model (switch) {1=uncoupled, 2=Pitt/Peters, 3=coupled} [unused when WakeMod=0 or 3]
   call ParseVar( FileInfo_In, CurLine, "SkewMod", InputFileData%SkewMod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! SkewModFactor - Constant used in Pitt/Peters skewed wake model {or "default" is 15/32*pi} (-) [used only when SkewMod=2; unused when WakeMod=0 or 3]
   call ParseVarWDefault( FileInfo_In, CurLine, "SkewModFactor", InputFileData%SkewModFactor, (15.0_ReKi * pi / 32.0_ReKi), ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TipLoss - Use the Prandtl tip-loss model? (flag) [unused when WakeMod=0 or 3]
   call ParseVar( FileInfo_In, CurLine, "TipLoss", InputFileData%TipLoss, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! HubLoss - Use the Prandtl hub-loss model? (flag) [unused when WakeMod=0 or 3]
   call ParseVar( FileInfo_In, CurLine, "HubLoss", InputFileData%HubLoss, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TanInd - Include tangential induction in BEMT calculations? (flag) [unused when WakeMod=0 or 3]
   call ParseVar( FileInfo_In, CurLine, "TanInd", InputFileData%TanInd, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! AIDrag - Include the drag term in the axial-induction calculation? (flag) [unused when WakeMod=0 or 3]
   call ParseVar( FileInfo_In, CurLine, "AIDrag", InputFileData%AIDrag, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! TIDrag - Include the drag term in the tangential-induction calculation? (flag) [unused when WakeMod=0,3 or TanInd=FALSE]
   call ParseVar( FileInfo_In, CurLine, "TIDrag", InputFileData%TIDrag, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! IndToler - Convergence tolerance for BEMT nonlinear solve residual equation {or "default"} (-) [unused when WakeMod=0 or 3]
   if (ReKi==SiKi) then
      call ParseVarWDefault( FileInfo_In, CurLine, "IndToler", InputFileData%IndToler, real(5E-5,ReKi), ErrStat2, ErrMsg2, UnEc )
   else
      call ParseVarWDefault( FileInfo_In, CurLine, "IndToler", InputFileData%IndToler, real(5D-10,ReKi), ErrStat2, ErrMsg2, UnEc )
   end if
      if (Failed()) return
      ! MaxIter - Maximum number of iteration steps (-) [unused when WakeMod=0]
   call ParseVar( FileInfo_In, CurLine, "MaxIter", InputFileData%MaxIter, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return

   !======  Dynamic Blade-Element/Momentum Theory Options  ============================================== [used only when WakeMod=2]
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! DBEMT_Mod - Type of dynamic BEMT (DBEMT) model {1=constant tau1, 2=time-dependent tau1} (-) [used only when WakeMod=2]
   call ParseVar( FileInfo_In, CurLine, "DBEMT_Mod", InputFileData%DBEMT_Mod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! tau1_const - Time constant for DBEMT (s) [used only when WakeMod=2 and DBEMT_Mod=1]
   call ParseVar( FileInfo_In, CurLine, "tau1_const", InputFileData%tau1_const, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return

   !======  OLAF -- cOnvecting LAgrangian Filaments (Free Vortex Wake) Theory Options  ================== [used only when WakeMod=3]
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! OLAFInputFileName - Input file for OLAF [used only when WakeMod=3]
   call ParseVar( FileInfo_In, CurLine, "OLAFInputFileName", InputFileData%FVWFileName, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      IF ( PathIsRelative( InputFileData%FVWFileName ) ) InputFileData%FVWFileName = TRIM(PriPath)//TRIM(InputFileData%FVWFileName)

   !======  Beddoes-Leishman Unsteady Airfoil Aerodynamics Options  ===================================== [used only when AFAeroMod=2]
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! UAMod - Unsteady Aero Model Switch (switch) {1=Baseline model (Original), 2=Gonzalez's variant (changes in Cn,Cc,Cm), 3=Minnema/Pierce variant (changes in Cc and Cm)} [used only when AFAeroMod=2]
   call ParseVar( FileInfo_In, CurLine, "UAMod", InputFileData%UAMod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! FLookup - Flag to indicate whether a lookup for f' will be calculated (TRUE) or whether best-fit exponential equations will be used (FALSE); if FALSE S1-S4 must be provided in airfoil input files (flag) [used only when AFAeroMod=2]
   call ParseVar( FileInfo_In, CurLine, "FLookup", InputFileData%FLookup, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      
      ! UAStartRad - Starting radius for dynamic stall (fraction of rotor radius) [used only when AFAeroMod=2]:
   call ParseVar( FileInfo_In, CurLine, "UAStartRad", InputFileData%UAStartRad, ErrStat2, ErrMsg2, UnEc )
      if (ErrStat2>= AbortErrLev) InputFileData%UAStartRad = 0.0_ReKi
   
      ! UAEndRad - Ending radius for dynamic stall (fraction of rotor radius) [used only when AFAeroMod=2]:
   call ParseVar( FileInfo_In, CurLine, "UAEndRad", InputFileData%UAEndRad, ErrStat2, ErrMsg2, UnEc )
      if (ErrStat2>= AbortErrLev) InputFileData%UAEndRad = 1.0_ReKi

   !======  Airfoil Information =========================================================================
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! AFTabMod - Interpolation method for multiple airfoil tables {1=1D interpolation on AoA (first table only); 2=2D interpolation on AoA and Re; 3=2D interpolation on AoA and UserProp} (-)
   call ParseVar( FileInfo_In, CurLine, "AFTabMod", InputFileData%AFTabMod, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! InCol_Alfa - The column in the airfoil tables that contains the angle of attack (-)
   call ParseVar( FileInfo_In, CurLine, "InCol_Alfa", InputFileData%InCol_Alfa, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! InCol_Cl - The column in the airfoil tables that contains the lift coefficient (-)
   call ParseVar( FileInfo_In, CurLine, "InCol_Cl", InputFileData%InCol_Cl, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! InCol_Cd - The column in the airfoil tables that contains the drag coefficient (-)
   call ParseVar( FileInfo_In, CurLine, "InCol_Cd", InputFileData%InCol_Cd, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! InCol_Cm - The column in the airfoil tables that contains the pitching-moment coefficient; use zero if there is no Cm column (-)
   call ParseVar( FileInfo_In, CurLine, "InCol_Cm", InputFileData%InCol_Cm, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! InCol_Cpmin - The column in the airfoil tables that contains the Cpmin coefficient; use zero if there is no Cpmin column (-)
   call ParseVar( FileInfo_In, CurLine, "InCol_Cpmin", InputFileData%InCol_Cpmin, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! NumAFfiles - Number of airfoil files used (-)
   call ParseVar( FileInfo_In, CurLine, "NumAFfiles", InputFileData%NumAFfiles, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
         ! Allocate space to hold AFNames
      ALLOCATE( InputFileData%AFNames(InputFileData%NumAFfiles), STAT=ErrStat2)
         IF (ErrStat2 /= 0 ) THEN
            ErrStat2=ErrID_Fatal
            ErrMsg2 = "Error allocating AFNames."
            if (Failed()) return
         END IF
      ! AFNames - Airfoil file names (NumAFfiles lines) (quoted strings): -- NOTE: this line may not have a keyname with it
   DO I = 1,InputFileData%NumAFfiles         ! ParseChVar allows empty keynames.
      call ParseVar( FileInfo_In, CurLine, "", InputFileData%AFNames(I), ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      IF ( PathIsRelative( InputFileData%AFNames(I) ) ) InputFileData%AFNames(I) = TRIM(PriPath)//TRIM(InputFileData%AFNames(I))
   END DO

   !======  Rotor/Blade Properties  =====================================================================
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! UseBlCm - Include aerodynamic pitching moment in calculations?  (flag)
   call ParseVar( FileInfo_In, CurLine, "UseBlCm", InputFileData%UseBlCm, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! Allocate space for AD blade file names -- MaxBl is usually set to 3, but if we specify more blades, this will work still.
   call AllocAry( InputFileData%ADBlFile, max(MaxBl,NumBladesTot), 'ADBlFile', ErrStat2, ErrMsg2)
      if (Failed()) return
   do I =1,size(InputFileData%ADBlFile)  ! We expect MaxBl blade file lines.  We may want to revisit this idea later if we allow more thn 3 blades
      call ParseVar( FileInfo_In, CurLine, "", InputFileData%ADBlFile(i), ErrStat2, ErrMsg2, UnEc )
         if (Failed()) return
      IF ( PathIsRelative( InputFileData%ADBlFile(I) ) ) InputFileData%ADBlFile(I) = TRIM(PriPath)//TRIM(InputFileData%ADBlFile(I))
   enddo

   !======  Tower Influence and Aerodynamics ============================================================= [used only when TwrPotent/=0, TwrShadow/=0, or TwrAero=True]

   do iR = 1,size(NumBlades) ! Loop on rotors
      if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
      CurLine = CurLine + 1
         ! NumTwrNds - Number of tower nodes used in the analysis  (-) [used only when TwrPotent/=0, TwrShadow/=0, or TwrAero=True]
      call ParseVar( FileInfo_In, CurLine, "NumTwrNds", InputFileData%rotors(iR)%NumTwrNds, ErrStat2, ErrMsg2, UnEc )
         if (Failed()) return
         !TwrElev        TwrDiam        TwrCd
      if ( InputFileData%Echo )   WRITE(UnEc, '(A)') 'Tower Table Header: '//FileInfo_In%Lines(CurLine)    ! Write section break to echo
      CurLine = CurLine + 1
         !(m)              (m)           (-)
      if ( InputFileData%Echo )   WRITE(UnEc, '(A)') 'Tower Table Header: '//FileInfo_In%Lines(CurLine)    ! Write section break to echo
      CurLine = CurLine + 1
         ! Allocate space for tower table
      CALL AllocAry( InputFileData%rotors(iR)%TwrElev,  InputFileData%rotors(iR)%NumTwrNds, 'TwrElev',  ErrStat2, ErrMsg2)
         if (Failed()) return
      CALL AllocAry( InputFileData%rotors(iR)%TwrDiam, InputFileData%rotors(iR)%NumTwrNds, 'TwrDiam', ErrStat2, ErrMsg2)
         if (Failed()) return
      CALL AllocAry( InputFileData%rotors(iR)%TwrCd, InputFileData%rotors(iR)%NumTwrNds, 'TwrCd', ErrStat2, ErrMsg2)
         if (Failed()) return
      CALL AllocAry( InputFileData%rotors(iR)%TwrTI, InputFileData%rotors(iR)%NumTwrNds, 'TwrTI', ErrStat2, ErrMsg2)
         if (Failed()) return

      do I=1,InputFileData%rotors(iR)%NumTwrNds
         call ParseAry ( FileInfo_In, CurLine, 'Properties for tower node '//trim( Int2LStr( I ) )//'.', TmpRe4, 4, ErrStat2, ErrMsg2, UnEc )
            if (Failed()) return;
         InputFileData%rotors(iR)%TwrElev(I) = TmpRe4( 1)
         InputFileData%rotors(iR)%TwrDiam(I) = TmpRe4( 2)
         InputFileData%rotors(iR)%TwrCd(I)   = TmpRe4( 3)
         InputFileData%rotors(iR)%TwrTI(I)   = TmpRe4( 4)
      end do
   enddo

   !======  Outputs  ====================================================================================
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
      ! SumPrint - Generate a summary file listing input options and interpolated properties to "<rootname>.AD.sum"?  (flag)
   call ParseVar( FileInfo_In, CurLine, "SumPrint", InputFileData%SumPrint, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return

      ! NBlOuts - Number of blade node outputs [0 - 9] (-)
   call ParseVar( FileInfo_In, CurLine, "NBlOuts", InputFileData%NBlOuts, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! Make sure we don't try to read in more than will fit in the pre-allocated BlOutNd array
   if ( InputFileData%NBlOuts > SIZE(InputFileData%BlOutNd) ) THEN
      CALL SetErrStat( ErrID_Warn, ' Warning: number of blade output nodes exceeds '//&
                        TRIM(Num2LStr(SIZE(InputFileData%BlOutNd))) //'.', ErrStat, ErrMsg, RoutineName )
      InputFileData%NBlOuts = SIZE(InputFileData%BlOutNd)
   endif
      ! BlOutNd - Blade nodes whose values will be output (-):
   call ParseAry( FileInfo_In, CurLine, "BlOutNd", InputFileData%BlOutNd, InputFileData%NBlOuts, ErrStat2, ErrMsg2, UnEc)
      if (Failed()) return

      ! NTwOuts - Number of blade node outputs [0 - 9] (-)
   call ParseVar( FileInfo_In, CurLine, "NTwOuts", InputFileData%NTwOuts, ErrStat2, ErrMsg2, UnEc )
      if (Failed()) return
      ! Make sure we don't try to read in more than will fit in the pre-allocated TwOutNd array
   if ( InputFileData%NTwOuts > SIZE(InputFileData%TwOutNd) ) THEN
      CALL SetErrStat( ErrID_Warn, ' Warning: number of blade output nodes exceeds '//&
                        TRIM(Num2LStr(SIZE(InputFileData%TwOutNd))) //'.', ErrStat, ErrMsg, RoutineName )
      InputFileData%NTwOuts = SIZE(InputFileData%TwOutNd)
   endif
      ! TwOutNd - Tower nodes whose values will be output (-):
   call ParseAry( FileInfo_In, CurLine, "TwOutNd", InputFileData%TwOutNd, InputFileData%NTwOuts, ErrStat2, ErrMsg2, UnEc)
      if (Failed()) return

   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1
   call ReadOutputListFromFileInfo( FileInfo_In, CurLine, InputFileData%OutList, &
            InputFileData%NumOuts, 'OutList', "List of user-requested output channels", ErrStat2, ErrMsg2, UnEc )
         if (Failed()) return;

   !======  Nodal Outputs  ==============================================================================
      ! In case there is something ill-formed in the additional nodal outputs section, we will simply ignore it.
      ! Expecting at least 5 more lines in the input file for this section
   if (FileInfo_In%NumLines < CurLine + 5) then
      ErrStat2 = ErrID_Fatal
      ErrMsg2  = ''
      if (FailedNodal()) return;
   endif

   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1

      ! BldNd_BladesOut - Number of blades to output all node information at.  Up to number of blades on turbine. (-)
      ! TODO:  In a future release, allow this to be an array of N blade numbers (change BldNd_BladesOut to an array if we do that).
      !        Will likely require reading this line in as a string (BldNd_BladesOut_Str) and parsing it
   call ParseVar( FileInfo_In, CurLine, "BldNd_BladesOut", InputFileData%BldNd_BladesOut, ErrStat2, ErrMsg2, UnEc )
      if (FailedNodal()) return
      ! BldNd_BlOutNd - Future feature will allow selecting a portion of the nodes to output.  Not implemented yet. (-)
      ! TODO: Parse this string into an array of nodes to output at (one idea is to set an array of boolean to T/F for which nodes to output).  At present, we ignore it entirely.
   call ParseVar( FileInfo_In, CurLine, "BldNd_BlOutNd", InputFileData%BldNd_BlOutNd_Str, ErrStat2, ErrMsg2, UnEc )
      if (FailedNodal()) return
      ! OutList - The next line(s) contains a list of output parameters.  See OutListParameters.xlsx for a listing of available output channels, (-)
   if ( InputFileData%Echo )   WRITE(UnEc, '(A)') FileInfo_In%Lines(CurLine)    ! Write section break to echo
   CurLine = CurLine + 1

   call ReadOutputListFromFileInfo( FileInfo_In, CurLine, InputFileData%BldNd_OutList, &
            InputFileData%BldNd_NumOuts, 'BldNd_OutList', "List of user-requested output nodal channel groups", ErrStat2, ErrMsg2, UnEc )
         if (FailedNodal()) return;

   RETURN
CONTAINS
   !-------------------------------------------------------------------------------------------------
   logical function Failed()
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, 'ParsePrimaryFileInfo' )
      Failed = ErrStat >= AbortErrLev
      !if (Failed) then
      !endif
   end function Failed
   logical function FailedNodal()
      ErrMsg_NoAllBldNdOuts='AD15 Nodal Outputs: Nodal output section of AeroDyn input file not found or improperly formatted. Skipping nodal outputs.'
      FailedNodal = ErrStat2 >= AbortErrLev
      if ( FailedNodal ) then
         InputFileData%BldNd_BladesOut = 0
         InputFileData%BldNd_NumOuts = 0
         call wrscr( trim(ErrMsg_NoAllBldNdOuts) )
      endif
   end function FailedNodal
   !-------------------------------------------------------------------------------------------------
END SUBROUTINE ParsePrimaryFileInfo
!----------------------------------------------------------------------------------------------------------------------------------
SUBROUTINE ReadBladeInputs ( ADBlFile, BladeKInputFileData, UnEc, ErrStat, ErrMsg )
! This routine reads a blade input file.
!..................................................................................................................................


      ! Passed variables:

   TYPE(AD_BladePropsType),  INTENT(INOUT)  :: BladeKInputFileData                 ! Data for Blade K stored in the module's input file
   CHARACTER(*),             INTENT(IN)     :: ADBlFile                            ! Name of the blade input file data
   INTEGER(IntKi),           INTENT(IN)     :: UnEc                                ! I/O unit for echo file. If present and > 0, write to UnEc

   INTEGER(IntKi),           INTENT(OUT)    :: ErrStat                             ! Error status
   CHARACTER(*),             INTENT(OUT)    :: ErrMsg                              ! Error message


      ! Local variables:

   INTEGER(IntKi)               :: I                                               ! A generic DO index.
   INTEGER( IntKi )             :: UnIn                                            ! Unit number for reading file
   INTEGER(IntKi)               :: ErrStat2 , IOS                                  ! Temporary Error status
   CHARACTER(ErrMsgLen)         :: ErrMsg2                                         ! Temporary Err msg
   CHARACTER(*), PARAMETER      :: RoutineName = 'ReadBladeInputs'

   ErrStat = ErrID_None
   ErrMsg  = ""
   UnIn = -1
   
   CALL GetNewUnit( UnIn, ErrStat2, ErrMsg2 )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)


      ! Open the input file for blade K.

   CALL OpenFInpFile ( UnIn, ADBlFile, ErrStat2, ErrMsg2 )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      IF ( ErrStat >= AbortErrLev ) RETURN


   !  -------------- HEADER -------------------------------------------------------

      ! Skip the header.

   CALL ReadCom ( UnIn, ADBlFile, 'unused blade file header line 1', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)

   CALL ReadCom ( UnIn, ADBlFile, 'unused blade file header line 2', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      
   !  -------------- Blade properties table ------------------------------------------                                    
   CALL ReadCom ( UnIn, ADBlFile, 'Section header: Blade Properties', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)

      ! NumBlNds - Number of blade nodes used in the analysis (-):
   CALL ReadVar( UnIn, ADBlFile, BladeKInputFileData%NumBlNds, "NumBlNds", "Number of blade nodes used in the analysis (-)", ErrStat2, ErrMsg2, UnEc)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      IF ( ErrStat>= AbortErrLev ) THEN 
         CALL Cleanup()
         RETURN
      END IF

   CALL ReadCom ( UnIn, ADBlFile, 'Table header: names', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)

   CALL ReadCom ( UnIn, ADBlFile, 'Table header: units', ErrStat2, ErrMsg2, UnEc )
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      
   IF ( ErrStat>= AbortErrLev ) THEN 
      CALL Cleanup()
      RETURN
   END IF
   
      
      ! allocate space for blade inputs:
   CALL AllocAry( BladeKInputFileData%BlSpn,   BladeKInputFileData%NumBlNds, 'BlSpn',   ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlCrvAC, BladeKInputFileData%NumBlNds, 'BlCrvAC', ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlSwpAC, BladeKInputFileData%NumBlNds, 'BlSwpAC', ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlCrvAng,BladeKInputFileData%NumBlNds, 'BlCrvAng',ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlTwist, BladeKInputFileData%NumBlNds, 'BlTwist', ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlChord, BladeKInputFileData%NumBlNds, 'BlChord', ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
   CALL AllocAry( BladeKInputFileData%BlAFID,  BladeKInputFileData%NumBlNds, 'BlAFID',  ErrStat2, ErrMsg2)
      CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
      
      ! Return on error if we didn't allocate space for the next inputs
   IF ( ErrStat >= AbortErrLev ) THEN
      CALL Cleanup()
      RETURN
   END IF
            
   DO I=1,BladeKInputFileData%NumBlNds
      READ( UnIn, *, IOStat=IOS ) BladeKInputFileData%BlSpn(I), BladeKInputFileData%BlCrvAC(I), BladeKInputFileData%BlSwpAC(I), &
                                  BladeKInputFileData%BlCrvAng(I), BladeKInputFileData%BlTwist(I), BladeKInputFileData%BlChord(I), &
                                  BladeKInputFileData%BlAFID(I)  
         CALL CheckIOS( IOS, ADBlFile, 'Blade properties row '//TRIM(Num2LStr(I)), NumType, ErrStat2, ErrMsg2 )
         CALL SetErrStat( ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName )
               ! Return on error if we couldn't read this line
            IF ( ErrStat >= AbortErrLev ) THEN
               CALL Cleanup()
               RETURN
            END IF
         
         IF (UnEc > 0) THEN
            WRITE( UnEc, "(6(F9.4,1x),I9)", IOStat=IOS) BladeKInputFileData%BlSpn(I), BladeKInputFileData%BlCrvAC(I), BladeKInputFileData%BlSwpAC(I), &
                                  BladeKInputFileData%BlCrvAng(I), BladeKInputFileData%BlTwist(I), BladeKInputFileData%BlChord(I), &
                                  BladeKInputFileData%BlAFID(I)
         END IF         
   END DO
   BladeKInputFileData%BlCrvAng = BladeKInputFileData%BlCrvAng*D2R
   BladeKInputFileData%BlTwist  = BladeKInputFileData%BlTwist*D2R
                  
   !  -------------- END OF FILE --------------------------------------------

   CALL Cleanup()
   RETURN


CONTAINS
   !...............................................................................................................................
   SUBROUTINE Cleanup()
   ! This subroutine cleans up local variables and closes files
   !...............................................................................................................................

      IF (UnIn > 0) CLOSE(UnIn)

   END SUBROUTINE Cleanup

END SUBROUTINE ReadBladeInputs      
!----------------------------------------------------------------------------------------------------------------------------------
SUBROUTINE AD_PrintSum( InputFileData, p, p_AD, u, y, ErrStat, ErrMsg )
! This routine generates the summary file, which contains a summary of input file options.

      ! passed variables
   TYPE(AD_InputFile),        INTENT(IN)  :: InputFileData                        ! Input-file data
   TYPE(RotParameterType),    INTENT(IN)  :: p                                    ! Parameters
   TYPE(AD_ParameterType),    INTENT(IN)  :: p_AD                                 ! Parameters
   TYPE(AD_InputType),        INTENT(IN)  :: u                                    ! inputs 
   TYPE(AD_OutputType),       INTENT(IN)  :: y                                    ! outputs
   INTEGER(IntKi),            INTENT(OUT) :: ErrStat
   CHARACTER(*),              INTENT(OUT) :: ErrMsg


      ! Local variables.

   INTEGER(IntKi)               :: I                                               ! Index for the nodes.
   INTEGER(IntKi)               :: UnSu                                            ! I/O unit number for the summary output file

   CHARACTER(*), PARAMETER      :: FmtDat    = '(A,T35,1(:,F13.3))'                ! Format for outputting mass and modal data.
   CHARACTER(*), PARAMETER      :: FmtDatT   = '(A,T35,1(:,F13.8))'                ! Format for outputting time steps.

   CHARACTER(30)                :: OutPFmt                                         ! Format to print list of selected output channels to summary file
   CHARACTER(100)               :: Msg                                             ! temporary string for writing appropriate text to summary file

   ! Open the summary file and give it a heading.
      
   CALL GetNewUnit( UnSu, ErrStat, ErrMsg )
   CALL OpenFOutFile ( UnSu, TRIM( p%RootName )//'.sum', ErrStat, ErrMsg )
   IF ( ErrStat >= AbortErrLev ) RETURN

      ! Heading:
   WRITE (UnSu,'(/,A)')  'This summary information was generated by '//TRIM( GetNVD(AD_Ver) )// &
                         ' on '//CurDate()//' at '//CurTime()//'.'

   WRITE (UnSu,'(/,A)') '======  General Options  ============================================================================'
   ! WakeMod
   select case (p_AD%WakeMod)
      case (WakeMod_BEMT)
         Msg = 'Blade-Element/Momentum Theory'
      case (WakeMod_DBEMT)
         Msg = 'Dynamic Blade-Element/Momentum Theory'
      case (WakeMod_FVW)
         Msg = 'Free Vortex Wake Theory'
      case (WakeMod_None)
         Msg = 'steady'
      case default      
         Msg = 'unknown'      
   end select   
   WRITE (UnSu,Ec_IntFrmt) p_AD%WakeMod, 'WakeMod', 'Type of wake/induction model: '//TRIM(Msg)

   
   ! AFAeroMod
   select case (InputFileData%AFAeroMod)
      case (AFAeroMod_BL_unsteady)
         Msg = 'Beddoes-Leishman unsteady model'
      case (AFAeroMod_steady)
         Msg = 'steady'
      case default      
         Msg = 'unknown'      
   end select   
   WRITE (UnSu,Ec_IntFrmt) InputFileData%AFAeroMod, 'AFAeroMod', 'Type of blade airfoil aerodynamics model: '//TRIM(Msg)
   
   
   ! TwrPotent
   select case (p%TwrPotent)
      case (TwrPotent_baseline)
         Msg = 'baseline potential flow'
      case (TwrPotent_Bak)
         Msg = 'potential flow with Bak correction'
      case (TwrPotent_none)
         Msg = 'none'      
      case default      
         Msg = 'unknown'      
   end select
   WRITE (UnSu,Ec_IntFrmt) p%TwrPotent, 'TwrPotent', 'Type of tower influence on wind based on potential flow around the tower: '//TRIM(Msg)
   
   
   ! TwrShadow
   select case (p%TwrShadow)
      case (TwrShadow_Powles)
         Msg = 'Powles tower shadow model'
      case (TwrShadow_Eames)
         Msg = 'Eames tower shadow model with TI values from the table' 
      case (TwrShadow_none)
         Msg = 'none'      
      case default      
         Msg = 'unknown'      
   end select
   WRITE (UnSu,Ec_IntFrmt) p%TwrShadow, 'TwrShadow', 'Type of tower influence on wind based on downstream tower shadow: '//TRIM(Msg)
    
   
   ! TwrAero
   if (p%TwrAero) then
      Msg = 'Yes'
   else
      Msg = 'No'
   end if   
   WRITE (UnSu,Ec_LgFrmt) p%TwrAero, 'TwrAero', 'Calculate tower aerodynamic loads? '//TRIM(Msg)


   if (p_AD%WakeMod/=WakeMod_none) then
      WRITE (UnSu,'(A)') '======  Blade-Element/Momentum Theory Options  ======================================================'
      
      ! SkewMod 
      select case (InputFileData%SkewMod)
         case (SkewMod_Orthogonal)
            Msg = 'orthogonal'
         case (SkewMod_Uncoupled)
            Msg = 'uncoupled'
         case (SkewMod_PittPeters)
            Msg = 'Pitt/Peters' 
         case default      
            Msg = 'unknown'      
      end select
      WRITE (UnSu,Ec_IntFrmt) InputFileData%SkewMod, 'SkewMod', 'Type of skewed-wake correction model: '//TRIM(Msg)
      
      
      ! TipLoss
      if (InputFileData%TipLoss) then
         Msg = 'Yes'
      else
         Msg = 'No'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%TipLoss, 'TipLoss', "Use the Prandtl tip-loss model? "//TRIM(Msg)      
      
      
      ! HubLoss 
      if (InputFileData%HubLoss) then
         Msg = 'Yes'
      else
         Msg = 'No'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%HubLoss, 'HubLoss', "Use the Prandtl hub-loss model? "//TRIM(Msg)      

      
      ! TanInd  
      if (InputFileData%TanInd) then
         Msg = 'Yes'
      else
         Msg = 'No'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%TanInd, 'TanInd', "Include tangential induction in BEMT calculations? "//TRIM(Msg)      

      
      ! AIDrag 
      if (InputFileData%AIDrag) then
         Msg = 'Yes'
      else
         Msg = 'No'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%AIDrag, 'AIDrag', "Include the drag term in the axial-induction calculation? "//TRIM(Msg)      
      
      ! TIDrag  
      if (InputFileData%TIDrag .and. InputFileData%TanInd) then
         Msg = 'Yes'
      else
         Msg = 'No'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%TIDrag, 'TIDrag', "Include the drag term in the tangential-induction calculation? "//TRIM(Msg)      
      
      ! IndToler
      WRITE (UnSu,Ec_ReFrmt) InputFileData%IndToler, 'IndToler', "Convergence tolerance for BEM induction factors (radians)"     
      
      ! MaxIter 
      
      
      if (p_AD%WakeMod == WakeMod_DBEMT) then
         select case (InputFileData%DBEMT_Mod)
            case (DBEMT_tauConst)
               Msg = 'constant tau1'
            case (DBEMT_tauVaries)
               Msg = 'time-dependent tau1'
            case (DBEMT_cont_tauConst)
               Msg = 'continuous formulation with constant tau1'
            case default
               Msg = 'unknown'
         end select   
         
         WRITE (UnSu,Ec_IntFrmt) InputFileData%DBEMT_Mod, 'DBEMT_Mod', 'Type of dynamic BEMT (DBEMT) model: '//TRIM(Msg)
         
         if (InputFileData%DBEMT_Mod==DBEMT_tauConst) &
         WRITE (UnSu,Ec_ReFrmt) InputFileData%tau1_const, 'tau1_const', 'Time constant for DBEMT (s)'
         
      end if      
      
   end if
   
   if (InputFileData%AFAeroMod==AFAeroMod_BL_unsteady) then
      WRITE (UnSu,'(A)') '======  Beddoes-Leishman Unsteady Airfoil Aerodynamics Options  ====================================='
      
      ! UAMod
      select case (InputFileData%UAMod)
         case (UA_Baseline)
            Msg = 'baseline model (original)'
         case (UA_Gonzalez)
            Msg = "Gonzalez's variant (changes in Cn, Cc, and Cm)"
         case (UA_MinnemaPierce)
            Msg = 'Minnema/Pierce variant (changes in Cc and Cm)'      
         !case (4)
         !   Msg = 'DYSTOOL'      
         case (UA_HGM)
            Msg = 'HGM (continuous state)'
         case (UA_HGMV)
            Msg = 'HGMV (continuous state + vortex)'
         case (UA_OYE)
            Msg = 'Stieg Oye dynamic stall model'
         case (UA_BV)
            Msg = 'Boeing-Vertol dynamic stall model (e.g. used in CACTUS)'
         case default      
            Msg = 'unknown'      
      end select
      WRITE (UnSu,Ec_IntFrmt) InputFileData%UAMod, 'UAMod', 'Unsteady Aero Model: '//TRIM(Msg)
   
   
      ! FLookup
      if (InputFileData%FLookup) then
         Msg = 'Yes'
      else
         Msg = 'No, use best-fit exponential equations instead'
      end if   
      WRITE (UnSu,Ec_LgFrmt) InputFileData%FLookup, 'FLookup', "Use a lookup for f'? "//TRIM(Msg)      
      
   end if
   
   WRITE (UnSu,'(A)') '======  Outputs  ===================================================================================='
   
   OutPFmt = '( 49X, I11, 2X, I13 )'
   
   WRITE(UnSu,Ec_IntFrmt) p%NBlOuts,'NBlOuts','Number of blade nodes selected for output'
   if (p%NBlOuts > 0) then
      WRITE(UnSu,Ec_IntFrmt) p%NumBlNds,'NumBlNds','Number of blade nodes in the analysis'
      
      WRITE (UnSu,"(15x,A)")  'Blade nodes selected for output:  Output node  Analysis node'
      WRITE (UnSu,"(15x,A)")  '                                  -----------  -------------'
      DO I = 1,p%NBlOuts
         WRITE (UnSu,OutPFmt)  I, p%BlOutNd(I)
      END DO  
   end if
   
   WRITE(UnSu,Ec_IntFrmt) p%NTwOuts,'NTwOuts','Number of tower nodes selected for output'
   if (p%NTwOuts > 0) then
      WRITE(UnSu,Ec_IntFrmt) p%NumTwrNds,'NumTwrNds','Number of tower nodes in the analysis'
      WRITE (UnSu,"(15x,A)")  'Tower nodes selected for output:  Output node  Analysis node'
      WRITE (UnSu,"(15x,A)")  '                                  -----------  -------------'
      DO I = 1,p%NTwOuts
         WRITE (UnSu,OutPFmt)  I, p%TwOutNd(I)
      END DO  
   end if
   
   
   OutPFmt =  '( 15x, I4, 2X, A '//TRIM(Num2LStr(ChanLen))//',1 X, A'//TRIM(Num2LStr(ChanLen))//' )'
   WRITE (UnSu,'(15x,A)')  'Requested Output Channels:'
   WRITE (UnSu,'(15x,A)')  'Col   Parameter       Units'
   WRITE (UnSu,'(15x,A)')  '----  --------------  -----'

   DO I = 0,p%NumOuts
      WRITE (UnSu,OutPFmt)  I, p%OutParam(I)%Name, p%OutParam(I)%Units
   END DO             

   WRITE (UnSu,'(15x,A)')
   WRITE (UnSu,'(15x,A)')
   WRITE (UnSu,'(15x,A)')  'Requested Output Channels at each blade station:'
   WRITE (UnSu,'(15x,A)')  'Col   Parameter       Units'
   WRITE (UnSu,'(15x,A)')  '----  --------------  -----'
   DO I = 1,p%BldNd_NumOuts
      WRITE (UnSu,OutPFmt)  I, p%BldNd_OutParam(I)%Name, p%BldNd_OutParam(I)%Units
   END DO             

   CLOSE(UnSu)

RETURN
END SUBROUTINE AD_PrintSum
!----------------------------------------------------------------------------------------------------------------------------------


!**********************************************************************************************************************************
! NOTE: The following lines of code were generated by a Matlab script called "Write_ChckOutLst.m"
!      using the parameters listed in the "OutListParameters.xlsx" Excel file. Any changes to these 
!      lines should be modified in the Matlab script and/or Excel worksheet as necessary. 
!----------------------------------------------------------------------------------------------------------------------------------
!> This routine checks to see if any requested output channel names (stored in the OutList(:)) are invalid. It returns a 
!! warning if any of the channels are not available outputs from the module.
!!  It assigns the settings for OutParam(:) (i.e, the index, name, and units of the output channels, WriteOutput(:)).
!!  the sign is set to 0 if the channel is invalid.
!! It sets assumes the value p%NumOuts has been set before this routine has been called, and it sets the values of p%OutParam here.
!! 
!! This routine was generated by Write_ChckOutLst.m using the parameters listed in OutListParameters.xlsx at 01-Mar-2022 11:16:33.
SUBROUTINE SetOutParam(OutList, p, p_AD, ErrStat, ErrMsg )
!..................................................................................................................................

   IMPLICIT                        NONE

      ! Passed variables

   CHARACTER(ChanLen),        INTENT(IN)     :: OutList(:)                        !< The list out user-requested outputs
   TYPE(RotParameterType),    INTENT(INOUT)  :: p                                 !< The module parameters
   TYPE(AD_ParameterType),    INTENT(INOUT)  :: p_AD                              !< The module parameters
   INTEGER(IntKi),            INTENT(OUT)    :: ErrStat                           !< The error status code
   CHARACTER(*),              INTENT(OUT)    :: ErrMsg                            !< The error message, if an error occurred

      ! Local variables

   INTEGER                      :: ErrStat2                                        ! temporary (local) error status
   INTEGER                      :: I                                               ! Generic loop-counting index
   INTEGER                      :: J                                               ! Generic loop-counting index
   INTEGER                      :: INDX                                            ! Index for valid arrays

   LOGICAL                      :: CheckOutListAgain                               ! Flag used to determine if output parameter starting with "M" is valid (or the negative of another parameter)
   LOGICAL                      :: InvalidOutput(0:MaxOutPts)                      ! This array determines if the output channel is valid for this configuration
   CHARACTER(ChanLen)           :: OutListTmp                                      ! A string to temporarily hold OutList(I)
   CHARACTER(*), PARAMETER      :: RoutineName = "SetOutParam"

   CHARACTER(OutStrLenM1), PARAMETER  :: ValidParamAry(1270) =  (/  &   ! This lists the names of the allowed parameters, which must be sorted alphabetically
                               "B1AEROFX ","B1AEROFXG","B1AEROFY ","B1AEROFYG","B1AEROFZ ","B1AEROFZG","B1AEROMX ","B1AEROMXG", &
                               "B1AEROMY ","B1AEROMYG","B1AEROMZ ","B1AEROMZG","B1AEROPWR","B1AZIMUTH","B1N1ALPHA","B1N1AXIND", &
                               "B1N1CD   ","B1N1CL   ","B1N1CLRNC","B1N1CM   ","B1N1CN   ","B1N1CPMIN","B1N1CT   ","B1N1CURVE", &
                               "B1N1CX   ","B1N1CY   ","B1N1DYNP ","B1N1FD   ","B1N1FL   ","B1N1FN   ","B1N1FT   ","B1N1FX   ", &
                               "B1N1FY   ","B1N1GAM  ","B1N1M    ","B1N1MM   ","B1N1PHI  ","B1N1RE   ","B1N1SGCAV","B1N1SIGCR", &
                               "B1N1STVX ","B1N1STVY ","B1N1STVZ ","B1N1THETA","B1N1TNIND","B1N1VDISX","B1N1VDISY","B1N1VDISZ", &
                               "B1N1VINDX","B1N1VINDY","B1N1VREL ","B1N1VUNDX","B1N1VUNDY","B1N1VUNDZ","B1N2ALPHA","B1N2AXIND", &
                               "B1N2CD   ","B1N2CL   ","B1N2CLRNC","B1N2CM   ","B1N2CN   ","B1N2CPMIN","B1N2CT   ","B1N2CURVE", &
                               "B1N2CX   ","B1N2CY   ","B1N2DYNP ","B1N2FD   ","B1N2FL   ","B1N2FN   ","B1N2FT   ","B1N2FX   ", &
                               "B1N2FY   ","B1N2GAM  ","B1N2M    ","B1N2MM   ","B1N2PHI  ","B1N2RE   ","B1N2SGCAV","B1N2SIGCR", &
                               "B1N2STVX ","B1N2STVY ","B1N2STVZ ","B1N2THETA","B1N2TNIND","B1N2VDISX","B1N2VDISY","B1N2VDISZ", &
                               "B1N2VINDX","B1N2VINDY","B1N2VREL ","B1N2VUNDX","B1N2VUNDY","B1N2VUNDZ","B1N3ALPHA","B1N3AXIND", &
                               "B1N3CD   ","B1N3CL   ","B1N3CLRNC","B1N3CM   ","B1N3CN   ","B1N3CPMIN","B1N3CT   ","B1N3CURVE", &
                               "B1N3CX   ","B1N3CY   ","B1N3DYNP ","B1N3FD   ","B1N3FL   ","B1N3FN   ","B1N3FT   ","B1N3FX   ", &
                               "B1N3FY   ","B1N3GAM  ","B1N3M    ","B1N3MM   ","B1N3PHI  ","B1N3RE   ","B1N3SGCAV","B1N3SIGCR", &
                               "B1N3STVX ","B1N3STVY ","B1N3STVZ ","B1N3THETA","B1N3TNIND","B1N3VDISX","B1N3VDISY","B1N3VDISZ", &
                               "B1N3VINDX","B1N3VINDY","B1N3VREL ","B1N3VUNDX","B1N3VUNDY","B1N3VUNDZ","B1N4ALPHA","B1N4AXIND", &
                               "B1N4CD   ","B1N4CL   ","B1N4CLRNC","B1N4CM   ","B1N4CN   ","B1N4CPMIN","B1N4CT   ","B1N4CURVE", &
                               "B1N4CX   ","B1N4CY   ","B1N4DYNP ","B1N4FD   ","B1N4FL   ","B1N4FN   ","B1N4FT   ","B1N4FX   ", &
                               "B1N4FY   ","B1N4GAM  ","B1N4M    ","B1N4MM   ","B1N4PHI  ","B1N4RE   ","B1N4SGCAV","B1N4SIGCR", &
                               "B1N4STVX ","B1N4STVY ","B1N4STVZ ","B1N4THETA","B1N4TNIND","B1N4VDISX","B1N4VDISY","B1N4VDISZ", &
                               "B1N4VINDX","B1N4VINDY","B1N4VREL ","B1N4VUNDX","B1N4VUNDY","B1N4VUNDZ","B1N5ALPHA","B1N5AXIND", &
                               "B1N5CD   ","B1N5CL   ","B1N5CLRNC","B1N5CM   ","B1N5CN   ","B1N5CPMIN","B1N5CT   ","B1N5CURVE", &
                               "B1N5CX   ","B1N5CY   ","B1N5DYNP ","B1N5FD   ","B1N5FL   ","B1N5FN   ","B1N5FT   ","B1N5FX   ", &
                               "B1N5FY   ","B1N5GAM  ","B1N5M    ","B1N5MM   ","B1N5PHI  ","B1N5RE   ","B1N5SGCAV","B1N5SIGCR", &
                               "B1N5STVX ","B1N5STVY ","B1N5STVZ ","B1N5THETA","B1N5TNIND","B1N5VDISX","B1N5VDISY","B1N5VDISZ", &
                               "B1N5VINDX","B1N5VINDY","B1N5VREL ","B1N5VUNDX","B1N5VUNDY","B1N5VUNDZ","B1N6ALPHA","B1N6AXIND", &
                               "B1N6CD   ","B1N6CL   ","B1N6CLRNC","B1N6CM   ","B1N6CN   ","B1N6CPMIN","B1N6CT   ","B1N6CURVE", &
                               "B1N6CX   ","B1N6CY   ","B1N6DYNP ","B1N6FD   ","B1N6FL   ","B1N6FN   ","B1N6FT   ","B1N6FX   ", &
                               "B1N6FY   ","B1N6GAM  ","B1N6M    ","B1N6MM   ","B1N6PHI  ","B1N6RE   ","B1N6SGCAV","B1N6SIGCR", &
                               "B1N6STVX ","B1N6STVY ","B1N6STVZ ","B1N6THETA","B1N6TNIND","B1N6VDISX","B1N6VDISY","B1N6VDISZ", &
                               "B1N6VINDX","B1N6VINDY","B1N6VREL ","B1N6VUNDX","B1N6VUNDY","B1N6VUNDZ","B1N7ALPHA","B1N7AXIND", &
                               "B1N7CD   ","B1N7CL   ","B1N7CLRNC","B1N7CM   ","B1N7CN   ","B1N7CPMIN","B1N7CT   ","B1N7CURVE", &
                               "B1N7CX   ","B1N7CY   ","B1N7DYNP ","B1N7FD   ","B1N7FL   ","B1N7FN   ","B1N7FT   ","B1N7FX   ", &
                               "B1N7FY   ","B1N7GAM  ","B1N7M    ","B1N7MM   ","B1N7PHI  ","B1N7RE   ","B1N7SGCAV","B1N7SIGCR", &
                               "B1N7STVX ","B1N7STVY ","B1N7STVZ ","B1N7THETA","B1N7TNIND","B1N7VDISX","B1N7VDISY","B1N7VDISZ", &
                               "B1N7VINDX","B1N7VINDY","B1N7VREL ","B1N7VUNDX","B1N7VUNDY","B1N7VUNDZ","B1N8ALPHA","B1N8AXIND", &
                               "B1N8CD   ","B1N8CL   ","B1N8CLRNC","B1N8CM   ","B1N8CN   ","B1N8CPMIN","B1N8CT   ","B1N8CURVE", &
                               "B1N8CX   ","B1N8CY   ","B1N8DYNP ","B1N8FD   ","B1N8FL   ","B1N8FN   ","B1N8FT   ","B1N8FX   ", &
                               "B1N8FY   ","B1N8GAM  ","B1N8M    ","B1N8MM   ","B1N8PHI  ","B1N8RE   ","B1N8SGCAV","B1N8SIGCR", &
                               "B1N8STVX ","B1N8STVY ","B1N8STVZ ","B1N8THETA","B1N8TNIND","B1N8VDISX","B1N8VDISY","B1N8VDISZ", &
                               "B1N8VINDX","B1N8VINDY","B1N8VREL ","B1N8VUNDX","B1N8VUNDY","B1N8VUNDZ","B1N9ALPHA","B1N9AXIND", &
                               "B1N9CD   ","B1N9CL   ","B1N9CLRNC","B1N9CM   ","B1N9CN   ","B1N9CPMIN","B1N9CT   ","B1N9CURVE", &
                               "B1N9CX   ","B1N9CY   ","B1N9DYNP ","B1N9FD   ","B1N9FL   ","B1N9FN   ","B1N9FT   ","B1N9FX   ", &
                               "B1N9FY   ","B1N9GAM  ","B1N9M    ","B1N9MM   ","B1N9PHI  ","B1N9RE   ","B1N9SGCAV","B1N9SIGCR", &
                               "B1N9STVX ","B1N9STVY ","B1N9STVZ ","B1N9THETA","B1N9TNIND","B1N9VDISX","B1N9VDISY","B1N9VDISZ", &
                               "B1N9VINDX","B1N9VINDY","B1N9VREL ","B1N9VUNDX","B1N9VUNDY","B1N9VUNDZ","B1PITCH  ","B2AEROFX ", &
                               "B2AEROFXG","B2AEROFY ","B2AEROFYG","B2AEROFZ ","B2AEROFZG","B2AEROMX ","B2AEROMXG","B2AEROMY ", &
                               "B2AEROMYG","B2AEROMZ ","B2AEROMZG","B2AEROPWR","B2AZIMUTH","B2N1ALPHA","B2N1AXIND","B2N1CD   ", &
                               "B2N1CL   ","B2N1CLRNC","B2N1CM   ","B2N1CN   ","B2N1CPMIN","B2N1CT   ","B2N1CURVE","B2N1CX   ", &
                               "B2N1CY   ","B2N1DYNP ","B2N1FD   ","B2N1FL   ","B2N1FN   ","B2N1FT   ","B2N1FX   ","B2N1FY   ", &
                               "B2N1GAM  ","B2N1M    ","B2N1MM   ","B2N1PHI  ","B2N1RE   ","B2N1SGCAV","B2N1SIGCR","B2N1STVX ", &
                               "B2N1STVY ","B2N1STVZ ","B2N1THETA","B2N1TNIND","B2N1VDISX","B2N1VDISY","B2N1VDISZ","B2N1VINDX", &
                               "B2N1VINDY","B2N1VREL ","B2N1VUNDX","B2N1VUNDY","B2N1VUNDZ","B2N2ALPHA","B2N2AXIND","B2N2CD   ", &
                               "B2N2CL   ","B2N2CLRNC","B2N2CM   ","B2N2CN   ","B2N2CPMIN","B2N2CT   ","B2N2CURVE","B2N2CX   ", &
                               "B2N2CY   ","B2N2DYNP ","B2N2FD   ","B2N2FL   ","B2N2FN   ","B2N2FT   ","B2N2FX   ","B2N2FY   ", &
                               "B2N2GAM  ","B2N2M    ","B2N2MM   ","B2N2PHI  ","B2N2RE   ","B2N2SGCAV","B2N2SIGCR","B2N2STVX ", &
                               "B2N2STVY ","B2N2STVZ ","B2N2THETA","B2N2TNIND","B2N2VDISX","B2N2VDISY","B2N2VDISZ","B2N2VINDX", &
                               "B2N2VINDY","B2N2VREL ","B2N2VUNDX","B2N2VUNDY","B2N2VUNDZ","B2N3ALPHA","B2N3AXIND","B2N3CD   ", &
                               "B2N3CL   ","B2N3CLRNC","B2N3CM   ","B2N3CN   ","B2N3CPMIN","B2N3CT   ","B2N3CURVE","B2N3CX   ", &
                               "B2N3CY   ","B2N3DYNP ","B2N3FD   ","B2N3FL   ","B2N3FN   ","B2N3FT   ","B2N3FX   ","B2N3FY   ", &
                               "B2N3GAM  ","B2N3M    ","B2N3MM   ","B2N3PHI  ","B2N3RE   ","B2N3SGCAV","B2N3SIGCR","B2N3STVX ", &
                               "B2N3STVY ","B2N3STVZ ","B2N3THETA","B2N3TNIND","B2N3VDISX","B2N3VDISY","B2N3VDISZ","B2N3VINDX", &
                               "B2N3VINDY","B2N3VREL ","B2N3VUNDX","B2N3VUNDY","B2N3VUNDZ","B2N4ALPHA","B2N4AXIND","B2N4CD   ", &
                               "B2N4CL   ","B2N4CLRNC","B2N4CM   ","B2N4CN   ","B2N4CPMIN","B2N4CT   ","B2N4CURVE","B2N4CX   ", &
                               "B2N4CY   ","B2N4DYNP ","B2N4FD   ","B2N4FL   ","B2N4FN   ","B2N4FT   ","B2N4FX   ","B2N4FY   ", &
                               "B2N4GAM  ","B2N4M    ","B2N4MM   ","B2N4PHI  ","B2N4RE   ","B2N4SGCAV","B2N4SIGCR","B2N4STVX ", &
                               "B2N4STVY ","B2N4STVZ ","B2N4THETA","B2N4TNIND","B2N4VDISX","B2N4VDISY","B2N4VDISZ","B2N4VINDX", &
                               "B2N4VINDY","B2N4VREL ","B2N4VUNDX","B2N4VUNDY","B2N4VUNDZ","B2N5ALPHA","B2N5AXIND","B2N5CD   ", &
                               "B2N5CL   ","B2N5CLRNC","B2N5CM   ","B2N5CN   ","B2N5CPMIN","B2N5CT   ","B2N5CURVE","B2N5CX   ", &
                               "B2N5CY   ","B2N5DYNP ","B2N5FD   ","B2N5FL   ","B2N5FN   ","B2N5FT   ","B2N5FX   ","B2N5FY   ", &
                               "B2N5GAM  ","B2N5M    ","B2N5MM   ","B2N5PHI  ","B2N5RE   ","B2N5SGCAV","B2N5SIGCR","B2N5STVX ", &
                               "B2N5STVY ","B2N5STVZ ","B2N5THETA","B2N5TNIND","B2N5VDISX","B2N5VDISY","B2N5VDISZ","B2N5VINDX", &
                               "B2N5VINDY","B2N5VREL ","B2N5VUNDX","B2N5VUNDY","B2N5VUNDZ","B2N6ALPHA","B2N6AXIND","B2N6CD   ", &
                               "B2N6CL   ","B2N6CLRNC","B2N6CM   ","B2N6CN   ","B2N6CPMIN","B2N6CT   ","B2N6CURVE","B2N6CX   ", &
                               "B2N6CY   ","B2N6DYNP ","B2N6FD   ","B2N6FL   ","B2N6FN   ","B2N6FT   ","B2N6FX   ","B2N6FY   ", &
                               "B2N6GAM  ","B2N6M    ","B2N6MM   ","B2N6PHI  ","B2N6RE   ","B2N6SGCAV","B2N6SIGCR","B2N6STVX ", &
                               "B2N6STVY ","B2N6STVZ ","B2N6THETA","B2N6TNIND","B2N6VDISX","B2N6VDISY","B2N6VDISZ","B2N6VINDX", &
                               "B2N6VINDY","B2N6VREL ","B2N6VUNDX","B2N6VUNDY","B2N6VUNDZ","B2N7ALPHA","B2N7AXIND","B2N7CD   ", &
                               "B2N7CL   ","B2N7CLRNC","B2N7CM   ","B2N7CN   ","B2N7CPMIN","B2N7CT   ","B2N7CURVE","B2N7CX   ", &
                               "B2N7CY   ","B2N7DYNP ","B2N7FD   ","B2N7FL   ","B2N7FN   ","B2N7FT   ","B2N7FX   ","B2N7FY   ", &
                               "B2N7GAM  ","B2N7M    ","B2N7MM   ","B2N7PHI  ","B2N7RE   ","B2N7SGCAV","B2N7SIGCR","B2N7STVX ", &
                               "B2N7STVY ","B2N7STVZ ","B2N7THETA","B2N7TNIND","B2N7VDISX","B2N7VDISY","B2N7VDISZ","B2N7VINDX", &
                               "B2N7VINDY","B2N7VREL ","B2N7VUNDX","B2N7VUNDY","B2N7VUNDZ","B2N8ALPHA","B2N8AXIND","B2N8CD   ", &
                               "B2N8CL   ","B2N8CLRNC","B2N8CM   ","B2N8CN   ","B2N8CPMIN","B2N8CT   ","B2N8CURVE","B2N8CX   ", &
                               "B2N8CY   ","B2N8DYNP ","B2N8FD   ","B2N8FL   ","B2N8FN   ","B2N8FT   ","B2N8FX   ","B2N8FY   ", &
                               "B2N8GAM  ","B2N8M    ","B2N8MM   ","B2N8PHI  ","B2N8RE   ","B2N8SGCAV","B2N8SIGCR","B2N8STVX ", &
                               "B2N8STVY ","B2N8STVZ ","B2N8THETA","B2N8TNIND","B2N8VDISX","B2N8VDISY","B2N8VDISZ","B2N8VINDX", &
                               "B2N8VINDY","B2N8VREL ","B2N8VUNDX","B2N8VUNDY","B2N8VUNDZ","B2N9ALPHA","B2N9AXIND","B2N9CD   ", &
                               "B2N9CL   ","B2N9CLRNC","B2N9CM   ","B2N9CN   ","B2N9CPMIN","B2N9CT   ","B2N9CURVE","B2N9CX   ", &
                               "B2N9CY   ","B2N9DYNP ","B2N9FD   ","B2N9FL   ","B2N9FN   ","B2N9FT   ","B2N9FX   ","B2N9FY   ", &
                               "B2N9GAM  ","B2N9M    ","B2N9MM   ","B2N9PHI  ","B2N9RE   ","B2N9SGCAV","B2N9SIGCR","B2N9STVX ", &
                               "B2N9STVY ","B2N9STVZ ","B2N9THETA","B2N9TNIND","B2N9VDISX","B2N9VDISY","B2N9VDISZ","B2N9VINDX", &
                               "B2N9VINDY","B2N9VREL ","B2N9VUNDX","B2N9VUNDY","B2N9VUNDZ","B2PITCH  ","B3AEROFX ","B3AEROFXG", &
                               "B3AEROFY ","B3AEROFYG","B3AEROFZ ","B3AEROFZG","B3AEROMX ","B3AEROMXG","B3AEROMY ","B3AEROMYG", &
                               "B3AEROMZ ","B3AEROMZG","B3AEROPWR","B3AZIMUTH","B3N1ALPHA","B3N1AXIND","B3N1CD   ","B3N1CL   ", &
                               "B3N1CLRNC","B3N1CM   ","B3N1CN   ","B3N1CPMIN","B3N1CT   ","B3N1CURVE","B3N1CX   ","B3N1CY   ", &
                               "B3N1DYNP ","B3N1FD   ","B3N1FL   ","B3N1FN   ","B3N1FT   ","B3N1FX   ","B3N1FY   ","B3N1GAM  ", &
                               "B3N1M    ","B3N1MM   ","B3N1PHI  ","B3N1RE   ","B3N1SGCAV","B3N1SIGCR","B3N1STVX ","B3N1STVY ", &
                               "B3N1STVZ ","B3N1THETA","B3N1TNIND","B3N1VDISX","B3N1VDISY","B3N1VDISZ","B3N1VINDX","B3N1VINDY", &
                               "B3N1VREL ","B3N1VUNDX","B3N1VUNDY","B3N1VUNDZ","B3N2ALPHA","B3N2AXIND","B3N2CD   ","B3N2CL   ", &
                               "B3N2CLRNC","B3N2CM   ","B3N2CN   ","B3N2CPMIN","B3N2CT   ","B3N2CURVE","B3N2CX   ","B3N2CY   ", &
                               "B3N2DYNP ","B3N2FD   ","B3N2FL   ","B3N2FN   ","B3N2FT   ","B3N2FX   ","B3N2FY   ","B3N2GAM  ", &
                               "B3N2M    ","B3N2MM   ","B3N2PHI  ","B3N2RE   ","B3N2SGCAV","B3N2SIGCR","B3N2STVX ","B3N2STVY ", &
                               "B3N2STVZ ","B3N2THETA","B3N2TNIND","B3N2VDISX","B3N2VDISY","B3N2VDISZ","B3N2VINDX","B3N2VINDY", &
                               "B3N2VREL ","B3N2VUNDX","B3N2VUNDY","B3N2VUNDZ","B3N3ALPHA","B3N3AXIND","B3N3CD   ","B3N3CL   ", &
                               "B3N3CLRNC","B3N3CM   ","B3N3CN   ","B3N3CPMIN","B3N3CT   ","B3N3CURVE","B3N3CX   ","B3N3CY   ", &
                               "B3N3DYNP ","B3N3FD   ","B3N3FL   ","B3N3FN   ","B3N3FT   ","B3N3FX   ","B3N3FY   ","B3N3GAM  ", &
                               "B3N3M    ","B3N3MM   ","B3N3PHI  ","B3N3RE   ","B3N3SGCAV","B3N3SIGCR","B3N3STVX ","B3N3STVY ", &
                               "B3N3STVZ ","B3N3THETA","B3N3TNIND","B3N3VDISX","B3N3VDISY","B3N3VDISZ","B3N3VINDX","B3N3VINDY", &
                               "B3N3VREL ","B3N3VUNDX","B3N3VUNDY","B3N3VUNDZ","B3N4ALPHA","B3N4AXIND","B3N4CD   ","B3N4CL   ", &
                               "B3N4CLRNC","B3N4CM   ","B3N4CN   ","B3N4CPMIN","B3N4CT   ","B3N4CURVE","B3N4CX   ","B3N4CY   ", &
                               "B3N4DYNP ","B3N4FD   ","B3N4FL   ","B3N4FN   ","B3N4FT   ","B3N4FX   ","B3N4FY   ","B3N4GAM  ", &
                               "B3N4M    ","B3N4MM   ","B3N4PHI  ","B3N4RE   ","B3N4SGCAV","B3N4SIGCR","B3N4STVX ","B3N4STVY ", &
                               "B3N4STVZ ","B3N4THETA","B3N4TNIND","B3N4VDISX","B3N4VDISY","B3N4VDISZ","B3N4VINDX","B3N4VINDY", &
                               "B3N4VREL ","B3N4VUNDX","B3N4VUNDY","B3N4VUNDZ","B3N5ALPHA","B3N5AXIND","B3N5CD   ","B3N5CL   ", &
                               "B3N5CLRNC","B3N5CM   ","B3N5CN   ","B3N5CPMIN","B3N5CT   ","B3N5CURVE","B3N5CX   ","B3N5CY   ", &
                               "B3N5DYNP ","B3N5FD   ","B3N5FL   ","B3N5FN   ","B3N5FT   ","B3N5FX   ","B3N5FY   ","B3N5GAM  ", &
                               "B3N5M    ","B3N5MM   ","B3N5PHI  ","B3N5RE   ","B3N5SGCAV","B3N5SIGCR","B3N5STVX ","B3N5STVY ", &
                               "B3N5STVZ ","B3N5THETA","B3N5TNIND","B3N5VDISX","B3N5VDISY","B3N5VDISZ","B3N5VINDX","B3N5VINDY", &
                               "B3N5VREL ","B3N5VUNDX","B3N5VUNDY","B3N5VUNDZ","B3N6ALPHA","B3N6AXIND","B3N6CD   ","B3N6CL   ", &
                               "B3N6CLRNC","B3N6CM   ","B3N6CN   ","B3N6CPMIN","B3N6CT   ","B3N6CURVE","B3N6CX   ","B3N6CY   ", &
                               "B3N6DYNP ","B3N6FD   ","B3N6FL   ","B3N6FN   ","B3N6FT   ","B3N6FX   ","B3N6FY   ","B3N6GAM  ", &
                               "B3N6M    ","B3N6MM   ","B3N6PHI  ","B3N6RE   ","B3N6SGCAV","B3N6SIGCR","B3N6STVX ","B3N6STVY ", &
                               "B3N6STVZ ","B3N6THETA","B3N6TNIND","B3N6VDISX","B3N6VDISY","B3N6VDISZ","B3N6VINDX","B3N6VINDY", &
                               "B3N6VREL ","B3N6VUNDX","B3N6VUNDY","B3N6VUNDZ","B3N7ALPHA","B3N7AXIND","B3N7CD   ","B3N7CL   ", &
                               "B3N7CLRNC","B3N7CM   ","B3N7CN   ","B3N7CPMIN","B3N7CT   ","B3N7CURVE","B3N7CX   ","B3N7CY   ", &
                               "B3N7DYNP ","B3N7FD   ","B3N7FL   ","B3N7FN   ","B3N7FT   ","B3N7FX   ","B3N7FY   ","B3N7GAM  ", &
                               "B3N7M    ","B3N7MM   ","B3N7PHI  ","B3N7RE   ","B3N7SGCAV","B3N7SIGCR","B3N7STVX ","B3N7STVY ", &
                               "B3N7STVZ ","B3N7THETA","B3N7TNIND","B3N7VDISX","B3N7VDISY","B3N7VDISZ","B3N7VINDX","B3N7VINDY", &
                               "B3N7VREL ","B3N7VUNDX","B3N7VUNDY","B3N7VUNDZ","B3N8ALPHA","B3N8AXIND","B3N8CD   ","B3N8CL   ", &
                               "B3N8CLRNC","B3N8CM   ","B3N8CN   ","B3N8CPMIN","B3N8CT   ","B3N8CURVE","B3N8CX   ","B3N8CY   ", &
                               "B3N8DYNP ","B3N8FD   ","B3N8FL   ","B3N8FN   ","B3N8FT   ","B3N8FX   ","B3N8FY   ","B3N8GAM  ", &
                               "B3N8M    ","B3N8MM   ","B3N8PHI  ","B3N8RE   ","B3N8SGCAV","B3N8SIGCR","B3N8STVX ","B3N8STVY ", &
                               "B3N8STVZ ","B3N8THETA","B3N8TNIND","B3N8VDISX","B3N8VDISY","B3N8VDISZ","B3N8VINDX","B3N8VINDY", &
                               "B3N8VREL ","B3N8VUNDX","B3N8VUNDY","B3N8VUNDZ","B3N9ALPHA","B3N9AXIND","B3N9CD   ","B3N9CL   ", &
                               "B3N9CLRNC","B3N9CM   ","B3N9CN   ","B3N9CPMIN","B3N9CT   ","B3N9CURVE","B3N9CX   ","B3N9CY   ", &
                               "B3N9DYNP ","B3N9FD   ","B3N9FL   ","B3N9FN   ","B3N9FT   ","B3N9FX   ","B3N9FY   ","B3N9GAM  ", &
                               "B3N9M    ","B3N9MM   ","B3N9PHI  ","B3N9RE   ","B3N9SGCAV","B3N9SIGCR","B3N9STVX ","B3N9STVY ", &
                               "B3N9STVZ ","B3N9THETA","B3N9TNIND","B3N9VDISX","B3N9VDISY","B3N9VDISZ","B3N9VINDX","B3N9VINDY", &
                               "B3N9VREL ","B3N9VUNDX","B3N9VUNDY","B3N9VUNDZ","B3PITCH  ","B4AEROFX ","B4AEROFXG","B4AEROFY ", &
                               "B4AEROFYG","B4AEROFZ ","B4AEROFZG","B4AEROMX ","B4AEROMXG","B4AEROMY ","B4AEROMYG","B4AEROMZ ", &
                               "B4AEROMZG","B4AEROPWR","DBEMTAU1 ","RTAEROCP ","RTAEROCQ ","RTAEROCT ","RTAEROFXG","RTAEROFXH", &
                               "RTAEROFYG","RTAEROFYH","RTAEROFZG","RTAEROFZH","RTAEROMXG","RTAEROMXH","RTAEROMYG","RTAEROMYH", &
                               "RTAEROMZG","RTAEROMZH","RTAEROPWR","RTAREA   ","RTSKEW   ","RTSPEED  ","RTTSR    ","RTVAVGXH ", &
                               "RTVAVGYH ","RTVAVGZH ","TWN1DYNP ","TWN1FDX  ","TWN1FDY  ","TWN1M    ","TWN1RE   ","TWN1STVX ", &
                               "TWN1STVY ","TWN1STVZ ","TWN1VREL ","TWN1VUNDX","TWN1VUNDY","TWN1VUNDZ","TWN2DYNP ","TWN2FDX  ", &
                               "TWN2FDY  ","TWN2M    ","TWN2RE   ","TWN2STVX ","TWN2STVY ","TWN2STVZ ","TWN2VREL ","TWN2VUNDX", &
                               "TWN2VUNDY","TWN2VUNDZ","TWN3DYNP ","TWN3FDX  ","TWN3FDY  ","TWN3M    ","TWN3RE   ","TWN3STVX ", &
                               "TWN3STVY ","TWN3STVZ ","TWN3VREL ","TWN3VUNDX","TWN3VUNDY","TWN3VUNDZ","TWN4DYNP ","TWN4FDX  ", &
                               "TWN4FDY  ","TWN4M    ","TWN4RE   ","TWN4STVX ","TWN4STVY ","TWN4STVZ ","TWN4VREL ","TWN4VUNDX", &
                               "TWN4VUNDY","TWN4VUNDZ","TWN5DYNP ","TWN5FDX  ","TWN5FDY  ","TWN5M    ","TWN5RE   ","TWN5STVX ", &
                               "TWN5STVY ","TWN5STVZ ","TWN5VREL ","TWN5VUNDX","TWN5VUNDY","TWN5VUNDZ","TWN6DYNP ","TWN6FDX  ", &
                               "TWN6FDY  ","TWN6M    ","TWN6RE   ","TWN6STVX ","TWN6STVY ","TWN6STVZ ","TWN6VREL ","TWN6VUNDX", &
                               "TWN6VUNDY","TWN6VUNDZ","TWN7DYNP ","TWN7FDX  ","TWN7FDY  ","TWN7M    ","TWN7RE   ","TWN7STVX ", &
                               "TWN7STVY ","TWN7STVZ ","TWN7VREL ","TWN7VUNDX","TWN7VUNDY","TWN7VUNDZ","TWN8DYNP ","TWN8FDX  ", &
                               "TWN8FDY  ","TWN8M    ","TWN8RE   ","TWN8STVX ","TWN8STVY ","TWN8STVZ ","TWN8VREL ","TWN8VUNDX", &
                               "TWN8VUNDY","TWN8VUNDZ","TWN9DYNP ","TWN9FDX  ","TWN9FDY  ","TWN9M    ","TWN9RE   ","TWN9STVX ", &
                               "TWN9STVY ","TWN9STVZ ","TWN9VREL ","TWN9VUNDX","TWN9VUNDY","TWN9VUNDZ"/)
   INTEGER(IntKi), PARAMETER :: ParamIndxAry(1270) =  (/ &                            ! This lists the index into AllOuts(:) of the allowed parameters ValidParamAry(:)
                                 B1AeroFx , B1AeroFxg ,  B1AeroFy , B1AeroFyg ,  B1AeroFz , B1AeroFzg ,  B1AeroMx , B1AeroMxg , &
                                 B1AeroMy , B1AeroMyg ,  B1AeroMz , B1AeroMzg , B1AeroPwr , B1Azimuth , B1N1Alpha , B1N1AxInd , &
                                   B1N1Cd ,    B1N1Cl , B1N1Clrnc ,    B1N1Cm ,    B1N1Cn , B1N1Cpmin ,    B1N1Ct , B1N1Curve , &
                                   B1N1Cx ,    B1N1Cy ,  B1N1DynP ,    B1N1Fd ,    B1N1Fl ,    B1N1Fn ,    B1N1Ft ,    B1N1Fx , &
                                   B1N1Fy ,   B1N1Gam ,     B1N1M ,    B1N1Mm ,   B1N1Phi ,    B1N1Re , B1N1SgCav , B1N1SigCr , &
                                 B1N1STVx ,  B1N1STVy ,  B1N1STVz , B1N1Theta , B1N1TnInd , B1N1VDisx , B1N1VDisy , B1N1VDisz , &
                                B1N1Vindx , B1N1Vindy ,  B1N1VRel , B1N1VUndx , B1N1VUndy , B1N1VUndz , B1N2Alpha , B1N2AxInd , &
                                   B1N2Cd ,    B1N2Cl , B1N2Clrnc ,    B1N2Cm ,    B1N2Cn , B1N2Cpmin ,    B1N2Ct , B1N2Curve , &
                                   B1N2Cx ,    B1N2Cy ,  B1N2DynP ,    B1N2Fd ,    B1N2Fl ,    B1N2Fn ,    B1N2Ft ,    B1N2Fx , &
                                   B1N2Fy ,   B1N2Gam ,     B1N2M ,    B1N2Mm ,   B1N2Phi ,    B1N2Re , B1N2SgCav , B1N2SigCr , &
                                 B1N2STVx ,  B1N2STVy ,  B1N2STVz , B1N2Theta , B1N2TnInd , B1N2VDisx , B1N2VDisy , B1N2VDisz , &
                                B1N2Vindx , B1N2Vindy ,  B1N2VRel , B1N2VUndx , B1N2VUndy , B1N2VUndz , B1N3Alpha , B1N3AxInd , &
                                   B1N3Cd ,    B1N3Cl , B1N3Clrnc ,    B1N3Cm ,    B1N3Cn , B1N3Cpmin ,    B1N3Ct , B1N3Curve , &
                                   B1N3Cx ,    B1N3Cy ,  B1N3DynP ,    B1N3Fd ,    B1N3Fl ,    B1N3Fn ,    B1N3Ft ,    B1N3Fx , &
                                   B1N3Fy ,   B1N3Gam ,     B1N3M ,    B1N3Mm ,   B1N3Phi ,    B1N3Re , B1N3SgCav , B1N3SigCr , &
                                 B1N3STVx ,  B1N3STVy ,  B1N3STVz , B1N3Theta , B1N3TnInd , B1N3VDisx , B1N3VDisy , B1N3VDisz , &
                                B1N3Vindx , B1N3Vindy ,  B1N3VRel , B1N3VUndx , B1N3VUndy , B1N3VUndz , B1N4Alpha , B1N4AxInd , &
                                   B1N4Cd ,    B1N4Cl , B1N4Clrnc ,    B1N4Cm ,    B1N4Cn , B1N4Cpmin ,    B1N4Ct , B1N4Curve , &
                                   B1N4Cx ,    B1N4Cy ,  B1N4DynP ,    B1N4Fd ,    B1N4Fl ,    B1N4Fn ,    B1N4Ft ,    B1N4Fx , &
                                   B1N4Fy ,   B1N4Gam ,     B1N4M ,    B1N4Mm ,   B1N4Phi ,    B1N4Re , B1N4SgCav , B1N4SigCr , &
                                 B1N4STVx ,  B1N4STVy ,  B1N4STVz , B1N4Theta , B1N4TnInd , B1N4VDisx , B1N4VDisy , B1N4VDisz , &
                                B1N4Vindx , B1N4Vindy ,  B1N4VRel , B1N4VUndx , B1N4VUndy , B1N4VUndz , B1N5Alpha , B1N5AxInd , &
                                   B1N5Cd ,    B1N5Cl , B1N5Clrnc ,    B1N5Cm ,    B1N5Cn , B1N5Cpmin ,    B1N5Ct , B1N5Curve , &
                                   B1N5Cx ,    B1N5Cy ,  B1N5DynP ,    B1N5Fd ,    B1N5Fl ,    B1N5Fn ,    B1N5Ft ,    B1N5Fx , &
                                   B1N5Fy ,   B1N5Gam ,     B1N5M ,    B1N5Mm ,   B1N5Phi ,    B1N5Re , B1N5SgCav , B1N5SigCr , &
                                 B1N5STVx ,  B1N5STVy ,  B1N5STVz , B1N5Theta , B1N5TnInd , B1N5VDisx , B1N5VDisy , B1N5VDisz , &
                                B1N5Vindx , B1N5Vindy ,  B1N5VRel , B1N5VUndx , B1N5VUndy , B1N5VUndz , B1N6Alpha , B1N6AxInd , &
                                   B1N6Cd ,    B1N6Cl , B1N6Clrnc ,    B1N6Cm ,    B1N6Cn , B1N6Cpmin ,    B1N6Ct , B1N6Curve , &
                                   B1N6Cx ,    B1N6Cy ,  B1N6DynP ,    B1N6Fd ,    B1N6Fl ,    B1N6Fn ,    B1N6Ft ,    B1N6Fx , &
                                   B1N6Fy ,   B1N6Gam ,     B1N6M ,    B1N6Mm ,   B1N6Phi ,    B1N6Re , B1N6SgCav , B1N6SigCr , &
                                 B1N6STVx ,  B1N6STVy ,  B1N6STVz , B1N6Theta , B1N6TnInd , B1N6VDisx , B1N6VDisy , B1N6VDisz , &
                                B1N6Vindx , B1N6Vindy ,  B1N6VRel , B1N6VUndx , B1N6VUndy , B1N6VUndz , B1N7Alpha , B1N7AxInd , &
                                   B1N7Cd ,    B1N7Cl , B1N7Clrnc ,    B1N7Cm ,    B1N7Cn , B1N7Cpmin ,    B1N7Ct , B1N7Curve , &
                                   B1N7Cx ,    B1N7Cy ,  B1N7DynP ,    B1N7Fd ,    B1N7Fl ,    B1N7Fn ,    B1N7Ft ,    B1N7Fx , &
                                   B1N7Fy ,   B1N7Gam ,     B1N7M ,    B1N7Mm ,   B1N7Phi ,    B1N7Re , B1N7SgCav , B1N7SigCr , &
                                 B1N7STVx ,  B1N7STVy ,  B1N7STVz , B1N7Theta , B1N7TnInd , B1N7VDisx , B1N7VDisy , B1N7VDisz , &
                                B1N7Vindx , B1N7Vindy ,  B1N7VRel , B1N7VUndx , B1N7VUndy , B1N7VUndz , B1N8Alpha , B1N8AxInd , &
                                   B1N8Cd ,    B1N8Cl , B1N8Clrnc ,    B1N8Cm ,    B1N8Cn , B1N8Cpmin ,    B1N8Ct , B1N8Curve , &
                                   B1N8Cx ,    B1N8Cy ,  B1N8DynP ,    B1N8Fd ,    B1N8Fl ,    B1N8Fn ,    B1N8Ft ,    B1N8Fx , &
                                   B1N8Fy ,   B1N8Gam ,     B1N8M ,    B1N8Mm ,   B1N8Phi ,    B1N8Re , B1N8SgCav , B1N8SigCr , &
                                 B1N8STVx ,  B1N8STVy ,  B1N8STVz , B1N8Theta , B1N8TnInd , B1N8VDisx , B1N8VDisy , B1N8VDisz , &
                                B1N8Vindx , B1N8Vindy ,  B1N8VRel , B1N8VUndx , B1N8VUndy , B1N8VUndz , B1N9Alpha , B1N9AxInd , &
                                   B1N9Cd ,    B1N9Cl , B1N9Clrnc ,    B1N9Cm ,    B1N9Cn , B1N9Cpmin ,    B1N9Ct , B1N9Curve , &
                                   B1N9Cx ,    B1N9Cy ,  B1N9DynP ,    B1N9Fd ,    B1N9Fl ,    B1N9Fn ,    B1N9Ft ,    B1N9Fx , &
                                   B1N9Fy ,   B1N9Gam ,     B1N9M ,    B1N9Mm ,   B1N9Phi ,    B1N9Re , B1N9SgCav , B1N9SigCr , &
                                 B1N9STVx ,  B1N9STVy ,  B1N9STVz , B1N9Theta , B1N9TnInd , B1N9VDisx , B1N9VDisy , B1N9VDisz , &
                                B1N9Vindx , B1N9Vindy ,  B1N9VRel , B1N9VUndx , B1N9VUndy , B1N9VUndz ,   B1Pitch ,  B2AeroFx , &
                                B2AeroFxg ,  B2AeroFy , B2AeroFyg ,  B2AeroFz , B2AeroFzg ,  B2AeroMx , B2AeroMxg ,  B2AeroMy , &
                                B2AeroMyg ,  B2AeroMz , B2AeroMzg , B2AeroPwr , B2Azimuth , B2N1Alpha , B2N1AxInd ,    B2N1Cd , &
                                   B2N1Cl , B2N1Clrnc ,    B2N1Cm ,    B2N1Cn , B2N1Cpmin ,    B2N1Ct , B2N1Curve ,    B2N1Cx , &
                                   B2N1Cy ,  B2N1DynP ,    B2N1Fd ,    B2N1Fl ,    B2N1Fn ,    B2N1Ft ,    B2N1Fx ,    B2N1Fy , &
                                  B2N1Gam ,     B2N1M ,    B2N1Mm ,   B2N1Phi ,    B2N1Re , B2N1SgCav , B2N1SigCr ,  B2N1STVx , &
                                 B2N1STVy ,  B2N1STVz , B2N1Theta , B2N1TnInd , B2N1VDisx , B2N1VDisy , B2N1VDisz , B2N1Vindx , &
                                B2N1Vindy ,  B2N1VRel , B2N1VUndx , B2N1VUndy , B2N1VUndz , B2N2Alpha , B2N2AxInd ,    B2N2Cd , &
                                   B2N2Cl , B2N2Clrnc ,    B2N2Cm ,    B2N2Cn , B2N2Cpmin ,    B2N2Ct , B2N2Curve ,    B2N2Cx , &
                                   B2N2Cy ,  B2N2DynP ,    B2N2Fd ,    B2N2Fl ,    B2N2Fn ,    B2N2Ft ,    B2N2Fx ,    B2N2Fy , &
                                  B2N2Gam ,     B2N2M ,    B2N2Mm ,   B2N2Phi ,    B2N2Re , B2N2SgCav , B2N2SigCr ,  B2N2STVx , &
                                 B2N2STVy ,  B2N2STVz , B2N2Theta , B2N2TnInd , B2N2VDisx , B2N2VDisy , B2N2VDisz , B2N2Vindx , &
                                B2N2Vindy ,  B2N2VRel , B2N2VUndx , B2N2VUndy , B2N2VUndz , B2N3Alpha , B2N3AxInd ,    B2N3Cd , &
                                   B2N3Cl , B2N3Clrnc ,    B2N3Cm ,    B2N3Cn , B2N3Cpmin ,    B2N3Ct , B2N3Curve ,    B2N3Cx , &
                                   B2N3Cy ,  B2N3DynP ,    B2N3Fd ,    B2N3Fl ,    B2N3Fn ,    B2N3Ft ,    B2N3Fx ,    B2N3Fy , &
                                  B2N3Gam ,     B2N3M ,    B2N3Mm ,   B2N3Phi ,    B2N3Re , B2N3SgCav , B2N3SigCr ,  B2N3STVx , &
                                 B2N3STVy ,  B2N3STVz , B2N3Theta , B2N3TnInd , B2N3VDisx , B2N3VDisy , B2N3VDisz , B2N3Vindx , &
                                B2N3Vindy ,  B2N3VRel , B2N3VUndx , B2N3VUndy , B2N3VUndz , B2N4Alpha , B2N4AxInd ,    B2N4Cd , &
                                   B2N4Cl , B2N4Clrnc ,    B2N4Cm ,    B2N4Cn , B2N4Cpmin ,    B2N4Ct , B2N4Curve ,    B2N4Cx , &
                                   B2N4Cy ,  B2N4DynP ,    B2N4Fd ,    B2N4Fl ,    B2N4Fn ,    B2N4Ft ,    B2N4Fx ,    B2N4Fy , &
                                  B2N4Gam ,     B2N4M ,    B2N4Mm ,   B2N4Phi ,    B2N4Re , B2N4SgCav , B2N4SigCr ,  B2N4STVx , &
                                 B2N4STVy ,  B2N4STVz , B2N4Theta , B2N4TnInd , B2N4VDisx , B2N4VDisy , B2N4VDisz , B2N4Vindx , &
                                B2N4Vindy ,  B2N4VRel , B2N4VUndx , B2N4VUndy , B2N4VUndz , B2N5Alpha , B2N5AxInd ,    B2N5Cd , &
                                   B2N5Cl , B2N5Clrnc ,    B2N5Cm ,    B2N5Cn , B2N5Cpmin ,    B2N5Ct , B2N5Curve ,    B2N5Cx , &
                                   B2N5Cy ,  B2N5DynP ,    B2N5Fd ,    B2N5Fl ,    B2N5Fn ,    B2N5Ft ,    B2N5Fx ,    B2N5Fy , &
                                  B2N5Gam ,     B2N5M ,    B2N5Mm ,   B2N5Phi ,    B2N5Re , B2N5SgCav , B2N5SigCr ,  B2N5STVx , &
                                 B2N5STVy ,  B2N5STVz , B2N5Theta , B2N5TnInd , B2N5VDisx , B2N5VDisy , B2N5VDisz , B2N5Vindx , &
                                B2N5Vindy ,  B2N5VRel , B2N5VUndx , B2N5VUndy , B2N5VUndz , B2N6Alpha , B2N6AxInd ,    B2N6Cd , &
                                   B2N6Cl , B2N6Clrnc ,    B2N6Cm ,    B2N6Cn , B2N6Cpmin ,    B2N6Ct , B2N6Curve ,    B2N6Cx , &
                                   B2N6Cy ,  B2N6DynP ,    B2N6Fd ,    B2N6Fl ,    B2N6Fn ,    B2N6Ft ,    B2N6Fx ,    B2N6Fy , &
                                  B2N6Gam ,     B2N6M ,    B2N6Mm ,   B2N6Phi ,    B2N6Re , B2N6SgCav , B2N6SigCr ,  B2N6STVx , &
                                 B2N6STVy ,  B2N6STVz , B2N6Theta , B2N6TnInd , B2N6VDisx , B2N6VDisy , B2N6VDisz , B2N6Vindx , &
                                B2N6Vindy ,  B2N6VRel , B2N6VUndx , B2N6VUndy , B2N6VUndz , B2N7Alpha , B2N7AxInd ,    B2N7Cd , &
                                   B2N7Cl , B2N7Clrnc ,    B2N7Cm ,    B2N7Cn , B2N7Cpmin ,    B2N7Ct , B2N7Curve ,    B2N7Cx , &
                                   B2N7Cy ,  B2N7DynP ,    B2N7Fd ,    B2N7Fl ,    B2N7Fn ,    B2N7Ft ,    B2N7Fx ,    B2N7Fy , &
                                  B2N7Gam ,     B2N7M ,    B2N7Mm ,   B2N7Phi ,    B2N7Re , B2N7SgCav , B2N7SigCr ,  B2N7STVx , &
                                 B2N7STVy ,  B2N7STVz , B2N7Theta , B2N7TnInd , B2N7VDisx , B2N7VDisy , B2N7VDisz , B2N7Vindx , &
                                B2N7Vindy ,  B2N7VRel , B2N7VUndx , B2N7VUndy , B2N7VUndz , B2N8Alpha , B2N8AxInd ,    B2N8Cd , &
                                   B2N8Cl , B2N8Clrnc ,    B2N8Cm ,    B2N8Cn , B2N8Cpmin ,    B2N8Ct , B2N8Curve ,    B2N8Cx , &
                                   B2N8Cy ,  B2N8DynP ,    B2N8Fd ,    B2N8Fl ,    B2N8Fn ,    B2N8Ft ,    B2N8Fx ,    B2N8Fy , &
                                  B2N8Gam ,     B2N8M ,    B2N8Mm ,   B2N8Phi ,    B2N8Re , B2N8SgCav , B2N8SigCr ,  B2N8STVx , &
                                 B2N8STVy ,  B2N8STVz , B2N8Theta , B2N8TnInd , B2N8VDisx , B2N8VDisy , B2N8VDisz , B2N8Vindx , &
                                B2N8Vindy ,  B2N8VRel , B2N8VUndx , B2N8VUndy , B2N8VUndz , B2N9Alpha , B2N9AxInd ,    B2N9Cd , &
                                   B2N9Cl , B2N9Clrnc ,    B2N9Cm ,    B2N9Cn , B2N9Cpmin ,    B2N9Ct , B2N9Curve ,    B2N9Cx , &
                                   B2N9Cy ,  B2N9DynP ,    B2N9Fd ,    B2N9Fl ,    B2N9Fn ,    B2N9Ft ,    B2N9Fx ,    B2N9Fy , &
                                  B2N9Gam ,     B2N9M ,    B2N9Mm ,   B2N9Phi ,    B2N9Re , B2N9SgCav , B2N9SigCr ,  B2N9STVx , &
                                 B2N9STVy ,  B2N9STVz , B2N9Theta , B2N9TnInd , B2N9VDisx , B2N9VDisy , B2N9VDisz , B2N9Vindx , &
                                B2N9Vindy ,  B2N9VRel , B2N9VUndx , B2N9VUndy , B2N9VUndz ,   B2Pitch ,  B3AeroFx , B3AeroFxg , &
                                 B3AeroFy , B3AeroFyg ,  B3AeroFz , B3AeroFzg ,  B3AeroMx , B3AeroMxg ,  B3AeroMy , B3AeroMyg , &
                                 B3AeroMz , B3AeroMzg , B3AeroPwr , B3Azimuth , B3N1Alpha , B3N1AxInd ,    B3N1Cd ,    B3N1Cl , &
                                B3N1Clrnc ,    B3N1Cm ,    B3N1Cn , B3N1Cpmin ,    B3N1Ct , B3N1Curve ,    B3N1Cx ,    B3N1Cy , &
                                 B3N1DynP ,    B3N1Fd ,    B3N1Fl ,    B3N1Fn ,    B3N1Ft ,    B3N1Fx ,    B3N1Fy ,   B3N1Gam , &
                                    B3N1M ,    B3N1Mm ,   B3N1Phi ,    B3N1Re , B3N1SgCav , B3N1SigCr ,  B3N1STVx ,  B3N1STVy , &
                                 B3N1STVz , B3N1Theta , B3N1TnInd , B3N1VDisx , B3N1VDisy , B3N1VDisz , B3N1Vindx , B3N1Vindy , &
                                 B3N1VRel , B3N1VUndx , B3N1VUndy , B3N1VUndz , B3N2Alpha , B3N2AxInd ,    B3N2Cd ,    B3N2Cl , &
                                B3N2Clrnc ,    B3N2Cm ,    B3N2Cn , B3N2Cpmin ,    B3N2Ct , B3N2Curve ,    B3N2Cx ,    B3N2Cy , &
                                 B3N2DynP ,    B3N2Fd ,    B3N2Fl ,    B3N2Fn ,    B3N2Ft ,    B3N2Fx ,    B3N2Fy ,   B3N2Gam , &
                                    B3N2M ,    B3N2Mm ,   B3N2Phi ,    B3N2Re , B3N2SgCav , B3N2SigCr ,  B3N2STVx ,  B3N2STVy , &
                                 B3N2STVz , B3N2Theta , B3N2TnInd , B3N2VDisx , B3N2VDisy , B3N2VDisz , B3N2Vindx , B3N2Vindy , &
                                 B3N2VRel , B3N2VUndx , B3N2VUndy , B3N2VUndz , B3N3Alpha , B3N3AxInd ,    B3N3Cd ,    B3N3Cl , &
                                B3N3Clrnc ,    B3N3Cm ,    B3N3Cn , B3N3Cpmin ,    B3N3Ct , B3N3Curve ,    B3N3Cx ,    B3N3Cy , &
                                 B3N3DynP ,    B3N3Fd ,    B3N3Fl ,    B3N3Fn ,    B3N3Ft ,    B3N3Fx ,    B3N3Fy ,   B3N3Gam , &
                                    B3N3M ,    B3N3Mm ,   B3N3Phi ,    B3N3Re , B3N3SgCav , B3N3SigCr ,  B3N3STVx ,  B3N3STVy , &
                                 B3N3STVz , B3N3Theta , B3N3TnInd , B3N3VDisx , B3N3VDisy , B3N3VDisz , B3N3Vindx , B3N3Vindy , &
                                 B3N3VRel , B3N3VUndx , B3N3VUndy , B3N3VUndz , B3N4Alpha , B3N4AxInd ,    B3N4Cd ,    B3N4Cl , &
                                B3N4Clrnc ,    B3N4Cm ,    B3N4Cn , B3N4Cpmin ,    B3N4Ct , B3N4Curve ,    B3N4Cx ,    B3N4Cy , &
                                 B3N4DynP ,    B3N4Fd ,    B3N4Fl ,    B3N4Fn ,    B3N4Ft ,    B3N4Fx ,    B3N4Fy ,   B3N4Gam , &
                                    B3N4M ,    B3N4Mm ,   B3N4Phi ,    B3N4Re , B3N4SgCav , B3N4SigCr ,  B3N4STVx ,  B3N4STVy , &
                                 B3N4STVz , B3N4Theta , B3N4TnInd , B3N4VDisx , B3N4VDisy , B3N4VDisz , B3N4Vindx , B3N4Vindy , &
                                 B3N4VRel , B3N4VUndx , B3N4VUndy , B3N4VUndz , B3N5Alpha , B3N5AxInd ,    B3N5Cd ,    B3N5Cl , &
                                B3N5Clrnc ,    B3N5Cm ,    B3N5Cn , B3N5Cpmin ,    B3N5Ct , B3N5Curve ,    B3N5Cx ,    B3N5Cy , &
                                 B3N5DynP ,    B3N5Fd ,    B3N5Fl ,    B3N5Fn ,    B3N5Ft ,    B3N5Fx ,    B3N5Fy ,   B3N5Gam , &
                                    B3N5M ,    B3N5Mm ,   B3N5Phi ,    B3N5Re , B3N5SgCav , B3N5SigCr ,  B3N5STVx ,  B3N5STVy , &
                                 B3N5STVz , B3N5Theta , B3N5TnInd , B3N5VDisx , B3N5VDisy , B3N5VDisz , B3N5Vindx , B3N5Vindy , &
                                 B3N5VRel , B3N5VUndx , B3N5VUndy , B3N5VUndz , B3N6Alpha , B3N6AxInd ,    B3N6Cd ,    B3N6Cl , &
                                B3N6Clrnc ,    B3N6Cm ,    B3N6Cn , B3N6Cpmin ,    B3N6Ct , B3N6Curve ,    B3N6Cx ,    B3N6Cy , &
                                 B3N6DynP ,    B3N6Fd ,    B3N6Fl ,    B3N6Fn ,    B3N6Ft ,    B3N6Fx ,    B3N6Fy ,   B3N6Gam , &
                                    B3N6M ,    B3N6Mm ,   B3N6Phi ,    B3N6Re , B3N6SgCav , B3N6SigCr ,  B3N6STVx ,  B3N6STVy , &
                                 B3N6STVz , B3N6Theta , B3N6TnInd , B3N6VDisx , B3N6VDisy , B3N6VDisz , B3N6Vindx , B3N6Vindy , &
                                 B3N6VRel , B3N6VUndx , B3N6VUndy , B3N6VUndz , B3N7Alpha , B3N7AxInd ,    B3N7Cd ,    B3N7Cl , &
                                B3N7Clrnc ,    B3N7Cm ,    B3N7Cn , B3N7Cpmin ,    B3N7Ct , B3N7Curve ,    B3N7Cx ,    B3N7Cy , &
                                 B3N7DynP ,    B3N7Fd ,    B3N7Fl ,    B3N7Fn ,    B3N7Ft ,    B3N7Fx ,    B3N7Fy ,   B3N7Gam , &
                                    B3N7M ,    B3N7Mm ,   B3N7Phi ,    B3N7Re , B3N7SgCav , B3N7SigCr ,  B3N7STVx ,  B3N7STVy , &
                                 B3N7STVz , B3N7Theta , B3N7TnInd , B3N7VDisx , B3N7VDisy , B3N7VDisz , B3N7Vindx , B3N7Vindy , &
                                 B3N7VRel , B3N7VUndx , B3N7VUndy , B3N7VUndz , B3N8Alpha , B3N8AxInd ,    B3N8Cd ,    B3N8Cl , &
                                B3N8Clrnc ,    B3N8Cm ,    B3N8Cn , B3N8Cpmin ,    B3N8Ct , B3N8Curve ,    B3N8Cx ,    B3N8Cy , &
                                 B3N8DynP ,    B3N8Fd ,    B3N8Fl ,    B3N8Fn ,    B3N8Ft ,    B3N8Fx ,    B3N8Fy ,   B3N8Gam , &
                                    B3N8M ,    B3N8Mm ,   B3N8Phi ,    B3N8Re , B3N8SgCav , B3N8SigCr ,  B3N8STVx ,  B3N8STVy , &
                                 B3N8STVz , B3N8Theta , B3N8TnInd , B3N8VDisx , B3N8VDisy , B3N8VDisz , B3N8Vindx , B3N8Vindy , &
                                 B3N8VRel , B3N8VUndx , B3N8VUndy , B3N8VUndz , B3N9Alpha , B3N9AxInd ,    B3N9Cd ,    B3N9Cl , &
                                B3N9Clrnc ,    B3N9Cm ,    B3N9Cn , B3N9Cpmin ,    B3N9Ct , B3N9Curve ,    B3N9Cx ,    B3N9Cy , &
                                 B3N9DynP ,    B3N9Fd ,    B3N9Fl ,    B3N9Fn ,    B3N9Ft ,    B3N9Fx ,    B3N9Fy ,   B3N9Gam , &
                                    B3N9M ,    B3N9Mm ,   B3N9Phi ,    B3N9Re , B3N9SgCav , B3N9SigCr ,  B3N9STVx ,  B3N9STVy , &
                                 B3N9STVz , B3N9Theta , B3N9TnInd , B3N9VDisx , B3N9VDisy , B3N9VDisz , B3N9Vindx , B3N9Vindy , &
                                 B3N9VRel , B3N9VUndx , B3N9VUndy , B3N9VUndz ,   B3Pitch ,  B4AeroFx , B4AeroFxg ,  B4AeroFy , &
                                B4AeroFyg ,  B4AeroFz , B4AeroFzg ,  B4AeroMx , B4AeroMxg ,  B4AeroMy , B4AeroMyg ,  B4AeroMz , &
                                B4AeroMzg , B4AeroPwr ,  DBEMTau1 ,  RtAeroCp ,  RtAeroCq ,  RtAeroCt , RtAeroFxg , RtAeroFxh , &
                                RtAeroFyg , RtAeroFyh , RtAeroFzg , RtAeroFzh , RtAeroMxg , RtAeroMxh , RtAeroMyg , RtAeroMyh , &
                                RtAeroMzg , RtAeroMzh , RtAeroPwr ,    RtArea ,    RtSkew ,   RtSpeed ,     RtTSR ,  RtVAvgxh , &
                                 RtVAvgyh ,  RtVAvgzh ,  TwN1DynP ,   TwN1Fdx ,   TwN1Fdy ,     TwN1M ,    TwN1Re ,  TwN1STVx , &
                                 TwN1STVy ,  TwN1STVz ,  TwN1Vrel , TwN1VUndx , TwN1VUndy , TwN1VUndz ,  TwN2DynP ,   TwN2Fdx , &
                                  TwN2Fdy ,     TwN2M ,    TwN2Re ,  TwN2STVx ,  TwN2STVy ,  TwN2STVz ,  TwN2Vrel , TwN2VUndx , &
                                TwN2VUndy , TwN2VUndz ,  TwN3DynP ,   TwN3Fdx ,   TwN3Fdy ,     TwN3M ,    TwN3Re ,  TwN3STVx , &
                                 TwN3STVy ,  TwN3STVz ,  TwN3Vrel , TwN3VUndx , TwN3VUndy , TwN3VUndz ,  TwN4DynP ,   TwN4Fdx , &
                                  TwN4Fdy ,     TwN4M ,    TwN4Re ,  TwN4STVx ,  TwN4STVy ,  TwN4STVz ,  TwN4Vrel , TwN4VUndx , &
                                TwN4VUndy , TwN4VUndz ,  TwN5DynP ,   TwN5Fdx ,   TwN5Fdy ,     TwN5M ,    TwN5Re ,  TwN5STVx , &
                                 TwN5STVy ,  TwN5STVz ,  TwN5Vrel , TwN5VUndx , TwN5VUndy , TwN5VUndz ,  TwN6DynP ,   TwN6Fdx , &
                                  TwN6Fdy ,     TwN6M ,    TwN6Re ,  TwN6STVx ,  TwN6STVy ,  TwN6STVz ,  TwN6Vrel , TwN6VUndx , &
                                TwN6VUndy , TwN6VUndz ,  TwN7DynP ,   TwN7Fdx ,   TwN7Fdy ,     TwN7M ,    TwN7Re ,  TwN7STVx , &
                                 TwN7STVy ,  TwN7STVz ,  TwN7Vrel , TwN7VUndx , TwN7VUndy , TwN7VUndz ,  TwN8DynP ,   TwN8Fdx , &
                                  TwN8Fdy ,     TwN8M ,    TwN8Re ,  TwN8STVx ,  TwN8STVy ,  TwN8STVz ,  TwN8Vrel , TwN8VUndx , &
                                TwN8VUndy , TwN8VUndz ,  TwN9DynP ,   TwN9Fdx ,   TwN9Fdy ,     TwN9M ,    TwN9Re ,  TwN9STVx , &
                                 TwN9STVy ,  TwN9STVz ,  TwN9Vrel , TwN9VUndx , TwN9VUndy , TwN9VUndz /)
   CHARACTER(ChanLen), PARAMETER :: ParamUnitsAry(1270) =  (/  &  ! This lists the units corresponding to the allowed parameters
                               "(N)    ","(N)    ","(N)    ","(N)    ","(N)    ","(N)    ","(N-m)  ","(N-m)  ", &
                               "(N-m)  ","(N-m)  ","(N-m)  ","(N-m)  ","(W)    ","(deg)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ", &
                               "(-)    ","(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ", &
                               "(-)    ","(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(N/m)  ","(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(N)    ", &
                               "(N)    ","(N)    ","(N)    ","(N)    ","(N)    ","(N-m)  ","(N-m)  ","(N-m)  ", &
                               "(N-m)  ","(N-m)  ","(N-m)  ","(W)    ","(deg)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ", &
                               "(-)    ","(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ", &
                               "(-)    ","(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ", &
                               "(m^2/s)","(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(N)    ","(N)    ", &
                               "(N)    ","(N)    ","(N)    ","(N)    ","(N-m)  ","(N-m)  ","(N-m)  ","(N-m)  ", &
                               "(N-m)  ","(N-m)  ","(W)    ","(deg)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(-)    ","(-)    ","(-)    ", &
                               "(m)    ","(-)    ","(-)    ","(-)    ","(-)    ","(deg)  ","(-)    ","(-)    ", &
                               "(Pa)   ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(N/m)  ","(m^2/s)", &
                               "(-)    ","(N-m/m)","(deg)  ","(-)    ","(-)    ","(-)    ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(deg)  ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(deg)  ","(N)    ","(N)    ","(N)    ", &
                               "(N)    ","(N)    ","(N)    ","(N-m)  ","(N-m)  ","(N-m)  ","(N-m)  ","(N-m)  ", &
                               "(N-m)  ","(W)    ","(s)    ","(-)    ","(-)    ","(-)    ","(N)    ","(N)    ", &
                               "(N)    ","(N)    ","(N)    ","(N)    ","(N-m)  ","(N-m)  ","(N-m)  ","(N-m)  ", &
                               "(N-m)  ","(N-m)  ","(W)    ","(m^2)  ","(deg)  ","(rpm)  ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ","(N/m)  ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ", &
                               "(N/m)  ","(-)    ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ","(N/m)  ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ", &
                               "(N/m)  ","(-)    ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ","(N/m)  ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ", &
                               "(N/m)  ","(-)    ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ","(N/m)  ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ", &
                               "(N/m)  ","(-)    ","(-)    ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(Pa)   ","(N/m)  ","(N/m)  ","(-)    ","(-)    ","(m/s)  ", &
                               "(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  ","(m/s)  "/)


      ! Initialize values
   ErrStat = ErrID_None
   ErrMsg = ""
   InvalidOutput = .FALSE.


!   ..... Developer must add checking for invalid inputs here: .....

   !bjj: do we want to avoid outputting this if we haven't used tower aero?
   
   if ( p%TwrPotent == TwrPotent_none .and. p%TwrShadow == TwrShadow_none ) then
      
         ! BNClrnc is set only when we're computing the tower influence
      do i = 1,size(BNClrnc,2)  ! all blades (need to do this in a loop because we need the index of InvalidOutput to be an array of rank one)
         InvalidOutput( BNClrnc(:,i) ) = .true.  
      end do
      
   end if
      
   if (p_AD%WakeMod /= WakeMod_DBEMT) then
      InvalidOutput( DBEMTau1 ) = .true.
   end if
   
   DO i = p%NTwOuts+1,9  ! Invalid tower nodes
   
      InvalidOutput( TwNVUnd(:,i) ) = .true.
      InvalidOutput( TwNSTV( :,i) ) = .true.
      InvalidOutput( TwNVRel(  i) ) = .true.
      InvalidOutput( TwNDynP(  i) ) = .true.
      InvalidOutput( TwNRe(    i) ) = .true.
      InvalidOutput( TwNM(     i) ) = .true.
      InvalidOutput( TwNFdx(   i) ) = .true.
      InvalidOutput( TwNFdy(   i) ) = .true.
      
   END DO
   
   DO I = p%NumBlades+1,size(BAzimuth,1)  ! Invalid blades
      
      InvalidOutput( BAzimuth( i) ) = .true.
      InvalidOutput( BPitch(   i) ) = .true.
      InvalidOutput( BNVUndx(:,i) ) = .true.
      InvalidOutput( BNVUndy(:,i) ) = .true.
      InvalidOutput( BNVUndz(:,i) ) = .true.
      InvalidOutput( BNVDisx(:,i) ) = .true.
      InvalidOutput( BNVDisy(:,i) ) = .true.
      InvalidOutput( BNVDisz(:,i) ) = .true.
      InvalidOutput( BNSTVx( :,i) ) = .true.
      InvalidOutput( BNSTVy( :,i) ) = .true.
      InvalidOutput( BNSTVz( :,i) ) = .true.
      InvalidOutput( BNVRel( :,i) ) = .true.
      InvalidOutput( BNDynP( :,i) ) = .true.
      InvalidOutput( BNRe(   :,i) ) = .true.
      InvalidOutput( BNM(    :,i) ) = .true.
      InvalidOutput( BNVIndx(:,i) ) = .true.
      InvalidOutput( BNVIndy(:,i) ) = .true.
      InvalidOutput( BNAxInd(:,i) ) = .true.
      InvalidOutput( BNTnInd(:,i) ) = .true.
      InvalidOutput( BNAlpha(:,i) ) = .true.
      InvalidOutput( BNTheta(:,i) ) = .true.
      InvalidOutput( BNPhi(  :,i) ) = .true.
      InvalidOutput( BNCurve(:,i) ) = .true.
      InvalidOutput( BNCl(   :,i) ) = .true.
      InvalidOutput( BNCd(   :,i) ) = .true.
      InvalidOutput( BNCm(   :,i) ) = .true.
      InvalidOutput( BNCx(   :,i) ) = .true.
      InvalidOutput( BNCy(   :,i) ) = .true.
      InvalidOutput( BNCn(   :,i) ) = .true.
      InvalidOutput( BNCt(   :,i) ) = .true.
      InvalidOutput( BNFl(   :,i) ) = .true.
      InvalidOutput( BNFd(   :,i) ) = .true.
      InvalidOutput( BNMm(   :,i) ) = .true.
      InvalidOutput( BNFx(   :,i) ) = .true.
      InvalidOutput( BNFy(   :,i) ) = .true.
      InvalidOutput( BNFn(   :,i) ) = .true.
      InvalidOutput( BNFt(   :,i) ) = .true.
      InvalidOutput( BNClrnc(:,i) ) = .true.
      InvalidOutput( BNGam(  :,i) ) = .true.
      InvalidOutput( BNSgCav(:,i) ) = .true.
      InvalidOutput( BNSigCr(:,i) ) = .true.
      InvalidOutput( BNCpMin(:,i) ) = .true.
      InvalidOutput( BAeroFx(  i) ) = .true.
      InvalidOutput( BAeroFy(  i) ) = .true.
      InvalidOutput( BAeroFz(  i) ) = .true.
      InvalidOutput( BAeroMx(  i) ) = .true.
      InvalidOutput( BAeroMy(  i) ) = .true.
      InvalidOutput( BAeroMz(  i) ) = .true.
               
   END DO
      
   DO I = p%NBlOuts+1,9  ! Invalid blade nodes
      
      InvalidOutput( BNVUndx(i,:) ) = .true.
      InvalidOutput( BNVUndy(i,:) ) = .true.
      InvalidOutput( BNVUndz(i,:) ) = .true.
      InvalidOutput( BNVDisx(i,:) ) = .true.
      InvalidOutput( BNVDisy(i,:) ) = .true.
      InvalidOutput( BNVDisz(i,:) ) = .true.
      InvalidOutput( BNSTVx( i,:) ) = .true.
      InvalidOutput( BNSTVy( i,:) ) = .true.
      InvalidOutput( BNSTVz( i,:) ) = .true.
      InvalidOutput( BNVRel( i,:) ) = .true.
      InvalidOutput( BNDynP( i,:) ) = .true.
      InvalidOutput( BNRe(   i,:) ) = .true.
      InvalidOutput( BNM(    i,:) ) = .true.
      InvalidOutput( BNVIndx(i,:) ) = .true.
      InvalidOutput( BNVIndy(i,:) ) = .true.
      InvalidOutput( BNAxInd(i,:) ) = .true.
      InvalidOutput( BNTnInd(i,:) ) = .true.
      InvalidOutput( BNAlpha(i,:) ) = .true.
      InvalidOutput( BNTheta(i,:) ) = .true.
      InvalidOutput( BNPhi(  i,:) ) = .true.
      InvalidOutput( BNCurve(i,:) ) = .true.
      InvalidOutput( BNCl(   i,:) ) = .true.
      InvalidOutput( BNCd(   i,:) ) = .true.
      InvalidOutput( BNCm(   i,:) ) = .true.
      InvalidOutput( BNCx(   i,:) ) = .true.
      InvalidOutput( BNCy(   i,:) ) = .true.
      InvalidOutput( BNCn(   i,:) ) = .true.
      InvalidOutput( BNCt(   i,:) ) = .true.
      InvalidOutput( BNFl(   i,:) ) = .true.
      InvalidOutput( BNFd(   i,:) ) = .true.
      InvalidOutput( BNMm(   i,:) ) = .true.
      InvalidOutput( BNFx(   i,:) ) = .true.
      InvalidOutput( BNFy(   i,:) ) = .true.
      InvalidOutput( BNFn(   i,:) ) = .true.
      InvalidOutput( BNFt(   i,:) ) = .true.
      InvalidOutput( BNClrnc(i,:) ) = .true.
      InvalidOutput( BNGam(  i,:) ) = .true.
      InvalidOutput( BNSgCav(i,:) ) = .true.
      InvalidOutput( BNSigCr(i,:) ) = .true.
      InvalidOutput( BNCpMin(i,:) ) = .true.
         
   END DO   
   
!   ................. End of validity checking .................


   !-------------------------------------------------------------------------------------------------
   ! Allocate and set index, name, and units for the output channels
   ! If a selected output channel is not available in this module, set error flag.
   !-------------------------------------------------------------------------------------------------

   ALLOCATE ( p%OutParam(0:p%NumOuts) , STAT=ErrStat2 )
   IF ( ErrStat2 /= 0_IntKi )  THEN
      CALL SetErrStat( ErrID_Fatal,"Error allocating memory for the AeroDyn OutParam array.", ErrStat, ErrMsg, RoutineName )
      RETURN
   ENDIF

      ! Set index, name, and units for the time output channel:

   p%OutParam(0)%Indx  = Time
   p%OutParam(0)%Name  = "Time"    ! OutParam(0) is the time channel by default.
   p%OutParam(0)%Units = "(s)"
   p%OutParam(0)%SignM = 1


      ! Set index, name, and units for all of the output channels.
      ! If a selected output channel is not available by this module set ErrStat = ErrID_Warn.

   DO I = 1,p%NumOuts

      p%OutParam(I)%Name  = OutList(I)
      OutListTmp          = OutList(I)

      ! Reverse the sign (+/-) of the output channel if the user prefixed the
      !   channel name with a "-", "_", "m", or "M" character indicating "minus".


      CheckOutListAgain = .FALSE.

      IF      ( INDEX( "-_", OutListTmp(1:1) ) > 0 ) THEN
         p%OutParam(I)%SignM = -1                         ! ex, "-TipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)
      ELSE IF ( INDEX( "mM", OutListTmp(1:1) ) > 0 ) THEN ! We'll assume this is a variable name for now, (if not, we will check later if OutListTmp(2:) is also a variable name)
         CheckOutListAgain   = .TRUE.
         p%OutParam(I)%SignM = 1
      ELSE
         p%OutParam(I)%SignM = 1
      END IF

      CALL Conv2UC( OutListTmp )    ! Convert OutListTmp to upper case


      Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )


         ! If it started with an "M" (CheckOutListAgain) we didn't find the value in our list (Indx < 1)

      IF ( CheckOutListAgain .AND. Indx < 1 ) THEN    ! Let's assume that "M" really meant "minus" and then test again
         p%OutParam(I)%SignM = -1                     ! ex, "MTipDxc1" causes the sign of TipDxc1 to be switched.
         OutListTmp          = OutListTmp(2:)

         Indx = IndexCharAry( OutListTmp(1:OutStrLenM1), ValidParamAry )
      END IF


      IF ( Indx > 0 ) THEN ! we found the channel name
         IF ( InvalidOutput( ParamIndxAry(Indx) ) ) THEN  ! but, it isn't valid for these settings
            p%OutParam(I)%Indx  = 0                 ! pick any valid channel (I just picked "Time=0" here because it's universal)
            p%OutParam(I)%Units = "INVALID"
            p%OutParam(I)%SignM = 0
         ELSE
            p%OutParam(I)%Indx  = ParamIndxAry(Indx)
            p%OutParam(I)%Units = ParamUnitsAry(Indx) ! it's a valid output
         END IF
      ELSE ! this channel isn't valid
         p%OutParam(I)%Indx  = 0                    ! pick any valid channel (I just picked "Time=0" here because it's universal)
         p%OutParam(I)%Units = "INVALID"
         p%OutParam(I)%SignM = 0                    ! multiply all results by zero

         CALL SetErrStat(ErrID_Fatal, TRIM(p%OutParam(I)%Name)//" is not an available output channel.",ErrStat,ErrMsg,RoutineName)
      END IF

   END DO

   RETURN
END SUBROUTINE SetOutParam
!----------------------------------------------------------------------------------------------------------------------------------
!End of code generated by Matlab script
!**********************************************************************************************************************************



END MODULE AeroDyn_IO
