!STARTOFREGISTRYGENERATEDFILE 'AeroAcoustics_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroAcoustics_Types
!.................................................................................................................................
! This file is part of AeroAcoustics.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroAcoustics. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroAcoustics_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE NWTC_Library
IMPLICIT NONE
! =========  AA_BladePropsType  =======
  TYPE, PUBLIC :: AA_BladePropsType
    REAL(ReKi)  :: TEThick      !<  [-]
    REAL(ReKi)  :: TEAngle      !<  [-]
  END TYPE AA_BladePropsType
! =======================
! =========  AA_InitInputType  =======
  TYPE, PUBLIC :: AA_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    INTEGER(IntKi)  :: NumBlades      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBlNds      !< Number of blade nodes [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlSpn      !< Span at blade node [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlChord      !< Chord at blade node [m]
    REAL(ReKi)  :: AirDens      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: SpdSound      !< Speed of sound [m/s]
    REAL(ReKi)  :: HubHeight      !< Hub Height [m]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: BlAFID      !< Index of airfoil data file for blade node location [array of numBladeNodes by numBlades] [-]
    TYPE(AFI_ParameterType) , DIMENSION(:), ALLOCATABLE  :: AFInfo      !< Airfoil information structure containing the aerodynamic center and airfoil shape coordinates [-]
  END TYPE AA_InitInputType
! =======================
! =========  AA_InitOutputType  =======
  TYPE, PUBLIC :: AA_InitOutputType
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrforPE      !< Names of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntforPE      !< Units of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrSep      !< Names of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntSep      !< Units of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrNodes      !< Names of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntNodes      !< Units of the output-to-file channels [-]
    character(1)  :: delim      !< column delimiter [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi)  :: AirDens      !< Air density [kg/m^3]
  END TYPE AA_InitOutputType
! =======================
! =========  AA_InputFile  =======
  TYPE, PUBLIC :: AA_InputFile
    REAL(DbKi)  :: DT_AA      !< Time interval for aerodynamic calculations {or "default"} [s]
    INTEGER(IntKi)  :: IBLUNT      !< FLAG TO COMPUTE BLUNTNESS NOISE [-]
    INTEGER(IntKi)  :: ILAM      !< FLAG TO COMPUTE LBL NOISE {1=steady model, 2=Beddoes-Leishman unsteady model} [-]
    INTEGER(IntKi)  :: ITIP      !< FLAG TO COMPUTE TIP NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: ITRIP      !< FLAG TO TRIP BOUNDARY LAYER {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: ITURB      !< FLAG TO COMPUTE TBLTE NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: IInflow      !< FLAG TO COMPUTE Turbulent Inflow NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: X_BLMethod      !< Integer describing calculation method for boundary layer properties,  = 1 BPM = 2 Pretabulated [-]
    INTEGER(IntKi)  :: TICalcMeth      !< TICalcMeth [-]
    INTEGER(IntKi)  :: NReListBL      !< Number of values of ReListBL [-]
    LOGICAL  :: aweightflag      !< Integer a weighting call [-]
    LOGICAL  :: ROUND      !< LOGICAL INDICATING ROUNDED TIP [-]
    REAL(ReKi)  :: ALPRAT      !< TIP LIFT CURVE SLOPE [-]
    INTEGER(IntKi)  :: AA_Bl_Prcntge      !< see the AeroAcoustics input file for description   [-]
    INTEGER(IntKi)  :: NrObsLoc      !< Number of observer locations  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsX      !< Observer location in tower-base coordinate X horizontal [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsY      !< Observer location in tower-base coordinate Y lateral [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsZ      !< Observer location in tower-base coordinate Z vertical [m]
    TYPE(AA_BladePropsType) , DIMENSION(:), ALLOCATABLE  :: BladeProps      !< blade property information from blade input files [-]
    INTEGER(IntKi)  :: NrOutFile      !< Nr of output files [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: AAoutfile      !< AAoutfile for writing output files [-]
    CHARACTER(1024)  :: TICalcTabFile      !< Name of the file containing the table for incident turbulence intensity [-]
    CHARACTER(1024)  :: FTitle      !< File Title: the 2nd line of the input file, which contains a description of its contents [-]
    REAL(DbKi)  :: AAStart      !< Time after which to calculate AA [s]
    REAL(ReKi)  :: Lturb      !< Turbulent lengthscale in Amiet model [-]
    REAL(ReKi)  :: AvgV      !< Average wind speed to compute incident turbulence intensity [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ReListBL      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AoAListBL      !<  [deg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_DispThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_DispThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_BLThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_BLThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_Cf      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_Cf      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_EdgeVelRat      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_EdgeVelRat      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TI_Grid_In      !<  [-]
    REAL(ReKi)  :: dz_turb_in      !<  [m]
    REAL(ReKi)  :: dy_turb_in      !<  [m]
  END TYPE AA_InputFile
! =======================
! =========  AA_ContinuousStateType  =======
  TYPE, PUBLIC :: AA_ContinuousStateType
    REAL(SiKi)  :: DummyContState      !< Remove this variable if you have continuous states [-]
  END TYPE AA_ContinuousStateType
! =======================
! =========  AA_DiscreteStateType  =======
  TYPE, PUBLIC :: AA_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeanVrel      !< Vrel Cumu. Mean [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VrelSq      !< Vrel Squared Store [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TIVrel      !< Vrel St. deviat [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: VrelStore      !< Vrel Store for fft - dissipation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TIVx      !< Vx St. deviat [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeanVxVyVz      !< Vrel Cumu. Mean [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VxSq      !< Vxl Squared Store [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: allregcounter      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VxSqRegion      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: RegVxStor      !< VxVyVz Store for fft or TI - dissipation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: RegionTIDelete      !<  [-]
  END TYPE AA_DiscreteStateType
! =======================
! =========  AA_ConstraintStateType  =======
  TYPE, PUBLIC :: AA_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState      !< Remove this variable if you have  states [-]
  END TYPE AA_ConstraintStateType
! =======================
! =========  AA_OtherStateType  =======
  TYPE, PUBLIC :: AA_OtherStateType
    REAL(SiKi)  :: DummyOtherState      !< Remove this variable if you have  states [-]
  END TYPE AA_OtherStateType
! =======================
! =========  AA_MiscVarType  =======
  TYPE, PUBLIC :: AA_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: ChordAngleTE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SpanAngleTE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: ChordAngleLE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SpanAngleLE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rTEtoObserve      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rLEtoObserve      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LE_Location      !< Height of Leading Edge for calculation of TI and Scales if needed [-]
    REAL(ReKi)  :: RotSpeedAoA      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLLBL      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLP      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLS      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLALPH      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTBL      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTIP      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTI      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTIGui      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLBLUNT      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CfVar      !< Output Skin friction coef Pressure Side [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: d99Var      !< BL Output  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dStarVar      !< BL Output  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgeVelVar      !< BL Output  [-]
    INTEGER(IntKi)  :: speccou      !< Secptrum counter every XX seconds new spectrum [-]
    INTEGER(IntKi)  :: filesopen      !< check if file is open [-]
  END TYPE AA_MiscVarType
! =======================
! =========  AA_ParameterType  =======
  TYPE, PUBLIC :: AA_ParameterType
    REAL(DbKi)  :: DT      !< Time step for continuous state integration & discrete state update [seconds]
    INTEGER(IntKi)  :: IBLUNT      !< Bluntness noise model [-]
    INTEGER(IntKi)  :: ILAM      !< LBL noise model  [-]
    INTEGER(IntKi)  :: ITIP      !< Tip noise model [-]
    INTEGER(IntKi)  :: ITRIP      !< Trip boundary layer [-]
    INTEGER(IntKi)  :: ITURB      !< Tblte noise model [-]
    INTEGER(IntKi)  :: IInflow      !< Turbulent inflow noise model [-]
    INTEGER(IntKi)  :: X_BLMethod      !< Integer describing calculation method for boundary layer properties,  = 1 BPM = 2 Pretabulated [-]
    INTEGER(IntKi)  :: TICalcMeth      !<  [-]
    LOGICAL  :: ROUND      !< Logical indicating rounded tip [-]
    REAL(ReKi)  :: ALPRAT      !< TIP LIFT CURVE SLOPE [-]
    INTEGER(IntKi)  :: NumBlades      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBlNds      !< Number of nodes on each blade [-]
    REAL(ReKi)  :: AirDens      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: SpdSound      !< Speed of sound [m/s]
    REAL(ReKi)  :: HubHeight      !< Hub height [m]
    REAL(ReKi)  :: toptip      !< Top Tip Height = Hub height plus radius [m]
    REAL(ReKi)  :: bottip      !< Bottom Tip Height = Hub height minus radius [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsVert      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsHorz      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsalph      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsrad      !<  [-]
    INTEGER(IntKi)  :: NrObsLoc      !< Number of observer locations  [-]
    LOGICAL  :: aweightflag      !<   [-]
    LOGICAL  :: TxtFileOutput      !<   [-]
    REAL(DbKi)  :: AAStart      !< Time after which to calculate AA [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsX      !< Observer location in tower-base coordinate X horizontal [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsY      !< Observer location in tower-base coordinate Y lateral [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsZ      !< Observer location in tower-base coordinate Z vertical [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FreqList      !< List of Acoustic Frequencies to Calculate [Hz]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Aweight      !< List of Acoustic Frequencies a weighting [dB]
    REAL(ReKi)  :: Fsample      !< Sampling Frequency 1/delta(t) - 1/(simulation time step) [Hz]
    INTEGER(IntKi)  :: total_sample      !< Total FFT Sample amount for dissipation calculation [-]
    INTEGER(IntKi)  :: total_sampleTI      !< Total FFT Sample amount for dissipation calculation [-]
    INTEGER(IntKi)  :: AA_Bl_Prcntge      !< The Percentage of the Blade which the noise is calculated [%]
    INTEGER(IntKi)  :: startnode      !< Corersponding node to the noise calculation percentage of the blade [-]
    REAL(ReKi)  :: Lturb      !< Turbulent lengthscale in Amiet model [m]
    REAL(ReKi)  :: AvgV      !< Average wind speed to compute incident turbulence intensity [m]
    REAL(ReKi)  :: dz_turb_in      !<  [m]
    REAL(ReKi)  :: dy_turb_in      !<  [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TI_Grid_In      !<  [-]
    CHARACTER(1024)  :: FTitle      !< File Title: the 2nd line of the input file, which contains a description of its contents [-]
    character(20)  :: outFmt      !< Format specifier [-]
    INTEGER(IntKi)  :: NrOutFile      !< Nr of output files [-]
    character(1)  :: delim      !< column delimiter [-]
    INTEGER(IntKi)  :: NumOuts      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForPE      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForSep      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForNodes      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: unOutFile      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile2      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile3      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile4      !< unit number for writing output file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StallStart      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TEThick      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TEAngle      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AerCent      !< ation [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: BlAFID      !< Index of airfoil data file for blade node location [array of numBladeNodes by numBlades] [-]
    TYPE(AFI_ParameterType) , DIMENSION(:), ALLOCATABLE  :: AFInfo      !< Airfoil information structure containing the aerodynamic center and airfoil shape coordinates [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AFLECo      !< Dimensionalized  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AFTECo 
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlSpn      !< Span at blade node [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlChord      !< Chord at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ReListBL      !< BL list of Reynolds [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AOAListBL      !< BL list of Angle Of Attack  [deg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dStarAll1      !< Output Disp Thickness Suction Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dStarAll2      !< Output Disp Thickness Pressure Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: d99All1      !< Output B.L. Thickness Suction Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: d99All2      !< Output B.L. Thickness Pressure Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CfAll1      !< Output Skin friction coef Suction Side [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CfAll2      !< Output Skin friction coef Pressure Side [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: EdgeVelRat1      !< Output Edge Velocity Ratio Suction [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: EdgeVelRat2      !< Output Edge Velocity Ratio Pressure Side [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AFThickGuida      !< 1 and 10 percent thickness t/c used for Simplified Guidati [-]
  END TYPE AA_ParameterType
! =======================
! =========  AA_InputType  =======
  TYPE, PUBLIC :: AA_InputType
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: RotGtoL      !< 3x3 rotation matrix transform a vector from the local airfoil coordinate system to the global inertial coordinate system [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AeroCent_G      !< location in global coordinates of the blade element aerodynamic center.  1st index = vector components, 2nd index = blade node, 3rd index = blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vrel      !< Vrel [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AoANoise      !< Angle of attack [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Inflow      !< atmospheric undisturbed flow on blade [-]
  END TYPE AA_InputType
! =======================
! =========  AA_OutputType  =======
  TYPE, PUBLIC :: AA_OutputType
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SumSpecNoise      !< Spectra of summed noise level of each blade and blade nodes for each receiver and frequency [SPL]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SumSpecNoiseSep      !< Spectra of summed noise level of all blades and blade nodes for each receiver and frequency [SPL]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: OASPL      !< summed noise level for each blade and blade nodes and receiver  [SPL]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: OASPL_Mech      !< 5 different mechanism noise level for each blade and blade nodes and receiver  [SPL]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DirectiviOutput      !<   [SPL]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: OutLECoords      !<   [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PtotalFreq      !< SPL for each observer and frequency [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputForPE      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputSep      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputNode      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE AA_OutputType
! =======================
CONTAINS
 SUBROUTINE AA_CopyBladePropsType( SrcBladePropsTypeData, DstBladePropsTypeData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_BladePropsType), INTENT(IN) :: SrcBladePropsTypeData
   TYPE(AA_BladePropsType), INTENT(INOUT) :: DstBladePropsTypeData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyBladePropsType'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstBladePropsTypeData%TEThick = SrcBladePropsTypeData%TEThick
    DstBladePropsTypeData%TEAngle = SrcBladePropsTypeData%TEAngle
 END SUBROUTINE AA_CopyBladePropsType

 SUBROUTINE AA_DestroyBladePropsType( BladePropsTypeData, ErrStat, ErrMsg )
  TYPE(AA_BladePropsType), INTENT(INOUT) :: BladePropsTypeData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyBladePropsType'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE AA_DestroyBladePropsType

 SUBROUTINE AA_PackBladePropsType( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_BladePropsType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackBladePropsType'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! TEThick
      Re_BufSz   = Re_BufSz   + 1  ! TEAngle
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%TEThick
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%TEAngle
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackBladePropsType

 SUBROUTINE AA_UnPackBladePropsType( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_BladePropsType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackBladePropsType'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%TEThick = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%TEAngle = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackBladePropsType

 SUBROUTINE AA_CopyInitInput( SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_InitInputType), INTENT(IN) :: SrcInitInputData
   TYPE(AA_InitInputType), INTENT(INOUT) :: DstInitInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyInitInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInitInputData%InputFile = SrcInitInputData%InputFile
    DstInitInputData%NumBlades = SrcInitInputData%NumBlades
    DstInitInputData%NumBlNds = SrcInitInputData%NumBlNds
    DstInitInputData%RootName = SrcInitInputData%RootName
IF (ALLOCATED(SrcInitInputData%BlSpn)) THEN
  i1_l = LBOUND(SrcInitInputData%BlSpn,1)
  i1_u = UBOUND(SrcInitInputData%BlSpn,1)
  i2_l = LBOUND(SrcInitInputData%BlSpn,2)
  i2_u = UBOUND(SrcInitInputData%BlSpn,2)
  IF (.NOT. ALLOCATED(DstInitInputData%BlSpn)) THEN 
    ALLOCATE(DstInitInputData%BlSpn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlSpn.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%BlSpn = SrcInitInputData%BlSpn
ENDIF
IF (ALLOCATED(SrcInitInputData%BlChord)) THEN
  i1_l = LBOUND(SrcInitInputData%BlChord,1)
  i1_u = UBOUND(SrcInitInputData%BlChord,1)
  i2_l = LBOUND(SrcInitInputData%BlChord,2)
  i2_u = UBOUND(SrcInitInputData%BlChord,2)
  IF (.NOT. ALLOCATED(DstInitInputData%BlChord)) THEN 
    ALLOCATE(DstInitInputData%BlChord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlChord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%BlChord = SrcInitInputData%BlChord
ENDIF
    DstInitInputData%AirDens = SrcInitInputData%AirDens
    DstInitInputData%KinVisc = SrcInitInputData%KinVisc
    DstInitInputData%SpdSound = SrcInitInputData%SpdSound
    DstInitInputData%HubHeight = SrcInitInputData%HubHeight
IF (ALLOCATED(SrcInitInputData%BlAFID)) THEN
  i1_l = LBOUND(SrcInitInputData%BlAFID,1)
  i1_u = UBOUND(SrcInitInputData%BlAFID,1)
  i2_l = LBOUND(SrcInitInputData%BlAFID,2)
  i2_u = UBOUND(SrcInitInputData%BlAFID,2)
  IF (.NOT. ALLOCATED(DstInitInputData%BlAFID)) THEN 
    ALLOCATE(DstInitInputData%BlAFID(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlAFID.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitInputData%BlAFID = SrcInitInputData%BlAFID
ENDIF
IF (ALLOCATED(SrcInitInputData%AFInfo)) THEN
  i1_l = LBOUND(SrcInitInputData%AFInfo,1)
  i1_u = UBOUND(SrcInitInputData%AFInfo,1)
  IF (.NOT. ALLOCATED(DstInitInputData%AFInfo)) THEN 
    ALLOCATE(DstInitInputData%AFInfo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AFInfo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInitInputData%AFInfo,1), UBOUND(SrcInitInputData%AFInfo,1)
      CALL AFI_CopyParam( SrcInitInputData%AFInfo(i1), DstInitInputData%AFInfo(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
 END SUBROUTINE AA_CopyInitInput

 SUBROUTINE AA_DestroyInitInput( InitInputData, ErrStat, ErrMsg )
  TYPE(AA_InitInputType), INTENT(INOUT) :: InitInputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyInitInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitInputData%BlSpn)) THEN
  DEALLOCATE(InitInputData%BlSpn)
ENDIF
IF (ALLOCATED(InitInputData%BlChord)) THEN
  DEALLOCATE(InitInputData%BlChord)
ENDIF
IF (ALLOCATED(InitInputData%BlAFID)) THEN
  DEALLOCATE(InitInputData%BlAFID)
ENDIF
IF (ALLOCATED(InitInputData%AFInfo)) THEN
DO i1 = LBOUND(InitInputData%AFInfo,1), UBOUND(InitInputData%AFInfo,1)
  CALL AFI_DestroyParam( InitInputData%AFInfo(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InitInputData%AFInfo)
ENDIF
 END SUBROUTINE AA_DestroyInitInput

 SUBROUTINE AA_PackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_InitInputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackInitInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%InputFile)  ! InputFile
      Int_BufSz  = Int_BufSz  + 1  ! NumBlades
      Int_BufSz  = Int_BufSz  + 1  ! NumBlNds
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
  Int_BufSz   = Int_BufSz   + 1     ! BlSpn allocated yes/no
  IF ( ALLOCATED(InData%BlSpn) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlSpn upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlSpn)  ! BlSpn
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BlChord allocated yes/no
  IF ( ALLOCATED(InData%BlChord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlChord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlChord)  ! BlChord
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! AirDens
      Re_BufSz   = Re_BufSz   + 1  ! KinVisc
      Re_BufSz   = Re_BufSz   + 1  ! SpdSound
      Re_BufSz   = Re_BufSz   + 1  ! HubHeight
  Int_BufSz   = Int_BufSz   + 1     ! BlAFID allocated yes/no
  IF ( ALLOCATED(InData%BlAFID) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlAFID upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%BlAFID)  ! BlAFID
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AFInfo allocated yes/no
  IF ( ALLOCATED(InData%AFInfo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AFInfo upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%AFInfo,1), UBOUND(InData%AFInfo,1)
      Int_BufSz   = Int_BufSz + 3  ! AFInfo: size of buffers for each call to pack subtype
      CALL AFI_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%AFInfo(i1), ErrStat2, ErrMsg2, .TRUE. ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! AFInfo
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! AFInfo
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! AFInfo
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DO I = 1, LEN(InData%InputFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%InputFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NumBlades
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBlNds
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%BlSpn) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlSpn,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlSpn,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlSpn,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlSpn,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlSpn,2), UBOUND(InData%BlSpn,2)
        DO i1 = LBOUND(InData%BlSpn,1), UBOUND(InData%BlSpn,1)
          ReKiBuf(Re_Xferred) = InData%BlSpn(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BlChord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlChord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlChord,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlChord,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlChord,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlChord,2), UBOUND(InData%BlChord,2)
        DO i1 = LBOUND(InData%BlChord,1), UBOUND(InData%BlChord,1)
          ReKiBuf(Re_Xferred) = InData%BlChord(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%AirDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%KinVisc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SpdSound
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubHeight
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%BlAFID) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlAFID,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlAFID,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlAFID,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlAFID,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlAFID,2), UBOUND(InData%BlAFID,2)
        DO i1 = LBOUND(InData%BlAFID,1), UBOUND(InData%BlAFID,1)
          IntKiBuf(Int_Xferred) = InData%BlAFID(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AFInfo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFInfo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFInfo,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%AFInfo,1), UBOUND(InData%AFInfo,1)
      CALL AFI_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%AFInfo(i1), ErrStat2, ErrMsg2, OnlySize ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
 END SUBROUTINE AA_PackInitInput

 SUBROUTINE AA_UnPackInitInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_InitInputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackInitInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    DO I = 1, LEN(OutData%InputFile)
      OutData%InputFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NumBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumBlNds = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlSpn not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlSpn)) DEALLOCATE(OutData%BlSpn)
    ALLOCATE(OutData%BlSpn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlSpn.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlSpn,2), UBOUND(OutData%BlSpn,2)
        DO i1 = LBOUND(OutData%BlSpn,1), UBOUND(OutData%BlSpn,1)
          OutData%BlSpn(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlChord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlChord)) DEALLOCATE(OutData%BlChord)
    ALLOCATE(OutData%BlChord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlChord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlChord,2), UBOUND(OutData%BlChord,2)
        DO i1 = LBOUND(OutData%BlChord,1), UBOUND(OutData%BlChord,1)
          OutData%BlChord(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%AirDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%KinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SpdSound = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlAFID not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlAFID)) DEALLOCATE(OutData%BlAFID)
    ALLOCATE(OutData%BlAFID(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlAFID.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlAFID,2), UBOUND(OutData%BlAFID,2)
        DO i1 = LBOUND(OutData%BlAFID,1), UBOUND(OutData%BlAFID,1)
          OutData%BlAFID(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFInfo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFInfo)) DEALLOCATE(OutData%AFInfo)
    ALLOCATE(OutData%AFInfo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFInfo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%AFInfo,1), UBOUND(OutData%AFInfo,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AFI_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%AFInfo(i1), ErrStat2, ErrMsg2 ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
 END SUBROUTINE AA_UnPackInitInput

 SUBROUTINE AA_CopyInitOutput( SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_InitOutputType), INTENT(IN) :: SrcInitOutputData
   TYPE(AA_InitOutputType), INTENT(INOUT) :: DstInitOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyInitOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdr)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdr,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdr,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdr)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUnt)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUnt,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUnt,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUnt)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdrforPE)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdrforPE,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdrforPE,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdrforPE)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdrforPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrforPE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdrforPE = SrcInitOutputData%WriteOutputHdrforPE
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUntforPE)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUntforPE,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUntforPE,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUntforPE)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUntforPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntforPE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUntforPE = SrcInitOutputData%WriteOutputUntforPE
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdrSep)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdrSep,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdrSep,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdrSep)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdrSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrSep.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdrSep = SrcInitOutputData%WriteOutputHdrSep
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUntSep)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUntSep,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUntSep,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUntSep)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUntSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntSep.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUntSep = SrcInitOutputData%WriteOutputUntSep
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputHdrNodes)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputHdrNodes,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputHdrNodes,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputHdrNodes)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputHdrNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputHdrNodes = SrcInitOutputData%WriteOutputHdrNodes
ENDIF
IF (ALLOCATED(SrcInitOutputData%WriteOutputUntNodes)) THEN
  i1_l = LBOUND(SrcInitOutputData%WriteOutputUntNodes,1)
  i1_u = UBOUND(SrcInitOutputData%WriteOutputUntNodes,1)
  IF (.NOT. ALLOCATED(DstInitOutputData%WriteOutputUntNodes)) THEN 
    ALLOCATE(DstInitOutputData%WriteOutputUntNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntNodes.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInitOutputData%WriteOutputUntNodes = SrcInitOutputData%WriteOutputUntNodes
ENDIF
    DstInitOutputData%delim = SrcInitOutputData%delim
      CALL NWTC_Library_Copyprogdesc( SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    DstInitOutputData%AirDens = SrcInitOutputData%AirDens
 END SUBROUTINE AA_CopyInitOutput

 SUBROUTINE AA_DestroyInitOutput( InitOutputData, ErrStat, ErrMsg )
  TYPE(AA_InitOutputType), INTENT(INOUT) :: InitOutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyInitOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InitOutputData%WriteOutputHdr)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdr)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUnt)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUnt)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputHdrforPE)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdrforPE)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUntforPE)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUntforPE)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputHdrSep)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdrSep)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUntSep)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUntSep)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputHdrNodes)) THEN
  DEALLOCATE(InitOutputData%WriteOutputHdrNodes)
ENDIF
IF (ALLOCATED(InitOutputData%WriteOutputUntNodes)) THEN
  DEALLOCATE(InitOutputData%WriteOutputUntNodes)
ENDIF
  CALL NWTC_Library_Destroyprogdesc( InitOutputData%Ver, ErrStat, ErrMsg )
 END SUBROUTINE AA_DestroyInitOutput

 SUBROUTINE AA_PackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_InitOutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackInitOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdr allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdr) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdr upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdr)*LEN(InData%WriteOutputHdr)  ! WriteOutputHdr
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUnt allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUnt) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUnt upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUnt)*LEN(InData%WriteOutputUnt)  ! WriteOutputUnt
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdrforPE allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdrforPE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdrforPE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdrforPE)*LEN(InData%WriteOutputHdrforPE)  ! WriteOutputHdrforPE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUntforPE allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUntforPE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUntforPE upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUntforPE)*LEN(InData%WriteOutputUntforPE)  ! WriteOutputUntforPE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdrSep allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdrSep) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdrSep upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdrSep)*LEN(InData%WriteOutputHdrSep)  ! WriteOutputHdrSep
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUntSep allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUntSep) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUntSep upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUntSep)*LEN(InData%WriteOutputUntSep)  ! WriteOutputUntSep
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputHdrNodes allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputHdrNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputHdrNodes upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputHdrNodes)*LEN(InData%WriteOutputHdrNodes)  ! WriteOutputHdrNodes
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputUntNodes allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputUntNodes) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputUntNodes upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%WriteOutputUntNodes)*LEN(InData%WriteOutputUntNodes)  ! WriteOutputUntNodes
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%delim)  ! delim
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
      Int_BufSz   = Int_BufSz + 3  ! Ver: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, .TRUE. ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! Ver
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! Ver
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! Ver
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
      Re_BufSz   = Re_BufSz   + 1  ! AirDens
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%WriteOutputHdr) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdr,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdr,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdr,1), UBOUND(InData%WriteOutputHdr,1)
        DO I = 1, LEN(InData%WriteOutputHdr)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdr(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUnt) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUnt,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUnt,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUnt,1), UBOUND(InData%WriteOutputUnt,1)
        DO I = 1, LEN(InData%WriteOutputUnt)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUnt(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputHdrforPE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdrforPE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdrforPE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdrforPE,1), UBOUND(InData%WriteOutputHdrforPE,1)
        DO I = 1, LEN(InData%WriteOutputHdrforPE)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdrforPE(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUntforPE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUntforPE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUntforPE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUntforPE,1), UBOUND(InData%WriteOutputUntforPE,1)
        DO I = 1, LEN(InData%WriteOutputUntforPE)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUntforPE(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputHdrSep) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdrSep,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdrSep,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdrSep,1), UBOUND(InData%WriteOutputHdrSep,1)
        DO I = 1, LEN(InData%WriteOutputHdrSep)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdrSep(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUntSep) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUntSep,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUntSep,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUntSep,1), UBOUND(InData%WriteOutputUntSep,1)
        DO I = 1, LEN(InData%WriteOutputUntSep)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUntSep(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputHdrNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputHdrNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputHdrNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputHdrNodes,1), UBOUND(InData%WriteOutputHdrNodes,1)
        DO I = 1, LEN(InData%WriteOutputHdrNodes)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputHdrNodes(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputUntNodes) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputUntNodes,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputUntNodes,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputUntNodes,1), UBOUND(InData%WriteOutputUntNodes,1)
        DO I = 1, LEN(InData%WriteOutputUntNodes)
          IntKiBuf(Int_Xferred) = ICHAR(InData%WriteOutputUntNodes(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(InData%delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      CALL NWTC_Library_Packprogdesc( Re_Buf, Db_Buf, Int_Buf, InData%Ver, ErrStat2, ErrMsg2, OnlySize ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    ReKiBuf(Re_Xferred) = InData%AirDens
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackInitOutput

 SUBROUTINE AA_UnPackInitOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_InitOutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackInitOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdr not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdr)) DEALLOCATE(OutData%WriteOutputHdr)
    ALLOCATE(OutData%WriteOutputHdr(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdr.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdr,1), UBOUND(OutData%WriteOutputHdr,1)
        DO I = 1, LEN(OutData%WriteOutputHdr)
          OutData%WriteOutputHdr(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUnt not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUnt)) DEALLOCATE(OutData%WriteOutputUnt)
    ALLOCATE(OutData%WriteOutputUnt(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUnt.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUnt,1), UBOUND(OutData%WriteOutputUnt,1)
        DO I = 1, LEN(OutData%WriteOutputUnt)
          OutData%WriteOutputUnt(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdrforPE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdrforPE)) DEALLOCATE(OutData%WriteOutputHdrforPE)
    ALLOCATE(OutData%WriteOutputHdrforPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdrforPE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdrforPE,1), UBOUND(OutData%WriteOutputHdrforPE,1)
        DO I = 1, LEN(OutData%WriteOutputHdrforPE)
          OutData%WriteOutputHdrforPE(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUntforPE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUntforPE)) DEALLOCATE(OutData%WriteOutputUntforPE)
    ALLOCATE(OutData%WriteOutputUntforPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUntforPE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUntforPE,1), UBOUND(OutData%WriteOutputUntforPE,1)
        DO I = 1, LEN(OutData%WriteOutputUntforPE)
          OutData%WriteOutputUntforPE(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdrSep not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdrSep)) DEALLOCATE(OutData%WriteOutputHdrSep)
    ALLOCATE(OutData%WriteOutputHdrSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdrSep.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdrSep,1), UBOUND(OutData%WriteOutputHdrSep,1)
        DO I = 1, LEN(OutData%WriteOutputHdrSep)
          OutData%WriteOutputHdrSep(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUntSep not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUntSep)) DEALLOCATE(OutData%WriteOutputUntSep)
    ALLOCATE(OutData%WriteOutputUntSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUntSep.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUntSep,1), UBOUND(OutData%WriteOutputUntSep,1)
        DO I = 1, LEN(OutData%WriteOutputUntSep)
          OutData%WriteOutputUntSep(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputHdrNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputHdrNodes)) DEALLOCATE(OutData%WriteOutputHdrNodes)
    ALLOCATE(OutData%WriteOutputHdrNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputHdrNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputHdrNodes,1), UBOUND(OutData%WriteOutputHdrNodes,1)
        DO I = 1, LEN(OutData%WriteOutputHdrNodes)
          OutData%WriteOutputHdrNodes(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputUntNodes not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputUntNodes)) DEALLOCATE(OutData%WriteOutputUntNodes)
    ALLOCATE(OutData%WriteOutputUntNodes(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputUntNodes.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputUntNodes,1), UBOUND(OutData%WriteOutputUntNodes,1)
        DO I = 1, LEN(OutData%WriteOutputUntNodes)
          OutData%WriteOutputUntNodes(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(OutData%delim)
      OutData%delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackprogdesc( Re_Buf, Db_Buf, Int_Buf, OutData%Ver, ErrStat2, ErrMsg2 ) ! Ver 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    OutData%AirDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackInitOutput

 SUBROUTINE AA_CopyInputFile( SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_InputFile), INTENT(IN) :: SrcInputFileData
   TYPE(AA_InputFile), INTENT(INOUT) :: DstInputFileData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyInputFile'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstInputFileData%DT_AA = SrcInputFileData%DT_AA
    DstInputFileData%IBLUNT = SrcInputFileData%IBLUNT
    DstInputFileData%ILAM = SrcInputFileData%ILAM
    DstInputFileData%ITIP = SrcInputFileData%ITIP
    DstInputFileData%ITRIP = SrcInputFileData%ITRIP
    DstInputFileData%ITURB = SrcInputFileData%ITURB
    DstInputFileData%IInflow = SrcInputFileData%IInflow
    DstInputFileData%X_BLMethod = SrcInputFileData%X_BLMethod
    DstInputFileData%TICalcMeth = SrcInputFileData%TICalcMeth
    DstInputFileData%NReListBL = SrcInputFileData%NReListBL
    DstInputFileData%aweightflag = SrcInputFileData%aweightflag
    DstInputFileData%ROUND = SrcInputFileData%ROUND
    DstInputFileData%ALPRAT = SrcInputFileData%ALPRAT
    DstInputFileData%AA_Bl_Prcntge = SrcInputFileData%AA_Bl_Prcntge
    DstInputFileData%NrObsLoc = SrcInputFileData%NrObsLoc
IF (ALLOCATED(SrcInputFileData%ObsX)) THEN
  i1_l = LBOUND(SrcInputFileData%ObsX,1)
  i1_u = UBOUND(SrcInputFileData%ObsX,1)
  IF (.NOT. ALLOCATED(DstInputFileData%ObsX)) THEN 
    ALLOCATE(DstInputFileData%ObsX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%ObsX = SrcInputFileData%ObsX
ENDIF
IF (ALLOCATED(SrcInputFileData%ObsY)) THEN
  i1_l = LBOUND(SrcInputFileData%ObsY,1)
  i1_u = UBOUND(SrcInputFileData%ObsY,1)
  IF (.NOT. ALLOCATED(DstInputFileData%ObsY)) THEN 
    ALLOCATE(DstInputFileData%ObsY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%ObsY = SrcInputFileData%ObsY
ENDIF
IF (ALLOCATED(SrcInputFileData%ObsZ)) THEN
  i1_l = LBOUND(SrcInputFileData%ObsZ,1)
  i1_u = UBOUND(SrcInputFileData%ObsZ,1)
  IF (.NOT. ALLOCATED(DstInputFileData%ObsZ)) THEN 
    ALLOCATE(DstInputFileData%ObsZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsZ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%ObsZ = SrcInputFileData%ObsZ
ENDIF
IF (ALLOCATED(SrcInputFileData%BladeProps)) THEN
  i1_l = LBOUND(SrcInputFileData%BladeProps,1)
  i1_u = UBOUND(SrcInputFileData%BladeProps,1)
  IF (.NOT. ALLOCATED(DstInputFileData%BladeProps)) THEN 
    ALLOCATE(DstInputFileData%BladeProps(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BladeProps.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcInputFileData%BladeProps,1), UBOUND(SrcInputFileData%BladeProps,1)
      CALL AA_Copybladepropstype( SrcInputFileData%BladeProps(i1), DstInputFileData%BladeProps(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
    DstInputFileData%NrOutFile = SrcInputFileData%NrOutFile
IF (ALLOCATED(SrcInputFileData%AAoutfile)) THEN
  i1_l = LBOUND(SrcInputFileData%AAoutfile,1)
  i1_u = UBOUND(SrcInputFileData%AAoutfile,1)
  IF (.NOT. ALLOCATED(DstInputFileData%AAoutfile)) THEN 
    ALLOCATE(DstInputFileData%AAoutfile(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AAoutfile.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%AAoutfile = SrcInputFileData%AAoutfile
ENDIF
    DstInputFileData%TICalcTabFile = SrcInputFileData%TICalcTabFile
    DstInputFileData%FTitle = SrcInputFileData%FTitle
    DstInputFileData%AAStart = SrcInputFileData%AAStart
    DstInputFileData%Lturb = SrcInputFileData%Lturb
    DstInputFileData%AvgV = SrcInputFileData%AvgV
IF (ALLOCATED(SrcInputFileData%ReListBL)) THEN
  i1_l = LBOUND(SrcInputFileData%ReListBL,1)
  i1_u = UBOUND(SrcInputFileData%ReListBL,1)
  IF (.NOT. ALLOCATED(DstInputFileData%ReListBL)) THEN 
    ALLOCATE(DstInputFileData%ReListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ReListBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%ReListBL = SrcInputFileData%ReListBL
ENDIF
IF (ALLOCATED(SrcInputFileData%AoAListBL)) THEN
  i1_l = LBOUND(SrcInputFileData%AoAListBL,1)
  i1_u = UBOUND(SrcInputFileData%AoAListBL,1)
  IF (.NOT. ALLOCATED(DstInputFileData%AoAListBL)) THEN 
    ALLOCATE(DstInputFileData%AoAListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AoAListBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%AoAListBL = SrcInputFileData%AoAListBL
ENDIF
IF (ALLOCATED(SrcInputFileData%Pres_DispThick)) THEN
  i1_l = LBOUND(SrcInputFileData%Pres_DispThick,1)
  i1_u = UBOUND(SrcInputFileData%Pres_DispThick,1)
  i2_l = LBOUND(SrcInputFileData%Pres_DispThick,2)
  i2_u = UBOUND(SrcInputFileData%Pres_DispThick,2)
  i3_l = LBOUND(SrcInputFileData%Pres_DispThick,3)
  i3_u = UBOUND(SrcInputFileData%Pres_DispThick,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Pres_DispThick)) THEN 
    ALLOCATE(DstInputFileData%Pres_DispThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_DispThick.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Pres_DispThick = SrcInputFileData%Pres_DispThick
ENDIF
IF (ALLOCATED(SrcInputFileData%Suct_DispThick)) THEN
  i1_l = LBOUND(SrcInputFileData%Suct_DispThick,1)
  i1_u = UBOUND(SrcInputFileData%Suct_DispThick,1)
  i2_l = LBOUND(SrcInputFileData%Suct_DispThick,2)
  i2_u = UBOUND(SrcInputFileData%Suct_DispThick,2)
  i3_l = LBOUND(SrcInputFileData%Suct_DispThick,3)
  i3_u = UBOUND(SrcInputFileData%Suct_DispThick,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Suct_DispThick)) THEN 
    ALLOCATE(DstInputFileData%Suct_DispThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_DispThick.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Suct_DispThick = SrcInputFileData%Suct_DispThick
ENDIF
IF (ALLOCATED(SrcInputFileData%Pres_BLThick)) THEN
  i1_l = LBOUND(SrcInputFileData%Pres_BLThick,1)
  i1_u = UBOUND(SrcInputFileData%Pres_BLThick,1)
  i2_l = LBOUND(SrcInputFileData%Pres_BLThick,2)
  i2_u = UBOUND(SrcInputFileData%Pres_BLThick,2)
  i3_l = LBOUND(SrcInputFileData%Pres_BLThick,3)
  i3_u = UBOUND(SrcInputFileData%Pres_BLThick,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Pres_BLThick)) THEN 
    ALLOCATE(DstInputFileData%Pres_BLThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_BLThick.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Pres_BLThick = SrcInputFileData%Pres_BLThick
ENDIF
IF (ALLOCATED(SrcInputFileData%Suct_BLThick)) THEN
  i1_l = LBOUND(SrcInputFileData%Suct_BLThick,1)
  i1_u = UBOUND(SrcInputFileData%Suct_BLThick,1)
  i2_l = LBOUND(SrcInputFileData%Suct_BLThick,2)
  i2_u = UBOUND(SrcInputFileData%Suct_BLThick,2)
  i3_l = LBOUND(SrcInputFileData%Suct_BLThick,3)
  i3_u = UBOUND(SrcInputFileData%Suct_BLThick,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Suct_BLThick)) THEN 
    ALLOCATE(DstInputFileData%Suct_BLThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_BLThick.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Suct_BLThick = SrcInputFileData%Suct_BLThick
ENDIF
IF (ALLOCATED(SrcInputFileData%Pres_Cf)) THEN
  i1_l = LBOUND(SrcInputFileData%Pres_Cf,1)
  i1_u = UBOUND(SrcInputFileData%Pres_Cf,1)
  i2_l = LBOUND(SrcInputFileData%Pres_Cf,2)
  i2_u = UBOUND(SrcInputFileData%Pres_Cf,2)
  i3_l = LBOUND(SrcInputFileData%Pres_Cf,3)
  i3_u = UBOUND(SrcInputFileData%Pres_Cf,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Pres_Cf)) THEN 
    ALLOCATE(DstInputFileData%Pres_Cf(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_Cf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Pres_Cf = SrcInputFileData%Pres_Cf
ENDIF
IF (ALLOCATED(SrcInputFileData%Suct_Cf)) THEN
  i1_l = LBOUND(SrcInputFileData%Suct_Cf,1)
  i1_u = UBOUND(SrcInputFileData%Suct_Cf,1)
  i2_l = LBOUND(SrcInputFileData%Suct_Cf,2)
  i2_u = UBOUND(SrcInputFileData%Suct_Cf,2)
  i3_l = LBOUND(SrcInputFileData%Suct_Cf,3)
  i3_u = UBOUND(SrcInputFileData%Suct_Cf,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Suct_Cf)) THEN 
    ALLOCATE(DstInputFileData%Suct_Cf(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_Cf.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Suct_Cf = SrcInputFileData%Suct_Cf
ENDIF
IF (ALLOCATED(SrcInputFileData%Pres_EdgeVelRat)) THEN
  i1_l = LBOUND(SrcInputFileData%Pres_EdgeVelRat,1)
  i1_u = UBOUND(SrcInputFileData%Pres_EdgeVelRat,1)
  i2_l = LBOUND(SrcInputFileData%Pres_EdgeVelRat,2)
  i2_u = UBOUND(SrcInputFileData%Pres_EdgeVelRat,2)
  i3_l = LBOUND(SrcInputFileData%Pres_EdgeVelRat,3)
  i3_u = UBOUND(SrcInputFileData%Pres_EdgeVelRat,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Pres_EdgeVelRat)) THEN 
    ALLOCATE(DstInputFileData%Pres_EdgeVelRat(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_EdgeVelRat.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Pres_EdgeVelRat = SrcInputFileData%Pres_EdgeVelRat
ENDIF
IF (ALLOCATED(SrcInputFileData%Suct_EdgeVelRat)) THEN
  i1_l = LBOUND(SrcInputFileData%Suct_EdgeVelRat,1)
  i1_u = UBOUND(SrcInputFileData%Suct_EdgeVelRat,1)
  i2_l = LBOUND(SrcInputFileData%Suct_EdgeVelRat,2)
  i2_u = UBOUND(SrcInputFileData%Suct_EdgeVelRat,2)
  i3_l = LBOUND(SrcInputFileData%Suct_EdgeVelRat,3)
  i3_u = UBOUND(SrcInputFileData%Suct_EdgeVelRat,3)
  IF (.NOT. ALLOCATED(DstInputFileData%Suct_EdgeVelRat)) THEN 
    ALLOCATE(DstInputFileData%Suct_EdgeVelRat(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_EdgeVelRat.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%Suct_EdgeVelRat = SrcInputFileData%Suct_EdgeVelRat
ENDIF
IF (ALLOCATED(SrcInputFileData%TI_Grid_In)) THEN
  i1_l = LBOUND(SrcInputFileData%TI_Grid_In,1)
  i1_u = UBOUND(SrcInputFileData%TI_Grid_In,1)
  i2_l = LBOUND(SrcInputFileData%TI_Grid_In,2)
  i2_u = UBOUND(SrcInputFileData%TI_Grid_In,2)
  IF (.NOT. ALLOCATED(DstInputFileData%TI_Grid_In)) THEN 
    ALLOCATE(DstInputFileData%TI_Grid_In(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%TI_Grid_In.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputFileData%TI_Grid_In = SrcInputFileData%TI_Grid_In
ENDIF
    DstInputFileData%dz_turb_in = SrcInputFileData%dz_turb_in
    DstInputFileData%dy_turb_in = SrcInputFileData%dy_turb_in
 END SUBROUTINE AA_CopyInputFile

 SUBROUTINE AA_DestroyInputFile( InputFileData, ErrStat, ErrMsg )
  TYPE(AA_InputFile), INTENT(INOUT) :: InputFileData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyInputFile'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputFileData%ObsX)) THEN
  DEALLOCATE(InputFileData%ObsX)
ENDIF
IF (ALLOCATED(InputFileData%ObsY)) THEN
  DEALLOCATE(InputFileData%ObsY)
ENDIF
IF (ALLOCATED(InputFileData%ObsZ)) THEN
  DEALLOCATE(InputFileData%ObsZ)
ENDIF
IF (ALLOCATED(InputFileData%BladeProps)) THEN
DO i1 = LBOUND(InputFileData%BladeProps,1), UBOUND(InputFileData%BladeProps,1)
  CALL AA_Destroybladepropstype( InputFileData%BladeProps(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(InputFileData%BladeProps)
ENDIF
IF (ALLOCATED(InputFileData%AAoutfile)) THEN
  DEALLOCATE(InputFileData%AAoutfile)
ENDIF
IF (ALLOCATED(InputFileData%ReListBL)) THEN
  DEALLOCATE(InputFileData%ReListBL)
ENDIF
IF (ALLOCATED(InputFileData%AoAListBL)) THEN
  DEALLOCATE(InputFileData%AoAListBL)
ENDIF
IF (ALLOCATED(InputFileData%Pres_DispThick)) THEN
  DEALLOCATE(InputFileData%Pres_DispThick)
ENDIF
IF (ALLOCATED(InputFileData%Suct_DispThick)) THEN
  DEALLOCATE(InputFileData%Suct_DispThick)
ENDIF
IF (ALLOCATED(InputFileData%Pres_BLThick)) THEN
  DEALLOCATE(InputFileData%Pres_BLThick)
ENDIF
IF (ALLOCATED(InputFileData%Suct_BLThick)) THEN
  DEALLOCATE(InputFileData%Suct_BLThick)
ENDIF
IF (ALLOCATED(InputFileData%Pres_Cf)) THEN
  DEALLOCATE(InputFileData%Pres_Cf)
ENDIF
IF (ALLOCATED(InputFileData%Suct_Cf)) THEN
  DEALLOCATE(InputFileData%Suct_Cf)
ENDIF
IF (ALLOCATED(InputFileData%Pres_EdgeVelRat)) THEN
  DEALLOCATE(InputFileData%Pres_EdgeVelRat)
ENDIF
IF (ALLOCATED(InputFileData%Suct_EdgeVelRat)) THEN
  DEALLOCATE(InputFileData%Suct_EdgeVelRat)
ENDIF
IF (ALLOCATED(InputFileData%TI_Grid_In)) THEN
  DEALLOCATE(InputFileData%TI_Grid_In)
ENDIF
 END SUBROUTINE AA_DestroyInputFile

 SUBROUTINE AA_PackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_InputFile),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackInputFile'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT_AA
      Int_BufSz  = Int_BufSz  + 1  ! IBLUNT
      Int_BufSz  = Int_BufSz  + 1  ! ILAM
      Int_BufSz  = Int_BufSz  + 1  ! ITIP
      Int_BufSz  = Int_BufSz  + 1  ! ITRIP
      Int_BufSz  = Int_BufSz  + 1  ! ITURB
      Int_BufSz  = Int_BufSz  + 1  ! IInflow
      Int_BufSz  = Int_BufSz  + 1  ! X_BLMethod
      Int_BufSz  = Int_BufSz  + 1  ! TICalcMeth
      Int_BufSz  = Int_BufSz  + 1  ! NReListBL
      Int_BufSz  = Int_BufSz  + 1  ! aweightflag
      Int_BufSz  = Int_BufSz  + 1  ! ROUND
      Re_BufSz   = Re_BufSz   + 1  ! ALPRAT
      Int_BufSz  = Int_BufSz  + 1  ! AA_Bl_Prcntge
      Int_BufSz  = Int_BufSz  + 1  ! NrObsLoc
  Int_BufSz   = Int_BufSz   + 1     ! ObsX allocated yes/no
  IF ( ALLOCATED(InData%ObsX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsX)  ! ObsX
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ObsY allocated yes/no
  IF ( ALLOCATED(InData%ObsY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsY)  ! ObsY
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ObsZ allocated yes/no
  IF ( ALLOCATED(InData%ObsZ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsZ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsZ)  ! ObsZ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BladeProps allocated yes/no
  IF ( ALLOCATED(InData%BladeProps) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! BladeProps upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%BladeProps,1), UBOUND(InData%BladeProps,1)
      Int_BufSz   = Int_BufSz + 3  ! BladeProps: size of buffers for each call to pack subtype
      CALL AA_Packbladepropstype( Re_Buf, Db_Buf, Int_Buf, InData%BladeProps(i1), ErrStat2, ErrMsg2, .TRUE. ) ! BladeProps 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! BladeProps
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! BladeProps
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! BladeProps
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NrOutFile
  Int_BufSz   = Int_BufSz   + 1     ! AAoutfile allocated yes/no
  IF ( ALLOCATED(InData%AAoutfile) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AAoutfile upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%AAoutfile)*LEN(InData%AAoutfile)  ! AAoutfile
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%TICalcTabFile)  ! TICalcTabFile
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%FTitle)  ! FTitle
      Db_BufSz   = Db_BufSz   + 1  ! AAStart
      Re_BufSz   = Re_BufSz   + 1  ! Lturb
      Re_BufSz   = Re_BufSz   + 1  ! AvgV
  Int_BufSz   = Int_BufSz   + 1     ! ReListBL allocated yes/no
  IF ( ALLOCATED(InData%ReListBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ReListBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ReListBL)  ! ReListBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AoAListBL allocated yes/no
  IF ( ALLOCATED(InData%AoAListBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AoAListBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AoAListBL)  ! AoAListBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Pres_DispThick allocated yes/no
  IF ( ALLOCATED(InData%Pres_DispThick) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Pres_DispThick upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Pres_DispThick)  ! Pres_DispThick
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Suct_DispThick allocated yes/no
  IF ( ALLOCATED(InData%Suct_DispThick) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Suct_DispThick upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Suct_DispThick)  ! Suct_DispThick
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Pres_BLThick allocated yes/no
  IF ( ALLOCATED(InData%Pres_BLThick) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Pres_BLThick upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Pres_BLThick)  ! Pres_BLThick
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Suct_BLThick allocated yes/no
  IF ( ALLOCATED(InData%Suct_BLThick) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Suct_BLThick upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Suct_BLThick)  ! Suct_BLThick
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Pres_Cf allocated yes/no
  IF ( ALLOCATED(InData%Pres_Cf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Pres_Cf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Pres_Cf)  ! Pres_Cf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Suct_Cf allocated yes/no
  IF ( ALLOCATED(InData%Suct_Cf) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Suct_Cf upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Suct_Cf)  ! Suct_Cf
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Pres_EdgeVelRat allocated yes/no
  IF ( ALLOCATED(InData%Pres_EdgeVelRat) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Pres_EdgeVelRat upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Pres_EdgeVelRat)  ! Pres_EdgeVelRat
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Suct_EdgeVelRat allocated yes/no
  IF ( ALLOCATED(InData%Suct_EdgeVelRat) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Suct_EdgeVelRat upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Suct_EdgeVelRat)  ! Suct_EdgeVelRat
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TI_Grid_In allocated yes/no
  IF ( ALLOCATED(InData%TI_Grid_In) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TI_Grid_In upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TI_Grid_In)  ! TI_Grid_In
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! dz_turb_in
      Re_BufSz   = Re_BufSz   + 1  ! dy_turb_in
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT_AA
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IBLUNT
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ILAM
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITIP
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITRIP
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITURB
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IInflow
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%X_BLMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TICalcMeth
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NReListBL
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%aweightflag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ROUND, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ALPRAT
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%AA_Bl_Prcntge
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NrObsLoc
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%ObsX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsX,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsX,1), UBOUND(InData%ObsX,1)
        ReKiBuf(Re_Xferred) = InData%ObsX(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ObsY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsY,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsY,1), UBOUND(InData%ObsY,1)
        ReKiBuf(Re_Xferred) = InData%ObsY(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ObsZ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsZ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsZ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsZ,1), UBOUND(InData%ObsZ,1)
        ReKiBuf(Re_Xferred) = InData%ObsZ(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BladeProps) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BladeProps,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BladeProps,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%BladeProps,1), UBOUND(InData%BladeProps,1)
      CALL AA_Packbladepropstype( Re_Buf, Db_Buf, Int_Buf, InData%BladeProps(i1), ErrStat2, ErrMsg2, OnlySize ) ! BladeProps 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NrOutFile
    Int_Xferred = Int_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%AAoutfile) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AAoutfile,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AAoutfile,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AAoutfile,1), UBOUND(InData%AAoutfile,1)
        DO I = 1, LEN(InData%AAoutfile)
          IntKiBuf(Int_Xferred) = ICHAR(InData%AAoutfile(i1)(I:I), IntKi)
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(InData%TICalcTabFile)
      IntKiBuf(Int_Xferred) = ICHAR(InData%TICalcTabFile(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%FTitle)
      IntKiBuf(Int_Xferred) = ICHAR(InData%FTitle(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DbKiBuf(Db_Xferred) = InData%AAStart
    Db_Xferred = Db_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Lturb
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AvgV
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%ReListBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ReListBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ReListBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ReListBL,1), UBOUND(InData%ReListBL,1)
        ReKiBuf(Re_Xferred) = InData%ReListBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AoAListBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AoAListBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AoAListBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AoAListBL,1), UBOUND(InData%AoAListBL,1)
        ReKiBuf(Re_Xferred) = InData%AoAListBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Pres_DispThick) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_DispThick,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_DispThick,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_DispThick,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_DispThick,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_DispThick,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_DispThick,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Pres_DispThick,3), UBOUND(InData%Pres_DispThick,3)
        DO i2 = LBOUND(InData%Pres_DispThick,2), UBOUND(InData%Pres_DispThick,2)
          DO i1 = LBOUND(InData%Pres_DispThick,1), UBOUND(InData%Pres_DispThick,1)
            ReKiBuf(Re_Xferred) = InData%Pres_DispThick(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Suct_DispThick) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_DispThick,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_DispThick,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_DispThick,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_DispThick,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_DispThick,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_DispThick,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Suct_DispThick,3), UBOUND(InData%Suct_DispThick,3)
        DO i2 = LBOUND(InData%Suct_DispThick,2), UBOUND(InData%Suct_DispThick,2)
          DO i1 = LBOUND(InData%Suct_DispThick,1), UBOUND(InData%Suct_DispThick,1)
            ReKiBuf(Re_Xferred) = InData%Suct_DispThick(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Pres_BLThick) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_BLThick,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_BLThick,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_BLThick,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_BLThick,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_BLThick,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_BLThick,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Pres_BLThick,3), UBOUND(InData%Pres_BLThick,3)
        DO i2 = LBOUND(InData%Pres_BLThick,2), UBOUND(InData%Pres_BLThick,2)
          DO i1 = LBOUND(InData%Pres_BLThick,1), UBOUND(InData%Pres_BLThick,1)
            ReKiBuf(Re_Xferred) = InData%Pres_BLThick(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Suct_BLThick) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_BLThick,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_BLThick,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_BLThick,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_BLThick,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_BLThick,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_BLThick,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Suct_BLThick,3), UBOUND(InData%Suct_BLThick,3)
        DO i2 = LBOUND(InData%Suct_BLThick,2), UBOUND(InData%Suct_BLThick,2)
          DO i1 = LBOUND(InData%Suct_BLThick,1), UBOUND(InData%Suct_BLThick,1)
            ReKiBuf(Re_Xferred) = InData%Suct_BLThick(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Pres_Cf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_Cf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_Cf,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_Cf,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_Cf,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_Cf,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_Cf,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Pres_Cf,3), UBOUND(InData%Pres_Cf,3)
        DO i2 = LBOUND(InData%Pres_Cf,2), UBOUND(InData%Pres_Cf,2)
          DO i1 = LBOUND(InData%Pres_Cf,1), UBOUND(InData%Pres_Cf,1)
            ReKiBuf(Re_Xferred) = InData%Pres_Cf(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Suct_Cf) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_Cf,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_Cf,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_Cf,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_Cf,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_Cf,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_Cf,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Suct_Cf,3), UBOUND(InData%Suct_Cf,3)
        DO i2 = LBOUND(InData%Suct_Cf,2), UBOUND(InData%Suct_Cf,2)
          DO i1 = LBOUND(InData%Suct_Cf,1), UBOUND(InData%Suct_Cf,1)
            ReKiBuf(Re_Xferred) = InData%Suct_Cf(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Pres_EdgeVelRat) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_EdgeVelRat,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_EdgeVelRat,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_EdgeVelRat,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_EdgeVelRat,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Pres_EdgeVelRat,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Pres_EdgeVelRat,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Pres_EdgeVelRat,3), UBOUND(InData%Pres_EdgeVelRat,3)
        DO i2 = LBOUND(InData%Pres_EdgeVelRat,2), UBOUND(InData%Pres_EdgeVelRat,2)
          DO i1 = LBOUND(InData%Pres_EdgeVelRat,1), UBOUND(InData%Pres_EdgeVelRat,1)
            ReKiBuf(Re_Xferred) = InData%Pres_EdgeVelRat(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Suct_EdgeVelRat) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_EdgeVelRat,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_EdgeVelRat,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_EdgeVelRat,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_EdgeVelRat,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Suct_EdgeVelRat,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Suct_EdgeVelRat,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Suct_EdgeVelRat,3), UBOUND(InData%Suct_EdgeVelRat,3)
        DO i2 = LBOUND(InData%Suct_EdgeVelRat,2), UBOUND(InData%Suct_EdgeVelRat,2)
          DO i1 = LBOUND(InData%Suct_EdgeVelRat,1), UBOUND(InData%Suct_EdgeVelRat,1)
            ReKiBuf(Re_Xferred) = InData%Suct_EdgeVelRat(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TI_Grid_In) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_Grid_In,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_Grid_In,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_Grid_In,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_Grid_In,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TI_Grid_In,2), UBOUND(InData%TI_Grid_In,2)
        DO i1 = LBOUND(InData%TI_Grid_In,1), UBOUND(InData%TI_Grid_In,1)
          ReKiBuf(Re_Xferred) = InData%TI_Grid_In(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%dz_turb_in
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dy_turb_in
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackInputFile

 SUBROUTINE AA_UnPackInputFile( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_InputFile), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackInputFile'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT_AA = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%IBLUNT = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ILAM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITIP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITRIP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITURB = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%IInflow = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%X_BLMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TICalcMeth = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NReListBL = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%aweightflag = TRANSFER(IntKiBuf(Int_Xferred), OutData%aweightflag)
    Int_Xferred = Int_Xferred + 1
    OutData%ROUND = TRANSFER(IntKiBuf(Int_Xferred), OutData%ROUND)
    Int_Xferred = Int_Xferred + 1
    OutData%ALPRAT = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AA_Bl_Prcntge = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NrObsLoc = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsX)) DEALLOCATE(OutData%ObsX)
    ALLOCATE(OutData%ObsX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsX,1), UBOUND(OutData%ObsX,1)
        OutData%ObsX(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsY)) DEALLOCATE(OutData%ObsY)
    ALLOCATE(OutData%ObsY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsY,1), UBOUND(OutData%ObsY,1)
        OutData%ObsY(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsZ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsZ)) DEALLOCATE(OutData%ObsZ)
    ALLOCATE(OutData%ObsZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsZ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsZ,1), UBOUND(OutData%ObsZ,1)
        OutData%ObsZ(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BladeProps not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BladeProps)) DEALLOCATE(OutData%BladeProps)
    ALLOCATE(OutData%BladeProps(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeProps.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%BladeProps,1), UBOUND(OutData%BladeProps,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AA_Unpackbladepropstype( Re_Buf, Db_Buf, Int_Buf, OutData%BladeProps(i1), ErrStat2, ErrMsg2 ) ! BladeProps 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
    OutData%NrOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AAoutfile not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AAoutfile)) DEALLOCATE(OutData%AAoutfile)
    ALLOCATE(OutData%AAoutfile(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AAoutfile.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AAoutfile,1), UBOUND(OutData%AAoutfile,1)
        DO I = 1, LEN(OutData%AAoutfile)
          OutData%AAoutfile(i1)(I:I) = CHAR(IntKiBuf(Int_Xferred))
          Int_Xferred = Int_Xferred + 1
        END DO ! I
      END DO
  END IF
    DO I = 1, LEN(OutData%TICalcTabFile)
      OutData%TICalcTabFile(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%FTitle)
      OutData%FTitle(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%AAStart = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%Lturb = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AvgV = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ReListBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ReListBL)) DEALLOCATE(OutData%ReListBL)
    ALLOCATE(OutData%ReListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ReListBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ReListBL,1), UBOUND(OutData%ReListBL,1)
        OutData%ReListBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AoAListBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AoAListBL)) DEALLOCATE(OutData%AoAListBL)
    ALLOCATE(OutData%AoAListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AoAListBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AoAListBL,1), UBOUND(OutData%AoAListBL,1)
        OutData%AoAListBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Pres_DispThick not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Pres_DispThick)) DEALLOCATE(OutData%Pres_DispThick)
    ALLOCATE(OutData%Pres_DispThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Pres_DispThick.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Pres_DispThick,3), UBOUND(OutData%Pres_DispThick,3)
        DO i2 = LBOUND(OutData%Pres_DispThick,2), UBOUND(OutData%Pres_DispThick,2)
          DO i1 = LBOUND(OutData%Pres_DispThick,1), UBOUND(OutData%Pres_DispThick,1)
            OutData%Pres_DispThick(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Suct_DispThick not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Suct_DispThick)) DEALLOCATE(OutData%Suct_DispThick)
    ALLOCATE(OutData%Suct_DispThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Suct_DispThick.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Suct_DispThick,3), UBOUND(OutData%Suct_DispThick,3)
        DO i2 = LBOUND(OutData%Suct_DispThick,2), UBOUND(OutData%Suct_DispThick,2)
          DO i1 = LBOUND(OutData%Suct_DispThick,1), UBOUND(OutData%Suct_DispThick,1)
            OutData%Suct_DispThick(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Pres_BLThick not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Pres_BLThick)) DEALLOCATE(OutData%Pres_BLThick)
    ALLOCATE(OutData%Pres_BLThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Pres_BLThick.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Pres_BLThick,3), UBOUND(OutData%Pres_BLThick,3)
        DO i2 = LBOUND(OutData%Pres_BLThick,2), UBOUND(OutData%Pres_BLThick,2)
          DO i1 = LBOUND(OutData%Pres_BLThick,1), UBOUND(OutData%Pres_BLThick,1)
            OutData%Pres_BLThick(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Suct_BLThick not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Suct_BLThick)) DEALLOCATE(OutData%Suct_BLThick)
    ALLOCATE(OutData%Suct_BLThick(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Suct_BLThick.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Suct_BLThick,3), UBOUND(OutData%Suct_BLThick,3)
        DO i2 = LBOUND(OutData%Suct_BLThick,2), UBOUND(OutData%Suct_BLThick,2)
          DO i1 = LBOUND(OutData%Suct_BLThick,1), UBOUND(OutData%Suct_BLThick,1)
            OutData%Suct_BLThick(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Pres_Cf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Pres_Cf)) DEALLOCATE(OutData%Pres_Cf)
    ALLOCATE(OutData%Pres_Cf(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Pres_Cf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Pres_Cf,3), UBOUND(OutData%Pres_Cf,3)
        DO i2 = LBOUND(OutData%Pres_Cf,2), UBOUND(OutData%Pres_Cf,2)
          DO i1 = LBOUND(OutData%Pres_Cf,1), UBOUND(OutData%Pres_Cf,1)
            OutData%Pres_Cf(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Suct_Cf not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Suct_Cf)) DEALLOCATE(OutData%Suct_Cf)
    ALLOCATE(OutData%Suct_Cf(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Suct_Cf.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Suct_Cf,3), UBOUND(OutData%Suct_Cf,3)
        DO i2 = LBOUND(OutData%Suct_Cf,2), UBOUND(OutData%Suct_Cf,2)
          DO i1 = LBOUND(OutData%Suct_Cf,1), UBOUND(OutData%Suct_Cf,1)
            OutData%Suct_Cf(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Pres_EdgeVelRat not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Pres_EdgeVelRat)) DEALLOCATE(OutData%Pres_EdgeVelRat)
    ALLOCATE(OutData%Pres_EdgeVelRat(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Pres_EdgeVelRat.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Pres_EdgeVelRat,3), UBOUND(OutData%Pres_EdgeVelRat,3)
        DO i2 = LBOUND(OutData%Pres_EdgeVelRat,2), UBOUND(OutData%Pres_EdgeVelRat,2)
          DO i1 = LBOUND(OutData%Pres_EdgeVelRat,1), UBOUND(OutData%Pres_EdgeVelRat,1)
            OutData%Pres_EdgeVelRat(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Suct_EdgeVelRat not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Suct_EdgeVelRat)) DEALLOCATE(OutData%Suct_EdgeVelRat)
    ALLOCATE(OutData%Suct_EdgeVelRat(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Suct_EdgeVelRat.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Suct_EdgeVelRat,3), UBOUND(OutData%Suct_EdgeVelRat,3)
        DO i2 = LBOUND(OutData%Suct_EdgeVelRat,2), UBOUND(OutData%Suct_EdgeVelRat,2)
          DO i1 = LBOUND(OutData%Suct_EdgeVelRat,1), UBOUND(OutData%Suct_EdgeVelRat,1)
            OutData%Suct_EdgeVelRat(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TI_Grid_In not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TI_Grid_In)) DEALLOCATE(OutData%TI_Grid_In)
    ALLOCATE(OutData%TI_Grid_In(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TI_Grid_In.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TI_Grid_In,2), UBOUND(OutData%TI_Grid_In,2)
        DO i1 = LBOUND(OutData%TI_Grid_In,1), UBOUND(OutData%TI_Grid_In,1)
          OutData%TI_Grid_In(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    OutData%dz_turb_in = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dy_turb_in = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackInputFile

 SUBROUTINE AA_CopyContState( SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_ContinuousStateType), INTENT(IN) :: SrcContStateData
   TYPE(AA_ContinuousStateType), INTENT(INOUT) :: DstContStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyContState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstContStateData%DummyContState = SrcContStateData%DummyContState
 END SUBROUTINE AA_CopyContState

 SUBROUTINE AA_DestroyContState( ContStateData, ErrStat, ErrMsg )
  TYPE(AA_ContinuousStateType), INTENT(INOUT) :: ContStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyContState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE AA_DestroyContState

 SUBROUTINE AA_PackContState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_ContinuousStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackContState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyContState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyContState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackContState

 SUBROUTINE AA_UnPackContState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_ContinuousStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackContState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyContState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackContState

 SUBROUTINE AA_CopyDiscState( SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_DiscreteStateType), INTENT(IN) :: SrcDiscStateData
   TYPE(AA_DiscreteStateType), INTENT(INOUT) :: DstDiscStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyDiscState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcDiscStateData%MeanVrel)) THEN
  i1_l = LBOUND(SrcDiscStateData%MeanVrel,1)
  i1_u = UBOUND(SrcDiscStateData%MeanVrel,1)
  i2_l = LBOUND(SrcDiscStateData%MeanVrel,2)
  i2_u = UBOUND(SrcDiscStateData%MeanVrel,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%MeanVrel)) THEN 
    ALLOCATE(DstDiscStateData%MeanVrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%MeanVrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%MeanVrel = SrcDiscStateData%MeanVrel
ENDIF
IF (ALLOCATED(SrcDiscStateData%VrelSq)) THEN
  i1_l = LBOUND(SrcDiscStateData%VrelSq,1)
  i1_u = UBOUND(SrcDiscStateData%VrelSq,1)
  i2_l = LBOUND(SrcDiscStateData%VrelSq,2)
  i2_u = UBOUND(SrcDiscStateData%VrelSq,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%VrelSq)) THEN 
    ALLOCATE(DstDiscStateData%VrelSq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VrelSq.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%VrelSq = SrcDiscStateData%VrelSq
ENDIF
IF (ALLOCATED(SrcDiscStateData%TIVrel)) THEN
  i1_l = LBOUND(SrcDiscStateData%TIVrel,1)
  i1_u = UBOUND(SrcDiscStateData%TIVrel,1)
  i2_l = LBOUND(SrcDiscStateData%TIVrel,2)
  i2_u = UBOUND(SrcDiscStateData%TIVrel,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%TIVrel)) THEN 
    ALLOCATE(DstDiscStateData%TIVrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TIVrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%TIVrel = SrcDiscStateData%TIVrel
ENDIF
IF (ALLOCATED(SrcDiscStateData%VrelStore)) THEN
  i1_l = LBOUND(SrcDiscStateData%VrelStore,1)
  i1_u = UBOUND(SrcDiscStateData%VrelStore,1)
  i2_l = LBOUND(SrcDiscStateData%VrelStore,2)
  i2_u = UBOUND(SrcDiscStateData%VrelStore,2)
  i3_l = LBOUND(SrcDiscStateData%VrelStore,3)
  i3_u = UBOUND(SrcDiscStateData%VrelStore,3)
  IF (.NOT. ALLOCATED(DstDiscStateData%VrelStore)) THEN 
    ALLOCATE(DstDiscStateData%VrelStore(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VrelStore.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%VrelStore = SrcDiscStateData%VrelStore
ENDIF
IF (ALLOCATED(SrcDiscStateData%TIVx)) THEN
  i1_l = LBOUND(SrcDiscStateData%TIVx,1)
  i1_u = UBOUND(SrcDiscStateData%TIVx,1)
  i2_l = LBOUND(SrcDiscStateData%TIVx,2)
  i2_u = UBOUND(SrcDiscStateData%TIVx,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%TIVx)) THEN 
    ALLOCATE(DstDiscStateData%TIVx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TIVx.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%TIVx = SrcDiscStateData%TIVx
ENDIF
IF (ALLOCATED(SrcDiscStateData%MeanVxVyVz)) THEN
  i1_l = LBOUND(SrcDiscStateData%MeanVxVyVz,1)
  i1_u = UBOUND(SrcDiscStateData%MeanVxVyVz,1)
  i2_l = LBOUND(SrcDiscStateData%MeanVxVyVz,2)
  i2_u = UBOUND(SrcDiscStateData%MeanVxVyVz,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%MeanVxVyVz)) THEN 
    ALLOCATE(DstDiscStateData%MeanVxVyVz(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%MeanVxVyVz.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%MeanVxVyVz = SrcDiscStateData%MeanVxVyVz
ENDIF
IF (ALLOCATED(SrcDiscStateData%VxSq)) THEN
  i1_l = LBOUND(SrcDiscStateData%VxSq,1)
  i1_u = UBOUND(SrcDiscStateData%VxSq,1)
  i2_l = LBOUND(SrcDiscStateData%VxSq,2)
  i2_u = UBOUND(SrcDiscStateData%VxSq,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%VxSq)) THEN 
    ALLOCATE(DstDiscStateData%VxSq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VxSq.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%VxSq = SrcDiscStateData%VxSq
ENDIF
IF (ALLOCATED(SrcDiscStateData%allregcounter)) THEN
  i1_l = LBOUND(SrcDiscStateData%allregcounter,1)
  i1_u = UBOUND(SrcDiscStateData%allregcounter,1)
  i2_l = LBOUND(SrcDiscStateData%allregcounter,2)
  i2_u = UBOUND(SrcDiscStateData%allregcounter,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%allregcounter)) THEN 
    ALLOCATE(DstDiscStateData%allregcounter(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%allregcounter.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%allregcounter = SrcDiscStateData%allregcounter
ENDIF
IF (ALLOCATED(SrcDiscStateData%VxSqRegion)) THEN
  i1_l = LBOUND(SrcDiscStateData%VxSqRegion,1)
  i1_u = UBOUND(SrcDiscStateData%VxSqRegion,1)
  i2_l = LBOUND(SrcDiscStateData%VxSqRegion,2)
  i2_u = UBOUND(SrcDiscStateData%VxSqRegion,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%VxSqRegion)) THEN 
    ALLOCATE(DstDiscStateData%VxSqRegion(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VxSqRegion.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%VxSqRegion = SrcDiscStateData%VxSqRegion
ENDIF
IF (ALLOCATED(SrcDiscStateData%RegVxStor)) THEN
  i1_l = LBOUND(SrcDiscStateData%RegVxStor,1)
  i1_u = UBOUND(SrcDiscStateData%RegVxStor,1)
  i2_l = LBOUND(SrcDiscStateData%RegVxStor,2)
  i2_u = UBOUND(SrcDiscStateData%RegVxStor,2)
  i3_l = LBOUND(SrcDiscStateData%RegVxStor,3)
  i3_u = UBOUND(SrcDiscStateData%RegVxStor,3)
  IF (.NOT. ALLOCATED(DstDiscStateData%RegVxStor)) THEN 
    ALLOCATE(DstDiscStateData%RegVxStor(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%RegVxStor.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%RegVxStor = SrcDiscStateData%RegVxStor
ENDIF
IF (ALLOCATED(SrcDiscStateData%RegionTIDelete)) THEN
  i1_l = LBOUND(SrcDiscStateData%RegionTIDelete,1)
  i1_u = UBOUND(SrcDiscStateData%RegionTIDelete,1)
  i2_l = LBOUND(SrcDiscStateData%RegionTIDelete,2)
  i2_u = UBOUND(SrcDiscStateData%RegionTIDelete,2)
  IF (.NOT. ALLOCATED(DstDiscStateData%RegionTIDelete)) THEN 
    ALLOCATE(DstDiscStateData%RegionTIDelete(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%RegionTIDelete.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstDiscStateData%RegionTIDelete = SrcDiscStateData%RegionTIDelete
ENDIF
 END SUBROUTINE AA_CopyDiscState

 SUBROUTINE AA_DestroyDiscState( DiscStateData, ErrStat, ErrMsg )
  TYPE(AA_DiscreteStateType), INTENT(INOUT) :: DiscStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyDiscState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(DiscStateData%MeanVrel)) THEN
  DEALLOCATE(DiscStateData%MeanVrel)
ENDIF
IF (ALLOCATED(DiscStateData%VrelSq)) THEN
  DEALLOCATE(DiscStateData%VrelSq)
ENDIF
IF (ALLOCATED(DiscStateData%TIVrel)) THEN
  DEALLOCATE(DiscStateData%TIVrel)
ENDIF
IF (ALLOCATED(DiscStateData%VrelStore)) THEN
  DEALLOCATE(DiscStateData%VrelStore)
ENDIF
IF (ALLOCATED(DiscStateData%TIVx)) THEN
  DEALLOCATE(DiscStateData%TIVx)
ENDIF
IF (ALLOCATED(DiscStateData%MeanVxVyVz)) THEN
  DEALLOCATE(DiscStateData%MeanVxVyVz)
ENDIF
IF (ALLOCATED(DiscStateData%VxSq)) THEN
  DEALLOCATE(DiscStateData%VxSq)
ENDIF
IF (ALLOCATED(DiscStateData%allregcounter)) THEN
  DEALLOCATE(DiscStateData%allregcounter)
ENDIF
IF (ALLOCATED(DiscStateData%VxSqRegion)) THEN
  DEALLOCATE(DiscStateData%VxSqRegion)
ENDIF
IF (ALLOCATED(DiscStateData%RegVxStor)) THEN
  DEALLOCATE(DiscStateData%RegVxStor)
ENDIF
IF (ALLOCATED(DiscStateData%RegionTIDelete)) THEN
  DEALLOCATE(DiscStateData%RegionTIDelete)
ENDIF
 END SUBROUTINE AA_DestroyDiscState

 SUBROUTINE AA_PackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_DiscreteStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackDiscState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! MeanVrel allocated yes/no
  IF ( ALLOCATED(InData%MeanVrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! MeanVrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MeanVrel)  ! MeanVrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! VrelSq allocated yes/no
  IF ( ALLOCATED(InData%VrelSq) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! VrelSq upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%VrelSq)  ! VrelSq
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TIVrel allocated yes/no
  IF ( ALLOCATED(InData%TIVrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TIVrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TIVrel)  ! TIVrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! VrelStore allocated yes/no
  IF ( ALLOCATED(InData%VrelStore) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! VrelStore upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%VrelStore)  ! VrelStore
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TIVx allocated yes/no
  IF ( ALLOCATED(InData%TIVx) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TIVx upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TIVx)  ! TIVx
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! MeanVxVyVz allocated yes/no
  IF ( ALLOCATED(InData%MeanVxVyVz) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! MeanVxVyVz upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%MeanVxVyVz)  ! MeanVxVyVz
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! VxSq allocated yes/no
  IF ( ALLOCATED(InData%VxSq) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! VxSq upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%VxSq)  ! VxSq
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! allregcounter allocated yes/no
  IF ( ALLOCATED(InData%allregcounter) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! allregcounter upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%allregcounter)  ! allregcounter
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! VxSqRegion allocated yes/no
  IF ( ALLOCATED(InData%VxSqRegion) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! VxSqRegion upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%VxSqRegion)  ! VxSqRegion
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RegVxStor allocated yes/no
  IF ( ALLOCATED(InData%RegVxStor) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! RegVxStor upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RegVxStor)  ! RegVxStor
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! RegionTIDelete allocated yes/no
  IF ( ALLOCATED(InData%RegionTIDelete) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! RegionTIDelete upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RegionTIDelete)  ! RegionTIDelete
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%MeanVrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeanVrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeanVrel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeanVrel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeanVrel,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%MeanVrel,2), UBOUND(InData%MeanVrel,2)
        DO i1 = LBOUND(InData%MeanVrel,1), UBOUND(InData%MeanVrel,1)
          ReKiBuf(Re_Xferred) = InData%MeanVrel(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%VrelSq) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VrelSq,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VrelSq,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VrelSq,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VrelSq,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%VrelSq,2), UBOUND(InData%VrelSq,2)
        DO i1 = LBOUND(InData%VrelSq,1), UBOUND(InData%VrelSq,1)
          ReKiBuf(Re_Xferred) = InData%VrelSq(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TIVrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TIVrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TIVrel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TIVrel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TIVrel,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TIVrel,2), UBOUND(InData%TIVrel,2)
        DO i1 = LBOUND(InData%TIVrel,1), UBOUND(InData%TIVrel,1)
          ReKiBuf(Re_Xferred) = InData%TIVrel(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%VrelStore) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VrelStore,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VrelStore,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VrelStore,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VrelStore,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VrelStore,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VrelStore,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%VrelStore,3), UBOUND(InData%VrelStore,3)
        DO i2 = LBOUND(InData%VrelStore,2), UBOUND(InData%VrelStore,2)
          DO i1 = LBOUND(InData%VrelStore,1), UBOUND(InData%VrelStore,1)
            ReKiBuf(Re_Xferred) = InData%VrelStore(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TIVx) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TIVx,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TIVx,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TIVx,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TIVx,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TIVx,2), UBOUND(InData%TIVx,2)
        DO i1 = LBOUND(InData%TIVx,1), UBOUND(InData%TIVx,1)
          ReKiBuf(Re_Xferred) = InData%TIVx(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%MeanVxVyVz) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeanVxVyVz,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeanVxVyVz,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%MeanVxVyVz,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%MeanVxVyVz,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%MeanVxVyVz,2), UBOUND(InData%MeanVxVyVz,2)
        DO i1 = LBOUND(InData%MeanVxVyVz,1), UBOUND(InData%MeanVxVyVz,1)
          ReKiBuf(Re_Xferred) = InData%MeanVxVyVz(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%VxSq) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VxSq,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VxSq,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VxSq,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VxSq,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%VxSq,2), UBOUND(InData%VxSq,2)
        DO i1 = LBOUND(InData%VxSq,1), UBOUND(InData%VxSq,1)
          ReKiBuf(Re_Xferred) = InData%VxSq(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%allregcounter) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%allregcounter,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%allregcounter,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%allregcounter,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%allregcounter,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%allregcounter,2), UBOUND(InData%allregcounter,2)
        DO i1 = LBOUND(InData%allregcounter,1), UBOUND(InData%allregcounter,1)
          ReKiBuf(Re_Xferred) = InData%allregcounter(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%VxSqRegion) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VxSqRegion,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VxSqRegion,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%VxSqRegion,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%VxSqRegion,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%VxSqRegion,2), UBOUND(InData%VxSqRegion,2)
        DO i1 = LBOUND(InData%VxSqRegion,1), UBOUND(InData%VxSqRegion,1)
          ReKiBuf(Re_Xferred) = InData%VxSqRegion(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RegVxStor) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RegVxStor,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RegVxStor,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RegVxStor,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RegVxStor,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RegVxStor,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RegVxStor,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%RegVxStor,3), UBOUND(InData%RegVxStor,3)
        DO i2 = LBOUND(InData%RegVxStor,2), UBOUND(InData%RegVxStor,2)
          DO i1 = LBOUND(InData%RegVxStor,1), UBOUND(InData%RegVxStor,1)
            ReKiBuf(Re_Xferred) = InData%RegVxStor(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%RegionTIDelete) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RegionTIDelete,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RegionTIDelete,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RegionTIDelete,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RegionTIDelete,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%RegionTIDelete,2), UBOUND(InData%RegionTIDelete,2)
        DO i1 = LBOUND(InData%RegionTIDelete,1), UBOUND(InData%RegionTIDelete,1)
          ReKiBuf(Re_Xferred) = InData%RegionTIDelete(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AA_PackDiscState

 SUBROUTINE AA_UnPackDiscState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_DiscreteStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackDiscState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MeanVrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MeanVrel)) DEALLOCATE(OutData%MeanVrel)
    ALLOCATE(OutData%MeanVrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MeanVrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%MeanVrel,2), UBOUND(OutData%MeanVrel,2)
        DO i1 = LBOUND(OutData%MeanVrel,1), UBOUND(OutData%MeanVrel,1)
          OutData%MeanVrel(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! VrelSq not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%VrelSq)) DEALLOCATE(OutData%VrelSq)
    ALLOCATE(OutData%VrelSq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%VrelSq.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%VrelSq,2), UBOUND(OutData%VrelSq,2)
        DO i1 = LBOUND(OutData%VrelSq,1), UBOUND(OutData%VrelSq,1)
          OutData%VrelSq(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TIVrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TIVrel)) DEALLOCATE(OutData%TIVrel)
    ALLOCATE(OutData%TIVrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TIVrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TIVrel,2), UBOUND(OutData%TIVrel,2)
        DO i1 = LBOUND(OutData%TIVrel,1), UBOUND(OutData%TIVrel,1)
          OutData%TIVrel(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! VrelStore not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%VrelStore)) DEALLOCATE(OutData%VrelStore)
    ALLOCATE(OutData%VrelStore(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%VrelStore.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%VrelStore,3), UBOUND(OutData%VrelStore,3)
        DO i2 = LBOUND(OutData%VrelStore,2), UBOUND(OutData%VrelStore,2)
          DO i1 = LBOUND(OutData%VrelStore,1), UBOUND(OutData%VrelStore,1)
            OutData%VrelStore(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TIVx not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TIVx)) DEALLOCATE(OutData%TIVx)
    ALLOCATE(OutData%TIVx(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TIVx.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TIVx,2), UBOUND(OutData%TIVx,2)
        DO i1 = LBOUND(OutData%TIVx,1), UBOUND(OutData%TIVx,1)
          OutData%TIVx(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! MeanVxVyVz not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%MeanVxVyVz)) DEALLOCATE(OutData%MeanVxVyVz)
    ALLOCATE(OutData%MeanVxVyVz(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%MeanVxVyVz.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%MeanVxVyVz,2), UBOUND(OutData%MeanVxVyVz,2)
        DO i1 = LBOUND(OutData%MeanVxVyVz,1), UBOUND(OutData%MeanVxVyVz,1)
          OutData%MeanVxVyVz(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! VxSq not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%VxSq)) DEALLOCATE(OutData%VxSq)
    ALLOCATE(OutData%VxSq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%VxSq.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%VxSq,2), UBOUND(OutData%VxSq,2)
        DO i1 = LBOUND(OutData%VxSq,1), UBOUND(OutData%VxSq,1)
          OutData%VxSq(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! allregcounter not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%allregcounter)) DEALLOCATE(OutData%allregcounter)
    ALLOCATE(OutData%allregcounter(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%allregcounter.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%allregcounter,2), UBOUND(OutData%allregcounter,2)
        DO i1 = LBOUND(OutData%allregcounter,1), UBOUND(OutData%allregcounter,1)
          OutData%allregcounter(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! VxSqRegion not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%VxSqRegion)) DEALLOCATE(OutData%VxSqRegion)
    ALLOCATE(OutData%VxSqRegion(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%VxSqRegion.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%VxSqRegion,2), UBOUND(OutData%VxSqRegion,2)
        DO i1 = LBOUND(OutData%VxSqRegion,1), UBOUND(OutData%VxSqRegion,1)
          OutData%VxSqRegion(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RegVxStor not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RegVxStor)) DEALLOCATE(OutData%RegVxStor)
    ALLOCATE(OutData%RegVxStor(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RegVxStor.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%RegVxStor,3), UBOUND(OutData%RegVxStor,3)
        DO i2 = LBOUND(OutData%RegVxStor,2), UBOUND(OutData%RegVxStor,2)
          DO i1 = LBOUND(OutData%RegVxStor,1), UBOUND(OutData%RegVxStor,1)
            OutData%RegVxStor(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RegionTIDelete not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RegionTIDelete)) DEALLOCATE(OutData%RegionTIDelete)
    ALLOCATE(OutData%RegionTIDelete(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RegionTIDelete.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%RegionTIDelete,2), UBOUND(OutData%RegionTIDelete,2)
        DO i1 = LBOUND(OutData%RegionTIDelete,1), UBOUND(OutData%RegionTIDelete,1)
          OutData%RegionTIDelete(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AA_UnPackDiscState

 SUBROUTINE AA_CopyConstrState( SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_ConstraintStateType), INTENT(IN) :: SrcConstrStateData
   TYPE(AA_ConstraintStateType), INTENT(INOUT) :: DstConstrStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyConstrState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
 END SUBROUTINE AA_CopyConstrState

 SUBROUTINE AA_DestroyConstrState( ConstrStateData, ErrStat, ErrMsg )
  TYPE(AA_ConstraintStateType), INTENT(INOUT) :: ConstrStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyConstrState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE AA_DestroyConstrState

 SUBROUTINE AA_PackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_ConstraintStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackConstrState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyConstrState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyConstrState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackConstrState

 SUBROUTINE AA_UnPackConstrState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_ConstraintStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackConstrState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyConstrState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackConstrState

 SUBROUTINE AA_CopyOtherState( SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_OtherStateType), INTENT(IN) :: SrcOtherStateData
   TYPE(AA_OtherStateType), INTENT(INOUT) :: DstOtherStateData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyOtherState'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
 END SUBROUTINE AA_CopyOtherState

 SUBROUTINE AA_DestroyOtherState( OtherStateData, ErrStat, ErrMsg )
  TYPE(AA_OtherStateType), INTENT(INOUT) :: OtherStateData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyOtherState'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
 END SUBROUTINE AA_DestroyOtherState

 SUBROUTINE AA_PackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_OtherStateType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackOtherState'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Re_BufSz   = Re_BufSz   + 1  ! DummyOtherState
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    ReKiBuf(Re_Xferred) = InData%DummyOtherState
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_PackOtherState

 SUBROUTINE AA_UnPackOtherState( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_OtherStateType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackOtherState'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DummyOtherState = REAL(ReKiBuf(Re_Xferred), SiKi)
    Re_Xferred = Re_Xferred + 1
 END SUBROUTINE AA_UnPackOtherState

 SUBROUTINE AA_CopyMisc( SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_MiscVarType), INTENT(IN) :: SrcMiscData
   TYPE(AA_MiscVarType), INTENT(INOUT) :: DstMiscData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyMisc'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcMiscData%AllOuts)) THEN
  i1_l = LBOUND(SrcMiscData%AllOuts,1)
  i1_u = UBOUND(SrcMiscData%AllOuts,1)
  IF (.NOT. ALLOCATED(DstMiscData%AllOuts)) THEN 
    ALLOCATE(DstMiscData%AllOuts(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%AllOuts = SrcMiscData%AllOuts
ENDIF
IF (ALLOCATED(SrcMiscData%ChordAngleTE)) THEN
  i1_l = LBOUND(SrcMiscData%ChordAngleTE,1)
  i1_u = UBOUND(SrcMiscData%ChordAngleTE,1)
  i2_l = LBOUND(SrcMiscData%ChordAngleTE,2)
  i2_u = UBOUND(SrcMiscData%ChordAngleTE,2)
  i3_l = LBOUND(SrcMiscData%ChordAngleTE,3)
  i3_u = UBOUND(SrcMiscData%ChordAngleTE,3)
  IF (.NOT. ALLOCATED(DstMiscData%ChordAngleTE)) THEN 
    ALLOCATE(DstMiscData%ChordAngleTE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ChordAngleTE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%ChordAngleTE = SrcMiscData%ChordAngleTE
ENDIF
IF (ALLOCATED(SrcMiscData%SpanAngleTE)) THEN
  i1_l = LBOUND(SrcMiscData%SpanAngleTE,1)
  i1_u = UBOUND(SrcMiscData%SpanAngleTE,1)
  i2_l = LBOUND(SrcMiscData%SpanAngleTE,2)
  i2_u = UBOUND(SrcMiscData%SpanAngleTE,2)
  i3_l = LBOUND(SrcMiscData%SpanAngleTE,3)
  i3_u = UBOUND(SrcMiscData%SpanAngleTE,3)
  IF (.NOT. ALLOCATED(DstMiscData%SpanAngleTE)) THEN 
    ALLOCATE(DstMiscData%SpanAngleTE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SpanAngleTE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SpanAngleTE = SrcMiscData%SpanAngleTE
ENDIF
IF (ALLOCATED(SrcMiscData%ChordAngleLE)) THEN
  i1_l = LBOUND(SrcMiscData%ChordAngleLE,1)
  i1_u = UBOUND(SrcMiscData%ChordAngleLE,1)
  i2_l = LBOUND(SrcMiscData%ChordAngleLE,2)
  i2_u = UBOUND(SrcMiscData%ChordAngleLE,2)
  i3_l = LBOUND(SrcMiscData%ChordAngleLE,3)
  i3_u = UBOUND(SrcMiscData%ChordAngleLE,3)
  IF (.NOT. ALLOCATED(DstMiscData%ChordAngleLE)) THEN 
    ALLOCATE(DstMiscData%ChordAngleLE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ChordAngleLE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%ChordAngleLE = SrcMiscData%ChordAngleLE
ENDIF
IF (ALLOCATED(SrcMiscData%SpanAngleLE)) THEN
  i1_l = LBOUND(SrcMiscData%SpanAngleLE,1)
  i1_u = UBOUND(SrcMiscData%SpanAngleLE,1)
  i2_l = LBOUND(SrcMiscData%SpanAngleLE,2)
  i2_u = UBOUND(SrcMiscData%SpanAngleLE,2)
  i3_l = LBOUND(SrcMiscData%SpanAngleLE,3)
  i3_u = UBOUND(SrcMiscData%SpanAngleLE,3)
  IF (.NOT. ALLOCATED(DstMiscData%SpanAngleLE)) THEN 
    ALLOCATE(DstMiscData%SpanAngleLE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SpanAngleLE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SpanAngleLE = SrcMiscData%SpanAngleLE
ENDIF
IF (ALLOCATED(SrcMiscData%rTEtoObserve)) THEN
  i1_l = LBOUND(SrcMiscData%rTEtoObserve,1)
  i1_u = UBOUND(SrcMiscData%rTEtoObserve,1)
  i2_l = LBOUND(SrcMiscData%rTEtoObserve,2)
  i2_u = UBOUND(SrcMiscData%rTEtoObserve,2)
  i3_l = LBOUND(SrcMiscData%rTEtoObserve,3)
  i3_u = UBOUND(SrcMiscData%rTEtoObserve,3)
  IF (.NOT. ALLOCATED(DstMiscData%rTEtoObserve)) THEN 
    ALLOCATE(DstMiscData%rTEtoObserve(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rTEtoObserve.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%rTEtoObserve = SrcMiscData%rTEtoObserve
ENDIF
IF (ALLOCATED(SrcMiscData%rLEtoObserve)) THEN
  i1_l = LBOUND(SrcMiscData%rLEtoObserve,1)
  i1_u = UBOUND(SrcMiscData%rLEtoObserve,1)
  i2_l = LBOUND(SrcMiscData%rLEtoObserve,2)
  i2_u = UBOUND(SrcMiscData%rLEtoObserve,2)
  i3_l = LBOUND(SrcMiscData%rLEtoObserve,3)
  i3_u = UBOUND(SrcMiscData%rLEtoObserve,3)
  IF (.NOT. ALLOCATED(DstMiscData%rLEtoObserve)) THEN 
    ALLOCATE(DstMiscData%rLEtoObserve(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rLEtoObserve.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%rLEtoObserve = SrcMiscData%rLEtoObserve
ENDIF
IF (ALLOCATED(SrcMiscData%LE_Location)) THEN
  i1_l = LBOUND(SrcMiscData%LE_Location,1)
  i1_u = UBOUND(SrcMiscData%LE_Location,1)
  i2_l = LBOUND(SrcMiscData%LE_Location,2)
  i2_u = UBOUND(SrcMiscData%LE_Location,2)
  i3_l = LBOUND(SrcMiscData%LE_Location,3)
  i3_u = UBOUND(SrcMiscData%LE_Location,3)
  IF (.NOT. ALLOCATED(DstMiscData%LE_Location)) THEN 
    ALLOCATE(DstMiscData%LE_Location(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LE_Location.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%LE_Location = SrcMiscData%LE_Location
ENDIF
    DstMiscData%RotSpeedAoA = SrcMiscData%RotSpeedAoA
IF (ALLOCATED(SrcMiscData%SPLLBL)) THEN
  i1_l = LBOUND(SrcMiscData%SPLLBL,1)
  i1_u = UBOUND(SrcMiscData%SPLLBL,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLLBL)) THEN 
    ALLOCATE(DstMiscData%SPLLBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLLBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLLBL = SrcMiscData%SPLLBL
ENDIF
IF (ALLOCATED(SrcMiscData%SPLP)) THEN
  i1_l = LBOUND(SrcMiscData%SPLP,1)
  i1_u = UBOUND(SrcMiscData%SPLP,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLP)) THEN 
    ALLOCATE(DstMiscData%SPLP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLP = SrcMiscData%SPLP
ENDIF
IF (ALLOCATED(SrcMiscData%SPLS)) THEN
  i1_l = LBOUND(SrcMiscData%SPLS,1)
  i1_u = UBOUND(SrcMiscData%SPLS,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLS)) THEN 
    ALLOCATE(DstMiscData%SPLS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLS.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLS = SrcMiscData%SPLS
ENDIF
IF (ALLOCATED(SrcMiscData%SPLALPH)) THEN
  i1_l = LBOUND(SrcMiscData%SPLALPH,1)
  i1_u = UBOUND(SrcMiscData%SPLALPH,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLALPH)) THEN 
    ALLOCATE(DstMiscData%SPLALPH(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLALPH.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLALPH = SrcMiscData%SPLALPH
ENDIF
IF (ALLOCATED(SrcMiscData%SPLTBL)) THEN
  i1_l = LBOUND(SrcMiscData%SPLTBL,1)
  i1_u = UBOUND(SrcMiscData%SPLTBL,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLTBL)) THEN 
    ALLOCATE(DstMiscData%SPLTBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLTBL = SrcMiscData%SPLTBL
ENDIF
IF (ALLOCATED(SrcMiscData%SPLTIP)) THEN
  i1_l = LBOUND(SrcMiscData%SPLTIP,1)
  i1_u = UBOUND(SrcMiscData%SPLTIP,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLTIP)) THEN 
    ALLOCATE(DstMiscData%SPLTIP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTIP.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLTIP = SrcMiscData%SPLTIP
ENDIF
IF (ALLOCATED(SrcMiscData%SPLTI)) THEN
  i1_l = LBOUND(SrcMiscData%SPLTI,1)
  i1_u = UBOUND(SrcMiscData%SPLTI,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLTI)) THEN 
    ALLOCATE(DstMiscData%SPLTI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTI.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLTI = SrcMiscData%SPLTI
ENDIF
IF (ALLOCATED(SrcMiscData%SPLTIGui)) THEN
  i1_l = LBOUND(SrcMiscData%SPLTIGui,1)
  i1_u = UBOUND(SrcMiscData%SPLTIGui,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLTIGui)) THEN 
    ALLOCATE(DstMiscData%SPLTIGui(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTIGui.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLTIGui = SrcMiscData%SPLTIGui
ENDIF
IF (ALLOCATED(SrcMiscData%SPLBLUNT)) THEN
  i1_l = LBOUND(SrcMiscData%SPLBLUNT,1)
  i1_u = UBOUND(SrcMiscData%SPLBLUNT,1)
  IF (.NOT. ALLOCATED(DstMiscData%SPLBLUNT)) THEN 
    ALLOCATE(DstMiscData%SPLBLUNT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLBLUNT.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%SPLBLUNT = SrcMiscData%SPLBLUNT
ENDIF
IF (ALLOCATED(SrcMiscData%CfVar)) THEN
  i1_l = LBOUND(SrcMiscData%CfVar,1)
  i1_u = UBOUND(SrcMiscData%CfVar,1)
  IF (.NOT. ALLOCATED(DstMiscData%CfVar)) THEN 
    ALLOCATE(DstMiscData%CfVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CfVar.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%CfVar = SrcMiscData%CfVar
ENDIF
IF (ALLOCATED(SrcMiscData%d99Var)) THEN
  i1_l = LBOUND(SrcMiscData%d99Var,1)
  i1_u = UBOUND(SrcMiscData%d99Var,1)
  IF (.NOT. ALLOCATED(DstMiscData%d99Var)) THEN 
    ALLOCATE(DstMiscData%d99Var(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%d99Var.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%d99Var = SrcMiscData%d99Var
ENDIF
IF (ALLOCATED(SrcMiscData%dStarVar)) THEN
  i1_l = LBOUND(SrcMiscData%dStarVar,1)
  i1_u = UBOUND(SrcMiscData%dStarVar,1)
  IF (.NOT. ALLOCATED(DstMiscData%dStarVar)) THEN 
    ALLOCATE(DstMiscData%dStarVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dStarVar.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%dStarVar = SrcMiscData%dStarVar
ENDIF
IF (ALLOCATED(SrcMiscData%EdgeVelVar)) THEN
  i1_l = LBOUND(SrcMiscData%EdgeVelVar,1)
  i1_u = UBOUND(SrcMiscData%EdgeVelVar,1)
  IF (.NOT. ALLOCATED(DstMiscData%EdgeVelVar)) THEN 
    ALLOCATE(DstMiscData%EdgeVelVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%EdgeVelVar.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstMiscData%EdgeVelVar = SrcMiscData%EdgeVelVar
ENDIF
    DstMiscData%speccou = SrcMiscData%speccou
    DstMiscData%filesopen = SrcMiscData%filesopen
 END SUBROUTINE AA_CopyMisc

 SUBROUTINE AA_DestroyMisc( MiscData, ErrStat, ErrMsg )
  TYPE(AA_MiscVarType), INTENT(INOUT) :: MiscData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyMisc'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(MiscData%AllOuts)) THEN
  DEALLOCATE(MiscData%AllOuts)
ENDIF
IF (ALLOCATED(MiscData%ChordAngleTE)) THEN
  DEALLOCATE(MiscData%ChordAngleTE)
ENDIF
IF (ALLOCATED(MiscData%SpanAngleTE)) THEN
  DEALLOCATE(MiscData%SpanAngleTE)
ENDIF
IF (ALLOCATED(MiscData%ChordAngleLE)) THEN
  DEALLOCATE(MiscData%ChordAngleLE)
ENDIF
IF (ALLOCATED(MiscData%SpanAngleLE)) THEN
  DEALLOCATE(MiscData%SpanAngleLE)
ENDIF
IF (ALLOCATED(MiscData%rTEtoObserve)) THEN
  DEALLOCATE(MiscData%rTEtoObserve)
ENDIF
IF (ALLOCATED(MiscData%rLEtoObserve)) THEN
  DEALLOCATE(MiscData%rLEtoObserve)
ENDIF
IF (ALLOCATED(MiscData%LE_Location)) THEN
  DEALLOCATE(MiscData%LE_Location)
ENDIF
IF (ALLOCATED(MiscData%SPLLBL)) THEN
  DEALLOCATE(MiscData%SPLLBL)
ENDIF
IF (ALLOCATED(MiscData%SPLP)) THEN
  DEALLOCATE(MiscData%SPLP)
ENDIF
IF (ALLOCATED(MiscData%SPLS)) THEN
  DEALLOCATE(MiscData%SPLS)
ENDIF
IF (ALLOCATED(MiscData%SPLALPH)) THEN
  DEALLOCATE(MiscData%SPLALPH)
ENDIF
IF (ALLOCATED(MiscData%SPLTBL)) THEN
  DEALLOCATE(MiscData%SPLTBL)
ENDIF
IF (ALLOCATED(MiscData%SPLTIP)) THEN
  DEALLOCATE(MiscData%SPLTIP)
ENDIF
IF (ALLOCATED(MiscData%SPLTI)) THEN
  DEALLOCATE(MiscData%SPLTI)
ENDIF
IF (ALLOCATED(MiscData%SPLTIGui)) THEN
  DEALLOCATE(MiscData%SPLTIGui)
ENDIF
IF (ALLOCATED(MiscData%SPLBLUNT)) THEN
  DEALLOCATE(MiscData%SPLBLUNT)
ENDIF
IF (ALLOCATED(MiscData%CfVar)) THEN
  DEALLOCATE(MiscData%CfVar)
ENDIF
IF (ALLOCATED(MiscData%d99Var)) THEN
  DEALLOCATE(MiscData%d99Var)
ENDIF
IF (ALLOCATED(MiscData%dStarVar)) THEN
  DEALLOCATE(MiscData%dStarVar)
ENDIF
IF (ALLOCATED(MiscData%EdgeVelVar)) THEN
  DEALLOCATE(MiscData%EdgeVelVar)
ENDIF
 END SUBROUTINE AA_DestroyMisc

 SUBROUTINE AA_PackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_MiscVarType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackMisc'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! AllOuts allocated yes/no
  IF ( ALLOCATED(InData%AllOuts) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AllOuts upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AllOuts)  ! AllOuts
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ChordAngleTE allocated yes/no
  IF ( ALLOCATED(InData%ChordAngleTE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! ChordAngleTE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ChordAngleTE)  ! ChordAngleTE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SpanAngleTE allocated yes/no
  IF ( ALLOCATED(InData%SpanAngleTE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! SpanAngleTE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SpanAngleTE)  ! SpanAngleTE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ChordAngleLE allocated yes/no
  IF ( ALLOCATED(InData%ChordAngleLE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! ChordAngleLE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ChordAngleLE)  ! ChordAngleLE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SpanAngleLE allocated yes/no
  IF ( ALLOCATED(InData%SpanAngleLE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! SpanAngleLE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SpanAngleLE)  ! SpanAngleLE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rTEtoObserve allocated yes/no
  IF ( ALLOCATED(InData%rTEtoObserve) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rTEtoObserve upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rTEtoObserve)  ! rTEtoObserve
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rLEtoObserve allocated yes/no
  IF ( ALLOCATED(InData%rLEtoObserve) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! rLEtoObserve upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rLEtoObserve)  ! rLEtoObserve
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! LE_Location allocated yes/no
  IF ( ALLOCATED(InData%LE_Location) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! LE_Location upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%LE_Location)  ! LE_Location
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! RotSpeedAoA
  Int_BufSz   = Int_BufSz   + 1     ! SPLLBL allocated yes/no
  IF ( ALLOCATED(InData%SPLLBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLLBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLLBL)  ! SPLLBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLP allocated yes/no
  IF ( ALLOCATED(InData%SPLP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLP)  ! SPLP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLS allocated yes/no
  IF ( ALLOCATED(InData%SPLS) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLS upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLS)  ! SPLS
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLALPH allocated yes/no
  IF ( ALLOCATED(InData%SPLALPH) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLALPH upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLALPH)  ! SPLALPH
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLTBL allocated yes/no
  IF ( ALLOCATED(InData%SPLTBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLTBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLTBL)  ! SPLTBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLTIP allocated yes/no
  IF ( ALLOCATED(InData%SPLTIP) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLTIP upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLTIP)  ! SPLTIP
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLTI allocated yes/no
  IF ( ALLOCATED(InData%SPLTI) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLTI upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLTI)  ! SPLTI
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLTIGui allocated yes/no
  IF ( ALLOCATED(InData%SPLTIGui) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLTIGui upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLTIGui)  ! SPLTIGui
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SPLBLUNT allocated yes/no
  IF ( ALLOCATED(InData%SPLBLUNT) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! SPLBLUNT upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SPLBLUNT)  ! SPLBLUNT
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CfVar allocated yes/no
  IF ( ALLOCATED(InData%CfVar) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! CfVar upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CfVar)  ! CfVar
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! d99Var allocated yes/no
  IF ( ALLOCATED(InData%d99Var) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! d99Var upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%d99Var)  ! d99Var
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dStarVar allocated yes/no
  IF ( ALLOCATED(InData%dStarVar) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! dStarVar upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dStarVar)  ! dStarVar
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgeVelVar allocated yes/no
  IF ( ALLOCATED(InData%EdgeVelVar) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! EdgeVelVar upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgeVelVar)  ! EdgeVelVar
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! speccou
      Int_BufSz  = Int_BufSz  + 1  ! filesopen
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%AllOuts) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AllOuts,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AllOuts,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AllOuts,1), UBOUND(InData%AllOuts,1)
        ReKiBuf(Re_Xferred) = InData%AllOuts(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ChordAngleTE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleTE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleTE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleTE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleTE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleTE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleTE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%ChordAngleTE,3), UBOUND(InData%ChordAngleTE,3)
        DO i2 = LBOUND(InData%ChordAngleTE,2), UBOUND(InData%ChordAngleTE,2)
          DO i1 = LBOUND(InData%ChordAngleTE,1), UBOUND(InData%ChordAngleTE,1)
            ReKiBuf(Re_Xferred) = InData%ChordAngleTE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SpanAngleTE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleTE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleTE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleTE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleTE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleTE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleTE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%SpanAngleTE,3), UBOUND(InData%SpanAngleTE,3)
        DO i2 = LBOUND(InData%SpanAngleTE,2), UBOUND(InData%SpanAngleTE,2)
          DO i1 = LBOUND(InData%SpanAngleTE,1), UBOUND(InData%SpanAngleTE,1)
            ReKiBuf(Re_Xferred) = InData%SpanAngleTE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ChordAngleLE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleLE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleLE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleLE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleLE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ChordAngleLE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ChordAngleLE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%ChordAngleLE,3), UBOUND(InData%ChordAngleLE,3)
        DO i2 = LBOUND(InData%ChordAngleLE,2), UBOUND(InData%ChordAngleLE,2)
          DO i1 = LBOUND(InData%ChordAngleLE,1), UBOUND(InData%ChordAngleLE,1)
            ReKiBuf(Re_Xferred) = InData%ChordAngleLE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SpanAngleLE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleLE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleLE,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleLE,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleLE,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SpanAngleLE,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SpanAngleLE,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%SpanAngleLE,3), UBOUND(InData%SpanAngleLE,3)
        DO i2 = LBOUND(InData%SpanAngleLE,2), UBOUND(InData%SpanAngleLE,2)
          DO i1 = LBOUND(InData%SpanAngleLE,1), UBOUND(InData%SpanAngleLE,1)
            ReKiBuf(Re_Xferred) = InData%SpanAngleLE(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rTEtoObserve) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rTEtoObserve,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rTEtoObserve,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rTEtoObserve,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rTEtoObserve,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rTEtoObserve,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rTEtoObserve,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rTEtoObserve,3), UBOUND(InData%rTEtoObserve,3)
        DO i2 = LBOUND(InData%rTEtoObserve,2), UBOUND(InData%rTEtoObserve,2)
          DO i1 = LBOUND(InData%rTEtoObserve,1), UBOUND(InData%rTEtoObserve,1)
            ReKiBuf(Re_Xferred) = InData%rTEtoObserve(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rLEtoObserve) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLEtoObserve,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLEtoObserve,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLEtoObserve,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLEtoObserve,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rLEtoObserve,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rLEtoObserve,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%rLEtoObserve,3), UBOUND(InData%rLEtoObserve,3)
        DO i2 = LBOUND(InData%rLEtoObserve,2), UBOUND(InData%rLEtoObserve,2)
          DO i1 = LBOUND(InData%rLEtoObserve,1), UBOUND(InData%rLEtoObserve,1)
            ReKiBuf(Re_Xferred) = InData%rLEtoObserve(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%LE_Location) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LE_Location,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LE_Location,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LE_Location,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LE_Location,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%LE_Location,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%LE_Location,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%LE_Location,3), UBOUND(InData%LE_Location,3)
        DO i2 = LBOUND(InData%LE_Location,2), UBOUND(InData%LE_Location,2)
          DO i1 = LBOUND(InData%LE_Location,1), UBOUND(InData%LE_Location,1)
            ReKiBuf(Re_Xferred) = InData%LE_Location(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%RotSpeedAoA
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%SPLLBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLLBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLLBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLLBL,1), UBOUND(InData%SPLLBL,1)
        ReKiBuf(Re_Xferred) = InData%SPLLBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLP,1), UBOUND(InData%SPLP,1)
        ReKiBuf(Re_Xferred) = InData%SPLP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLS) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLS,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLS,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLS,1), UBOUND(InData%SPLS,1)
        ReKiBuf(Re_Xferred) = InData%SPLS(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLALPH) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLALPH,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLALPH,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLALPH,1), UBOUND(InData%SPLALPH,1)
        ReKiBuf(Re_Xferred) = InData%SPLALPH(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLTBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLTBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLTBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLTBL,1), UBOUND(InData%SPLTBL,1)
        ReKiBuf(Re_Xferred) = InData%SPLTBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLTIP) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLTIP,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLTIP,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLTIP,1), UBOUND(InData%SPLTIP,1)
        ReKiBuf(Re_Xferred) = InData%SPLTIP(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLTI) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLTI,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLTI,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLTI,1), UBOUND(InData%SPLTI,1)
        ReKiBuf(Re_Xferred) = InData%SPLTI(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLTIGui) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLTIGui,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLTIGui,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLTIGui,1), UBOUND(InData%SPLTIGui,1)
        ReKiBuf(Re_Xferred) = InData%SPLTIGui(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SPLBLUNT) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SPLBLUNT,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SPLBLUNT,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%SPLBLUNT,1), UBOUND(InData%SPLBLUNT,1)
        ReKiBuf(Re_Xferred) = InData%SPLBLUNT(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CfVar) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfVar,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfVar,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%CfVar,1), UBOUND(InData%CfVar,1)
        ReKiBuf(Re_Xferred) = InData%CfVar(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%d99Var) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99Var,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99Var,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%d99Var,1), UBOUND(InData%d99Var,1)
        ReKiBuf(Re_Xferred) = InData%d99Var(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dStarVar) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarVar,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarVar,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%dStarVar,1), UBOUND(InData%dStarVar,1)
        ReKiBuf(Re_Xferred) = InData%dStarVar(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgeVelVar) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelVar,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelVar,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%EdgeVelVar,1), UBOUND(InData%EdgeVelVar,1)
        ReKiBuf(Re_Xferred) = InData%EdgeVelVar(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%speccou
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%filesopen
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE AA_PackMisc

 SUBROUTINE AA_UnPackMisc( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_MiscVarType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackMisc'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AllOuts not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AllOuts)) DEALLOCATE(OutData%AllOuts)
    ALLOCATE(OutData%AllOuts(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AllOuts.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AllOuts,1), UBOUND(OutData%AllOuts,1)
        OutData%AllOuts(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ChordAngleTE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ChordAngleTE)) DEALLOCATE(OutData%ChordAngleTE)
    ALLOCATE(OutData%ChordAngleTE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ChordAngleTE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%ChordAngleTE,3), UBOUND(OutData%ChordAngleTE,3)
        DO i2 = LBOUND(OutData%ChordAngleTE,2), UBOUND(OutData%ChordAngleTE,2)
          DO i1 = LBOUND(OutData%ChordAngleTE,1), UBOUND(OutData%ChordAngleTE,1)
            OutData%ChordAngleTE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SpanAngleTE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SpanAngleTE)) DEALLOCATE(OutData%SpanAngleTE)
    ALLOCATE(OutData%SpanAngleTE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SpanAngleTE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%SpanAngleTE,3), UBOUND(OutData%SpanAngleTE,3)
        DO i2 = LBOUND(OutData%SpanAngleTE,2), UBOUND(OutData%SpanAngleTE,2)
          DO i1 = LBOUND(OutData%SpanAngleTE,1), UBOUND(OutData%SpanAngleTE,1)
            OutData%SpanAngleTE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ChordAngleLE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ChordAngleLE)) DEALLOCATE(OutData%ChordAngleLE)
    ALLOCATE(OutData%ChordAngleLE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ChordAngleLE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%ChordAngleLE,3), UBOUND(OutData%ChordAngleLE,3)
        DO i2 = LBOUND(OutData%ChordAngleLE,2), UBOUND(OutData%ChordAngleLE,2)
          DO i1 = LBOUND(OutData%ChordAngleLE,1), UBOUND(OutData%ChordAngleLE,1)
            OutData%ChordAngleLE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SpanAngleLE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SpanAngleLE)) DEALLOCATE(OutData%SpanAngleLE)
    ALLOCATE(OutData%SpanAngleLE(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SpanAngleLE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%SpanAngleLE,3), UBOUND(OutData%SpanAngleLE,3)
        DO i2 = LBOUND(OutData%SpanAngleLE,2), UBOUND(OutData%SpanAngleLE,2)
          DO i1 = LBOUND(OutData%SpanAngleLE,1), UBOUND(OutData%SpanAngleLE,1)
            OutData%SpanAngleLE(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rTEtoObserve not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rTEtoObserve)) DEALLOCATE(OutData%rTEtoObserve)
    ALLOCATE(OutData%rTEtoObserve(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rTEtoObserve.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rTEtoObserve,3), UBOUND(OutData%rTEtoObserve,3)
        DO i2 = LBOUND(OutData%rTEtoObserve,2), UBOUND(OutData%rTEtoObserve,2)
          DO i1 = LBOUND(OutData%rTEtoObserve,1), UBOUND(OutData%rTEtoObserve,1)
            OutData%rTEtoObserve(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rLEtoObserve not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rLEtoObserve)) DEALLOCATE(OutData%rLEtoObserve)
    ALLOCATE(OutData%rLEtoObserve(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rLEtoObserve.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%rLEtoObserve,3), UBOUND(OutData%rLEtoObserve,3)
        DO i2 = LBOUND(OutData%rLEtoObserve,2), UBOUND(OutData%rLEtoObserve,2)
          DO i1 = LBOUND(OutData%rLEtoObserve,1), UBOUND(OutData%rLEtoObserve,1)
            OutData%rLEtoObserve(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! LE_Location not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%LE_Location)) DEALLOCATE(OutData%LE_Location)
    ALLOCATE(OutData%LE_Location(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%LE_Location.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%LE_Location,3), UBOUND(OutData%LE_Location,3)
        DO i2 = LBOUND(OutData%LE_Location,2), UBOUND(OutData%LE_Location,2)
          DO i1 = LBOUND(OutData%LE_Location,1), UBOUND(OutData%LE_Location,1)
            OutData%LE_Location(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
    OutData%RotSpeedAoA = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLLBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLLBL)) DEALLOCATE(OutData%SPLLBL)
    ALLOCATE(OutData%SPLLBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLLBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLLBL,1), UBOUND(OutData%SPLLBL,1)
        OutData%SPLLBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLP)) DEALLOCATE(OutData%SPLP)
    ALLOCATE(OutData%SPLP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLP,1), UBOUND(OutData%SPLP,1)
        OutData%SPLP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLS not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLS)) DEALLOCATE(OutData%SPLS)
    ALLOCATE(OutData%SPLS(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLS.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLS,1), UBOUND(OutData%SPLS,1)
        OutData%SPLS(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLALPH not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLALPH)) DEALLOCATE(OutData%SPLALPH)
    ALLOCATE(OutData%SPLALPH(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLALPH.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLALPH,1), UBOUND(OutData%SPLALPH,1)
        OutData%SPLALPH(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLTBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLTBL)) DEALLOCATE(OutData%SPLTBL)
    ALLOCATE(OutData%SPLTBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLTBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLTBL,1), UBOUND(OutData%SPLTBL,1)
        OutData%SPLTBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLTIP not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLTIP)) DEALLOCATE(OutData%SPLTIP)
    ALLOCATE(OutData%SPLTIP(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLTIP.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLTIP,1), UBOUND(OutData%SPLTIP,1)
        OutData%SPLTIP(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLTI not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLTI)) DEALLOCATE(OutData%SPLTI)
    ALLOCATE(OutData%SPLTI(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLTI.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLTI,1), UBOUND(OutData%SPLTI,1)
        OutData%SPLTI(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLTIGui not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLTIGui)) DEALLOCATE(OutData%SPLTIGui)
    ALLOCATE(OutData%SPLTIGui(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLTIGui.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLTIGui,1), UBOUND(OutData%SPLTIGui,1)
        OutData%SPLTIGui(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SPLBLUNT not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SPLBLUNT)) DEALLOCATE(OutData%SPLBLUNT)
    ALLOCATE(OutData%SPLBLUNT(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SPLBLUNT.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%SPLBLUNT,1), UBOUND(OutData%SPLBLUNT,1)
        OutData%SPLBLUNT(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CfVar not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CfVar)) DEALLOCATE(OutData%CfVar)
    ALLOCATE(OutData%CfVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CfVar.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%CfVar,1), UBOUND(OutData%CfVar,1)
        OutData%CfVar(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! d99Var not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%d99Var)) DEALLOCATE(OutData%d99Var)
    ALLOCATE(OutData%d99Var(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%d99Var.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%d99Var,1), UBOUND(OutData%d99Var,1)
        OutData%d99Var(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dStarVar not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dStarVar)) DEALLOCATE(OutData%dStarVar)
    ALLOCATE(OutData%dStarVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dStarVar.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%dStarVar,1), UBOUND(OutData%dStarVar,1)
        OutData%dStarVar(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgeVelVar not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgeVelVar)) DEALLOCATE(OutData%EdgeVelVar)
    ALLOCATE(OutData%EdgeVelVar(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgeVelVar.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%EdgeVelVar,1), UBOUND(OutData%EdgeVelVar,1)
        OutData%EdgeVelVar(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%speccou = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%filesopen = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
 END SUBROUTINE AA_UnPackMisc

 SUBROUTINE AA_CopyParam( SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_ParameterType), INTENT(IN) :: SrcParamData
   TYPE(AA_ParameterType), INTENT(INOUT) :: DstParamData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyParam'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
    DstParamData%DT = SrcParamData%DT
    DstParamData%IBLUNT = SrcParamData%IBLUNT
    DstParamData%ILAM = SrcParamData%ILAM
    DstParamData%ITIP = SrcParamData%ITIP
    DstParamData%ITRIP = SrcParamData%ITRIP
    DstParamData%ITURB = SrcParamData%ITURB
    DstParamData%IInflow = SrcParamData%IInflow
    DstParamData%X_BLMethod = SrcParamData%X_BLMethod
    DstParamData%TICalcMeth = SrcParamData%TICalcMeth
    DstParamData%ROUND = SrcParamData%ROUND
    DstParamData%ALPRAT = SrcParamData%ALPRAT
    DstParamData%NumBlades = SrcParamData%NumBlades
    DstParamData%NumBlNds = SrcParamData%NumBlNds
    DstParamData%AirDens = SrcParamData%AirDens
    DstParamData%KinVisc = SrcParamData%KinVisc
    DstParamData%SpdSound = SrcParamData%SpdSound
    DstParamData%HubHeight = SrcParamData%HubHeight
    DstParamData%toptip = SrcParamData%toptip
    DstParamData%bottip = SrcParamData%bottip
IF (ALLOCATED(SrcParamData%rotorregionlimitsVert)) THEN
  i1_l = LBOUND(SrcParamData%rotorregionlimitsVert,1)
  i1_u = UBOUND(SrcParamData%rotorregionlimitsVert,1)
  IF (.NOT. ALLOCATED(DstParamData%rotorregionlimitsVert)) THEN 
    ALLOCATE(DstParamData%rotorregionlimitsVert(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsVert.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rotorregionlimitsVert = SrcParamData%rotorregionlimitsVert
ENDIF
IF (ALLOCATED(SrcParamData%rotorregionlimitsHorz)) THEN
  i1_l = LBOUND(SrcParamData%rotorregionlimitsHorz,1)
  i1_u = UBOUND(SrcParamData%rotorregionlimitsHorz,1)
  IF (.NOT. ALLOCATED(DstParamData%rotorregionlimitsHorz)) THEN 
    ALLOCATE(DstParamData%rotorregionlimitsHorz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsHorz.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rotorregionlimitsHorz = SrcParamData%rotorregionlimitsHorz
ENDIF
IF (ALLOCATED(SrcParamData%rotorregionlimitsalph)) THEN
  i1_l = LBOUND(SrcParamData%rotorregionlimitsalph,1)
  i1_u = UBOUND(SrcParamData%rotorregionlimitsalph,1)
  IF (.NOT. ALLOCATED(DstParamData%rotorregionlimitsalph)) THEN 
    ALLOCATE(DstParamData%rotorregionlimitsalph(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsalph.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rotorregionlimitsalph = SrcParamData%rotorregionlimitsalph
ENDIF
IF (ALLOCATED(SrcParamData%rotorregionlimitsrad)) THEN
  i1_l = LBOUND(SrcParamData%rotorregionlimitsrad,1)
  i1_u = UBOUND(SrcParamData%rotorregionlimitsrad,1)
  IF (.NOT. ALLOCATED(DstParamData%rotorregionlimitsrad)) THEN 
    ALLOCATE(DstParamData%rotorregionlimitsrad(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsrad.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%rotorregionlimitsrad = SrcParamData%rotorregionlimitsrad
ENDIF
    DstParamData%NrObsLoc = SrcParamData%NrObsLoc
    DstParamData%aweightflag = SrcParamData%aweightflag
    DstParamData%TxtFileOutput = SrcParamData%TxtFileOutput
    DstParamData%AAStart = SrcParamData%AAStart
IF (ALLOCATED(SrcParamData%ObsX)) THEN
  i1_l = LBOUND(SrcParamData%ObsX,1)
  i1_u = UBOUND(SrcParamData%ObsX,1)
  IF (.NOT. ALLOCATED(DstParamData%ObsX)) THEN 
    ALLOCATE(DstParamData%ObsX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsX.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ObsX = SrcParamData%ObsX
ENDIF
IF (ALLOCATED(SrcParamData%ObsY)) THEN
  i1_l = LBOUND(SrcParamData%ObsY,1)
  i1_u = UBOUND(SrcParamData%ObsY,1)
  IF (.NOT. ALLOCATED(DstParamData%ObsY)) THEN 
    ALLOCATE(DstParamData%ObsY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsY.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ObsY = SrcParamData%ObsY
ENDIF
IF (ALLOCATED(SrcParamData%ObsZ)) THEN
  i1_l = LBOUND(SrcParamData%ObsZ,1)
  i1_u = UBOUND(SrcParamData%ObsZ,1)
  IF (.NOT. ALLOCATED(DstParamData%ObsZ)) THEN 
    ALLOCATE(DstParamData%ObsZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsZ.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ObsZ = SrcParamData%ObsZ
ENDIF
IF (ALLOCATED(SrcParamData%FreqList)) THEN
  i1_l = LBOUND(SrcParamData%FreqList,1)
  i1_u = UBOUND(SrcParamData%FreqList,1)
  IF (.NOT. ALLOCATED(DstParamData%FreqList)) THEN 
    ALLOCATE(DstParamData%FreqList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqList.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%FreqList = SrcParamData%FreqList
ENDIF
IF (ALLOCATED(SrcParamData%Aweight)) THEN
  i1_l = LBOUND(SrcParamData%Aweight,1)
  i1_u = UBOUND(SrcParamData%Aweight,1)
  IF (.NOT. ALLOCATED(DstParamData%Aweight)) THEN 
    ALLOCATE(DstParamData%Aweight(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Aweight.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%Aweight = SrcParamData%Aweight
ENDIF
    DstParamData%Fsample = SrcParamData%Fsample
    DstParamData%total_sample = SrcParamData%total_sample
    DstParamData%total_sampleTI = SrcParamData%total_sampleTI
    DstParamData%AA_Bl_Prcntge = SrcParamData%AA_Bl_Prcntge
    DstParamData%startnode = SrcParamData%startnode
    DstParamData%Lturb = SrcParamData%Lturb
    DstParamData%AvgV = SrcParamData%AvgV
    DstParamData%dz_turb_in = SrcParamData%dz_turb_in
    DstParamData%dy_turb_in = SrcParamData%dy_turb_in
IF (ALLOCATED(SrcParamData%TI_Grid_In)) THEN
  i1_l = LBOUND(SrcParamData%TI_Grid_In,1)
  i1_u = UBOUND(SrcParamData%TI_Grid_In,1)
  i2_l = LBOUND(SrcParamData%TI_Grid_In,2)
  i2_u = UBOUND(SrcParamData%TI_Grid_In,2)
  IF (.NOT. ALLOCATED(DstParamData%TI_Grid_In)) THEN 
    ALLOCATE(DstParamData%TI_Grid_In(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TI_Grid_In.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TI_Grid_In = SrcParamData%TI_Grid_In
ENDIF
    DstParamData%FTitle = SrcParamData%FTitle
    DstParamData%outFmt = SrcParamData%outFmt
    DstParamData%NrOutFile = SrcParamData%NrOutFile
    DstParamData%delim = SrcParamData%delim
    DstParamData%NumOuts = SrcParamData%NumOuts
    DstParamData%NumOutsForPE = SrcParamData%NumOutsForPE
    DstParamData%NumOutsForSep = SrcParamData%NumOutsForSep
    DstParamData%NumOutsForNodes = SrcParamData%NumOutsForNodes
    DstParamData%unOutFile = SrcParamData%unOutFile
    DstParamData%unOutFile2 = SrcParamData%unOutFile2
    DstParamData%unOutFile3 = SrcParamData%unOutFile3
    DstParamData%unOutFile4 = SrcParamData%unOutFile4
    DstParamData%RootName = SrcParamData%RootName
IF (ALLOCATED(SrcParamData%OutParam)) THEN
  i1_l = LBOUND(SrcParamData%OutParam,1)
  i1_u = UBOUND(SrcParamData%OutParam,1)
  IF (.NOT. ALLOCATED(DstParamData%OutParam)) THEN 
    ALLOCATE(DstParamData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%OutParam,1), UBOUND(SrcParamData%OutParam,1)
      CALL NWTC_Library_Copyoutparmtype( SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcParamData%StallStart)) THEN
  i1_l = LBOUND(SrcParamData%StallStart,1)
  i1_u = UBOUND(SrcParamData%StallStart,1)
  i2_l = LBOUND(SrcParamData%StallStart,2)
  i2_u = UBOUND(SrcParamData%StallStart,2)
  IF (.NOT. ALLOCATED(DstParamData%StallStart)) THEN 
    ALLOCATE(DstParamData%StallStart(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StallStart.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%StallStart = SrcParamData%StallStart
ENDIF
IF (ALLOCATED(SrcParamData%TEThick)) THEN
  i1_l = LBOUND(SrcParamData%TEThick,1)
  i1_u = UBOUND(SrcParamData%TEThick,1)
  i2_l = LBOUND(SrcParamData%TEThick,2)
  i2_u = UBOUND(SrcParamData%TEThick,2)
  IF (.NOT. ALLOCATED(DstParamData%TEThick)) THEN 
    ALLOCATE(DstParamData%TEThick(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TEThick.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TEThick = SrcParamData%TEThick
ENDIF
IF (ALLOCATED(SrcParamData%TEAngle)) THEN
  i1_l = LBOUND(SrcParamData%TEAngle,1)
  i1_u = UBOUND(SrcParamData%TEAngle,1)
  i2_l = LBOUND(SrcParamData%TEAngle,2)
  i2_u = UBOUND(SrcParamData%TEAngle,2)
  IF (.NOT. ALLOCATED(DstParamData%TEAngle)) THEN 
    ALLOCATE(DstParamData%TEAngle(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TEAngle.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%TEAngle = SrcParamData%TEAngle
ENDIF
IF (ALLOCATED(SrcParamData%AerCent)) THEN
  i1_l = LBOUND(SrcParamData%AerCent,1)
  i1_u = UBOUND(SrcParamData%AerCent,1)
  i2_l = LBOUND(SrcParamData%AerCent,2)
  i2_u = UBOUND(SrcParamData%AerCent,2)
  i3_l = LBOUND(SrcParamData%AerCent,3)
  i3_u = UBOUND(SrcParamData%AerCent,3)
  IF (.NOT. ALLOCATED(DstParamData%AerCent)) THEN 
    ALLOCATE(DstParamData%AerCent(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AerCent.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AerCent = SrcParamData%AerCent
ENDIF
IF (ALLOCATED(SrcParamData%BlAFID)) THEN
  i1_l = LBOUND(SrcParamData%BlAFID,1)
  i1_u = UBOUND(SrcParamData%BlAFID,1)
  i2_l = LBOUND(SrcParamData%BlAFID,2)
  i2_u = UBOUND(SrcParamData%BlAFID,2)
  IF (.NOT. ALLOCATED(DstParamData%BlAFID)) THEN 
    ALLOCATE(DstParamData%BlAFID(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlAFID.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BlAFID = SrcParamData%BlAFID
ENDIF
IF (ALLOCATED(SrcParamData%AFInfo)) THEN
  i1_l = LBOUND(SrcParamData%AFInfo,1)
  i1_u = UBOUND(SrcParamData%AFInfo,1)
  IF (.NOT. ALLOCATED(DstParamData%AFInfo)) THEN 
    ALLOCATE(DstParamData%AFInfo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFInfo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DO i1 = LBOUND(SrcParamData%AFInfo,1), UBOUND(SrcParamData%AFInfo,1)
      CALL AFI_CopyParam( SrcParamData%AFInfo(i1), DstParamData%AFInfo(i1), CtrlCode, ErrStat2, ErrMsg2 )
         CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
         IF (ErrStat>=AbortErrLev) RETURN
    ENDDO
ENDIF
IF (ALLOCATED(SrcParamData%AFLECo)) THEN
  i1_l = LBOUND(SrcParamData%AFLECo,1)
  i1_u = UBOUND(SrcParamData%AFLECo,1)
  i2_l = LBOUND(SrcParamData%AFLECo,2)
  i2_u = UBOUND(SrcParamData%AFLECo,2)
  i3_l = LBOUND(SrcParamData%AFLECo,3)
  i3_u = UBOUND(SrcParamData%AFLECo,3)
  IF (.NOT. ALLOCATED(DstParamData%AFLECo)) THEN 
    ALLOCATE(DstParamData%AFLECo(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFLECo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AFLECo = SrcParamData%AFLECo
ENDIF
IF (ALLOCATED(SrcParamData%AFTECo)) THEN
  i1_l = LBOUND(SrcParamData%AFTECo,1)
  i1_u = UBOUND(SrcParamData%AFTECo,1)
  i2_l = LBOUND(SrcParamData%AFTECo,2)
  i2_u = UBOUND(SrcParamData%AFTECo,2)
  i3_l = LBOUND(SrcParamData%AFTECo,3)
  i3_u = UBOUND(SrcParamData%AFTECo,3)
  IF (.NOT. ALLOCATED(DstParamData%AFTECo)) THEN 
    ALLOCATE(DstParamData%AFTECo(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFTECo.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AFTECo = SrcParamData%AFTECo
ENDIF
IF (ALLOCATED(SrcParamData%BlSpn)) THEN
  i1_l = LBOUND(SrcParamData%BlSpn,1)
  i1_u = UBOUND(SrcParamData%BlSpn,1)
  i2_l = LBOUND(SrcParamData%BlSpn,2)
  i2_u = UBOUND(SrcParamData%BlSpn,2)
  IF (.NOT. ALLOCATED(DstParamData%BlSpn)) THEN 
    ALLOCATE(DstParamData%BlSpn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlSpn.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BlSpn = SrcParamData%BlSpn
ENDIF
IF (ALLOCATED(SrcParamData%BlChord)) THEN
  i1_l = LBOUND(SrcParamData%BlChord,1)
  i1_u = UBOUND(SrcParamData%BlChord,1)
  i2_l = LBOUND(SrcParamData%BlChord,2)
  i2_u = UBOUND(SrcParamData%BlChord,2)
  IF (.NOT. ALLOCATED(DstParamData%BlChord)) THEN 
    ALLOCATE(DstParamData%BlChord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlChord.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%BlChord = SrcParamData%BlChord
ENDIF
IF (ALLOCATED(SrcParamData%ReListBL)) THEN
  i1_l = LBOUND(SrcParamData%ReListBL,1)
  i1_u = UBOUND(SrcParamData%ReListBL,1)
  IF (.NOT. ALLOCATED(DstParamData%ReListBL)) THEN 
    ALLOCATE(DstParamData%ReListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ReListBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%ReListBL = SrcParamData%ReListBL
ENDIF
IF (ALLOCATED(SrcParamData%AOAListBL)) THEN
  i1_l = LBOUND(SrcParamData%AOAListBL,1)
  i1_u = UBOUND(SrcParamData%AOAListBL,1)
  IF (.NOT. ALLOCATED(DstParamData%AOAListBL)) THEN 
    ALLOCATE(DstParamData%AOAListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AOAListBL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AOAListBL = SrcParamData%AOAListBL
ENDIF
IF (ALLOCATED(SrcParamData%dStarAll1)) THEN
  i1_l = LBOUND(SrcParamData%dStarAll1,1)
  i1_u = UBOUND(SrcParamData%dStarAll1,1)
  i2_l = LBOUND(SrcParamData%dStarAll1,2)
  i2_u = UBOUND(SrcParamData%dStarAll1,2)
  i3_l = LBOUND(SrcParamData%dStarAll1,3)
  i3_u = UBOUND(SrcParamData%dStarAll1,3)
  IF (.NOT. ALLOCATED(DstParamData%dStarAll1)) THEN 
    ALLOCATE(DstParamData%dStarAll1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dStarAll1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dStarAll1 = SrcParamData%dStarAll1
ENDIF
IF (ALLOCATED(SrcParamData%dStarAll2)) THEN
  i1_l = LBOUND(SrcParamData%dStarAll2,1)
  i1_u = UBOUND(SrcParamData%dStarAll2,1)
  i2_l = LBOUND(SrcParamData%dStarAll2,2)
  i2_u = UBOUND(SrcParamData%dStarAll2,2)
  i3_l = LBOUND(SrcParamData%dStarAll2,3)
  i3_u = UBOUND(SrcParamData%dStarAll2,3)
  IF (.NOT. ALLOCATED(DstParamData%dStarAll2)) THEN 
    ALLOCATE(DstParamData%dStarAll2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dStarAll2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%dStarAll2 = SrcParamData%dStarAll2
ENDIF
IF (ALLOCATED(SrcParamData%d99All1)) THEN
  i1_l = LBOUND(SrcParamData%d99All1,1)
  i1_u = UBOUND(SrcParamData%d99All1,1)
  i2_l = LBOUND(SrcParamData%d99All1,2)
  i2_u = UBOUND(SrcParamData%d99All1,2)
  i3_l = LBOUND(SrcParamData%d99All1,3)
  i3_u = UBOUND(SrcParamData%d99All1,3)
  IF (.NOT. ALLOCATED(DstParamData%d99All1)) THEN 
    ALLOCATE(DstParamData%d99All1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%d99All1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%d99All1 = SrcParamData%d99All1
ENDIF
IF (ALLOCATED(SrcParamData%d99All2)) THEN
  i1_l = LBOUND(SrcParamData%d99All2,1)
  i1_u = UBOUND(SrcParamData%d99All2,1)
  i2_l = LBOUND(SrcParamData%d99All2,2)
  i2_u = UBOUND(SrcParamData%d99All2,2)
  i3_l = LBOUND(SrcParamData%d99All2,3)
  i3_u = UBOUND(SrcParamData%d99All2,3)
  IF (.NOT. ALLOCATED(DstParamData%d99All2)) THEN 
    ALLOCATE(DstParamData%d99All2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%d99All2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%d99All2 = SrcParamData%d99All2
ENDIF
IF (ALLOCATED(SrcParamData%CfAll1)) THEN
  i1_l = LBOUND(SrcParamData%CfAll1,1)
  i1_u = UBOUND(SrcParamData%CfAll1,1)
  i2_l = LBOUND(SrcParamData%CfAll1,2)
  i2_u = UBOUND(SrcParamData%CfAll1,2)
  i3_l = LBOUND(SrcParamData%CfAll1,3)
  i3_u = UBOUND(SrcParamData%CfAll1,3)
  IF (.NOT. ALLOCATED(DstParamData%CfAll1)) THEN 
    ALLOCATE(DstParamData%CfAll1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CfAll1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CfAll1 = SrcParamData%CfAll1
ENDIF
IF (ALLOCATED(SrcParamData%CfAll2)) THEN
  i1_l = LBOUND(SrcParamData%CfAll2,1)
  i1_u = UBOUND(SrcParamData%CfAll2,1)
  i2_l = LBOUND(SrcParamData%CfAll2,2)
  i2_u = UBOUND(SrcParamData%CfAll2,2)
  i3_l = LBOUND(SrcParamData%CfAll2,3)
  i3_u = UBOUND(SrcParamData%CfAll2,3)
  IF (.NOT. ALLOCATED(DstParamData%CfAll2)) THEN 
    ALLOCATE(DstParamData%CfAll2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CfAll2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%CfAll2 = SrcParamData%CfAll2
ENDIF
IF (ALLOCATED(SrcParamData%EdgeVelRat1)) THEN
  i1_l = LBOUND(SrcParamData%EdgeVelRat1,1)
  i1_u = UBOUND(SrcParamData%EdgeVelRat1,1)
  i2_l = LBOUND(SrcParamData%EdgeVelRat1,2)
  i2_u = UBOUND(SrcParamData%EdgeVelRat1,2)
  i3_l = LBOUND(SrcParamData%EdgeVelRat1,3)
  i3_u = UBOUND(SrcParamData%EdgeVelRat1,3)
  IF (.NOT. ALLOCATED(DstParamData%EdgeVelRat1)) THEN 
    ALLOCATE(DstParamData%EdgeVelRat1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EdgeVelRat1.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%EdgeVelRat1 = SrcParamData%EdgeVelRat1
ENDIF
IF (ALLOCATED(SrcParamData%EdgeVelRat2)) THEN
  i1_l = LBOUND(SrcParamData%EdgeVelRat2,1)
  i1_u = UBOUND(SrcParamData%EdgeVelRat2,1)
  i2_l = LBOUND(SrcParamData%EdgeVelRat2,2)
  i2_u = UBOUND(SrcParamData%EdgeVelRat2,2)
  i3_l = LBOUND(SrcParamData%EdgeVelRat2,3)
  i3_u = UBOUND(SrcParamData%EdgeVelRat2,3)
  IF (.NOT. ALLOCATED(DstParamData%EdgeVelRat2)) THEN 
    ALLOCATE(DstParamData%EdgeVelRat2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EdgeVelRat2.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%EdgeVelRat2 = SrcParamData%EdgeVelRat2
ENDIF
IF (ALLOCATED(SrcParamData%AFThickGuida)) THEN
  i1_l = LBOUND(SrcParamData%AFThickGuida,1)
  i1_u = UBOUND(SrcParamData%AFThickGuida,1)
  i2_l = LBOUND(SrcParamData%AFThickGuida,2)
  i2_u = UBOUND(SrcParamData%AFThickGuida,2)
  IF (.NOT. ALLOCATED(DstParamData%AFThickGuida)) THEN 
    ALLOCATE(DstParamData%AFThickGuida(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFThickGuida.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstParamData%AFThickGuida = SrcParamData%AFThickGuida
ENDIF
 END SUBROUTINE AA_CopyParam

 SUBROUTINE AA_DestroyParam( ParamData, ErrStat, ErrMsg )
  TYPE(AA_ParameterType), INTENT(INOUT) :: ParamData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyParam'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(ParamData%rotorregionlimitsVert)) THEN
  DEALLOCATE(ParamData%rotorregionlimitsVert)
ENDIF
IF (ALLOCATED(ParamData%rotorregionlimitsHorz)) THEN
  DEALLOCATE(ParamData%rotorregionlimitsHorz)
ENDIF
IF (ALLOCATED(ParamData%rotorregionlimitsalph)) THEN
  DEALLOCATE(ParamData%rotorregionlimitsalph)
ENDIF
IF (ALLOCATED(ParamData%rotorregionlimitsrad)) THEN
  DEALLOCATE(ParamData%rotorregionlimitsrad)
ENDIF
IF (ALLOCATED(ParamData%ObsX)) THEN
  DEALLOCATE(ParamData%ObsX)
ENDIF
IF (ALLOCATED(ParamData%ObsY)) THEN
  DEALLOCATE(ParamData%ObsY)
ENDIF
IF (ALLOCATED(ParamData%ObsZ)) THEN
  DEALLOCATE(ParamData%ObsZ)
ENDIF
IF (ALLOCATED(ParamData%FreqList)) THEN
  DEALLOCATE(ParamData%FreqList)
ENDIF
IF (ALLOCATED(ParamData%Aweight)) THEN
  DEALLOCATE(ParamData%Aweight)
ENDIF
IF (ALLOCATED(ParamData%TI_Grid_In)) THEN
  DEALLOCATE(ParamData%TI_Grid_In)
ENDIF
IF (ALLOCATED(ParamData%OutParam)) THEN
DO i1 = LBOUND(ParamData%OutParam,1), UBOUND(ParamData%OutParam,1)
  CALL NWTC_Library_Destroyoutparmtype( ParamData%OutParam(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%OutParam)
ENDIF
IF (ALLOCATED(ParamData%StallStart)) THEN
  DEALLOCATE(ParamData%StallStart)
ENDIF
IF (ALLOCATED(ParamData%TEThick)) THEN
  DEALLOCATE(ParamData%TEThick)
ENDIF
IF (ALLOCATED(ParamData%TEAngle)) THEN
  DEALLOCATE(ParamData%TEAngle)
ENDIF
IF (ALLOCATED(ParamData%AerCent)) THEN
  DEALLOCATE(ParamData%AerCent)
ENDIF
IF (ALLOCATED(ParamData%BlAFID)) THEN
  DEALLOCATE(ParamData%BlAFID)
ENDIF
IF (ALLOCATED(ParamData%AFInfo)) THEN
DO i1 = LBOUND(ParamData%AFInfo,1), UBOUND(ParamData%AFInfo,1)
  CALL AFI_DestroyParam( ParamData%AFInfo(i1), ErrStat, ErrMsg )
ENDDO
  DEALLOCATE(ParamData%AFInfo)
ENDIF
IF (ALLOCATED(ParamData%AFLECo)) THEN
  DEALLOCATE(ParamData%AFLECo)
ENDIF
IF (ALLOCATED(ParamData%AFTECo)) THEN
  DEALLOCATE(ParamData%AFTECo)
ENDIF
IF (ALLOCATED(ParamData%BlSpn)) THEN
  DEALLOCATE(ParamData%BlSpn)
ENDIF
IF (ALLOCATED(ParamData%BlChord)) THEN
  DEALLOCATE(ParamData%BlChord)
ENDIF
IF (ALLOCATED(ParamData%ReListBL)) THEN
  DEALLOCATE(ParamData%ReListBL)
ENDIF
IF (ALLOCATED(ParamData%AOAListBL)) THEN
  DEALLOCATE(ParamData%AOAListBL)
ENDIF
IF (ALLOCATED(ParamData%dStarAll1)) THEN
  DEALLOCATE(ParamData%dStarAll1)
ENDIF
IF (ALLOCATED(ParamData%dStarAll2)) THEN
  DEALLOCATE(ParamData%dStarAll2)
ENDIF
IF (ALLOCATED(ParamData%d99All1)) THEN
  DEALLOCATE(ParamData%d99All1)
ENDIF
IF (ALLOCATED(ParamData%d99All2)) THEN
  DEALLOCATE(ParamData%d99All2)
ENDIF
IF (ALLOCATED(ParamData%CfAll1)) THEN
  DEALLOCATE(ParamData%CfAll1)
ENDIF
IF (ALLOCATED(ParamData%CfAll2)) THEN
  DEALLOCATE(ParamData%CfAll2)
ENDIF
IF (ALLOCATED(ParamData%EdgeVelRat1)) THEN
  DEALLOCATE(ParamData%EdgeVelRat1)
ENDIF
IF (ALLOCATED(ParamData%EdgeVelRat2)) THEN
  DEALLOCATE(ParamData%EdgeVelRat2)
ENDIF
IF (ALLOCATED(ParamData%AFThickGuida)) THEN
  DEALLOCATE(ParamData%AFThickGuida)
ENDIF
 END SUBROUTINE AA_DestroyParam

 SUBROUTINE AA_PackParam( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_ParameterType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackParam'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
      Db_BufSz   = Db_BufSz   + 1  ! DT
      Int_BufSz  = Int_BufSz  + 1  ! IBLUNT
      Int_BufSz  = Int_BufSz  + 1  ! ILAM
      Int_BufSz  = Int_BufSz  + 1  ! ITIP
      Int_BufSz  = Int_BufSz  + 1  ! ITRIP
      Int_BufSz  = Int_BufSz  + 1  ! ITURB
      Int_BufSz  = Int_BufSz  + 1  ! IInflow
      Int_BufSz  = Int_BufSz  + 1  ! X_BLMethod
      Int_BufSz  = Int_BufSz  + 1  ! TICalcMeth
      Int_BufSz  = Int_BufSz  + 1  ! ROUND
      Re_BufSz   = Re_BufSz   + 1  ! ALPRAT
      Int_BufSz  = Int_BufSz  + 1  ! NumBlades
      Int_BufSz  = Int_BufSz  + 1  ! NumBlNds
      Re_BufSz   = Re_BufSz   + 1  ! AirDens
      Re_BufSz   = Re_BufSz   + 1  ! KinVisc
      Re_BufSz   = Re_BufSz   + 1  ! SpdSound
      Re_BufSz   = Re_BufSz   + 1  ! HubHeight
      Re_BufSz   = Re_BufSz   + 1  ! toptip
      Re_BufSz   = Re_BufSz   + 1  ! bottip
  Int_BufSz   = Int_BufSz   + 1     ! rotorregionlimitsVert allocated yes/no
  IF ( ALLOCATED(InData%rotorregionlimitsVert) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rotorregionlimitsVert upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rotorregionlimitsVert)  ! rotorregionlimitsVert
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rotorregionlimitsHorz allocated yes/no
  IF ( ALLOCATED(InData%rotorregionlimitsHorz) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rotorregionlimitsHorz upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rotorregionlimitsHorz)  ! rotorregionlimitsHorz
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rotorregionlimitsalph allocated yes/no
  IF ( ALLOCATED(InData%rotorregionlimitsalph) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rotorregionlimitsalph upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rotorregionlimitsalph)  ! rotorregionlimitsalph
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! rotorregionlimitsrad allocated yes/no
  IF ( ALLOCATED(InData%rotorregionlimitsrad) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! rotorregionlimitsrad upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%rotorregionlimitsrad)  ! rotorregionlimitsrad
  END IF
      Int_BufSz  = Int_BufSz  + 1  ! NrObsLoc
      Int_BufSz  = Int_BufSz  + 1  ! aweightflag
      Int_BufSz  = Int_BufSz  + 1  ! TxtFileOutput
      Db_BufSz   = Db_BufSz   + 1  ! AAStart
  Int_BufSz   = Int_BufSz   + 1     ! ObsX allocated yes/no
  IF ( ALLOCATED(InData%ObsX) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsX upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsX)  ! ObsX
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ObsY allocated yes/no
  IF ( ALLOCATED(InData%ObsY) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsY upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsY)  ! ObsY
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ObsZ allocated yes/no
  IF ( ALLOCATED(InData%ObsZ) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ObsZ upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ObsZ)  ! ObsZ
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! FreqList allocated yes/no
  IF ( ALLOCATED(InData%FreqList) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! FreqList upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%FreqList)  ! FreqList
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Aweight allocated yes/no
  IF ( ALLOCATED(InData%Aweight) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! Aweight upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Aweight)  ! Aweight
  END IF
      Re_BufSz   = Re_BufSz   + 1  ! Fsample
      Int_BufSz  = Int_BufSz  + 1  ! total_sample
      Int_BufSz  = Int_BufSz  + 1  ! total_sampleTI
      Int_BufSz  = Int_BufSz  + 1  ! AA_Bl_Prcntge
      Int_BufSz  = Int_BufSz  + 1  ! startnode
      Re_BufSz   = Re_BufSz   + 1  ! Lturb
      Re_BufSz   = Re_BufSz   + 1  ! AvgV
      Re_BufSz   = Re_BufSz   + 1  ! dz_turb_in
      Re_BufSz   = Re_BufSz   + 1  ! dy_turb_in
  Int_BufSz   = Int_BufSz   + 1     ! TI_Grid_In allocated yes/no
  IF ( ALLOCATED(InData%TI_Grid_In) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TI_Grid_In upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TI_Grid_In)  ! TI_Grid_In
  END IF
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%FTitle)  ! FTitle
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%outFmt)  ! outFmt
      Int_BufSz  = Int_BufSz  + 1  ! NrOutFile
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%delim)  ! delim
      Int_BufSz  = Int_BufSz  + 1  ! NumOuts
      Int_BufSz  = Int_BufSz  + 1  ! NumOutsForPE
      Int_BufSz  = Int_BufSz  + 1  ! NumOutsForSep
      Int_BufSz  = Int_BufSz  + 1  ! NumOutsForNodes
      Int_BufSz  = Int_BufSz  + 1  ! unOutFile
      Int_BufSz  = Int_BufSz  + 1  ! unOutFile2
      Int_BufSz  = Int_BufSz  + 1  ! unOutFile3
      Int_BufSz  = Int_BufSz  + 1  ! unOutFile4
      Int_BufSz  = Int_BufSz  + 1*LEN(InData%RootName)  ! RootName
  Int_BufSz   = Int_BufSz   + 1     ! OutParam allocated yes/no
  IF ( ALLOCATED(InData%OutParam) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! OutParam upper/lower bounds for each dimension
   ! Allocate buffers for subtypes, if any (we'll get sizes from these) 
    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      Int_BufSz   = Int_BufSz + 3  ! OutParam: size of buffers for each call to pack subtype
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, .TRUE. ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! OutParam
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! OutParam
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! OutParam
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! StallStart allocated yes/no
  IF ( ALLOCATED(InData%StallStart) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! StallStart upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%StallStart)  ! StallStart
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TEThick allocated yes/no
  IF ( ALLOCATED(InData%TEThick) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TEThick upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TEThick)  ! TEThick
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! TEAngle allocated yes/no
  IF ( ALLOCATED(InData%TEAngle) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! TEAngle upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%TEAngle)  ! TEAngle
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AerCent allocated yes/no
  IF ( ALLOCATED(InData%AerCent) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AerCent upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AerCent)  ! AerCent
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BlAFID allocated yes/no
  IF ( ALLOCATED(InData%BlAFID) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlAFID upper/lower bounds for each dimension
      Int_BufSz  = Int_BufSz  + SIZE(InData%BlAFID)  ! BlAFID
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AFInfo allocated yes/no
  IF ( ALLOCATED(InData%AFInfo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AFInfo upper/lower bounds for each dimension
    DO i1 = LBOUND(InData%AFInfo,1), UBOUND(InData%AFInfo,1)
      Int_BufSz   = Int_BufSz + 3  ! AFInfo: size of buffers for each call to pack subtype
      CALL AFI_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%AFInfo(i1), ErrStat2, ErrMsg2, .TRUE. ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN ! AFInfo
         Re_BufSz  = Re_BufSz  + SIZE( Re_Buf  )
         DEALLOCATE(Re_Buf)
      END IF
      IF(ALLOCATED(Db_Buf)) THEN ! AFInfo
         Db_BufSz  = Db_BufSz  + SIZE( Db_Buf  )
         DEALLOCATE(Db_Buf)
      END IF
      IF(ALLOCATED(Int_Buf)) THEN ! AFInfo
         Int_BufSz = Int_BufSz + SIZE( Int_Buf )
         DEALLOCATE(Int_Buf)
      END IF
    END DO
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AFLECo allocated yes/no
  IF ( ALLOCATED(InData%AFLECo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AFLECo upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AFLECo)  ! AFLECo
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AFTECo allocated yes/no
  IF ( ALLOCATED(InData%AFTECo) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AFTECo upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AFTECo)  ! AFTECo
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BlSpn allocated yes/no
  IF ( ALLOCATED(InData%BlSpn) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlSpn upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlSpn)  ! BlSpn
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! BlChord allocated yes/no
  IF ( ALLOCATED(InData%BlChord) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! BlChord upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%BlChord)  ! BlChord
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! ReListBL allocated yes/no
  IF ( ALLOCATED(InData%ReListBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! ReListBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%ReListBL)  ! ReListBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AOAListBL allocated yes/no
  IF ( ALLOCATED(InData%AOAListBL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! AOAListBL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AOAListBL)  ! AOAListBL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dStarAll1 allocated yes/no
  IF ( ALLOCATED(InData%dStarAll1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! dStarAll1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dStarAll1)  ! dStarAll1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! dStarAll2 allocated yes/no
  IF ( ALLOCATED(InData%dStarAll2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! dStarAll2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%dStarAll2)  ! dStarAll2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! d99All1 allocated yes/no
  IF ( ALLOCATED(InData%d99All1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! d99All1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%d99All1)  ! d99All1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! d99All2 allocated yes/no
  IF ( ALLOCATED(InData%d99All2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! d99All2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%d99All2)  ! d99All2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CfAll1 allocated yes/no
  IF ( ALLOCATED(InData%CfAll1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! CfAll1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CfAll1)  ! CfAll1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! CfAll2 allocated yes/no
  IF ( ALLOCATED(InData%CfAll2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! CfAll2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%CfAll2)  ! CfAll2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgeVelRat1 allocated yes/no
  IF ( ALLOCATED(InData%EdgeVelRat1) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! EdgeVelRat1 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgeVelRat1)  ! EdgeVelRat1
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! EdgeVelRat2 allocated yes/no
  IF ( ALLOCATED(InData%EdgeVelRat2) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! EdgeVelRat2 upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%EdgeVelRat2)  ! EdgeVelRat2
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AFThickGuida allocated yes/no
  IF ( ALLOCATED(InData%AFThickGuida) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AFThickGuida upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AFThickGuida)  ! AFThickGuida
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

    DbKiBuf(Db_Xferred) = InData%DT
    Db_Xferred = Db_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IBLUNT
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ILAM
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITIP
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITRIP
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%ITURB
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%IInflow
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%X_BLMethod
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%TICalcMeth
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%ROUND, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%ALPRAT
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBlades
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumBlNds
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AirDens
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%KinVisc
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%SpdSound
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%HubHeight
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%toptip
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%bottip
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%rotorregionlimitsVert) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rotorregionlimitsVert,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rotorregionlimitsVert,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rotorregionlimitsVert,1), UBOUND(InData%rotorregionlimitsVert,1)
        ReKiBuf(Re_Xferred) = InData%rotorregionlimitsVert(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rotorregionlimitsHorz) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rotorregionlimitsHorz,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rotorregionlimitsHorz,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rotorregionlimitsHorz,1), UBOUND(InData%rotorregionlimitsHorz,1)
        ReKiBuf(Re_Xferred) = InData%rotorregionlimitsHorz(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rotorregionlimitsalph) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rotorregionlimitsalph,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rotorregionlimitsalph,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rotorregionlimitsalph,1), UBOUND(InData%rotorregionlimitsalph,1)
        ReKiBuf(Re_Xferred) = InData%rotorregionlimitsalph(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%rotorregionlimitsrad) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%rotorregionlimitsrad,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%rotorregionlimitsrad,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%rotorregionlimitsrad,1), UBOUND(InData%rotorregionlimitsrad,1)
        ReKiBuf(Re_Xferred) = InData%rotorregionlimitsrad(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    IntKiBuf(Int_Xferred) = InData%NrObsLoc
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%aweightflag, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = TRANSFER(InData%TxtFileOutput, IntKiBuf(1))
    Int_Xferred = Int_Xferred + 1
    DbKiBuf(Db_Xferred) = InData%AAStart
    Db_Xferred = Db_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%ObsX) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsX,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsX,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsX,1), UBOUND(InData%ObsX,1)
        ReKiBuf(Re_Xferred) = InData%ObsX(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ObsY) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsY,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsY,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsY,1), UBOUND(InData%ObsY,1)
        ReKiBuf(Re_Xferred) = InData%ObsY(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ObsZ) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ObsZ,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ObsZ,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ObsZ,1), UBOUND(InData%ObsZ,1)
        ReKiBuf(Re_Xferred) = InData%ObsZ(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%FreqList) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%FreqList,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%FreqList,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%FreqList,1), UBOUND(InData%FreqList,1)
        ReKiBuf(Re_Xferred) = InData%FreqList(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Aweight) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Aweight,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Aweight,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%Aweight,1), UBOUND(InData%Aweight,1)
        ReKiBuf(Re_Xferred) = InData%Aweight(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    ReKiBuf(Re_Xferred) = InData%Fsample
    Re_Xferred = Re_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%total_sample
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%total_sampleTI
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%AA_Bl_Prcntge
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%startnode
    Int_Xferred = Int_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%Lturb
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%AvgV
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dz_turb_in
    Re_Xferred = Re_Xferred + 1
    ReKiBuf(Re_Xferred) = InData%dy_turb_in
    Re_Xferred = Re_Xferred + 1
  IF ( .NOT. ALLOCATED(InData%TI_Grid_In) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_Grid_In,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_Grid_In,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TI_Grid_In,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TI_Grid_In,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TI_Grid_In,2), UBOUND(InData%TI_Grid_In,2)
        DO i1 = LBOUND(InData%TI_Grid_In,1), UBOUND(InData%TI_Grid_In,1)
          ReKiBuf(Re_Xferred) = InData%TI_Grid_In(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO I = 1, LEN(InData%FTitle)
      IntKiBuf(Int_Xferred) = ICHAR(InData%FTitle(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(InData%outFmt)
      IntKiBuf(Int_Xferred) = ICHAR(InData%outFmt(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NrOutFile
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%delim)
      IntKiBuf(Int_Xferred) = ICHAR(InData%delim(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    IntKiBuf(Int_Xferred) = InData%NumOuts
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOutsForPE
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOutsForSep
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%NumOutsForNodes
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%unOutFile
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%unOutFile2
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%unOutFile3
    Int_Xferred = Int_Xferred + 1
    IntKiBuf(Int_Xferred) = InData%unOutFile4
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(InData%RootName)
      IntKiBuf(Int_Xferred) = ICHAR(InData%RootName(I:I), IntKi)
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( .NOT. ALLOCATED(InData%OutParam) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutParam,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutParam,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%OutParam,1), UBOUND(InData%OutParam,1)
      CALL NWTC_Library_Packoutparmtype( Re_Buf, Db_Buf, Int_Buf, InData%OutParam(i1), ErrStat2, ErrMsg2, OnlySize ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%StallStart) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StallStart,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StallStart,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%StallStart,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%StallStart,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%StallStart,2), UBOUND(InData%StallStart,2)
        DO i1 = LBOUND(InData%StallStart,1), UBOUND(InData%StallStart,1)
          ReKiBuf(Re_Xferred) = InData%StallStart(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TEThick) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TEThick,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TEThick,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TEThick,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TEThick,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TEThick,2), UBOUND(InData%TEThick,2)
        DO i1 = LBOUND(InData%TEThick,1), UBOUND(InData%TEThick,1)
          ReKiBuf(Re_Xferred) = InData%TEThick(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%TEAngle) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TEAngle,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TEAngle,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%TEAngle,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%TEAngle,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%TEAngle,2), UBOUND(InData%TEAngle,2)
        DO i1 = LBOUND(InData%TEAngle,1), UBOUND(InData%TEAngle,1)
          ReKiBuf(Re_Xferred) = InData%TEAngle(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AerCent) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AerCent,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AerCent,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AerCent,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AerCent,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AerCent,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AerCent,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AerCent,3), UBOUND(InData%AerCent,3)
        DO i2 = LBOUND(InData%AerCent,2), UBOUND(InData%AerCent,2)
          DO i1 = LBOUND(InData%AerCent,1), UBOUND(InData%AerCent,1)
            ReKiBuf(Re_Xferred) = InData%AerCent(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BlAFID) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlAFID,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlAFID,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlAFID,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlAFID,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlAFID,2), UBOUND(InData%BlAFID,2)
        DO i1 = LBOUND(InData%BlAFID,1), UBOUND(InData%BlAFID,1)
          IntKiBuf(Int_Xferred) = InData%BlAFID(i1,i2)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AFInfo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFInfo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFInfo,1)
    Int_Xferred = Int_Xferred + 2

    DO i1 = LBOUND(InData%AFInfo,1), UBOUND(InData%AFInfo,1)
      CALL AFI_PackParam( Re_Buf, Db_Buf, Int_Buf, InData%AFInfo(i1), ErrStat2, ErrMsg2, OnlySize ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Re_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Re_Buf) > 0) ReKiBuf( Re_Xferred:Re_Xferred+SIZE(Re_Buf)-1 ) = Re_Buf
        Re_Xferred = Re_Xferred + SIZE(Re_Buf)
        DEALLOCATE(Re_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Db_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Db_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Db_Buf) > 0) DbKiBuf( Db_Xferred:Db_Xferred+SIZE(Db_Buf)-1 ) = Db_Buf
        Db_Xferred = Db_Xferred + SIZE(Db_Buf)
        DEALLOCATE(Db_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
      IF(ALLOCATED(Int_Buf)) THEN
        IntKiBuf( Int_Xferred ) = SIZE(Int_Buf); Int_Xferred = Int_Xferred + 1
        IF (SIZE(Int_Buf) > 0) IntKiBuf( Int_Xferred:Int_Xferred+SIZE(Int_Buf)-1 ) = Int_Buf
        Int_Xferred = Int_Xferred + SIZE(Int_Buf)
        DEALLOCATE(Int_Buf)
      ELSE
        IntKiBuf( Int_Xferred ) = 0; Int_Xferred = Int_Xferred + 1
      ENDIF
    END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AFLECo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFLECo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFLECo,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFLECo,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFLECo,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFLECo,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFLECo,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AFLECo,3), UBOUND(InData%AFLECo,3)
        DO i2 = LBOUND(InData%AFLECo,2), UBOUND(InData%AFLECo,2)
          DO i1 = LBOUND(InData%AFLECo,1), UBOUND(InData%AFLECo,1)
            ReKiBuf(Re_Xferred) = InData%AFLECo(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AFTECo) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFTECo,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFTECo,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFTECo,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFTECo,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFTECo,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFTECo,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AFTECo,3), UBOUND(InData%AFTECo,3)
        DO i2 = LBOUND(InData%AFTECo,2), UBOUND(InData%AFTECo,2)
          DO i1 = LBOUND(InData%AFTECo,1), UBOUND(InData%AFTECo,1)
            ReKiBuf(Re_Xferred) = InData%AFTECo(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BlSpn) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlSpn,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlSpn,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlSpn,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlSpn,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlSpn,2), UBOUND(InData%BlSpn,2)
        DO i1 = LBOUND(InData%BlSpn,1), UBOUND(InData%BlSpn,1)
          ReKiBuf(Re_Xferred) = InData%BlSpn(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%BlChord) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlChord,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlChord,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%BlChord,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%BlChord,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%BlChord,2), UBOUND(InData%BlChord,2)
        DO i1 = LBOUND(InData%BlChord,1), UBOUND(InData%BlChord,1)
          ReKiBuf(Re_Xferred) = InData%BlChord(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%ReListBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%ReListBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%ReListBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%ReListBL,1), UBOUND(InData%ReListBL,1)
        ReKiBuf(Re_Xferred) = InData%ReListBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AOAListBL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AOAListBL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AOAListBL,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%AOAListBL,1), UBOUND(InData%AOAListBL,1)
        ReKiBuf(Re_Xferred) = InData%AOAListBL(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dStarAll1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%dStarAll1,3), UBOUND(InData%dStarAll1,3)
        DO i2 = LBOUND(InData%dStarAll1,2), UBOUND(InData%dStarAll1,2)
          DO i1 = LBOUND(InData%dStarAll1,1), UBOUND(InData%dStarAll1,1)
            ReKiBuf(Re_Xferred) = InData%dStarAll1(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%dStarAll2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%dStarAll2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%dStarAll2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%dStarAll2,3), UBOUND(InData%dStarAll2,3)
        DO i2 = LBOUND(InData%dStarAll2,2), UBOUND(InData%dStarAll2,2)
          DO i1 = LBOUND(InData%dStarAll2,1), UBOUND(InData%dStarAll2,1)
            ReKiBuf(Re_Xferred) = InData%dStarAll2(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%d99All1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%d99All1,3), UBOUND(InData%d99All1,3)
        DO i2 = LBOUND(InData%d99All1,2), UBOUND(InData%d99All1,2)
          DO i1 = LBOUND(InData%d99All1,1), UBOUND(InData%d99All1,1)
            ReKiBuf(Re_Xferred) = InData%d99All1(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%d99All2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%d99All2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%d99All2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%d99All2,3), UBOUND(InData%d99All2,3)
        DO i2 = LBOUND(InData%d99All2,2), UBOUND(InData%d99All2,2)
          DO i1 = LBOUND(InData%d99All2,1), UBOUND(InData%d99All2,1)
            ReKiBuf(Re_Xferred) = InData%d99All2(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CfAll1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%CfAll1,3), UBOUND(InData%CfAll1,3)
        DO i2 = LBOUND(InData%CfAll1,2), UBOUND(InData%CfAll1,2)
          DO i1 = LBOUND(InData%CfAll1,1), UBOUND(InData%CfAll1,1)
            ReKiBuf(Re_Xferred) = InData%CfAll1(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%CfAll2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%CfAll2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%CfAll2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%CfAll2,3), UBOUND(InData%CfAll2,3)
        DO i2 = LBOUND(InData%CfAll2,2), UBOUND(InData%CfAll2,2)
          DO i1 = LBOUND(InData%CfAll2,1), UBOUND(InData%CfAll2,1)
            ReKiBuf(Re_Xferred) = InData%CfAll2(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgeVelRat1) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat1,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat1,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat1,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat1,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat1,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat1,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%EdgeVelRat1,3), UBOUND(InData%EdgeVelRat1,3)
        DO i2 = LBOUND(InData%EdgeVelRat1,2), UBOUND(InData%EdgeVelRat1,2)
          DO i1 = LBOUND(InData%EdgeVelRat1,1), UBOUND(InData%EdgeVelRat1,1)
            ReKiBuf(Re_Xferred) = InData%EdgeVelRat1(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%EdgeVelRat2) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat2,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat2,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat2,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat2,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%EdgeVelRat2,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%EdgeVelRat2,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%EdgeVelRat2,3), UBOUND(InData%EdgeVelRat2,3)
        DO i2 = LBOUND(InData%EdgeVelRat2,2), UBOUND(InData%EdgeVelRat2,2)
          DO i1 = LBOUND(InData%EdgeVelRat2,1), UBOUND(InData%EdgeVelRat2,1)
            ReKiBuf(Re_Xferred) = InData%EdgeVelRat2(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AFThickGuida) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFThickGuida,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFThickGuida,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AFThickGuida,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AFThickGuida,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AFThickGuida,2), UBOUND(InData%AFThickGuida,2)
        DO i1 = LBOUND(InData%AFThickGuida,1), UBOUND(InData%AFThickGuida,1)
          ReKiBuf(Re_Xferred) = InData%AFThickGuida(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AA_PackParam

 SUBROUTINE AA_UnPackParam( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_ParameterType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackParam'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
    OutData%DT = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
    OutData%IBLUNT = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ILAM = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITIP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITRIP = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ITURB = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%IInflow = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%X_BLMethod = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%TICalcMeth = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%ROUND = TRANSFER(IntKiBuf(Int_Xferred), OutData%ROUND)
    Int_Xferred = Int_Xferred + 1
    OutData%ALPRAT = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%NumBlades = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumBlNds = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%AirDens = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%KinVisc = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%SpdSound = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%HubHeight = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%toptip = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%bottip = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rotorregionlimitsVert not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rotorregionlimitsVert)) DEALLOCATE(OutData%rotorregionlimitsVert)
    ALLOCATE(OutData%rotorregionlimitsVert(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotorregionlimitsVert.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rotorregionlimitsVert,1), UBOUND(OutData%rotorregionlimitsVert,1)
        OutData%rotorregionlimitsVert(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rotorregionlimitsHorz not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rotorregionlimitsHorz)) DEALLOCATE(OutData%rotorregionlimitsHorz)
    ALLOCATE(OutData%rotorregionlimitsHorz(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotorregionlimitsHorz.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rotorregionlimitsHorz,1), UBOUND(OutData%rotorregionlimitsHorz,1)
        OutData%rotorregionlimitsHorz(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rotorregionlimitsalph not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rotorregionlimitsalph)) DEALLOCATE(OutData%rotorregionlimitsalph)
    ALLOCATE(OutData%rotorregionlimitsalph(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotorregionlimitsalph.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rotorregionlimitsalph,1), UBOUND(OutData%rotorregionlimitsalph,1)
        OutData%rotorregionlimitsalph(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! rotorregionlimitsrad not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%rotorregionlimitsrad)) DEALLOCATE(OutData%rotorregionlimitsrad)
    ALLOCATE(OutData%rotorregionlimitsrad(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotorregionlimitsrad.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%rotorregionlimitsrad,1), UBOUND(OutData%rotorregionlimitsrad,1)
        OutData%rotorregionlimitsrad(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%NrObsLoc = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%aweightflag = TRANSFER(IntKiBuf(Int_Xferred), OutData%aweightflag)
    Int_Xferred = Int_Xferred + 1
    OutData%TxtFileOutput = TRANSFER(IntKiBuf(Int_Xferred), OutData%TxtFileOutput)
    Int_Xferred = Int_Xferred + 1
    OutData%AAStart = DbKiBuf(Db_Xferred)
    Db_Xferred = Db_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsX not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsX)) DEALLOCATE(OutData%ObsX)
    ALLOCATE(OutData%ObsX(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsX.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsX,1), UBOUND(OutData%ObsX,1)
        OutData%ObsX(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsY not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsY)) DEALLOCATE(OutData%ObsY)
    ALLOCATE(OutData%ObsY(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsY.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsY,1), UBOUND(OutData%ObsY,1)
        OutData%ObsY(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ObsZ not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ObsZ)) DEALLOCATE(OutData%ObsZ)
    ALLOCATE(OutData%ObsZ(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ObsZ.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ObsZ,1), UBOUND(OutData%ObsZ,1)
        OutData%ObsZ(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! FreqList not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%FreqList)) DEALLOCATE(OutData%FreqList)
    ALLOCATE(OutData%FreqList(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%FreqList.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%FreqList,1), UBOUND(OutData%FreqList,1)
        OutData%FreqList(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Aweight not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Aweight)) DEALLOCATE(OutData%Aweight)
    ALLOCATE(OutData%Aweight(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Aweight.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%Aweight,1), UBOUND(OutData%Aweight,1)
        OutData%Aweight(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
    OutData%Fsample = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%total_sample = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%total_sampleTI = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%AA_Bl_Prcntge = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%startnode = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%Lturb = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%AvgV = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dz_turb_in = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
    OutData%dy_turb_in = ReKiBuf(Re_Xferred)
    Re_Xferred = Re_Xferred + 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TI_Grid_In not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TI_Grid_In)) DEALLOCATE(OutData%TI_Grid_In)
    ALLOCATE(OutData%TI_Grid_In(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TI_Grid_In.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TI_Grid_In,2), UBOUND(OutData%TI_Grid_In,2)
        DO i1 = LBOUND(OutData%TI_Grid_In,1), UBOUND(OutData%TI_Grid_In,1)
          OutData%TI_Grid_In(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
    DO I = 1, LEN(OutData%FTitle)
      OutData%FTitle(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    DO I = 1, LEN(OutData%outFmt)
      OutData%outFmt(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NrOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%delim)
      OutData%delim(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
    OutData%NumOuts = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumOutsForPE = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumOutsForSep = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%NumOutsForNodes = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%unOutFile = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%unOutFile2 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%unOutFile3 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    OutData%unOutFile4 = IntKiBuf(Int_Xferred)
    Int_Xferred = Int_Xferred + 1
    DO I = 1, LEN(OutData%RootName)
      OutData%RootName(I:I) = CHAR(IntKiBuf(Int_Xferred))
      Int_Xferred = Int_Xferred + 1
    END DO ! I
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutParam not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutParam)) DEALLOCATE(OutData%OutParam)
    ALLOCATE(OutData%OutParam(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%OutParam,1), UBOUND(OutData%OutParam,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL NWTC_Library_Unpackoutparmtype( Re_Buf, Db_Buf, Int_Buf, OutData%OutParam(i1), ErrStat2, ErrMsg2 ) ! OutParam 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! StallStart not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%StallStart)) DEALLOCATE(OutData%StallStart)
    ALLOCATE(OutData%StallStart(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%StallStart.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%StallStart,2), UBOUND(OutData%StallStart,2)
        DO i1 = LBOUND(OutData%StallStart,1), UBOUND(OutData%StallStart,1)
          OutData%StallStart(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TEThick not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TEThick)) DEALLOCATE(OutData%TEThick)
    ALLOCATE(OutData%TEThick(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TEThick.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TEThick,2), UBOUND(OutData%TEThick,2)
        DO i1 = LBOUND(OutData%TEThick,1), UBOUND(OutData%TEThick,1)
          OutData%TEThick(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! TEAngle not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%TEAngle)) DEALLOCATE(OutData%TEAngle)
    ALLOCATE(OutData%TEAngle(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%TEAngle.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%TEAngle,2), UBOUND(OutData%TEAngle,2)
        DO i1 = LBOUND(OutData%TEAngle,1), UBOUND(OutData%TEAngle,1)
          OutData%TEAngle(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AerCent not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AerCent)) DEALLOCATE(OutData%AerCent)
    ALLOCATE(OutData%AerCent(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AerCent.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AerCent,3), UBOUND(OutData%AerCent,3)
        DO i2 = LBOUND(OutData%AerCent,2), UBOUND(OutData%AerCent,2)
          DO i1 = LBOUND(OutData%AerCent,1), UBOUND(OutData%AerCent,1)
            OutData%AerCent(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlAFID not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlAFID)) DEALLOCATE(OutData%BlAFID)
    ALLOCATE(OutData%BlAFID(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlAFID.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlAFID,2), UBOUND(OutData%BlAFID,2)
        DO i1 = LBOUND(OutData%BlAFID,1), UBOUND(OutData%BlAFID,1)
          OutData%BlAFID(i1,i2) = IntKiBuf(Int_Xferred)
          Int_Xferred = Int_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFInfo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFInfo)) DEALLOCATE(OutData%AFInfo)
    ALLOCATE(OutData%AFInfo(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFInfo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
    DO i1 = LBOUND(OutData%AFInfo,1), UBOUND(OutData%AFInfo,1)
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Re_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Re_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Re_Buf = ReKiBuf( Re_Xferred:Re_Xferred+Buf_size-1 )
        Re_Xferred = Re_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Db_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Db_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Db_Buf = DbKiBuf( Db_Xferred:Db_Xferred+Buf_size-1 )
        Db_Xferred = Db_Xferred + Buf_size
      END IF
      Buf_size=IntKiBuf( Int_Xferred )
      Int_Xferred = Int_Xferred + 1
      IF(Buf_size > 0) THEN
        ALLOCATE(Int_Buf(Buf_size),STAT=ErrStat2)
        IF (ErrStat2 /= 0) THEN 
           CALL SetErrStat(ErrID_Fatal, 'Error allocating Int_Buf.', ErrStat, ErrMsg,RoutineName)
           RETURN
        END IF
        Int_Buf = IntKiBuf( Int_Xferred:Int_Xferred+Buf_size-1 )
        Int_Xferred = Int_Xferred + Buf_size
      END IF
      CALL AFI_UnpackParam( Re_Buf, Db_Buf, Int_Buf, OutData%AFInfo(i1), ErrStat2, ErrMsg2 ) ! AFInfo 
        CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
        IF (ErrStat >= AbortErrLev) RETURN

      IF(ALLOCATED(Re_Buf )) DEALLOCATE(Re_Buf )
      IF(ALLOCATED(Db_Buf )) DEALLOCATE(Db_Buf )
      IF(ALLOCATED(Int_Buf)) DEALLOCATE(Int_Buf)
    END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFLECo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFLECo)) DEALLOCATE(OutData%AFLECo)
    ALLOCATE(OutData%AFLECo(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFLECo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AFLECo,3), UBOUND(OutData%AFLECo,3)
        DO i2 = LBOUND(OutData%AFLECo,2), UBOUND(OutData%AFLECo,2)
          DO i1 = LBOUND(OutData%AFLECo,1), UBOUND(OutData%AFLECo,1)
            OutData%AFLECo(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFTECo not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFTECo)) DEALLOCATE(OutData%AFTECo)
    ALLOCATE(OutData%AFTECo(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFTECo.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AFTECo,3), UBOUND(OutData%AFTECo,3)
        DO i2 = LBOUND(OutData%AFTECo,2), UBOUND(OutData%AFTECo,2)
          DO i1 = LBOUND(OutData%AFTECo,1), UBOUND(OutData%AFTECo,1)
            OutData%AFTECo(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlSpn not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlSpn)) DEALLOCATE(OutData%BlSpn)
    ALLOCATE(OutData%BlSpn(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlSpn.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlSpn,2), UBOUND(OutData%BlSpn,2)
        DO i1 = LBOUND(OutData%BlSpn,1), UBOUND(OutData%BlSpn,1)
          OutData%BlSpn(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! BlChord not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%BlChord)) DEALLOCATE(OutData%BlChord)
    ALLOCATE(OutData%BlChord(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%BlChord.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%BlChord,2), UBOUND(OutData%BlChord,2)
        DO i1 = LBOUND(OutData%BlChord,1), UBOUND(OutData%BlChord,1)
          OutData%BlChord(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! ReListBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%ReListBL)) DEALLOCATE(OutData%ReListBL)
    ALLOCATE(OutData%ReListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%ReListBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%ReListBL,1), UBOUND(OutData%ReListBL,1)
        OutData%ReListBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AOAListBL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AOAListBL)) DEALLOCATE(OutData%AOAListBL)
    ALLOCATE(OutData%AOAListBL(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AOAListBL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%AOAListBL,1), UBOUND(OutData%AOAListBL,1)
        OutData%AOAListBL(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dStarAll1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dStarAll1)) DEALLOCATE(OutData%dStarAll1)
    ALLOCATE(OutData%dStarAll1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dStarAll1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%dStarAll1,3), UBOUND(OutData%dStarAll1,3)
        DO i2 = LBOUND(OutData%dStarAll1,2), UBOUND(OutData%dStarAll1,2)
          DO i1 = LBOUND(OutData%dStarAll1,1), UBOUND(OutData%dStarAll1,1)
            OutData%dStarAll1(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! dStarAll2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%dStarAll2)) DEALLOCATE(OutData%dStarAll2)
    ALLOCATE(OutData%dStarAll2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%dStarAll2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%dStarAll2,3), UBOUND(OutData%dStarAll2,3)
        DO i2 = LBOUND(OutData%dStarAll2,2), UBOUND(OutData%dStarAll2,2)
          DO i1 = LBOUND(OutData%dStarAll2,1), UBOUND(OutData%dStarAll2,1)
            OutData%dStarAll2(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! d99All1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%d99All1)) DEALLOCATE(OutData%d99All1)
    ALLOCATE(OutData%d99All1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%d99All1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%d99All1,3), UBOUND(OutData%d99All1,3)
        DO i2 = LBOUND(OutData%d99All1,2), UBOUND(OutData%d99All1,2)
          DO i1 = LBOUND(OutData%d99All1,1), UBOUND(OutData%d99All1,1)
            OutData%d99All1(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! d99All2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%d99All2)) DEALLOCATE(OutData%d99All2)
    ALLOCATE(OutData%d99All2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%d99All2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%d99All2,3), UBOUND(OutData%d99All2,3)
        DO i2 = LBOUND(OutData%d99All2,2), UBOUND(OutData%d99All2,2)
          DO i1 = LBOUND(OutData%d99All2,1), UBOUND(OutData%d99All2,1)
            OutData%d99All2(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CfAll1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CfAll1)) DEALLOCATE(OutData%CfAll1)
    ALLOCATE(OutData%CfAll1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CfAll1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%CfAll1,3), UBOUND(OutData%CfAll1,3)
        DO i2 = LBOUND(OutData%CfAll1,2), UBOUND(OutData%CfAll1,2)
          DO i1 = LBOUND(OutData%CfAll1,1), UBOUND(OutData%CfAll1,1)
            OutData%CfAll1(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! CfAll2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%CfAll2)) DEALLOCATE(OutData%CfAll2)
    ALLOCATE(OutData%CfAll2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%CfAll2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%CfAll2,3), UBOUND(OutData%CfAll2,3)
        DO i2 = LBOUND(OutData%CfAll2,2), UBOUND(OutData%CfAll2,2)
          DO i1 = LBOUND(OutData%CfAll2,1), UBOUND(OutData%CfAll2,1)
            OutData%CfAll2(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgeVelRat1 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgeVelRat1)) DEALLOCATE(OutData%EdgeVelRat1)
    ALLOCATE(OutData%EdgeVelRat1(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgeVelRat1.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%EdgeVelRat1,3), UBOUND(OutData%EdgeVelRat1,3)
        DO i2 = LBOUND(OutData%EdgeVelRat1,2), UBOUND(OutData%EdgeVelRat1,2)
          DO i1 = LBOUND(OutData%EdgeVelRat1,1), UBOUND(OutData%EdgeVelRat1,1)
            OutData%EdgeVelRat1(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! EdgeVelRat2 not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%EdgeVelRat2)) DEALLOCATE(OutData%EdgeVelRat2)
    ALLOCATE(OutData%EdgeVelRat2(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%EdgeVelRat2.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%EdgeVelRat2,3), UBOUND(OutData%EdgeVelRat2,3)
        DO i2 = LBOUND(OutData%EdgeVelRat2,2), UBOUND(OutData%EdgeVelRat2,2)
          DO i1 = LBOUND(OutData%EdgeVelRat2,1), UBOUND(OutData%EdgeVelRat2,1)
            OutData%EdgeVelRat2(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AFThickGuida not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AFThickGuida)) DEALLOCATE(OutData%AFThickGuida)
    ALLOCATE(OutData%AFThickGuida(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFThickGuida.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AFThickGuida,2), UBOUND(OutData%AFThickGuida,2)
        DO i1 = LBOUND(OutData%AFThickGuida,1), UBOUND(OutData%AFThickGuida,1)
          OutData%AFThickGuida(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
 END SUBROUTINE AA_UnPackParam

 SUBROUTINE AA_CopyInput( SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_InputType), INTENT(IN) :: SrcInputData
   TYPE(AA_InputType), INTENT(INOUT) :: DstInputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyInput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcInputData%RotGtoL)) THEN
  i1_l = LBOUND(SrcInputData%RotGtoL,1)
  i1_u = UBOUND(SrcInputData%RotGtoL,1)
  i2_l = LBOUND(SrcInputData%RotGtoL,2)
  i2_u = UBOUND(SrcInputData%RotGtoL,2)
  i3_l = LBOUND(SrcInputData%RotGtoL,3)
  i3_u = UBOUND(SrcInputData%RotGtoL,3)
  i4_l = LBOUND(SrcInputData%RotGtoL,4)
  i4_u = UBOUND(SrcInputData%RotGtoL,4)
  IF (.NOT. ALLOCATED(DstInputData%RotGtoL)) THEN 
    ALLOCATE(DstInputData%RotGtoL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%RotGtoL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%RotGtoL = SrcInputData%RotGtoL
ENDIF
IF (ALLOCATED(SrcInputData%AeroCent_G)) THEN
  i1_l = LBOUND(SrcInputData%AeroCent_G,1)
  i1_u = UBOUND(SrcInputData%AeroCent_G,1)
  i2_l = LBOUND(SrcInputData%AeroCent_G,2)
  i2_u = UBOUND(SrcInputData%AeroCent_G,2)
  i3_l = LBOUND(SrcInputData%AeroCent_G,3)
  i3_u = UBOUND(SrcInputData%AeroCent_G,3)
  IF (.NOT. ALLOCATED(DstInputData%AeroCent_G)) THEN 
    ALLOCATE(DstInputData%AeroCent_G(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%AeroCent_G.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%AeroCent_G = SrcInputData%AeroCent_G
ENDIF
IF (ALLOCATED(SrcInputData%Vrel)) THEN
  i1_l = LBOUND(SrcInputData%Vrel,1)
  i1_u = UBOUND(SrcInputData%Vrel,1)
  i2_l = LBOUND(SrcInputData%Vrel,2)
  i2_u = UBOUND(SrcInputData%Vrel,2)
  IF (.NOT. ALLOCATED(DstInputData%Vrel)) THEN 
    ALLOCATE(DstInputData%Vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vrel.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Vrel = SrcInputData%Vrel
ENDIF
IF (ALLOCATED(SrcInputData%AoANoise)) THEN
  i1_l = LBOUND(SrcInputData%AoANoise,1)
  i1_u = UBOUND(SrcInputData%AoANoise,1)
  i2_l = LBOUND(SrcInputData%AoANoise,2)
  i2_u = UBOUND(SrcInputData%AoANoise,2)
  IF (.NOT. ALLOCATED(DstInputData%AoANoise)) THEN 
    ALLOCATE(DstInputData%AoANoise(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%AoANoise.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%AoANoise = SrcInputData%AoANoise
ENDIF
IF (ALLOCATED(SrcInputData%Inflow)) THEN
  i1_l = LBOUND(SrcInputData%Inflow,1)
  i1_u = UBOUND(SrcInputData%Inflow,1)
  i2_l = LBOUND(SrcInputData%Inflow,2)
  i2_u = UBOUND(SrcInputData%Inflow,2)
  i3_l = LBOUND(SrcInputData%Inflow,3)
  i3_u = UBOUND(SrcInputData%Inflow,3)
  IF (.NOT. ALLOCATED(DstInputData%Inflow)) THEN 
    ALLOCATE(DstInputData%Inflow(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Inflow.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstInputData%Inflow = SrcInputData%Inflow
ENDIF
 END SUBROUTINE AA_CopyInput

 SUBROUTINE AA_DestroyInput( InputData, ErrStat, ErrMsg )
  TYPE(AA_InputType), INTENT(INOUT) :: InputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyInput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(InputData%RotGtoL)) THEN
  DEALLOCATE(InputData%RotGtoL)
ENDIF
IF (ALLOCATED(InputData%AeroCent_G)) THEN
  DEALLOCATE(InputData%AeroCent_G)
ENDIF
IF (ALLOCATED(InputData%Vrel)) THEN
  DEALLOCATE(InputData%Vrel)
ENDIF
IF (ALLOCATED(InputData%AoANoise)) THEN
  DEALLOCATE(InputData%AoANoise)
ENDIF
IF (ALLOCATED(InputData%Inflow)) THEN
  DEALLOCATE(InputData%Inflow)
ENDIF
 END SUBROUTINE AA_DestroyInput

 SUBROUTINE AA_PackInput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_InputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackInput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! RotGtoL allocated yes/no
  IF ( ALLOCATED(InData%RotGtoL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! RotGtoL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%RotGtoL)  ! RotGtoL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AeroCent_G allocated yes/no
  IF ( ALLOCATED(InData%AeroCent_G) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! AeroCent_G upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AeroCent_G)  ! AeroCent_G
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Vrel allocated yes/no
  IF ( ALLOCATED(InData%Vrel) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! Vrel upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Vrel)  ! Vrel
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! AoANoise allocated yes/no
  IF ( ALLOCATED(InData%AoANoise) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! AoANoise upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%AoANoise)  ! AoANoise
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! Inflow allocated yes/no
  IF ( ALLOCATED(InData%Inflow) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! Inflow upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%Inflow)  ! Inflow
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%RotGtoL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotGtoL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotGtoL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotGtoL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotGtoL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotGtoL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotGtoL,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%RotGtoL,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%RotGtoL,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%RotGtoL,4), UBOUND(InData%RotGtoL,4)
        DO i3 = LBOUND(InData%RotGtoL,3), UBOUND(InData%RotGtoL,3)
          DO i2 = LBOUND(InData%RotGtoL,2), UBOUND(InData%RotGtoL,2)
            DO i1 = LBOUND(InData%RotGtoL,1), UBOUND(InData%RotGtoL,1)
              ReKiBuf(Re_Xferred) = InData%RotGtoL(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AeroCent_G) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AeroCent_G,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AeroCent_G,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AeroCent_G,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AeroCent_G,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AeroCent_G,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AeroCent_G,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%AeroCent_G,3), UBOUND(InData%AeroCent_G,3)
        DO i2 = LBOUND(InData%AeroCent_G,2), UBOUND(InData%AeroCent_G,2)
          DO i1 = LBOUND(InData%AeroCent_G,1), UBOUND(InData%AeroCent_G,1)
            ReKiBuf(Re_Xferred) = InData%AeroCent_G(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Vrel) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vrel,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vrel,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Vrel,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Vrel,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%Vrel,2), UBOUND(InData%Vrel,2)
        DO i1 = LBOUND(InData%Vrel,1), UBOUND(InData%Vrel,1)
          ReKiBuf(Re_Xferred) = InData%Vrel(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%AoANoise) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AoANoise,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AoANoise,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%AoANoise,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%AoANoise,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%AoANoise,2), UBOUND(InData%AoANoise,2)
        DO i1 = LBOUND(InData%AoANoise,1), UBOUND(InData%AoANoise,1)
          ReKiBuf(Re_Xferred) = InData%AoANoise(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%Inflow) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Inflow,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Inflow,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Inflow,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Inflow,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%Inflow,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%Inflow,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%Inflow,3), UBOUND(InData%Inflow,3)
        DO i2 = LBOUND(InData%Inflow,2), UBOUND(InData%Inflow,2)
          DO i1 = LBOUND(InData%Inflow,1), UBOUND(InData%Inflow,1)
            ReKiBuf(Re_Xferred) = InData%Inflow(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE AA_PackInput

 SUBROUTINE AA_UnPackInput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_InputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackInput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! RotGtoL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%RotGtoL)) DEALLOCATE(OutData%RotGtoL)
    ALLOCATE(OutData%RotGtoL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%RotGtoL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%RotGtoL,4), UBOUND(OutData%RotGtoL,4)
        DO i3 = LBOUND(OutData%RotGtoL,3), UBOUND(OutData%RotGtoL,3)
          DO i2 = LBOUND(OutData%RotGtoL,2), UBOUND(OutData%RotGtoL,2)
            DO i1 = LBOUND(OutData%RotGtoL,1), UBOUND(OutData%RotGtoL,1)
              OutData%RotGtoL(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AeroCent_G not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AeroCent_G)) DEALLOCATE(OutData%AeroCent_G)
    ALLOCATE(OutData%AeroCent_G(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AeroCent_G.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%AeroCent_G,3), UBOUND(OutData%AeroCent_G,3)
        DO i2 = LBOUND(OutData%AeroCent_G,2), UBOUND(OutData%AeroCent_G,2)
          DO i1 = LBOUND(OutData%AeroCent_G,1), UBOUND(OutData%AeroCent_G,1)
            OutData%AeroCent_G(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Vrel not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Vrel)) DEALLOCATE(OutData%Vrel)
    ALLOCATE(OutData%Vrel(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Vrel.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%Vrel,2), UBOUND(OutData%Vrel,2)
        DO i1 = LBOUND(OutData%Vrel,1), UBOUND(OutData%Vrel,1)
          OutData%Vrel(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! AoANoise not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%AoANoise)) DEALLOCATE(OutData%AoANoise)
    ALLOCATE(OutData%AoANoise(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%AoANoise.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%AoANoise,2), UBOUND(OutData%AoANoise,2)
        DO i1 = LBOUND(OutData%AoANoise,1), UBOUND(OutData%AoANoise,1)
          OutData%AoANoise(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! Inflow not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%Inflow)) DEALLOCATE(OutData%Inflow)
    ALLOCATE(OutData%Inflow(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%Inflow.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%Inflow,3), UBOUND(OutData%Inflow,3)
        DO i2 = LBOUND(OutData%Inflow,2), UBOUND(OutData%Inflow,2)
          DO i1 = LBOUND(OutData%Inflow,1), UBOUND(OutData%Inflow,1)
            OutData%Inflow(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
 END SUBROUTINE AA_UnPackInput

 SUBROUTINE AA_CopyOutput( SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg )
   TYPE(AA_OutputType), INTENT(IN) :: SrcOutputData
   TYPE(AA_OutputType), INTENT(INOUT) :: DstOutputData
   INTEGER(IntKi),  INTENT(IN   ) :: CtrlCode
   INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
   CHARACTER(*),    INTENT(  OUT) :: ErrMsg
! Local 
   INTEGER(IntKi)                 :: i,j,k
   INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
   INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
   INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
   INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
   INTEGER(IntKi)                 :: ErrStat2
   CHARACTER(ErrMsgLen)           :: ErrMsg2
   CHARACTER(*), PARAMETER        :: RoutineName = 'AA_CopyOutput'
! 
   ErrStat = ErrID_None
   ErrMsg  = ""
IF (ALLOCATED(SrcOutputData%SumSpecNoise)) THEN
  i1_l = LBOUND(SrcOutputData%SumSpecNoise,1)
  i1_u = UBOUND(SrcOutputData%SumSpecNoise,1)
  i2_l = LBOUND(SrcOutputData%SumSpecNoise,2)
  i2_u = UBOUND(SrcOutputData%SumSpecNoise,2)
  i3_l = LBOUND(SrcOutputData%SumSpecNoise,3)
  i3_u = UBOUND(SrcOutputData%SumSpecNoise,3)
  IF (.NOT. ALLOCATED(DstOutputData%SumSpecNoise)) THEN 
    ALLOCATE(DstOutputData%SumSpecNoise(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%SumSpecNoise.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%SumSpecNoise = SrcOutputData%SumSpecNoise
ENDIF
IF (ALLOCATED(SrcOutputData%SumSpecNoiseSep)) THEN
  i1_l = LBOUND(SrcOutputData%SumSpecNoiseSep,1)
  i1_u = UBOUND(SrcOutputData%SumSpecNoiseSep,1)
  i2_l = LBOUND(SrcOutputData%SumSpecNoiseSep,2)
  i2_u = UBOUND(SrcOutputData%SumSpecNoiseSep,2)
  i3_l = LBOUND(SrcOutputData%SumSpecNoiseSep,3)
  i3_u = UBOUND(SrcOutputData%SumSpecNoiseSep,3)
  IF (.NOT. ALLOCATED(DstOutputData%SumSpecNoiseSep)) THEN 
    ALLOCATE(DstOutputData%SumSpecNoiseSep(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%SumSpecNoiseSep.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%SumSpecNoiseSep = SrcOutputData%SumSpecNoiseSep
ENDIF
IF (ALLOCATED(SrcOutputData%OASPL)) THEN
  i1_l = LBOUND(SrcOutputData%OASPL,1)
  i1_u = UBOUND(SrcOutputData%OASPL,1)
  i2_l = LBOUND(SrcOutputData%OASPL,2)
  i2_u = UBOUND(SrcOutputData%OASPL,2)
  i3_l = LBOUND(SrcOutputData%OASPL,3)
  i3_u = UBOUND(SrcOutputData%OASPL,3)
  IF (.NOT. ALLOCATED(DstOutputData%OASPL)) THEN 
    ALLOCATE(DstOutputData%OASPL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OASPL.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%OASPL = SrcOutputData%OASPL
ENDIF
IF (ALLOCATED(SrcOutputData%OASPL_Mech)) THEN
  i1_l = LBOUND(SrcOutputData%OASPL_Mech,1)
  i1_u = UBOUND(SrcOutputData%OASPL_Mech,1)
  i2_l = LBOUND(SrcOutputData%OASPL_Mech,2)
  i2_u = UBOUND(SrcOutputData%OASPL_Mech,2)
  i3_l = LBOUND(SrcOutputData%OASPL_Mech,3)
  i3_u = UBOUND(SrcOutputData%OASPL_Mech,3)
  i4_l = LBOUND(SrcOutputData%OASPL_Mech,4)
  i4_u = UBOUND(SrcOutputData%OASPL_Mech,4)
  IF (.NOT. ALLOCATED(DstOutputData%OASPL_Mech)) THEN 
    ALLOCATE(DstOutputData%OASPL_Mech(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OASPL_Mech.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%OASPL_Mech = SrcOutputData%OASPL_Mech
ENDIF
IF (ALLOCATED(SrcOutputData%DirectiviOutput)) THEN
  i1_l = LBOUND(SrcOutputData%DirectiviOutput,1)
  i1_u = UBOUND(SrcOutputData%DirectiviOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%DirectiviOutput)) THEN 
    ALLOCATE(DstOutputData%DirectiviOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%DirectiviOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%DirectiviOutput = SrcOutputData%DirectiviOutput
ENDIF
IF (ALLOCATED(SrcOutputData%OutLECoords)) THEN
  i1_l = LBOUND(SrcOutputData%OutLECoords,1)
  i1_u = UBOUND(SrcOutputData%OutLECoords,1)
  i2_l = LBOUND(SrcOutputData%OutLECoords,2)
  i2_u = UBOUND(SrcOutputData%OutLECoords,2)
  i3_l = LBOUND(SrcOutputData%OutLECoords,3)
  i3_u = UBOUND(SrcOutputData%OutLECoords,3)
  i4_l = LBOUND(SrcOutputData%OutLECoords,4)
  i4_u = UBOUND(SrcOutputData%OutLECoords,4)
  IF (.NOT. ALLOCATED(DstOutputData%OutLECoords)) THEN 
    ALLOCATE(DstOutputData%OutLECoords(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OutLECoords.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%OutLECoords = SrcOutputData%OutLECoords
ENDIF
IF (ALLOCATED(SrcOutputData%PtotalFreq)) THEN
  i1_l = LBOUND(SrcOutputData%PtotalFreq,1)
  i1_u = UBOUND(SrcOutputData%PtotalFreq,1)
  i2_l = LBOUND(SrcOutputData%PtotalFreq,2)
  i2_u = UBOUND(SrcOutputData%PtotalFreq,2)
  IF (.NOT. ALLOCATED(DstOutputData%PtotalFreq)) THEN 
    ALLOCATE(DstOutputData%PtotalFreq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%PtotalFreq.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%PtotalFreq = SrcOutputData%PtotalFreq
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutputForPE)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutputForPE,1)
  i1_u = UBOUND(SrcOutputData%WriteOutputForPE,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutputForPE)) THEN 
    ALLOCATE(DstOutputData%WriteOutputForPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputForPE.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutputForPE = SrcOutputData%WriteOutputForPE
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutput)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutput,1)
  i1_u = UBOUND(SrcOutputData%WriteOutput,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutput)) THEN 
    ALLOCATE(DstOutputData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutput = SrcOutputData%WriteOutput
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutputSep)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutputSep,1)
  i1_u = UBOUND(SrcOutputData%WriteOutputSep,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutputSep)) THEN 
    ALLOCATE(DstOutputData%WriteOutputSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputSep.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutputSep = SrcOutputData%WriteOutputSep
ENDIF
IF (ALLOCATED(SrcOutputData%WriteOutputNode)) THEN
  i1_l = LBOUND(SrcOutputData%WriteOutputNode,1)
  i1_u = UBOUND(SrcOutputData%WriteOutputNode,1)
  IF (.NOT. ALLOCATED(DstOutputData%WriteOutputNode)) THEN 
    ALLOCATE(DstOutputData%WriteOutputNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
      CALL SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputNode.', ErrStat, ErrMsg,RoutineName)
      RETURN
    END IF
  END IF
    DstOutputData%WriteOutputNode = SrcOutputData%WriteOutputNode
ENDIF
 END SUBROUTINE AA_CopyOutput

 SUBROUTINE AA_DestroyOutput( OutputData, ErrStat, ErrMsg )
  TYPE(AA_OutputType), INTENT(INOUT) :: OutputData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
  CHARACTER(*),    PARAMETER :: RoutineName = 'AA_DestroyOutput'
  INTEGER(IntKi)                 :: i, i1, i2, i3, i4, i5 
! 
  ErrStat = ErrID_None
  ErrMsg  = ""
IF (ALLOCATED(OutputData%SumSpecNoise)) THEN
  DEALLOCATE(OutputData%SumSpecNoise)
ENDIF
IF (ALLOCATED(OutputData%SumSpecNoiseSep)) THEN
  DEALLOCATE(OutputData%SumSpecNoiseSep)
ENDIF
IF (ALLOCATED(OutputData%OASPL)) THEN
  DEALLOCATE(OutputData%OASPL)
ENDIF
IF (ALLOCATED(OutputData%OASPL_Mech)) THEN
  DEALLOCATE(OutputData%OASPL_Mech)
ENDIF
IF (ALLOCATED(OutputData%DirectiviOutput)) THEN
  DEALLOCATE(OutputData%DirectiviOutput)
ENDIF
IF (ALLOCATED(OutputData%OutLECoords)) THEN
  DEALLOCATE(OutputData%OutLECoords)
ENDIF
IF (ALLOCATED(OutputData%PtotalFreq)) THEN
  DEALLOCATE(OutputData%PtotalFreq)
ENDIF
IF (ALLOCATED(OutputData%WriteOutputForPE)) THEN
  DEALLOCATE(OutputData%WriteOutputForPE)
ENDIF
IF (ALLOCATED(OutputData%WriteOutput)) THEN
  DEALLOCATE(OutputData%WriteOutput)
ENDIF
IF (ALLOCATED(OutputData%WriteOutputSep)) THEN
  DEALLOCATE(OutputData%WriteOutputSep)
ENDIF
IF (ALLOCATED(OutputData%WriteOutputNode)) THEN
  DEALLOCATE(OutputData%WriteOutputNode)
ENDIF
 END SUBROUTINE AA_DestroyOutput

 SUBROUTINE AA_PackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Indata, ErrStat, ErrMsg, SizeOnly )
  REAL(ReKi),       ALLOCATABLE, INTENT(  OUT) :: ReKiBuf(:)
  REAL(DbKi),       ALLOCATABLE, INTENT(  OUT) :: DbKiBuf(:)
  INTEGER(IntKi),   ALLOCATABLE, INTENT(  OUT) :: IntKiBuf(:)
  TYPE(AA_OutputType),  INTENT(IN) :: InData
  INTEGER(IntKi),   INTENT(  OUT) :: ErrStat
  CHARACTER(*),     INTENT(  OUT) :: ErrMsg
  LOGICAL,OPTIONAL, INTENT(IN   ) :: SizeOnly
    ! Local variables
  INTEGER(IntKi)                 :: Re_BufSz
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_BufSz
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_BufSz
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i,i1,i2,i3,i4,i5
  LOGICAL                        :: OnlySize ! if present and true, do not pack, just allocate buffers
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_PackOutput'
 ! buffers to store subtypes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)

  OnlySize = .FALSE.
  IF ( PRESENT(SizeOnly) ) THEN
    OnlySize = SizeOnly
  ENDIF
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_BufSz  = 0
  Db_BufSz  = 0
  Int_BufSz  = 0
  Int_BufSz   = Int_BufSz   + 1     ! SumSpecNoise allocated yes/no
  IF ( ALLOCATED(InData%SumSpecNoise) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! SumSpecNoise upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SumSpecNoise)  ! SumSpecNoise
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! SumSpecNoiseSep allocated yes/no
  IF ( ALLOCATED(InData%SumSpecNoiseSep) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! SumSpecNoiseSep upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%SumSpecNoiseSep)  ! SumSpecNoiseSep
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OASPL allocated yes/no
  IF ( ALLOCATED(InData%OASPL) ) THEN
    Int_BufSz   = Int_BufSz   + 2*3  ! OASPL upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OASPL)  ! OASPL
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OASPL_Mech allocated yes/no
  IF ( ALLOCATED(InData%OASPL_Mech) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! OASPL_Mech upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OASPL_Mech)  ! OASPL_Mech
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! DirectiviOutput allocated yes/no
  IF ( ALLOCATED(InData%DirectiviOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! DirectiviOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%DirectiviOutput)  ! DirectiviOutput
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! OutLECoords allocated yes/no
  IF ( ALLOCATED(InData%OutLECoords) ) THEN
    Int_BufSz   = Int_BufSz   + 2*4  ! OutLECoords upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%OutLECoords)  ! OutLECoords
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! PtotalFreq allocated yes/no
  IF ( ALLOCATED(InData%PtotalFreq) ) THEN
    Int_BufSz   = Int_BufSz   + 2*2  ! PtotalFreq upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%PtotalFreq)  ! PtotalFreq
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputForPE allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputForPE) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputForPE upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutputForPE)  ! WriteOutputForPE
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutput allocated yes/no
  IF ( ALLOCATED(InData%WriteOutput) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutput upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutput)  ! WriteOutput
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputSep allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputSep) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputSep upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutputSep)  ! WriteOutputSep
  END IF
  Int_BufSz   = Int_BufSz   + 1     ! WriteOutputNode allocated yes/no
  IF ( ALLOCATED(InData%WriteOutputNode) ) THEN
    Int_BufSz   = Int_BufSz   + 2*1  ! WriteOutputNode upper/lower bounds for each dimension
      Re_BufSz   = Re_BufSz   + SIZE(InData%WriteOutputNode)  ! WriteOutputNode
  END IF
  IF ( Re_BufSz  .GT. 0 ) THEN 
     ALLOCATE( ReKiBuf(  Re_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating ReKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Db_BufSz  .GT. 0 ) THEN 
     ALLOCATE( DbKiBuf(  Db_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating DbKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF ( Int_BufSz  .GT. 0 ) THEN 
     ALLOCATE( IntKiBuf(  Int_BufSz  ), STAT=ErrStat2 )
     IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating IntKiBuf.', ErrStat, ErrMsg,RoutineName)
       RETURN
     END IF
  END IF
  IF(OnlySize) RETURN ! return early if only trying to allocate buffers (not pack them)

  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred = 1

  IF ( .NOT. ALLOCATED(InData%SumSpecNoise) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoise,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoise,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoise,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoise,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoise,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoise,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%SumSpecNoise,3), UBOUND(InData%SumSpecNoise,3)
        DO i2 = LBOUND(InData%SumSpecNoise,2), UBOUND(InData%SumSpecNoise,2)
          DO i1 = LBOUND(InData%SumSpecNoise,1), UBOUND(InData%SumSpecNoise,1)
            ReKiBuf(Re_Xferred) = InData%SumSpecNoise(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%SumSpecNoiseSep) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoiseSep,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoiseSep,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoiseSep,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoiseSep,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%SumSpecNoiseSep,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%SumSpecNoiseSep,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%SumSpecNoiseSep,3), UBOUND(InData%SumSpecNoiseSep,3)
        DO i2 = LBOUND(InData%SumSpecNoiseSep,2), UBOUND(InData%SumSpecNoiseSep,2)
          DO i1 = LBOUND(InData%SumSpecNoiseSep,1), UBOUND(InData%SumSpecNoiseSep,1)
            ReKiBuf(Re_Xferred) = InData%SumSpecNoiseSep(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OASPL) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL,3)
    Int_Xferred = Int_Xferred + 2

      DO i3 = LBOUND(InData%OASPL,3), UBOUND(InData%OASPL,3)
        DO i2 = LBOUND(InData%OASPL,2), UBOUND(InData%OASPL,2)
          DO i1 = LBOUND(InData%OASPL,1), UBOUND(InData%OASPL,1)
            ReKiBuf(Re_Xferred) = InData%OASPL(i1,i2,i3)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OASPL_Mech) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL_Mech,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL_Mech,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL_Mech,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL_Mech,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL_Mech,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL_Mech,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OASPL_Mech,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OASPL_Mech,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%OASPL_Mech,4), UBOUND(InData%OASPL_Mech,4)
        DO i3 = LBOUND(InData%OASPL_Mech,3), UBOUND(InData%OASPL_Mech,3)
          DO i2 = LBOUND(InData%OASPL_Mech,2), UBOUND(InData%OASPL_Mech,2)
            DO i1 = LBOUND(InData%OASPL_Mech,1), UBOUND(InData%OASPL_Mech,1)
              ReKiBuf(Re_Xferred) = InData%OASPL_Mech(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%DirectiviOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%DirectiviOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%DirectiviOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%DirectiviOutput,1), UBOUND(InData%DirectiviOutput,1)
        ReKiBuf(Re_Xferred) = InData%DirectiviOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%OutLECoords) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutLECoords,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutLECoords,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutLECoords,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutLECoords,2)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutLECoords,3)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutLECoords,3)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%OutLECoords,4)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%OutLECoords,4)
    Int_Xferred = Int_Xferred + 2

      DO i4 = LBOUND(InData%OutLECoords,4), UBOUND(InData%OutLECoords,4)
        DO i3 = LBOUND(InData%OutLECoords,3), UBOUND(InData%OutLECoords,3)
          DO i2 = LBOUND(InData%OutLECoords,2), UBOUND(InData%OutLECoords,2)
            DO i1 = LBOUND(InData%OutLECoords,1), UBOUND(InData%OutLECoords,1)
              ReKiBuf(Re_Xferred) = InData%OutLECoords(i1,i2,i3,i4)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%PtotalFreq) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PtotalFreq,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PtotalFreq,1)
    Int_Xferred = Int_Xferred + 2
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%PtotalFreq,2)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%PtotalFreq,2)
    Int_Xferred = Int_Xferred + 2

      DO i2 = LBOUND(InData%PtotalFreq,2), UBOUND(InData%PtotalFreq,2)
        DO i1 = LBOUND(InData%PtotalFreq,1), UBOUND(InData%PtotalFreq,1)
          ReKiBuf(Re_Xferred) = InData%PtotalFreq(i1,i2)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputForPE) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputForPE,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputForPE,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputForPE,1), UBOUND(InData%WriteOutputForPE,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutputForPE(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutput) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutput,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutput,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutput,1), UBOUND(InData%WriteOutput,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutput(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputSep) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputSep,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputSep,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputSep,1), UBOUND(InData%WriteOutputSep,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutputSep(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( .NOT. ALLOCATED(InData%WriteOutputNode) ) THEN
    IntKiBuf( Int_Xferred ) = 0
    Int_Xferred = Int_Xferred + 1
  ELSE
    IntKiBuf( Int_Xferred ) = 1
    Int_Xferred = Int_Xferred + 1
    IntKiBuf( Int_Xferred    ) = LBOUND(InData%WriteOutputNode,1)
    IntKiBuf( Int_Xferred + 1) = UBOUND(InData%WriteOutputNode,1)
    Int_Xferred = Int_Xferred + 2

      DO i1 = LBOUND(InData%WriteOutputNode,1), UBOUND(InData%WriteOutputNode,1)
        ReKiBuf(Re_Xferred) = InData%WriteOutputNode(i1)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE AA_PackOutput

 SUBROUTINE AA_UnPackOutput( ReKiBuf, DbKiBuf, IntKiBuf, Outdata, ErrStat, ErrMsg )
  REAL(ReKi),      ALLOCATABLE, INTENT(IN   ) :: ReKiBuf(:)
  REAL(DbKi),      ALLOCATABLE, INTENT(IN   ) :: DbKiBuf(:)
  INTEGER(IntKi),  ALLOCATABLE, INTENT(IN   ) :: IntKiBuf(:)
  TYPE(AA_OutputType), INTENT(INOUT) :: OutData
  INTEGER(IntKi),  INTENT(  OUT) :: ErrStat
  CHARACTER(*),    INTENT(  OUT) :: ErrMsg
    ! Local variables
  INTEGER(IntKi)                 :: Buf_size
  INTEGER(IntKi)                 :: Re_Xferred
  INTEGER(IntKi)                 :: Db_Xferred
  INTEGER(IntKi)                 :: Int_Xferred
  INTEGER(IntKi)                 :: i
  INTEGER(IntKi)                 :: i1, i1_l, i1_u  !  bounds (upper/lower) for an array dimension 1
  INTEGER(IntKi)                 :: i2, i2_l, i2_u  !  bounds (upper/lower) for an array dimension 2
  INTEGER(IntKi)                 :: i3, i3_l, i3_u  !  bounds (upper/lower) for an array dimension 3
  INTEGER(IntKi)                 :: i4, i4_l, i4_u  !  bounds (upper/lower) for an array dimension 4
  INTEGER(IntKi)                 :: ErrStat2
  CHARACTER(ErrMsgLen)           :: ErrMsg2
  CHARACTER(*), PARAMETER        :: RoutineName = 'AA_UnPackOutput'
 ! buffers to store meshes, if any
  REAL(ReKi),      ALLOCATABLE   :: Re_Buf(:)
  REAL(DbKi),      ALLOCATABLE   :: Db_Buf(:)
  INTEGER(IntKi),  ALLOCATABLE   :: Int_Buf(:)
    !
  ErrStat = ErrID_None
  ErrMsg  = ""
  Re_Xferred  = 1
  Db_Xferred  = 1
  Int_Xferred  = 1
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SumSpecNoise not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SumSpecNoise)) DEALLOCATE(OutData%SumSpecNoise)
    ALLOCATE(OutData%SumSpecNoise(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SumSpecNoise.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%SumSpecNoise,3), UBOUND(OutData%SumSpecNoise,3)
        DO i2 = LBOUND(OutData%SumSpecNoise,2), UBOUND(OutData%SumSpecNoise,2)
          DO i1 = LBOUND(OutData%SumSpecNoise,1), UBOUND(OutData%SumSpecNoise,1)
            OutData%SumSpecNoise(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! SumSpecNoiseSep not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%SumSpecNoiseSep)) DEALLOCATE(OutData%SumSpecNoiseSep)
    ALLOCATE(OutData%SumSpecNoiseSep(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%SumSpecNoiseSep.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%SumSpecNoiseSep,3), UBOUND(OutData%SumSpecNoiseSep,3)
        DO i2 = LBOUND(OutData%SumSpecNoiseSep,2), UBOUND(OutData%SumSpecNoiseSep,2)
          DO i1 = LBOUND(OutData%SumSpecNoiseSep,1), UBOUND(OutData%SumSpecNoiseSep,1)
            OutData%SumSpecNoiseSep(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OASPL not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OASPL)) DEALLOCATE(OutData%OASPL)
    ALLOCATE(OutData%OASPL(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OASPL.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i3 = LBOUND(OutData%OASPL,3), UBOUND(OutData%OASPL,3)
        DO i2 = LBOUND(OutData%OASPL,2), UBOUND(OutData%OASPL,2)
          DO i1 = LBOUND(OutData%OASPL,1), UBOUND(OutData%OASPL,1)
            OutData%OASPL(i1,i2,i3) = ReKiBuf(Re_Xferred)
            Re_Xferred = Re_Xferred + 1
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OASPL_Mech not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OASPL_Mech)) DEALLOCATE(OutData%OASPL_Mech)
    ALLOCATE(OutData%OASPL_Mech(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OASPL_Mech.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%OASPL_Mech,4), UBOUND(OutData%OASPL_Mech,4)
        DO i3 = LBOUND(OutData%OASPL_Mech,3), UBOUND(OutData%OASPL_Mech,3)
          DO i2 = LBOUND(OutData%OASPL_Mech,2), UBOUND(OutData%OASPL_Mech,2)
            DO i1 = LBOUND(OutData%OASPL_Mech,1), UBOUND(OutData%OASPL_Mech,1)
              OutData%OASPL_Mech(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! DirectiviOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%DirectiviOutput)) DEALLOCATE(OutData%DirectiviOutput)
    ALLOCATE(OutData%DirectiviOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%DirectiviOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%DirectiviOutput,1), UBOUND(OutData%DirectiviOutput,1)
        OutData%DirectiviOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! OutLECoords not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i3_l = IntKiBuf( Int_Xferred    )
    i3_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i4_l = IntKiBuf( Int_Xferred    )
    i4_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%OutLECoords)) DEALLOCATE(OutData%OutLECoords)
    ALLOCATE(OutData%OutLECoords(i1_l:i1_u,i2_l:i2_u,i3_l:i3_u,i4_l:i4_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutLECoords.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i4 = LBOUND(OutData%OutLECoords,4), UBOUND(OutData%OutLECoords,4)
        DO i3 = LBOUND(OutData%OutLECoords,3), UBOUND(OutData%OutLECoords,3)
          DO i2 = LBOUND(OutData%OutLECoords,2), UBOUND(OutData%OutLECoords,2)
            DO i1 = LBOUND(OutData%OutLECoords,1), UBOUND(OutData%OutLECoords,1)
              OutData%OutLECoords(i1,i2,i3,i4) = ReKiBuf(Re_Xferred)
              Re_Xferred = Re_Xferred + 1
            END DO
          END DO
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! PtotalFreq not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    i2_l = IntKiBuf( Int_Xferred    )
    i2_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%PtotalFreq)) DEALLOCATE(OutData%PtotalFreq)
    ALLOCATE(OutData%PtotalFreq(i1_l:i1_u,i2_l:i2_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%PtotalFreq.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i2 = LBOUND(OutData%PtotalFreq,2), UBOUND(OutData%PtotalFreq,2)
        DO i1 = LBOUND(OutData%PtotalFreq,1), UBOUND(OutData%PtotalFreq,1)
          OutData%PtotalFreq(i1,i2) = ReKiBuf(Re_Xferred)
          Re_Xferred = Re_Xferred + 1
        END DO
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputForPE not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputForPE)) DEALLOCATE(OutData%WriteOutputForPE)
    ALLOCATE(OutData%WriteOutputForPE(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputForPE.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputForPE,1), UBOUND(OutData%WriteOutputForPE,1)
        OutData%WriteOutputForPE(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutput not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutput)) DEALLOCATE(OutData%WriteOutput)
    ALLOCATE(OutData%WriteOutput(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutput.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutput,1), UBOUND(OutData%WriteOutput,1)
        OutData%WriteOutput(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputSep not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputSep)) DEALLOCATE(OutData%WriteOutputSep)
    ALLOCATE(OutData%WriteOutputSep(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputSep.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputSep,1), UBOUND(OutData%WriteOutputSep,1)
        OutData%WriteOutputSep(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
  IF ( IntKiBuf( Int_Xferred ) == 0 ) THEN  ! WriteOutputNode not allocated
    Int_Xferred = Int_Xferred + 1
  ELSE
    Int_Xferred = Int_Xferred + 1
    i1_l = IntKiBuf( Int_Xferred    )
    i1_u = IntKiBuf( Int_Xferred + 1)
    Int_Xferred = Int_Xferred + 2
    IF (ALLOCATED(OutData%WriteOutputNode)) DEALLOCATE(OutData%WriteOutputNode)
    ALLOCATE(OutData%WriteOutputNode(i1_l:i1_u),STAT=ErrStat2)
    IF (ErrStat2 /= 0) THEN 
       CALL SetErrStat(ErrID_Fatal, 'Error allocating OutData%WriteOutputNode.', ErrStat, ErrMsg,RoutineName)
       RETURN
    END IF
      DO i1 = LBOUND(OutData%WriteOutputNode,1), UBOUND(OutData%WriteOutputNode,1)
        OutData%WriteOutputNode(i1) = ReKiBuf(Re_Xferred)
        Re_Xferred = Re_Xferred + 1
      END DO
  END IF
 END SUBROUTINE AA_UnPackOutput


 SUBROUTINE AA_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
!
!..................................................................................................................................

 TYPE(AA_InputType), INTENT(IN)  :: u(:) ! Input at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Inputs
 TYPE(AA_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'AA_Input_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(u)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(u)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(u) - 1
 IF ( order .eq. 0 ) THEN
   CALL AA_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL AA_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL AA_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(u) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE AA_Input_ExtrapInterp


 SUBROUTINE AA_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

 TYPE(AA_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
 TYPE(AA_InputType), INTENT(IN)  :: u2    ! Input at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
 TYPE(AA_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'AA_Input_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i04    ! dim4 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
 INTEGER                                    :: i3    ! dim3 counter variable for arrays
 INTEGER                                    :: i4    ! dim4 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(u_out%RotGtoL) .AND. ALLOCATED(u1%RotGtoL)) THEN
  DO i4 = LBOUND(u_out%RotGtoL,4),UBOUND(u_out%RotGtoL,4)
    DO i3 = LBOUND(u_out%RotGtoL,3),UBOUND(u_out%RotGtoL,3)
      DO i2 = LBOUND(u_out%RotGtoL,2),UBOUND(u_out%RotGtoL,2)
        DO i1 = LBOUND(u_out%RotGtoL,1),UBOUND(u_out%RotGtoL,1)
          b = -(u1%RotGtoL(i1,i2,i3,i4) - u2%RotGtoL(i1,i2,i3,i4))
          u_out%RotGtoL(i1,i2,i3,i4) = u1%RotGtoL(i1,i2,i3,i4) + b * ScaleFactor
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%AeroCent_G) .AND. ALLOCATED(u1%AeroCent_G)) THEN
  DO i3 = LBOUND(u_out%AeroCent_G,3),UBOUND(u_out%AeroCent_G,3)
    DO i2 = LBOUND(u_out%AeroCent_G,2),UBOUND(u_out%AeroCent_G,2)
      DO i1 = LBOUND(u_out%AeroCent_G,1),UBOUND(u_out%AeroCent_G,1)
        b = -(u1%AeroCent_G(i1,i2,i3) - u2%AeroCent_G(i1,i2,i3))
        u_out%AeroCent_G(i1,i2,i3) = u1%AeroCent_G(i1,i2,i3) + b * ScaleFactor
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vrel) .AND. ALLOCATED(u1%Vrel)) THEN
  DO i2 = LBOUND(u_out%Vrel,2),UBOUND(u_out%Vrel,2)
    DO i1 = LBOUND(u_out%Vrel,1),UBOUND(u_out%Vrel,1)
      b = -(u1%Vrel(i1,i2) - u2%Vrel(i1,i2))
      u_out%Vrel(i1,i2) = u1%Vrel(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%AoANoise) .AND. ALLOCATED(u1%AoANoise)) THEN
  DO i2 = LBOUND(u_out%AoANoise,2),UBOUND(u_out%AoANoise,2)
    DO i1 = LBOUND(u_out%AoANoise,1),UBOUND(u_out%AoANoise,1)
      b = -(u1%AoANoise(i1,i2) - u2%AoANoise(i1,i2))
      u_out%AoANoise(i1,i2) = u1%AoANoise(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Inflow) .AND. ALLOCATED(u1%Inflow)) THEN
  DO i3 = LBOUND(u_out%Inflow,3),UBOUND(u_out%Inflow,3)
    DO i2 = LBOUND(u_out%Inflow,2),UBOUND(u_out%Inflow,2)
      DO i1 = LBOUND(u_out%Inflow,1),UBOUND(u_out%Inflow,1)
        b = -(u1%Inflow(i1,i2,i3) - u2%Inflow(i1,i2,i3))
        u_out%Inflow(i1,i2,i3) = u1%Inflow(i1,i2,i3) + b * ScaleFactor
      END DO
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE AA_Input_ExtrapInterp1


 SUBROUTINE AA_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

 TYPE(AA_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
 TYPE(AA_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
 TYPE(AA_InputType), INTENT(IN)  :: u3      ! Input at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
 TYPE(AA_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'AA_Input_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i04    ! dim4 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
 INTEGER                                    :: i3    ! dim3 counter variable for arrays
 INTEGER                                    :: i4    ! dim4 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(u_out%RotGtoL) .AND. ALLOCATED(u1%RotGtoL)) THEN
  DO i4 = LBOUND(u_out%RotGtoL,4),UBOUND(u_out%RotGtoL,4)
    DO i3 = LBOUND(u_out%RotGtoL,3),UBOUND(u_out%RotGtoL,3)
      DO i2 = LBOUND(u_out%RotGtoL,2),UBOUND(u_out%RotGtoL,2)
        DO i1 = LBOUND(u_out%RotGtoL,1),UBOUND(u_out%RotGtoL,1)
          b = (t(3)**2*(u1%RotGtoL(i1,i2,i3,i4) - u2%RotGtoL(i1,i2,i3,i4)) + t(2)**2*(-u1%RotGtoL(i1,i2,i3,i4) + u3%RotGtoL(i1,i2,i3,i4)))* scaleFactor
          c = ( (t(2)-t(3))*u1%RotGtoL(i1,i2,i3,i4) + t(3)*u2%RotGtoL(i1,i2,i3,i4) - t(2)*u3%RotGtoL(i1,i2,i3,i4) ) * scaleFactor
          u_out%RotGtoL(i1,i2,i3,i4) = u1%RotGtoL(i1,i2,i3,i4) + b  + c * t_out
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%AeroCent_G) .AND. ALLOCATED(u1%AeroCent_G)) THEN
  DO i3 = LBOUND(u_out%AeroCent_G,3),UBOUND(u_out%AeroCent_G,3)
    DO i2 = LBOUND(u_out%AeroCent_G,2),UBOUND(u_out%AeroCent_G,2)
      DO i1 = LBOUND(u_out%AeroCent_G,1),UBOUND(u_out%AeroCent_G,1)
        b = (t(3)**2*(u1%AeroCent_G(i1,i2,i3) - u2%AeroCent_G(i1,i2,i3)) + t(2)**2*(-u1%AeroCent_G(i1,i2,i3) + u3%AeroCent_G(i1,i2,i3)))* scaleFactor
        c = ( (t(2)-t(3))*u1%AeroCent_G(i1,i2,i3) + t(3)*u2%AeroCent_G(i1,i2,i3) - t(2)*u3%AeroCent_G(i1,i2,i3) ) * scaleFactor
        u_out%AeroCent_G(i1,i2,i3) = u1%AeroCent_G(i1,i2,i3) + b  + c * t_out
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Vrel) .AND. ALLOCATED(u1%Vrel)) THEN
  DO i2 = LBOUND(u_out%Vrel,2),UBOUND(u_out%Vrel,2)
    DO i1 = LBOUND(u_out%Vrel,1),UBOUND(u_out%Vrel,1)
      b = (t(3)**2*(u1%Vrel(i1,i2) - u2%Vrel(i1,i2)) + t(2)**2*(-u1%Vrel(i1,i2) + u3%Vrel(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%Vrel(i1,i2) + t(3)*u2%Vrel(i1,i2) - t(2)*u3%Vrel(i1,i2) ) * scaleFactor
      u_out%Vrel(i1,i2) = u1%Vrel(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%AoANoise) .AND. ALLOCATED(u1%AoANoise)) THEN
  DO i2 = LBOUND(u_out%AoANoise,2),UBOUND(u_out%AoANoise,2)
    DO i1 = LBOUND(u_out%AoANoise,1),UBOUND(u_out%AoANoise,1)
      b = (t(3)**2*(u1%AoANoise(i1,i2) - u2%AoANoise(i1,i2)) + t(2)**2*(-u1%AoANoise(i1,i2) + u3%AoANoise(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*u1%AoANoise(i1,i2) + t(3)*u2%AoANoise(i1,i2) - t(2)*u3%AoANoise(i1,i2) ) * scaleFactor
      u_out%AoANoise(i1,i2) = u1%AoANoise(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(u_out%Inflow) .AND. ALLOCATED(u1%Inflow)) THEN
  DO i3 = LBOUND(u_out%Inflow,3),UBOUND(u_out%Inflow,3)
    DO i2 = LBOUND(u_out%Inflow,2),UBOUND(u_out%Inflow,2)
      DO i1 = LBOUND(u_out%Inflow,1),UBOUND(u_out%Inflow,1)
        b = (t(3)**2*(u1%Inflow(i1,i2,i3) - u2%Inflow(i1,i2,i3)) + t(2)**2*(-u1%Inflow(i1,i2,i3) + u3%Inflow(i1,i2,i3)))* scaleFactor
        c = ( (t(2)-t(3))*u1%Inflow(i1,i2,i3) + t(3)*u2%Inflow(i1,i2,i3) - t(2)*u3%Inflow(i1,i2,i3) ) * scaleFactor
        u_out%Inflow(i1,i2,i3) = u1%Inflow(i1,i2,i3) + b  + c * t_out
      END DO
    END DO
  END DO
END IF ! check if allocated
 END SUBROUTINE AA_Input_ExtrapInterp2


 SUBROUTINE AA_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
!
!  expressions below based on either
!
!  f(t) = a
!  f(t) = a + b * t, or
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
!
!..................................................................................................................................

 TYPE(AA_OutputType), INTENT(IN)  :: y(:) ! Output at t1 > t2 > t3
 REAL(DbKi),                 INTENT(IN   )  :: t(:)           ! Times associated with the Outputs
 TYPE(AA_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: t_out           ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat         ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
 INTEGER(IntKi)                             :: order           ! order of polynomial fit (max 2)
 INTEGER(IntKi)                             :: ErrStat2        ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2         ! local errors
 CHARACTER(*),    PARAMETER                 :: RoutineName = 'AA_Output_ExtrapInterp'
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
 if ( size(t) .ne. size(y)) then
    CALL SetErrStat(ErrID_Fatal,'size(t) must equal size(y)',ErrStat,ErrMsg,RoutineName)
    RETURN
 endif
 order = SIZE(y) - 1
 IF ( order .eq. 0 ) THEN
   CALL AA_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 1 ) THEN
   CALL AA_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE IF ( order .eq. 2 ) THEN
   CALL AA_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2 )
     CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
 ELSE 
   CALL SetErrStat(ErrID_Fatal,'size(y) must be less than 4 (order must be less than 3).',ErrStat,ErrMsg,RoutineName)
   RETURN
 ENDIF 
 END SUBROUTINE AA_Output_ExtrapInterp


 SUBROUTINE AA_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

 TYPE(AA_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
 TYPE(AA_OutputType), INTENT(IN)  :: y2    ! Output at t2 
 REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
 TYPE(AA_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
 REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
 INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
 CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
 CHARACTER(*),                    PARAMETER :: RoutineName = 'AA_Output_ExtrapInterp1'
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i04    ! dim4 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
 INTEGER                                    :: i3    ! dim3 counter variable for arrays
 INTEGER                                    :: i4    ! dim4 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / t(2)
IF (ALLOCATED(y_out%SumSpecNoise) .AND. ALLOCATED(y1%SumSpecNoise)) THEN
  DO i3 = LBOUND(y_out%SumSpecNoise,3),UBOUND(y_out%SumSpecNoise,3)
    DO i2 = LBOUND(y_out%SumSpecNoise,2),UBOUND(y_out%SumSpecNoise,2)
      DO i1 = LBOUND(y_out%SumSpecNoise,1),UBOUND(y_out%SumSpecNoise,1)
        b = -(y1%SumSpecNoise(i1,i2,i3) - y2%SumSpecNoise(i1,i2,i3))
        y_out%SumSpecNoise(i1,i2,i3) = y1%SumSpecNoise(i1,i2,i3) + b * ScaleFactor
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%SumSpecNoiseSep) .AND. ALLOCATED(y1%SumSpecNoiseSep)) THEN
  DO i3 = LBOUND(y_out%SumSpecNoiseSep,3),UBOUND(y_out%SumSpecNoiseSep,3)
    DO i2 = LBOUND(y_out%SumSpecNoiseSep,2),UBOUND(y_out%SumSpecNoiseSep,2)
      DO i1 = LBOUND(y_out%SumSpecNoiseSep,1),UBOUND(y_out%SumSpecNoiseSep,1)
        b = -(y1%SumSpecNoiseSep(i1,i2,i3) - y2%SumSpecNoiseSep(i1,i2,i3))
        y_out%SumSpecNoiseSep(i1,i2,i3) = y1%SumSpecNoiseSep(i1,i2,i3) + b * ScaleFactor
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OASPL) .AND. ALLOCATED(y1%OASPL)) THEN
  DO i3 = LBOUND(y_out%OASPL,3),UBOUND(y_out%OASPL,3)
    DO i2 = LBOUND(y_out%OASPL,2),UBOUND(y_out%OASPL,2)
      DO i1 = LBOUND(y_out%OASPL,1),UBOUND(y_out%OASPL,1)
        b = -(y1%OASPL(i1,i2,i3) - y2%OASPL(i1,i2,i3))
        y_out%OASPL(i1,i2,i3) = y1%OASPL(i1,i2,i3) + b * ScaleFactor
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OASPL_Mech) .AND. ALLOCATED(y1%OASPL_Mech)) THEN
  DO i4 = LBOUND(y_out%OASPL_Mech,4),UBOUND(y_out%OASPL_Mech,4)
    DO i3 = LBOUND(y_out%OASPL_Mech,3),UBOUND(y_out%OASPL_Mech,3)
      DO i2 = LBOUND(y_out%OASPL_Mech,2),UBOUND(y_out%OASPL_Mech,2)
        DO i1 = LBOUND(y_out%OASPL_Mech,1),UBOUND(y_out%OASPL_Mech,1)
          b = -(y1%OASPL_Mech(i1,i2,i3,i4) - y2%OASPL_Mech(i1,i2,i3,i4))
          y_out%OASPL_Mech(i1,i2,i3,i4) = y1%OASPL_Mech(i1,i2,i3,i4) + b * ScaleFactor
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%DirectiviOutput) .AND. ALLOCATED(y1%DirectiviOutput)) THEN
  DO i1 = LBOUND(y_out%DirectiviOutput,1),UBOUND(y_out%DirectiviOutput,1)
    b = -(y1%DirectiviOutput(i1) - y2%DirectiviOutput(i1))
    y_out%DirectiviOutput(i1) = y1%DirectiviOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OutLECoords) .AND. ALLOCATED(y1%OutLECoords)) THEN
  DO i4 = LBOUND(y_out%OutLECoords,4),UBOUND(y_out%OutLECoords,4)
    DO i3 = LBOUND(y_out%OutLECoords,3),UBOUND(y_out%OutLECoords,3)
      DO i2 = LBOUND(y_out%OutLECoords,2),UBOUND(y_out%OutLECoords,2)
        DO i1 = LBOUND(y_out%OutLECoords,1),UBOUND(y_out%OutLECoords,1)
          b = -(y1%OutLECoords(i1,i2,i3,i4) - y2%OutLECoords(i1,i2,i3,i4))
          y_out%OutLECoords(i1,i2,i3,i4) = y1%OutLECoords(i1,i2,i3,i4) + b * ScaleFactor
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%PtotalFreq) .AND. ALLOCATED(y1%PtotalFreq)) THEN
  DO i2 = LBOUND(y_out%PtotalFreq,2),UBOUND(y_out%PtotalFreq,2)
    DO i1 = LBOUND(y_out%PtotalFreq,1),UBOUND(y_out%PtotalFreq,1)
      b = -(y1%PtotalFreq(i1,i2) - y2%PtotalFreq(i1,i2))
      y_out%PtotalFreq(i1,i2) = y1%PtotalFreq(i1,i2) + b * ScaleFactor
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputForPE) .AND. ALLOCATED(y1%WriteOutputForPE)) THEN
  DO i1 = LBOUND(y_out%WriteOutputForPE,1),UBOUND(y_out%WriteOutputForPE,1)
    b = -(y1%WriteOutputForPE(i1) - y2%WriteOutputForPE(i1))
    y_out%WriteOutputForPE(i1) = y1%WriteOutputForPE(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = -(y1%WriteOutput(i1) - y2%WriteOutput(i1))
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputSep) .AND. ALLOCATED(y1%WriteOutputSep)) THEN
  DO i1 = LBOUND(y_out%WriteOutputSep,1),UBOUND(y_out%WriteOutputSep,1)
    b = -(y1%WriteOutputSep(i1) - y2%WriteOutputSep(i1))
    y_out%WriteOutputSep(i1) = y1%WriteOutputSep(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputNode) .AND. ALLOCATED(y1%WriteOutputNode)) THEN
  DO i1 = LBOUND(y_out%WriteOutputNode,1),UBOUND(y_out%WriteOutputNode,1)
    b = -(y1%WriteOutputNode(i1) - y2%WriteOutputNode(i1))
    y_out%WriteOutputNode(i1) = y1%WriteOutputNode(i1) + b * ScaleFactor
  END DO
END IF ! check if allocated
 END SUBROUTINE AA_Output_ExtrapInterp1


 SUBROUTINE AA_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

 TYPE(AA_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
 TYPE(AA_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
 TYPE(AA_OutputType), INTENT(IN)  :: y3      ! Output at t3
 REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
 TYPE(AA_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
 REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
 INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
 CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
 REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
 REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
 INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
 REAL(DbKi)                                 :: b        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: c        ! temporary for extrapolation/interpolation
 REAL(DbKi)                                 :: ScaleFactor ! temporary for extrapolation/interpolation
 INTEGER(IntKi)                             :: ErrStat2 ! local errors
 CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
 CHARACTER(*),            PARAMETER         :: RoutineName = 'AA_Output_ExtrapInterp2'
 INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i03    ! dim3 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i04    ! dim4 level 0 counter variable for arrays of ddts
 INTEGER                                    :: i1    ! dim1 counter variable for arrays
 INTEGER                                    :: i2    ! dim2 counter variable for arrays
 INTEGER                                    :: i3    ! dim3 counter variable for arrays
 INTEGER                                    :: i4    ! dim4 counter variable for arrays
    ! Initialize ErrStat
 ErrStat = ErrID_None
 ErrMsg  = ""
    ! we'll subtract a constant from the times to resolve some 
    ! numerical issues when t gets large (and to simplify the equations)
 t = tin - tin(1)
 t_out = tin_out - tin(1)

   IF ( EqualRealNos( t(1), t(2) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
     CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
     RETURN
   END IF

   ScaleFactor = t_out / (t(2) * t(3) * (t(2) - t(3)))
IF (ALLOCATED(y_out%SumSpecNoise) .AND. ALLOCATED(y1%SumSpecNoise)) THEN
  DO i3 = LBOUND(y_out%SumSpecNoise,3),UBOUND(y_out%SumSpecNoise,3)
    DO i2 = LBOUND(y_out%SumSpecNoise,2),UBOUND(y_out%SumSpecNoise,2)
      DO i1 = LBOUND(y_out%SumSpecNoise,1),UBOUND(y_out%SumSpecNoise,1)
        b = (t(3)**2*(y1%SumSpecNoise(i1,i2,i3) - y2%SumSpecNoise(i1,i2,i3)) + t(2)**2*(-y1%SumSpecNoise(i1,i2,i3) + y3%SumSpecNoise(i1,i2,i3)))* scaleFactor
        c = ( (t(2)-t(3))*y1%SumSpecNoise(i1,i2,i3) + t(3)*y2%SumSpecNoise(i1,i2,i3) - t(2)*y3%SumSpecNoise(i1,i2,i3) ) * scaleFactor
        y_out%SumSpecNoise(i1,i2,i3) = y1%SumSpecNoise(i1,i2,i3) + b  + c * t_out
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%SumSpecNoiseSep) .AND. ALLOCATED(y1%SumSpecNoiseSep)) THEN
  DO i3 = LBOUND(y_out%SumSpecNoiseSep,3),UBOUND(y_out%SumSpecNoiseSep,3)
    DO i2 = LBOUND(y_out%SumSpecNoiseSep,2),UBOUND(y_out%SumSpecNoiseSep,2)
      DO i1 = LBOUND(y_out%SumSpecNoiseSep,1),UBOUND(y_out%SumSpecNoiseSep,1)
        b = (t(3)**2*(y1%SumSpecNoiseSep(i1,i2,i3) - y2%SumSpecNoiseSep(i1,i2,i3)) + t(2)**2*(-y1%SumSpecNoiseSep(i1,i2,i3) + y3%SumSpecNoiseSep(i1,i2,i3)))* scaleFactor
        c = ( (t(2)-t(3))*y1%SumSpecNoiseSep(i1,i2,i3) + t(3)*y2%SumSpecNoiseSep(i1,i2,i3) - t(2)*y3%SumSpecNoiseSep(i1,i2,i3) ) * scaleFactor
        y_out%SumSpecNoiseSep(i1,i2,i3) = y1%SumSpecNoiseSep(i1,i2,i3) + b  + c * t_out
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OASPL) .AND. ALLOCATED(y1%OASPL)) THEN
  DO i3 = LBOUND(y_out%OASPL,3),UBOUND(y_out%OASPL,3)
    DO i2 = LBOUND(y_out%OASPL,2),UBOUND(y_out%OASPL,2)
      DO i1 = LBOUND(y_out%OASPL,1),UBOUND(y_out%OASPL,1)
        b = (t(3)**2*(y1%OASPL(i1,i2,i3) - y2%OASPL(i1,i2,i3)) + t(2)**2*(-y1%OASPL(i1,i2,i3) + y3%OASPL(i1,i2,i3)))* scaleFactor
        c = ( (t(2)-t(3))*y1%OASPL(i1,i2,i3) + t(3)*y2%OASPL(i1,i2,i3) - t(2)*y3%OASPL(i1,i2,i3) ) * scaleFactor
        y_out%OASPL(i1,i2,i3) = y1%OASPL(i1,i2,i3) + b  + c * t_out
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OASPL_Mech) .AND. ALLOCATED(y1%OASPL_Mech)) THEN
  DO i4 = LBOUND(y_out%OASPL_Mech,4),UBOUND(y_out%OASPL_Mech,4)
    DO i3 = LBOUND(y_out%OASPL_Mech,3),UBOUND(y_out%OASPL_Mech,3)
      DO i2 = LBOUND(y_out%OASPL_Mech,2),UBOUND(y_out%OASPL_Mech,2)
        DO i1 = LBOUND(y_out%OASPL_Mech,1),UBOUND(y_out%OASPL_Mech,1)
          b = (t(3)**2*(y1%OASPL_Mech(i1,i2,i3,i4) - y2%OASPL_Mech(i1,i2,i3,i4)) + t(2)**2*(-y1%OASPL_Mech(i1,i2,i3,i4) + y3%OASPL_Mech(i1,i2,i3,i4)))* scaleFactor
          c = ( (t(2)-t(3))*y1%OASPL_Mech(i1,i2,i3,i4) + t(3)*y2%OASPL_Mech(i1,i2,i3,i4) - t(2)*y3%OASPL_Mech(i1,i2,i3,i4) ) * scaleFactor
          y_out%OASPL_Mech(i1,i2,i3,i4) = y1%OASPL_Mech(i1,i2,i3,i4) + b  + c * t_out
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%DirectiviOutput) .AND. ALLOCATED(y1%DirectiviOutput)) THEN
  DO i1 = LBOUND(y_out%DirectiviOutput,1),UBOUND(y_out%DirectiviOutput,1)
    b = (t(3)**2*(y1%DirectiviOutput(i1) - y2%DirectiviOutput(i1)) + t(2)**2*(-y1%DirectiviOutput(i1) + y3%DirectiviOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%DirectiviOutput(i1) + t(3)*y2%DirectiviOutput(i1) - t(2)*y3%DirectiviOutput(i1) ) * scaleFactor
    y_out%DirectiviOutput(i1) = y1%DirectiviOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%OutLECoords) .AND. ALLOCATED(y1%OutLECoords)) THEN
  DO i4 = LBOUND(y_out%OutLECoords,4),UBOUND(y_out%OutLECoords,4)
    DO i3 = LBOUND(y_out%OutLECoords,3),UBOUND(y_out%OutLECoords,3)
      DO i2 = LBOUND(y_out%OutLECoords,2),UBOUND(y_out%OutLECoords,2)
        DO i1 = LBOUND(y_out%OutLECoords,1),UBOUND(y_out%OutLECoords,1)
          b = (t(3)**2*(y1%OutLECoords(i1,i2,i3,i4) - y2%OutLECoords(i1,i2,i3,i4)) + t(2)**2*(-y1%OutLECoords(i1,i2,i3,i4) + y3%OutLECoords(i1,i2,i3,i4)))* scaleFactor
          c = ( (t(2)-t(3))*y1%OutLECoords(i1,i2,i3,i4) + t(3)*y2%OutLECoords(i1,i2,i3,i4) - t(2)*y3%OutLECoords(i1,i2,i3,i4) ) * scaleFactor
          y_out%OutLECoords(i1,i2,i3,i4) = y1%OutLECoords(i1,i2,i3,i4) + b  + c * t_out
        END DO
      END DO
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%PtotalFreq) .AND. ALLOCATED(y1%PtotalFreq)) THEN
  DO i2 = LBOUND(y_out%PtotalFreq,2),UBOUND(y_out%PtotalFreq,2)
    DO i1 = LBOUND(y_out%PtotalFreq,1),UBOUND(y_out%PtotalFreq,1)
      b = (t(3)**2*(y1%PtotalFreq(i1,i2) - y2%PtotalFreq(i1,i2)) + t(2)**2*(-y1%PtotalFreq(i1,i2) + y3%PtotalFreq(i1,i2)))* scaleFactor
      c = ( (t(2)-t(3))*y1%PtotalFreq(i1,i2) + t(3)*y2%PtotalFreq(i1,i2) - t(2)*y3%PtotalFreq(i1,i2) ) * scaleFactor
      y_out%PtotalFreq(i1,i2) = y1%PtotalFreq(i1,i2) + b  + c * t_out
    END DO
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputForPE) .AND. ALLOCATED(y1%WriteOutputForPE)) THEN
  DO i1 = LBOUND(y_out%WriteOutputForPE,1),UBOUND(y_out%WriteOutputForPE,1)
    b = (t(3)**2*(y1%WriteOutputForPE(i1) - y2%WriteOutputForPE(i1)) + t(2)**2*(-y1%WriteOutputForPE(i1) + y3%WriteOutputForPE(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutputForPE(i1) + t(3)*y2%WriteOutputForPE(i1) - t(2)*y3%WriteOutputForPE(i1) ) * scaleFactor
    y_out%WriteOutputForPE(i1) = y1%WriteOutputForPE(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
  DO i1 = LBOUND(y_out%WriteOutput,1),UBOUND(y_out%WriteOutput,1)
    b = (t(3)**2*(y1%WriteOutput(i1) - y2%WriteOutput(i1)) + t(2)**2*(-y1%WriteOutput(i1) + y3%WriteOutput(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutput(i1) + t(3)*y2%WriteOutput(i1) - t(2)*y3%WriteOutput(i1) ) * scaleFactor
    y_out%WriteOutput(i1) = y1%WriteOutput(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputSep) .AND. ALLOCATED(y1%WriteOutputSep)) THEN
  DO i1 = LBOUND(y_out%WriteOutputSep,1),UBOUND(y_out%WriteOutputSep,1)
    b = (t(3)**2*(y1%WriteOutputSep(i1) - y2%WriteOutputSep(i1)) + t(2)**2*(-y1%WriteOutputSep(i1) + y3%WriteOutputSep(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutputSep(i1) + t(3)*y2%WriteOutputSep(i1) - t(2)*y3%WriteOutputSep(i1) ) * scaleFactor
    y_out%WriteOutputSep(i1) = y1%WriteOutputSep(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
IF (ALLOCATED(y_out%WriteOutputNode) .AND. ALLOCATED(y1%WriteOutputNode)) THEN
  DO i1 = LBOUND(y_out%WriteOutputNode,1),UBOUND(y_out%WriteOutputNode,1)
    b = (t(3)**2*(y1%WriteOutputNode(i1) - y2%WriteOutputNode(i1)) + t(2)**2*(-y1%WriteOutputNode(i1) + y3%WriteOutputNode(i1)))* scaleFactor
    c = ( (t(2)-t(3))*y1%WriteOutputNode(i1) + t(3)*y2%WriteOutputNode(i1) - t(2)*y3%WriteOutputNode(i1) ) * scaleFactor
    y_out%WriteOutputNode(i1) = y1%WriteOutputNode(i1) + b  + c * t_out
  END DO
END IF ! check if allocated
 END SUBROUTINE AA_Output_ExtrapInterp2

END MODULE AeroAcoustics_Types
!ENDOFREGISTRYGENERATEDFILE
