# Database #####


The_Database_dry<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20seas")
#The_Database_dry <- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                          sheet = "12x20seas")


Filtered_database_dry<-The_Database_dry %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_gdw) %>% 
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), 
          Tree_spp= as.factor(Tree_spp)) %>%
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 Dep_var_RII, Dep_var_ave, Season_1234t, Comm_eff_GDW, precip_mm) %>% 
  dplyr::group_by (Padd_unique) %>% 
  mutate(Dep_var_RII=ifelse(is.na(Dep_var_RII), mean(Dep_var_RII, na.rm =TRUE), Dep_var_RII))

# Filter database ####
Filtered_database_dry_123 <- Filtered_database_dry %>%
  dplyr::filter(Canopy_0123 %in% c( 1,2, 3))


# Model ####
GDW1<-lmer(Dep_var_ave~ Season_1234t*Canopy_0123 + Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + 
            Tree_height + RII_Soil_moist + RII_Soil_temp + RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + 
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_dry_123)

GDW1<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 +  
             Tree_height +  RII_Light_Intensity + 
             (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
           data= Filtered_database_dry_123)

Anova_GDW1=anova(GDW1, test.statistic="F")
summary (GDW1)



#Write anova and LSMeans 
capture.output(Anova_GDW1, file= "C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Grass/Tables/Anova_GDW1_dif.doc")

LSMeans_GDW1<-lsmeans (GDW1, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")
capture.output(LSMeans_GDW1, file= "C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Grass/Tables/LSMeans_GDW1.doc")

# Ls Means ####
LSMeans_GDW1=lsmeans (GDW1, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(GDW1,~ Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Fac_eff_GDW<-Groups_var

Groups_var

marginal

pd = position_dodge(0.3)
ggplot(Groups_var, aes(x=Canopy_0123, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  0.2, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Overstory Canopy Effect", subtitle = "Grass dry weight") +
  labs( x = "Canopy type",
        #y = expression(paste("Dry weight (g/m"^2, ")")), 
        y = "OCE Grass dry weight", 
        #y = expression(paste("Recovery rate (% day"^-1, ")"))) +  
        
        caption  = paste0("\nDifference in Dry weight in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Palm','N fix','Dry 2019', 'No N Fix'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

# Summary of database for ggplot graph####

Summ_graph_long<- summarySE(Filtered_database_dry_123, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season_1234t", "FPPlot"), 
                            na.rm = TRUE) %>% 
  dplyr::filter(Canopy_0123 %in% c( 1, 2, 3))

Summ_graph<- Summ_graph_long%>% 
  dplyr::group_by(Canopy_0123, Season_1234t) %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  # geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("% Green grass", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  #scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
  #                   name = "Canopy type",
  #                   labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)+
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  


#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Groups_var %>% 
  add_column(relat_abund_study = c (0.37,0.37, 0.09,0.09,0.37,0.37,0.09,0.54,0.54,0.54,0.09,0.54 ),
             precip_mm =c(530.14,213.77,530.14,213.77,431.01,150.27,150.27,431.01,213.77, 150.27, 431.01,530.14)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(marginal_comm_eff, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass Dry weight", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))



# Models with Community facilitative effect Bare, Season 1234 and Subset. ####



CE_GDW_6<-lmer(Comm_eff_GDW~  Canopy_0123 + precip_mm +  
                   (1|Padd_unique/Plot_ID), REML= F, 
                 data= Filtered_database_dry_123)

CE_GDW_6<-lmer(Comm_eff_GDW~ Season_1234t * Canopy_0123 +   
          (1|Farm/Padd_unique/FPPlot), REML= F, 
           data= Filtered_database_dry_123)

anova(CE_GDW_6, test.statistic="F")
summary (CE_GDW_6)

lsmeans (CE_GDW_6, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")


# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_GDW_6,~ Season_1234t + Canopy_0123, adjust = "Tukey")

Groups_var_GDW=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var_GDW


marginal_comm_eff_ind_GDW <- Groups_var_GDW %>% 
  add_column(precip_mm =c(530.14, 213.77, 530.14,  431.01,  213.77, 150.27, 150.27,431.01, 431.01,213.77,150.27,530.14))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind_GDW, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass dry weight", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))



####IMPACT AND RECOVERY RATES DRY WEIGHT ####
Summary_database_no_norm_GDW<-The_Database_dry %>%                                #No Normalized but individually normalized for impact and rec rates
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, GDW) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  group_by(Farm, Paddock, FPPlot, Canopy_0123, Tree_spp) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(GDW, Date_peak)) %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
   mutate(Impact_1 = (GDW_2W1 - GDW_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = -(GDW_3D2 - GDW_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (GDW_4W2 - GDW_3D2), X3s = Date_peak_4W2 - Date_peak_3D2)  %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  mutate (GDW_2W1_ind_norm = GDW_2W1/GDW_2W1 * 100,
          GDW_3D2_ind_norm = GDW_3D2/GDW_2W1 * 100) %>% 
  mutate (Impact_ind_norm = GDW_2W1_ind_norm - GDW_3D2_ind_norm) %>% 
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  #dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
   #              -Canopy_diameter, -DBH, -Tree_height, -Tree_spp) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  filter_all(all_vars(!is.na(Date_peak_4W2)))

Impact_GDW2<-lmer(Impact_2~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F, #########MODEL PAPER IMPACT 
                data= Summary_database_no_norm_GDW)

anova(Impact_GDW2, test.statistic="F")
summary (Impact_GDW2)

emmeans (Impact_GDW2, pairwise~ Canopy_0123, adjust="Tukey") 

marginal_Impact_GDW <- emmeans(Impact_GDW2,~ Canopy_0123, adjust = "Tukey")

Groups_var_Impact_GDW=cld(marginal_Impact_GDW, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                      adjust="Tukey") 

Groups_var_Impact_GDW$Canopy_0132 <- factor(Groups_var_Impact_GDW$Canopy_0123,                                                      # Change ordering manually
                                        levels = c("0", "1", "3", "2"))

Graph_Impact_GDW <- ggplot(Groups_var_Impact_GDW, aes (x=Canopy_0123, y = emmean, color = Canopy_0123)) +
  geom_point(size = 2) +
  geom_errorbar(aes(ymin=emmean-SE, ymax=emmean+SE, color=Canopy_0123), width=.05, size = 0.5,) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none") +
  ggtitle ("Grass biomass impact", subtitle = "during severe drought") +
  labs( x = "Canopy type (ordered by canopy density)", 
        y =  expression(paste("Impact ( g / m"^2, " )"))) +  
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3")) +
  scale_x_discrete("Canopy type", labels = c( "Open", "Palm",  "N fix","No N Fix"))+  
  scale_y_continuous(expand = c(0,0), limits = c(0,400))

#Recovery rates

RecovRate_M2_GDW<-lmer(RR2~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F,   #########MODEL PAPER RECOVERY RATE 1 
                   data= Summary_database_no_norm_GDW)

anova(RecovRate_M2_GDW)

summary (RecovRate_M2_GDW)
emmeans (RecovRate_M2_GDW, pairwise~ Canopy_0123, adjust="Tukey") 
marginal_RecovRate2_GDW <- emmeans(RecovRate_M2_GDW,~ Canopy_0123, adjust = "Tukey")
marginal_RecovRate2_GDW
marginal_RecovRate2_table_GDW<- as.data.frame(marginal_RecovRate2_GDW)
marginal_RecovRate2_table_GDW$Canopy_0132 <- factor(marginal_RecovRate2_table$Canopy_0123,                                                      # Change ordering manually
                                                levels = c("0", "1", "3", "2"))
Groups_var_RecovRate2_GDW=cld(marginal_RecovRate2_GDW, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                          adjust="Tukey") 
Groups_var_RecovRate2_GDW
Groups_var_RecovRate2_GDW$Canopy_0132 <- factor(Groups_var_RecovRate2_GDW$Canopy_0123,                                                      # Change ordering manually
                                            levels = c("0", "1", "3", "2"))


RecovRate_M1_GDW<-lmer(RR1~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F, #########MODEL PAPER RECOVERY RATE 1 
                   data= Summary_database_no_norm_GDW)
anova(RecovRate_M1_GDW)
summary (RecovRate_M1_GDW)
emmeans (RecovRate_M1_GDW, pairwise~ Canopy_0123, adjust="Tukey") 
marginal_RecovRate1_GDW <- emmeans(RecovRate_M1_GDW,~ Canopy_0123, adjust = "Tukey")
marginal_RecovRate1_GDW
marginal_RecovRate1_table_GDW<- as.data.frame(marginal_RecovRate1_GDW)
marginal_RecovRate1_table_GDW$Canopy_0132 <- factor(marginal_RecovRate1_GDW$Canopy_0123,                                                      # Change ordering manually
                                                levels = c("0", "1", "3", "2"))

Groups_var_RecovRate1_GDW=cld(marginal_RecovRate1_GDW, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                          adjust="Tukey") 
Groups_var_RecovRate1_GDW
Groups_var_RecovRate1_GDW$Canopy_0132 <- factor(Groups_var_RecovRate1_GDW$Canopy_0123,                                                      # Change ordering manually
                                            levels = c("0", "1", "3", "2"))

RR1_RR2_SE_GDW<-full_join(marginal_RecovRate1_table_GDW, marginal_RecovRate2_table_GDW, by = "Canopy_0123")

RR1_RR2_SE_longer_GDW <- RR1_RR2_SE_GDW %>% 
  pivot_longer(cols = (c("emmean.x", "emmean.y")),
               names_to = "Rec_rate",
               values_to= "RR_values",
               values_drop_na = TRUE) %>% 
  pivot_longer(cols = (c("SE.x", "SE.y")),
               names_to = "SE",
               values_to= "SE_values",
               values_drop_na = TRUE)  %>% 
  filter(Rec_rate == c("emmean.x", "emmean.y") & SE == c("SE.x", "SE.y"))

pd=position_dodge(0.4)

Graph_RR_GDW = ggplot(RR1_RR2_SE_longer_GDW, aes (x=Rec_rate, y = RR_values, color = Canopy_0123)) +
  geom_point(size = 2, position = pd ) +
  geom_errorbar(aes(ymin=RR_values-SE_values, ymax=RR_values+SE_values, color=Canopy_0123), width=.1, size = 0.5, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  #theme(legend.position="none") +
  ggtitle ("Recovery rate", subtitle = "after droughts") +
  labs( x = "Droughts", y = expression(paste("Recovery rate ( g / m"^2, ". day )"))) + 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3" ),
                     name = "Canopy type",
                     labels=c("Open", "Palm","NF",  "NNF")) +
  
  scale_x_discrete("Droughts", labels = c( "Average 2018", "Severe 2019"))+ 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_y_continuous(expand = c(0,0), limits = c(-0.80,0.8))

Graph_Impact_GDW + Graph_RR_GDW

# Summary of database for ggplot graph####

Summ_graph_long_GDW<- summarySE(Filtered_database_dry, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season_1234t", "FPPlot"), 
                            na.rm = TRUE) %>% 
  filter(Canopy_0123 %in% c( 0, 1, 2, 3))

Summ_graph_GDW<- Summ_graph_long_GDW%>% 
  group_by(Canopy_0123, Season_1234t) %>% 
  summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph_GDW, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dry biomass", subtitle = "in plots") +
  labs( x = "Season", 
        y = expression(paste("Dry biomass ( g / m"^2, " )"))) + 
            #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "NF", "NNF")) +
  scale_x_discrete(labels = c('Dry 2018','Wet 2018','Dry 2019','Wet 2019' ))
  
