# Database #####

#The_Database<- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                         sheet = "12x20")
The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20")

Filtered_database<-The_Database %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_shrubs) %>% 
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), Date_peak= as.factor(Date_peak), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Observer= as.factor(Observer), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123)) %>%
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Monitoring, Date_peak, Observer, Padd_unique, Paddock, FPPlot, Canopy_0123,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, Dif_Soil_moist, Dif_Soil_temp,  
                 Dif_Temp_above, Dif_Light_Intensity, 
                 Dep_var_RII, Dep_var_ave, Season_1234t, Comm_eff_shrubs) %>% 
  dplyr::group_by (Padd_unique) %>% 
  mutate(Dep_var_RII=ifelse(is.na(Dep_var_RII), mean(Dep_var_RII, na.rm =TRUE), Dep_var_RII))

write.csv(as.matrix(Filtered_database), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Filtered_database_shrubs.csv", na = "")

# Filter database ####
Filtered_database_123 <- Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(1,2, 3))

# Model ####
Sh1x<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 + Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + 
           Tree_height + RII_Soil_moist + RII_Soil_temp + RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + 
           Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

Sh1x<-lmer(Dep_var_ave~ Season_1234t + Canopy_0123 + Canopy_dens +   
             (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)

#PAPER
Sh1<-lmer(Dep_var_ave~ Canopy_0123 + Canopy_dens +   
            (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)


anova(Sh1, test.statistic="F")
summary (Sh1)


write.csv(as.matrix(anova(Sh1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_Sh1.csv", na = "")
tab_model(Sh1)

CE_Sh1<-lmer(Comm_eff_shrubs~ Canopy_0123 + Canopy_dens +   
            (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)


anova(CE_Sh1, test.statistic="F")
summary (CE_Sh1)


write.csv(as.matrix(anova(CE_Sh1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_CE_Sh1.csv", na = "")
tab_model(CE_Sh1)

# Ls Means ####
lsmeans (Sh1, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(Sh1,~ Season_1234t+Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
marginal

pd = position_dodge(0.3)
ggplot(Groups_var, aes(x=Season_1234t, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  0.2, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrub cover difference under tree - open plot", subtitle = "in plots") +
  labs( x = "Seasons", 
        y = "Shrub cover difference ", 
        caption  = paste0("\nDifference in shrub cover in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

# Summary of database for ggplot graph####

Summ_graph_long<- summarySE(Filtered_database_123, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season_1234t", "FPPlot"), 
                            na.rm = TRUE) %>% 
  filter(Canopy_0123 %in% c( 1, 2, 3))

Summ_graph<- Summ_graph_long%>% 
  group_by(Canopy_0123, Season_1234t) %>% 
  summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  # geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("% Green grass", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  #scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
  #                   name = "Canopy type",
  #                   labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)+
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  


#Dif_shrubs ####

# Transform Database to calculate Impact and recovery rates -No Normalized###

Summary_database_no_norm<-The_Database %>%                                #No Normalized
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green, Dif_shrubs) %>%
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(Dif_shrubs, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Dif_shrubs_2W1 - Dif_shrubs_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = -(Dif_shrubs_3D2 - Dif_shrubs_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Dif_shrubs_4W2 - Dif_shrubs_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>% 
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Temp_Logger, -Light_Intensity, -RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3)) %>% 
  filter_all(all_vars(!is.na(Date_peak_4W2)))


# Convert from wide to long table Database with Impacts and RR ###
Summary_database_longer <- Summary_database_no_norm %>% 
  pivot_longer(cols = (c("Dif_shrubs_1D1", "Dif_shrubs_2W1", "Dif_shrubs_3D2", "Dif_shrubs_4W2")),
               names_to = "Season",
               values_to= "Dif_shrubs",
               values_drop_na = TRUE)

Summary_database_longer_short <- Summary_database_longer %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot) %>% 
  filter(Canopy_0123 %in% c(1, 2, 3))  %>% 
  add_column(relat_abund_padd = c(0.45,0.45,0.45,0.45, 0.35,0.35,0.35,0.35, 0.2, 0.2, 0.2, 0.2),
             relat_abund_study = c(0.54,0.54,0.54,0.54, 0.37,0.37,0.37,0.37, 0.09,0.09,0.09,0.09),
             precip_mm = c (213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01),
             Evapotrans = c(5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45),
             temp = c(31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4)) %>%
  mutate (Comm_eff_padd= (Dif_shrubs * relat_abund_padd)) %>% 
  mutate (Comm_eff_study= (Dif_shrubs * relat_abund_study))

#Shorten long table Database with Impacts and RR to only average per Canopy type
Summary_database_canopy0123 <- Summary_database_no_norm %>% 
  group_by(Canopy_0123) %>% 
  summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot)



#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(Summary_database_longer_short, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrubs ", subtitle = "Community facilitative effect") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))

#scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' )) 



#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Groups_var %>% 
  add_column(relat_abund_study = c (0.37,0.37,0.37,0.54,0.54,0.37,0.54,0.54,0.09,0.09,0.09,0.09),
             precip_mm =c(213.77,530.14,150.27,213.77,530.14,431.01,150.27,431.01,213.77,530.14,150.27,431.01)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(marginal_comm_eff, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrubs", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA 2
# Models with Bare, Season 1234 and Subset. ####

CE_Shrubs_6<-lmer(Comm_eff_shrubs~ Season_1234t +  Canopy_0123 +  
                  (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                data= Filtered_database_123, )

anova(CE_Shrubs_6, test.statistic="F")
summary (CE_Shrubs_6)

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_Shrubs_6,~ Season_1234t + Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var


marginal_comm_eff_ind <- Groups_var %>% 
  add_column(precip_mm =c(213.77, 530.14, 150.27, 431.01, 213.77, 530.14, 150.27, 431.01, 213.77, 530.14, 150.27, 431.01 ))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrubs", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))




