# Database #####

#The_Database<- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                         sheet = "12x20")
The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20")


Filtered_database<-The_Database %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_bare) %>% 
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), Date_peak= as.factor(Date_peak), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Observer= as.factor(Observer), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123)) %>%
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Monitoring, Date_peak, Observer, Padd_unique, Paddock, FPPlot, Canopy_0123,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, Dif_Soil_moist, Dif_Soil_temp,  
                 Dif_Temp_above, Dif_Light_Intensity, 
                 Dep_var_RII, Dep_var_ave, Season_1234t, Comm_eff_bare, precip_mm) %>% 
  dplyr::group_by (Padd_unique) %>% 
  mutate(Dep_var_RII=ifelse(is.na(Dep_var_RII), mean(Dep_var_RII, na.rm =TRUE), Dep_var_RII))

write.csv(as.matrix(Filtered_database), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Filtered_database_Diff_bare.csv", na = "")


# Filter database ####
Filtered_database_123 <- Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(1,2, 3))

# Model ####
B0<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 + Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + 
            Tree_height + RII_Soil_moist + RII_Soil_temp + RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + 
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)

B1<-lmer(Dep_var_ave~ Canopy_0123 + Season + Canopy_dens + 
           (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

anova(B1, test.statistic="F")
summary (B1)

write.csv(as.matrix(anova(B1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_B1.csv", na = "")
tab_model(B1)

CE_B1<-lmer(Comm_eff_bare~ Canopy_0123 + Canopy_dens + Season +
           (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

anova(CE_B1, test.statistic="F")
summary (CE_B1)

write.csv(as.matrix(anova(CE_B1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_CE_B1.csv", na = "")
ºtab_model(CE_B1)

# Ls Means ####
lsmeans (B1, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(B1,~ Season*Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
marginal

pd = position_dodge(0.3)
ggplot(Groups_var, aes(x=Season, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  0.2, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Bare soil difference under tree - open plot", subtitle = "in plots") +
  labs( x = "Season", 
        y = quote (Delta*  " Bare soil (%) "))+
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "NF", "NNF")) +
  scale_x_discrete(labels = c('Dry','Wet'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)


# Summary of database for ggplot graph####

Summ_graph_long<- summarySE(The_Database, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season_1234t", "FPPlot"), 
                            na.rm = TRUE) %>% 
  filter(Canopy_0123 %in% c( 1, 2, 3))

Summ_graph<- Summ_graph_long%>% 
  group_by(Canopy_0123, Season_1234t) %>% 
  summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  # geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("% Green grass", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  #scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
  #                   name = "Canopy type",
  #                   labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)+
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  








#Graphs Diff Green####
#Graph Impact
ggplot(Data_seas, aes(x=Season_norm, y=Green_norm, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "% Green normalized ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  


# Calculate RRs for sepparate season pairs ###
Summary_database_RR1<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, RII_Green_2W1, RII_Green_1D1) %>% 
  pivot_longer (c (RII_Green_1D1, RII_Green_2W1), 
                names_to = "Season",
                values_to= "Values") %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)


Summary_database_RR2<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_2W1) %>% 
  pivot_longer (c (Green_2W1, Green_3D2), 
                names_to = "Season",
                values_to= "Values")  %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

Summary_database_RR2$Season <- factor(Summary_database_RR2$Season, levels = c("W1N", "D2N"))

Summary_database_RR3<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_4W2) %>% 
  mutate(GreenDry2=(Green_3D2*100)/Green_4W2, GreenWet2 = (Green_4W2*100/Green_4W2)) 
pivot_longer (c (GreenDry2, GreenWet2), 
              names_to = "Season",
              values_to= "Values")  %>% 
  #group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

# Graph single RRs or drop lines###
#1
Ind_RR1=ggplot(Summary_database_no_norm, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))   

#2

Ind_RR2=ggplot(Summary_database_RR2, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Wet 2018 (90%)','Dry 2019 (72%)')) 


#3
Ind_RR3=ggplot(Summary_database_RR3, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2019 (72%)', 'Wet 2019 (90%)'))  

Ind_RR1 + Ind_RR2 + Ind_RR3
# My three graphs with the three impacts and the three recovery rates. ###


Reco_rate_sum<- read_excel("C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Recovery_rates.xlsx", 
                           sheet = "Recov_rat_sum")

Reco_rate_sum<-Reco_rate_sum %>% mutate (Canopy_0123= as.factor(Canopy_0123))

Graph_1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_1, y = RR1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("2018", subtitle = "") +
  
  labs( x = "Impact 2018", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_2 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = Drop1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Wet 2018- Dry2019", subtitle = "") +
  
  labs( x = "Impact wet 2018- dry2019", 
        y = "Drop rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_3 <- ggplot(Summary_database_canopy0123, aes (x = Impact_3, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dry 2019 - Wet 2019", subtitle = "") +
  
  labs( x = "Impact 2019", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c( "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_1 + Graph_2 + Graph_3
# Milena's suggested graphs ###
#Specific resilience graphs

####Impact severe drought and recovery after severe drought

Graph_RR1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in Effect size ", subtitle = "during and after severe drought 2018-2019") +
  labs(x=quote(Delta* " Effect size from wet 18 to strong dry season 19"), 
       y = " Rate of change ES after drought 2019") +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(0,100))+
  scale_y_continuous(expand = c(0,0), limits = c(-1.69,0.01))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 



##### Recovery rate after dry season 2018 and after dry season 2019
Graph_RR2 = ggplot(Summary_database_no_norm, aes (x = RR1, y = RR2, color = Canopy_0123)) +
  geom_point(size =2 ) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Rates of change of ES after droughts", subtitle = "From Dry to Wet (2018 and 2019)") +
  
  labs( x = "Rate of change ES - severe drought 2018", 
        y = "Rate of change ES- average drought 2019", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(-0.6,0.6))+
  scale_y_continuous(expand = c(0,0), limits = c(-0.6,0.6))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  geom_abline(slope=1, intercept=0, color= "blue")


Summary_database_canopy0123$Canopy_132 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                 levels = c("1", "3", "2"))

##Impact per canopy type during dry season.
Graph_RR3 = ggplot(Summary_database_canopy0123, aes (x=Canopy_132, y = Impact_2, color = Canopy_132)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in Effect size", subtitle = "During severe drought 2018-2019") +
  labs(y=quote(Delta* "  ES from wet 18 to strong dry season 19"), 
       x = "Canopy type (ordered by canopy density)") +
  scale_color_manual(values=c("seagreen3", "tomato3","paleturquoise4" ))+
  scale_y_continuous(expand = c(0,0), limits = c(0,40))+
  scale_x_discrete("Canopy type", labels = c("Palm", "No fix", " N Fix"))


Graph_RR3 + Graph_RR1 + Graph_RR2 



#Dif_bare ####

# Transform Database to calculate Impact and recovery rates -No Normalized###

Summary_database_no_norm<-The_Database %>%                                #No Normalized
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green, Dif_bare) %>%
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(Dif_bare, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Dif_bare_2W1 - Dif_bare_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = -(Dif_bare_3D2 - Dif_bare_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Dif_bare_4W2 - Dif_bare_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>% 
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123, -Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Temp_Logger, -Light_Intensity, -RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3)) %>% 
  filter_all(all_vars(!is.na(Date_peak_4W2)))


# Convert from wide to long table Database with Impacts and RR ###
Summary_database_longer <- Summary_database_no_norm %>% 
  pivot_longer(cols = (c("Dif_bare_1D1", "Dif_bare_2W1", "Dif_bare_3D2", "Dif_bare_4W2")),
               names_to = "Season",
               values_to= "Dif_bare",
               values_drop_na = TRUE)

Summary_database_longer_short <- Summary_database_longer %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot) %>% 
  filter(Canopy_0123 %in% c(1, 2, 3))  %>% 
  add_column(relat_abund_padd = c(0.45,0.45,0.45,0.45, 0.35,0.35,0.35,0.35, 0.2, 0.2, 0.2, 0.2),
             relat_abund_study = c(0.54,0.54,0.54,0.54, 0.37,0.37,0.37,0.37, 0.09,0.09,0.09,0.09),
             precip_mm = c (213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01),
             Evapotrans = c(5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45),
             temp = c(31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4)) %>%
  mutate (Comm_eff_padd= (Dif_bare * relat_abund_padd)) %>% 
  mutate (Comm_eff_study= (Dif_bare * relat_abund_study))

#Order seasons manually in long table Database with Impacts and RR
Summary_database_longer$Season_norm <- factor(Summary_database_longer$Season_norm,          # Change ordering manually
                                              levels = c("D1N", "W1N", "D2N", "W2N"))

#Shorten long table Database with Impacts and RR to only average per Canopy type
Summary_database_canopy0123 <- Summary_database_no_norm %>% 
  group_by(Canopy_0123) %>% 
  summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot)



#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(Summary_database_longer_short, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Bare soil ", subtitle = "Community facilitative effect") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))

#scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' )) 






#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Groups_var %>% 
  add_column(relat_abund_study = c (0.54,0.54,0.54,0.54, 0.37,0.37,0.37,0.37,0.09,0.09,0.09,0.09),
             precip_mm =c(150.27, 530.14, 431.01, 213.77, 150.27, 530.14, 431.01, 213.77, 150.27, 530.14, 431.01, 213.77)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(marginal_comm_eff, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Bare soil", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA 2
# Models with Bare, Season 1234 and Subset. ####

CE_Bare_6<-lmer(Comm_eff_bare~ Season_1234t +  Canopy_0123 +  
                   (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                 data= Filtered_database_123, )

anova(CE_Bare_6, test.statistic="F")
summary (CE_Bare_6)

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_Bare_6,~ Season_1234t + Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var


marginal_comm_eff_ind <- Groups_var %>% 
  add_column(precip_mm =c(150.27, 530.14, 431.01, 213.77, 150.27, 530.14, 431.01, 213.77, 150.27, 530.14, 431.01, 213.77))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Bare", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))




