# Database #####

#The_Database<- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                         sheet = "12x20")

The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20")

Filtered_database<-The_Database %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_grass_height) %>% 
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), Date_peak= as.factor(Date_peak), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Observer= as.factor(Observer), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123)) %>%
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Monitoring, Date_peak, Observer, Padd_unique, Paddock, FPPlot, Canopy_0123,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, Dif_Soil_moist, Dif_Soil_temp,  
                 Dif_Temp_above, Dif_Light_Intensity, 
                 Dep_var_RII, Dep_var_ave, Season_1234t, Comm_eff_height, precip_mm)
  group_by (Padd_unique) %>% 
  mutate(Dep_var_RII=ifelse(is.na(Dep_var_RII), mean(Dep_var_RII, na.rm =TRUE), Dep_var_RII))

# Filter database ####
Filtered_database_123 <- Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(1,2,3))

# Model ####
GH0<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 + Canopy_dens + DBH + 
            Tree_height + Dif_Soil_moist + Dif_Soil_temp + Dif_Temp_above + Dif_Light_Intensity +  
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)

GH0<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 + Canopy_dens + 
            Tree_height + Dif_Soil_temp +   
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)


GH1<-lmer(Dep_var_ave~ Season_1234t * Canopy_0123 +   #PAPER
            Tree_height +    
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)

anova(GH1, test.statistic="F")
summary (GH1)

write.csv(as.matrix(anova(GH1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_GH1.csv", na = "")
tab_model(GH1)

CE_GH1<-lmer(Comm_eff_height~ Season_1234t * Canopy_0123 +   #PAPER
            Tree_height +    
            Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
          data= Filtered_database_123)

anova(CE_GH1, test.statistic="F")
summary (CE_GH1)

write.csv(as.matrix(anova(CE_GH1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_CE_GH1.csv", na = "")
tab_model(CE_GH1)


# Ls Means ####
lsmeans (GH1, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(GH1,~ Season_1234t*Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 

Fac_eff_height<-Groups_var

write.csv(as.matrix(Fac_eff_height), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Grass_heght.csv", na = "")


marginal

pd = position_dodge(0.3)
ggplot(Groups_var, aes(x=Season_1234t, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  0.2, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass height difference under tree - open plot", subtitle = "in plots") +
  labs( x = "Seasons", 
        y = "Grass height difference ", 
        caption  = paste0("\nDifference in grass height in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

#Facilitative effect ordered by precipitation ####

marginal_ind_eff_height <- Fac_eff_height %>% 
  add_column(precip_mm =c( 213.77, 150.27, 213.77, 150.27, 431.01, 530.14, 150.27, 530.14, 213.77, 431.01, 431.01, 530.14))

ggplot(marginal_ind_eff_height, aes(x=Season_1234t, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 0.5, linetype = "dotted") +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  10, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Greeness under tree - open plot", subtitle = "in plots") +
  labs( x = "Precipitation (mm)", 
        y = "OE on grass height", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

# Summary of database for ggplot graph####

Summ_graph_long<- summarySE(Filtered_database, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season_1234t", "FPPlot"), 
                            na.rm = TRUE) %>% 
  filter(Canopy_0123 %in% c( 1, 2, 3))

Summ_graph<- Summ_graph_long%>% 
  group_by(Canopy_0123, Season_1234t) %>% 
  summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
 # geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("% Green grass", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  #scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
  #                   name = "Canopy type",
  #                   labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)+
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  







#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Groups_var %>% 
  add_column(relat_abund_study = c (0.37,0.37,0.37,0.54,0.54,0.37,0.54,0.54,0.09,0.09,0.09,0.09),
             precip_mm =c(213.77,530.14,150.27,213.77,530.14,431.01,150.27,431.01,213.77,530.14,150.27,431.01)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(marginal_comm_eff, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrubs", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA 2
# Models with Bare, Season 1234 and Subset. ####

CE_Shrubs_6<-lmer(Comm_eff_shrubs~ Season_1234t * Canopy_0123 + Canopy_dens + 
                    Tree_height + Dif_Soil_temp +   
                    Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                  data= Filtered_database_123)

anova(CE_Shrubs_6, test.statistic="F")
summary (CE_Shrubs_6)

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_Shrubs_6,~ Season_1234t + Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var


marginal_comm_eff_ind <- Groups_var %>% 
  add_column(precip_mm =c(213.77, 530.14, 150.27, 431.01, 213.77, 530.14, 150.27, 431.01, 213.77, 530.14, 150.27, 431.01 ))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Shrubs", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Groups_var %>% 
  add_column(relat_abund_study = c (0.09, 0.37, 0.09, 0.37, 0.54, 0.54, 0.37, 0.09, 0.09,0.37, 0.54, 0.54 ),
             precip_mm =c(213.77, 213.77,150.27,150.27, 213.77, 150.27, 431.01, 431.01, 530.14, 530.14, 431.01,530.14)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(marginal_comm_eff, aes(y=precip_mm, x=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass height", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA 2
# Models with height, Season 1234 and Subset. ####

CE_height_6<-lmer(Comm_eff_height~ Season_1234t * Canopy_0123 + Canopy_dens + 
                    Tree_height + Dif_Soil_temp +   
                    Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                  data= Filtered_database_123)

#PAPER
CE_height_6<-lmer(Comm_eff_height~ Season_1234t * Canopy_0123 + 
                    Tree_height + Dif_Soil_temp +   
                    Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                  data= Filtered_database_123)

CE_height_7<-lmer(Comm_eff_height~  Canopy_0123 + precip_mm +  
                   (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp) , REML= F, 
                 data= Filtered_database_123)

anova(CE_height_6, test.statistic="F")
summary (CE_height_6)

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_height_6,~ Season_1234t + Canopy_0123, adjust = "Tukey")

Groups_var_height=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var_height


marginal_comm_eff_ind_height <- Groups_var_height %>% 
  add_column(precip_mm =c( 213.77, 150.27, 530.14, 150.27, 213.77, 431.01 ,431.01, 530.14, 150.27, 213.77, 431.01, 530.14 ))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind_height, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass height", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))




