# Library packages ####
if(!require(easypackages)) install.packages("easypackages")

easypackages::packages(c("tidyverse", "patchwork", "rayshader", 
                         "ggthemes", "gganimate", "manipulate", "plotly", 
                         "quantreg", "dslabs", "Hmisc", "nycflights13",
                         "stringr", "dplyr", "ggplot2", "sjPlot"))

##packages
packages<-c("psych", "lsmeans", "MASS", "nlme", "aod", "betareg", "pbkrtest", "lmerTest", 
            "multcomp", "ggpubr", "readxl", "ggplot2", "Rmisc")

require(packages)
lapply(packages, require,character.only = TRUE)

install.packages("xlsx")

# Database #####

#The_Database<- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                         sheet = "12x20")

The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                         sheet = "12x20")
                          
str(The_Database)

Filtered_database<-The_Database %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_green) %>%  
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), Date_peak= as.factor(Date_peak), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Observer= as.factor(Observer), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123)) %>% 
  dplyr::select (Plot_ID, Plot, Farm,Paddock, FPPlot, Padd_unique, Canopy_0123, Paddock_TreeCover, Season, Season_1234,Season_1234t, Monitoring, Date_peak, precip_mm,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, Dif_Soil_moist, Dif_Soil_temp,  
                 Dif_Temp_above, Dif_Light_Intensity, 
                 Dep_var_ave, Dif_shrubs, Dif_bare, Grass_height,Bare_corr, Shrubs_corr,
                 Comm_eff_green, Comm_eff_shrubs, Comm_eff_bare) 
  group_by (Padd_unique) %>% 
  dplyr::mutate(Dep_var_RII=ifelse(is.na(Dep_var_RII), mean(Dep_var_RII, na.rm =TRUE), Dep_var_RII))
  
# Filter database ####
Filtered_database_123 <- Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(1,2, 3))
  
Summ_filt_database_123<-Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(0,1,2, 3)) %>% 
  dplyr::select(Canopy_0123, Season,Dep_var_ave, Grass_height, Bare_corr, Shrubs_corr) %>% 
    group_by(Canopy_0123, Season ) %>% 
    summarise_all(funs(mean), na.rm =TRUE)
  

#Write table in excel file
#write_csv(Summ_graph_long, path = "M:/My Documents/PhD WUR session/Field/Summ_graph_long.csv")



# checking for random effects RII ####
# LMER Linear Mixed Models. Normality on residuals =Yes.  #

MA0<-lmer(Dep_var_RII~ (1|Farm/Padd_unique/Plot_ID), REML= T, data= Filtered_database) 
MA1<-lmer(Dep_var_RII~ (1|Farm/Padd_unique), REML= T, data= Filtered_database)
MA2<-lmer(Dep_var_RII~ (1|Farm/Plot_ID), REML= T, data= Filtered_database) 
MA3<-lmer(Dep_var_RII~ (1|Padd_unique/Plot_ID), REML= T, data= Filtered_database)
MA4<-lmer(Dep_var_RII~ (1|Plot_ID), REML= T, data= Filtered_database) 


MA5<-lmer(Dep_var_RII~ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= T, data= Filtered_database) #BEST ONE PAULINA!!!
MA6<-lmer(Dep_var_RII~ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp) + (1|Monitoring), REML= T, data= Filtered_database) 

summary (MA6)
summary (MA5)

anova (MA0, MA5)

# checking for random effects Dif_green ####
# LMER Linear Mixed Models. Normality on residuals =Yes.  #

MA0<-lmer(Dif_green~ (1|Farm/Padd_unique/Plot_ID), REML= T, data= Filtered_database) 
MA1<-lmer(Dif_green~ (1|Farm/Padd_unique), REML= T, data= Filtered_database)
MA2<-lmer(Dif_green~ (1|Farm/Plot_ID), REML= T, data= Filtered_database) 
MA3<-lmer(Dif_green~ (1|Padd_unique/Plot_ID), REML= T, data= Filtered_database)
MA4<-lmer(Dif_green~ (1|Plot_ID), REML= T, data= Filtered_database) 


MA5<-lmer(Dif_green~ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= T, data= Filtered_database) #BEST ONE PAULINA-Ivan!!!
MA6<-lmer(Dif_green~ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp) + (1|Monitoring), REML= T, data= Filtered_database) 

summary (MA0)
summary (MA5)

anova (MA0, MA5)

# Models with RII,       Season 1234 and Subset. ####

G5<-lmer(Dep_var_RII~ Season_1234t + Canopy_0123 + Canopy_dens + DBH + 
           Tree_height + Dif_Soil_moist + Dif_Soil_temp Dif_Temp_above + Dif_Light_Intensity + 
           Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

#With season
G6<-lmer(Dep_var_RII~ Season_1234t * Canopy_0123 + Canopy_dens +  
           (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

#With only Canopy
G6<-lmer(Dep_var_RII~ Canopy_0123 + Canopy_dens +  
           (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

G6_glm<-glm(Dep_var_RII~ Canopy_0123, 
         data= Filtered_database_123)


anova(G6, test.statistic="F")
anova(G6_glm, test.statistic = "F")
#, test.statistic="F")


lsmeans (G6_glm, pairwise~ Canopy_0123, adjust="Tukey") 

summary (G6)
summary (G6_glm)
# Models with Dif_green, Season 1234 and Subset. ####

G5<-lmer(Dep_var_ave~ Season_1234t + Canopy_0123 + Canopy_dens + DBH + 
           Tree_height + Dif_Soil_moist + Dif_Soil_temp + Dif_Temp_above + Dif_Light_Intensity +  
           Canopy_diameter+ (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

G7<-lmer(Dep_var_ave~  Season_1234t * Canopy_0123 + Canopy_dens +  ##PAPER Greenness dif indiv
           Dif_Light_Intensity +  
           (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
         data= Filtered_database_123)

anova(G7, test.statistic="F")
summary (G7)


write.csv(as.matrix(anova(G7)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_G7.csv", na = "")
tab_model(G7)

The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20")


CE_Green_7<-lmer(Comm_eff_green~ Season_1234t * Canopy_0123 + Canopy_dens +  ##PAPER Greenness dif indiv
                   Dif_Light_Intensity +  
                   (1|Farm/Padd_unique/Plot_ID)+ (1|Tree_spp), REML= F, 
                 data= Filtered_database_123)


write.csv(as.matrix(anova(CE_Green_7)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_CE_Green_7.csv", na = "")
tab_model(CE_Green_7)


# Ls Means ####
lsmeans (G6, pairwise~ Season_1234t*Canopy_0123, adjust="Tukey")

# Descriptive #####
describeBy(Filtered_database$Dep_var_ave, group=Filtered_database$Season_1234t:Filtered_database$Canopy_0123)
# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(G7,~ Season_1234t*Canopy_0123, adjust = "Tukey")

Groups_var=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
marginal

Fac_eff_green<-Groups_var

write.csv(as.matrix(Fac_eff_green), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Grass_green.csv", na = "")



pd = position_dodge(0.3)
ggplot(Groups_var, aes(x=Season_1234t, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  0.2, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Greeness under tree - open plot", subtitle = "in plots") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

#Facilitative effect ordered by precipitation ####

marginal_ind_eff_green <- Fac_eff_green %>% 
  add_column(precip_mm =c(530.14, 213.77, 431.01,431.01, 213.77,530.14,  431.01, 530.14, 150.27, 213.77, 150.27, 150.27))

ggplot(marginal_ind_eff_green, aes(x=precip_mm, y=Greenness, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 0.5, linetype = "dotted") +
  #geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  10, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Greeness under tree - open plot", subtitle = "in plots") +
  labs( x = "Precipitation (mm)", 
        y = "OE on grass greenness", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7)

# Summary of database for ggplot graph####

Summ_graph_long<- summarySE(Filtered_database, measurevar = "Dep_var_ave", groupvars= c("Canopy_0123", "Season"), 
                            na.rm = TRUE) %>% 
  dplyr::filter(Canopy_0123 %in% c( 0, 1, 2, 3))

Summ_graph<- Summ_graph_long%>% 
  dplyr::group_by(Canopy_0123, Season_1234t) %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE)

pd = position_dodge(0)

ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("% Green grass", subtitle = "in plots") +
  labs( x = "Season", 
        y = "Grass greenness (%)", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3 ", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "NF", "NNF")) +
    scale_x_discrete(labels = c('Dry 2018','Wet 2018','Dry 2019','Wet 2019' ))  

# Transform Database to calculate Impact and recovery rates -No Normalized####
#USADA PAPER YESS!·#
rm(Summary_database_no_norm)

Summary_database_no_norm<-The_Database %>%                                #No Normalized but individually normalized for impact and rec rates
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>%
  dplyr::filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  dplyr::group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  tidyr::pivot_wider(names_from = Season_1234t, 
              values_from = c(Green, Date_peak))  %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Green_2W1 - Green_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = -(Green_3D2 - Green_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Green_4W2 - Green_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  mutate (Green_2W1_ind_norm = Green_2W1/Green_2W1 * 100,
          Green_3D2_ind_norm = Green_3D2/Green_2W1 * 100) %>% 
  mutate (Impact_ind_norm = Green_2W1_ind_norm - Green_3D2_ind_norm) %>% 
    #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Light_Intensity, -RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs)  
  dplyr::filter(Canopy_0123 %in% c(0, 1, 2, 3)) %>% 
  dplyr::filter_all(all_vars(!is.na(Date_peak_4W2)))

Summary_database_no_norm<-The_Database %>%                                #No Normalized but individually normalized for impact and rec rates
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>%
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  dplyr::group_by(Canopy_0123, Padd_unique, FPPlot, Tree_spp) %>% 
  tidyr::pivot_wider(names_from = Season_1234t, 
              values_from = c(Green, Date_peak))  %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Green_2W1 - Green_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = -(Green_3D2 - Green_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Green_4W2 - Green_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2, RR2=Impact_3/X3s) %>%
  mutate (Green_2W1_ind_norm = Green_2W1/Green_2W1 * 100,
          Green_3D2_ind_norm = Green_3D2/Green_2W1 * 100) %>% 
  mutate (Impact_ind_norm = Green_2W1_ind_norm - Green_3D2_ind_norm) %>% 
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, -Farm, -Season, -Season_1234, -Monitoring, Padd_unique, -Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath, RII_Temp_Logg, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3)) %>% 
  dplyr::filter_all(all_vars(!is.na(Date_peak_4W2)))

# Transform Database to calculate Impact and recovery rates -Normalized to Wet 1####

Summary_database<-The_Database %>%                                #Normalized to the baseline pre-disturbance
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>%
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(Green, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (((Green_2W1 - Green_1D1)/Green_2W1)*100), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = ((-(Green_3D2 - Green_2W1)/Green_2W1)*100), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (((Green_4W2 - Green_3D2)/Green_2W1)*100), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  mutate(D1N = Green_1D1 *100/Green_2W1 , W1N = Green_2W1*100/Green_2W1, 
         D2N =Green_3D2 *100/Green_2W1, W2N= Green_4W2*100/Green_2W1) %>% 
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, -Padd_unique, Paddock, FPPlot, Canopy_0123, -Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Temp_Logger, -Light_Intensity, -RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs, D1N, W1N, D2N, W2N) %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3)) %>% 
  filter_all(all_vars(!is.na(Date_peak_4W2)))

#Shorten long table Database with RR to only average per Canopy type
Summary_database_canopy0123 <- Summary_database_no_norm %>% 
  group_by(Canopy_0123) %>% 
  summarise_all(funs(mean), na.rm =TRUE) 



# Convert from wide to long table Database with RR ####

Summary_database_canopy0123 <- Summary_database_no_norm %>% 
    group_by(Canopy_0123) %>% 
    summarise_all(funs(mean), na.rm =TRUE)  %>% 
    dplyr::select(-FPPlot) %>% 
    filter(Canopy_0123 %in% c(0, 1, 2, 3)) 

    #mutate(RR1_RR2 = RR1/RR2, RR2_RR1 = RR2/RR1) %>% 
    #mutate (Green_2W1_norm = Green_2W1/Green_2W1 * 100,
    #        Green_3D2_norm = Green_3D2/Green_2W1 * 100) %>% 
    #mutate (Impact_norm = Green_2W1_norm - Green_3D2_norm)

clean_data_df_long <- clean_data_df %>%
  rename (acacia_1 = JH1MY1SS01, acacia_2 = JH1MY1SS02, acacia_3 = JH1MY1SS03, 
          acacia_4 = JH1MY1SS04 , acacia_5 = JH1MY1SS05, 
          bulk_1 = JH1MY1SS06 , bulk_2=JH1MY1SS07 , bulk_3= JH1MY1SS08, bulk_4=JH1MY1SS09  , bulk_5= JH1MY1SS10 , 
          grass_1=JH1MY1SS11 , grass_2=JH1MY1SS12 , grass_3=JH1MY1SS13 , grass_4=JH1MY1SS14 , grass_5=JH1MY1SS15,
          palm_1=JH1MY1SS16, palm_2=JH1MY1SS17 , palm_3=JH1MY1SS18 , palm_4=JH1MY1SS19 , palm_5=JH1MY1SS20) %>% 
    pivot_longer(cols = (c("acacia_1", "acacia_2", "acacia_3", "acacia_4", "acacia_5",
                           "bulk_1", "bulk_2", "bulk_3", "bulk_4", "bulk_5",
                           "grass_1", "grass_2", "grass_3", "grass_4", "grass_5",
                           "palm_1", "palm_2", "palm_3", "palm_4", "palm_5")),
               names_to = "Sample",
               values_to= "Counts",
               values_drop_na = TRUE)  
  
#Order seasons manually in long table Database with Impacts and RR
Summary_database_longer$Season_norm <- factor(Summary_database_longer$Season_norm,          # Change ordering manually
                                              levels = c("D1N", "W1N", "D2N", "W2N"))



# Model Impacts or RRs with Canopy type####
M_RR1<-lmer(Drop1 ~ Canopy_0123 + Canopy_dens + Canopy_diameter  + (1|Farm) , REML= T, 
            data= Summary_database)

anova(M_RR1, test.statistic="F")
summary (G6)

y tam#G3<-lmer(Dep_var_ave~ Season + Canopy_0123 + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) 
+ Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + Tree_height + RII_Soil_temp
+ RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + Canopy_diameter, REML= F, 
data= Filtered_database_123) 


##Create summart table of long table= Same as previous table? Compare
Data_seas<- summarySE(Summary_database_longer, measurevar = "Green_norm", groupvars= c("Canopy_0123", "Season_norm"), 
                      na.rm = TRUE)  %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3))

pd = position_dodge(0.0)

#Graph Impact
ggplot(Data_seas, aes(x=Season_norm, y=Green_norm, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "% Green normalized ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  

# Calculate RRs for sepparate season pairs ####
Summary_database_RR1<-Summary_database_no_norm  %>%
dplyr::select(Canopy_0123, Green_2W1, Green_1D1) %>% 
  pivot_longer (c (Green_1D1, Green_2W1), 
                names_to = "Season",
                values_to= "Values") %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)


Summary_database_RR2<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_2W1) %>% 
  pivot_longer (c (Green_2W1, Green_3D2), 
                names_to = "Season",
                values_to= "Values")  %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

Summary_database_RR2$Season <- factor(Summary_database_RR2$Season, levels = c("W1N", "D2N"))

Summary_database_RR3<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_4W2) %>% 
  mutate(GreenDry2=(Green_3D2*100)/Green_4W2, GreenWet2 = (Green_4W2*100/Green_4W2)) 
pivot_longer (c (GreenDry2, GreenWet2), 
              names_to = "Season",
              values_to= "Values")  %>% 
  #group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

# Graph single RRs or drop lines####
#1
Ind_RR1=ggplot(Summary_database_no_norm, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))   

#2

Ind_RR2=ggplot(Summary_database_RR2, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Wet 2018 (90%)','Dry 2019 (72%)')) 


#3
Ind_RR3=ggplot(Summary_database_RR3, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2019 (72%)', 'Wet 2019 (90%)'))  

Ind_RR1 + Ind_RR2 + Ind_RR3
# My three graphs with the three impacts and the three recovery rates. ####


Reco_rate_sum<- read_excel("C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Recovery_rates.xlsx", 
                           sheet = "Recov_rat_sum")

Reco_rate_sum<-Reco_rate_sum %>% mutate (Canopy_0123= as.factor(Canopy_0123))

Graph_1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_1, y = RR1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("2018", subtitle = "") +
  
  labs( x = "Impact 2018", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_2 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = Drop1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Wet 2018- Dry2019", subtitle = "") +
  
  labs( x = "Impact wet 2018- dry2019", 
        y = "Drop rate", hjust=0.9) +
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_3 <- ggplot(Summary_database_canopy0123, aes (x = Impact_3, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dry 2019 - Wet 2019", subtitle = "") +
  
  labs( x = "Impact 2019", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_1 + Graph_2 + Graph_3
# Milena's suggested graphs ####
#Specific resilience graphs

#### Graph RR1_RR2

Graph_RR4 <- ggplot(Summary_database_canopy0123, aes (x = Canopy_0132, y = RR2_RR1, color = Canopy_0132)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Recovery rates after drought", subtitle = "2018 and 2019") +
    labs( x = "Canopy type", 
        y = "RR2/RR1", hjust=0.9) +
  scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "No N Fix", "N fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_hline(yintercept = 1, color="blue", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete("Canopy type", labels = c( "Open", "Palm", "No N Fix", "N fix"))



#### Graph RR1_RR2 scattered


Graph_RR5<- ggplot(Summary_database_longer, aes (x = Rec_rate, y = RRs, color = Canopy_0123 )) +
  geom_point(size = 3) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Recovery rates ", subtitle = "after drought2018 and 2019") +
  labs( x = "Canopy type", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "No N Fix", "N fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete("Drought", labels = c( "Average 2018", "Severe 2019"))

pd = position_dodge(.2)

ggplot(RR1_RR2_SE_longer, aes (x = Rec_rate, y = RR_values, color = Canopy_0123 )) +
  geom_point(size = 4, position = pd) +
  geom_errorbar(aes(ymin=RR_values-SE_values, ymax=RR_values+SE_values, color=Canopy_0123), width=.1, size = 0.5, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Recovery rates ", subtitle = "after drought2018 and 2019") +
  labs( x = "Canopy type", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4"),
                     name = "Drought",
                     labels=c("Open", "Palm", "No N Fix", "N fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete("Drought", labels = c( "Average 2018", "Severe 2019"))

Graph_RR5_SE<- 




Graph_RR3 + Graph_RR5

####Impact severe drought and recovery after severe drought

Graph_RR1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Impact sever drought and recovery after drop", subtitle = "Drop from wet 2018 to Dry 2019. Recovery 2019") +
  
  labs( x = "Impact (Drop of % Grass greeness from Wet 2018 to Dry 2019)", 
        y = "Recovery Rate after drop", hjust=0.9) +
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7)  

##### Recovery rate after dry season 2018 and after dry season 2019
Graph_RR2 = ggplot(Summary_database_canopy0123, aes (x = RR1, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Recovery rates 2018 and 2019", subtitle = "Drop from wet 2018 to Dry 2019. Recovery 2019") +
  
  labs( x = "Recovery Rate 2018", 
        y = "Recovery Rate 2019", hjust=0.9) +
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(0,0.5))+
  scale_y_continuous(expand = c(0,0), limits = c(-.10,0.5))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  geom_abline(slope=1, intercept=0, color= "blue")


Summary_database_canopy0123$Canopy_0123 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                  levels = c("0", "1", "2", "3"))
Summary_database_canopy0123$Canopy_1320 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                  levels = c("1", "3", "2", "0"))
Summary_database_canopy0123$Canopy_1203 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                  levels = c("1", "2", "0", "3"))
Summary_database_canopy0123$Canopy_0132 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                  levels = c("0", "1", "3", "2"))

##Impact per canopy type during severe drought.

Impact_ind_norm_SE<- summarySE(Summary_database_no_norm, measurevar = "Impact_ind_norm", groupvars= c("Canopy_0123"), na.rm = TRUE) %>%
  filter(Canopy_0123 %in% c( 0, 1, 2, 3))

Impact_ind_norm_SE$Canopy_0132 <- factor(Impact_ind_norm_SE$Canopy_0123,                                                      # Change ordering manually
                                         levels = c("0", "1", "3", "2"))
#Impact individually normalized
Graph_RR3 = ggplot(Impact_ind_norm_SE, aes (x=Canopy_0132, y = Impact_ind_norm, color = Canopy_0132)) +
  geom_point(size = 6) +
  #geom_errorbar(aes(ymin=Impact_ind_norm-se, ymax=Impact_ind_norm+se, color=Canopy_0132), width=.1, size = 0.5,) +
    theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none") +
  ggtitle ("Impact", subtitle = "during severe drought (Wet 18 to Dry 19)") +
    labs( x = "Canopy type (ordered by canopy density)", 
        y = "Impact on grass greenness", hjust=0.9) +
  scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4")) +
  scale_x_discrete("Canopy type", labels = c( "Open", "Palm", "No N Fix", "N fix"))  +
  scale_y_continuous(expand = c(0,0), limits = c(0,100))

Graph_RR1 + Graph_RR2 + Graph_RR3

Graph_RR3 + Graph_RR5 #THESE ARE GRAPHS OF POWERPOINT OF IMPACT AND RECOVERY RATE

# Model for Resilience and canopy density (which one is this? Repeated?) ####
#MODEL for RESILIENCE -  CANOPY DENS 

#Resilience_database <-The_Database %>% 
mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
        Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
        Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
        Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>% 
  #filter(Canopy_0123 %in% c(1, 2, 3))  %>% 
  group_by(Plot_ID, Canopy_0123, Tree_spp, Farm, Padd_unique, Plot) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(Green, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Green_2W1 - Green_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = (Green_3D2 - Green_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Green_4W2 - Green_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  group_by(Plot_ID, Canopy_0123, Tree_spp, Farm, Padd_unique, Plot) %>% 
  summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Season, -Season_1234, -Monitoring, -Paddock, -FPPlot, Canopy_0123, 
                 Canopy_diameter, DBH, Tree_height, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, -Temp_Logger, -Light_Intensity, RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs) %>% 
  #filter(Canopy_0123 %in% c(1, 2, 3)) %>% 
  drop_na(Green_2W1)


Resilience_database<- read_csv("M:/My Documents/PhD WUR session/Field/Resilience_database.csv")

RE1<-lmer(RR1~ Canopy_0123 + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) 
          + Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + Tree_height + RII_Soil_moist + RII_Soil_temp
          + RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + Canopy_diameter, REML= F, 
          data= Resilience_database)
RE2<-lmer(Dep_var_RII~ Season_1234t * Canopy_0123 + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) + Canopy_dens, REML= F, 
          data= Resilience_database)

anova(G6, test.statistic="F")
summary (G6)



#Graph Impact raw data & models
describeBy(Summary_database_no_norm$Impact_2, group=Summary_database_no_norm$Canopy_0123)

Impact_SE<- summarySE(Summary_database_no_norm, measurevar = "Impact_2", groupvars= c("Canopy_0123"), na.rm = TRUE) %>%
  filter(Canopy_0123 %in% c( 0, 1, 2, 3))

Impact_SE$Canopy_0132 <- factor(Impact_SE$Canopy_0123,                                                      # Change ordering manually
                                levels = c("0", "1", "3", "2"))


ggplot(Impact_SE, aes (x=Canopy_0123, y = Impact_2, color = Canopy_0123)) +
  geom_point(size = 4) +
  #geom_errorbar(aes(ymin=lsmean-SE, ymax=lsmean+SE, color=Canopy_0132), width=.1, size = 0.5,) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none") +
  ggtitle ("Impact", subtitle = "during severe drought (Wet 18 to Dry 19)") +
  labs( x = "Canopy type (ordered by canopy density)", 
        y = "Impact on grass greenness", hjust=0.9) +
scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4")) +
scale_x_discrete("Canopy type", labels = c( "Open", "Palm", "No N Fix", "N fix"))+  
scale_y_continuous(expand = c(0,0), limits = c(0,100))




#GRAPHS Y TABLAS PAPER

Impact_M3<-lmer(Impact_2~ Canopy_0123 +   (1|Padd_unique/FPPlot) + (1|Tree_spp), REML= F, 
                data= Summary_database_no_norm)
#USADA PAPER

Impact_M2<-lmer(Impact_2~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F, #########MODEL PAPER IMPACT 
                data= Summary_database_no_norm)
#rm(Impact_M2)
tab_model(Impact_M2)

anova(Impact_M2, test.statistic="F")
summary(Impact_M)

write.csv(as.matrix(anova(Impact_M2)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_Impact_M2.csv", na = "")

tab_model(Impact_M2)




emmeans (Impact_M2, pairwise~ Canopy_0123, adjust="Tukey") 

marginal_Impact <- emmeans(Impact_M2,~ Canopy_0123, adjust = "Tukey")

Groups_var_Impact=cld(marginal_Impact, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var_Impact$Canopy_0132 <- factor(Groups_var_Impact$Canopy_0123,                                                      # Change ordering manually
                                         levels = c("0", "1", "3", "2"))

Graph_6 <- ggplot(Groups_var_Impact, aes (x=Canopy_0123, y = emmean, color = Canopy_0132)) +
  geom_point(size = 2) +
  geom_errorbar(aes(ymin=emmean-SE, ymax=emmean+SE, color=Canopy_0123), width=.05, size = 0.5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none") +
  ggtitle ("Impact", subtitle = "during severe drought") +
  labs( x = "Canopy type (ordered by canopy density)", 
        y = "Impact (%)", hjust=0.9)+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "tomato3", "paleturquoise4")) +
  scale_x_discrete("Canopy type", labels = c( "Open", "Palm", "No N Fix", "N fix"))+  
  scale_y_continuous(expand = c(0,0), limits = c(0,100))

  Graph_6 + Graph_RR5 

 #Models recovery resilience AND Impact
  
  describeBy(Summary_database_no_norm$RR1, group=Summary_database_no_norm$Canopy_0123)
  
  
RecovRate_M2<-lmer(RR2~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F,   #########MODEL PAPER RECOVERY RATE 1 
                  data= Summary_database_no_norm)

tab_model(RecovRate_M2)

anova(RecovRate_M2)
write.csv(as.matrix(anova(RecovRate_M2)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_RecovRate_M2.csv", na = "")
tab_model(RecovRate_M2)

summary (RecovRate_M2)
emmeans (RecovRate_M2, pairwise~ Canopy_0123, adjust="Tukey") 
marginal_RecovRate2 <- emmeans(RecovRate_M2,~ Canopy_0123, adjust = "Tukey")
marginal_RecovRate2
marginal_RecovRate2_table<- as.data.frame(marginal_RecovRate2)
marginal_RecovRate2_table$Canopy_0132 <- factor(marginal_RecovRate2_table$Canopy_0123,                                                      # Change ordering manually
                                                levels = c("0", "1", "3", "2"))
Groups_var_RecovRate2=cld(marginal_RecovRate2, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                    adjust="Tukey") 
Groups_var_RecovRate2
Groups_var_RecovRate2$Canopy_0132 <- factor(Groups_var_RecovRate2$Canopy_0123,                                                      # Change ordering manually
                                          levels = c("0", "1", "3", "2"))
  

RecovRate_M1<-lmer(RR1~ Canopy_0123 + (1|Farm/Paddock/FPPlot), REML= F, #########MODEL PAPER RECOVERY RATE 1 
                   data= Summary_database_no_norm)
tab_model (RecovRate_M1)
anova(RecovRate_M1)
summary (RecovRate_M1)

write.csv(as.matrix(anova(RecovRate_M1)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/anova_RecovRate_M1.csv", na = "")
tab_model(RecovRate_M1)


emmeans (RecovRate_M1, pairwise~ Canopy_0123, adjust="Tukey") 
marginal_RecovRate1 <- emmeans(RecovRate_M1,~ Canopy_0123, adjust = "Tukey")
marginal_RecovRate1
marginal_RecovRate1_table<- as.data.frame(marginal_RecovRate1)
marginal_RecovRate1_table$Canopy_0132 <- factor(marginal_RecovRate1_table$Canopy_0123,                                                      # Change ordering manually
                                            levels = c("0", "1", "3", "2"))

Groups_var_RecovRate1=cld(marginal_RecovRate1, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                          adjust="Tukey") 
Groups_var_RecovRate1
Groups_var_RecovRate1$Canopy_0132 <- factor(Groups_var_RecovRate1$Canopy_0123,                                                      # Change ordering manually
                                            levels = c("0", "1", "3", "2"))

RR1_RR2_SE<-dplyr::full_join(marginal_RecovRate1_table, marginal_RecovRate2_table, by = "Canopy_0123")

RR1_RR2_SE_longer <- RR1_RR2_SE %>% 
  tidyr::pivot_longer(cols = (c("emmean.x", "emmean.y")),
               names_to = "Rec_rate",
               values_to= "RR_values",
               values_drop_na = TRUE) %>% 
  tidyr::pivot_longer(cols = (c("SE.x", "SE.y")),
               names_to = "SE",
               values_to= "SE_values",
               values_drop_na = TRUE)  %>% 
  dplyr::filter(Rec_rate == c("emmean.x", "emmean.y") & SE == c("SE.x", "SE.y"))

pd=position_dodge(0.4)

Graph_RR5 = ggplot(RR1_RR2_SE_longer, aes (x=Rec_rate, y = RR_values, color = Canopy_0123)) +
    geom_point(size = 2, position = pd ) +
    geom_errorbar(aes(ymin=RR_values-SE_values, ymax=RR_values+SE_values, color=Canopy_0123), width=.1, size = 0.5, position = pd) +
    theme_classic() +
    theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
          plot.caption = element_text(hjust = 0)) +
    #theme(legend.position="none") +
    ggtitle ("Recovery rate", subtitle = "after droughts") +
    labs( x = "Droughts", y = expression(paste("Recovery rate (% day"^-1, ")"))) + 
    scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3" ),
                       name = "Canopy type",
                       labels=c("Open", "Palm","NF",  "NNF")) +
  
    scale_x_discrete("Droughts", labels = c( "Average 2018", "Severe 2019"))+ 
    geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
    scale_y_continuous(expand = c(0,0), limits = c(-0.10,0.25))
  
  Graph_6 + Graph_RR5   
  
  
  



# Open Plots #### 

#Graph grass greeness for open plots - diff canopy types

Summ_graph<- summarySE(Filtered_database, measurevar = "Dep_var_ave", groupvars= c("Canopy_open", "Season_1234t"), 
                       na.rm = TRUE) %>% 
  filter(Canopy_open %in% c(1, 2, 3))


ggplot(Summ_graph, aes(x=Season_1234t, y=Dep_var_ave, color = Canopy_open) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_open), size = 1, linetype= "dashed") +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_open), width=.2, size = 0.5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass ", subtitle = "in open plots") +
  labs( x = "Season", 
        y = "% Grass greeness", 
        caption  = paste0("\n% Green grass in open plots for the three canopy types. ",
                          "Points indicate the means. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm open", "N fix open", "No N Fix open")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' )) 

#Model
G6O<-lmer(Dep_var_ave~ Season_1234t * Canopy_open + (1|Farm/Padd_unique) + (1|Plot/Plot_ID) + Canopy_dens, REML= F, 
          data= Filtered_database_123)

G6<-lmer(Dep_var_ave~ Season_1234t * Canopy_open + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) + Canopy_dens, REML= F, 
         data= Filtered_database)

anova(G6O, test.statistic="F")
summary (G6)

anova(G6, test.statistic="F")
summary (G6)

#Resilience open


Summary_database<-The_Database %>% 
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Canopy_open= as.factor(Canopy_open), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_open,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>%
  filter(Canopy_open %in% c(1, 2, 3))  %>% 
  group_by(Canopy_open) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(Green, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (((Green_2W1 - Green_1D1)/Green_2W1)*100), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = (((Green_3D2 - Green_2W1)/Green_2W1)*100), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (((Green_4W2 - Green_3D2)/Green_4W2)*100), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  group_by(Canopy_open) %>% 
  summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, -Farm, -Season, -Season_1234, -Monitoring, -Padd_unique, -Paddock, -FPPlot, Canopy_open, -Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Temp_Logger, -Light_Intensity, -RII_Light_Intensity, 
                 RII_Green, -RII_Bare, -RII_Shrubs) %>% 
  filter(Canopy_open %in% c(1, 2, 3))

Summary_database_RR1<-Summary_database %>%
  dplyr::select(Canopy_open, Green_2W1, Green_1D1) %>% 
  mutate(GreenWet1=(Green_2W1/Green_2W1)*100, GreenDry1 = (Green_1D1*100)/Green_2W1) %>% 
  pivot_longer (c (GreenDry1, GreenWet1), 
                names_to = "Season",
                values_to= "Values")

Summary_database_RR2<-Summary_database %>%
  dplyr::select(Canopy_open, Green_3D2, Green_2W1) %>% 
  mutate(GreenWet1=(Green_2W1/Green_2W1)*100, GreenDry2 = (Green_3D2*100)/Green_2W1) %>% 
  pivot_longer (c (GreenWet1, GreenDry2), 
                names_to = "Season",
                values_to= "Values")

Summary_database_RR2$Season <- factor(Summary_database_RR2$Season, levels = c("GreenWet1", "GreenDry2"))

Summary_database_RR3<-Summary_database %>%
  dplyr::select(Canopy_open, Green_3D2, Green_4W2) %>% 
  mutate(GreenWet2=(Green_4W2*100)/Green_4W2, GreenDry2 = (Green_3D2/Green_4W2)*100) %>% 
  pivot_longer (c (GreenWet2, GreenDry2), 
                names_to = "Season",
                values_to= "Values")

#Graph single RRs or drop
#1
Ind_RR1=ggplot(Summary_database_RR1, aes(x=Season, y=Values, color = Canopy_open) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_open), size = 1, linetype="dashed") +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_open), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))   

#2

Ind_RR2=ggplot(Summary_database_RR2, aes(x=Season, y=Values, color = Canopy_open) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_open), size = 1, linetype="dashed") +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_open), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Wet 2018 (90%)','Dry 2019 (72%)')) 


#3
Ind_RR3=ggplot(Summary_database_RR3, aes(x=Season, y=Values, color = Canopy_open) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_open), size = 1, linetype="dashed") +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_open), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2019 (72%)', 'Wet 2019 (90%)'))  

Ind_RR1 + Ind_RR2 + Ind_RR3

##The 3 graphs points resilience recovery and recovery rate

Graph_RR1 <- ggplot(Summary_database, aes (x = Impact_1, y = RR1, color = Canopy_open)) +
  geom_point(size = 5, alpha = 0.5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Recovery rate 1", subtitle = "Dry 2018 to Wet 2018 (77% to 90% RH)") +
  
  labs( x = "Impact", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7)  

Graph_RR2 = ggplot(Summary_database, aes (x = Impact_2, y = Drop1, color = Canopy_open)) +
  geom_point(size = 5, alpha = 0.5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Drop ", subtitle = "Wet 2018 to Dry 2019 (90% to 72% RH)") +
  
  labs( x = "Impact", 
        y = "Drop rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7)  

Graph_RR3 = ggplot(Summary_database, aes (x = Impact_3, y = RR2, color = Canopy_open)) +
  geom_point(size = 5, alpha = 0.5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme()+
  ggtitle ("Recovery rate 2", subtitle = "Dry 2019 to Wet 2019  (72% to 83% RH)") +
  
  labs( x = "Impact", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm open", "N fix open", "No N Fix open")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7)

Graph_RR1 + Graph_RR2 + Graph_RR3
#RR RRI ####

# Transform Database to calculate Impact and recovery rates -No Normalized###

Summary_database_no_norm<-The_Database %>%                                #No Normalized
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Temp_Logger, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green) %>%
  filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  pivot_wider(names_from = Season_1234t, 
              values_from = c(RII_Green, Date_peak))  %>% 
  summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (RII_Green_2W1 - RII_Green_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = (RII_Green_3D2 - RII_Green_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (RII_Green_4W2 - RII_Green_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (-Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, -Padd_unique, Paddock, FPPlot, Canopy_0123, -Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, -Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Temp_Logger, -Light_Intensity, -RII_Light_Intensity, 
                 -RII_Bare, -RII_Shrubs) %>% 
  filter(Canopy_0123 %in% c(1, 2, 3)) %>% 
  filter_all(all_vars(!is.na(Date_peak_4W2)))

# Convert from wide to long table Database with Impacts and RR ###
Summary_database_longer <- Summary_database_no_norm %>% 
  pivot_longer(cols = (c("RII_Green_1D1", "RII_Green_2W1", "RII_Green_3D2", "RII_Green_4W2")),
               names_to = "Season_norm",
               values_to= "Green_norm",
               values_drop_na = TRUE)

#Order seasons manually in long table Database with Impacts and RR
Summary_database_longer$Season_norm <- factor(Summary_database_longer$Season_norm,          # Change ordering manually
                                              levels = c("D1N", "W1N", "D2N", "W2N"))

#Shorten long table Database with Impacts and RR to only average per Canopy type
Summary_database_canopy0123 <- Summary_database_no_norm %>% 
  group_by(Canopy_0123) %>% 
  summarise_all(funs(mean), na.rm =TRUE)   

# Model Impacts or RRs with Canopy type###
M_RR1<-lmer(Drop1 ~ Canopy_0123 + Canopy_dens + Canopy_diameter  + (1|Farm) , REML= T, 
            data= Summary_database)

anova(M_RR1, test.statistic="F")
summary (G6)

#G3<-lmer(Dep_var_ave~ Season + Canopy_0123 + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) 
+ Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + Tree_height + RII_Soil_temp
+ RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + Canopy_diameter, REML= F, 
data= Filtered_database_123)


`##Create summart table of long table= Same as previous table? Compare
Data_seas<- summarySE(Summary_database_longer, measurevar = "Green_norm", groupvars= c("Canopy_0123", "Season_norm"), 
                      na.rm = TRUE)  %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3))

pd = position_dodge(0.0)

#Graph Impact
ggplot(Data_seas, aes(x=Season_norm, y=Green_norm, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "% Green normalized ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  
# Calculate RRs for sepparate season pairs ###
Summary_database_RR1<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, RII_Green_2W1, RII_Green_1D1) %>% 
  pivot_longer (c (RII_Green_1D1, RII_Green_2W1), 
                names_to = "Season",
                values_to= "Values") %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)


Summary_database_RR2<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_2W1) %>% 
  pivot_longer (c (Green_2W1, Green_3D2), 
                names_to = "Season",
                values_to= "Values")  %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

Summary_database_RR2$Season <- factor(Summary_database_RR2$Season, levels = c("W1N", "D2N"))

Summary_database_RR3<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_4W2) %>% 
  mutate(GreenDry2=(Green_3D2*100)/Green_4W2, GreenWet2 = (Green_4W2*100/Green_4W2)) 
pivot_longer (c (GreenDry2, GreenWet2), 
              names_to = "Season",
              values_to= "Values")  %>% 
  #group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

# Graph single RRs or drop lines###
#1
Ind_RR1=ggplot(Summary_database_no_norm, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))   

#2

Ind_RR2=ggplot(Summary_database_RR2, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Wet 2018 (90%)','Dry 2019 (72%)')) 


#3
Ind_RR3=ggplot(Summary_database_RR3, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2019 (72%)', 'Wet 2019 (90%)'))  

Ind_RR1 + Ind_RR2 + Ind_RR3
# My three graphs with the three impacts and the three recovery rates. ###


Reco_rate_sum<- read_excel("C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Recovery_rates.xlsx", 
                           sheet = "Recov_rat_sum")

Reco_rate_sum<-Reco_rate_sum %>% mutate (Canopy_0123= as.factor(Canopy_0123))

Graph_1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_1, y = RR1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("2018", subtitle = "") +
  
  labs( x = "Impact 2018", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_2 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = Drop1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Wet 2018- Dry2019", subtitle = "") +
  
  labs( x = "Impact wet 2018- dry2019", 
        y = "Drop rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_3 <- ggplot(Summary_database_canopy0123, aes (x = Impact_3, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dry 2019 - Wet 2019", subtitle = "") +
  
  labs( x = "Impact 2019", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c( "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_1 + Graph_2 + Graph_3
# Milena's suggested graphs ###
#Specific resilience graphs

####Impact severe drought and recovery after severe drought

Graph_RR1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
    theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in RII", subtitle = "During and after severe drought 2018-2019") +
  labs(x=quote(Delta* " RII from wet 18 to strong dry season 19"), 
    y = " RII Rate of change after drought 2019") +
   scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_y_continuous(expand = c(0,0), limits = c(-.010,0.01))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 



##### Recovery rate after dry season 2018 and after dry season 2019
Graph_RR2 = ggplot(Summary_database_canopy0123, aes (x = RR1, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
    theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("RII Rates of change after droughts", subtitle = "From Dry to Wet (2018 and 2019)") +
  
  labs( x = "RII Rate of change 2018", 
        y = "RII Rate of change 2019", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(-.010,0.01))+
  scale_y_continuous(expand = c(0,0), limits = c(-.010,0.01))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  geom_abline(slope=1, intercept=0, color= "blue")


Summary_database_canopy0123$Canopy_132 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                  levels = c("1", "3", "2"))

##Impact per canopy type during dry season.
Graph_RR3 = ggplot(Summary_database_canopy0123, aes (x=Canopy_132, y = Impact_2, color = Canopy_132)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
    theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in RII", subtitle = "During severe drought 2018-2019") +
  labs(y=quote(Delta* "  RII from wet 18 to strong dry season 19"), 
       x = "Canopy type (ordered by canopy density)") +
    scale_color_manual(values=c("seagreen3", "tomato3","paleturquoise4" ))+
  scale_x_discrete("Canopy type", labels = c("Palm", "No fix", " N Fix"))


Graph_RR3 + Graph_RR1 + Graph_RR2 


#RR Dif_green #### 
#DEFINITIVAMENTE NO NORMALIZED. USADA ___)

# Transform Database to calculate Impact and recovery rates -No Normalized###
 rm(Summary_database_no_norm)
Summary_database_no_norm<-The_Database %>%                                #No Normalized
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season),
          Season_1234= as.factor(Season_1234), Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123), Date_peak= as.Date(Date_peak)) %>% 
  dplyr::select (Plot_ID, Plot, Farm, Season, Season_1234, Season_1234t, Monitoring, Date_peak, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 Canopy_diameter, DBH, Tree_height, Tree_spp, RII_Soil_moist, RII_Soil_temp, RII_Soil_EC, Av_Temp_weath, 
                 Av_RH_weath, RII_Temp_Logg, Light_Intensity, RII_Light_Intensity, 
                 RII_Green, RII_Bare, RII_Shrubs, Green, Dif_green) %>%
  dplyr::filter(Canopy_0123 %in% c(0, 1, 2, 3))  %>% 
  dplyr::group_by(Canopy_0123, Farm, Paddock, FPPlot) %>% 
  tidyr::pivot_wider(names_from = Season_1234t, 
              values_from = c(Dif_green, Date_peak))  %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE) %>% 
  mutate(Impact_1 = (Dif_green_2W1 - Dif_green_1D1), X1s = Date_peak_2W1 - Date_peak_1D1,
         Impact_2 = (Dif_green_3D2 - Dif_green_2W1), X2s = Date_peak_3D2 - Date_peak_2W1,
         Impact_3 = (Dif_green_4W2 - Dif_green_3D2), X3s = Date_peak_4W2 - Date_peak_3D2) %>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate (X1s = as.numeric(X1s),
          X2s = as.numeric(X2s),
          X3s = as.numeric(X3s))%>% 
  mutate(RR1=Impact_1/X1s, Drop1=Impact_2/X2s, RR2=Impact_3/X3s) %>%
  #group_by(Canopy_0123) %>% 
  #summarise_all(funs(mean), na.rm =TRUE)   %>% 
  dplyr::select (Plot_ID, -Plot, Farm, -Season, -Season_1234, -Monitoring, Padd_unique, Paddock, FPPlot, Canopy_0123, Canopy_dens, 
                 -Canopy_diameter, -DBH, -Tree_height, Tree_spp, -RII_Soil_moist, -RII_Soil_temp, -RII_Soil_EC, -Av_Temp_weath, 
                 -Av_RH_weath,- RII_Temp_Logg, -Light_Intensity, -RII_Light_Intensity, 
                 -RII_Bare, -RII_Shrubs) %>% 
  dplyr::filter(Canopy_0123 %in% c(1, 2, 3)) %>% 
  dplyr::filter_all(all_vars(!is.na(Date_peak_4W2)))

# Convert from wide to long table Database with Impacts and RR ###
Summary_database_longer <- Summary_database_no_norm %>% 
  pivot_longer(cols = (c("Dif_green_1D1", "Dif_green_2W1", "Dif_green_3D2", "Dif_green_4W2")),
               names_to = "Season",
               values_to= "Dif_Green",
               values_drop_na = TRUE)

Summary_database_longer_short <- Summary_database_longer %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot) %>% 
  filter(Canopy_0123 %in% c(1, 2, 3))  %>% 
  add_column(relat_abund_padd = c(0.45,0.45,0.45,0.45, 0.35,0.35,0.35,0.35, 0.2, 0.2, 0.2, 0.2),
             relat_abund_study = c(0.54,0.54,0.54,0.54, 0.37,0.37,0.37,0.37, 0.09,0.09,0.09,0.09),
             precip_mm = c (213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01,213.77, 530.14, 150.27,431.01),
             Evapotrans = c(5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45,5.32, 6.21, 5.37, 6.45),
             temp = c(31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4, 31.57, 30.07, 29.67, 33.4)) %>%
  mutate (Comm_eff_padd= (Dif_Green * relat_abund_padd)) %>% 
  mutate (Comm_eff_study= (Dif_Green * relat_abund_study))

#Order seasons manually in long table Database with Impacts and RR
Summary_database_longer$Season_norm <- factor(Summary_database_longer$Season_norm,          # Change ordering manually
                                              levels = c("D1N", "W1N", "D2N", "W2N"))

#Shorten long table Database with Impacts and RR to only average per Canopy type
Summary_database_canopy0123 <- Summary_database_no_norm %>% 
  dplyr::group_by(Canopy_0123) %>% 
  dplyr::summarise_all((mean), na.rm =TRUE)  %>% 
  #dplyr::summarise_all(funs(mean), na.rm =TRUE)  %>% 
  dplyr::select(-Farm, -Paddock, -FPPlot)

# Model Impacts or RRs with Canopy type###
M1_Dif_Green<-lmer(Impact_2~ Season + Canopy_0123 + (1|FPPlot) + Canopy_dens, REML= F, 
                      data= Summary_database_longer)
M1_Dif_Green<-lmer(RR1~ Season + Canopy_0123 + (1|FPPlot) + Canopy_dens, REML= F, 
                   data= Summary_database_longer)
M1_Dif_Green<-lmer(Drop1~ Season + Canopy_0123 + (1|FPPlot) + Canopy_dens, REML= F, 
                   data= Summary_database_longer)
M1_Dif_Green<-lmer(RR2~ Season + Canopy_0123 + (1|FPPlot) + Canopy_dens, REML= F, 
                   data= Summary_database_longer)


anova(M1_Dif_Green, test.statistic="F")
summary (M1_Dif_Green)

#G3<-lmer(Dep_var_ave~ Season + Canopy_0123 + (1|Farm/Padd_unique) + (1|Tree_spp) + (1|Plot/Plot_ID) 
+ Av_Temp_weath + Av_RH_weath + Canopy_dens + DBH + Tree_height + RII_Soil_temp
+ RII_Soil_EC + RII_Temp_Logg + RII_Light_Intensity + Canopy_diameter, REML= F, 
data= Filtered_database_123)


##Create summart table of long table= Same as previous table? Compare
Data_seas<- summarySE(Summary_database_longer, measurevar = "Green_norm", groupvars= c("Canopy_0123", "Season_norm"), 
                      na.rm = TRUE)  %>% 
  filter(Canopy_0123 %in% c(0, 1, 2, 3))

pd = position_dodge(0.0)

#Graphs Diff Green####
#Graph Impact
ggplot(Data_seas, aes(x=Season_norm, y=Green_norm, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "% Green normalized ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open", "Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))  


# Calculate RRs for sepparate season pairs ###
Summary_database_RR1<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, RII_Green_2W1, RII_Green_1D1) %>% 
  pivot_longer (c (RII_Green_1D1, RII_Green_2W1), 
                names_to = "Season",
                values_to= "Values") %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)


Summary_database_RR2<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_2W1) %>% 
  pivot_longer (c (Green_2W1, Green_3D2), 
                names_to = "Season",
                values_to= "Values")  %>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

Summary_database_RR2$Season <- factor(Summary_database_RR2$Season, levels = c("W1N", "D2N"))

Summary_database_RR3<-Summary_database_no_norm  %>%
  dplyr::select(Canopy_0123, Green_3D2, Green_4W2) %>% 
  mutate(GreenDry2=(Green_3D2*100)/Green_4W2, GreenWet2 = (Green_4W2*100/Green_4W2)) 
pivot_longer (c (GreenDry2, GreenWet2), 
              names_to = "Season",
              values_to= "Values")  %>% 
  #group_by(Canopy_0123, Season) %>% 
  summarise_all(funs(mean), na.rm =TRUE)

# Graph single RRs or drop lines###
#1
Ind_RR1=ggplot(Summary_database_no_norm, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' ))   

#2

Ind_RR2=ggplot(Summary_database_RR2, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  theme(legend.position="none")+
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Wet 2018 (90%)','Dry 2019 (72%)')) 


#3
Ind_RR3=ggplot(Summary_database_RR3, aes(x=Season, y=Values, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dep_var_ave-se, ymax=Dep_var_ave+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Green grass base normalized", subtitle = "in plots") +
  labs( x = "Season", 
        y = "% Grass greeness") +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c( "yellow3", "seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Open","Palm", "N fix", "No N Fix")) +
  scale_x_discrete(labels = c('Dry 2019 (72%)', 'Wet 2019 (90%)'))  

Ind_RR1 + Ind_RR2 + Ind_RR3
# My three graphs with the three impacts and the three recovery rates. ###


Reco_rate_sum<- read_excel("C:/Ivan/PhD C drive/Fieldwork/R analysis/Paper 1/Recovery_rates.xlsx", 
                           sheet = "Recov_rat_sum")

Reco_rate_sum<-Reco_rate_sum %>% mutate (Canopy_0123= as.factor(Canopy_0123))

Graph_1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_1, y = RR1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("2018", subtitle = "") +
  
  labs( x = "Impact 2018", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_2 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = Drop1, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Wet 2018- Dry2019", subtitle = "") +
  
  labs( x = "Impact wet 2018- dry2019", 
        y = "Drop rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_3 <- ggplot(Summary_database_canopy0123, aes (x = Impact_3, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dry 2019 - Wet 2019", subtitle = "") +
  
  labs( x = "Impact 2019", 
        y = "Recovery rate", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c( "Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 

Graph_1 + Graph_2 + Graph_3
# Milena's suggested graphs ###
#Specific resilience graphs

####Impact severe drought and recovery after severe drought

Graph_RR1 <- ggplot(Summary_database_canopy0123, aes (x = Impact_2, y = RR2, color = Canopy_0123)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in Effect size ", subtitle = "during and after severe drought 2018-2019") +
  labs(x=quote(Delta* " Effect size from wet 18 to strong dry season 19"), 
       y = " Rate of change ES after drought 2019") +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(0,100))+
    scale_y_continuous(expand = c(0,0), limits = c(-1.69,0.01))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) 



##### Recovery rate after dry season 2018 and after dry season 2019
Graph_RR2 = ggplot(Summary_database_no_norm, aes (x = RR1, y = RR2, color = Canopy_0123)) +
  geom_point(size =2 ) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Rates of change of ES after droughts", subtitle = "From Dry to Wet (2018 and 2019)") +
  
  labs( x = "Rate of change ES - severe drought 2018", 
        y = "Rate of change ES- average drought 2019", hjust=0.9) +
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  scale_x_continuous(expand = c(0,0), limits = c(-0.6,0.6))+
  scale_y_continuous(expand = c(0,0), limits = c(-0.6,0.6))+
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  geom_vline(xintercept = 0, linetype="dotted", size = 0.7) +
  geom_abline(slope=1, intercept=0, color= "blue")


Summary_database_canopy0123$Canopy_132 <- factor(Summary_database_canopy0123$Canopy_0123,                                    # Change ordering manually
                                                 levels = c("1", "3", "2"))

##Impact per canopy type during dry season.
Graph_RR3 = ggplot(Summary_database_canopy0123, aes (x=Canopy_132, y = Impact_2, color = Canopy_132)) +
  geom_point(size = 5) +
  theme_classic() +
  theme(legend.position="none")+
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Change in Effect size", subtitle = "During severe drought 2018-2019") +
  labs(y=quote(Delta* "  ES from wet 18 to strong dry season 19"), 
       x = "Canopy type (ordered by canopy density)") +
  scale_color_manual(values=c("seagreen3", "tomato3","paleturquoise4" ))+
  scale_y_continuous(expand = c(0,0), limits = c(0,40))+
  scale_x_discrete("Canopy type", labels = c("Palm", "No fix", " N Fix"))


Graph_RR3 + Graph_RR1 + Graph_RR2 

#Graph community effect in study and in paddock ####
po = 1

#In study
ggplot(Summary_database_longer_short, aes(x=Season, y=Comm_eff_study, color = Canopy_0123) ) + 
   geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Community facilitative effect", subtitle = "in paddocks") +
  labs( x = "Season", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)','Wet 2019 (83%)' )) 

#In whole paddock

Summary_database_longer_short$Season_ordered <- factor(Summary_database_longer_short$Season,          # Change ordering manually
                                              levels = c("Dif_green_3D2", "Dif_green_1D1", "Dif_green_4W2", "Dif_green_2W1"))

ggplot(Summary_database_longer_short, aes(x=temp, y=Comm_eff_padd, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  #geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Community facilitative effect", subtitle = "in paddocks") +
  labs( x = "Average daily Temperature", 
        y = "Community effect (relative abundance total spp)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) 
  #scale_x_discrete(labels = c('Dry 2019 (72%)','Dry 2018 (77%)','Wet 2019 (83%)','Wet 2018 (90%)' ))  


#PRUEBA PARA HACER LSMEANS CON COMMUNITY FACILITATIVE EFFECT

Groups_var

marginal_comm_eff <- Fac_eff_green %>% 
  add_column(relat_abund_study = c (0.22,0.45,0.22,0.22,),
             precip_mm =c(530.14, 431.01, 530.14,213.77, 431.01, 213.77, 530.14,431.01, 150.27, 213.77, 150.27,150.27)) %>% 
  mutate (Comm_eff_study= (lsmean * relat_abund_study))
 
#Graph community effect in study and in paddock ####
po = 0

#In study
ggplot(marginal_comm_eff, aes(x=precip_mm, y=Comm_eff_study, color = Canopy_0123) ) + 
  geom_point(shape = 16, size   = 2) +
  geom_line(aes(group=Canopy_0123), size = 1) +
  #geom_errorbar(aes(ymin=Dif_green-se, ymax=Dif_green+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass greenness", subtitle = "Community facilitative effect (LSMeans)") +
  labs( x = "Rainfall (mm)", 
        y = "Community effect (rel. abund. spp in study)", 
        caption  = paste0("\n Community effect represents the facilitative effect in relation to the\n ",
                          "relative abundance of each group. \n"), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))


#PRUEBA 2
# Models with Dif_green, Season 1234 and Subset. ####

CE_Green_6<-lmer(Comm_eff_green~ Season_1234t* Canopy_0123 +  
           (1|Farm/Padd_unique/FPPlot)+ (1|Tree_spp) , REML= F, 
         data= Filtered_database_123)

anova(CE_Green_6, test.statistic="F")
summary (CE_Green_6)

# Pairwise comparisons and graph####
emm_options(pbkrtest.limit = 3878) 
glmerControl(optimizer="bobyqa", optCtrl = list(maxfun = 100000))
marginal <- lsmeans(CE_Green_6,~ Season_1234t*Canopy_0123, adjust = "Tukey")

Groups_var_green=cld(marginal, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
Groups_var_green


marginal_comm_eff_ind_green <- Groups_var_green %>% 
  add_column(precip_mm =c(530.14, 431.01, 530.14, 213.77, 431.01, 530.14, 431.01, 213.77, 150.27, 150.27, 213.77, 150.27))

pd = position_dodge(0)
ggplot(marginal_comm_eff_ind_green, aes(x=precip_mm, y=lsmean, label=.group, color = Canopy_0123) ) + 
  geom_point( shape = 16, size   = 2, position = pd) +
  geom_line(aes(group=Canopy_0123), size = 1, position = pd) +
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Canopy_0123), width =  20, size  =  0.7, position = pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Grass greenness", subtitle = "Community facilitative effect (Ind - LSMeans)") +
  labs( x = "Seasons", 
        y = "Plot under canopy - open plot", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("seagreen3", "paleturquoise4", "tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "N fix", "No N Fix")) +
  #scale_x_discrete(labels = c('Dry 2018 (77%)','Wet 2018 (90%)','Dry 2019 (72%)', 'Wet 2019 (83%)'))  + 
  #scale_x_discrete(labels = c('Dry','Wet'))  + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_continuous(expand = c(0,0), limits = c(0,600))

#GRAPH LIGHT FOR GREENNESS
Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Canopy_0123, Season) %>% 
  summarise_all(list (mean), na.rm = TRUE)

Filtered_database_123_summ_canopy<- Filtered_database_123%>% 
  group_by(Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)

#Light reduction
ggplot(Filtered_database_123_summ, aes(x=Canopy_0123, y=Dif_Light_Intensity, color = Season) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Light reduction", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Light reduction (Lux) ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) +
  scale_x_discrete(labels = c('Palm','NF','NNF'))  

#Tree height
ggplot(Filtered_database_123_summ_canopy, aes(x=Canopy_0123, y=Tree_height) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Tree_height", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Tree_height ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) +
  scale_x_discrete(labels = c('Palm','NF','NNF'))  

#Dif_Soil_temp
ggplot(Filtered_database_123_summ, aes(x=Canopy_0123, y=Dif_Soil_temp, color=Season) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dif_Soil_temp", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Dif_Soil_temp ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  scale_x_discrete(labels = c('Palm','NF','NNF'))

#Canopy_diam
ggplot(Filtered_database_123_summ_canopy, aes(x=Canopy_0123, y=Canopy_diameter) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Canopy_diam", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Canopy_diam ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) +
  scale_x_discrete(labels = c('Palm','NF','NNF')) 

#DBH
ggplot(Filtered_database_123_summ_canopy, aes(x=Canopy_0123, y=DBH) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("DBH", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "DBH ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) +
  scale_x_discrete(labels = c('Palm','NF','NNF')) 

#Canopy_density
ggplot(Filtered_database_123_summ_canopy, aes(x=Canopy_0123, y=Canopy_dens) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Canopy_density", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Canopy_density ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) +
  scale_x_discrete(labels = c('Palm','NF','NNF')) 

#Canopy density season
ggplot(Filtered_database_123_summ, aes(x=Canopy_0123, y=Canopy_dens, color=Season) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Canopy_dens", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Canopy_dens ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  scale_x_discrete(labels = c('Palm','NF','NNF'))

#Dif_Temp_above
ggplot(Filtered_database_123_summ, aes(x=Canopy_0123, y=Dif_Temp_above, color=Season) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dif_Soil_temp", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Dif_Soil_temp ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  scale_x_discrete(labels = c('Palm','NF','NNF'))

#Dif_Soil_moist
ggplot(Filtered_database_123_summ, aes(x=Canopy_0123, y=Dif_Soil_moist, color=Season) ) + 
  geom_point(shape = 16, size   = 2, position = pd) +
  #geom_line(aes(group=Canopy_0123), position = pd, size = 1) +
  # geom_errorbar(aes(ymin=Green_norm-se, ymax=Green_norm+se, color=Canopy_0123), width=.2, size = 0.5,  position=pd) +
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dif_Soil_moist", subtitle = "during dry and wet season per canopy type") +
  labs( x = "Canopy type", 
        y = "Dif_Soil_moist ", 
        caption  = paste0("\n% Green grass for the three canopy types. ",
                          "Points indicate the means. \n",
                          "Error bars indicate the Standard Error. \n "), hjust=0.9) +
  #geom_text(nudge_x = c(0.2, 0.1), nudge_y = c(0.1, 0.1), color   = "black")+ 
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  scale_x_discrete(labels = c('Palm','NF','NNF'))







