# Library packages ####
if(!require(easypackages)) install.packages("easypackages")

easypackages::packages(c("tidyverse", "patchwork", "rayshader", 
                         "ggthemes", "gganimate", "manipulate", "plotly", 
                         "quantreg", "dslabs", "Hmisc", "nycflights13",
                         "stringr", "dplyr", "ggplot2", "xlsx"))

##packages
packages<-c("psych", "lsmeans", "MASS", "nlme", "aod", "betareg", "pbkrtest", "lmerTest", 
            "multcomp", "ggpubr", "readxl", "ggplot2", "Rmisc")

require(packages)
lapply(packages, require,character.only = TRUE)

#The_Database<- read_excel("M:/My Documents/PhD WUR session/Field/The Database.xlsx", 
 #                         sheet = "12x20")
The_Database<- read_excel("/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/The Database.xlsx",
                          sheet = "12x20")

Filtered_database<-The_Database %>% 
  dplyr::rename(Dep_var_RII = RII_Green, Dep_var_ave = Dif_green) %>%  
  mutate (Plot_ID = as.factor(Plot_ID), Plot= as.factor(Plot), Farm= as.factor(Farm), Season= as.factor(Season), Tree_spp= as.factor(Tree_spp),
          Season_1234= as.factor(Season_1234), Date_peak= as.factor(Date_peak), 
          Season_1234t= as.factor(Season_1234t), Monitoring= as.factor(Monitoring), 
          Padd_unique= as.factor(Padd_unique), Observer= as.factor(Observer), Paddock= as.factor(Paddock), FPPlot= as.factor(FPPlot), 
          Canopy_0123= as.factor(Canopy_0123)) %>% 
  dplyr::select (Plot_ID, Canopy_0123,
                 Canopy_dens, Canopy_diameter, DBH, Tree_height, Dif_Soil_moist, Dif_Soil_temp,  
                 Dif_Temp_above, Dif_Light_Intensity, Soil_temperature, Soil_moisture, Light_Intensity, Temp_above, Dif_Light_perc,
                 Farm, Padd_unique, FPPlot, Season, Season_1234t, Tree_spp)


# Filter database ####
Filtered_database_123 <- Filtered_database %>%
  dplyr::filter(Canopy_0123 %in% c(1,2, 3))
  
Filtered_database_plots<-Filtered_database %>% 
  dplyr::group_by(Plot_ID, Canopy_0123) %>%
  dplyr::summarise_all(list (mean), na.rm = FALSE)

#Describe
describe_database_envvar<-psych::describeBy(Filtered_database_plots, list(Filtered_database_plots$Canopy_0123, Filtered_database_plots$Season), digit = 2)

table_describe_database<-do.call("rbind",describe_database_envvar)

#write table in excel
write.csv(table_describe_database, "M:\\My Documents\\PhD WUR session\\Field\\describe_database_envvar.csv")





#Canopy_diameter####
aov.Canopy_diameter <- aov(Canopy_diameter ~ Canopy_0123, data = Filtered_database_123)

# Summary of the analysis
summary(aov.Canopy_diameter)

plot(aov.Canopy_diameter, 1)
plot(aov.Canopy_diameter, 2) #Normality, as all the points fall approximately along this reference line, we can ssume normality
# Extract the residuals
aov.Canopy_diameter <- residuals(object = aov.Canopy_diameter )
# Run Shapiro-Wilk test
shapiro.test(x = aov.Canopy_diameter ) # IF p value > 0.05, so Shapiro-Wilk test on the ANOVA residuals finds no indication that normality is violated
                            #No normality

library(car)

leveneTest(Canopy_diameter ~ Canopy_0123, data = Filtered_database_123) #P value is not less than the significance level of 0.05. There is no evidence to suggest that the variance
#across groups is statisticall ysignificant different, correct assumption then, ANOVA YES

kruskal.test(Canopy_diameter ~ Canopy_0123, data = Filtered_database_123)

#Pairwise Wilcox text for non parametric

PT.Canopy_diameter=pairwise.wilcox.test(Filtered_database_123$Canopy_diameter,
                        Filtered_database_123$Canopy_0123,
                        p.adjust.method="none")

PT.Canopy_diameter = PT.Canopy_diameter$p.value

library(rcompanion)

PT1.Canopy_diameter = fullPTable(PT.Canopy_diameter)

PT1.Canopy_diameter

library(multcompView)

multcompLetters(PT1.Canopy_diameter,
                compare="<",
                threshold=0.05,
                Letters=letters,
                reversed = FALSE)



#Tree_height####
aov.Tree_height<- aov(Tree_height ~ Canopy_0123, data = Filtered_database_123)

#Summary of the analysis
summary(aov.Tree_height)

plot(aov.Tree_height, 1)
plot(aov.Tree_height, 2) #Normality, as all the points fall approximately along this reference line, we can ssume normality
# Extract the residuals
aov.Tree_height <- residuals(object = aov.Tree_height )
# Run Shapiro-Wilk test
shapiro.test(x = aov.Tree_height ) # IF p value > 0.05, so Shapiro-Wilk test on the ANOVA residuals finds no indication that normality is violated
#No normality

library(car)

leveneTest(Tree_height ~ Canopy_0123, data = Filtered_database_123) #P value is not less than the significance level of 0.05. There is no evidence to suggest that the variance
#across groups is statisticall ysignificant different, correct assumption then, ANOVA YES

kruskal.test(Tree_height ~ Canopy_0123, data = Filtered_database_123)

#Pairwise Wilcox text for non parametric

PT.Tree_height=pairwise.wilcox.test(Filtered_database_123$Tree_height,
                                        Filtered_database_123$Canopy_0123,
                                        p.adjust.method="none")

PT.Tree_height = PT.Tree_height$p.value

library(rcompanion)

PT1.Tree_height= fullPTable(PT.Tree_height)

PT1.Tree_height

library(multcompView)

multcompLetters(PT1.Tree_height,
                compare="<",
                threshold=0.05,
                Letters=letters,
                reversed = FALSE)

#DBH####
aov.DBH<- aov(DBH ~ Canopy_0123, data = Filtered_database_123)

#Summary of the analysis
summary(DBH)

plot(aov.DBH, 1)
plot(aov.DBH, 2) #Normality, as all the points fall approximately along this reference line, we can ssume normality
# Extract the residuals
aov.DBH <- residuals(object = aov.DBH )
# Run Shapiro-Wilk test
shapiro.test(x = aov.DBH ) # IF p value > 0.05, so Shapiro-Wilk test on the ANOVA residuals finds no indication that normality is violated
#No normality

library(car)

leveneTest(DBH ~ Canopy_0123, data = Filtered_database_123) #P value is not less than the significance level of 0.05. There is no evidence to suggest that the variance
#across groups is statisticall ysignificant different, correct assumption then, ANOVA YES

kruskal.test(DBH ~ Canopy_0123, data = Filtered_database_123)

#Pairwise Wilcox text for non parametric

PT.DBH=pairwise.wilcox.test(Filtered_database_123$DBH,
                                    Filtered_database_123$Canopy_0123,
                                    p.adjust.method="none")

PT.DBH = PT.DBH$p.value

library(rcompanion)

PT1.DBH= fullPTable(PT.DBH)

PT1.DBH

library(multcompView)

multcompLetters(PT1.DBH,
                compare="<",
                threshold=0.05,
                Letters=letters,
                reversed = FALSE)


#Canopy density

Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Farm, Padd_unique, Plot_ID, FPPlot, Season, Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)

CD_monit<-lmer(Canopy_dens~ Canopy_0123 * Season +  #Using all data because CD was monitored every month
           (1|Farm/Padd_unique/Plot_ID)+
           (1|Tree_spp), REML= F, 
         data= Filtered_database_123)


anova(CD_monit, test.statistic="F")
summary (CD_monit)


marginal_monit <- emmeans(CD_monit, ~ Canopy_0123 * Season, adjust = "Tukey")
emmeans (CD_monit, pairwise~ Canopy_0123 * Season, adjust="Tukey") 


Groups_var_monit=cld(marginal_monit, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
               adjust="Tukey") 
marginal_monit

#Canopy density graph

ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Canopy_dens" , 
            xlab="Canopy",
            ylab="Canopy density (%)", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))

pd = position_dodge(0.3)
ggplot(Groups_var_monit, aes(x=Canopy_0123, y=emmean, label=.group, color = Season) ) + 
  geom_point( shape = 16, size   = 2, position = pd)+
  geom_errorbar(aes(ymin  =  emmean-SE, ymax  =  emmean+SE, color=Season), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Canopy density (%)", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "Canopy density (%)", 
        caption  = paste0("\nDifference in grass greeness in paired plots under the three canopy types. ",
                          "Points indicate the LS mean. \n",
                          "Error bars indicate the Standard Error. Means sharing",
                          " a letter are not significantly different \n "), hjust=0.9)+
     scale_color_manual(values=c("gold", "steelblue"),
                      name = "Season",
                       labels=c("Dry", "Wet")) + 
    scale_x_discrete(labels = c('Palm','NF','NNF'))

  geom_point( size = 3, shape = 16,  position = pd)+
  #scale_size(range = c(0, 25))+
  geom_errorbar(aes(ymin  =  emmean-SE, ymax  =  emmean+SE, color=Canopy_0123), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Canopy density (%)", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = "Canopy density (%)")+
  scale_color_manual(values=c("seagreen3",  "paleturquoise4","tomato3"),
                     name = "Canopy type",
                     labels=c("Palm", "NF", "NNF")) + 
  scale_x_discrete(name = "Season",
                   labels = c('Dry', 'Wet')) 
  scale_y_continuous(expand = c(0,0), limits = c(20,80))



#Light density diff this variable (%) or Dif_Light_Intensity????

Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Tree_spp, Farm, Padd_unique, Plot_ID, FPPlot, Season, Season_1234t, Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)
  filter(Season_1234t %in% c( "1D1", "2W1"))



ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dif_Light_perc" , 
            xlab="Canopy",
            ylab="Light Intensity reduction (Lux)", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))





LI_monit<-lmer(Dif_Light_perc ~ Canopy_0123 * Season +  #Using all data because CD was monitored every month
                 (1|Farm/Padd_unique/Plot_ID)+
                 (1|Tree_spp), REML= F, 
               data= Filtered_database_123_summ)


anova(LI_monit, test.statistic="F")
summary (LI_monit)

write.csv(as.matrix(anova(LI_monit)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/LI_monit.csv", na = "")


marginal_monit <- lsmeans(LI_monit, ~ Canopy_0123*Season, adjust = "Tukey")

Groups_var_monit=cld(marginal_monit, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                     adjust="Tukey") 
marginal_monit

pd = position_dodge(0.3)
LI=ggplot(Groups_var_monit, aes(x=Canopy_0123, y=lsmean, label=.group, color = Season) ) + 
  geom_point( shape = 16, size   = 2, position = pd)+
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Season), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Dif_Light_Intensity", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = quote (Delta*  " Light irradiance (%) "))+
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete(labels = c('Palm','NF','NNF'))

#Soil_temperature difference

ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dif_Soil_temp" , 
            xlab="Canopy",
            ylab="Soil T difference  bg", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))


Filtered_database_123_summ<- Filtered_database_123%>% 
  dplyr::group_by(Tree_spp, Farm, Padd_unique, Plot_ID, FPPlot, Season, Season_1234t, Canopy_0123) %>% 
  dplyr::summarise_all(list (mean), na.rm = TRUE)



Soil_Temp_monit<-lmer(Dif_Soil_temp~ Canopy_0123 * Season +  #Using all data because CD was monitored every month
                 (1|Farm/Padd_unique/Plot_ID)+
                 (1|Tree_spp), REML= F, 
               data= Filtered_database_123_summ)


anova(Soil_Temp_monit, test.statistic="F")
summary (Soil_Temp_monit)

write.csv(as.matrix(anova(Soil_Temp_monit)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Soil_Temp_monit.csv", na = "")


marginal_monit <- lsmeans(Soil_Temp_monit, ~ Canopy_0123*Season, adjust = "Tukey")

Groups_var_monit=cld(marginal_monit, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                     adjust="Tukey") 
marginal_monit

pd = position_dodge(0.3)
BT = ggplot(Groups_var_monit, aes(x=Canopy_0123, y=lsmean, label=.group, color = Season) ) + 
  geom_point( shape = 16, size   = 2, position = pd)+
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Season), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Soil Temp", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = quote (Delta*  " Soil temperature " (degree*C)))+
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete(labels = c('Palm','NF','NNF'))


#Soil_temperature above difference

ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dif_Temp_above" , 
            xlab="Canopy",
            ylab="Soil T difference  ag", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))


Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Tree_spp, Farm, Padd_unique, Plot_ID, FPPlot, Season, Season_1234t, Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)  
  filter(Season_1234t %in% c( "1D1", "2W1"))



Soil_Temp_monit_above<-lmer(Dif_Temp_above~ Canopy_0123 * Season +  #Using all data because CD was monitored every month
                        (1|Farm/Padd_unique/Plot_ID)+
                        (1|Tree_spp), REML= F, 
                      data= Filtered_database_123_summ)


anova(Soil_Temp_monit_above, test.statistic="F")
summary (Soil_Temp_monit_above)

write.csv(as.matrix(anova(Soil_Temp_monit_above)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Soil_Temp_monit_above.csv", na = "")


marginal_monit <- lsmeans(Soil_Temp_monit_above, ~ Canopy_0123*Season, adjust = "Tukey")

Groups_var_monit=cld(marginal_monit, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                     adjust="Tukey") 
marginal_monit

pd = position_dodge(0.3)
AT = ggplot(Groups_var_monit, aes(x=Canopy_0123, y=lsmean, label=.group, color = Season) ) + 
  geom_point( shape = 16, size   = 2, position = pd)+
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Season), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Soil Temp above ground", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = quote (Delta*  " Air temperature "(degree*C)))+
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) +
  scale_x_discrete(labels = c('Palm','NF','NNF'))

#Soil moisture difference

ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dif_Soil_moist" , 
            xlab="Canopy",
            ylab="Soil moisture", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))


Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Tree_spp, Farm, Padd_unique, Plot_ID, FPPlot, Season, Season_1234t, Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)



Soil_moist<-lmer(Dif_Soil_moist~ Canopy_0123 * Season +  #Using all data because CD was monitored every month
                              (1|Farm/Padd_unique/Plot_ID)+
                              (1|Tree_spp), REML= F, 
                            data= Filtered_database_123_summ)


anova(Soil_moist, test.statistic="F")
summary (Soil_moist)

write.csv(as.matrix(anova(Soil_moist)), file="/Users/apple/Documents/Papers after PhD Mex 2022/Paper native trees/Soil_moist.csv", na = "")



emmeans (Soil_moist, pairwise~ Canopy_0123 * Season, adjust="Tukey") 


marginal_monit <- lsmeans(Soil_moist, ~ Canopy_0123*Season, adjust = "Tukey")

Groups_var_monit=cld(marginal_monit, alpha=0.05, Letters=letters,      ### Use lower-case letters for .group
                     adjust="Tukey") 
marginal_monit

pd = position_dodge(0.3)
SM = ggplot(Groups_var_monit, aes(x=Canopy_0123, y=lsmean, label=.group, color = Season) ) + 
  geom_point( shape = 16, size   = 2, position = pd)+
  geom_errorbar(aes(ymin  =  lsmean-SE, ymax  =  lsmean+SE, color=Season), width = 0.1, size = 0.3, position = pd)+
  theme_classic() +
  theme(axis.title   = element_text(face = "bold"), axis.text    = element_text(face = "bold"),
        plot.caption = element_text(hjust = 0)) +
  ggtitle ("Soil moisture", subtitle = "in plots") +
  labs( x = "Canopy type", 
        y = quote (Delta*  " Soil moisture "(degree*C)))+
  scale_color_manual(values=c("gold", "steelblue"),
                     name = "Season",
                     labels=c("Dry", "Wet")) + 
  scale_x_discrete(labels = c('Palm','NF','NNF')) + 
  geom_hline(yintercept = 0, linetype="dotted", size = 0.7) 
  

LI + AT + BT + SM


#Grass height and grass greenness per canopy type and season graph

Filtered_database_123_summ<- Filtered_database_123%>% 
  group_by(Tree_spp, Farm, Padd_unique, Plot_ID, FPPlot, Season, Season_1234t, Canopy_0123) %>% 
  summarise_all(list (mean), na.rm = TRUE)


ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dep_var_ave" , 
            xlab="Canopy",
            ylab="Greenness difference (%)", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))

ggerrorplot(Filtered_database_123_summ, x = "Canopy_0123", y = "Dep_var_ave" , 
            xlab="Canopy",
            ylab="Grass height difference (%)", remove =NA , error.plot = "errorbar",            # Change error plot type
            add = "mean", color= "Season", palette = c ("gold", "steelblue"))

