# Optimized l1-wavelet CS

This is an implementation of Optimized l1-wavelet CS for accelerated MRI reconstruction.

## Datasets

[FastMRI](https://fastmri.med.nyu.edu/) dataset is used in the experiments.

## How to use

numpy version: 1.21.5

tensorflow version: 1.13.1

### Summary:

**train_optimized.py** file generates a first trained l1-wavelet CS model with subband processing. Then **test_optimized.py** is in charge of generating the first set of reconstructed images (for either training set or testing set). **train_optimized_reweighted.py** generates a second trained l1-wavelet CS model with subband processing and reweighted l1-minimization. Then the final set of reconstructed testing images are generated by **test_optimized_reweighted.py**.

### Step by step:

Step1: Run **train_optimized.py** with input (training data, training coil, mask), and generate output (folder of saved model #1)

Step2: Run **test_optimized.py** with input (training data, training coil, mask, folder of saved model #1), and generate output (first set of training data's reconstruction)

Step3: Run **test_optimized.py** with input (testing data, testing coil, mask, folder of saved model #1), and generate output (first set of testing data's reconstruction)

Step4: Run **train_optimized_reweighted.py** with input (training data, training coil, mask, first set of training data's reconstruction), and generate output (folder of saved model #2)

Step5: Run **test_optimized_reweighted.py** with input (testing data, testing coil, mask, folder of saved model #2, first set of testing data's reconstruction), and generate output (final testing data's reconstructions)

### Directories:

User need to specify the following variables in the py files to give directories for input(i) and output(o):

At step1: 

data_dir(i)--directory for training data in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

coil_dir(i)--directory for training coil in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

mask_dir(i)--directory for mask in mat file, with dimension nRo x nPE

At step2: 

data_dir(i)--directory for training data in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

coil_dir(i)--directory for training coil in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

mask_dir(i)--directory for mask in mat file, with dimension nRo x nPE

file_dir(i)--directory for folder of saved model #1

save_dir(o)--directory for first set of training data's reconstruction in mat file, with dimension nSlice_train x nRo x nPE

At step3: 

data_dir(i)--directory for testing data in h5 file, with dimension nSlice_test x nRo x nPE x nCoil

coil_dir(i)--directory for testing coil in h5 file, with dimension nSlice_test x nRo x nPE x nCoil

mask_dir(i)--directory for mask in mat file, with dimension nRo x nPE

file_dir(i)--directory for folder of saved model #1

save_dir(o)--directory for first set of testing data's reconstruction in mat file, with dimension nSlice_test x nRo x nPE

At step4: 

data_dir(i)--directory for training data in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

coil_dir(i)--directory for training coil in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

mask_dir(i)--directory for mask in mat file, with dimension nRo x nPE

reweight_dir(i)--directory for first set of training data's reconstruction in mat file, with dimension nSlice_train x nRo x nPE

At step5: 

data_dir(i)--directory for testing data in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

coil_dir(i)--directory for testing coil in h5 file, with dimension nSlice_train x nRo x nPE x nCoil

mask_dir(i)--directory for mask in mat file, with dimension nRo x nPE

file_dir(i)--directory for folder of saved model #2

save_dir(o)--directory for final testing data's reconstructions in mat file, with dimension nSlice_test x nRo x nPE

reweight_dir(i)--directory for first set of testing data's reconstruction in mat file, with dimension nSlice_test x nRo x nPE

## Notes

The implementation of wavelet transforms uses and modifies from [here](https://github.com/UiO-CS/tf-wavelets). Before running the above training and testing files, *please go to the forked repository* [here](https://github.com/hongygu/tf-wavelets/tree/master/tfwavelets) and download **dwtcoeffs.py**, **nodes.py**, **utils.py**. Make sure they are in the same directory as the above training and testing files.

The codes currently only works for batchsize = 1.

14 subbands are used in subband processing.

For implementation of reweighted l1-minimization, all slices of input data are normalized such that their zero-filled solution has inf-norm = 255.

Two iterations of reweighted l1-minimization are implemented during testing (step5).

## Copyright and License Notice

Optimized l1-wavelet CS is copyrighted by Regents of the University of Minnesota. Regents of the University of Minnesota will license the use of Optimized l1-wavelet CS solely for educational and research purposes by non-profit institutions and US government agencies only. For other proposed uses, contact umotc@umn.edu. The software may not be sold or redistributed without prior approval. One may make copies of the software for their use provided that the copies, are not sold or distributed, are used under the same terms and conditions. As unestablished research software, this code is provided on an "as is'' basis without warranty of any kind, either expressed or implied. The downloading, or executing any part of this software constitutes an implicit agreement to these terms. These terms and conditions are subject to change at any time without prior notice.

## Questions

If you have any questions, feel free to open an issue or contact gu003818@umn.edu
