#!/usr/bin/env python3

import sys, os, math
import numpy as np
import matplotlib.pyplot as plt
import re
import sys
plt.rcParams.update({'font.size': 14})

def uncode(arg):
    try:
        return arg.decode('utf-8')
    except:
        return arg

def getMT(file):
    fname = file + '/config.cym'
    Lines = open(fname,'r').readlines()
    MT = 0
    for line in Lines:
        s = uncode(line).split()
        if len(s)<3:
            pass
        elif s[0]=='new' and s[2] =='creator':
            MT = int(s[1])
        elif s[0] =='new' and s[2]=='single':
            MT = int(s[1])
        elif s[0] =='new' and s[2]=='microtubule':
            MT = int(s[1])
    return MT

def getime(filename):
    with open (filename, "r") as myfile:
        data=myfile.readlines()    
        time = list()
        for i in range(len(data)):
            match1 = re.search("time [+-]?([0-9]*[.])?[0-9]+", data[i]) # REGEX    
            if match1: time.append(float(match1.group()[4:]))
    time = np.array(time)
    return time

def plotc(file,MT,coupleid):
    fname = file+'/link.txt'
    x = np.loadtxt(fname, comments='%', unpack=True)
    time = getime(fname)
    #P         A         X        T+        V+        T-        V-
    P = x[1,:]/MT
    AP = x[2,:]/MT
    X = x[3,:]/MT
    T1 = x[4,:]/MT
    T2 = x[6,:]/MT
    V1 = x[5,:]/MT
    V2 = x[7,:]/MT
    V = V1+V2#np.sum(x[4:,:],axis=0)
    T = T1+T2
    tf = open(file+'/lastPratio.txt','w')
    tf.write(str(AP[-1]/P[-1])+'\n')
    plt.plot(time,P,label='P',c='c')
    plt.plot(time,AP,label='AP',c='m')
    plt.plot(time,X,label='X',c='gray')
    plt.plot(time,V,label='V',c='y')
    plt.plot(time,T,label='T',c='r')
    plt.title('coupleid={},T+V={:.1f},P+AP={:.1f}\n AP/P={:.1f},P={:.1f},AP={:.1f},\n X={:.1f},T={:.1f},V={:.1f}'.format(coupleid,(T[-1]+V[-1]),(P[-1]+AP[-1]),AP[-1]/P[-1],P[-1],AP[-1],X[-1],T[-1],V[-1]))
    plt.legend()
    #plt.xlim([0,1000])
    plt.xlabel('Time (s)')
    plt.ylabel('Crosslink number/MT')
    plt.tight_layout()
    plt.savefig(file+'/crosslink'+str(coupleid)+'.png')
    np.savetxt(file+'/crosslinkstat'+str(coupleid)+'.txt',np.array([time,P,AP,X,V,T]))

if __name__ == "__main__":
    #file  = '/home/chew/work/diff_crosslinkers/parallel_2_fibers/hset+kif11/3D'
    file = sys.argv[1]
    coupleid = sys.argv[2]
    print(file)
    plt.figure()
    MT =getMT(file)
    print(type(MT),'MT=',MT)
    if MT ==0:
        MT = int(sys.argv[3])
    plotc(file,MT,coupleid)
