#!/usr/bin/env python3

import sys, os, math
import numpy as np
import matplotlib.pyplot as plt
import re
import sys
plt.rcParams.update({'font.size': 14})

def getime(filename):
    with open (filename, "r") as myfile:
        data=myfile.readlines()    
        time = list()
        for i in range(len(data)):
            match1 = re.search("time [+-]?([0-9]*[.])?[0-9]+", data[i]) # REGEX    
            if match1: time.append(float(match1.group()[4:]))
    time = np.array(time)
    return time

def plot1(file):
    fname = file+'/MTlength.txt'
    totallength = np.loadtxt(fname, comments='%', unpack=True,usecols=(6))
    time = getime(fname)
    plt.plot(time,totallength,'-',label='total L')
    plt.xlabel('Time, s')
    plt.ylabel('total length, um')
    #plt.xlim([0,1000])
    plt.savefig(file+'/totallength.png')
    plt.close()
    return 

def plot2(file):
    fname = file+'/MTlength.txt'
    aveL = np.loadtxt(fname, comments='%', unpack=True,usecols=(2))
    time = getime(fname)
    plt.plot(time,aveL,'-',label='ave L')
    plt.xlabel('Time, s')
    plt.ylabel('average length, um')
    #plt.xlim([0,1000])
    plt.savefig(file+'/averageL.png')
    plt.close()
    return 

def plot3(file):
    fname = file+'/MTlength.txt'
    aveL = np.loadtxt(fname, comments='%', unpack=True,usecols=(1))
    time = getime(fname)
    plt.plot(time,aveL,'-')
    plt.xlabel('Time, s')
    plt.ylabel('number of MT, um')
    #plt.xlim([0,1000])
    plt.savefig(file+'/NMT.png')
    plt.close()
    return

if __name__ == "__main__":
    file = sys.argv[1]
    print(file)
    plt.figure()
    plot1(file)
    plot2(file)
    plot3(file)
