#!/usr/bin/env python3

import sys, os, math
import numpy as np
import matplotlib.pyplot as plt
import re
import sys
plt.rcParams.update({'font.size': 14})

def uncode(arg):
    try:
        return arg.decode('utf-8')
    except:
        return arg
    
def plotc(file,no):
    fname = file + '/fibercluster.txt'
    file1 = open(fname, 'r')
    Lines = file1.readlines()
    times = []
    yy= []
    y=[]
    css = []
    no = int(no)
    for line in Lines:
        if not line :#or line[0] == '%':
            continue
        s = uncode(line).split()
        if len(s) <2:
            pass
        elif line[0] == '%' and s[1] == 'time':
            time =float(s[2])  #2nd column is no of frame
            times.append(time)
            cnt = 0
            y0 = np.zeros(no)
            y0[:len(y)] = y
            yy.append(np.array(y0))
            y = []
        elif line[0] != '%' and s[1] =='clusters:':
            css.append(int(s[0]))
        elif line[0] != '%' and cnt<no:
            nfiber = int(s[1])
            y.append(nfiber)
            cnt+=1
    yy = np.array(yy,dtype=object)        
    fig = plt.figure(figsize=(9,7))
    ax1 = fig.add_subplot(111)   
    for i in range(no):
        ax1.plot(times,yy[:,i],'-',alpha=0.5,label='last={:.0f}'.format(yy[-1,i]))         
    ax2 = fig.add_subplot(111, sharex=ax1, frameon=False)       
    np.savetxt(file+'/test',np.array([yy[:,0],times])) 
    ax2.plot(times,css,'--')
    ax2.yaxis.tick_right()
    ax1.legend(loc='best')
    ax2.yaxis.set_label_position("right")                
    ax2.set_title('top '+str(no))
    ax2.set_xlabel('Time (s)')
    ax1.set_ylabel('cluster size (-)')
    ax2.set_ylabel('Number of cluster (--)')   
    plt.savefig(file+'/fibercluster.png')
    return 

if __name__ == "__main__":
    file = sys.argv[1]
    print(file)
    no = 20
    no = sys.argv[2]
    print(no)
    plt.figure()
    plotc(file,no)
