// Cytosim was created by Francois Nedelec. Copyright 2007-2017 EMBL.

#include "simul.h"
#include "event.h"

#include "matrix11.h"
#include "matrix22.h"
#include "matrix33.h"

#include "sparmatsym.h"
#include "sparmatsym1.h"
#include "sparmatsym2.h"
#include "sparmatsymblk.h"
#include "sparmatsymblkdiag.h"
#include "rasterizer.h"

#define PRINT(arg) printf("sizeof %32s  %lu bytes\n", #arg, sizeof(arg));

int main(int argc, char* argv[])
{
    int x = ( argc>1 ? atoi(argv[1]) : 0 );
    if ( x == 2 )
    {
        PRINT(Random);
        PRINT(Array<int>);

        PRINT(PointGrid)
        PRINT(FatVector);
        PRINT(FatPoint);
        PRINT(FatLocus);
        PRINT(PointGridCell);
        
        PRINT(BigVector);
        PRINT(BigLocus);
        PRINT(BigLocusList);
        PRINT(LocusGrid);
        
        PRINT(Rasterizer::Vertex2);
        PRINT(Rasterizer::Vertex2d);
        PRINT(Rasterizer::Vertex3);
    }
    else if ( x == 1 )
    {
        PRINT(Mecapoint);
        PRINT(FiberSegment);
        PRINT(Interpolation);
        PRINT(HandMonitor);
        PRINT(FiberSite);
        PRINT(Hand);
        
        PRINT(Inventoried);
        PRINT(Movable);
        PRINT(Buddy);
        
        PRINT(Object);
        PRINT(Mecable);
        PRINT(Chain);
        PRINT(Mecafil);
        PRINT(Fiber);
        
        PRINT(Space);
        PRINT(Single);
        PRINT(Couple);
        
        PRINT(Solid);
        PRINT(Bead);
        PRINT(Sphere);
        PRINT(Event);
        PRINT(Simul);
    }
    else
    {
        PRINT(Vector1);
        PRINT(Vector2);
        PRINT(Vector3);
        
        PRINT(Matrix11);
        PRINT(Matrix22);
        PRINT(Matrix33);
        
        PRINT(SparMatSym::Element);
        PRINT(SparMatSym1::Element);
        PRINT(SparMatSym2::Element);
        
        PRINT(SparMatSymBlk::Column);
        PRINT(SparMatSymBlkDiag::Block);
        PRINT(SparMatSymBlkDiag::Pilar);
    }
}
