# How to Run Simulations with Cytosim

This describes some simple ways to run one or many simulations on a personal computer,
using the unix-style command line interface. If you are not familiar with the command line, [follow this first](starter.md).

It is good practice to perform simulations in a separate folder (eg. `run`), where one copies only the necessary files: `config.cym` and `sim` and `play`.

# Live Run

A *live run* will perform a simulation and display its result on the fly, without saving anything on the disk.
To run a program, you may need to specify the full path of the corresponding executable.
If cytosim's executable `play` is present in the current directory, you can type:
 
	./play live

this should open a graphical window and start a live simulation using the file
`config.cym` that is located in the current working directory.

You can specify another configuration file, here from the subdirectory `cym`:
 
	./play cym/self.cym


In the following, only the executable name will be specified. If you get an error `command not found`, please check our [Unix starter](starter.md), as every details of the command matter. 

# Normal Run
 
The canonical way to use cytosim is to call `sim` to calculate a simulation,
and then `play` to display the results once `sim` has finished:
 
	sim
	play

By default, `sim` uses the configuration file `config.cym` in the current directory, and `play` will read two files written by `sim`: `properties.cmp` and `objects.cmo`.
If you do not want to wait until `sim` finishes, you may run `sim` in the background:

	sim&

You can then use `play` at any time to display the partial results, even if `sim` is still running. This works because `sim` access the result files for writting, and `play` only for reading. You could also open a second terminal window to run `play` while `sim` is still running. Learn [how to convert the results into a movie](making_movies.md).


# Overnight Run
 
You should not start two `sim` in the same directory, because the output files
are always named in the same way, and the results will be losts. The good practice
is to run every simulation in a separate directory.
You may however use `play` or `play live` in a directory where `sim` is working.

You can let `sim` run in its own terminal window, and wait for it to complete.
However, if the calculation requires an hour to complete or more,
you can use <a href="http://en.wikipedia.org/wiki/Nohup">nohup</a> to release the
terminal, and prevent `sim` from being automatically terminated when you log out:

Here is an example:
	
	mkdir run0
	cp config.cym run0
	cd run0
	nohup ../sim&

To automate this, you can use the script `/python/run/start.py`:
it will automatically create the new directory, and start the simulation:
 
start.py sim config.cym
 
You can call `start.py` many times, and the new directories will be named `run0000`, `run0001`, etc.


# Parametric Scan

The process of running many simulations can be automated with the python scripts
located in `/python/run`. Here we illustrate how to scan one parameter by using [preconfig](https://openresearchsoftware.metajnl.com/articles/10.5334/jors.156).
The same technique makes it possible to scan many parameters.

First create a template file from your existing config file:

	cp config.cym config.cym.tpl
 
Then edit this template file to replace the parameter value(s) that you would like
to vary with some python code surrounded in double-brackets.
This code will specify how the parameter is varied, for example:
 
	set hand binder
	{
	 	binding_rate = [[ random.uniform(0,1) ]]
	}
 
Here `binding_rate` will be set randomly between 0 and 1 following a uniform distribution.
Any plain python code should work, including functions from the <a href="http://docs.python.org/library/random.html">Random Module</a>.
It is also possible to use multiple bracketed expressions in the same file to vary several parameters.
Please check the help provided by the script itself by running `preconfig.py help`.

 
You are now ready to use `preconfig.py` to generate a set of config files:

	preconfig.py 100 config.cym.tpl
 
This should create 100 files called `config????.cym` and
you can use `go_sim.py` to run simulations with all these files sequentially:
 
	go_sim.py config????.cym
 
You may also want to run these jobs in parallel, if your machine has multiple cores.
For example the UNIX command 'xargs' can be used to run 4 processes in parallel:

	ls config????.cym | xargs -P 4 -L 1 go_sim.py sim
 
The script `start.py` can be used to start long-running jobs.
Please check the help provided by the scripts (`go_sim.py help` and `start.py help`).


# Visual Inspection

You should now have many completed simulations, each in a different directory.
You can look at them, using a few python scripts:

Script          |   Typical usage                                   |
----------------|----------------------------------------------------
`make_page.py`  | create a HTML page to easily view all the images
`scan.py`       | run a command in multiple directories


For example, create an HTML directory with an image for each `run`:

	scan.py '~/bin/play window_size=1024,128 frame=100 movie' run*
	make_page.py run*
 
One needs to provide the full path for the executable to *scan.py*, and here we refer
to a copy of 'play' in the directory 'bin/' located in the Home directory.

Create HTML directory with images every 100 frame:

	scan.py '~/bin/play movie period=100 size=256 label={}' run*
	make_page.py run*
 
Open `page.html` in a browser to view the results.
 
 
# Analysis

You can also analyse the runs in a non-visual way using 'report'.
This tool will generate text files from the trajectory file of a completed simulation.
You may use `scan.py` to analyse a set of directories.
Alternatively, you can include some reporting directly into the config file,
with [the command "report"](../sim/commands.md).


The tools and python scripts should be able provide up-to-date help, for example:

	make_page.py help
	scan.py help


# Restarting a simulation

To restart a simulation from a frame stored in a trajectory file,
follow these steps:

1. Build the accessory program `frametool` if necessary:

		make frametool

2. Using `frametool`, extract the desired frame from which you want to restart from.
This will create a file `objects.cmi`. The frame index start at 0, and we extract here frame 30. 

		frametool objects.cmo 30 > objects.cmi
		
Note that `frametool objects.cmo` will tell you how many frames are contained in the file.

3. Copy `objects.cmi` in a new directory. Also copy `properties.cmp` and rename it `properties.cmi`.
Start the `sim` with a new config file, containing these instructions:

           read properties.cmi
		import all objects.cmi
		
		run 1000000 system
		{
			nb_frames = 100
		}

The `read` command loads the properties, and the `import` command loads the objects. 
Starting `sim` will erase any preexisting `object.cmo` file, so it is important to use a new directory.

Alternatively, it is also possible to edit the config file, keeping all the `set`, deleting all the `new`, and adding the `import` command. The `import` command has options to keep the objects or to delete them. 
Any `new` placed after the `import` will add objects as usual. 

One can merge two trajectory files later with 'cat' if necessary:

	cat objects1.cmo objects2.cmo > objects.cmo

# Conversion

With `sim`, it is possible to extract a frame from a binary trajectory file,
and export it in the text-based format. The text-based format is a plain ascii
file containing all the simulation state variables.


Simply execute a following config file:

	read properties.cmp
	import objects.cmo { frame=10; }
	export objects objects.txt { binary=0; }

