# How to export images from `play`

Play has an 'Export' menu which can be used to save images.

By pressing `y` in `play` you can export the current display into an image file.
With `Y` (capital Y), all trajectory points remaining in the file are processed.
The images are saved by default in the current working directory. 
This is called the interactive *on-screen* mode.

The format of the images generated by `play`, may be PNG, TGA or PPM, depending on the libraries
that were linked during compilation. This can be queried from the command line by `play info`.

Cytosim can usually generate [PPM](https://en.wikipedia.org/wiki/Netpbm_format) and
[TGA](https://en.wikipedia.org/wiki/Truevision_TGA) images, readable by [ImageJ or FIJI](http://rsbweb.nih.gov/ij/).

In addition, Cytosim may be able to generate [PNG](https://en.wikipedia.org/wiki/Portable_Network_Graphics) images, 
if the required library was linked during compilation.
Note that the PNG files are not optimized, and in particular do not use compression.
They can be processed through a PNG optimizer, for example [oxipng](https://github.com/shssoichiro/oxipng) to save disk space.

These images can be assembled into a movie using freely available tools, 
[ImageJ](http://rsbweb.nih.gov/ij/) or [`ffmpeg`](https://www.ffmpeg.org), outside of cytosim.

# Generating images off-screen

`Play` may also be able to generate images *off-screen* without opening a window,
but this is not supported on all platforms. In this case, 'play' needs to be
invoked from the command line, in one of this mode:

Command               | Result   
----------------------|---------------------------------------------
`play image`          | one image representing the specified frame
`play movie`          | an image for each frame in the trajectory file
`play poster`         | generate a nicer image using supersampling

Some options are available:

Option to `play`      | Description 
----------------------|--------------------------------------------------------------------
`png` `tga` `png`     | set the image file format
`size=INT,INT`        | set size of image
`image_dir=PATH`      | set the destination directory for exported images
`image_name=STRING`   | specifies the name of the image to be generated, and the format
`frame=INT`           | index of frame to be saved (starting from 0)
`period=INT`          | interval between images to be saved (for option 'movie')


Examples:

	play image frame=3               | generate image of frame 3 (image0003.png)
	play image frame=3 size=1024,512 | generate image of frame 3 (image0003.png)
	play image.png frame=3           | generate `image.png` for frame 3
	play image frame=0,5,10,15       | images representing the specified frames
	play movie frame=1 period=10     | images for frames 1, 11, 21, ...

In addition, parameters of [View](../../src/disp/view_prop.h) and
[Display](../../src/disp/display_prop.h) can also be specified on the command line:

	play back_color=black samples=5
	play rotation='0.998 0 0.0491 0' zoom=2 focus='0 1 0' image.tga

Morover, the display parameters can also be included in a separate file with extension ".cyp":

	play display.cyp image.png

Values specified on the command line would overwrite any value specified in the file.


# Adjusting image quality

The parameters `magnify` and `downsample` can be used to increase or decrease the size of the images. 
Values of 2, 3 or 4 set the size of the larger pixels in terms of the smaller pixels.

Option to `play`      | Description 
----------------------|--------------------------------------------------------------------
`magnify=INT`         | increase pixel resolution when assembling the images
`downsample=INT`      | reduce resolution before saving images, by averaging pixel values
`samples=INT`         | use multisampling during image generation

Example:

	play frame=100 magnify=4 downsample=2 image.tga

Note that specifying both `magnify` and `downsample` will achieve [antialiasing](https://en.wikipedia.org/wiki/Spatial_anti-aliasing).
 Alternatively, the `samples` parameter can be set to use [multisampling](https://en.wikipedia.org/wiki/Multisample_anti-aliasing).


# Generating images on-screen

`Play` can also be scripted to generate images *on-screen* and to automatically exit.
This can be useful on platforms without off-screen capabilities. Simpy specify `on` in the 'play' command. 
Without this option, off-screen mode is the default. The same options are available than with the *off-screen* mode.

Examples:

	play zoom=2 on image.tga
	play zoom=2 on tga movie
	
Check a scripting example: [multi_views.py](../../python/misc/multi_views.py).


# Assembling the images

## ImageJ

Multiple images can be combined into a movie file by using [ImageJ](http://rsbweb.nih.gov/ij/) or [Fiji](https://imagej.net/Fiji):  

Put all the images into a specific folder. Drag this folder onto the ImageJ window. 
ImageJ should open a dialog asking if you would like to assemble them into a stack. 
Accept, and the resulting stack can then be exported as a movie in several formats.

## FFmpeg 

Alternatively, [FFmpeg](http://ffmpeg.org) is a versatile command line tool that can assemble images into a movie file.
Please check their manual for the different options. We often use this command to assemble _images*.png_:
 
	ffmpeg -r 10 -i image%04d.png -pix_fmt yuv420p -c:v libx264 -crf 23 movie.mp4
 
 The quality is specified with the `-crf` factor between 0 (better) and 51 (worse).   

### FFmpeg options

To create a Quicktime-friendly MP4:

	ffmpeg -i input.mp4 -pix_fmt yuv420p -c:v libx264 -crf 32  output.mp4
 
To crop a movie:

	ffmpeg -i input.mp4 -filter:v crop=w:h:x:y output.mp4

To resize a movie:
	
	ffmpeg -i input.mp4 -filter:v scale=2048:768 output.mp4

To drop every other frame:

	ffmpeg -i input.mp4 -filter:v select="mod(n\,2)" output.mp4

Combine multiple filters:

	ffmpeg -i input.mp4 -filter:v scale=2048:768,select="mod(n\,2)" output.mp4

# Optional libraries

The PNG library is necessary to export PNG images. It can be installed on MacOS via <a href="http://brew.sh">Homebrew</a>:

	brew install libpng
	brew tap homebrew/dupes

The `makefile.inc` needs to be edited, and `play` needs to be recompiled.
