

# Overview



This folder contains all the Cytosim configuration files necessary to replicate the simulation results shown in the paper "Crosslinker design determines microtubule network organization by opposing motors".

 

The simulation can be run using the [Open Source software Cytosim](https://github.com/nedelec/cytosim). The Cytosim version used in this work is available in code/cytosim. 



Note that due to the stochastic nature of the simulation, your results will not be identical to the ones presented in the paper. 



# Template configuration files



To run simulations with varying parameters, we use a template file with extension `.cym.tpl`, from which multiple configuration files (extension `.cym`) are generated. 

For this we use the Python program [*Preconfig*](https://github.com/nedelec/preconfig), from the command line:

     

     preconfig config.cym.tpl



The template specifies parameters to vary, and how to vary them, which are reflected in the output.



For more information on *Preconfig*, please refer to [this article](https://openresearchsoftware.metajnl.com/articles/10.5334/jors.156):

 	

 	preconfig: A Versatile Configuration File Generator for Varying Parameters

	Journal of Open Research Software, 2017 5(1), p.9.


# Reproducing the simulation result
All the simulations are run using the code in `code/cytosim` and can be recompiled from the source files.

### Fig. 5
First generate the config files from `Fig5/config_KIF11.cym.tpl` (for Fig 5b) and `Fig5/config_HSET.cym.tpl` (for Fig 5d) using `preconfig.py`.

Then run them with 

	cytosim/python/look/scan.py 'cytosim/bin/sim' run????

The cluster size shown in Fig 5c can be obtained from 

	cytosim/bin/report fiber:cluster couple=1 linktype=6 > fibercluster.txt
	plot_cluster.py . 10

The MT mobility shown in Fig 5e can be obtained from

	cytosim/bin/report fiber:displacement period=80 > mobility80.txt
	plot_mobility.py .

### Fig. 6

Similarly, generate the configuration files and run the simulation from the `*cym.tpl` files.
 
Fig. 6a 

`Fig6/config_KIF11_HSET_bigbox.cym.tpl`

Fig. 6c and 6d

hset: `Fig6/config_KIF11_HSET_smallbox.cym.tpl `

double hset motor: `Fig6/config_KIF11_doubleHmotor.cym.tpl`

double hset tail (end holding): `Fig6/config_KIF11_doubleHtail.cym.tpl` 

double hset tail (no end holding): `Fig6/config_KIF11_doubleHtail_noholdend.cym.tpl `

The mobility can be calculated as described in Fig. 5.

### Fig. S3
Generate the configuration files and run the simulation from `FigS3/config.cym.tpl`

The time series of microtubule length can be obtained via

	cytosim/bin/report fiber:length period=10 > MTlength.txt
	plot_lengthrelated.py . 


### Fig. S4
Similarly, generate the configuration files and run the simulation from the `*cym.tpl` files.

Minus KIF11:
`FigS4/config_minusKIF11.cym.tpl`

HSET:
`FigS4/config_HSET.cym.tpl`

KIF11+double tail
`FigS4/config_KIF11_doubleHtail.cym.tpl`

The link types can be obtained via

    id=1 #ID of couple
	cytosim/bin/report couple:configuration period=5 threshold=0.009 coupleID=$id > link.txt 
	plotcrosslink_v3.py . $id 0

### Fig. S5
Generate the configuration files and run the simulation from `FigS5/config.cym.tpl`

The tension of crosslinkers can be obtained via

	cytosim/bin/report couple:force


