%MT only

set simul system
{
    time_step = 0.05
    viscosity = 0.02
    steric = 1,50
    precondition = 4
}

set space cell
{
  shape = strip
}

new cell
{
  length = 60, 60, 0.2 
}

[[ L = 2.5 ]]
[[ MT = 2880 ]]

set fiber microtubule
{
    rigidity = 30
    segmentation = 1
    lattice = 1, 0.008
    confine = inside, 100
    steric = 1, 0.05 
    activity = grow 
    growing_speed   =  0.03
    growing_speed_var = 0.25
    growing_force    = 1.67
   persistent      = 0
   min_length = 0.016
   total_polymer = [[ L*MT ]]
}


set hand nucleator
{
  unbinding = 0,3
  activity = nucleate
  nucleate = 0.1, microtubule, (fiber_length=0.032;plus_end=1;)
}

set single creator
{
  hand = nucleator
  diffusion = 1
}

new [[ MT ]] creator

run system
{
    nb_steps = 160000
    nb_frames = 1000
}



