%extensile bundle with KIF11

set simul system
{
    time_step = 0.05
    viscosity = 0.02
    steric = 1,50
    precondition = 4
}

set space cell
{
  shape = strip
}

new cell
{
  length = 60, 60, 0.2 
}

[[ L = 2.5 ]]
[[ MT = 2880 ]]
[[ Nkif11 = [2*MT,4*MT,8*MT,16*MT,32*MT] ]]

set fiber microtubule
{
    rigidity = 30
    segmentation = 1
    lattice = 1, 0.008
    confine = inside, 100
    steric = 1, 0.05 
    activity = grow 
    growing_speed   =  0.03
    growing_speed_var = 0.25
    growing_force    = 1.67
   persistent      = 0
   min_length = 0.016
   total_polymer = [[ L*MT ]]
}

set hand kinesin
{
    binding = 0.5, 0.16 
    unbinding = 0.1, 5 
    activity = walk
    footprint = 0 
    step_size = 0.008
    unloaded_speed =  0.03
    stall_force = 5
    hold_growing_end = 0
    bind_also_end = both_ends
}

set couple kif11
{
	hand1 = kinesin
	hand2 = kinesin
	stiffness = 100
	length=0.105
	diffusion = 10.
	activity = bridge
}

set hand nucleator
{
  unbinding = 0,3
  activity = nucleate
  nucleate = 0.1, microtubule, (fiber_length=0.032;plus_end=1;)
}

set single creator
{
  hand = nucleator
  diffusion = 1
}

new [[ MT ]] creator
new [[ Nkif11 ]]  kif11

run system
{
    nb_steps = 160000
    nb_frames = 1000
}



