import matplotlib
import matplotlib.pyplot as plt
import pandas as pd

grid = True
names = ["plot_data"]

matplotlib.rcParams['font.family'] = 'Latin Modern Sans'
plt.rc('font', size=20) 

for name in names:
    df = pd.read_csv(name + '.csv',
                    delimiter=';',
                    names=['step', 'conf', 'store'])

    f = plt.figure(figsize = (12, 7.2))
    if grid:
        # cf. https://stackoverflow.com/a/24953575
        ax = f.add_subplot(1, 1, 1)
        
        ax.set_xticks(list(range(0, 32, 5)))
        ax.set_xticks(list(range(0, 32)), minor=True)
        ax.set_yticks(list(range(0, 75, 5)))
        ax.set_yticks(list(range(0, 71)), minor=True)
        ax.grid(which='minor', alpha=0.2)
        ax.grid(which='major', alpha=0.5)
        ax.set_xlabel('step')
        ax.set_ylabel('potential')
    
    plt.plot(df['step'], df['conf'])[0].set_label('configuration potential')
    plt.plot(df['step'], df['store'])[0].set_label('store potential')
    plt.grid(b=True, which="both", linewidth=1)
    plt.legend()
    f.savefig(name + ".pdf", bbox_inches='tight')

