#lang racket

(require rackunit "term.rkt")

(check-equal? (named->index *yes) (*lam '() (*lam '() (*var 1))))
(check-equal? (term-size *yes) 3)

(check-equal?
  (subst 'x (*var 'y) (*appseq (*var 'x) (*lam 'x (*var 'x)) (*lam 'y (*var 'x))))
                      (*appseq (*var 'y) (*lam 'x (*var 'x)) (*lam 'y (*var 'y))))

(check-equal?
  (subst-redices (*let-sugar 'x *id
                 (*let-sugar 'y (*lam 'f (*appseq (*var 'f) (*var 'x) (*var 'x)))
                 (*let-sugar 'z (*lam 'f (*appseq (*var 'f) (*var 'y) (*var 'y)))
                 (*var 'z)))))
  (let ([x *id])
  (let ([y (*lam 'f (*appseq (*var 'f) x x))])
  (let ([z (*lam 'f (*appseq (*var 'f) y y))])
  z))))

(check-equal? (subst-redices *var-chain) *id)

(check-pred named-term? *yes)
(check-pred normal-term? (*Church 8))
(check-pred normal-term? *omega)
(check-false (normal-term? *Omega))

(check-pred   normal-term? (subst-redices (*lam 'x (*let-sugar 'y *id (*app (*var 'x) (*var 'y))))) )
(check-false (normal-term? (subst-redices (*lam 'x (*let-sugar 'y *id (*app (*var 'y) (*var 'x)))))))

(check-pred   is-*list (*list *id *omega *Omega))
(check-false (is-*list ( list *id *omega *Omega)))

(check-pred   is-*list *yes)
(check-false (is-*list *no))

(check-equal? (inv-*Scott (*Scott 0)) 0)
(check-equal? (inv-*Scott (*Scott 7)) 7)

(check-equal?
  (inv-*list (*list (*Church 2) (*Church 3) (*Church 5)))
             ( list (*Church 2) (*Church 3) (*Church 5)))

(check-equal? (*binary 6) (*list *no *yes *yes))
(check-pred normal-term? (*binary 13))
(check-equal? (inv-*binary (*list *yes *yes *no *yes)) 11)

