#lang racket

(require rackunit "common.rkt")

(check-equal? (ignore 1) (void))

(check-equal? (option-map -  3) -3)
(check-equal? (option-map - #f) #f)

(check-equal? (range 4 9) '(4 5 6 7 8))

(check-equal? ((binflip -) 4 9) 5)

(check-equal?
  (foldl (binflip set-add) (seteq) (range 4 7))
  (seteq 4 5 6))

(check-equal? (church 5 (λ (n) (+ n 10)) 3) 53)

(check-equal?
  (count-bounces 1024 (λ (n) (if (<= n 1) #f (/ n 2))))
  10)

(check-equal?
  (hash-matching-union (hasheq 'x 1 'y 2) (hasheq 'z 3))
  (hasheq 'x 1 'y 2 'z 3))
(check-equal?
  (hash-matching-union (hasheq 'x 1 'y 2) (hasheq 'y 2 'z 3))
  (hasheq 'x 1 'y 2 'z 3))
(check-exn exn:fail? (λ ()
  (hash-matching-union (hasheq 'x 1 'y 2) (hasheq 'y 4 'z 3))))

(check-equal?
  (hash-difference-set (hasheq 'x 1 'y 2 'z 3 'w 4) (seteq 'x 'w))
  (hasheq 'y 2 'z 3))
