#lang racket

; tests in "test-term.rkt"

(require "common.rkt")
(provide (all-defined-out))

(struct *var (x  ) #:transparent)
(struct *app (l r) #:transparent)
(struct *lam (x t) #:transparent)

(define identifier? symbol?)

(define (named-term? t)
  (match t
    [(*app l r) (and (named-term? l) (named-term? r))]
    [(*lam x t) (and (identifier? x) (named-term? t))]
    [(*var x  ) (identifier? x)]
    [_         #f]))

(define (normal-term? t)
  (match t
    [(*lam _ t) (normal-term? t)]
    [_          (neutral-term? t)]))
(define (neutral-term? t)
  (match t
    [(*app l r) (and (neutral-term? l) (normal-term? r))]
    [(*lam _ t) #f]
    [(*var _)   #t]
    [_          #f]))

(define (term-size t)
  (match t
    [(*app l r)  (+ 1 (term-size l) (term-size r))]
    [(*lam _ t)  (+ 1 (term-size t))]
    [(*var _  )  1]))

(define (subst x s t)
  (match t
    [(*app l r) (*app (subst x s l) (subst x s r))]
    [(*lam y m) (if (equal? x y) t (*lam y (subst x s m)))]
    [(*var y  ) (if (equal? x y) s t)]))

(define (subst-redices t)
  (match t
    [(*app (*lam x s) t) (subst x (subst-redices t) (subst-redices s))]
    [(*app         s  t) (*app    (subst-redices s) (subst-redices t))]
    [(*lam y m)          (*lam y (subst-redices m))]
    [(*var x)            (*var x)]))

(define (*let-sugar x x-def body)
  (*app (*lam x body) x-def))

(define (free-var? x t)
  (match t
    [(*var y  ) (equal? x y)]
    [(*lam y m) (if (equal? x y) #f (free-var? x m))]
    [(*app l r) (or (free-var? x l) (free-var? x r))]))

(define (named->index t)
  (define (aux t e)
    (match t
      [(*app l r) (*app (aux l e) (aux r e))]
      [(*lam x t) (*lam '() (aux t (cons x e)))]
      [(*var x  ) (*var (index-of e x))]))
  (aux t '()))

(define (gensym-bound-vars t)
  (define (aux t e)
    (match t
      [(*app l r) (*app (aux l e) (aux r e))]
      [(*lam x t) (let ([x1 (gensym x)]) (*lam x1 (aux t (hash-set e x x1))))]
      [(*var x  ) (*var (hash-ref e x x))]))
  (aux t (hasheq)))

(define (alpha-eqv? t1 t2)
  (define (aux t1 t2 e1 e2)
    (match* (t1 t2)
    [((*var x1   ) (*var x2   ))    (eq? (hash-ref e1 x1 x1) (hash-ref e2 x2 x2))]
    [((*app l1 r1) (*app l2 r2))    (and (aux l1 l2 e1 e2) (aux r1 r2 e1 e2))]
    [((*lam x1 t1) (*lam x2 t2))    (let ([x (gensym)]) (aux t1 t2 (hash-set e1 x1 x) (hash-set e2 x2 x)))]
    [(_ _) #f]))
  (aux t1 t2 (hasheq) (hasheq)))

(define *id  (*lam 'x (*var 'x)))

(define (*appseq . ts)
  (match ts
   ['()         *id]
   [(cons t ts) (foldl (binflip *app) t ts)]))

(define *id2 (*lam 'x (*lam 'y (*app (*var 'x) (*var 'y)))))
(define *yes (*lam 'x (*lam 'y (*var 'x))))
(define *no  (*lam 'x (*lam 'y (*var 'y))))
(define *const *yes)
(define *omega (*lam 'x (*app (*var 'x) (*var 'x))))
(define *Omega (*app *omega *omega))
(define *alpha-test (*app *omega *id2))
(define *koma-example (*appseq *yes *no *yes *no *yes))
(define *RKNL-example (*app (*lam 'x (*appseq (*var 'c) (*var 'x) (*var 'x))) (*app (*lam 'y (*lam 'z (*app *id (*var 'z)))) *Omega)))

(define *compose (*lam 'g (*lam 'f
  (*lam 'x (*app (*var 'g) (*app (*var 'f) (*var 'x)))))))

(define *pair (*lam 'x (*lam 'y
  (*lam 'f (*appseq (*var 'f) (*var 'x) (*var 'y))))))

(define *singleton (*lam 'x (*lam 'f (*app (*var 'f) (*var 'x)))))
(define *dubleton  (*lam 'x (*lam 'f (*appseq (*var 'f) (*var 'x) (*var 'x)))))

(define (*pair-of *x *y)
  (let ([f (gensym 'f)]) (*lam f (*appseq (*var f) *x *y))))
(define (*singleton-of *x)
  (let ([f (gensym 'f)]) (*lam f (*app (*var f) *x))))

(define *fst (*lam 'f (*app (*var 'f) *yes)))
(define *snd (*lam 'f (*app (*var 'f) *no)))

(define (*eta-expansion-of *t)
  (let ([z (gensym 'z)]) (*lam z (*app *t (*var z)))))

(define *Y (*lam 'f
  (let ([*t (*lam 'x (*app (*var 'f)                    (*app (*var 'x) (*var 'x))))])
  (*app *t *t))))
(define *fix (*lam 'f
  (let ([*t (*lam 'x (*app (*var 'f) (*eta-expansion-of (*app (*var 'x) (*var 'x)))))])
  (*app *t *t))))
(define *Theta
  (let ([*t (*lam 'x (*lam 'y (*app (*var 'y) (*appseq (*var 'x) (*var 'y) (*var 'y)))))])
  (*app *t *t)))

(define (*Church n)
  (*lam 'f (*lam 'x (church n (λ (a) (*app (*var 'f) a)) (*var 'x)))))

(define *Church-is-zero (*lam 'n
  (*appseq (*var 'n) (*app *const *no) *yes)))

(define *Church-succ
  (*lam 'n (*lam 'f (*lam 'x
    (*appseq (*var 'n) (*var 'f) (*app (*var 'f) (*var 'x)))))))

(define *Church-succ2
  (*lam 'n (*lam 'f (*lam 'x
    (*app (*var 'f) (*appseq (*var 'n) (*var 'f) (*var 'x)))))))

(define *Church-add (*lam 'n (*lam 'm
  (*appseq (*var 'm) *Church-succ (*var 'n)))))
(define *Church-mult (*lam 'n (*lam 'm
  (*appseq (*var 'm) (*app *Church-add (*var 'n)) (*Church 0)))))
(define *Church-smart-mult *compose)
(define *Church-pow (*lam 'n (*lam 'm
  (*appseq (*var 'm) (*app *Church-mult (*var 'n)) (*Church 1)))))

(define *Church-pred-aux (*lam 'p
  (*pair-of (*app (*var 'p) *no) (*app *Church-succ (*app (*var 'p) *no)))))
(define *Church-pred (*lam 'n
  (*app (*appseq (*var 'n) *Church-pred-aux (*pair-of (*Church 0) (*Church 0)))
        *yes)))
(define *Church-monus (*lam 'n (*lam 'm
  (*appseq (*var 'm) *Church-pred (*var 'n)))))

(define *Church-Cregut-pred (*lam 'n (*lam 'f (*lam 'x
    (*app (*appseq (*var 'n)
                   (*lam 'e (*appseq *pair
                                     (*app (*var 'e)
                                           *no)
                                     (*app (*var 'f)
                                           (*app (*var 'e)
                                                  *no))))
                   (*appseq *pair (*var 'x) (*var 'x)))
          *yes)))))

(define *Church-fact-step-cbn (*lam 'f (*lam 'n
  (*appseq *Church-is-zero (*var 'n) (*Church 1)
    (*appseq *Church-smart-mult (*var 'n)                    (*app (*var 'f) (*app *Church-pred (*var 'n))))))))
(define *Church-fact-step-cbv (*lam 'f (*lam 'n
  (*appseq *Church-is-zero (*var 'n) (*Church 1)
    (*appseq *Church-smart-mult (*var 'n) (*eta-expansion-of (*app (*var 'f) (*app *Church-pred (*var 'n)))))))))

(define *Church-fact-cbn (*app *Y   *Church-fact-step-cbn))
(define *Church-fact-cbv (*app *fix *Church-fact-step-cbv))

(define (inv-*Church n)
  (match n
  [(*lam f (*lam x b))
    (define (aux b)
      (match b
      [      (*var x0)     #:when (eq? x x0)                0]
      [(*app (*var f0) b0) #:when (eq? f f0)   (+ 1 (aux b0))]))
    (aux b)]))

(define (*Scott n) (*lam 's (*lam 'z
  (church n (λ (a) (*app (*var 's) (*lam 's (*lam 'z a)))) (*var 'z)))))
(define *Scott-succ (*lam 'n
  (*lam 's (*lam 'z (*app (*var 's) (*var 'n))))))
(define *Scott-pred (*lam 'n
  (*appseq (*var 'n) *id (*Scott 0)))) 

(define *Scott-add-step-cbn (*lam 'f (*lam 'n (*lam 'm
  (*appseq (*var 'm) (*app (*var 'f) (*app *Scott-succ (*var 'n))) (*var 'n))))))

(define *Scott-add-cbn (*app *Y *Scott-add-step-cbn))

(define *Scott-sub-step-cbn (*lam 'f (*lam 'n (*lam 'm
  (*appseq (*var 'm) (*app (*var 'f) (*app *Scott-pred (*var 'n))) (*var 'n))))))

(define *Scott-sub-cbn (*app *Y *Scott-sub-step-cbn))

(define (inv-*Scott n)
  (match n
  [(*lam s (*lam z       (*var z0)    )) #:when (eq? z z0)    0]
  [(*lam s (*lam z (*app (*var s0) n1))) #:when (eq? s s0)    (+ (inv-*Scott n1) 1)]))

(define (*Parigot n) (*lam 's (*lam 'z
  (if (= n 0)
    (*var 'z)
    (let ([*n- (*Parigot (- n 1))])
      (*appseq (*var 's) *n- (*appseq *n- (*var 's) (*var 'z))))))))

(define (*shared-Parigot n) (*lam 's (*lam 'z
  (if (= n 0)
    (*var 'z)
    (*app (*lam 'n
      (*appseq (*var 's) (*var 'n) (*appseq (*var 'n) (*var 's) (*var 'z))))
      (*shared-Parigot (- n 1)))))))

; Scott lists

(define *nil
  (*lam 'nil (*lam 'cons (*var 'nil))))

(define *cons
  (*lam 'h (*lam 't (*lam 'nil (*lam 'cons (*appseq (*var 'cons) (*var 'h) (*var 't)))))))

(define (*cons-of h t)
  (*lam 'nil (*lam 'cons (*appseq (*var 'cons) h t))))

(define (*list . ts)
  (match ts
   ['()         *nil]
   [(cons t ts) (*cons-of t (apply *list ts))]))

(define *head
  (*lam 'xs (*appseq (*var 'xs) *id *yes)))

(define *tail
  (*lam 'xs (*appseq (*var 'xs) *id *no)))

(define (is-*list ts)
  (match ts
  [(*lam n (*lam c (*var n1)))                        (eq? n n1)]
  [(*lam n (*lam c (*app (*app (*var c1) h) t))) (and (eq? c c1) (is-*list t))]
  [_ #f]))

(define (inv-*list xs)
  (match xs
  [(*lam _ (*lam _ (*var _)))                   '()]
  [(*lam _ (*lam _ (*app (*app (*var _) h) t))) (cons h (inv-*list t))]))

; binary numbers

(define (*binary n)
  (if (eq? n 0)
      *nil
      (*cons-of (if (eq? (modulo n 2) 1) *yes *no) (*binary (quotient n 2)))))

(define (inv-*binary n)
  (define (boolean->digit b)
    (match b
    [(*lam x (*lam y (*var xy)))   (if (eq? x xy) 1 0)]))
  (foldr (λ (d acc) (+ (* 2 acc) d)) 0 (map boolean->digit (inv-*list n))))

; exploding families

(define (*explode1 n) (*lam 'x (*appseq (*Church n) *omega    (*var 'x))))
(define (*explode3 n) (*lam 'x (*appseq (*Church n) *dubleton (*var 'x))))
(define (*explode4 n)          (*appseq (*Church n) *dubleton *id))
(define (*implode2 n)          (*appseq (*Church n) *dubleton (*lam 'x (*app *id (*var 'x)))))

(define *var-chain (*lam 'x
  (*let-sugar 'y (*var 'x)
  (*let-sugar 'z (*var 'y)
  (*var 'z)))))
(define *var-chain2
  (*let-sugar 'y *id
  (*let-sugar 'z (*var 'y)
  (*var 'z))))
(define *var-chain3
  (*let-sugar 'y *id
  (*let-sugar 'z (*let-sugar 'w (*var 'y) (*var 'w))
  (*var 'z))))

(define *two-monads-test
  (*let-sugar  'id-monad (*lam  'id-m (*appseq (*var  'id-m)
      *id
      (*lam 'id-x (*lam 'id-f (*app (*var 'id-f) (*var 'id-x))))))
  (*let-sugar 'opt-monad (*lam 'opt-m (*appseq (*var 'opt-m)
      (*lam 'v (*lam 'some (*lam 'none (*app (*var 'some) (*var 'v)))))
      (*lam 'opt-x (*lam 'opt-f (*appseq (*var 'opt-x) (*var 'opt-f) (*lam 'so (*lam 'no (*var 'no))))))))
  (*let-sugar  'id-pure (*app (*var  'id-monad) (*lam 'x1 (*lam 'y1 (*var 'x1))))
  (*let-sugar  'id-bind (*app (*var  'id-monad) (*lam 'x2 (*lam 'y2 (*var 'y2))))
  (*let-sugar 'opt-pure (*app (*var 'opt-monad) (*lam 'x3 (*lam 'y3 (*var 'x3))))
  (*let-sugar 'opt-bind (*app (*var 'opt-monad) (*lam 'x4 (*lam 'y4 (*var 'y4))))
  (*appseq (*var 'opt-bind) (*app (*var 'opt-pure) (*var 'id-bind)) (*var 'opt-pure) (*var 'id-pure) (*var 'id-pure)) 
)))))))

(define *Lamping
  (*app (*lam 'g (*app (*var 'g) (*app (*var 'g) (*lam 'x (*var 'x)))))
        (*lam 'h (*app (*lam 'f (*app (*var 'f) (*app (*var 'f) (*lam 'z (*var 'z)))))
                       (*lam 'w (*app (*var 'h) (*app (*var 'w) (*lam 'y (*var 'y)))))))))

