#lang racket

(require "../common/common.rkt")
(require "../common/term.rkt")
(provide (all-defined-out))

(define already-full-normal-forms
  (map (λ (x) (list x x))
   (list
    *Church-succ
    (*Church 3))))

(define weak-as-full-normal-forms
  (append already-full-normal-forms
  `((,(*appseq *id *id *id *id) ,*id)
    (,*koma-example ,*yes)
    (,(*app *Scott-succ (*Scott 8)) ,(*Scott 9))
    (,(*app *Scott-pred (*Scott 13)) ,(*Scott 12))
    (,(*app *head (*list (*Scott 10) (*Scott 11) (*Scott 12) (*Scott 13))) ,(*Scott 10))
    (,(*app *head (*appseq (*Church 2) *tail (*list (*Scott 10) (*Scott 11) (*Scott 12) (*Scott 13)))) ,(*Scott 12))
  )))

(define cbv-normal-forms
  (append weak-as-full-normal-forms
  `((,*alpha-test ,(*lam 'z (*app *id2 (*var 'z))))
   )))

(define perpetual-full-normal-forms
  `((,*alpha-test ,*id2)
    (,(*appseq *Church-add (*Church 5) (*Church 8)) ,(*Church 13))
    (,(*appseq *Church-mult (*Church 3) (*Church 4)) ,(*Church 12))
    (,(*appseq *compose (*Church 3) (*Church 4)) ,(*Church 12))
    (,(*appseq *Church-pow (*Church 2) (*Church 5)) ,(*Church 32))
    (,(*app (*Church 3) (*Church 3)) ,(*Church 27))
    (,(*app *Church-pred-aux (*pair-of (*Church 7) (*Church 2)))
                            ,(*pair-of (*Church 2) (*Church 3)))
    (,(*appseq *Church-monus (*Church 5) (*Church 3)) ,(*Church 2))
    (,(*app *Church-Cregut-pred (*Church 6)) ,(*Church 5))
    (,*var-chain ,*id)
    (,*var-chain2 ,*id)
    (,*var-chain3 ,*id)
    (,*two-monads-test ,*singleton)
   ))

(define logicians-scbv-normal-forms
  (append weak-as-full-normal-forms
          perpetual-full-normal-forms
  `((,(*app *no (*lam '_ *Omega)) ,*id)
    (,(*app *Church-fact-cbv (*Church 5)) ,(*Church 120))
   )))

(define scbv-normal-forms
  (append logicians-scbv-normal-forms
  `((,(*lam 'x (*app *no (*app (*var 'x) (*lam '_ *Omega)))) ,(*lam 'x *id))
   )))

(define complete-full-normal-forms
  (append weak-as-full-normal-forms
          scbv-normal-forms
  `((,(*app *no *Omega) ,*id)
    (,(*app *Church-fact-cbn (*Church 5)) ,(*Church 120))
    (,(*appseq *Scott-add-cbn (*Scott 5) (*Scott 8)) ,(*Scott 13))
    (,(*appseq *Scott-sub-cbn (*Scott 15) (*Scott 3)) ,(*Scott 12))
   )))

(define open-normal-forms
  (list
    (list (*appseq (*var 'y) (*app *id (*var 'x)) (*app *id (*app (*var 'z) (*var 'z))))
          (*app (*app (*var 'y) (*var 'x)) (*app (*var 'z) (*var 'z))))
    (list (*app (*lam 'x (*lam 'y (*app (*var 'x) (*var 'y)))) (*var 'y))
          (*lam 'z (*app (*var 'y) (*var 'z))))
  ))

(define (named->index-normal-forms xss)
  (map (λ (xs) (map named->index xs)) xss))

(require rackunit)

(define-check (check-normalizer-of-case? normalizer test)
  (let ([actual   (normalizer (first test))]
        [expected (second test)])
  (with-check-info (['actual   (string-info (~v actual))]
                    ['expected (string-info (~v expected))]
                    ['test     (string-info (~v (first test)))])
  (unless (alpha-eqv? actual expected) (fail-check)))))

(define (check-normalizer-of? normalizer normal-forms)
  (define (check-case test)
    (check-normalizer-of-case? normalizer test)) 
  (ignore (map check-case normal-forms)))

