#lang racket

(provide (all-defined-out))
(require racket/hash)

(define (ignore x)
  (void))

(define (assert v)
  (if v (void) (error 'assertion-error)))

(define (trace v)
  (begin (println v) v))

(define (option-map f xs)
  (if xs (f xs) #f))

(define (range b e)
  (if (>= b e) '() (cons b (range (+ b 1) e))))

(define (church n f x)
  (match n
  [0 x]
  [_ (church (- n 1) f (f x))]))

(define (binflip f)
  (λ (x y) (f y x)))

(define (count-bounces init trans)
  (let ([next (trans init)])
  (if next (+ 1 (count-bounces next trans)) 0)))

(define (for-each-state init trans f)
  (f init)
  (let ([next (trans init)])
  (if next (for-each-state next trans f) init)))

(define (hash-matching-union h0 h1)
  (hash-union h0 h1 #:combine (λ (x y) (if (eq? x y) x (error 'hash-matching-union-error)))))

(define (hash-difference-set h s)
  (foldl (binflip hash-remove) h (set->list s)))

