#lang racket

(require "../common/common.rkt")
(require "../common/term.rkt")
(provide (all-defined-out))

(struct *let (x x-def body) #:transparent) ; explicit let syntax

(define (make-lets-explicit t)
  (match t
    [(*app (*lam x s) t) (*let x (make-lets-explicit t) (make-lets-explicit s))]
    [(*app         s  t) (*app   (make-lets-explicit s) (make-lets-explicit t))]
    [(*lam y m)          (*lam y (make-lets-explicit m))]
    [(*var x)            (*var x)]))

(struct *closure (t e) #:transparent)

(define (remove-from-env x e)
  (filter (λ (kv) (not (eq? x (first kv)))) e))

(define (subst-closure decoder c)
  (define (aux e t)
    (match t
      [(*app l r) (*app (aux e l) (aux e r))]
      [(*lam x t) (*lam x (aux (remove-from-env x e) t))]
      [(*var x  ) (let ([e-x-entry (assoc x e)])
                  (if e-x-entry (decoder (second e-x-entry)) t))]))
  (match c
    [(*closure t e) (aux e t)]))

(define (reify-closure c)
  (subst-closure reify-closure c))

