#lang racket

#|
"06_stackless.rkt"

This file is a modification of "05_env_simpl.rkt":
+ elimination of stack
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(define (eval-t t e)
  (match t
  [(*var x)   (second (assoc x e))]
  [(*lam x t) (*closure (*lam x t) e)]
  [(*app l r) (let* ([vr (eval-t r e)]
                     [vl (eval-t l e)])
              (apply-value vl vr))]))

(define (apply-value vl vr)
  (match vl [(*closure (*lam x t) e1) (eval-t t (cons (list x vr) e1))]))

(define (normal-form t)
  (reify-closure (eval-t t '())))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

