#lang racket

#|
"05_env_simpl.rkt"

This file is a modification of "04_controlless.rkt":
+ not lugging environments which don't change
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(define (run-t t e s)
  (match t
  [(*var x)   (cons (second (assoc x e)) s)]
  [(*lam x t) (cons (*closure (*lam x t) e) s)]
  [(*app l r) (run-ap (run-t l e (run-t r e s)))]))

(define (run-ap s)
  (match s
  [(list* (*closure (*lam x t) e1) t2 s)
     (cons (car (run-t t (cons (list x t2) e1) '())) s)]))

(define (normal-form t)
  (reify-closure (car (run-t t '() '()))))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

