#lang racket

#|
"04_controlless.rkt"

This file is a modification of "03_dumpless.rkt":
+ refunctionalization of stacks (with pairing of stack and environment)
+ transformation to direct style
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(define pair cons)

(define (run-t t se)
  (let ([s (car se)]
        [e (cdr se)])
  (match t
  [(*var x)   (pair (cons (second (assoc x e)) s) e)]
  [(*lam x t) (pair (cons (*closure (*lam x t) e) s) e)]
  [(*app l r) (run-ap (run-t l (run-t r se)))])))

(define (run-ap se)
  (let ([s (car se)]
        [e (cdr se)])
  (match s
  [(list* (*closure (*lam x t) e1) t2 s)
     (pair (cons (caar (run-t t (pair '() (cons (list x t2) e1)))) s) e)])))

(define (normal-form t)
  (reify-closure (caar (run-t t (pair '() '())))))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

