#lang racket

#|
"03_dumpless.rkt"

This file is a modification of "02_disentanglement.rkt":
+ refunctionalization of dumps and transformation to direct style
+ run-ap factorization
|#

(require "../common/common.rkt")
(require "../common/term.rkt")
(require "../common/closure.rkt")

(struct ap () #:transparent)

(define (run-t t s e c)
  (match t
  [(*var x)   (run-c (cons (second (assoc x e)) s) e c)]
  [(*lam x t) (run-c (cons (*closure (*lam x t) e) s) e c)]
  [(*app l r) (run-c s e (list* r l (ap) c))]))

(define (run-ap s e c)
  (match s
  [(list* (*closure (*lam x t) e1) t2 s)
       (run-c (cons (run-t t '() (cons (list x t2) e1) '()) s) e c)]))

(define (run-c s e c)
  (match c
  ['()           (car s)]
  [(cons (ap) c) (run-ap s e c)]
  [(cons   t  c) (run-t t s e c)]))

(define (normal-form t)
  (reify-closure (run-t t '() '() '())))

(require "../common/term-checks.rkt")

(check-normalizer-of? normal-form cbv-normal-forms)

